PersonalDataProcessView = KS.extend(BaseSvodView, {
    onInit: function () {
        if (this.data.needToClose) {
            this.close();
        } else {
            this.renderViewTemplate();
            if (this.containerPanel)
                this.containerPanel.setScrollable(false); // Чтобы при масштабировании не было лишних скроллов
        }
    },

    onTemplateRendered: function() {
        if (this.descriptionPanel) {
            var baseScroll = this.descriptionPanel.getScrollable();
            if (baseScroll && baseScroll.getMaxPosition().y === 0) { // скролла нет, мало текста
                this.descriptionScrolled = true;
            } else {
                this.descriptionPanel.setScrollable({
                    xtype: 'scroller.scroller',
                    parentView: this,
                    listeners: {
                        scrollend: this.descriptionScroll
                    }
                });
            }
        }
    },

    descriptionScroll: function(scrollComp, x, y){
        if ((this.getMaxPosition().y - 5) <= y) { // '-5' - погрешность 5px при масштабировании страницы 
            this.parentView.descriptionScrolled = true;
        }
    },

    savePersonalData: function(){
        var view = this.parentView || this;
        var snils = view.snilsEditor.getValue();
        var uceAgreement = view.uceAgreement.getValue();
        var descriptionScrolled = view.descriptionScrolled || false;
        view.serverCall({
            method: 'SavePersonalData',
            params: [snils, uceAgreement, descriptionScrolled],
            success: function(hasSaveErrors){
                if (!hasSaveErrors) {
                    view.saved = true;
                    view.close();
                }
            }
        });
    },

    // Переопределяем эвент закрытия
    close: function (closeContainerPanel) {
        var me = this.parentView || this;

        if (!me.saved && !me.data.needToClose) {
            KS.confirm(me.data.exitText.replace(/\r\n/g, "<br>"), "Внимание", function (btn) {
                if (btn === 'no') {
                    me.saved = true;
                    me.close();
                }
            });
            return false;
        }

        me._closing = true;
        me.serverCall({
            method: 'CloseView',
            disableFog: false,
            waitMessage: KS.L10n.closingWindow,
            success: function() {
                if (closeContainerPanel !== false && me.containerPanel && me.containerPanel.doClose) {
                    me.containerPanel.doClose();
                }

                me.drop();
                me.onAfterClose();
            }
        });

        return true;
    },
});