﻿// ============= VIEW =======================
OrganizationsDictionaryView = KS.extend(BaseDictionaryView, {
    deleteConfirmMsg: 'Удалить выделенные организации?'
});

// ============= TOOLBAR =======================
(function(viewClass) {
    var sc = OrganizationsDictionaryView.superclass;

    KS.apply(viewClass, {
        onTemplateRendered: function() {
            KS.registerCssStyles(this.tpl.cssList);
        },

        resetView: function () {
            this.mainGrid.reload();
            this.discardChanges();
        },

        getTbarClickHandler: function(tbarItem) {
            switch (tbarItem.code) {
                case 'SETTINGS_MENU':
                case 'SYNC_MENU':
                    return null;

                case 'SHOW_ALL_ORGANIZATIONS':
                case 'SHOW_ORGANIZATIONS_IN_BUDGET_TREE':
                case 'SHOW_ORGANIZATIONS_NOT_IN_BUDGET_TREE':
                    return this.changeOrgFilter;

                case 'GROUP_SET':
                    return this.getGroupSetPanel;

                case 'SYNC_UBP':
                case 'SYNCHRONIZE':
                    return this.syncOrgs;

                case 'EXCEL':
                    return this.openExcelImportPanel;

                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        },

        changeOrgFilter: function() {
            var view = this.parentView || this;
            var code = this.tbarNode.code;
            view.serverCall({
                method: 'ChangeOrgFilter',
                params: [code],
                waitMessage: 'Ожидайте ...',
                success: function() {
                    view.mainGrid.reload();
                }
            });
        },

        getGroupSetPanel: function(){
            var view = this.parentView || this;
            var checkedRows = view.mainGrid.getCheckedRows();
            if (Ext.isEmpty(checkedRows)) return;
            view.serverCall({
                method: 'GetGroupSetPanel',
                success: view.showGroupSetPanel
            });
        },

        showGroupSetPanel: function(settings){
            if (Ext.isEmpty(settings)) return;
            this.groupSetGrid = this.getPropertyGridByOption(settings, "groupSetGrid", "Организация");
            this.groupSetGrid.on("propertychange", this.groupPropertyChange, this);
            var view = this;
            this.groupSetPanelWin = KS.showModal(this.groupSetGrid,
                {
                    title: 'Свойства',
                    autoHeight: false,
                    scrollable: true,
                    layout: "anchor",
                    height: Math.min(600, KS.rootViewport.getHeight() / 1.5),
                    minHeight: 200,
                    width: 600,
                    minWidth: 300,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.doGroupSet();
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.groupSetPanelWin.close();
                            }
                        }]
                },
                true);
        },

        doGroupSet: function(){
            var view = this;
            var checkedCodes = view.mainGrid.getCheckedCodes();
            view.groupSetPanelWin.close();
            if (!Ext.isEmpty(checkedCodes)) {
                view.serverCall({
                    method: 'DoGroupSet',
                    params: [checkedCodes],
                    waitMessages: 'Установка свойств...',
                    success: function (needReload) {
                        if (needReload)
                            view.mainGrid.reload();
                    }
                });
            }
        },

        groupPropertyChange: function(source, recordId, value){
            var code = recordId.split("#")[1];
            var view = this;
            view.serverCall({
                method: 'SetGroupPropValue',
                disableFog: true,
                params: [code, value],
                success: function(newValue) {
                    if (newValue != null) {
                        view.groupSetGrid.setProperty(recordId, newValue);
                    }
                }
            });
        },

        propertyGridFieldSelectorSelect: function(selectProp, propGrid, record){
            var view = this;
            var propId = record.id;
            view.propertySelectorGrid = view.createTemplateControl(selectProp.SelectorGrid);
            if (view.propertySelectorGrid) {
                view.propertySelectorGrid.propId = propId;
                view.propertySelectorWin = KS.showModal(view.propertySelectorGrid, {
                    title: 'Выберите значение...',
                    autoHeight: false,
                    resizable: true,
                    autoScroll: true,
                    maximizable: true,
                    height: Math.max(400, KS.rootViewport.getHeight() / 1.5),
                    minHeight: 300,
                    width: Math.max(600, KS.rootViewport.getWidth() / 2.5),
                    minWidth: 400,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.selectFromSelectorGrid();
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.propertySelectorWin.close();
                            }
                        }]
                }, true);
            }
        },

        selectFromSelectorGrid: function(){
            var checkedRows = this.propertySelectorGrid.getCheckedRows();
            if (Ext.isEmpty(checkedRows)) return;
            var nameField = ""; // Поле из которого берём значение для отображения на клиенте
            var selectorGridId = this.propertySelectorGrid.ctrlId;
            switch (selectorGridId) {
                case "orgTypesGrid":
                case "organizationsGrid":
                    nameField = "NAME";
                    break;
                case "reportTypesGrid":
                    nameField = "COL1";
                    break;
            }
            
            if (Ext.isEmpty(nameField)) return;
            var names = [];
            var selectedValues = [];
            Ext.each(checkedRows, function(row) {
                names.push(KS.Grid.getAnyCase(row, nameField));
                selectedValues.push(row.data);
            })
            
            var view = this;
            var propId = view.propertySelectorGrid.propId;
            var code = propId.split("#")[1] || "";
            view.propertySelectorGrid.mask("Пожалуйста, подождите...");
            view.serverCall({
                method: 'FieldSelectorChange',
                params: [code, selectedValues],
                success: function() {
                    view.groupSetGrid.setProperty(propId, names.join(','));
                    view.propertySelectorGrid.unmask()
                    view.propertySelectorWin.close();
                }
            });
        },

        selectorGridDblClick: function(){
            this.selectFromSelectorGrid();
        },

        syncOrgs: function(){
            var view = this.parentView || this;
            view.tryExecuteSvodTask(0, this.tbarNode.code);
        }
    });
}(OrganizationsDictionaryView.prototype));

// ============ EXCEL IMPORT ==============
(function (viewClass) {
    KS.apply(viewClass, {
        openExcelImportPanel: function () {
            var view = this.parentView;
            view.serverCall({
                method: 'OpenExcelImportPanel',
                success: function (panel) {
                    if (Ext.isEmpty(panel)) return;
                    view.importOrganizationsPanel = view.createTemplateControl(panel, 'importOrganizationsPanel');
                    view.addPanelItems(panel, view.importOrganizationsPanel);
                    view.importOrganizationsWin = KS.showModal(view.importOrganizationsPanel, {
                        title: 'Добавление организаций из Excel',
                        autoHeight: false,
                        border: false,
                        flex: 1,
                        height: KS.rootViewport.getHeight() * 0.8,
                        width: KS.rootViewport.getWidth() * 0.8,
                        buttonAlign: 'left',
                        buttons: ['->',
                            {
                                text: 'ОК',
                                cls: 'dim-button',
                                handler: function () {
                                    view.createOrganizationsFromExcel();
                                }
                            }, { xtype: 'tbspacer', width: 8 },
                            {
                                text: 'Отмена',
                                cls: 'dim-button',
                                handler: function () {
                                    view.importOrganizationsWin.close();
                                }
                            }]
                    }, true);
                }
            });
        },

        createOrganizationsFromExcel: function () {
            var view = this;

            var date = view.getToolbarItem(view.importOrganizationsPanel, null, 'DATE').getValue(),
                updateExistsRows = view.getToolbarItem(view.importOrganizationsPanel, null, 'UPDATE').getValue(),
                alwaysCreateVersion = view.getToolbarItem(view.importOrganizationsPanel, null, 'NEW').getValue();

            view.spreadsheetFrame.saveDocument(function () {
                view.serverCall({
                    method: 'CreateOrganizationsFromExcel',
                    params: [date, updateExistsRows, alwaysCreateVersion],
                    success: function (protocol) {
                        if (!Ext.isEmpty(protocol))
                            KS.Svod.showHtmlProtocol(protocol);
                        else {
                            view.importOrganizationsWin.close();
                        }

                        view.mainGrid.reload();
                    }
                });
            }, view);
        }
    });
}(OrganizationsDictionaryView.prototype));

function orgTypesVisualSchemaRenderer(value) {
    return value.replace(/</g, "&lt;").replace(/>/g, "&gt;");
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();