﻿// ============= VIEW CLASS =======================
OrganizationView = KS.extend(BaseSvodView, {
    constructor: function(viewId) {
        OrganizationView.superclass.constructor.call(this, viewId);
    },

    onTemplateRendered: function() {
        KS.registerCssStyles(this.data.cssList);
        this.addRequisitesPropertyGrid();
        this.newNoteValue = ""; //Полное примечание, чтобы не делать serverCall при каждом change
        if (this.data.isNewOutcome) {
            this.touch();
        }
        this.filterEmployees();
    },

    resetView: function () {
        this.addRequisitesPropertyGrid();
        this.postGrid.reload();
        this.employeeGrid.reload();
        this.historyGrid.reload();
        this.additionalRequisitesGrid.reload();         
        this.noteField.setValue(this.noteField.originalValue);
    },

    onValuesSelected: function(arg) {
        this.touch();
        if (arg[0][0].CLOSE_CODE === "ENTITY_CLOSE_CODE") {
            var store = this.additionalRequisitesGrid.store,
                recIdx = store.find('link_diction', arg[0][0].LINK_DICTION),
                rec = store.getAt(recIdx);
            if (rec) {
                rec.set('VALUE', arg[0][0].COL1);
                rec.commit();
            }
        } else if (arg[0][0].CLOSE_CODE === "LINK_ORGANIZATION_TYPE") {
            this.historyGrid.reload();
        } else if (arg[0][0].ACTION === "RELOAD_REQUISITES") {
            this.addRequisitesPropertyGrid();
            this.touch();
        }
    },

    saveChanges: function (close, callback) {
        var view = this.parentView || this;
        view.serverCall({
            method: 'SaveOrgChanges',
            params: [view.newNoteValue || ""],
            waitMessage: 'Сохранение ...',
            success: (callback && Ext.isFunction(callback)) ?
                callback :
                view.saveChangesCallback
        });
    },

    saveChangesCallback: function (hasSaveErrors) {
        if (hasSaveErrors === true) {
            KS.alert('Документ не сохранен!');
            return;
        }
        this.noteField.originalValue = this.newNoteValue;
        this.discardChanges();
        if (close === true) {
            this.close();
        } else {
            this.reload();
        }
    },

    touch: function () {
        this.hasChanges = true;
        this.setSavedState(false);
        this.getToolbarItem(this.rootPanel, null, 'SAVE').setDisabled(false);
    },

    discardChanges: function () {
        this.hasChanges = false;
        this.setSavedState(true);
        this.newNoteValue = "";
        this.getToolbarItem(this.rootPanel, null, 'SAVE').setDisabled(true);
    },

    requestToolClick: function() {
        var view = this.parentView;
        view.requestCode = this.tbarNode.code;
        view.showAddRequestNote();
    },

    showAddRequestNote: function() {
        var view = this;
        view.reqNoteWin = KS.showModal({
            xtype: 'textarea',
            itemId: 'reqNoteArea'
        },{
            layout: 'fit',
            plain: true,
            frame: true,
            autoScroll: true,
            modal: true,
            maximizable: true,
            minWidth: 400,
            width: Math.max(400, KS.rootViewport.getWidth() / 2),
            minHeight: 400,
            height: Math.max(400, KS.rootViewport.getHeight() / 1.5),
            title: 'Добавить комментарий к заявке',
            buttonAlign: 'right',
            buttons: [{
                    text: 'Далее',
                    cls: 'dim-button',
                    handler: function () {
                        var reqNote = view.reqNoteWin.getComponent("reqNoteArea").getValue();
                        view.doRequestToolClick(reqNote);
                    }
                }, { xtype: 'tbspacer', width: 8 },
                {
                    text: 'Отмена',
                    cls: 'dim-button',
                    handler: function() {
                        view.requestCode = "";
                        view.doRequestToolClick("");
                    }
                }]
        }, true);
    },

    doRequestToolClick: function(note) {
        var view = this;
        var code = view.requestCode;
        view.reqNoteWin.close();
        view.serverCall({
            method: 'RequestToolClick',
            params: [code, note],
            disableFod: true,
            success: function(hasSaveErrors) {
                view.requestCode = "";
                view.getToolbarItem(view.rootPanel, null, 'APPROVE').setVisible(false);
                view.getToolbarItem(view.rootPanel, null, 'REJECT').setVisible(false);
                view.saveChangesCallback(hasSaveErrors);
            }
        });
    }
});

// ============= REQUISITES =======================
KS.apply(OrganizationView.prototype, {
    addRequisitesPropertyGrid: function() { //Добавить propertyGrid с реквизитами
        var view = this;
        view.serverCall({
            method: 'GetRequisitesGridData',
            waitMessage: 'Обновление реквизитов ...',
            success: this.createPropertyGrids
        });
    },
    
    onServerRefreshPropertyGrid: function(){
        this.addRequisitesPropertyGrid();
    },

    createPropertyGrids: function(listOptions) {
        if (listOptions) {
            var view = this;
            view.requisitesPanel.removeAll();
            view.selectedRequisitesProperty = {};
            if (!Ext.Object.isEmpty(listOptions)) {
                var i = 0;
                for (var prop in listOptions) {
                    if (listOptions.hasOwnProperty(prop)) {
                        var propertyGrid = view.getPropertyGridByOption(listOptions[prop], "requisitesPropGrid" + i++, prop);
                        propertyGrid.on("propertychange", view.requisitesPropertyGridChange, view);
                        view.requisitesPanel.add(propertyGrid);
                    }
                }
            }
        }
    },

    propertyGridDictSelect: function(propId, dictId) {
        var propName = propId.split("#")[1] || "";
        this.serverCall({
            method: 'OpenPropertyGridDict',
            params: [propName]
        });
    },

    requisitesPropertyGridChange: function(source, recordId, value, oldValue) {
        var code = recordId.split("#")[1] || "";
        var view = this;
        this.serverCall({
            method: 'ChangePropertyGridValue',
            disableFog: true,
            params: [code, value],
            success: function(newValue) {
                if (!Ext.isEmpty(newValue)){
                    view.setRequisiteValue(recordId, newValue);
                }
                view.touch();
            }
        });
    },

    setRequisiteValue: function(recordId, newValue){
        var foundedGrid;
        Ext.each(this.requisitesPanel.items.items, function(requisitesGrid){
            if (requisitesGrid.source.hasOwnProperty(recordId)){
                foundedGrid = requisitesGrid;
                return false;
            }
        });
        
        if (foundedGrid)
            foundedGrid.setProperty(recordId, newValue);
    },

    onServerShowInnGrid: function(innGrid){
        if (Ext.isEmpty(innGrid)) return;
        var view = this;
        this.innGrid = this.createTemplateControl(innGrid);
        this.innWin = KS.showModal(this.innGrid,
            {
                title: 'Выберите значение...',
                autoHeight: false,
                layout: "fit",
                minWidth: 400,
                minHeight: 300,
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                buttonAlign: 'left',
                buttons: ['->',
                    {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function() {
                            view.setInnFromGrid();
                        }
                    },
                    { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.innWin.close();
                        }
                    }]
            }, true);
    },

    setInnFromGrid: function(){
        var view = this,
            selRows = view.innGrid.getSelectedRows();
        if (!Ext.isEmpty(selRows)){
            view.innWin.close();
            view.serverCall({
                method: 'SetInnFromGrid',
                params: [selRows[0].data],
                success: function() {
                    view.addRequisitesPropertyGrid();
                    view.touch();
                }
            });
        }
    }
});

// ============= HISTORY =======================
KS.apply(OrganizationView.prototype, {
    beforeHistoryEdit: function(e, context) {
        if (this.data.isHistoryEditAllow === false) return false;
        var dataIndex = context.column.dataIndex;
        if (dataIndex === "ORGANIZATION_TYPE") return false;
        if (this.data.historyColumnMaxLengthDict &&
            this.data.historyColumnMaxLengthDict[dataIndex] &&
            !Ext.isEmpty(context.column.config.editor))   
            context.column.config.editor.maxLength = this.data.historyColumnMaxLengthDict[dataIndex];
        return true;
    },
    
    afterHistoryEdit: function(e, context) {
        if (context.field === "CHECKED" || context.value === context.originalValue)
            return;
        if (context.value === null) {
            context.record.reject();
            return;
        }
        var closeCode = KS.Grid.getAnyCase(context.record, "ENTITY_CLOSE_CODE");
        this.serverCall({
            method: 'EditHistory',
            params: [closeCode, context.field, context.value],
            disableFog: true,
            success: function(errMsg) {
                if (errMsg) {
                    context.record.reject();
                    KS.alert(errMsg);
                } else {
                    this.touch();
                }
            }
        });
    },

    historyGridDblClick: function(grid, td, cellIndex, record) {
        if (this.data.isHistoryEditAllow === false) return;
        var colCfg = this.historyGrid.getColCfgByIndex(cellIndex);
        if (!Ext.isEmpty(colCfg) && colCfg.dataIndex === "ORGANIZATION_TYPE"){
            this.serverCall({
                method: 'OpenOrgTypeDictionary',
                params: [record.get("DATE_END")]
            });
        }
    },

    addHistory: function() {
        var view = this.parentView || this;
        view.serverCall({
            method: 'AddHistory',
            disableFog: true,
            success: view.redrawHistory
        });
    },

    getSelectedHistoryRows: function() {
        var store = this.historyGrid.store,
            closeCodes = this.historyGrid.getCheckedCodes();
        store.each(function(rec) {
            if (KS.Grid.getAnyCase(rec, 'CHECKED')) 
                closeCodes.push(KS.Grid.getAnyCase(rec, 'ENTITY_CLOSE_CODE'));
        });
        return closeCodes;
    },

    deleteHistory: function() {
        var view = this.parentView || this,
            closeCodes = view.getSelectedHistoryRows();
        if (Ext.isEmpty(closeCodes)) return;
        KS.confirm("Удалить выделенные строки?", "Подтвердите удаление", function(btn) {
            if (btn === 'yes') {
                view.serverCall({
                    method: 'DeleteHistory',
                    params: [closeCodes],
                    success: view.redrawHistory
                });
            }
        });
    },

    redrawHistory: function() {
        this.historyGrid.reload();
        this.touch();
    },

    historyGridSelection: function(selModel, selected) {
        var orgName = "";
        if (selected && selected[0]) {
            orgName = selected[0].get("NAME");
        }
        this.getToolbarItem(this.tabPanel, 'bottom', 'ORG_NAME').setText("Организация: " + orgName);
    },

    historyGridLoad: function() {
        var firstRow = this.historyGrid.store.getAt(0);
        if (firstRow) {
            var orgName = firstRow.get("NAME");
            this.getToolbarItem(this.tabPanel, 'bottom', 'ORG_NAME').setText("Организация: " + orgName);
        }
    }
});

// ============= EMPLOYEES =======================
KS.apply(OrganizationView.prototype, {
    afterPostGridDataLoad: function() {
        this.filterEmployees();
    },

    buildEmployeeKey: function(rec) {
        try {
            var date = KS.Grid.getAnyCase(rec, 'DATE'),
                closeCode = KS.Grid.getAnyCase(rec, 'ENTITY_CLOSE_CODE') || -1,
                year = 0,
                month = 0,
                day = 0;
            if (!Ext.isEmpty(date) && (new Date(date) != "Invalid Date")) {
                date = new Date(date);
            }
            if (Ext.isDate(date)) {
                year = date.getFullYear();
                month = date.getMonth() + 1;
                day = date.getDate();
            } else if (Ext.isString(date)) {
                var dateCmpnts = date.split(' ')[0].split('.');
                year = dateCmpnts[2];
                month = dateCmpnts[1];
                day = dateCmpnts[0];
            }
            return {
                CloseCode: closeCode,
                OrganizationLink: KS.Grid.getAnyCase(rec, 'link_organization'),
                PostLink: KS.Grid.getAnyCase(rec, 'link_post'),
                Year: year,
                Month: month,
                Day: day
            };
        } catch (e) {
            return null;
        }
    },

    afterEmployeesEditHandler: function(e, context) {
        if (context.field === "CHECKED" || context.value === context.originalValue) 
            return;
        this.serverCall({
            method: 'EditEmployee',
            params: [this.buildEmployeeKey(context.record), context.field, context.value],
            disableFog: true,
            success: this.touch,
            error: function() {
                context.record.reject();
            }
        });
    },

    filterEmployees: function() {
        var spl = this.getSelectedPostLink();
        if (!spl) return;
        this.employeeGrid.store.clearFilter();
        this.employeeGrid.store.filterBy(function(rec) {
            return (KS.Grid.getAnyCase(rec, 'link_post') === spl);  
        });
    },

    postHasEmployees: function(postRecord) {
        var postLink = KS.Grid.getAnyCase(postRecord, 'link_post');
        var store = this.employeeGrid.store;
        var records = (store.isFiltered() || store.isSorted()) ? store.getData().getSource().getRange() : store.getRange();
        var hasEmployees = false;
        Ext.each(records, function(record) {
            if (KS.Grid.getAnyCase(record, "LINK_POST") === postLink) {
                hasEmployees = true;
                return false;
            }
            return true;
        });
        return hasEmployees;
    },

    getSelectedPostLink: function() {
        var rec = this.postGrid.getSelectedRecs()[0];
        return KS.Grid.getAnyCase(rec, 'link_post');
    },

    getCheckedEmployeeRows: function() {
        var rows = [];
        this.employeeGrid.store.each(function(r) {
            if (KS.Grid.getAnyCase(r, 'CHECKED'))
                rows.push(r);
        });
        return rows;
    },

    addEmployee: function() {
        var view = this.parentView || this;
        var spl = view.getSelectedPostLink();
        if (!spl) return;
        view.serverCall({
            method: 'AddEmployee',
            params: [spl],
            disableFog: true,
            success: view.addEmployeeCallback
        });
    },

    addEmployeeCallback: function(dict) {
        var store = this.employeeGrid.getStore();
        if (dict) {
            for (var field in dict) {
                if (dict.hasOwnProperty(field)) {
                    if (field.indexOf('DATE') >= 0) {
                        dict[field] = KS.parseAjaxDateTime(dict[field]);
                    }
                    if (field === "LINK_POST") {
                        dict[field] = dict[field].toString();
                    }
                }
            }
            var newRec = this.employeeGrid.addRecord(dict);
            this.employeeGrid.getSelectionModel().select({
                row: store.indexOf(newRec),
                column: 1
            });
            this.touch();
        }
    },

    deleteEmployee: function() {
        var view = this.parentView || this,
            keys = [];
        Ext.each(view.getCheckedEmployeeRows(), function(r) {
            keys.push(view.buildEmployeeKey(r));
        });
        if (Ext.isEmpty(keys)) return;
        KS.confirm("Удалить выделенные строки?", "Подтвердите удаление", function(btn) {
            if (btn === 'yes') {
                view.serverCall({
                    method: 'DeleteEmployees',
                    params: [keys],
                    disableFog: true,
                    success: view.redrawEmployees
                });
            }
        });
    },

    redrawEmployees: function() {
        this.employeeGrid.reload();
        this.touch();
        this.filterEmployees();
    }
});

// ============= NOTE =======================
KS.apply(OrganizationView.prototype, {
    changeNote: function(textArea, newValue) {
        this.newNoteValue = newValue;
        this.touch();
    }
});

// ============= ADDITIONAL_REQUISITES =======================
KS.apply(OrganizationView.prototype, {
    additionalReqGridDblClick: function(grid, td, cellIndex, record) {
        if (this.data.isEdit === false) return;
        var linkDiction = KS.Grid.getAnyCase(record, 'link_diction');
        var closeCode = KS.Grid.getAnyCase(record, 'ENTITY_CLOSE_CODE');
        if(!Ext.isEmpty(linkDiction))
        {
            this.serverCall({
                method: 'SelectDictAdditionalReq',
                params: [closeCode, linkDiction]
            });
        }
    },

    afteradditionalReqEditHandler: function(e, context) {
        if (context.field === "CHECKED" || context.value === context.originalValue) 
            return;
        var closeCode = KS.Grid.getAnyCase(context.record, 'ENTITY_CLOSE_CODE');
        this.serverCall({
            method: 'EditAdditionalReq',
            params: [closeCode, context.field, context.value],
            disableFog: true,
            success: this.touch,
            error: function() {
                context.record.reject();
            }
        });
    }
});

// ============= RENDERERS =======================
function organizationTypeHistoryRenderer(value, metadata) {
    metadata.css += ' org-dict-cell';
    return value;
}

function organizationPostRenderer(value, metadata, record, rowIndex, colIndex, store) {
    var view = store.parentView || this.parentView;
    if (view && view.postHasEmployees(record)) {
        value = "<b>" + value + "</b>";
    }
    return value;
}

function organizationDateRenderer(value, metadata, record, rowIndex, colIndex, store) {
    if (store.grid.getColCfgByIndex(colIndex).tag === 'disabled')
        metadata.css += ' disabled-org-cell';
    if (!Ext.isEmpty(value) && (new Date(value) != "Invalid Date")) {
        value = new Date(value);
    }
    if (Ext.isString(value) && !Ext.isEmpty(value)) {
        var parsed = KS.parseAjaxDateTime(value);
        if (parsed) {
            value = Ext.util.Format.date(parsed, 'd.m.Y');
        } else if (value.length > 10) {
            value = value.substring(0, 10);
        }
    } else {
        value = Ext.util.Format.date(value, 'd.m.Y');
    }
    return (value == '06.06.2079') ? '' : value;
}

function organizationAdditionalRenderer(value, metadata, record) {
    if (!Ext.isEmpty(record.get("link_diction"))) {
        metadata.css += ' org-dict-cell';
    }
    return value;
}

// ============= EDITORS =======================
organizationDateEditor = KS.extend(Ext.form.DateField, {
    format: 'd.m.Y',
    editable: false
});

Ext.define('organizationEnforceMaxLengthEditor',
    {
        extend: 'Ext.form.TextField',
        allowBlank: true,
        enforceMaxLength: true
    });

if (typeof (Sys) !== 'undefined') { Sys.Application.notifyScriptLoaded(); }