﻿Msk86NSendView = KS.extend(BaseTreeView, {
    customName: 'Msk86NSendView'
});

// =============== COMMON ===================
(function (viewClass) {
    KS.apply(viewClass, {
        getTbarClickHandler: function(tbarItem) {
            var sc = Msk86NSendView.superclass;
            switch (tbarItem.code) {
                case 'SEND':
                    return this.signAndSend;
                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        },

        resetView: function () {
            this.getToolbarItem(this.mainTabs, 'top', 'SEND').setDisabled(true);
            this.hideProtocol();
            this.baseTree.selectFirstNode();
        },

        activateTabHandler: function (tabPanel, newTab) {
            if (!newTab.ctrlId.startsWith('pdfTab')) return;
            var view = this;
            if (view.treeNode && view.treeNode.objData) {
                var objData = view.treeNode.objData;
                if (!Ext.isEmpty(objData.PDF_URLS) && !Ext.isEmpty(objData.PDF_URLS[newTab.customId - 1])) {
                    view.previewPdf(newTab, objData.PDF_URLS[newTab.customId - 1]);
                }
            }
        },

        hideProtocol: function () {
            this.setTabHidden(this.n86Tab, false);
            this.setTabHidden(this.protocolTab, true);
        },

        showProtocol: function (protocol) {
            this.setTabHidden(this.n86Tab, true);
            this.setTabHidden(this.protocolTab, false);
            this.removePdfTabs();
            this.getToolbarItem(this.mainTabs, 'top', 'SEND').setDisabled(true);
            this.mainTabs.setActiveTab(this.protocolTab);
            this.protocolTab.update(protocol);
        },

        setTabHidden: function (tab, hidden) {
            if (!tab) return;
            if (this.mainTabs && Ext.isFunction(this.mainTabs.hideTabStripItem)) {
                if (hidden) {
                    this.mainTabs.hideTabStripItem(tab);
                } else {
                    this.mainTabs.unhideTabStripItem(tab);
                }
            } else {
                var tabBar = this.mainTabs.getTabBar();
                tabBar.items.each(function (item) {
                    if (tab.title === item.text) {
                        item.setHidden(hidden);
                    }
                });
            }
        },

        onBeforeClose: function () {
            var view = this;
            if (!Ext.isEmpty(view.pdfTabs))
            {
                Ext.each(Object.keys(view.pdfTabs), function (linkSavedForm) {
                    if (!Ext.isEmpty(view.pdfTabs[linkSavedForm]))
                    {
                        var reportTabs = view.pdfTabs[linkSavedForm];
                        Ext.each(Object.keys(reportTabs), function (pdfTabId) {
                            var pdfTab = reportTabs[pdfTabId];
                            pdfTab.destroy();
                        })
                    }
                })
            }

            Msk86NSendView.superclass.onBeforeClose.call(this);
        }
    });
}(Msk86NSendView.prototype));

// ================ TREE ====================
(function (viewClass) {
    KS.apply(viewClass, {
        selectForm: function (selModel, selected) {
            this.treeNode = selected[0] || selected;
            if (!Ext.isEmpty(this.treeNode)) {
                if (this.treeNode.objData) {
                    this.showFormData(this.treeNode.objData);
                } else {
                    this.serverCall({
                        method: 'PrepareForm',
                        waitMessage: 'Подготовка данных',
                        params: [this.treeNode.id],
                        success: this.showFormData
                    });
                }
            }
        },

        showFormData: function (objData) {
            var view = this,
                enableSignAndSend = true;

            if (objData) view.treeNode.objData = objData;
            if (!objData) {
                view.showProtocol('');
                enableSignAndSend = false;
            } else if (objData.errorProtocol) {
                view.showProtocol(objData.errorProtocol);
                enableSignAndSend = false;
            } else {
                view.hideProtocol();
                if (objData.N86_URL) {
                    view.mainTabs.setActiveTab(view.n86Tab);
                    view.n86Tab.update(objData.N86_CONTENT);
                }
                if (!Ext.isEmpty(objData.PDF_URLS) && !Ext.isEmpty(objData.PDF_TABS)) {
                    view.loadPdfTabs(objData.PDF_TABS, objData.PDF_URLS);
                }
            }
            view.getToolbarItem(view.mainTabs, 'top', 'SEND').setDisabled(!enableSignAndSend);
        }
    });
}(Msk86NSendView.prototype));

// ================= PDF ====================
(function (viewClass) {
    KS.apply(viewClass, {
        loadPdfTabs: function (pdfTabs, pdfUrls) {
            var view = this,
                savedFormLink = view.treeNode.id;

            if (!view.pdfTabs) view.pdfTabs = {};

            // удалить открытые pdf табы
            view.removePdfTabs();

            for (var i = 0; i < pdfUrls.length; i++) {
                var pdfTabConfig = pdfTabs[i];

                if (!view.pdfTabs[savedFormLink])
                    view.pdfTabs[savedFormLink] = {};

                if (!view.pdfTabs[savedFormLink][pdfTabConfig.itemId]) {
                    var newPdfTab = view.createTemplateControl(pdfTabConfig, pdfTabConfig.itemId);
                    view.addPanelItems(pdfTabConfig, newPdfTab);
                    newPdfTab.savedFormLink = savedFormLink;

                    view.pdfTabs[savedFormLink][pdfTabConfig.itemId] = newPdfTab;
                }

                var pdfTab = view.pdfTabs[savedFormLink][pdfTabConfig.itemId];

                view.mainTabs.add(pdfTab);
            }
        },

        removePdfTabs: function () {
            var view = this;
            var itemsToDel = [];
            if (!Ext.isEmpty(view.mainTabs.items.items)) {
                Ext.each(view.mainTabs.items.items, function (item) {
                    if (item.ctrlId.startsWith('pdfTab'))
                        itemsToDel.push(item.id);
                })
            }

            Ext.each(itemsToDel, function (item) {
                view.mainTabs.remove(item, false);
            })
        },

        switchToPdfTab: function (pdfTab, pdfUrl) {
            var view = this;
            view.mainTabs.setActiveTab(pdfTab);
            view.getToolbarItem(pdfTab, 'top', 'download').setDisabled(false);
            view.previewPdf(pdfTab, pdfUrl);
        },

        previewPdf: function(pdfTab, pdfUrl) {
            var view = this;
            if (view.checkPdfJsSupported() && window.PDFJS) {
                pdfTab.update('<canvas id="the-canvas' + pdfTab.customId + '"></canvas>');
                if (KS.netCore){
                    window.PDFJS.workerSrc = 'js/svod/Views/ViewerJS/pdf.worker.js';
                } else {
                    window.PDFJS.workerSrc = 'Javascript/Views/ViewerJS/pdf.worker.js';
                }
                view.maskPdf(pdfTab, 'Формирование документа');
                window.PDFJS.getDocument(pdfUrl).then(view.renderPdf.bind(this, pdfTab));
            } else {
                pdfTab.update('<h1>В данном браузере предварительный просмотр недоступен</h1>');
            }
        },

        checkPdfJsSupported: function() {
            return !!window.Promise;
        },

        renderPdf: function(pdfTab, pdf) {
            var view = this;
            pdfTab.pdf = pdf;
            view.gotoPage(pdfTab, 1);
        },

        gotoPage: function(pdfTab, pageNum) {
            var view = this;
            pdfTab.currentPage = pageNum;
            var numPages = pdfTab.pdf.pdfInfo.numPages,
                pdfTbar = view.getToolbar(pdfTab, 'top'),
                prevBtn = view.getToolbarItem(pdfTab, 'top', 'prevBtn'),
                nextBtn = view.getToolbarItem(pdfTab, 'top', 'nextBtn'),
                pageLabel = view.getToolbarItem(pdfTab, 'top', 'pageLabel_' + pdfTab.savedFormLink + '_' + pdfTab.customId);
            if (pdfTab.currentPage < 1) pdfTab.currentPage = 1;
            if (pdfTab.currentPage > numPages) pdfTab.currentPage = numPages;
            if (numPages > 1) {
                prevBtn.setDisabled(pdfTab.currentPage === 1);
                nextBtn.setDisabled(pdfTab.currentPage === numPages);
            }
            pdfTbar.setDisabled(false);
            pageLabel.setText(pdfTab.currentPage + ' из ' + numPages);
            view.maskPdf(pdfTab, 'Формирование страницы');
            pdfTab.pdf.getPage(pdfTab.currentPage).then(view.renderPdfPage.bind(this, pdfTab));
        },

        renderPdfPage: function(pdfTab, page) {
            var scale = 2,
                viewport = page.getViewport(scale),
                canvas = document.getElementById('the-canvas' + pdfTab.customId),
                context = canvas.getContext('2d');
            canvas.height = viewport.height;
            canvas.width = viewport.width;
            var renderContext = {
                canvasContext: context,
                viewport: viewport
            };
            this.maskPdf(pdfTab, 'Формирование страницы');
            var callback = this.pdfPageRenderComplete.bind(this, pdfTab);
            page.render(renderContext).then(callback, callback);
        },

        pdfPageRenderComplete: function (pdfTab) {
            this.unmaskPdf(pdfTab);
        },

        maskPdf: function(pdfTab, msg) {
            if (!pdfTab.body) return;
            pdfTab.body.unmask();
            pdfTab.body.mask(msg);
        },

        unmaskPdf: function(pdfTab) {
            pdfTab.body.unmask();
        },

        downloadPdf: function() {
            var pdfTab = this.ownerCt.ownerCt;
            KS.openUrl(this.parentView.treeNode.objData.PDF_URLS[pdfTab.customId - 1]);
        },

        prevPage: function() {
            var pdfTab = this.ownerCt.ownerCt;
            this.parentView.gotoPage(pdfTab, pdfTab.currentPage - 1);
        },

        nextPage: function() {
            var pdfTab = this.ownerCt.ownerCt;
            this.parentView.gotoPage(pdfTab, pdfTab.currentPage + 1);
        },
    });
}(Msk86NSendView.prototype));

// ================ SIGN ====================
(function (viewClass) {
    KS.apply(viewClass, {
        signAndSend: function () {
            var view = this.parentView || this;
            KS.XCrypt.viewContext = view;
            delete KS.XCrypt.lastSignError;
            delete view.certErrorDiaplyed;
            view.getOpenData([]);
        }
    });
}(Msk86NSendView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();