﻿ModelStorageMonitorView = KS.extend(KS.Ext.ClientView, {});

(function (viewClass) {
    KS.apply(viewClass, {
        refresh: function () {
            this.parentView.keysGrid.resetGrid();
            this.parentView.objectTree.getRootNode().removeAll();
            this.parentView.detailsPanel.update();
            this.parentView.previewPanel.update();
        },

        remove: function () {
            var view = this.parentView,
                recs = view.keysGrid.getSelectedRecs();
            if (Ext.isEmpty(recs)) return;
            KS.confirm("Удалить модель из хранилища?", "Подтвердите удаление", function (btn) {
                if (btn === 'yes') {
                    view.serverCall({
                        method: 'Delete',
                        params: [recs[0].data],
                        success: function () {
                            this.keysGrid.resetGrid();
                        }
                    });
                }
            });
        },

        selectModel: function () {
            var recs = this.keysGrid.getSelectedRecs();
            if (Ext.isEmpty(recs)) return;
            if (recs[0].data.id)
                delete recs[0].data.id;
            this.serverCall({
                method: 'SelectModel',
                params: [recs[0].data],
                success: function () {
                    this.objectTree.getRootNode().removeAll(true);
                    this.objectTree.fullReload();
                }
            });
        },

        objTreeClick: function (v, node) {
            if (!node) return;
            if (node.length > 0)
                node = node[0];
            else
                return;
            this.serverCall({
                method: 'GetDescription',
                params: [node.id],
                success: this.preview
            });
        },

        setSortBySize: function() {
            var view = this.parentView;
            var treeSort = "";
            if (this.pressed)
                treeSort = "size DESC";
            view.serverCall({
                method: 'SetTreeFilter',
                params: [treeSort],
                success: function() {
                    view.objectTree.getRootNode().removeAll(true);
                    view.objectTree.fullReload();
                }
            });
        },

        preview: function(data) {
            this.detailsPanel.update(data.details);
            this.previewPanel.update(data.preview);
        }
    });
}(ModelStorageMonitorView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();