﻿FormPackageDictionaryView = KS.extend(BaseTreeView, { });

// ============= COMMON =======================
(function(viewClass) {
    var sc = FormPackageDictionaryView.superclass;
    KS.apply(viewClass, {

        onTemplateRendered: function () {
            this.baseTree.selectFirstNode();
        },
        
        getTbarClickHandler: function (tbarItem) {
            switch (tbarItem.code) {
                case "NEW":
                    return this.addFormsToPackage;

                case "ADD":
                    return this.addNewPackage;
                    
                case "ADD_CHILD":
                    return this.addNewChildPackage;

                case "EDIT":
                    return this.editPackage;

                case "DELETE":
                    return this.defineDelButton;
                    
                case "PRINT":
                case "HTML":
                    return this.printTreeToHtml;

                case "MOVE":
                    return this.moveToPackage;
                
                case "PopupAddGroup":
                    return null;
                    
                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        },

        defineDelButton: function () {
            var view = this.parentView;
            switch (this.ownerCt.ownerCt.itemId) {
                case "baseTree":
                    return view.deletePackage();

                case "mainGrid":
                    return view.deleteForms();

                default:
                    return null;
            }
        },
    });
}(FormPackageDictionaryView.prototype));

// ============= TREE =======================
(function(viewClass) {
    KS.apply(viewClass, {

        setTreeFilter: function (node) {
            var nodeId = node.id;
            this.serverCall({
                method: 'SetPackageFilter',
                params: [(nodeId === 'filter_off') ? null : nodeId],
                waitMessage: 'Фильтрация ...',
                success: this.resetGrid
            });
        },
        
        addNewPackage: function(){
            var view = this.parentView || this;
            view.showEditPackagePanel(null, true);
        },

        addNewChildPackage: function(){
            var view = this.parentView || this;
            var nodeId = view.baseTree.getSelNodeId();
            if (!Ext.isEmpty(nodeId) && nodeId !== 'filter_off')
                view.showEditPackagePanel(nodeId, true);
        },
        
        editPackage: function () {
            var view = this.parentView || this;
            var nodeId = view.baseTree.getSelNodeId();
            if (!Ext.isEmpty(nodeId) && nodeId !== 'filter_off')
                view.showEditPackagePanel(nodeId, false);
        },

        showEditPackagePanel: function (packageLink, isNew) {
            var view = this;
            view.serverCall({
                method: 'GetEditPackageProperties',
                params: [packageLink, isNew],
                success: function (settings) {
                    view.showEditPackagePanelCallback(settings, packageLink, isNew);
                }
            });
        },

        showEditPackagePanelCallback: function(settings, packageLink, isNew) {
            if (Ext.isEmpty(settings)) return;
            this.propertyGrid = this.getPropertyGridByOption(settings, "propertyGrid", "Общие");
            var view = this;
            this.packageEditPanelWin = KS.showModal(this.propertyGrid,
                {
                    title: 'Свойства',
                    autoHeight: false,
                    layout: "anchor",
                    height: 400,
                    minHeight: 200,
                    width: 600,
                    minWidth: 300,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.doEditPackage(packageLink, isNew);
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.rejectPackage(packageLink, isNew);
                            }
                        }]
                },
                true);
        },

        doEditPackage: function (packageLink, isNew) {
            var view = this;
            var newValues = this.propertyGrid.source;
            view.packageEditPanelWin.close();
            view.serverCall({
                method: 'EditPackage',
                params: [newValues, packageLink, isNew],
                waitMessage: isNew ? 'Создание ...' : 'Редактирование ...',
                success: function () {
                    view.baseTree.getRootNode().removeAll(true);
                    view.baseTree.fullReload();
                }
            });
        },

        rejectPackage: function (packageLink, isNew) {
            var view = this;
            view.serverCall({
                method: 'RejectPackage',
                params: [packageLink, isNew],
                waitMessage: 'Отмена...',
                success: function () {
                    view.packageEditPanelWin.close();
                }
            });
        },
        
        deletePackage: function(){
            var view = this.parentView || this;
            var checkedNodes = view.baseTree.getChecked();
            if (Ext.isEmpty(checkedNodes)) {
                var selNode = view.baseTree.getSelNode();
                if (!Ext.isEmpty(selNode)) {
                    checkedNodes.push(selNode);
                }
            }

            if (!Ext.isEmpty(checkedNodes)) {
                var checkedCodes = [];
                Ext.each(checkedNodes, function (node) {
                    checkedCodes.push(node.getId());
                });
                KS.confirm("Будет удалено строк: " + checkedNodes.length + ". Продолжить?",
                    "Подтвердите удаление", function (btn) {
                        if (btn === 'yes')
                            view.deletePackageInternal(checkedCodes);
                    });
            }
        },

        deletePackageInternal: function (checkedCodes) {
            this.serverCall({
                method: 'DeletePackage',
                params: [checkedCodes],
                waitMessage: 'Удаление ...',
                success: this.deleteCallback
            });
        },

        deleteCallback: function (deleted) {
            if (deleted) {
                this.baseTree.getRootNode().removeAll(true);
                this.baseTree.fullReload();
                this.mainGrid.reload();
            }
        },
    });
}(FormPackageDictionaryView.prototype));

// ============= GRID =======================
(function(viewClass) {
    KS.apply(viewClass, {
        
        setFormsFilter: function() {
            var view = this.parentView || this;
            var buttonStates = view.getToogleButtonStates();
            view.serverCall({
                method: 'SetFormsFilter',
                params: [buttonStates],
                waitMessage: 'Фильтрация ...',
                success: view.resetGrid
            });
        },

        getToogleButtonStates: function() {
            var view = this;
            var buttonStates = {};
            var toolbar = view.getToolbar(view.mainGrid);
            if (toolbar)
                toolbar.items.each(function (item) {
                    if (item.enableToggle)
                        buttonStates[item.tbarNode.code] = item.pressed;
                });
            return buttonStates;
        },

        setToggleButtonStates: function () {
            var view = this;
            var toolbar = view.getToolbar(view.mainGrid);
            if (toolbar)
                toolbar.items.each(function (item) {
                    if (item.enableToggle)
                        item.setPressed(true);
                });
            view.setFormsFilter();
        },

        addFormsToPackage: function(){
            var view = this.parentView || this;
            var nodeId = view.baseTree.getSelNodeId();
            if (!Ext.isEmpty(nodeId) && nodeId !== 'filter_off'){
                view.serverCall({
                    method: 'GetFormsSelectGrid',
                    params: [nodeId],
                    success: function(formsSelectGrid){
                        view.showFormsSelectGrid(formsSelectGrid, nodeId);
                    }
                });
            }
        },

        showFormsSelectGrid: function(formsSelectGrid, treeLink){
            if (Ext.isEmpty(formsSelectGrid)) return;
            var view = this;
            view.formsSelectGrid = this.createTemplateControl(formsSelectGrid, "formsSelectGrid");
            
            view.formsSelectWin = KS.showModal(view.formsSelectGrid, {
                title: 'Выберите значения...',
                autoHeight: false,
                resizable: true,
                autoScroll: true,
                maximizable: true,
                width: Math.max(600, KS.rootViewport.getWidth() / 2),
                height: Math.max(500, KS.rootViewport.getHeight() / 1.5),
                minHeight: 300,
                minWidth: 400,
                buttonAlign: 'left',
                buttons: ['->', 
                    {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.doAddFormsToPackage(treeLink);
                        }
                    }, 
                    { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function () {
                            view.formsSelectWin.close();
                        }
                    }]
            }, true);
        },

        doAddFormsToPackage: function(treeLink){
            var view = this;
            var formLinks = view.formsSelectGrid.getCheckedCodes();
            if (!Ext.isEmpty(formLinks) && formLinks.length > 0) {
                view.serverCall({
                    method: 'AddFormsToPackage',
                    params: [treeLink, formLinks],
                    success: function () {
                        view.formsSelectWin.close();
                        view.setTreeFilter(view.baseTree.getSelNode());
                    }
                });
            }
        },

        deleteForms: function(){
            var view = this.parentView || this;
            var selNode = view.baseTree.getSelNode();
            var treeLink = view.baseTree.getSelNodeId();
            if (Ext.isEmpty(selNode) ||  treeLink === 'filter_off') return;
            var formLinks = view.mainGrid.getCheckedCodes();
            if (Ext.isEmpty(formLinks)) return;
            
            var nodeCode = KS.Grid.getAnyCase(selNode, "text").split(" - ")[0];
            KS.confirm("Исключить выделенные объекты из " + nodeCode + "?", "Внимание", function (btn) {
                if (btn === 'yes'){
                    view.serverCall({
                        method: 'DeleteFormsFromPackage',
                        params: [treeLink, formLinks],
                        success: function () {
                            view.setTreeFilter(view.baseTree.getSelNode());
                        }
                    });
                }                    
            });
        },

        moveToPackage: function() {
            var view = this.parentView || this;
            var selNode = view.baseTree.getSelNode();
            var treeLink = view.baseTree.getSelNodeId();
            if (Ext.isEmpty(selNode) || treeLink === 'filter_off') return;
            var formLinks = view.mainGrid.getCheckedCodes();
            if (Ext.isEmpty(formLinks)) return;

            view.serverCall({
                method: 'GetSelectPackageGrid',
                success: function(selectPackageGrid){
                    view.showSelectPackageGrid(selectPackageGrid, treeLink, formLinks)
                }
            });
        },

        showSelectPackageGrid: function(selectPackageGrid, treeLink, formLinks){
            if (Ext.isEmpty(selectPackageGrid)) return;
            var view = this;
            view.selectPackageGrid = this.createTemplateControl(selectPackageGrid, "selectPackageGrid");

            view.selectPackageWin = KS.showModal(view.selectPackageGrid, {
                title: 'Выберите значения...',
                autoHeight: false,
                resizable: true,
                autoScroll: true,
                maximizable: true,
                width: 600,
                height: 550,
                minHeight: 300,
                minWidth: 400,
                buttonAlign: 'left',
                buttons: ['->', {
                    text: 'ОК',
                    cls: 'dim-button',
                    handler: function () {
                        view.moveFormsToPackage(treeLink, formLinks);
                    }
                }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function () {
                            view.selectPackageWin.close();
                        }
                    }]
            }, true);
        },

        moveFormsToPackage: function(oldTreeLink, formLinks){
            var view = this;
            var selectedForms = view.selectPackageGrid.getCheckedCodes();
            if (Ext.isEmpty(selectedForms)) return;
            var newTreeLink = selectedForms[0];
            
            if (oldTreeLink === newTreeLink) {
                view.selectPackageWin.close();
                return;
            }
            
            view.serverCall({
                method: 'MoveFormsToPackage',
                params: [oldTreeLink, newTreeLink, formLinks],
                success: function () {
                    view.selectPackageWin.close();
                    view.setTreeFilter(view.baseTree.getSelNode());
                }
            });
        }        
    });
}(FormPackageDictionaryView.prototype));