﻿FinControlImportView = KS.extend(BaseSvodView, {
    constructor: function(viewId) {
        FinControlImportView.superclass.constructor.call(this, viewId);
    },

    doImport: function() {
        var formCodes = [];
        var view = this.parentView || this;
        var checkedRows = view.formsGrid.getCheckedRows();
        Ext.each(checkedRows, function(formRec) {
            formCodes.push(formRec.get('code'));
        });
        if (Ext.isEmpty(formCodes)) return;
        view.serverCall({
            method: 'DoImport',
            waitMessage: ['Импорт ...'],
            params: [formCodes],
            success: function(cssList) {
                KS.registerCssStyles(cssList);
                view.mainGrid.reload();
                view.refreshTaskList();
            }
        });
    }
});

function finControlProtocolRenderer(value, metadata, record, rowIndex, colIndex, store) {
    return '<a href="_" class="like-hypertext" onclick="finControlShowProtocol(' +
        "'" + store.parentView.viewID + "'" + ',' + rowIndex + ');return false;">Протокол</a>';
}

function finControlShowProtocol(viewId, rowIdx) {
    var view = KS.getView(viewId),
        record = view.mainGrid.getStore().getAt(rowIdx),
        protocol = KS.Grid.getAnyCase(record, 'PROTOCOL');
    KS.showHtmlProtocol(protocol);
}

function finControlReportRenderer(value, metadata, record, rowIndex, colIndex, store) {
    var sfLink = KS.Grid.getAnyCase(record, 'REPORT');
    if (sfLink > 0) {
        return '<a href="_" class="like-hypertext" onclick="finControlOpenReport(' +
            "'" + store.parentView.viewID + "'" + ',' + sfLink + ');return false;">Отчет</a>';
    }
    return '';
}

function finControlOpenReport(viewId, sfLink) {
    var view = KS.getView(viewId);
    view.serverCall({
        method: 'OnGroupOperation',
        waitMessage: ['Открывается отчет ...'],
        params: ['REPORT_FORM', [sfLink], null]
    });
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();