EbudgetReportLoadView = KS.extend(BaseDictionaryView, {});
// ============= COMMON =======================
(function(viewClass) {
    var sc = EbudgetReportLoadView.superclass;
    
    KS.apply(viewClass, {
        getTbarClickHandler: function(tbarItem) {
            switch (tbarItem.code) {
                case 'LOAD':
                    return this.loadData;

                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        },
        
        processToolbarItemControl: function(ctrl, tbarNode) {
            switch (tbarNode.code) {
                case 'PERIOD': // Компонент выбора периода
                    ctrl = this.createTemplateControl(this.tpl.controls['periodComponent']);
                    break;     
                    
                case 'reportCodesSelector': // Компонент выбора отчетов
                    var store = Ext.create('Ext.data.Store', {
                        fields: tbarNode.additional.fields,
                        data: tbarNode.additional.storeData
                    });
                    ctrl = this.reportCodesSelector = Ext.create('Ext.form.field.Tag', {
                        store: store,
                        displayField: 'name',
                        valueField: 'code',
                        queryMode: 'local',
                        flex: 1,
                        grow: false,
                        emptyText: 'Выберите отчеты',
                        value: tbarNode.additional.checkedValues,
                        parentView: this
                    });
                    break;
            }
            return sc.processToolbarItemControl.call(this, ctrl, tbarNode);
        },

        periodCompChange: function(){
            this.periodComponent.getType(); // настраивается видимость элементов
        },

        loadData: function(){
            var view = this.parentView || this;
            if (view.hasChanges)
                KS.confirm("Сохранить изменения?", "Внимание", function(btn) {
                    if (btn === 'yes') {
                        view.loadDataAfterSave = true;
                        view.saveChanges();
                    }
                });
            else
                view.doLoadData();
        },

        saveChanges: function (close) {
            var view = this.parentView || this;
            view.serverCall({
                method: 'SaveChanges',
                waitMessage: 'Сохранение ...',
                success: function (hasSaveErrors) {
                    if (hasSaveErrors === true) {
                        KS.alert('Документ не сохранен!');
                        view.loadDataAfterSave = false;
                        return;
                    }
                    this.discardChanges();
                    if (close === true) {
                        this.close();
                    } else {
                        this.reload();
                    }
                }
            });
        },
        
        doLoadData: function(){
            var view = this;
            KS.confirm("Загрузить отчеты?", "Внимание", function(btn) {
                if (btn === 'yes') {
                    var period = view.periodComponent.getPeriod();
                    var reports = view.reportCodesSelector.getValue();
                    var checkedCodes = view.mainGrid.getCheckedCodes();
                    view.serverCall({
                        method: 'LoadData',
                        params: [period, reports, checkedCodes]
                    });
                }
            });            
        },

        resetView: function(){
            this.mainGrid.reload();
            this.discardChanges();

            var view = this;
            //Запоминаем индексы, чтобы восставновить отмеченные строки после обновления
            // в т.ч. новые строки, у которых closeCode меняется после сохранения
            var selectedRows = view.mainGrid.getCheckedRows();
            if (!Ext.isEmpty(selectedRows)){
                view.prevSelection = [];
                Ext.each(selectedRows, function(row){
                    view.prevSelection.push(view.mainGrid.getStore().indexOf(row));
                })
            }
        },

        afterGridDataLoad: function(){
            var view = this,
                grid = this.mainGrid;
            
            if (this.prevSelection){
                var selectedRecords = [];
                Ext.each(this.prevSelection, function(rowIdx){
                    var rec = grid.store.getAt(rowIdx);
                    if (rec)
                        selectedRecords.push(rec);
                })
                if (!Ext.isEmpty(selectedRecords))
                    grid.getSelectionModel().select(selectedRecords);
                this.prevSelection = [];
            }
            
            if (view.loadDataAfterSave){
                view.loadDataAfterSave = false;
                view.doLoadData();
            }
        },

        rowDblClickHandler: function(gridView, record, element, rowIndex, e) {
            var column = e.position.column;
            if (column.renderer === EbudgetDictRenderer) {
                var closeCode = KS.Grid.getAnyCase(record, gridView.grid.closeCode);
                this.openBudgetTree(closeCode);
            }
        },
        
        openBudgetTree: function(closeCode){
            this.serverCall({
                method: 'OpenBudgetTree',
                params: [closeCode]
            });
        },

        editGridCell: function(e, context) {
            if (context.value === null || context.value === context.originalValue)
                return false;
            var closeCode = KS.Grid.getAnyCase(context.record, context.grid.closeCode);
            var view = this;
            view.serverCall({
                method: 'EditGridCell',
                params: [closeCode, context.field, context.value],
                disableFog: true,
                success: function(result){
                    if (result)
                        view.touch();
                }
            });
        },

        clearOrgCell: function(closeCode){
            var view = this;
            this.serverCall({
                method: 'ClearOrgCell',
                params: [closeCode],
                disableFog: true,
                success: function(result){
                    if (result) {
                        view.mainGrid.reload();
                        view.touch();
                    }
                }
            });
        }
    });
}(EbudgetReportLoadView.prototype));

function EbudgetDictRenderer(value, metadata, record, rowIndex, colIndex, store) {
    if (Ext.isString(value))
        setTooltip(metadata, value);
    metadata.css += ' sidewall-dict-cell';
    var closeCode = KS.Grid.getAnyCase(record, store.grid.closeCode);
    var viewId = store.grid.parentView.viewID;
    return '<img src="PlatformHandler.axd?icon=delete.png" onclick="clearOrgCell(\'' + closeCode + '\',\'' + viewId +'\')" style="vertical-align: middle;"/>'
         + '<img src="PlatformHandler.axd?icon=dict.png" onclick="openBudgetTree(\'' + closeCode + '\',\'' + viewId +'\')" style="vertical-align: middle;"/>'
         + value;
}

function clearOrgCell(closeCode, viewId) {
    var view = KS.getView(viewId);
    if (view)
        view.clearOrgCell(closeCode);
}

function openBudgetTree(closeCode, viewId) {
    var view = KS.getView(viewId);
    if (view)
        view.openBudgetTree(closeCode);
}

