﻿DictionaryRROTreeView = KS.extend(BaseSvodView, {
    
    onTemplateRendered: function() {
        this.discardChanges();
    },

    onSetSavedState: function(saved) {
        var saveBtn = this.getToolbarItem(this.tree, null, 'SAVE');
        if (saveBtn)
            saveBtn.setDisabled(saved);
    },

    getTbarClickHandler: function(tbarItem) {
        var sc = DictionaryRROTreeView.superclass;

        switch (tbarItem.code) {
            case 'SORT':
            case 'SORT_BY_NUMBER':
            case 'SORT_BY_CODE':
            case 'EXPORT':
                return null;
            
            default:
                return sc.getTbarClickHandler.apply(this, arguments);
        }
    },

    testHandler: function() {

    },

    addRootNode: function() {
        var view = this.parentView || this;
        view.getEditNodePanel(null, true);
    },

    addChildNode: function() {
        var view = this.parentView || this;
        var activeNodeId = view.tree.getSelNodeId();
        view.getEditNodePanel(activeNodeId, true);
    },

    nodeDblClick: function(treeView, record) {
        this.getEditNodePanel(record.id, false);
    },

    editNode: function() {
        var view = this.parentView || this;
        var activeNodeId = view.tree.getSelNodeId();
        view.getEditNodePanel(activeNodeId, false);
    },

    getEditNodePanel: function(code, isNew) {
        var view = this;
        view.serverCall({
            method: 'GetEditNodePanel',
            params: [code, isNew],
            success: function(panel) {
                view.showEditNodePanel(panel, code, isNew);
            }
        });
    },
    
    showEditNodePanel: function(panel, code, isNew) {
        if (Ext.isEmpty(panel)) return;

        var view = this;
        this.editNodePanel = this.createTemplateControl(panel);
        this.addPanelItems(panel, this.editNodePanel);

        view.editNodeWin = KS.showModal(this.editNodePanel,{
            layout: 'fit',
            plain: true,
            frame: true,
            autoScroll: true,
            modal: true,
            maximizable: true,
            minWidth: 600,
            minHeight: 325,
            width: 600,
            height: 325,
            title: "Номер пунктов для формы РРО",
            buttonAlign: 'right',
            buttons: new Array({
                    text: 'Сохранить',
                    cls: 'dim-button',
                    handler: function () {
                        view.setNodeValues(code, isNew);
                    }
                }, { xtype: 'tbspacer', width: 8 },
                {
                    text: 'Отмена',
                    cls: 'dim-button',
                    handler: function() {
                        view.editNodeWin.close();
                    }
                })
        }, true);
    },

    setNodeValues: function(code, isNew) {
        var newValues = {
            Code: this.codeField.getValue(),
            Number: this.numberField.getValue(),
            GroupPoln: this.groupPolnField.getValue(),
            ShortName: this.shortNameField.getValue(),
            FullName: this.fullNameField.getValue(),
            EditOnlySums: this.onlySumsField.getValue()
        };

        var periodLink = this.getToolbarItem(this.tree, null, 'YEAR').getValue();

        var view = this;
        view.serverCall({
            method: 'SetNodeValues',
            params: [code, isNew, newValues, periodLink],
            success: function(nodeChanged) {
                if (nodeChanged) {
                    view.editNodeWin.close();
                    view.reloadTree();
                    view.touch();
                }
            }
        });
    },

    deleteNode: function() {
        var view = this.parentView || this;
        var activeNode = view.tree.getSelNode();
        if (activeNode) {
            KS.confirm("Удалить узел " + activeNode.data.text + " ?", "Внимание",
                function (btn) {
                    if (btn === 'yes') {
                        view.doDeleteNode(activeNode);
                    }
                });
        }
    },

    doDeleteNode: function(activeNode) {
        var view = this;
        var deleteNodes = [activeNode.getId()];
        var nodeChilds = view.getNodeChilds(activeNode);
        deleteNodes = deleteNodes.concat(nodeChilds);
        view.serverCall({
            method: 'DeleteNode',
            params: [deleteNodes],
            success: function(nodDeleted) {
                if (nodDeleted) {
                    view.reloadTree();
                    view.touch();
                }
            }
        });
    },

    getNodeChilds: function(node) {
        var view = this;
        var childNodes = [];
        if (node.hasChildNodes()) {
            Ext.each(node.childNodes, function (childNode) {
                childNodes.push(childNode.getId());
                childNodes = childNodes.concat(view.getNodeChilds(childNode));
            });
        }
        return childNodes;
    },

    setValues: function(data) {
        this.data = data;
        this.reloadTree();

        var historyCombo = this.getToolbarItem(this.tree, null, 'YEAR');
        if (historyCombo)
            historyCombo.getStore().loadData(this.data.historyItems);
    },

    reload: function() {
        var view = this.parentView || this;
        view.serverCall({
            method: 'Reload',
            waitMessage: 'Обновление дерева...',
            success: view.setValues
        });
    },

    reloadTree: function() {
        this.tree.getRootNode().removeAll(true);
        this.tree.fullReload();
    },

    setHistory: function(combo, record) {
        var link = KS.Grid.getAnyCase(record, "link");
        this.serverCall({
            method: 'SetHistory',
            params: [link],
            waitMessage: 'Чтение ...',
            success: this.reloadTree
        });
    },

    collapseHandler: function () {
        this.parentView.tree.collapseAll();
    },

    expandHandler: function () {
        this.parentView.tree.expandAll();
    },

    resetView: function() {
        this.reloadTree();
    },

    sortByNumber: function() {
        var view = this.parentView || this;
        var fullTree = this.tbarNode &&  this.tbarNode.code === "SORT_BY_NUMBER_FULL";
        var nodeId = fullTree ? null : view.tree.getSelNodeId();
        if (fullTree && nodeId == null) return;
        view.serverCall({
            method: 'OnSortByNumber',
            params: [fullTree, nodeId],
            success: view.reloadTree
        });
    },

    sortByCode: function() {
        var view = this.parentView || this;
        var fullTree = this.tbarItem &&  this.tbarNode.code === "SORT_BY_CODE_FULL";
        var nodeId = fullTree ? null : view.tree.getSelNodeId();
        if (fullTree && nodeId == null) return;
        view.serverCall({
            method: 'OnSortByCode',
            params: [fullTree, nodeId],
            success: view.reloadTree
        });
    }
});

if (typeof (Sys) !== 'undefined') {Sys.Application.notifyScriptLoaded(); }