﻿DictionaryOrg1CView = KS.extend(BaseDictionaryView, {
    
    newHandler: function () {
        var view = this.parentView;
        view.getOrg1CGridData("NEW", null);
    },

    editHandler: function () {
        var view = this.parentView;
        var checkedCodes = view.mainGrid.getCheckedCodes(true);
        if (Ext.isEmpty(checkedCodes)) return;
        if (checkedCodes[0])
            view.getOrg1CGridData("EDIT", checkedCodes[0]);
    },

    getOrg1CGridData: function (mode, orgId) {
        var view = this;
        view.serverCall({
            method: 'GetOrg1CGridData',
            waitMessage: 'Открывается ...',
            params: [mode, orgId],
            success: function (settings) {
                view.showEditOrg1C(settings, mode === "EDIT", orgId);
            }
        });
    },

    showEditOrg1C: function (settings, isEdit, orgId) {
        if (settings == null) {
            KS.log("Не удалось " + (isEdit ? "найти" : "создать") + " строку");
            return;   
        }
        this.propertyGrid = this.getPropertyGridByOption(settings, "propertyGrid", "Общие")
        var view = this;
        this.editOrg1CWin = KS.showModal(this.propertyGrid, {
            title: 'Свойства',
            autoHeight: false,
            height: 400,
            buttonAlign: 'left',
            buttons: ['->', 
                {
                    text: 'ОК',
                    cls: 'dim-button',
                    handler: function () {
                        view.doEditInfo(isEdit, orgId);
                    }
                }, 
                { xtype: 'tbspacer', width: 8 },
                {
                    text: 'Отмена',
                    cls: 'dim-button',
                    handler: function () {
                        view.rejectInfo(isEdit, orgId);
                    }
                }]
        }, true);
    },

    doEditInfo: function (isEdit, orgId) {
        var view = this;
        var newValues = this.propertyGrid.source;
        view.serverCall({
            method: 'EditInfo',
            params: [newValues, isEdit, orgId],
            waitMessage: isEdit ? 'Редактирование ...' : 'Создание ...',
            success: function (result) {
                if (result) {
                    view.editOrg1CWin.close();
                    view.mainGrid.reload();
                }
            }
        });
    },
    
    rejectInfo: function (isEdit, orgId) {
        var view = this;
        view.serverCall({
            method: 'RejectInfo',
            params: [isEdit, orgId],
            disableFog: true,
            success: function () {
                view.editOrg1CWin.close();
            }
        });
    }
});

if (typeof (Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();