﻿DictionaryEdsView = KS.extend(BaseTreeView, { });

// ============= COMMON =======================
(function(viewClass) {
    KS.apply(viewClass, {
        
        onTemplateRendered: function () {
            this.baseTree.selectFirstNode();
        },
        
        getTbarClickHandler: function (tbarItem) {
            var sc = DictionaryEdsView.superclass;

            if (this.checkHandler(tbarItem.pluginNameWeb) && !Ext.isEmpty(tbarItem.code)) {
                return sc.getTbarClickHandler.call(this, tbarItem);
            }

            switch (tbarItem.code) {
                case "NEW":
                    return this.addUser;

                case "ADD":
                    return this.defineAddButton;

                case "ADD_FROM_EXCEL":
                    return this.showUsersExcelWindow;

                case "EDIT":
                    return this.defineEditButton;

                case "DELETE":
                    return this.defineDelButton;

                case "MOVE":
                    return this.moveToLevel;

                case "COPY":
                    return this.copyToLevel;

                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        },

        defineAddButton: function () {
            var view = this.parentView;
            switch (this.ownerCt.ownerCt.itemId) {
                case "baseTree": 
                    return view.addGroup();

                case "mainGrid": 
                    return view.addUser();

                default:
                    return null;
            }
        },

        defineEditButton: function () {
            var view = this.parentView;
            switch (this.ownerCt.ownerCt.itemId) {
                case "baseTree": 
                    return view.editGroup();

                case "mainGrid":
                    return view.editUser();

                default:
                    return null;
            }
        },

        defineDelButton: function () {
            var view = this.parentView;
            switch (this.ownerCt.ownerCt.itemId) {
                case "baseTree": 
                    return view.deleteGroup();

                case "mainGrid":
                    return view.deleteUsers();

                default:
                    return null;
            }
        },

        //=========================TREE=========================
        addGroup: function () {
            this.showEditGroupPanel(null, true);
        },

        editGroup: function () {
            var view = this;
            var node = view.baseTree.getSelNode();
            if (!Ext.isEmpty(node) && !Ext.isEmpty(node.data) && node.data.isFirst == false)
                view.showEditGroupPanel(node.getId(), false);
        },

        showEditGroupPanel: function (groupLink, isNew) {
            var view = this;
            view.serverCall({
                method: 'GetEditGroupProperties',
                params: [groupLink, isNew],
                success: function (settings) {
                    view.showEditGroupPanelCallback(settings, groupLink, isNew);
                }
            });
        },

        showEditGroupPanelCallback: function(settings, groupLink, isNew) {
            if (Ext.isEmpty(settings)) return;
            this.propertyGrid = this.getPropertyGridByOption(settings, "propertyGrid", "Общие");
            var view = this;
            this.formEditPanelWin = KS.showModal(this.propertyGrid,
                {
                    title: 'Свойства',
                    autoHeight: false,
                    layout: "anchor",
                    height: 400,
                    minHeight: 200,
                    width: 600,
                    minWidth: 300,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.doEditGroup(groupLink, isNew);
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.rejectGroup(groupLink, isNew);
                            }
                        }]
                },
                true);
        },

        doEditGroup: function (groupLink, isNew) {
            var view = this;
            var newValues = this.propertyGrid.source;
            view.formEditPanelWin.close();
            view.serverCall({
                method: 'EditGroup',
                params: [newValues, groupLink, isNew],
                waitMessage: isNew ? 'Создание ...' : 'Редактирование ...',
                success: function () {
                    view.baseTree.getRootNode().removeAll(true);
                    view.baseTree.fullReload();
                }
            });
        },

        rejectGroup: function (groupLink, isNew) {
            var view = this;
            view.serverCall({
                method: 'RejectGroup',
                params: [groupLink, isNew],
                waitMessage: 'Отмена...',
                success: function () {
                    view.formEditPanelWin.close();
                }
            });
        },

        deleteGroup: function () {
            var view = this.parentView || this;
            var checkedNodes = view.baseTree.getChecked();
            if (Ext.isEmpty(checkedNodes)) {
                var selNode = view.baseTree.getSelNode();
                if (!Ext.isEmpty(selNode)) {
                    checkedNodes.push(selNode);
                }
            }

            if (!Ext.isEmpty(checkedNodes)) {
                var checkedCodes = [];
                Ext.each(checkedNodes, function (node) {
                    checkedCodes.push(node.getId());
                });
                KS.confirm("Будет удалено строк: " + checkedNodes.length + ". Продолжить?",
                    "Подтвердите удаление", function (btn) {
                        if (btn === 'yes')
                            view.deleteGroupInternal(checkedCodes);
                    });
            }
        },

        deleteGroupInternal: function (checkedCodes) {
            this.serverCall({
                method: 'DeleteGroup',
                params: [checkedCodes],
                waitMessage: 'Удаление ...',
                success: this.deleteCallback
            });
        },

        deleteCallback: function (deleted) {
            if (deleted) {
                this.baseTree.getRootNode().removeAll(true);
                this.baseTree.fullReload();
                this.mainGrid.reload();
            }
        },

        moveToLevel: function() {
            var view = this.parentView || this;
            view.getSelectLevelTree(true);
        },

        copyToLevel: function() {
            var view = this.parentView || this;
            view.getSelectLevelTree(false);
        },

        getSelectLevelTree: function(isMove){
            var view = this;
            var checkedRows = view.mainGrid.getCheckedRows();
            if (!Ext.isEmpty(checkedRows)) {
                view.serverCall({
                    method: 'GetSelectLevelTree',
                    success: function(selectLevelTree){
                        view.showSelectUserGrid(selectLevelTree, isMove)
                    }
                });
            }
        },
        
        showSelectUserGrid: function (selectLevelTree, isMove) {
            if (Ext.isEmpty(selectLevelTree)) return;
            var view = this;
            view.selectLevelTree = this.createTemplateControl(selectLevelTree, "selectLevelTree");
            view.selectFormsWin = KS.showModal(view.selectLevelTree, {   
                title: 'Выберите значения...',
                autoHeight: false,
                resizable: true,
                autoScroll: true,
                maximizable: true,
                width: 550,
                height: 600,
                minHeight: 300,
                minWidth: 400,
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.addUsersToLevel(isMove);
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function () {
                            view.selectFormsWin.close();
                        }
                    }]
            }, true);
        },

        addUsersToLevel: function (isMove) {
            var view = this;
            var linkLevel = view.selectLevelTree.getSelNodeId();
            if (linkLevel){
                var checkedRows = view.mainGrid.getCheckedRows();
                var userRelationLinks = [];
                Ext.each(checkedRows, function(row){
                    userRelationLinks.push(KS.Grid.getAnyCase(row, "LINK_RELU"));
                })
                view.selectFormsWin.close();
                view.serverCall({
                    method: 'AddUsersToLevel',
                    params: [linkLevel, userRelationLinks, isMove],
                    success: function () {
                        view.mainGrid.reload();
                    }
                });
            }
        },

        setTreeFilter: function (node) {
            var nodeId = node.id;
            var filterOff = nodeId === 'filter_off';
            var newUserBtn = this.getToolbarItem(this.mainGrid, null, "NEW");
            if (newUserBtn)
                newUserBtn.setDisabled(filterOff);
            this.serverCall({
                method: 'SetTreeFilter',
                params: [filterOff ? null : nodeId],
                waitMessage: 'Фильтрация ...',
                success: this.resetGrid
            });
        },

        //=========================GRID=========================
        rowDblClickHandler: function() {
            this.editUser();
        },
        
        addUser: function () { 
            var view = this.parentView;
            var nodeId = view.baseTree.getSelNodeId();
            if (nodeId !== "filter_off") {
                view.showEditUserPanel(nodeId, true);
            } else {
                console.log("Не выбран уровень.");
            }
        },

        editUser: function () {
            var view = this;
            var ccc = view.mainGrid.getCheckedRows();
            if (Ext.isEmpty(ccc)) return;
            var userId = KS.Grid.getAnyCase(ccc[0], "link_relu")
            view.showEditUserPanel(userId, false);
        },

        //Если добавление пользователя, то userId - LINK_LEVEL, если редактирование, то link_relu
        showEditUserPanel: function (userId, isNew) {
            var view = this;
            view.serverCall({
                method: 'GetUserEditPanel',
                params: [userId, isNew],
                success: function (panel) {
                    view.showEditUserPanelCallback(panel, userId, isNew);
                }
            });
        },

        showEditUserPanelCallback: function (panel, userId, isNew) {
            if (Ext.isEmpty(panel)) return;

            var view = this;
            view.userPanel = view.createTemplateControl(panel, 'userPanel');
            view.addPanelItems(panel, view.userPanel);

            view.selectCertBtn = KS.create({
                    type: 'filefield',
                    parentView: view,
                    itemId: 'selectCertBtn',
                    accept: '.cer,.p7b,.pfx,.crt'
                },
                {
                    buttonConfig: {
                        tooltip : 'Выбрать сертификат',
                        iconCls: 'ks-icon-folder_open',
                        text: '',
                        width: 24
                    },
                    callback: view.loadCertFromFile,
                    multiple: false,
                    buttonOnly: true,
                    emptyText: 'Выберите файл...',
                    width: 24
                });
            if (view.certName)
                view.certName.add(view.selectCertBtn);

            view.editableUserId = userId;
            view.globalIsNew = isNew;
            view.userPanelWin = KS.showModal(view.userPanel, {
                title: 'Редактирование пользователя',
                autoHeight: false,
                resizable: true,
                maximizable: false,
                layout: 'anchor',
                height: 340,
                minHeight: 200,
                width: 600,
                minWidth: 300,
                buttonAlign: 'left',
                buttons: ['->', {
                    text: 'ОК',
                    cls: 'dim-button',
                    handler: function () {
                        view.doEditUser();
                    }
                }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function () {
                            view.userPanelWin.close();
                        }
                    }]
            }, true);
        },

        edsBlockDateChange: function(comp, newValue) {
            var isBegin = comp.ctrlId === "beginBlock";
            this.serverCall({
                method: 'EdsBlockDateChange',
                params: [this.editableUserId, this.globalIsNew, newValue, isBegin],
                disableFog: true
            });
        },

        doEditUser: function () {
            var newValues = this.collectUserEditValue();
            var view = this;
            view.serverCall({
                method: 'DoEditUser',
                waitMessage: 'Сохранение ...',
                params: [newValues, this.editableUserId, this.globalIsNew],
                success: function () {
                    view.userPanelWin.close();
                    view.reload();
                }
            });
        },

        collectUserEditValue: function () {
            return {
                "USER": this.user.getValue(),
                "SERT_NAME": this.certName.getValue(),
                "SUBJECT": this.subjectName.getValue(),
                "ISSUER": this.issuerName.getValue(),
                "NAME_ORGANIZATION": this.nameOrganization.getValue(),
                "BEGIN_BLOCK_DATE": this.beginBlockDate.getValue(),
                "END_BLOCK_DATE": this.endBlockDate.getValue(),
                "NOTBEFORE": this.notbefore.getValue(),
                "NOTAFTER": this.notafter.getValue()
            }
        },

        deleteUsers: function () {
            var view = this.parentView || this;
            var checkedRows = view.mainGrid.getCheckedRows();
            if (!Ext.isEmpty(checkedRows)) {
                var links = [];
                Ext.each(checkedRows, function (row) {
                    links.push(KS.Grid.getAnyCase(row, "LINK_RELU"));
                });
                KS.confirm("Будет удалено строк: " + checkedRows.length + ". Продолжить?", "Подтвердите удаление", function (btn) {
                    if (btn === 'yes')
                        view.serverCall({
                            method: 'DeleteUsers',
                            params: [links],
                            success: function () {
                                view.mainGrid.reload();
                            }
                        });
                });
            }
        },

        onSelect: function () {
            var view = this.parentView;
            var relationId = this.ownerCt.textField.relationId;
            view.userPanelWin.mask();
            view.serverCall({
                method: 'OnSelect',
                params: [relationId, view.editableUserId, view.globalIsNew],
                success: function(){
                    view.userPanelWin.unmask();
                }
            });
        },

        addUsers: function () {
            var view = this.parentView;
            view.serverCall({
                method: 'AddUsers'
            });
        },

        onValuesSelected: function (arg) {
            var view = this,
                values = arg[0][0];

            if (values['ACTION']) {
                if (values['ACTION'] === 'RELOAD_MAIN_GRID'){ // Добавление нескольких пользователей
                    view.mainGrid.reload();
                    return;                    
                }
            }
            switch (values["CLOSE_CODE"]) {
                case "LINK_USER":
                    this.user.setValue(values["USER"]);
                    break;
            }
            if (values["LINK_BUDGET_HIERARCHY"]) {
                this.nameOrganization.setValue(values["ORGANIZATION_NAME_SHORT"]);
            }
        },

        showUsersExcelWindow: function () {
            var view = this.parentView || this;
            var linkLevel = view.baseTree.getSelNodeId();

            if (Ext.isEmpty(linkLevel))
                return;

            view.serverCall({
                method: 'GetExcelLoadUsers',
                success: function(result) {
                    if (Ext.isEmpty(result)) return;
                    view.excelLoadPanel = view.createTemplateControl(result.spreadsheetPanel, 'excelLoadPanel');
                    view.addPanelItems(result.spreadsheetPanel, view.excelLoadPanel);
                    view.excelLoadWin = KS.showModal(view.excelLoadPanel, {
                        title: 'Справочник',
                        autoHeight: false,
                        border: false,
                        flex: 1,
                        height: KS.rootViewport.getHeight() * 0.8,
                        width: KS.rootViewport.getWidth() * 0.8,
                        buttonAlign: 'left',
                        buttons: ['->',
                            {
                                text: 'ОК',
                                cls: 'dim-button',
                                handler: function () {
                                    view.addUsersFromExcel(result.fileStorageKey, linkLevel);
                                }
                            }, { xtype: 'tbspacer', width: 8 },
                            {
                                text: 'Отмена',
                                cls: 'dim-button',
                                handler: function () {
                                    view.excelLoadWin.close();
                                }
                            }]
                    }, true);
                }
            })
        },

        addUsersFromExcel: function (fileStorageKey, linkLevel) {
            var view = this;
            view.spreadsheetFrame.saveDocument(function () {
                view.excelLoadPanel.mask('Загрузка...');
                view.serverCall({
                    method: 'AddUsersFromExcel',
                    params: [fileStorageKey, linkLevel],
                    success: function () {
                        view.excelLoadPanel.unmask();
                        view.excelLoadWin.close();
                        view.reload();
                    }
                });
            }, view);
        },

        //===========CERT===============
        changeCertNameField: function(comp, certName){
            if (Ext.isEmpty(certName)){ // clearBtn
                this.notbefore.setValue("");
                this.notafter.setValue("");
                this.subjectName.setValue("");
                this.issuerName.setValue("");

                this.edsCertDataChange({
                    serial : certName,
                    subject : null,
                    issuer : null,
                    notbefore : null,
                    notafter : null,
                }, true);
            }
        },

        edsCertDataChange: function(certData, isCertNameChange) {
            this.serverCall({
                method: 'EdsCertDataChange',
                params: [this.editableUserId, this.globalIsNew, certData, isCertNameChange],
                disableFog: true
            });
        },
        
        showCertDictionary: function () {
           var view = this.parentView || this;
           view.getOpenData([]);
        },

        getCertificates: function () {
           KS.XCrypt.selectCertificate(this.setSelectedCert, this);
        },

        setSelectedCert: function (certData) {
            if (certData && certData.serial) {
                var certSerial = '#' + certData.serial.toUpperCase();
                this.certName.setValue(certSerial);
                this.notbefore.setValue(certData.notbefore);
                this.notafter.setValue(certData.notafter);
                this.subjectName.setValue(certData.subject);
                this.issuerName.setValue(certData.issuer);

                this.edsCertDataChange({
                    serial : certSerial,
                    subject : certData.subject,
                    issuer : certData.issuer,
                    notbefore : certData.notbefore,
                    notafter : certData.notafter,
                }, false);
            }
        },

        loadCertFromFile: function(fileKeys) {
            var view = this.parentView || this;
            if (!KS.isEmpty(fileKeys[0]) && !KS.isEmpty(fileKeys[0].fileName) && !KS.isEmpty(fileKeys[0].fileExtension)) {
                view.serverCall({
                    method: 'LoadCert',
                    params: [fileKeys, ""],
                    waitMessage: 'Загрузка сертификата...',
                    success: view.setSelectedCert
                });
            }
        }
    });
}(DictionaryEdsView.prototype));

if (typeof (Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();