﻿/*reads',
hits', 
percent
dirty',
objects*/

DictionaryCacheView = KS.extend(BaseSvodView, {
    constructor: function(viewId) {
        DictionaryCacheView.superclass.constructor.call(this, viewId);
    },

    onTemplateRendered: function() {
        this.setCacheTotalSize();
    },

    setCacheTotalSize: function () {
        var view = this;
        view.serverCall({
            method: 'GetCacheTotalSize',
            success: function(size) {
                view.cacheTotalSize.setValue(size);
            }
        });
    },

    deleteKeys: function() {
        var view = this.parentView || this;
        if (view.activeKeyrec) {
            KS.confirm("Удалить строку?", "Подтвердите удаление", function(btn) {
                if (btn === 'yes') {
                    view.serverCall({
                        method: 'DeleteKeyDictionary',
                        params: [KS.Grid.getAnyCase(view.activeKeyrec,"CODE") || null],
                        waitMessage: 'Удаление ...',
                        success: function(deleted) {
                            if (deleted) {
                                view.keysGrid.store.remove(view.activeKeyrec);
                                delete view.activeKeyrec;
                                view.dictionaryTabPanel.removeAll();
                                view.calcTotalSize();
                            }
                        }
                    });
                }
            });
        }
    },

    reloadKeys: function() {
        var view = this.parentView || this;
        view.calcTotalSize();
        view.dictionaryTabPanel.removeAll();
        view.keysGrid.resetPage();
    },

    headerClick: function(gridView, record) {
        if (record.dataIndex !== 'ESTIMAED_SIZE_BYTE' && record.dataIndex !== 'ESTIMAED_SIZE')
            return;

        var sorters = record.grid.store.getSorters();
        if (sorters.length === 0) {
            sorters.add();
        }
        sorters.items[0].setSorterFn(function(firstItem, secondItem) {
            var firstItemSize = parseInt(firstItem.data['ESTIMAED_SIZE_BYTE']);
            var secondItemSize = parseInt(secondItem.data['ESTIMAED_SIZE_BYTE']);
            return firstItemSize > secondItemSize ? 1 : (firstItemSize < secondItemSize ? -1 : 0);
        });
    },

    keysRowClick: function(gridView, record) {
        this.activeKeyrec = record;
        if (this.activeKeyrec) {
            this.serverCall({
                method: 'ReloadKeyDictionary',
                params: [KS.Grid.getAnyCase(this.activeKeyrec, "CODE") || null],
                waitMessage: 'Чтение ...',
                success: this.showKeyDictionary
            });
        }
    },

    showKeyDictionary: function(gridSettingsList) {
        var view = this;
        view.dictionaryTabPanel.removeAll(true);
        if (Ext.isEmpty(gridSettingsList))
            return;
        this.serverCall({
            method: 'GetCachedDictsGrid',
            params: [],
            waitMessage: 'Чтение ...',
            success: this.showDictionaryGrids
        });
    },

    showDictionaryGrids: function(dictGrids) {
        var view = this;
        Ext.each(dictGrids, function(dictGrid) {
            var grid = KS.create(dictGrid); 
            view.dictionaryTabPanel.add(grid);
        });
    },

    seacrhDictionary: function() {
        var view = this.parentView || this;
        var csgSm = view.cacheStatGrid.getSelectionModel();
        var selRec = null;
        var selRecs = csgSm.getSelection();
        if (selRecs && selRecs.length > 0)
            selRec = selRecs[0];
        if (!selRec || Ext.isEmpty(KS.Grid.getAnyCase(selRec,"CODE")))
            return;
        view.iisTabs.setActiveTab(0);
        view.dictionaryTabPanel.removeAll(true);
        view.keysGrid.eachColumnCfg(function (column) {
            if (column.dataIndex === 'CODE' ||
                column.dataIndex === 'code') {
                view.keysGrid.onKsFilterChange(column, "'%"+KS.Grid.getAnyCase(selRec,"CODE")+"%'", "like");
            }
        });
        view.keysGrid.resetPage();
    },

    clearWholeClientCache: function() {
        var view = this.parentView || this;
        view.serverCall({
            method: 'ClearWholeClientCache',
            waitMessage: 'Удаление ...',
            success: view.reloadKeys
        });
    },

    clearCachedDictionaryStatistics: function() {
        var view = this.parentView || this;
        view.cacheStatGrid.store.removeAll();
        view.serverCall({
            method: 'ClearCachedDictionaryStatistics',
            waitMessage: 'Удаление ...'
        });
    },

    calcTotalSize: function() {
        var view = this.parentView || this;
        view.serverCall({
            method: 'CalcTotalSize',
            waitMessage: 'Вычисление ...',
            success: function(size) {
                view.cacheTotalSize.setValue(size);
            }
        });
    }
});

function dictionaryCacheObjectsRenderer(value, metadata, record, rowIndex, colIndex, store) {
    var code = record.get('code'),
        stat = store.grid.parentView.data.cachedDictionaryStatistics,
        rec = stat[code];
    if (rec) {
        var dev = rec.Reads - rec.CacheHits - rec.DirtyReads - rec.Fails - rec.CachedObjectsCount;
        if (dev > 0 && dev <= 5) {
            metadata.css += ' log-level-WARN';
        } else if (dev < 0 || dev > 5) {
            metadata.css += ' log-level-ERROR';
        }
    }
    return value;
}

if (typeof (Sys) !== 'undefined') {Sys.Application.notifyScriptLoaded(); }