DbListView = KS.extend(KS.Ext.ClientView, {});

// =============== COMMON ==============
(function(viewClass) {
    KS.apply(viewClass, {
        treeNodeClick: function(v, node) {
            if(node.data.json.disabled) return false;

            if (node.isLeaf()) {
                this.serverCall({
                    method: 'DbListTreeClick',
                    params: [node.id]
                });
            } else {
                if (node.isExpanded()) {
                    node.expand();
                } else {
                    node.collapse();
                }
            }
            return false;
        },

        setBranchLoadedState: function (nodeId) {
            var view = this;
            view.serverCall({
                method: 'SetNodeLoadedState',
                params: [nodeId]
            });
        }
    });
}(DbListView.prototype));

// =============== Events ==============
(function(viewClass) {
    KS.apply(viewClass, {
        beforeMainTreeNodeExpand: function (node) {
            var view = this;
            view.serverCall({
                method: 'OnMainTreeBeforeNodeExpand',
                params: [node.id],
                success: function () {
                    view.setBranchLoadedState(node.id);
                }
            });
        },

        showContextMenu: function(tree, node, sel, t, event) {
            var view = this;
            view.serverCall({
                method: 'GetContextMenu',
                params: [node.id],
                success: function(data) {
                    if (Ext.isEmpty(data)) return;

                    var menu = new Ext.menu.Menu({
                        shadow: true,
                        ignoreParentClicks: true,
                        items: data,
                        listeners: {
                            'click': function (menu, itemClicked) {
                                view.serverCall({
                                    method: 'OnContextMenuClick',
                                    params: [node.id, itemClicked.menuId || 0]
                                });
                            }
                        }
                    });
                    menu.showAt(event.getXY());
                    view.setBranchLoadedState(node.id);
                }
            });

            event.stopEvent();
            return false;
        },

        onServerRemoveNode: function(nodeId) {
            var node = this.mainTree.getNodeById(nodeId);
            if (Ext.isEmpty(node)) return;
            node.remove(true);
        },

        onServerShowModalProtocol: function(caption, html){
            var view = this;
            view.protocolModal = KS.Ext.showAdjustableWindow(html, {
                title: caption,
                buttons: ['->', {
                    text: 'ОК',
                    cls: 'dim-button',
                    handler: function () {
                        view.protocolModal.close();
                    }
                }]
            });
        }
    });
}(DbListView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();