﻿function clusterStateRenderer(value, metadata, record, rowIndex, colIndex, store) {
    setTooltip(metadata, value);
    if (record.data.load <= store.parentView.minLoad) metadata.css += ' log-level-INFO';
    return value;
}

function clusterTimeRenderer(value, metadata, record, rowIndex, colIndex, store) {
    var dt = new Date(+value);
    if (record.data.load <= store.parentView.minLoad) metadata.css += ' log-level-INFO';
    return Ext.util.Format.date(dt, 'H:i:s.u');
}

ClusterStateView = KS.extend(KS.Ext.ClientView, {
    constructor: function(viewId) {
        ClusterStateView.superclass.constructor.call(this, viewId);
    },

    onInit: function() {
        this.renderToParent(this.grid = new TabListGrid({
            parentView: this,
            customLoad: true,
            enablePaging: false,
            enableFiltering: false,
            stateful: false,
            viewConfig: { forceFit: true },
            toolbarItems: new Array({
                iconCls: 'ks-icon-refresh',
                tooltip: 'Обновить список',
                scope: this,
                handler: this.refresh
            }),
            fbar: new Ext.Toolbar({
                items: new Array(this.stateLabel = new Ext.form.Label({
                    text: '-'
                })),
                enableOverflow: false
            }),
            gridSettings: {
                PageSize: this.pageSize,
                Band: new Array({
                    AutoExpandColumn: "details",
                    PageSize: this.pageSize,
                    Column: KS.Grid.ColumnArray(new Array({
                        dataIndex: "id",
                        header: "ID узла",
                        width: 80,
                        align: 2,
                        renderer: 'clusterStateRenderer',
                        visibility: KS.webClusterEnabled
                    }, {
                        dataIndex: "load",
                        header: "Нагрузка",
                        width: 30,
                        align: 2,
                        renderer: 'clusterStateRenderer',
                        visibility: KS.webClusterEnabled
                    }, {
                        dataIndex: "activeUsers",
                        header: "activeUsers",
                        width: 30,
                        align: 2,
                        renderer: 'clusterStateRenderer',
                        visibility: true
                    }, {
                        dataIndex: "maxUsers",
                        header: "maxUsers",
                        width: 30,
                        align: 2,
                        renderer: 'clusterStateRenderer',
                        visibility: KS.webClusterEnabled
                    }, {
                        dataIndex: "serverTime",
                        header: "serverTime",
                        width: 80,
                        align: 2,
                        renderer: 'clusterTimeRenderer',
                        visibility: true
                    }, {
                        dataIndex: "serverUri",
                        header: "serverUri",
                        width: 180,
                        align: 1,
                        renderer: 'clusterStateRenderer',
                        visibility: true
                    }, {
                        dataIndex: "clientUri",
                        header: "clientUri",
                        width: 180,
                        align: 1,
                        renderer: 'clusterStateRenderer',
                        visibility: KS.webClusterEnabled
                    }))
                })
            }
        }));
        this.setData();
    },

    setData: function() {
        var newRow, node,
            total = this.data.nodes.length,
            json = { total: total, rows: [] };
        this.minLoad = 1000000;
        for (var idx = 0; idx < total; idx++) {
            node = this.data.nodes[idx];
            newRow = {};
            for (var field in node) {
                newRow[field] = node[field];
            }
            if (node.load < this.minLoad) this.minLoad = node.load;
            json.rows.push(newRow);
        }
        var r = this.grid.store.reader.readRecords(json);
        this.grid.store.loadRecords(r, Ext.apply({}, this.grid.store.lastOptions), true);
        this.stateLabel.setText('Polled at ' + this.data.delay.toFixed(0) + ' ms');
        return false;
    },

    refresh: function() {
        var view = this;
        view.serverCall({
            method: 'RefreshState',
            waitMessage: 'Обновление ...',
            success: function(data) {
                view.data = data;
                view.setData();
            }
        });
    }
});

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();