﻿CheckSumsView = KS.extend(BaseSvodView, { });

(function (viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function () {
            this.setExcludeBtnsState("0");
            this.groupsGrid.getSelectionModel().select(0);
        },

        resetView: function () {
            this.groupsGrid.reload();
            this.systemRulesGrid.reload();
            this.userRulesGrid.reload();
        },

        setExcludeBtnsState: function(groupLink) {
            this.getToolbarItem(this.systemRulesGrid, null, 'EXCLUDE').setDisabled(groupLink === "0");
            this.getToolbarItem(this.userRulesGrid, null, 'EXCLUDE').setDisabled(groupLink === "0");
        },

        getTbarClickHandler: function(tbarItem) {
            var sc = CheckSumsView.superclass;
            switch (tbarItem.code) {
                case "NEW_GROUP":
                    return this.createNewGroup;

                case "NEW_RULE":
                    return this.createNewRule;

                case "EDIT_GROUP":
                    return this.editGroup;

                case "EDIT_RULE":
                    return this.editRule;

                case "COPY_GROUP":
                    return this.copyGroup;

                case "COPY_RULE":
                    return this.copyRule;

                case "DELETE_GROUP":
                    return this.deleteGroup;

                case "DELETE_RULE":
                    return this.deleteRule;

                case "EXPORT":
                    return this.exportRules;

                case "IMPORT":
                    return this.importRules;

                case "TRANSFER_TO_USER":
                    return this.transferToUser;

                case "TRANSFER_TO_SYSTEM":
                    return this.transferToSystem;

                case "COPY_TO_USER":
                    return this.copyToUser;

                case "COPY_TO_SYSTEM":
                    return this.copyToSystem;

                case "MOVE":
                    return this.includeInGroup;

                case "EXCLUDE":
                    return this.excludeFromGroup;

                case "ADD":
                    return this.addExisting;

                case "REPLACE":
                    return this.massiveReplace;

                case "LIST_ORG_ROW_SELECTOR_METHOD":
                case "LIST_BUDGET_GROUPS":
                case "LIST_RULE_CALC_MACRO":
                    return this.tryExecuteTask;

                case "HIDE_CLOSED_GROUPS":
                    return this.hideClosedGroups;

                case "TRANSFER":
                    return null;

                case "EXCELEDIT":
                case "EXCELEDITR":
                    return this.massiveEdit;

                case "CHECK_SUMS_BETWEEN_COPY":
                    return this.copyRulesInOther;

                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        },

        processToolbarItemControl: function(ctrl, tbarItem) {
            if (tbarItem.nodeStyle === 4 &&
                tbarItem.additional &&
                tbarItem.additional.DATETIMEEDITOR_VALUE) {
                switch (tbarItem.additional.DATETIMEEDITOR_VALUE) {
                    case 'DATETIMEEDITOR':
                    {
                        var newCtrl = new Ext.form.field.Date({
                            itemId: 'RULE_DATETIME',
                            format: 'd.m.Y',
                            editable: true,
                            enableKeyEvents: false,
                            value: new Date()
                        });
                        newCtrl.on('change', this.dateChanged, this);
                        return newCtrl;
                    }
                }
            }
            return CheckSumsView.superclass.processToolbarItemControl.apply(this, arguments);
        },

        showGroups: function() {
            var view = this.parentView;
            if (this.pressed) {
                view.groupsPanel.expand();
            } else {
                view.groupsPanel.collapse();
            }
        },

        groupGridRowSelect: function(selModel, record) {
            var groupLink = KS.Grid.getAnyCase(record, "LINK_GROUP");
            this.setActiveGroup(groupLink);
        },

        setActiveGroup: function(groupLink) {
            var view = this;
            if (Ext.isEmpty(groupLink)) {
                var groupLinks = view.groupsGrid.getCheckedCodes();
                if (Ext.isEmpty(groupLinks)) return;
                groupLink = groupLinks[0];
            }
            var activeGrid = view.rulesTabPanel.getActiveTab();
            var dateTime = this.getToolbarItem(activeGrid, null, "Container2").getValue();

            view.serverCall({
                method: 'SetActiveGroup',
                params: [groupLink, dateTime],
                disableFog: true,
                success: function() {
                    view.systemRulesGrid.reload();
                    view.userRulesGrid.reload();
                    view.setExcludeBtnsState(groupLink);
                }
            });
        },

        createNewGroup: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'CreateNewGroup',
                disableFog: true,
                success: view.showEditGroupWin
            });
        },

        editGroup: function(btn) {
            var view = btn ? this.parentView : this;
            var selectGroups = view.groupsGrid.getCheckedCodes();
            if (!Ext.isEmpty(selectGroups)) {
                view.serverCall({
                    method: 'EditGroup',
                    disableFog: true,
                    params: [selectGroups[0]],
                    success: view.showEditGroupWin
                });
            }
        },

        groupGridDblClick: function() {
            this.editGroup();
        },

        copyGroup: function() {
            var view =this.parentView;
            var selectGroups = view.groupsGrid.getCheckedCodes();
            if (!Ext.isEmpty(selectGroups)) {
                view.serverCall({
                    method: 'CopyGroup',
                    disableFog: true,
                    params: [selectGroups[0]],
                    success: view.showEditGroupWin
                });
            }
        },

        showEditGroupWin: function(panel) {
            if (Ext.isEmpty(panel)) return;
            this.groupPanel = this.createTemplateControl(panel);
            this.addPanelItems(panel, this.groupPanel);
            this.editGroupWin = KS.showModal(this.groupPanel,
                {
                    title: this.groupPanel.isCopy ? "Копирование" : "Редактирование...",
                    autoHeight: false,
                    layout: "fit",
                    height: 600,
                    minHeight: 200,
                    width: 500,
                    minWidth: 300
                }, true);
            if (this.groupPanel.isCopy) {
                this.codeGroup.textField.selectText(this.codeGroup.getValue.length);
            }
        },

        saveEditGroup: function() {
            var view = this.parentView;
            if (view.validateGroup()) {
                var groupValues = view.collectGroupValues();
                var selectedLinkGroup = null;
                if (!view.groupPanel.isNew) {
                    var selectGroups = view.groupsGrid.getCheckedCodes();
                    if (!Ext.isEmpty(selectGroups)) {
                        selectedLinkGroup = selectGroups[0];
                    }
                }
                view.editGroupWin.close();
                view.serverCall({
                    method: 'SaveEditGroup',
                    waitMessage: "Сохранение...",
                    params: [groupValues, selectedLinkGroup, view.groupPanel.isCopy],
                    success: function() {
                        view.groupsGrid.reload();
                    }
                });
            }
        },

        validateGroup: function() {
            var codeValue = this.codeGroup.getValue();
            if (Ext.isEmpty(codeValue)) {
                KS.alert("Поле 'Код' обязательно для заполнения!");
                return false;
            } else if (this.groupPanel.blockedCodes.indexOf(codeValue) !== -1) {
                KS.alert("Группа правил с таким кодом уже существует!");
                return false;
            }

            var nameValue = this.nameGroup.getValue();
            if (Ext.isEmpty(nameValue)) {
                KS.alert("Поле 'Наименование' обязательно для заполнения!");
                return false;
            }
            return true;
        },

        collectGroupValues: function() {
            var groupValues = {
                CODE: this.codeGroup.getValue(),
                NAME: this.nameGroup.getValue(),
                BEGIN_DATE: this.beginDateGroup.getValue(),
                END_DATE: this.endDateGroup.getValue(),
                KS_PROC: this.ksProcGroup.getValue(),
                COMMENT: this.commentGroup.getValue()
            };

            if (this.copyRulesGroup) groupValues.COPY_RULES = this.copyRulesGroup.getValue();
            if (this.isSystemGroup) groupValues.IS_SYSTEM = this.isSystemGroup.getValue();
            if (this.isCheckGroup) groupValues.IS_CHECK = this.isCheckGroup.getValue();
            if (this.isAutofillGroup) groupValues.IS_AUTOFILL = this.isAutofillGroup.getValue();
            if (this.isConsolidGroup) groupValues.IS_CONSOLID = this.isConsolidGroup.getValue();

            if (this.optionCheckboxs) {
                var options = 0;
                this.optionCheckboxs.items.each(function(checkbox) {
                    if (checkbox.ctrlId.indexOf("optionCheckbox_") !== -1 &&
                        checkbox.getValue() === true) {
                        options += checkbox.mask;
                    }
                });
                groupValues.OPTIONS = options;
            }

            return groupValues;
        },

        exitGroup: function() {
            this.parentView.editGroupWin.close();
        },

        selectBudgetOrg: function() {
            this.parentView.openBudgetDictionary(false);
        },

        selectBudget: function() {
            this.parentView.openBudgetDictionary(true);
        },

        openBudgetDictionary: function(onlyBudget) {
            if (this.groupPanel) {
                var groupLink = this.groupPanel.groupLink;
                this.serverCall({
                    method: 'OpenBudgetDictionary',
                    params: [onlyBudget, groupLink],
                    disableFog: true
                });
            }
        },

        onServerSetBudgetCount: function(count) {
            if (this.groupPanel && this.BUDGET)
                this.BUDGET.setValue(count);
        },

        onServerSetBudgetOrgCount: function(count) {
            if (this.groupPanel && this.BUDGET_ORG)
                this.BUDGET_ORG.setValue(count);
        },

        deleteGroup: function() {
            var view = this.parentView;
            var checkedCodes = view.groupsGrid.getCheckedCodes();
            if (!Ext.isEmpty(checkedCodes)) {
                checkedCodes = checkedCodes.filter(function(code) { return code !== "0" && code !== 0 });
                if (checkedCodes.length > 0) {
                    var deleteMsg = "Будет удалено строк: " + checkedCodes.length + ". Продолжить?";
                    KS.confirm(deleteMsg, "Внимание", function (btn) {
                        if (btn === 'yes')
                            view.serverCall({
                                method: 'DeleteGroup',
                                params: [checkedCodes],
                                waitMessage: "Удаление...",
                                success: function() {
                                    view.groupsGrid.reload();
                                }
                            });
                    });
                }
            }
        },

        createNewRule: function() {
            var view = this.parentView;
            var selectedLinkGroup = null;
            var selectGroups = view.groupsGrid.getCheckedCodes();
            if (!Ext.isEmpty(selectGroups)) {
                selectedLinkGroup = selectGroups[0];
            }
            view.serverCall({
                method: 'CreateNewRule',
                params: [selectedLinkGroup],
                disableFog: true
            });
        },

        rulesGridDblClick: function(gridView) {
            var grid = gridView.grid;
            this.doEditRule(grid);
        },

        editRule: function() {
            var view = this.parentView;
            var activeGrid = view.rulesTabPanel.getActiveTab();
            if (view.isGrid(activeGrid)) {
                view.doEditRule(activeGrid);
            }
        },

        doEditRule: function(grid) {
            var checkedCodes = grid.getCheckedCodes();
            if (!Ext.isEmpty(checkedCodes)) {
                this.serverCall({
                    method: 'EditRule',
                    params: [checkedCodes[0]],
                    disableFog: true
                });
            }
        },

        copyRule: function() {
            var view = this.parentView;
            var activeGrid = view.rulesTabPanel.getActiveTab();
            if (view.isGrid(activeGrid)) {
                var checkedCodes = activeGrid.getCheckedCodes();
                if (!Ext.isEmpty(checkedCodes)) {
                    view.serverCall({
                        method: 'CopyRule',
                        params: [checkedCodes[0]],
                        disableFog: true
                    });
                }
            }
        },

        copyRulesInOther: function(){
            var view = this.parentView || this;
            var checkedGroupCodes = view.groupsGrid.getCheckedCodes();
            if (!Ext.isEmpty(checkedGroupCodes)) {
                checkedGroupCodes = checkedGroupCodes.filter(function (code) {
                    return code !== "0" && code !== 0
                });
                if (checkedGroupCodes.length > 0) {
                    var activeGrid = view.rulesTabPanel.getActiveTab();
                    if (view.isGrid(activeGrid)) {
                        var checkedRulesCodes = activeGrid.getCheckedCodes();
                        view.serverCall({
                            method: 'CopyRulesInOther',
                            params: [checkedRulesCodes],
                            success: function(copyGroupListGrid){
                                if (!Ext.isEmpty(copyGroupListGrid)){
                                    view.showCopyGroupListWin(copyGroupListGrid, checkedGroupCodes[0], checkedRulesCodes);
                                }
                            }
                        });
                    }
                }
            }
        },

        showCopyGroupListWin: function(copyGroupListGrid, checkedGroupCode, checkedRulesCodes){
            this.copyGroupListGrid = this.createTemplateControl(copyGroupListGrid);
            var view = this;
            view.copyGroupListWin = KS.showModal(view.copyGroupListGrid,
                {
                    title: 'Выберите значение...',
                    autoHeight: false,
                    layout: "fit",
                    height: Math.max(700, KS.rootViewport.getHeight() / 1.5),
                    minHeight: 200,
                    width: Math.max(1000, KS.rootViewport.getWidth() / 1.5),
                    minWidth: 300,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.replaceCopyRules(checkedGroupCode, checkedRulesCodes);
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.copyGroupListWin.close();
                            }
                        }]
                }, true);
        },

        hideClosedCopyGroups: function(){
            var view = this.parentView || this;
            view.serverCall({
                method: 'HideClosedCopyGroups',
                params: [this.pressed],
                success: function() {
                    this.copyGroupListGrid.reload();
                }
            });
        },

        replaceCopyRules: function(checkedGroupCode, checkedRulesCodes){
            var view = this;
            var selectedRows = view.copyGroupListGrid.getSelectedRows();
            if (!Ext.isEmpty(selectedRows)){
                // Иногда попадает "Все правила"
                var filteredSelectedRows = selectedRows.filter(function (row) {return KS.Grid.getAnyCase(row, "CODE") !== "-"});
                if (!Ext.isEmpty(filteredSelectedRows)) {
                    var copyLinkGroupCode = KS.Grid.getAnyCase(filteredSelectedRows[0], "LINK_GROUP");
                    view.serverCall({
                        method: 'ReplaceCopyRules',
                        params: [copyLinkGroupCode, checkedGroupCode, checkedRulesCodes],
                        success: function(){
                            view.copyGroupListWin.close();
                        }
                    });
                }
            }
        },

        deleteRule: function() {
            var view = this.parentView;
            var activeGrid = view.rulesTabPanel.getActiveTab();
            if (view.isGrid(activeGrid)) {
                var checkedCodes = activeGrid.getCheckedCodes();
                if (!Ext.isEmpty(checkedCodes)) {
                    KS.confirm("Будет удалено строк: " + checkedCodes.length +". Продолжить?", "Внимание",
                        function(btn) {
                            if (btn === 'yes') {
                                view.serverCall({
                                    method: 'DeleteRule',
                                    params: [checkedCodes],
                                    waitMessage: "Удаление...",
                                    success: function() {
                                        activeGrid.reload();
                                    }
                                });
                            }
                        });
                }
            }
        },

        exportRules: function() {
            var view = this.parentView || this;
            var groupLinks = view.groupsGrid.getCheckedCodes();
            if (!Ext.isEmpty(groupLinks)) {
                var activeGrid = view.rulesTabPanel.getActiveTab();
                var ruleLinks = [];
                if (view.isGrid(activeGrid)) {
                    ruleLinks = activeGrid.getCheckedCodes();
                }
                view.serverCall({
                    method: 'OpenExportRules',
                    params: [groupLinks, ruleLinks],
                    disableFog: true
                });
            }
        },

        importRules: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'ImportRules',
                disableFog: true
            });
        },

        transferToUser: function() {
            var view = this.parentView;
            view.transferRules(false);
        },

        transferToSystem: function() {
            var view = this.parentView;
            view.transferRules(true);
        },

        transferRules: function(isSystem) {
            var view = this;
            var groupLinks = view.groupsGrid.getCheckedCodes();
            if (!Ext.isEmpty(groupLinks)) {
                var activeGrid = view.rulesTabPanel.getActiveTab();
                if (view.isGrid(activeGrid)) {
                    var checkedCodes = activeGrid.getCheckedCodes();
                    if (!Ext.isEmpty(checkedCodes)) {
                        KS.confirm("Будет перемещено правил: " + checkedCodes.length + ". Продолжить?", "Внимание",
                            function(btn) {
                                if (btn === 'yes') {
                                    view.serverCall({
                                        method: 'DoTransferRules',
                                        params: [checkedCodes, isSystem, groupLinks[0]],
                                        waitMessage: 'Перемещение...',
                                        success: function() {
                                            view.systemRulesGrid.reload();
                                            view.userRulesGrid.reload();
                                        }
                                    });
                                }
                            });
                    }
                }
            }
        },

        copyToUser: function() {
            var view = this.parentView;
            view.copyRules(false);
        },

        copyToSystem: function() {
            var view = this.parentView;
            view.copyRules(true);
        },

        copyRules: function(isSystem) {
            var view = this;
            var groupLinks = view.groupsGrid.getCheckedCodes();
            if (!Ext.isEmpty(groupLinks)) {
                var activeGrid = view.rulesTabPanel.getActiveTab();
                if (view.isGrid(activeGrid)) {
                    var checkedCodes = activeGrid.getCheckedCodes();
                    if (!Ext.isEmpty(checkedCodes)) {
                        KS.confirm("Будет скопировано правил: " + checkedCodes.length + ". Продолжить?", "Внимание",
                            function(btn) {
                                if (btn === 'yes') {
                                    view.serverCall({
                                        method: 'CopyRules',
                                        params: [checkedCodes, isSystem, groupLinks[0]],
                                        waitMessage: 'Копирование...',
                                        success: function() {
                                            view.systemRulesGrid.reload();
                                            view.userRulesGrid.reload();
                                        }
                                    });
                                }
                            });
                    }
                }
            }
        },

        includeInGroup: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'GetSelectGroupGrid',
                disableFog: true,
                success: view.showSelectGroupGrid
            });
        },

        showSelectGroupGrid: function(grid) {
            if (Ext.isEmpty(grid)) return;
            this.selectGroupGrid = this.createTemplateControl(grid);
            var view = this;
            this.selectGroupWin = KS.showModal(this.selectGroupGrid,
                {
                    title: 'Выберите значение...',
                    autoHeight: false,
                    layout: "fit",
                    height: 500,
                    minHeight: 200,
                    width: 650,
                    minWidth: 300,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.doIncludeInGroup();
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.selectGroupWin.close();
                            }
                        }]
                },
                true);
        },

        doIncludeInGroup: function() {
            var view = this;
            var selectedGroups = this.selectGroupGrid.getCheckedCodes();
            var activeGrid = view.rulesTabPanel.getActiveTab();
            if (view.isGrid(activeGrid)) {
                var ruleLinks = activeGrid.getCheckedCodes();
                if (!Ext.isEmpty(ruleLinks) && !Ext.isEmpty(selectedGroups)) {
                    var groupLink = selectedGroups[0];
                    if (groupLink === 0 || groupLink === "0") return;
                    view.selectGroupWin.close();
                    view.serverCall({
                        method: 'IncludeInGroup',
                        params: [ruleLinks, groupLink],
                        success: function() {
                            view.reload();
                        }
                    });

                }
            }
        },

        excludeFromGroup: function() {
            var view = this.parentView;
            var groupLinks = view.groupsGrid.getCheckedCodes();
            if (Ext.isEmpty(groupLinks)) return;
            var groupLink = groupLinks[0];
            if (groupLink === 0 || groupLink === "0") return;
            var activeGrid = view.rulesTabPanel.getActiveTab();
            if (!view.isGrid(activeGrid)) return;
            var ruleLinks = activeGrid.getCheckedCodes();
            if (Ext.isEmpty(ruleLinks)) return;
            KS.confirm("Из группы будет исключено " + ruleLinks.length + " объектов. Продолжить?",
                "Внимание",
                function(btn) {
                    if (btn === 'yes') {
                        view.serverCall({
                            method: 'ExcludeFromGroup',
                            params: [ruleLinks, groupLink],
                            success: function() {
                                view.setActiveGroup(groupLink);
                            }
                        });
                    }
                });
        },

        dateChanged: function() {
            this.setActiveGroup();
        },

        addExisting: function() {
            var view = this.parentView;
            var groupLinks = view.groupsGrid.getCheckedCodes();
            if (Ext.isEmpty(groupLinks)) return;
            var groupLink = groupLinks[0];
            if (groupLink === 0 || groupLink === "0") return;
            view.serverCall({
                method: 'GetSelectRulesPanel',
                params: [groupLink],
                disableFog: true,
                success: function(panel) {
                    view.showSelectRulesPanel(panel, groupLink);
                }
            });
        },

        showSelectRulesPanel: function(panel, groupLink) {
            if (Ext.isEmpty(panel)) return;
            this.selectRulesPanel = this.createTemplateControl(panel);
            this.addPanelItems(panel, this.selectRulesPanel);
            var view = this;
            this.selectRulesWin = KS.showModal(this.selectRulesPanel,
                {
                    title: 'Выберите значение...',
                    autoHeight: false,
                    layout: "fit",
                    minHeight: 200,
                    height: Math.max(700, KS.rootViewport.getHeight() / 1.5),
                    minWidth: 300,
                    width: Math.max(1000, KS.rootViewport.getWidth() / 1.5),
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.doAddExisting(groupLink);
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.selectRulesWin.close();
                            }
                        }]
                },
                true);
        },

        doAddExisting: function(groupLink) {
            var view = this;
            var ruleLinks = view.existingRulesGrid.getCheckedCodes();
            if (Ext.isEmpty(ruleLinks)) {
                KS.alert("Выберите минимум одно правило");
                return;
            }
            view.selectRulesWin.disable();
            view.serverCall({
                method: 'AddExisting',
                params: [ruleLinks, groupLink],
                waitMessage: 'Добавление в группу...',
                success: function() {
                    view.selectRulesWin.enable();
                    view.selectRulesWin.close();
                    view.setActiveGroup(groupLink);
                },
                error: function() {
                    view.selectRulesWin.enable();
                }
            });
        },

        existingGroupsGridSelect: function() {
            var view = this;
            var groupLinks = view.existingGroupsGrid.getCheckedCodes();
            if (Ext.isEmpty(groupLinks)) return;
            var groupLink = groupLinks[0];
            view.serverCall({
                method: 'SetActiveExistingGroup',
                params: [groupLink],
                disableFog: true,
                success: function() {
                    view.existingRulesGrid.reload();
                }
            });
        },

        massiveReplace: function() {
            var view = this.parentView || this;
            var selectGroups = view.groupsGrid.getCheckedCodes();
            if (!Ext.isEmpty(selectGroups) && selectGroups[0].toString() !== "0") {
                view.serverCall({
                    method: 'MassiveReplace',
                    params: [selectGroups[0]],
                    disableFog: true
                });
            }
        },

        tryExecuteTask: function() {
            var code = this.tbarNode.code;
            var view = this.parentView;
            var gridId = this.gridId || "";
            view.serverCall({
                method: 'CheckSumsTryExecuteTask',
                params: [code, gridId]
            });
        },

        hideClosedGroups: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'HideClosedGroups',
                params: [this.pressed],
                disableFog: true,
                success: function() {
                    view.groupsGrid.reload();
                }
            });
        },

        massiveEdit: function() {
            var view = this.parentView;
            var editBtn = this;

            var selectGroups = view.groupsGrid.getCheckedCodes();
            if (Ext.isEmpty(selectGroups) || selectGroups[0].toString() === "0")
                return;

            var groupLink = selectGroups[0];

            KS.confirm("Перед редактированием рекомендуется сделать экспорт правил. Сделать экспорт?", this.tbarNode.code === "EXCELEDIT" ? "Массовое редактирование слагаемых" : "Массовое редактирование правил",
                function (btn) {
                    if (btn === 'yes') {
                        view.exportRules();
                    }
                    else if (btn === 'no') {
                        var code = editBtn.tbarNode.code;
                        view.serverCall({
                            method: 'MassiveEdit',
                            params: [code, groupLink],
                            disableFog: true
                        });
                    }
                }
            );
        }
    });
}(CheckSumsView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();