﻿CheckSumsEditorView = KS.extend(BaseSvodView, { });

// ============= COMMON =======================
(function (viewClass) {
    KS.apply(viewClass, {

        onTemplateRendered: function () {
            if (!Ext.isEmpty(this.data.identifier.CopyLink)) {
                this.touch();
            }
            this.addRulesProperties();
        },

        resetView: function () {
            this.gridPart0.reload();
            this.gridPart1.reload();
            this.gridPart2.reload();
            this.gridPart3.reload();
        },
        
        onSetSavedState: function(saved) {
            this.getToolbarItem(this.rootPanel, null, 'SAVE_RULE').setDisabled(saved);
        },

        getTbarClickHandler: function(tbarItem) {
            var sc = CheckSumsEditorView.superclass;
            switch (tbarItem.code) {
                case "":

                    break;
            }
            return sc.getTbarClickHandler.apply(this, arguments);
        },

        onValuesSelected: function(arg) {
            if (arg) {
                var isTerm = this.getIsTerm();
                var prefix = isTerm ? "term" : "condition";
                var field = null;
                switch (arg[0][0].CLOSE_CODE) {
                    case "LINK_ORGANIZATION": // "Организация"
                        field = this[prefix + "EditOrganization"];
                        break;
                        
                    case "LINK_DICTION_ROW":
                        if (this.openedDict === "termEditCode") {
                            field = this[prefix + "EditCode"]; // "Код строки"
                        } else {
                            field = this[prefix + "EditGroup"]; // "Группа"
                        }
                        this.openedDict = null;
                        break;
                        
                    case "LINK_GROUP": // "Форма"
                        field = this[prefix + "EditForm"];
                        field.textField.linkForm = arg[0][0]["LINK_FORM"];
                        break;
                }
                if (field != null) {
                    field.setValue(arg[0][0].CODE);
                }
                this.editorTouch();
            }
        },

        addRulesProperties: function() {
            this.serverCall({
                method: 'GetRulesPropertiesData',
                disableFog: true,
                success: this.fillRulesProperties
            });
        },

        fillRulesProperties: function(listOptions) {
            if (listOptions) {
                var view = this;
                view.rulesProperties.removeAll();
                if (!Ext.Object.isEmpty(listOptions)) {
                    var i = 0;
                    for (var prop in listOptions) {
                        if (listOptions.hasOwnProperty(prop)) {
                            var propertyGrid = view.getPropertyGridByOption(listOptions[prop], "rulePropGrid" + i++, prop);
                            propertyGrid.on("propertychange", view.touch, view);
                            view.rulesProperties.add(propertyGrid);
                        }
                    }
                }
            }
        },
        
        rootTabPanelTabChange: function(tabPanel, newCard) {
            if (newCard.ctrlId === "ruleTab") return;
            if (!newCard.opened) {
                switch(newCard.ctrlId) {
                    case "termsTab":
                        if (this.gridPart0.store.count() > 0) {
                            this.gridPart0.getSelectionModel().select(0);
                        } else if (this.data.identifier.RuleLink < 0 && Ext.isEmpty(this.data.identifier.CopyLink)) {
                            this.recreateEditRulePanel(true, true, null);
                        } else {
                            this.recreateEditRulePanel(true, true, null, true);
                        }
                        break;

                    case "conditionsTab":
                        if (this.gridPart0.store.count() > 0){
                            this.gridPart2.getSelectionModel().select(0);
                        } else if (this.data.identifier.RuleLink < 0
                            && Ext.isEmpty(this.data.identifier.CopyLink)) {
                            this.recreateEditRulePanel(false, true, null);
                        } else {
                            this.recreateEditRulePanel(false, true, null, true);
                        }
                        break;
                }
                newCard.opened = true;
            }
        },

        saveRule: function(){
            var view = this.parentView || this;
            var collectValues = view.collectRuleValues();
            view.serverCall({
                method: 'SaveRuleChanges',
                waitMessage: 'Сохранение ...',
                params: [collectValues],
                success: function (hasSaveErrors) {
                    if (hasSaveErrors === true) {
                        return;
                    }
                    view.discardChanges();
                    view.reload();
                }
            });
        },

        collectRuleValues: function() {
            var mainOptions = {
                ORDER : this.ruleNumber.getValue(),
                BEGIN_DATE : this.ruleBeginDate.getValue(),
                END_DATE : this.ruleEndDate.getValue()
            }
            var ruleProperty = {};
            Ext.each(this.rulesProperties.items.items, function(propertyGrid) {
                var sourcePropGrid = propertyGrid.source;
                if (!Ext.Object.isEmpty(sourcePropGrid)) {
                    for (var prop in sourcePropGrid) {
                        if (sourcePropGrid.hasOwnProperty(prop)) {
                            var propKey = prop.split("#")[1];
                            ruleProperty[propKey] = sourcePropGrid[prop];
                        }
                    }
                }
            });
            return {
                MAIN_OPTIONS : mainOptions,
                RULE_PROPERTY : ruleProperty
            };
        },

        findGridRecord: function(grid, value, colKey) {
            if (!KS.isString(colKey) || KS.isEmpty(colKey)) {
                colKey = grid.closeCode;
            }
            var foundRecs = [];
            grid.getStore().each(function(rec) {
                if (KS.Grid.getAnyCase(rec, colKey) == value) {
                    foundRecs.push(rec);
                }
            });
            return foundRecs[0] || null;
        },

        signComboChange: function(combo, newValues) {
            var isTerm = this.getIsTerm();
            this.serverCall({
                method: 'ChangeSignComboValue',
                disableFog: true,
                params: [isTerm, newValues],
                success: this.touch
            });
        },

        createNewRule: function() {
            var view = this.parentView;
            var closeCode = view.getActiveRowCloseCode();
            var gridId = this.gridPropertyName;
            if (Ext.isEmpty(closeCode)) {
                var isTerm = gridId === "gridPart0" || gridId === "gridPart1"; 
                var isLeftGrid = gridId === "gridPart0" || gridId === "gridPart2"; 
                view.recreateEditRulePanel(isTerm, isLeftGrid, closeCode);
            } else {
                var grid = view[gridId];
                if (grid) {
                    view.serverCall({
                        method: 'CreateNewRule',
                        disableFog: true,
                        params: [gridId],
                        success: function() {
                            view.gridIdForSelectAfterReload = gridId;
                            grid.reload();
                            view.touch();
                        }
                    });
                }
            }
        },

        copyRule: function() {
            var view = this.parentView;
            var closeCode = view.getActiveRowCloseCode();
            if (Ext.isEmpty(closeCode)) return;
            var gridId = this.gridPropertyName;
            var grid = view[gridId];
            if (grid) {
                view.serverCall({
                    method: 'CopyRule',
                    disableFog: true,
                    success: function(newRow) {
                        newRow["FORM_VERSION"] = Ext.util.Format.date(KS.parseAjaxDateTime(newRow["FORM_VERSION"]), "d.m.Y");
                        grid.addRecord(newRow);
                        view.touch();
                    }
                });
            }
        },

        deleteRule: function() {
            var view = this.parentView;
            var gridId = this.gridPropertyName;
            var grid = view[gridId];
            if (grid) {
                var checkedCodes = grid.getCheckedCodes();
                var checkedRows = grid.getCheckedRows();
                if (Ext.isEmpty(checkedCodes)) return;
                KS.confirm("Будет удалено строк: " + checkedCodes.length +". Продолжить?", "Внимание",
                    function(btn) {
                        if (btn === 'yes') {
                            view.serverCall({
                                method: 'DeleteRule',
                                params: [checkedCodes],
                                disableFog: true,
                                success: function() {
                                    view.deleteRuleCallBack(grid, checkedRows);
                                }
                            });
                        }
                    });
            }
        },

        deleteRuleCallBack: function(grid, checkedRows) {
            grid.getStore().remove(checkedRows);
            var gridId = grid.ctrlId;
            var isTerm = gridId === "gridPart0" || gridId === "gridPart1"; 
            var prefix = isTerm ? "term" : "condition";
            if (grid.getStore().count() === 0) {
                this[prefix + "EditorPanel"].setDisabled(true);
            } else {
                var orderRow = 1;
                grid.store.each(function(item) {
                    item.data["ORDER_ROW"] = orderRow++;
                });
                grid.reload();
                grid.getSelectionModel().select(0);
            }
            this.touch();
        }
    });
}(CheckSumsEditorView.prototype));

// ============= EDITOR =======================
(function (viewClass) {
    KS.apply(viewClass, {
        editorSaveEdit: function(btn) {
            var view =  (btn && btn.isButton) ? this.parentView : this;
            var isTerm = this.isTerm;
            var isLeftGrid = this.isLeftGrid;
            view.doEditorSaveEdit(isTerm, isLeftGrid);
        },

        doEditorSaveEdit: function(isTerm, isLeftGrid, closeCode, collectEditorValues) {
            var view = this;
            if (Ext.isEmpty(isTerm))
                isTerm = this.getIsTerm();
            if (Ext.isEmpty(isLeftGrid))
                isLeftGrid = this.getIsLeft(isTerm);
            if (Ext.isEmpty(closeCode))
                closeCode = this.getActiveRowCloseCode(isTerm);
            var prefix = isTerm ? "term" : "condition";
            if (!this.validateBeforeSave(prefix)) return;

            var grid = this.getActiveGrid(isTerm, isLeftGrid);
            var activeRow = !Ext.isEmpty(closeCode) ? this.findGridRecord(grid, closeCode) : null;
            if (Ext.isEmpty(collectEditorValues)) {
                collectEditorValues = this.collectEditorValues(prefix);
            }

            view.serverCall({
                method: 'SaveEditorChanges',
                params: [collectEditorValues, closeCode],
                disableFog: true,
                success: function(newValues) {
                    view.saveEditorCallBack(newValues, activeRow, grid);
                }
            });
        },

        validateBeforeSave: function(prefix) {
            var tableFieldValue = this[prefix + "EditTable"].getValue();
            var type = this[prefix + "EditRowType"].getValue();
            if ((type === 0 || type === 3) && (Ext.isEmpty(tableFieldValue) || tableFieldValue === "0" || tableFieldValue === 0)) {
                 KS.alert("Поле 'Таблица' обязательно для заполнения!");
                 return false;
             }
             return true;
        },

        saveEditorCallBack: function(newRows, activeRow, grid) {
            var view = this;
            var rowsCount = grid.store.data.length;
            if (!Ext.isEmpty(newRows)) {
                Ext.each(newRows, function (newRowData) {
                    if (!Ext.isEmpty(newRowData)) {
                        if (!Ext.isEmpty(activeRow)) {
                            activeRow.set("DESCRIPTION", newRowData["DESCRIPTION"]);
                            activeRow.set("FORM_VERSION", Ext.util.Format.date(KS.parseAjaxDateTime(newRowData["FORM_VERSION"]), "d.m.Y"));
                            activeRow.set("link_rule_row", newRowData["LINK_RULE_ROW"]);
                            activeRow.set("link_rule", newRowData["LINK_RULE"]);
                            activeRow.set("SIGN", newRowData["SIGN"]);
                            activeRow = null;
                        } else {
                            newRowData["FORM_VERSION"] = Ext.util.Format.date(KS.parseAjaxDateTime(newRowData["FORM_VERSION"]), "d.m.Y");
                            newRowData["ORDER_ROW"] = ++rowsCount;
                            var newRow = grid.addRecord(newRowData);
                            grid.getSelectionModel().select([newRow]);
                        }
                        view.touch();
                        view.editorDiscardChanges();
                    }
                    if (!Ext.isEmpty(view.nextEditorRowToSelect)) {
                        view.editorDiscardChanges();
                        var oldGrid = view.nextEditorRowToSelect.store.grid;
                        oldGrid.getSelectionModel().select([view.nextEditorRowToSelect]);
                        view.nextEditorRowToSelect = null;
                    }
                });
            }
        },

        collectEditorValues: function(prefix) {
            var baseEditorParams = {
                CODE_BUDGET : this[prefix + 'EditBudgetKind'].getValue(),
                CODE_BUDGET_TYPE : this[prefix + 'EditBudgetType'].getValue(),
                PERIOD_TYPE : this[prefix + 'EditPeriodType'].getValue(),
                IS_PERIOD_YEAR_ABS : this[prefix + 'EditYearAbs'].getValue(),
                PERIOD_YEAR : this[prefix + 'EditYear'].getValue(),
                IS_PERIOD_NUMBER_ABS : this[prefix + 'EditNumberAbs'].getValue(),
                PERIOD_NUMBER : this[prefix + 'EditNumber'].getValue(),
                CODE_ORGANIZATION: this[prefix + 'EditOrganization'].getValue(),
                CODE_SIDEWALL: this[prefix + 'EditCode'].getValue(),
                CODE_GROUP: this[prefix + 'EditGroup'].getValue(),
                GRAPH_VALUE: this[prefix + 'EditGraph'].getValue()
            }
            baseEditorParams["EDITOR_TYPE"] = this[prefix + "EditRowType"].getValue();
            var sourcePropGrid = this[prefix + "PropGrid"].source;
            if (!Ext.Object.isEmpty(sourcePropGrid)) {
                for (var prop in sourcePropGrid) {
                    if (sourcePropGrid.hasOwnProperty(prop)) {
                        var propKey = prop.split("#")[1];
                        baseEditorParams[propKey] = sourcePropGrid[prop];
                    }
                }
            }
            return baseEditorParams;
        },

        editorTouch: function() {
            var isTerm = this.getIsTerm();
            var prefix = isTerm ? "term" : "condition";
            this.hasEditorChanges = true;
            this.getToolbarItem(this[prefix + "EditorPanel"], null, 'SAVE_EDIT_' + prefix.toUpperCase()).setDisabled(false);
            var label = this.getToolbarItem(this[prefix + "EditorPanel"], null, prefix.toUpperCase() + "_LABEL");
            if (label) {
                label.setStyle("color", "red");
            }
        },

        editorDiscardChanges: function() {
            var isTerm = this.getIsTerm();
            var prefix = isTerm ? "term" : "condition";
            this.hasEditorChanges = false;
            this.getToolbarItem(this[prefix + "EditorPanel"], null, 'SAVE_EDIT_' + prefix.toUpperCase()).setDisabled(true);
            var label = this.getToolbarItem(this[prefix + "EditorPanel"], null, prefix.toUpperCase() + "_LABEL");
            if (label) {
                label.setStyle("color", "black");
            }
        },

        getIsTerm: function() {
            var activeTabId = this.rootTabPanel.getActiveTab().ctrlId;
            if (activeTabId === "ruleTab") return null;

            return activeTabId.indexOf("term") !== -1;
        },

        getIsLeft: function(isTerm) {
            //Если в правой таблице нет выделенных строк, значит активна левая таблица
            var rightGrid = isTerm ? this.gridPart1 : this.gridPart3;
            return Ext.isEmpty(rightGrid.getSelectedRows());
        },

        recreateEditRulePanel: function(isTerm, isLeftGrid, closeCode, needDisabled) {
            var view = this;
            view.serverCall({
                method: 'GetEditRulePanel',
                params: [isTerm, isLeftGrid, closeCode],
                disableFog: true,
                success: function(ruleEditor) {
                    view.createNewEditorPanel(ruleEditor, isTerm, isLeftGrid, needDisabled);
                }
            });
        },

        createNewEditorPanel: function(ruleEditor, isTerm, isLeftGrid, needDisabled) {
            var editorId = ruleEditor.itemId;
            var oldEditor = this[editorId];

            var prefix = isTerm ? "term" : "condition";
            var groupFieldStatus = {};
            if (this[prefix + "EditTable"]) {
                this[prefix + "EditTable"].store.each(function (item) {
                    groupFieldStatus[item.data.code] = item.data.isGroupDisable;
                });
            }

            this.rootTabPanel.getActiveTab().remove(oldEditor);
            this[editorId] = this.createTemplateControl(ruleEditor);
            this.addPanelItems(ruleEditor, this[editorId]);
            this.rootTabPanel.getActiveTab().add(this[editorId]);

            if (!Ext.isEmpty(needDisabled)) {
                this[editorId].setDisabled(needDisabled);
            }

            this.configureEditGroupField(groupFieldStatus, prefix);
            this.configureLabelText(isTerm, isLeftGrid);
            this.configureEditorByType();
        },

        configureEditGroupField: function(groupFieldStatus, prefix) {
            var view = this;
            if (groupFieldStatus != null && Object.keys(groupFieldStatus).length === view[prefix + "EditTable"].store.data.items.length) {
                view.setTablesGroupStatus(groupFieldStatus, prefix);
                view.disableGroupField(prefix);
            }
            else {
                var tablesCodes = [];
                view[prefix + "EditTable"].store.each(function(item) {
                    tablesCodes.push(item.data.code);
                });
                view.serverCall({
                    method: 'GetGroupFieldStatus',
                    params: [tablesCodes],
                    disableFog: true,
                    success: function(groupsList) {
                        view.setTablesGroupStatus(groupsList, prefix);
                        view.disableGroupField(prefix);
                    }
                });
            }
        },

        setTablesGroupStatus: function(groupsList, prefix) {
            this[prefix + "EditTable"].store.each(function(item) {
                item.data.isGroupDisable = groupsList[item.data.code];
            });
        },

        disableGroupField: function(prefix) {
            var view = this;
            var isDisabled = true;
            if (view[prefix + "EditTable"].value != null) {
                var item = Ext.Array.findBy(view[prefix + "EditTable"].store.data.items, function (item) {
                    return item.data.code === view[prefix + "EditTable"].value;
                });
                if (item)
                    isDisabled = item.data.isGroupDisable
            }
            view[prefix + "EditGroup"].setDisabled(isDisabled);
        },

        configureEditorByType: function() {
            var isTerm = this.getIsTerm();
            var prefix = isTerm ? "term" : "condition";
            var type = this[prefix + "EditRowType"].getValue();

            this.setElementsVisibleByType(type, prefix);
            this.getEditorPropertiesData(type, isTerm);
        },

        setElementsVisibleByType: function(type, prefix) {
            var panelsVisible = true;
            switch (type) {
                case 0:
                    panelsVisible = true;
                    this[prefix + "EditCode"].setVisible(true);
                    break;
                case 1:
                case 2:
                    panelsVisible = false;
                    break;
                case 3:
                    panelsVisible = true;
                    this[prefix + "EditCode"].setVisible(false);
                    break;
            }
            this[prefix + "EditOptionsPanel"].setVisible(panelsVisible);
            this[prefix + "EditPeriodPanel"].setVisible(panelsVisible);
        },

        getEditorPropertiesData: function(type, isTerm) {
            var view = this;
            this.serverCall({
                method: 'GetEditorPropertiesData',
                params: [type],
                disableFog: true,
                success: function(listOptions) {
                    view.fillEditProperty(listOptions, isTerm);
                }
            });
        },
        
        fillEditProperty: function(listOptions, isTerm) {
            if (listOptions) {
                var view = this;
                var prefix = isTerm ? "term" : "condition";
                var editProperty = this[prefix + "EditProperty"];
                editProperty.removeAll();
                if (!Ext.Object.isEmpty(listOptions)) {
                    for (var prop in listOptions) {
                        if (listOptions.hasOwnProperty(prop)) {
                            var propGridId = prefix + "PropGrid";
                            this[propGridId] = view.getPropertyGridByOption(listOptions[prop], propGridId, prop);
                            this[propGridId].on("propertychange", view.editorTouch, view);
                            editProperty.add(this[propGridId]);
                        }
                    }
                }
            }
        },

        editRowTypeChange: function(combo, newValue) {
            this.changeActiveRowCell("TYPE_ROW", newValue, this.configureEditorByType);
            this.editorTouch();
        },

        editSignChange: function(combo, newValue) {
            this.changeActiveRowCell("SIGN", newValue);
        },

        changeActiveRowCell: function(dataIndex, newValue, callback) {
            this.serverCall({
                method: 'ChangeActiveRowCell',
                params: [dataIndex, newValue],
                disableFog: true,
                success: Ext.isEmpty(callback) ? 
                            this.editorTouch : 
                            callback
            });
        },

        setNewEditTableComboData: function(formLink, prefix){
            this.serverCall({
                method: 'GetNewEditTableComboData',
                params: [formLink],
                disableFog: true,
                success: function(newData){
                    if (!Ext.isEmpty(newData)){
                        this[prefix + "EditTable"].setStore(newData);
                        if (this[prefix + "EditTable"].getStore().getTotalCount() > 0)
                            this[prefix + "EditTable"].setValue(0);
                    } else {
                        this[prefix + "EditTable"].getStore().removeAll();
                        this[prefix + "EditTable"].setValue("");
                    }
                }
            });
        },
        
        changeEditTableField: function(combo, newValue) {
            // Устанавливаем значение на сервере
            this.serverCall({
                method: 'ChangeEditTableField',
                params: [newValue],
                disableFog: true,
                success: function(){
                    this.afterChangeEditTableField(newValue);
                }
            });            
        },

        afterChangeEditTableField: function(newValue){
            var isTerm = this.getIsTerm();
            var prefix = isTerm ? "term" : "condition";

            // Видимость элементов на клиента
            var disable = Ext.isEmpty(newValue) || newValue === "0" || newValue === 0;
            this.disableGroupField(prefix);
            this[prefix + "EditCode"].setDisabled(disable);
            this[prefix + "EditGraph"].setDisabled(disable);

            // Сбрасываем значение в "Графа"
            this.doSetNewGraphValue([], prefix);

            // Сбрасываем значение в "Код строки"
            this[prefix + "EditCode"].setValue("");

            this.editorTouch();
        },
        
        configureLabelText: function(isTerm, isLeftGrid) {
            var prefix = isTerm ? "term" : "condition";
            var label = this.getToolbarItem(this[prefix + "EditorPanel"], null, prefix.toUpperCase() + "_LABEL");
            if (label) {
                var saveBtn = this.getToolbarItem(this[prefix + "EditorPanel"], null, 'SAVE_EDIT_' + prefix.toUpperCase());
                var gridHasRows = this.getActiveGrid(isTerm, isLeftGrid).store.count() !== 0;
                var action = gridHasRows ? "Редактирование" : "Добавление";
//                    (this.data.identifier.RuleLink < 0 && Ext.isEmpty(this.data.identifier.CopyLink)) ?
//                        "Добавление" : 
//                        "Редактирование";
                if (isLeftGrid) {
                    label.setText(action + " левой части " + (isTerm ? "слагаемого" : "условия"));
                } else {
                    label.setText(action + " правой части " + (isTerm ? "слагаемого" : "условия"));
                }
                label.setStyle("color", saveBtn.disabled ? "black" : "red");
            }
        },

        beforeEditCodeRender: function(textField) {
            if (textField && textField.ownerCt)
                textField.ownerCt.hideMode = 'visibility';
        },
        
        changeDictionField: function(comp, newValue){
            var view = this.parentView || this;
            var fieldCode = comp.code;
            var relationID = view.getFieldRelationId(fieldCode);
            var isTerm = this.getIsTerm();
            var prefix = isTerm ? "term" : "condition";
            if (Ext.isEmpty(newValue)){ // Если пришли сюда после нажатия кнопки clear
               view.serverCall({
                    method: 'ClearDictionField',
                    params: [relationID],
                    disableFog: true,
                    success: function(){
                        view.afterClearDictionField(prefix, relationID);
                    }
                });
            } else {
                if (fieldCode.indexOf("EditCode") !== -1) { // "Код строки"
                    
                } else if (fieldCode.indexOf("EditGroup") !== -1) { // "Группа"
                    
                } else if (fieldCode.indexOf("EditForm") !== -1) { // "Форма"
                    var linkForm = comp.linkForm;
                    this.setNewEditTableComboData(linkForm, prefix); 
                } else if (fieldCode.indexOf("EditOrganization") !== -1) { // "Организация"
                    
                }                    
            }
            
            view.editorTouch();
        },

        afterClearDictionField: function(prefix, relationID){
            switch (relationID) {
                case "DICTIONARY_FORMS":
                    this[prefix + "EditForm"].linkForm = null;
                    this.setNewEditTableComboData(null, prefix);
                    break;
            }
        },
        
        selectFromDiction: function() {
            var view = this.parentView;
            var fieldCode = this.code;
            var relationID = view.getFieldRelationId(fieldCode);
            view.openedDict = fieldCode;
            view.serverCall({
                method: 'SelectFromDiction',
                params: [relationID],
                disableFog: true
            });
        },

        getFieldRelationId: function(fieldCode) {
            var relationId = "";
            if (fieldCode.indexOf("EditCode") !== -1) { // "Код строки"
                relationId = "DICTIONARY_TABLE_ROWS";
            } else if (fieldCode.indexOf("EditGroup") !== -1) { // "Группа"
                relationId = "DICTIONARY_TABLE_GROUPS";
            } else if (fieldCode.indexOf("EditForm") !== -1) { // "Форма"
                relationId = "DICTIONARY_FORMS";
            } else if (fieldCode.indexOf("EditOrganization") !== -1) { // "Организация"
                relationId = "DICTIONARY_UCHR";
            }
            return relationId;
        },
        
        selectGraph: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'GetGraphGrid',
                disableFog: true,
                success: view.showGraphGrid
            });
        },

        showGraphGrid: function(grid) {
            if (Ext.isEmpty(grid)) return;
            this.graphGrid = this.createTemplateControl(grid);
            var view = this;
            this.graphGridWin = KS.showModal(this.graphGrid,
                {
                    title: 'Выбор графы',
                    autoHeight: false,
                    layout: "fit",
                    height: 500,
                    minHeight: 200,
                    width: 600,
                    minWidth: 300,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.setNewGraphValue();
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.graphGridWin.close();
                            }
                        }]
                },
                true);
        },

        graphGridCellClick: function(gridView, td, cellIndex, record, tr, rowIndex, e) {
            var col = e.position.column;
            if (col.xtype === "checkcolumn") {
                var order = 1;
                this.graphGrid.store.each(function(row) {
                    if (KS.Grid.getAnyCase(row, "CHECKED")) {
                        row.set("ORDER", order);
                        order++;
                    } else {
                        row.set("ORDER", 0);
                    }
                });
            }
        },

        setNewGraphValue: function() {
            var isTerm = this.getIsTerm();
            var prefix = isTerm ? "term" : "condition";
            var checkedRows = this.graphGrid.getCheckedRows();
            var selectedData = [];
            Ext.each(checkedRows, function(record) {
                selectedData.push(record.data);
            });
            this.doSetNewGraphValue(selectedData, prefix);
        },

        doSetNewGraphValue: function(selectedData, prefix) {
            var view = this;
            var graphText = "";

            selectedData.sort(function(a, b){
                if ( parseInt(a["COLUMN_ORDER"]) < parseInt(b["COLUMN_ORDER"]) )
                    return -1;
                if ( parseInt(a["COLUMN_ORDER"]) > parseInt(b["COLUMN_ORDER"]) )
                    return 1;
                return 0;
            });
            
            Ext.each(selectedData, function(columnData){
                var order = columnData["COLUMN_ORDER"];
                graphText += order + "; "; 
            });
            
            view[prefix + "EditGraph"].setValue(graphText.trim());
            
            view.editorTouch();
            if (view.graphGridWin &&
                !view.graphGridWin.destroyed)
                view.graphGridWin.close();
        },

        changeEditPeriodType: function(){
            this.configureByPeriod();
        },

        configureByPeriod: function() {
            var isTerm = this.getIsTerm();
            var prefix = isTerm ? "term" : "condition";

            this[prefix + "EditYearAbs"].setValue(this[prefix + "EditYearAbs"].startValue);
            this[prefix + "EditYear"].setValue(this[prefix + "EditYear"].items.items[0].startValue);
            this[prefix + "EditNumberAbs"].setValue(this[prefix + "EditNumberAbs"].startValue);
            this[prefix + "EditNumber"].setValue(this[prefix + "EditNumber"].items.items[0].startValue);

            this.editorTouch();
        },

        changeEditYearAbs: function(combo, newValue){
            var isTerm = this.getIsTerm();
            var prefix = isTerm ? "term" : "condition";
            var yearComp = this[prefix + "EditYear"];
            var yearValue = yearComp.getValue();
            switch (newValue)
                {
                case "+":
                case "-":
                    if (yearValue > 10)
                    {
                        yearComp.setValue(0);
                    }
                    break;

                case "=":
                    yearComp.setValue((new Date()).getFullYear());
                    break;
            }
            this.changePeriodComp(combo, newValue);
        },

        changePeriodComp: function() {
            this.editorTouch();
        }
    });
}(CheckSumsEditorView.prototype));
    
// ============= GRID'S =======================
(function (viewClass) {
    KS.apply(viewClass, {

        getActiveRowCloseCode: function(isTerm, isLeftGrid) {
            if (Ext.isEmpty(isTerm)) {
                isTerm = this.getIsTerm();
            }
            if (Ext.isEmpty(isLeftGrid)) {
                isLeftGrid = this.getIsLeft(isTerm);
            }
            var closeCode = "";
            var grid = this.getActiveGrid(isTerm, isLeftGrid);
            if (!Ext.isEmpty(grid.getCheckedCodes())) {
                closeCode = grid.getCheckedCodes()[0];
            }
            return closeCode;
        },

        getActiveGrid: function(isTerm, isLeftGrid) {
            if (Ext.isEmpty(isTerm)) {
                isTerm = this.getIsTerm();
            }
            if (Ext.isEmpty(isLeftGrid)) {
                isLeftGrid = this.getIsLeft(isTerm);
            }
            if (isTerm && isLeftGrid) {
                return this.gridPart0;
            } else if (isTerm && !isLeftGrid) {
                return this.gridPart1;
            } else if (!isTerm && isLeftGrid) {
                return this.gridPart2;
            } else if (!isTerm && !isLeftGrid) {
                return this.gridPart3;
            }
            return null;
        },
        
        getPairGridById: function(gridId) {
            switch(gridId) {
            case "gridPart0":
                return this.gridPart1;

            case "gridPart1":
                return this.gridPart0;

            case "gridPart2":
                return this.gridPart3;

            case "gridPart3":
                return this.gridPart2;
            }
            return null;
        },

        gridBeforeRowDeselect: function(selModel, record) {
            if (this.hasEditorChanges && record.store.contains(record)) {
                var view = this;
                var isTerm = this.getIsTerm();
                var gridId = selModel.store.grid.ctrlId;
                var isLeftGrid = gridId === "gridPart0" || gridId === "gridPart2";
                var prefix = isTerm ? "term" : "condition";
                var collectEditorValues = this.collectEditorValues(prefix);
                var label = this.getToolbarItem(this[prefix + "EditorPanel"], null, prefix.toUpperCase() + "_LABEL");
                KS.confirm("Сохранить изменения?", label.text, function(btn) {
                    if (btn === 'yes') {
                        var closeCode = KS.Grid.getAnyCase(record, "link_rule_row");
                        view.doEditorSaveEdit(isTerm, isLeftGrid, closeCode, collectEditorValues);
                    } else {
                        view.editorDiscardChanges();
                        var oldGrid = view.nextEditorRowToSelect.store.grid;
                        oldGrid.getSelectionModel().select([view.nextEditorRowToSelect]);
                        view.nextEditorRowToSelect = null;
                    }
                });
            }
            return true;
        },

        gridBeforeRowSelect: function(selModel, record) {
            if (this.hasEditorChanges) {
                this.nextEditorRowToSelect = record;
                return false;
            }
            return true;
        },

        gridRowSelected: function(selModel, record) {
            var grid = selModel.store.grid;
            this.changeActiveRow(grid, record);
        },

        changeActiveRow: function(grid, record) {
            var gridId = grid.ctrlId;
            var pairGrid = this.getPairGridById(gridId);
            if (pairGrid) {
                pairGrid.getSelectionModel().deselectAll();
            }

            var isTerm = gridId === "gridPart0" || gridId === "gridPart1";
            var isLeftGrid = gridId === "gridPart0" || gridId === "gridPart2";
            var closeCode = KS.Grid.getAnyCase(record, "LINK_RULE_ROW");
            this.recreateEditRulePanel(isTerm, isLeftGrid, closeCode);
        },

        part0ToPart1: function() {
            var view = this.parentView;
            view.transferGridItem(view.gridPart0, view.gridPart1);
        },

        part1ToPart0: function() {
            var view = this.parentView;
            view.transferGridItem(view.gridPart1, view.gridPart0);
        },

        part2ToPart3: function() {
            var view = this.parentView;
            view.transferGridItem(view.gridPart2, view.gridPart3);
        },

        part3ToPart2: function() {
            var view = this.parentView;
            view.transferGridItem(view.gridPart3, view.gridPart2);
        },

        transferGridItem: function(source, destination) {
            var checkedCodes = source.getCheckedCodes();
            if (Ext.isEmpty(checkedCodes)) return;
            var closeCode = checkedCodes[0];
            var destinationId = destination.ctrlId;
            var view = this;
            view.serverCall({
                method: 'TransferGridItem',
                params: [closeCode, destinationId],
                disableFog: true,
                success: function() {
                    source.reload();
                    destination.reload();
                    view.touch();
                }
            });
        },

        moveRow: function() {
            var view = this.parentView;
            var grid = view[this.gridPropertyName];
            if (grid) {
                var operCode = this.tbarNode.code;
                var checkedRows = grid.getCheckedRows();
                if (Ext.isEmpty(checkedRows)) return;
                var rowLink = KS.Grid.getAnyCase(checkedRows[0], "LINK_RULE_ROW");
                var rowType = KS.Grid.getAnyCase(checkedRows[0], "TYPE_ROW");
                view.serverCall({
                    method: 'MoveRow',
                    params: [operCode, rowLink, rowType],
                    disableFog: true,
                    success: function() {
                        grid.reload();
                        view.touch();
                    }
                });
            }
        },

        afterGridDataLoad: function() {
            if (!Ext.isEmpty(this.gridIdForSelectAfterReload)) {
                var grid = this[this.gridIdForSelectAfterReload];
                if (grid) {
                    var selModel = grid.getSelectionModel();
                    var lastRecordIdx = grid.getStore().count();
                    selModel.select(lastRecordIdx - 1);
                }
                this.gridIdForSelectAfterReload = null;
            }
        }
    });
}(CheckSumsEditorView.prototype));

function checkSumsEditorDateRenderer(value) {
    if (!Ext.isEmpty(value) && (new Date(value) != "Invalid Date")) {
        value = new Date(value);
    }
    if (Ext.isString(value) && !Ext.isEmpty(value)) {
        var parsed = KS.parseAjaxDateTime(value);
        if (parsed) {
            value = Ext.util.Format.date(parsed, 'd.m.Y');
        } else if (value.length > 10) {
            value = value.substring(0, 10);
        }
    } else {
        value = Ext.util.Format.date(value, 'd.m.Y');
    }
    return (value == '06.06.2079') ? '' : value;
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();