﻿BudgetHierarchyView2 = KS.extend(BaseSvodView, {});

// ============= COMMON =======================
(function (viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function () {
            this.discardChanges();
            this.childViews = [];
            if (!KS.isEmpty(this.deferredAddChildViews)) {
                for (var idx = 0; idx < this.deferredAddChildViews.length; idx++) {
                    this.addChildView(this.deferredAddChildViews[idx]);
                }
                delete this.deferredAddChildViews;
            }
        },
        
        addChildView: function (panel) {
            this.editTreeNodeTabPanel.unmask ();

            if (!this.editTreeNodeTabPanel) {
                // Parent view is not ready, render child later
                if (!this.deferredAddChildViews) {
                    this.deferredAddChildViews = [];
                }
                this.deferredAddChildViews.push(panel);
                return true;
            }

            var activeTab = this.editTreeNodeTabPanel.getActiveTab();
            panel.tbar = false;
            panel.header = false;
            if (activeTab) {
                activeTab.removeAll();
                activeTab.add(panel);
                var childView = eval(panel.classInstance);
                if (childView) {
                    this.childViews.push(childView);
                    childView.parentView = this;
                }
                KS.updateLayout(activeTab);
                return true;
            }

            return false;
        },

        getTbarClickHandler: function(tbarItem) {
            if (!tbarItem) return null;
            var sc = BudgetHierarchyView2.superclass;
            if (!this.checkHandler(tbarItem.pluginNameWeb)) {
                switch (tbarItem.code) {
                    case 'ADDITIONAL':
                        return null;
                }
            }
            return sc.getTbarClickHandler.call(this, tbarItem);
        },

        onSetSavedState: function(saved) {
            var saveBtn = this.getToolbarItem(this.rootPanel, null, 'SAVE');
            if (saveBtn)
                saveBtn.setDisabled(saved);
        },

        saveChanges: function() {
            var view = this.parentView || this;
            view.treeValidateCallback = view.saveChangesWithoutValidate;
            view.doSaveChanges(true);
        },

        saveChangesWithoutValidate: function() {
            this.doSaveChanges(false);
        },

        doSaveChanges: function(needValidate) {
            this.serverCall({
                method: 'ValidateAndSaveChanges',
                params: [needValidate],
                success: function (hasSaveErrors) {
                    if (hasSaveErrors === true) {
                        if (needValidate === false)
                            KS.alert('Документ не сохранен!');
                        return;
                    }
                    this.discardChanges();
                    this.reload();
                }
            });
        },

        resetView: function () {
            this.versionsGrid.reload();

            this.budgetTreeNodeIdToScroll = null;
        },
        
        confirmTreeValidateWarning: function(historyLink) {
            var view = this;
            KS.confirm("Продолжить?" , "Внимание", function(btn) {
                if (btn === 'yes') {
                    if (Ext.isFunction(view.treeValidateCallback))
                        view.treeValidateCallback(); 
                        //activateVersionWithoutValidate() - если проверка дерева в выборе версии дерева
                        //saveChangesWithoutValidate() - если проверка при сохранении
                } else {
                    view.onServerSelectVersionRow(historyLink);
                }
            });
        },

        onServerShowWarningProtocol: function(protocol, historyLink){
            var view = this;
            view.warningProtocolWin = KS.Ext.showAdjustableWindow(protocol, {
                title : 'Протокол',
                listeners: {
                    close: function() {
                        view.confirmTreeValidateWarning(historyLink);
                    }
                },
                buttons: ['->', {
                    text: 'ОК',
                    cls: 'dim-button',
                    handler: function () {
                        view.warningProtocolWin.close();
                    }
                }]
            });
        }
    });
}(BudgetHierarchyView2.prototype));

// ============= VERSIONS GRID =======================
(function (viewClass) {
    KS.apply(viewClass, {

        afterVersionsGridLoad: function() {
            this.selectRowInVersionsGrid();
        },

        selectRowInVersionsGrid: function() {
            var row;
            var needActivateVersion = false;
            if (this.versionLink) 
                row = this.versionsGrid.findRecord(this.versionLink, "link_history");
                        
            if (!row)
            {
                row = this.versionsGrid.getStore().getData().last();
                if (!row){
                    this.versionLink = null;
                    this.date = null;
                }
            }

            if (row) {
                this.versionLink = KS.Grid.getAnyCase(row, "link_history");
                this.date = KS.Grid.getAnyCase(row, "DATE");
                this.versionsGrid.getSelectionModel().select([row]);
                this.scrollToSelectedRow(this.versionsGrid);
                needActivateVersion = true;
            }

            if (needActivateVersion)
                this.activateVersionWithoutValidate();
        },

        createVersion: function() {
            var view = this.parentView || this;
            view.getEditVersionPanel("NEW", null);
        },

        editVersion: function() {
            var view = this.parentView || this;
            var checkedRows = view.versionsGrid.getCheckedRows();
            if (!Ext.isEmpty(checkedRows)) {
                var activeRow = checkedRows[0];
                var versionLink = KS.Grid.getAnyCase(activeRow, "LINK_HISTORY");
                view.getEditVersionPanel("EDIT", versionLink);
            }
        },
        
        copyVersion: function() {
            var view = this.parentView || this;
            var checkedRows = view.versionsGrid.getCheckedRows();
            if (!Ext.isEmpty(checkedRows)) {
                var activeRow = checkedRows[0];
                var versionLink = KS.Grid.getAnyCase(activeRow, "LINK_HISTORY");
                view.getEditVersionPanel("COPY", versionLink);
            }
        },

        getEditVersionPanel: function(operation, versionLink) {
            var view = this;
            view.serverCall({
                method: 'GetEditVersionPanel',
                params: [operation, versionLink],
                success: function(settings) {
                    view.showEditVersionPanel(settings, operation, versionLink);
                }
            });
        },

        showEditVersionPanel: function(settings, operation, versionLink) {
            this.propertyGrid = this.getPropertyGridByOption(settings, "propertyGrid", "Общие");
            var view = this;
            this.editVersionWin = KS.showModal(this.propertyGrid, {
                title: 'Свойства',
                autoHeight: false,    
                layout: 'anchor',
                height: 400, 
                minHeight: 200,
                width: 600,
                minWidth: 300,
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.doEditVersion(operation, versionLink);
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.editVersionWin.close();
                        }
                    }]
            }, true);
        },

        doEditVersion: function(operation, versionLink) {       
            var view = this;
            var newValues = view.propertyGrid.source;
            view.editVersionWin.close();
            view.serverCall({
                method: 'EditVersion',
                params: [newValues, operation, versionLink],
                waitMessage: operation === "NEW" ? 'Создание ...' : 'Редактрование ...',
                success: function(editRowLink) {
                    if (!Ext.isEmpty(editRowLink)) {
                        view.touch();
                        view.versionLink = editRowLink;
                        view.versionsGrid.reload();
                        if (view.isAutoBuildCreate){
                            view.isAutoBuildCreate = false;
                            view.sync243();
                            return;
                        }
                        view.selectRowInVersionsGrid();
                        if (operation === "NEW")
                            view.addOrganization();
                    }
                }
            });
        },

        deleteVersions: function() {
            var view = this.parentView || this;
            var checkedRows = view.versionsGrid.getCheckedRows();
            if (!Ext.isEmpty(checkedRows)) {
                var links = [];
                Ext.each(checkedRows, function(row) {
                    links.push(KS.Grid.getAnyCase(row, "link_history"));
                }); 
                KS.confirm("Будет удалено строк: " + checkedRows.length + ". Продолжить?", "Подтвердите удаление", function (btn) {
                    if (btn === 'yes')
                        view.serverCall({
                            method: 'DeleteVersions',
                            params: [links],
                            success: function() {
                                view.touch();
                                view.versionLink = null;
                                view.versionsGrid.reload();
                            }
                        });
                });
            }
        },
        
        exportVersions: function() {
            var view = this.parentView || this;
            var checkedRows = view.versionsGrid.getCheckedRows();
            if (!Ext.isEmpty(checkedRows)) {
                var links = [];
                Ext.each(checkedRows, function(row) {
                    links.push(KS.Grid.getAnyCase(row, "link_history"));
                });
                view.serverCall({
                    method: 'ExportVersions',
                    params: [links]
                });
            }
        },

        rowDblClickVersions: function(gridView, record) {
            this.versionLink = KS.Grid.getAnyCase(record, "link_history");
            this.date = KS.Grid.getAnyCase(record, "DATE");
            this.treeValidateCallback = this.activateVersionWithoutValidate;
            this.activateVersion(true);
        },

        onServerSelectVersionRow: function(historyLink) {
            this.versionLink = historyLink;
            this.selectRowInVersionsGrid();
        },
        
        activateVersionWithoutValidate: function() {
            this.activateVersion(false);
        },

        activateVersion: function(needValidate) {
            this.serverCall({
                method: 'ActivateVersion',
                params: [needValidate, this.versionLink, this.date],
                success: function(result) {
                    if (result)
                        this.reloadBudgetTree();
                }
            });
        }
    });
}(BudgetHierarchyView2.prototype));

// ============= BUDGET TREE =======================
(function (viewClass) {
    KS.apply(viewClass, {
        reloadBudgetTree: function() {
            this.budgetTree.getRootNode().removeAll(true);
            this.budgetTree.fullReload();
        },
        
        removeNotRightNode: function(node){
            var view = this;
            if (node && !Ext.isEmpty(node.childNodes)){
                for (var i = 0; i < node.childNodes.length; i++){
                    var childNode = node.childNodes[i];
                    view.removeNotRightNode(childNode);
                    if (node.childNodes.indexOf(childNode) == -1) // удалили узел
                        i--;
                }
            }
            if (node && node.id != 'root' && 
                Ext.isEmpty(node.childNodes) && 
                !view.isNodeEditable(node)){
                node.remove();
            }
        },

        isNodeEditable: function(node){
            return node && node.data && node.data.cls !== "disabled-budget-node"; // пока редактируемость смотрим по cls
        },

        budgetTreeSelect: function(selModel, selected) {    
            var node = selected[0] || selected;
            var editable = this.isNodeEditable(node);
            var isAdministrator = editable && KS.isAdmin;
            this.setTreeToolbarButtonState("ADD", editable);
            this.setTreeToolbarButtonState("ADD_CHILD", editable);
            this.setTreeToolbarButtonState("EXCEL", isAdministrator);
            this.setTreeToolbarButtonState("EDIT_BUDGET", editable);
            this.setTreeToolbarButtonState("DELETE_BUDGET", editable);
            this.setTreeToolbarButtonState("OPEN_ORGANIZATION", editable);
            this.setTreeToolbarButtonState("ADDITIONAL", editable, "EXCLUDE");
            this.setTreeToolbarButtonState("ADDITIONAL", editable, "SET_BEFORE");
            this.setTreeToolbarButtonState("ADDITIONAL", editable, "SET_TO");
            this.setTreeToolbarButtonState("ADDITIONAL", editable, "SET_AFTER");
            this.setTreeToolbarButtonState("ADDITIONAL", editable, "TEST_EXPORT_TO_BARS");
        },

        setTreeToolbarButtonState: function (code, visible, childCompCode) {
            var button = this.getToolbarItem(this.budgetTreePanel, null, code);
            if (!Ext.isEmpty(button)) {
                if (!Ext.isEmpty(childCompCode)) {  //Если нужно взять компонент из подменю
                    button = button.getMenu().items.findBy(function(item) {
                        return (item && item.tbarNode && (item.tbarNode.code === childCompCode));
                    });
                    if (Ext.isEmpty(button)) return;
                }
                button.setVisible(visible);
            }
        },

        budgetTreeLoad: function() { 
            var tree = this.budgetTree;
            if (tree.hasRights){
                var rootNode = tree.getRootNode();
                if (rootNode){
                    this.removeNotRightNode(rootNode);
                }
            }
            if (this.budgetTreeNodeIdToScroll) {
                tree.setSelected(this.budgetTreeNodeIdToScroll);
                this.scrollToActiveNode(tree);
                this.budgetTreeNodeIdToScroll = null;
            }
            
            var nodesCount = tree.getStore().count();
            if (this.versionLink < 0 && nodesCount > 0){
                var view = this;
                KS.confirm("Сохранить новую версию (рекомендуется для дальнейшего корректного изменения)?", "Внимание", function(btn) {
                    if (btn === 'yes') {
                        view.saveChanges();
                    }
                });
            }
        },

        beforeNodeDrop: function(nodeHtml, data, overModel, dropPosition, dropHandlers) {
            var view = this;
            var nodes = data.records; // перемещаемый узел
            var checkedNodes = this.budgetTree.getChecked(); // отмеченные узлы
            Ext.each(checkedNodes, function(checkedNode){
                if (nodes.indexOf(checkedNode) == -1)
                    nodes.push(checkedNode);
            });
            nodes = nodes.filter(function (node){ return view.isNodeEditable(node)})
            if (Ext.isEmpty(nodes) || !view.isNodeEditable(overModel)) return false;

            var message = "";
            var code = "";
            switch(dropPosition)
            {
                case "append":
                    message = nodes.length > 1
                        ? "Подчинить отмеченные узлу '" + overModel.data.text + "'?" 
                        : "Подчинить узел '" + nodes[0].data.text + "' узлу '" + overModel.data.text + "'?";
                    code = "SET_TO";
                    break;

                case "before":
                    message = nodes.length > 1
                        ? "Переместить отмеченные перед узлом '" + overModel.data.text + "'?" 
                        : "Переместить узел '" + nodes[0].data.text + "' перед узлом '" + overModel.data.text + "'?";
                    code = "SET_BEFORE";
                    break;

                case "after":
                    message = nodes.length > 1
                        ? "Переместить отмеченные после узла '" + overModel.data.text + "'?" 
                        : "Переместить узел '" + nodes[0].data.text + "' после узла '" + overModel.data.text + "'?";
                    code = "SET_AFTER";
                    break;
            }

            var checkedLinks = [];
            Ext.each(nodes,
                function(checkedNode) {
                    checkedLinks.push(checkedNode.id);
                });

            dropHandlers.wait = true;

            KS.confirm(message, "Внимание", function(btn) {
                if (btn === 'yes') {
                    // Если переставляем сразу больше 1 узла, то обновляем дерево
                    view.doReplaceNode(checkedLinks, code, overModel, checkedLinks.length > 1);
                    if (checkedLinks.length > 1)
                        dropHandlers.cancelDrop();
                    else
                        dropHandlers.processDrop();
                } 
                else {
                    dropHandlers.cancelDrop();
                }
            });
        },

        editTreeNodeTabHandler: function(tabPanel, newTab) { //beforetabchange editTreeNodeTabPanel
            if (newTab.tabLoaded)
                return;

            switch (newTab.ctrlId) {
            case "organizationPanel":
                this.loadEditTreeNodeView(true);
                break;

            case "budgetPanel":
                this.loadEditTreeNodeView(false);
                break;
            }
            newTab.tabLoaded = true;
        },

        loadEditTreeNodeView: function(loadOrganization) {
            var view = this;
            view.editTreeNodeTabPanel.mask("Справочник загружается..."); // разблокируется в addChildView
            view.serverCall({
                method: 'LoadEditTreeNodeView',
                params: [loadOrganization, view.versionLink, view.date, view.editTreeNodePanel.mode]
            });
        },

        getOptionsGrid: function() { // beforerender editTreeNodeTabPanel
            var view = this;
            view.serverCall({
                method: 'GetOptionsGrid',
                disableFog: true,
                params: [view.editTreeNodePanel.nodeLink || ""],
                success: function(settings) {
                    view.nodeOptionsGrid = view.getPropertyGridByOption(settings, "nodeOptionsGrid", "Прочее");
                    view.optionsPanel.removeAll();
                    view.optionsPanel.add(view.nodeOptionsGrid);
                }
            });
        },

        getBudgetTreeCheckedNodes: function() {
            var checkedNodes = this.budgetTree.getChecked();
            if (Ext.isEmpty(checkedNodes)) {
                var selNode = this.budgetTree.getSelNode();
                if (selNode)
                    checkedNodes.push(selNode);
            }
            return checkedNodes;
        },

        addOrganization: function() {
            var view = this.parentView || this;
            var selNode = view.budgetTree.getSelNode();
            if (!view.isNodeEditable(selNode)) return;
            var selfLink = selNode &&
                selNode.parentNode &&
                !selNode.parentNode.data.root &&
                selNode.parentNode.id.split('_')[0];

            if (selNode &&
                selNode.parentNode.data.root &&
                !Ext.isEmpty(view.budgetTree.getRootNode().childNodes)) {
                KS.alert("Во главе иерархии должна стоять единственная организация!", "Внимание");
                return;
            }

            selfLink = Ext.isNumeric(selfLink) ? selfLink : null;
            var mode = selfLink
                ? selNode &&
                selNode.parentNode &&
                (selNode.parentNode.data.root ||
                    selNode.parentNode.parentNode && selNode.parentNode.parentNode.data.root)
                ? 2
                : 0
                : 4;
            view.getEditTreeNodePanel(selfLink, mode);
        },

        addChildOrganization: function() {
            var view = this.parentView || this;
            var selNode = view.budgetTree.getSelNode();
            if (selNode) {
                if (!view.isNodeEditable(selNode)) return;
                var selfLink = selNode.id.split('_')[0];
                var mode = (selNode.parentNode && selNode.parentNode.data.root) ? 2 : 0;
                view.getEditTreeNodePanel(selfLink, mode);
            }
        },

        editOrganization: function() {
            var view = this.parentView || this;
            var selNode = view.budgetTree.getSelNode();
            if (selNode) {
                if (!view.isNodeEditable(selNode)) return;
                var mode = selNode.parentNode && selNode.parentNode.data.root
                    ? 4
                    : selNode.parentNode && selNode.parentNode.parentNode && selNode.parentNode.parentNode.data.root
                    ? 3
                    : 1;
                view.getEditTreeNodePanel(null, mode, selNode.id);
            }
        },

        getEditTreeNodePanel: function(selfLink, mode, nodeLink) {
            var view = this;
            this.serverCall({
                method: 'GetEditTreeNodePanel',
                params: [mode, nodeLink || ""],
                success: function(editTreeNodePanel) {
                    view.showEditTreeNodePanel(editTreeNodePanel, selfLink, mode, nodeLink);
                }
            });
        },

        showEditTreeNodePanel: function(editTreeNodePanel, selfLink, mode, nodeLink) {
            var view = this;
            this.editTreeNodePanel = KS.create(editTreeNodePanel);
            this.addPanelItems(editTreeNodePanel, this.editTreeNodePanel);
            this.editTreeNodeWin = KS.showModal(this.editTreeNodePanel,
                {
                    title: 'Дерево организаций и бюджетов',
                    autoHeight: false,
                    layout: 'fit',
                    height: Math.max(500, KS.rootViewport.getHeight() / 1.5),
                    minHeight: 200,
                    width: Math.max(600, KS.rootViewport.getWidth() / 1.5),
                    minWidth: 300,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.editTreeNode(selfLink, mode, nodeLink);
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.editTreeNodeWin.close();
                            }
                        }]
                },
                true);

            this.editTreeNodeWin.on("close",
                function() {
                    if (!Ext.isEmpty(this.childViews)) {
                        Ext.each(this.childViews,
                            function(childView) {
                                childView.close();
                            });
                    }
                    this.childViews = [];
                },
                this);
        },

        editTreeNode: function(selfLink, mode, nodeLink) {
            var budgetsRowsData = this.getCheckedRowsData("BudgetsDictionaryView");
            var organizationsRowsData = this.getCheckedRowsData("OrganizationsDictionaryView");

            var newOptions = this.nodeOptionsGrid.source;

            this.serverCall({
                method: 'EditTreeNode',
                params: [selfLink, mode, nodeLink || "", budgetsRowsData, organizationsRowsData, newOptions],
                success: this.editTreeNodeCallback
            });
        },

        editTreeNodeCallback: function(activeNodeId) {
            if (!Ext.isEmpty(activeNodeId))
                this.budgetTreeNodeIdToScroll = activeNodeId;

            this.editTreeNodeWin.close();
            this.reloadBudgetTree();
            this.touch();
        },

        getCheckedRowsData: function(classInstance) {
            var rowsData = [];
            var childView = this.getChildView(classInstance);
            if (childView && childView.mainGrid) {
                var rows = childView.mainGrid.getCheckedRows();
                Ext.each(rows,
                    function(row) {
                        rowsData.push(row.data);
                    });
            }
            return rowsData;
        },

        getChildView: function(classInstance) {
            var childView = null;
            Ext.each(this.childViews,
                function(view) {
                    if (view.containerPanel.classInstance.indexOf(classInstance) !== -1)
                        childView = view;
                });
            return childView;
        },

        deleteOrganizations: function() {
            var view = this.parentView || this;
            var checkedNodes = view.getBudgetTreeCheckedNodes();
            if (!Ext.isEmpty(checkedNodes)) {
                KS.confirm("Будет удалено объектов: " + checkedNodes.length + ". Продолжить?",
                    "Внимание",
                    function(btn) {
                        if (btn === 'yes') {
                            view.deleteNodesFromHierarchy(checkedNodes);
                        }
                    });
            }
        },

        excludeOrganization: function() {
            var view = this.parentView || this;
            var checkedNodes = view.getBudgetTreeCheckedNodes();
            if (!Ext.isEmpty(checkedNodes)) {
                KS.confirm("Исключить выбранные узлы (" + checkedNodes.length + ") из иерархии?",
                    "Внимание",
                    function(btn) {
                        if (btn === 'yes') {
                            view.deleteNodesFromHierarchy(checkedNodes);
                        }
                    });
            }
        },

        deleteNodesFromHierarchy: function(checkedNodes) {
            var view = this;
            var links = [];
            Ext.each(checkedNodes,
                function(node) {
                    if (view.isNodeEditable(node))
                        links.push(node.id);
                });
            view.serverCall({
                method: 'DeleteNodesFromHierarchy',
                params: [links],
                success: function(result) {
                    if (result) {
                        view.budgetTree.getStore().remove(checkedNodes);
                        view.touch();
                    }
                }
            });
        },

        exportTreeNodes: function() {
            var view = this.parentView || this;
            var checkedNodes = view.getBudgetTreeCheckedNodes();
            if (Ext.isEmpty(checkedNodes)) {
                KS.alert("Не выбран ни один узел дерева организаций и бюджетов", "Внимание");
                return;
            }

            var checkedLinks = [];
            Ext.each(checkedNodes,
                function(node) {
                    checkedLinks.push(node.id);
                });

            view.serverCall({
                method: 'ExportTreeNodes',
                params: [checkedLinks]
            });
        },

        openUsersList: function() {
            var view = this.parentView || this;
            var code = this.tbarNode.code;
            var checkedNodes = view.getBudgetTreeCheckedNodes();
            if (!Ext.isEmpty(checkedNodes)) {
                var checkedLinks = [];
                Ext.each(checkedNodes,
                    function(node) {
                        checkedLinks.push(node.id);
                    });

                view.serverCall({
                    method: 'OnOpenUsersList',
                    params: [checkedLinks, code]
                });

            }
        },

        autoBuild: function(){
            var view = this.parentView || this;
            KS.confirm("Создать новую точку дерева?", "Внимание",
                function (btn) {
                    if (btn === 'yes') {
                        view.getEditVersionPanel("NEW", null);
                        view.isAutoBuildCreate = true;
                    } else if (btn === 'no'){
                        view.sync243();
                    }
                });
        },
        
        sync243: function(){
            var view = this;
            view.serverCall({
                method: 'Sync243',
                params: [view.versionLink],
                success: function(){
                    view.selectRowInVersionsGrid();
                }
            });            
        },

        replaceNode: function() {
            var view = this.parentView || this;
            var code = this.tbarNode.code;
            var checkedNodes = view.getBudgetTreeCheckedNodes();
            if (!Ext.isEmpty(checkedNodes)) {
                var checkedLinks = [];
                Ext.each(checkedNodes,
                    function(node) {
                        if (view.isNodeEditable(node))
                            checkedLinks.push(node.id);
                    });
                if (Ext.isEmpty(checkedLinks)) return;
                view.serverCall({
                    method: 'GetReplaceNodeTree',
                    success: function(replaceNodeTree) {
                        view.showReplaceNodeTree(replaceNodeTree, checkedLinks, code);
                    }
                });
            }
        },

        showReplaceNodeTree: function(replaceNodeTree, checkedLinks, code) {
            var view = this;
            replaceNodeTree.parentView = this;
            this.replaceNodeTree = KS.create(replaceNodeTree);
            this.replaceNodeWin = KS.showModal(this.replaceNodeTree,
                {
                    title: 'Выберите значение...',
                    autoHeight: false,
                    layout: 'fit',
                    height: Math.max(500, KS.rootViewport.getHeight() / 1.5),
                    minHeight: 200,
                    width: Math.max(600, KS.rootViewport.getWidth() / 2),
                    minWidth: 300,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                var selNode = view.replaceNodeTree.getSelNode();
                                view.doReplaceNode(checkedLinks, code, selNode, true);
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.closeReplaceNodeWin();
                            }
                        }]
                },
                true);
        },

        // checkedLinks - id переставляемых узлов
        // code - выполняемая операция
        // finalNode - узел, к которому перемещаем
        // neeedReloadTree - необходимо перезагрузить дерево
        doReplaceNode: function(checkedLinks, code, finalNode, neeedReloadTree) {
            var view = this;
            if (finalNode) {
                var finalNodeId = finalNode.id;
                
                if (!view.isNodeEditable(finalNode) ||          // нет прав на узел
                    checkedLinks.indexOf(finalNodeId) !== -1) { // циклическая ссылка
                    view.closeReplaceNodeWin();
                    return;
                }
                
                var parentNodeId = null;
                
                switch(code) {
                    case "SET_BEFORE":
                    case "SET_AFTER":
                        if (finalNode.parentNode && !finalNode.parentNode.data.root) {
                            parentNodeId = finalNode.parentNode.id;
                        }
                        break;

                    case "SET_TO":
                        parentNodeId = finalNode.id;
                        break;
                }

                if (finalNodeId != null && parentNodeId != null) {
                    view.closeReplaceNodeWin();
                    view.serverCall({
                        method: 'ReplaceNode',
                        disableFog: true,
                        params: [checkedLinks, finalNodeId, code, parentNodeId],
                        success: function(activeNodeId) {
                            if (neeedReloadTree) {
                                if (!Ext.isEmpty(activeNodeId))
                                    view.budgetTreeNodeIdToScroll = activeNodeId;
                                view.reloadBudgetTree();
                            }
                            view.touch();
                        }
                    });
                }
            }
        },
        
        closeReplaceNodeWin: function(){
            if (this.replaceNodeWin)
                this.replaceNodeWin.close();
        },

        setGroupOrgProperty: function() {
            var view = this.parentView || this;
            var checkedNodes = view.getBudgetTreeCheckedNodes();
            if (!Ext.isEmpty(checkedNodes)) {
                view.serverCall({
                    method: 'GetGroupOrgPropertyPanel',
                    success: view.showGroupOrgPropertyPanel
                });
            }
        },

        showGroupOrgPropertyPanel: function(settings){
            if (Ext.isEmpty(settings)) return;
            this.groupSetGrid = this.getPropertyGridByOption(settings, "groupSetGrid", "Организация");
            this.groupSetGrid.on("propertychange", this.groupPropertyChange, this);
            var view = this;
            this.groupSetPanelWin = KS.showModal(this.groupSetGrid,
                {
                    title: 'Свойства',
                    autoHeight: false,
                    scrollable: true,
                    layout: "anchor",
                    height: Math.min(600, KS.rootViewport.getHeight() / 1.5),
                    minHeight: 200,
                    width: 600,
                    minWidth: 300,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.doGroupSet();
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.groupSetPanelWin.close();
                            }
                        }]
                },
                true);
        },

        doGroupSet: function(){
            var view = this;
            var checkedNodes = view.getBudgetTreeCheckedNodes();
            view.groupSetPanelWin.close();
            if (!Ext.isEmpty(checkedNodes)) {
                var checkedLinks = [];
                Ext.each(checkedNodes,
                    function(node) {
                        checkedLinks.push(node.id);
                    });
                view.serverCall({
                    method: 'DoGroupSet',
                    params: [checkedLinks],
                    waitMessages: 'Установка свойств...',
                    success: function (activeNodeId) {
                        if (activeNodeId)
                            view.doGroupSetCallback(activeNodeId);
                    }
                });
            }
        },

        doGroupSetCallback: function(activeNodeId) {
            if (!Ext.isEmpty(activeNodeId))
                this.budgetTreeNodeIdToScroll = activeNodeId;
            this.reloadBudgetTree();
        },

        groupPropertyChange: function(source, recordId, value){
            var code = recordId.split("#")[1];
            var view = this;
            view.serverCall({
                method: 'SetGroupPropValue',
                disableFog: true,
                params: [code, value],
                success: function(newValue) {
                    if (newValue != null) {
                        view.groupSetGrid.setProperty(recordId, newValue);
                    }
                }
            });
        },

        propertyGridFieldSelectorSelect: function(selectProp, propGrid, record){
            var view = this;
            var propId = record.id;
            view.propertySelectorGrid = view.createTemplateControl(selectProp.SelectorGrid);
            if (view.propertySelectorGrid) {
                view.propertySelectorGrid.propId = propId;
                view.propertySelectorWin = KS.showModal(view.propertySelectorGrid, {
                    title: 'Выберите значение...',
                    autoHeight: false,
                    resizable: true,
                    autoScroll: true,
                    maximizable: true,
                    height: Math.max(400, KS.rootViewport.getHeight() / 1.5),
                    minHeight: 300,
                    width: Math.max(600, KS.rootViewport.getWidth() / 2.5),
                    minWidth: 400,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.selectFromSelectorGrid();
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.propertySelectorWin.close();
                            }
                        }]
                }, true);
            }
        },
        
        selectFromSelectorGrid: function(){
            var checkedRows = this.propertySelectorGrid.getCheckedRows();
            if (Ext.isEmpty(checkedRows)) return;
            var nameField = ""; // Поле из которого берём значение для отображения на клиенте
            var selectorGridId = this.propertySelectorGrid.ctrlId;
            switch (selectorGridId) {
                case "orgTypesGrid":
                case "organizationsGrid":
                    nameField = "NAME";
                    break;
                case "reportTypesGrid":
                    nameField = "COL1";
                    break;
            }

            if (Ext.isEmpty(nameField)) return;
            var names = [];
            var selectedValues = [];
            Ext.each(checkedRows, function(row) {
                names.push(KS.Grid.getAnyCase(row, nameField));
                selectedValues.push(row.data);
            })

            var view = this;
            var propId = view.propertySelectorGrid.propId;
            var code = propId.split("#")[1] || "";
            view.propertySelectorGrid.mask("Пожалуйста, подождите...");
            view.serverCall({
                method: 'FieldSelectorChange',
                params: [code, selectedValues],
                success: function() {
                    view.groupSetGrid.setProperty(propId, names.join(','));
                    view.propertySelectorGrid.unmask()
                    view.propertySelectorWin.close();
                }
            });
        },

        selectorGridDblClick: function(){
            this.selectFromSelectorGrid();
        },

        openOrganization: function() {
            var view = this.parentView || this;
            var selNode = view.budgetTree.getSelNode();
            if (selNode) {
                if (!view.isNodeEditable(selNode)) return;
                var selNodeId = selNode.id;
                view.serverCall({
                    method: 'CheckBeforeOpenOrg',
                    params: [selNodeId],
                    disableFog: true,
                    success: function(orgName) {
                        view.doOpenOrganization(selNodeId, orgName);
                    }
                });
            }
        },

        doOpenOrganization: function(selNodeId, orgName) {
            if (!Ext.isEmpty(orgName)) {
                var view = this;
                KS.confirm("Открыть организацию " + orgName + "?", "Внимание", 
                    function (btn) {
                        if (btn === 'yes') {
                            view.serverCall({
                                method: 'DoOpenOrganization',
                                params: [selNodeId]
                            });
                        }
                });
            }
        },

        onServerUpdateTreeInfo: function(treeInfo){
            var infoField = this.getToolbarItem(this.budgetTree, null, 'budgetTreeInfoField');
            if (infoField && !Ext.isEmpty(treeInfo)){
                infoField.setHidden(false);
                infoField.setHtml(treeInfo);
            } else {
                infoField.setHidden(true);
                infoField.setHtml("");
            }
        }
    });
}(BudgetHierarchyView2.prototype));

if (typeof (Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();