﻿// ============= VIEW =======================
BaseSvodView = KS.extend(KS.Ext.ClientView, {
    constructor: function(viewId) {
        BaseSvodView.superclass.constructor.call(this, viewId);
    }
});

// ============= COMMON =======================
(function(viewClass) {
    KS.apply(viewClass, {
        helpTopic: null,
        printGridPropertyName: 'grid',

        resolveViewId: function (html) {
            if (html && this.viewID) {
                return html.replace(/<<<ViewID>>>/g, this.viewID);
            } else {
                return html;
            }
        },

        openUrl: function () {
            KS.openUrl.apply(this, arguments);
        },

        showHtmlProtocolInContainer: function(htmlProtocol) {
            if (htmlProtocol) {
                try {
                    this.containerPanel.removeAll();
                } catch (e) {
                }
                if (Ext.isArray(htmlProtocol)) {
                    var combined = '';
                    Ext.each(htmlProtocol, function(protocol) {
                        combined += protocol;
                    });
                    htmlProtocol = combined;
                }
                this.containerPanel.add({
                    layout: 'fit',
                    autoScroll: true,
                    html: htmlProtocol
                });
                this.updateContainer();
            }
        },

        onServerShowProtocolTable: function(grid, title){
            var view = this;
            view.protocolGrid = view.createTemplateControl(grid);
            if (view.protocolGrid) {
                view.protocolGridWin = KS.showModal(view.protocolGrid, {
                    title: title,
                    autoHeight: false,
                    resizable: true,
                    autoScroll: true,
                    maximizable: true,
                    height: Math.max(400, KS.rootViewport.getHeight() / 1.5),
                    minHeight: 300,
                    width: Math.max(600, KS.rootViewport.getWidth() / 2.5),
                    minWidth: 400,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.protocolGridWin.close();
                            }
                        }]
                }, true);
            }
        },

        exportToExcel: function() {
            var view = this.parentView;
            if (!view) return;
            var grid = view[this.gridPropertyName || ''] || view.findOwnerGrid(this),
                gridId = null,
                filters = null,
                sort = null,
                dir = null,
                addidional = {};
            if (grid) {
                gridId = grid.itemId;
                filters = KS.isString(grid.filters) ? grid.filters : '';
                if (grid.getFilter) {
                    // // make ext3 - formatted
                    // var fstr = grid.getFilter();
                    // if (!KS.isEmpty(fstr)) {
                    //     var arr = KS.safeDecode(fstr);
                    //     for (var idx = 0; idx < arr.length; idx++) {
                    //         var entry = arr[idx];
                    //         filters += entry.Name + "#" + entry.Value + ";";
                    //     }
                    // }
                    filters = grid.getFilter();
                }
                var store = grid.store,
                    ss = store.getSortState ? store.getSortState() : null,
                    sorters = store.getSorters ? store.getSorters() : null;
                if (ss) {
                    sort = ss.field;
                    dir = ss.direction;
                }
                if (sorters && sorters.length > 0) {
                    sorters.each(function (sorter) {
                        sort = sorter.getId();
                        dir = sorter.getDirection();
                    });
                }
                if (Ext.isFunction(grid.getExcelAdditionals))
                    addidional = grid.getExcelAdditionals();
                else if (Ext.isFunction(view.getGridExcelAdditionals))
                    addidional = view.getGridExcelAdditionals(grid);
                var columns = '';
                grid.eachColumnCfg(function (c) {
                    if (!c.hidden && c.dataIndex) columns += (c.dataIndex + ',');
                });
                addidional.columns = columns;
            }
            view.serverCall({
                method: 'ExportToExcel',
                waitMessage: 'Формирование документа Excel ...',
                params: [gridId || '', filters || '', sort || '', dir || '', addidional],
                success: view.openUrl
            });
        },

        saveProfile: function(profile, silent) {
            this.serverCall({
                method: 'SaveProfile',
                disableFog: true,
                params: [profile || null],
                success: function() {
                    if (silent === true)
                        return;
                    KS.msg('Профиль ' + (Ext.isEmpty(profile) ? 'удален' : 'сохранен'), 'Сообщение');
                }
            });
        },

        prepareComboRows: function (comboData) {
            var data = [],
                value = comboData.value;
            Ext.each(comboData.rows, function(dict) {
                    var dataValue = dict[comboData.valueField],
                        displayValue = dict[comboData.displayField];
                    if (displayValue == value) value = dataValue;
                    if (Ext.isEmpty(displayValue)) displayValue = /*cfg.editable ? */'' /*: '-'*/;
                    var tempData = [dataValue, displayValue];
                    if (comboData.additionalDisplayValue)
                        tempData.push(dict[comboData.additionalDisplayValue]);
                    data.push(tempData);
            });
            return {
                data: data,
                value: value
            };
        },

        buildDictionaryCombo: function (comboData, cfg) {
            var store,
                comboCfg = {
                valueField: comboData.valueField,
                displayField: comboData.displayField,
                comboData: comboData,
                cfg: cfg,
                parentView: this,
                typeAhead: false,
                width: 150,
                editable: cfg.editable,
                anchor: cfg.anchor,
                emptyText: cfg.emptyText,
                readOnly: cfg.readOnly,
                listWidth: cfg.listWidth,
                matchFieldWidth: Ext.isEmpty(cfg.listWidth),
                tpl: '<tpl for="."><div class=' + ('"x-boundlist-item"') + 
                    '>{' + comboData.displayField + ':defaultValue("&nbsp;")}' +
                    (comboData.additionalDisplayValue ? " {" + comboData.additionalDisplayValue + "}" : "") + '</div></tpl>',
                style: { overflow: 'hidden' },
                listeners: { 'select': this.comboDataSelectedHandler }
            };
            if (comboData.serverSearch) {
                // remote
                var url = 'PlatformHandler.axd?getctrldata=combo&id=' + comboData.link + '&s=' + comboData.dataSrc,
                    fields = [comboData.valueField, comboData.displayField];
                comboCfg.mode = 'remote';
                if (comboData.dataSrc === 'DADATA') {
                    comboCfg.emptyText = 'Введите название в свободной форме, адрес, ИНН или ОГРН';
                    comboCfg.minChars = 1;
                    comboCfg.tpl = '<tpl for="."><div class=' + ('"x-boundlist-item"') + '>' +
                        '<h3>{NAME}</h3><span>{INN:defaultValue("&nbsp;")} &nbsp;&nbsp; </span>{ADDR:defaultValue("&nbsp;")}' +
                        '</div></tpl>';
                    url += '&t=' + comboData.authToken;
                    fields.push('INN');
                    fields.push('ADDR');
                    fields.push('OGRN');
                }
                
                store = new Ext.data.Store({ 
                    model: new Ext.data.Model({
                        fields: fields,
                        idProperty: comboData.valueField
                    }), 
                    proxy: {
                        type: 'jsonp',
                        url: url,
                        reader: {
                            type: 'json',
                            rootProperty: 'rows',
                            totalProperty: 'total'
                        }
                    }
                });
                if (cfg.storeLoadEvent) {
                    store.on('load', cfg.storeLoadEvent);
                    store.parentView = this;
                }
            } else {
                // local
                var comboRows = this.prepareComboRows(comboData);
                var storeFields = [comboData.valueField, comboData.displayField];
                if (comboData.additionalDisplayValue)
                    storeFields.push(comboData.additionalDisplayValue);
                store = new Ext.data.ArrayStore({
                    fields: storeFields,
                    data: comboRows.data,
                    filter: function(field, value) {
                        Ext.data.ArrayStore.prototype.filter.apply(this, [field, value, true, false]);
                    }
                });
                comboCfg.value = comboRows.value;
                comboCfg.mode = 'local';
                comboCfg.triggerAction = 'all';
                comboCfg.minChars = 2;
            }
            comboCfg.store = store;
            var combo = new Ext.form.ComboBox(comboCfg);
            return combo;
        },

        comboDataSelectedHandler: function (combo, record) {
            var view = combo.parentView,
                value = record.get(combo.valueField),
                row = view.findComboDataRow(combo, value) || record.data;
            if (Ext.isFunction(combo.cfg.onSelectHandler))
                combo.cfg.onSelectHandler.call(view, combo, row);
        },

        findComboDataRow: function (combo, value) {
            var selectedRow = null;
            Ext.each(combo.comboData.rows, function(row) {
                if (row[combo.valueField] == value) selectedRow = row;
            });
            return selectedRow;
        },

        buildTransformDate: function(maskedString) {
            if (Ext.isEmpty(maskedString) || !Ext.isString(maskedString))
                return null;
            var dtParts,
                year = -1,
                month = -1,
                date = -1;
            if (maskedString.indexOf('-') > 0) {
                dtParts = maskedString.split(' ')[0].split('-');
                if (dtParts.length === 3) {
                    year = +dtParts[0];
                    month = +dtParts[1];
                    date = +dtParts[2];
                }
            } else if (maskedString.indexOf('.') > 0) {
                dtParts = maskedString.split(' ')[0].split('.');
                if (dtParts.length === 3) {
                    date = +dtParts[0];
                    month = +dtParts[1];
                    year = +dtParts[2];
                }
            }

            if (!isNaN(year) && !isNaN(month) && !isNaN(date) && year >= 0 && month >= 0 && date >= 0)
                return new Date(year, month - 1, date);

            return null;
        },

        buildTransformTime: function(maskedString) {
            if (Ext.isEmpty(maskedString) || !Ext.isString(maskedString) || maskedString.indexOf(' ') < 0)
                return null;
            var dtParts = maskedString.split(' ')[1].split(':');
            if (dtParts.length >= 2) {
                var hours = dtParts[0],
                    minutes = dtParts[1];
                var time = hours + ':' + minutes;
                if (dtParts.length > 2) {
                    var seconds = dtParts[2];
                    time += ':' + seconds;
                }                    
                return time;
            }
            return null;
        },

        getViewInfo: function () {
            var info = { 'ClientViewID': this.viewID };
            if (!Ext.isEmpty(this.dependentViews)) {
                for (var k = 0; k < this.dependentViews.length; k++) {
                    info['dependentViews' + k] = this.dependentViews[k];
                }
            }
            if (!Ext.isEmpty(this.masterView))
                info['masterView'] = this.masterView;
            try {
                this.serverCall({
                    method: 'GetViewInfo',
                    params: [info],
                    urgent: true,
                    success: function (info) {
                        var msg = '';
                        for (var key in info) {
                            if (info.hasOwnProperty(key))
                                msg += key + ':' + info[key] + '<br>';
                        }
                        KS.alert(msg);
                    },
                    error: function() {
                        KS.alert('GetViewInfo error');
                    },
                    complete: function() {
                        KS.alert('GetViewInfo complete');
                    }
                });
                KS.msg('GetViewInfo called');
            } catch (e) {
                KS.alert('GetViewInfo call failed: ' + e);
            }
        },

        buildSvodEntityTbarControls: function (ed, dock, helpBtn) {
            var toolbarControls = [],
                items = (Ext.isDefined(ed) && ed && !Ext.isEmpty(ed.toolbarItems)) ? ed.toolbarItems : null,
                dockedItems = items && items[dock] ? items[dock] : null;

            if (dockedItems) {
                for (var idx in dockedItems) {
                    if (dockedItems.hasOwnProperty(idx)) {
                        var tbarItem = dockedItems[idx],
                            ctrl = this.buildToolbarItemControl(tbarItem);
                        if (ctrl)
                            toolbarControls.push(ctrl);
                    }
                }
            }
            if (helpBtn === true && !Ext.isEmpty(this.helpTopic) && !KS.isSurDB) {
                toolbarControls.push('-', KS.Svod.helpBtn(this.helpTopic, 'tbar'), '-');
            }
            return toolbarControls;
        },

        buildConfirmWindow: function (confirmField, confirmMsg, callback) {
            var view = this,
                confirmWin = KS.showModal(this.createTemplateControl(confirmField),
                    {
                        title: confirmMsg,
                        autoHeight: false,
                        width: 450,
                        height: 350,
                        bbar: ['->', {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function () {
                                view.statusNoteCancelled();
                                delete view.confirmMsg;
                                confirmWin.close();
                            }
                        }, {
                            text: 'Далее',
                            cls: 'marked-button',
                            handler: function () {
                                if (KS.isEmpty(view.confirmMsg)) return;
                                callback.apply(view);
                                delete view.confirmMsg;
                                confirmWin.close();
                            }
                        }]
                    });
        },

        statusNoteCancelled: function() {
        },

        statusNoteChanged: function (ed, value) {
            ed.parentView.confirmMsg = value;
        },

        returnFalse: function() {
            return false;
        },

        onServerSetEditState: function(edited) {
            if (edited === true) {
                this.touch();
            } else if (edited === false) {
                this.discardChanges();
            }   
        },

        writeToClipboard: function(text) {
            if (!Ext.isIE && navigator.clipboard) {
                navigator.clipboard.writeText(text);
            } else if (window.clipboardData && clipboardData.setData) {
                clipboardData.setData("text", text);
            }
        }
    });
}(BaseSvodView.prototype));

// ============= SYSTEM HANDLERS =======================
(function (viewClass) {
    KS.apply(viewClass, {
        onBeforeClose: function () {
            var view = this;
            if (view.hasChanges) {
                Ext.MessageBox.show({
                    icon: Ext.MessageBox.QUESTION,
                    title: 'Сохранить изменения?',
                    msg: 'Документ содержит несохраненные изменения. <br />Сохранить перед закрытием?',
                    buttons: Ext.MessageBox.YESNOCANCEL,
                    fn: function (btn) {
                        switch (btn) {
                            case 'yes':
                                view.saveChanges(true);
                                break;
                            case 'no':
                                view.close();
                                break;
                        }
                    }
                });
                return false;
            }
            return BaseSvodView.superclass.onBeforeClose.call(view);
        }
    });
}(BaseSvodView.prototype));

// ============= TOOLBAR =======================
(function (viewClass) {
    var sc = BaseSvodView.superclass;

    function selectOptionVisibleDependCheckHandler (cb, checked) {
        cb.visibleDependent.setVisible(checked);
        cb.ownerCt.ownerCt.ownerCt.updateLayout();
    }

    KS.apply(viewClass,
    {
        getTbarClickHandler: function(tbarItem) {
            if (!tbarItem) return null;
            if (!this.checkHandler(tbarItem.pluginNameWeb)) {
                switch (tbarItem.code) {
                    case 'SAVE':
                        return this.saveChanges;

                    case 'REFRESH':
                        return this.reload;
                        
                    case 'MARK_INVERT':
                    case 'MARK_INVERT2':
                        return this.markInvertHandler;

                    case 'MARK_TOP':
                        return this.markTopHandler;

                    case 'MARK_ALL':
                        return this.markAllHandler;

                    case 'MARK_REST':
                        return this.markRestHandler;

                    case 'MARK_BETWEEN':
                        return this.markBetweenHandler;

                    case 'UNMARK':
                        return this.unmarkHandler;

                    case 'SYSTEM_JOURNAL':
                        return this.openSystemJournal;

                    case "PRINT_TREE":
                    case "PRINT_TREE_HTML":
                        return this.printTreeToHtml;

                    case "COLLAPSE_TREE":
                        return this.collapseTree;

                    case "EXPAND_TREE":
                        return this.expandTree;
                }
            }
            return sc.getTbarClickHandler.call(this, tbarItem);
        },

        buildContainerToolbarItemControl: function(tbarNode, schema) {
            var type = null;
            if (tbarNode.code === 'HelpTopic') {
                return KS.Svod.helpBtn(tbarNode.name, 'tbar');
            } else if (schema) {
                type = schema.TYPE;
            } else if (tbarNode.additional) {
                for (var key in tbarNode.additional) {
                    if (tbarNode.additional.hasOwnProperty(key))
                        type = key.split('_')[0];
                }
            }
            if (type) {
                var control = null;
                switch (type) {
                case 'CHECK':
                    control = this.buildToolbarCheckbox(tbarNode, schema);
                    break;
                case 'OPTIONSET':
                    control = this.buildToolbarRadioGroup(tbarNode, schema);
                    break;
                }
                if (control) {
                    var item = {
                        code: tbarNode.code,
                        tbarNode: tbarNode,
                        schema: schema,
                        type: type,
                        control: control
                    }
                    if (!this.tbarContainerItems)
                        this.tbarContainerItems = [];
                    this.tbarContainerItems.push(item);
                    return item.control;
                }
            }
            return sc.buildContainerToolbarItemControl.apply(this, arguments);
        },

        buildToolbarCheckbox: function(tbarNode, schema) {
            try {
                var width = 100,
                    checked = tbarNode.checked;
                if (schema) {
                    width = +schema.WIDTH;
                } else if (tbarNode.additional) {
                    width = +tbarNode.additional['CHECK_WIDTH'];
                    checked = (tbarNode.additional['CHECK_VALUE'] === 'CHECK');
                }
                var item = new Ext.form.Checkbox({
                    boxLabel: tbarNode.name,
                    checked: checked,
                    parentView: this,
                    width: (width > 0) ? width : undefined
                });
                return item;
            } catch (e) {
                return null;
            }
        },

        buildToolbarRadioGroup: function(tbarNode, schema) {
            var radioItems = [],
                items = [],
                width = 100;
            try {
                if (schema) {
                    items = schema.ITEMS.ITEM;
                    width = schema.WIDTH;
                } else if (tbarNode.additional) {
                    items = tbarNode.additional['OPTIONSET_ITEMS'];
                    width = tbarNode.additional['OPTIONSET_WIDTH'];
                }
                Ext.each(items,
                    function(radioItem) {
                        radioItems.push({
                            inputValue: radioItem.DATA_VALUE,
                            boxLabel: radioItem.DISPLAY_TEXT,
                            disabled: tbarNode.disabled,
                            // boxLabelAttrTpl: tbarNode.tooltip,
                            checked: radioItem.DEFAULT === true || radioItem.DEFAULT === 'True'
                        });
                    });
                if (Ext.isEmpty(radioItems)) return null;
                var item = new Ext.form.RadioGroup({
                    width: width,
                    parentView: this,
                    defaults: { name: 'container1' },
                    items: radioItems
                });
                return item;
            } catch (e) {
                return null;
            }
        },

        processToolbarItemControl: function(ctrl, tbarNode) {
            switch (tbarNode.code) {
            case 'PRINT_LIST':
                KS.apply(ctrl,
                {
                    gridPropertyName: this.printGridPropertyName,
                    parentView: this,
                    scope: undefined,
                    handler: this.exportToExcel
                });
                break;
            }
            return sc.processToolbarItemControl.call(this, ctrl, tbarNode);
        },
        
        collectContainerItemsValues: function() {
            var result = {};
            Ext.each(this.tbarContainerItems,
                function(tci) {
                    switch (tci.type) {
                    case 'CHECK':
                        result[tci.code] = tci.control.getValue();
                        break;
                    case 'OPTIONSET':
                        result[tci.code] = tci.control.getValue().inputValue ||
                                           tci.control.getValue()[tci.code.toLowerCase()];
                        break;
                    }
                });
            return result;
        },

        destroyContainerItems: function() {
            Ext.each(this.tbarContainerItems,
                function(tci) {
                    if (tci.control && Ext.isFunction(tci.control.destroy))
                        try {
                            tci.control.destroy();
                        } catch (e) {
                        }
                    delete tci;
                });
        },

        createOptionsGroup: function(optCfg) {
            KS.apply(optCfg, {
                columns: Ext.isNumber(optCfg.columns) ? optCfg.columns : 1,
                defaults: { scale: 'medium' }
            });
            optCfg.items = KS.Ext.processTbarItems(optCfg.items);
            var selOpt = new Ext.ButtonGroup(optCfg);
            selOpt.items.each(function(item) {
                var vd = item.initialConfig.visibleDepends;
                if (!vd) return;
                var parentChkbx = selOpt[vd];
                if (parentChkbx && parentChkbx.xtype === 'checkbox') {
                    item.setVisible(parentChkbx.checked);
                    parentChkbx.visibleDependent = item;
                    parentChkbx.ownerGroup = selOpt;
                    parentChkbx.on('check', selectOptionVisibleDependCheckHandler);
                }
            });
            this.selectOptions123 = selOpt;
            return selOpt;
        },

        collectSelectOptions: function () {
            var view = this,
                result = {};
            this.selectOptions123.items.each(function(item) {
                if (KS.isString(item.ref)) {
                    var value = view.getSelectOption(item.ref);
                    if (value !== null) result[item.ref] = value;
                }
            });
            return result;
        },

        getSelectOption: function(name) {
            var optCntr = this.selectOptions123;
            if (!optCntr) return null;
            var ct = optCntr[name];
            if (!ct) return null;
            var value = ct.getValue();
            if (ct.xtype === 'radiogroup' && value)
                value = value.inputValue;
            return value;
        },
        
        tryExecuteSvodTask: function (taskType, owner, gridId, callback, additional) {
            var gridState = "";
            var grid = this[gridId || 'mainGrid'];
            if (grid) {
                gridId = grid.itemId;
                gridState = JSON.stringify(grid.getControlState(additional));
            }

            var view = this.parentView || this;
            if (owner === "LOAD") {
                KS.confirm("Загрузить справочник?", "Внимание", function (btn) {
                    if (btn === 'yes')
                        view.serverCall({
                            method: 'TryExecuteTask',
                            params: [taskType, owner, gridId, gridState],
                            success: callback
                        });
                });
            } else {
                this.serverCall({
                    method: 'TryExecuteTask',
                    params: [taskType, owner, gridId, gridState],
                    success: callback
                });
            }
        },

        markInvertHandler: function () {
            var grid = this.parentView.findOwnerGrid(this) || this.parentView.getMarkableGrid();
            if (grid) grid.markInvert();
        },

        markTopHandler: function() {
            var grid = this.parentView.findOwnerGrid(this) || this.parentView.getMarkableGrid();
            if (grid) grid.markTop();
        },

        markAllHandler: function() {
            var grid = this.parentView.findOwnerGrid(this) || this.parentView.getMarkableGrid();
            if (grid) grid.markAll();
        },

        markRestHandler: function() {
            var grid = this.parentView.findOwnerGrid(this) || this.parentView.getMarkableGrid();
            if (grid) grid.markRest();
        },

        markBetweenHandler: function() {
            var grid = this.parentView.findOwnerGrid(this) || this.parentView.getMarkableGrid();
            if (grid) grid.markBetween();
        },

        unmarkHandler: function() {
            var grid = this.parentView.findOwnerGrid(this) || this.parentView.getMarkableGrid();
            if (grid) grid.unmark();
        },

        /*
            Получить грид для отметки строк
            Необходимо переопределить в наследующих представлениях!
        */
        getMarkableGrid: function () {
            return null;
        },

        scrollToSelectedRow: function(grid) {
            var selRows = grid.getCheckedRows();
            if (!Ext.isEmpty(selRows)){
                var yPosition = 0;
                var activeRowNumber = grid.store.indexOf(selRows[0]) + 1;
                var oneBlockHeight = 24;
                if (activeRowNumber * oneBlockHeight > grid.getHeight() / 2) {
                    yPosition = activeRowNumber * oneBlockHeight - grid.getHeight() / 2;
                }
                grid.setScrollY(yPosition);
            }
        },

        openSystemJournal: function() {
            var gridId = null;
            var grid = this.parentView.findOwnerGrid(this);
            if (grid)
                gridId = grid.itemId;

            this.parentView.tryExecuteSvodTask(0, 'SYSTEM_JOURNAL', gridId);
        },

        printTreeToHtml: function() {
            var view = this.parentView || this;
            var treeId = (this.tbarNode.additional && this.tbarNode.additional.treeId) || 'baseTree';
            if (view[treeId]) {
                view.serverCall({
                    method: 'PrintTreeToHtml',
                    params: [treeId]
                });
            }
        },

        collapseTree: function() {
            var tree = this.parentView.findOwnerTree(this);
            if (tree) {
                tree.collapseAll();
            }
        },

        expandTree: function() {
            var tree = this.parentView.findOwnerTree(this);
            if (tree) {
                tree.expandAll();
            }
        }
    });
}(BaseSvodView.prototype));

// ============= SAVE =======================
(function (viewClass) {
    KS.apply(viewClass, {
        touch: function () {
            this.hasChanges = true;
            this.setSavedState(false);
        },

        discardChanges: function () {
            this.hasChanges = false;
            this.setSavedState(true);
        },

        setSavedState: function (saved) {
            var t = this.containerPanel.title;
            if (Ext.isEmpty(t))
                return;
            if (saved === true) {
                if (t.substring(t.length - 1) === '*')
                    this.containerPanel.setTitle(t.substring(0, t.length - 1));
            } else {
                if (t.substring(t.length - 1) !== '*')
                    this.containerPanel.setTitle(t + '*');
            }
            if (typeof (this.onSetSavedState) == 'function') this.onSetSavedState(saved);
        },

        saveChanges: function (close) {
            var view = this.parentView || this;
            view.beforeSaveChanges();
            view.serverCall({
                method: 'SaveChanges',
                waitMessage: 'Сохранение ...',
                success: function (hasSaveErrors) {
                    if (hasSaveErrors === true) {
                        KS.alert('Документ не сохранен!');
                        return;
                    }
                    this.discardChanges();
                    if (close === true) {
                        this.close();
                    } else {
                        this.reload();
                    }
                }
            });
        },

        beforeSaveChanges: function(){
        }
    });
}(BaseSvodView.prototype));

// ============= RELOAD =======================
(function (viewClass) {
    KS.apply(viewClass, {
        reload: function () {
            var view = this.parentView || this;
            if (!view.hasChanges) {
                view.doReload();
                return;
            }
            KS.confirm("Обновить документ? Несохраненные данные будут утеряны.", "Подтвердите обновление", function (btn) {
                if (btn === 'yes') view.doReload();
            });
        },

        doReload: function () {
            this.serverCall({
                method: 'Reload',
                waitMessage: 'Обновление ...',
                success: this.reloadCallback
            });
        },

        reloadCallback: function (data) {
            if (typeof (data) == 'object') this.data = data;
            this.discardChanges();
            this.resetView();
        },

        resetView: function () {
        }
    });
}(BaseSvodView.prototype));

// ============= UPLOAD =======================
(function (viewClass) {
    KS.apply(viewClass, {
        uploadFiles: function (form, callback, uplField, evt, grid) {
            if (KS.checkHtml5UploadSupport()) {
                try {
                    this.html5Upload(form, callback, uplField, evt, grid);
                } catch (e) {
                    this.extUpload(form, callback);
                }
            } else {
                this.extUpload(form, callback);
            }
            //this.ajaxUpload(form, callback);
            //this.ajaxFormUpload(form, callback);
        },

        extUpload: function (form, callback) {
            var view = this,
                url = 'PlatformHandler.axd?upload=1&important=1';
            form.submit({
                url: url,
                method: 'POST',
                fileUpload: true,
                waitMsg: 'Отправка файла на сервер ...',
                success: function () { },
                failure: function (fp, o) {
                    callback.call(view, o.result);
                }
            });
        },

        html5Upload: function(form, callback, uplField, evt, grid) {
            if (Ext.isEmpty(evt.target.files)) return;
            var uploader = new KS.Ext.Html5Uploader({
                file: evt.target.files[0],
                grid: grid,
                parentView: this,
                success: callback
            });
            if (uploader.isValid())
                uploader.upload();
        },

        ajaxUpload: function (form, callback) {
            var view = this;
            $.ajax({
                url: 'PlatformHandler.axd?upload=1&important=1',
                type: 'POST',
                xhr: function () {
                    var myXhr = $.ajaxSettings.xhr();
                    if (myXhr.upload) {
                        myXhr.upload.addEventListener('progress', view.progressHandlingFunction, false);
                    }
                    return myXhr;
                },
                beforeSend: function () {  },
                success: function () { debugger; },
                error: function () { debugger; },
                data: new FormData(form),
                //Options to tell jQuery not to process data or worry about content-type.
                cache: false,
                contentType: "application/json",
                dataType: "json",
                processData: false
            });
        },

        ajaxFormUpload: function (form, callback) {
            var view = this;
            $(form.getEl()).ajaxForm({
                url: 'PlatformHandler.axd?upload=1&important=1',
                type: 'post',
                dataType:  'json',        // 'xml', 'script', or 'json' (expected server response type) 
                //clearForm: true,        // clear all form fields after successful submit 
                //resetForm: true,        // reset the form after successful submit 
                // $.ajax options can be used here too, for example: 
                //timeout:   3000                 contentType: "application/json",
                beforeSend: function () {
                    status.empty();
                    var percentVal = '0%';
                    bar.width(percentVal);
                    percent.html(percentVal);
                },
                uploadProgress: function (event, position, total, percentComplete) {
                    var percentVal = percentComplete + '%';
                    bar.width(percentVal);
                    percent.html(percentVal);
                },
                complete: function (xhr) {
                    status.html(xhr.responseText);
                }
            });
        },

        progressHandlingFunction: function () {
        }
    });
}(BaseSvodView.prototype));

// ============= SIGN =======================
(function (viewClass) {
    // Common
    KS.apply(viewClass, {
        setSecretKeyValidity: function () {
            var skv = this.data.settings.SecretKeyValidity;
            if (Ext.isNumber(skv) && skv > 0) KS.Svod.certValidity = skv;
        },

        signDataSelector: function (links, trySignFn) {
            if (Ext.isEmpty(links)) {
                KS.msg('Не выбраны данные для подписи');
                return;
            }
            if (KS.edsType >= 1) {
                this.getOpenData(links);
            } else {
                KS.loadXcrypt(trySignFn, this, [links]);
            }
        },

        afterTrySign: function (dict) {
            if (KS.edsType === 0) {
                this.fillCertDataType0(dict);
            }
        },

        afterDataSigned: function (dict) {
            // Reset cached cert password
            if (KS.edsType === 2) {
                KS.XCrypt.cmInitor.container.Lavanda.Crypto.Clear({});
            }
            this.serverCall({
                method: 'OnAfterDataSigned',
                params: [dict],
                waitMessage: 'Подписывание ...',
                success: this.afterSignData
            });
        },

        afterSignData: function () {
        }
    });

    // Xcrypt10
    KS.apply(viewClass, {
        fillCertDataType0: function (dict) {
            if (Ext.isEmpty(dict)) return;
            var xObj = KS.getXcryptObj();
            Ext.each(dict, function (data) {
                try {
                    var dataUrl = data['DATA_URL'],
                        certData = xObj.SelectCertificate(data['SERT_NAME'] || ''),
                        signature = xObj.CPGetSignature(dataUrl, certData, 1);
                    data['SERT_DATA'] = certData;
                    data['SIGN'] = signature;
                } catch (e) {
                    KS.warning('Сертификат с именем "' + data['SERT_NAME'] + '" не найден или недействителен. Проверьте настройки ЭП.');
                }
            });
            this.afterDataSigned(dict);
        }
    });

    // npXcrypt/CryptoModule
    KS.apply(viewClass, {
        getOpenData: function(links) {
            this.serverCall({
                method: 'GetOpenData',
                params: [links, null],
                waitMessage: 'Чтение настроек ...',
                success: this.signSettingsMode
            });
        },
        
        initializeXCrypt: function(signSettings, callback, scope){
            KS.XCrypt.initialize(signSettings, callback, scope);
            if (KS.edsType == 2 && KS.cryptoPort != 0) { // Порт для криптомодуля из настроек веба
                KS.XCrypt.cmInitor.container.Lavanda.SetSettings({
                    port: KS.cryptoPort
                })
            }
        },

        signSettingsMode: function(signSettings) {
            this.initializeXCrypt(signSettings, this.getCertificates, this);
        },

        getCertificates: function() {
            KS.XCrypt.selectCertificate(this.getDataForSign, this);
        },

        getDataForSign: function(certData) {
            this.serverCall({
                method: 'GetDataForSign',
                params: [KS.XCrypt.signSettings.sessionId, certData],
                waitMessage: 'Чтение данных ...',
                success: this.getDataForSignCallback
            });
        },

        getDataForSignCallback: function (dataForSignList) {
            if (Ext.isEmpty(dataForSignList)) return;
            this.forSignList = dataForSignList.slice(0);
            this.dataForSave = [];
            this.signNext();
        },

        signNext: function () {
            var item = this.forSignList.splice(0, 1)[0];
            if (KS.isEmpty(item.url)) return;
            this.currentData = item.certData;
            this.currentData.LINK = item.link;
            if (KS.XCrypt.signSettings.primaryB64 && item.data) {
                KS.XCrypt.sign(item.data, this.currentData.serial, 1, 'TspUrl=', this.fileSigned, this);
            } else {
                KS.XCrypt.downloadFile(item.url, this.fileDownloaded, this);
            }
        },

        fileDownloaded: function(path) {
            if (this.checkSignForErrors(path)) return;
            KS.XCrypt.signFileWeb(path, this.currentData.serial, 1, 'TspUrl=', this.fileSigned, this);
        },

        fileSigned: function (sign) {
            if (this.checkSignForErrors(sign)) return;
            this.currentData.SIGN = sign;
            this.dataForSave.push(this.currentData);
            if (KS.isEmpty(this.forSignList)) {
                this.afterDataSigned(this.dataForSave);
            } else {
                this.signNext();
            }
        },

        checkSignForErrors: function (sign, silent) {
            if (KS.isEmpty(sign)) return true;
            try {
                var errIdx = sign.toLowerCase().indexOf('<error>');
                if (errIdx >= 0) {
                    var errBody = sign.substring(errIdx + 7).replace('</Error>', '');
                    if (silent === true) {
                        KS.log(errBody);
                    } else {
                        KS.error(errBody);
                    }
                    KS.XCrypt.lastSignError = errBody;
                    return true;
                }
                //var x = KS.xml2json.parser(sign);
                //if (!KS.isEmpty(x.error)) {
                //    KS.error(x.error);
                //    return true;
                //}
            } catch (e) {
                KS.log(sign);
                return false;
            }
            return false;
        }
    });
}(BaseSvodView.prototype));

// ============= TASK LIST =======================
(function (viewClass) {
    KS.apply(viewClass, {
        refreshTaskList: function () {
            var tlv = this.getTaskListView();
            if (tlv)
                tlv.refreshList();
        },

        activateTaskList: function () {
            var tlv = this.getTaskListView();
            if (tlv) KS.tabViewport.setActiveTab(tlv.containerPanel);
        },

        isTaskListOpen: function () {
            return (this.getTaskListView() != null);
        },

        getTaskListView: function () {
            return KS.findSingleView('customName', 'ReportTaskListView');
        }
    });
}(BaseSvodView.prototype));

// ============= STATISTICS VIEW =======================
(function (viewClass) {
    KS.apply(viewClass, {
        refreshStatisticsView: function () {
            var statView = this.getStatisticsView();
            if (statView)
                statView.refreshList();
        },

        activateStatisticsView: function () {
            var statView = this.getStatisticsView();
            if (statView) KS.tabViewport.setActiveTab(statView.containerPanel);
        },

        isStatisticsViewOpen: function () {
            return (this.getStatisticsView() != null);
        },

        getStatisticsView: function () {
            return KS.findSingleView('customName', 'ReportStatisticsView');
        }
    });
}(BaseSvodView.prototype));

// ============= EArchView VIEW =======================
(function (viewClass) {
    KS.apply(viewClass, {
        refreshEArchiveView: function () {
            var view = this.getEArchiveView();
            if (view)
                view.refreshList();
        },

        activateEArchiveView: function () {
            var view = this.getEArchiveView();
            if (view) KS.tabViewport.setActiveTab(view.containerPanel);
        },

        isEArchiveViewOpen: function () {
            return (this.getEArchiveView() != null);
        },

        getEArchiveView: function () {
            return KS.findSingleView('customName', 'SvodEArcView');
        }
    });
}(BaseSvodView.prototype));

// ========== ReportCacheView ==================
(function (viewClass) {
    KS.apply(viewClass, {
        refreshReportCacheView: function () {
            var view = this.getReportCacheView();
            if (view)
                view.refreshList();
        },

        activateReportCacheView: function () {
            var view = this.getReportCacheView();
            if (view) KS.tabViewport.setActiveTab(view.containerPanel);
        },

        isReportCacheViewOpen: function () {
            return (this.getReportCacheView() != null);
        },

        getReportCacheView: function () {
            return KS.findSingleView('customName', 'ReportCacheView');
        }
    });
}(BaseSvodView.prototype));

// ============= DOCUMENT FOR SIGN =======================
(function (viewClass) {
    KS.apply(viewClass, {
        refreshDocumentForSign: function () {
            var tlv = this.getDocumentForSignView();
            if (tlv)
                tlv.refreshDocuments();
        },

        getDocumentForSignView: function () {
            return KS.findSingleView('customName', 'DocumentForSignView');
        }
    });
}(BaseSvodView.prototype));

// ============= TREE =======================
(function (viewClass) {
    KS.apply(viewClass, {
        scrollToActiveNode: function(tree) {
            if (tree && tree.rendered) {
                var yPosition = 0;
                var activeNodeNumber = this.findActiveNodeNumber(tree);
                var oneBlockHeight = KS.theme === 'Classic' ? 20 : 23;
                if (activeNodeNumber * oneBlockHeight > tree.getHeight() / 2) {
                    yPosition = activeNodeNumber * oneBlockHeight - tree.getHeight() / 2;
                }
                setTimeout(function() {
                    setTimeout(function() {
                        tree.setScrollY(yPosition);
                    }, 0);
                }, 0);
            }
        },

        findActiveNodeNumber: function(tree) {
            var activeNodeId = tree.getSelNodeId(),
                root = tree.getRootNode(),
                activeNumber = -1, // -1, т.к. в первый раз node - root, и он невидимый
                nodeFound = false;

            var getNodeNumber = function(node) {
                if (node.id === activeNodeId)
                    nodeFound = true;
                if (nodeFound) return;
                activeNumber++;
                if (!Ext.isEmpty(node.childNodes) && node.isExpanded()) {
                    Ext.each(node.childNodes, function(childNode) {
                        getNodeNumber(childNode);
                    });
                }
            }

            getNodeNumber(root);
            return activeNumber;
        },

        findOwnerTree: function(inst) {
            if (inst.parentMenu && inst.parentMenu.ownerCmp)
                inst = inst.parentMenu.ownerCmp;
            return this.findOwnerContainer(inst, this.isTree);
        },

        isTree: function(ctrl) {
            return ctrl && ctrl.isTree;
        },

        copyPathToActiveNode: function(tree){
            var path = this.getActiveNodePath(tree);
            path = path.replace(/<b>/g,"").replace(/<\/b>/g,"")
                       .replace(/<i>/g,"").replace(/<\/i>/g,"");
            this.writeToClipboard(path);
        },

        getActiveNodePath: function(tree){
            var path = "";
            var selNode = tree.getSelNode();
            if (!Ext.isEmpty(selNode))
                path = selNode.getPath("text", "\\").replace("\\\\", "");
            return path;
        }
    });
}(BaseSvodView.prototype));

// ============= BUDGET TREE =======================
(function (viewClass) {
    KS.apply(viewClass, {

        selectBudgetTreeVersion: function(){
            // переопределять во вьюшках  
        },

        //Кастомное из renderer обновление данных в гриде версий дерева при раскрытии комбобокса
        setCustomComboBoxExpand: function(panel) {
            var view = this.parentView || this;
            var cboCfg = view.getToolbarItem(panel, null, 'ComboVersions');
            if (cboCfg == null) return;
            cboCfg.onExpand = function() {
                var grid = KS.gridOnExpand,
                    combo = this,
                    columns = [],
                    storeCfg = combo.store.config,
                    lastSelRec = (combo.lastSelection && combo.lastSelection[0]) || combo.store.getAt(0),
                    index = 0,
                    comboData = combo.store.getData().getRange();

                if (Ext.isNumber(combo.getValue()) || combo.ksTriggerClicked) {
                    combo.collapse();
                    if (grid.expanded) return true;
                    Ext.each(storeCfg.fields,
                        function(field) {
                            if (field === 'Index') return 1;
                            if (combo.visibleColumns != null) {
                                columns.push({
                                    text: combo.visibleColumns[field] || field,
                                    dataIndex: field,
                                    hidden: !combo.visibleColumns.hasOwnProperty(field),
                                    renderer: tooltipRenderer,
                                    flex: 1
                                });
                            } else {
                                columns.push({
                                    text: field,
                                    dataIndex: field,
                                    hidden: false,
                                    renderer: tooltipRenderer,
                                    flex: 1
                                });
                            }
                            return 1;
                        }
                    );

                    grid.getSelectionModel().setSelectionMode('SINGLE');

                    grid.store.fields = storeCfg.fields;
                    grid.reconfigure(grid.store, columns);

                    KS.gridOnExpandParentWindow.show();
                    KS.gridOnExpandParentWindow.setPosition(combo.inputEl.getX(), combo.getY() + combo.getHeight());
                    if (combo.visibleColumns != null) {
                        // У самого окна прописан minWidth = 400 в renderer, поэтому меньше всё равно не будет
                        KS.gridOnExpandParentWindow.setWidth(Object.keys(combo.visibleColumns).length * 120); 
                    } else {
                        KS.gridOnExpandParentWindow.setWidth(550);
                    }

                    grid.expanded = true;
                    grid.bindedCombo = combo;
                    grid.focus();
                    grid.mask('Загрузка данных...');

                    //Обновляем данные грида
                    combo.parentView.serverCall({
                        method: 'ChangeReportParam1',
                        success: function(result) {
                            if (result && result.Values.length > 0) {
                                combo.store.loadData(result.Values);
                                comboData = combo.store.getData().getRange();
                                grid.store.loadData(comboData);
                                if (lastSelRec) {
                                    var lastDisplayValue = KS.Grid.getAnyCase(lastSelRec, combo.displayField).toString();
                                    Ext.each(comboData, function(d, ind) {
                                        if (KS.Grid.getAnyCase(d, combo.displayField).toString() === lastDisplayValue)
                                            index = ind;
                                    });
                                }
                                grid.getSelectionModel().select(comboData[index]);
                                combo.parentView.scrollToSelectedRow(grid);
                            }
                            grid.unmask();
                        },
                        error: function(){
                            grid.unmask();
                        }
                    });
                }
                return true;
            };
        },

        markInvertTreeNodes: function() {
            var view = this.parentView || this;
            view.budgetTree.invertAll();
        },
    
        markAllTreeNodes: function() {
            var view = this.parentView || this;
            view.budgetTree.checkAll();
        },
    
        unmarkTreeNodes: function() {
            var view = this.parentView || this;
            view.budgetTree.uncheckAll();
        },

        checkChildrenNodes: function() {
            var view = this.parentView || this;
            view.budgetTree.checkAllChildren();
        },

        checkDirectChildrenNodes: function() {
            var view = this.parentView || this;
            view.budgetTree.checkDirectChildren();
        },

        checkLeafNodes: function() {
            var view = this.parentView || this;
            view.budgetTree.checkAllLeafs();
        },

        collapseAllNodes: function() {
            var view = this.parentView || this;
            view.budgetTree.collapseAll();
        },

        expandAllNodes: function() {
            var view = this.parentView || this;
            view.budgetTree.expandAll();
        },

        changeSearchPanelVisible: function() {
            var view = this.parentView || this;
            view.searchPanel.setVisible(this.pressed);
        },

        hideSearchPanel: function() {
            var view = this.parentView || this;
            view.searchPanel.setHidden(true);
        },

        clearSearchField: function() {
            var view = this.parentView || this;
            var searchField = view.getToolbarItem(view.searchPanel, null, "searchField");
            if (searchField) {
                searchField.setValue("");
                view.searchFieldChange();
            }
        },

        searchTree: "budgetTree",

        // Поиск запускается только при клике на кнопку поиска или очистить, 
        // т.к. слишком много узлов и если делать поиск при каждом изменении, сильно подвисает
        searchFieldChange: function() {
            var view = this.parentView || this;
            var searchField = view.getToolbarItem(view.searchPanel, null, "searchField");
            if (searchField) {
                var newVal = searchField.getValue();

                view[view.searchTree].ksObjs.ksProgressBar.showProgressBar();

                if (newVal.indexOf('/') !== -1) {
                    var splitted = newVal.split('/ ');
                    if (splitted && splitted.length) {
                        newVal = splitted[splitted.length - 1];
                    }
                }

                if (Ext.isEmpty(newVal)) {
                    view[view.searchTree].store.clearFilter();
                    view[view.searchTree].collapseAll();
                } else {
                    var stringCompare = function(val, filterVal) {
                            return val.toString().toLowerCase().indexOf(filterVal.toLowerCase());
                        },
                        store = view[view.searchTree].store;

                    //Фильтрация снизу вверх
                    store.filterer = 'bottomup';
                    store.filter({
                        property: 'text',
                        filterFn: function(item) {
                            var ind = stringCompare(item.get('text'), newVal);
                            return Ext.isNumber(ind) && ind !== -1;
                        },
                        value: newVal
                    });

                    view[view.searchTree].expandAll();
                }

                if (view.updateTimeoutId) clearTimeout(view.updateTimeoutId);
                view.updateTimeoutId = setTimeout(
                    function() {
                        delete view.updateTimeoutId;
                        view[view.searchTree].ksObjs.ksProgressBar.hideProgressBar();
                    },
                    1500);
            }
        }
    });
}(BaseSvodView.prototype));

// ============= PROPERTY GRID =======================
(function (viewClass) {
    KS.apply(viewClass, {
        getPropertyGridByOption: function(settings, itemId, title) {
            var source = {},
                sourceConfig = {},
                view = this;
            Ext.each(settings, function (option, optIdx) {
                    var key = (optIdx < 10 ? '0' : '') + optIdx + "#" + option.Key; // for sort
                    source[key] = !Ext.isEmpty(option.Value) ? option.Value : "";
                    switch (option.Type) {
                        case 0: //number
                            sourceConfig[key] = {
                                editor: new Ext.form.field.Number({
                                    xtype: 'numberfield',
                                    anchor: '100%',
                                    name: key,
                                    fieldStyle: "font-weight: bold",
                                    disabled : option.ReadOnly,
                                    value: option.Value,
                                    maxValue: option.MaxValue,
                                    minValue: option.MinValue,
                                    allowBlank: option.AllowBlank
                                }),
                                renderer: function(v){
                                    if (Ext.isEmpty(v)) return "";
                                    return '<span style="font-weight: bold">' + v + '</span>';
                                }
                            };
                            break;

                        case 1: // string
                            var textEditor = new Ext.form.field.Text({
                                fieldCls: option.ReadOnly ? "textfield-read-only" : "",
                                fieldStyle: "font-weight: bold",
                                allowBlank: option.AllowBlank
                            });
                            sourceConfig[key] = {
                                editor: textEditor,
                                renderer: function(v, metadata){
                                    if (Ext.isEmpty(v)) return "";
                                    metadata.css = option.ReadOnly ? "textfield-read-only" : "";
                                    v = v.replace(/</g, "&lt;");
                                    v = v.replace(/>/g, "&gt;");
                                    setTooltip(metadata, v);
                                    return '<span style="font-weight: bold">' + v + '</span>';
                                }
                            }; 
                            break;

                        case 2: // boolean
                            source[key] = Ext.isEmpty(option.Value) ? 
                                "" :
                                option.Value === true || $.inArray(source[key], ['true', 'True']) >= 0;
                            sourceConfig[key] = {
                                editor:
                                    Ext.create('Ext.form.field.ComboBox',
                                        {
                                            store: Ext.create('Ext.data.Store',
                                                {
                                                    fields: ['value', 'name'],
                                                    data: [
                                                        { "value": true, "name": "Да" },
                                                        { "value": false, "name": "Нет" }
                                                    ]
                                                }),
                                            displayField: 'name',
                                            fieldStyle: "font-weight: bold",
                                            valueField: 'value',
                                            name: key
                                        }),
                                renderer: function (v){
                                    var displayValue = Ext.isEmpty(v) ?  "" : (v ? 'Да' : 'Нет');
                                    return '<span style="font-weight: bold">' + displayValue + '</span>';
                                }
                            };
                            break;
                            
                        case 3: // date
                            var dateValue = "";
                            if (!Ext.isEmpty(option.Value)) {
                                if (Ext.isString(option.Value)) {
                                    var parsed = KS.parseAjaxDateTime(option.Value);
                                    if (parsed) {
                                        dateValue = Ext.util.Format.date(parsed, 'd.m.Y');
                                    } else {
                                        dateValue = option.Value.substring(0, 10);
                                    }
                                } else {
                                    dateValue = Ext.util.Format.date(option.Value, 'd.m.Y');
                                }
                            }

                            source[key] = dateValue;
                            sourceConfig[key] = {
                                editor:
                                    new Ext.form.field.Date({
                                        editable: true,
                                        format: 'd.m.Y',
                                        allowBlank: option.AllowBlank
                                    }),
                                renderer: function (value) {
                                    if (!Ext.isEmpty(value) && Ext.isString(value)) {
                                        var parsed = KS.parseAjaxDateTime(value);
                                        if (parsed) {
                                            value = Ext.util.Format.date(parsed, 'd.m.Y');
                                        } else if (value.length > 10) {
                                            value = value.substring(0, 10);
                                        }
                                    } else {
                                        value = Ext.util.Format.date(value, 'd.m.Y');
                                    }
                                    return '<span style="font-weight: bold">' + value + '</span>';
                                },
                                type : 'date'
                            };
                            break;

                        case 4: // dropDownList
                            source[key] = option.Items[option.Value];
                            var hasEmptyItem = option.Items.indexOf("") > -1;
                            sourceConfig[key] = {
                                editor:
                                    new Ext.form.field.ComboBox({
                                        name: key,
                                        allowBlank: hasEmptyItem, 
                                        store: option.Items,
                                        fieldStyle: "font-weight: bold",
                                        mode: 'local',
                                        triggerAction: 'all',
                                        emptyText: hasEmptyItem ? '' : '-- Значение не выбрано --',
                                        typeAhead: option.Editable,
                                        editable: option.Editable,
                                        selectOnFocus: option.Editable
                                    }),
                                renderer: function(v){
                                    return '<span style="font-weight: bold">' + v + '</span>';
                                },
                                items: option.Items,
                                type: "dropDownList"
                            };
                            break;

                        case 5: // tagField
                            source[key] = option.Value.join(",");
                            sourceConfig[key] = {
                                editor:
                                    new Ext.form.field.Tag({
                                        name: key,
                                        store: option.Items,
                                        fieldStyle: "font-weight: bold",
                                        typeAhead: true,
                                        mode: 'local',
                                        editable: true,
                                        triggerAction: 'all',
                                        filterPickList: true,
                                        emptyText: '-- Значение не выбрано --',
                                        selectOnFocus: true
                                    }),
                                renderer: function(v){
                                    return '<span style="font-weight: bold">' + v + '</span>';
                                }
                            };
                            break;

                        case 6: // password
                            sourceConfig[key] = {
                                editor: 
                                    new Ext.form.field.Text({
                                        inputType: 'password',
                                        fieldStyle: "font-weight: bold"
                                    }),
                                renderer: function(value){
                                    var strLength = !Ext.isEmpty(value) ? value.length : 0;
                                    var newValue = "";
                                    for (var i = 0; i < strLength; i++) {
                                        newValue += "&#x25cf;";
                                    }
                                    return newValue;
                                }
                            }; 
                            break;

                        case 7: // fieldSelector
                            sourceConfig[key] = {
                                editor:new Ext.form.field.Text({
                                    readOnly: option.ReadOnlySelector,
                                    fieldCls: "textfield-dict",
                                    fieldStyle: "font-weight: bold",
                                    grid: option.SelectorGrid
                                }),
                                renderer: function(v, metadata){
                                    metadata.css = "textfield-dict";
                                    setTooltip(metadata, v);
                                    return '<span style="font-weight: bold">' + (v || "") + '</span>';
                                },
                                type: "fieldSelector"
                            }; 
                            break;  
                        
                        case 8: // visualSelector
                            sourceConfig[key] = {
                                editor:new Ext.form.field.Text({
                                    readOnly: option.ReadOnlySelector,
                                    visualSelector: true
                                }),
                                renderer: function(v, metadata){
                                    var backColor = v.split("_")[0];
                                    var fontColor = v.split("_")[1];
                                    metadata.style = 'background-color:' + convertToHexString(backColor) + ';' +
                                                     'color:' + convertToHexString(fontColor);
                                    return "X";
                                },
                                type: "visualSelector"
                            }; 
                            break;                        
                        
                        case 9: // imageBase64
                            sourceConfig[key] = {
                                editor:new Ext.form.field.Text({
                                    readOnly: option.ReadOnlySelector
                                }),
                                renderer: function(v, metadata){
                                    metadata.css = option.ReadOnly ? "textfield-read-only" : "";
                                    metadata.style = 'padding : 0';
                                    return '<span><img src="data:image/png;base64, '+ option.ImageSrc +'" ' +
                                        'width="20" height="20" />'+ v +'</span>';
                                },
                                type: "image"
                            }; 
                            break;

                        case 10: // dictionSelect
                            sourceConfig[key] = {
                                editor:new Ext.form.field.Text({
                                    readOnly: option.ReadOnlySelector,
                                    fieldCls: "textfield-dict",
                                    fieldStyle: "font-weight: bold",
                                    dictId: option.DictionID
                                }),
                                renderer: function(v, metadata){
                                    if (v == null) v = "";
                                    metadata.css = "textfield-dict";
                                    return '<span style="font-weight: bold">' + v + '</span>';
                                },
                                type: "dictionSelect"
                            }; 
                            break;  

                        case 11: // fileSelect
                            sourceConfig[key] = {
                                editor:new Ext.form.field.Text({
                                    readOnly: option.ReadOnlySelector,
                                    fieldCls: "textfield-dict",
                                    fieldStyle: "font-weight: bold"
                                }),
                                renderer: function(v, metadata){
                                    metadata.css = "textfield-dict";
                                    return '<span style="font-weight: bold">' + v + '</span>';
                                },
                                type: "fileSelect"
                            }; 
                            break;  

                        case 12: // selectDictionCode
                            sourceConfig[key] = {
                                editor:
                                    new Ext.form.field.ComboBox({
                                        name: key,
                                        allowBlank: false,
                                        store: option.Items,
                                        fieldStyle: "font-weight: bold",
                                        mode: 'local',
                                        editable: false,
                                        triggerAction: 'all',
                                        parentView: view,
                                        listeners: {
                                            beforeselect: view.selectDictionCodeSelect
                                        }
                                    }),
                                renderer: function(v){
                                    return '<span style="font-weight: bold">' + v + '</span>';
                                },
                                items: option.Items,
                                type: "selectDictionCode"
                            };
                            break;  
                    }
                    sourceConfig[key].description = option.Description ? option.Description : option.Name;
                    sourceConfig[key].isUserSetting = option.IsUserSetting;
                    sourceConfig[key].baseName = option.Name;                    
                    sourceConfig[key].displayName = '<span title="' + option.Name.replace(/"/g, '&quot;') + '"' 
                                            + (option.ReadOnly ? ' style="opacity: 0.6"' : '')
                                            + '>' + option.Name + '</span>';

                    var baseRenderer = sourceConfig[key].renderer;
                    if (option.ReadOnly) {
                        sourceConfig[key].editor.setDisabled(true);
    
                        sourceConfig[key].renderer = function (v, metadata) {
                            if (baseRenderer)
                                v = baseRenderer(v, metadata);
                            metadata.css = "textfield-read-only";
                            return v;
                        };
                    } else if (!option.AllowBlank){
                        sourceConfig[key].renderer = function (v, metadata) {
                            var isEmpty = Ext.isEmpty(v);
                            if (baseRenderer)
                                v = baseRenderer(v, metadata);
                            if (isEmpty) {
                                metadata.style = "border: 1px solid #ff000080;"
                                setTooltip(metadata, "Это поле обязательно для заполнения");
                            }
                            return v;
                        };
                    }
            });

            var properyGrid = new Ext.grid.property.Grid({
                itemId: itemId,
                source: source,
                hideHeaders: true,
                nameColumnWidth: "50%",
                sourceConfig: sourceConfig,
                settings: settings,
                parentView: view,
                listeners: {
                    'celldblclick': view.propertyGridDblClick,
                    'beforecellclick': view.beforePropertyGridCellClick,
                    'cellclick': view.propertyGridCellClick
                },
                viewConfig: {
                    forceFit: true
                }
            });
            
            if (!Ext.isEmpty(title)) {
                properyGrid.setTitle("<b>" + (title || "") + "</b>");
            }

            return properyGrid;
        },

        propertyGridDblClick: function(gridView, td, cellIndex, record, tr, rowIndex) {
            var propGrid = this;
            var view = this.parentView;
            var selectProp = propGrid.settings[rowIndex];
            var sourceConfig = propGrid.sourceConfig[record.id];
            if (!KS.isEmpty(sourceConfig) 
                && (sourceConfig.editor && sourceConfig.editor.field && !sourceConfig.editor.field.disabled)) {
                switch(sourceConfig.type) {
                    case "boolean":
                        view.changeBooleanByDblClick(propGrid, record, propGrid.source[record.id]);
                        break;
                    case "dictionSelect":
                        view.propertyGridDictSelect(record.id, selectProp.DictionID);
                        break;
                    case "fieldSelector":
                        view.propertyGridFieldSelectorSelect(selectProp, propGrid, record, rowIndex);
                        break;
                }
            }
        },

        propertyGridDictSelect: function(propId) {

        },
        
        propertyGridFieldSelectorSelect: function(selectProp, propGrid, record, rowIndex){
            
        },        

        beforePropertyGridCellClick: function() {

        },

        propertyGridCellClick: function() {

        },

        selectDictionCodeSelect: function(combo) {
            combo.collapse();
            return false;
        },

        changeBooleanByDblClick: function(propGrid, record, oldValue) {
            var newValue = !oldValue;
            propGrid.setProperty(record.id, newValue);
            propGrid.getCellEditor(record, 1).completeEdit();
        }
    });
}(BaseSvodView.prototype));

// ============= HIGHLIGHT ROWS =======================
(function (viewClass) {
    KS.apply(viewClass, {
        // подкраска строк по полю HIGHLIGHT . Добавляется к таблице через grid.AddListener("beforerender", "view.beforeGridRender");
        beforeGridRender: function(grid) {  
            var gridView = grid.getView();
            gridView.getRowClass = this.gridGetRowClass;
        },

        gridGetRowClass: function(record) {
            var highlight = KS.Grid.getAnyCase(record, 'HIGHLIGHT');
            if (record.previousValues && !record.previousValues.CHECKED
                && highlight !== '-1')
                return "";
            if (highlight && highlight !== '-1') {
                var selector = "link-setting-" + highlight;
                KS.registerCssStyles([{
                    Properties: {
                        "background-color" : convertToHexString(highlight)
                    },
                    Selector: "." + selector
                }]);
                return selector;
            }
            var linkSettings = KS.Grid.getAnyCase(record, 'link_setting');
            if (linkSettings) {
                return "link-setting-" + linkSettings;
            }
            return "";
        }        
    });
}(BaseSvodView.prototype));

// ============= HTMLEDITOR =======================
(function (viewClass) {
    KS.apply(viewClass, {
        afterRenderHtmlEditor: function(editor){
            if (editor && editor.getToolbar()) {
                var fontSelect = editor.getToolbar().getComponent("fontSelect");
                if (fontSelect && fontSelect.selectEl &&
                    fontSelect.selectEl.dom && fontSelect.selectEl.dom.options) {
                    // Пересоздаём первый элемент, убирая кавычки, чтобы не пропадал шрифт
                    var firstOption = fontSelect.selectEl.dom.options[0];
                    var font = firstOption.text.replace(/"/g, ''); // Исправления с исходников Ext 7.7.0 из метода initDefaultFont
                    var lower = font.toLowerCase();
                    var option = new Option(font, lower);
                    option.style.fontFamily = lower;
                    option.selected = true;
                    fontSelect.selectEl.dom.options[0] = option;

                    editor.defaultFont = font;
                }
            }
        }
    });
}(BaseSvodView.prototype));

// ============= RENDERERS =======================
function dictRenderer(value, metadata) {
    if (Ext.isString(value))
        setTooltip(metadata, value);
    metadata.css += ' sidewall-dict-cell';
    return value;
}

function dictKeyRenderer(value, metadata) {
    if (Ext.isString(value))
        setTooltip(metadata, value);
    return value;
}

function reportRenderer(value, metadata, record, rowIndex, colIndex, store) {
    var cp = store.grid.colModel.config[colIndex].tag;
    if (cp && cp.isError) {
        metadata.css += ' error-attribute-cell';
    } else if (cp && cp.isDiction) {
        metadata.css += ' sidewall-dict-cell';
    }
    return value;
}

function defaultLinkSettingRenderer(value, metadata, record) {
    var ls = KS.Grid.getAnyCase(record, 'LINK_SETTING');
    if (ls) metadata.css += ' link-setting-' + ls;
    return value;
}

function statusRendererInternal(value, metadata, record, textField, iconFields) {
    defaultLinkSettingRenderer(value, metadata, record);
    var linkTaskStatus;
    Ext.each(iconFields.split(','), function(iconField) {
        if (linkTaskStatus > 0) return;
        var s = KS.Grid.getAnyCase(record, iconField);
        if (s > 0) linkTaskStatus = s;
    });
    metadata.css += ' status-image status-' + linkTaskStatus;
    if (Ext.isIE) {
        return '<span class="indent-15px-ie">' + (KS.Grid.getAnyCase(record, textField) || '') + '</span>';
    } else {
        return '<span class="indent-15px">' + (KS.Grid.getAnyCase(record, textField) || '') + '</span>';
    }
}

function statusRenderer(value, metadata, record) {
    return statusRendererInternal(value, metadata, record, 'STATUS', 'LINK_STATUS,LINK_SAVED_FORM_STATUS');
}

function valuesListRenderer(value, metadata, record, rowIndex, colIndex, store) {
    var vl = store.grid.valueLists;
    if (vl) {
        var colCfg = store.grid.getColCfgByIndex(colIndex);
        if (!colCfg.vlItems && !Ext.isEmpty(colCfg.dataIndex)) {
            colCfg.vlItems = {};
            Ext.each(vl, function (vlEl) {
                if (vlEl.ColumnKey.toUpperCase() === colCfg.dataIndex.toUpperCase()) {
                    Ext.each(vlEl.Items, function (item) {
                        var img = item.ImageBase64String ? "<img src='data:image/png;base64," + item.ImageBase64String + "'/> " : "";
                        colCfg.vlItems[item.StringDataValue] = img + item.DisplayText;
                    });
                }
            });
        }
        return (colCfg.vlItems && colCfg.vlItems[value]) || value;
    }
    return value;
}

function tripleCheckboxRenderer(value, metadata) {
    if (metadata.column.dataIndex.toLowerCase().indexOf("read_only") !== -1) {
        metadata.css += " ks-cell-disabled";
    }
    switch (typeof (value)) {
        case 'boolean':
            value = value ? 1 : 0;
            break;
        case 'string':
            if (value === 0 || value === 1)
                value = +value;
            else if (value.toLowerCase() === 'false')
                value = 0;
            else if (value.toLowerCase() === 'true')
                value = 1;
            else
                value = 2;
        case 'number':
            value = (value >= 0 && value <= 2) ? value : 2;
            break;
        default:
            value = 2;
            break;
    }
    var icons = ['images/ks/fail.png', 'images/ks/success.png', 'images/checkbox/unchecked.gif'];
    return "<img width='12' height='12' src='" + icons[value] + "'/>";
}

function passwordRenderer(value) {
    var strLength = !Ext.isEmpty(value) ? value.length : 0;
    var newValue = "";
    for (var i = 0; i < strLength; i++) {
        newValue += "&#8226;";
    }
    return newValue;
}

// ============= EDITORS =======================

Ext.define('valuesListEditor',
    {
        extend: 'Ext.form.ComboBox',
        displayField: 'text',
        valueField: 'value',
        editable: false,
        constructor: function(cfg) {
            var grid = cfg.grid,
                view = grid.parentView,
                vl = grid.valueLists,
                comboData = [];
            var colCfg = cfg.col;
            if (!colCfg.vlItems) {
                colCfg.vlItems = {};
                Ext.each(vl, function (vlEl) {
                    if (vlEl.ColumnKey.toUpperCase() === colCfg.dataIndex.toUpperCase()) {
                        Ext.each(vlEl.Items, function (item) {
                            var img = item.ImageBase64String ? "<img src='data:image/png;base64," + item.ImageBase64String + "'/> " : "";
                            colCfg.vlItems[item.StringDataValue] = img + item.DisplayText;
                            comboData.push({"value" : item.StringDataValue,
                                "text" : item.DisplayText,
                                "image" : img});
                        });
                    }
                });
            }
            KS.apply(cfg, {
                comboData: comboData,
                parentView: view
            });

            cfg.store = Ext.create('Ext.data.Store', {
                fields: ['value', 'text', 'image'],
                data: comboData
            });
            
            cfg.tpl = '<tpl for=".">' +
            '<tpl if="image != \'\'">' +
            '<div class="x-boundlist-item">{image}{text}</div>' +
            '<tpl else>' +
            '<div class="x-boundlist-item">{text}</div>' +
            '</tpl></tpl>';

            window.valuesListEditor.superclass.constructor.call(this, cfg);
        }
    });

Ext.define('KS.cellDateEditor',
    {
        extend: 'KS.Ext.Grid.dateEditor',
        formatText: 'Формат даты дд.мм.гггг'
    });

Ext.define('KS.cellDateTimeEditor',
    {
        extend: 'Ext.form.FieldContainer',
        layout: 'hbox',
        items: [
            {
                xtype: 'datefield',
                name: 'date',
                itemId: 'dateComp',
                maskRe: /[0-9.]/,
                format: 'd.m.Y',
                formatText: "Формат даты дд.мм.гггг",
                flex: 1,
                listeners:{
                    // Изменение размеров едиторов при изменении ширины колонки
                    focus: function(comp){
                        var container = comp.ownerCt;
                        var editor = container ? container.ownerCt : null;
                        if (container && editor &&
                            editor.getWidth() != container.width)
                            container.setWidth("100%");
                    }
                }
            },
            {
                xtype: 'timefield',
                name: 'time',
                itemId: 'timeComp',
                maskRe: /[0-9:]/,
                formatText: 'Формат времени чч:мм:сс',
                format: 'H:i:s',
                increment: 30,
                flex: 1
            }
        ],

        setValue: function(value) {
            var me = this,
                dateComp = me.getComponent("dateComp"),
                timeComp = me.getComponent("timeComp");
            if (value) {
                var dateValue = value.split(" ")[0],
                    timeValue = value.split(" ")[1];
                dateComp.setValue(dateValue);
                timeComp.setValue(timeValue);
            }
        },

        getValue: function() {
            var me = this,
                dateComp = me.getComponent("dateComp"),
                timeComp = me.getComponent("timeComp"),
                dateValue = Ext.util.Format.date(dateComp.getValue(), 'd.m.Y'),
                timeValue = Ext.util.Format.date(timeComp.getValue(), 'H:i:s');
            return dateValue + " " + timeValue;
        },

        isValid: function() {
            var me = this,
                dateComp = me.getComponent("dateComp"),
                timeComp = me.getComponent("timeComp");
            if (!dateComp.isValid()) {                 // восстанавливаем старое значение
                dateComp.setValue(dateComp.value);     // если введено не подходящее
            }
            if (!timeComp.isValid()) {
                if (timeComp.selection) {
                    timeComp.setValue(timeComp.selection.get("disp"));
                }
            }
            return true;
        },

        resetOriginalValue: function() {}
    });

Ext.define('passwordEditor', 
    {
        extend: 'Ext.form.TextField',
        allowBlank: true,
        style: 'text-align:left',
        inputType: "password"
    });

function convertToHexString(number)
{
    if (Ext.isString(number)) 
        number = parseInt(number, 10);
    
    if (number < 0)
        number = 0xFFFFFF + number + 1;

    var hexStr = number.toString(16);
    while (hexStr.length < 6) {
        hexStr = "0" + hexStr;
    }

    return "#" + hexStr.toUpperCase();
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();