﻿// ============= VIEW =======================
BaseDictionaryView = KS.extend(BaseSvodView, { });

// ============= COMMON =======================
(function (viewClass) {
    KS.apply(viewClass, {
        onInit: function () {
            if (this.data.needToClose) {
                this.close();
            } else if (this.data.autoSelect) {
                this.select(true);
            } else {
                this.renderViewTemplate();
            }
        },

        onTemplateRendered: function () {
            if (this.data.showAsHtml) {
                var html = this.resolveViewId(this.data.html);
                this.htmlContainer.update(html);
            } else if (this.mainGrid) {
                this.mainGrid.getExcelAdditionals = this.getExcelAdditionals;
            }
            this.resetView();
        },

        resetView: function () {
            this.resetGrid();
            this.discardChanges();
        },

        onSetSavedState: function(saved) {
            if (Ext.isEmpty(this.mainGrid) || Ext.isEmpty(this.mainGrid.dockedItems)) return;
            var saveBtn = this.getToolbarItem(this.mainGrid, null, 'SAVE');
            if (saveBtn)
                saveBtn.setDisabled(saved);
        },

        hasSaveButton: function() {
            var saveBtn = this.getToolbarItem(this.mainGrid, null, 'SAVE');
            return saveBtn != null;
        },

        disable: function () {
            if (this.mainGrid) {
                this.mainGrid.disable();
            } else {
                this.containerPanel.disable();
            }
        },

        enable: function() {
            if (this.mainGrid) {
                this.mainGrid.enable();
                if (this.fieldsGrid && this.fieldsGrid.editingRec)
                    this.fieldsGrid.editingRec.commit();
            } else {
                this.containerPanel.enable();
            }
        },
        
        dataSourceChanged: function (combo, record) {
            var view = combo.parentView;
            view.serverCall({
                method: 'DataSourceChanged',
                params: [record.data.DATA_VALUE || 0],
                success: view.reload
            });
        },

        onValuesSelected: function (args) {
            if (Ext.isEmpty(args) || Ext.isEmpty(args[0])) return;
            var view = this, field;
            for (field in args[0][0]) {
                if (field === 'ACTION') {
                    var action = args[0][0][field];
                    switch(action) {
                        case 'RELOAD':
                            view.reload();
                            break;
                        case 'SET_ROW_VALUES':
                            var selVal = args[0][0],
                                grid = view[selVal['srvGridId']],
                                rec = grid.findRecord(selVal['srvCloseCode'], grid.closeCode.toLowerCase()) || 
                                    grid.findRecord(selVal['srvCloseCode'], grid.closeCode.toUpperCase());
                            var srvValuesDict = selVal['srvValuesDict'];
                            for (var c in srvValuesDict) {
                                if (srvValuesDict.hasOwnProperty(c)) {
                                    var val = srvValuesDict[c];
                                    if (Ext.isDefined(rec.get(c.toLowerCase()))) c = c.toLowerCase();
                                    if (Ext.isDefined(rec.get(c.toUpperCase()))) c = c.toUpperCase();
                                    rec.set(c, val);
                                }
                            }
                            break;
                        case 'RELOAD_GRID':
                            var gridToReload = view[args[0][0]['srvGridId']];
                            if (gridToReload) {
                                gridToReload.reload();
                            }
                            break;
                        default:
                            var ap = action.split(':'),
                                fn = ap[1];
                            if (ap[0] === 'js' && Ext.isFunction(view[fn]))
                                view[fn].call(this, args[0][0]);
                            break;
                    }
                } else if (field.indexOf("PRINT_URL") >= 0) {
                    var urlsArray = args[0][0][field];
                    Ext.each(urlsArray, function (url) {
                        view.openUrl(url);
                    });
                }
            }
        }
    });
}(BaseDictionaryView.prototype));

// ============= TOP TOOLBAR =======================
(function (viewClass) {
    var sc = BaseDictionaryView.superclass;

    function getCheckedCloseCodes(src) {
        var view;
        if (src.grid) {
            view = src.grid.parentView || src;
        } else {
            view = src.parentView || src;
        }
        var grid = view.isGrid(src) ? src : view.findOwnerContainer(src, view.isGrid);
        return (grid) ? grid.getCheckedCodes(true) : [];
    }

    KS.apply(viewClass, {
        printGridPropertyName: 'mainGrid',

        toolbarParentComponentName: 'mainGrid',

        processToolbarItemControl: function(ctrl, tbarItem, schema) {
            if (tbarItem.nodeStyle === 4 && schema) {
                switch (schema.TYPE) {
                case 'DATETIMEEDITOR':
                    ctrl = new Ext.form.DateField({
                        format: 'd.m.Y',
                        editable: false,
                        enableKeyEvents: false,
                        value: KS.parseAjaxDateTime(this.data.date)
                    });
                    ctrl.on('change', this.dateChanged, this);
                    return ctrl;
                }
            }
            if (this.isRouteAgreementList()) {
                if (tbarItem.code === 'AutoFilterContainer') {
                    ctrl.on('change', this.setAutoFilter, this);
                    return ctrl;
                }
            }
            return sc.processToolbarItemControl.apply(this, arguments);
        },

        setAutoFilter: function (cb, set) {
            this.serverCall({
                method: 'SetAutoFilter',
                params: [set],
                waitMessage: 'Фильтрация ...',
                success: this.resetGrid
            });
        },

        getTbarClickHandler: function(tbarItem) {
            switch (tbarItem.code) {
                case 'NEW':
                    return this.newHandler;

                case 'EDIT':
                    return this.editHandler;

                case 'COPY':
                    return this.copyHandler;

                case 'DELETE':
                case 'DELETE_MENU':
                    return this.deleteHandler;

                case 'EXPORT':
                    return this.exportHandler;

                case 'IMPORT':
                    return this.importHandler;

                case "LOAD":
                    return this.loadHandler;

                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        },

        buildAutoFilterControlItem: function() {
            return null;
        },

        backgroundOperation: function (code, single, waitMsg, objectLinks, additional) {
            if (Ext.isEmpty(code)) return;
            if (!Ext.isDefined(objectLinks)) {
                objectLinks = this.mainGrid.getCheckedCodes(true);
            }
            this.serverCall({
                method: 'OnBackgroundOperation',
                params: [code, objectLinks, additional || this.getAdditionalBkgrParams(code)],
                waitMessage: (waitMsg || 'Ожидайте') + ' ...'
            });
        },

        getAdditionalBkgrParams: function() {
            return {};
        },

        dateChanged: function(df, newValue) {
            this.serverCall({
                method: 'SetDate',
                params: [newValue],
                waitMessage: 'Установка даты ...',
                success: this.reload
            });
        },

        newHandler: function() {
            var view = this.parentView || this;
            view.tryExecuteSvodTask(0, 'NEW', null, view.addRecordCallback);
        },

        addRecordCallback: function(result) {
            if (result) {
                this.resetGrid();
                if (this.hasSaveButton())
                    this.touch();
            }
        },

        editHandler: function() {
            var ccc = getCheckedCloseCodes(this);
            if (Ext.isEmpty(ccc)) return;
            var view = this.parentView || this;
            view.tryExecuteSvodTask(0, 'EDIT');
        },

        copyHandler: function() {
            var ccc = getCheckedCloseCodes(this);
            if (Ext.isEmpty(ccc)) return;
            var view = this.parentView || this;
            view.tryExecuteSvodTask(0, 'COPY', null, view.addRecordCallback);
        },

        deleteConfirmMsg: 'Удалить выделенные строки?',

        deleteHandler: function() {
            var ccc = getCheckedCloseCodes(this);
            if (Ext.isEmpty(ccc)) return;
            var view = this.parentView || this;
            KS.confirm(view.deleteConfirmMsg, "Подтвердите удаление", function (btn) {
                if (btn === 'yes')
                    view.deleteHandlerInternal(ccc);
            });
        },

        deleteHandlerInternal: function (ccc) {
            if (this.data.deleteByTask) {
                this.tryExecuteSvodTask(0, 'DELETE', null, this.resetGrid);
            } else {
                var autoSave = this.getToolbarItem(this[this.toolbarParentComponentName], null, 'SAVE') == null;
                var view = this;
                this.serverCall({
                    method: 'DeleteRows',
                    params: [ccc, autoSave],
                    waitMessage: 'Удаление ...',
                    success: function(deleted) {
                        view.deleteCallback(deleted, autoSave);
                    }
                });
            }
        },

        deleteCallback: function(deleted, autoSave) {
            if (deleted) {
                this.resetGrid();
                if (!autoSave)
                    this.touch();
            }
        },

        getExcelAdditionals: function() {
            var ccc = '';
            Ext.each(this.getCheckedCodes(),
                function(cc) {
                    ccc += "'" + cc + "',";
                });
            return {
                'checkedCodes': ccc
            }
        },
        
        exportHandler: function() {
            this.parentView.tryExecuteSvodTask(0, 'EXPORT');
        },

        importHandler: function() {
            this.parentView.tryExecuteSvodTask(0, 'IMPORT');
        },

        loadHandler: function () {
            this.parentView.tryExecuteSvodTask(0, "LOAD");
        }
    });
}(BaseDictionaryView.prototype));

// ============= BOTTOM TOOLBAR =======================
(function (viewClass) {
    KS.apply(viewClass, {
        select: function (auto) {
            var view = this.parentView || this,
                grid = view.mainGrid,
                ccc = [],
                nodes = [];
            if (auto !== true) {
                ccc = grid.getCheckedCodes(true).concat(grid.checkedCodes);
                nodes = view.getCheckedNodes();
                if (Ext.isEmpty(ccc) && Ext.isEmpty(nodes)) return;
            }
            view.disable();
            view.serverCall({
                method: 'EndSelection',
                params: [ccc, nodes, view.getAdditionalParams()],
                success: function (ok) {
                    if (ok) {
                        view.destroyContainerItems();
                    } else {
                        view.enable();
                    }
                },
                error: view.enable
            });
        },

        getCheckedNodes: function() {
            return [];
        },

        getAdditionalParams: function () {
            return this.collectContainerItemsValues();
        }
    });
}(BaseDictionaryView.prototype));

// ============= GRID =======================
(function(viewClass) {
    KS.apply(viewClass, {
        rowDblClickHandler: function(gridView, record, element, rowIndex, e) {
            if (this.data.isSelecting) {
                this.select();
            } else if (e.position.column.renderer === dictRenderer) {
                this.tryExecuteSvodTask(6, e.position.column.dataIndex, null);
                return false;
            } else if (e.position.column.aspType && e.position.column.aspType.indexOf("show_protocol") >= 0) {
                this.showCellValueInProtocol(KS.Grid.getAnyCase(record, gridView.grid.closeCode), e.position.column.dataIndex);
                return false;
            } else {
                this.execGridRowDoubleClickedTask(gridView.grid || gridView);
            }
            return true;
        },

        execGridRowDoubleClickedTask: function(grid) {
            this.tryExecuteSvodTask(2,
                'BaseGrid',
                null,
                function(resolved) {
                    if (!resolved)
                        this.editHandler.apply(grid);
                });
        },

        cellDblClickHandler: function() {
        },

        resetGrid: function(jsonData) {
            if (!this.data.showAsHtml && !Ext.isEmpty(this.mainGrid)) {
                if (Ext.isString(jsonData)) {
                    this.mainGrid.jsonData = jsonData;
                } else if (this.mainGrid.enablePaging === false) {
                    this.mainGrid.reload();

                    if (this.isRouteAgreementList()) {
                        var myRoute = this.getToolbarItem(this.mainGrid, 'top', 'AutoFilterContainer').getValue();
                        this.setAutoFilter(null, myRoute);
                    }
                    return;
                }
                this.mainGrid.resetGrid();
                this.showMainGridRowsCount();
            }
        },

        getMarkableGrid: function () {
            return this.mainGrid;
        },

        showMainGridRowsCount: function() {
            if (this.mainGrid.enablePaging) return;
            var topTbar = this.getToolbar(this.mainGrid);
            if (topTbar && KS.isFunction(topTbar.add)) {
                if (!topTbar.getComponent("countLbl")) {
                    topTbar.add('->',
                        {
                            xtype: 'tbtext',
                            itemId: 'countLbl'
                        });
                }
                var count,
                    store = this.mainGrid.getStore();
                if (store.count) {
                    count = store.count();
                } else {
                    count = store.getTotalCount();
                }
                topTbar.getComponent("countLbl").setText('Строк: ' + count);
            }
        },

        buildChosenRows: function(grid, includeSelected) {
            var view = this,
                recs = grid.getCheckedRows(includeSelected !== false),
                active = grid.getSelectedRows(),
                rows = [];
            Ext.each(recs,
                function(rec) {
                    var rowDict = view.buildRowDictionary(rec, active);
                    if (rowDict) rows.push(rowDict);
                });
            return rows;
        },

        buildRowDictionary: function(rec, active) {
            var dict = {},
                grid = rec.store.grid;
            if (!Ext.isEmpty(grid.closeCode) && !Ext.isEmpty(grid.ctrlId)) {
                dict['ctrlId'] = grid.ctrlId;
                dict[grid.closeCode] = grid.getCloseCode(rec);
            }
            if ($.inArray(rec, active) >= 0) dict['isActive'] = true;
            return dict;
        },

        editGridCell: function(plugin, context) {
            if (context.field.toUpperCase() !== 'CHECKED')
                this.touch();
        },

        showCellValueInProtocol: function(closeCode, dataIndex) {
            this.serverCall({
                method: 'ShowCellValueInProtocol',
                params: [closeCode, dataIndex],
                disableFog: true
            });
        },
        
        addLockedGridFilterFunctions: function(grid){
            grid = grid ? grid : this.mainGrid;
            grid.getFilter = this.getFilter;
            grid.setLockedGridFilterVisible = this.setLockedGridFilterVisible;
            grid.removeLockedGridFilter = this.removeLockedGridFilter;
        },

        getFilter: function(grid) {
            var me = grid || this;
            if (!Ext.isEmpty(me.lockedGrid) &&  //В гриде с локидом учитывать оба фильтра
                !Ext.isEmpty(me.normalGrid) ) {
                var mainFilter = "";
                if (!KS.isEmpty(me.lockedGrid.filter) &&
                    !KS.isEmpty(me.lockedGrid.filter.asString) &&
                    me.lockedGrid.filter.asString !== "[]") {
                    mainFilter += me.lockedGrid.filter.asString;
                }
                if (!KS.isEmpty(me.normalGrid.filter) &&
                    !KS.isEmpty(me.normalGrid.filter.asString) &&
                    me.normalGrid.filter.asString !== "[]") {
                    mainFilter +=  me.normalGrid.filter.asString;
                }
                if (!KS.isEmpty(me.lockedGrid.filter) ||
                    !KS.isEmpty(me.normalGrid.filter)) {
                    if (!me.filter) {
                        me.filter = {};
                    }
                    if (KS.isEmpty(mainFilter)) {
                        mainFilter = "[]";
                    } else {
                        mainFilter = mainFilter.replace(/\]\[/g, ",");
                    }
                    me.filter.asString = mainFilter;
                }
            } else if (me.hasOwnProperty("isLocked")) {
                return me.ownerCt.getFilter();
            }

            if (!me.filter) return '[]';
            if (me.filter.asString) return me.filter.asString;

            var res = [];
            Ext.each(me.filter,
                function(el) {
                    if (el.Condition !== null && el.Condition !== -1 && el.Value !== null) {
                        res.push({
                            Name: el.Name,
                            Condition: el.Condition,
                            Value: me.getFilterValue(el)
                        });
                    }
                });

            return me.filter.asString = JSON.stringify(res);
        },

        setLockedGridFilterVisible: function(isVisible){
            if (!Ext.isEmpty(this.normalGrid)) {
                var normalFilterBar = this.normalGrid.ksObjs.filterBar;
                normalFilterBar.setVisible(isVisible || !normalFilterBar.isVisible());
            }
            if (!Ext.isEmpty(this.lockedGrid)) {
                var lockedFilterBar = this.lockedGrid.ksObjs.filterBar;
                lockedFilterBar.setVisible(isVisible || !lockedFilterBar.isVisible());
            }
        },

        removeLockedGridFilter: function(columns){
            var grid = this,
                store = grid.getStore();

            var removeChildGridFilter = function(childGrid, childColumn){
                var childFilterFeature = childGrid.getView().filterFeature;
                var childGridColumns = childGrid.getColumns();
                // Удаляем либо 1 фильтр, либо все
                if (childColumn) {
                    if (!KS.isEmpty(childGrid.filter) &&
                        !KS.isEmpty(childGrid.filter.asString) &&
                        childGrid.filter.asString !== "[]" &&
                        childGridColumns.indexOf(childColumn) !== -1) {
                        var filters = JSON.parse(childGrid.filter.asString),
                            filtersByIndex = {};

                        for (var i = 0; i < filters.length; i++)
                            filtersByIndex[filters[i].Name] = i;

                        childFilterFeature.removeFilter(childColumn);
                        filters.splice(filtersByIndex[childColumn.dataIndex], 1);

                        Ext.apply(childGrid.filter, {
                            asString: JSON.stringify(filters)
                        });
                    }
                } else {
                    for (var i = 0; i < childGridColumns.length; i++)
                        childFilterFeature.removeFilter(childGridColumns[i]);

                    delete childGrid.filter;
                }
            }

            if (!Ext.isEmpty(this.normalGrid))
                removeChildGridFilter(this.normalGrid, columns);
            if (!Ext.isEmpty(this.lockedGrid))
                removeChildGridFilter(this.lockedGrid, columns);

            if (!columns) {
                delete grid.filter;
                store.getFilters().removeAll();
            }

            grid.setSBText(grid.getSelectionModel().getSelection().length, grid.checkedCodes ? grid.checkedCodes.length : 0, false);

            if (grid.ctrl.filterMode > 1)
                store.loadPageFromServerTemplate(1);
        }
});
}(BaseDictionaryView.prototype));

// ============= ROUTEAGREEMENTLIST =======================
(function(viewClass) {
    KS.apply(viewClass, {
        isRouteAgreementList: function() {
            return !!(this.containerPanel && this.containerPanel.title === "Маршрут согласования");            
        }
    });
}(BaseDictionaryView.prototype));

// ============= RENDERERS =======================
function parentRowRenderer(value, metadata, record) {
    if (KS.Grid.getAnyCase(record, 'IS_PARENT_ROW'))
        metadata.css += ' parent-row-cell';
    return value;
}

function baseDictionaryHyperLinkRenderer(value, metadata, record, rowIndex, colIndex, store) {
    var grid = store.grid,
        gridId = grid.ctrlId || '',
        colDesc = grid.getColCfgByIndex(colIndex);
    return '<a href="' + rowIndex + '_' + colDesc.dataIndex + '" class="like-hypertext" ' +
        'onclick="KS.Svod.processTemplateHyperLink(event,' +
        "'" + grid.parentView.viewID + "','" + gridId + "','" + colDesc.dataIndex + "','" + grid.getCloseCode(record) + "'" +
        ');return false;"/>' + value + '</a>';
}

function tooltipRenderer(value, metadata) {
    setTooltip(metadata, value);
    return value;
}

// ============= OTHER =======================

//Выделение текста при старте редактирования ячейки
function selectTextInEditor (start, end, direction) {
    var me = this;
    start = 0;
    Ext.defer(function() {
        if (me.isKeyDown === true && me.value) {
            start = me.value.length;
            end = start;
        }
        if (!me.destroyed && me.inputEl.isVisible(true)) {
            me.inputEl.selectText(start, end, direction);
        }
        me.isKeyDown = false;
    }, Ext.isIE ? 10 : 0);
    return me;
}


if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();