﻿(function() {
    Ext.define('KS.Ext.SpreadsheetFrame', {
        extend: 'Ext.panel.Panel',

        alias: 'spreadsheet.frame',

        loadMask: 'Загрузка...',

        spreadsheet: null,

        iframeHtml: null,

        parentView: null,

        listeners: {
            documentchanged: 'onDocumentChanged',
            cellendedit: 'onCellEndEdit'
        },

        constructor: function(cfg, ctrl) {
            var spreadsheetFrame = this;

            spreadsheetFrame.ksObjs = {};
            KS.apply(spreadsheetFrame,
                KS.apply(cfg || {}, ctrl ? ctrl.json : null),
                {
                    isTpl: true,
                    plugins: []
                });

            if (spreadsheetFrame.layout === 'box') {
                spreadsheetFrame.layout = {
                    type: 'box',
                    pack: 'center',
                    align: 'center'
                };
            }

            if (ctrl && ctrl.ui) {
                spreadsheetFrame.ui = ctrl.ui;
            }

            KS.Ext.SpreadsheetFrame.superclass.constructor.call(spreadsheetFrame);
        },

        controller: {
            onDocumentChanged: function (s, e) {
                var me = this.view;

                if (me.parentView && me.parentView.onSpreadsheetDocumentChanged)
                    me.parentView.onSpreadsheetDocumentChanged(s, e);
            },

            onCellEndEdit: function (s, e) {
                var me = this.view;

                if (me.parentView && me.parentView.onSpreadsheetCellEndEdit)
                    me.parentView.onSpreadsheetCellEndEdit(s, e);
            },
        },

        initComponent: function () {
            this.callParent();
        },

        beforeDestroy: function () {
            this.closeSession();
        },

        initSpreadsheet: function (spreadsheet, parentView) {
            this.spreadsheet = spreadsheet;
            this.parentView = parentView;
            this.iframeHtml = document.getElementById('spreadsheet_frame');
        },

        setSrc: function (src) {
            var me = this;
            me.iframeHtml.src = src;
        },

        reloadFrame: function () {
            if (this.iframeHtml)
                this.iframeHtml.contentWindow.location.reload(true);
        },

        saveDocument: function (callback, context) {
            var me = this;
            console.error('Not implemented method!');
        },

        saveDocumentCopy: function (tempFileKey, callback, context) {
            var me = this;
            console.error('Not implemented method!');
        },

        downloadFile: function () {
            var me = this;
            console.error('Not implemented method!');
        },

        closeSession: function () {
            var me = this;
            if (!me.spreadsheet) return; // todo: в модальных окнах spreadsheet при beforeDestroy будет null
            console.error('Not implemented method!');
        }
    });

    function createSpreadsheetFrame(ctrl, cfg) {
        KS.apply(cfg,
            {
                ctrl: ctrl
            });
        var spreadsheetFrame = new KS.Svod.SpreadsheetFrame(ctrl, cfg);
        KS.Ext.setTemplateListeners(spreadsheetFrame, ctrl.listeners, ctrl.parentView);
        return spreadsheetFrame;
    }

    KS.Ext.registerControlRenderer('spreadsheetFrame', createSpreadsheetFrame);
})();