﻿(function() {
    Ext.define('KS.Ext.SpreadsheetFrame', {
        extend: 'Ext.panel.Panel',

        alias: 'spreadsheet.frame',

        loadMask: 'Загрузка...',

        spreadsheet: null,

        iframeHtml: null,

        parentView: null,

        listeners: {
            documentchanged: 'onDocumentChanged',
            selectionchanged: 'onSelectionChanged',
            cellendedit: 'onCellEndEdit'
        },

        constructor: function(cfg, ctrl) {
            var spreadsheetFrame = this;

            spreadsheetFrame.ksObjs = {};
            KS.apply(spreadsheetFrame,
                KS.apply(cfg || {}, ctrl ? ctrl.json : null),
                {
                    isTpl: true,
                    plugins: []
                });

            if (spreadsheetFrame.layout === 'box') {
                spreadsheetFrame.layout = {
                    type: 'box',
                    pack: 'center',
                    align: 'center'
                };
            }

            if (ctrl && ctrl.ui) {
                spreadsheetFrame.ui = ctrl.ui;
            }

            KS.Ext.SpreadsheetFrame.superclass.constructor.call(spreadsheetFrame);
        },

        controller: {
            onDocumentChanged: function (s, e) {
                var me = this.view;

                if (me.parentView && me.parentView.onSpreadsheetDocumentChanged)
                    me.parentView.onSpreadsheetDocumentChanged(s, e);
            },

            onSelectionChanged: function (s, e) {
                var me = this.view;

                if (me.parentView && me.parentView.onSpreadsheetSelectionChanged)
                    me.parentView.onSpreadsheetSelectionChanged(s, e);
            },

            onCellEndEdit: function (s, e) {
                var me = this.view;

                if (me.parentView && me.parentView.onSpreadsheetCellEndEdit)
                    me.parentView.onSpreadsheetCellEndEdit(s, e);
            },
        },

        initComponent: function () {
            this.callParent();
        },

        beforeDestroy: function () {
            this.closeSession();
        },

        initSpreadsheet: function (spreadsheet, parentView) {
            this.spreadsheet = spreadsheet;
            this.parentView = parentView;
            this.iframeHtml = document.getElementById('spreadsheet_frame');
            if (this.body)
                this.body.unmask();

            if (parentView.getFormulaBar) {
                this.addFormulaBar(spreadsheet, parentView.getFormulaBar.bind(parentView));
            }
        },

        addFormulaBar: function (spreadsheet, getFormulaBar) {
            spreadsheet.GetActiveCellPosition = function () {
                var paneManager = this.getPaneManager(),
                    selectionInternal = this.getSelectionInternal(),
                    internalSelectionWithModelIndices = selectionInternal.getConvertedToModelIndices(paneManager);
                return {
                    column: internalSelectionWithModelIndices.activeCellColIndex,
                    row: internalSelectionWithModelIndices.activeCellRowIndex
                };
            }.bind(spreadsheet);

            spreadsheet.GetActiveCellFormula = function () {
                var position = this.GetActiveCellPosition();
                return this.getPaneManager().getCellEditingText(position.column, position.row);
            }.bind(spreadsheet);

            var formulaBarHtml = getFormulaBar().getEl().dom;
            formulaBarHtml.addEventListener("keyup", function(event) {
                if (event.key === "Enter")
                    spreadsheet.focus();
            });
            formulaBarHtml.addEventListener("focusin", function() {
                spreadsheet.formulaBarCellPosition = spreadsheet.GetActiveCellPosition();
            });
            formulaBarHtml.addEventListener("focusout", function() {
                var position = spreadsheet.formulaBarCellPosition;
                if (position) {
                    spreadsheet.SetCellValue(position.column, position.row, getFormulaBar().getValue());
                    spreadsheet.formulaBarCellPosition = undefined;
                }
            });
        },

        setSrc: function (src) {
            var me = this;
            if (me.body)
                me.body.mask(me.loadMask);
            me.iframeHtml.src = src;
        },

        reloadFrame: function () {
            if (this.iframeHtml)
                this.iframeHtml.contentWindow.location.reload(true);
        },

        saveDocument: function (callback, context) {
            var me = this;
            var spreadsheetState = me.spreadsheet.getSpreadsheetState();
            $.ajax({
                type: 'POST',
                url: 'Devexpress/SaveDocument',
                data: { spreadsheetState: spreadsheetState },
                success: function () {
                    if (typeof callback === 'function')
                        callback.call(context || me, arguments);
                }
            });
        },

        saveDocumentCopy: function (tempFileKey, callback, context) {
            var me = this;
            var spreadsheetState = me.spreadsheet.getSpreadsheetState();
            $.ajax({
                type: 'POST',
                url: 'Devexpress/SaveDocumentCopy',
                data: {
                    spreadsheetState: spreadsheetState,
                    tempFileKey: tempFileKey
                },
                success: function () {
                    if (typeof callback === 'function')
                        callback.call(context || me);
                }
            });
        },

        downloadFile: function () {
            var me = this;
            var spreadsheetState = me.spreadsheet.getSpreadsheetState();
            $.ajax({
                type: 'POST',
                url: 'Devexpress/GetDownloadUrl',
                data: { spreadsheetState: spreadsheetState },
                success: function (downloadUrl) {
                    window.open(downloadUrl);
                }
            });
        },

        closeSession: function () {
            var me = this;
            if (!me.spreadsheet) return; // todo: в модальных окнах spreadsheet при beforeDestroy будет null
            var spreadsheetState = me.spreadsheet.getSpreadsheetState();
            $.ajax({
                type: 'POST',
                url: 'Devexpress/CloseSession',
                data: { spreadsheetState: spreadsheetState }
            });
        }
    });

    function createSpreadsheetFrame(ctrl, cfg) {
        KS.apply(cfg,
            {
                ctrl: ctrl
            });
        var spreadsheetFrame = new KS.Svod.SpreadsheetFrame(ctrl, cfg);
        KS.Ext.setTemplateListeners(spreadsheetFrame, ctrl.listeners, ctrl.parentView);
        return spreadsheetFrame;
    }

    KS.Ext.registerControlRenderer('spreadsheetFrame', createSpreadsheetFrame);
})();