/*!
* DevExtreme (dx.messages.ru.js)
* Version: 19.2.4
* Build date: Tue Nov 19 2019
*
* Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define(function(require) {
            factory(require("devextreme/localization"))
        })
    } else {
        if ("object" === typeof module && module.exports) {
            factory(require("devextreme/localization"))
        } else {
            factory(DevExpress.localization)
        }
    }
}(this, function(localization) {
    localization.loadMessages({
ru: {
  "OfficeStringId.Caption_EditHyperlinkForm": "Изменение гиперссылки",
  "OfficeStringId.Caption_EditHyperlinkFormDescription": " ",
  "OfficeStringId.Caption_InsertHyperlinkForm": "Вставка гиперссылки",
  "OfficeStringId.Caption_InsertHyperlinkFormDescription": " ",
  "OfficeStringId.Caption_UnitCentimeters": "Сантиметры",
  "OfficeStringId.Caption_UnitInches": "Дюймы",
  "OfficeStringId.Caption_UnitMillimeters": "Миллиметры",
  "OfficeStringId.Caption_UnitPercent": "Процент",
  "OfficeStringId.Caption_UnitPoints": "Пункты",
  "OfficeStringId.FileFilterDescription_AllFiles": "Все файлы",
  "OfficeStringId.FileFilterDescription_AllSupportedFiles": "Все поддерживаемые файлы",
  "OfficeStringId.FileFilterDescription_BitmapFiles": "Точечный рисунок Windows",
  "OfficeStringId.FileFilterDescription_EmfFiles": "Расширенный метафайл Windows",
  "OfficeStringId.FileFilterDescription_GifFiles": "Формат GIF",
  "OfficeStringId.FileFilterDescription_JPEGFiles": "Формат JPEG",
  "OfficeStringId.FileFilterDescription_PNGFiles": "Формат PNG",
  "OfficeStringId.FileFilterDescription_TiffFiles": "Теговый формат изображения",
  "OfficeStringId.FileFilterDescription_WmfFiles": "Метафайл Windows",
  "OfficeStringId.MenuCmd_AlignmentCenter": "По центру",
  "OfficeStringId.MenuCmd_AlignmentCenterDescription": "Выравнивание текста по центру.",
  "OfficeStringId.MenuCmd_AlignmentJustify": "По ширине",
  "OfficeStringId.MenuCmd_AlignmentJustifyDescription": "Выравнивание текста одновременно по левому и правому полям за счет добавления дополнительных интервалов между словами там, где это необходимо.\n    \nТекст распределяется равномерно между левым и правым краями страницы.",
  "OfficeStringId.MenuCmd_AlignmentLeft": "По левому краю",
  "OfficeStringId.MenuCmd_AlignmentLeftDescription": "Выравнивание текста по левому краю.",
  "OfficeStringId.MenuCmd_AlignmentRight": "По правому краю",
  "OfficeStringId.MenuCmd_AlignmentRightDescription": "Выравнивание текста по правому краю.",
  "OfficeStringId.MenuCmd_ChangeFontColor": "Цвет текста",
  "OfficeStringId.MenuCmd_ChangeFontColorDescription": "Изменение цвета текста.",
  "OfficeStringId.MenuCmd_ChangeFontName": "Шрифт",
  "OfficeStringId.MenuCmd_ChangeFontNameDescription": "Изменение шрифта.",
  "OfficeStringId.MenuCmd_ChangeFontSize": "Размер шрифта",
  "OfficeStringId.MenuCmd_ChangeFontSizeDescription": "Изменение размера шрифта.",
  "OfficeStringId.MenuCmd_ClearUndo": "Очистить буфер ввода",
  "OfficeStringId.MenuCmd_ClearUndoDescription": "Очищение буфера ввода.",
  "OfficeStringId.MenuCmd_CopySelection": "Копировать",
  "OfficeStringId.MenuCmd_CopySelectionDescription": "Копирование выделенного фрагмента в буфер обмена.",
  "OfficeStringId.MenuCmd_CutSelection": "Вырезать",
  "OfficeStringId.MenuCmd_CutSelectionDescription": "Удаление выделенного фрагмента из документа в буфер обмена.",
  "OfficeStringId.MenuCmd_DecreaseFontSize": "Уменьшить размер шрифта",
  "OfficeStringId.MenuCmd_DecreaseFontSizeDescription": "Уменьшение размер шрифта.",
  "OfficeStringId.MenuCmd_DeleteComment": "Удалить примечание",
  "OfficeStringId.MenuCmd_DeleteCommentDescription": "Удаление выделенного примечания.",
  "OfficeStringId.MenuCmd_EditComment": "Изменить примечание",
  "OfficeStringId.MenuCmd_EditCommentDescription": "Изменение выделенного примечания.",
  "OfficeStringId.MenuCmd_EditHyperlink": "Изменить гиперссылку...",
  "OfficeStringId.MenuCmd_EditHyperlinkDescription": "Изменение гиперссылки.",
  "OfficeStringId.MenuCmd_Encrypt": "Зашифровать с использованием пароля",
  "OfficeStringId.MenuCmd_EncryptDescription": "Настройка пароля, который требуется для открытия данной книги.",
  "OfficeStringId.MenuCmd_FloatingObjectBringForward": "Переместить вперед",
  "OfficeStringId.MenuCmd_FloatingObjectBringForwardCommandGroup": "Переместить вперед",
  "OfficeStringId.MenuCmd_FloatingObjectBringForwardCommandGroupDescription": "Принести вперед на один уровень выбранного объекта, или принести его перед всеми другими объектами.",
  "OfficeStringId.MenuCmd_FloatingObjectBringForwardDescription": "Принесите выбранный объект вперед так, что оно скрыто меньшее количество объектов, которые находятся напротив него.",
  "OfficeStringId.MenuCmd_FloatingObjectBringToFront": "На передний план",
  "OfficeStringId.MenuCmd_FloatingObjectBringToFrontDescription": "Приведения выбранного объекта перед всеми другими объектами таким образом, чтобы никакая часть его скрыта за другими объектами.",
  "OfficeStringId.MenuCmd_FloatingObjectSendBackward": "Переместить назад",
  "OfficeStringId.MenuCmd_FloatingObjectSendBackwardCommandGroup": "Переместить назад",
  "OfficeStringId.MenuCmd_FloatingObjectSendBackwardCommandGroupDescription": "Отправить обратно один уровень выбранного объекта, или отправить его позади всех остальных объектов.",
  "OfficeStringId.MenuCmd_FloatingObjectSendBackwardDescription": "Перемещение выделенного объекта обратно, так что он скрыт объектами, которые находятся напротив него.",
  "OfficeStringId.MenuCmd_FloatingObjectSendToBack": "На задний план",
  "OfficeStringId.MenuCmd_FloatingObjectSendToBackDescription": "Отправить выбранный объект позади всех остальных объектов.",
  "OfficeStringId.MenuCmd_Hyperlink": "Гиперссылка",
  "OfficeStringId.MenuCmd_HyperlinkDescription": "Создание ссылки на веб-страницу, рисунок, адрес электронной почты или программу.",
  "OfficeStringId.MenuCmd_IncreaseFontSize": "Увеличить размер шрифта",
  "OfficeStringId.MenuCmd_IncreaseFontSizeDescription": "Увеличение размера шрифта.",
  "OfficeStringId.MenuCmd_InsertComment": "Создать примечание",
  "OfficeStringId.MenuCmd_InsertCommentDescription": "Добавление примечания к текущей части документа.",
  "OfficeStringId.MenuCmd_InsertFloatingObjectPicture": "Рисунок",
  "OfficeStringId.MenuCmd_InsertFloatingObjectPictureDescription": "Вставка рисунка из файла.",
  "OfficeStringId.MenuCmd_InsertHyperlink": "Гиперссылка...",
  "OfficeStringId.MenuCmd_InsertHyperlinkDescription": "Добавление новой гиперссылки.",
  "OfficeStringId.MenuCmd_InsertSymbol": "Символ",
  "OfficeStringId.MenuCmd_InsertSymbolDescription": "Вставить символы, которые находятся не на клавиатуре, например символов авторского права, товарного знака, пункт знаков и символов Юникода.",
  "OfficeStringId.MenuCmd_LoadDocument": "Открыть",
  "OfficeStringId.MenuCmd_LoadDocumentDescription": "Открытие документа.",
  "OfficeStringId.MenuCmd_NewEmptyDocument": "Создать",
  "OfficeStringId.MenuCmd_NewEmptyDocumentDescription": "Создание нового документа.",
  "OfficeStringId.MenuCmd_OpenHyperlink": "Открыть гиперссылку",
  "OfficeStringId.MenuCmd_OpenHyperlinkDescription": "Открытие гиперссылки.",
  "OfficeStringId.MenuCmd_PageMarginsModerate": "Средние поля\nВерхнее:\t{1,10}\tНижнее:\t{3,10}\nЛевое:\t{0,10}\tПравое:\t{2,10}",
  "OfficeStringId.MenuCmd_PageMarginsModerateDescription": " ",
  "OfficeStringId.MenuCmd_PageMarginsNarrow": "Узкие поля\nВерхнее:\t{1,10}\tНижнее:\t{3,10}\nЛевое:\t{0,10}\tПравое:\t{2,10}",
  "OfficeStringId.MenuCmd_PageMarginsNarrowDescription": " ",
  "OfficeStringId.MenuCmd_PageMarginsNormal": "Обычные поля\nВерхнее:\t{1,10}\tНижнее:\t{3,10}\nЛевое:\t{0,10}\tПравое:\t{2,10}",
  "OfficeStringId.MenuCmd_PageMarginsNormalDescription": " ",
  "OfficeStringId.MenuCmd_PageMarginsWide": "Широкие поля\nВерхнее:\t{1,10}\tНижнее:\t{3,10}\nЛевое:\t{0,10}\tПравое:\t{2,10}",
  "OfficeStringId.MenuCmd_PageMarginsWideDescription": " ",
  "OfficeStringId.MenuCmd_PageOrientationCommandGroup": "Ориентация",
  "OfficeStringId.MenuCmd_PageOrientationCommandGroupDescription": "Выбор книжной или альбомной ориентации страниц.",
  "OfficeStringId.MenuCmd_PageOrientationLandscape": "Альбомная",
  "OfficeStringId.MenuCmd_PageOrientationLandscapeDescription": "Альбомная ориентация.",
  "OfficeStringId.MenuCmd_PageOrientationPortrait": "Книжная",
  "OfficeStringId.MenuCmd_PageOrientationPortraitDescription": "Книжная ориентация.",
  "OfficeStringId.MenuCmd_Paste": "Вставить",
  "OfficeStringId.MenuCmd_PasteDescription": "Вставка содержимого буфера обмена.",
  "OfficeStringId.MenuCmd_Print": "Печать",
  "OfficeStringId.MenuCmd_PrintDescription": "Выбор принтера, числа копий и других параметров печати перед печатью.",
  "OfficeStringId.MenuCmd_PrintPreview": "Предварительный просмотр",
  "OfficeStringId.MenuCmd_PrintPreviewDescription": "Предварительный просмотр страниц перед печатью.",
  "OfficeStringId.MenuCmd_QuickPrint": "Быстрая печать",
  "OfficeStringId.MenuCmd_QuickPrintDescription": "Отправка документа на используемый по умолчанию принтер без внесения изменений.",
  "OfficeStringId.MenuCmd_Redo": "Вернуть",
  "OfficeStringId.MenuCmd_RedoDescription": "Возврат последнего отмененного действия.",
  "OfficeStringId.MenuCmd_RemoveHyperlink": "Удалить гиперссылку",
  "OfficeStringId.MenuCmd_RemoveHyperlinkDescription": "Удаление гиперссылки.",
  "OfficeStringId.MenuCmd_RemoveHyperlinks": "Удалить гиперссылки",
  "OfficeStringId.MenuCmd_RemoveHyperlinksDescription": "Удаление гиперссылок.",
  "OfficeStringId.MenuCmd_SaveDocument": "Сохранить",
  "OfficeStringId.MenuCmd_SaveDocumentAs": "Сохранить как",
  "OfficeStringId.MenuCmd_SaveDocumentAsDescription": "Открытие диалогового окна \"Сохранить как\" для выбора формата и расположения файла.",
  "OfficeStringId.MenuCmd_SaveDocumentDescription": "Сохранение документа.",
  "OfficeStringId.MenuCmd_ShowPasteSpecialForm": "Специальная вставка",
  "OfficeStringId.MenuCmd_ShowPasteSpecialFormDescription": "Открытие диалогового окна \"Специальная вставка\" для выбора специальной вставки.",
  "OfficeStringId.MenuCmd_StatusBarPopupMenuHeader": "Настройка строки состояния",
  "OfficeStringId.MenuCmd_StatusBarPopupMenuZoom": "Масштаб",
  "OfficeStringId.MenuCmd_StatusBarPopupMenuZoomSlider": "Ползунок масштаба",
  "OfficeStringId.MenuCmd_StatusBarZoomDescription": "Выбор масштаба. Щелкните, чтобы открыть диалоговое окно \"Масштаб\".",
  "OfficeStringId.MenuCmd_StatusBarZoomSliderDescription": "Масштаб",
  "OfficeStringId.MenuCmd_ToggleFontBold": "Полужирный",
  "OfficeStringId.MenuCmd_ToggleFontBoldDescription": "Применение полужирного начертания к выделенному тексту.",
  "OfficeStringId.MenuCmd_ToggleFontDoubleUnderline": "Двойное подчеркивание",
  "OfficeStringId.MenuCmd_ToggleFontDoubleUnderlineDescription": "Двойное подчеркивание выделенного текста.",
  "OfficeStringId.MenuCmd_ToggleFontItalic": "Курсив",
  "OfficeStringId.MenuCmd_ToggleFontItalicDescription": "Применение курсивного начертания к выделенному тексту.",
  "OfficeStringId.MenuCmd_ToggleFontStrikeout": "Зачеркнутый",
  "OfficeStringId.MenuCmd_ToggleFontStrikeoutDescription": "Добавление линии, проходящей через середину выделенного текста.",
  "OfficeStringId.MenuCmd_ToggleFontUnderline": "Подчеркнутый",
  "OfficeStringId.MenuCmd_ToggleFontUnderlineDescription": "Подчеркивание выделенного текста.",
  "OfficeStringId.MenuCmd_Undo": "Отменить",
  "OfficeStringId.MenuCmd_UndoDescription": "Отмена последнего действия.",
  "OfficeStringId.MenuCmd_Zoom100Percent": "100%",
  "OfficeStringId.MenuCmd_Zoom100PercentDescription": "Отображение документа в масштабе 1:1.",
  "OfficeStringId.MenuCmd_ZoomIn": "Увеличить масштаб",
  "OfficeStringId.MenuCmd_ZoomInDescription": "Увеличение масштаба.",
  "OfficeStringId.MenuCmd_ZoomOut": "Уменьшить масштаб",
  "OfficeStringId.MenuCmd_ZoomOutDescription": "Уменьшение масштаба.",
  "OfficeStringId.Msg_InternalError": "Внутренняя ошибка!",
  "OfficeStringId.Msg_InvalidBeginInit": "Ошибка: вызов BeginInit внутри BeginUpdate",
  "OfficeStringId.Msg_InvalidBeginUpdate": "Ошибка: вызов BeginUpdate внутри BeginInit ",
  "OfficeStringId.Msg_InvalidCopyFromDocumentModel": "Ошибка: исходники и назначение моделей документа изменены.",
  "OfficeStringId.Msg_InvalidEndInit": "Ошибка: вызов EndInit или CancelInit без BeginInit или внутри  BeginUpdate",
  "OfficeStringId.Msg_InvalidEndUpdate": "Ошибка: вызов EndUpdate или CancelUpate без BeginUpdate или внутри  BeginInit",
  "OfficeStringId.Msg_InvalidFontSize": "Значение должно находится в диапазоне от {0} до {1}.",
  "OfficeStringId.Msg_InvalidNumber": "Недопустимое значение.",
  "OfficeStringId.Msg_InvalidNumberConverterValue": "Значение должно быть между {0} и {1}.",
  "OfficeStringId.Msg_InvalidRemoveDataSource": "Источник данных нельзя удалить во время процесса слияния.",
  "OfficeStringId.Msg_IsNotValid": "значение '{0}' недопустимо для '{1}'",
  "OfficeStringId.Msg_Loading": "Загрузка...",
  "OfficeStringId.Msg_MagicNumberNotFound": "Формат файла, который вы пытаетесь открыть, не совпадает с расширением файла.",
  "OfficeStringId.Msg_UnsupportedFormatOrCorruptedFile": "Unsupported format or corrupted file.",
  "OfficeStringId.UnitAbbreviation_Centimeter": " см",
  "OfficeStringId.UnitAbbreviation_Inch": "\"",
  "OfficeStringId.UnitAbbreviation_Millimeter": " мм",
  "OfficeStringId.UnitAbbreviation_Percent": "%",
  "OfficeStringId.UnitAbbreviation_Pica": " пк",
  "OfficeStringId.UnitAbbreviation_Point": " пт",
  "XtraSpreadsheetCellErrorNameStringId.DivisionByZero": "#ДЕЛ/0!",
  "XtraSpreadsheetCellErrorNameStringId.GettingData": "#GETTING_DATA",
  "XtraSpreadsheetCellErrorNameStringId.Name": "#ИМЯ?",
  "XtraSpreadsheetCellErrorNameStringId.NullIntersection": "#ПУСТО!",
  "XtraSpreadsheetCellErrorNameStringId.Number": "#ЧИСЛО!",
  "XtraSpreadsheetCellErrorNameStringId.Reference": "#ССЫЛКА!",
  "XtraSpreadsheetCellErrorNameStringId.Value": "#ЗНАЧ!",
  "XtraSpreadsheetCellErrorNameStringId.ValueNotAvailable": "#Н/Д",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CountValue1": "от 1 до 255 аргументов, которые могут содержать или ссылаться на данные различных типов, но учитываются только числовые значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CountValue2": "от 1 до 255 аргументов, которые могут содержать или ссылаться на данные различных типов, но учитываются только числовые значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IfLogicaltest": "любое значение или выражение, которое при вычислении дает значение ИСТИНА или ЛОЖЬ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IfValueiftrue": "значение, которое возвращается, если 'лог_выражение' имеет значение ИСТИНА. Если не указано, возвращается значение ИСТИНА. Допустимая глубина вложенности - семь",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IfValueiffalse": "значение, которое возвращается, если 'лог_выражение' имеет значение ЛОЖЬ. Если не указано, возвращается значение ЛОЖЬ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IsNAValue": "проверяемое значение. Значение может содержать ссылку на ячейку, формулу или имя ячейки, формулы или значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IsErrorValue": "проверяемое значение. Значение может содержать ссылку на ячейку, формулу или имя ячейки, формулы или значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SumNumber1": "от 1 до 255 аргументов, которые суммируются. Логические и текстовые значения игнорируются",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SumNumber2": "от 1 до 255 аргументов, которые суммируются. Логические и текстовые значения игнорируются",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AverageNumber1": "от 1 до 255 числовых аргументов, для которых вычисляется среднее",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AverageNumber2": "от 1 до 255 числовых аргументов, для которых вычисляется среднее",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MinNumber1": "от 1 до 255 чисел, пустых ячеек, логических или текстовых значений, среди которых ищется наименьшее значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MinNumber2": "от 1 до 255 чисел, пустых ячеек, логических или текстовых значений, среди которых ищется наименьшее значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MaxNumber1": "от 1 до 255 чисел, пустых ячеек, логических или текстовых значений, среди которых ищется наибольшее значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MaxNumber2": "от 1 до 255 чисел, пустых ячеек, логических или текстовых значений, среди которых ищется наибольшее значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RowReference": "ячейка или диапазон, для которых определяется номер строки; если опущено, возвращает ячейку с функцией СТРОКА",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ColumnReference": "ячейка или диапазон, для которых определяется номер столбца. Если опущено, ячейка содержит функцию столбца",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NpvRate": "ставка дисконтирования на один период",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NpvValue1": "от 1 до 254 выплат и поступлений, равноотстоящих друг от друга по времени и происходящих в конце каждого периода",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NpvValue2": "от 1 до 254 выплат и поступлений, равноотстоящих друг от друга по времени и происходящих в конце каждого периода",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevNumber1": "от 1 до 255 значений, составляющих выборку из генеральной совокупности; допускаются числовые значения и ссылки на числовые значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevNumber2": "от 1 до 255 значений, составляющих выборку из генеральной совокупности; допускаются числовые значения и ссылки на числовые значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DollarNumber": "число либо ссылка на ячейку, содержащую число, либо формула, вычисление которой дает число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DollarDecimals": "число цифр справа от десятичной запятой. При необходимости округляется; если опущено, число знаков после запятой равно 2",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FixedNumber": "число, которое округляется и преобразуется в текст",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FixedDecimals": "число цифр справа от десятичной запятой. По умолчанию принимается равным 2",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FixedNocommas": "логическое значение, определяющее, должны (ИСТИНА) или не должны (ЛОЖЬ) разделители разрядов присутствовать в результате",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SinNumber": "угол в радианах, синус которого требуется определить. Градусы*ПИ()/180=радианы",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CosNumber": "угол в радианах, косинус которого требуется определить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TanNumber": "угол в радианах, тангенс которого требуется определить. Градусы * ПИ()/180 = радианы",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ATanNumber": "Тангенс искомого угла",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SqrtNumber": "число, для которого вычисляется квадратный корень",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ExpNumber": "степень, в которую возводится основание e. Величина e, основание натурального логарифма, приблизительно равна 2.71828182845904",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LnNumber": "положительное действительное число, для которого вычисляется натуральный логарифм",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Log10Number": "положительное действительное число, для которого вычисляется десятичный логарифм",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AbsNumber": "действительное число, абсолютную величину которого требуется найти",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IntNumber": "действительное число, округляемое до ближайшего меньшего целого",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SignNumber": "любое действительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RoundNumber": "округляемое число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RoundNumdigits": "количество десятичных разрядов, до которого нужно округлить число. Отрицательные значения вызывают округление целой части, ноль - округление до ближайшего целого числа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LookupLookupvalue": "Значение, которое ПРОСМОТР ищет в векторе просмотра; значение может быть числом, текстом, логическим значением, именем или ссылкой на значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LookupLookupvector": "диапазон, содержащий только одну строку или один столбец с текстом, числами или логическими значениями, расположенными в порядке возрастания",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LookupResultvector": "диапазон, содержащий только одну строку или один столбец того же размера, что и просматриваемый вектор",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IndexArray": "диапазон ячеек или константа массива.",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IndexRownum": "строка в массиве, из которой нужно возвращать значение; если опущена, требуется указание номера столбца",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IndexColumnnum": "столбец в массиве, из которого нужно возвращать значение; если опущен - требуется указание номера строки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ReptText": "повторяемый текст",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ReptNumbertimes": "положительное число, задающее количество требуемых повторений текста",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MidText": "текстовая строка, из которой следует извлечь знаки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MidStartnum": "позиция, начиная с которой следует извлечь знаки. Первый знак в тексте имеет позицию 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MidNumchars": "количество знаков, которое следует извлечь из текста",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LenText": "строка, длину которой следует определить. Пробелы считаются знаками",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ValueText": "текст в кавычках или ссылка на ячейку, содержащую текст который нужно преобразовать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AndLogical1": "от 1 до 255 проверяемых условий, которые могут принимать значение ИСТИНА либо ЛОЖЬ; они могут быть логическими значениями, массивами или ссылками",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AndLogical2": "от 1 до 255 проверяемых условий, которые могут принимать значение ИСТИНА либо ЛОЖЬ; они могут быть логическими значениями, массивами или ссылками",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OrLogical1": "от 1 до 255 проверяемых условий, которые могут принимать значение ИСТИНА либо ЛОЖЬ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OrLogical2": "от 1 до 255 проверяемых условий, которые могут принимать значение ИСТИНА либо ЛОЖЬ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NotLogical": "значение или выражение, которое может принимать значение либо ИСТИНА, либо ЛОЖЬ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ModNumber": "число, остаток от деления которого определяется",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ModDivisor": "число, на которое нужно разделить (делитель)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DCountDatabase": "диапазон, содержащий базу данных. База данных представляет собой набор связанных данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DCountField": "заголовок столбца в кавычках или номер столбца",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DCountCriteria": "диапазон, содержащий условие базы данных. Диапазон включает заголовки столбцов и одну ячейку с условием.",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DSumDatabase": "диапазон базы данных. База данных представляет собой набор связанных данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DSumField": "заголовок столбца в кавычках или номер столбца",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DSumCriteria": "диапазон, содержащий условие базы данных. Диапазон включает заголовок столбца и одну ячейку с условием",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DAverageDatabase": "диапазон ячеек, формирующих список или базу данных. База данных представляет собой список связанных данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DAverageField": "заголовок столбца в двойных кавычках или число, представляющее номер столбца в списке",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DAverageCriteria": "диапазон, содержащий задаваемые условия. Диапазон включает заголовок столбца и одну ячейку с условием под заголовком",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DMinDatabase": "диапазон базы данных. База данных представляет собой набор связанных данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DMinField": "заголовок столбца в кавычках или номер столбца",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DMinCriteria": "диапазон, содержащий условие базы данных. Диапазон включает заголовок столбца и одну ячейку с условием",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DMaxDatabase": "диапазон ячеек, составляющих список или базу данных. База данных представляет собой список связанных данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DMaxField": "заголовок столбца в двойных кавычках или число, представляющее номер столбца в списке",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DMaxCriteria": "диапазон, содержащий задаваемые условия. Диапазон включает заголовок столбца и одну ячейку с условием под заголовком",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DStDevDatabase": "диапазон базы данных . База данных представляет собой набор связанных данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DStDevField": "заголовок столбца в кавычках или номер столбца",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DStDevCriteria": "диапазон, содержащий условие базы данных. Диапазон включает заголовок столбца и одну ячейку с условием",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VarNumber1": "от 1 до 255 значений, составляющих выборку из генеральной совокупности",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VarNumber2": "от 1 до 255 значений, составляющих выборку из генеральной совокупности",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DVarDatabase": "диапазон базы данных. База данных представляет собой набор связанных данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DVarField": "заголовок столбца в кавычках или номер столбца",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DVarCriteria": "диапазон, содержащий условие базы данных. Диапазон включает заголовок столбца и одну ячейку с условием",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TextValue": "числовое значение либо формула, вычисление которой дает числовое значение, либо ссылка на ячейку, содержащую числовое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TextFormattext": "формат числа в текстовом виде из поля 'Числовые форматы' диалогового окна 'Формат ячеек'",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LinestKnownys": "множество значений y, для которых уже известно соотношение y = mx + b",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LinestKnownxs": "необязательное множество значений x, для которых, возможно, уже известно соотношение y = mx + b",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LinestConst": "логическое значение: константа b вычисляется обычным образом при значении ИСТИНА или отсутствии значения и равна 0 при значении ЛОЖЬ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LinestStats": "логическое значение, которое указывает, требуется ли вернуть дополнительную статистику по регрессии (ИСТИНА) или только коэффициенты m и константу b (ЛОЖЬ или отсутствие значения)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TrendKnownys": "множество значений y, для которых уже известно соотношение y = mx + b",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TrendKnownxs": "необязательное множество значений x, для которых, возможно, уже известно соотношение y = mx + b или массив имеет тот же размер, что и известные значения y",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TrendNewxs": "новые значения x, для которых ТРЕНД возвращает соответствующие значения y",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TrendConst": "логическое значение: константа b вычисляется обычным образом при значении ИСТИНА или отсутствии значения и равна 0 при значении ЛОЖЬ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LogestKnownys": "множество значений y, которые уже известны для соотношения y=b*m^x",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LogestKnownxs": "необязательное множество значений x, для которых, возможно, уже известно соотношение y = b*m^x",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LogestConst": "логическое значение: константа b вычисляется обычным образом при значении ИСТИНА или отсутствии значения и равна 1 при значении ЛОЖЬ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LogestStats": "логическое значение, которое указывает, требуется ли вернуть дополнительную статистику по регрессии (ИСТИНА) или только коэффициенты m и константу b (ЛОЖЬ или отсутствие значения)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GrowthKnownys": "множество значений y, которые уже известны для соотношения y=b*m^x, массив или диапазон положительных чисел",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GrowthKnownxs": "необязательное множество значений x, для которых, возможно, уже известно соотношение y = b*m^x, массив или диапазон того же размера, что и для y",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GrowthNewxs": "новые значения x, для которых РОСТ возвращает соответствующие значения y",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GrowthConst": "логическое значение: константа b вычисляется обычным образом при значении ИСТИНА и равна 1 при значении ЛОЖЬ или отсутствии значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PvRate": "процентная ставка за период. Например, при годовой процентной ставке в 6% для квартальной ставки используйте значение 6%/4",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PvNper": "общее число периодов выплат инвестиции",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PvPmt": "выплата, производимая в каждый период и не меняющаяся за все время выплаты инвестиции",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PvFv": "будущая стоимость или баланс, который нужно достичь после последней выплаты",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PvType": "логическое значение (0 или 1), обозначающее, должна ли производиться выплата в конце периода (0 или отсутствие значения) или в начале периода (1)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FvRate": "процентная ставка за период. Например, при годовой процентной ставке в 6% для квартальной ставки используйте значение 6%/4",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FvNper": "общее число периодов выплат инвестиции",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FvPmt": "выплата, производимая в каждый период и не меняющаяся за все время выплаты",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FvPv": "приведенная (нынешняя) стоимость, или общая сумма, которая на настоящий момент равноценна серии будущих выплат. Если не указана, то значение пс=0",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FvType": "значение 0 или 1, обозначающее, должна ли производиться выплата в начале периода (1) или же в конце периода (0 или отсутствие значения)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NPerRate": "процентная ставка за период. Например, при годовой процентной ставке в 6% для квартальной ставки используйте значение 6%/4",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NPerPmt": "выплата, производимая в каждый период; не может изменяться в течение времени выплаты инвестиции",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NPerPv": "приведенная (нынешняя) стоимость, или общая сумма, равноценная на данный момент сумме всех будущих выплат",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NPerFv": "будущая стоимость или баланс наличности, который нужно достичь после последней выплаты. Если опущено, используется нулевое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NPerType": "логическое значение (0 или 1), обозначающее, должна ли производиться выплата в конце периода (0 или отсутствие значения) или в начале периода (1)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PmtRate": "процентная ставка за период займа. Например, при годовой процентной ставке в 6% для квартальной ставки используйте значение 6%/4",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PmtNper": "общее число периодов выплат по займу",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PmtPv": "приведенная (нынешняя) стоимость - общая сумма, на настоящий момент равноценная серии будущих выплат",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PmtFv": "будущая стоимость или баланс наличности, который нужно достичь после последней выплаты; принимается равной 0, если значение не указано",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PmtType": "логическое значение (0 или 1), обозначающее, должна ли производиться выплата в конце периода (0 или отсутствие значения) или в начале периода (1)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RateNper": "общее число периодов выплат займа или инвестиции",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RatePmt": "выплата, производимая в каждый период и не меняющаяся за все время выплаты займа или инвестиции",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RatePv": "приведенная (нынешняя) стоимость - общая сумма, равноценная на настоящий момент серии будущих платежей",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RateFv": "будущая стоимость, или баланс наличности, который нужно достичь после последней выплаты (при отсутствии значения бс принимается равной 0)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RateType": "логическое значение (0 или 1), обозначающее, должна ли производиться выплата в конце периода (0 или отсутствие значения) или в начале периода (1)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RateGuess": "предполагаемая величина ставки; если значение не указано, то оно принимается равным 0,1 (10%)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MirrValues": "массив или ссылка на ячейки, содержащие числа, которые представляют серии платежей (отрицательные числа) и доходов (положительные числа), осуществляемые в одинаковые по продолжительности периоды",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MirrFinancerate": "процентная ставка, выплачиваемая за средства, находящиеся в обороте",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MirrReinvestrate": "процентная ставка, получаемая за средства, находящиеся в обороте, при реинвестировании",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IrrValues": "массив или ссылка на ячейки, содержащие числа, по которым нужно вычислить внутреннюю ставку доходности",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IrrGuess": "предполагаемая величина, близкая к результату ВСД; если не указана, принимается равной 0,1 (10 процентов)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MatchLookupvalue": "значение, используемое при поиске нужного значения в массиве - может быть числом, текстом или логическим значением, либо ссылкой на один из этих типов",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MatchLookuparray": "непрерывный диапазон ячеек, просматриваемый в поиске искомого значения - может быть диапазоном значений или ссылкой на диапазон",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MatchMatchtype": "число (1, 0 или -1), определяющее возвращаемое значение.",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DateYear": "число от 1900 до 9999 в Spreadsheet для Windows или число от 1904 до 9999 в Spreadsheet для Macintosh",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DateMonth": "число от 1 до 12, соответствующее месяцу года",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DateDay": "число от 1 до 31, соответствующее дню месяца",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TimeHour": "число от 0 до 23, представляющее час",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TimeMinute": "число от 0 до 59, представляющее минуту",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TimeSecond": "число от 0 до 59, представляющее секунду",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DaySerialnumber": "число в коде даты-времени, используемом в Spreadsheet",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MonthSerialnumber": "число в коде даты-времени, используемом в Spreadsheet",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YearSerialnumber": "число в коде даты-времени, используемом в Spreadsheet",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.WeekDaySerialnumber": "число, представляющее дату",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.WeekDayReturntype": "число (1,2 или 3), определяющее тип отсчета недели (с Вс=1 до Сб=7; с Пн=1 до Вс=7 или с Пн=0 до Вс=6 соответственно)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.HourSerialnumber": "число в коде даты-времени, используемом в Spreadsheet, или текст в формате времени, например 16:48:00",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MinuteSerialnumber": "число в коде даты-времени, используемом в Spreadsheet, или текст в формате времени, например 16:48:00",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SecondSerialnumber": "число в коде даты-времени, используемом в Spreadsheet, или текст в формате времени, например 16:48:23",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AreasReference": "ссылка на ячейку или диапазон (в том числе несвязный диапазон)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RowsArray": "массив или формула, выдающая массив, либо ссылка на диапазон, для которых определяется количество строк",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ColumnsArray": "массив либо формула, возвращающая массив, либо ссылка на диапазон, в котором определяется количество столбцов",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OffsetReference": "ссылка, от которой отсчитывается смещение - ссылка на ячейку или диапазон смежных ячеек",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OffsetRows": "количество строк вниз или вверх, на которое диапазон результирующей ссылки смещен относительно диапазона исходной ссылки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OffsetCols": "количество столбцов вправо или влево, на которое диапазон результирующей ссылки смещен относительно диапазона исходной ссылки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OffsetHeight": "высота, в строках, диапазона результирующей ссылки; если не указана, то равна высоте диапазона исходной ссылки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OffsetWidth": "ширина, в столбцах, диапазона результирующей ссылки; если не указана, то равна ширине диапазона исходной ссылки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SearchFindtext": "строка, которую требуется найти. Допускается использование знаков  ? и *; для поиска самих знаков * и ? используйте синтаксис ~? и ~*",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SearchWithintext": "строка, в которой нужно найти искомый текст",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SearchStartnum": "позиция в тексте для поиска (считая слева), с которой следует начать поиск. Если не указана, используется значение 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TransposeArray": "диапазон ячеек на листе или массив значений, который нужно транспонировать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TypeValue": "любое допустимое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ATan2Xnum": "координата X точки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ATan2Ynum": "координата Y точки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ASinNumber": "синус искомого угла (значение в диапазоне от -1 до 1)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ACosNumber": "косинус искомого угла (значение в интервале от  -1 до 1)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ChooseIndexnum": "указывает, какой аргумент должен быть выбран. Допустимые значения: число от 1 до 254, ссылка на число от 1 до 254 или формула, результатом которой является число от 1 до 254",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ChooseValue1": "от 1 до 254 чисел, ссылок на ячейки, определенных имен, формул, функций или текстовых аргументов, из которых производится выбор",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ChooseValue2": "от 1 до 254 чисел, ссылок на ячейки, определенных имен, формул, функций или текстовых аргументов, из которых производится выбор",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.HLookupLookupvalue": "значение, которое требуется найти в первой строке таблицы. Искомое_значение может быть значением, ссылкой или текстовой строкой",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.HLookupTablearray": "таблица с текстом, числами или логическими значениями, в которой производится поиск данных; может быть ссылкой или именем диапазона",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.HLookupRowindexnum": "номер строки в таблице, из которой должно быть возвращено сопоставляемое значение. Первая строка значений таблицы имеет номер 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.HLookupRangelookup": "логическое значение, определяющее, точно (ЛОЖЬ) или приближенно (ИСТИНА или отсутствие значения) должен производиться поиск в верхней строке (отсортированной по возрастанию)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VLookupLookupvalue": "значение, которое должно быть найдено в первом столбце массива (значение, ссылка или строка текста)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VLookupTablearray": "таблица с текстом, числами или логическими значениями, в которой производится поиск данных; может быть ссылкой или именем диапазона",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VLookupColindexnum": "номер столбца в таблице, из которого нужно вернуть значение. Первый столбец значений таблицы имеет номер 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VLookupRangelookup": "логическое значение, определяющее, точно (ЛОЖЬ) или приближенно (ИСТИНА или отсутствие значения) должен производиться поиск в первом столбце (отсортированном по возрастанию)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IsRefValue": "проверяемое значение. Значение может содержать ссылку на ячейку, формулу или имя ячейки, формулы или значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNumber": "положительное действительное число, для которого вычисляется логарифм",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LogBase": "основание логарифма; 10 если опущено",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CharNumber": "число в интервале от 1 до 255, указывающее нужный символ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LowerText": "строка, буквы которой требуется преобразовать в строчные. Знаки, не являющиеся буквами, не изменяются",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.UpperText": "строка, буквы которой требуется преобразовать в прописные; может быть ссылкой или строкой текста",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ProperText": " строка текста, заключенная в кавычки; формула, возвращающая текст; либо ссылка на ячейку, содержащую текст, в котором некоторые буквы заменяются на прописные",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LeftText": "строка текста, содержащая знаки, которые нужно извлечь",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LeftNumchars": "количество знаков, которое нужно извлечь; если не указано, принимается равным 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RightText": "строка текста, содержащая знаки, которые нужно извлечь",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RightNumchars": "число знаков, которое нужно извлечь; если не указано, принимается равным 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ExactText1": "первая текстовая строка",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ExactText2": "вторая текстовая строка",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TrimText": "текст, из которого удаляются пробелы",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ReplaceOldtext": "строка, в которой нужно заменить некоторые знаки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ReplaceStartnum": "позиция знака в строке 'старый_текст', начиная с которого нужно заменить часть этой строки на 'новый_текст'",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ReplaceNumchars": "число знаков в строке 'старый_текст', которое нужно заменить на знаки строки 'новый_текст'",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ReplaceNewtext": "строка, которая заменит соответствующую подстроку строки 'старый_текст'",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SubstituteText": "либо текст, либо ссылка на ячейку, содержащую текст, в котором подставляются знаки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SubstituteOldtext": "заменяемый текст, с учетом регистра знаков",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SubstituteNewtext": "строка, которой заменяется старый_текст",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SubstituteInstancenum": "номер вхождения стар_текст, который следует заменить на нов_текст. Если опущено, заменяется каждое вхождение стар_текст",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CodeText": "текст, в котором требуется узнать код первого символа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FindFindtext": "строка, которую требуется найти. Для поиска первого знака укажите пустую строку (две двойных кавычки); использование знаков подстановки не допускается",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FindWithintext": "строка, содержащая искомый текст",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FindStartnum": "позиция, с которой нужно начать поиск. Первый знак в параметре 'просматриваемый_текст' имеет позицию номер 1. Если значение не указано, начальная позиция принимается равной 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CellInfotype": "строка, определяющая тип сведений о ячейке.",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CellReference": "ячейка, сведения о которой требуется получить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IsErrValue": "проверяемое значение. Значение может содержать ссылку на ячейку, формулу или имя ячейки, формулы или значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IsTextValue": "проверяемое значение. Значение может содержать ссылку на ячейку, формулу или имя ячейки, формулы или значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IsNumberValue": "проверяемое значение. Значение может содержать ссылку на ячейку, формулу или имя ячейки, формулы или значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IsBlankValue": "проверяемая ячейка или ссылающееся на ее имя",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TValue": "проверяемое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NValue": "преобразуемое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DateValueDatetext": "строка, содержащая дату в формате даты Spreadsheet в диапазоне от 01.01.1900 (Windows) или 01.01.1904 (Macintosh) до 31.12.9999",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TimeValueTimetext": "строка текста, содержащая время в любом из форматов времени Spreadsheet (сведения о дате игнорируются)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SlnCost": "начальная стоимость актива",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SlnSalvage": "остаточная стоимость в конце времени эксплуатации актива",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SlnLife": "число периодов амортизации актива (иногда называется временем полезной службы актива)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SydCost": "начальная стоимость актива",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SydSalvage": "остаточная стоимость в конце времени эксплуатации актива",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SydLife": "число периодов амортизации актива (иногда называется временем полезной службы актива)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SydPer": "период; должен указываться в тех же единицах, что и время_эксплуатации",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DdbCost": "начальная стоимость актива",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DdbSalvage": "остаточная стоимость в конце времени эксплуатации актива",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DdbLife": "число периодов амортизации актива (иногда называется временем нормальной эксплуатации актива)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DdbPeriod": "период, для которого нужно вычислить амортизацию; должен указываться в тех же единицах, что и время_эксплуатации",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DdbFactor": "коэффициент уменьшения остатка. Если коэффициент не указан, он принимается равным 2 (метод двукратного уменьшения остатка)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IndirectReftext": "ссылка на ячейку, которая содержит либо ссылку в стиле А1, либо ссылку в стиле R1C1, либо имя, определенное как ссылка, либо ссылку на ячейку в виде текстовой строки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IndirectA1": "логическое значение, указывающее, какого типа ссылка содержится в ячейке, задаваемой аргументом 'ссылка_на_ячейку': R1C1 = ЛОЖЬ; A1 = ИСТИНА или опущено",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CallRegisterid": "значение, возвращенное ранее выполненной функцией РЕГИСТРАТОР или РЕГИСТРАТОР.ИД",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CallArgument1": "аргументы, которые должны быть переданы процедуре",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CleanText": "любая информация на рабочем листе, из которой удаляются непечатаемые знаки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MDetermArray": "числовой массив с равным количеством строк и столбцов, диапазон ячеек или массив",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MInverseArray": "числовой массив с равным количеством строк и столбцов, либо диапазон или массив",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MMultArray1": "первый из перемножаемых массивов, число столбцов в нем должно равняться числу строк во втором массиве",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MMultArray2": "первый из перемножаемых массивов, число столбцов в нем должно равняться числу строк во втором массиве",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IpmtRate": "процентная ставка за период. Например, при годовой процентной ставке в 6% используйте для квартальной процентной ставки значение 6%/4",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IpmtPer": "период, для которого нужно определить сумму выплаты; должен быть в диапазоне от 1 до кпер",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IpmtNper": "общее число периодов выплат инвестиции",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IpmtPv": "приведенная (нынешняя) стоимость, или общая сумма, равноценная на данный момент серии будущих выплат",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IpmtFv": "будущая стоимость, или наличный баланс, который нужно достигнуть после последней выплаты. Если значение не указано, бс принимается равной 0",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IpmtType": "логическое значение, обозначающее, когда должен выполняться платеж - в конце периода (0 или отсутствие значения) или в начале периода (1)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PpmtRate": "процентная ставка за период. Например, при годовой процентной ставке в 6% используйте для квартальной процентной ставки значение 6%/4",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PpmtPer": "период; должен быть в диапазоне от 1 до кпер",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PpmtNper": "общее число периодов выплат инвестиции",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PpmtPv": "приведенная (нынешняя) стоимость, или общая сумма, равноценная на данный момент серии будущих выплат",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PpmtFv": "будущая стоимость, или наличный баланс, который нужно достигнуть после последней выплаты",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PpmtType": "логическое значение, обозначающее, когда должен выполняться платеж - в конце периода (0 или отсутствие значения) или в начале периода (1)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CountAValue1": "от 1 до 255 аргументов любого типа, количество которых требуется определить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CountAValue2": "от 1 до 255 аргументов любого типа, количество которых требуется определить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ProductNumber1": "от 1 до 255 перемножаемых чисел, логических значений или чисел, представленных в текстовом виде",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ProductNumber2": "от 1 до 255 перемножаемых чисел, логических значений или чисел, представленных в текстовом виде",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FactNumber": "неотрицательное число, факториал которого вычисляется",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DProductDatabase": "диапазон базы данных. База данных представляет собой набор связанных данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DProductField": "заголовок столбца в кавычках или номер столбца",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DProductCriteria": "диапазон, содержащий условие базы данных. Диапазон включает заголовок столбца и одну ячейку с условием",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IsNonTextValue": "проверяемое значение: ячейка, формула или имя ячейки, формулы или значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevPNumber1": "от 1 до 255 значений, составляющих генеральную совокупность; допускаются числовые значения и ссылки на числовые значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevPNumber2": "от 1 до 255 значений, составляющих генеральную совокупность; допускаются числовые значения и ссылки на числовые значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VarPNumber1": "от 1 до 255 числовых аргументов, составляющих генеральную совокупность",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VarPNumber2": "от 1 до 255 числовых аргументов, составляющих генеральную совокупность",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DStDevPDatabase": "диапазон базы данных. База данных представляет собой набор связанных данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DStDevPField": "заголовок столбца в кавычках или номер столбца",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DStDevPCriteria": "диапазон, содержащий условие базы данных. Диапазон включает заголовок столбца и одну ячейку с условием",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DVarPDatabase": "диапазон базы данных. База данных представляет собой набор связанных данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DVarPField": "заголовок столбца в кавычках или номер столбца",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DVarPCriteria": "диапазон, содержащий условие базы данных. Диапазон включает заголовок столбца и одну ячейку с условием",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TruncNumber": "усекаемое число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TruncNumdigits": "число, определяющее точность усечения. По умолчанию используется значение 0",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IsLogicalValue": "проверяемое значение - ячейка, формула или имя ячейки, формулы или значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DCountADatabase": "диапазон, составляющий базу данных. База данных представляет собой набор связанных данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DCountAField": "заголовок столбца в кавычках или номер столбца",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DCountACriteria": "диапазон, содержащий условие базы данных. Диапазон включает заголовок столбца и одну ячейку  условием.",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FindBFindtext": "строка, которую нужно найти",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FindBWithintext": "строка, содержащая строку, которую нужно найти",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FindBStartnum": "позиция в строке, с которой следует начинать поиск",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SearchBFindtext": "строка, которую требуется найти",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SearchBWithintext": "строка, в которой нужно найти искомый текст",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SearchBStartnum": "позиция знака в тексте для поиска (считая слева), с которой следует начать поиск",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ReplaceBOldtext": "строка, в которой нужно заменить некоторые знаки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ReplaceBStartnum": "позиция знака в строке 'старый_текст', начиная с которого нужно заменить часть этой строки на 'новый_текст'",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ReplaceBNumbytes": "число знаков в строке 'старый_текст', которое нужно заменить на знаки строки 'новый_текст'",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ReplaceBNewtext": "строка, которая заменит соответствующую подстроку строки 'старый_текст'",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LeftBText": "строка текста, содержащая знаки, которые нужно извлечь",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LeftBNumbytes": "число знаков, которые нужно извлечь",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RightBText": "строка текста, содержащая знаки, которые нужно извлечь",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RightBNumbytes": "число знаков, которые нужно извлечь",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MidBText": "текстовая строка, из которой нужно извлечь знаки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MidBStartnum": "позиция первого знака, который нужно извлечь",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MidBNumbytes": "число знаков, которые нужно извлечь",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LenBText": "строка, длину которой нужно определить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RoundUpNumber": "любое действительное число, которое нужно округлить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RoundUpNumdigits": "количество разрядов, до которого округляется число. Отрицательные значения вызывают округление целой части, ноль или отсутствие значения - до ближайшего целого числа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RoundDownNumber": "любое действительное число, которое нужно округлить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RoundDownNumdigits": "количество разрядов, до которого округляется число. Отрицательные значения вызывают округление целой части, ноль или отсутствие значения - до ближайшего целого числа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AscText": "текст или ссылка на ячейку, содержащую текст",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RankNumber": "число, для которого определяется ранг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RankRef": "массив или ссылка на список чисел. Нечисловые значения игнорируются",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RankOrder": "число, определяющее способ округления",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AddressRownum": "Номер строки, используемый в ссылке ячейки; для строки 1 номер строки равен 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AddressColumnnum": "Номер столбца, используемый в ссылке ячейки; для столбца D номер столбца равен 4",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AddressAbsnum": "Задание типа возвращаемой ссылки (типы ссылки пронумерованы от 1 до 4)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AddressA1": "логическое значение, определяющее стиль ссылок: A1 (1 или ИСТИНА) или R1C1 (0 или ЛОЖЬ)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AddressSheettext": "строка, задающая имя листа, который используется как внешняя ссылка",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Days360Startdate": "'нач_дата' и 'кон_дата' - это даты, количество дней между которыми требуется определить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Days360Enddate": "'нач_дата' и 'кон_дата' - это даты, количество дней между которыми требуется определить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Days360Method": "логическое значение, определяющее используемый в вычислениях метод: европейский (ИСТИНА) или американский (ЛОЖЬ или отсутствие значения).",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VdbCost": "начальная стоимость актива",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VdbSalvage": "остаточная стоимость актива в конце времени эксплуатации",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VdbLife": "число периодов амортизации актива (иногда называется временем нормальной эксплуатации актива)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VdbStartperiod": "начальный период, для которого нужно вычислить амортизацию, в тех же единицах, что и время_эксплуатации",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VdbEndperiod": "конечный период, для которого нужно вычислить амортизацию, в тех же единицах, что и время_эксплуатации",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VdbFactor": "коэффициент уменьшения остатка; если не указан, принимается равным 2 (двукратное уменьшение остатка)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VdbNoswitch": "значение, определяющее, следует ли переключаться на использование прямолинейной амортизации, когда амортизация превышает уменьшающийся остаток: переключаться, если ЛОЖЬ или значение не указано; не переключаться, если ИСТИНА",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MedianNumber1": "от 1 до 255 чисел, имен, массивов или ссылок на числовые значения, для которых определяется медиана",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MedianNumber2": "от 1 до 255 чисел, имен, массивов или ссылок на числовые значения, для которых определяется медиана",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SumProductArray1": "от 2 до 255 массивов, соответствующие компоненты которых нужно сначала перемножить, а затем сложить полученные произведения. Все массивы должны иметь одинаковую размерность",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SumProductArray2": "от 2 до 255 массивов, соответствующие компоненты которых нужно сначала перемножить, а затем сложить полученные произведения. Все массивы должны иметь одинаковую размерность",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SumProductArray3": "от 2 до 255 массивов, соответствующие компоненты которых нужно сначала перемножить, а затем сложить полученные произведения. Все массивы должны иметь одинаковую размерность",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SinHNumber": "любое действительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CosHNumber": "любое действительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TanHNumber": "любое действительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ASinHNumber": "любое действительное число, большее или равное 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ACosHNumber": "Любое действительное число, большее или равное 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ATanHNumber": "любое действительное число в диапазоне от -1 до 1, исключая -1 и 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DGetDatabase": "диапазон базы данных. База данных представляет собой набор связанных данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DGetField": "заголовок столбца в кавычках или номер столбца",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DGetCriteria": "диапазон, содержащий условие базы данных. Диапазон включает заголовок столбца и одну ячейку с условием",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.InfoTypetext": "текст, задающий тип возвращаемой информации.",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DbCost": "начальная стоимость актива",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DbSalvage": "остаточная стоимость актива в конце времени эксплуатации",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DbLife": "число периодов амортизации актива (иногда называется временем нормальной эксплуатации актива)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DbPeriod": "период, для которого нужно вычислить амортизацию, в тех же единицах, что и время_эксплуатации",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DbMonth": "число месяцев в первом году. Если не указано, принимается равным 12",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FrequencyDataarray": "массив или ссылка на множество данных, для которых вычисляются частоты (пробелы и текст не учитываются)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FrequencyBinsarray": "массив интервалов или ссылка на интервалы, в которых группируются значения из массива данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ErrorTypeErrorval": "значение ошибки, для которой нужно найти код. Может быть фактическим значением ошибки или ссылкой на ячейку, содержащую ошибку",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RegisterIdModuletext": "строка с именем DLL, которая содержит функцию Spreadsheet для Windows",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RegisterIdProcedure": "строка с именем функции в DLL в Spreadsheet для Windows",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RegisterIdTypetext": "строка, задающая тип данных принимаемого и возвращаемого значений; может быть опущена, если функция уже зарегистрирована.",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AvedevNumber1": "от 1 до 255 аргументов, для которых определяется среднее абсолютных отклонений",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AvedevNumber2": "от 1 до 255 аргументов, для которых определяется среднее абсолютных отклонений",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistCompatibilityX": "значение в интервале между A и B, для которого вычисляется функция",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistCompatibilityAlpha": "параметр распределения; должен быть положительной величиной",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistCompatibilityBeta": "параметр распределения; должен быть положительной величиной",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistCompatibilityA": "необязательная нижняя граница интервала изменения x. Если опущено, A = 0",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistCompatibilityB": "необязательная верхняя граница интервала изменения x. Если опущено, В = 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaLnX": "значение, для которого вычисляется ГАММАНЛОГ, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaInvProbability": "вероятность, связанная с бета распределением",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaInvAlpha": "параметр распределения; должен быть положительной величиной",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaInvBeta": "параметр распределения; должен быть положительной величиной",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaInvA": "необязательная нижняя граница интервала изменения x. Если опущено, A = 0",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaInvB": "необязательная верхняя граница интервала изменения x. Если опущено, В = 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDistNumbers": "число успешных испытаний",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDistTrials": "число независимых испытаний",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDistProbabilitys": "вероятность успеха каждого испытания",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDistCumulative": "логическое значение, определяющее вид функции: интегральная функция распределения (ИСТИНА) или весовая функция распределения (ЛОЖЬ)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ChiDistX": "значение, для которого требуется вычислить распределение, неотрицательное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ChiDistDegfreedom": "число степеней свободы - число от 1 до 10^10, исключая 10^10",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ChiInvProbability": "вероятность, связанная с распределением хи-квадрат, значение в диапазоне от 0 до 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ChiInvDegfreedom": "число степеней свободы - число от 1 до 10^10, исключая 10^10",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CombinNumber": "число элементов",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CombinNumberchosen": "число элементов в каждой комбинации",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ConfidenceAlpha": "уровень значимости, используемый для вычисления доверительного уровня - число, большее 0 и меньшее 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ConfidenceStandarddev": "стандартное отклонение генеральной совокупности для интервала данных (предполагается известным). Должно быть больше нуля",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ConfidenceSize": "размер выборки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CritBinomTrials": "число испытаний Бернулли",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CritBinomProbabilitys": "вероятность успеха в каждом испытании",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CritBinomAlpha": "значение критерия, число в диапазоне от 0 до 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.EvenNumber": "округляемое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ExponDistX": "значение функции, неотрицательное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ExponDistLambda": "значение параметра, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ExponDistCumulative": "логическое значение, определяющее возвращаемую функцию: интегральную функцию распределения, если ИСТИНА; функцию плотности распределения вероятности, если ЛОЖЬ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FDistX": "значение, для которого вычисляется функция, неотрицательное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FDistDegfreedom1": "число степеней свободы - число от 1 до 10^10, исключая 10^10",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FDistDegfreedom2": "знаменатель степеней свободы - число от 1 до 10^10, исключая 10^10",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FInvProbability": "вероятность, связанная с F-интегральным распределением, число в диапазоне от 0 до 1 включительно",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FInvDegfreedom1": "числитель степеней свободы - число от 1 до 10^10, исключая 10^10",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FInvDegfreedom2": "знаменатель степеней свободы - число от 1 до 10^10, исключая 10^10",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FisherX": "числовое значение, которое требуется преобразовать, целое число в интервале от -1 до 1, исключая концы",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FisherInvY": "значение, для которого производится обратное преобразование",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FloorNumber": "округляемое числовое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FloorSignificance": "кратное, до которого требуется округлить. Оба значения должны иметь одинаковый знак",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDistX": "значение, для которого требуется вычислить распределение, неотрицательное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDistAlpha": "параметр распределения, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDistBeta": "параметр распределения, положительное число. Если бета=1, то ГАММАРАСП возвращает стандартное гамма распределение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDistCumulative": "логическое значение, определяющее вид функции: интегральная функция распределения (ИСТИНА) или весовая функция распределения (ЛОЖЬ или отсутствие значения)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaInvProbability": "вероятность, связанная с гамма-распределением, число в диапазоне от 0 до 1, включительно",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaInvAlpha": "параметр распределения, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaInvBeta": "параметр распределения, положительное число. Если бета=1, то ГАММАОБР возвращает стандартное гамма-распределение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CeilingNumber": "округляемое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CeilingSignificance": "кратное, до которого требуется округлить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.HypGeomDistSamples": "число успешных испытаний в выборке",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.HypGeomDistNumbersample": "размер выборки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.HypGeomDistPopulations": "число успешных испытаний в генеральной совокупности",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.HypGeomDistNumberpop": "размер генеральной совокупности",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNormDistCompatibilityX": "значение, для которого вычисляется функция, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNormDistCompatibilityMean": "среднее ln(x)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNormDistCompatibilityStandarddev": "стандартное отклонение ln(x), положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LogInvCompatibilityProbability": "вероятность, связанная с нормальным логарифмическим распределением, число в диапазоне от 0 до 1 включительно",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LogInvCompatibilityMean": "среднее ln(x)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LogInvCompatibilityStandarddev": "стандартное отклонение ln(x), положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NegBinomDistNumberf": "число неудачных испытаний",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NegBinomDistNumbers": "пороговое значение числа успешных испытаний",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NegBinomDistProbabilitys": "вероятность успеха - число в интервале от 0 до 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NormDistCompatibilityX": "значение, для которого строится распределение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NormDistCompatibilityMean": "арифметическое среднее распределения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NormDistCompatibilityStandarddev": "стандартное отклонение распределения, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NormDistCompatibilityCumulative": "логическое значение, определяющее вид функции: интегральная функция распределения (ИСТИНА) или весовая функция распределения (ЛОЖЬ)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NormSDistCompatibilityZ": "значение, для которого строится распределение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NormInvCompatibilityProbability": "вероятность, соответствующая нормальному распределению, число в диапазоне от 0 до 1 включительно",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NormInvCompatibilityMean": "арифметическое среднее распределения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NormInvCompatibilityStandarddev": "стандартное отклонение распределения, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NormSInvCompatibilityProbability": "вероятность, соответствующая нормальному распределению",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.StandardizeX": "нормализуемое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.StandardizeMean": "арифметическое среднее распределения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.StandardizeStandarddev": "стандартное отклонение распределения, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddNumber": "округляемое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PermutNumber": "целое число, задающее общее количество объектов",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PermutNumberchosen": "целое число, задающее количество объектов в каждой перестановке",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PoissonX": "количество событий",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PoissonMean": "ожидаемое числовое значение, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PoissonCumulative": "логическое значение, определяющее вид функции: интегральная функция распределения (ИСТИНА) или весовая функция распределения (ЛОЖЬ)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TDistX": "числовое значение, для которого требуется вычислить распределение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TDistDegfreedom": "целое, указывающее количество степеней свободы",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TDistTails": "число возвращаемых хвостов распределения (1 или 2)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.WeibullX": "значение, для которого вычисляется функция, неотрицательное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.WeibullAlpha": "параметр распределения, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.WeibullBeta": "параметр распределения, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.WeibullCumulative": "логическое значение, определяющее вид функции: интегральная функция распределения (ИСТИНА) или весовая функция распределения (ЛОЖЬ)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SumXMY2Arrayx": "первый диапазон или массив - число, имя, массив или ссылка на диапазон с числами",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SumXMY2Arrayy": "второй диапазон или массив - число, имя, массив или ссылка на диапазон с числами",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SumX2MY2Arrayx": "первый диапазон или массив - число, имя, массив или ссылка на диапазон с числами",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SumX2MY2Arrayy": "второй диапазон или массив - число, имя, массив или ссылка на диапазон с числами",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SumX2PY2Arrayx": "первый массив или диапазон - число, имя, массив или ссылка на диапазон с числами",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SumX2PY2Arrayy": "второй массив или диапазон - число, имя, массив или ссылка на диапазон с числами",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ChiTestActualrange": "диапазон, содержащий наблюдения, подлежащие сравнению с ожидаемыми значениями",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ChiTestExpectedrange": "диапазон, содержащий отношение произведений итогов по строкам и столбцам к общему итогу",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CorrelArray1": "первый диапазон значений. Значениями могут быть числа, имена, массивы или ссылки с именами",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CorrelArray2": "второй диапазон значений. Значениями могут быть числа, имена, массивы или ссылки с именами",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CovarArray1": "первый диапазон целых чисел - числа, массивы или ссылки на ячейки, содержащие числа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CovarArray2": "второй диапазон целых чисел - числа, массивы или ссылки на ячейки, содержащие числа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ForecastX": "элемент данных, для которого предсказывается значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ForecastKnownys": "зависимый массив или диапазон данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ForecastKnownxs": "независимый массив или диапазон. Дисперсия данных не должна быть нулевой",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FTestArray1": "первый массив или диапазон - числа, массивы или ссылки на ячейки, содержащие числа (пробелы игнорируются)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FTestArray2": "второй массив или диапазон - числа, массивы или ссылки на ячейки, содержащие числа (пробелы игнорируются)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.InterceptKnownys": "зависимое множество наблюдений или данных - числа, массивы или ссылки на ячейки, содержащие числа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.InterceptKnownxs": "независимое множество наблюдений или данных - числа, массивы или ссылки на ячейки, содержащие числа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PearsonArray1": "множество независимых значений",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PearsonArray2": "множество зависимых значений",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RsqKnownys": "массив или диапазон, могущий включать числа или имена, массивы или ссылки на ячейки с числами",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RsqKnownxs": "массив или диапазон, могущий включать числа или имена, массивы или ссылки на ячейки с числами",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.StEYXKnownys": "массив или диапазон зависимых точек данных - числа, массивы или ссылки на ячейки, содержащие числа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.StEYXKnownxs": "массив или диапазон независимых точек данных - числа, массивы или ссылки на ячейки, содержащие числа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SlopeKnownys": "массив или диапазон, содержащий числовые зависимые элементы данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SlopeKnownxs": "множество независимых элементов данных -- имена, массивы или ссылки на ячейки, содержащие числа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TTestArray1": "первый набор данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TTestArray2": "второй набор данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TTestTails": "число хвостов распределения (1 или 2)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TTestType": "вид t-test: парный = 1, двухпарный = 2, двухпарный с неравным отклонением = 3",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ProbXrange": "интервал числовых значений x, с которыми связаны вероятности",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ProbProbrange": "множество вероятностей, соответствующих значениям в аргументе 'x_интервал'; значения лежат в интервале между 0 и 1, исключая 0",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ProbLowerlimit": "нижняя граница значения, для которого вычисляется вероятность",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ProbUpperlimit": "необязательная верхняя граница значения, для которого вычисляется вероятность. Если опущена, возвращается вероятность того, что значения в аргументе 'x_интервал' равны нижнему пределу",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DevSqNumber1": "от 1 до 255 аргументов, массивов или ссылок на массивы, для которых вычисляется сумма квадратов отклонений",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DevSqNumber2": "от 1 до 255 аргументов, массивов или ссылок на массивы, для которых вычисляется сумма квадратов отклонений",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GeomeanNumber1": "от 1 до 255 чисел, имен, массивов или ссылок на числовые значения, для которых вычисляется среднее",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GeomeanNumber2": "от 1 до 255 чисел, имен, массивов или ссылок на числовые значения, для которых вычисляется среднее",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.HarMeanNumber1": "от 1 до 255 чисел, имен, массивов или ссылок на числовые значения, для которых вычисляется среднее гармоническое",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.HarMeanNumber2": "от 1 до 255 чисел, имен, массивов или ссылок на числовые значения, для которых вычисляется среднее гармоническое",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SumSqNumber1": "от 1 до 255 чисел, массивов, имен или ссылок на массивы, для которых вычисляется сумма квадратов",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SumSqNumber2": "от 1 до 255 чисел, массивов, имен или ссылок на массивы, для которых вычисляется сумма квадратов",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.KurtNumber1": "от 1 до 255 чисел, имен, массивов или ссылок на числовые значения, для которых вычисляется эксцесс",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.KurtNumber2": "от 1 до 255 чисел, имен, массивов или ссылок на числовые значения, для которых вычисляется эксцесс",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SkewNumber1": "от 1 до 255 числовых значений, массивов чисел или ссылок на числовые значения, для которых вычисляется асимметричность",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SkewNumber2": "от 1 до 255 числовых значений, массивов чисел или ссылок на числовые значения, для которых вычисляется асимметричность",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ZTestArray": "массив или диапазон, с которыми сравнивается x",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ZTestX": "проверяемое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ZTestSigma": "известное стандартное отклонение генеральной совокупности",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LargeArray": "массив или диапазон, для которых определяется k-ое наибольшее значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LargeK": "позиция (начиная с наибольшей) в массиве или диапазоне",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SmallArray": "массив или диапазон числовых данных, для которых определяется k-ое наименьшее значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SmallK": "позиция (начиная с наименьшей) в массиве или диапазоне",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.QuartileArray": "массив или диапазон ячеек с числовыми значениями, для которых определяется значение квартиля",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.QuartileQuart": "значение: минимальное = 0; первый квартиль = 1; медиана = 2; третий квартиль = 3; максимальное значение = 4",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentileArray": "массив или диапазон с численными значениями, который определяет относительное положение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentileK": "значение процентиля в интервале от 0 до 1 включительно",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentRankArray": "массив или диапазон с численными значениями, который определяет относительное положение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentRankX": "значение, для которого определяется ранг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentRankSignificance": "необязательное значение, определяющее количество значащих цифр в возвращаемом значении процентного содержания; по умолчанию принимается равным 3 (0,xxx%)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ModeNumber1": "от 1 до 255 чисел, имен, массивов или ссылок на числовые значения, для которых вычисляется мода",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ModeNumber2": "от 1 до 255 чисел, имен, массивов или ссылок на числовые значения, для которых вычисляется мода",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TrimmeanArray": "массив или диапазон усредняемых значений",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TrimmeanPercent": "дробное число точек данных, исключаемых из вычислений",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TinvProbability": "вероятность, связанная с двусторонним t-распределением Стьюдента",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TinvDegfreedom": "положительное целое число степеней свободы, характеризующее распределение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ConcatenateText1": "от 1 до 255 текстовых строк, которые следует объединить в одну строку; могут быть строками, числами или ссылками на отдельные ячейки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ConcatenateText2": "от 1 до 255 текстовых строк, которые следует объединить в одну строку; могут быть строками, числами или ссылками на отдельные ячейки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PowerNumber": "номер основания - любое действительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PowerPower": "показатель степени, в которую возводится основание",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RadiansAngle": "угол в градусах, который нужно преобразовать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DegreesAngle": "угол в радианах, преобразуемый в градусы",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SubtotalFunctionnum": "число от 1 до 11, которое указывает, какую функцию следует использовать при вычислении промежуточных итогов",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SubtotalRef1": "от 1 до 254 диапазонов или ссылок, для которых требуется вычислить промежуточные итоги",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SumIfRange": "диапазон проверяемых ячеек",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SumIfCriteria": "условие в форме числа, выражения или текста, определяющее суммируемые ячейки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SumIfSumrange": "фактические ячейки для суммирования. Если диапазон суммирования не указан, будут использоваться ячейки, задаваемые параметром 'диапазон'",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CountIfRange": "диапазон, в котором подсчитывается количество непустых ячеек",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CountIfCriteria": "условие в форме числа, выражения или текста, который определяет, какие ячейки надо подсчитывать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CountBlankRange": "диапазон, в котором требуется определить количество пустых ячеек",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IsPmtRate": "процентная ставка за период. Например, при годовой процентной ставке в 6% используйте для квартальной процентной ставки значение 6%/4",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IsPmtPer": "период, для которого нужно определить процент",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IsPmtNper": "общее число периодов выплат инвестиции",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IsPmtPv": "приведенная (нынешняя) стоимость, или общая сумма, равноценная на данный момент серии будущих выплат",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RomanNumber": "число в арабской записи, которое требуется преобразовать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RomanForm": "число, указывающее желаемый тип числа в римской записи.",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GetPivotDataDatafield": "имя поля данных, из которого следует извлечь данные",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GetPivotDataPivottable": "ссылка на ячейку или диапазон ячеек сводной таблицы, где содержатся данные, которые нужно извлечь",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GetPivotDataField": "поле",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GetPivotDataItem": "элемент поля",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.HyperlinkLinklocation": "путь и имя файла документа (полный путь, адрес UNC или URL).",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.HyperlinkFriendlyname": "текст или число, отображаемое в ячейке. Если этот параметр не задан, в ячейке отображается значение параметра 'адрес'",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PhoneticReference": "ссылка на ячейку, содержащую фонетическую строку",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AverageAValue1": "от 1 до 255 аргументов, для которых требуется определить среднее",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AverageAValue2": "от 1 до 255 аргументов, для которых требуется определить среднее",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MaxAValue1": "от 1 до 255 чисел, пустых ячеек, логических значений или чисел в текстовом виде, среди которых требуется определить наибольшее",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MaxAValue2": "от 1 до 255 чисел, пустых ячеек, логических значений или чисел в текстовом виде, среди которых требуется определить наибольшее",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MinAValue1": "от 1 до 255 чисел, пустых ячеек, логических значений или чисел в текстовом виде, среди которых требуется определить наименьшее",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MinAValue2": "от 1 до 255 чисел, пустых ячеек, логических значений или чисел в текстовом виде, среди которых требуется определить наименьшее",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevPAValue1": "от 1 до 255 значений, составляющих генеральную совокупность; допускаются числовые значения, имена, массивы и ссылки на числовые значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevPAValue2": "от 1 до 255 значений, составляющих генеральную совокупность; допускаются числовые значения, имена, массивы и ссылки на числовые значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VarPAValue1": "от 1 до 255 числовых аргументов, составляющих генеральную совокупность",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VarPAValue2": "от 1 до 255 числовых аргументов, составляющих генеральную совокупность",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevAValue1": "от 1 до 255 значений, составляющих выборку из генеральной совокупности; допускаются числовые значения, имена и ссылки на числовые значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevAValue2": "от 1 до 255 значений, составляющих выборку из генеральной совокупности; допускаются числовые значения, имена и ссылки на числовые значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VarAValue1": "от 1 до 255 числовых аргументов, составляющих выборку из генеральной совокупности",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VarAValue2": "от 1 до 255 числовых аргументов, составляющих выборку из генеральной совокупности",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BahtTextNumber": "число, которое нужно преобразовать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RtdProgID": "имя (КодПрог) зарегистрированной надстройки автоматизации COM. Заключите имя в кавычки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RtdServer": "имя сервера, на котором должна быть запущена надстройка. Заключите имя в кавычки. Если надстройка запускается локально, укажите пустую строку",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RtdTopic1": "от 1 до 38 параметров, задающих элементы данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RtdTopic2": "от 1 до 38 параметров, задающих элементы данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeValueConnection": "имя подключения к кубу OLAP",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeValueMemberexpression1": "срез, определяющий часть куба OLAP, агрегированное значение по которой требуется получить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeMemberConnection": "имя подключения к кубу OLAP",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeMemberMemberexpression": "выражение, результатом которого является имя элемента или кортежа в кубе OLAP",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeMemberCaption": "подпись для отображения в ячейке",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeMemberPropertyConnection": "имя подключения к кубу OLAP",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeMemberPropertyMemberexpression": "выражение, результатом которого является имя элемента в кубе OLAP",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeMemberPropertyProperty": "имя свойства",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeRankedMemberConnection": "имя подключения к кубу OLAP",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeRankedMemberSetexpression": "множество, элемент которого требуется получить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeRankedMemberRank": "порядковый номер элемента, который требуется получить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeRankedMemberCaption": "подпись для отображения в ячейке",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Hex2BinNumber": "шестнадцатеричное число, которое требуется преобразовать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Hex2BinPlaces": "количество знаков для использования",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Hex2DecNumber": "шестнадцатеричное число, которое требуется преобразовать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Hex2OctNumber": "шестнадцатеричное число, которое требуется преобразовать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Hex2OctPlaces": "количество знаков для использования",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Dec2BinNumber": "десятичное целое число, которое требуется преобразовать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Dec2BinPlaces": "количество знаков для использования",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Dec2HexNumber": "десятичное целое число, которое требуется преобразовать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Dec2HexPlaces": "количество знаков для использования",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Dec2OctNumber": "десятичное целое число, которое требуется преобразовать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Dec2OctPlaces": "количество знаков для использования",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Oct2BinNumber": "восьмеричное число, которое требуется преобразовать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Oct2BinPlaces": "количество знаков для использования",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Oct2HexNumber": "восьмеричное число, которое требуется преобразовать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Oct2HexPlaces": "количество знаков для использования",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Oct2DecNumber": "восьмеричное число, которое требуется преобразовать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Bin2DecNumber": "двоичное число, которое требуется преобразовать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Bin2OctNumber": "двоичное число, которое требуется преобразовать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Bin2OctPlaces": "количество знаков для использования",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Bin2HexNumber": "двоичное число, которое требуется преобразовать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.Bin2HexPlaces": "количество знаков для использования",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImSubInumber1": "уменьшаемое комплексное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImSubInumber2": "вычитаемое комплексное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImDivInumber1": "комплексный числитель или делимое",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImDivInumber2": "комплексный знаменатель или делитель",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImPowerInumber": "комплексное число, возводимое в степень",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImPowerNumber": "степень, в которую возводится комплексное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImAbsInumber": "комплексное число, абсолютную величину которого требуется получить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImSqrtInumber": "комплексное число, для которого вычисляется квадратный корень",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImLnInumber": "комплексное число, для которого вычисляется натуральный логарифм",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImLog2Inumber": "комплексное число, для которого вычисляется двоичный логарифм",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImLog10Inumber": "комплексное число, для которого вычисляется десятичный логарифм",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImSinInumber": "комплексное число, для которого вычисляется синус",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImCosInumber": "комплексное число, для которого вычисляется косинус",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImExpInumber": "комплексное число, для которого вычисляется экспонента",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImArgumentInumber": "комплексное число, для которого определяется аргумент",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImConjugateInumber": "комплексное число, для которого определяется сопряженное комплексное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImaginaryInumber": "комплексное число, для которого определяется коэффициент при мнимой части",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImRealInumber": "комплексное число, для которого определяется коэффициент при вещественной (действительной) части",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ComplexRealnum": "действительная часть комплексного числа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ComplexInum": "мнимая часть комплексного числа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ComplexSuffix": "обозначение мнимой единицы в комплексном числе",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImSumInumber1": "от 1 до 255 суммируемых комплексных чисел",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImSumInumber2": "от 1 до 255 суммируемых комплексных чисел",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImProductInumber1": "компл_число1, компл_число2,... — от 1 до 255 перемножаемых комплексных чисел.",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImProductInumber2": "компл_число1, компл_число2,... — от 1 до 255 перемножаемых комплексных чисел.",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SeriessumX": "переменная степенного ряда",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SeriessumN": "показатель степени x для первого члена степенного ряда",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SeriessumM": "шаг увеличения n для каждого следующего члена степенного ряда",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SeriessumCoefficients": "набор коэффициентов при соответствующих степенях x",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FactDoubleNumber": "число, для которого требуется вычислить двойной факториал",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SqrtPiNumber": "число, которое умножается на число пи",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.QuotientNumerator": "делимое",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.QuotientDenominator": "делитель",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DeltaNumber1": "первое число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DeltaNumber2": "второе число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GestepNumber": "проверяемое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GestepStep": "пороговое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IsEvenNumber": "проверяемое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IsOddNumber": "проверяемое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MRoundNumber": "округляемое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MRoundMultiple": "точность, с которой требуется округлить число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ErfLowerlimit": "нижний предел интегрирования ФОШ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ErfUpperlimit": "верхний предел интегрирования ФОШ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ErfcX": "нижний предел интегрирования ФОШ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BesselJX": "значение, для которого вычисляется функция",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BesselJN": "порядок функции Бесселя",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BesselKX": "значение, для которого вычисляется функция",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BesselKN": "порядок функции",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BesselYX": "значение, для которого вычисляется функция",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BesselYN": "порядок функции",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BesselIX": "значение, для которого вычисляется функция",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BesselIN": "порядок функции Бесселя",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.XirrValues": "ряд денежных потоков, соответствующий графику платежей, приведенному в аргументе \"даты\"",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.XirrDates": "расписание дат платежей, соответствующее ряду денежных потоков",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.XirrGuess": "предполагаемое значение результата функции ЧИСТВНДОХ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.XnpvRate": "ставка дисконтирования, применяемая к денежным потокам",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.XnpvValues": "ряд денежных потоков, соответствующий графику платежей, приведенному в аргументе \"даты\"",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.XnpvDates": "расписание дат платежей, соответствующее ряду денежных потоков",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceMatSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceMatMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceMatIssue": "дата выпуска ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceMatRate": "процентная ставка дохода по ценным бумагам на дату выпуска",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceMatYld": "годовая доходность ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceMatBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldMatSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldMatMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldMatIssue": "дата выпуска ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldMatRate": "процентная ставка дохода по ценным бумагам на дату выпуска",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldMatPr": "цена за 100 рублей номинальной стоимости ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldMatBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IntrateSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IntrateMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IntrateInvestment": "сумма, инвестированная в ценные бумаги",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IntrateRedemption": "сумма, которая должна быть получена при погашении ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IntrateBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ReceivedSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ReceivedMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ReceivedInvestment": "сумма, инвестированная в ценные бумаги",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ReceivedDiscount": "скидка на ценные бумаги",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ReceivedBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DiscSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DiscMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DiscPr": "цена за 100 рублей номинальной стоимости ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DiscRedemption": "выкупная стоимость ценных бумаг за 100 рублей номинальной стоимости",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DiscBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceDiscSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceDiscMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceDiscDiscount": "ставка дисконтирования ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceDiscRedemption": "выкупная стоимость ценных бумаг за 100 рублей номинальной стоимости",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceDiscBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldDiscSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldDiscMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldDiscPr": "цена за 100 рублей номинальной стоимости ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldDiscRedemption": "выкупная стоимость ценных бумаг за 100 рублей номинальной стоимости",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldDiscBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TbillEqSettlement": "дата расчета за казначейский вексель, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TbillEqMaturity": "дата погашения казначейского векселя, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TbillEqDiscount": "ставка дисконтирования казначейского векселя",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TbillPriceSettlement": "дата расчета за казначейский вексель, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TbillPriceMaturity": "дата погашения казначейского векселя, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TbillPriceDiscount": "ставка дисконтирования казначейского векселя",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TbillYieldSettlement": "дата расчета за казначейский вексель, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TbillYieldMaturity": "дата погашения казначейского векселя, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TbillYieldPr": "цена за 100 рублей номинальной стоимости казначейского векселя",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceRate": "годовая купонная ставка ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceYld": "годовая доходность ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceRedemption": "выкупная стоимость ценных бумаг за 100 рублей номинальной стоимости",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceFrequency": "количество купонных выплат за год",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldRate": "годовая купонная ставка ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldPr": "цена ценных бумаг за 100 рублей номинальной стоимости",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldRedemption": "выкупная стоимость ценных бумаг за 100 рублей номинальной стоимости",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldFrequency": "количество купонных выплат за год",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DollarDeFractionaldollar": "число, выраженное в виде дроби",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DollarDeFraction": "целое число для использования в знаменателе дроби",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DollarFrDecimaldollar": "десятичное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DollarFrFraction": "целое число для использования в знаменателе дроби",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NominalEffectrate": "фактическая процентная ставка",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NominalNpery": "количество периодов в году, за которые начисляются сложные проценты",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.EffectNominalrate": "номинальная процентная ставка",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.EffectNpery": "количество периодов в году, за которые начисляются сложные проценты",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CumPrincRate": "процентная ставка",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CumPrincNper": "общее число периодов выплат",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CumPrincPv": "текущая стоимость инвестиции",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CumPrincStartperiod": "номер первого периода, включенного в вычисления",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CumPrincEndperiod": "номер последнего периода, включенного в вычисления",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CumPrincType": "выбор времени платежа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CumIpmtRate": "процентная ставка",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CumIpmtNper": "общее число периодов выплат",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CumIpmtPv": "текущая стоимость инвестиции",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CumIpmtStartperiod": "номер первого периода, включенного в вычисления",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CumIpmtEndperiod": "номер последнего периода, включенного в вычисления",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CumIpmtType": "выбор времени платежа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.EDateStartdate": "порядковый номер начальной даты",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.EDateMonths": "количество месяцев до или после начальной даты",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.EOMonthStartdate": "порядковый номер начальной даты",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.EOMonthMonths": "количество месяцев до или после начальной даты",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YearFracStartdate": "порядковый номер начальной даты",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YearFracEnddate": "порядковый номер конечной даты",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.YearFracBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaybsSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaybsMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaybsFrequency": "количество купонных выплат за год",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaybsBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaysSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaysMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaysFrequency": "количество купонных выплат за год",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaysBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaysncSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaysncMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaysncFrequency": "количество купонных выплат за год",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaysncBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupncdSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupncdMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupncdFrequency": "количество купонных выплат за год",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupncdBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupNumSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupNumMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupNumFrequency": "количество купонных выплат за год",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupNumBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CouppcdSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CouppcdMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CouppcdFrequency": "количество купонных выплат за год",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CouppcdBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DurationSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DurationMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DurationCoupon": "годовая купонная ставка ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DurationYld": "годовая доходность ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DurationFrequency": "количество купонных выплат за год",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DurationBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MDurationSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MDurationMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MDurationCoupon": "годовая купонная ставка ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MDurationYld": "годовая доходность ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MDurationFrequency": "количество купонных выплат за год",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MDurationBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLPriceSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLPriceMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLPriceLastinterest": "дата последнего купона для ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLPriceRate": "процентная ставка для ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLPriceYld": "годовая доходность ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLPriceRedemption": "выкупная стоимость ценных бумаг за 100 рублей номинальной стоимости",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLPriceFrequency": "количество купонных выплат за год",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLPriceBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLYieldSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLYieldMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLYieldLastinterest": "дата последнего купона для ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLYieldRate": "процентная ставка для ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLYieldPr": "стоимость ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLYieldRedemption": "выкупная стоимость ценных бумаг за 100 рублей номинальной стоимости",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLYieldFrequency": "количество купонных выплат за год",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLYieldBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFPriceSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFPriceMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFPriceIssue": "дата выпуска ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFPriceFirstcoupon": "дата первого купона для ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFPriceRate": "процентная ставка для ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFPriceYld": "годовая доходность ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFPriceRedemption": "выкупная стоимость ценных бумаг за 100 рублей номинальной стоимости",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFPriceFrequency": "количество купонных выплат за год",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFPriceBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFYieldSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFYieldMaturity": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFYieldIssue": "дата выпуска ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFYieldFirstcoupon": "дата первого купона для ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFYieldRate": "процентная ставка для ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFYieldPr": "стоимость ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFYieldRedemption": "выкупная стоимость ценных бумаг за 100 рублей номинальной стоимости",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFYieldFrequency": "количество купонных выплат за год",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFYieldBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RandBetweenBottom": "наименьшее целое число, которое возвращает функция СЛУЧМЕЖДУ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RandBetweenTop": "наибольшее целое число, которое возвращает функция СЛУЧМЕЖДУ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.WeekNumSerialnumber": "код, используемый Spreadsheet для расчета даты и времени",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.WeekNumReturntype": "число (1 или 2), определяющее тип возвращаемого значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AmordegrcCost": "затраты на приобретение актива",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AmordegrcDatepurchased": "дата приобретения актива",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AmordegrcFirstperiod": "дата окончания первого периода",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AmordegrcSalvage": "остаточная стоимость в конце времени эксплуатации актива.",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AmordegrcPeriod": "период",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AmordegrcRate": "ставка амортизации",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AmordegrcBasis": "годовой базис: 0 — 360 дней, 1 — фактический, 3 — 365 дней.",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AmorlincCost": "затраты на приобретение актива",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AmorlincDatepurchased": "дата приобретения актива",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AmorlincFirstperiod": "дата окончания первого периода",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AmorlincSalvage": "остаточная стоимость в конце времени эксплуатации актива.",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AmorlincPeriod": "период",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AmorlincRate": "ставка амортизации",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AmorlincBasis": "годовой базис: 0 — 360 дней, 1 — фактический, 3 — 365 дней.",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ConvertNumber": "преобразуемое значение в исходных единицах измерения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ConvertFromunit": "единицы измерения для аргумента \"число\"",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ConvertTounit": "единицы измерения для результата",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintIssue": "дата выпуска ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintFirstinterest": "дата первой выплаты процентов по ценным бумагам, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintSettlement": "дата расчета за ценные бумаги, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintRate": "годовая процентная ставка для купонов по ценным бумагам",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintPar": "номинальная стоимость ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintFrequency": "количество купонных выплат за год",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintCalcmethod": "логическое значение: для расчета с даты выпуска = ИСТИНА или опущено; для расчета с даты последнего купона = ЛОЖЬ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintmIssue": "дата выпуска ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintmSettlement": "дата погашения ценных бумаг, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintmRate": "годовая процентная ставка для купонов по ценным бумагам",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintmPar": "номинальная стоимость ценных бумаг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintmBasis": "используемый способ вычисления дня",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.WorkDayStartdate": "начальная дата, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.WorkDayDays": "количество не выходных и не праздничных дней до или после начальной даты",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.WorkDayHolidays": "необязательный список из одной или нескольких заданных порядковыми номерами дат для исключения из рабочего календаря, таких как государственные праздники",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NetworkDaysStartdate": "порядковый номер начальной даты",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NetworkDaysEnddate": "порядковый номер конечной даты",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NetworkDaysHolidays": "необязательный список из одной или нескольких заданных порядковыми номерами дат для исключения из рабочего календаря, таких как государственные праздники",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GcdNumber1": "от 1 до 255 значений",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GcdNumber2": "от 1 до 255 значений",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MultinomialNumber1": "от 1 до 255 значений",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MultinomialNumber2": "от 1 до 255 значений",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LcmNumber1": "от 1 до 255 значений, для которых определяется наименьшее общее кратное",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LcmNumber2": "от 1 до 255 значений, для которых определяется наименьшее общее кратное",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FvSchedulePrincipal": "стоимость инвестиции на текущий момент",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FvScheduleSchedule": "массив применяемых процентных ставок",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeKpiMemberConnection": "имя подключения к кубу OLAP",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeKpiMemberKpiname": "имя КПЭ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeKpiMemberKpiproperty": "свойство КПЭ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeKpiMemberCaption": "подпись для отображения в ячейке",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeSetConnection": "имя подключения к кубу OLAP",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeSetSetexpression": "выражение для множества",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeSetCaption": "подпись для отображения в ячейке",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeSetSortorder": "порядок сортировки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeSetSortby": "поле, по которому требуется выполнить сортировку",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeSetCountSet": "множество, подсчет элементов которого требуется выполнить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IfErrorValue": "любое значение, выражение или ссылка",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IfErrorValueiferror": "любое значение, выражение или ссылка",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CountIfsCriteriarange": "диапазон ячеек, проверяемый на соответствие определенному условию",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CountIfsCriteria": "условие в форме числа, выражения или текста, определяющее подсчитываемые ячейки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SumIfsSumrange": "фактически суммируемые ячейки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SumIfsCriteriarange": "диапазон ячеек, проверяемых на соответствие определенному условию",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SumIfsCriteria": "условие в форме числа, выражения или текста, определяющее суммируемые ячейки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AverageIfRange": "диапазон обрабатываемых ячеек",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AverageIfCriteria": "условие в форме числа, выражения или текста, определяющее суммируемые ячейки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AverageIfAveragerange": "фактические ячейки для расчета среднего значения. Если этот аргумент опущен, будут использоваться ячейки, заданные аргументом \"диапазон\"",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AverageIfsAveragerange": "фактические ячейки, используемые для расчета среднего значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AverageIfsCriteriarange": "диапазон ячеек, проверяемых на соответствие определенному условию",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AverageIfsCriteria": "условие в форме числа, выражения или текста, определяющее ячейки, по которым будет выполняться расчет среднего значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AggregateFunctionnum": "число от 1 до 19, которое указывает используемую функцию сведения.",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AggregateOptions": "число от 0 до 7, которое указывает значения, пропускаемые при сведении",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AggregateArray": "массив или диапазон числовых данных для вычисления сводного значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.AggregateK": "указывает позицию в массиве; k-е наибольшее, k-е наименьшее, k-й процентиль или k-й квартиль.",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDotDistNumbers": "число успешных испытаний",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDotDistTrials": "число независимых испытаний",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDotDistProbabilitys": "вероятность успеха каждого испытания",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDotDistCumulative": "логическое значение, определяющее вид функции: интегральная функция распределения (ИСТИНА) или весовая функция распределения (ЛОЖЬ)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDotInvTrials": "число испытаний Бернулли",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDotInvProbabilitys": "вероятность успеха в каждом испытании",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDotInvAlpha": "значение критерия, число в диапазоне от 0 до 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ConfidenceNormAlpha": "уровень значимости, используемый для вычисления доверительного уровня - число, большее 0 и меньшее 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ConfidenceNormStandarddev": "стандартное отклонение генеральной совокупности для интервала данных (предполагается известным). Должно быть больше нуля",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ConfidenceNormSize": "размер выборки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ConfidenceDotTAlpha": "уровень значимости, используемый для вычисления доверительного уровня - число, большее 0 и меньшее 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ConfidenceDotTStandarddev": "стандартное отклонение генеральной совокупности для интервала данных (предполагается известным). Должно быть больше нуля",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ConfidenceDotTSize": "размер выборки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotTestActualrange": "диапазон, содержащий наблюдения, подлежащие сравнению с ожидаемыми значениями",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotTestExpectedrange": "диапазон, содержащий отношение произведений итогов по строкам и столбцам к общему итогу",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotTestArray1": "первый массив или диапазон - числа, массивы или ссылки на ячейки, содержащие числа (пробелы игнорируются)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotTestArray2": "второй массив или диапазон - числа, массивы или ссылки на ячейки, содержащие числа (пробелы игнорируются)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CovariancePArray1": "первый диапазон целых чисел - числа, массивы или ссылки на ячейки, содержащие числа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CovariancePArray2": "второй диапазон целых чисел - числа, массивы или ссылки на ячейки, содержащие числа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CovarianceSArray1": "первый диапазон целых чисел - числа, массивы или ссылки на ячейки, содержащие числа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CovarianceSArray2": "второй диапазон целых чисел - числа, массивы или ссылки на ячейки, содержащие числа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ExponDotDistX": "значение функции, неотрицательное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ExponDotDistLambda": "значение параметра, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ExponDotDistCumulative": "логическое значение, определяющее возвращаемую функцию: интегральную функцию распределения, если ИСТИНА; функцию плотности распределения вероятности, если ЛОЖЬ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDotDistX": "значение, для которого требуется вычислить распределение, неотрицательное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDotDistAlpha": "параметр распределения, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDotDistBeta": "параметр распределения, положительное число. Если бета=1, функция ГАММА.РАСП возвращает стандартное гамма распределение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDotDistCumulative": "логическое значение, определяющее вид функции: интегральная функция распределения (ИСТИНА) или весовая функция распределения (ЛОЖЬ или отсутствие значения)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDotInvProbability": "вероятность, связанная с гамма-распределением, число в диапазоне от 0 до 1 включительно",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDotInvAlpha": "параметр распределения, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDotInvBeta": "параметр распределения, положительное число. Если бета=1, то ГАММА.ОБР возвращает обратное стандартное гамма-распределение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ModeMultNumber1": "от 1 до 255 чисел, имен, массивов или ссылок на числовые значения, для которых вычисляется мода",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ModeMultNumber2": "от 1 до 255 чисел, имен, массивов или ссылок на числовые значения, для которых вычисляется мода",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ModeSnglNumber1": "от 1 до 255 чисел, имен, массивов или ссылок на числовые значения, для которых вычисляется мода",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ModeSnglNumber2": "от 1 до 255 чисел, имен, массивов или ссылок на числовые значения, для которых вычисляется мода",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NormDistX": "значение, для которого строится распределение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NormDistMean": "арифметическое среднее распределения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NormDistStandarddev": "стандартное отклонение распределения, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NormDistCumulative": "логическое значение, определяющее вид функции: интегральная функция распределения (ИСТИНА) или функция плотности вероятности (ЛОЖЬ)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NormInvProbability": "вероятность, соответствующая нормальному распределению, число в диапазоне от 0 до 1 включительно",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NormInvMean": "арифметическое среднее распределения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NormInvStandarddev": "стандартное отклонение распределения, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentileExcArray": "массив или диапазон с численными значениями, который определяет относительное положение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentileExcK": "значение процентиля в интервале от 0 до 1 включительно",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentileIncArray": "массив или диапазон с численными значениями, который определяет относительное положение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentileIncK": "значение процентиля в интервале от 0 до 1 включительно",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentRankExcArray": "массив или диапазон с численными значениями, который определяет относительное положение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentRankExcX": "значение, для которого определяется ранг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentRankExcSignificance": "необязательное значение, определяющее количество значащих цифр в возвращаемом значении процентного содержания; по умолчанию принимается равным 3 (0,xxx%)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentRankIncArray": "массив или диапазон с численными значениями, который определяет относительное положение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentRankIncX": "значение, для которого определяется ранг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentRankIncSignificance": "необязательное значение, определяющее количество значащих цифр в возвращаемом значении процентного содержания; по умолчанию принимается равным 3 (0,xxx%)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PoissonDotDistX": "количество событий",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PoissonDotDistMean": "ожидаемое числовое значение, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PoissonDotDistCumulative": "логическое значение, определяющее вид функции: интегральная функция распределения (ИСТИНА) или весовая функция распределения (ЛОЖЬ)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.QuartileExcArray": "массив или диапазон ячеек с числовыми значениями, для которых определяется значение квартиля",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.QuartileExcQuart": "значение: минимальное = 0; первый квартиль = 1; медиана = 2; третий квартиль = 3; максимальное значение = 4",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.QuartileIncArray": "массив или диапазон ячеек с числовыми значениями, для которых определяется значение квартиля",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.QuartileIncQuart": "значение: минимальное = 0; первый квартиль = 1; медиана = 2; третий квартиль = 3; максимальное значение = 4",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RankDotAvgNumber": "число, для которого определяется ранг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RankDotAvgRef": "массив или ссылка на список чисел. Нечисловые значения в ссылке игнорируются",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RankDotAvgOrder": "число: опущено или 0 - сортировка рангов в списке по убыванию; любое ненулевое значение - сортировка рангов в списке по возрастанию",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RankDotEqNumber": "число, для которого определяется ранг",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RankDotEqRef": "массив или ссылка на список чисел. Нечисловые значения в ссылке игнорируются",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RankDotEqOrder": "число: опущено или 0 - сортировка рангов в списке по убыванию; любое ненулевое значение - сортировка рангов в списке по возрастанию",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevDotSNumber1": "от 1 до 255 значений, составляющих выборку из генеральной совокупности; допускаются числовые значения и ссылки на числовые значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevDotSNumber2": "от 1 до 255 значений, составляющих выборку из генеральной совокупности; допускаются числовые значения и ссылки на числовые значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevDotPNumber1": "от 1 до 255 значений, составляющих генеральную совокупность; допускаются числовые значения и ссылки на числовые значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevDotPNumber2": "от 1 до 255 значений, составляющих генеральную совокупность; допускаются числовые значения и ссылки на числовые значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotDistX": "числовое значение, для которого требуется вычислить распределение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotDistDegfreedom": "целое, указывающее количество степеней свободы",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotDistCumulative": "логическое значение, определяющее вид функции: интегральная функция распределения (ИСТИНА) или функция плотности вероятности (ЛОЖЬ)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotDistDot2tX": "числовое значение, для которого требуется вычислить распределение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotDistDot2tDegfreedom": "целое, указывающее количество степеней свободы",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotDistDotTtX": "числовое значение, для которого требуется вычислить распределение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotDistDotTtDegfreedom": "целое, указывающее количество степеней свободы",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotInvProbability": "вероятность, связанная с двусторонним t-распределением Стьюдента, число от 0 до 1 включительно",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotInvDegfreedom": "положительное целое число степеней свободы, характеризующее распределение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotInvDot2tProbability": "вероятность, связанная с двусторонним t-распределением Стьюдента, число от 0 до 1 включительно",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotInvDot2tDegfreedom": "положительное целое число степеней свободы, характеризующее распределение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VarDotSNumber1": "от 1 до 255 значений, составляющих выборку из генеральной совокупности",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VarDotSNumber2": "от 1 до 255 значений, составляющих выборку из генеральной совокупности",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VarDotPNumber1": "от 1 до 255 числовых аргументов, составляющих генеральную совокупность",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.VarDotPNumber2": "от 1 до 255 числовых аргументов, составляющих генеральную совокупность",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.WeibullDotDistX": "значение, для которого вычисляется функция, неотрицательное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.WeibullDotDistAlpha": "параметр распределения, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.WeibullDotDistBeta": "параметр распределения, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.WeibullDotDistCumulative": "логическое значение, определяющее вид функции: интегральная функция распределения (ИСТИНА) или весовая функция распределения (ЛОЖЬ)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NetworkDaysIntlStartdate": "порядковый номер начальной даты",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NetworkDaysIntlEnddate": "порядковый номер конечной даты",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NetworkDaysIntlWeekend": "число или строка, указывающая на выходные дни",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NetworkDaysIntlHolidays": "необязательный список из одной или нескольких заданных порядковыми номерами дат для исключения из рабочего календаря, таких как государственные праздники",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.WorkDayIntlStartdate": "начальная дата, заданная порядковым номером",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.WorkDayIntlDays": "количество не выходных и не праздничных дней до или после начальной даты",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.WorkDayIntlWeekend": "число или строка, указывающая на выходные дни",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.WorkDayIntlHolidays": "необязательный список из одной или нескольких заданных порядковыми номерами дат для исключения из рабочего календаря, таких как государственные праздники",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IsoCeilingNumber": "округляемое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IsoCeilingSignificance": "кратное, до которого требуется округлить (необязательно)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistX": "значение в интервале между A и B, для которого вычисляется функция",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistAlpha": "параметр распределения; должен быть положительной величиной",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistBeta": "параметр распределения; должен быть положительной величиной",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistCumulative": "логическое значение, определяющее вид функции: интегральная функция распределения (ИСТИНА) или функция плотности вероятности (ЛОЖЬ)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistA": "необязательная нижняя граница интервала изменения x. Если опущено, A = 0",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistB": "необязательная верхняя граница интервала изменения x. Если опущено, В = 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDotInvProbability": "вероятность, связанная с бета распределением",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDotInvAlpha": "параметр распределения; должен быть положительной величиной",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDotInvBeta": "параметр распределения; должен быть положительной величиной",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDotInvA": "необязательная нижняя граница интервала изменения x. Если опущено, A = 0",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDotInvB": "необязательная верхняя граница интервала изменения x. Если опущено, В = 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotDistX": "значение, для которого требуется вычислить распределение, неотрицательное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotDistDegfreedom": "число степеней свободы - число от 1 до 10^10, исключая 10^10",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotDistCumulative": "логическое значение, определяющее вид функции: интегральная функция распределения (ИСТИНА) или функция плотности вероятности (ЛОЖЬ)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotDistDotRtX": "значение, для которого требуется вычислить распределение, неотрицательное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotDistDotRtDegfreedom": "число степеней свободы - число от 1 до 10^10, исключая 10^10",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotInvProbability": "вероятность, связанная с распределением хи-квадрат, значение в диапазоне от 0 до 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotInvDegfreedom": "число степеней свободы - число от 1 до 10^10, исключая 10^10",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotInvDotRtProbability": "вероятность, связанная с распределением хи-квадрат, значение в диапазоне от 0 до 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotInvDotRtDegfreedom": "число степеней свободы - число от 1 до 10^10, исключая 10^10",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotDistX": "значение, для которого вычисляется функция, неотрицательное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotDistDegfreedom1": "число степеней свободы - число от 1 до 10^10, исключая 10^10",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotDistDegfreedom2": "знаменатель степеней свободы - число от 1 до 10^10, исключая 10^10",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotDistCumulative": "логическое значение, определяющее вид функции: интегральная функция распределения (ИСТИНА) или функция плотности вероятности (ЛОЖЬ)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotDistDotRtX": "значение, для которого вычисляется функция, неотрицательное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotDistDotRtDegfreedom1": "число степеней свободы - число от 1 до 10^10, исключая 10^10",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotDistDotRtDegfreedom2": "знаменатель степеней свободы - число от 1 до 10^10, исключая 10^10",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotInvProbability": "вероятность, связанная с F-интегральным распределением, число в диапазоне от 0 до 1 включительно",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotInvDegfreedom1": "числитель степеней свободы - число от 1 до 10^10, исключая 10^10",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotInvDegfreedom2": "знаменатель степеней свободы - число от 1 до 10^10, исключая 10^10",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotinvDotRtProbability": "вероятность, связанная с F-интегральным распределением, число в диапазоне от 0 до 1 включительно",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotinvDotRtDegfreedom1": "числитель степеней свободы - число от 1 до 10^10, исключая 10^10",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotinvDotRtDegfreedom2": "знаменатель степеней свободы - число от 1 до 10^10, исключая 10^10",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.HypgeomDotDistSamples": "число успехов в выборке",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.HypgeomDotDistNumbersample": "размер выборки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.HypgeomDotDistPopulations": "число успехов в совокупности",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.HypgeomDotDistNumberpop": "размер совокупности",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.HypgeomDotDistCumulative": "логическое значение, определяющее вид функции: интегральная функция распределения (ИСТИНА) или функция плотности вероятности (ЛОЖЬ)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNormDistX": "значение, для которого вычисляется функция, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNormDistMean": "среднее ln(x)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNormDistStandarddev": "стандартное отклонение ln(x), положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNormDistCumulative": "логическое значение, определяющее вид функции: интегральная функция распределения (ИСТИНА) или функция плотности вероятности (ЛОЖЬ)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNormInvProbability": "вероятность, связанная с нормальным логарифмическим распределением, число в диапазоне от 0 до 1 включительно",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNormInvMean": "среднее ln(x)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNormInvStandarddev": "стандартное отклонение ln(x), положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NegbinomDotDistNumberf": "число неудачных испытаний",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NegbinomDotDistNumbers": "пороговое значение числа успешных испытаний",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NegbinomDotDistProbabilitys": "вероятность успеха - число в интервале от 0 до 1",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NegbinomDotDistCumulative": "логическое значение, определяющее вид функции: интегральная функция распределения (ИСТИНА) или функция плотности вероятности (ЛОЖЬ)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NormSDistZ": "значение, для которого строится распределение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NormSDistCumulative": "логическое значение, определяющее вид функции: интегральная функция распределения (ИСТИНА) или функция плотности вероятности (ЛОЖЬ)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NormSInvProbability": "вероятность, соответствующая нормальному распределению",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotTestArray1": "первый набор данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotTestArray2": "второй набор данных",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotTestTails": "число хвостов распределения (1 или 2)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotTestType": "вид t-test: парный = 1, двухпарный = 2, двухпарный с неравным отклонением = 3",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ZDotTestArray": "массив или диапазон, с которыми сравнивается x",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ZDotTestX": "проверяемое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ZDotTestSigma": "известное стандартное отклонение генеральной совокупности",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ErfPreciseX": "нижний предел интегрирования ФОШ.ТОЧН",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ErfcPreciseX": "нижний предел интегрирования ДФОШ.ТОЧН",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaLnPreciseX": "значение, для которого вычисляется ГАММАНЛОГ.ТОЧН, положительное число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CeilingDotPreciseNumber": "округляемое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CeilingDotPreciseSignificance": "кратное, до которого требуется округлить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FloorDotPreciseNumber": "округляемое числовое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FloorDotPreciseSignificance": "кратное, до которого требуется округлить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ACotNumber": "котангенс искомого угла",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ACotHNumber": "гиперболический котангенс искомого угла",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CotNumber": "угол в радианах, для которого требуется найти котангенс",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CotHNumber": "угол в радианах, для которого требуется найти гиперболический котангенс",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CscNumber": "угол в радианах, для которого требуется найти косеканс",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CscHNumber": "угол в радианах, для которого требуется найти гиперболический косеканс",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SecNumber": "угол в радианах, для которого требуется найти секанс",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SecHNumber": "угол в радианах, для которого требуется найти гиперболический секанс",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImTanInumber": "комплексное число, для которого требуется найти тангенс",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImCotInumber": "комплексное число, для которого требуется найти котангенс",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImCscInumber": "комплексное число, для которого требуется найти косеканс",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImCscHInumber": "комплексное число, для которого требуется найти гиперболический косеканс",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImSecInumber": "комплексное число, для которого требуется найти секанс",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImSecHInumber": "комплексное число, для которого требуется найти гиперболический секанс",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BitAndNumber1": "десятичное представление двоичного числа, для которого требуется выполнить вычисление",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BitAndNumber2": "десятичное представление двоичного числа, для которого требуется выполнить вычисление",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BitOrNumber1": "десятичное представление двоичного числа, для которого требуется выполнить вычисление",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BitOrNumber2": "десятичное представление двоичного числа, для которого требуется выполнить вычисление",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BitXorNumber1": "десятичное представление двоичного числа, для которого требуется выполнить вычисление",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BitXorNumber2": "десятичное представление двоичного числа, для которого требуется выполнить вычисление",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BitLShiftNumber": "десятичное представление двоичного числа, для которого требуется выполнить вычисление",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BitLShiftShiftamount": "количество битов, на которое требуется сдвинуть число влево",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BitRShiftNumber": "десятичное представление двоичного числа, для которого требуется выполнить вычисление",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BitRShiftShiftamount": "количество битов, на которое требуется сдвинуть число вправо",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PermutationaNumber": "общее число объектов",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PermutationaNumberchosen": "число объектов в каждой перестановке",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CombinANumber": "общее число элементов",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CombinANumberchosen": "число элементов в каждой комбинации",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.XOrLogical1": "от 1 до 254 проверяемых условий, которые могут принимать значения ИСТИНА или ЛОЖЬ и могут быть логическими значениями, массивами или ссылками",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.XOrLogical2": "от 1 до 254 проверяемых условий, которые могут принимать значения ИСТИНА или ЛОЖЬ и могут быть логическими значениями, массивами или ссылками",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PDurationRate": "процентная ставка за период",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PDurationPv": "текущая стоимость инвестиции",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PDurationFv": "требуемая будущая стоимость инвестиции",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BaseNumber": "число, которое требуется преобразовать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BaseRadix": "основание системы счисления, в которую требуется преобразовать число",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BaseMinlength": "минимальная длина возвращаемой строки (если этот параметр опущен, нули в начале не добавляются)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DecimalNumber": "число, которое требуется преобразовать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DecimalRadix": "основание системы счисления преобразуемого числа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DaysEnddate": "нач_дата и кон_дата — две даты, количество дней между которыми необходимо определить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.DaysStartdate": "нач_дата и кон_дата — две даты, количество дней между которыми необходимо определить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDistRangeTrials": "число независимых испытаний",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDistRangeProbabilitys": "вероятность успеха в каждом испытании",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDistRangeNumbers": "количество успешных испытаний",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDistRangeNumbers2": "если этот параметр указан, функция возвращает вероятность того, что число успешных испытаний будет находиться в диапазоне между значениями число_успехов и число_успехов2",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaX": "значение, для которого требуется вычислить гамма-функцию",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SkewPNumber1": "от 1 до 254 числовых значений или имен, массивов чисел или ссылок на числовые значения, для которых вычисляется асимметричность",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SkewPNumber2": "от 1 до 254 числовых значений или имен, массивов чисел или ссылок на числовые значения, для которых вычисляется асимметричность",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.PhiX": "число, для которого требуется найти плотность стандартного нормального распределения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RRINper": "число периодов для инвестиции",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RRIPv": "текущая стоимость инвестиции",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.RRIFv": "будущая стоимость инвестиции",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.UnicodeText": "знак, для которого требуется получить значение Юникода",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MUnitDimension": "целое число, задающее размер единичной матрицы, которую требуется получить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ArabicText": "римское число, которое требуется преобразовать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ISOWeekNumDate": "код даты и времени, используемый в Spreadsheet для вычислений со значениями этого типа",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NumberValueText": "строка, представляющая число, которое требуется преобразовать",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NumberValueDecimalseparator": "знак, используемый в строке в качестве десятичного разделителя",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.NumberValueGroupseparator": "знак, используемый в строке в качестве разделителя групп разрядов",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SheetValue": "имя листа или ссылка на лист, номер которого требуется получить (если этот параметр опущен, возвращается номер листа, содержащего функцию)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SheetsReference": "ссылка, для которой требуется определить число содержащихся в ней листов (если этот параметр опущен, возвращается число листов в книге, содержащей функцию)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FormulaTextReference": "ссылка на формулу",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IsFormulaReference": "ссылка на ячейку, которую требуется проверить (может быть ссылкой на ячейку, формулой или именем, указывающим на ячейку)",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IfNAValue": "любое значение, выражение или ссылка",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IfNAValueifna": "любое значение, выражение или ссылка",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CeilingMathNumber": "округляемое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CeilingMathSignificance": "кратное, до которого требуется округлить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.CeilingMathMode": "если этот параметр задан и отличен от нуля, функция округляет число в направлении от нуля",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FloorMathNumber": "округляемое значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FloorMathSignificance": "кратное, до которого требуется округлить",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FloorMathMode": "если этот параметр задан и отличен от нуля, функция округляет в направлении к нулю",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImSinHInumber": "комплексное число, для которого требуется найти гиперболический синус",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ImCosHInumber": "комплексное число, для которого требуется найти гиперболический косинус",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FunctionFilterXMLXml": "допустимая строка в формате XML",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FunctionFilterXMLXpath": "строка в стандартном формате XPath",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.FunctionWebServiceUrl": "URL-адрес веб-службы",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.EncodeURLText": "строка, которую нужно преобразовать в кодировку URL",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ConcatText1": "строки или диапазоны текста (от 1 до 254), которые будут объединены в одну строку",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.ConcatText2": "строки или диапазоны текста (от 1 до 254), которые будут объединены в одну строку",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IfsLogicaltest": "должно быть значением или выражением, которое можно оценить как ИСТИНА или ЛОЖЬ",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.IfsValueiftrue": "значение возвращается, если в результате логической проверки будет получено значение ИСТИНА",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MaxIfsMaxrange": "ячейки, в которых определяется максимальное значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MaxIfsCriteriarange": "диапазон ячеек, которые требуется вычислить для определенного условия",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MaxIfsCriteria": "условие или критерии в форме числа, выражения или текста, которые определяют, какие ячейки будут включены при определении максимального значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MinIfsMinrange": "ячейки, в которых определяется минимальное значение",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MinIfsCriteriarange": "диапазон ячеек, которые требуется вычислить для определенного условия",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.MinIfsCriteria": "условие или критерии в форме числа, выражения или текста, которые определяют, какие ячейки будут включены при определении минимального значения",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SwitchExpression": "выражение для оценки",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SwitchValue1": "значение для сравнения с выражением",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SwitchResult1": "результат возвращается, если соответствующее значение соответствует выражению",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SwitchDefaultOrValue2": "значение для сравнения с выражением",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SwitchResult2": "результат возвращается, если соответствующее значение соответствует выражению",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SwitchDefaultOrValue3": "значение для сравнения с выражением",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.SwitchResult3": "результат возвращается, если соответствующее значение соответствует выражению",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TextJoinDelimeter": "символ или строка, которые вставляются между каждым элементом текста",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TextJoinIgnoreEmpty": "если установлено значение ИСТИНА (по умолчанию), пустые ячейки пропускаются",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TextJoinText1": "строки или диапазоны текста (от 1 до 252), которые будут объединены",
  "XtraSpreadsheetFunctionArgumentDescriptionStringId.TextJoinText2": "строки или диапазоны текста (от 1 до 252), которые будут объединены",
  "XtraSpreadsheetFunctionArgumentNameStringId.CountValue1": "значение1",
  "XtraSpreadsheetFunctionArgumentNameStringId.CountValue2": "значение2",
  "XtraSpreadsheetFunctionArgumentNameStringId.IfLogicaltest": "лог_выражение",
  "XtraSpreadsheetFunctionArgumentNameStringId.IfValueiftrue": "значение_если_истина",
  "XtraSpreadsheetFunctionArgumentNameStringId.IfValueiffalse": "значение_если_ложь",
  "XtraSpreadsheetFunctionArgumentNameStringId.IsNAValue": "значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.IsErrorValue": "значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.SumNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.SumNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.AverageNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.AverageNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.MinNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.MinNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.MaxNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.MaxNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.RowReference": "ссылка",
  "XtraSpreadsheetFunctionArgumentNameStringId.ColumnReference": "ссылка",
  "XtraSpreadsheetFunctionArgumentNameStringId.NpvRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.NpvValue1": "значение1",
  "XtraSpreadsheetFunctionArgumentNameStringId.NpvValue2": "значение2",
  "XtraSpreadsheetFunctionArgumentNameStringId.StDevNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.StDevNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.DollarNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.DollarDecimals": "число_знаков",
  "XtraSpreadsheetFunctionArgumentNameStringId.FixedNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.FixedDecimals": "число_знаков",
  "XtraSpreadsheetFunctionArgumentNameStringId.FixedNocommas": "без_разделителей",
  "XtraSpreadsheetFunctionArgumentNameStringId.SinNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.CosNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.TanNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ATanNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.SqrtNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ExpNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.LnNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.Log10Number": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.AbsNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.IntNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.SignNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.RoundNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.RoundNumdigits": "число_разрядов",
  "XtraSpreadsheetFunctionArgumentNameStringId.LookupLookupvalue": "искомое_значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.LookupLookupvector": "просматриваемый_вектор",
  "XtraSpreadsheetFunctionArgumentNameStringId.LookupResultvector": "вектор_результатов",
  "XtraSpreadsheetFunctionArgumentNameStringId.IndexArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.IndexRownum": "номер_строки",
  "XtraSpreadsheetFunctionArgumentNameStringId.IndexColumnnum": "номер_столбца",
  "XtraSpreadsheetFunctionArgumentNameStringId.ReptText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.ReptNumbertimes": "число_повторений",
  "XtraSpreadsheetFunctionArgumentNameStringId.MidText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.MidStartnum": "начальная_позиция",
  "XtraSpreadsheetFunctionArgumentNameStringId.MidNumchars": "количество_знаков",
  "XtraSpreadsheetFunctionArgumentNameStringId.LenText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.ValueText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.AndLogical1": "логическое_значение1",
  "XtraSpreadsheetFunctionArgumentNameStringId.AndLogical2": "логическое_значение2",
  "XtraSpreadsheetFunctionArgumentNameStringId.OrLogical1": "логическое_значение1",
  "XtraSpreadsheetFunctionArgumentNameStringId.OrLogical2": "логическое_значение2",
  "XtraSpreadsheetFunctionArgumentNameStringId.NotLogical": "логическое_значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.ModNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ModDivisor": "делитель",
  "XtraSpreadsheetFunctionArgumentNameStringId.DCountDatabase": "база_данных",
  "XtraSpreadsheetFunctionArgumentNameStringId.DCountField": "поле",
  "XtraSpreadsheetFunctionArgumentNameStringId.DCountCriteria": "критерий",
  "XtraSpreadsheetFunctionArgumentNameStringId.DSumDatabase": "база_данных",
  "XtraSpreadsheetFunctionArgumentNameStringId.DSumField": "поле",
  "XtraSpreadsheetFunctionArgumentNameStringId.DSumCriteria": "критерий",
  "XtraSpreadsheetFunctionArgumentNameStringId.DAverageDatabase": "база_данных",
  "XtraSpreadsheetFunctionArgumentNameStringId.DAverageField": "поле",
  "XtraSpreadsheetFunctionArgumentNameStringId.DAverageCriteria": "критерий",
  "XtraSpreadsheetFunctionArgumentNameStringId.DMinDatabase": "база_данных",
  "XtraSpreadsheetFunctionArgumentNameStringId.DMinField": "поле",
  "XtraSpreadsheetFunctionArgumentNameStringId.DMinCriteria": "критерий",
  "XtraSpreadsheetFunctionArgumentNameStringId.DMaxDatabase": "база_данных",
  "XtraSpreadsheetFunctionArgumentNameStringId.DMaxField": "поле",
  "XtraSpreadsheetFunctionArgumentNameStringId.DMaxCriteria": "критерий",
  "XtraSpreadsheetFunctionArgumentNameStringId.DStDevDatabase": "база_данных",
  "XtraSpreadsheetFunctionArgumentNameStringId.DStDevField": "поле",
  "XtraSpreadsheetFunctionArgumentNameStringId.DStDevCriteria": "критерий",
  "XtraSpreadsheetFunctionArgumentNameStringId.VarNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.VarNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.DVarDatabase": "база_данных",
  "XtraSpreadsheetFunctionArgumentNameStringId.DVarField": "поле",
  "XtraSpreadsheetFunctionArgumentNameStringId.DVarCriteria": "критерий",
  "XtraSpreadsheetFunctionArgumentNameStringId.TextValue": "значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.TextFormattext": "формат",
  "XtraSpreadsheetFunctionArgumentNameStringId.LinestKnownys": "известные_значения_y",
  "XtraSpreadsheetFunctionArgumentNameStringId.LinestKnownxs": "известные_значения_x",
  "XtraSpreadsheetFunctionArgumentNameStringId.LinestConst": "конст",
  "XtraSpreadsheetFunctionArgumentNameStringId.LinestStats": "статистика",
  "XtraSpreadsheetFunctionArgumentNameStringId.TrendKnownys": "известные_значения_y",
  "XtraSpreadsheetFunctionArgumentNameStringId.TrendKnownxs": "известные_значения_x",
  "XtraSpreadsheetFunctionArgumentNameStringId.TrendNewxs": "новые_значения_x",
  "XtraSpreadsheetFunctionArgumentNameStringId.TrendConst": "конст",
  "XtraSpreadsheetFunctionArgumentNameStringId.LogestKnownys": "известные_значения_y",
  "XtraSpreadsheetFunctionArgumentNameStringId.LogestKnownxs": "известные_значения_x",
  "XtraSpreadsheetFunctionArgumentNameStringId.LogestConst": "конст",
  "XtraSpreadsheetFunctionArgumentNameStringId.LogestStats": "статистика",
  "XtraSpreadsheetFunctionArgumentNameStringId.GrowthKnownys": "известные_значения_y",
  "XtraSpreadsheetFunctionArgumentNameStringId.GrowthKnownxs": "известные_значения_x",
  "XtraSpreadsheetFunctionArgumentNameStringId.GrowthNewxs": "новые_значения_x",
  "XtraSpreadsheetFunctionArgumentNameStringId.GrowthConst": "конст",
  "XtraSpreadsheetFunctionArgumentNameStringId.PvRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.PvNper": "кпер",
  "XtraSpreadsheetFunctionArgumentNameStringId.PvPmt": "плт",
  "XtraSpreadsheetFunctionArgumentNameStringId.PvFv": "бс",
  "XtraSpreadsheetFunctionArgumentNameStringId.PvType": "тип",
  "XtraSpreadsheetFunctionArgumentNameStringId.FvRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.FvNper": "кпер",
  "XtraSpreadsheetFunctionArgumentNameStringId.FvPmt": "плт",
  "XtraSpreadsheetFunctionArgumentNameStringId.FvPv": "пс",
  "XtraSpreadsheetFunctionArgumentNameStringId.FvType": "тип",
  "XtraSpreadsheetFunctionArgumentNameStringId.NPerRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.NPerPmt": "плт",
  "XtraSpreadsheetFunctionArgumentNameStringId.NPerPv": "пс",
  "XtraSpreadsheetFunctionArgumentNameStringId.NPerFv": "бс",
  "XtraSpreadsheetFunctionArgumentNameStringId.NPerType": "тип",
  "XtraSpreadsheetFunctionArgumentNameStringId.PmtRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.PmtNper": "кпер",
  "XtraSpreadsheetFunctionArgumentNameStringId.PmtPv": "пс",
  "XtraSpreadsheetFunctionArgumentNameStringId.PmtFv": "бс",
  "XtraSpreadsheetFunctionArgumentNameStringId.PmtType": "тип",
  "XtraSpreadsheetFunctionArgumentNameStringId.RateNper": "кпер",
  "XtraSpreadsheetFunctionArgumentNameStringId.RatePmt": "плт",
  "XtraSpreadsheetFunctionArgumentNameStringId.RatePv": "пс",
  "XtraSpreadsheetFunctionArgumentNameStringId.RateFv": "бс",
  "XtraSpreadsheetFunctionArgumentNameStringId.RateType": "тип",
  "XtraSpreadsheetFunctionArgumentNameStringId.RateGuess": "предположение",
  "XtraSpreadsheetFunctionArgumentNameStringId.MirrValues": "значения",
  "XtraSpreadsheetFunctionArgumentNameStringId.MirrFinancerate": "ставка_финанс",
  "XtraSpreadsheetFunctionArgumentNameStringId.MirrReinvestrate": "ставка_реинвест",
  "XtraSpreadsheetFunctionArgumentNameStringId.IrrValues": "значения",
  "XtraSpreadsheetFunctionArgumentNameStringId.IrrGuess": "предположение",
  "XtraSpreadsheetFunctionArgumentNameStringId.MatchLookupvalue": "искомое_значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.MatchLookuparray": "просматриваемый_массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.MatchMatchtype": "тип_сопоставления",
  "XtraSpreadsheetFunctionArgumentNameStringId.DateYear": "год",
  "XtraSpreadsheetFunctionArgumentNameStringId.DateMonth": "месяц",
  "XtraSpreadsheetFunctionArgumentNameStringId.DateDay": "день",
  "XtraSpreadsheetFunctionArgumentNameStringId.TimeHour": "часы",
  "XtraSpreadsheetFunctionArgumentNameStringId.TimeMinute": "минуты",
  "XtraSpreadsheetFunctionArgumentNameStringId.TimeSecond": "секунды",
  "XtraSpreadsheetFunctionArgumentNameStringId.DaySerialnumber": "дата_в_числовом_формате",
  "XtraSpreadsheetFunctionArgumentNameStringId.MonthSerialnumber": "дата_в_числовом_формате",
  "XtraSpreadsheetFunctionArgumentNameStringId.YearSerialnumber": "дата_в_числовом_формате",
  "XtraSpreadsheetFunctionArgumentNameStringId.WeekDaySerialnumber": "дата_в_числовом_формате",
  "XtraSpreadsheetFunctionArgumentNameStringId.WeekDayReturntype": "тип",
  "XtraSpreadsheetFunctionArgumentNameStringId.HourSerialnumber": "время_в_числовом_формате",
  "XtraSpreadsheetFunctionArgumentNameStringId.MinuteSerialnumber": "время_в_числовом_формате",
  "XtraSpreadsheetFunctionArgumentNameStringId.SecondSerialnumber": "время_в_числовом_формате",
  "XtraSpreadsheetFunctionArgumentNameStringId.AreasReference": "ссылка",
  "XtraSpreadsheetFunctionArgumentNameStringId.RowsArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.ColumnsArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.OffsetReference": "ссылка",
  "XtraSpreadsheetFunctionArgumentNameStringId.OffsetRows": "смещ_по_строкам",
  "XtraSpreadsheetFunctionArgumentNameStringId.OffsetCols": "смещ_по_столбцам",
  "XtraSpreadsheetFunctionArgumentNameStringId.OffsetHeight": "высота",
  "XtraSpreadsheetFunctionArgumentNameStringId.OffsetWidth": "ширина",
  "XtraSpreadsheetFunctionArgumentNameStringId.SearchFindtext": "искомый_текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.SearchWithintext": "текст_для_поиска",
  "XtraSpreadsheetFunctionArgumentNameStringId.SearchStartnum": "нач_позиция",
  "XtraSpreadsheetFunctionArgumentNameStringId.TransposeArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.TypeValue": "значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.ATan2Xnum": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.ATan2Ynum": "y",
  "XtraSpreadsheetFunctionArgumentNameStringId.ASinNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ACosNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ChooseIndexnum": "номер_индекса",
  "XtraSpreadsheetFunctionArgumentNameStringId.ChooseValue1": "значение1",
  "XtraSpreadsheetFunctionArgumentNameStringId.ChooseValue2": "значение2",
  "XtraSpreadsheetFunctionArgumentNameStringId.HLookupLookupvalue": "искомое_значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.HLookupTablearray": "таблица",
  "XtraSpreadsheetFunctionArgumentNameStringId.HLookupRowindexnum": "номер_строки",
  "XtraSpreadsheetFunctionArgumentNameStringId.HLookupRangelookup": "интервальный_просмотр",
  "XtraSpreadsheetFunctionArgumentNameStringId.VLookupLookupvalue": "искомое_значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.VLookupTablearray": "таблица",
  "XtraSpreadsheetFunctionArgumentNameStringId.VLookupColindexnum": "номер_столбца",
  "XtraSpreadsheetFunctionArgumentNameStringId.VLookupRangelookup": "интервальный_просмотр",
  "XtraSpreadsheetFunctionArgumentNameStringId.IsRefValue": "значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.LogNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.LogBase": "основание",
  "XtraSpreadsheetFunctionArgumentNameStringId.CharNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.LowerText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.UpperText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.ProperText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.LeftText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.LeftNumchars": "количество_знаков",
  "XtraSpreadsheetFunctionArgumentNameStringId.RightText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.RightNumchars": "число_знаков",
  "XtraSpreadsheetFunctionArgumentNameStringId.ExactText1": "текст1",
  "XtraSpreadsheetFunctionArgumentNameStringId.ExactText2": "текст2",
  "XtraSpreadsheetFunctionArgumentNameStringId.TrimText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.ReplaceOldtext": "старый_текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.ReplaceStartnum": "нач_поз",
  "XtraSpreadsheetFunctionArgumentNameStringId.ReplaceNumchars": "число_знаков",
  "XtraSpreadsheetFunctionArgumentNameStringId.ReplaceNewtext": "новый_текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.SubstituteText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.SubstituteOldtext": "стар_текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.SubstituteNewtext": "нов_текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.SubstituteInstancenum": "номер_вхождения",
  "XtraSpreadsheetFunctionArgumentNameStringId.CodeText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.FindFindtext": "искомый_текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.FindWithintext": "просматриваемый_текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.FindStartnum": "нач_позиция",
  "XtraSpreadsheetFunctionArgumentNameStringId.CellInfotype": "тип_сведений",
  "XtraSpreadsheetFunctionArgumentNameStringId.CellReference": "ссылка",
  "XtraSpreadsheetFunctionArgumentNameStringId.IsErrValue": "значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.IsTextValue": "значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.IsNumberValue": "значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.IsBlankValue": "значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.TValue": "значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.NValue": "значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.DateValueDatetext": "дата_как_текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.TimeValueTimetext": "время_как_текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.SlnCost": "нач_стоимость",
  "XtraSpreadsheetFunctionArgumentNameStringId.SlnSalvage": "ост_стоимость",
  "XtraSpreadsheetFunctionArgumentNameStringId.SlnLife": "время_эксплуатации",
  "XtraSpreadsheetFunctionArgumentNameStringId.SydCost": "нач_стоимость",
  "XtraSpreadsheetFunctionArgumentNameStringId.SydSalvage": "ост_стоимость",
  "XtraSpreadsheetFunctionArgumentNameStringId.SydLife": "время_эксплуатации",
  "XtraSpreadsheetFunctionArgumentNameStringId.SydPer": "период",
  "XtraSpreadsheetFunctionArgumentNameStringId.DdbCost": "нач_стоимость",
  "XtraSpreadsheetFunctionArgumentNameStringId.DdbSalvage": "ост_стоимость",
  "XtraSpreadsheetFunctionArgumentNameStringId.DdbLife": "время_эксплуатации",
  "XtraSpreadsheetFunctionArgumentNameStringId.DdbPeriod": "период",
  "XtraSpreadsheetFunctionArgumentNameStringId.DdbFactor": "коэффициент",
  "XtraSpreadsheetFunctionArgumentNameStringId.IndirectReftext": "ссылка_на_ячейку",
  "XtraSpreadsheetFunctionArgumentNameStringId.IndirectA1": "а1",
  "XtraSpreadsheetFunctionArgumentNameStringId.CallRegisterid": "ид_регистрации",
  "XtraSpreadsheetFunctionArgumentNameStringId.CallArgument1": "аргумент1",
  "XtraSpreadsheetFunctionArgumentNameStringId.CleanText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.MDetermArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.MInverseArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.MMultArray1": "массив1",
  "XtraSpreadsheetFunctionArgumentNameStringId.MMultArray2": "массив2",
  "XtraSpreadsheetFunctionArgumentNameStringId.IpmtRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.IpmtPer": "период",
  "XtraSpreadsheetFunctionArgumentNameStringId.IpmtNper": "кпер",
  "XtraSpreadsheetFunctionArgumentNameStringId.IpmtPv": "пс",
  "XtraSpreadsheetFunctionArgumentNameStringId.IpmtFv": "бс",
  "XtraSpreadsheetFunctionArgumentNameStringId.IpmtType": "тип",
  "XtraSpreadsheetFunctionArgumentNameStringId.PpmtRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.PpmtPer": "период",
  "XtraSpreadsheetFunctionArgumentNameStringId.PpmtNper": "кпер",
  "XtraSpreadsheetFunctionArgumentNameStringId.PpmtPv": "пс",
  "XtraSpreadsheetFunctionArgumentNameStringId.PpmtFv": "бс",
  "XtraSpreadsheetFunctionArgumentNameStringId.PpmtType": "тип",
  "XtraSpreadsheetFunctionArgumentNameStringId.CountAValue1": "значение1",
  "XtraSpreadsheetFunctionArgumentNameStringId.CountAValue2": "значение2",
  "XtraSpreadsheetFunctionArgumentNameStringId.ProductNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.ProductNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.FactNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.DProductDatabase": "база_данных",
  "XtraSpreadsheetFunctionArgumentNameStringId.DProductField": "поле",
  "XtraSpreadsheetFunctionArgumentNameStringId.DProductCriteria": "критерий",
  "XtraSpreadsheetFunctionArgumentNameStringId.IsNonTextValue": "значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.StDevPNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.StDevPNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.VarPNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.VarPNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.DStDevPDatabase": "база_данных",
  "XtraSpreadsheetFunctionArgumentNameStringId.DStDevPField": "поле",
  "XtraSpreadsheetFunctionArgumentNameStringId.DStDevPCriteria": "критерий",
  "XtraSpreadsheetFunctionArgumentNameStringId.DVarPDatabase": "база_данных",
  "XtraSpreadsheetFunctionArgumentNameStringId.DVarPField": "поле",
  "XtraSpreadsheetFunctionArgumentNameStringId.DVarPCriteria": "критерий",
  "XtraSpreadsheetFunctionArgumentNameStringId.TruncNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.TruncNumdigits": "число_разрядов",
  "XtraSpreadsheetFunctionArgumentNameStringId.IsLogicalValue": "значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.DCountADatabase": "база_данных",
  "XtraSpreadsheetFunctionArgumentNameStringId.DCountAField": "поле",
  "XtraSpreadsheetFunctionArgumentNameStringId.DCountACriteria": "критерий",
  "XtraSpreadsheetFunctionArgumentNameStringId.FindBFindtext": "искомый_текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.FindBWithintext": "просматриваемый_текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.FindBStartnum": "нач_позиция",
  "XtraSpreadsheetFunctionArgumentNameStringId.SearchBFindtext": "искомый_текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.SearchBWithintext": "текст_для_поиска",
  "XtraSpreadsheetFunctionArgumentNameStringId.SearchBStartnum": "нач_позиция",
  "XtraSpreadsheetFunctionArgumentNameStringId.ReplaceBOldtext": "старый_текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.ReplaceBStartnum": "нач_поз",
  "XtraSpreadsheetFunctionArgumentNameStringId.ReplaceBNumbytes": "число_байтов",
  "XtraSpreadsheetFunctionArgumentNameStringId.ReplaceBNewtext": "новый_текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.LeftBText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.LeftBNumbytes": "количество_байтов",
  "XtraSpreadsheetFunctionArgumentNameStringId.RightBText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.RightBNumbytes": "число_байтов",
  "XtraSpreadsheetFunctionArgumentNameStringId.MidBText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.MidBStartnum": "начальная_позиция",
  "XtraSpreadsheetFunctionArgumentNameStringId.MidBNumbytes": "количество_байтов",
  "XtraSpreadsheetFunctionArgumentNameStringId.LenBText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.RoundUpNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.RoundUpNumdigits": "число_разрядов",
  "XtraSpreadsheetFunctionArgumentNameStringId.RoundDownNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.RoundDownNumdigits": "число_разрядов",
  "XtraSpreadsheetFunctionArgumentNameStringId.AscText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.RankNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.RankRef": "ссылка",
  "XtraSpreadsheetFunctionArgumentNameStringId.RankOrder": "порядок",
  "XtraSpreadsheetFunctionArgumentNameStringId.AddressRownum": "номер_строки",
  "XtraSpreadsheetFunctionArgumentNameStringId.AddressColumnnum": "номер_столбца",
  "XtraSpreadsheetFunctionArgumentNameStringId.AddressAbsnum": "тип_ссылки",
  "XtraSpreadsheetFunctionArgumentNameStringId.AddressA1": "а1",
  "XtraSpreadsheetFunctionArgumentNameStringId.AddressSheettext": "имя_листа",
  "XtraSpreadsheetFunctionArgumentNameStringId.Days360Startdate": "нач_дата",
  "XtraSpreadsheetFunctionArgumentNameStringId.Days360Enddate": "кон_дата",
  "XtraSpreadsheetFunctionArgumentNameStringId.Days360Method": "метод",
  "XtraSpreadsheetFunctionArgumentNameStringId.VdbCost": "нач_стоимость",
  "XtraSpreadsheetFunctionArgumentNameStringId.VdbSalvage": "ост_стоимость",
  "XtraSpreadsheetFunctionArgumentNameStringId.VdbLife": "время_эксплуатации",
  "XtraSpreadsheetFunctionArgumentNameStringId.VdbStartperiod": "нач_период",
  "XtraSpreadsheetFunctionArgumentNameStringId.VdbEndperiod": "кон_период",
  "XtraSpreadsheetFunctionArgumentNameStringId.VdbFactor": "коэффициент",
  "XtraSpreadsheetFunctionArgumentNameStringId.VdbNoswitch": "без_переключения",
  "XtraSpreadsheetFunctionArgumentNameStringId.MedianNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.MedianNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.SumProductArray1": "массив1",
  "XtraSpreadsheetFunctionArgumentNameStringId.SumProductArray2": "массив2",
  "XtraSpreadsheetFunctionArgumentNameStringId.SumProductArray3": "массив3",
  "XtraSpreadsheetFunctionArgumentNameStringId.SinHNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.CosHNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.TanHNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ASinHNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ACosHNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ATanHNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.DGetDatabase": "база_данных",
  "XtraSpreadsheetFunctionArgumentNameStringId.DGetField": "поле",
  "XtraSpreadsheetFunctionArgumentNameStringId.DGetCriteria": "критерий",
  "XtraSpreadsheetFunctionArgumentNameStringId.InfoTypetext": "тип_информации",
  "XtraSpreadsheetFunctionArgumentNameStringId.DbCost": "нач_стоимость",
  "XtraSpreadsheetFunctionArgumentNameStringId.DbSalvage": "ост_стоимость",
  "XtraSpreadsheetFunctionArgumentNameStringId.DbLife": "время_эксплуатации",
  "XtraSpreadsheetFunctionArgumentNameStringId.DbPeriod": "период",
  "XtraSpreadsheetFunctionArgumentNameStringId.DbMonth": "месяцы",
  "XtraSpreadsheetFunctionArgumentNameStringId.FrequencyDataarray": "массив_данных",
  "XtraSpreadsheetFunctionArgumentNameStringId.FrequencyBinsarray": "массив_интервалов",
  "XtraSpreadsheetFunctionArgumentNameStringId.ErrorTypeErrorval": "значение_ошибки",
  "XtraSpreadsheetFunctionArgumentNameStringId.RegisterIdModuletext": "имя_модуля",
  "XtraSpreadsheetFunctionArgumentNameStringId.RegisterIdProcedure": "процедура",
  "XtraSpreadsheetFunctionArgumentNameStringId.RegisterIdTypetext": "тип",
  "XtraSpreadsheetFunctionArgumentNameStringId.AvedevNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.AvedevNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaDistCompatibilityX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaDistCompatibilityAlpha": "альфа",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaDistCompatibilityBeta": "бета",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaDistCompatibilityA": "А",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaDistCompatibilityB": "B",
  "XtraSpreadsheetFunctionArgumentNameStringId.GammaLnX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaInvProbability": "вероятность",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaInvAlpha": "альфа",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaInvBeta": "бета",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaInvA": "А",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaInvB": "B",
  "XtraSpreadsheetFunctionArgumentNameStringId.BinomDistNumbers": "число_успехов",
  "XtraSpreadsheetFunctionArgumentNameStringId.BinomDistTrials": "число_испытаний",
  "XtraSpreadsheetFunctionArgumentNameStringId.BinomDistProbabilitys": "вероятность_успеха",
  "XtraSpreadsheetFunctionArgumentNameStringId.BinomDistCumulative": "интегральная",
  "XtraSpreadsheetFunctionArgumentNameStringId.ChiDistX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.ChiDistDegfreedom": "степени_свободы",
  "XtraSpreadsheetFunctionArgumentNameStringId.ChiInvProbability": "вероятность",
  "XtraSpreadsheetFunctionArgumentNameStringId.ChiInvDegfreedom": "степени_свободы",
  "XtraSpreadsheetFunctionArgumentNameStringId.CombinNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.CombinNumberchosen": "число_выбранных",
  "XtraSpreadsheetFunctionArgumentNameStringId.ConfidenceAlpha": "альфа",
  "XtraSpreadsheetFunctionArgumentNameStringId.ConfidenceStandarddev": "станд_откл",
  "XtraSpreadsheetFunctionArgumentNameStringId.ConfidenceSize": "размер",
  "XtraSpreadsheetFunctionArgumentNameStringId.CritBinomTrials": "число_испытаний",
  "XtraSpreadsheetFunctionArgumentNameStringId.CritBinomProbabilitys": "вероятность_успеха",
  "XtraSpreadsheetFunctionArgumentNameStringId.CritBinomAlpha": "альфа",
  "XtraSpreadsheetFunctionArgumentNameStringId.EvenNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ExponDistX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.ExponDistLambda": "лямбда",
  "XtraSpreadsheetFunctionArgumentNameStringId.ExponDistCumulative": "интегральная",
  "XtraSpreadsheetFunctionArgumentNameStringId.FDistX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.FDistDegfreedom1": "степени_свободы1",
  "XtraSpreadsheetFunctionArgumentNameStringId.FDistDegfreedom2": "степени_свободы2",
  "XtraSpreadsheetFunctionArgumentNameStringId.FInvProbability": "вероятность",
  "XtraSpreadsheetFunctionArgumentNameStringId.FInvDegfreedom1": "степени_свободы1",
  "XtraSpreadsheetFunctionArgumentNameStringId.FInvDegfreedom2": "степени_свободы2",
  "XtraSpreadsheetFunctionArgumentNameStringId.FisherX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.FisherInvY": "y",
  "XtraSpreadsheetFunctionArgumentNameStringId.FloorNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.FloorSignificance": "точность",
  "XtraSpreadsheetFunctionArgumentNameStringId.GammaDistX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.GammaDistAlpha": "альфа",
  "XtraSpreadsheetFunctionArgumentNameStringId.GammaDistBeta": "бета",
  "XtraSpreadsheetFunctionArgumentNameStringId.GammaDistCumulative": "интегральная",
  "XtraSpreadsheetFunctionArgumentNameStringId.GammaInvProbability": "вероятность",
  "XtraSpreadsheetFunctionArgumentNameStringId.GammaInvAlpha": "альфа",
  "XtraSpreadsheetFunctionArgumentNameStringId.GammaInvBeta": "бета",
  "XtraSpreadsheetFunctionArgumentNameStringId.CeilingNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.CeilingSignificance": "точность",
  "XtraSpreadsheetFunctionArgumentNameStringId.HypGeomDistSamples": "число_успехов_в_выборке",
  "XtraSpreadsheetFunctionArgumentNameStringId.HypGeomDistNumbersample": "размер_выборки",
  "XtraSpreadsheetFunctionArgumentNameStringId.HypGeomDistPopulations": "число_успехов_в_совокупности",
  "XtraSpreadsheetFunctionArgumentNameStringId.HypGeomDistNumberpop": "размер_совокупности",
  "XtraSpreadsheetFunctionArgumentNameStringId.LogNormDistCompatibilityX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.LogNormDistCompatibilityMean": "среднее",
  "XtraSpreadsheetFunctionArgumentNameStringId.LogNormDistCompatibilityStandarddev": "стандартное_откл",
  "XtraSpreadsheetFunctionArgumentNameStringId.LogInvCompatibilityProbability": "вероятность",
  "XtraSpreadsheetFunctionArgumentNameStringId.LogInvCompatibilityMean": "среднее",
  "XtraSpreadsheetFunctionArgumentNameStringId.LogInvCompatibilityStandarddev": "стандартное_отклонение",
  "XtraSpreadsheetFunctionArgumentNameStringId.NegBinomDistNumberf": "число_неудач",
  "XtraSpreadsheetFunctionArgumentNameStringId.NegBinomDistNumbers": "число_успехов",
  "XtraSpreadsheetFunctionArgumentNameStringId.NegBinomDistProbabilitys": "вероятность_успеха",
  "XtraSpreadsheetFunctionArgumentNameStringId.NormDistCompatibilityX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.NormDistCompatibilityMean": "среднее",
  "XtraSpreadsheetFunctionArgumentNameStringId.NormDistCompatibilityStandarddev": "стандартное_откл",
  "XtraSpreadsheetFunctionArgumentNameStringId.NormDistCompatibilityCumulative": "интегральная",
  "XtraSpreadsheetFunctionArgumentNameStringId.NormSDistCompatibilityZ": "z",
  "XtraSpreadsheetFunctionArgumentNameStringId.NormInvCompatibilityProbability": "вероятность",
  "XtraSpreadsheetFunctionArgumentNameStringId.NormInvCompatibilityMean": "среднее",
  "XtraSpreadsheetFunctionArgumentNameStringId.NormInvCompatibilityStandarddev": "стандартное_откл",
  "XtraSpreadsheetFunctionArgumentNameStringId.NormSInvCompatibilityProbability": "вероятность",
  "XtraSpreadsheetFunctionArgumentNameStringId.StandardizeX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.StandardizeMean": "среднее",
  "XtraSpreadsheetFunctionArgumentNameStringId.StandardizeStandarddev": "стандартное_откл",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.PermutNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.PermutNumberchosen": "число_выбранных",
  "XtraSpreadsheetFunctionArgumentNameStringId.PoissonX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.PoissonMean": "среднее",
  "XtraSpreadsheetFunctionArgumentNameStringId.PoissonCumulative": "интегральная",
  "XtraSpreadsheetFunctionArgumentNameStringId.TDistX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.TDistDegfreedom": "степени_свободы",
  "XtraSpreadsheetFunctionArgumentNameStringId.TDistTails": "хвосты",
  "XtraSpreadsheetFunctionArgumentNameStringId.WeibullX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.WeibullAlpha": "альфа",
  "XtraSpreadsheetFunctionArgumentNameStringId.WeibullBeta": "бета",
  "XtraSpreadsheetFunctionArgumentNameStringId.WeibullCumulative": "интегральная",
  "XtraSpreadsheetFunctionArgumentNameStringId.SumXMY2Arrayx": "массив_x",
  "XtraSpreadsheetFunctionArgumentNameStringId.SumXMY2Arrayy": "массив_y",
  "XtraSpreadsheetFunctionArgumentNameStringId.SumX2MY2Arrayx": "массив_x",
  "XtraSpreadsheetFunctionArgumentNameStringId.SumX2MY2Arrayy": "массив_y",
  "XtraSpreadsheetFunctionArgumentNameStringId.SumX2PY2Arrayx": "массив_x",
  "XtraSpreadsheetFunctionArgumentNameStringId.SumX2PY2Arrayy": "массив_y",
  "XtraSpreadsheetFunctionArgumentNameStringId.ChiTestActualrange": "фактический_интервал",
  "XtraSpreadsheetFunctionArgumentNameStringId.ChiTestExpectedrange": "ожидаемый_интервал",
  "XtraSpreadsheetFunctionArgumentNameStringId.CorrelArray1": "массив1",
  "XtraSpreadsheetFunctionArgumentNameStringId.CorrelArray2": "массив2",
  "XtraSpreadsheetFunctionArgumentNameStringId.CovarArray1": "массив1",
  "XtraSpreadsheetFunctionArgumentNameStringId.CovarArray2": "массив2",
  "XtraSpreadsheetFunctionArgumentNameStringId.ForecastX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.ForecastKnownys": "известные_значения_y",
  "XtraSpreadsheetFunctionArgumentNameStringId.ForecastKnownxs": "известные_значения_x",
  "XtraSpreadsheetFunctionArgumentNameStringId.FTestArray1": "массив1",
  "XtraSpreadsheetFunctionArgumentNameStringId.FTestArray2": "массив2",
  "XtraSpreadsheetFunctionArgumentNameStringId.InterceptKnownys": "известные_значения_y",
  "XtraSpreadsheetFunctionArgumentNameStringId.InterceptKnownxs": "известные_значения_x",
  "XtraSpreadsheetFunctionArgumentNameStringId.PearsonArray1": "массив1",
  "XtraSpreadsheetFunctionArgumentNameStringId.PearsonArray2": "массив2",
  "XtraSpreadsheetFunctionArgumentNameStringId.RsqKnownys": "известные_значения_y",
  "XtraSpreadsheetFunctionArgumentNameStringId.RsqKnownxs": "известные_значения_x",
  "XtraSpreadsheetFunctionArgumentNameStringId.StEYXKnownys": "известные_значения_y",
  "XtraSpreadsheetFunctionArgumentNameStringId.StEYXKnownxs": "известные_значения_x",
  "XtraSpreadsheetFunctionArgumentNameStringId.SlopeKnownys": "известные_значения_y",
  "XtraSpreadsheetFunctionArgumentNameStringId.SlopeKnownxs": "известные_значения_x",
  "XtraSpreadsheetFunctionArgumentNameStringId.TTestArray1": "массив1",
  "XtraSpreadsheetFunctionArgumentNameStringId.TTestArray2": "массив2",
  "XtraSpreadsheetFunctionArgumentNameStringId.TTestTails": "хвосты",
  "XtraSpreadsheetFunctionArgumentNameStringId.TTestType": "тип",
  "XtraSpreadsheetFunctionArgumentNameStringId.ProbXrange": "x_интервал",
  "XtraSpreadsheetFunctionArgumentNameStringId.ProbProbrange": "интервал_вероятностей",
  "XtraSpreadsheetFunctionArgumentNameStringId.ProbLowerlimit": "нижний_предел",
  "XtraSpreadsheetFunctionArgumentNameStringId.ProbUpperlimit": "верхний_предел",
  "XtraSpreadsheetFunctionArgumentNameStringId.DevSqNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.DevSqNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.GeomeanNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.GeomeanNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.HarMeanNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.HarMeanNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.SumSqNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.SumSqNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.KurtNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.KurtNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.SkewNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.SkewNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.ZTestArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.ZTestX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.ZTestSigma": "сигма",
  "XtraSpreadsheetFunctionArgumentNameStringId.LargeArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.LargeK": "k",
  "XtraSpreadsheetFunctionArgumentNameStringId.SmallArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.SmallK": "k",
  "XtraSpreadsheetFunctionArgumentNameStringId.QuartileArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.QuartileQuart": "часть",
  "XtraSpreadsheetFunctionArgumentNameStringId.PercentileArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.PercentileK": "k",
  "XtraSpreadsheetFunctionArgumentNameStringId.PercentRankArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.PercentRankX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.PercentRankSignificance": "разрядность",
  "XtraSpreadsheetFunctionArgumentNameStringId.ModeNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.ModeNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.TrimmeanArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.TrimmeanPercent": "доля",
  "XtraSpreadsheetFunctionArgumentNameStringId.TinvProbability": "вероятность",
  "XtraSpreadsheetFunctionArgumentNameStringId.TinvDegfreedom": "степени_свободы",
  "XtraSpreadsheetFunctionArgumentNameStringId.ConcatenateText1": "текст1",
  "XtraSpreadsheetFunctionArgumentNameStringId.ConcatenateText2": "текст2",
  "XtraSpreadsheetFunctionArgumentNameStringId.PowerNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.PowerPower": "степень",
  "XtraSpreadsheetFunctionArgumentNameStringId.RadiansAngle": "угол",
  "XtraSpreadsheetFunctionArgumentNameStringId.DegreesAngle": "угол",
  "XtraSpreadsheetFunctionArgumentNameStringId.SubtotalFunctionnum": "номер_функции",
  "XtraSpreadsheetFunctionArgumentNameStringId.SubtotalRef1": "ссылка1",
  "XtraSpreadsheetFunctionArgumentNameStringId.SumIfRange": "диапазон",
  "XtraSpreadsheetFunctionArgumentNameStringId.SumIfCriteria": "критерий",
  "XtraSpreadsheetFunctionArgumentNameStringId.SumIfSumrange": "диапазон_суммирования",
  "XtraSpreadsheetFunctionArgumentNameStringId.CountIfRange": "диапазон",
  "XtraSpreadsheetFunctionArgumentNameStringId.CountIfCriteria": "критерий",
  "XtraSpreadsheetFunctionArgumentNameStringId.CountBlankRange": "диапазон",
  "XtraSpreadsheetFunctionArgumentNameStringId.IsPmtRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.IsPmtPer": "период",
  "XtraSpreadsheetFunctionArgumentNameStringId.IsPmtNper": "кпер",
  "XtraSpreadsheetFunctionArgumentNameStringId.IsPmtPv": "пс",
  "XtraSpreadsheetFunctionArgumentNameStringId.RomanNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.RomanForm": "форма",
  "XtraSpreadsheetFunctionArgumentNameStringId.GetPivotDataDatafield": "поле_данных",
  "XtraSpreadsheetFunctionArgumentNameStringId.GetPivotDataPivottable": "сводная_таблица",
  "XtraSpreadsheetFunctionArgumentNameStringId.GetPivotDataField": "поле",
  "XtraSpreadsheetFunctionArgumentNameStringId.GetPivotDataItem": "элемент",
  "XtraSpreadsheetFunctionArgumentNameStringId.HyperlinkLinklocation": "адрес",
  "XtraSpreadsheetFunctionArgumentNameStringId.HyperlinkFriendlyname": "имя",
  "XtraSpreadsheetFunctionArgumentNameStringId.PhoneticReference": "ссылка",
  "XtraSpreadsheetFunctionArgumentNameStringId.AverageAValue1": "значение1",
  "XtraSpreadsheetFunctionArgumentNameStringId.AverageAValue2": "значение2",
  "XtraSpreadsheetFunctionArgumentNameStringId.MaxAValue1": "значение1",
  "XtraSpreadsheetFunctionArgumentNameStringId.MaxAValue2": "значение2",
  "XtraSpreadsheetFunctionArgumentNameStringId.MinAValue1": "значение1",
  "XtraSpreadsheetFunctionArgumentNameStringId.MinAValue2": "значение2",
  "XtraSpreadsheetFunctionArgumentNameStringId.StDevPAValue1": "значение1",
  "XtraSpreadsheetFunctionArgumentNameStringId.StDevPAValue2": "значение2",
  "XtraSpreadsheetFunctionArgumentNameStringId.VarPAValue1": "значение1",
  "XtraSpreadsheetFunctionArgumentNameStringId.VarPAValue2": "значение2",
  "XtraSpreadsheetFunctionArgumentNameStringId.StDevAValue1": "значение1",
  "XtraSpreadsheetFunctionArgumentNameStringId.StDevAValue2": "значение2",
  "XtraSpreadsheetFunctionArgumentNameStringId.VarAValue1": "значение1",
  "XtraSpreadsheetFunctionArgumentNameStringId.VarAValue2": "значение2",
  "XtraSpreadsheetFunctionArgumentNameStringId.BahtTextNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.RtdProgID": "кодПрог",
  "XtraSpreadsheetFunctionArgumentNameStringId.RtdServer": "сервер",
  "XtraSpreadsheetFunctionArgumentNameStringId.RtdTopic1": "элемент1",
  "XtraSpreadsheetFunctionArgumentNameStringId.RtdTopic2": "элемент2",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeValueConnection": "подключение",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeValueMemberexpression1": "выражение_элемента1",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeMemberConnection": "подключение",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeMemberMemberexpression": "выражение_элемента",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeMemberCaption": "подпись",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeMemberPropertyConnection": "подключение",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeMemberPropertyMemberexpression": "выражение_элемента",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeMemberPropertyProperty": "свойство",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeRankedMemberConnection": "подключение",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeRankedMemberSetexpression": "выражение_множества",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeRankedMemberRank": "номер",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeRankedMemberCaption": "подпись",
  "XtraSpreadsheetFunctionArgumentNameStringId.Hex2BinNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.Hex2BinPlaces": "разрядность",
  "XtraSpreadsheetFunctionArgumentNameStringId.Hex2DecNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.Hex2OctNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.Hex2OctPlaces": "разрядность",
  "XtraSpreadsheetFunctionArgumentNameStringId.Dec2BinNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.Dec2BinPlaces": "разрядность",
  "XtraSpreadsheetFunctionArgumentNameStringId.Dec2HexNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.Dec2HexPlaces": "разрядность",
  "XtraSpreadsheetFunctionArgumentNameStringId.Dec2OctNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.Dec2OctPlaces": "разрядность",
  "XtraSpreadsheetFunctionArgumentNameStringId.Oct2BinNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.Oct2BinPlaces": "разрядность",
  "XtraSpreadsheetFunctionArgumentNameStringId.Oct2HexNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.Oct2HexPlaces": "разрядность",
  "XtraSpreadsheetFunctionArgumentNameStringId.Oct2DecNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.Bin2DecNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.Bin2OctNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.Bin2OctPlaces": "разрядность",
  "XtraSpreadsheetFunctionArgumentNameStringId.Bin2HexNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.Bin2HexPlaces": "разрядность",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImSubInumber1": "компл_число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImSubInumber2": "компл_число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImDivInumber1": "компл_число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImDivInumber2": "компл_число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImPowerInumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImPowerNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImAbsInumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImSqrtInumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImLnInumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImLog2Inumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImLog10Inumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImSinInumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImCosInumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImExpInumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImArgumentInumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImConjugateInumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImaginaryInumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImRealInumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ComplexRealnum": "действительная_часть",
  "XtraSpreadsheetFunctionArgumentNameStringId.ComplexInum": "мнимая_часть",
  "XtraSpreadsheetFunctionArgumentNameStringId.ComplexSuffix": "мнимая_единица",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImSumInumber1": "компл_число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImSumInumber2": "компл_число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImProductInumber1": "компл_число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImProductInumber2": "компл_число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.SeriessumX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.SeriessumN": "n",
  "XtraSpreadsheetFunctionArgumentNameStringId.SeriessumM": "m",
  "XtraSpreadsheetFunctionArgumentNameStringId.SeriessumCoefficients": "коэффициенты",
  "XtraSpreadsheetFunctionArgumentNameStringId.FactDoubleNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.SqrtPiNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.QuotientNumerator": "числитель",
  "XtraSpreadsheetFunctionArgumentNameStringId.QuotientDenominator": "знаменатель",
  "XtraSpreadsheetFunctionArgumentNameStringId.DeltaNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.DeltaNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.GestepNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.GestepStep": "порог",
  "XtraSpreadsheetFunctionArgumentNameStringId.IsEvenNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.IsOddNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.MRoundNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.MRoundMultiple": "точность",
  "XtraSpreadsheetFunctionArgumentNameStringId.ErfLowerlimit": "нижний_предел",
  "XtraSpreadsheetFunctionArgumentNameStringId.ErfUpperlimit": "верхний_предел",
  "XtraSpreadsheetFunctionArgumentNameStringId.ErfcX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.BesselJX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.BesselJN": "n",
  "XtraSpreadsheetFunctionArgumentNameStringId.BesselKX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.BesselKN": "n",
  "XtraSpreadsheetFunctionArgumentNameStringId.BesselYX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.BesselYN": "n",
  "XtraSpreadsheetFunctionArgumentNameStringId.BesselIX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.BesselIN": "n",
  "XtraSpreadsheetFunctionArgumentNameStringId.XirrValues": "значения",
  "XtraSpreadsheetFunctionArgumentNameStringId.XirrDates": "даты",
  "XtraSpreadsheetFunctionArgumentNameStringId.XirrGuess": "предп",
  "XtraSpreadsheetFunctionArgumentNameStringId.XnpvRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.XnpvValues": "значения",
  "XtraSpreadsheetFunctionArgumentNameStringId.XnpvDates": "даты",
  "XtraSpreadsheetFunctionArgumentNameStringId.PriceMatSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.PriceMatMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.PriceMatIssue": "дата_выпуска",
  "XtraSpreadsheetFunctionArgumentNameStringId.PriceMatRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.PriceMatYld": "доходность",
  "XtraSpreadsheetFunctionArgumentNameStringId.PriceMatBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.YieldMatSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.YieldMatMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.YieldMatIssue": "дата_выпуска",
  "XtraSpreadsheetFunctionArgumentNameStringId.YieldMatRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.YieldMatPr": "цена",
  "XtraSpreadsheetFunctionArgumentNameStringId.YieldMatBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.IntrateSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.IntrateMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.IntrateInvestment": "инвестиция",
  "XtraSpreadsheetFunctionArgumentNameStringId.IntrateRedemption": "погашение",
  "XtraSpreadsheetFunctionArgumentNameStringId.IntrateBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.ReceivedSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.ReceivedMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.ReceivedInvestment": "инвестиция",
  "XtraSpreadsheetFunctionArgumentNameStringId.ReceivedDiscount": "скидка",
  "XtraSpreadsheetFunctionArgumentNameStringId.ReceivedBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.DiscSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.DiscMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.DiscPr": "цена",
  "XtraSpreadsheetFunctionArgumentNameStringId.DiscRedemption": "погашение",
  "XtraSpreadsheetFunctionArgumentNameStringId.DiscBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.PriceDiscSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.PriceDiscMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.PriceDiscDiscount": "скидка",
  "XtraSpreadsheetFunctionArgumentNameStringId.PriceDiscRedemption": "погашение",
  "XtraSpreadsheetFunctionArgumentNameStringId.PriceDiscBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.YieldDiscSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.YieldDiscMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.YieldDiscPr": "цена",
  "XtraSpreadsheetFunctionArgumentNameStringId.YieldDiscRedemption": "погашение",
  "XtraSpreadsheetFunctionArgumentNameStringId.YieldDiscBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.TbillEqSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.TbillEqMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.TbillEqDiscount": "скидка",
  "XtraSpreadsheetFunctionArgumentNameStringId.TbillPriceSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.TbillPriceMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.TbillPriceDiscount": "скидка",
  "XtraSpreadsheetFunctionArgumentNameStringId.TbillYieldSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.TbillYieldMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.TbillYieldPr": "цена",
  "XtraSpreadsheetFunctionArgumentNameStringId.PriceSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.PriceMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.PriceRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.PriceYld": "доход",
  "XtraSpreadsheetFunctionArgumentNameStringId.PriceRedemption": "погашение",
  "XtraSpreadsheetFunctionArgumentNameStringId.PriceFrequency": "частота",
  "XtraSpreadsheetFunctionArgumentNameStringId.PriceBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.YieldSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.YieldMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.YieldRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.YieldPr": "цена",
  "XtraSpreadsheetFunctionArgumentNameStringId.YieldRedemption": "погашение",
  "XtraSpreadsheetFunctionArgumentNameStringId.YieldFrequency": "частота",
  "XtraSpreadsheetFunctionArgumentNameStringId.YieldBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.DollarDeFractionaldollar": "дроб_руб",
  "XtraSpreadsheetFunctionArgumentNameStringId.DollarDeFraction": "дроб",
  "XtraSpreadsheetFunctionArgumentNameStringId.DollarFrDecimaldollar": "дроб_руб",
  "XtraSpreadsheetFunctionArgumentNameStringId.DollarFrFraction": "дроб",
  "XtraSpreadsheetFunctionArgumentNameStringId.NominalEffectrate": "факт_ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.NominalNpery": "кол_пер",
  "XtraSpreadsheetFunctionArgumentNameStringId.EffectNominalrate": "номинальная_ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.EffectNpery": "кол_пер",
  "XtraSpreadsheetFunctionArgumentNameStringId.CumPrincRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.CumPrincNper": "кол_пер",
  "XtraSpreadsheetFunctionArgumentNameStringId.CumPrincPv": "нз",
  "XtraSpreadsheetFunctionArgumentNameStringId.CumPrincStartperiod": "нач_период",
  "XtraSpreadsheetFunctionArgumentNameStringId.CumPrincEndperiod": "кон_период",
  "XtraSpreadsheetFunctionArgumentNameStringId.CumPrincType": "тип",
  "XtraSpreadsheetFunctionArgumentNameStringId.CumIpmtRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.CumIpmtNper": "кол_пер",
  "XtraSpreadsheetFunctionArgumentNameStringId.CumIpmtPv": "нз",
  "XtraSpreadsheetFunctionArgumentNameStringId.CumIpmtStartperiod": "нач_период",
  "XtraSpreadsheetFunctionArgumentNameStringId.CumIpmtEndperiod": "кон_период",
  "XtraSpreadsheetFunctionArgumentNameStringId.CumIpmtType": "тип",
  "XtraSpreadsheetFunctionArgumentNameStringId.EDateStartdate": "нач_дата",
  "XtraSpreadsheetFunctionArgumentNameStringId.EDateMonths": "число_месяцев",
  "XtraSpreadsheetFunctionArgumentNameStringId.EOMonthStartdate": "нач_дата",
  "XtraSpreadsheetFunctionArgumentNameStringId.EOMonthMonths": "число_месяцев",
  "XtraSpreadsheetFunctionArgumentNameStringId.YearFracStartdate": "нач_дата",
  "XtraSpreadsheetFunctionArgumentNameStringId.YearFracEnddate": "кон_дата",
  "XtraSpreadsheetFunctionArgumentNameStringId.YearFracBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.CoupDaybsSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.CoupDaybsMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.CoupDaybsFrequency": "частота",
  "XtraSpreadsheetFunctionArgumentNameStringId.CoupDaybsBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.CoupDaysSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.CoupDaysMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.CoupDaysFrequency": "частота",
  "XtraSpreadsheetFunctionArgumentNameStringId.CoupDaysBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.CoupDaysncSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.CoupDaysncMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.CoupDaysncFrequency": "частота",
  "XtraSpreadsheetFunctionArgumentNameStringId.CoupDaysncBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.CoupncdSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.CoupncdMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.CoupncdFrequency": "частота",
  "XtraSpreadsheetFunctionArgumentNameStringId.CoupncdBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.CoupNumSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.CoupNumMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.CoupNumFrequency": "частота",
  "XtraSpreadsheetFunctionArgumentNameStringId.CoupNumBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.CouppcdSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.CouppcdMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.CouppcdFrequency": "частота",
  "XtraSpreadsheetFunctionArgumentNameStringId.CouppcdBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.DurationSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.DurationMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.DurationCoupon": "купон",
  "XtraSpreadsheetFunctionArgumentNameStringId.DurationYld": "доход",
  "XtraSpreadsheetFunctionArgumentNameStringId.DurationFrequency": "частота",
  "XtraSpreadsheetFunctionArgumentNameStringId.DurationBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.MDurationSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.MDurationMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.MDurationCoupon": "купон",
  "XtraSpreadsheetFunctionArgumentNameStringId.MDurationYld": "доход",
  "XtraSpreadsheetFunctionArgumentNameStringId.MDurationFrequency": "частота",
  "XtraSpreadsheetFunctionArgumentNameStringId.MDurationBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddLPriceSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddLPriceMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddLPriceLastinterest": "посл_купон",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddLPriceRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddLPriceYld": "доход",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddLPriceRedemption": "погашение",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddLPriceFrequency": "частота",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddLPriceBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddLYieldSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddLYieldMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddLYieldLastinterest": "посл_купон",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddLYieldRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddLYieldPr": "цена",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddLYieldRedemption": "погашение",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddLYieldFrequency": "частота",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddLYieldBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddFPriceSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddFPriceMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddFPriceIssue": "дата_выпуска",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddFPriceFirstcoupon": "первый_купон",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddFPriceRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddFPriceYld": "доход",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddFPriceRedemption": "погашение",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddFPriceFrequency": "частота",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddFPriceBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddFYieldSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddFYieldMaturity": "дата_вступл_в_силу",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddFYieldIssue": "дата_выпуска",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddFYieldFirstcoupon": "первый_купон",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddFYieldRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddFYieldPr": "цена",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddFYieldRedemption": "погашение",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddFYieldFrequency": "частота",
  "XtraSpreadsheetFunctionArgumentNameStringId.OddFYieldBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.RandBetweenBottom": "нижн_граница",
  "XtraSpreadsheetFunctionArgumentNameStringId.RandBetweenTop": "верхн_граница",
  "XtraSpreadsheetFunctionArgumentNameStringId.WeekNumSerialnumber": "пор_номер_даты",
  "XtraSpreadsheetFunctionArgumentNameStringId.WeekNumReturntype": "тип_возвр",
  "XtraSpreadsheetFunctionArgumentNameStringId.AmordegrcCost": "стоимость",
  "XtraSpreadsheetFunctionArgumentNameStringId.AmordegrcDatepurchased": "дата_приобр",
  "XtraSpreadsheetFunctionArgumentNameStringId.AmordegrcFirstperiod": "первый_период",
  "XtraSpreadsheetFunctionArgumentNameStringId.AmordegrcSalvage": "остаточная_стоимость",
  "XtraSpreadsheetFunctionArgumentNameStringId.AmordegrcPeriod": "период",
  "XtraSpreadsheetFunctionArgumentNameStringId.AmordegrcRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.AmordegrcBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.AmorlincCost": "стоимость",
  "XtraSpreadsheetFunctionArgumentNameStringId.AmorlincDatepurchased": "дата_приобр",
  "XtraSpreadsheetFunctionArgumentNameStringId.AmorlincFirstperiod": "первый_период",
  "XtraSpreadsheetFunctionArgumentNameStringId.AmorlincSalvage": "остаточная_стоимость",
  "XtraSpreadsheetFunctionArgumentNameStringId.AmorlincPeriod": "период",
  "XtraSpreadsheetFunctionArgumentNameStringId.AmorlincRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.AmorlincBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.ConvertNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ConvertFromunit": "исх_ед_изм",
  "XtraSpreadsheetFunctionArgumentNameStringId.ConvertTounit": "кон_ед_изм",
  "XtraSpreadsheetFunctionArgumentNameStringId.AccrintIssue": "дата_выпуска",
  "XtraSpreadsheetFunctionArgumentNameStringId.AccrintFirstinterest": "первый_доход",
  "XtraSpreadsheetFunctionArgumentNameStringId.AccrintSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.AccrintRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.AccrintPar": "номинал",
  "XtraSpreadsheetFunctionArgumentNameStringId.AccrintFrequency": "частота",
  "XtraSpreadsheetFunctionArgumentNameStringId.AccrintBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.AccrintCalcmethod": "способ_расчета",
  "XtraSpreadsheetFunctionArgumentNameStringId.AccrintmIssue": "дата_выпуска",
  "XtraSpreadsheetFunctionArgumentNameStringId.AccrintmSettlement": "дата_согл",
  "XtraSpreadsheetFunctionArgumentNameStringId.AccrintmRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.AccrintmPar": "номинал",
  "XtraSpreadsheetFunctionArgumentNameStringId.AccrintmBasis": "базис",
  "XtraSpreadsheetFunctionArgumentNameStringId.WorkDayStartdate": "нач_дата",
  "XtraSpreadsheetFunctionArgumentNameStringId.WorkDayDays": "число_дней",
  "XtraSpreadsheetFunctionArgumentNameStringId.WorkDayHolidays": "праздники",
  "XtraSpreadsheetFunctionArgumentNameStringId.NetworkDaysStartdate": "нач_дата",
  "XtraSpreadsheetFunctionArgumentNameStringId.NetworkDaysEnddate": "кон_дата",
  "XtraSpreadsheetFunctionArgumentNameStringId.NetworkDaysHolidays": "праздники",
  "XtraSpreadsheetFunctionArgumentNameStringId.GcdNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.GcdNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.MultinomialNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.MultinomialNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.LcmNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.LcmNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.FvSchedulePrincipal": "первичное",
  "XtraSpreadsheetFunctionArgumentNameStringId.FvScheduleSchedule": "план",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeKpiMemberConnection": "подключение",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeKpiMemberKpiname": "имя_КПЭ",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeKpiMemberKpiproperty": "свойство_КПЭ",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeKpiMemberCaption": "подпись",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeSetConnection": "подключение",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeSetSetexpression": "выражение_множества",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeSetCaption": "подпись",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeSetSortorder": "порядок_сортировки",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeSetSortby": "сорт_по",
  "XtraSpreadsheetFunctionArgumentNameStringId.CubeSetCountSet": "множество",
  "XtraSpreadsheetFunctionArgumentNameStringId.IfErrorValue": "значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.IfErrorValueiferror": "значение_если_ошибка",
  "XtraSpreadsheetFunctionArgumentNameStringId.CountIfsCriteriarange": "диапазон_условия",
  "XtraSpreadsheetFunctionArgumentNameStringId.CountIfsCriteria": "условие",
  "XtraSpreadsheetFunctionArgumentNameStringId.SumIfsSumrange": "диапазон_суммирования",
  "XtraSpreadsheetFunctionArgumentNameStringId.SumIfsCriteriarange": "диапазон_условия",
  "XtraSpreadsheetFunctionArgumentNameStringId.SumIfsCriteria": "условие",
  "XtraSpreadsheetFunctionArgumentNameStringId.AverageIfRange": "диапазон",
  "XtraSpreadsheetFunctionArgumentNameStringId.AverageIfCriteria": "условие",
  "XtraSpreadsheetFunctionArgumentNameStringId.AverageIfAveragerange": "диапазон_усреднения",
  "XtraSpreadsheetFunctionArgumentNameStringId.AverageIfsAveragerange": "диапазон_усреднения",
  "XtraSpreadsheetFunctionArgumentNameStringId.AverageIfsCriteriarange": "диапазон_условия",
  "XtraSpreadsheetFunctionArgumentNameStringId.AverageIfsCriteria": "условие",
  "XtraSpreadsheetFunctionArgumentNameStringId.AggregateFunctionnum": "номер_функции",
  "XtraSpreadsheetFunctionArgumentNameStringId.AggregateOptions": "параметры",
  "XtraSpreadsheetFunctionArgumentNameStringId.AggregateArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.AggregateK": "k",
  "XtraSpreadsheetFunctionArgumentNameStringId.BinomDotDistNumbers": "число_успехов",
  "XtraSpreadsheetFunctionArgumentNameStringId.BinomDotDistTrials": "число_испытаний",
  "XtraSpreadsheetFunctionArgumentNameStringId.BinomDotDistProbabilitys": "вероятность_успеха",
  "XtraSpreadsheetFunctionArgumentNameStringId.BinomDotDistCumulative": "интегральная",
  "XtraSpreadsheetFunctionArgumentNameStringId.BinomDotInvTrials": "число_испытаний",
  "XtraSpreadsheetFunctionArgumentNameStringId.BinomDotInvProbabilitys": "вероятность_успеха",
  "XtraSpreadsheetFunctionArgumentNameStringId.BinomDotInvAlpha": "альфа",
  "XtraSpreadsheetFunctionArgumentNameStringId.ConfidenceNormAlpha": "альфа",
  "XtraSpreadsheetFunctionArgumentNameStringId.ConfidenceNormStandarddev": "станд_откл",
  "XtraSpreadsheetFunctionArgumentNameStringId.ConfidenceNormSize": "размер",
  "XtraSpreadsheetFunctionArgumentNameStringId.ConfidenceDotTAlpha": "альфа",
  "XtraSpreadsheetFunctionArgumentNameStringId.ConfidenceDotTStandarddev": "станд_откл",
  "XtraSpreadsheetFunctionArgumentNameStringId.ConfidenceDotTSize": "размер",
  "XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotTestActualrange": "фактический_интервал",
  "XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotTestExpectedrange": "ожидаемый_интервал",
  "XtraSpreadsheetFunctionArgumentNameStringId.FDotTestArray1": "массив1",
  "XtraSpreadsheetFunctionArgumentNameStringId.FDotTestArray2": "массив2",
  "XtraSpreadsheetFunctionArgumentNameStringId.CovariancePArray1": "массив1",
  "XtraSpreadsheetFunctionArgumentNameStringId.CovariancePArray2": "массив2",
  "XtraSpreadsheetFunctionArgumentNameStringId.CovarianceSArray1": "массив1",
  "XtraSpreadsheetFunctionArgumentNameStringId.CovarianceSArray2": "массив2",
  "XtraSpreadsheetFunctionArgumentNameStringId.ExponDotDistX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.ExponDotDistLambda": "лямбда",
  "XtraSpreadsheetFunctionArgumentNameStringId.ExponDotDistCumulative": "интегральная",
  "XtraSpreadsheetFunctionArgumentNameStringId.GammaDotDistX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.GammaDotDistAlpha": "альфа",
  "XtraSpreadsheetFunctionArgumentNameStringId.GammaDotDistBeta": "бета",
  "XtraSpreadsheetFunctionArgumentNameStringId.GammaDotDistCumulative": "интегральная",
  "XtraSpreadsheetFunctionArgumentNameStringId.GammaDotInvProbability": "вероятность",
  "XtraSpreadsheetFunctionArgumentNameStringId.GammaDotInvAlpha": "альфа",
  "XtraSpreadsheetFunctionArgumentNameStringId.GammaDotInvBeta": "бета",
  "XtraSpreadsheetFunctionArgumentNameStringId.ModeMultNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.ModeMultNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.ModeSnglNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.ModeSnglNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.NormDistX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.NormDistMean": "среднее",
  "XtraSpreadsheetFunctionArgumentNameStringId.NormDistStandarddev": "стандартное_откл",
  "XtraSpreadsheetFunctionArgumentNameStringId.NormDistCumulative": "интегральная",
  "XtraSpreadsheetFunctionArgumentNameStringId.NormInvProbability": "вероятность",
  "XtraSpreadsheetFunctionArgumentNameStringId.NormInvMean": "среднее",
  "XtraSpreadsheetFunctionArgumentNameStringId.NormInvStandarddev": "стандартное_откл",
  "XtraSpreadsheetFunctionArgumentNameStringId.PercentileExcArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.PercentileExcK": "k",
  "XtraSpreadsheetFunctionArgumentNameStringId.PercentileIncArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.PercentileIncK": "k",
  "XtraSpreadsheetFunctionArgumentNameStringId.PercentRankExcArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.PercentRankExcX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.PercentRankExcSignificance": "разрядность",
  "XtraSpreadsheetFunctionArgumentNameStringId.PercentRankIncArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.PercentRankIncX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.PercentRankIncSignificance": "разрядность",
  "XtraSpreadsheetFunctionArgumentNameStringId.PoissonDotDistX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.PoissonDotDistMean": "среднее",
  "XtraSpreadsheetFunctionArgumentNameStringId.PoissonDotDistCumulative": "интегральная",
  "XtraSpreadsheetFunctionArgumentNameStringId.QuartileExcArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.QuartileExcQuart": "часть",
  "XtraSpreadsheetFunctionArgumentNameStringId.QuartileIncArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.QuartileIncQuart": "часть",
  "XtraSpreadsheetFunctionArgumentNameStringId.RankDotAvgNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.RankDotAvgRef": "ссылка",
  "XtraSpreadsheetFunctionArgumentNameStringId.RankDotAvgOrder": "порядок",
  "XtraSpreadsheetFunctionArgumentNameStringId.RankDotEqNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.RankDotEqRef": "ссылка",
  "XtraSpreadsheetFunctionArgumentNameStringId.RankDotEqOrder": "порядок",
  "XtraSpreadsheetFunctionArgumentNameStringId.StDevDotSNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.StDevDotSNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.StDevDotPNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.StDevDotPNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.TDotDistX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.TDotDistDegfreedom": "степени_свободы",
  "XtraSpreadsheetFunctionArgumentNameStringId.TDotDistCumulative": "интегральная",
  "XtraSpreadsheetFunctionArgumentNameStringId.TDotDistDot2tX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.TDotDistDot2tDegfreedom": "степени_свободы",
  "XtraSpreadsheetFunctionArgumentNameStringId.TDotDistDotTtX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.TDotDistDotTtDegfreedom": "степени_свободы",
  "XtraSpreadsheetFunctionArgumentNameStringId.TDotInvProbability": "вероятность",
  "XtraSpreadsheetFunctionArgumentNameStringId.TDotInvDegfreedom": "степени_свободы",
  "XtraSpreadsheetFunctionArgumentNameStringId.TDotInvDot2tProbability": "вероятность",
  "XtraSpreadsheetFunctionArgumentNameStringId.TDotInvDot2tDegfreedom": "степени_свободы",
  "XtraSpreadsheetFunctionArgumentNameStringId.VarDotSNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.VarDotSNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.VarDotPNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.VarDotPNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.WeibullDotDistX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.WeibullDotDistAlpha": "альфа",
  "XtraSpreadsheetFunctionArgumentNameStringId.WeibullDotDistBeta": "бета",
  "XtraSpreadsheetFunctionArgumentNameStringId.WeibullDotDistCumulative": "интегральная",
  "XtraSpreadsheetFunctionArgumentNameStringId.NetworkDaysIntlStartdate": "нач_дата",
  "XtraSpreadsheetFunctionArgumentNameStringId.NetworkDaysIntlEnddate": "кон_дата",
  "XtraSpreadsheetFunctionArgumentNameStringId.NetworkDaysIntlWeekend": "выходные",
  "XtraSpreadsheetFunctionArgumentNameStringId.NetworkDaysIntlHolidays": "праздники",
  "XtraSpreadsheetFunctionArgumentNameStringId.WorkDayIntlStartdate": "нач_дата",
  "XtraSpreadsheetFunctionArgumentNameStringId.WorkDayIntlDays": "число_дней",
  "XtraSpreadsheetFunctionArgumentNameStringId.WorkDayIntlWeekend": "выходные",
  "XtraSpreadsheetFunctionArgumentNameStringId.WorkDayIntlHolidays": "праздники",
  "XtraSpreadsheetFunctionArgumentNameStringId.IsoCeilingNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.IsoCeilingSignificance": "точность",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaDistX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaDistAlpha": "альфа",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaDistBeta": "бета",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaDistCumulative": "интегральная",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaDistA": "А",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaDistB": "B",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaDotInvProbability": "вероятность",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaDotInvAlpha": "альфа",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaDotInvBeta": "бета",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaDotInvA": "А",
  "XtraSpreadsheetFunctionArgumentNameStringId.BetaDotInvB": "B",
  "XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotDistX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotDistDegfreedom": "степени_свободы",
  "XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotDistCumulative": "интегральная",
  "XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotDistDotRtX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotDistDotRtDegfreedom": "степени_свободы",
  "XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotInvProbability": "вероятность",
  "XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotInvDegfreedom": "степени_свободы",
  "XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotInvDotRtProbability": "вероятность",
  "XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotInvDotRtDegfreedom": "степени_свободы",
  "XtraSpreadsheetFunctionArgumentNameStringId.FDotDistX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.FDotDistDegfreedom1": "степени_свободы1",
  "XtraSpreadsheetFunctionArgumentNameStringId.FDotDistDegfreedom2": "степени_свободы2",
  "XtraSpreadsheetFunctionArgumentNameStringId.FDotDistCumulative": "интегральная",
  "XtraSpreadsheetFunctionArgumentNameStringId.FDotDistDotRtX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.FDotDistDotRtDegfreedom1": "степени_свободы1",
  "XtraSpreadsheetFunctionArgumentNameStringId.FDotDistDotRtDegfreedom2": "степени_свободы2",
  "XtraSpreadsheetFunctionArgumentNameStringId.FDotInvProbability": "вероятность",
  "XtraSpreadsheetFunctionArgumentNameStringId.FDotInvDegfreedom1": "степени_свободы1",
  "XtraSpreadsheetFunctionArgumentNameStringId.FDotInvDegfreedom2": "степени_свободы2",
  "XtraSpreadsheetFunctionArgumentNameStringId.FDotinvDotRtProbability": "вероятность",
  "XtraSpreadsheetFunctionArgumentNameStringId.FDotinvDotRtDegfreedom1": "степени_свободы1",
  "XtraSpreadsheetFunctionArgumentNameStringId.FDotinvDotRtDegfreedom2": "степени_свободы2",
  "XtraSpreadsheetFunctionArgumentNameStringId.HypgeomDotDistSamples": "усп_выб",
  "XtraSpreadsheetFunctionArgumentNameStringId.HypgeomDotDistNumbersample": "размер_выб",
  "XtraSpreadsheetFunctionArgumentNameStringId.HypgeomDotDistPopulations": "усп_сов",
  "XtraSpreadsheetFunctionArgumentNameStringId.HypgeomDotDistNumberpop": "размер_сов",
  "XtraSpreadsheetFunctionArgumentNameStringId.HypgeomDotDistCumulative": "интегральная",
  "XtraSpreadsheetFunctionArgumentNameStringId.LogNormDistX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.LogNormDistMean": "среднее",
  "XtraSpreadsheetFunctionArgumentNameStringId.LogNormDistStandarddev": "стандартное_откл",
  "XtraSpreadsheetFunctionArgumentNameStringId.LogNormDistCumulative": "интегральная",
  "XtraSpreadsheetFunctionArgumentNameStringId.LogNormInvProbability": "вероятность",
  "XtraSpreadsheetFunctionArgumentNameStringId.LogNormInvMean": "среднее",
  "XtraSpreadsheetFunctionArgumentNameStringId.LogNormInvStandarddev": "стандартное_отклонение",
  "XtraSpreadsheetFunctionArgumentNameStringId.NegbinomDotDistNumberf": "число_неудач",
  "XtraSpreadsheetFunctionArgumentNameStringId.NegbinomDotDistNumbers": "число_успехов",
  "XtraSpreadsheetFunctionArgumentNameStringId.NegbinomDotDistProbabilitys": "вероятность_успеха",
  "XtraSpreadsheetFunctionArgumentNameStringId.NegbinomDotDistCumulative": "интегральная",
  "XtraSpreadsheetFunctionArgumentNameStringId.NormSDistZ": "z",
  "XtraSpreadsheetFunctionArgumentNameStringId.NormSDistCumulative": "интегральная",
  "XtraSpreadsheetFunctionArgumentNameStringId.NormSInvProbability": "вероятность",
  "XtraSpreadsheetFunctionArgumentNameStringId.TDotTestArray1": "массив1",
  "XtraSpreadsheetFunctionArgumentNameStringId.TDotTestArray2": "массив2",
  "XtraSpreadsheetFunctionArgumentNameStringId.TDotTestTails": "хвосты",
  "XtraSpreadsheetFunctionArgumentNameStringId.TDotTestType": "тип",
  "XtraSpreadsheetFunctionArgumentNameStringId.ZDotTestArray": "массив",
  "XtraSpreadsheetFunctionArgumentNameStringId.ZDotTestX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.ZDotTestSigma": "сигма",
  "XtraSpreadsheetFunctionArgumentNameStringId.ErfPreciseX": "X",
  "XtraSpreadsheetFunctionArgumentNameStringId.ErfcPreciseX": "X",
  "XtraSpreadsheetFunctionArgumentNameStringId.GammaLnPreciseX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.CeilingDotPreciseNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.CeilingDotPreciseSignificance": "точность",
  "XtraSpreadsheetFunctionArgumentNameStringId.FloorDotPreciseNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.FloorDotPreciseSignificance": "точность",
  "XtraSpreadsheetFunctionArgumentNameStringId.ACotNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ACotHNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.CotNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.CotHNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.CscNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.CscHNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.SecNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.SecHNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImTanInumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImCotInumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImCscInumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImCscHInumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImSecInumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImSecHInumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.BitAndNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.BitAndNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.BitOrNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.BitOrNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.BitXorNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.BitXorNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.BitLShiftNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.BitLShiftShiftamount": "сдвиг",
  "XtraSpreadsheetFunctionArgumentNameStringId.BitRShiftNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.BitRShiftShiftamount": "сдвиг",
  "XtraSpreadsheetFunctionArgumentNameStringId.PermutationaNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.PermutationaNumberchosen": "число_выбранных",
  "XtraSpreadsheetFunctionArgumentNameStringId.CombinANumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.CombinANumberchosen": "число_выбранных",
  "XtraSpreadsheetFunctionArgumentNameStringId.XOrLogical1": "логическое_значение1",
  "XtraSpreadsheetFunctionArgumentNameStringId.XOrLogical2": "логическое_значение2",
  "XtraSpreadsheetFunctionArgumentNameStringId.PDurationRate": "ставка",
  "XtraSpreadsheetFunctionArgumentNameStringId.PDurationPv": "тс",
  "XtraSpreadsheetFunctionArgumentNameStringId.PDurationFv": "бс",
  "XtraSpreadsheetFunctionArgumentNameStringId.BaseNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.BaseRadix": "основание",
  "XtraSpreadsheetFunctionArgumentNameStringId.BaseMinlength": "мин_длина",
  "XtraSpreadsheetFunctionArgumentNameStringId.DecimalNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.DecimalRadix": "основание",
  "XtraSpreadsheetFunctionArgumentNameStringId.DaysEnddate": "кон_дата",
  "XtraSpreadsheetFunctionArgumentNameStringId.DaysStartdate": "нач_дата",
  "XtraSpreadsheetFunctionArgumentNameStringId.BinomDistRangeTrials": "испытания",
  "XtraSpreadsheetFunctionArgumentNameStringId.BinomDistRangeProbabilitys": "вероятность_успеха",
  "XtraSpreadsheetFunctionArgumentNameStringId.BinomDistRangeNumbers": "число_успехов",
  "XtraSpreadsheetFunctionArgumentNameStringId.BinomDistRangeNumbers2": "число_успехов2",
  "XtraSpreadsheetFunctionArgumentNameStringId.GammaX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.SkewPNumber1": "число1",
  "XtraSpreadsheetFunctionArgumentNameStringId.SkewPNumber2": "число2",
  "XtraSpreadsheetFunctionArgumentNameStringId.PhiX": "x",
  "XtraSpreadsheetFunctionArgumentNameStringId.RRINper": "кпер",
  "XtraSpreadsheetFunctionArgumentNameStringId.RRIPv": "тс",
  "XtraSpreadsheetFunctionArgumentNameStringId.RRIFv": "бс",
  "XtraSpreadsheetFunctionArgumentNameStringId.UnicodeText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.MUnitDimension": "размер",
  "XtraSpreadsheetFunctionArgumentNameStringId.ArabicText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.ISOWeekNumDate": "дата",
  "XtraSpreadsheetFunctionArgumentNameStringId.NumberValueText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.NumberValueDecimalseparator": "десятичный_разделитель",
  "XtraSpreadsheetFunctionArgumentNameStringId.NumberValueGroupseparator": "разделитель_разрядов",
  "XtraSpreadsheetFunctionArgumentNameStringId.SheetValue": "значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.SheetsReference": "ссылка",
  "XtraSpreadsheetFunctionArgumentNameStringId.FormulaTextReference": "ссылка",
  "XtraSpreadsheetFunctionArgumentNameStringId.IsFormulaReference": "ссылка",
  "XtraSpreadsheetFunctionArgumentNameStringId.IfNAValue": "значение",
  "XtraSpreadsheetFunctionArgumentNameStringId.IfNAValueifna": "значение_если_нд",
  "XtraSpreadsheetFunctionArgumentNameStringId.CeilingMathNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.CeilingMathSignificance": "точность",
  "XtraSpreadsheetFunctionArgumentNameStringId.CeilingMathMode": "режим",
  "XtraSpreadsheetFunctionArgumentNameStringId.FloorMathNumber": "число",
  "XtraSpreadsheetFunctionArgumentNameStringId.FloorMathSignificance": "точность",
  "XtraSpreadsheetFunctionArgumentNameStringId.FloorMathMode": "режим",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImSinHInumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.ImCosHInumber": "компл_число",
  "XtraSpreadsheetFunctionArgumentNameStringId.FunctionFilterXMLXml": "xml",
  "XtraSpreadsheetFunctionArgumentNameStringId.FunctionFilterXMLXpath": "xpath",
  "XtraSpreadsheetFunctionArgumentNameStringId.FunctionWebServiceUrl": "url",
  "XtraSpreadsheetFunctionArgumentNameStringId.EncodeURLText": "текст",
  "XtraSpreadsheetFunctionArgumentNameStringId.ConcatText1": "текст1",
  "XtraSpreadsheetFunctionArgumentNameStringId.ConcatText2": "текст2",
  "XtraSpreadsheetFunctionArgumentNameStringId.IfsLogicaltest": "логическая_проверка1",
  "XtraSpreadsheetFunctionArgumentNameStringId.IfsValueiftrue": "если_значение_истина1",
  "XtraSpreadsheetFunctionArgumentNameStringId.MaxIfsMaxrange": "максимальный_диапазон",
  "XtraSpreadsheetFunctionArgumentNameStringId.MaxIfsCriteriarange": "диапазон_условий",
  "XtraSpreadsheetFunctionArgumentNameStringId.MaxIfsCriteria": "условия",
  "XtraSpreadsheetFunctionArgumentNameStringId.MinIfsMinrange": "минимальный_диапазон",
  "XtraSpreadsheetFunctionArgumentNameStringId.MinIfsCriteriarange": "диапазон_условий",
  "XtraSpreadsheetFunctionArgumentNameStringId.MinIfsCriteria": "условия",
  "XtraSpreadsheetFunctionArgumentNameStringId.SwitchExpression": "выражение",
  "XtraSpreadsheetFunctionArgumentNameStringId.SwitchValue1": "значение1",
  "XtraSpreadsheetFunctionArgumentNameStringId.SwitchResult1": "результат1",
  "XtraSpreadsheetFunctionArgumentNameStringId.SwitchDefaultOrValue2": "по_умолчанию_или_значение2",
  "XtraSpreadsheetFunctionArgumentNameStringId.SwitchResult2": "результат2",
  "XtraSpreadsheetFunctionArgumentNameStringId.SwitchDefaultOrValue3": "по_умолчанию_или_значение3",
  "XtraSpreadsheetFunctionArgumentNameStringId.SwitchResult3": "результат3",
  "XtraSpreadsheetFunctionArgumentNameStringId.TextJoinDelimeter": "разделитель",
  "XtraSpreadsheetFunctionArgumentNameStringId.TextJoinIgnoreEmpty": "пропускать_пустые",
  "XtraSpreadsheetFunctionArgumentNameStringId.TextJoinText1": "текст1",
  "XtraSpreadsheetFunctionArgumentNameStringId.TextJoinText2": "текст2",
  "XtraSpreadsheetFunctionDescriptionStringId.Count": "Подсчитывает количество ячеек в диапазоне, который содержит числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.If": "Проверяет, выполняется ли условие, и возвращает одно значение, если оно выполняется, и другое значение, если нет.",
  "XtraSpreadsheetFunctionDescriptionStringId.IsNA": "Проверяет, является ли значение недоступным (#Н/Д), и возвращает значение ИСТИНА или ЛОЖЬ.",
  "XtraSpreadsheetFunctionDescriptionStringId.IsError": "Проверяет, является ли значение ошибкой (#Н/Д, #ЗНАЧ!, #ССЫЛКА!, #ДЕЛ/0!, #ЧИСЛО!, #ИМЯ? или #ПУСТО!), и возвращает значение ИСТИНА или ЛОЖЬ.",
  "XtraSpreadsheetFunctionDescriptionStringId.Sum": "Суммирует аргументы.",
  "XtraSpreadsheetFunctionDescriptionStringId.Average": "Возвращает среднее арифметическое своих аргументов, которые могут быть числами, именами, массивами или ссылками на ячейки с числами.",
  "XtraSpreadsheetFunctionDescriptionStringId.Min": "Возвращает наименьшее значение из списка аргументов. Логические и текстовые значения игнорируются.",
  "XtraSpreadsheetFunctionDescriptionStringId.Max": "Возвращает наибольшее значение из списка аргументов. Логические и текстовые значения игнорируются.",
  "XtraSpreadsheetFunctionDescriptionStringId.Row": "Возвращает номер строки, определяемой ссылкой.",
  "XtraSpreadsheetFunctionDescriptionStringId.Column": "Возвращает номер столбца, на который указывает ссылка.",
  "XtraSpreadsheetFunctionDescriptionStringId.NA": "Возвращает неопределенное значение #Н/Д (значение недоступно).",
  "XtraSpreadsheetFunctionDescriptionStringId.Npv": "Возвращает величину чистой приведенной стоимости инвестиции, используя ставку дисконтирования и стоимости будущих выплат (отрицательные значения) и поступлений (положительные значения).",
  "XtraSpreadsheetFunctionDescriptionStringId.StDev": "Оценивает стандартное отклонение по выборке. Логические и текстовые значения игнорируются.",
  "XtraSpreadsheetFunctionDescriptionStringId.Dollar": "Преобразует число в текст, используя денежный формат.",
  "XtraSpreadsheetFunctionDescriptionStringId.Fixed": "Форматирует число и преобразует его в текст с заданным числом десятичных знаков.",
  "XtraSpreadsheetFunctionDescriptionStringId.Sin": "Возвращает синус угла.",
  "XtraSpreadsheetFunctionDescriptionStringId.Cos": "Возвращает косинус угла.",
  "XtraSpreadsheetFunctionDescriptionStringId.Tan": "Возвращает тангенс угла.",
  "XtraSpreadsheetFunctionDescriptionStringId.ATan": "Возвращает арктангенс числа в радианах, в диапазоне от -Пи/2 до Пи/2.",
  "XtraSpreadsheetFunctionDescriptionStringId.Pi": "Возвращает округленное до 15 знаков после запятой число Пи (значение 3,14159265358979).",
  "XtraSpreadsheetFunctionDescriptionStringId.Sqrt": "Возвращает значение квадратного корня.",
  "XtraSpreadsheetFunctionDescriptionStringId.Exp": "Возвращает экспоненту заданного числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.Ln": "Возвращает натуральный логарифм числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.Log10": "Возвращает десятичный логарифм числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.Abs": "Возвращает модуль (абсолютную величину) числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.Int": "Округляет число до ближайшего меньшего целого.",
  "XtraSpreadsheetFunctionDescriptionStringId.Sign": "Возвращает знак числа: 1 - если число положительное, 0 - если оно равно нулю и -1 - если число отрицательное.",
  "XtraSpreadsheetFunctionDescriptionStringId.Round": "Округляет число до указанного количества десятичных разрядов.",
  "XtraSpreadsheetFunctionDescriptionStringId.Lookup": "Ищет значения в одной строке, одном столбце или массиве. Включен для обеспечения обратной совместимости.",
  "XtraSpreadsheetFunctionDescriptionStringId.Index": "Возвращает значение или ссылку на ячейку на пересечении конкретных строки и столбца, в данном диапазоне.",
  "XtraSpreadsheetFunctionDescriptionStringId.Rept": "Повторяет текст заданное число раз.",
  "XtraSpreadsheetFunctionDescriptionStringId.Mid": "Возвращает заданное число знаков из строки текста, начиная с указанной позиции.",
  "XtraSpreadsheetFunctionDescriptionStringId.Len": "Возвращает количество знаков в текстовой строке.",
  "XtraSpreadsheetFunctionDescriptionStringId.Value": "Преобразует текстовый аргумент в число.",
  "XtraSpreadsheetFunctionDescriptionStringId.True": "Возвращает логическое значение ИСТИНА.",
  "XtraSpreadsheetFunctionDescriptionStringId.False": "Возвращает логическое значение ЛОЖЬ.",
  "XtraSpreadsheetFunctionDescriptionStringId.And": "Проверяет, все ли аргументы имеют значение ИСТИНА, и возвращает значение ИСТИНА, если истинны все аргументы.",
  "XtraSpreadsheetFunctionDescriptionStringId.Or": "Проверяет, имеет ли хотя бы один из аргументов значение ИСТИНА, и возвращает значение ИСТИНА или ЛОЖЬ. Значение ЛОЖЬ возвращается только в том случае, если все аргументы имеют значение ЛОЖЬ.",
  "XtraSpreadsheetFunctionDescriptionStringId.Not": "Изменяет значение ЛОЖЬ на ИСТИНА, а ИСТИНА на ЛОЖЬ.",
  "XtraSpreadsheetFunctionDescriptionStringId.Mod": "Возвращает остаток от деления.",
  "XtraSpreadsheetFunctionDescriptionStringId.DCount": "Подсчитывает количество числовых ячеек в выборке из заданной базы данных по заданному критерию.",
  "XtraSpreadsheetFunctionDescriptionStringId.DSum": "Суммирует числа в поле (столбце) записей базы данных, удовлетворяющих условию.",
  "XtraSpreadsheetFunctionDescriptionStringId.DAverage": "Возвращает среднее всех значений столбца списка или базы данных, которые удовлетворяют заданным условиям.",
  "XtraSpreadsheetFunctionDescriptionStringId.DMin": "Возвращает минимальное значение среди выделенных фрагментов базы данных.",
  "XtraSpreadsheetFunctionDescriptionStringId.DMax": "Возвращает максимальное значение поля (столбца) записей базы данных, удовлетворяющих указанным условиям.",
  "XtraSpreadsheetFunctionDescriptionStringId.DStDev": "Оценивает стандартное отклонение по выборке из выделенной части базы данных.",
  "XtraSpreadsheetFunctionDescriptionStringId.Var": "Оценивает дисперсию по выборке. Логические и текстовые значения игнорируются.",
  "XtraSpreadsheetFunctionDescriptionStringId.DVar": "Оценивает дисперсию по выборке из выделенной части базы данных.",
  "XtraSpreadsheetFunctionDescriptionStringId.Text": "Форматирует число и преобразует его в текст.",
  "XtraSpreadsheetFunctionDescriptionStringId.Linest": "Возвращает параметры линейного приближения по методу наименьших квадратов.",
  "XtraSpreadsheetFunctionDescriptionStringId.Trend": "Возвращает значения в соответствии с линейной аппроксимацией по методу наименьших квадратов.",
  "XtraSpreadsheetFunctionDescriptionStringId.Logest": "Возвращает параметры экспоненциального приближения.",
  "XtraSpreadsheetFunctionDescriptionStringId.Growth": "Возвращает значения в соответствии с экспоненциальным трендом.",
  "XtraSpreadsheetFunctionDescriptionStringId.Pv": "Возвращает приведенную (к текущему моменту) стоимость инвестиции — общую сумму, которая на настоящий момент равноценна ряду будущих выплат.",
  "XtraSpreadsheetFunctionDescriptionStringId.Fv": "Возвращает будущую стоимость инвестиции на основе периодических постоянных (равных по величине сумм) платежей и постоянной процентной ставки.",
  "XtraSpreadsheetFunctionDescriptionStringId.NPer": "Возвращает общее количество периодов выплаты для инвестиции на основе периодических постоянных выплат и постоянной процентной ставки.",
  "XtraSpreadsheetFunctionDescriptionStringId.Pmt": "Возвращает сумму периодического платежа для аннуитета на основе постоянства сумм платежей и постоянства процентной ставки.",
  "XtraSpreadsheetFunctionDescriptionStringId.Rate": "Возвращает процентную ставку по аннуитету за один период. Например, при годовой процентной ставке в 6% для квартальной ставки используется значение 6%/4.",
  "XtraSpreadsheetFunctionDescriptionStringId.Mirr": "Возвращает внутреннюю ставку доходности для ряда периодических денежных потоков, учитывая как затраты на привлечение инвестиции, так и процент, получаемый от реинвестирования денежных средств.",
  "XtraSpreadsheetFunctionDescriptionStringId.Irr": "Возвращает внутреннюю ставку доходности для ряда потоков денежных средств, представленных численными значениями.",
  "XtraSpreadsheetFunctionDescriptionStringId.Rand": "Возвращает равномерно распределенное случайное число большее или равное 0 и меньшее 1 (изменяется при пересчете).",
  "XtraSpreadsheetFunctionDescriptionStringId.Match": "Возвращает относительную позицию в массиве элемента, соответствующего указанному значению с учетом указанного порядка.",
  "XtraSpreadsheetFunctionDescriptionStringId.Date": "Возвращает число, представляющее дату в коде даты-времени Spreadsheet.",
  "XtraSpreadsheetFunctionDescriptionStringId.Time": "Преобразует заданные в виде чисел часы, минуты и секунды в число в коде времени Spreadsheet.",
  "XtraSpreadsheetFunctionDescriptionStringId.Day": "Возвращает число месяца - число от 1 до 31.",
  "XtraSpreadsheetFunctionDescriptionStringId.Month": "Возвращает месяц - число от 1 (январь) до 12 (декабрь).",
  "XtraSpreadsheetFunctionDescriptionStringId.Year": "Возвращает год - целое число от 1900 до 9999.",
  "XtraSpreadsheetFunctionDescriptionStringId.WeekDay": "Возвращает число от 1 до 7, соответствующее номеру дня недели для заданной даты.",
  "XtraSpreadsheetFunctionDescriptionStringId.Hour": "Возвращает часы в виде числа от 0 до 23.",
  "XtraSpreadsheetFunctionDescriptionStringId.Minute": "Возвращает минуты в виде числа от 0 до 59.",
  "XtraSpreadsheetFunctionDescriptionStringId.Second": "Возвращает секунды в виде числа от 0 до 59.",
  "XtraSpreadsheetFunctionDescriptionStringId.Now": "Возвращает текущую дату и время в формате даты и времени.",
  "XtraSpreadsheetFunctionDescriptionStringId.Areas": "Возвращает количество областей в ссылке. Область представляет собой непрерывный диапазон или одну ячейку.",
  "XtraSpreadsheetFunctionDescriptionStringId.Rows": "Возвращает количество строк в ссылке или массиве.",
  "XtraSpreadsheetFunctionDescriptionStringId.Columns": "Возвращает количество столбцов в массиве или ссылке.",
  "XtraSpreadsheetFunctionDescriptionStringId.Offset": "Возвращает ссылку на диапазон, смещенный относительно заданной ссылки на указанное число строк и столбцов.",
  "XtraSpreadsheetFunctionDescriptionStringId.Search": "Возвращает позицию первого вхождения знака или строки текста при чтении слева направо; прописные и строчные буквы не различаются.",
  "XtraSpreadsheetFunctionDescriptionStringId.Transpose": "Преобразует вертикальный диапазон ячеек в горизонтальный, или наоборот.",
  "XtraSpreadsheetFunctionDescriptionStringId.Type": "Возвращает число, обозначающее тип данных указанного значения: число = 1; строка = 2; логическое значение = 4; ошибка = 16; массив = 64.",
  "XtraSpreadsheetFunctionDescriptionStringId.Call": "Вызывает процедуру из библиотеки динамической компоновки (DLL) или кодового ресурса.",
  "XtraSpreadsheetFunctionDescriptionStringId.ATan2": "Возвращает арктангенс для заданных координат x и y, в радианах между -Пи и Пи, исключая -Пи.",
  "XtraSpreadsheetFunctionDescriptionStringId.ASin": "Возвращает арксинус числа в радианах, в диапазоне от -Пи/2 до Пи/2.",
  "XtraSpreadsheetFunctionDescriptionStringId.ACos": "Возвращает арккосинус числа в радианах, в диапазоне от 0 до Пи. Арккосинус числа есть угол, косинус которого равен числу.",
  "XtraSpreadsheetFunctionDescriptionStringId.Choose": "Выбирает значение или действие из списка значений по номеру индекса.",
  "XtraSpreadsheetFunctionDescriptionStringId.HLookup": "Ищет значение в верхней строке таблицы и возвращает значение ячейки, находящейся в указанной строке того же столбца.",
  "XtraSpreadsheetFunctionDescriptionStringId.VLookup": "Ищет значение в крайнем левом столбце таблицы и возвращает значение ячейки, находящейся в указанном столбце той же строки. По умолчанию таблица должна быть отсортирована по возрастанию.",
  "XtraSpreadsheetFunctionDescriptionStringId.IsRef": "Проверяет, является ли значение ссылкой, и возвращает значение ИСТИНА или ЛОЖЬ.",
  "XtraSpreadsheetFunctionDescriptionStringId.Log": "Возвращает логарифм числа по заданному основанию.",
  "XtraSpreadsheetFunctionDescriptionStringId.Char": "Возвращает символ с заданным кодом.",
  "XtraSpreadsheetFunctionDescriptionStringId.Lower": "Делает все буквы в строке текста строчными.",
  "XtraSpreadsheetFunctionDescriptionStringId.Upper": "Делает все буквы в строке текста прописными.",
  "XtraSpreadsheetFunctionDescriptionStringId.Proper": "Делает прописной первую букву в каждом слове текста, преобразуя все другие буквы в строчные.",
  "XtraSpreadsheetFunctionDescriptionStringId.Left": "Возвращает указанное количество знаков с начала строки текста.",
  "XtraSpreadsheetFunctionDescriptionStringId.Right": "Возвращает указанное число знаков с конца строки текста.",
  "XtraSpreadsheetFunctionDescriptionStringId.Exact": "Проверяет идентичность двух строк текста и возвращает значение ИСТИНА или ЛОЖЬ. Прописные и строчные буквы различаются.",
  "XtraSpreadsheetFunctionDescriptionStringId.Trim": "Удаляет из текста лишние пробелы (кроме одиночных пробелов между словами).",
  "XtraSpreadsheetFunctionDescriptionStringId.Replace": "Заменяет часть строки текста на другую строку.",
  "XtraSpreadsheetFunctionDescriptionStringId.Substitute": "Заменяет новым текстом старый текст в текстовой строке.",
  "XtraSpreadsheetFunctionDescriptionStringId.Code": "Возвращает числовой код первого символа в текстовой строке.",
  "XtraSpreadsheetFunctionDescriptionStringId.Find": "Возвращает позицию начала искомой строки текста в содержащей ее строке текста. Прописные и строчные буквы различаются.",
  "XtraSpreadsheetFunctionDescriptionStringId.Cell": "Возвращает сведения о форматировании, адресе или содержимом первой (согласно установленному для этого листа порядку чтения) ячейки ссылки.",
  "XtraSpreadsheetFunctionDescriptionStringId.IsErr": "Проверяет, является ли значение ошибкой (#ЗНАЧ!, #ССЫЛКА!, #ДЕЛ/0!, #ЧИСЛО!, #ИМЯ? или #ПУСТО!), отличной от #Н/Д, и возвращает значение ИСТИНА или ЛОЖЬ.",
  "XtraSpreadsheetFunctionDescriptionStringId.IsText": "Проверяет, является ли значение текстом, и возвращает значение ИСТИНА или ЛОЖЬ.",
  "XtraSpreadsheetFunctionDescriptionStringId.IsNumber": "Проверяет, является ли значение числом, и возвращает значение ИСТИНА или ЛОЖЬ.",
  "XtraSpreadsheetFunctionDescriptionStringId.IsBlank": "Проверяет, ссылается ли данная ссылка на пустую ячейку, и возвращает значение ИСТИНА или ЛОЖЬ.",
  "XtraSpreadsheetFunctionDescriptionStringId.T": "Проверяет, является ли значение текстовым, и возвращает его текст, если да, либо две кавычки (пустой текст), если нет.",
  "XtraSpreadsheetFunctionDescriptionStringId.N": "Преобразует нечисловые значения в числа, даты - в даты, представленные числами, значения ИСТИНА в 1, все остальные значения - в 0 (ноль).",
  "XtraSpreadsheetFunctionDescriptionStringId.DateValue": "Преобразует дату из текстового формата в числовой в коде даты-времени Spreadsheet.",
  "XtraSpreadsheetFunctionDescriptionStringId.TimeValue": "Преобразует время из текстового формата в число, представляющее время в Spreadsheet - число от 0 (0:00:00) до 0,999988426 (23:59:59). Введя формулу, задайте для ячейки тип \"Время\".",
  "XtraSpreadsheetFunctionDescriptionStringId.Sln": "Возвращает величину амортизации актива за один период, рассчитанную линейным методом.",
  "XtraSpreadsheetFunctionDescriptionStringId.Syd": "Возвращает величину амортизации актива за данный период, рассчитанную методом суммы годовых чисел.",
  "XtraSpreadsheetFunctionDescriptionStringId.Ddb": "Возвращает значение амортизации актива за данный период, используя метод двойного уменьшения остатка или иной явно указанный метод.",
  "XtraSpreadsheetFunctionDescriptionStringId.Indirect": "Возвращает ссылку, заданную текстовой строкой.",
  "XtraSpreadsheetFunctionDescriptionStringId.Clean": "Удаляет все непечатаемые знаки из текста.",
  "XtraSpreadsheetFunctionDescriptionStringId.MDeterm": "Возвращает определитель матрицы (матрица хранится в массиве).",
  "XtraSpreadsheetFunctionDescriptionStringId.MInverse": "Возвращает обратную матрицу (матрица хранится в массиве).",
  "XtraSpreadsheetFunctionDescriptionStringId.MMult": "Возвращает матричное произведение двух массивов; результат имеет то же число строк, что и первый массив, и то же число столбцов, что и второй массив.",
  "XtraSpreadsheetFunctionDescriptionStringId.Ipmt": "Возвращает сумму платежей процентов по инвестиции за данный период на основе постоянства сумм периодических платежей и постоянства процентной ставки.",
  "XtraSpreadsheetFunctionDescriptionStringId.Ppmt": "Возвращает величину платежа в погашение основной суммы по инвестиции за данный период на основе постоянства периодических платежей и постоянства процентной ставки.",
  "XtraSpreadsheetFunctionDescriptionStringId.CountA": "Подсчитывает количество непустых ячеек в диапазоне.",
  "XtraSpreadsheetFunctionDescriptionStringId.Product": "Возвращает произведение аргументов.",
  "XtraSpreadsheetFunctionDescriptionStringId.Fact": "Возвращает факториал числа, равный 1*2*3*..*число.",
  "XtraSpreadsheetFunctionDescriptionStringId.DProduct": "Перемножает значения определенных полей записей базы данных, удовлетворяющих критерию.",
  "XtraSpreadsheetFunctionDescriptionStringId.IsNonText": "Возвращает ИСТИНА, если значение не является текстовым, и ЛОЖЬ в противном случае. Пустые ячейки не являются текстовыми.",
  "XtraSpreadsheetFunctionDescriptionStringId.StDevP": "Вычисляет стандартное отклонение по генеральной совокупности. Логические и текстовые значения игнорируются.",
  "XtraSpreadsheetFunctionDescriptionStringId.VarP": "Вычисляет дисперсию для генеральной совокупности. Логические и текстовые значения игнорируются.",
  "XtraSpreadsheetFunctionDescriptionStringId.DStDevP": "Вычисляет стандартное отклонение по генеральной совокупности из выделенной части базы данных.",
  "XtraSpreadsheetFunctionDescriptionStringId.DVarP": "Вычисляет дисперсию по генеральной совокупности из выделенной части базы данных.",
  "XtraSpreadsheetFunctionDescriptionStringId.Trunc": "Отбрасывает дробную часть числа, так что остается целое число.",
  "XtraSpreadsheetFunctionDescriptionStringId.IsLogical": "Проверяет, является ли значение логическим (ИСТИНА или ЛОЖЬ), и возвращает ИСТИНА или ЛОЖЬ.",
  "XtraSpreadsheetFunctionDescriptionStringId.DCountA": "Подсчитывает количество непустых ячеек в выборке из заданной базы данных по заданному критерию.",
  "XtraSpreadsheetFunctionDescriptionStringId.FindB": "Ищет начальную позицию одной строки текста в другой строке (прописные и строчные буквы различаются). Используется с двухбайтовыми наборами знаков.",
  "XtraSpreadsheetFunctionDescriptionStringId.SearchB": "Возвращает позицию первого вхождения знака или строки при чтении слева направо; прописные и строчные буквы не различаются. Используется с двухбайтовыми наборами знаков.",
  "XtraSpreadsheetFunctionDescriptionStringId.ReplaceB": "Заменяет часть строки текста на другую строку. Используется с двухбайтовыми наборами знаков.",
  "XtraSpreadsheetFunctionDescriptionStringId.LeftB": "Возвращает указанное число знаков с начала текстовой строки. Используется с двухбайтовыми наборами знаков.",
  "XtraSpreadsheetFunctionDescriptionStringId.RightB": "Возвращает указанное число знаков с конца текстовой строки. Используйте с двухбайтовыми наборами знаков.",
  "XtraSpreadsheetFunctionDescriptionStringId.MidB": "Возвращает заданное число знаков из текстовой строки, начиная с указанной позиции. Используется с двухбайтовыми наборами знаков.",
  "XtraSpreadsheetFunctionDescriptionStringId.LenB": "Возвращает число знаков в строке текста. Используйте с двухбайтовыми наборами знаков.",
  "XtraSpreadsheetFunctionDescriptionStringId.RoundUp": "Округляет число до ближайшего большего по модулю.",
  "XtraSpreadsheetFunctionDescriptionStringId.RoundDown": "Округляет число до ближайшего меньшего по модулю.",
  "XtraSpreadsheetFunctionDescriptionStringId.Asc": "Преобразует двухбайтовые знаки в однобайтовые. Используйте с двухбайтовыми наборами знаков.",
  "XtraSpreadsheetFunctionDescriptionStringId.Rank": "Возвращает ранг числа в списке чисел: его порядковый номер относительно других чисел в списке.",
  "XtraSpreadsheetFunctionDescriptionStringId.Address": "Возвращает ссылку на одну ячейку в рабочем листе в виде текста.",
  "XtraSpreadsheetFunctionDescriptionStringId.Days360": "Вычисляет количество дней между двумя датами на основе 360-дневного года (двенадцать месяцев по 30 дней).",
  "XtraSpreadsheetFunctionDescriptionStringId.Today": "Возвращает текущую дату в формате даты.",
  "XtraSpreadsheetFunctionDescriptionStringId.Vdb": "Возвращает величину амортизации актива для любого выбранного периода, в том числе для частичных периодов, с использованием метода двойного уменьшения остатка или иного указанного метода.",
  "XtraSpreadsheetFunctionDescriptionStringId.Median": "Возвращает медиану исходных чисел.",
  "XtraSpreadsheetFunctionDescriptionStringId.SumProduct": "Возвращает сумму произведений диапазонов или массивов.",
  "XtraSpreadsheetFunctionDescriptionStringId.SinH": "Возвращает гиперболический синус числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.CosH": "Возвращает гиперболический косинус числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.TanH": "Возвращает гиперболический тангенс числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.ASinH": "Возвращает гиперболический арксинус числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.ACosH": "Возвращает гиперболический арккосинус числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.ATanH": "Возвращает гиперболический арктангенс числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.DGet": "Извлекает из базы данных одну запись, удовлетворяющую заданному критерию.",
  "XtraSpreadsheetFunctionDescriptionStringId.Info": "Возвращает сведения о текущей операционной среде.",
  "XtraSpreadsheetFunctionDescriptionStringId.Db": "Возвращает величину амортизации актива для заданного периода, рассчитанную методом фиксированного уменьшения остатка.",
  "XtraSpreadsheetFunctionDescriptionStringId.Frequency": "Вычисляет распределение значений по интервалам и возвращает вертикальный массив, содержащий на один элемент больше, чем массив интервалов.",
  "XtraSpreadsheetFunctionDescriptionStringId.ErrorType": "Возвращает код ошибки, соответствующий ее значению.",
  "XtraSpreadsheetFunctionDescriptionStringId.RegisterId": "Возвращает регистрационный идентификатор указанной библиотеки динамической компоновки (DLL) или ранее зарегистрированного кодового ресурса.",
  "XtraSpreadsheetFunctionDescriptionStringId.Avedev": "Возвращает среднее абсолютных значений отклонений точек данных от среднего. Аргументами могут являться числа, имена, массивы или ссылки на числовые значения.",
  "XtraSpreadsheetFunctionDescriptionStringId.BetaDistCompatibility": "Возвращает интегральную функцию плотности бета-вероятности.",
  "XtraSpreadsheetFunctionDescriptionStringId.GammaLn": "Возвращает натуральный логарифм гамма-функции.",
  "XtraSpreadsheetFunctionDescriptionStringId.BetaInv": "Возвращает обратную функцию к интегральной функции плотности бета-вероятности.",
  "XtraSpreadsheetFunctionDescriptionStringId.BinomDist": "Возвращает отдельное значение биномиального распределения.",
  "XtraSpreadsheetFunctionDescriptionStringId.ChiDist": "Возвращает одностороннюю вероятность распределения хи-квадрат.",
  "XtraSpreadsheetFunctionDescriptionStringId.ChiInv": "Возвращает значение обратное к односторонней вероятности распределения хи-квадрат.",
  "XtraSpreadsheetFunctionDescriptionStringId.Combin": "Возвращает количество комбинаций для заданного числа элементов.",
  "XtraSpreadsheetFunctionDescriptionStringId.Confidence": "Возвращает доверительный интервал для среднего генеральной совокупности, используя нормальное распределение.",
  "XtraSpreadsheetFunctionDescriptionStringId.CritBinom": "Возвращает наименьшее значение, для которого биномиальная функция распределения больше или равна заданного значения.",
  "XtraSpreadsheetFunctionDescriptionStringId.Even": "Округляет число до ближайшего четного целого. Положительные числа округляются в сторону увеличения, отрицательные - в сторону уменьшения.",
  "XtraSpreadsheetFunctionDescriptionStringId.ExponDist": "Возвращает экспоненциальное распределение.",
  "XtraSpreadsheetFunctionDescriptionStringId.FDist": "Возвращает одностороннее F-распределение вероятности (степень отклонения) для двух наборов данных.",
  "XtraSpreadsheetFunctionDescriptionStringId.FInv": "Возвращает обратное значение для одностороннего F-распределения вероятностей: если p = FРАСП(x,...), то FРАСПОБР(p,...) = x.",
  "XtraSpreadsheetFunctionDescriptionStringId.Fisher": "Возвращает преобразование Фишера.",
  "XtraSpreadsheetFunctionDescriptionStringId.FisherInv": "Возвращает обратное преобразование Фишера: если y = ФИШЕР(x), то ФИШЕРОБР(y) = x.",
  "XtraSpreadsheetFunctionDescriptionStringId.Floor": "Округляет число до ближайшего меньшего по модулю целого, кратного указанному значению.",
  "XtraSpreadsheetFunctionDescriptionStringId.GammaDist": "Возвращает гамма-распределение.",
  "XtraSpreadsheetFunctionDescriptionStringId.GammaInv": "Возвращает обратное гамма-распределение.",
  "XtraSpreadsheetFunctionDescriptionStringId.Ceiling": "Округляет число до ближайшего большего по модулю целого, кратного указанному значению.",
  "XtraSpreadsheetFunctionDescriptionStringId.HypGeomDist": "Возвращает гипергеометрическое распределение.",
  "XtraSpreadsheetFunctionDescriptionStringId.LogNormDistCompatibility": "Возвращает интегральное логнормальное распределение, где ln(x) представляет собой нормальное распределение.",
  "XtraSpreadsheetFunctionDescriptionStringId.LogInvCompatibility": "Возвращает обратное логарифмическое нормальное распределение, где ln(x) представляет собой нормальное распределение.",
  "XtraSpreadsheetFunctionDescriptionStringId.NegBinomDist": "Возвращает отрицательное биномиальное распределение - вероятность возникновения определенного числа неудач до указанного количества успехов, с данной вероятностью успеха.",
  "XtraSpreadsheetFunctionDescriptionStringId.NormDistCompatibility": "Возвращает нормальную функцию распределения.",
  "XtraSpreadsheetFunctionDescriptionStringId.NormSDistCompatibility": "Возвращает стандартное нормальное интегральное распределение.",
  "XtraSpreadsheetFunctionDescriptionStringId.NormInvCompatibility": "Возвращает обратное нормальное распределение.",
  "XtraSpreadsheetFunctionDescriptionStringId.NormSInvCompatibility": "Возвращает обратное значение стандартного нормального распределения.",
  "XtraSpreadsheetFunctionDescriptionStringId.Standardize": "Возвращает нормализованное значение.",
  "XtraSpreadsheetFunctionDescriptionStringId.Odd": "Округляет число до ближайшего нечетного целого: положительное - в сторону увеличения, отрицательное - в сторону уменьшения.",
  "XtraSpreadsheetFunctionDescriptionStringId.Permut": "Возвращает количество перестановок  заданного числа объектов, которые выбираются из общего числа объектов.",
  "XtraSpreadsheetFunctionDescriptionStringId.Poisson": "Возвращает распределение Пуассона.",
  "XtraSpreadsheetFunctionDescriptionStringId.TDist": "Возвращает t-распределение Стьюдента.",
  "XtraSpreadsheetFunctionDescriptionStringId.Weibull": "Возвращает распределение Вейбулла.",
  "XtraSpreadsheetFunctionDescriptionStringId.SumXMY2": "Возвращает сумму квадратов разностей соответствующих значений в двух массивах.",
  "XtraSpreadsheetFunctionDescriptionStringId.SumX2MY2": "Возвращает сумму разностей квадратов соответствующих значений в двух массивах.",
  "XtraSpreadsheetFunctionDescriptionStringId.SumX2PY2": "Возвращает сумму сумм квадратов соответствующих элементов двух массивов.",
  "XtraSpreadsheetFunctionDescriptionStringId.ChiTest": "Возвращает тест на независимость: значение распределения хи-квадрат для статистического распределения и соответствующего числа степеней свободы.",
  "XtraSpreadsheetFunctionDescriptionStringId.Correl": "Возвращает коэффициент корреляции между двумя множествами данных.",
  "XtraSpreadsheetFunctionDescriptionStringId.Covar": "Возвращает ковариацию, среднее попарных произведений отклонений.",
  "XtraSpreadsheetFunctionDescriptionStringId.Forecast": "Возвращает значение линейного тренда, значение проекции по линейному приближению.",
  "XtraSpreadsheetFunctionDescriptionStringId.FTest": "Возвращает результат F-теста, двустороннюю вероятность сходства двух совокупностей.",
  "XtraSpreadsheetFunctionDescriptionStringId.Intercept": "Возвращает отрезок, отсекаемый на оси линией линейной регрессии.",
  "XtraSpreadsheetFunctionDescriptionStringId.Pearson": "Возвращает коэффициент корреляции Пирсона, r.",
  "XtraSpreadsheetFunctionDescriptionStringId.Rsq": "Возвращает квадрат коэффициента корреляции Пирсона по данным точкам.",
  "XtraSpreadsheetFunctionDescriptionStringId.StEYX": "Возвращает стандартную ошибку предсказанных значений y для каждого значения x в регрессии.",
  "XtraSpreadsheetFunctionDescriptionStringId.Slope": "Возвращает наклон линии линейной регрессии.",
  "XtraSpreadsheetFunctionDescriptionStringId.TTest": "Возвращает вероятность, соответствующую t-тесту Стьюдента.",
  "XtraSpreadsheetFunctionDescriptionStringId.Prob": "Возвращает вероятность того, что значения диапазона находятся внутри заданных пределов.",
  "XtraSpreadsheetFunctionDescriptionStringId.DevSq": "Возвращает сумму квадратов отклонений точек данных от среднего по выборке.",
  "XtraSpreadsheetFunctionDescriptionStringId.Geomean": "Возвращает среднее геометрическое для массива или диапазона из положительных чисел.",
  "XtraSpreadsheetFunctionDescriptionStringId.HarMean": "Возвращает среднее гармоническое для множества положительных чисел - величину, обратную среднему арифметическому обратных величин.",
  "XtraSpreadsheetFunctionDescriptionStringId.SumSq": "Возвращает сумму квадратов аргументов. Аргументами могут являться числа, массивы, имена или ссылки на числовые значения.",
  "XtraSpreadsheetFunctionDescriptionStringId.Kurt": "Возвращает эксцесс множества данных.",
  "XtraSpreadsheetFunctionDescriptionStringId.Skew": "Возвращает асимметрию распределения относительно среднего.",
  "XtraSpreadsheetFunctionDescriptionStringId.ZTest": "Возвращает одностороннее P-значение z-теста.",
  "XtraSpreadsheetFunctionDescriptionStringId.Large": "Возвращает k-ое наибольшее значение в множестве данных (например, пятое наибольшее).",
  "XtraSpreadsheetFunctionDescriptionStringId.Small": "Возвращает k-ое наименьшее значение в множестве данных (например, пятое наименьшее).",
  "XtraSpreadsheetFunctionDescriptionStringId.Quartile": "Возвращает квартиль множества данных.",
  "XtraSpreadsheetFunctionDescriptionStringId.Percentile": "Возвращает k-й процентиль для значений диапазона.",
  "XtraSpreadsheetFunctionDescriptionStringId.PercentRank": "Возвращает процентную норму значения в множестве данных.",
  "XtraSpreadsheetFunctionDescriptionStringId.Mode": "Возвращает значение моды для массива или диапазона значений.",
  "XtraSpreadsheetFunctionDescriptionStringId.Trimmean": "Возвращает среднее внутренней части множества данных.",
  "XtraSpreadsheetFunctionDescriptionStringId.Tinv": "Возвращает двустороннее обратное распределение Стьюдента.",
  "XtraSpreadsheetFunctionDescriptionStringId.Concatenate": "Объединяет несколько текстовых строк в одну.",
  "XtraSpreadsheetFunctionDescriptionStringId.Power": "Возвращает результат возведения в степень.",
  "XtraSpreadsheetFunctionDescriptionStringId.Radians": "Преобразует градусы в радианы.",
  "XtraSpreadsheetFunctionDescriptionStringId.Degrees": "Преобразует радианы в градусы.",
  "XtraSpreadsheetFunctionDescriptionStringId.Subtotal": "Возвращает промежуточные итоги в список или базу данных.",
  "XtraSpreadsheetFunctionDescriptionStringId.SumIf": "Суммирует ячейки, заданные указанным условием.",
  "XtraSpreadsheetFunctionDescriptionStringId.CountIf": "Подсчитывает количество непустых ячеек в диапазоне, удовлетворяющих заданному условию.",
  "XtraSpreadsheetFunctionDescriptionStringId.CountBlank": "Подсчитывает количество пустых ячеек в диапазоне.",
  "XtraSpreadsheetFunctionDescriptionStringId.IsPmt": "Вычисляет проценты, выплачиваемые за определенный инвестиционный период.",
  "XtraSpreadsheetFunctionDescriptionStringId.DateDif": "",
  "XtraSpreadsheetFunctionDescriptionStringId.Roman": "Преобразует арабские числа в римские, в текстовом формате.",
  "XtraSpreadsheetFunctionDescriptionStringId.GetPivotData": "Извлекает данные, хранящиеся в сводной таблице.",
  "XtraSpreadsheetFunctionDescriptionStringId.Hyperlink": "Создает ссылку, открывающую документ, находящийся на жестком диске, сервере сети или в Интернете.",
  "XtraSpreadsheetFunctionDescriptionStringId.Phonetic": "Получение фонетической строки.",
  "XtraSpreadsheetFunctionDescriptionStringId.AverageA": "Возвращает среднее арифметическое указанных аргументов. При этом текстовые и ложные логические значения считаются равными 0, а истинные логические значения считаются равными 1. В качестве аргументов могут быть указаны числа, имена, массивы или ссылки.",
  "XtraSpreadsheetFunctionDescriptionStringId.MaxA": "Возвращает наибольшее значение из набора значений. Учитываются логические и текстовые значения.",
  "XtraSpreadsheetFunctionDescriptionStringId.MinA": "Возвращает наименьшее значение из набора значений. Учитываются логические и текстовые значения.",
  "XtraSpreadsheetFunctionDescriptionStringId.StDevPA": "Вычисляет стандартное отклонение по генеральной совокупности с учетом логических и текстовых значений. При этом текстовые и ложные логические значения считаются равными 0, а истинные логические значения считаются равными 1.",
  "XtraSpreadsheetFunctionDescriptionStringId.VarPA": "Вычисляет дисперсию по генеральной совокупности с учетом логических и текстовых значений. При этом текстовые и ложные логические значения считаются равными 0, а истинные логические значения считаются равными 1.",
  "XtraSpreadsheetFunctionDescriptionStringId.StDevA": "Вычисляет стандартное отклонение по выборке с учетом логических и текстовых значений. При этом текстовые и ложные логические значения считаются равными 0, а истинные логические значения считаются равными 1.",
  "XtraSpreadsheetFunctionDescriptionStringId.VarA": "Вычисляет дисперсию по выборке с учетом логических и текстовых значений. При этом текстовые и ложные логические значения считаются равными 0, а истинные логические значения считаются равными 1.",
  "XtraSpreadsheetFunctionDescriptionStringId.BahtText": "Преобразует число в текст (бат).",
  "XtraSpreadsheetFunctionDescriptionStringId.Rtd": "Получает данные реального времени от программы, поддерживающей автоматизацию COM.",
  "XtraSpreadsheetFunctionDescriptionStringId.CubeValue": "Возвращает агрегированное значение из куба.",
  "XtraSpreadsheetFunctionDescriptionStringId.CubeMember": "Возвращает элемент или кортеж из куба.",
  "XtraSpreadsheetFunctionDescriptionStringId.CubeMemberProperty": "Возвращает значение свойства элемента из куба.",
  "XtraSpreadsheetFunctionDescriptionStringId.CubeRankedMember": "Возвращает n-й по порядку элемент множества.",
  "XtraSpreadsheetFunctionDescriptionStringId.Hex2Bin": "Преобразует шестнадцатеричное число в двоичное.",
  "XtraSpreadsheetFunctionDescriptionStringId.Hex2Dec": "Преобразует шестнадцатеричное число в десятичное.",
  "XtraSpreadsheetFunctionDescriptionStringId.Hex2Oct": "Преобразует шестнадцатеричное число в восьмеричное.",
  "XtraSpreadsheetFunctionDescriptionStringId.Dec2Bin": "Преобразует десятичное число в двоичное.",
  "XtraSpreadsheetFunctionDescriptionStringId.Dec2Hex": "Преобразует десятичное число в шестнадцатеричное.",
  "XtraSpreadsheetFunctionDescriptionStringId.Dec2Oct": "Преобразует десятичное число в восьмеричное.",
  "XtraSpreadsheetFunctionDescriptionStringId.Oct2Bin": "Преобразует восьмеричное число в двоичное.",
  "XtraSpreadsheetFunctionDescriptionStringId.Oct2Hex": "Преобразует восьмеричное число в шестнадцатеричное.",
  "XtraSpreadsheetFunctionDescriptionStringId.Oct2Dec": "Преобразует восьмеричное число в десятичное.",
  "XtraSpreadsheetFunctionDescriptionStringId.Bin2Dec": "Преобразует двоичное число в десятичное.",
  "XtraSpreadsheetFunctionDescriptionStringId.Bin2Oct": "Преобразует двоичное число в восьмеричное.",
  "XtraSpreadsheetFunctionDescriptionStringId.Bin2Hex": "Преобразует двоичное число в шестнадцатеричное.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImSub": "Возвращает разность двух комплексных чисел.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImDiv": "Возвращает частное двух комплексных чисел.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImPower": "Возвращает комплексное число, возведенное в степень с целочисленным показателем.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImAbs": "Возвращает абсолютную величину (модуль) комплексного числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImSqrt": "Возвращает значение квадратного корня комплексного числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImLn": "Возвращает натуральный логарифм комплексного числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImLog2": "Возвращает двоичный логарифм комплексного числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImLog10": "Возвращает десятичный логарифм комплексного числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImSin": "Возвращает синус комплексного числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImCos": "Возвращает косинус комплексного числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImExp": "Возвращает экспоненту комплексного числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImArgument": "Возвращает аргумент q, то есть угол, выраженный в радианах.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImConjugate": "Возвращает комплексно-сопряженное комплексного числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.Imaginary": "Возвращает коэффициент при мнимой части комплексного числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImReal": "Возвращает коэффициент при вещественной (действительной) части комплексного числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.Complex": "Преобразует коэффициенты при вещественной и мнимой частях комплексного числа в комплексное число.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImSum": "Возвращает сумму комплексных чисел.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImProduct": "Возвращает произведение от 1 до 255 комплексных чисел.",
  "XtraSpreadsheetFunctionDescriptionStringId.Seriessum": "Возвращает сумму степенного ряда, вычисленную по формуле.",
  "XtraSpreadsheetFunctionDescriptionStringId.FactDouble": "Возвращает двойной факториал числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.SqrtPi": "Возвращает квадратный корень из значения выражения (число * ПИ).",
  "XtraSpreadsheetFunctionDescriptionStringId.Quotient": "Возвращает целую часть результата деления с остатком.",
  "XtraSpreadsheetFunctionDescriptionStringId.Delta": "Проверяет равенство двух чисел.",
  "XtraSpreadsheetFunctionDescriptionStringId.Gestep": "Проверяет, превышает ли число пороговое значение.",
  "XtraSpreadsheetFunctionDescriptionStringId.IsEven": "Возвращает значение ИСТИНА, если число четное.",
  "XtraSpreadsheetFunctionDescriptionStringId.IsOdd": "Возвращает значение ИСТИНА, если число нечетное.",
  "XtraSpreadsheetFunctionDescriptionStringId.MRound": "Возвращает число, округленное с желаемой точностью.",
  "XtraSpreadsheetFunctionDescriptionStringId.Erf": "Возвращает функцию ошибки.",
  "XtraSpreadsheetFunctionDescriptionStringId.Erfc": "Возвращает дополнительную функцию ошибки.",
  "XtraSpreadsheetFunctionDescriptionStringId.BesselJ": "Возвращает функцию Бесселя Jn(x).",
  "XtraSpreadsheetFunctionDescriptionStringId.BesselK": "Возвращает функцию Бесселя Kn(x).",
  "XtraSpreadsheetFunctionDescriptionStringId.BesselY": "Возвращает функцию Бесселя Yn(x).",
  "XtraSpreadsheetFunctionDescriptionStringId.BesselI": "Возвращает модифицированную функцию Бесселя In(x).",
  "XtraSpreadsheetFunctionDescriptionStringId.Xirr": "Возвращает внутреннюю ставку доходности для графика денежных потоков.",
  "XtraSpreadsheetFunctionDescriptionStringId.Xnpv": "Возвращает чистую приведенную стоимость для графика денежных потоков.",
  "XtraSpreadsheetFunctionDescriptionStringId.PriceMat": "Возвращает цену за 100 рублей номинальной стоимости ценных бумаг, по которым процент выплачивается в срок погашения.",
  "XtraSpreadsheetFunctionDescriptionStringId.YieldMat": "Возвращает годовую доходность ценных бумаг, по которым процент выплачивается в срок погашения.",
  "XtraSpreadsheetFunctionDescriptionStringId.Intrate": "Возвращает процентную ставку для полностью инвестированных ценных бумаг.",
  "XtraSpreadsheetFunctionDescriptionStringId.Received": "Возвращает сумму, полученную к сроку погашения полностью инвестированных ценных бумаг.",
  "XtraSpreadsheetFunctionDescriptionStringId.Disc": "Возвращает ставку дисконтирования для ценных бумаг.",
  "XtraSpreadsheetFunctionDescriptionStringId.PriceDisc": "Возвращает цену за 100 рублей номинальной стоимости ценных бумаг, на которые сделана скидка.",
  "XtraSpreadsheetFunctionDescriptionStringId.YieldDisc": "Возвращает годовую доходность по ценным бумагам, на которые сделана скидка. Например, по казначейским векселям.",
  "XtraSpreadsheetFunctionDescriptionStringId.TbillEq": "Возвращает эквивалентный облигации доход по казначейскому векселю.",
  "XtraSpreadsheetFunctionDescriptionStringId.TbillPrice": "Возвращает цену за 100 рублей номинальной стоимости для казначейского векселя.",
  "XtraSpreadsheetFunctionDescriptionStringId.TbillYield": "Возвращает доходность по казначейскому векселю.",
  "XtraSpreadsheetFunctionDescriptionStringId.Price": "Возвращает цену за 100 рублей номинальной стоимости ценных бумаг, по которым выплачивается периодический процент.",
  "XtraSpreadsheetFunctionDescriptionStringId.Yield": "Возвращает доходность ценных бумаг, по которым выплачивается периодический процент.",
  "XtraSpreadsheetFunctionDescriptionStringId.DollarDe": "Преобразует цену в рублях, выраженную в виде дроби, в цену в рублях, выраженную десятичным числом.",
  "XtraSpreadsheetFunctionDescriptionStringId.DollarFr": "Преобразует цену в рублях, выраженную десятичным числом, в цену в рублях, выраженную в виде дроби.",
  "XtraSpreadsheetFunctionDescriptionStringId.Nominal": "Возвращает номинальную годовую процентную ставку.",
  "XtraSpreadsheetFunctionDescriptionStringId.Effect": "Возвращает фактическую (эффективную) годовую процентную ставку.",
  "XtraSpreadsheetFunctionDescriptionStringId.CumPrinc": "Возвращает кумулятивную (нарастающим итогом) сумму, выплачиваемую в погашение основной суммы займа в промежутке между двумя периодами.",
  "XtraSpreadsheetFunctionDescriptionStringId.CumIpmt": "Возвращает кумулятивную (нарастающим итогом) величину процентов, выплачиваемых по займу в промежутке между двумя периодами выплат.",
  "XtraSpreadsheetFunctionDescriptionStringId.EDate": "Возвращает порядковый номер даты, отстоящей на заданное число месяцев вперед или назад от заданной даты (нач_дата).",
  "XtraSpreadsheetFunctionDescriptionStringId.EOMonth": "Возвращает порядковый номер последнего дня месяца, отстоящего на заданное число месяцев вперед или назад от заданной даты (нач_дата).",
  "XtraSpreadsheetFunctionDescriptionStringId.YearFrac": "Возвращает долю года, которую составляет количество дней между двумя датами (начальной и конечной).",
  "XtraSpreadsheetFunctionDescriptionStringId.CoupDaybs": "Возвращает количество дней от начала действия купона до даты соглашения.",
  "XtraSpreadsheetFunctionDescriptionStringId.CoupDays": "Возвращает количество дней в периоде купона, который содержит дату расчета.",
  "XtraSpreadsheetFunctionDescriptionStringId.CoupDaysnc": "Возвращает количество от даты расчета до срока следующего купона.",
  "XtraSpreadsheetFunctionDescriptionStringId.Coupncd": "Возвращает порядковый номер даты следующего купона после даты соглашения.",
  "XtraSpreadsheetFunctionDescriptionStringId.CoupNum": "Возвращает количество купонов между датой соглашения и сроком вступления в силу.",
  "XtraSpreadsheetFunctionDescriptionStringId.Couppcd": "Возвращает порядковый номер даты предыдущего купона до даты соглашения.",
  "XtraSpreadsheetFunctionDescriptionStringId.Duration": "Возвращает продолжительность Макалея для ценных бумаг, по которым выплачивается периодический процент.",
  "XtraSpreadsheetFunctionDescriptionStringId.MDuration": "Возвращает модифицированную продолжительность Макалея для ценных бумаг с предполагаемой номинальной стоимостью 100 рублей.",
  "XtraSpreadsheetFunctionDescriptionStringId.OddLPrice": "Возвращает цену за 100 рублей номинальной стоимости ценных бумаг с нерегулярным (коротким или длинным) последним периодом купона.",
  "XtraSpreadsheetFunctionDescriptionStringId.OddLYield": "Возвращает доход по ценным бумагам с нерегулярным (коротким или длинным) последним периодом купона.",
  "XtraSpreadsheetFunctionDescriptionStringId.OddFPrice": "Возвращает цену за 100 рублей номинальной стоимости ценных бумаг с нерегулярным (коротким или длинным) первым периодом купона.",
  "XtraSpreadsheetFunctionDescriptionStringId.OddFYield": "Возвращает доход по ценным бумагам с нерегулярным (коротким или длинным) первым периодом купона.",
  "XtraSpreadsheetFunctionDescriptionStringId.RandBetween": "Возвращает случайное число между двумя заданными числами.",
  "XtraSpreadsheetFunctionDescriptionStringId.WeekNum": "Возвращает номер недели года.",
  "XtraSpreadsheetFunctionDescriptionStringId.Amordegrc": "Возвращает величину пропорционально распределенной амортизации актива для каждого учетного периода.",
  "XtraSpreadsheetFunctionDescriptionStringId.Amorlinc": "Возвращает величину пропорционально распределенной амортизации актива для каждого учетного периода.",
  "XtraSpreadsheetFunctionDescriptionStringId.Convert": "Преобразует значение из одной системы мер в другую.",
  "XtraSpreadsheetFunctionDescriptionStringId.Accrint": "Возвращает накопленный процент по ценным бумагам с периодической выплатой процентов.",
  "XtraSpreadsheetFunctionDescriptionStringId.Accrintm": "Возвращает накопленный процент по ценным бумагам, процент по которым выплачивается в срок погашения.",
  "XtraSpreadsheetFunctionDescriptionStringId.WorkDay": "Возвращает порядковый номер даты, отстоящей на заданное число рабочих дней вперед или назад от начальной даты.",
  "XtraSpreadsheetFunctionDescriptionStringId.NetworkDays": "Возвращает количество полных рабочих дней между двумя датами.",
  "XtraSpreadsheetFunctionDescriptionStringId.Gcd": "Возвращает наибольший общий делитель.",
  "XtraSpreadsheetFunctionDescriptionStringId.Multinomial": "Возвращает отношение факториала суммы значений к произведению факториалов значений.",
  "XtraSpreadsheetFunctionDescriptionStringId.Lcm": "Возвращает наименьшее общее кратное.",
  "XtraSpreadsheetFunctionDescriptionStringId.FvSchedule": "Возвращает будущее значение первоначальной основной суммы после применения ряда (плана) ставок сложных процентов.",
  "XtraSpreadsheetFunctionDescriptionStringId.CubeKpiMember": "Возвращает свойство ключевого показателя эффективности (КПЭ) и выводит имя КПЭ в ячейке.",
  "XtraSpreadsheetFunctionDescriptionStringId.CubeSet": "Определяет вычисляемое множество элементов или кортежей путем отправки выражения множества в куб на сервере, который создает множество и возвращает его в Spreadsheet.",
  "XtraSpreadsheetFunctionDescriptionStringId.CubeSetCount": "Возвращает число элементов множества.",
  "XtraSpreadsheetFunctionDescriptionStringId.IfError": "Возвращает значение_если_ошибка, если выражение ошибочно; в противном случае возвращает само выражение.",
  "XtraSpreadsheetFunctionDescriptionStringId.CountIfs": "Подсчитывает количество ячеек, удовлетворяющих заданному набору условий.",
  "XtraSpreadsheetFunctionDescriptionStringId.SumIfs": "Суммирует ячейки, удовлетворяющие заданному набору условий.",
  "XtraSpreadsheetFunctionDescriptionStringId.AverageIf": "Вычисляет среднее (арифметическое) для ячеек, заданных указанным условием.",
  "XtraSpreadsheetFunctionDescriptionStringId.AverageIfs": "Вычисляет среднее (арифметическое) для ячеек, удовлетворяющие заданному набору условий.",
  "XtraSpreadsheetFunctionDescriptionStringId.Aggregate": "Возвращает сводное значение в списке или базе данных.",
  "XtraSpreadsheetFunctionDescriptionStringId.BinomDotDist": "Возвращает отдельное значение биномиального распределения.",
  "XtraSpreadsheetFunctionDescriptionStringId.BinomDotInv": "Возвращает наименьшее значение, для которого биномиальная функция распределения больше или равна заданного значения.",
  "XtraSpreadsheetFunctionDescriptionStringId.ConfidenceNorm": "Возвращает доверительный интервал для среднего генеральной совокупности с использованием нормального распределения.",
  "XtraSpreadsheetFunctionDescriptionStringId.ConfidenceDotT": "Возвращает доверительный интервал для среднего генеральной совокупности с использованием распределения Стьюдента.",
  "XtraSpreadsheetFunctionDescriptionStringId.ChisqDotTest": "Возвращает тест на независимость: значение распределения хи-квадрат для статистического распределения и соответствующего числа степеней свободы.",
  "XtraSpreadsheetFunctionDescriptionStringId.FDotTest": "Возвращает результат F-теста, двустороннюю вероятность сходства двух совокупностей.",
  "XtraSpreadsheetFunctionDescriptionStringId.CovarianceP": "Возвращает ковариацию генеральной совокупности, среднее попарных произведений отклонений.",
  "XtraSpreadsheetFunctionDescriptionStringId.CovarianceS": "Возвращает ковариацию выборки, среднее попарных произведений отклонений.",
  "XtraSpreadsheetFunctionDescriptionStringId.ExponDotDist": "Возвращает экспоненциальное распределение.",
  "XtraSpreadsheetFunctionDescriptionStringId.GammaDotDist": "Возвращает гамма-распределение.",
  "XtraSpreadsheetFunctionDescriptionStringId.GammaDotInv": "Возвращает обратное интегральное гамма-распределение: если p = ГАММА.РАСП(x,...), то ГАММА.ОБР(p,...) = x.",
  "XtraSpreadsheetFunctionDescriptionStringId.ModeMult": "Возвращает вертикальный массив наиболее часто встречающихся (повторяющихся) значений в массиве или диапазоне значений. Для горизонтального массива используйте выражение =ТРАНСП(МОДА.НСК(число1,число2,...)).",
  "XtraSpreadsheetFunctionDescriptionStringId.ModeSngl": "Возвращает значение моды для массива или диапазона значений.",
  "XtraSpreadsheetFunctionDescriptionStringId.NormDist": "Возвращает нормальную функцию распределения.",
  "XtraSpreadsheetFunctionDescriptionStringId.NormInv": "Возвращает обратное нормальное распределение.",
  "XtraSpreadsheetFunctionDescriptionStringId.PercentileExc": "Возвращает k-й процентиль для значений диапазона (k от 0 до 1 не включительно).",
  "XtraSpreadsheetFunctionDescriptionStringId.PercentileInc": "Возвращает k-й процентиль для значений диапазона, при k от 0 до 1 включительно.",
  "XtraSpreadsheetFunctionDescriptionStringId.PercentRankExc": "Возвращает процентную норму значения в множестве данных (от 0 до 1 не включительно).",
  "XtraSpreadsheetFunctionDescriptionStringId.PercentRankInc": "Возвращает процентную норму значения в множестве данных (от 0 до 1 включительно).",
  "XtraSpreadsheetFunctionDescriptionStringId.PoissonDotDist": "Возвращает распределение Пуассона.",
  "XtraSpreadsheetFunctionDescriptionStringId.QuartileExc": "Возвращает квартиль множества данных по значениям процентиля от 0 до 1 не включительно.",
  "XtraSpreadsheetFunctionDescriptionStringId.QuartileInc": "Возвращает квартиль множества данных по значениям процентиля от 0 до 1 включительно.",
  "XtraSpreadsheetFunctionDescriptionStringId.RankDotAvg": "Возвращает ранг числа в списке чисел: его порядковый номер относительно других чисел в списке; если несколько значений имеет одинаковый ранг, возвращается средний ранг.",
  "XtraSpreadsheetFunctionDescriptionStringId.RankDotEq": "Возвращает ранг числа в списке чисел: его порядковый номер относительно других чисел в списке; если несколько значений имеет одинаковый ранг, возвращается высший ранг из этого набора значений.",
  "XtraSpreadsheetFunctionDescriptionStringId.StDevDotS": "Оценивает стандартное отклонение по выборке. Логические и текстовые значения игнорируются.",
  "XtraSpreadsheetFunctionDescriptionStringId.StDevDotP": "Вычисляет стандартное отклонение по генеральной совокупности. Логические и текстовые значения игнорируются.",
  "XtraSpreadsheetFunctionDescriptionStringId.TDotDist": "Возвращает левостороннее t-распределение Стьюдента.",
  "XtraSpreadsheetFunctionDescriptionStringId.TDotDistDot2t": "Возвращает двустороннее t-распределение Стьюдента.",
  "XtraSpreadsheetFunctionDescriptionStringId.TDotDistDotTt": "Возвращает правостороннее t-распределение Стьюдента.",
  "XtraSpreadsheetFunctionDescriptionStringId.TDotInv": "Возвращает левостороннее обратное распределение Стьюдента.",
  "XtraSpreadsheetFunctionDescriptionStringId.TDotInvDot2t": "Возвращает двустороннее обратное распределение Стьюдента.",
  "XtraSpreadsheetFunctionDescriptionStringId.VarDotS": "Оценивает дисперсию по выборке. Логические и текстовые значения игнорируются.",
  "XtraSpreadsheetFunctionDescriptionStringId.VarDotP": "Вычисляет дисперсию для генеральной совокупности. Логические и текстовые значения игнорируются.",
  "XtraSpreadsheetFunctionDescriptionStringId.WeibullDotDist": "Возвращает распределение Вейбулла.",
  "XtraSpreadsheetFunctionDescriptionStringId.NetworkDaysIntl": "Возвращает количество полных рабочих дней между двумя датами с настраиваемыми параметрами выходных.",
  "XtraSpreadsheetFunctionDescriptionStringId.WorkDayIntl": "Возвращает порядковый номер даты, отстоящей на заданное число рабочих дней вперед или назад от начальной даты с настраиваемыми параметрами выходных дней.",
  "XtraSpreadsheetFunctionDescriptionStringId.IsoCeiling": "Округляет число до ближайшего большего по модулю целого или кратного указанному значению.",
  "XtraSpreadsheetFunctionDescriptionStringId.BetaDist": "Возвращает функцию плотности бета-вероятности.",
  "XtraSpreadsheetFunctionDescriptionStringId.BetaDotInv": "Возвращает обратную функцию к интегральной функции плотности бета-вероятности (БЕТА.РАСП).",
  "XtraSpreadsheetFunctionDescriptionStringId.ChisqDotDist": "Возвращает левостороннюю вероятность распределения хи-квадрат.",
  "XtraSpreadsheetFunctionDescriptionStringId.ChisqDotDistDotRt": "Возвращает правостороннюю вероятность распределения хи-квадрат.",
  "XtraSpreadsheetFunctionDescriptionStringId.ChisqDotInv": "Возвращает значение, обратное к левосторонней вероятности распределения хи-квадрат.",
  "XtraSpreadsheetFunctionDescriptionStringId.ChisqDotInvDotRt": "Возвращает значение, обратное к правосторонней вероятности распределения хи-квадрат.",
  "XtraSpreadsheetFunctionDescriptionStringId.FDotDist": "Возвращает (левостороннее) F-распределение вероятности (степень отклонения) для двух наборов данных.",
  "XtraSpreadsheetFunctionDescriptionStringId.FDotDistDotRt": "Возвращает (правостороннее) F-распределение вероятности (степень отклонения) для двух наборов данных.",
  "XtraSpreadsheetFunctionDescriptionStringId.FDotInv": "Возвращает обратное значение для (левостороннего) F-распределения вероятностей: если p = F.РАСП(x,...), то F.ОБР(p,...) = x.",
  "XtraSpreadsheetFunctionDescriptionStringId.FDotinvDotRt": "Возвращает обратное значение для (правостороннего) F-распределения вероятностей: если p = F.РАСП.ПХ(x,...), то F.ОБР(p,...) = x.",
  "XtraSpreadsheetFunctionDescriptionStringId.HypgeomDotDist": "Возвращает гипергеометрическое распределение числа успехов в выборке.",
  "XtraSpreadsheetFunctionDescriptionStringId.LogNormDist": "Возвращает логнормальное распределение, где ln(x) представляет собой нормальное распределение.",
  "XtraSpreadsheetFunctionDescriptionStringId.LogNormInv": "Возвращает обратное логарифмическое нормальное распределение, где ln(x) представляет собой нормальное распределение.",
  "XtraSpreadsheetFunctionDescriptionStringId.NegbinomDotDist": "Возвращает отрицательное биномиальное распределение - вероятность возникновения определенного числа неудач до указанного количества успехов, с данной вероятностью успеха.",
  "XtraSpreadsheetFunctionDescriptionStringId.NormSDist": "Возвращает стандартное нормальное интегральное распределение.",
  "XtraSpreadsheetFunctionDescriptionStringId.NormSInv": "Возвращает обратное значение стандартного нормального распределения.",
  "XtraSpreadsheetFunctionDescriptionStringId.TDotTest": "Возвращает вероятность, соответствующую t-тесту Стьюдента.",
  "XtraSpreadsheetFunctionDescriptionStringId.ZDotTest": "Возвращает одностороннее P-значение z-теста.",
  "XtraSpreadsheetFunctionDescriptionStringId.ErfPrecise": "Возвращает функцию ошибки.",
  "XtraSpreadsheetFunctionDescriptionStringId.ErfcPrecise": "Возвращает дополнительную функцию ошибки.",
  "XtraSpreadsheetFunctionDescriptionStringId.GammaLnPrecise": "Возвращает натуральный логарифм гамма-функции.",
  "XtraSpreadsheetFunctionDescriptionStringId.CeilingDotPrecise": "Округляет число до ближайшего большего по модулю целого или кратного указанному значению.",
  "XtraSpreadsheetFunctionDescriptionStringId.FloorDotPrecise": "Округляет число до ближайшего меньшего по модулю целого или кратного указанному значению.",
  "XtraSpreadsheetFunctionDescriptionStringId.ACot": "Возвращает арккотангенс числа в радианах от 0 до пи.",
  "XtraSpreadsheetFunctionDescriptionStringId.ACotH": "Возвращает обратный гиперболический котангенс числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.Cot": "Возвращает котангенс угла.",
  "XtraSpreadsheetFunctionDescriptionStringId.CotH": "Возвращает гиперболический котангенс угла.",
  "XtraSpreadsheetFunctionDescriptionStringId.Csc": "Возвращает косеканс угла.",
  "XtraSpreadsheetFunctionDescriptionStringId.CscH": "Возвращает гиперболический косеканс угла.",
  "XtraSpreadsheetFunctionDescriptionStringId.Sec": "Возвращает секанс угла.",
  "XtraSpreadsheetFunctionDescriptionStringId.SecH": "Возвращает гиперболический секанс угла.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImTan": "Возвращает тангенс комплексного числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImCot": "Возвращает котангенс комплексного числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImCsc": "Возвращает косеканс комплексного числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImCscH": "Возвращает гиперболический косеканс комплексного числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImSec": "Возвращает секанс комплексного числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImSecH": "Возвращает гиперболический секанс комплексного числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.BitAnd": "Возвращает побитовое \"и\" двух чисел.",
  "XtraSpreadsheetFunctionDescriptionStringId.BitOr": "Возвращает побитовое \"или\" двух чисел.",
  "XtraSpreadsheetFunctionDescriptionStringId.BitXor": "Возвращает побитовое \"исключающее или\" двух чисел.",
  "XtraSpreadsheetFunctionDescriptionStringId.BitLShift": "Возвращает значение числа, сдвинутое влево на число бит, которое задано параметром \"сдвиг\".",
  "XtraSpreadsheetFunctionDescriptionStringId.BitRShift": "Возвращает значение числа, сдвинутое вправо на число бит, которое задано параметром \"сдвиг\".",
  "XtraSpreadsheetFunctionDescriptionStringId.Permutationa": "Возвращает количество перестановок для заданного числа объектов (с повторами), которые выбираются из общего числа объектов.",
  "XtraSpreadsheetFunctionDescriptionStringId.CombinA": "Возвращает количество комбинаций с повторами для заданного числа элементов.",
  "XtraSpreadsheetFunctionDescriptionStringId.XOr": "Возвращает логическое \"исключающее или\" всех аргументов.",
  "XtraSpreadsheetFunctionDescriptionStringId.PDuration": "Возвращает число периодов, необходимое для достижения указанной стоимости инвестиции.",
  "XtraSpreadsheetFunctionDescriptionStringId.Base": "Преобразует число в текстовое представление в системе счисления с заданным основанием.",
  "XtraSpreadsheetFunctionDescriptionStringId.Decimal": "Преобразует текстовое представление числа в системе счисления с заданным основанием в десятичное значение.",
  "XtraSpreadsheetFunctionDescriptionStringId.Days": "Возвращает количество дней между двумя датами.",
  "XtraSpreadsheetFunctionDescriptionStringId.BinomDistRange": "Возвращает вероятность результата испытания с использованием биномиального распределения.",
  "XtraSpreadsheetFunctionDescriptionStringId.Gamma": "Возвращает значение гамма-функции.",
  "XtraSpreadsheetFunctionDescriptionStringId.SkewP": "Возвращает асимметрию распределения по генеральной совокупности относительно среднего.",
  "XtraSpreadsheetFunctionDescriptionStringId.Phi": "Возвращает значение плотности стандартного нормального распределения.",
  "XtraSpreadsheetFunctionDescriptionStringId.RRI": "Возвращает эквивалентную процентную ставку для заданного роста инвестиции.",
  "XtraSpreadsheetFunctionDescriptionStringId.Unicode": "Возвращает число (код знака), соответствующее первому знаку в тексте.",
  "XtraSpreadsheetFunctionDescriptionStringId.MUnit": "Возвращает единичную матрицу указанного размера.",
  "XtraSpreadsheetFunctionDescriptionStringId.Arabic": "Преобразует римское число в арабское.",
  "XtraSpreadsheetFunctionDescriptionStringId.ISOWeekNum": "Возвращает номер недели в году по стандарту ISO для указанной даты.",
  "XtraSpreadsheetFunctionDescriptionStringId.NumberValue": "Преобразует текст в число без учета языкового стандарта.",
  "XtraSpreadsheetFunctionDescriptionStringId.Sheet": "Возвращает номер указанного листа.",
  "XtraSpreadsheetFunctionDescriptionStringId.Sheets": "Возвращает число листов в ссылке.",
  "XtraSpreadsheetFunctionDescriptionStringId.FormulaText": "Возвращает формулу в виде строки.",
  "XtraSpreadsheetFunctionDescriptionStringId.IsFormula": "Проверяет, содержится ли формула в ячейке, на которую указывает ссылка, и возвращает значение ИСТИНА или ЛОЖЬ.",
  "XtraSpreadsheetFunctionDescriptionStringId.IfNA": "Возвращает указанное значение, если выражение дает результат #Н/Д; в противном случае возвращает результат выражения.",
  "XtraSpreadsheetFunctionDescriptionStringId.CeilingMath": "Округляет число вверх до ближайшего целого или ближайшего кратного указанной точности.",
  "XtraSpreadsheetFunctionDescriptionStringId.FloorMath": "Округляет число вниз до ближайшего целого или ближайшего кратного указанной точности.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImSinH": "Возвращает гиперболический синус комплексного числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.ImCosH": "Возвращает гиперболический косинус комплексного числа.",
  "XtraSpreadsheetFunctionDescriptionStringId.FunctionFilterXML": "Получает определенные данные из кода XML с помощью указаного объекта XPath.",
  "XtraSpreadsheetFunctionDescriptionStringId.FunctionWebService": "Возвращает данные из веб-службы.",
  "XtraSpreadsheetFunctionDescriptionStringId.EncodeURL": "Возвращает строку в кодировке URL.",
  "XtraSpreadsheetFunctionDescriptionStringId.Concat": "Сцепляет список или диапазон строк текста.",
  "XtraSpreadsheetFunctionDescriptionStringId.Ifs": "Проверяет соответствие одному или нескольким условиям и возвращает значение для первого условия со значением ИСТИНА.",
  "XtraSpreadsheetFunctionDescriptionStringId.MaxIfs": "Возвращает максимальное значение из ячеек, заданных данным набором условий или критериев.",
  "XtraSpreadsheetFunctionDescriptionStringId.MinIfs": "Возвращает минимальное значение из ячеек, заданных данным набором условий или критериев.",
  "XtraSpreadsheetFunctionDescriptionStringId.Switch": "Вычисляет выражение на основе списка значений и возвращает результат, соответствующий первому совпавшему значению. Если совпадение отсутствует, возвращается необязательное значение по умолчанию.",
  "XtraSpreadsheetFunctionDescriptionStringId.TextJoin": "Сцепляет список или диапазон строк текста с помощью разделителя.",
  "XtraSpreadsheetFunctionNameStringId.Abs": "ABS",
  "XtraSpreadsheetFunctionNameStringId.Accrint": "НАКОПДОХОД",
  "XtraSpreadsheetFunctionNameStringId.Accrintm": "НАКОПДОХОДПОГАШ",
  "XtraSpreadsheetFunctionNameStringId.ACos": "ACOS",
  "XtraSpreadsheetFunctionNameStringId.ACosH": "ACOSH",
  "XtraSpreadsheetFunctionNameStringId.ACot": "ACOT",
  "XtraSpreadsheetFunctionNameStringId.ACotH": "ACOTH",
  "XtraSpreadsheetFunctionNameStringId.Address": "АДРЕС",
  "XtraSpreadsheetFunctionNameStringId.AddressInfo": "АДРЕС",
  "XtraSpreadsheetFunctionNameStringId.Aggregate": "АГРЕГАТ",
  "XtraSpreadsheetFunctionNameStringId.Amordegrc": "АМОРУМ",
  "XtraSpreadsheetFunctionNameStringId.Amorlinc": "АМОРУВ",
  "XtraSpreadsheetFunctionNameStringId.And": "И",
  "XtraSpreadsheetFunctionNameStringId.Arabic": "АРАБСКОЕ",
  "XtraSpreadsheetFunctionNameStringId.Areas": "ОБЛАСТИ",
  "XtraSpreadsheetFunctionNameStringId.Asc": "ASC",
  "XtraSpreadsheetFunctionNameStringId.ASin": "ASIN",
  "XtraSpreadsheetFunctionNameStringId.ASinH": "ASINH",
  "XtraSpreadsheetFunctionNameStringId.ATan": "ATAN",
  "XtraSpreadsheetFunctionNameStringId.ATan2": "ATAN2",
  "XtraSpreadsheetFunctionNameStringId.ATanH": "ATANH",
  "XtraSpreadsheetFunctionNameStringId.AutoCalcMode": "Автоматически",
  "XtraSpreadsheetFunctionNameStringId.Avedev": "СРОТКЛ",
  "XtraSpreadsheetFunctionNameStringId.Average": "СРЗНАЧ",
  "XtraSpreadsheetFunctionNameStringId.AverageA": "СРЗНАЧА",
  "XtraSpreadsheetFunctionNameStringId.AverageIf": "СРЗНАЧЕСЛИ",
  "XtraSpreadsheetFunctionNameStringId.AverageIfs": "СРЗНАЧЕСЛИМН",
  "XtraSpreadsheetFunctionNameStringId.BahtText": "БАТТЕКСТ",
  "XtraSpreadsheetFunctionNameStringId.Base": "ОСНОВАНИЕ",
  "XtraSpreadsheetFunctionNameStringId.BesselI": "БЕССЕЛЬ.I",
  "XtraSpreadsheetFunctionNameStringId.BesselJ": "БЕССЕЛЬ.J",
  "XtraSpreadsheetFunctionNameStringId.BesselK": "БЕССЕЛЬ.K",
  "XtraSpreadsheetFunctionNameStringId.BesselY": "БЕССЕЛЬ.Y",
  "XtraSpreadsheetFunctionNameStringId.BetaDist": "БЕТА.РАСП",
  "XtraSpreadsheetFunctionNameStringId.BetaDistCompatibility": "БЕТАРАСП",
  "XtraSpreadsheetFunctionNameStringId.BetaDotInv": "БЕТА.ОБР",
  "XtraSpreadsheetFunctionNameStringId.BetaInv": "БЕТАОБР",
  "XtraSpreadsheetFunctionNameStringId.Bin2Dec": "ДВ.В.ДЕС",
  "XtraSpreadsheetFunctionNameStringId.Bin2Hex": "ДВ.В.ШЕСТН",
  "XtraSpreadsheetFunctionNameStringId.Bin2Oct": "ДВ.В.ВОСЬМ",
  "XtraSpreadsheetFunctionNameStringId.BinomDist": "БИНОМРАСП",
  "XtraSpreadsheetFunctionNameStringId.BinomDistRange": "БИНОМ.РАСП.ДИАП",
  "XtraSpreadsheetFunctionNameStringId.BinomDotDist": "БИНОМ.РАСП",
  "XtraSpreadsheetFunctionNameStringId.BinomDotInv": "БИНОМ.ОБР",
  "XtraSpreadsheetFunctionNameStringId.BitAnd": "БИТ.И",
  "XtraSpreadsheetFunctionNameStringId.BitLShift": "БИТ.СДВИГЛ",
  "XtraSpreadsheetFunctionNameStringId.BitOr": "БИТ.ИЛИ",
  "XtraSpreadsheetFunctionNameStringId.BitRShift": "БИТ.СДВИГП",
  "XtraSpreadsheetFunctionNameStringId.BitXor": "БИТ.ИСКЛИЛИ",
  "XtraSpreadsheetFunctionNameStringId.Call": "CALL",
  "XtraSpreadsheetFunctionNameStringId.Ceiling": "ОКРВВЕРХ",
  "XtraSpreadsheetFunctionNameStringId.CeilingDotPrecise": "ОКРВВЕРХ.ТОЧН",
  "XtraSpreadsheetFunctionNameStringId.CeilingMath": "ОКРВВЕРХ.МАТ",
  "XtraSpreadsheetFunctionNameStringId.Cell": "ЯЧЕЙКА",
  "XtraSpreadsheetFunctionNameStringId.Char": "СИМВОЛ",
  "XtraSpreadsheetFunctionNameStringId.ChiDist": "ХИ2РАСП",
  "XtraSpreadsheetFunctionNameStringId.ChiInv": "ХИ2ОБР",
  "XtraSpreadsheetFunctionNameStringId.ChisqDotDist": "ХИ2.РАСП",
  "XtraSpreadsheetFunctionNameStringId.ChisqDotDistDotRt": "ХИ2.РАСП.ПХ",
  "XtraSpreadsheetFunctionNameStringId.ChisqDotInv": "ХИ2.ОБР",
  "XtraSpreadsheetFunctionNameStringId.ChisqDotInvDotRt": "ХИ2.ОБР.ПХ",
  "XtraSpreadsheetFunctionNameStringId.ChisqDotTest": "ХИ2.ТЕСТ",
  "XtraSpreadsheetFunctionNameStringId.ChiTest": "ХИ2ТЕСТ",
  "XtraSpreadsheetFunctionNameStringId.Choose": "ВЫБОР",
  "XtraSpreadsheetFunctionNameStringId.Clean": "ПЕЧСИМВ",
  "XtraSpreadsheetFunctionNameStringId.Code": "КОДСИМВ",
  "XtraSpreadsheetFunctionNameStringId.ColorInfo": "ЦВЕТ",
  "XtraSpreadsheetFunctionNameStringId.Column": "СТОЛБЕЦ",
  "XtraSpreadsheetFunctionNameStringId.ColumnInfo": "СТОЛБЕЦ",
  "XtraSpreadsheetFunctionNameStringId.Columns": "ЧИСЛСТОЛБ",
  "XtraSpreadsheetFunctionNameStringId.Combin": "ЧИСЛКОМБ",
  "XtraSpreadsheetFunctionNameStringId.CombinA": "ЧИСЛКОМБА",
  "XtraSpreadsheetFunctionNameStringId.Complex": "КОМПЛЕКСН",
  "XtraSpreadsheetFunctionNameStringId.Concat": "СЦЕП",
  "XtraSpreadsheetFunctionNameStringId.Concatenate": "СЦЕПИТЬ",
  "XtraSpreadsheetFunctionNameStringId.Confidence": "ДОВЕРИТ",
  "XtraSpreadsheetFunctionNameStringId.ConfidenceDotT": "ДОВЕРИТ.СТЬЮДЕНТ",
  "XtraSpreadsheetFunctionNameStringId.ConfidenceNorm": "ДОВЕРИТ.НОРМ",
  "XtraSpreadsheetFunctionNameStringId.ContentsInfo": "СОДЕРЖИМОЕ",
  "XtraSpreadsheetFunctionNameStringId.Convert": "ПРЕОБР",
  "XtraSpreadsheetFunctionNameStringId.Correl": "КОРРЕЛ",
  "XtraSpreadsheetFunctionNameStringId.Cos": "COS",
  "XtraSpreadsheetFunctionNameStringId.CosH": "COSH",
  "XtraSpreadsheetFunctionNameStringId.Cot": "COT",
  "XtraSpreadsheetFunctionNameStringId.CotH": "COTH",
  "XtraSpreadsheetFunctionNameStringId.Count": "СЧЁТ",
  "XtraSpreadsheetFunctionNameStringId.CountA": "СЧЁТЗ",
  "XtraSpreadsheetFunctionNameStringId.CountBlank": "СЧИТАТЬПУСТОТЫ",
  "XtraSpreadsheetFunctionNameStringId.CountIf": "СЧЁТЕСЛИ",
  "XtraSpreadsheetFunctionNameStringId.CountIfs": "СЧЁТЕСЛИМН",
  "XtraSpreadsheetFunctionNameStringId.CoupDaybs": "ДНЕЙКУПОНДО",
  "XtraSpreadsheetFunctionNameStringId.CoupDays": "ДНЕЙКУПОН",
  "XtraSpreadsheetFunctionNameStringId.CoupDaysnc": "ДНЕЙКУПОНПОСЛЕ",
  "XtraSpreadsheetFunctionNameStringId.Coupncd": "ДАТАКУПОНПОСЛЕ",
  "XtraSpreadsheetFunctionNameStringId.CoupNum": "ЧИСЛКУПОН",
  "XtraSpreadsheetFunctionNameStringId.Couppcd": "ДАТАКУПОНДО",
  "XtraSpreadsheetFunctionNameStringId.Covar": "КОВАР",
  "XtraSpreadsheetFunctionNameStringId.CovarianceP": "КОВАРИАЦИЯ.Г",
  "XtraSpreadsheetFunctionNameStringId.CovarianceS": "КОВАРИАЦИЯ.В",
  "XtraSpreadsheetFunctionNameStringId.CritBinom": "КРИТБИНОМ",
  "XtraSpreadsheetFunctionNameStringId.Csc": "CSC",
  "XtraSpreadsheetFunctionNameStringId.CscH": "CSCH",
  "XtraSpreadsheetFunctionNameStringId.CubeKpiMember": "КУБЭЛЕМЕНТКИП",
  "XtraSpreadsheetFunctionNameStringId.CubeMember": "КУБЭЛЕМЕНТ",
  "XtraSpreadsheetFunctionNameStringId.CubeMemberProperty": "КУБСВОЙСТВОЭЛЕМЕНТА",
  "XtraSpreadsheetFunctionNameStringId.CubeRankedMember": "КУБПОРЭЛЕМЕНТ",
  "XtraSpreadsheetFunctionNameStringId.CubeSet": "КУБМНОЖ",
  "XtraSpreadsheetFunctionNameStringId.CubeSetCount": "КУБЧИСЛОЭЛМНОЖ",
  "XtraSpreadsheetFunctionNameStringId.CubeValue": "КУБЗНАЧЕНИЕ",
  "XtraSpreadsheetFunctionNameStringId.CumIpmt": "ОБЩПЛАТ",
  "XtraSpreadsheetFunctionNameStringId.CumPrinc": "ОБЩДОХОД",
  "XtraSpreadsheetFunctionNameStringId.Date": "ДАТА",
  "XtraSpreadsheetFunctionNameStringId.DateDif": "РАЗНДАТ",
  "XtraSpreadsheetFunctionNameStringId.DateValue": "ДАТАЗНАЧ",
  "XtraSpreadsheetFunctionNameStringId.DAverage": "ДСРЗНАЧ",
  "XtraSpreadsheetFunctionNameStringId.Day": "ДЕНЬ",
  "XtraSpreadsheetFunctionNameStringId.Days": "ДНИ",
  "XtraSpreadsheetFunctionNameStringId.Days360": "ДНЕЙ360",
  "XtraSpreadsheetFunctionNameStringId.Db": "ФУО",
  "XtraSpreadsheetFunctionNameStringId.DCount": "БСЧЁТ",
  "XtraSpreadsheetFunctionNameStringId.DCountA": "БСЧЁТА",
  "XtraSpreadsheetFunctionNameStringId.Ddb": "ДДОБ",
  "XtraSpreadsheetFunctionNameStringId.Dec2Bin": "ДЕС.В.ДВ",
  "XtraSpreadsheetFunctionNameStringId.Dec2Hex": "ДЕС.В.ШЕСТН",
  "XtraSpreadsheetFunctionNameStringId.Dec2Oct": "ДЕС.В.ВОСЬМ",
  "XtraSpreadsheetFunctionNameStringId.Decimal": "ДЕС",
  "XtraSpreadsheetFunctionNameStringId.Degrees": "ГРАДУСЫ",
  "XtraSpreadsheetFunctionNameStringId.Delta": "ДЕЛЬТА",
  "XtraSpreadsheetFunctionNameStringId.DevSq": "КВАДРОТКЛ",
  "XtraSpreadsheetFunctionNameStringId.DGet": "БИЗВЛЕЧЬ",
  "XtraSpreadsheetFunctionNameStringId.DirectoryInfo": "КАТАЛОГ",
  "XtraSpreadsheetFunctionNameStringId.Disc": "СКИДКА",
  "XtraSpreadsheetFunctionNameStringId.DMax": "ДМАКС",
  "XtraSpreadsheetFunctionNameStringId.DMin": "ДМИН",
  "XtraSpreadsheetFunctionNameStringId.Dollar": "РУБЛЬ",
  "XtraSpreadsheetFunctionNameStringId.DollarDe": "РУБЛЬ.ДЕС",
  "XtraSpreadsheetFunctionNameStringId.DollarFr": "РУБЛЬ.ДРОБЬ",
  "XtraSpreadsheetFunctionNameStringId.DProduct": "БДПРОИЗВЕД",
  "XtraSpreadsheetFunctionNameStringId.DStDev": "ДСТАНДОТКЛ",
  "XtraSpreadsheetFunctionNameStringId.DStDevP": "ДСТАНДОТКЛП",
  "XtraSpreadsheetFunctionNameStringId.DSum": "БДСУММ",
  "XtraSpreadsheetFunctionNameStringId.Duration": "ДЛИТ",
  "XtraSpreadsheetFunctionNameStringId.DVar": "БДДИСП",
  "XtraSpreadsheetFunctionNameStringId.DVarP": "БДДИСПП",
  "XtraSpreadsheetFunctionNameStringId.EDate": "ДАТАМЕС",
  "XtraSpreadsheetFunctionNameStringId.Effect": "ЭФФЕКТ",
  "XtraSpreadsheetFunctionNameStringId.EncodeURL": "КОДИР.URL",
  "XtraSpreadsheetFunctionNameStringId.EOMonth": "КОНМЕСЯЦА",
  "XtraSpreadsheetFunctionNameStringId.Erf": "ФОШ",
  "XtraSpreadsheetFunctionNameStringId.Erfc": "ДФОШ",
  "XtraSpreadsheetFunctionNameStringId.ErfcPrecise": "ДФОШ.ТОЧН",
  "XtraSpreadsheetFunctionNameStringId.ErfPrecise": "ФОШ.ТОЧН",
  "XtraSpreadsheetFunctionNameStringId.ErrorType": "ТИП.ОШИБКИ",
  "XtraSpreadsheetFunctionNameStringId.Even": "ЧЁТН",
  "XtraSpreadsheetFunctionNameStringId.Exact": "СОВПАД",
  "XtraSpreadsheetFunctionNameStringId.Exp": "EXP",
  "XtraSpreadsheetFunctionNameStringId.ExponDist": "ЭКСПРАСП",
  "XtraSpreadsheetFunctionNameStringId.ExponDotDist": "ЭКСП.РАСП",
  "XtraSpreadsheetFunctionNameStringId.Fact": "ФАКТР",
  "XtraSpreadsheetFunctionNameStringId.FactDouble": "ДВФАКТР",
  "XtraSpreadsheetFunctionNameStringId.False": "ЛОЖЬ",
  "XtraSpreadsheetFunctionNameStringId.FDist": "FРАСП",
  "XtraSpreadsheetFunctionNameStringId.FDotDist": "F.РАСП",
  "XtraSpreadsheetFunctionNameStringId.FDotDistDotRt": "F.РАСП.ПХ",
  "XtraSpreadsheetFunctionNameStringId.FDotInv": "F.ОБР",
  "XtraSpreadsheetFunctionNameStringId.FDotinvDotRt": "F.ОБР.ПХ",
  "XtraSpreadsheetFunctionNameStringId.FDotTest": "F.ТЕСТ",
  "XtraSpreadsheetFunctionNameStringId.Field": "ПОЛЕ",
  "XtraSpreadsheetFunctionNameStringId.FieldPicture": "ПОЛЕИЗОБР",
  "XtraSpreadsheetFunctionNameStringId.FilenameInfo": "ИМЯФАЙЛА",
  "XtraSpreadsheetFunctionNameStringId.Find": "НАЙТИ",
  "XtraSpreadsheetFunctionNameStringId.FindB": "НАЙТИБ",
  "XtraSpreadsheetFunctionNameStringId.FInv": "FРАСПОБР",
  "XtraSpreadsheetFunctionNameStringId.Fisher": "ФИШЕР",
  "XtraSpreadsheetFunctionNameStringId.FisherInv": "ФИШЕРОБР",
  "XtraSpreadsheetFunctionNameStringId.Fixed": "ФИКСИРОВАННЫЙ",
  "XtraSpreadsheetFunctionNameStringId.Floor": "ОКРВНИЗ",
  "XtraSpreadsheetFunctionNameStringId.FloorDotPrecise": "ОКРВНИЗ.ТОЧН",
  "XtraSpreadsheetFunctionNameStringId.FloorMath": "ОКРВНИЗ.МАТ",
  "XtraSpreadsheetFunctionNameStringId.Forecast": "ПРЕДСКАЗ",
  "XtraSpreadsheetFunctionNameStringId.FormatInfo": "ФОРМАТ",
  "XtraSpreadsheetFunctionNameStringId.FormulaText": "Ф.ТЕКСТ",
  "XtraSpreadsheetFunctionNameStringId.Frequency": "ЧАСТОТА",
  "XtraSpreadsheetFunctionNameStringId.FTest": "ФТЕСТ",
  "XtraSpreadsheetFunctionNameStringId.FunctionFilterXML": "ФИЛЬТР.XML",
  "XtraSpreadsheetFunctionNameStringId.FunctionWebService": "ВЕБСЛУЖБА",
  "XtraSpreadsheetFunctionNameStringId.Fv": "БС",
  "XtraSpreadsheetFunctionNameStringId.FvSchedule": "БЗРАСПИС",
  "XtraSpreadsheetFunctionNameStringId.Gamma": "ГАММА",
  "XtraSpreadsheetFunctionNameStringId.GammaDist": "ГАММАРАСП",
  "XtraSpreadsheetFunctionNameStringId.GammaDotDist": "ГАММА.РАСП",
  "XtraSpreadsheetFunctionNameStringId.GammaDotInv": "ГАММА.ОБР",
  "XtraSpreadsheetFunctionNameStringId.GammaInv": "ГАММАОБР",
  "XtraSpreadsheetFunctionNameStringId.GammaLn": "ГАММАНЛОГ",
  "XtraSpreadsheetFunctionNameStringId.GammaLnPrecise": "ГАММАНЛОГ.ТОЧН",
  "XtraSpreadsheetFunctionNameStringId.Gauss": "ГАУСС",
  "XtraSpreadsheetFunctionNameStringId.Gcd": "НОД",
  "XtraSpreadsheetFunctionNameStringId.Geomean": "СРГЕОМ",
  "XtraSpreadsheetFunctionNameStringId.Gestep": "ПОРОГ",
  "XtraSpreadsheetFunctionNameStringId.GetPivotData": "ПОЛУЧИТЬ.ДАННЫЕ.СВОДНОЙ.ТАБЛИЦЫ",
  "XtraSpreadsheetFunctionNameStringId.Growth": "РОСТ",
  "XtraSpreadsheetFunctionNameStringId.HarMean": "СРГАРМ",
  "XtraSpreadsheetFunctionNameStringId.Hex2Bin": "ШЕСТН.В.ДВ",
  "XtraSpreadsheetFunctionNameStringId.Hex2Dec": "ШЕСТН.В.ДЕС",
  "XtraSpreadsheetFunctionNameStringId.Hex2Oct": "ШЕСТН.В.ВОСЬМ",
  "XtraSpreadsheetFunctionNameStringId.HLookup": "ГПР",
  "XtraSpreadsheetFunctionNameStringId.Hour": "ЧАС",
  "XtraSpreadsheetFunctionNameStringId.Hyperlink": "ГИПЕРССЫЛКА",
  "XtraSpreadsheetFunctionNameStringId.HypGeomDist": "ГИПЕРГЕОМЕТ",
  "XtraSpreadsheetFunctionNameStringId.HypgeomDotDist": "ГИПЕРГЕОМ.РАСП",
  "XtraSpreadsheetFunctionNameStringId.If": "ЕСЛИ",
  "XtraSpreadsheetFunctionNameStringId.IfError": "ЕСЛИОШИБКА",
  "XtraSpreadsheetFunctionNameStringId.IfNA": "ЕСНД",
  "XtraSpreadsheetFunctionNameStringId.Ifs": "УСЛОВИЯ",
  "XtraSpreadsheetFunctionNameStringId.ImAbs": "МНИМ.ABS",
  "XtraSpreadsheetFunctionNameStringId.Imaginary": "МНИМ.ЧАСТЬ",
  "XtraSpreadsheetFunctionNameStringId.ImArgument": "МНИМ.АРГУМЕНТ",
  "XtraSpreadsheetFunctionNameStringId.ImConjugate": "МНИМ.СОПРЯЖ",
  "XtraSpreadsheetFunctionNameStringId.ImCos": "МНИМ.COS",
  "XtraSpreadsheetFunctionNameStringId.ImCosH": "МНИМ.COSH",
  "XtraSpreadsheetFunctionNameStringId.ImCot": "МНИМ.COT",
  "XtraSpreadsheetFunctionNameStringId.ImCsc": "МНИМ.CSC",
  "XtraSpreadsheetFunctionNameStringId.ImCscH": "МНИМ.CSCH",
  "XtraSpreadsheetFunctionNameStringId.ImDiv": "МНИМ.ДЕЛ",
  "XtraSpreadsheetFunctionNameStringId.ImExp": "МНИМ.EXP",
  "XtraSpreadsheetFunctionNameStringId.ImLn": "МНИМ.LN",
  "XtraSpreadsheetFunctionNameStringId.ImLog10": "МНИМ.LOG10",
  "XtraSpreadsheetFunctionNameStringId.ImLog2": "МНИМ.LOG2",
  "XtraSpreadsheetFunctionNameStringId.ImPower": "МНИМ.СТЕПЕНЬ",
  "XtraSpreadsheetFunctionNameStringId.ImProduct": "МНИМ.ПРОИЗВЕД",
  "XtraSpreadsheetFunctionNameStringId.ImReal": "МНИМ.ВЕЩ",
  "XtraSpreadsheetFunctionNameStringId.ImSec": "МНИМ.SEC",
  "XtraSpreadsheetFunctionNameStringId.ImSecH": "МНИМ.SECH",
  "XtraSpreadsheetFunctionNameStringId.ImSin": "МНИМ.SIN",
  "XtraSpreadsheetFunctionNameStringId.ImSinH": "МНИМ.SINH",
  "XtraSpreadsheetFunctionNameStringId.ImSqrt": "МНИМ.КОРЕНЬ",
  "XtraSpreadsheetFunctionNameStringId.ImSub": "МНИМ.РАЗН",
  "XtraSpreadsheetFunctionNameStringId.ImSum": "МНИМ.СУММ",
  "XtraSpreadsheetFunctionNameStringId.ImTan": "МНИМ.TAN",
  "XtraSpreadsheetFunctionNameStringId.Index": "ИНДЕКС",
  "XtraSpreadsheetFunctionNameStringId.Indirect": "ДВССЫЛ",
  "XtraSpreadsheetFunctionNameStringId.Info": "ИНФОРМ",
  "XtraSpreadsheetFunctionNameStringId.Int": "ЦЕЛОЕ",
  "XtraSpreadsheetFunctionNameStringId.Intercept": "ОТРЕЗОК",
  "XtraSpreadsheetFunctionNameStringId.Intrate": "ИНОРМА",
  "XtraSpreadsheetFunctionNameStringId.Ipmt": "ПРПЛТ",
  "XtraSpreadsheetFunctionNameStringId.Irr": "ВСД",
  "XtraSpreadsheetFunctionNameStringId.IsBlank": "ЕПУСТО",
  "XtraSpreadsheetFunctionNameStringId.IsErr": "ЕОШ",
  "XtraSpreadsheetFunctionNameStringId.IsError": "ЕОШИБКА",
  "XtraSpreadsheetFunctionNameStringId.IsEven": "ЕЧЁТН",
  "XtraSpreadsheetFunctionNameStringId.IsFormula": "ЕФОРМУЛА",
  "XtraSpreadsheetFunctionNameStringId.IsLogical": "ЕЛОГИЧ",
  "XtraSpreadsheetFunctionNameStringId.IsNA": "ЕНД",
  "XtraSpreadsheetFunctionNameStringId.IsNonText": "ЕНЕТЕКСТ",
  "XtraSpreadsheetFunctionNameStringId.IsNumber": "ЕЧИСЛО",
  "XtraSpreadsheetFunctionNameStringId.IsoCeiling": "ISO.ОКРВВЕРХ",
  "XtraSpreadsheetFunctionNameStringId.IsOdd": "ЕНЕЧЁТ",
  "XtraSpreadsheetFunctionNameStringId.ISOWeekNum": "НОМНЕДЕЛИ.ISO",
  "XtraSpreadsheetFunctionNameStringId.IsPmt": "ПРОЦПЛАТ",
  "XtraSpreadsheetFunctionNameStringId.IsRef": "ЕССЫЛКА",
  "XtraSpreadsheetFunctionNameStringId.IsText": "ЕТЕКСТ",
  "XtraSpreadsheetFunctionNameStringId.Kurt": "ЭКСЦЕСС",
  "XtraSpreadsheetFunctionNameStringId.Large": "НАИБОЛЬШИЙ",
  "XtraSpreadsheetFunctionNameStringId.Lcm": "НОК",
  "XtraSpreadsheetFunctionNameStringId.Left": "ЛЕВСИМВ",
  "XtraSpreadsheetFunctionNameStringId.LeftB": "ЛЕВБ",
  "XtraSpreadsheetFunctionNameStringId.Len": "ДЛСТР",
  "XtraSpreadsheetFunctionNameStringId.LenB": "ДЛИНБ",
  "XtraSpreadsheetFunctionNameStringId.Linest": "ЛИНЕЙН",
  "XtraSpreadsheetFunctionNameStringId.Ln": "LN",
  "XtraSpreadsheetFunctionNameStringId.Log": "LOG",
  "XtraSpreadsheetFunctionNameStringId.Log10": "LOG10",
  "XtraSpreadsheetFunctionNameStringId.Logest": "ЛГРФПРИБЛ",
  "XtraSpreadsheetFunctionNameStringId.LogInvCompatibility": "ЛОГНОРМОБР",
  "XtraSpreadsheetFunctionNameStringId.LogNormDist": "ЛОГНОРМ.РАСП",
  "XtraSpreadsheetFunctionNameStringId.LogNormDistCompatibility": "ЛОГНОРМРАСП",
  "XtraSpreadsheetFunctionNameStringId.LogNormInv": "ЛОГНОРМ.ОБР",
  "XtraSpreadsheetFunctionNameStringId.Lookup": "ПРОСМОТР",
  "XtraSpreadsheetFunctionNameStringId.Lower": "СТРОЧН",
  "XtraSpreadsheetFunctionNameStringId.ManualCalcMode": "Вручную",
  "XtraSpreadsheetFunctionNameStringId.Match": "ПОИСКПОЗ",
  "XtraSpreadsheetFunctionNameStringId.Max": "МАКС",
  "XtraSpreadsheetFunctionNameStringId.MaxA": "МАКСА",
  "XtraSpreadsheetFunctionNameStringId.MaxIfs": "МАКСЕСЛИ",
  "XtraSpreadsheetFunctionNameStringId.MDeterm": "МОПРЕД",
  "XtraSpreadsheetFunctionNameStringId.MDuration": "МДЛИТ",
  "XtraSpreadsheetFunctionNameStringId.Median": "МЕДИАНА",
  "XtraSpreadsheetFunctionNameStringId.MemAvailInfo": "ДОСТУПНАЯПАМЯТЬ",
  "XtraSpreadsheetFunctionNameStringId.MemUsedInfo": "ИСПОЛЬЗУЕМАЯПАМЯТЬ",
  "XtraSpreadsheetFunctionNameStringId.Mid": "ПСТР",
  "XtraSpreadsheetFunctionNameStringId.MidB": "ПСТРБ",
  "XtraSpreadsheetFunctionNameStringId.Min": "МИН",
  "XtraSpreadsheetFunctionNameStringId.MinA": "МИНА",
  "XtraSpreadsheetFunctionNameStringId.MinIfs": "МИНЕСЛИ",
  "XtraSpreadsheetFunctionNameStringId.Minute": "МИНУТЫ",
  "XtraSpreadsheetFunctionNameStringId.MInverse": "МОБР",
  "XtraSpreadsheetFunctionNameStringId.Mirr": "МВСД",
  "XtraSpreadsheetFunctionNameStringId.MMult": "МУМНОЖ",
  "XtraSpreadsheetFunctionNameStringId.Mod": "ОСТАТ",
  "XtraSpreadsheetFunctionNameStringId.Mode": "МОДА",
  "XtraSpreadsheetFunctionNameStringId.ModeMult": "МОДА.НСК",
  "XtraSpreadsheetFunctionNameStringId.ModeSngl": "МОДА.ОДН",
  "XtraSpreadsheetFunctionNameStringId.Month": "МЕСЯЦ",
  "XtraSpreadsheetFunctionNameStringId.MRound": "ОКРУГЛТ",
  "XtraSpreadsheetFunctionNameStringId.Multinomial": "МУЛЬТИНОМ",
  "XtraSpreadsheetFunctionNameStringId.MUnit": "МЕДИН",
  "XtraSpreadsheetFunctionNameStringId.N": "Ч",
  "XtraSpreadsheetFunctionNameStringId.NA": "НД",
  "XtraSpreadsheetFunctionNameStringId.NegBinomDist": "ОТРБИНОМРАСП",
  "XtraSpreadsheetFunctionNameStringId.NegbinomDotDist": "ОТРБИНОМ.РАСП",
  "XtraSpreadsheetFunctionNameStringId.NetworkDays": "ЧИСТРАБДНИ",
  "XtraSpreadsheetFunctionNameStringId.NetworkDaysIntl": "ЧИСТРАБДНИ.МЕЖД",
  "XtraSpreadsheetFunctionNameStringId.Nominal": "НОМИНАЛ",
  "XtraSpreadsheetFunctionNameStringId.NormDist": "НОРМ.РАСП",
  "XtraSpreadsheetFunctionNameStringId.NormDistCompatibility": "НОРМРАСП",
  "XtraSpreadsheetFunctionNameStringId.NormInv": "НОРМ.ОБР",
  "XtraSpreadsheetFunctionNameStringId.NormInvCompatibility": "НОРМОБР",
  "XtraSpreadsheetFunctionNameStringId.NormSDist": "НОРМ.СТ.РАСП",
  "XtraSpreadsheetFunctionNameStringId.NormSDistCompatibility": "НОРМСТРАСП",
  "XtraSpreadsheetFunctionNameStringId.NormSInv": "НОРМ.СТ.ОБР",
  "XtraSpreadsheetFunctionNameStringId.NormSInvCompatibility": "НОРМСТОБР",
  "XtraSpreadsheetFunctionNameStringId.Not": "НЕ",
  "XtraSpreadsheetFunctionNameStringId.Now": "ТДАТА",
  "XtraSpreadsheetFunctionNameStringId.NPer": "КПЕР",
  "XtraSpreadsheetFunctionNameStringId.Npv": "ЧПС",
  "XtraSpreadsheetFunctionNameStringId.NumberValue": "ЧЗНАЧ",
  "XtraSpreadsheetFunctionNameStringId.NumFileInfo": "ЧИСЛОФАЙЛОВ",
  "XtraSpreadsheetFunctionNameStringId.Oct2Bin": "ВОСЬМ.В.ДВ",
  "XtraSpreadsheetFunctionNameStringId.Oct2Dec": "ВОСЬМ.В.ДЕС",
  "XtraSpreadsheetFunctionNameStringId.Oct2Hex": "ВОСЬМ.В.ШЕСТН",
  "XtraSpreadsheetFunctionNameStringId.Odd": "НЕЧЁТ",
  "XtraSpreadsheetFunctionNameStringId.OddFPrice": "ЦЕНАПЕРВНЕРЕГ",
  "XtraSpreadsheetFunctionNameStringId.OddFYield": "ДОХОДПЕРВНЕРЕГ",
  "XtraSpreadsheetFunctionNameStringId.OddLPrice": "ЦЕНАПОСЛНЕРЕГ",
  "XtraSpreadsheetFunctionNameStringId.OddLYield": "ДОХОДПОСЛНЕРЕГ",
  "XtraSpreadsheetFunctionNameStringId.Offset": "СМЕЩ",
  "XtraSpreadsheetFunctionNameStringId.Or": "ИЛИ",
  "XtraSpreadsheetFunctionNameStringId.OriginInfo": "ИСТОЧНИК",
  "XtraSpreadsheetFunctionNameStringId.OsVersionInfo": "ВЕРСИЯОС",
  "XtraSpreadsheetFunctionNameStringId.Parameter": "PARAMETER",
  "XtraSpreadsheetFunctionNameStringId.ParenthesesInfo": "СКОБКИ",
  "XtraSpreadsheetFunctionNameStringId.PDuration": "ПДЛИТ",
  "XtraSpreadsheetFunctionNameStringId.Pearson": "PEARSON",
  "XtraSpreadsheetFunctionNameStringId.Percentile": "ПЕРСЕНТИЛЬ",
  "XtraSpreadsheetFunctionNameStringId.PercentileExc": "ПРОЦЕНТИЛЬ.ИСКЛ",
  "XtraSpreadsheetFunctionNameStringId.PercentileInc": "ПРОЦЕНТИЛЬ.ВКЛ",
  "XtraSpreadsheetFunctionNameStringId.PercentRank": "ПРОЦЕНТРАНГ",
  "XtraSpreadsheetFunctionNameStringId.PercentRankExc": "ПРОЦЕНТРАНГ.ИСКЛ",
  "XtraSpreadsheetFunctionNameStringId.PercentRankInc": "ПРОЦЕНТРАНГ.ВКЛ",
  "XtraSpreadsheetFunctionNameStringId.Permut": "ПЕРЕСТ",
  "XtraSpreadsheetFunctionNameStringId.Permutationa": "ПЕРЕСТА",
  "XtraSpreadsheetFunctionNameStringId.Phi": "ФИ",
  "XtraSpreadsheetFunctionNameStringId.Phonetic": "PHONETIC",
  "XtraSpreadsheetFunctionNameStringId.Pi": "ПИ",
  "XtraSpreadsheetFunctionNameStringId.Pmt": "ПЛТ",
  "XtraSpreadsheetFunctionNameStringId.Poisson": "ПУАССОН",
  "XtraSpreadsheetFunctionNameStringId.PoissonDotDist": "ПУАССОН.РАСП",
  "XtraSpreadsheetFunctionNameStringId.Power": "СТЕПЕНЬ",
  "XtraSpreadsheetFunctionNameStringId.Ppmt": "ОСПЛТ",
  "XtraSpreadsheetFunctionNameStringId.PrefixInfo": "ПРЕФИКС",
  "XtraSpreadsheetFunctionNameStringId.Price": "ЦЕНА",
  "XtraSpreadsheetFunctionNameStringId.PriceDisc": "ЦЕНАСКИДКА",
  "XtraSpreadsheetFunctionNameStringId.PriceMat": "ЦЕНАПОГАШ",
  "XtraSpreadsheetFunctionNameStringId.Prob": "ВЕРОЯТНОСТЬ",
  "XtraSpreadsheetFunctionNameStringId.Product": "ПРОИЗВЕД",
  "XtraSpreadsheetFunctionNameStringId.Proper": "ПРОПНАЧ",
  "XtraSpreadsheetFunctionNameStringId.ProtectInfo": "ЗАЩИТА",
  "XtraSpreadsheetFunctionNameStringId.Pv": "ПС",
  "XtraSpreadsheetFunctionNameStringId.Quartile": "КВАРТИЛЬ",
  "XtraSpreadsheetFunctionNameStringId.QuartileExc": "КВАРТИЛЬ.ИСКЛ",
  "XtraSpreadsheetFunctionNameStringId.QuartileInc": "КВАРТИЛЬ.ВКЛ",
  "XtraSpreadsheetFunctionNameStringId.Quotient": "ЧАСТНОЕ",
  "XtraSpreadsheetFunctionNameStringId.Radians": "РАДИАНЫ",
  "XtraSpreadsheetFunctionNameStringId.Rand": "СЛЧИС",
  "XtraSpreadsheetFunctionNameStringId.RandBetween": "СЛУЧМЕЖДУ",
  "XtraSpreadsheetFunctionNameStringId.Range": "ДИАПАЗОН",
  "XtraSpreadsheetFunctionNameStringId.Rank": "РАНГ",
  "XtraSpreadsheetFunctionNameStringId.RankDotAvg": "РАНГ.СР",
  "XtraSpreadsheetFunctionNameStringId.RankDotEq": "РАНГ.РВ",
  "XtraSpreadsheetFunctionNameStringId.Rate": "СТАВКА",
  "XtraSpreadsheetFunctionNameStringId.RecalcInfo": "ПЕРЕВЫЧИСЛИТЬ",
  "XtraSpreadsheetFunctionNameStringId.Received": "ПОЛУЧЕНО",
  "XtraSpreadsheetFunctionNameStringId.RegisterId": "REGISTER.ID",
  "XtraSpreadsheetFunctionNameStringId.ReleaseInfo": "ВЕРСИЯ",
  "XtraSpreadsheetFunctionNameStringId.Replace": "ЗАМЕНИТЬ",
  "XtraSpreadsheetFunctionNameStringId.ReplaceB": "ЗАМЕНИТЬБ",
  "XtraSpreadsheetFunctionNameStringId.Rept": "ПОВТОР",
  "XtraSpreadsheetFunctionNameStringId.Right": "ПРАВСИМВ",
  "XtraSpreadsheetFunctionNameStringId.RightB": "ПРАВБ",
  "XtraSpreadsheetFunctionNameStringId.Roman": "РИМСКОЕ",
  "XtraSpreadsheetFunctionNameStringId.Round": "ОКРУГЛ",
  "XtraSpreadsheetFunctionNameStringId.RoundDown": "ОКРУГЛВНИЗ",
  "XtraSpreadsheetFunctionNameStringId.RoundUp": "ОКРУГЛВВЕРХ",
  "XtraSpreadsheetFunctionNameStringId.Row": "СТРОКА",
  "XtraSpreadsheetFunctionNameStringId.RowInfo": "СТРОКА",
  "XtraSpreadsheetFunctionNameStringId.Rows": "ЧСТРОК",
  "XtraSpreadsheetFunctionNameStringId.RRI": "ЭКВ.СТАВКА",
  "XtraSpreadsheetFunctionNameStringId.Rsq": "КВПИРСОН",
  "XtraSpreadsheetFunctionNameStringId.Rtd": "ДРВ",
  "XtraSpreadsheetFunctionNameStringId.Search": "ПОИСК",
  "XtraSpreadsheetFunctionNameStringId.SearchB": "ПОИСКБ",
  "XtraSpreadsheetFunctionNameStringId.Sec": "SEC",
  "XtraSpreadsheetFunctionNameStringId.SecH": "SECH",
  "XtraSpreadsheetFunctionNameStringId.Second": "СЕКУНДЫ",
  "XtraSpreadsheetFunctionNameStringId.Seriessum": "РЯД.СУММ",
  "XtraSpreadsheetFunctionNameStringId.Sheet": "ЛИСТ",
  "XtraSpreadsheetFunctionNameStringId.Sheets": "ЛИСТЫ",
  "XtraSpreadsheetFunctionNameStringId.Sign": "ЗНАК",
  "XtraSpreadsheetFunctionNameStringId.Sin": "SIN",
  "XtraSpreadsheetFunctionNameStringId.SinH": "SINH",
  "XtraSpreadsheetFunctionNameStringId.Skew": "СКОС",
  "XtraSpreadsheetFunctionNameStringId.SkewP": "СКОС.Г",
  "XtraSpreadsheetFunctionNameStringId.Sln": "АПЛ",
  "XtraSpreadsheetFunctionNameStringId.Slope": "НАКЛОН",
  "XtraSpreadsheetFunctionNameStringId.Small": "НАИМЕНЬШИЙ",
  "XtraSpreadsheetFunctionNameStringId.Sqrt": "КОРЕНЬ",
  "XtraSpreadsheetFunctionNameStringId.SqrtPi": "КОРЕНЬПИ",
  "XtraSpreadsheetFunctionNameStringId.Standardize": "НОРМАЛИЗАЦИЯ",
  "XtraSpreadsheetFunctionNameStringId.StDev": "СТАНДОТКЛОН",
  "XtraSpreadsheetFunctionNameStringId.StDevA": "СТАНДОТКЛОНА",
  "XtraSpreadsheetFunctionNameStringId.StDevDotP": "СТАНДОТКЛОН.Г",
  "XtraSpreadsheetFunctionNameStringId.StDevDotS": "СТАНДОТКЛОН.В",
  "XtraSpreadsheetFunctionNameStringId.StDevP": "СТАНДОТКЛОНП",
  "XtraSpreadsheetFunctionNameStringId.StDevPA": "СТАНДОТКЛОНПА",
  "XtraSpreadsheetFunctionNameStringId.StEYX": "СТОШYX",
  "XtraSpreadsheetFunctionNameStringId.Substitute": "ПОДСТАВИТЬ",
  "XtraSpreadsheetFunctionNameStringId.Subtotal": "ПРОМЕЖУТОЧНЫЕ.ИТОГИ",
  "XtraSpreadsheetFunctionNameStringId.Sum": "СУММ",
  "XtraSpreadsheetFunctionNameStringId.SumIf": "СУММЕСЛИ",
  "XtraSpreadsheetFunctionNameStringId.SumIfs": "СУММЕСЛИМН",
  "XtraSpreadsheetFunctionNameStringId.SumProduct": "СУММПРОИЗВ",
  "XtraSpreadsheetFunctionNameStringId.SumSq": "СУММКВ",
  "XtraSpreadsheetFunctionNameStringId.SumX2MY2": "СУММРАЗНКВ",
  "XtraSpreadsheetFunctionNameStringId.SumX2PY2": "СУММСУММКВ",
  "XtraSpreadsheetFunctionNameStringId.SumXMY2": "СУММКВРАЗН",
  "XtraSpreadsheetFunctionNameStringId.Switch": "ПЕРЕКЛЮЧ",
  "XtraSpreadsheetFunctionNameStringId.Syd": "АСЧ",
  "XtraSpreadsheetFunctionNameStringId.SystemInfo": "СИСТЕМА",
  "XtraSpreadsheetFunctionNameStringId.T": "Т",
  "XtraSpreadsheetFunctionNameStringId.Tan": "TAN",
  "XtraSpreadsheetFunctionNameStringId.TanH": "TANH",
  "XtraSpreadsheetFunctionNameStringId.TbillEq": "РАВНОКЧЕК",
  "XtraSpreadsheetFunctionNameStringId.TbillPrice": "ЦЕНАКЧЕК",
  "XtraSpreadsheetFunctionNameStringId.TbillYield": "ДОХОДКЧЕК",
  "XtraSpreadsheetFunctionNameStringId.TDist": "СТЬЮДРАСП",
  "XtraSpreadsheetFunctionNameStringId.TDotDist": "СТЬЮДЕНТ.РАСП",
  "XtraSpreadsheetFunctionNameStringId.TDotDistDot2t": "СТЬЮДЕНТ.РАСП.2Х",
  "XtraSpreadsheetFunctionNameStringId.TDotDistDotTt": "СТЬЮДЕНТ.РАСП.ПХ",
  "XtraSpreadsheetFunctionNameStringId.TDotInv": "СТЬЮДЕНТ.ОБР",
  "XtraSpreadsheetFunctionNameStringId.TDotInvDot2t": "СТЬЮДЕНТ.ОБР.2Х",
  "XtraSpreadsheetFunctionNameStringId.TDotTest": "СТЬЮДЕНТ.ТЕСТ",
  "XtraSpreadsheetFunctionNameStringId.Text": "ТЕКСТ",
  "XtraSpreadsheetFunctionNameStringId.TextJoin": "ОБЪЕДИНИТЬ",
  "XtraSpreadsheetFunctionNameStringId.Time": "ВРЕМЯ",
  "XtraSpreadsheetFunctionNameStringId.TimeValue": "ВРЕМЗНАЧ",
  "XtraSpreadsheetFunctionNameStringId.Tinv": "СТЬЮДРАСПОБР",
  "XtraSpreadsheetFunctionNameStringId.Today": "СЕГОДНЯ",
  "XtraSpreadsheetFunctionNameStringId.TotMemInfo": "ПАМЯТЬВСЕГО",
  "XtraSpreadsheetFunctionNameStringId.Transpose": "ТРАНСП",
  "XtraSpreadsheetFunctionNameStringId.Trend": "ТЕНДЕНЦИЯ",
  "XtraSpreadsheetFunctionNameStringId.Trim": "СЖПРОБЕЛЫ",
  "XtraSpreadsheetFunctionNameStringId.Trimmean": "УРЕЗСРЕДНЕЕ",
  "XtraSpreadsheetFunctionNameStringId.True": "ИСТИНА",
  "XtraSpreadsheetFunctionNameStringId.Trunc": "ОТБР",
  "XtraSpreadsheetFunctionNameStringId.TTest": "ТТЕСТ",
  "XtraSpreadsheetFunctionNameStringId.Type": "ТИП",
  "XtraSpreadsheetFunctionNameStringId.TypeInfo": "ТИП",
  "XtraSpreadsheetFunctionNameStringId.Unichar": "UNICHAR",
  "XtraSpreadsheetFunctionNameStringId.Unicode": "UNICODE",
  "XtraSpreadsheetFunctionNameStringId.Upper": "ПРОПИСН",
  "XtraSpreadsheetFunctionNameStringId.Value": "ЗНАЧЕН",
  "XtraSpreadsheetFunctionNameStringId.Var": "ДИСП",
  "XtraSpreadsheetFunctionNameStringId.VarA": "ДИСПА",
  "XtraSpreadsheetFunctionNameStringId.VarDotP": "ДИСП.Г",
  "XtraSpreadsheetFunctionNameStringId.VarDotS": "ДИСП.В",
  "XtraSpreadsheetFunctionNameStringId.VarP": "ДИСПР",
  "XtraSpreadsheetFunctionNameStringId.VarPA": "ДИСПРА",
  "XtraSpreadsheetFunctionNameStringId.Vdb": "ПУО",
  "XtraSpreadsheetFunctionNameStringId.VLookup": "ВПР",
  "XtraSpreadsheetFunctionNameStringId.WeekDay": "ДЕНЬНЕД",
  "XtraSpreadsheetFunctionNameStringId.WeekNum": "НОМНЕДЕЛИ",
  "XtraSpreadsheetFunctionNameStringId.Weibull": "ВЕЙБУЛЛ",
  "XtraSpreadsheetFunctionNameStringId.WeibullDotDist": "ВЕЙБУЛЛ.РАСП",
  "XtraSpreadsheetFunctionNameStringId.WidthInfo": "ШИРИНА",
  "XtraSpreadsheetFunctionNameStringId.WorkDay": "РАБДЕНЬ",
  "XtraSpreadsheetFunctionNameStringId.WorkDayIntl": "РАБДЕНЬ.МЕЖД",
  "XtraSpreadsheetFunctionNameStringId.Xirr": "ЧИСТВНДОХ",
  "XtraSpreadsheetFunctionNameStringId.Xnpv": "ЧИСТНЗ",
  "XtraSpreadsheetFunctionNameStringId.XOr": "ИСКЛИЛИ",
  "XtraSpreadsheetFunctionNameStringId.Year": "ГОД",
  "XtraSpreadsheetFunctionNameStringId.YearFrac": "ДОЛЯГОДА",
  "XtraSpreadsheetFunctionNameStringId.Yield": "ДОХОД",
  "XtraSpreadsheetFunctionNameStringId.YieldDisc": "ДОХОДСКИДКА",
  "XtraSpreadsheetFunctionNameStringId.YieldMat": "ДОХОДПОГАШ",
  "XtraSpreadsheetFunctionNameStringId.ZDotTest": "Z.ТЕСТ",
  "XtraSpreadsheetFunctionNameStringId.ZTest": "ZТЕСТ",
  "XtraSpreadsheetStringId.Caption_Bytes": "bytes",
  "XtraSpreadsheetStringId.Caption_CellStyleAccent": "Акцент",
  "XtraSpreadsheetStringId.Caption_CellStyleBad": "Плохой",
  "XtraSpreadsheetStringId.Caption_CellStyleCalculation": "Вычисление",
  "XtraSpreadsheetStringId.Caption_CellStyleCheckCell": "Контрольная ячейка",
  "XtraSpreadsheetStringId.Caption_CellStyleComma": "Финансовый",
  "XtraSpreadsheetStringId.Caption_CellStyleComma0": "Финансовый [0]",
  "XtraSpreadsheetStringId.Caption_CellStyleCurrency": "Денежный",
  "XtraSpreadsheetStringId.Caption_CellStyleCurrency0": "Денежный [0]",
  "XtraSpreadsheetStringId.Caption_CellStyleEmphasis": "Выделение",
  "XtraSpreadsheetStringId.Caption_CellStyleExplanatoryText": "Пояснение",
  "XtraSpreadsheetStringId.Caption_CellStyleFollowedHyperlink": "Открывавшаяся гиперссылка",
  "XtraSpreadsheetStringId.Caption_CellStyleGood": "Хороший",
  "XtraSpreadsheetStringId.Caption_CellStyleHeading": "Заголовок",
  "XtraSpreadsheetStringId.Caption_CellStyleHeading2": "Заголовок",
  "XtraSpreadsheetStringId.Caption_CellStyleHyperlink": "Гиперссылка",
  "XtraSpreadsheetStringId.Caption_CellStyleInput": "Ввод",
  "XtraSpreadsheetStringId.Caption_CellStyleLinkedCell": "Связанная ячейка",
  "XtraSpreadsheetStringId.Caption_CellStyleNeutral": "Нейтральный",
  "XtraSpreadsheetStringId.Caption_CellStyleNormal": "Обычный",
  "XtraSpreadsheetStringId.Caption_CellStyleNote": "Примечание",
  "XtraSpreadsheetStringId.Caption_CellStyleOutput": "Вывод",
  "XtraSpreadsheetStringId.Caption_CellStylePercent": "Процентный",
  "XtraSpreadsheetStringId.Caption_CellStyleTitle": "Название",
  "XtraSpreadsheetStringId.Caption_CellStyleTotal": "Итог",
  "XtraSpreadsheetStringId.Caption_CellStyleWarningText": "Текст предупреждения",
  "XtraSpreadsheetStringId.Caption_ChangeChartHorizontalAxisTitleFormLabel": "Название горизонтальной оси:",
  "XtraSpreadsheetStringId.Caption_ChangeChartTitleFormLabel": "Название диаграммы:",
  "XtraSpreadsheetStringId.Caption_ChangeChartVerticalAxisTitleFormLabel": "Название вертикальной оси:",
  "XtraSpreadsheetStringId.Caption_ChartStyle": "Стиль",
  "XtraSpreadsheetStringId.Caption_ColorAutomatic": "Авто",
  "XtraSpreadsheetStringId.Caption_ConditionalFormatting_Duplicate": "повторяющиеся",
  "XtraSpreadsheetStringId.Caption_ConditionalFormatting_Unique": "уникальные",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingAboveAverageRule_FormText": "Выше среднего",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingAboveAverageRule_LabelHeaderText": "Форматировать ячейки, которые находятся ВЫШЕ СРЕДНЕГО:",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingAboveAverageRule_LabelWithText": "для выделенного диапазона с",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingBelowAverageRule_FormText": "Ниже среднего",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingBelowAverageRule_LabelHeaderText": "Форматировать ячейки, которые находятся НИЖЕ СРЕДНЕГО:",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingBelowAverageRule_LabelWithText": "для выделенного диапазона с",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingBetweenRule_FormText": "Между",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingBetweenRule_LabelHeaderText": "Форматировать ячейки, которые находятся МЕЖДУ:",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingBottom10PercentRule_FormText": "Последние 10%",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingBottom10Rule_FormText": "Последние 10 элементов",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingBottomRule_LabelHeaderText": "Форматировать ПОСЛЕДНИЕ ячейки",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingDateOccurringRule_FormText": "Дата",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingDateOccurringRule_LabelHeaderText": "Форматировать ячейки, которые содержат дату:",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingDateOccurringRule_LabelWithText": "с",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingDuplicateValuesRule_FormText": "Повторяющиеся значения",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingDuplicateValuesRule_LabelHeaderText": "Форматировать ячейки, которые содержат:",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingDuplicateValuesRule_LabelWithText": "значения с",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingEqualToRule_FormText": "Равно",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingEqualToRule_LabelHeaderText": "Форматировать ячейки, которые РАВНЫ:",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingGreaterThanRule_FormText": "Больше",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingGreaterThanRule_LabelHeaderText": "Форматировать ячейки, которые БОЛЬШЕ:",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingLessThanRule_FormText": "Меньше",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingLessThanRule_LabelHeaderText": "Форматировать ячейки, которые МЕНЬШЕ:",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingTextContainsRule_FormText": "Текст, который содержит",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingTextContainsRule_LabelHeaderText": "Форматировать ячейки, которые содержат следующий текст:",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingTop10PercentRule_FormText": "Первые 10%",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingTop10Rule_FormText": "Первые 10 элементов",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingTopBottomPercentRule_LabelWithText": "% с",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingTopBottomRule_LabelWithText": "с",
  "XtraSpreadsheetStringId.Caption_ConditionalFormattingTopRule_LabelHeaderText": "Форматировать ПЕРВЫЕ ячейки:",
  "XtraSpreadsheetStringId.Caption_CreateTable": "Создание таблицы",
  "XtraSpreadsheetStringId.Caption_CustomPropertyCheckedBy": "Проверено",
  "XtraSpreadsheetStringId.Caption_CustomPropertyClient": "Клиент",
  "XtraSpreadsheetStringId.Caption_CustomPropertyDateCompleted": "Дата заполнения",
  "XtraSpreadsheetStringId.Caption_CustomPropertyDepartment": "Отдел",
  "XtraSpreadsheetStringId.Caption_CustomPropertyDestination": "Назначение",
  "XtraSpreadsheetStringId.Caption_CustomPropertyDisposition": "Расположение",
  "XtraSpreadsheetStringId.Caption_CustomPropertyDivision": "Подразделение",
  "XtraSpreadsheetStringId.Caption_CustomPropertyDocumentNumber": "Номер документа",
  "XtraSpreadsheetStringId.Caption_CustomPropertyEditor": "Редактор",
  "XtraSpreadsheetStringId.Caption_CustomPropertyForwardTo": "Направить",
  "XtraSpreadsheetStringId.Caption_CustomPropertyGroup": "Группа",
  "XtraSpreadsheetStringId.Caption_CustomPropertyLanguage": "Язык",
  "XtraSpreadsheetStringId.Caption_CustomPropertyMailstop": "Почтовое отделение",
  "XtraSpreadsheetStringId.Caption_CustomPropertyMatter": "Вопрос",
  "XtraSpreadsheetStringId.Caption_CustomPropertyNo": "Нет",
  "XtraSpreadsheetStringId.Caption_CustomPropertyOffice": "Офис",
  "XtraSpreadsheetStringId.Caption_CustomPropertyOwner": "Ответственный",
  "XtraSpreadsheetStringId.Caption_CustomPropertyProject": "Проект",
  "XtraSpreadsheetStringId.Caption_CustomPropertyPublisher": "Издатель",
  "XtraSpreadsheetStringId.Caption_CustomPropertyPurpose": "Цель",
  "XtraSpreadsheetStringId.Caption_CustomPropertyReceivedFrom": "Получено от",
  "XtraSpreadsheetStringId.Caption_CustomPropertyRecordedBy": "Записано",
  "XtraSpreadsheetStringId.Caption_CustomPropertyRecordedDate": "Дата записи",
  "XtraSpreadsheetStringId.Caption_CustomPropertyReference": "Ссылка",
  "XtraSpreadsheetStringId.Caption_CustomPropertySource": "Источник",
  "XtraSpreadsheetStringId.Caption_CustomPropertyStatus": "Состояние",
  "XtraSpreadsheetStringId.Caption_CustomPropertyTelephoneNumber": "Телефон",
  "XtraSpreadsheetStringId.Caption_CustomPropertyTypeBoolean": "Да/Нет",
  "XtraSpreadsheetStringId.Caption_CustomPropertyTypeDateTime": "Дата",
  "XtraSpreadsheetStringId.Caption_CustomPropertyTypeNumber": "Число",
  "XtraSpreadsheetStringId.Caption_CustomPropertyTypeText": "Текст",
  "XtraSpreadsheetStringId.Caption_CustomPropertyTypist": "Отпечатано",
  "XtraSpreadsheetStringId.Caption_CustomPropertyYes": "Да",
  "XtraSpreadsheetStringId.Caption_CustomTableStyleCategory": "Пользовательский",
  "XtraSpreadsheetStringId.Caption_DarkTableStyleCategory": "Темный",
  "XtraSpreadsheetStringId.Caption_DarkTableStyleNamePart": "Темный",
  "XtraSpreadsheetStringId.Caption_DataValidationAnyValue": "Любое значение",
  "XtraSpreadsheetStringId.Caption_DataValidationBetween": "между",
  "XtraSpreadsheetStringId.Caption_DataValidationCustom": "Другой",
  "XtraSpreadsheetStringId.Caption_DataValidationDate": "Дата",
  "XtraSpreadsheetStringId.Caption_DataValidationDecimal": "Действительное",
  "XtraSpreadsheetStringId.Caption_DataValidationEndDate": "Конечная дата",
  "XtraSpreadsheetStringId.Caption_DataValidationEndTime": "Время конца",
  "XtraSpreadsheetStringId.Caption_DataValidationEqual": "равно",
  "XtraSpreadsheetStringId.Caption_DataValidationFormula": "Формула",
  "XtraSpreadsheetStringId.Caption_DataValidationGreaterThan": "больше",
  "XtraSpreadsheetStringId.Caption_DataValidationGreaterThanOrEqual": "больше или равно",
  "XtraSpreadsheetStringId.Caption_DataValidationInformation": "Сообщение",
  "XtraSpreadsheetStringId.Caption_DataValidationLength": "Длина",
  "XtraSpreadsheetStringId.Caption_DataValidationLessThan": "меньше",
  "XtraSpreadsheetStringId.Caption_DataValidationLessThanOrEqual": "меньше или равно",
  "XtraSpreadsheetStringId.Caption_DataValidationList": "Список",
  "XtraSpreadsheetStringId.Caption_DataValidationMaximum": "Максимум",
  "XtraSpreadsheetStringId.Caption_DataValidationMinimum": "Минимум",
  "XtraSpreadsheetStringId.Caption_DataValidationNotBetween": "вне",
  "XtraSpreadsheetStringId.Caption_DataValidationNotEqual": "не равно",
  "XtraSpreadsheetStringId.Caption_DataValidationSource": "Источник",
  "XtraSpreadsheetStringId.Caption_DataValidationStartDate": "Начальная дата",
  "XtraSpreadsheetStringId.Caption_DataValidationStartTime": "Время начала",
  "XtraSpreadsheetStringId.Caption_DataValidationStop": "Остановка",
  "XtraSpreadsheetStringId.Caption_DataValidationTextLength": "Длина текста",
  "XtraSpreadsheetStringId.Caption_DataValidationTime": "Время",
  "XtraSpreadsheetStringId.Caption_DataValidationValue": "Значение",
  "XtraSpreadsheetStringId.Caption_DataValidationWarning": "Предупреждение",
  "XtraSpreadsheetStringId.Caption_DataValidationWholeNumber": "Целое число",
  "XtraSpreadsheetStringId.Caption_EditDefinedNameFormTitle": "Изменение имени",
  "XtraSpreadsheetStringId.Caption_EditProtectedRangeFormTitle": "Изменение диапазона",
  "XtraSpreadsheetStringId.Caption_FormatNumberCustom": "(все форматы)",
  "XtraSpreadsheetStringId.Caption_FormatNumberDate": "Дата",
  "XtraSpreadsheetStringId.Caption_FormatPictureAutomatic": "Авто",
  "XtraSpreadsheetStringId.Caption_FormatPictureBlackAndWhite": "Черно-белое",
  "XtraSpreadsheetStringId.Caption_FormatPictureGrayscale": "Оттенки серого",
  "XtraSpreadsheetStringId.Caption_FormatPictureWashout": "Подложка",
  "XtraSpreadsheetStringId.Caption_FunctionArgumentAny": "любое",
  "XtraSpreadsheetStringId.Caption_FunctionArgumentArray": "массив",
  "XtraSpreadsheetStringId.Caption_FunctionArgumentLogical": "логическое",
  "XtraSpreadsheetStringId.Caption_FunctionArgumentNumber": "число",
  "XtraSpreadsheetStringId.Caption_FunctionArgumentReference": "ссылка",
  "XtraSpreadsheetStringId.Caption_FunctionArgumentText": "строка",
  "XtraSpreadsheetStringId.Caption_FunctionTakesNoArguments": "У данной функции аргументов нет.",
  "XtraSpreadsheetStringId.Caption_FunctionUndefined": "не определен",
  "XtraSpreadsheetStringId.Caption_GenericFilterOperatorAfter": "после",
  "XtraSpreadsheetStringId.Caption_GenericFilterOperatorAfterOrEqual": "после или равно",
  "XtraSpreadsheetStringId.Caption_GenericFilterOperatorBefore": "до",
  "XtraSpreadsheetStringId.Caption_GenericFilterOperatorBeforeOrEqual": "до или равно",
  "XtraSpreadsheetStringId.Caption_GenericFilterOperatorBeginsWith": "начинается с",
  "XtraSpreadsheetStringId.Caption_GenericFilterOperatorBetween": "между",
  "XtraSpreadsheetStringId.Caption_GenericFilterOperatorContains": "содержит",
  "XtraSpreadsheetStringId.Caption_GenericFilterOperatorDoesNotBeginWith": "не начинается с",
  "XtraSpreadsheetStringId.Caption_GenericFilterOperatorDoesNotContain": "не содержит",
  "XtraSpreadsheetStringId.Caption_GenericFilterOperatorDoesNotEndWith": "не заканчивается на",
  "XtraSpreadsheetStringId.Caption_GenericFilterOperatorDoesNotEqual": "не равно",
  "XtraSpreadsheetStringId.Caption_GenericFilterOperatorEndsWith": "заканчивается на",
  "XtraSpreadsheetStringId.Caption_GenericFilterOperatorEquals": "равно",
  "XtraSpreadsheetStringId.Caption_GenericFilterOperatorGreater": "больше",
  "XtraSpreadsheetStringId.Caption_GenericFilterOperatorGreaterOrEqual": "больше или равно",
  "XtraSpreadsheetStringId.Caption_GenericFilterOperatorLess": "меньше",
  "XtraSpreadsheetStringId.Caption_GenericFilterOperatorLessOrEqual": "меньше или равно",
  "XtraSpreadsheetStringId.Caption_GenericFilterOperatorNone": " ",
  "XtraSpreadsheetStringId.Caption_GenericFilterOperatorNotBetween": "вне",
  "XtraSpreadsheetStringId.Caption_GroupAlignment": "Выравнивание",
  "XtraSpreadsheetStringId.Caption_GroupArrange": "Упорядочить",
  "XtraSpreadsheetStringId.Caption_GroupCells": "Ячейки",
  "XtraSpreadsheetStringId.Caption_GroupChanges": "Изменения",
  "XtraSpreadsheetStringId.Caption_GroupCharts": "Диаграммы",
  "XtraSpreadsheetStringId.Caption_GroupChartsDesignData": "Данные",
  "XtraSpreadsheetStringId.Caption_GroupChartsDesignLayouts": "Макеты диаграмм",
  "XtraSpreadsheetStringId.Caption_GroupChartsDesignLocation": "Location",
  "XtraSpreadsheetStringId.Caption_GroupChartsDesignStyles": "Стили диаграмм",
  "XtraSpreadsheetStringId.Caption_GroupChartsDesignType": "Тип",
  "XtraSpreadsheetStringId.Caption_GroupChartsLayoutAnalysis": "Анализ",
  "XtraSpreadsheetStringId.Caption_GroupChartsLayoutAxes": "Оси",
  "XtraSpreadsheetStringId.Caption_GroupChartsLayoutLabels": "Метки",
  "XtraSpreadsheetStringId.Caption_GroupClipboard": "Буфер обмена",
  "XtraSpreadsheetStringId.Caption_GroupComments": "Примечания",
  "XtraSpreadsheetStringId.Caption_GroupCommon": "Общее",
  "XtraSpreadsheetStringId.Caption_GroupDataTools": "Работа с данными",
  "XtraSpreadsheetStringId.Caption_GroupEditing": "Редактирование",
  "XtraSpreadsheetStringId.Caption_GroupFont": "Шрифт",
  "XtraSpreadsheetStringId.Caption_GroupFormulaAuditing": "Зависимости формул",
  "XtraSpreadsheetStringId.Caption_GroupFormulaCalculation": "Вычисление",
  "XtraSpreadsheetStringId.Caption_GroupFormulaDefinedNames": "Определенные имена",
  "XtraSpreadsheetStringId.Caption_GroupFunctionLibrary": "Библиотека функций",
  "XtraSpreadsheetStringId.Caption_GroupIllustrations": "Иллюстрации",
  "XtraSpreadsheetStringId.Caption_GroupInfo": "Информация",
  "XtraSpreadsheetStringId.Caption_GroupLinks": "Ссылки",
  "XtraSpreadsheetStringId.Caption_GroupMailMergeBinding": "Конструктор",
  "XtraSpreadsheetStringId.Caption_GroupMailMergeData": "External Data Sources",
  "XtraSpreadsheetStringId.Caption_GroupMailMergeExtended": "Template Ranges",
  "XtraSpreadsheetStringId.Caption_GroupMailMergeFiltering": "Фильтр",
  "XtraSpreadsheetStringId.Caption_GroupMailMergeGrouping": "Sort && Group",
  "XtraSpreadsheetStringId.Caption_GroupMailMergeMode": "Mode",
  "XtraSpreadsheetStringId.Caption_GroupNumber": "Число",
  "XtraSpreadsheetStringId.Caption_GroupOutline": "Структура",
  "XtraSpreadsheetStringId.Caption_GroupPageSetup": "Параметры страницы",
  "XtraSpreadsheetStringId.Caption_GroupPrint": "Печать",
  "XtraSpreadsheetStringId.Caption_GroupShow": "Показать",
  "XtraSpreadsheetStringId.Caption_GroupSortAndFilter": "Сортировка и фильтр",
  "XtraSpreadsheetStringId.Caption_GroupStatusBar": "Status",
  "XtraSpreadsheetStringId.Caption_GroupStyles": "Стили",
  "XtraSpreadsheetStringId.Caption_GroupSymbols": "Символы",
  "XtraSpreadsheetStringId.Caption_GroupTableProperties": "Свойства",
  "XtraSpreadsheetStringId.Caption_GroupTables": "Таблицы",
  "XtraSpreadsheetStringId.Caption_GroupTableStyleOptions": "Параметры стилей таблицы",
  "XtraSpreadsheetStringId.Caption_GroupTableStyles": "Стили таблиц",
  "XtraSpreadsheetStringId.Caption_GroupTableTools": "Инструменты",
  "XtraSpreadsheetStringId.Caption_GroupWindow": "Окно",
  "XtraSpreadsheetStringId.Caption_GroupZoom": "Масштаб",
  "XtraSpreadsheetStringId.Caption_InvalidExpression": "Недопустимое",
  "XtraSpreadsheetStringId.Caption_LightTableStyleCategory": "Светлый",
  "XtraSpreadsheetStringId.Caption_LightTableStyleNamePart": "Светлый",
  "XtraSpreadsheetStringId.Caption_MailMergeFilterExpressionEditor": "Filter Expression",
  "XtraSpreadsheetStringId.Caption_MediumTableStyleCategory": "Средний",
  "XtraSpreadsheetStringId.Caption_MediumTableStyleNamePart": "Средний",
  "XtraSpreadsheetStringId.Caption_NewDefinedNameFormTitle": "Создание имени",
  "XtraSpreadsheetStringId.Caption_NewProtectedRangeFormTitle": "Новый диапазон",
  "XtraSpreadsheetStringId.Caption_NoColor": "Нет цвета",
  "XtraSpreadsheetStringId.Caption_NoFill": "Нет заливки",
  "XtraSpreadsheetStringId.Caption_PageCategoryChartTools": "Работа с диаграммами",
  "XtraSpreadsheetStringId.Caption_PageCategoryDefault": "Default",
  "XtraSpreadsheetStringId.Caption_PageCategoryDrawingTools": "Средства рисования",
  "XtraSpreadsheetStringId.Caption_PageCategoryPictureTools": "Работа с рисунками",
  "XtraSpreadsheetStringId.Caption_PageCategoryPivotTableTools": "Работа со сводными таблицами",
  "XtraSpreadsheetStringId.Caption_PageCategoryTableTools": "Работа с таблицами",
  "XtraSpreadsheetStringId.Caption_PageChartsDesign": "Конструктор",
  "XtraSpreadsheetStringId.Caption_PageChartsLayout": "Макет",
  "XtraSpreadsheetStringId.Caption_PageData": "Данные",
  "XtraSpreadsheetStringId.Caption_PageFile": "Файл",
  "XtraSpreadsheetStringId.Caption_PageFormat": "Формат",
  "XtraSpreadsheetStringId.Caption_PageFormulas": "Формулы",
  "XtraSpreadsheetStringId.Caption_PageHome": "Главная",
  "XtraSpreadsheetStringId.Caption_PageInsert": "Вставить",
  "XtraSpreadsheetStringId.Caption_PageMailMerge": "Рассылки",
  "XtraSpreadsheetStringId.Caption_PagePageLayout": "Разметка страницы",
  "XtraSpreadsheetStringId.Caption_PageReview": "Рецензирование",
  "XtraSpreadsheetStringId.Caption_PageView": "Вид",
  "XtraSpreadsheetStringId.Caption_PasteSpecial_All": "вс&е",
  "XtraSpreadsheetStringId.Caption_PasteSpecial_AllExceptBorders": "без рам&ки",
  "XtraSpreadsheetStringId.Caption_PasteSpecial_ColumnWidths": "&ширины столбцов",
  "XtraSpreadsheetStringId.Caption_PasteSpecial_Comments": "приме&чания",
  "XtraSpreadsheetStringId.Caption_PasteSpecial_Formats": "форма&ты",
  "XtraSpreadsheetStringId.Caption_PasteSpecial_Formulas": "&формулы",
  "XtraSpreadsheetStringId.Caption_PasteSpecial_FormulasAndNumberFormats": "форму&лы и форматы чисел",
  "XtraSpreadsheetStringId.Caption_PasteSpecial_Values": "&значения",
  "XtraSpreadsheetStringId.Caption_PasteSpecial_ValuesAndNumberFormats": "значени&я и форматы чисел",
  "XtraSpreadsheetStringId.Caption_PatternType_12Gray": "12,5%-ый серый",
  "XtraSpreadsheetStringId.Caption_PatternType_25Gray": "25%-ый серый",
  "XtraSpreadsheetStringId.Caption_PatternType_50Gray": "50%-ый серый",
  "XtraSpreadsheetStringId.Caption_PatternType_6Gray": "6,25-ый серый",
  "XtraSpreadsheetStringId.Caption_PatternType_75Gray": "75%-ый серый",
  "XtraSpreadsheetStringId.Caption_PatternType_DiagonalCrosshatch": "Диагональный клетчатый",
  "XtraSpreadsheetStringId.Caption_PatternType_DiagonalStripe": "Диагональный штриховой",
  "XtraSpreadsheetStringId.Caption_PatternType_HorizontalStripe": "Горизонтальный штриховой",
  "XtraSpreadsheetStringId.Caption_PatternType_ReverseDiagonalStripe": "Перевёрнутый диагональный штриховой",
  "XtraSpreadsheetStringId.Caption_PatternType_Solid": "Сплошной",
  "XtraSpreadsheetStringId.Caption_PatternType_ThickDiagonalCrosshatch": "Толстый, диагональный клетчатый",
  "XtraSpreadsheetStringId.Caption_PatternType_ThinDiagonalCrosshatch": "Тонкий, диагональный клетчатый",
  "XtraSpreadsheetStringId.Caption_PatternType_ThinDiagonalStripe": "Тонкий, диагональный штриховой",
  "XtraSpreadsheetStringId.Caption_PatternType_ThinHorizontalCrosshatch": "Тонкий, горизонтальный клетчатый",
  "XtraSpreadsheetStringId.Caption_PatternType_ThinHorizontalStripe": "Тонкий, горизонтальный штриховой",
  "XtraSpreadsheetStringId.Caption_PatternType_ThinReserseDiagonalStripe": "Тонкий, перевёрнутый диагональный штриховой",
  "XtraSpreadsheetStringId.Caption_PatternType_ThinVerticalStripe": "Тонкий, вертикальный штриховой",
  "XtraSpreadsheetStringId.Caption_PatternType_VerticalStripe": "Вертикальный штриховой",
  "XtraSpreadsheetStringId.Caption_PermissionAutoFilter": "использование автофильтра",
  "XtraSpreadsheetStringId.Caption_PermissionDeleteColumns": "удаление столбцов",
  "XtraSpreadsheetStringId.Caption_PermissionDeleteRows": "удаление строк",
  "XtraSpreadsheetStringId.Caption_PermissionEditObjects": "изменение объектов",
  "XtraSpreadsheetStringId.Caption_PermissionEditRangeWithoutPassword": "Edit range without a password",
  "XtraSpreadsheetStringId.Caption_PermissionEditScenarios": "изменение сценариев",
  "XtraSpreadsheetStringId.Caption_PermissionFormatCells": "форматирование ячеек",
  "XtraSpreadsheetStringId.Caption_PermissionFormatColumns": "форматирование столбцов",
  "XtraSpreadsheetStringId.Caption_PermissionFormatRows": "форматирование строк",
  "XtraSpreadsheetStringId.Caption_PermissionInsertColumns": "вставку столбцов",
  "XtraSpreadsheetStringId.Caption_PermissionInsertHyperlinks": "вставку гиперссылок",
  "XtraSpreadsheetStringId.Caption_PermissionInsertRows": "вставку строк",
  "XtraSpreadsheetStringId.Caption_PermissionPivotTable": "использование отчетов сводной таблицы",
  "XtraSpreadsheetStringId.Caption_PermissionSelectLockedCells": "выделение заблокированных ячеек",
  "XtraSpreadsheetStringId.Caption_PermissionSelectUnlockedCells": "выделение незаблокированных ячеек",
  "XtraSpreadsheetStringId.Caption_PermissionSort": "сортировку",
  "XtraSpreadsheetStringId.Caption_PivotDefaultColumnHeader": "Column Labels",
  "XtraSpreadsheetStringId.Caption_PivotDefaultDataCaption": "Values",
  "XtraSpreadsheetStringId.Caption_PivotDefaultRowHeader": "Row Labels",
  "XtraSpreadsheetStringId.Caption_PivotEmptyValue": "(пусто)",
  "XtraSpreadsheetStringId.Caption_PivotFalseValue": "FALSE",
  "XtraSpreadsheetStringId.Caption_PivotGrandTotal": "Grand Total",
  "XtraSpreadsheetStringId.Caption_PivotOrValue": "or",
  "XtraSpreadsheetStringId.Caption_PivotTableAnalyze": "Анализ",
  "XtraSpreadsheetStringId.Caption_PivotTableAnalyzeActions": "Действия",
  "XtraSpreadsheetStringId.Caption_PivotTableAnalyzeActiveField": "Активное поле",
  "XtraSpreadsheetStringId.Caption_PivotTableAnalyzeCalculations": "Вычисления",
  "XtraSpreadsheetStringId.Caption_PivotTableAnalyzeData": "Данные",
  "XtraSpreadsheetStringId.Caption_PivotTableAnalyzeGroup": "Группировать",
  "XtraSpreadsheetStringId.Caption_PivotTableAnalyzePivotTable": "Сводная таблица",
  "XtraSpreadsheetStringId.Caption_PivotTableAnalyzeShow": "Показать",
  "XtraSpreadsheetStringId.Caption_PivotTableDesign": "Конструктор",
  "XtraSpreadsheetStringId.Caption_PivotTableDesignLayout": "Макет",
  "XtraSpreadsheetStringId.Caption_PivotTableDesignPivotTableStyleOptions": "Параметры стилей сводной таблицы",
  "XtraSpreadsheetStringId.Caption_PivotTableDesignPivotTableStyles": "Стили сводной таблицы",
  "XtraSpreadsheetStringId.Caption_PivotTrueValue": "TRUE",
  "XtraSpreadsheetStringId.Caption_PrefixPivotStyleNamePart": "Стиль сводной таблицы:",
  "XtraSpreadsheetStringId.Caption_PrefixTableStyleNamePart": "Стиль таблицы:",
  "XtraSpreadsheetStringId.Caption_SearchByColumns": "по столбцам",
  "XtraSpreadsheetStringId.Caption_SearchByRows": "по строкам",
  "XtraSpreadsheetStringId.Caption_SearchInComments": "Comments",
  "XtraSpreadsheetStringId.Caption_SearchInFormulas": "формулы",
  "XtraSpreadsheetStringId.Caption_SearchInValues": "значения",
  "XtraSpreadsheetStringId.Caption_ShowValuesAsCalculation": "Вычисление:",
  "XtraSpreadsheetStringId.Caption_StyleGalleryGroupCustom": "Настраиваемый",
  "XtraSpreadsheetStringId.Caption_StyleGalleryGroupDataAndModel": "Данные и модель",
  "XtraSpreadsheetStringId.Caption_StyleGalleryGroupGoogBadAndNeutral": "Хороший, плохой и нейтральный",
  "XtraSpreadsheetStringId.Caption_StyleGalleryGroupNumberFormat": "Числовой формат",
  "XtraSpreadsheetStringId.Caption_StyleGalleryGroupThemedCellStyles": "Стили ячеек с темой",
  "XtraSpreadsheetStringId.Caption_StyleGalleryGroupTitlesAndHeadings": "Названия и заголовки",
  "XtraSpreadsheetStringId.Caption_Subtotal_ColumnHeader": "(Столбец {0})",
  "XtraSpreadsheetStringId.Caption_Subtotal_Grand": "Общий {0}",
  "XtraSpreadsheetStringId.Caption_Subtotal_SumName": "Итог",
  "XtraSpreadsheetStringId.Caption_TableStyleNameIsNone": "Нет",
  "XtraSpreadsheetStringId.Caption_TableToolsDesignPage": "Конструктор",
  "XtraSpreadsheetStringId.Caption_TimePeriod_Last7Days": "За последние 7 дней",
  "XtraSpreadsheetStringId.Caption_TimePeriod_LastMonth": "В прошлом месяце",
  "XtraSpreadsheetStringId.Caption_TimePeriod_LastWeek": "На прошлой неделе",
  "XtraSpreadsheetStringId.Caption_TimePeriod_NextMonth": "В следующем месяце",
  "XtraSpreadsheetStringId.Caption_TimePeriod_NextWeek": "На следующей неделе",
  "XtraSpreadsheetStringId.Caption_TimePeriod_ThisMonth": "В этом месяце",
  "XtraSpreadsheetStringId.Caption_TimePeriod_ThisWeek": "На этой неделе",
  "XtraSpreadsheetStringId.Caption_TimePeriod_Today": "Сегодня",
  "XtraSpreadsheetStringId.Caption_TimePeriod_Tomorrow": "Завтра",
  "XtraSpreadsheetStringId.Caption_TimePeriod_Yesterday": "Вчера",
  "XtraSpreadsheetStringId.Caption_Top10FilterOrderBottom": "наименьших",
  "XtraSpreadsheetStringId.Caption_Top10FilterOrderTop": "наибольших",
  "XtraSpreadsheetStringId.Caption_Top10FilterTypeItems": "элементов списка",
  "XtraSpreadsheetStringId.Caption_Top10FilterTypePercent": "% от количества элементов",
  "XtraSpreadsheetStringId.Caption_Top10FilterTypeSum": "Сумма",
  "XtraSpreadsheetStringId.CaptionAllFunctionsGroup": "Все",
  "XtraSpreadsheetStringId.CaptionDatabaseFunctionsGroup": "Работа с базой данных",
  "XtraSpreadsheetStringId.CaptionUserDefinedFunctionsGroup": "User Defined",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_BlackCircle": "Черный круг",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_CircleWithOneWhiteQuarter": "Круг с одной белой четвертью",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_CircleWithThreeWhiteQuarters": "Круг с тремя белыми четвертями",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_CircleWithTwoWhiteQuarters": "Круг с двумя белыми четвертями",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_FourFilledBoxes": "Четыре заполненных квадратика",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GoldStar": "Золотая звезда",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GrayCircle": "Серый круг",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GrayDownArrow": "Серая стрелка вниз",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GrayDownInclineArrow": "Серая наклонная стрелка вниз",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GraySideArrow": "Серая стрелка влево",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GrayUpArrow": "Серая стрелка вверх",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GrayUpInclineArrow": "Серая наклонная стрелка вверх",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GreenCheck": "Зеленая галочка",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GreenCheckSymbol": "Зеленая галочка",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GreenCircle": "Зеленый круг",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GreenFlag": "Зеленый флажок",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GreenTrafficLight": "Зеленый сигнал светофора",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GreenUpArrow": "Зеленая стрелка вверх",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GreenUpTriangle": "Зеленый треугольник вверх",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_HalfGoldStar": "Половинка золотой звезды",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_NoIcon": "Нет значка ячейки",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_OneFilledBox": "Один заполненный квадратик",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_PinkCircle": "Розовый круг",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_RedCircle": "Красный круг",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_RedCircleWithBorder": "Красный круг с границей",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_RedCross": "Красный крест",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_RedCrossSymbol": "Красный крест",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_RedDiamond": "Красный ромб",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_RedDownArrow": "Красная стрелка вниз",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_RedDownTriangle": "Красный треугольник вниз",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_RedFlag": "Красный флажок",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_RedTrafficLight": "Красный сигнал светофора",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_SignalMeterWithFourFilledBars": "Уровень сигнала: четыре полоски",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_SignalMeterWithNoFilledBars": "Уровень сигнала: без полосок",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_SignalMeterWithOneFilledBar": "Уровень сигнала: одна полоска",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_SignalMeterWithThreeFilledBars": "Уровень сигнала: три полоски",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_SignalMeterWithTwoFilledBars": "Уровень сигнала: две полоски",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_SilverStar": "Серебряная звезда",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_ThreeFilledBoxes": "Три заполненных квадратика",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_TwoFilledBoxes": "Два заполненных квадратика",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_WhiteCircle": "Белый круг",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_YellowCircle": "Желтый круг",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_YellowDash": "Желтый дефис",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_YellowDownInclineArrow": "Желтая наклонная стрелка вниз",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_YellowExclamation": "Желтый восклицательный знак",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_YellowExclamationSymbol": "Желтый восклицательный знак",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_YellowFlag": "Желтый флажок",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_YellowSideArrow": "Желтая стрелка влево",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_YellowTrafficLight": "Желтый сигнал светофора",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_YellowTriangle": "Желтый треугольник",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_YellowUpInclineArrow": "Желтая наклонная стрелка вверх",
  "XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_ZeroFilledBoxes": "Ноль заполненных квадратиков",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_1StdDevAboveAverageCaption": "На 1 стандартное отклонение выше среднего",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_1StdDevBelowAverageCaption": "На 1 стандартное отклонение ниже среднего",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_2StdDevAboveAverageCaption": "На 2 стандартных отклонения выше среднего",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_2StdDevBelowAverageCaption": "На 2 стандартных отклонения ниже среднего",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_3StdDevAboveAverageCaption": "На 3 стандартных отклонения выше среднего",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_3StdDevBelowAverageCaption": "На 3 стандартных отклонения ниже среднего",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_AboveAverageCaption": "Выше среднего",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_BelowAverageCaption": "Ниже среднего",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_BottomCaption": "Последние {0}",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_CaptionCancel": "Отмена",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_CaptionClose": "Закрыть",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_CellValueBeginsWithCaption": "Значение ячейки начинается с {0}",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_CellValueBetweenCaption": "Значение ячейки от {0} до {1}",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_CellValueCaption": "Значение ячейки",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_CellValueContainsCaption": "Значение ячейки содержит {0}",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_CellValueDoesNotContainCaption": "Значение ячейки не содержит {0}",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_CellValueEndsWithCaption": "Значение ячейки заканчивается на {0}",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_CellValueNotBetweenCaption": "Значение ячейки вне диапазона от {0} до {1}",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_ColorScaleCaption": "Шкала цветов",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_ContainBlankCaption": "Ячейка содержит пустое значение",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_ContainErrorCaption": "Ячейка содержит ошибку",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_ContainNoBlanksCaption": "Ячейка не содержит пустое значение",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_ContainNoErrorsCaption": "Ячейка не содержит ошибку",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_CurrentSelection": "Текущий фрагмент",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_DataBarCaption": "Гистограмма",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_DuplicateValuesCaption": "Повторяющиеся значения",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_EqualOrAboveAverageCaption": "Равно или выше среднего",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_EqualOrBelowAverageCaption": "Равно или ниже среднего",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_FormulaCaption": "Формула:",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_IconSetCaption": "Набор значков",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_Last7DaysCaption": "За последние 7 дней",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_PivotTable": "Сводная таблица",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_Table": "Таблица",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_ThisPivotTable": "Эта сводная таблица",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_ThisTable": "Эта таблица",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_ThisWorksheet": "Этот лист",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_TopCaption": "Первые {0}",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_UniqueValuesCaption": "Уникальные значения",
  "XtraSpreadsheetStringId.ConditionalFormattingRulesManagerForm_Worksheet": "Лист",
  "XtraSpreadsheetStringId.ConditionalFormattingStyle_GreenFillWithDarkGreenText": "Зеленая заливка и темно-зеленый текст",
  "XtraSpreadsheetStringId.ConditionalFormattingStyle_LightRedFill": "Светло-красная заливка",
  "XtraSpreadsheetStringId.ConditionalFormattingStyle_LightRedFillWithDarkRedText": "Светло-красная заливка и темно-красный текст",
  "XtraSpreadsheetStringId.ConditionalFormattingStyle_RedBorder": "Красная граница",
  "XtraSpreadsheetStringId.ConditionalFormattingStyle_RedText": "Красный текст",
  "XtraSpreadsheetStringId.ConditionalFormattingStyle_YellowFillWithDarkYellowText": "Желтая заливка и темно-желтый текст",
  "XtraSpreadsheetStringId.ConditionFormattingFormatCellsForm_FontDescription": "Условное форматирование может включать в себя изменение начертания шрифта и его цвета.",
  "XtraSpreadsheetStringId.DataFieldSettingsPivotTableForm_BaseItemNext": "(далее)",
  "XtraSpreadsheetStringId.DataFieldSettingsPivotTableForm_BaseItemPrevious": "(назад)",
  "XtraSpreadsheetStringId.DataFieldSettingsPivotTableForm_PartOfCustomName": " по полю ",
  "XtraSpreadsheetStringId.DataFieldSettingsPivotTableForm_ShowValueAsNoCalculation": "Без вычислений",
  "XtraSpreadsheetStringId.DataFieldSettingsPivotTableForm_ShowValueDifference": "Отличие",
  "XtraSpreadsheetStringId.DataFieldSettingsPivotTableForm_ShowValueIndex": "Индекс",
  "XtraSpreadsheetStringId.DataFieldSettingsPivotTableForm_ShowValuePercent": "Доля",
  "XtraSpreadsheetStringId.DataFieldSettingsPivotTableForm_ShowValuePercentDifference": "Приведенное отличие",
  "XtraSpreadsheetStringId.DataFieldSettingsPivotTableForm_ShowValuePercentOfColumn": "% от суммы по столбцу",
  "XtraSpreadsheetStringId.DataFieldSettingsPivotTableForm_ShowValuePercentOfParent": "% от родительской суммы",
  "XtraSpreadsheetStringId.DataFieldSettingsPivotTableForm_ShowValuePercentOfParentColumn": "% от суммы по родительскому столбцу",
  "XtraSpreadsheetStringId.DataFieldSettingsPivotTableForm_ShowValuePercentOfParentRow": "% от суммы по родительской строке",
  "XtraSpreadsheetStringId.DataFieldSettingsPivotTableForm_ShowValuePercentOfRow": "% от суммы по строке",
  "XtraSpreadsheetStringId.DataFieldSettingsPivotTableForm_ShowValuePercentOfRunningTotal": "% от суммы с нарастающим итогом в поле",
  "XtraSpreadsheetStringId.DataFieldSettingsPivotTableForm_ShowValuePercentOfTotal": "% от общей суммы",
  "XtraSpreadsheetStringId.DataFieldSettingsPivotTableForm_ShowValueRankAscending": "Сортировка от минимального к максимальному",
  "XtraSpreadsheetStringId.DataFieldSettingsPivotTableForm_ShowValueRankDescending": "Сортировка от максимального к минимальному",
  "XtraSpreadsheetStringId.DataFieldSettingsPivotTableForm_ShowValueRunningTotal": "С нарастающим итогом в поле",
  "XtraSpreadsheetStringId.DefaultChartsheetName": "Диаграмма",
  "XtraSpreadsheetStringId.DefaultDocumentName": "Document",
  "XtraSpreadsheetStringId.DefaultInitialTableColumnNamePrefix": "Column",
  "XtraSpreadsheetStringId.DefaultRecoveredWorksheetName": "Восстановленный_Лист",
  "XtraSpreadsheetStringId.DefaultWorksheetName": "Лист",
  "XtraSpreadsheetStringId.EditConditionalFormattingRuleForm_FormTitle": "Изменение правила форматирования",
  "XtraSpreadsheetStringId.EditSpreadsheetMailMergeParameter_Text": "Spreadsheet Parameter",
  "XtraSpreadsheetStringId.FieldAndDataFieldSettingsPivotTableForm_FunctionAverage": "Среднее",
  "XtraSpreadsheetStringId.FieldAndDataFieldSettingsPivotTableForm_FunctionCount": "Количество",
  "XtraSpreadsheetStringId.FieldAndDataFieldSettingsPivotTableForm_FunctionCountNumbers": "Количество чисел",
  "XtraSpreadsheetStringId.FieldAndDataFieldSettingsPivotTableForm_FunctionDefault": "Итог",
  "XtraSpreadsheetStringId.FieldAndDataFieldSettingsPivotTableForm_FunctionMax": "Максимум",
  "XtraSpreadsheetStringId.FieldAndDataFieldSettingsPivotTableForm_FunctionMin": "Минимум",
  "XtraSpreadsheetStringId.FieldAndDataFieldSettingsPivotTableForm_FunctionProduct": "Произведение",
  "XtraSpreadsheetStringId.FieldAndDataFieldSettingsPivotTableForm_FunctionStdDev": "Смещенное отклонение",
  "XtraSpreadsheetStringId.FieldAndDataFieldSettingsPivotTableForm_FunctionStdDevp": "Несмещенное отклонение",
  "XtraSpreadsheetStringId.FieldAndDataFieldSettingsPivotTableForm_FunctionSum": "Сумма",
  "XtraSpreadsheetStringId.FieldAndDataFieldSettingsPivotTableForm_FunctionVar": "Смещенная дисперсия",
  "XtraSpreadsheetStringId.FieldAndDataFieldSettingsPivotTableForm_FunctionVarp": "Несмещенная дисперсия",
  "XtraSpreadsheetStringId.FieldListDockPanel_Text": "Список полей",
  "XtraSpreadsheetStringId.FileFilterDescription_AllFiles": "Все файлы",
  "XtraSpreadsheetStringId.FileFilterDescription_CSVFiles": "CSV (с разделителями)",
  "XtraSpreadsheetStringId.FileFilterDescription_DocFiles": "Книга Excel 97-2003",
  "XtraSpreadsheetStringId.FileFilterDescription_HtmlFiles": "HyperText Markup Language Format",
  "XtraSpreadsheetStringId.FileFilterDescription_OpenDocumentFiles": "Книга OpenDocument",
  "XtraSpreadsheetStringId.FileFilterDescription_OpenXmlFiles": "Книга Excel",
  "XtraSpreadsheetStringId.FileFilterDescription_TextFiles": "Текстовые файлы (с разделителями табуляции)",
  "XtraSpreadsheetStringId.FileFilterDescription_XlsbFiles": "Excel Binary Workbook",
  "XtraSpreadsheetStringId.FileFilterDescription_XlsmFiles": "Книга Excel с поддержкой макросов",
  "XtraSpreadsheetStringId.FileFilterDescription_XltFiles": "Excel 97-2003 Template",
  "XtraSpreadsheetStringId.FileFilterDescription_XltmFiles": "Excel Macro-Enabled Template",
  "XtraSpreadsheetStringId.FileFilterDescription_XltxFiles": "Excel Template",
  "XtraSpreadsheetStringId.FontStyle_Bold": "полужирный",
  "XtraSpreadsheetStringId.FontStyle_BoldItalic": "полужирный курсив",
  "XtraSpreadsheetStringId.FontStyle_Italic": "курсив",
  "XtraSpreadsheetStringId.FontStyle_Regular": "обычный",
  "XtraSpreadsheetStringId.FormatCellsForm_CategoryDescription_Accounting": "Формат \"Финансовый\" используется для выравнивания денежных величин по разделителю целой и дробной части.",
  "XtraSpreadsheetStringId.FormatCellsForm_CategoryDescription_Currency": "Формат \"Денежный\" используется для отображения денежных величин. Для выравнивания значений по десятичному разделителю используйте формат \"Финансовый\".",
  "XtraSpreadsheetStringId.FormatCellsForm_CategoryDescription_Custom": "Введите код числового формата, используя один из существующих кодов в качестве образца.",
  "XtraSpreadsheetStringId.FormatCellsForm_CategoryDescription_Date": "Форматы дат служат для отображения дат и времени, представленных числами, в виде дат. Форматы дат, которые начинаются со звездочки (*), меняются при изменении форматов отображения даты и времени в операционной системе. Форматы без звездочки не зависят от настроек операционной системы.",
  "XtraSpreadsheetStringId.FormatCellsForm_CategoryDescription_Number": "Числовой формат является наиболее общим способом представления чисел. Для вывода денежных значений используются также форматы \"Денежный\" и \"Финансовый\".",
  "XtraSpreadsheetStringId.FormatCellsForm_CategoryDescription_Percentage": "В процентном формате значение ячеек умножается на 100 и выводится на экран с символом процента.",
  "XtraSpreadsheetStringId.FormatCellsForm_CategoryDescription_Time": "Форматы времени служат для отображения дат и времени, представленных числами, в виде дат. Форматы времени, которые начинаются со звездочки (*), меняются при изменении форматов отображения даты и времени в операционной системе. Форматы без звездочки не зависят от настроек операционной системы.",
  "XtraSpreadsheetStringId.FormatCellsForm_CurrencySymbol_None": "Нет",
  "XtraSpreadsheetStringId.FormatCellsForm_FractionAsEighths": "Восьмыми долями (4/8)",
  "XtraSpreadsheetStringId.FormatCellsForm_FractionAsHalves": "Половинными долями (1/2)",
  "XtraSpreadsheetStringId.FormatCellsForm_FractionAsHundredths": "Сотыми долями (30/100)",
  "XtraSpreadsheetStringId.FormatCellsForm_FractionAsQuarters": "Четвертыми долями (2/4)",
  "XtraSpreadsheetStringId.FormatCellsForm_FractionAsSixteenths": "Шестнадцатыми долями (8/16)",
  "XtraSpreadsheetStringId.FormatCellsForm_FractionAsTenths": "Десятыми долями (3/10)",
  "XtraSpreadsheetStringId.FormatCellsForm_FractionUpToOneDigit": "Простыми дробями (1/4)",
  "XtraSpreadsheetStringId.FormatCellsForm_FractionUpToThreeDigits": "Дробями до трех цифр (312/943)",
  "XtraSpreadsheetStringId.FormatCellsForm_FractionUpToTwoDigits": "Дробями до двух цифр (21/25)",
  "XtraSpreadsheetStringId.FormatCellsForm_HorizontalAlignmentCaption_Center": "по центру",
  "XtraSpreadsheetStringId.FormatCellsForm_HorizontalAlignmentCaption_CenterAcrossSelection": "по центру выделения",
  "XtraSpreadsheetStringId.FormatCellsForm_HorizontalAlignmentCaption_DistributedIndent": "распределенное (отступ)",
  "XtraSpreadsheetStringId.FormatCellsForm_HorizontalAlignmentCaption_Fill": "с заполнением",
  "XtraSpreadsheetStringId.FormatCellsForm_HorizontalAlignmentCaption_General": "по значению",
  "XtraSpreadsheetStringId.FormatCellsForm_HorizontalAlignmentCaption_Justify": "по ширине",
  "XtraSpreadsheetStringId.FormatCellsForm_HorizontalAlignmentCaption_LeftIndent": "по левому краю (отступ)",
  "XtraSpreadsheetStringId.FormatCellsForm_HorizontalAlignmentCaption_RightIndent": "по правому краю (отступ)",
  "XtraSpreadsheetStringId.FormatCellsForm_NumberDescription_General": "Общий формат используется для отображения как текстовых, так и числовых значений произвольного типа.",
  "XtraSpreadsheetStringId.FormatCellsForm_NumberDescription_Text": "Значения в текстовом формате отображаются точно так же, как вводятся. Они обрабатываются как строки вне зависимости от их содержания.",
  "XtraSpreadsheetStringId.FormatCellsForm_NumberFormatCalendar_GregorianArabic": "Арабский (западный)",
  "XtraSpreadsheetStringId.FormatCellsForm_NumberFormatCalendar_GregorianLocalized": "Григорианский",
  "XtraSpreadsheetStringId.FormatCellsForm_NumberFormatCalendar_GregorianMiddleEastFrench": "Ближневосточный (французский)",
  "XtraSpreadsheetStringId.FormatCellsForm_NumberFormatCalendar_GregorianTransliteratedEnglish": "Транслитерированный английский",
  "XtraSpreadsheetStringId.FormatCellsForm_NumberFormatCalendar_GregorianTransliteratedFrench": "Транслитерированный французский",
  "XtraSpreadsheetStringId.FormatCellsForm_NumberFormatCalendar_GregorianUSEnglish": "Григорианский (английский)",
  "XtraSpreadsheetStringId.FormatCellsForm_NumberFormatCalendar_Hijri": "Хиджра",
  "XtraSpreadsheetStringId.FormatCellsForm_NumberFormatCalendar_Japanese": "Японский (от начала правления императора)",
  "XtraSpreadsheetStringId.FormatCellsForm_NumberFormatCalendar_Korean": "Корейский (данки)",
  "XtraSpreadsheetStringId.FormatCellsForm_NumberFormatCalendar_ThaiBuddhist": "Тайский (буддистский)",
  "XtraSpreadsheetStringId.FormatCellsForm_NumberFormatCalendar_UmAlQura": "Умм аль-Кура",
  "XtraSpreadsheetStringId.FormatCellsForm_RotatedTextPreview": "Текст",
  "XtraSpreadsheetStringId.FormatCellsForm_TextDirectionCaption_Context": "по контексту",
  "XtraSpreadsheetStringId.FormatCellsForm_TextDirectionCaption_LeftToRight": "слева направо",
  "XtraSpreadsheetStringId.FormatCellsForm_TextDirectionCaption_RightToLeft": "справа налево",
  "XtraSpreadsheetStringId.FormatCellsForm_UnderlineCaption_Double": "Двойное, по значению",
  "XtraSpreadsheetStringId.FormatCellsForm_UnderlineCaption_DoubleAccounting": "Двойное, по ячейке",
  "XtraSpreadsheetStringId.FormatCellsForm_UnderlineCaption_None": "Нет",
  "XtraSpreadsheetStringId.FormatCellsForm_UnderlineCaption_Single": "Одинарное, по значению",
  "XtraSpreadsheetStringId.FormatCellsForm_UnderlineCaption_SingleAccounting": "Одинарное, по ячейке",
  "XtraSpreadsheetStringId.FormatCellsForm_VerticalAlignmentCaption_Bottom": "по нижнему краю",
  "XtraSpreadsheetStringId.FormatCellsForm_VerticalAlignmentCaption_Center": "по центру",
  "XtraSpreadsheetStringId.FormatCellsForm_VerticalAlignmentCaption_Distributed": "распределенное",
  "XtraSpreadsheetStringId.FormatCellsForm_VerticalAlignmentCaption_Justify": "по высоте",
  "XtraSpreadsheetStringId.FormatCellsForm_VerticalAlignmentCaption_Top": "по верхнему краю",
  "XtraSpreadsheetStringId.HeaderFooterFormatTag_DateAnalog": "&[Дата]",
  "XtraSpreadsheetStringId.HeaderFooterFormatTag_PageNumberAnalog": "&[Страница]",
  "XtraSpreadsheetStringId.HeaderFooterFormatTag_PageTotalAnalog": "&[Страниц]",
  "XtraSpreadsheetStringId.HeaderFooterFormatTag_PictureAnalog": "&[Рисунок]",
  "XtraSpreadsheetStringId.HeaderFooterFormatTag_TimeAnalog": "&[Время]",
  "XtraSpreadsheetStringId.HeaderFooterFormatTag_WorkbookFileNameAnalog": "&[Файл]",
  "XtraSpreadsheetStringId.HeaderFooterFormatTag_WorkbookFilePathAnalog": "&[Путь]",
  "XtraSpreadsheetStringId.HeaderFooterFormatTag_WorksheetNameAnalog": "&[Лист]",
  "XtraSpreadsheetStringId.HeaderFooterPredefinedString_Confidential": "Конфиденциально",
  "XtraSpreadsheetStringId.HeaderFooterPredefinedString_None": "(нет)",
  "XtraSpreadsheetStringId.HeaderFooterPredefinedString_Of": "из",
  "XtraSpreadsheetStringId.HeaderFooterPredefinedString_Page": "Страница",
  "XtraSpreadsheetStringId.HeaderFooterPredefinedString_PreparedBy": "Подготовил:",
  "XtraSpreadsheetStringId.HyperlinkForm_DisabledDisplayText": "<<Selection in Document>>",
  "XtraSpreadsheetStringId.HyperlinkForm_NodeCellReferences": "Cell References",
  "XtraSpreadsheetStringId.HyperlinkForm_NodeDefinedName": "Defined Names",
  "XtraSpreadsheetStringId.HyperlinkForm_SelectedBookmarkNone": "<None>",
  "XtraSpreadsheetStringId.MailMergeParametersDockPanel_EditParameters": "Edit Parameters...",
  "XtraSpreadsheetStringId.MailMergeParametersDockPanel_NameColumn": "Name",
  "XtraSpreadsheetStringId.MailMergeParametersDockPanel_Text": "Parameters",
  "XtraSpreadsheetStringId.MailMergeParametersDockPanel_ValueColumn": "Value",
  "XtraSpreadsheetStringId.MenuCmd_AddNewWorksheetDescription": "Insert Worksheet",
  "XtraSpreadsheetStringId.MenuCmd_AutoOutlineCommand": "Создать структуру",
  "XtraSpreadsheetStringId.MenuCmd_AutoOutlineCommandDescription": "Analyze formulas to determine the grouping levels and create an outline that contains column groups, row groups or both.",
  "XtraSpreadsheetStringId.MenuCmd_AverageInfoStatusBarCommandCaptionPart": "СРЕДНЕЕ:",
  "XtraSpreadsheetStringId.MenuCmd_AverageInfoStatusBarCommandDescription": "Среднее выделенных ячеек",
  "XtraSpreadsheetStringId.MenuCmd_CalculateNow": "Пересчет",
  "XtraSpreadsheetStringId.MenuCmd_CalculateNowDescription": "Пересчет всей книги.\n\nЭто необходимо только в том случае, если автоматическое выполнение вычислений отключено.",
  "XtraSpreadsheetStringId.MenuCmd_CalculateSheet": "Произвести вычисления",
  "XtraSpreadsheetStringId.MenuCmd_CalculateSheetDescription": "Пересчет активного листа.\n\nЭто необходимо только в том случае, если автоматическое выполнение вычислений отключено.",
  "XtraSpreadsheetStringId.MenuCmd_CalculationModeAutomatic": "Авто",
  "XtraSpreadsheetStringId.MenuCmd_CalculationModeAutomaticDescription": "Automatic.",
  "XtraSpreadsheetStringId.MenuCmd_CalculationModeManual": "Вручную",
  "XtraSpreadsheetStringId.MenuCmd_CalculationModeManualDescription": "Manual.",
  "XtraSpreadsheetStringId.MenuCmd_CalculationOptionsCommandGroup": "Параметры вычислений",
  "XtraSpreadsheetStringId.MenuCmd_CalculationOptionsCommandGroupDescription": "Выбор режима пересчета формул - вручную или автоматически.\n\nЕсли вы внесете изменение, которое влияет на значения, автоматически выполнится их пересчет.",
  "XtraSpreadsheetStringId.MenuCmd_ChangeChartType": "Изменить тип диаграммы",
  "XtraSpreadsheetStringId.MenuCmd_ChangeChartTypeContextMenuItem": "Изменить тип диаграммы...",
  "XtraSpreadsheetStringId.MenuCmd_ChangeChartTypeDescription": "Изменение типа диаграммы.",
  "XtraSpreadsheetStringId.MenuCmd_ChangeDataSourcePivotTable": "Источник данных",
  "XtraSpreadsheetStringId.MenuCmd_ChangeDataSourcePivotTableDescription": "Изменение исходных данных для сводной таблицы.",
  "XtraSpreadsheetStringId.MenuCmd_ChartAxesCommandGroup": "Оси",
  "XtraSpreadsheetStringId.MenuCmd_ChartAxesCommandGroupDescription": "Изменение форматирования и разметки каждой оси.",
  "XtraSpreadsheetStringId.MenuCmd_ChartAxisTitlesCommandGroup": "Названия осей",
  "XtraSpreadsheetStringId.MenuCmd_ChartAxisTitlesCommandGroupDescription": "Добавление, удаление или размещение текста, который используется для подписи каждой оси.",
  "XtraSpreadsheetStringId.MenuCmd_ChartChangeHorizontalAxisTitleContextMenuItem": "Изменить название горизонтальной оси...",
  "XtraSpreadsheetStringId.MenuCmd_ChartChangeHorizontalAxisTitleContextMenuItemDescription": "Изменить название горизонтальной оси.",
  "XtraSpreadsheetStringId.MenuCmd_ChartChangeTitleContextMenuItem": "Изменить название диаграммы...",
  "XtraSpreadsheetStringId.MenuCmd_ChartChangeTitleContextMenuItemDescription": "Изменить название диаграммы.",
  "XtraSpreadsheetStringId.MenuCmd_ChartChangeVerticalAxisTitleContextMenuItem": "Изменить название вертикальной оси...",
  "XtraSpreadsheetStringId.MenuCmd_ChartChangeVerticalAxisTitleContextMenuItemDescription": "Изменить название вертикальной оси.",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsAboveCommand": "Сверху",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsAboveCommandDescription": "Показывать подписи данных над точками данных.",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsBelowCommand": "Снизу",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsBelowCommandDescription": "Показывать подписи данных под точками данных.",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsBestFitCommand": "По содержимому",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsBestFitCommandDescription": "Показывать подписи данных и размещать их оптимальным образом.",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsCenterCommand": "В центре",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsCenterCommandDescription": "Показывать подписи данных по центру точек данных.",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsCommandGroup": "Подписи данных",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsCommandGroupDescription": "Добавление, удаление или размещение подписей данных. \n\nПодписи данных позволяют обозначить элементы диаграммы с помощью реальных значений данных.",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsDefaultCommand": "Показать",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsDefaultCommandDescription": "Включить подписи данных для выделенного диапазона",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsInsideBaseCommand": "У основания, внутри",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsInsideBaseCommandDescription": "Показывать подписи данных внутри у основания точек данных.",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsInsideEndCommand": "У вершины, внутри",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsInsideEndCommandDescription": "Показывать подписи данных внутри у вершины точек данных.",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsLeftCommand": "Слева",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsLeftCommandDescription": "Показывать подписи данных слева от точек данных",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsNoneCommand": "Нет",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsNoneCommandDescription": "Не показывать подписи данных для выделенного диапазона.",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsOutsideEndCommand": "У вершины, снаружи",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsOutsideEndCommandDescription": "Показывать подписи данных снаружи у вершины точек данных.",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsRightCommand": "Справа",
  "XtraSpreadsheetStringId.MenuCmd_ChartDataLabelsRightCommandDescription": "Показывать подписи данных справа от точек данных.",
  "XtraSpreadsheetStringId.MenuCmd_ChartErrorBarsCommandGroup": "Планки погрешностей",
  "XtraSpreadsheetStringId.MenuCmd_ChartErrorBarsCommandGroupDescription": "Добавление планок погрешностей к диаграмме.",
  "XtraSpreadsheetStringId.MenuCmd_ChartErrorBarsNoneCommand": "Нет",
  "XtraSpreadsheetStringId.MenuCmd_ChartErrorBarsNoneCommandDescription": "Удаление планок погрешностей для выделенного ряда или для всех рядов, если ни один из них не выделен.",
  "XtraSpreadsheetStringId.MenuCmd_ChartErrorBarsPercentageCommand": "Планки погрешностей с относительными ошибками",
  "XtraSpreadsheetStringId.MenuCmd_ChartErrorBarsPercentageCommandDescription": "Отображение планок погрешностей для выделенного ряда диаграммы с использованием пятипроцентных значений.",
  "XtraSpreadsheetStringId.MenuCmd_ChartErrorBarsStandardDeviationCommand": "Планки погрешностей со стандартными отклонениями",
  "XtraSpreadsheetStringId.MenuCmd_ChartErrorBarsStandardDeviationCommandDescription": "Отображение планок погрешностей для выделенного ряда диаграммы с использованием одного стандартного отклонения.",
  "XtraSpreadsheetStringId.MenuCmd_ChartErrorBarsStandardErrorCommand": "Планки погрешностей со стандартными ошибками",
  "XtraSpreadsheetStringId.MenuCmd_ChartErrorBarsStandardErrorCommandDescription": "Отображение планок погрешностей для выделенного ряда диаграммы с использованием стандартных ошибок.",
  "XtraSpreadsheetStringId.MenuCmd_ChartGridlinesCommandGroup": "Сетка",
  "XtraSpreadsheetStringId.MenuCmd_ChartGridlinesCommandGroupDescription": "Включение или отключение линий сетки.",
  "XtraSpreadsheetStringId.MenuCmd_ChartHidePrimaryHorizontalAxisCommand": "Нет",
  "XtraSpreadsheetStringId.MenuCmd_ChartHidePrimaryHorizontalAxisCommandDescription": "Не показывать ось.",
  "XtraSpreadsheetStringId.MenuCmd_ChartHidePrimaryVerticalAxisCommand": "Нет",
  "XtraSpreadsheetStringId.MenuCmd_ChartHidePrimaryVerticalAxisCommandDescription": "Не показывать ось.",
  "XtraSpreadsheetStringId.MenuCmd_ChartHideUpDownBarsCommand": "Нет",
  "XtraSpreadsheetStringId.MenuCmd_ChartHideUpDownBarsCommandDescription": "Не показывать полосы повышения/понижения",
  "XtraSpreadsheetStringId.MenuCmd_ChartLegendAtBottomCommand": "Добавить легенду снизу",
  "XtraSpreadsheetStringId.MenuCmd_ChartLegendAtBottomCommandDescription": "Добавить легенду и выровнять по нижнему краю.",
  "XtraSpreadsheetStringId.MenuCmd_ChartLegendAtLeftCommand": "Добавить легенду слева",
  "XtraSpreadsheetStringId.MenuCmd_ChartLegendAtLeftCommandDescription": "Добавить легенду и выровнять по левому краю.",
  "XtraSpreadsheetStringId.MenuCmd_ChartLegendAtRightCommand": "Добавить легенду справа",
  "XtraSpreadsheetStringId.MenuCmd_ChartLegendAtRightCommandDescription": "Добавить легенду и выровнять по правому краю.",
  "XtraSpreadsheetStringId.MenuCmd_ChartLegendAtTopCommand": "Добавить легенду сверху",
  "XtraSpreadsheetStringId.MenuCmd_ChartLegendAtTopCommandDescription": "Добавить легенду и выровнять по верхнему краю.",
  "XtraSpreadsheetStringId.MenuCmd_ChartLegendCommandGroup": "Легенда",
  "XtraSpreadsheetStringId.MenuCmd_ChartLegendCommandGroupDescription": "Добавление, удаление или размещение легенды диаграммы.",
  "XtraSpreadsheetStringId.MenuCmd_ChartLegendNoneCommand": "Нет",
  "XtraSpreadsheetStringId.MenuCmd_ChartLegendNoneCommandDescription": "Не добавлять легенду.",
  "XtraSpreadsheetStringId.MenuCmd_ChartLegendOverlayAtLeftCommand": "Добавить легенду слева с перекрытием",
  "XtraSpreadsheetStringId.MenuCmd_ChartLegendOverlayAtLeftCommandDescription": "Добавить легенду слева от диаграммы без изменения размера.",
  "XtraSpreadsheetStringId.MenuCmd_ChartLegendOverlayAtRightCommand": "Добавить легенду справа с перекрытием",
  "XtraSpreadsheetStringId.MenuCmd_ChartLegendOverlayAtRightCommandDescription": "Добавить легенду справа от диаграммы без изменения размера.",
  "XtraSpreadsheetStringId.MenuCmd_ChartLinesCommandGroup": "Линии",
  "XtraSpreadsheetStringId.MenuCmd_ChartLinesCommandGroupDescription": "Добавление линий проекции и коридора колебания к диаграмме.",
  "XtraSpreadsheetStringId.MenuCmd_ChartLinesNoneCommand": "Нет",
  "XtraSpreadsheetStringId.MenuCmd_ChartLinesNoneCommandDescription": "Не показывать линии проекции, коридор колебания и линии ряда данных.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisCommandGroup": "Основная горизонтальная",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisCommandGroupDescription": " ",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisDefaultCommand": "По умолчанию",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisDefaultCommandDescription": "Разместить подписи на оси в используемом по умолчанию порядке.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisHideLabelsCommand": "Без подписей",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisHideLabelsCommandDescription": "Не отображать на оси ни подписи, ни деления.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisLeftToRightCommand": "Слева направо",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisLeftToRightCommandDescription": "Разместить подписи на оси слева направо.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisRightToLeftCommand": "Справа налево",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisRightToLeftCommandDescription": "Разместить подписи на оси справа налево.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisScaleBillionsCommand": "Миллиарды",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisScaleBillionsCommandDescription": "Показывать значения на оси в миллиардах.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisScaleLogarithmCommand": "Логарифмическая шкала",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisScaleLogarithmCommandDescription": "Показывать значения на оси в логарифмическом масштабе по основанию 10.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisScaleMillionsCommand": "Миллионы",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisScaleMillionsCommandDescription": "Показывать значения на оси в миллионах.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisScaleThousandsCommand": "Тысячи",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisScaleThousandsCommandDescription": "Показывать значения на оси в тысячах.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisTitleBelowCommand": "Название под осью",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisTitleBelowCommandDescription": "Размещение названия под горизонтальной осью с соответствующим изменением размеров диаграммы.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisTitleCommandGroup": "Название основной горизонтальной оси",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisTitleCommandGroupDescription": " ",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisTitleNoneCommand": "Нет",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalAxisTitleNoneCommandDescription": "Не показывать название оси",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalGridlinesCommandGroup": "Горизонтальные линии сетки по основной оси",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalGridlinesCommandGroupDescription": " ",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalGridlinesMajorAndMinorCommand": "Основные и промежуточные линии сетки",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalGridlinesMajorAndMinorCommandDescription": "Показать горизонтальные линии сетки для основных и промежуточных делений.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalGridlinesMajorCommand": "Основные линии сетки",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalGridlinesMajorCommandDescription": "Показать горизонтальные линии сетки для основных делений.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalGridlinesMinorCommand": "Вспомогательные линии сетки",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalGridlinesMinorCommandDescription": "Показать горизонтальные линии сетки для промежуточных делений.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalGridlinesNoneCommand": "Нет",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryHorizontalGridlinesNoneCommandDescription": "Не показывать горизонтальные линии сетки.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisCommandGroup": "Основная вертикальная",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisCommandGroupDescription": " ",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisDefaultCommand": "По умолчанию",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisDefaultCommandDescription": "Разместить подписи на оси в используемом по умолчанию порядке.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisHideLabelsCommand": "Без подписей",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisHideLabelsCommandDescription": "Не отображать на оси ни подписи, ни деления.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisLeftToRightCommand": "Слева направо",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisLeftToRightCommandDescription": "Разместить подписи на оси слева направо.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisRightToLeftCommand": "Справа налево",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisRightToLeftCommandDescription": "Разместить подписи на оси справа налево.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisScaleBillionsCommand": "Миллиарды",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisScaleBillionsCommandDescription": "Показывать значения на оси в миллиардах.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisScaleLogarithmCommand": "Логарифмическая шкала",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisScaleLogarithmCommandDescription": "Показывать значения на оси в логарифмическом масштабе по основанию 10.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisScaleMillionsCommand": "Миллионы",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisScaleMillionsCommandDescription": "Показывать значения на оси в миллионах.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisScaleThousandsCommand": "Тысячи",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisScaleThousandsCommandDescription": "Показывать значения на оси в тысячах.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisTitleCommandGroup": "Название основной вертикальной оси",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisTitleCommandGroupDescription": " ",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisTitleHorizontalCommand": "Горизонтальное название",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisTitleHorizontalCommandDescription": "Размещение названия оси горизонтально с соответствующим изменением размеров диаграммы.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisTitleNoneCommand": "Нет",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisTitleNoneCommandDescription": "Не показывать название оси",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisTitleRotatedCommand": "Повернутое название",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisTitleRotatedCommandDescription": "Размещение повернутого названия оси с соответствующим изменением размеров диаграммы.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisTitleVerticalCommand": "Вертикальное название",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalAxisTitleVerticalCommandDescription": "Использование вертикального текста в названии оси с соответствующим изменением размеров диаграммы.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalGridlinesCommandGroup": "Вертикальные линии сетки по основной оси",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalGridlinesCommandGroupDescription": " ",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalGridlinesMajorAndMinorCommand": "Основные и промежуточные линии сетки",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalGridlinesMajorAndMinorCommandDescription": "Показать горизонтальные линии сетки для основных и промежуточных делений.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalGridlinesMajorCommand": "Основные линии сетки",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalGridlinesMajorCommandDescription": "Показать горизонтальные линии сетки для основных делений.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalGridlinesMinorCommand": "Вспомогательные линии сетки",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalGridlinesMinorCommandDescription": "Показать горизонтальные линии сетки для промежуточных делений.",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalGridlinesNoneCommand": "Нет",
  "XtraSpreadsheetStringId.MenuCmd_ChartPrimaryVerticalGridlinesNoneCommandDescription": "Не показывать горизонтальные линии сетки.",
  "XtraSpreadsheetStringId.MenuCmd_ChartSelectData": "Выбрать данные",
  "XtraSpreadsheetStringId.MenuCmd_ChartSelectDataContextMenuItem": "Выбрать данные...",
  "XtraSpreadsheetStringId.MenuCmd_ChartSelectDataDescription": "Изменение диапазона данных, представленных на диаграмме.",
  "XtraSpreadsheetStringId.MenuCmd_ChartShowDropLinesAndHighLowLinesCommand": "Линии проекции и коридор колебания",
  "XtraSpreadsheetStringId.MenuCmd_ChartShowDropLinesAndHighLowLinesCommandDescription": "Показывать линии проекции и коридор колебания на двумерном графике.",
  "XtraSpreadsheetStringId.MenuCmd_ChartShowDropLinesCommand": "Линии проекции",
  "XtraSpreadsheetStringId.MenuCmd_ChartShowDropLinesCommandDescription": "Показывать линии проекции на диаграмме с областями или графике.",
  "XtraSpreadsheetStringId.MenuCmd_ChartShowHighLowLinesCommand": "Коридор колебания",
  "XtraSpreadsheetStringId.MenuCmd_ChartShowHighLowLinesCommandDescription": "Показывать коридор колебания на двумерном графике.",
  "XtraSpreadsheetStringId.MenuCmd_ChartShowSeriesLinesCommand": "Линии ряда",
  "XtraSpreadsheetStringId.MenuCmd_ChartShowSeriesLinesCommandDescription": "Показывать линии ряда данных на двумерной гистограмме, линейчатой диаграмме или круговой диаграмме.",
  "XtraSpreadsheetStringId.MenuCmd_ChartShowUpDownBarsCommand": "Полосы повышения/понижения",
  "XtraSpreadsheetStringId.MenuCmd_ChartShowUpDownBarsCommandDescription": "Показывать полосы повышения/понижения на графике.",
  "XtraSpreadsheetStringId.MenuCmd_ChartSwitchRowColumnCommand": "Строка/ столбец",
  "XtraSpreadsheetStringId.MenuCmd_ChartSwitchRowColumnCommandDescription": "Взаимная замена данных на осях.\n\nДанные, отложенные по оси X, перемещаются на ось Y, и наоборот.",
  "XtraSpreadsheetStringId.MenuCmd_ChartTitleAboveCommand": "Над диаграммой",
  "XtraSpreadsheetStringId.MenuCmd_ChartTitleAboveCommandDescription": "Размещение названия вверху области диаграммы с соответствующим изменением размеров диаграммы.",
  "XtraSpreadsheetStringId.MenuCmd_ChartTitleCenteredOverlayCommand": "Название по центру с перекрытием",
  "XtraSpreadsheetStringId.MenuCmd_ChartTitleCenteredOverlayCommandDescription": "Выравнивание названия по центру диаграммы без изменения размеров диаграммы.",
  "XtraSpreadsheetStringId.MenuCmd_ChartTitleCommandGroup": "Название диаграммы",
  "XtraSpreadsheetStringId.MenuCmd_ChartTitleCommandGroupDescription": "Добавление, удаление или размещение названия диаграммы.",
  "XtraSpreadsheetStringId.MenuCmd_ChartTitleNoneCommand": "Нет",
  "XtraSpreadsheetStringId.MenuCmd_ChartTitleNoneCommandDescription": "Не показывать название диаграммы.",
  "XtraSpreadsheetStringId.MenuCmd_ChartUpDownBarsCommandGroup": "Полосы повышения/ понижения",
  "XtraSpreadsheetStringId.MenuCmd_ChartUpDownBarsCommandGroupDescription": "Добавление полос повышения/понижения к диаграмме.",
  "XtraSpreadsheetStringId.MenuCmd_ClearAllPivotTable": "Очистить все",
  "XtraSpreadsheetStringId.MenuCmd_ClearAllPivotTableDescription": "Очистить всю сводную таблицу",
  "XtraSpreadsheetStringId.MenuCmd_ClearFiltersPivotTable": "Очистить фильтры",
  "XtraSpreadsheetStringId.MenuCmd_ClearOutlineCommandCommand": "Удалить структуру",
  "XtraSpreadsheetStringId.MenuCmd_ClearOutlineCommandCommandDescription": "Ungroup all the groups in the outline.",
  "XtraSpreadsheetStringId.MenuCmd_CollapseOrExpandFormulaBar": "Collapse or expand Formula Bar",
  "XtraSpreadsheetStringId.MenuCmd_CollapseOrExpandFormulaBarDescription": "Collapse or expand Formula Bar (Ctrl+Shift+U)",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingAboveAverageRuleCommand": "Выше среднего...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingAboveAverageRuleCommandDescription": "Выше среднего...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingBelowAverageRuleCommand": "Ниже среднего...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingBelowAverageRuleCommandDescription": "Ниже среднего...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingBetweenRuleCommand": "Между...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingBetweenRuleCommandDescription": "Между...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingBottom10PercentRuleCommand": "Последние 10%...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingBottom10PercentRuleCommandDescription": "Последние 10%...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingBottom10RuleCommand": "Последние 10 элементов...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingBottom10RuleCommandDescription": "Последние 10 элементов...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleBlueWhiteRed": "Цветовая шкала \"Синий-белый-красный\"",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleBlueWhiteRedDescription": "Применение цветного градиента к диапазону ячеек. Оттенок цвета зависит от относительной величины значения по сравнению с другими ячейками в диапазоне.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleGreenWhite": "Цветовая шкала \"Зеленый-белый\"",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleGreenWhiteDescription": "Применение цветного градиента к диапазону ячеек. Оттенок цвета зависит от относительной величины значения по сравнению с другими ячейками в диапазоне.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleGreenWhiteRed": "Цветовая шкала \"Зеленый-белый-красный\"",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleGreenWhiteRedDescription": "Применение цветного градиента к диапазону ячеек. Оттенок цвета зависит от относительной величины значения по сравнению с другими ячейками в диапазоне.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleGreenYellow": "Цветовая шкала \"Зеленый-желтый\"",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleGreenYellowDescription": "Применение цветного градиента к диапазону ячеек. Оттенок цвета зависит от относительной величины значения по сравнению с другими ячейками в диапазоне.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleGreenYellowRed": "Цветовая шкала \"Зеленый-желтый-красный\"",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleGreenYellowRedDescription": "Применение цветного градиента к диапазону ячеек. Оттенок цвета зависит от относительной величины значения по сравнению с другими ячейками в диапазоне.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleRedWhite": "Цветовая шкала \"Красный-белый\"",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleRedWhiteBlue": "Цветовая шкала \"Красный-белый-синий\"",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleRedWhiteBlueDescription": "Применение цветного градиента к диапазону ячеек. Оттенок цвета зависит от относительной величины значения по сравнению с другими ячейками в диапазоне.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleRedWhiteDescription": "Применение цветного градиента к диапазону ячеек. Оттенок цвета зависит от относительной величины значения по сравнению с другими ячейками в диапазоне.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleRedWhiteGreen": "Цветовая шкала \"Красный-белый-зеленый\"",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleRedWhiteGreenDescription": "Применение цветного градиента к диапазону ячеек. Оттенок цвета зависит от относительной величины значения по сравнению с другими ячейками в диапазоне.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleRedYellowGreen": "Цветовая шкала \"Красный-желтый-зеленый\"",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleRedYellowGreenDescription": "Применение цветного градиента к диапазону ячеек. Оттенок цвета зависит от относительной величины значения по сравнению с другими ячейками в диапазоне.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScalesCommandGroup": "Цветовые шкалы",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScalesCommandGroupDescription": "Цветовые шкалы.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleWhiteGreen": "Цветовая шкала \"Белый-зеленый\"",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleWhiteGreenDescription": "Применение цветного градиента к диапазону ячеек. Оттенок цвета зависит от относительной величины значения по сравнению с другими ячейками в диапазоне.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleWhiteRed": "Цветовая шкала \"Белый-красный\"",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleWhiteRedDescription": "Применение цветного градиента к диапазону ячеек. Оттенок цвета зависит от относительной величины значения по сравнению с другими ячейками в диапазоне.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleYellowGreen": "Цветовая шкала \"Желтый-зеленый\"",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingColorScaleYellowGreenDescription": "Применение цветного градиента к диапазону ячеек. Оттенок цвета зависит от относительной величины значения по сравнению с другими ячейками в диапазоне.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingCommandGroup": "Условное форматирование",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingCommandGroupDescription": "Визуальное выделение важных значений, а также выявление тенденций и шаблонов в данных с помощью гистограмм, цветов и значков.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarGradientBlue": "Синяя гистограмма",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarGradientBlueDescription": "Добавление цветной гистограммы в ячейку. Длина столбца зависит от значения в ячейке. Более длинный столбец соответствует большему значению.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarGradientGreen": "Зеленая гистограмма",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarGradientGreenDescription": "Добавление цветной гистограммы в ячейку. Длина столбца зависит от значения в ячейке. Более длинный столбец соответствует большему значению.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarGradientLightBlue": "Голубая гистограмма",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarGradientLightBlueDescription": "Добавление цветной гистограммы в ячейку. Длина столбца зависит от значения в ячейке. Более длинный столбец соответствует большему значению.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarGradientOrange": "Оранжевая гистограмма",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarGradientOrangeDescription": "Добавление цветной гистограммы в ячейку. Длина столбца зависит от значения в ячейке. Более длинный столбец соответствует большему значению.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarGradientPurple": "Фиолетовая гистограмма",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarGradientPurpleDescription": "Добавление цветной гистограммы в ячейку. Длина столбца зависит от значения в ячейке. Более длинный столбец соответствует большему значению.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarGradientRed": "Красная гистограмма",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarGradientRedDescription": "Добавление цветной гистограммы в ячейку. Длина столбца зависит от значения в ячейке. Более длинный столбец соответствует большему значению.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarsCommandGroup": "Гистограммы",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarsCommandGroupDescription": "Гистограммы.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarsGradientFillCommandGroup": "Градиентная заливка",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarsGradientFillCommandGroupDescription": "Градиентная заливка.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarSolidBlue": "Синяя гистограмма",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarSolidBlueDescription": "Добавление цветной гистограммы в ячейку. Длина столбца зависит от значения в ячейке. Более длинный столбец соответствует большему значению.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarSolidGreen": "Зеленая гистограмма",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarSolidGreenDescription": "Добавление цветной гистограммы в ячейку. Длина столбца зависит от значения в ячейке. Более длинный столбец соответствует большему значению.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarSolidLightBlue": "Голубая гистограмма",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarSolidLightBlueDescription": "Добавление цветной гистограммы в ячейку. Длина столбца зависит от значения в ячейке. Более длинный столбец соответствует большему значению.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarSolidOrange": "Оранжевая гистограмма",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarSolidOrangeDescription": "Добавление цветной гистограммы в ячейку. Длина столбца зависит от значения в ячейке. Более длинный столбец соответствует большему значению.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarSolidPurple": "Фиолетовая гистограмма",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarSolidPurpleDescription": "Добавление цветной гистограммы в ячейку. Длина столбца зависит от значения в ячейке. Более длинный столбец соответствует большему значению.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarSolidRed": "Красная гистограмма",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarSolidRedDescription": "Добавление цветной гистограммы в ячейку. Длина столбца зависит от значения в ячейке. Более длинный столбец соответствует большему значению.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarsSolidFillCommandGroup": "Сплошная заливка",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDataBarsSolidFillCommandGroupDescription": "Сплошная заливка.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDateOccurringRuleCommand": "Дата...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDateOccurringRuleCommandDescription": "Дата...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDuplicateValuesRuleCommand": "Повторяющиеся значения...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingDuplicateValuesRuleCommandDescription": "Повторяющиеся значения...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingEqualToRuleCommand": "Равно...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingEqualToRuleCommandDescription": "Равно...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingGreaterThanRuleCommand": "Больше...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingGreaterThanRuleCommandDescription": "Больше...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingHighlightCellsRuleCommandGroup": "Правила выделения ячеек",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingHighlightCellsRuleCommandGroupDescription": "Правила выделения ячеек.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetArrows3Colored": "3 цветные стрелки",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetArrows3ColoredDescription": "Выбор набора значков для представления значений в выделенных ячейках.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetArrows3Grayed": "3 серые стрелки",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetArrows3GrayedDescription": "Выбор набора значков для представления значений в выделенных ячейках.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetArrows4Colored": "4 цветные стрелки",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetArrows4ColoredDescription": "Выбор набора значков для представления значений в выделенных ячейках.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetArrows4Grayed": "4 серые стрелки",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetArrows4GrayedDescription": "Выбор набора значков для представления значений в выделенных ячейках.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetArrows5Colored": "5 цветных стрелок",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetArrows5ColoredDescription": "Выбор набора значков для представления значений в выделенных ячейках.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetArrows5Grayed": "5 серых стрелок",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetArrows5GrayedDescription": "Выбор набора значков для представления значений в выделенных ячейках.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetBoxes5": "5 квадратиков",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetBoxes5Description": "Выбор набора значков для представления значений в выделенных ячейках.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetFlags3": "3 флага",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetFlags3Description": "Выбор набора значков для представления значений в выделенных ячейках.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetQuarters5": "5 четвертей",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetQuarters5Description": "Выбор набора значков для представления значений в выделенных ячейках.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetRatings4": "4 оценки",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetRatings4Description": "Выбор набора значков для представления значений в выделенных ячейках.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetRatings5": "5 оценок",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetRatings5Description": "Выбор набора значков для представления значений в выделенных ячейках.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetRedToBlack": "От красного до черного",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetRedToBlackDescription": "Выбор набора значков для представления значений в выделенных ячейках.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetsCommandGroup": "Наборы значков",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetsCommandGroupDescription": "Наборы значков.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetsDirectionalCommandGroup": "Направления",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetsDirectionalCommandGroupDescription": "Направления.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetSigns3": "3 знака",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetSigns3Description": "Выбор набора значков для представления значений в выделенных ячейках.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetsIndicatorsCommandGroup": "Индикаторы",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetsIndicatorsCommandGroupDescription": "Индикаторы.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetsRatingsCommandGroup": "Оценки",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetsRatingsCommandGroupDescription": "Оценки.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetsShapesCommandGroup": "Фигуры",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetsShapesCommandGroupDescription": "Фигуры.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetStars3": "3 звезды",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetStars3Description": "Выбор набора значков для представления значений в выделенных ячейках.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetSymbols3": "3 символа без кружков",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetSymbols3Circled": "3 символа в кружках",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetSymbols3CircledDescription": "Выбор набора значков для представления значений в выделенных ячейках.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetSymbols3Description": "Выбор набора значков для представления значений в выделенных ячейках.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetTrafficLights3": "3 сигнала светофора без обрамления",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetTrafficLights3Description": "Выбор набора значков для представления значений в выделенных ячейках.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetTrafficLights3Rimmed": "3 сигнала светофора с обрамлением",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetTrafficLights3RimmedDescription": "Выбор набора значков для представления значений в выделенных ячейках.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetTrafficLights4": "4 сигнала светофора",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetTrafficLights4Description": "Выбор набора значков для представления значений в выделенных ячейках.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetTriangles3": "3 треугольника",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingIconSetTriangles3Description": "Выбор набора значков для представления значений в выделенных ячейках.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingLessThanRuleCommand": "Меньше...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingLessThanRuleCommandDescription": "Меньше...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingRemove": "Удалить правила из выделенных ячеек",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingRemoveCommandGroup": "Удалить правила",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingRemoveCommandGroupDescription": "Удалить правила.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingRemoveDescription": "Удалить правила из выделенных ячеек.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingRemoveFromSheet": "Удалить правила со всего листа",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingRemoveFromSheetDescription": "Удалить правила со всего листа.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingRulesManager": "Управление правилами...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingRulesManagerDescription": "Создание, изменение, удаление и просмотр всех правил условного форматирования в книге с помощью диспетчера правил условного форматирования.",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingTextContainsRuleCommand": "Текст содержит...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingTextContainsRuleCommandDescription": "Текст содержит...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingTop10PercentRuleCommand": "Первые 10%...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingTop10PercentRuleCommandDescription": "Первые 10%...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingTop10RuleCommand": "Первые 10 элементов...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingTop10RuleCommandDescription": "Первые 10 элементов...",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingTopBottomRuleCommandGroup": "Правила отбора первых и последних значений",
  "XtraSpreadsheetStringId.MenuCmd_ConditionalFormattingTopBottomRuleCommandGroupDescription": "Правила отбора первых и последних значений.",
  "XtraSpreadsheetStringId.MenuCmd_CountInfoStatusBarCommandCaptionPart": "КОЛИЧЕСТВО:",
  "XtraSpreadsheetStringId.MenuCmd_CountInfoStatusBarCommandDescription": "Количество значений в выделенном фрагменте, которые содержат данные",
  "XtraSpreadsheetStringId.MenuCmd_CreateDefinedNamesFromSelection": "Создать из выделенного",
  "XtraSpreadsheetStringId.MenuCmd_CreateDefinedNamesFromSelectionDescription": "Автоматическое создание имен для выделенных ячеек.\n\nБольшинство пользователей предпочитает использовать текст в верхней строке крайнего левого столбца выделения.",
  "XtraSpreadsheetStringId.MenuCmd_DataFieldSettingsPivotTableContextMenuItem": "Параметры полей значений...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterAboveAverage": "Выше среднего",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterAboveAverageDescription": "Выше среднего.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterAllDatesInPeriodFilters": "Все даты за период",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterAllDatesInPeriodFiltersDescription": "Все даты за период.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterBeginsWith": "начинается с...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterBeginsWithDescription": "начинается с...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterBelowAverage": "Ниже среднего",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterBelowAverageDescription": "Ниже среднего.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterBetween": "между...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterBetweenDescription": "между...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterBlanks": "(Пустые)",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterClear": "Очистить",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterClearDescription": "Очистка фильтра и состояния сортировки для текущего диапазона данных.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterColumnClear": "Удалить фильтр из столбца '{0}'",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterColumnClearDescription": "Удалить фильтр из столбца '{0}'.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterContains": "содержит...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterContainsDescription": "содержит...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterCustom": "Настраиваемый фильтр...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterCustomDescription": "Настраиваемый фильтр...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterDateAfter": "После...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterDateAfterDescription": "После...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterDateBefore": "До...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterDateBeforeDescription": "До...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterDateBetween": "между...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterDateBetweenDescription": "между...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterDateCustom": "Настраиваемый фильтр...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterDateCustomDescription": "Настраиваемый фильтр...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterDateEquals": "равно...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterDateEqualsDescription": "равно...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterDateFilters": "Фильтры по дате",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterDateFiltersDescription": "Фильтры по дате.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterDoesNotContain": "не содержит...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterDoesNotContainDescription": "не содержит...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterDoesNotEqual": "не равно...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterDoesNotEqualDescription": "не равно...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterEndsWith": "заканчивается на...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterEndsWithDescription": "заканчивается на...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterEquals": "равно...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterEqualsDescription": "равно...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterGreaterThan": "больше...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterGreaterThanDescription": "больше...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterGreaterThanOrEqualTo": "больше или равно...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterGreaterThanOrEqualToDescription": "больше или равно...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterLastMonth": "В прошлом месяце",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterLastMonthDescription": "В прошлом месяце.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterLastQuarter": "В прошлом квартале",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterLastQuarterDescription": "В прошлом квартале.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterLastWeek": "На прошлой неделе",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterLastWeekDescription": "На прошлой неделе.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterLastYear": "В прошлом году",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterLastYearDescription": "В прошлом году.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterLessThan": "меньше...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterLessThanDescription": "меньше...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterLessThanOrEqualTo": "меньше или равно...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterLessThanOrEqualToDescription": "меньше или равно...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterMonth": "{0}",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterMonthDescription": "{0}.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterNextMonth": "В следующем месяце",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterNextMonthDescription": "В следующем месяце.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterNextQuarter": "В следующем квартале",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterNextQuarterDescription": "В следующем квартале.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterNextWeek": "На следующей неделе",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterNextWeekDescription": "На следующей неделе.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterNextYear": "В следующем году",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterNextYearDescription": "В следующем году.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterNumberFilters": "Числовые фильтры",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterNumberFiltersDescription": "Числовые фильтры.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterQuarter": "Квартал {0}",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterQuarterDescription": "Квартал {0}.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterReApply": "Повторить",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterReApplyDescription": "Повторное применение фильтра и сортировки к текущему диапазону, чтобы включить внесенные вами изменения.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterSimple": "Фильтр по значению...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterSimpleDescription": "Фильтр по значению...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterTextFilters": "Текстовые фильтры",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterTextFiltersDescription": "Текстовые фильтры.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterThisMonth": "В этом месяце",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterThisMonthDescription": "В этом месяце.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterThisQuarter": "В этом квартале",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterThisQuarterDescription": "В этом квартале.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterThisWeek": "На этой неделе",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterThisWeekDescription": "На этой неделе.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterThisYear": "В этом году",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterThisYearDescription": "В этом году.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterToday": "Сегодня",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterTodayDescription": "Сегодня.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterToggle": "Фильтр",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterToggleDescription": "Применение фильтра к выделенным ячейкам.\n\nЕсли фильтрация включена, достаточно щелкнуть стрелку в заголовке столбца, чтобы выбрать для него фильтр.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterTomorrow": "Завтра",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterTomorrowDescription": "Завтра.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterTop10": "Первые 10...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterTop10Description": "Первые 10...",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterYearToDate": "С начала года",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterYearToDateDescription": "С начала года.",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterYesterday": "Вчера",
  "XtraSpreadsheetStringId.MenuCmd_DataFilterYesterdayDescription": "Вчера.",
  "XtraSpreadsheetStringId.MenuCmd_DataValidation": "Проверка данных",
  "XtraSpreadsheetStringId.MenuCmd_DataValidationCircleInvalidData": "Обвести неверные данные",
  "XtraSpreadsheetStringId.MenuCmd_DataValidationCircleInvalidDataDescription": "Обвести кругами неверные данные.",
  "XtraSpreadsheetStringId.MenuCmd_DataValidationClearValidationCircle": "Удалить обводку неверных данных",
  "XtraSpreadsheetStringId.MenuCmd_DataValidationClearValidationCircleDescription": "Удалить обводку неверных данных.",
  "XtraSpreadsheetStringId.MenuCmd_DataValidationDescription": "Ограничение типов данных, которые можно ввести в ячейку, путем выбора правил из списка.\n\nНапример, вы можете составить список значений, содержащий числа 1, 2 и 3, или разрешить вводить в ячейку только числа больше 1000.",
  "XtraSpreadsheetStringId.MenuCmd_DefineNameCommand": "Присвоить имя",
  "XtraSpreadsheetStringId.MenuCmd_DefineNameCommandDescription": "Присвоение имен отдельным ячейкам и диапазонам ячеек.\n\nВ дальнейшем можно будет ссылаться на них в формулах по данному имени.\n\nНапример, диапазону ячеек A20:A40 можно присвоить имя \"Затраты\". Использование имен в формулах делает формулы более понятными.",
  "XtraSpreadsheetStringId.MenuCmd_DefineNameCommandGroup": "Присвоить имя",
  "XtraSpreadsheetStringId.MenuCmd_DefineNameCommandGroupDescription": "Присвоение имен отдельным ячейкам и диапазонам ячеек.\n\nВ дальнейшем можно будет ссылаться на них в формулах по данному имени.\n\nНапример, диапазону ячеек A20:A40 можно присвоить имя \"Затраты\". Использование имен в формулах делает формулы более понятными.",
  "XtraSpreadsheetStringId.MenuCmd_EditingFillCommandGroup": "Заполнить",
  "XtraSpreadsheetStringId.MenuCmd_EditingFillCommandGroupDescription": "Распространение узора на одну или несколько соседних ячеек.\n    \nЯчейки можно заполнять в любом направлении, распространяя узор на любой диапазон соседних ячеек.",
  "XtraSpreadsheetStringId.MenuCmd_EditingFillDown": "Заполнить вниз",
  "XtraSpreadsheetStringId.MenuCmd_EditingFillDownDescription": "Распространение узора на одну или несколько ячеек вниз.",
  "XtraSpreadsheetStringId.MenuCmd_EditingFillLeft": "Заполнить влево",
  "XtraSpreadsheetStringId.MenuCmd_EditingFillLeftDescription": "Распространение узора на одну или несколько ячеек влево.",
  "XtraSpreadsheetStringId.MenuCmd_EditingFillRight": "Заполнить вправо",
  "XtraSpreadsheetStringId.MenuCmd_EditingFillRightDescription": "Распространение узора на одну или несколько ячеек вправо.",
  "XtraSpreadsheetStringId.MenuCmd_EditingFillUp": "Заполнить вверх",
  "XtraSpreadsheetStringId.MenuCmd_EditingFillUpDescription": "Распространение узора на одну или несколько ячеек вверх.",
  "XtraSpreadsheetStringId.MenuCmd_EditingFind": "Найти",
  "XtraSpreadsheetStringId.MenuCmd_EditingFindAndSelectCommandGroup": "Найти и выделить",
  "XtraSpreadsheetStringId.MenuCmd_EditingFindAndSelectCommandGroupDescription": "Щелкните, чтобы просмотреть параметры поиска текста в документе.\n\nВы можете воспользоваться дополнительными параметрами поиска для замены текста, перехода в определенное место документа или выбора других вариантов сужения поиска.",
  "XtraSpreadsheetStringId.MenuCmd_EditingFindDescription": "Поиск и выделение нужного текста, форматирования или типа сведений в документе.",
  "XtraSpreadsheetStringId.MenuCmd_EditingMailMergeMasterDetailCommandGroup": "Master-Detail",
  "XtraSpreadsheetStringId.MenuCmd_EditingMailMergeMasterDetailCommandGroupDescription": "Create a multi-level detail.",
  "XtraSpreadsheetStringId.MenuCmd_EditingMergeAndCenterCells": "Объединить и выровнять по центру",
  "XtraSpreadsheetStringId.MenuCmd_EditingMergeAndCenterCellsDescription": "Объединение выделенных ячеек в одну большую ячейку и выравнивание содержимого новой ячейки по центру.\n    \nЧасто используется для создания заголовка, общего для нескольких столбцов.",
  "XtraSpreadsheetStringId.MenuCmd_EditingMergeCells": "Объединить ячейки",
  "XtraSpreadsheetStringId.MenuCmd_EditingMergeCellsAcross": "Объединить по строкам",
  "XtraSpreadsheetStringId.MenuCmd_EditingMergeCellsAcrossDescription": "Объединение каждой строки выделенных ячеек в одну большую ячейку.",
  "XtraSpreadsheetStringId.MenuCmd_EditingMergeCellsCommandGroup": "Объединить ячейки",
  "XtraSpreadsheetStringId.MenuCmd_EditingMergeCellsCommandGroupDescription": "Щелкните здесь, чтобы объединить несколько ячеек либо разделить объединенную ячейку на составляющие ее ячейки.",
  "XtraSpreadsheetStringId.MenuCmd_EditingMergeCellsDescription": "Объединение выделенных ячеек в одну ячейку.",
  "XtraSpreadsheetStringId.MenuCmd_EditingReplace": "Заменить",
  "XtraSpreadsheetStringId.MenuCmd_EditingReplaceDescription": "Поиск и выделение нужного текста, форматирования или типа сведений в документе. \n\nМожно также заменить найденное новым текстом или форматированием.",
  "XtraSpreadsheetStringId.MenuCmd_EditingSelectComments": "Примечания",
  "XtraSpreadsheetStringId.MenuCmd_EditingSelectCommentsDescription": "Перейти к примечаниям",
  "XtraSpreadsheetStringId.MenuCmd_EditingSelectConditionalFormatting": "Условное форматирование",
  "XtraSpreadsheetStringId.MenuCmd_EditingSelectConditionalFormattingDescription": "Перейти к условному форматированию",
  "XtraSpreadsheetStringId.MenuCmd_EditingSelectConstants": "Константы",
  "XtraSpreadsheetStringId.MenuCmd_EditingSelectConstantsDescription": "Перейти к константам",
  "XtraSpreadsheetStringId.MenuCmd_EditingSelectDataValidation": "Проверка данных",
  "XtraSpreadsheetStringId.MenuCmd_EditingSelectDataValidationDescription": "Перейти к проверке данных",
  "XtraSpreadsheetStringId.MenuCmd_EditingSelectFormulas": "Формулы",
  "XtraSpreadsheetStringId.MenuCmd_EditingSelectFormulasDescription": "Перейти к формулам",
  "XtraSpreadsheetStringId.MenuCmd_EditingSortAndFilterCommandGroup": "Сортировка и фильтр",
  "XtraSpreadsheetStringId.MenuCmd_EditingSortAndFilterCommandGroupDescription": "Упорядочение данных для упрощение их анализа.\n\nВы можете упорядочить выделенные данные от меньших к большим, от больших к меньшим или отфильтровать отдельные значения.",
  "XtraSpreadsheetStringId.MenuCmd_EditingUnmergeCells": "Отменить объединение ячеек",
  "XtraSpreadsheetStringId.MenuCmd_EditingUnmergeCellsDescription": "Разбиение выделенных ячеек на несколько новых ячеек.",
  "XtraSpreadsheetStringId.MenuCmd_FieldListPanelPivotTable": "Список полей",
  "XtraSpreadsheetStringId.MenuCmd_FieldListPanelPivotTableDescription": "Отображение или скрытие списка полей.\n\nСписок полей позволяет добавлять поля в отчет сводной таблицы и удалять их из него.",
  "XtraSpreadsheetStringId.MenuCmd_FieldSettingsPivotTableContextMenuItem": "Параметры поля...",
  "XtraSpreadsheetStringId.MenuCmd_FormatAlignmentBottom": "По нижнему краю",
  "XtraSpreadsheetStringId.MenuCmd_FormatAlignmentBottomDescription": "Выравнивание текста по нижнему краю ячейки.",
  "XtraSpreadsheetStringId.MenuCmd_FormatAlignmentMiddle": "По середине",
  "XtraSpreadsheetStringId.MenuCmd_FormatAlignmentMiddleDescription": "Выравнивание текста по центру между верхней и нижней границами ячейки.",
  "XtraSpreadsheetStringId.MenuCmd_FormatAlignmentTop": "По верхнему краю",
  "XtraSpreadsheetStringId.MenuCmd_FormatAlignmentTopDescription": "Выравнивание текста по верхнему краю ячейки.",
  "XtraSpreadsheetStringId.MenuCmd_FormatAllBorders": "Все границы",
  "XtraSpreadsheetStringId.MenuCmd_FormatAllBordersDescription": "Изменение всех границ.",
  "XtraSpreadsheetStringId.MenuCmd_FormatAsTable": "Форматировать как таблицу",
  "XtraSpreadsheetStringId.MenuCmd_FormatAsTableDescription": "Быстрое преобразование диапазона ячеек в таблицу с применением определенного стиля.",
  "XtraSpreadsheetStringId.MenuCmd_FormatAutoFitColumnWidth": "Автоподбор ширины столбца",
  "XtraSpreadsheetStringId.MenuCmd_FormatAutoFitColumnWidthDescription": "Автоподбор ширины столбца.",
  "XtraSpreadsheetStringId.MenuCmd_FormatAutoFitRowHeight": "Автоподбор высоты строки",
  "XtraSpreadsheetStringId.MenuCmd_FormatAutoFitRowHeightDescription": "Автоподбор высоты строки.",
  "XtraSpreadsheetStringId.MenuCmd_FormatBorderColor": "Цвет границы",
  "XtraSpreadsheetStringId.MenuCmd_FormatBorderColorDescription": "Изменение цвета границы.",
  "XtraSpreadsheetStringId.MenuCmd_FormatBorderLineStyle": "Вид линии",
  "XtraSpreadsheetStringId.MenuCmd_FormatBorderLineStyleDescription": "Изменение типа линии, используемой для рисования границ.",
  "XtraSpreadsheetStringId.MenuCmd_FormatBordersCommandGroup": "Границы",
  "XtraSpreadsheetStringId.MenuCmd_FormatBordersCommandGroupDescription": "Изменение границ выделенных ячеек.",
  "XtraSpreadsheetStringId.MenuCmd_FormatBottomBorder": "Нижняя граница",
  "XtraSpreadsheetStringId.MenuCmd_FormatBottomBorderDescription": "Изменение нижней границы.",
  "XtraSpreadsheetStringId.MenuCmd_FormatBottomDoubleBorder": "Сдвоенная нижняя граница",
  "XtraSpreadsheetStringId.MenuCmd_FormatBottomDoubleBorderDescription": "Изменение нижней границы.",
  "XtraSpreadsheetStringId.MenuCmd_FormatBottomThickBorder": "Толстая нижняя граница",
  "XtraSpreadsheetStringId.MenuCmd_FormatBottomThickBorderDescription": "Изменение нижней границы.",
  "XtraSpreadsheetStringId.MenuCmd_FormatCellsAlignment": "Формат ячеек: выравнивание",
  "XtraSpreadsheetStringId.MenuCmd_FormatCellsAlignmentDescription": "Вывод вкладки \"Выравнивание\" диалогового окна \"Формат ячеек\".",
  "XtraSpreadsheetStringId.MenuCmd_FormatCellsBorder": "Format Cells: Border",
  "XtraSpreadsheetStringId.MenuCmd_FormatCellsBorderDescription": "Show the Border tab of the Format Cells dialog box.",
  "XtraSpreadsheetStringId.MenuCmd_FormatCellsContextMenuItem": "Формат ячеек...",
  "XtraSpreadsheetStringId.MenuCmd_FormatCellsContextMenuItemDescription": "Открытие диалогового окна \"Формат ячеек\".",
  "XtraSpreadsheetStringId.MenuCmd_FormatCellsFill": "Format Cells: Fill",
  "XtraSpreadsheetStringId.MenuCmd_FormatCellsFillDescription": "Show the Fill tab of the Format Cells dialog box.",
  "XtraSpreadsheetStringId.MenuCmd_FormatCellsFont": "Формат ячеек: шрифт",
  "XtraSpreadsheetStringId.MenuCmd_FormatCellsFontDescription": "Отображение вкладки \"Шрифт\" диалогового окна \"Формат ячеек\".",
  "XtraSpreadsheetStringId.MenuCmd_FormatCellsNumber": "Формат ячеек: число",
  "XtraSpreadsheetStringId.MenuCmd_FormatCellsNumberDescription": "Отображение вкладки \"Число\" диалогового окна \"Формат ячеек\".",
  "XtraSpreadsheetStringId.MenuCmd_FormatCellsProtection": "Format Cells: Protection",
  "XtraSpreadsheetStringId.MenuCmd_FormatCellsProtectionDescription": "Show the Protection tab of the Format Cells dialog box.",
  "XtraSpreadsheetStringId.MenuCmd_FormatCellStyle": "Стили ячеек",
  "XtraSpreadsheetStringId.MenuCmd_FormatCellStyleDescription": "Быстрое форматирование ячейки с помощью выбора одного из предварительно определенных стилей.\n    \nМожно также определить пользовательские стили ячеек.",
  "XtraSpreadsheetStringId.MenuCmd_FormatClearAll": "Очистить все",
  "XtraSpreadsheetStringId.MenuCmd_FormatClearAllDescription": "Полная очистка выделенных ячеек.\n    \nИз выделенных ячеек удаляется все содержимое, форматирование и примечания.",
  "XtraSpreadsheetStringId.MenuCmd_FormatClearCommandGroup": "Очистить",
  "XtraSpreadsheetStringId.MenuCmd_FormatClearCommandGroupDescription": "Удаление всего, что содержится в ячейке, либо выборочное удаление форматирования, содержимого или примечаний.",
  "XtraSpreadsheetStringId.MenuCmd_FormatClearComments": "Очистить примечания",
  "XtraSpreadsheetStringId.MenuCmd_FormatClearCommentsDescription": "Очистка всех примечаний, присоединенных к выделенным ячейкам.",
  "XtraSpreadsheetStringId.MenuCmd_FormatClearContents": "Очистить содержимое",
  "XtraSpreadsheetStringId.MenuCmd_FormatClearContentsDescription": "Очистка только содержимого выделенных ячеек.\n    \nФорматирование и примечания не удаляются.",
  "XtraSpreadsheetStringId.MenuCmd_FormatClearFormats": "Очистить форматы",
  "XtraSpreadsheetStringId.MenuCmd_FormatClearFormatsDescription": "Очистка только форматирования, примененного к выделенным ячейкам.",
  "XtraSpreadsheetStringId.MenuCmd_FormatClearHyperlinks": "Очистить гиперссылки",
  "XtraSpreadsheetStringId.MenuCmd_FormatClearHyperlinksDescription": "Очистка гиперссылок из выделенных ячеек.\n\nФорматирование не удаляется.",
  "XtraSpreadsheetStringId.MenuCmd_FormatColumnWidth": "Ширина столбца...",
  "XtraSpreadsheetStringId.MenuCmd_FormatColumnWidthDescription": "Открытие диалогового окна \"Ширина столбца\".",
  "XtraSpreadsheetStringId.MenuCmd_FormatCommandGroup": "Формат",
  "XtraSpreadsheetStringId.MenuCmd_FormatCommandGroupDescription": "Изменение высоты строки или ширины столбца, организация листов, защита или скрытие ячеек.",
  "XtraSpreadsheetStringId.MenuCmd_FormatDecreaseIndent": "Уменьшить отступ",
  "XtraSpreadsheetStringId.MenuCmd_FormatDecreaseIndentDescription": "Уменьшение поля между границей и текстом ячейки.",
  "XtraSpreadsheetStringId.MenuCmd_FormatDefaultColumnWidth": "Ширина по умолчанию...",
  "XtraSpreadsheetStringId.MenuCmd_FormatDefaultColumnWidthDescription": "Открытие диалогового окна \"Ширина по умолчанию\".",
  "XtraSpreadsheetStringId.MenuCmd_FormatFillColor": "Цвет заливки",
  "XtraSpreadsheetStringId.MenuCmd_FormatFillColorDescription": "Изменение цвета фона выделенных ячеек.",
  "XtraSpreadsheetStringId.MenuCmd_FormatIncreaseIndent": "Увеличить отступ",
  "XtraSpreadsheetStringId.MenuCmd_FormatIncreaseIndentDescription": "Увеличение поля между границей и текстом ячейки.",
  "XtraSpreadsheetStringId.MenuCmd_FormatLeftBorder": "Левая граница",
  "XtraSpreadsheetStringId.MenuCmd_FormatLeftBorderDescription": "Изменение левой границы.",
  "XtraSpreadsheetStringId.MenuCmd_FormatNoBorders": "Без границ",
  "XtraSpreadsheetStringId.MenuCmd_FormatNoBordersDescription": "Изменение границ.",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumber": "Числовой формат",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberAccounting": "Финансовый",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberAccountingCommandGroup": "Финансовый числовой формат",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberAccountingCommandGroupDescription": "Выбор формата денежной единицы (например, доллары или евро).",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberAccountingCurrency": "Денежный",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberAccountingCurrencyDescription": "Отображения значения ячейки в денежном формате.",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberAccountingDefaultDescription": "This will change the format of the cell to Accounting with a '{0}' as currency symbol.",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberAccountingDescription": "Отображения значения ячейки в финансовом формате.",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberAccountingEuro": "€ Евро",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberAccountingEuroDescription": "€ Евро.",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberAccountingPRC": "¥ китайский (КНР)",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberAccountingPRCDescription": "¥ китайский (КНР).",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberAccountingSwiss": "fr. французский (Швейцария)",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberAccountingSwissDescription": "fr. французский (Швейцария).",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberAccountingUK": "£ английский (Соединенное Королевство)",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberAccountingUKDescription": "£ английский (Соединенное Королевство).",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberAccountingUS": "$ английский (США)",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberAccountingUSDescription": "$ английский (США).",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberCommaStyle": "Формат с разделителями",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberCommaStyleDescription": "Использование разделителя тысяч при отображении значения ячейки.\n    \nФормат ячейки изменится на финансовый без обозначения денежной единицы.",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberDecimal": "Числовой",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberDecimalDescription": "Отображения значения ячейки в виде десятичного числа.",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberDecreaseDecimal": "Уменьшить разрядность",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberDecreaseDecimalDescription": "Отображение менее точных значений путем уменьшения числа знаков после запятой.",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberDescription": "Выбор формата отображения значений в ячейке: в процентах, как денежной единицы, как даты или времени и т. д.",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberFraction": "Дробный",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberFractionDescription": "Отображения значения ячейки в дробном формате.",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberGeneral": "Общий",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberGeneralDescription": "Формат не указан.",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberIncreaseDecimal": "Увеличить разрядность",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberIncreaseDecimalDescription": "Отображение более точных значений путем увеличения числа знаков после запятой.",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberLongDate": "Длинный формат даты",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberLongDateDescription": "Отображения значения ячейки в длинном формате даты.",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberPercent": "Процентный формат",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberPercentage": "Процентный",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberPercentageDescription": "Отображение значения ячейки в виде процента.",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberPercentDescription": "Отображение значения ячейки в виде процента.",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberScientific": "Экспоненциальный",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberScientificDescription": "Отображения значения ячейки в экспоненциальном формате.",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberShortDate": "Краткий формат даты",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberShortDateDescription": "Отображения значения ячейки в кратком формате даты.",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberText": "Текстовый",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberTextDescription": "Отображения значения ячейки в текстовом формате.",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberTime": "Время",
  "XtraSpreadsheetStringId.MenuCmd_FormatNumberTimeDescription": "Отображения значения ячейки в формате времени.",
  "XtraSpreadsheetStringId.MenuCmd_FormatOutsideBorders": "Внешние границы",
  "XtraSpreadsheetStringId.MenuCmd_FormatOutsideBordersDescription": "Изменение внешних границ.",
  "XtraSpreadsheetStringId.MenuCmd_FormatRemoveHyperlinks": "Удалить гиперссылки",
  "XtraSpreadsheetStringId.MenuCmd_FormatRemoveHyperlinksDescription": "Удаление гиперссылок и форматирования из выделенных ячеек.",
  "XtraSpreadsheetStringId.MenuCmd_FormatRightBorder": "Правая граница",
  "XtraSpreadsheetStringId.MenuCmd_FormatRightBorderDescription": "Изменение правой границы.",
  "XtraSpreadsheetStringId.MenuCmd_FormatRowHeight": "Высота строки...",
  "XtraSpreadsheetStringId.MenuCmd_FormatRowHeightDescription": "Открытие диалогового окна \"Высота строки\".",
  "XtraSpreadsheetStringId.MenuCmd_FormatTabColor": "Цвет ярлычка",
  "XtraSpreadsheetStringId.MenuCmd_FormatTabColorDescription": "Изменение цвета ярлычка.",
  "XtraSpreadsheetStringId.MenuCmd_FormatThickBorder": "Толстая внешняя граница",
  "XtraSpreadsheetStringId.MenuCmd_FormatThickBorderDescription": "Изменение внешних границ.",
  "XtraSpreadsheetStringId.MenuCmd_FormatTopAndBottomBorder": "Верхняя и нижняя границы",
  "XtraSpreadsheetStringId.MenuCmd_FormatTopAndBottomBorderDescription": "Изменение верхней и нижней границ.",
  "XtraSpreadsheetStringId.MenuCmd_FormatTopAndDoubleBottomBorder": "Верхняя и сдвоенная нижняя границы",
  "XtraSpreadsheetStringId.MenuCmd_FormatTopAndDoubleBottomBorderDescription": "Изменение верхней и нижней границ.",
  "XtraSpreadsheetStringId.MenuCmd_FormatTopAndThickBottomBorder": "Верхняя и толстая нижняя границы",
  "XtraSpreadsheetStringId.MenuCmd_FormatTopAndThickBottomBorderDescription": "Изменение верхней и нижней границ.",
  "XtraSpreadsheetStringId.MenuCmd_FormatTopBorder": "Верхняя граница",
  "XtraSpreadsheetStringId.MenuCmd_FormatTopBorderDescription": "Изменение верхней границы.",
  "XtraSpreadsheetStringId.MenuCmd_FormatWrapText": "Переносить текст",
  "XtraSpreadsheetStringId.MenuCmd_FormatWrapTextDescription": "Отображение всего содержимого ячейки на нескольких строках.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsAutoSumCommandGroup": "Сумма",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsAutoSumCommandGroupDescription": "Щелкните здесь, чтобы отобразить результат простого вычисления, например расчета среднего или максимального значения для выделенных ячеек.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsCompatibilityCommandGroup": "Функции совместимости",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsCompatibilityCommandGroupDescription": "Вывод списка функций совместимости",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsCubeCommandGroup": "Аналитические",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsCubeCommandGroupDescription": "Вывод списка аналитических функций.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsDateAndTimeCommandGroup": "Дата и время",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsDateAndTimeCommandGroupDescription": "Вывод списка функций даты и времени.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsEngineeringCommandGroup": "Инженерные",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsEngineeringCommandGroupDescription": "Вывод списка инженерных функций.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsFinancialCommandGroup": "Финансовые",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsFinancialCommandGroupDescription": "Вывод списка финансовых функций.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInformationCommandGroup": "Информационные",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInformationCommandGroupDescription": "Вывод списка информационных функций.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertAverage": "Среднее",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertAverageDescription": "Вывод среднего значения выделенных ячеек непосредственно после этих ячеек.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertCount": "Количество",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertCountDescription": "Count.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertCountNumbers": "Число",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertCountNumbersDescription": "Вывод числа значений выделенных ячеек непосредственно после этих ячеек.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertMax": "Максимум",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertMaxDescription": "Вывод максимального значения выделенных ячеек непосредственно после этих ячеек.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertMin": "Минимум",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertMinDescription": "Вывод минимального значения выделенных ячеек непосредственно после этих ячеек.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertProduct": "Произведение",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertProductDescription": "Product.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertSpecificFunction": "Insert specific function",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertSpecificFunctionDescription": "Insert specific function.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertStdDev": "Смещенное отклонение",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertStdDevDescription": "StdDev.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertStdDevp": "Несмещенное отклонение",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertStdDevpDescription": "StdDevp.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertSum": "Сумма",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertSumDescription": "Вывод суммы выделенных ячеек непосредственно после этих ячеек.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertVar": "Смещенная дисперсия",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertVarDescription": "Var.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertVarp": "Несмещенная дисперсия",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsInsertVarpDescription": "Varp.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsLogicalCommandGroup": "Логические",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsLogicalCommandGroupDescription": "Вывод списка логических функций.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsLookupAndReferenceCommandGroup": "Ссылки и массивы",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsLookupAndReferenceCommandGroupDescription": "Вывод списка функций для работы с ссылками и массивами.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsMathAndTrigonometryCommandGroup": "Математические и тригонометрические",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsMathAndTrigonometryCommandGroupDescription": "Вывод списка математических и тригонометрических функций.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsMoreCommandGroup": "Другие функции",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsMoreCommandGroupDescription": "Просмотр списка статистических, инженерных, аналитических и информационных функций, а также функций совместимости.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsStatisticalCommandGroup": "Статистические",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsStatisticalCommandGroupDescription": "Вывод списка статистических функций.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsTextCommandGroup": "Текстовые",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsTextCommandGroupDescription": "Вывод списка текстовых функций.",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsWebCommandGroup": "Интернет",
  "XtraSpreadsheetStringId.MenuCmd_FunctionsWebCommandGroupDescription": "Просмотреть список веб-функций и выбрать из него.",
  "XtraSpreadsheetStringId.MenuCmd_GroupCommand": "Группировать",
  "XtraSpreadsheetStringId.MenuCmd_GroupCommandDescription": "Группировка строк или столбцов или автоматическое создание структуры.",
  "XtraSpreadsheetStringId.MenuCmd_GroupFormCaption": "Группирование",
  "XtraSpreadsheetStringId.MenuCmd_HeaderFooterFormatPicture": "Формат рисунка",
  "XtraSpreadsheetStringId.MenuCmd_HeaderFooterFormatPictureDescription": "Форматирование рисунка в колонтитуле для изменения яркости, контрастности, или размера.",
  "XtraSpreadsheetStringId.MenuCmd_HeaderFooterInsertPicture": "Рисунок",
  "XtraSpreadsheetStringId.MenuCmd_HeaderFooterInsertPictureDescription": "Добавление рисунка в верхний или нижний колонтитул.",
  "XtraSpreadsheetStringId.MenuCmd_HideAndUnhideCommandGroup": "Скрыть или отобразить",
  "XtraSpreadsheetStringId.MenuCmd_HideAndUnhideCommandGroupDescription": "Скрыть или отобразить.",
  "XtraSpreadsheetStringId.MenuCmd_HideColumns": "Скрыть столбцы",
  "XtraSpreadsheetStringId.MenuCmd_HideColumnsContextMenuItem": "Скрыть",
  "XtraSpreadsheetStringId.MenuCmd_HideColumnsContextMenuItemDescription": "Hide Columns.",
  "XtraSpreadsheetStringId.MenuCmd_HideColumnsDescription": "Скрытие столбцов.",
  "XtraSpreadsheetStringId.MenuCmd_HideDetailCommandDescription": "Свертывание группы ячеек.",
  "XtraSpreadsheetStringId.MenuCmd_HideDetailModeCommand": "Скрыть детали",
  "XtraSpreadsheetStringId.MenuCmd_HideFieldListPanelPivotTableContextMenuItem": "Скрыть список полей",
  "XtraSpreadsheetStringId.MenuCmd_HideRows": "Скрыть строки",
  "XtraSpreadsheetStringId.MenuCmd_HideRowsContextMenuItem": "Скрыть",
  "XtraSpreadsheetStringId.MenuCmd_HideRowsContextMenuItemDescription": "Hide Rows.",
  "XtraSpreadsheetStringId.MenuCmd_HideRowsDescription": "Скрытие строк.",
  "XtraSpreadsheetStringId.MenuCmd_HideSheet": "Скрыть лист",
  "XtraSpreadsheetStringId.MenuCmd_HideSheetContextMenuItem": "Скрыть",
  "XtraSpreadsheetStringId.MenuCmd_HideSheetContextMenuItemDescription": "Скрытие листа.",
  "XtraSpreadsheetStringId.MenuCmd_HideSheetDescription": "Скрытие листа.",
  "XtraSpreadsheetStringId.MenuCmd_InsertArrayFormula": "Insert Array Formula",
  "XtraSpreadsheetStringId.MenuCmd_InsertArrayFormulaDescription": "Add a new array formula to worksheet.",
  "XtraSpreadsheetStringId.MenuCmd_InsertCellsCommandGroup": "Вставить",
  "XtraSpreadsheetStringId.MenuCmd_InsertCellsCommandGroupDescription": "Щелкните здесь, чтобы вставить ячейки, строки или столбцы на лист или в таблицу либо добавить лист в книгу.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartArea": "С областями",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartArea2DCommandGroup": "С областями",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartArea2DCommandGroupDescription": "С областями.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartArea3D": "Объемная с областями",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartArea3DCommandGroup": "Объемная с областями",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartArea3DCommandGroupDescription": "Объемная с областями.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartArea3DDescription": "Данный тип диаграммы используется: \n● Для отображения трендов по времени (по годам, месяцам и дням) или по категориям.\n● Для отображения данных по третьей оси, в результате чего некоторые области будут отображаться перед другими.\n\nПрименяется в случаях: \n● Когда важен порядок следования категорий.\n● Когда нужно показать отоносительное изменение вклада каждого из значений во времени.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartAreaCommandGroup": "C областями",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartAreaCommandGroupDescription": "Вставить диаграмму с областями.\n\nДанный тип диаграммы используется для отображения трендов по времени (по годам, месяцам и дням) или по категориям. Используется для выделения относительного изменения вклада каждого из значений во времени.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartAreaDescription": "Данный тип диаграммы используется: \n● Для отображения трендов по времени (по годам, месяцам и дням) или по категориям.\n\nПрименяется в случаях: \n● Когда важен порядок следования категорий.\n● Когда нужно показать отоносительное изменение вклада каждого из значений во времени.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBar2DCommandGroup": "Линейчатая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBar2DCommandGroupDescription": "Линейчатая.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBar3DCommandGroup": "Объемная линейчатая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBar3DCommandGroupDescription": "Объемная линейчатая.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBarClustered2D": "Линейчатая с группировкой",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBarClustered2DDescription": "Данный тип диаграммы используется: \n● Для сравнения значений по нескольким категориям.\n\nПрименяется в случаях: \n● Когда на диаграмме отображается длительность.\n● Когда текст категории имеет большую длину.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBarClustered3D": "Объемная линейчатая с группировкой",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBarClustered3DDescription": "Данный тип диаграммы используется:\n● Для сравнения значений по нескольким категориям.\n\nПрименяется в случаях:\n● Когда на диаграмме отображается длительность.\n● Когда текст категории имеет большую длину.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBarCommandGroup": "Линейчатая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBarCommandGroupDescription": "Вставить линейчатую диаграмму.\n\nИспользуйте данный тип диаграммы для визуального сравнения значений по нескольким категориям, когда на диаграмме отображается длительность или текст категории имеет большую длину.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBarPercentStacked2D": "Нормированная линейчатая с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBarPercentStacked2DDescription": "Данный тип диаграммы используется:\n● Для сравнения относительного вклада каждого из значений в общее значение.\n● Для отображения изменения относительного вклада каждого из значений в общее значение со временем.\n\nПрименяется в случаях:\n● Когда текст категории имеет большую длину.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBarPercentStacked3D": "Объемная нормированная линейчатая с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBarPercentStacked3DDescription": "Данный тип диаграммы используется:\n● Для сравнения относительного вклада каждого из значений в общее значение.\n● Для отображения изменения относительного вклада каждого из значений в общее значение со временем.\n\nПрименяется в случаях:\n● Когда текст категории имеет большую длину.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBarStacked2D": "Линейчатая с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBarStacked2DDescription": "Данный тип диаграммы используется:\n● Для сравнения вклада каждого значения по категориям.\n● Для отображения изменения вклада каждого значения со временем.\n\nПрименяется в случаях:\n● Когда текст категории имеет большую длину.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBarStacked3D": "Объемная линейчатая с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBarStacked3DDescription": "Данный тип диаграммы используется:\n● Для сравнения вклада каждого значения по категориям.\n● Для отображения изменения вклада каждого значения со временем.\n\nПрименяется в случаях:\n● Когда текст категории имеет большую длину.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBubble": "Пузырьковая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBubble3D": "Объемная пузырьковая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBubble3DDescription": "Данный тип диаграммы используется:\n● Для сравнения трех и более наборов значений или пар данных.\n● Для отображения взаимосвязи между наборами значений.\n\nПрименяется в случаях:\n● Когда есть третье значение, которое можно использовать для определения относительного размера пузырька.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBubbleCommandGroup": "Пузырьковая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBubbleCommandGroupDescription": "Пузырьковая.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartBubbleDescription": "Данный тип диаграммы используется:\n● Для сравнения трех и более наборов значений или пар данных.\n● Для отображения взаимосвязи между наборами значений.\n\nПрименяется в случаях:\n● Когда есть третье значение, которое можно использовать для определения относительного размера пузырька.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartColumn2DCommandGroup": "Гистограмма",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartColumn2DCommandGroupDescription": "Гистограмма.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartColumn3D": "Объемная гистограмма",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartColumn3DCommandGroup": "Объемная гистограмма",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartColumn3DCommandGroupDescription": "Объемная гистограмма.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartColumn3DDescription": "Данный тип диаграммы используется:\n● Для сравнения значений по нескольким категориям.\n● Для отображения данных по третьей оси, благодаря чему некоторые столбцы будут отображаться перед другими.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartColumnClustered2D": "Гистограмма с группировкой",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartColumnClustered2DDescription": "Данный тип диаграммы используется:\n● Для сравнения значений по нескольким категориям.\n\nПрименяется в случаях:\n● Когда порядок следования категорий не играет роли.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartColumnClustered3D": "Объемная гистограмма с группировкой",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartColumnClustered3DDescription": "Данный тип диаграммы используется:\n● Для сравнения значений по нескольким категориям.\n\nПрименяется в случаях:\n● Когда порядок следования категорий не играет роли.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartColumnCommandGroup": "Гистограмма",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartColumnCommandGroupDescription": "Вставить гистограмму.\n\nДанный тип диаграммы служит для визуального сравнения значений по нескольким категориям.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartColumnPercentStacked2D": "Нормированная гистограмма с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartColumnPercentStacked2DDescription": "Данный тип диаграммы используется:\n● Для сравнения относительного вклада каждого значения в общую сумму.\n● Для отображения изменения вклада каждого из значений со временем.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartColumnPercentStacked3D": "Объемная нормированная гистограмма с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartColumnPercentStacked3DDescription": "Данный тип диаграммы используется:\n● Для сравнения относительного вклада каждого значения в общую сумму.\n● Для отображения изменения вклада каждого из значений со временем.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartColumnStacked2D": "Гистограмма с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartColumnStacked2DDescription": "Данный тип диаграммы используется:\n● Для сравнения частей целого значения.\n● Для отображения изменения составлящих целого значения со временем.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartColumnStacked3D": "Объемная гистограмма с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartColumnStacked3DDescription": "Данный тип диаграммы используется:\n● Для сравнения частей целого значения.\n● Для отображения изменения составлящих целого значения со временем.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartCone": "Объемная коническая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartConeClustered": "Коническая с группировкой",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartConeClusteredDescription": "Данный тип диаграммы используется:\n● Для сравнения значений по нескольким категориям.\n\nПрименяется в случаях:\n● Когда порядок следования категорий не играет роли.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartConeCommandGroup": "Коническая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartConeCommandGroupDescription": "Коническая.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartConeDescription": "Данный тип диаграммы используется:\n● Для сравнения значений по нескольким категориям.\n● Для отображения данных по третьей оси, благодаря чему некоторые столбцы будут отображаться перед другими.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartConePercentStacked": "Нормированная коническая с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartConePercentStackedDescription": "Данный тип диаграммы используется:\n● Для сравнения относительного вклада каждого значения в общую сумму.\n● Для отображения изменения вклада каждого из значений со временем.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartConeStacked": "Коническая с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartConeStackedDescription": "Данный тип диаграммы используется:\n● Для сравнения частей целого значения.\n● Для отображения изменения составлящих целого значения со временем.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartCylinder": "Объемная цилиндрическая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartCylinderClustered": "Цилиндрическая с группировкой",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartCylinderClusteredDescription": "Данный тип диаграммы используется:\n● Для сравнения значений по нескольким категориям.\n\nПрименяется в случаях:\n● Когда порядок следования категорий не играет роли.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartCylinderCommandGroup": "Цилиндрическая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartCylinderCommandGroupDescription": "Цилиндрическая.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartCylinderDescription": "Данный тип диаграммы используется:\n● Для сравнения значений по нескольким категориям.\n● Для отображения данных по третьей оси, благодаря чему некоторые столбцы будут отображаться перед другими.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartCylinderPercentStacked": "Нормированная цилиндрическая с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartCylinderPercentStackedDescription": "Данный тип диаграммы используется:\n● Для сравнения относительного вклада каждого значения в общую сумму.\n● Для отображения изменения вклада каждого из значений со временем.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartCylinderStacked": "Цилиндрическая с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartCylinderStackedDescription": "Данный тип диаграммы используется:\n● Для сравнения частей целого значения.\n● Для отображения изменения составлящих целого значения со временем.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartDoughnut2D": "Кольцевая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartDoughnut2DCommandGroup": "Кольцевая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartDoughnut2DCommandGroupDescription": "Кольцевая.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartDoughnut2DDescription": "Данный тип диаграммы используется:\n● Для отображения пропорций.\n\nЕе рекомендуется использовать вместо круговой диаграммы при наличии нескольких рядов, которые дают в сумме большое значение.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartDoughnutExploded2D": "Разрезанная кольцевая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartDoughnutExploded2DDescription": "Отображение вклада каждого значения в общую сумму с выделением отдельных значений, как на разрезанной круговой диаграмме; возможно включение нескольких рядов.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalConeClustered": "Горизонтальная коническая с группировкой",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalConeClusteredDescription": "Данный тип диаграммы используется: \n● Для сравнения значений по нескольким категориям.\n\nПрименяется в случаях: \n● Когда на диаграмме отображается длительность.\n● Когда текст категории имеет большую длину.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalConeCommandGroup": "Коническая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalConeCommandGroupDescription": "Коническая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalConePercentStacked": "Нормированная горизонтальная коническая с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalConePercentStackedDescription": "Данный тип диаграммы используется:\n● Для сравнения относительного вклада каждого из значений в общее значение.\n● Для отображения изменения относительного вклада каждого из значений в общее значение со временем.\n\nПрименяется в случаях:\n● Когда текст категории имеет большую длину.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalConeStacked": "Горизонтальная коническая с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalConeStackedDescription": "Данный тип диаграммы используется:\n● Для сравнения вклада каждого значения по категориям.\n● Для отображения изменения вклада каждого значения со временем.\n\nПрименяется в случаях:\n● Когда текст категории имеет большую длину.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalCylinderClustered": "Горизонтальная цилиндрическая с группировкой",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalCylinderClusteredDescription": "Данный тип диаграммы используется: \n● Для сравнения значений по нескольким категориям.\n\nПрименяется в случаях: \n● Когда на диаграмме отображается длительность.\n● Когда текст категории имеет большую длину.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalCylinderCommandGroup": "Цилиндрическая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalCylinderCommandGroupDescription": "Цилиндрическая.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalCylinderPercentStacked": "Нормированная горизонтальная цилиндрическая с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalCylinderPercentStackedDescription": "Данный тип диаграммы используется:\n● Для сравнения относительного вклада каждого из значений в общее значение.\n● Для отображения изменения относительного вклада каждого из значений в общее значение со временем.\n\nПрименяется в случаях:\n● Когда текст категории имеет большую длину.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalCylinderStacked": "Горизонтальная цилиндрическая с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalCylinderStackedDescription": "Данный тип диаграммы используется:\n● Для сравнения вклада каждого значения по категориям.\n● Для отображения изменения вклада каждого значения со временем.\n\nПрименяется в случаях:\n● Когда текст категории имеет большую длину.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalPyramidClustered": "Горизонтальная пирамидальная с группировкой",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalPyramidClusteredDescription": "Данный тип диаграммы используется: \n● Для сравнения значений по нескольким категориям.\n\nПрименяется в случаях: \n● Когда на диаграмме отображается длительность.\n● Когда текст категории имеет большую длину.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalPyramidCommandGroup": "Пирамидальная",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalPyramidCommandGroupDescription": "Пирамидальная.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalPyramidPercentStacked": "Нормированная горизонтальная пирамидальная с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalPyramidPercentStackedDescription": "Данный тип диаграммы используется:\n● Для сравнения относительного вклада каждого из значений в общее значение.\n● Для отображения изменения относительного вклада каждого из значений в общее значение со временем.\n\nПрименяется в случаях:\n● Когда текст категории имеет большую длину.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalPyramidStacked": "Горизонтальная пирамидальная с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartHorizontalPyramidStackedDescription": "Данный тип диаграммы используется:\n● Для сравнения вклада каждого значения по категориям.\n● Для отображения изменения вклада каждого значения со временем.\n\nПрименяется в случаях:\n● Когда текст категории имеет большую длину.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartLine": "График",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartLine2DCommandGroup": "График",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartLine2DCommandGroupDescription": "График.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartLine3D": "Объемный график",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartLine3DCommandGroup": "Объемный график",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartLine3DCommandGroupDescription": "Объемный график.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartLine3DDescription": "Данный тип диаграммы используется:\n● Для отображения трендов во времени (по годам, месяцам и дням) или по категориям.\n● Для отображения данных по третьей оси, в результате чего некоторые графики будут отображаться перед другими.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartLineCommandGroup": "График",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartLineCommandGroupDescription": "Вставить график.\n\nДанный тип диаграммы служит для отображения трендов во времени (по годам, месяцам и дням) или по категориям.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartLineDescription": "Данный тип диаграммы используется:\n● Для отображения трендов во времени (по годам, месяцам и дням) или по категориям.\n\nПрименяется в случаях:\n● Когда важен порядок следования категорий.\n● Когда точек данных много.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartLineWithMarkers": "График с маркерами",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartLineWithMarkersDescription": "Данный тип диаграммы используется:\n● Для отображения трендов во времени (по годам, месяцам и дням) или по категориям.\n\nПрименяется в случаях:\n● Когда важен порядок следования категорий.\n● Когда точек данных немного.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartOtherCommandGroup": "Другие диаграммы",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartOtherCommandGroupDescription": "Вставить биржевую или лепестковую диаграмму.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPercentStackedArea": "Нормированная с областями и накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPercentStackedArea3D": "Объемная нормированная с областями и накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPercentStackedArea3DDescription": "Данный тип диаграммы используется:\n● Для отображения относительного вклада в общее значение по времени или по категориям.\n● Для выделения значения относительного изменения вклада каждого из значений во времени.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPercentStackedAreaDescription": "Данный тип диаграммы используется:\n● Для отображения относительного вклада в общее значение по времени или по категориям.\n● Для выделения значения относительного изменения вклада каждого из значений во времени.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPercentStackedLine": "Нормированный график с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPercentStackedLineDescription": "Данный тип диаграммы используется:\n● Для отображения относительного вклада в общее значение со временем или по категориям.\n● Для отображения изменения вклада каждого значени со временем.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPercentStackedLineWithMarkers": "Нормированный график с маркерами и накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPercentStackedLineWithMarkersDescription": "Данный тип диаграммы используется:\n● Для отображения относительного вклада в общее значение со временем или по категориям.\n● Для отображения изменения вклада каждого значени со временем.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPie2D": "Круговая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPie2DCommandGroup": "Круговая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPie2DCommandGroupDescription": "Круговая.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPie2DDescription": "Данный тип диаграммы используется:\n● Для отображения пропорций.\n\nПрименяется в случаях:\n● Когда значения в сумме дают 100%.\n● Когда диаграмма состоит всего из нескольких секторов (большое количество секторов усложняет оценку углов).",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPie3D": "Объемная круговая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPie3DCommandGroup": "Объемная круговая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPie3DCommandGroupDescription": "Объемная круговая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPie3DDescription": "Данный тип диаграммы используется:\n● Для отображения пропорций.\n\nПрименяется в случаях:\n● Когда значения в сумме дают 100%.\n● Когда диаграмма состоит всего из нескольких секторов (большое количество секторов усложняет оценку углов).",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPieCommandGroup": "Круговая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPieCommandGroupDescription": "Вставить круговую или кольцевую диаграмму.\n\nДанный тип диаграммы используется для отображения пропорций. Он применим, когда все значения в сумме дают 100%.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPieExploded2D": "Разрезанная круговая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPieExploded2DDescription": "Отображение вклада каждого значения в общую сумму с выделением отдельных значений. \n   \nКак вариант, можно использовать круговую диаграмму, из которой вырезаны отдельные значения.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPieExploded3D": "Объемная разрезанная круговая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPieExploded3DDescription": "Отображение вклада каждого значения в общую сумму с выделением отдельных значений. \n   \nКак вариант, можно использовать объемную круговую диаграмму, из которой вырезаны отдельные значения.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPyramid": "Объемная пирамидальная",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPyramidClustered": "Пирамидальная с группировкой",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPyramidClusteredDescription": "Данный тип диаграммы используется:\n● Для сравнения значений по нескольким категориям.\n\nПрименяется в случаях:\n● Когда порядок следования категорий не играет роли.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPyramidCommandGroup": "Пирамидальная",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPyramidCommandGroupDescription": "Пирамидальная.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPyramidDescription": "Данный тип диаграммы используется:\n● Для сравнения значений по нескольким категориям.\n● Для отображения данных по третьей оси, благодаря чему некоторые столбцы будут отображаться перед другими.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPyramidPercentStacked": "Нормированная пирамидальная с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPyramidPercentStackedDescription": "Данный тип диаграммы используется:\n● Для сравнения относительного вклада каждого значения в общую сумму.\n● Для отображения изменения вклада каждого из значений со временем.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPyramidStacked": "Пирамидальная с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartPyramidStackedDescription": "Данный тип диаграммы используется:\n● Для сравнения частей целого значения.\n● Для отображения изменения составлящих целого значения со временем.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartRadar": "Лепестковая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartRadarCommandGroup": "Лепестковая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartRadarCommandGroupDescription": "Лепестковая.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartRadarDescription": "Данный тип диаграммы используется:\n● Для отображения значений по отношению к центральной точке.\n\nПрименяется в случаях:\n● Когда категории не сравниваются напрямую.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartRadarFilled": "Заполненная лепестковая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartRadarFilledDescription": "Данный тип диаграммы используется:\n● Для отображения значений по отношению к центральной точке.\n\nПрименяется в случаях:\n● Когда категории не сравниваются напрямую.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartRadarWithMarkers": "Лепестковая с маркерами",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartRadarWithMarkersDescription": "Данный тип диаграммы используется:\n● Для отображения значений по отношению к центральной точке.\n\nПрименяется в случаях:\n● Когда категории не сравниваются напрямую.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartScatterCommandGroup": "Точечная",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartScatterCommandGroupDescription": "Вставить точечную (X,Y) или пузырьковую диаграмму\n    \nДанный тип диаграммы используется для отображения взаимосвязи между рядами значений.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartScatterLines": "Точечная с прямыми отрезками",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartScatterLinesAndMarkers": "Точечная с прямыми отрезками и маркерами",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartScatterLinesAndMarkersDescription": "Данный тип диаграммы используется:\n● Для сравнения двух и более наборов значений или пар данных.\n\nПрименяется в случаях:\n● Когда точек данных немного.\n● Когда данные представляют собой разные измерения.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartScatterLinesDescription": "Данный тип диаграммы используется:\n● Для сравнения двух и более наборов значений или пар данных.\n\nПрименяется в случаях:\n● Когда точек данных много.\n● Когда данные представляют собой разные измерения.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartScatterMarkers": "Точечная",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartScatterMarkersDescription": "Данный тип диаграммы используется:\n● Для сравнения двух и более наборов значений или пар значений.\n● Для отображения взаимосвязи между рядами значений.\n\nПрименяется в случаях:\n● Когда данные представляют собой разные измерения.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartScatterSmoothLines": "Точечная с гладкими кривыми",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartScatterSmoothLinesAndMarkers": "Точечная с гладкими кривыми и маркерами",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartScatterSmoothLinesAndMarkersDescription": "Данный тип диаграммы используется:\n● Для сравнения двух и более наборов значений или пар данных.\n\nПрименяется в случаях:\n● Когда точек данных немного.\n● Когда данные представляют собой набор пар значений x и y, связанных формулой.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartScatterSmoothLinesDescription": "Данный тип диаграммы используется:\n● Для сравнения двух и более наборов значений или пар данных.\n\nПрименяется в случаях:\n● Когда точек данных много.\n● Когда данные представляют собой набор пар значений x и y, связанных формулой.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartStackedArea": "С областями и накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartStackedArea3D": "Объемная с областями и накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartStackedArea3DDescription": "Данный тип диаграммы используется:\n● Для отображения отношения элементов к общему значению по времени или по категориям.\n● Для выделения величины изменения во времени.\n● Для акцентирования внимания на суммарном значении на протяжении тренда.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartStackedAreaDescription": "Данный тип диаграммы используется:\n● Для отображения отношения элементов к общему значению по времени или по категориям.\n● Для выделения величины изменения во времени.\n● Для акцентирования внимания на суммарном значении на протяжении тренда.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartStackedLine": "График с накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartStackedLineDescription": "Данный тип диаграммы используется:\n● Для отображения изменения составляющих целого значения во времени.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartStackedLineWithMarkers": "График с маркерами и накоплением",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartStackedLineWithMarkersDescription": "Данный тип диаграммы используется:\n● Для отображения изменения составляющих целого значения во времени.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartStockCommandGroup": "Биржевая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartStockCommandGroupDescription": "Биржевая.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartStockHighLowClose": "Биржевая",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartStockHighLowCloseDescription": "Данный тип диаграммы используется:\n● Для отображения тренда доходности акций по времени.\n\nПрименяется в случаях:\n● Когда есть три ряда значений курса: максимальный, минимальный, курс закрытия.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartStockOpenHighLowClose": "Биржевая (курс открытия, самый высокий курс, самый низкий курс, курс закрытия)",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartStockOpenHighLowCloseDescription": "Данный тип диаграммы используется:\n● Для отображения тренда доходности акций по времени.\n\nПрименяется в случаях:\n● Когда есть четыре ряда значений: курс открытия, максимальный курс, минимальный курс, курс закрытия.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartStockVolumeHighLowClose": "Биржевая (объем, самый высокий курс, самый низкий курс, курс закрытия)",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartStockVolumeHighLowCloseDescription": "Данный тип диаграммы используется:\n● Для отображения тренда доходности акций по времени.\n\nПрименяется в случаях:\n● Когда есть четыре ряда значений: объем, максимальный курс, минимальный курс, курс закрытия.",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartStockVolumeOpenHighLowClose": "Биржевая (объем, курс открытия, самый высокий курс, самый низкий курс, курс закрытия)",
  "XtraSpreadsheetStringId.MenuCmd_InsertChartStockVolumeOpenHighLowCloseDescription": "Данный тип диаграммы используется:\n● Для отображения тренда доходности акций по времени.\n\nПрименяется в случаях:\n● Когда есть пять рядов значений: объем, курс открытия, максимальный курс, минимальный курс, курс закрытия.",
  "XtraSpreadsheetStringId.MenuCmd_InsertDefinedName": "Использовать в формуле",
  "XtraSpreadsheetStringId.MenuCmd_InsertDefinedNameCommandGroup": "Использовать в формуле",
  "XtraSpreadsheetStringId.MenuCmd_InsertDefinedNameCommandGroupDescription": "Выбор имени, используемого в книге, и вставка этого имени в текущую формулу.",
  "XtraSpreadsheetStringId.MenuCmd_InsertDefinedNameDescription": "Выбор имени, используемого в книге, и вставка этого имени в текущую формулу.",
  "XtraSpreadsheetStringId.MenuCmd_InsertPivotTable": "Сводная таблица",
  "XtraSpreadsheetStringId.MenuCmd_InsertPivotTableDescription": "Простое упорядочение и сведение данных в сводной таблице.",
  "XtraSpreadsheetStringId.MenuCmd_InsertSheet": "Вставить лист",
  "XtraSpreadsheetStringId.MenuCmd_InsertSheetColumns": "Вставить столбцы в лист",
  "XtraSpreadsheetStringId.MenuCmd_InsertSheetColumnsContextMenuItem": "Вставить",
  "XtraSpreadsheetStringId.MenuCmd_InsertSheetColumnsContextMenuItemDescription": "Добавление столбцов в лист.",
  "XtraSpreadsheetStringId.MenuCmd_InsertSheetColumnsDescription": "Вставить новые столбцы в лист.",
  "XtraSpreadsheetStringId.MenuCmd_InsertSheetContextMenuItem": "Вставить...",
  "XtraSpreadsheetStringId.MenuCmd_InsertSheetContextMenuItemDescription": "Вставить лист.",
  "XtraSpreadsheetStringId.MenuCmd_InsertSheetDescription": "Вставить лист.",
  "XtraSpreadsheetStringId.MenuCmd_InsertSheetRows": "Вставить строки в лист",
  "XtraSpreadsheetStringId.MenuCmd_InsertSheetRowsContextMenuItem": "Вставить",
  "XtraSpreadsheetStringId.MenuCmd_InsertSheetRowsContextMenuItemDescription": "Добавление строк в лист.",
  "XtraSpreadsheetStringId.MenuCmd_InsertSheetRowsDescription": "Вставить новые строки в лист.",
  "XtraSpreadsheetStringId.MenuCmd_InsertTable": "Таблица",
  "XtraSpreadsheetStringId.MenuCmd_InsertTableCellsCommandGroup": "Вставить",
  "XtraSpreadsheetStringId.MenuCmd_InsertTableCellsCommandGroupDescription": "Вставка строк или столбцов в таблицу.",
  "XtraSpreadsheetStringId.MenuCmd_InsertTableColumnsToTheLeft": "Вставить столбцы таблицы слева",
  "XtraSpreadsheetStringId.MenuCmd_InsertTableColumnsToTheLeftContextMenuItem": "Столбцы таблицы слева",
  "XtraSpreadsheetStringId.MenuCmd_InsertTableColumnsToTheLeftDescription": "Вставка столбцов таблицы слева.",
  "XtraSpreadsheetStringId.MenuCmd_InsertTableColumnToTheRight": "Вставить столбцы таблицы справа",
  "XtraSpreadsheetStringId.MenuCmd_InsertTableColumnToTheRightContextMenuItem": "Столбцы таблицы справа",
  "XtraSpreadsheetStringId.MenuCmd_InsertTableColumnToTheRightDescription": "Вставка столбцов таблицы справа.",
  "XtraSpreadsheetStringId.MenuCmd_InsertTableDescription": "Создание таблицы для упорядочения и анализа связанных данных.",
  "XtraSpreadsheetStringId.MenuCmd_InsertTableRowBelow": "Вставить строки таблицы ниже",
  "XtraSpreadsheetStringId.MenuCmd_InsertTableRowBelowContextMenuItem": "Строки таблицы ниже",
  "XtraSpreadsheetStringId.MenuCmd_InsertTableRowBelowDescription": "Вставка строк таблицы ниже.",
  "XtraSpreadsheetStringId.MenuCmd_InsertTableRowsAbove": "Вставить строки таблицы выше",
  "XtraSpreadsheetStringId.MenuCmd_InsertTableRowsAboveContextMenuItem": "Строки таблицы выше",
  "XtraSpreadsheetStringId.MenuCmd_InsertTableRowsAboveDescription": "Вставка строк таблицы выше.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeAddDataSourceCommand": "Add Data Source",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeAddDataSourceCommandDescription": "Create a connection to a data source.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeDocumentsModeCommand": "Multiple Documents",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeDocumentsModeCommandDescription": "Create a separate workbook for each record of the data source.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeHorizontalModeCommand": "Горизонтальное",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeHorizontalModeCommandDescription": "Insert merged ranges one after the other from left to right. Header and footer are on the left and on the right of the sheet respectively.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeManageDataSourceCommandGroup": "Manage Data Source",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeManageDataSourceCommandGroupDescription": "Add a new connection or select a data source from the list of existing connections. If a data source contains multiple data tables, select the required data member to perform mail merge.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeManageDataSourcesCommand": "Manage Data Sources",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeManageQueriesCommand": "Manage Queries",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeManageRelationsCommand": "Manage Relations",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeManageRelationsCommandGroup": "Manage Relations",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeManageRelationsCommandGroupDescription": "Add new queries to a data source or edit the existing queries. If a data source contains multiple data tables, create or modify master-detail relationships between data tables.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeOneDocumentModeCommand": "Multiple Sheets",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeOneDocumentModeCommandDescription": "Create a separate worksheet in a single workbook for each record of the data source.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeOneSheetModeCommand": "Single Sheet",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeOneSheetModeCommandDescription": "Insert all merged ranges into a single worksheet according to the selected document orientation.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeOrientationCommandGroup": "Document Orientation",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeOrientationCommandGroupDescription": "Select either vertical or horizontal orientation for a resulting document.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergePreviewCommand": "Mail Merge Preview",
  "XtraSpreadsheetStringId.MenuCmd_MailMergePreviewCommandDescription": "Preview a resulting document.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeResetFilterCommand": "Reset Filter",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeResetFilterCommandDescription": "Reset data filter in the selected detail range.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeResetRangeCommand": "Сброс",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeResetRangeCommandDescription": "Reset selected ranges of the template.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSelectDataMemberCommand": "Select Data Member",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSelectDataMemberCommandDescription": "Select Data Member",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSelectDataSourceCommand": "Select Data Source",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSelectDataSourceCommandDescription": "Select Data Source",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSetDetailDataMemberCommand": "Элемент данных",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSetDetailDataMemberCommandDescription": "Set a data member for a detail level.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSetDetailLevelCommand": "Detail Level",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSetDetailLevelCommandDescription": "Specify the detail range of the next level.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSetDetailRangeCommand": "Detail",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSetDetailRangeCommandDescription": "Specify a detail range to repeat for each record of the data source.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSetFilterCommand": "Edit Filter",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSetFilterCommandDescription": "Specify filter criteria for data in the selected detail range.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSetFooterRangeCommand": "Нижний колонтитул",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSetFooterRangeCommandDescription": "Specify a footer range in the template.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSetGroupCommand": "Sort Fields",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSetGroupCommandDescription": "Specify sorting criteria for data in the selected detail range.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSetGroupFooterCommand": "Group Footer",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSetGroupFooterCommandDescription": "Specify a group footer. It is based on a sort field and displays information at the end of a group of records in a resulting document.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSetGroupHeaderCommand": "Group Header",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSetGroupHeaderCommandDescription": "Specify a group header. It is based on a sort field and displays information at the beginning of a group of records in a resulting document.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSetHeaderRangeCommand": "Верхний колонтитул",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeSetHeaderRangeCommandDescription": "Specify a header range in the template.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeShowRangesCommand": "Mail Merge Design View",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeShowRangesCommandDescription": "Highlight template ranges.",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeVerticalModeCommand": "Вертикальное",
  "XtraSpreadsheetStringId.MenuCmd_MailMergeVerticalModeCommandDescription": "Insert merged ranges one under the other. Header and footer are at the top and at the bottom of the sheet respectively.",
  "XtraSpreadsheetStringId.MenuCmd_MaxInfoStatusBarCommandCaptionPart": "МАКС:",
  "XtraSpreadsheetStringId.MenuCmd_MaxInfoStatusBarCommandDescription": "Наибольшее из выделенных значений",
  "XtraSpreadsheetStringId.MenuCmd_MinInfoStatusBarCommandCaptionPart": "МИН:",
  "XtraSpreadsheetStringId.MenuCmd_MinInfoStatusBarCommandDescription": "Наименьшее из выделенных значений",
  "XtraSpreadsheetStringId.MenuCmd_ModifyChartLayout": "Quick Layout",
  "XtraSpreadsheetStringId.MenuCmd_ModifyChartLayoutDescription": "Change the overall layout of the chart.",
  "XtraSpreadsheetStringId.MenuCmd_ModifyChartStyle": "Quick Styles",
  "XtraSpreadsheetStringId.MenuCmd_ModifyChartStyleDescription": "Change the overall visual style of the chart.",
  "XtraSpreadsheetStringId.MenuCmd_MoveChart": "Перемещение диаграммы",
  "XtraSpreadsheetStringId.MenuCmd_MoveChartContextMenuItem": "Переместить диаграмму...",
  "XtraSpreadsheetStringId.MenuCmd_MoveChartDescription": "Перемещение диаграммы на другой лист или другую вкладку книги.",
  "XtraSpreadsheetStringId.MenuCmd_MoveOrCopySheet": "Переместить или скопировать лист...",
  "XtraSpreadsheetStringId.MenuCmd_MoveOrCopySheetContextMenuItem": "Переместить или скопировать...",
  "XtraSpreadsheetStringId.MenuCmd_MoveOrCopySheetContextMenuItemDescription": "Переместить или скопировать лист.",
  "XtraSpreadsheetStringId.MenuCmd_MoveOrCopySheetDescription": "Переместить или скопировать лист.",
  "XtraSpreadsheetStringId.MenuCmd_MovePivotFieldReference": "Переместить",
  "XtraSpreadsheetStringId.MenuCmd_MovePivotFieldReferenceDown": "Переместить \"{0}\" вниз",
  "XtraSpreadsheetStringId.MenuCmd_MovePivotFieldReferenceToBeginning": "Переместить \"{0}\" в начало",
  "XtraSpreadsheetStringId.MenuCmd_MovePivotFieldReferenceToColumns": "Переместить \"{0}\" в столбцы",
  "XtraSpreadsheetStringId.MenuCmd_MovePivotFieldReferenceToEnd": "Переместить \"{0}\" в конец",
  "XtraSpreadsheetStringId.MenuCmd_MovePivotFieldReferenceToLeft": "Переместить \"{0}\" влево",
  "XtraSpreadsheetStringId.MenuCmd_MovePivotFieldReferenceToRight": "Переместить \"{0}\" вправо",
  "XtraSpreadsheetStringId.MenuCmd_MovePivotFieldReferenceToRows": "Переместить \"{0}\" в строки",
  "XtraSpreadsheetStringId.MenuCmd_MovePivotFieldReferenceUp": "Переместить \"{0}\" вверх",
  "XtraSpreadsheetStringId.MenuCmd_MovePivotTable": "Переместить",
  "XtraSpreadsheetStringId.MenuCmd_MovePivotTableDescription": "Перемещение сводной таблицы в другое место книги.",
  "XtraSpreadsheetStringId.MenuCmd_MoveToNextSheetDescription": "Switches between worksheet tabs, from left-to-right.",
  "XtraSpreadsheetStringId.MenuCmd_MoveToPreviousSheetDescription": "Switches between worksheet tabs, from right-to-left.",
  "XtraSpreadsheetStringId.MenuCmd_NewConditionalFormattingRule": "Создать правило...",
  "XtraSpreadsheetStringId.MenuCmd_NewConditionalFormattingRuleDescription": "Создать правило...",
  "XtraSpreadsheetStringId.MenuCmd_None": "",
  "XtraSpreadsheetStringId.MenuCmd_NumericalCountInfoStatusBarCommandCaptionPart": "КОЛИЧЕСТВО ЧИСЕЛ:",
  "XtraSpreadsheetStringId.MenuCmd_NumericalCountInfoStatusBarCommandDescription": "Количество значений в выделенном фрагменте, которые содержат числовые данные",
  "XtraSpreadsheetStringId.MenuCmd_OptionsPivotTable": "Параметры",
  "XtraSpreadsheetStringId.MenuCmd_OptionsPivotTableContextMenuItem": "Параметры сводной таблицы...",
  "XtraSpreadsheetStringId.MenuCmd_OptionsPivotTableDescription": "Открытие диалогового окна \"Параметры сводной таблицы\".",
  "XtraSpreadsheetStringId.MenuCmd_OutlineDialogCommand": "Структура",
  "XtraSpreadsheetStringId.MenuCmd_OutlineDialogCommandDescription": "Открытие диалогового окна \"Структура\".",
  "XtraSpreadsheetStringId.MenuCmd_OutlineGroupCommandGroupDescription": "Группировка строк или столбцов или автоматическое создание структуры.",
  "XtraSpreadsheetStringId.MenuCmd_OutlineUngroupCommandGroupDescription": "Разгруппирование ранее сгруппированного диапазона ячеек.",
  "XtraSpreadsheetStringId.MenuCmd_PageSetup": "Параметры страницы",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupAddPrintArea": "Добавить в область печати",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupAddPrintAreaDescription": "Добавить в область печати.",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupChartsheet": "Page Setup: Chart",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupChartsheetDescription": "Show the Chart tab of the Page Setup dialog box.",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupClearPrintArea": "Убрать",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupClearPrintAreaDescription": "Убрать область печати",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupCustomMargins": "Настраиваемые поля...",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupDescription": "Отображение вкладки \"Страница\" диалогового окна \"Параметры страницы\".",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupHeaderFooter": "Page Setup: Header/Footer",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupHeaderFooterDescription": "Show the Header/Footer tab of the Page Setup dialog box.",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupMargins": "Page Setup: Margins",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupMarginsCommandGroup": "Поля",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupMarginsCommandGroupDescription": "Выбор размеров полей документа.",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupMarginsDescription": "Show the Margins tab of the Page Setup dialog box.",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupMorePaperSizes": "Другие размеры страниц...",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupPaperKindCommandGroup": "Размер страницы",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupPaperKindCommandGroupDescription": "Выбор размера бумаги для текущего листа.",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupPrintAreaCommandGroup": "Область печати",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupPrintAreaCommandGroupDescription": "Выбор области листа для печати.",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupPrintGridlines": "Сетка",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupPrintGridlinesDescription": "Печать линий между строками и столбцами листа для улучшения восприятия.",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupPrintHeadings": "Заголовки",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupPrintHeadingsDescription": "Печать заголовков строк и столбцов.\n\nЗаголовки строк – это номера строк в левой или правой части листа.\n\nЗаголовки столбцов – это буквы или цифры, которые отображаются над столбцами листа.",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupPrintTitles": "Печатать заголовки",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupPrintTitlesDescription": "Выбор строк и столбцов, которые нужно повторять на каждой печатной странице (это могут быть надписи или заголовки).",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupSetPaperKind": "Размер страницы",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupSetPaperKindDescription": "Выбор размера бумаги для текущего листа.",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupSetPrintArea": "Установить",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupSetPrintAreaDescription": "Установить область печати.",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupSheet": "Параметры страницы: лист",
  "XtraSpreadsheetStringId.MenuCmd_PageSetupSheetDescription": "Отображение вкладки \"Лист\" диалогового окна \"Параметры страницы\".",
  "XtraSpreadsheetStringId.MenuCmd_PasteBiff12Content": "Microsoft Excel 12.0 Format",
  "XtraSpreadsheetStringId.MenuCmd_PasteBiff12ContentDescription": "Inserts the contents of the Clipboard with the most of Microsoft Excel formatting.",
  "XtraSpreadsheetStringId.MenuCmd_PasteBiff5Content": "Microsoft Excel 5.0 Format",
  "XtraSpreadsheetStringId.MenuCmd_PasteBiff5ContentDescription": "Inserts the contents of the Clipboard with the most of Microsoft Excel formatting.",
  "XtraSpreadsheetStringId.MenuCmd_PasteBiff8Content": "Microsoft Excel 8.0 Format",
  "XtraSpreadsheetStringId.MenuCmd_PasteBiff8ContentDescription": "Inserts the contents of the Clipboard with the most of Microsoft Excel formatting.",
  "XtraSpreadsheetStringId.MenuCmd_PasteBitmap": "Bitmap",
  "XtraSpreadsheetStringId.MenuCmd_PasteBitmapDescription": "Inserts the contents of the Clipboard as a bitmap picture. This format can take up a lot of memory and disk space, but is exactly what you see on the screen",
  "XtraSpreadsheetStringId.MenuCmd_PasteCsvText": "Comma delimited (Csv)",
  "XtraSpreadsheetStringId.MenuCmd_PasteCsvTextDescription": "Inserts the contents of the Clipboard in Csv format.",
  "XtraSpreadsheetStringId.MenuCmd_PasteDataInterchangeFormat": "",
  "XtraSpreadsheetStringId.MenuCmd_PasteDataInterchangeFormatDescription": "",
  "XtraSpreadsheetStringId.MenuCmd_PasteEnhancedMetafile": "Picture (Enhanced Metafile)",
  "XtraSpreadsheetStringId.MenuCmd_PasteEnhancedMetafileDescription": "Inserts the contents of the Clipboard as a picture. This format is better than Bitmap for printing to high quality printers.",
  "XtraSpreadsheetStringId.MenuCmd_PasteMSODrawingObject": "Microsoft Office Drawing Object",
  "XtraSpreadsheetStringId.MenuCmd_PasteMSODrawingObjectDescription": "Inserts the contents of the Clipboard as a Microsoft Office Drawing Object format.",
  "XtraSpreadsheetStringId.MenuCmd_PasteRtfText": "Formatted text (RTF)",
  "XtraSpreadsheetStringId.MenuCmd_PasteRtfTextDescription": "Insert the contents of the Clipboard as text with font and table formatting.",
  "XtraSpreadsheetStringId.MenuCmd_PasteTabDelimitedDescription": "Inserts the contents of the Clipboard as text without any formatting.",
  "XtraSpreadsheetStringId.MenuCmd_PasteTabDelimitedText": "Unformatted text (Tab delimited text)",
  "XtraSpreadsheetStringId.MenuCmd_PasteXmlSpreadsheet": "Xml Spreadsheet 2003 (xml)",
  "XtraSpreadsheetStringId.MenuCmd_PasteXmlSpreadsheetDescription": "Insert the contents of the Clipboard in Xml Spreadsheet 2003 format.",
  "XtraSpreadsheetStringId.MenuCmd_PivotClearFieldFilter": "Очистить фильтр",
  "XtraSpreadsheetStringId.MenuCmd_PivotClearFieldFilterDescription": "Очистить фильтр.",
  "XtraSpreadsheetStringId.MenuCmd_PivotLabelFilterDoesNotBeginWith": "не начинается с...",
  "XtraSpreadsheetStringId.MenuCmd_PivotLabelFilterDoesNotBeginWithDescription": "не начинается с...",
  "XtraSpreadsheetStringId.MenuCmd_PivotLabelFilterDoesNotEndWith": "не заканчивается на...",
  "XtraSpreadsheetStringId.MenuCmd_PivotLabelFilterDoesNotEndWithDescription": "не заканчивается на...",
  "XtraSpreadsheetStringId.MenuCmd_PivotLabelFilterNotBetween": "вне...",
  "XtraSpreadsheetStringId.MenuCmd_PivotLabelFilterNotBetweenDescription": "вне...",
  "XtraSpreadsheetStringId.MenuCmd_PivotSortAscending": "Сортировка от А до Я",
  "XtraSpreadsheetStringId.MenuCmd_PivotSortAscendingDescription": "Сортировка от А до Я.",
  "XtraSpreadsheetStringId.MenuCmd_PivotSortAscendingOnlyDates": "Сортировка от старых к новым",
  "XtraSpreadsheetStringId.MenuCmd_PivotSortAscendingOnlyDatesDescription": "Сортировка от старых к новым.",
  "XtraSpreadsheetStringId.MenuCmd_PivotSortAscendingOnlyNumbers": "Сортировка по возрастанию",
  "XtraSpreadsheetStringId.MenuCmd_PivotSortAscendingOnlyNumbersDescription": "Сортировка по возрастанию.",
  "XtraSpreadsheetStringId.MenuCmd_PivotSortDescending": "Сортировка от Я до А",
  "XtraSpreadsheetStringId.MenuCmd_PivotSortDescendingDescription": "Сортировка от Я до А.",
  "XtraSpreadsheetStringId.MenuCmd_PivotSortDescendingOnlyDates": "Сортировка от новых к старым",
  "XtraSpreadsheetStringId.MenuCmd_PivotSortDescendingOnlyDatesDescription": "Сортировка от новых к старым.",
  "XtraSpreadsheetStringId.MenuCmd_PivotSortDescendingOnlyNumbers": "Сортировка по убыванию",
  "XtraSpreadsheetStringId.MenuCmd_PivotSortDescendingOnlyNumbersDescription": "Сортировка по убыванию.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableBlankRowsCommandGroup": "Пустые строки",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableBlankRowsCommandGroupDescription": "Выделение групп путем добавления пустой строки между сгруппированными элементами.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableCalculatedField": "Вычисляемое поле...",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableCalculatedItem": "Вычисляемый объект...",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableCalculatedItemSolveOrder": "Порядок вычислений...",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableClearCommandGroup": "Очистить",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableClearCommandGroupDescription": "Удаление полей, форматирования и фильтров.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableCollapseField": "Свернуть поле",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableCollapseFieldContextMenuItem": "Свернуть",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableCollapseFieldDescription": "Свертывание всех элементов активного поля.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableDateFilters": "Фильтры по дате",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableDateFiltersDescription": "Фильтры по дате.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableDoNotRepeatItemLabels": "Не повторять подписи элементов",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableDoNotShowSubtotals": "Не показывать промежуточные суммы",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableExpandCollapseCommandGroup": "Развернуть/свернуть",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableExpandCollapseCommandGroupDescription": "Развернуть/свернуть.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableExpandField": "Развернуть поле",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableExpandFieldContextMenuItem": "Развернуть",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableExpandFieldDescription": "Развертывание всех элементов активного поля.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableFieldGroup": "Группировка по полю",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableFieldGroupDescription": "Группировка полей с числами или датами.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableFieldsFilters": "Выбор поля:",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableFieldsFiltersDescription": "Выбор поля.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableFieldsItemsSetsCommandGroup": "Поля, элементы и наборы",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableFieldsItemsSetsCommandGroupDescription": "Создание и изменение вычисляемых полей и элементов.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableGrandTotalsCommandGroup": "Общие итоги",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableGrandTotalsCommandGroupDescription": "Отображение или скрытие общих итогов",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableGrandTotalsOffRowsColumns": "Отключить для строк и столбцов",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableGrandTotalsOnColumnsOnly": "Включить только для столбцов",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableGrandTotalsOnRowsColumns": "Включить для строк и столбцов",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableGrandTotalsOnRowsOnly": "Включить только для строк",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableGroupSelection": "Группировка по выделенному",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableGroupSelectionContextMenuItem": "Группировать...",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableGroupSelectionDescription": "Создание группы, содержащей выделенные элементы.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableInsertBlankLine": "Вставить пустую строку после каждого элемента",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableItemFilter": "Фильтр по полю...",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableItemFilterDescription": "Фильтр по полю...",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableLabelFilters": "Фильтры по подписи",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableLabelFiltersDescription": "Фильтры по подписи.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableListFormulas": "Вывести формулы",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableMoreOptions": "Дополнительные параметры...",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableMoreSortOptions": "Дополнительные параметры сортировки...",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableRefreshAllCommand": "Обновить все",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableRefreshCommandAndCommandGroup": "Обновить",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableRefreshDescription": "Получение новейших данных путем обновления всех источников в книге.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableRemoveBlankLine": "Удалить пустую строку после каждого элемента",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableRepeatAllItemLabels": "Повторять все подписи элементов",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableReportLayoutCommandGroup": "Макет отчета",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableReportLayoutCommandGroupDescription": "Настройка макета отчета.\n\nКомпактная форма позволяет улучшить восприятие отчета, а в табличную и структурную форму включаются заголовки полей.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableSelectCommandGroup": "Выделить",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableSelectCommandGroupDescription": "Выбор элемента сводной таблицы.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableShowAllSubtotalsAtBottom": "Показывать все промежуточные итоги в нижней части группы",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableShowAllSubtotalsAtTop": "Показывать все промежуточные итоги в заголовке группы",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableShowCompactForm": "Показать в сжатой форме",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableShowOutlineForm": "Показать в форме структуры",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableShowTabularForm": "Показать в табличной форме",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableShowValuesAs": "Дополнительные вычисления",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableSortCommandGroup": "Сортировка",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableSortCommandGroupDescription": "Сортировка.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableSubtotalsCommandGroup": "Промежуточные итоги",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableSubtotalsCommandGroupDescription": "Отображение или скрытие промежуточных итогов.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableSummarizeValuesBy": "Итоги по",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableToggleBandedColumns": "Чередующиеся столбцы",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableToggleBandedColumnsDescription": "Отображение чередующихся столбцов, при котором четные столбцы отформатированы иначе, чем нечетные.\n\nТакое чередование облегчает восприятие таблицы.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableToggleBandedRows": "Чередующиеся строки",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableToggleBandedRowsDescription": "Отображение чередующихся строк, при котором четные строки отформатированы иначе, чем нечетные.\n\nТакое чередование облегчает восприятие таблицы.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableToggleColumnHeaders": "Заголовки столбцов",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableToggleColumnHeadersDescription": "Применение особого форматирования к первому столбцу таблицы.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableToggleRowHeaders": "Заголовки строк",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableToggleRowHeadersDescription": "Применение особого форматирования к первой строке таблицы.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableUngroup": "Разгруппировать",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableUngroupContextMenuItem": "Разгруппировать...",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableUngroupDescription": "Разгруппирование ранее сгруппированного диапазона ячеек.",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableValueFilters": "Фильтры по значению",
  "XtraSpreadsheetStringId.MenuCmd_PivotTableValueFiltersDescription": "Фильтры по значению.",
  "XtraSpreadsheetStringId.MenuCmd_RemoveCellsCommandGroup": "Удалить",
  "XtraSpreadsheetStringId.MenuCmd_RemoveCellsCommandGroupDescription": "Удаление ячеек, строк или столбцов из таблицы или с листа.",
  "XtraSpreadsheetStringId.MenuCmd_RemoveGrandTotalPivotTable": "Удалить общий итог",
  "XtraSpreadsheetStringId.MenuCmd_RemoveGrandTotalPivotTableDescription": "Удалить общий итог.",
  "XtraSpreadsheetStringId.MenuCmd_RemovePivotField": "Удалить \"{0}\"",
  "XtraSpreadsheetStringId.MenuCmd_RemovePivotFieldDescription": "Удалить \"{0}\".",
  "XtraSpreadsheetStringId.MenuCmd_RemoveSheet": "Удалить лист",
  "XtraSpreadsheetStringId.MenuCmd_RemoveSheetColumns": "Удалить столбцы из листа",
  "XtraSpreadsheetStringId.MenuCmd_RemoveSheetColumnsContextMenuItem": "Удалить",
  "XtraSpreadsheetStringId.MenuCmd_RemoveSheetColumnsContextMenuItemDescription": "Удаление столбцов из листа.",
  "XtraSpreadsheetStringId.MenuCmd_RemoveSheetColumnsDescription": "Удаление столбцов из листа.",
  "XtraSpreadsheetStringId.MenuCmd_RemoveSheetContextMenuItem": "Удалить",
  "XtraSpreadsheetStringId.MenuCmd_RemoveSheetContextMenuItemDescription": "Удаление листа.",
  "XtraSpreadsheetStringId.MenuCmd_RemoveSheetDescription": "Удаление листа.",
  "XtraSpreadsheetStringId.MenuCmd_RemoveSheetRows": "Удалить строки из листа",
  "XtraSpreadsheetStringId.MenuCmd_RemoveSheetRowsContextMenuItem": "Удалить",
  "XtraSpreadsheetStringId.MenuCmd_RemoveSheetRowsContextMenuItemDescription": "Удаление строк из листа.",
  "XtraSpreadsheetStringId.MenuCmd_RemoveSheetRowsDescription": "Удаление строк из листа.",
  "XtraSpreadsheetStringId.MenuCmd_RemoveTableCellsCommandGroup": "Удалить",
  "XtraSpreadsheetStringId.MenuCmd_RemoveTableCellsCommandGroupDescription": "Удаление строк или столбцов из таблицы.",
  "XtraSpreadsheetStringId.MenuCmd_RemoveTableColumns": "Удалить столбцы таблицы",
  "XtraSpreadsheetStringId.MenuCmd_RemoveTableColumnsContextMenuItem": "Столбцы таблицы",
  "XtraSpreadsheetStringId.MenuCmd_RemoveTableColumnsDescription": "Удаление столбцов из таблицы.",
  "XtraSpreadsheetStringId.MenuCmd_RemoveTableRows": "Удалить строки таблицы",
  "XtraSpreadsheetStringId.MenuCmd_RemoveTableRowsContextMenuItem": "Строки таблицы",
  "XtraSpreadsheetStringId.MenuCmd_RemoveTableRowsDescription": "Удаление строк из таблицы.",
  "XtraSpreadsheetStringId.MenuCmd_RenameSheet": "Переименовать лист...",
  "XtraSpreadsheetStringId.MenuCmd_RenameSheetContextMenuItem": "Переименовать...",
  "XtraSpreadsheetStringId.MenuCmd_RenameSheetContextMenuItemDescription": "Переменование листа.",
  "XtraSpreadsheetStringId.MenuCmd_RenameSheetDescription": "Переменование листа.",
  "XtraSpreadsheetStringId.MenuCmd_ReviewDeleteCommentContextMenuItem": "Удалить примечание",
  "XtraSpreadsheetStringId.MenuCmd_ReviewDeleteCommentContextMenuItemDescription": "Удаление выделенного примечания.",
  "XtraSpreadsheetStringId.MenuCmd_ReviewInsertCommentContextMenuItem": "Вставить примечание",
  "XtraSpreadsheetStringId.MenuCmd_ReviewInsertCommentContextMenuItemDescription": "Добавление примечания к текущей части документа.",
  "XtraSpreadsheetStringId.MenuCmd_ReviewProtectSheet": "Защитить лист",
  "XtraSpreadsheetStringId.MenuCmd_ReviewProtectSheetContextMenuItem": "Защитить лист...",
  "XtraSpreadsheetStringId.MenuCmd_ReviewProtectSheetDescription": "Запрет на внесение нежелательных изменений другими пользователями путем ограничения их права на редактирование.\n\nНапример, можно запретить пользователям редактировать заблокированные ячейки или изменять форматирование документа.",
  "XtraSpreadsheetStringId.MenuCmd_ReviewProtectWorkbook": "Защитить книгу",
  "XtraSpreadsheetStringId.MenuCmd_ReviewProtectWorkbookDescription": "Запрет на внесение нежелательных изменений в структуру книги, таких как перемещение, удаление или добавление листов.\n\nМожно указать пароль, который должен быть введен для снятия защиты книги и отмены запрета на внесение изменений.",
  "XtraSpreadsheetStringId.MenuCmd_ReviewShowHideComment": "Показать или скрыть примечание",
  "XtraSpreadsheetStringId.MenuCmd_ReviewShowHideCommentDescription": "Отображение или скрытие примечания к выделенной ячейке.",
  "XtraSpreadsheetStringId.MenuCmd_ReviewShowProtectedRangeManager": "Разрешить изменение диапазонов",
  "XtraSpreadsheetStringId.MenuCmd_ReviewShowProtectedRangeManagerDescription": "Установка защиты паролем для диапазонов и выбор пользователей, которые могут редактировать эти диапазоны.\n\nПосле настройки выполните команду \"Защитить лист\", чтобы активировать защищенные паролем диапазоны.",
  "XtraSpreadsheetStringId.MenuCmd_ReviewUnprotectSheet": "Снять защиту листа",
  "XtraSpreadsheetStringId.MenuCmd_ReviewUnprotectSheetContextMenuItem": "Снять защиту листа...",
  "XtraSpreadsheetStringId.MenuCmd_ReviewUnprotectSheetDescription": "Запрет на внесение нежелательных изменений другими пользователями путем ограничения их права на редактирование.\n\nНапример, можно запретить пользователям редактировать заблокированные ячейки или изменять форматирование документа.",
  "XtraSpreadsheetStringId.MenuCmd_ReviewUnprotectWorkbook": "Снять защиту книги",
  "XtraSpreadsheetStringId.MenuCmd_ReviewUnprotectWorkbookDescription": "Запрет на внесение нежелательных изменений в структуру книги, таких как перемещение, удаление или добавление листов.\n\nМожно указать пароль, который должен быть введен для снятия защиты книги и отмены запрета на внесение изменений.",
  "XtraSpreadsheetStringId.MenuCmd_SelectEntirePivotTable": "Всю сводную таблицу",
  "XtraSpreadsheetStringId.MenuCmd_SelectEntirePivotTableDescription": "Выделить всю сводную таблицу",
  "XtraSpreadsheetStringId.MenuCmd_SelectFieldTypePivotTable": "Параметры поля",
  "XtraSpreadsheetStringId.MenuCmd_SelectFieldTypePivotTableDescription": "Открытие диалогового окна \"Параметры поля\".",
  "XtraSpreadsheetStringId.MenuCmd_SelectLabelsAndValuesPivotTable": "Заголовки и значения",
  "XtraSpreadsheetStringId.MenuCmd_SelectLabelsAndValuesPivotTableDescription": "Выделить заголовки и значения",
  "XtraSpreadsheetStringId.MenuCmd_SelectLabelsPivotTable": "Заголовки",
  "XtraSpreadsheetStringId.MenuCmd_SelectLabelsPivotTableDescription": "Выделить заголовки",
  "XtraSpreadsheetStringId.MenuCmd_SelectValuesPivotTable": "Значения",
  "XtraSpreadsheetStringId.MenuCmd_SelectValuesPivotTableDescription": "Выделить значения",
  "XtraSpreadsheetStringId.MenuCmd_ShowDetailCommand": "Отобразить детали",
  "XtraSpreadsheetStringId.MenuCmd_ShowDetailCommandDescription": "Развертывание свернутой группы ячеек.",
  "XtraSpreadsheetStringId.MenuCmd_ShowDocumentProperties": "Свойства документа",
  "XtraSpreadsheetStringId.MenuCmd_ShowDocumentPropertiesDescription": "Открытие диалогового окна \"Свойства документа\".",
  "XtraSpreadsheetStringId.MenuCmd_ShowFieldListPanelPivotTableContextMenuItem": "Показать список полей",
  "XtraSpreadsheetStringId.MenuCmd_ShowInsertSheetCellsForm": "Вставить ячейки...",
  "XtraSpreadsheetStringId.MenuCmd_ShowInsertSheetCellsFormDescription": "Добавление новых строк, столбцов, ячеек или листов в книгу.\n    \nНовые строки добавляются над выделенным диапазоном, а новые столбцы – слева от него.\n\nЕсли выделены три столбца, будут одновременно добавлены три новых столбца. То же правило относится и к добавлению нескольких строк.",
  "XtraSpreadsheetStringId.MenuCmd_ShowNameManager": "Диспетчер имен",
  "XtraSpreadsheetStringId.MenuCmd_ShowNameManagerDescription": "Создание, изменение, удаление, а также поиск всех имен, используемых в книге.\n\nИмена можно использовать в формулах вместо ссылок на ячейки.\n\nНапример: \"=СУММ(МоиПродажи)\" вместо \"=СУММ(C20:C30)\".",
  "XtraSpreadsheetStringId.MenuCmd_ShowPivotTableExpandCollapseButton": "Кнопки +/-",
  "XtraSpreadsheetStringId.MenuCmd_ShowPivotTableExpandCollapseButtonDescription": "Отображение или скрытие кнопок \"плюс\" (+) и \"минус\" (-).\n\nЭти кнопки позволяют развернуть или свернуть элементы сводной таблицы.",
  "XtraSpreadsheetStringId.MenuCmd_ShowPivotTableFieldHeaders": "Заголовки полей",
  "XtraSpreadsheetStringId.MenuCmd_ShowPivotTableFieldHeadersDescription": "Отображение заголовков полей для строк и столбцов.",
  "XtraSpreadsheetStringId.MenuCmd_SortAscending": "Сортировка от А до Я",
  "XtraSpreadsheetStringId.MenuCmd_SortAscendingDates": "Сортировка от старых к новым",
  "XtraSpreadsheetStringId.MenuCmd_SortAscendingDescription": "Соритровка по возрастанию.",
  "XtraSpreadsheetStringId.MenuCmd_SortAscendingNumbers": "Сортировка по возрастанию",
  "XtraSpreadsheetStringId.MenuCmd_SortDescending": "Сортировка от Я до А",
  "XtraSpreadsheetStringId.MenuCmd_SortDescendingDates": "Сортировка от новых к старым",
  "XtraSpreadsheetStringId.MenuCmd_SortDescendingDescription": "Сортировка по убыванию.",
  "XtraSpreadsheetStringId.MenuCmd_SortDescendingNumbers": "Сортировка по убыванию",
  "XtraSpreadsheetStringId.MenuCmd_StatusBarPopupMenuAverage": "Average",
  "XtraSpreadsheetStringId.MenuCmd_StatusBarPopupMenuCount": "Count",
  "XtraSpreadsheetStringId.MenuCmd_StatusBarPopupMenuMax": "Max",
  "XtraSpreadsheetStringId.MenuCmd_StatusBarPopupMenuMin": "Min",
  "XtraSpreadsheetStringId.MenuCmd_StatusBarPopupMenuNumericalCount": "Numerical Count",
  "XtraSpreadsheetStringId.MenuCmd_StatusBarPopupMenuSum": "Sum",
  "XtraSpreadsheetStringId.MenuCmd_SubtotalCommand": "Промежуточный итог",
  "XtraSpreadsheetStringId.MenuCmd_SubtotalCommandDescription": "Быстрый подсчет промежуточных и общих итогов для строк взаимосвязанных данных и вставка полученных значений на лист.",
  "XtraSpreadsheetStringId.MenuCmd_SubtotalPivotField": "Промежуточный итог \"{0}\"",
  "XtraSpreadsheetStringId.MenuCmd_SumInfoStatusBarCommandCaptionPart": "СУММА:",
  "XtraSpreadsheetStringId.MenuCmd_SumInfoStatusBarCommandDescription": "Сумма выделенных ячеек",
  "XtraSpreadsheetStringId.MenuCmd_TableToolsConvertToRange": "Преобразовать в диапазон",
  "XtraSpreadsheetStringId.MenuCmd_TableToolsConvertToRangeDescription": "Преобразование данной таблицы в обычный диапазон ячеек.\n\nПотери данных не происходит.",
  "XtraSpreadsheetStringId.MenuCmd_TableToolsRenameTableCommand": "Имя таблицы",
  "XtraSpreadsheetStringId.MenuCmd_TableToolsRenameTableCommandDescription": "Изменение имени данной таблицы, на которое ссылаются формулы.",
  "XtraSpreadsheetStringId.MenuCmd_TableToolsToggleBandedColumnsCommand": "Чередующиеся столбцы",
  "XtraSpreadsheetStringId.MenuCmd_TableToolsToggleBandedColumnsCommandDescription": "Отображение чередующихся столбцов, при котором четные столбцы отформатированы иначе, чем нечетные.\n\nТакое чередование облегчает восприятие таблицы.",
  "XtraSpreadsheetStringId.MenuCmd_TableToolsToggleBandedRowsCommand": "Чередующиеся строки",
  "XtraSpreadsheetStringId.MenuCmd_TableToolsToggleBandedRowsCommandDescription": "Отображение чередующихся строк, при котором четные строки отформатированы иначе, чем нечетные.\n\nТакое чередование облегчает восприятие таблицы.",
  "XtraSpreadsheetStringId.MenuCmd_TableToolsToggleFirstColumnCommand": "Первый столбец",
  "XtraSpreadsheetStringId.MenuCmd_TableToolsToggleFirstColumnCommandDescription": "Применение особого форматирования к первому столбцу таблицы.",
  "XtraSpreadsheetStringId.MenuCmd_TableToolsToggleHeaderRowCommand": "Строка заголовка",
  "XtraSpreadsheetStringId.MenuCmd_TableToolsToggleHeaderRowCommandDescription": "Отображение или скрытие строки заголовка в таблице.\n\nСтрока заголовка - это верхняя строка таблицы, которая форматируется особым образом.",
  "XtraSpreadsheetStringId.MenuCmd_TableToolsToggleLastColumnCommand": "Последний столбец",
  "XtraSpreadsheetStringId.MenuCmd_TableToolsToggleLastColumnCommandDescription": "Применение особого форматирования к последнему столбцу таблицы.",
  "XtraSpreadsheetStringId.MenuCmd_TableToolsToggleTotalRowCommand": "Строка итогов",
  "XtraSpreadsheetStringId.MenuCmd_TableToolsToggleTotalRowCommandDescription": "Отображение или скрытие строки итогов в таблице.\n\nСтрока итогов - это строка в конце таблицы, в которой отображаются итоги для каждого столбца.",
  "XtraSpreadsheetStringId.MenuCmd_ToggleCellLocked": "Блокировать ячейку",
  "XtraSpreadsheetStringId.MenuCmd_ToggleCellLockedDescription": "Блокирование выделенных ячеек, которое запрещает другим пользователям вносить в них изменения.\n\nЧтобы воспользоваться этой командой, необходимо включить защиту листа.",
  "XtraSpreadsheetStringId.MenuCmd_UngroupCommand": "Разгруппировать",
  "XtraSpreadsheetStringId.MenuCmd_UngroupCommandDescription": "Разгруппирование ранее сгруппированного диапазона ячеек.",
  "XtraSpreadsheetStringId.MenuCmd_UngroupFormCaption": "Разгруппировать",
  "XtraSpreadsheetStringId.MenuCmd_UnhideColumns": "Отобразить столбцы",
  "XtraSpreadsheetStringId.MenuCmd_UnhideColumnsContextMenuItem": "Показать",
  "XtraSpreadsheetStringId.MenuCmd_UnhideColumnsContextMenuItemDescription": "Отображение столбцов.",
  "XtraSpreadsheetStringId.MenuCmd_UnhideColumnsDescription": "Отображение столбцов.",
  "XtraSpreadsheetStringId.MenuCmd_UnhideRows": "Отобразить строки",
  "XtraSpreadsheetStringId.MenuCmd_UnhideRowsContextMenuItem": "Показать",
  "XtraSpreadsheetStringId.MenuCmd_UnhideRowsContextMenuItemDescription": "Отображение строк.",
  "XtraSpreadsheetStringId.MenuCmd_UnhideRowsDescription": "Отображение строк.",
  "XtraSpreadsheetStringId.MenuCmd_UnhideSheet": "Отобразить лист...",
  "XtraSpreadsheetStringId.MenuCmd_UnhideSheetContextMenuItem": "Показать...",
  "XtraSpreadsheetStringId.MenuCmd_UnhideSheetContextMenuItemDescription": "Открытие диалогового окна \"Вывод на экран скрытого листа\".",
  "XtraSpreadsheetStringId.MenuCmd_UnhideSheetDescription": "Открытие диалогового окна \"Вывод на экран скрытого листа\".",
  "XtraSpreadsheetStringId.MenuCmd_ViewFreezeFirstColumn": "Закрепить первый столбец",
  "XtraSpreadsheetStringId.MenuCmd_ViewFreezeFirstColumnDescription": "Первый столбец всегда будет виден на экране во время прокрутки листа.",
  "XtraSpreadsheetStringId.MenuCmd_ViewFreezePanes": "Закрепить области",
  "XtraSpreadsheetStringId.MenuCmd_ViewFreezePanesCommandGroup": "Закрепить области",
  "XtraSpreadsheetStringId.MenuCmd_ViewFreezePanesCommandGroupDescription": "Закрепление на экране части листа, которая должна быть видима при прокрутке остальной его части.\n\nЭто удобно, если нужно просмотреть данные в разных частях листа, не теряя из вида заголовки строк или столбцов.",
  "XtraSpreadsheetStringId.MenuCmd_ViewFreezePanesDescription": "Выделенные строки и столбцы всегда будут видны на экране во время прокрутки листа.",
  "XtraSpreadsheetStringId.MenuCmd_ViewFreezeTopRow": "Закрепить верхнюю строку",
  "XtraSpreadsheetStringId.MenuCmd_ViewFreezeTopRowDescription": "Верхняя строка всегда будет видна на экране во время прокрутки листа.",
  "XtraSpreadsheetStringId.MenuCmd_ViewShowFormulas": "Показать формулы",
  "XtraSpreadsheetStringId.MenuCmd_ViewShowFormulasDescription": "Отображение в каждой ячейке формулы, а не значения результата.",
  "XtraSpreadsheetStringId.MenuCmd_ViewShowGridlines": "Сетка",
  "XtraSpreadsheetStringId.MenuCmd_ViewShowGridlinesDescription": "Отображение линий между строками и столбцами листа для упрощения редактирования и просмотра.",
  "XtraSpreadsheetStringId.MenuCmd_ViewShowHeadings": "Заголовки",
  "XtraSpreadsheetStringId.MenuCmd_ViewShowHeadingsDescription": "Отображение заголовков строк и столбцов.\n    \nЗаголовки строк – это номера строк в левой или правой части листа.\n\nЗаголовки столбцов – это буквы или цифры, которые отображаются над столбцами листа.",
  "XtraSpreadsheetStringId.MenuCmd_ViewUnfreezePanes": "Снять закрепление областей",
  "XtraSpreadsheetStringId.MenuCmd_ViewUnfreezePanesDescription": "Ранее закрепленные строки и столбцы станут прокручиваться вместе с остальным листом.",
  "XtraSpreadsheetStringId.MenuCmd_ViewZoom": "Масштаб",
  "XtraSpreadsheetStringId.MenuCmd_ViewZoomDescription": "Настройка подходящего вам масштаба.",
  "XtraSpreadsheetStringId.MoveOrCopySheetForm_Copy": "Скопировать",
  "XtraSpreadsheetStringId.MoveOrCopySheetForm_Move": "Переместить",
  "XtraSpreadsheetStringId.MoveOrCopySheetForm_MoveToEnd": "(переместить в конец)",
  "XtraSpreadsheetStringId.Msg_ArrayFormulaRange": "array formula range",
  "XtraSpreadsheetStringId.Msg_BindedDataSourceDoesNotAllowEditing": "A cell range you're trying to modify is bound to a data source that does not allow editing.",
  "XtraSpreadsheetStringId.Msg_BindedDataSourcePropertyIsReadonly": "A cell range you're trying to modify is bound to the read-only data source field.",
  "XtraSpreadsheetStringId.Msg_BindingRangeHasMergedCells": "Cannot create a data source from the cell range containing merged cells.",
  "XtraSpreadsheetStringId.Msg_BuiltInFunctionNotFound": "Встроенная функция не найдена.",
  "XtraSpreadsheetStringId.Msg_BuiltInReplaceInvalidParameter": "Custom function and built-in function must have Parameter {0} of the same type.",
  "XtraSpreadsheetStringId.Msg_BuiltInReplaceInvalidParametersCount": "Custom function must have the same number of parameters as the built-in function being replaced.",
  "XtraSpreadsheetStringId.Msg_BuiltInReplaceInvalidReturnType": "Custom function must have the same ReturnDataType as the built-in function being replaced.",
  "XtraSpreadsheetStringId.Msg_BuiltInReplaceInvalidVolatile": "Custom function must have the same Volatile property value as the built-in function being replaced.",
  "XtraSpreadsheetStringId.Msg_CannotAddCalculatedItemIfCustomSubtotalsExists": "Calculated items do not work with custom subtotals.",
  "XtraSpreadsheetStringId.Msg_CannotAddCalculatedItemToGroupedField": "You cannot add a calculated item to a grouped field. Ungroup the field and insert the calcualted item. After inserted, you can group the items of the field again.",
  "XtraSpreadsheetStringId.Msg_CannotAddCalculatedItemToMultiAxisField": "If one or more fields in PivotTable have calculated items, no fields can be used in the data area two or more time, or in the data area and another area at the same time. Change the PivotTable report so that no field is used more than once and then add the calculated item.",
  "XtraSpreadsheetStringId.Msg_CannotAddFieldWithCalculatedItemToPageFields": "Cannot add the field with a calculated item to the filter area.",
  "XtraSpreadsheetStringId.Msg_CannotAddMultiAxisFieldIfContainsCalculatedItem": "If one or more fields in the PivotTable have calculated items, no fields can be used in the data area and another area at the same time. Remove the calculated items and add the field again.",
  "XtraSpreadsheetStringId.Msg_CannotAddMultiDataFieldIfContainsCalculatedItem": "Multiple data fields of the same field are not supported when PivotTable report has calculated items.",
  "XtraSpreadsheetStringId.Msg_CannotAddOrRemoveColumnsFromBindingRange": "Cannot add/remove a column to/from a data source range.",
  "XtraSpreadsheetStringId.Msg_CannotBeModifiedCellsWithFormulasInBindingRange": "Cannot change data in the selected cell range. It contains formulas that belong to a data source range and cannot be modified.",
  "XtraSpreadsheetStringId.Msg_CannotBeModifiedCellsWithFormulasInBindingRangeAPI": "Cannot change data in the selected cell range. It contains formulas belonging to a data source range for which the PreserveFormulas option is set.",
  "XtraSpreadsheetStringId.Msg_CannotChangeAppliedStyleType": "Style is already applied to pivot or table. It's type can be only changed to support both.",
  "XtraSpreadsheetStringId.Msg_CannotChangeDefaultOrPredefinedStyleType": "Type of default or predefined style cannot be changed.",
  "XtraSpreadsheetStringId.Msg_CannotChangeValueCellInBindingRangeAPI": "Cannot change a value of a cell from a data source range for which the AllowEdit option is not set.",
  "XtraSpreadsheetStringId.Msg_CannotCreateOutline": "Невозможно создать структуру документа.",
  "XtraSpreadsheetStringId.Msg_CannotExportActiveXControls": "ActiveX controls cannot be transferred to the selected file format. The controls will be lost.",
  "XtraSpreadsheetStringId.Msg_CannotExportEmptyWorkbook": "A workbook must contain at least one sheet.",
  "XtraSpreadsheetStringId.Msg_CannotFilterInBindingRange": "Cannot filter data in the specified data-bound range.",
  "XtraSpreadsheetStringId.Msg_CannotFilterInBindingRangeAPI": "Cannot filter data in the data-bound range when the SkipHiddenRows property is set to true.",
  "XtraSpreadsheetStringId.Msg_CannotFilterPartDataSourceRange": "Cannot apply filtering to the specified part of the data source range.",
  "XtraSpreadsheetStringId.Msg_CannotFilterPartDataSourceRangeAPI": "Cannot filter a part of a data source range when the SkipHiddenRows property is set to true.",
  "XtraSpreadsheetStringId.Msg_CannotMergeCellsContainedInBindingRange": "Cannot merge cells that belong to a data source range.",
  "XtraSpreadsheetStringId.Msg_CannotModifyTableWithDataBinding": "Cannot modify the table that contains a data binding.",
  "XtraSpreadsheetStringId.Msg_CannotMoveBindingRangeToOtherSheet": "The selected cell range is associated with a data source and cannot be moved to another worksheet.",
  "XtraSpreadsheetStringId.Msg_CannotRemoveAllRowsFromBindingRange": "Cannot remove all rows from a data source range. It must contain at least one row.",
  "XtraSpreadsheetStringId.Msg_CanNotShiftNonBlankCellsOffOfTheSheet": "To prevent possible loss of data, Spreasheet cannot shift nonblank cells off of the worksheet. Select another location in which to insert new cells, or delete data from the end of your worksheet.",
  "XtraSpreadsheetStringId.Msg_CannotTableContainMultipleDataBindings": "A table cannot contain multiple data bindings.",
  "XtraSpreadsheetStringId.Msg_CanReplaceTheContentsOfTheDestinationCells": "Заменить содержимое конечных ячеек?",
  "XtraSpreadsheetStringId.Msg_CanSaveChangesNameReference": "Сохранить изменения, внесенные в ссылку на имя?",
  "XtraSpreadsheetStringId.Msg_CantDoThatToAMergedCell": "We cannot do that to a merged cell.",
  "XtraSpreadsheetStringId.Msg_CantExportPivotCacheSourceExternal": "Pivot cache with external source is not supported.",
  "XtraSpreadsheetStringId.Msg_CantReplaceOnProtectedSheet": "Нельзя использовать данную команду на защищенном листе. Чтобы использовать данную команду, необходимо сначала снять защиту листа (вкладка \"Рецензирование\", группа \"Изменения\", кнопка \"Снять защиту листа\"). Возможно, потребуется ввести пароль.",
  "XtraSpreadsheetStringId.Msg_CellOnSheet": "Cell {0} on sheet \"{1}\"",
  "XtraSpreadsheetStringId.Msg_CellOrChartIsReadonly": "Ячейка или диаграмма, которую вы собираетесь изменить находится на защищенном листе.\n\nЧтобы внести изменения, выберите команду \"Снять защиту листа\" на вкладке \"Рецензирование\" (может потребоваться пароль).\n    ",
  "XtraSpreadsheetStringId.Msg_CellOrChartIsReadonlyShort": "Ячейка или диаграмма, которую вы собираетесь изменить находится на защищенном листе.",
  "XtraSpreadsheetStringId.Msg_CellsWillBeUnmergedAfterInsertingIntoTable": "Исходные данные содержат объединенные ячейки. Перед вставкой этих ячеек в таблицу следует отменить объединение.",
  "XtraSpreadsheetStringId.Msg_ChangingRangeOfAutoFilterNotAllowed": "This operation is attempting to change a filtered range on a worksheet and can not be completed. To complete this operation, Autofilters in the sheet need to be removed.",
  "XtraSpreadsheetStringId.Msg_ChartDataRangeIntersectPivotTable": "Chart data range can not intersect pivot table(s).",
  "XtraSpreadsheetStringId.Msg_CircularReference": "Circular Reference Warning\n\nOne or more formulas contain a circular reference and may not calculate correctly. Circular references are any references within a formula that depend upon the results of that same formula.\nFor example, a cell that refers to its own value or a cell that refers to another cell which depends on the original cell's value both contain circular references.",
  "XtraSpreadsheetStringId.Msg_ColumnIndexOutOfRange": "Column index is out of range.",
  "XtraSpreadsheetStringId.Msg_CommandRequiresAtLeastTwoRows": "This command requires at least two rows of source data. You cannot use this command on a selection in only one row.",
  "XtraSpreadsheetStringId.Msg_CondFmtExpressionCantBeAnArray": "Array can not be used in conditional formatting formula.",
  "XtraSpreadsheetStringId.Msg_CondFmtExpressionCantContainErrorValues": "Expression can not contain error value.",
  "XtraSpreadsheetStringId.Msg_CondFmtExpressionCantContainRelativeRefs": "Expression can not contain relative references.",
  "XtraSpreadsheetStringId.Msg_CondFmtIncorectValueType": "Incorrect value type",
  "XtraSpreadsheetStringId.Msg_ConfirmDeleteDefinedName": "Are you sure you want to delete the name {0} ?",
  "XtraSpreadsheetStringId.Msg_ConfirmDeleteDefinedNames": "Are you sure you want to delete the selected names?",
  "XtraSpreadsheetStringId.Msg_ConfirmModifyExistingOutline": "Modify existing outline?",
  "XtraSpreadsheetStringId.Msg_CouldNotCreatePropertyDecsriptorCollection": "Cannot create a PropertyDescriptorCollection instance.",
  "XtraSpreadsheetStringId.Msg_CustomAssemblyWarning": "You are about to load a third-party library: '{0}'.\n\nBefore you proceed, please consider resulting security risks and make sure that this library is supplied from a trusted source.",
  "XtraSpreadsheetStringId.Msg_CustomFunctionAlreadyDefined": "Function with same name is already defined.",
  "XtraSpreadsheetStringId.Msg_CustomFunctionInvalidName": "The function name is not valid. It should start with a letter or an underscore, and should not contain the following symbols: \\ / ? : * [ or ].",
  "XtraSpreadsheetStringId.Msg_CustomFunctionInvalidParameters": "The specified function parameters are invalid. Maximum number of parameters is 255. Required parameters should precede optional parameters. Unlimited parameter should be the final parameter. Array should not contain empty values.",
  "XtraSpreadsheetStringId.Msg_DataValidationBothFormulasAreEmpty": "Необходимо ввести значение и в поле \"{0}\", и в поле \"{1}\".",
  "XtraSpreadsheetStringId.Msg_DataValidationDefinedNameNotFound": "Указанный именованный диапазон не найден.",
  "XtraSpreadsheetStringId.Msg_DataValidationFailed": "Введенное значение неверно.\n\nНабор значений, которые могут быть введены в ячейку, ограничен.",
  "XtraSpreadsheetStringId.Msg_DataValidationFormulaIsEmpty": "Необходимо ввести значение в поле \"{0}\".",
  "XtraSpreadsheetStringId.Msg_DataValidationInvalidDate": "В поле \"{0}\" введена недопустимая дата.",
  "XtraSpreadsheetStringId.Msg_DataValidationInvalidDecimalValue": "В условиях \"{0}\" нельзя использовать значения, не являющиеся целыми числами.",
  "XtraSpreadsheetStringId.Msg_DataValidationInvalidNegativeValue": "В условиях \"{0}\" нельзя использовать отрицательные значения.",
  "XtraSpreadsheetStringId.Msg_DataValidationInvalidNonnumericValue": "Поле \"{0}\" должно содержать числовое значение, численное выражение или ссылку на ячейку с числовым значением.",
  "XtraSpreadsheetStringId.Msg_DataValidationInvalidReference": "Такой тип ссылки нельзя использовать в формуле Проверки данных.",
  "XtraSpreadsheetStringId.Msg_DataValidationInvalidTime": "В поле \"{0}\" введено недопустимое время.",
  "XtraSpreadsheetStringId.Msg_DataValidationMinGreaterThanMax": "Значение в поле \"{0}\" должно быть больше или равно значению в поле \"{1}\".",
  "XtraSpreadsheetStringId.Msg_DataValidationMoreThanOneCellInRange": "Такой тип ссылки нельзя использовать в формуле Проверки данных.\n\nВведите ссылку на одну ячейку или используйте функцию, например =СУММ(A1:E5).",
  "XtraSpreadsheetStringId.Msg_DataValidationMustBeRowOrColumnRange": "Источник списка должен быть списком с разделителями или ссылкой на одну строку или столбец.",
  "XtraSpreadsheetStringId.Msg_DataValidationUnionRangeNotAllowed": "Нельзя использовать операторы ссылок (такие как объединения, пересечения и диапазоны) или константы массивов для условий Проверка данных.",
  "XtraSpreadsheetStringId.Msg_DefaultCellXFUsed": "Possible loss of formatting: default cell format is used instead of original formatting.",
  "XtraSpreadsheetStringId.Msg_DefaultStyleXFUsed": "Possible loss of formatting: default style format is used instead of original formatting.",
  "XtraSpreadsheetStringId.Msg_DefinedNameHasBeenChanged": "Defined name \"{0}\"({1}): name has been changed to \"{2}\".",
  "XtraSpreadsheetStringId.Msg_DefinedNameHasInvalidExpression": "Defined name \"{0}\"({1}): parsed expression is not valid. Replaced by error #REF.",
  "XtraSpreadsheetStringId.Msg_DefinedNameHasInvalidScope": "Defined name \"{0}\" has invalid scope. Ignored.",
  "XtraSpreadsheetStringId.Msg_DefinedNameInvalidName": "The name you entered is not valid.\n\nReasons for this can include:\n\n    - The name does not begin with a letter or underscore\n    - The name contains a space or other invalid characters\n    - The name conflicts with a built-in name or the name of another object in the workbook.",
  "XtraSpreadsheetStringId.Msg_DeleteSheetConfirmation": "Отменить удаление листов невозможно. Возможно, на некоторых из них имеются данные. Если они не нужны, нажмите кнопку \"OK\".",
  "XtraSpreadsheetStringId.Msg_DiffRangeTypesCanNotBeChanged": "The command can not be used with selections that contain entire rows or columns, and also other cells. Try selecting only entire rows, entire columns, or just groups of cells.",
  "XtraSpreadsheetStringId.Msg_ElfLelToError": "deleted natural language formula reference has been replaced by error #NAME!.",
  "XtraSpreadsheetStringId.Msg_ElfToRef": "natural language formula has been replaced by cell reference.",
  "XtraSpreadsheetStringId.Msg_EncryptedFileIntegrityCheckFailed": "This file may have been tampered with or corrupted and the contents should not be trusted. Do you wish to continue opening this file?",
  "XtraSpreadsheetStringId.Msg_ErrorAddCondFmtToIncorrectSheet": "Conditional formatting can be added only to a worksheet that contains the cell range with this formatting.",
  "XtraSpreadsheetStringId.Msg_ErrorAddCustomShape": "You cannot create a custom geometric shape.",
  "XtraSpreadsheetStringId.Msg_ErrorArrayFormulaCannotContainLockedAndUnlockedCells": "Невозможно ввести формулу массива в диапазон, в котором лишь некоторые ячейки заблокированы или разблокированы.",
  "XtraSpreadsheetStringId.Msg_ErrorAttemptToCreateArrayFormulaInMergedCells": "Creating array formulas in merged cells is not allowed.",
  "XtraSpreadsheetStringId.Msg_ErrorAttemptToCreateSharedFormulaInMergedCells": "This operation is not allowed in merged cells.",
  "XtraSpreadsheetStringId.Msg_ErrorAttemptToHideAllColumns": "Cannot hide all columns in a worksheet.",
  "XtraSpreadsheetStringId.Msg_ErrorAttemptToHideAllRows": "Cannot hide all rows in a worksheet.",
  "XtraSpreadsheetStringId.Msg_ErrorAttemptToRemoveArrayFormula": "Range does not contain array formulas.",
  "XtraSpreadsheetStringId.Msg_ErrorAttemptToRemoveRangeWithLockedCells": "You are trying to delete a range that contains a locked cell. Locked cells cannot be deleted while the worksheet is protected.\n\nTo delete a locked cell, first remove protection using the Unprotect Sheet command (Review tab, Changes group). You may be prompted for a password.",
  "XtraSpreadsheetStringId.Msg_ErrorAttemptToRemoveTableHeader": "Невозможно удалить строку, содержащую заголовок таблицы.",
  "XtraSpreadsheetStringId.Msg_ErrorAxisGroupCannotBeChanged": "Cannot change the axis type for this data series in the current chart view collection.",
  "XtraSpreadsheetStringId.Msg_ErrorBlankSheetName": "Имя листа не должно быть пустым.",
  "XtraSpreadsheetStringId.Msg_ErrorCannotChangingMergedCell": "This operation cannot be performed over merged cells.",
  "XtraSpreadsheetStringId.Msg_ErrorCannotChangingPartOfAnArray": "You cannot change part of an array.",
  "XtraSpreadsheetStringId.Msg_ErrorCanNotCreateTable": "Cannot create a table in the specified position.",
  "XtraSpreadsheetStringId.Msg_ErrorCellIndexInRangeOutOfRange": "Cell index in a range should be non-negative and less than the number of cells in a range.",
  "XtraSpreadsheetStringId.Msg_ErrorChangingPartOfAMergedCell": "Changing part of a merged cell is not allowed.",
  "XtraSpreadsheetStringId.Msg_ErrorChangingPartOfAnArray": "Невозможно изменить часть массива.",
  "XtraSpreadsheetStringId.Msg_ErrorChartSheetIndexOutside": "ChartSheet index should be positive and less than the number of ChartSheets.",
  "XtraSpreadsheetStringId.Msg_ErrorChartSheetToBeDeletedNotFound": "ChartSheet is not found in a workbook.",
  "XtraSpreadsheetStringId.Msg_ErrorChartSheetWithNameNotFound": "ChartSheet with this name is not found.",
  "XtraSpreadsheetStringId.Msg_ErrorClearDefinedNamesCollectionReferencedQueryTable": "Cannot clear the defined name collection. It contains a defined name that references a QueryTable. Remove the QueryTable and try to clear the collection again.",
  "XtraSpreadsheetStringId.Msg_ErrorColumnIntervalRangeExpected": "Range should be a valid column interval range.",
  "XtraSpreadsheetStringId.Msg_ErrorColumnOffsetRefersBeyondWorksheet": "The specified offset refers to the column beyond the worksheet.",
  "XtraSpreadsheetStringId.Msg_ErrorCommandCannotPerformedWithMultipleSelections": "The command you chose cannot be performed with multiple selections.\n\nSelect a single range and click the command again.",
  "XtraSpreadsheetStringId.Msg_ErrorCommentAlreadyExists": "Comment with the same reference already exists.",
  "XtraSpreadsheetStringId.Msg_ErrorConditionalFormattingCannotAdd": "Не удается добавить условное форматирование.",
  "XtraSpreadsheetStringId.Msg_ErrorConditionalFormattingEmptyValue": "Введите значение.",
  "XtraSpreadsheetStringId.Msg_ErrorConditionalFormattingFormula": "Введите допустимую формулу.",
  "XtraSpreadsheetStringId.Msg_ErrorConditionalFormattingIconSetValuesOverlap": "Один или несколько диапазонов данных значков перекрываются. Скорректируйте значения диапазонов данных значков так, чтобы диапазоны не перекрывались.",
  "XtraSpreadsheetStringId.Msg_ErrorConditionalFormattingInvalidCellValue": "Введенное значение не является допустимыми числом, датой, временем или строкой.",
  "XtraSpreadsheetStringId.Msg_ErrorConditionalFormattingInvalidFormula": "Значение введенной формулы не является числом, датой, временем или строкой.",
  "XtraSpreadsheetStringId.Msg_ErrorConditionalFormattingInvalidIconSetNumber": "Введенное значение не является допустимым числом, датой или временем.",
  "XtraSpreadsheetStringId.Msg_ErrorConditionalFormattingInvalidPercentRank": "Необходимо ввести число от 1 до 100.",
  "XtraSpreadsheetStringId.Msg_ErrorConditionalFormattingRange": "Такой тип ссылки нельзя использовать в формуле Условное форматирование. \nВведите ссылку на одну ячейку или используйте функцию, например =СУММ(A1:E5).",
  "XtraSpreadsheetStringId.Msg_ErrorConditionalFormattingRank": "Введите целое число от 1 до 1000.",
  "XtraSpreadsheetStringId.Msg_ErrorConditionalFormattingReferenceToExternalWorkbook": "В условиях \"Условное форматирование\" нельзя использовать ссылки на другие книги.",
  "XtraSpreadsheetStringId.Msg_ErrorConditionalFormattingRelativeReference": "В условии \"Условное форматирование\" нельзя использовать относительные ссылки для шкал цветов, гистограмм и наборов значков.",
  "XtraSpreadsheetStringId.Msg_ErrorConditionalFormattingUnionRange": "Нельзя использовать операторы ссылок (такие как объединения, пересечения и диапазоны) или константы массивов для условий Условное форматирование.",
  "XtraSpreadsheetStringId.Msg_ErrorConditionalFormattingValueGreaterThanOtherValue": "{0} должно быть больше, чем {1}.",
  "XtraSpreadsheetStringId.Msg_ErrorConditionalFormattingValueNotValidNumber": "Указанное {0} не является допустимым числом.",
  "XtraSpreadsheetStringId.Msg_ErrorConditionalFormattingValueNotValidPercentage": "Указанное {0} не является допустимым процентом.",
  "XtraSpreadsheetStringId.Msg_ErrorConditionalFormattingValueNotValidPercentile": "Указанное {0} не является допустимым процентилем.",
  "XtraSpreadsheetStringId.Msg_ErrorConditionalFormattingValuesNotValidPercentage": "По крайней мере одно из указанных значений не является допустимым процентом.",
  "XtraSpreadsheetStringId.Msg_ErrorConnectionSiteOutOfRange": "A connectionSite number should be non-negative and less than a value returned by the Shape.ConnectionSiteCount property.",
  "XtraSpreadsheetStringId.Msg_ErrorCopyAreaCannotBeFitIntoThePasteArea": "The copy area cannot be fit into the paste area.",
  "XtraSpreadsheetStringId.Msg_ErrorCopyAreaCannotOverlapUnlessSameSizeAndShape": "Copy and paste areas cannot overlap unless they are same size and shape.",
  "XtraSpreadsheetStringId.Msg_ErrorCreateEmptyGroupShape": "A group should contain two or more shapes.",
  "XtraSpreadsheetStringId.Msg_ErrorDataTableExporterConversionError": "Conversion error (Subscribe to the CellValueConversionError event).",
  "XtraSpreadsheetStringId.Msg_ErrorDataTableExporterOverflow": "Narrowing Conversion (Subscribe to the CellValueConversionError event).",
  "XtraSpreadsheetStringId.Msg_ErrorDefinedNameAlreadyExists": "Идентификатор с таким именем уже существует.",
  "XtraSpreadsheetStringId.Msg_ErrorDefinedNameNotFounded": "DefinedName is not found.",
  "XtraSpreadsheetStringId.Msg_ErrorDefinedNameReferenceWithoutSheet": "Ссылка в идентификаторе должна содержать имя листа в каждой ссылке на ячейку.",
  "XtraSpreadsheetStringId.Msg_ErrorDeleteHeaderRow": "Невозможно удалить строку заголовка из таблицы.",
  "XtraSpreadsheetStringId.Msg_ErrorDeleteSingularWorksheet": "Workbook should contain at least one visible worksheet. To hide, delete, or move the sheet, insert a new sheet or unhide a hidden sheet.",
  "XtraSpreadsheetStringId.Msg_ErrorDeletingBuiltInTableStyle": "Удаление предустановленных стилей не допускается.",
  "XtraSpreadsheetStringId.Msg_ErrorDuplicateSheetName": "Лист с таким именем уже существует в книге.",
  "XtraSpreadsheetStringId.Msg_ErrorDuplicateStyleName": "Стиль с таким именем уже существует.",
  "XtraSpreadsheetStringId.Msg_ErrorEmptyDefinedNameReference": "You must enter a valid reference.",
  "XtraSpreadsheetStringId.Msg_ErrorErrorBarsWithBarDirectionAlreadyExists": "Error bars with the same direction already exists.",
  "XtraSpreadsheetStringId.Msg_ErrorExcludeRangeFromAnotherWorksheet": "Cannot exclude a range from another worksheet.",
  "XtraSpreadsheetStringId.Msg_ErrorFirstDVCriteriaMustBeEmpty": "First data validation criteria must be empty.",
  "XtraSpreadsheetStringId.Msg_ErrorFirstDVCriteriaMustNotBeEmpty": "First data validation criteria must be non empty.",
  "XtraSpreadsheetStringId.Msg_ErrorFormula": "Неверная формула. Формула: \\\"{0}\\\", Культура: {1}.",
  "XtraSpreadsheetStringId.Msg_ErrorIncompatibleDataLabelPosition": "The specified label position is incompatible with the current chart view/series.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorectCount": "Число должно быть больше 0.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorectFirstIndex": "First index is incorrect.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorectHighBound": "Верхняя граница неправильная.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorectLastIndex": "Last index is incorrect.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorectLowBound": "Нижняя граница неправильная.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorectMidPoint": "Midpoint is incorrect.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorectRotationAngleValue": "Угол поворота должен находиться в диапазоне от -90 до 90 градусов.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorrectColumnHeading": "Невереное имя столбца.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorrectColumnIndex": "Недопустимый индекс колонки.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorrectColumnWidth": "Значение ширины строки должно находиться в диапазоне от 0 до 255.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorrectCreateStockHighLowCloseChart": "To create this stock chart, arrange the data on your sheet in this order: high price, low price, closing price. Use dates or stock names as labels.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorrectCreateStockOpenHighLowCloseChart": "To create this stock chart, arrange the data on your sheet in this order: opening price, high price, low price, closing price. Use dates or stock names as labels.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorrectCreateStockVolumeHighLowCloseChart": "To create this stock chart, arrange the data on your sheet in this order: volume traded, high price, low price, closing price. Use dates or stock names as labels.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorrectCreateStockVolumeOpenHighLowCloseChart": "To create this stock chart, arrange the data on your sheet in this order: volume traded, opening price, high price, low price, closing price. Use dates or stock names as labels.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorrectErrorBarsCollectionCount": "Count of error bars collection should be between 0 and 2.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorrectIndentValue": "Значение отступа должно находиться в диапазоне от 0 до 250.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorrectIndexToInsert": "Worksheet index cannot be negative or greater than the number of worksheets in a workbook.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorrectReferenceExpression": "Неправильная ссылка на диапазон.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorrectReferenceExpressionInDefinedName": "To use defined name in the CreateRange method, the DefinedName.RefersTo property should be set to a cell range reference.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorrectRowHeading": "Невереное имя строки.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorrectRowHeight": "Значение высоты строки должно находиться в диапазоне от 0 до 409.",
  "XtraSpreadsheetStringId.Msg_ErrorIncorrectRowIndex": "Недопустимый индекс строки.",
  "XtraSpreadsheetStringId.Msg_ErrorIndexOutOfRange": "Index value out of range.",
  "XtraSpreadsheetStringId.Msg_ErrorInParseLine": "Ошибка в строке анализа.",
  "XtraSpreadsheetStringId.Msg_ErrorInplaceComboBoxMustBeUseRangeOrTextData": "Use a cell range or text values for the items of a ComboBox in-place editor.",
  "XtraSpreadsheetStringId.Msg_ErrorInsertAboveHeaderRow": "Нельзя вставить строку в таблицу выше строки заголовка.",
  "XtraSpreadsheetStringId.Msg_ErrorInsertBelowTotalRow": "Cannot insert a table row below the total row.",
  "XtraSpreadsheetStringId.Msg_ErrorInternalError": "Произошла внутренняя ошибка.",
  "XtraSpreadsheetStringId.Msg_ErrorInvalidCreateFromSelectionRange": "This selection is not valid.\nThe row or column containing the proposed names will not be included in the definitions of the names.\nIf the names you are creating are listed in a row or column, you must select more than one row or column.",
  "XtraSpreadsheetStringId.Msg_ErrorInvalidCustomPropertyValue": "The value entered does not match the specified type. The value will be stored as text.",
  "XtraSpreadsheetStringId.Msg_ErrorInvalidDefinedName": "Недопустимое имя для идентификатора.",
  "XtraSpreadsheetStringId.Msg_ErrorInvalidDefinedName_FormulaBar": "Необходимо ввести допустимую ссылку для перехода или допустимое имя для выделения.",
  "XtraSpreadsheetStringId.Msg_ErrorInvalidFilterArgument": "The filter argument entered is invalid.",
  "XtraSpreadsheetStringId.Msg_ErrorInvalidNumberFormat": "Сannot use the specified number format.",
  "XtraSpreadsheetStringId.Msg_ErrorInvalidObjectUsage": "The object is invalid.",
  "XtraSpreadsheetStringId.Msg_ErrorInvalidOperationForDataSheet": "This operation is invalid for data sheet.",
  "XtraSpreadsheetStringId.Msg_ErrorInvalidRange": "Invalid range.",
  "XtraSpreadsheetStringId.Msg_ErrorInvalidReference": "Reference is not valid.",
  "XtraSpreadsheetStringId.Msg_ErrorInvalidTableStyleType": "Style type is not valid.",
  "XtraSpreadsheetStringId.Msg_ErrorLastPrimaryAxisCannotBeChanged": "The last primary axis on the chart cannot be converted to a secondary axis.",
  "XtraSpreadsheetStringId.Msg_ErrorMaxNumberOfSeriesPerChart": "The maximum number of series per chart is 255.",
  "XtraSpreadsheetStringId.Msg_ErrorMuiltiCellArrayFormulaInTable": "Multi-cell array formulas are not allowed in tables.",
  "XtraSpreadsheetStringId.Msg_ErrorNegativeFrozenColumnOffset": "Column offset should be non-negative.",
  "XtraSpreadsheetStringId.Msg_ErrorNegativeFrozenRowOffset": "Row offset should be non-negative.",
  "XtraSpreadsheetStringId.Msg_ErrorNegativeIndexNotAllowed": "Значение индекса не может быть отрицательным числом.",
  "XtraSpreadsheetStringId.Msg_ErrorNoColumnInDataTable": "There is no {0} column in the DataTable.",
  "XtraSpreadsheetStringId.Msg_ErrorNoColumnsInDataTable": "The number of Options.CustomConverters exceeds the number of dataTable columns.",
  "XtraSpreadsheetStringId.Msg_ErrorOverlapRange": "A table cannot overlap another table.",
  "XtraSpreadsheetStringId.Msg_ErrorRangeColumnCountIsNotTheSameAsColumnCountInDataTable": "The number of columns in the DataTable must be the same as the number of columns in the cell range.",
  "XtraSpreadsheetStringId.Msg_ErrorRangeConsistsOfEmptyCells": "Specified range must contain at least one cell with data.",
  "XtraSpreadsheetStringId.Msg_ErrorRangeContainsTable": "Specified range must not intersect a table.",
  "XtraSpreadsheetStringId.Msg_ErrorRangeMustConsistOfASingleRowOrColumn": "Specified range must consist of a single row or column.",
  "XtraSpreadsheetStringId.Msg_ErrorRelativeReference": "Absolute range reference is required.",
  "XtraSpreadsheetStringId.Msg_ErrorRemoveDefinedNameReferencedQueryTable": "Cannot delete a defined name that references a QueryTable. Remove the QueryTable before deleting the defined name.",
  "XtraSpreadsheetStringId.Msg_ErrorResizeRangeToMergedCell": "Для этого требуется, чтобы ячейки имели одинаковый размер.",
  "XtraSpreadsheetStringId.Msg_ErrorRowIntervalRangeExpected": "Range should be a valid row interval range.",
  "XtraSpreadsheetStringId.Msg_ErrorRowOffsetRefersBeyondWorksheet": "The specified offset refers to the row beyond the worksheet.",
  "XtraSpreadsheetStringId.Msg_ErrorSecondDVCriteriaMustBeEmpty": "Second data validation criteria must be empty.",
  "XtraSpreadsheetStringId.Msg_ErrorSecondDVCriteriaMustNotBeEmpty": "Second data validation criteria must be non empty.",
  "XtraSpreadsheetStringId.Msg_ErrorSetInsideBordersToCell": "Невозможно установить внутренние границы для одной ячейки.",
  "XtraSpreadsheetStringId.Msg_ErrorSetShapeCustomPreset": "The ShapeGeometry.Preset property cannot be set to ShapeGeometryPreset.Custom.",
  "XtraSpreadsheetStringId.Msg_ErrorShapeAlreadyGrouped": "You cannot add a shape from another group to the current group. If you want to create nested groups, add an entire group instead.",
  "XtraSpreadsheetStringId.Msg_ErrorShapeWithIdNotFound": "Shape with this Id is not found.",
  "XtraSpreadsheetStringId.Msg_ErrorShapeWithNameNotFound": "Фигура с таким именем не найдена.",
  "XtraSpreadsheetStringId.Msg_ErrorSharedFormulaIndexOutside": "Общая формула с этим индексом не существует.",
  "XtraSpreadsheetStringId.Msg_ErrorSheetAlreadyExists": "A sheet with the same name already exists.",
  "XtraSpreadsheetStringId.Msg_ErrorSheetIndexOutside": "Sheet index should be positive and less than the number of sheets.",
  "XtraSpreadsheetStringId.Msg_ErrorSheetNameContainsNotAllowedCharacters": "Имя листа не должно содержать следующие символы: \\\\, /, ?, *, [, ] или :\"",
  "XtraSpreadsheetStringId.Msg_ErrorSheetNameExceedAllowedLength": "Имя листа не должно содержать больше 31 символа.",
  "XtraSpreadsheetStringId.Msg_ErrorSheetNameStartOrEndWithSingleQuote": "The worksheet name must not start and end with a single quote (').",
  "XtraSpreadsheetStringId.Msg_ErrorSheetWithNameNotFound": "Sheet with this name is not found.",
  "XtraSpreadsheetStringId.Msg_ErrorSomeChartTypesCannotBeCombinedWithOtherChartTypes": "Some chart types cannot be combined with other chart types. Select a different chart type.",
  "XtraSpreadsheetStringId.Msg_ErrorSparklinePositionOrDataRangeIsInvalid": "Specified position or data range is not valid.",
  "XtraSpreadsheetStringId.Msg_ErrorSparklinePositionsMustBeUnique": "Specified position range is invalid. Sparkline positions must be unique.",
  "XtraSpreadsheetStringId.Msg_ErrorStayOnlyHeaders": "Таблица не может содержать только заголовок.",
  "XtraSpreadsheetStringId.Msg_ErrorStyleNotFound": "Стиля с таким именем не существует.",
  "XtraSpreadsheetStringId.Msg_ErrorStyleTypeMustBeTableOrPivot": "Style type must be table, pivot or both.",
  "XtraSpreadsheetStringId.Msg_ErrorSubtotalUncomplete": "Нам не удалось выполнить это для указанного диапазона ячеек. Выделите одну ячейку из диапазона и повторите попытку.",
  "XtraSpreadsheetStringId.Msg_ErrorSurfaceChartMustContainAtLeastTwoSeries": "A surface chart must contain at least two series.",
  "XtraSpreadsheetStringId.Msg_ErrorTableAlreadyExists": "The name you entered already exists. Enter a unique name.",
  "XtraSpreadsheetStringId.Msg_ErrorTableCannotBeCreatedInTheLastRow": "Can not create a table in the last row of the worksheet. A table must have at least two rows, one for the table header, and one for data.",
  "XtraSpreadsheetStringId.Msg_ErrorTableColumnAlreadyExists": "Колонка с таким именем уже существует в таблице.",
  "XtraSpreadsheetStringId.Msg_ErrorTableColumnIndexOutside": "Table column index should be positive and should not exceed the number of columns in a table.",
  "XtraSpreadsheetStringId.Msg_ErrorTableNameIsNotValid": "The name you entered is not valid.",
  "XtraSpreadsheetStringId.Msg_ErrorTableRowIndexOutside": "Индекс вставляемой строки не должен быть больше общего количества строк в таблице.",
  "XtraSpreadsheetStringId.Msg_ErrorTableSlicersCantBeCopied": "Table slicers can't be copied from one workbook to another. Try again by selecting the entire table and the slicers.",
  "XtraSpreadsheetStringId.Msg_ErrorUnionRange": "That command cannot be used on multiple selections.",
  "XtraSpreadsheetStringId.Msg_ErrorUnionRangesWithDifferentWorksheets": "Union ranges containing ranges with different worksheets are not supported.",
  "XtraSpreadsheetStringId.Msg_ErrorUseCommentFromAnotherWorksheet": "Cannot use a comment from another worksheet.",
  "XtraSpreadsheetStringId.Msg_ErrorUseDeletedChartsheet": "ChartSheet is already deleted.",
  "XtraSpreadsheetStringId.Msg_ErrorUseDeletedComment": "Comment is already deleted.",
  "XtraSpreadsheetStringId.Msg_ErrorUseDeletedCommentRun": "Comment run is already deleted.",
  "XtraSpreadsheetStringId.Msg_ErrorUseDeletedConditionalFormatting": "Conditional formatting  is already deleted.",
  "XtraSpreadsheetStringId.Msg_ErrorUseDeletedDefinedName": "Использование удалённого идентификатора.",
  "XtraSpreadsheetStringId.Msg_ErrorUseDeletedHyperlink": "Использование удалённой гиперссылки.",
  "XtraSpreadsheetStringId.Msg_ErrorUseDeletedObject": "The object is already deleted.",
  "XtraSpreadsheetStringId.Msg_ErrorUseDeletedStyle": "Использование удалённого стиля.",
  "XtraSpreadsheetStringId.Msg_ErrorUseDeletedWorksheet": "Использование удалённого листа",
  "XtraSpreadsheetStringId.Msg_ErrorUseInvalidRangeFormatObject": "Свойства объекта форматирования диапазона больше не действительны.",
  "XtraSpreadsheetStringId.Msg_ErrorUseInvalidStyle": "Недопустимый объект стиля.",
  "XtraSpreadsheetStringId.Msg_ErrorUseInvalidWorkbook": "Эта книга не может быть больше использована.",
  "XtraSpreadsheetStringId.Msg_ErrorUseOnlyVisibleDataRangePropertyIncorrectUsing": "Use the UseOnlyVisibleDataRange property only for a ComboBox in-place editor with items obtained from a cell range.",
  "XtraSpreadsheetStringId.Msg_ErrorUseRangeFromAnotherWorkbook": "Cannot use a range from another workbook.",
  "XtraSpreadsheetStringId.Msg_ErrorUseRangeFromAnotherWorksheet": "Использование диапазона ячеек из другого листа.",
  "XtraSpreadsheetStringId.Msg_ErrorUseShapeFromAnotherWorksheet": "Cannot use a shape from another worksheet.",
  "XtraSpreadsheetStringId.Msg_ErrorUseStyleFromAnotherWorkbook": "Использование стиля из другой книги.",
  "XtraSpreadsheetStringId.Msg_ErrorUseTableStyleFromAnotherWorkbook": "Cannot use a table style from another workbook.",
  "XtraSpreadsheetStringId.Msg_ErrorWorkbookIsProtected": "Workbook is protected and cannot be changed.",
  "XtraSpreadsheetStringId.Msg_ErrorWorksheetIndexOutside": "Индекс вставляемого листа не должен быть больше количества листов.",
  "XtraSpreadsheetStringId.Msg_ErrorWorksheetToBeDeletedNotFound": "Worksheet is not found in a workbook.",
  "XtraSpreadsheetStringId.Msg_ErrorWorksheetWithNameNotFound": "Лист с таким именем не найден.",
  "XtraSpreadsheetStringId.Msg_ErrorZeroCountRanges": "The number of ranges should be greater than zero.",
  "XtraSpreadsheetStringId.Msg_ErrorZeroCountSheets": "The number of worksheets should be greater than zero.",
  "XtraSpreadsheetStringId.Msg_ExternalLinkAlreadyExists": "External link with the same name already exists.",
  "XtraSpreadsheetStringId.Msg_ExternalLinkInvalidPath": "External link path is invalid.",
  "XtraSpreadsheetStringId.Msg_ExternalWorkbookWithoutSheets": "External link should contain at least one worksheet.",
  "XtraSpreadsheetStringId.Msg_FormulaExceedMaxSize": "formula exceeds the maximum character length or byte size. Converted to #VALUE! error.",
  "XtraSpreadsheetStringId.Msg_FormulasNotAllowed": "Inserting/changing formulas is not allowed.",
  "XtraSpreadsheetStringId.Msg_FuncExceedMaxNestingLevel": "formula with more than 7 nested function levels has been converted to #VALUE! error.",
  "XtraSpreadsheetStringId.Msg_FuncVarExceedMaxArgCount": "formula with more than 30 arguments per function has been converted to #VALUE! error.",
  "XtraSpreadsheetStringId.Msg_GroupEditorFieldNameEmpty": "The Field Name column cannot contain empty values.",
  "XtraSpreadsheetStringId.Msg_GroupingNeedUnprotectSheet": "You cannot use this command on a protected sheet. To use this command, you must first unprotect the sheet (Review tab, Changes group, Unprotect Sheet button). You may be prompted for a password.",
  "XtraSpreadsheetStringId.Msg_HeaderFooterFormatTagRefersToNonexistentPicture": "Cannot find a picture to insert into the header or footer. Create the required picture by using the WorksheetHeaderFooter.AddPicture method.",
  "XtraSpreadsheetStringId.Msg_HeaderFooterTooLongTextString": "The text string you entered is too long. Reduce the number of characters used.",
  "XtraSpreadsheetStringId.Msg_IncompliantArrayParsedFormula": "Cell {0} on sheet \"{1}\" has a non-compliant array parsed formula. Replaced by error #N/A.",
  "XtraSpreadsheetStringId.Msg_IncompliantCellParsedFormula": "Cell {0} on sheet \"{1}\" has a non-compliant cell parsed formula. Replaced by error #N/A.",
  "XtraSpreadsheetStringId.Msg_IncompliantNamedParsedFormula": "Defined name \"{0}\"({1}): parsed formula is non-compliant. Replaced by error #N/A.",
  "XtraSpreadsheetStringId.Msg_IncorrectNumberRange": "The number must be between {0} and {1}. Try again by entering a number in this range.",
  "XtraSpreadsheetStringId.Msg_IncorrectPassword": "Неверный пароль. Убедитесь, что отключена клавиша CAPS LOCK и используется правильный регистр.",
  "XtraSpreadsheetStringId.Msg_IntersectedRangesCanNotBeChanged": "Can not use this command on overlapping selections.",
  "XtraSpreadsheetStringId.Msg_InvalidBorderStyleRemoved": "Border style is invalid, has been removed.",
  "XtraSpreadsheetStringId.Msg_InvalidCommentAuthor": "The comment author's name must be non-null.",
  "XtraSpreadsheetStringId.Msg_InvalidDefinedNameReference": "The specified reference is empty or invalid. A defined name should refer to a cell, cell range, formula or constant.",
  "XtraSpreadsheetStringId.Msg_InvalidFilePath": "Cannot open the specified file.",
  "XtraSpreadsheetStringId.Msg_InvalidFormula": "Введенная вами формула содержит ошибку.\n\nЕсли вы не пытаетесь ввести формулу, не используйте знак равенства (=) или знак минус (-), или ставьте перед знаком одинарную кавычку (').",
  "XtraSpreadsheetStringId.Msg_InvalidFormulaRemoved": "Cell {0} on the sheet \"{1}\" has an invalid formula. Formula has been removed.",
  "XtraSpreadsheetStringId.Msg_InvalidHyperlinkRemoved": "Hyperlink with invalid target Uri \"{0}\" has been removed.",
  "XtraSpreadsheetStringId.Msg_InvalidNumber": "Integer is not valid.",
  "XtraSpreadsheetStringId.Msg_InvalidSheetSpecified": "Specified sheet is not valid.",
  "XtraSpreadsheetStringId.Msg_InvalidSortColumnIndex": "This command cannot be performed with specified column index.",
  "XtraSpreadsheetStringId.Msg_InvalidStyleName": "Неверное имя стиля.",
  "XtraSpreadsheetStringId.Msg_MailMergeReachesEndOfWorksheet": "The Spreadsheet has reached the end of the worksheet when generating mail merge documents.",
  "XtraSpreadsheetStringId.Msg_MenuManagerPropertyIsNotSet": "The MenuManager property of SpreadsheetControl is not set.",
  "XtraSpreadsheetStringId.Msg_MergeCellsClarification": "Merging cells only keeps the upper-left cell value, and discards the other values.",
  "XtraSpreadsheetStringId.Msg_MoreThan255InvalidDataCircles": "Лист содержит более 255 недопустимых ячеек. Помечены будут только первые 255 ячеек. \t",
  "XtraSpreadsheetStringId.Msg_NoCellsWereFound": "Не найдено ни одной ячейки, удовлетворяющей указанным условиям.",
  "XtraSpreadsheetStringId.Msg_NumberColumnsInTableIsLessThanInDataSource": "The number of columns in the table is less than the number of columns in the data source.",
  "XtraSpreadsheetStringId.Msg_NumberFormatRecordsSkipped": "Number formats: the number of records exceeded the maximum value of ({0}). Some records are not written.",
  "XtraSpreadsheetStringId.Msg_NumberRowsInTableAndDataSourceDoNotMatch": "The number of rows in the table and in the data source do not match.",
  "XtraSpreadsheetStringId.Msg_OdsCalendarIgnored": "Non-gregorian calendar is not supported. Date values may differ.",
  "XtraSpreadsheetStringId.Msg_OdsCaseSensitiveIgnored": "Case sensitivity is not supported. Function calculation results may differ.",
  "XtraSpreadsheetStringId.Msg_OdsTimeFormatIgnored": "Unknown time format. Time value is ignored.",
  "XtraSpreadsheetStringId.Msg_OdsTooLowDateValue": "Date must be greater than 01/01/1900. Date format is ignored.",
  "XtraSpreadsheetStringId.Msg_OdsUnknownDateFormat": "Unknown date format. Date values may differ.",
  "XtraSpreadsheetStringId.Msg_OperationIncludesCellsInsideAndOutsideOfTable": "Невозможно выполнить операцию: не допускается использование операций над ячейками, расположенными как внутри, так и вне диапазона таблицы или сопоставления XML, а также операций над ячейками в нескольких таблицах.",
  "XtraSpreadsheetStringId.Msg_PageSetupMarginsNotFitPageSize": "Margins do not fit page size.",
  "XtraSpreadsheetStringId.Msg_PageSetupPrintTitlesMultiSelect": "Print titles must be contiguous and complete rows or columns.",
  "XtraSpreadsheetStringId.Msg_PageSetupProblemFormula": "The formula you typed contains an error. The range reference or defined name is missing.",
  "XtraSpreadsheetStringId.Msg_ParametersIdenticalNames": "Cannot create parameters with identical names: ",
  "XtraSpreadsheetStringId.Msg_ParametersInvalidCharacters": "Cannot create parameters with invalid names: ",
  "XtraSpreadsheetStringId.Msg_ParametersNoName": "Cannot create a parameter without specifying its name.",
  "XtraSpreadsheetStringId.Msg_PasswordNotConfirmed": "Второй пароль не совпадает с первым.",
  "XtraSpreadsheetStringId.Msg_PasswordTooLong": "Password length must be less than {0} characters long.",
  "XtraSpreadsheetStringId.Msg_PasteAreaNotSameSizeAsSelectionClarification": "The data you're pasting isn't the same size as your selection. Do you want to paste anyway?",
  "XtraSpreadsheetStringId.Msg_PivotCacheFieldContainsNonDateItems": "Cannot add date filter. Pivot cache field contains non date items.",
  "XtraSpreadsheetStringId.Msg_PivotCacheSourceTypeIsInvalid": "Pivot cache source must be of worksheet type.",
  "XtraSpreadsheetStringId.Msg_PivotCacheStringVeryLong": "Some cells or style in this workbook contain formatting that is not supported by the selected file format. These formats will be converted to the closest format available.",
  "XtraSpreadsheetStringId.Msg_PivotCalculatedFieldCantBeABase": "Calculated field cant be the base.",
  "XtraSpreadsheetStringId.Msg_PivotCalculatedFieldCantBeGroupped": "Calculated fields cant be grouped.",
  "XtraSpreadsheetStringId.Msg_PivotCalculationRequiresField": "This calculation requires to specify a pivot field.",
  "XtraSpreadsheetStringId.Msg_PivotCalculationRequiresItem": "This calculation requires to specify a pivot item or set item type to previous/next.",
  "XtraSpreadsheetStringId.Msg_PivotCanNotDetermineField": "Cannot detemine which PivotTable field to sort by.",
  "XtraSpreadsheetStringId.Msg_PivotCannotGroupThatSelection": "Cannot group that selection.",
  "XtraSpreadsheetStringId.Msg_PivotCannotHideLastVisibleItem": "Cannot hide last visible pivot item.",
  "XtraSpreadsheetStringId.Msg_PivotCircularReference": "Your formula can not be entered because calculated fields cannot contain circular references. Change the formula to make sure that it doesn't refer to its own cells.",
  "XtraSpreadsheetStringId.Msg_PivotEndNumberMustBeGreaterThanStartNumber": "The end number must be greater than the start number.",
  "XtraSpreadsheetStringId.Msg_PivotFieldAlreadyHasAnotherGroupingType": "Pivot field already grouped by another group type.",
  "XtraSpreadsheetStringId.Msg_PivotFieldCannotBePlacedOnThatAxis": "The field you are moving cannot be placed in that area of report.",
  "XtraSpreadsheetStringId.Msg_PivotFieldCantBeGrouped": "Some field items are not supported by the selected grouping.",
  "XtraSpreadsheetStringId.Msg_PivotFieldContainsTooMuschUniqueItems": "Only 32500 unique items per field are supported.",
  "XtraSpreadsheetStringId.Msg_PivotFieldHasTooMuchItems": "A field in your source data has more unique items than can be used in a PivotTable report.",
  "XtraSpreadsheetStringId.Msg_PivotFieldHasTooMuchItems_ColumnField": "You cannot place a field that has more than 16384 items in the column area. If you want to use this field in the report, move the field to either the row area or page area.",
  "XtraSpreadsheetStringId.Msg_PivotFieldNameAlreadyExists": "PivotTable field name already exists.",
  "XtraSpreadsheetStringId.Msg_PivotFieldNameIsInvalid": "Cannot enter a null value as an item or field name in PivotTable report.",
  "XtraSpreadsheetStringId.Msg_PivotFilterCannotAddFilterToPageField": "Cannot add pivot filter to page field.",
  "XtraSpreadsheetStringId.Msg_PivotFilterCannotChangeTop10TypeProperty": "To change this property pivot filter type must be count, sum or percent.",
  "XtraSpreadsheetStringId.Msg_PivotFilterCannotChangeUseWholeDayProperty": "The UseWholeDay property cannot be false when a PivotTable timeline is used to filter dates.",
  "XtraSpreadsheetStringId.Msg_PivotFilterInteger": "an integer",
  "XtraSpreadsheetStringId.Msg_PivotFilterInvalidDate": "The date you entered is not a valid date. Please try again.",
  "XtraSpreadsheetStringId.Msg_PivotFilterNumber": "a number",
  "XtraSpreadsheetStringId.Msg_PivotFilterNumbers": "numbers",
  "XtraSpreadsheetStringId.Msg_PivotFilterRequiresMeasureField": "This pivot filter type requires to specify measure field.",
  "XtraSpreadsheetStringId.Msg_PivotFilterRequiresSecondValue": "This pivot filter type requires to specify two values.",
  "XtraSpreadsheetStringId.Msg_PivotFilterRequiresValue": "This pivot filter type requires to specify a value.",
  "XtraSpreadsheetStringId.Msg_PivotFilterTop10CountMustBeInteger": "This filter's value must be integer.",
  "XtraSpreadsheetStringId.Msg_PivotFilterValueMustBeBetween": "You must enter {0} between {1} and {2}. Try again by entering {0} in this range.",
  "XtraSpreadsheetStringId.Msg_PivotFormulaContainsIllegalFunction": "Your formula includes a function that can not be used in PivotTable formulas. You can not use functions that return variable results, such as RAND ans NOW, database functions, or the GETPIVOTDATA function in PivotTable formulas.",
  "XtraSpreadsheetStringId.Msg_PivotFormulaContainsReferences": "References, names, and arrays are not supported in PivotTable formulas.",
  "XtraSpreadsheetStringId.Msg_PivotItemNameCannotBeFound": "An item name can not be found. Check that you've typed the name correctly and the item is present in the PivotTable report.",
  "XtraSpreadsheetStringId.Msg_PivotItemOrFieldWithSameNameExist": "Calculated item or field could not be created because another item or field of the same name exists.",
  "XtraSpreadsheetStringId.Msg_PivotPositionalReferences": "Positional references cannot be used in a calculated item formula while AutoSort by values or AutoShow is on.",
  "XtraSpreadsheetStringId.Msg_PivotPositionalReferencesUI": "Positional references cannot be used in a calculated item formula while AutoSort by values or AutoShow is on.\n\nTo turn off AutoSort and AutoShow, double-click the field button for the field, click Advanced, and click the Manual options under AutoShow properties.",
  "XtraSpreadsheetStringId.Msg_PivotReferencesToMultipleItemNames": "References to multiple item names per field cannot be included in PivotTable formulas.",
  "XtraSpreadsheetStringId.Msg_PivotReferenceToAnotherField": "PivotTable formulas can only refer to items in the same field as the calculated item.",
  "XtraSpreadsheetStringId.Msg_PivotTableCanNotApplyDataValidation": "You cannot apply data validation to cells in a PivotTable report.",
  "XtraSpreadsheetStringId.Msg_PivotTableCanNotBeBuiltFromEmptyCache": "The PivotTable report can not be built from empty data cache. Please refresh data cache.",
  "XtraSpreadsheetStringId.Msg_PivotTableCanNotBeChanged": "We cannot make this change for the selected cells because it will affect a PivotTable. Use the field list to change the report. If you are trying to insert or delete cells, move the PivotTable and try again.",
  "XtraSpreadsheetStringId.Msg_PivotTableCanNotOverlapPivotTable": "A PivotTable report cannot overlap another PivotTable table.",
  "XtraSpreadsheetStringId.Msg_PivotTableCircularReferencesWarning": "Some PivotTable cells contain circular references.\n\n    - Check your calculated field and item formulas to make sure that none of the formulas refer to their own cells.\n    - Or change the order of calculation by using the Solve Order command.",
  "XtraSpreadsheetStringId.Msg_PivotTableClearingClarification": "This PivotTable report is based on the same data as at least one other PivotTable report. Clearing the PivotTable report will remove the following from all the PivotTable reports:\n\n    - Grouping\n\n    - Calculated items\n\n    - Calculated fields",
  "XtraSpreadsheetStringId.Msg_PivotTableConsolidationRestricted": "Averages, standard deviations, and variances are not supported when a PivotReport has calculated items.",
  "XtraSpreadsheetStringId.Msg_PivotTableDataSourceAndDestinationReferencesAreBothInvalid": "References to data source and destination are both invalid.",
  "XtraSpreadsheetStringId.Msg_PivotTableDataSourceCannotBeChanged": "The data source of a PivotTable connected to filter controls that are also connected to other PivotTables cannot be changed. To change the data source, first disconnect the filter controls from this PivotTable or from the other PivotTables.",
  "XtraSpreadsheetStringId.Msg_PivotTableDataSourceReferenceNotValid": "Data source reference is not valid.",
  "XtraSpreadsheetStringId.Msg_PivotTableDestinationReferenceNotValid": "Destination reference is not valid.",
  "XtraSpreadsheetStringId.Msg_PivotTableEmptyDataCaption": "Cannot enter a null value as an item or field name in a PivotTable report.",
  "XtraSpreadsheetStringId.Msg_PivotTableEmptyDataCaptionAPI": "Cannot assign a null value as an item or field name in a PivotTable report.",
  "XtraSpreadsheetStringId.Msg_PivotTableEntryCannotBeUsed": "Your entry cannot be used. An integer or decimal number may be required.",
  "XtraSpreadsheetStringId.Msg_PivotTableFieldMoveRestricted": "The field you are moving is restricted so it cannot be removed from the PivotTable.",
  "XtraSpreadsheetStringId.Msg_PivotTableFieldNameIsInvalid": "The PivotTable field name is not valid. To create a PivotTable report, you must use data that organized as a list with labeled columns. If you a changing the name of a PivotTable field, you must type a new name for the field.",
  "XtraSpreadsheetStringId.Msg_PivotTableFieldsHasMultipleFiltersWarning": "К одному или нескольким полям сводной таблицы применяются несколько фильтров. \n\nЕсли снять флажок \"Разрешить несколько фильтров для поля\", а затем нажать кнопку \"ОК\" в диалоговом окне \"Параметры сводной таблицы\", все фильтры, примененные к этим полям, будут удалены.",
  "XtraSpreadsheetStringId.Msg_PivotTableIndentOverflow": "Because the maximum indentation limit for a cell has been reached, the next field will be displayed in a separate column.",
  "XtraSpreadsheetStringId.Msg_PivotTableNameAlreadyExists": "A PivotTable report with that name already exists on the destination sheet.",
  "XtraSpreadsheetStringId.Msg_PivotTableNameIsInvalid": "Pivot table name is not valid.",
  "XtraSpreadsheetStringId.Msg_PivotTableNotEnoughDataFields": "This operation requires at least two data fields on PivotTable report.",
  "XtraSpreadsheetStringId.Msg_PivotTablePartCanNotBeChanged": "Cannot change this part of a PivotTable report.",
  "XtraSpreadsheetStringId.Msg_PivotTableReportCanNotOverlapTable": "A PivotTable report cannot overlap a table or XML mapping.",
  "XtraSpreadsheetStringId.Msg_PivotTableSavedWithoutUnderlyingData": "The PivotTable report was saved without the underlying data. Use the Refresh Data command to update the report.",
  "XtraSpreadsheetStringId.Msg_PivotTableSubtotalListPlace": "This command subtotals lists in place. To display and remove subtotals in a PivotTable report, use the Field Settings command.",
  "XtraSpreadsheetStringId.Msg_PivotTableTooMuchDataFields": "A PivotTable report cannot contain more than 256 data fields.",
  "XtraSpreadsheetStringId.Msg_PivotTableTooMuchPageFields": "A PivotTable report cannot contain more than 256 page fields.",
  "XtraSpreadsheetStringId.Msg_PivotTableWillNotFitOnTheSheet": "The PivotTable report will not fit on the sheet. Do You want to show as much as possible?",
  "XtraSpreadsheetStringId.Msg_PivotTableWillNotFitOnTheSheetSelectNewLocation": "The PivotTable report will not fit on the sheet. Please select a different location.",
  "XtraSpreadsheetStringId.Msg_PivotTableWillOverrideSheetCells": "There's already data on worksheet. Do you want to replace it?",
  "XtraSpreadsheetStringId.Msg_PivotValueFilterNeedAtLeastOneDataField": "You need at least one field in the Values area in order to apply a value filter.",
  "XtraSpreadsheetStringId.Msg_ProtectedRangeDuplicateName": "A range with the title '{0}' already exists. Please enter a new title for the range.",
  "XtraSpreadsheetStringId.Msg_ProtectedRangeEmptyName": "You must enter a title for the range.",
  "XtraSpreadsheetStringId.Msg_ProtectedRangeInvalidName": "The title '{0}' contains illegal characters. Range titles may only contain letters, numbers, spaces, and must begin with a letter.",
  "XtraSpreadsheetStringId.Msg_RangeNotContainAllColumnsOfBindingRange": "The specified cell range cannot be sorted since it does not contain all columns of the data-bound range.",
  "XtraSpreadsheetStringId.Msg_RefToError": "formula has reference(s) exceeding the limits of XLS range. Replaced by error #REF!.",
  "XtraSpreadsheetStringId.Msg_RefTruncated": "formula has reference(s) exceeding the limits of XLS range. Truncated.",
  "XtraSpreadsheetStringId.Msg_ReplaceAllSucceeded": "Операция завершена. Сделано замен: {0}.",
  "XtraSpreadsheetStringId.Msg_ReplaceCantFindMatch": "Не удалось найти искомое значение.",
  "XtraSpreadsheetStringId.Msg_ResolveDefinedNameConflict": "Имя '{0}' уже существует. Чтобы использовать эту версию имени, нажмите \"Да\". Чтобы переименовать версию '{0}', которую требуется переместить или копировать, нажмите \"Нет\".",
  "XtraSpreadsheetStringId.Msg_ResolveDefinedNameConflictWithTableName": "Cannot use the existing name {0} because of a conflict with a table name.",
  "XtraSpreadsheetStringId.Msg_RowFirstColumnOutOfXLSRange": "All non-empty cells of row {0} are beyond the limits of XLS cell range. Row has been skipped.",
  "XtraSpreadsheetStringId.Msg_RowIndexOutOfRange": "Row index is out of range.",
  "XtraSpreadsheetStringId.Msg_RowLastColumnOutOfXLSRange": "Some non-empty cells of row {0} are beyond the limits of XLS cell range. Row has been truncated.",
  "XtraSpreadsheetStringId.Msg_SearchCantFindData": "Не удалось ничего найти по вашему запросу.",
  "XtraSpreadsheetStringId.Msg_SearchingInDataSourceRangeNotSupported": "Searching in the data source range is not supported.",
  "XtraSpreadsheetStringId.Msg_SelectedCellsAffectsPivotTableAndCanNotBeChanged": "We can't make this change for the selected cells because it will affect a PivotTable.",
  "XtraSpreadsheetStringId.Msg_SelectionContainsCellsWithoutDataValidation": "Выделенная область содержит ячейки без условий на значения. Вы хотите распространить условия на эти ячейки?",
  "XtraSpreadsheetStringId.Msg_SelectionContainsMoreThanOneDataValidation": "В выделенном диапазоне определено более одного условия.\n\nВы хотите удалить текущие параметры и продолжить?",
  "XtraSpreadsheetStringId.Msg_SharedFormulaRange": "shared formula range",
  "XtraSpreadsheetStringId.Msg_ShiftCellInAutoFilterIsNotAllowed": "Shifting cells in a table is not allowed.",
  "XtraSpreadsheetStringId.Msg_ShiftCellsInATableIsNotAllowed": "Shifting cells in a table is not allowed.",
  "XtraSpreadsheetStringId.Msg_ShiftCellsInBindingRangeIsNotAllowed": "Shifting cells in a cell range associated with a data source is not allowed.",
  "XtraSpreadsheetStringId.Msg_SortingInDataSourceRangeNotSupported": "Sorting in the data source range is not supported.",
  "XtraSpreadsheetStringId.Msg_StyleNameHasBeenChanged": "Custom style \"{0}\": name has been changed to \"{1}\".",
  "XtraSpreadsheetStringId.Msg_SubtotalNeedColumnNames": "Приложению Spreadsheet не удается определить, в какой строке списка или выделенного диапазона содержатся названия столбцов, необходимые для выполнения этой команды.\n\n● Чтобы использовать в качестве названий данные первой строки выделенного фрагмента или списка, нажмите кнопку \"ОК\".\n● Если группа ячеек была выделена по ошибке, выделите одну ячейку и повторите команду.\n● Чтобы создать названия столбцов, нажмите кнопку \"Отмена\" и введите их над каждым столбцом данных.\"",
  "XtraSpreadsheetStringId.Msg_TableColumnNameChanged": "Column name \"{0}\" in a table \"{1}\" is not unique. Changed to \"{2}\".",
  "XtraSpreadsheetStringId.Msg_TableMustHaveHeader": "The table must have a header because the binding range has a header.",
  "XtraSpreadsheetStringId.Msg_TableOverlap": "Can not complete operation: A table cannot overlap with a PivotTable report, query results, a table, merged cells, or an XML mapping.",
  "XtraSpreadsheetStringId.Msg_TableRangeDoesNotIncludeHeaderRow": "The binding range has no header. Extend the range to include a top row which will be the table header.",
  "XtraSpreadsheetStringId.Msg_TableRefToError": "formula has table reference(s). Replaced by error #REF!.",
  "XtraSpreadsheetStringId.Msg_TableRefToRef": "formula has table reference(s). Replaced by cell reference.",
  "XtraSpreadsheetStringId.Msg_TopLeftOfBindingRangeBelongsMergedCells": "Cannot bind the specified cell range to a data source. Its top-left cell is a part of a merged cell.",
  "XtraSpreadsheetStringId.Msg_TryingToSortDataNextToLockedCells": "Spreadsheet обнаружил данные рядом с выделенным диапазоном, но у вас недостаточно прав для изменения этих ячеек.\n\nВы хотите продолжить работу с выделенным диапазоном?",
  "XtraSpreadsheetStringId.Msg_TryingToSortDataNextToOtherData": "Data found next to your selection. Since you have not selected this data, it will not be sorted.\n\nDo you want to expand the selection?",
  "XtraSpreadsheetStringId.Msg_UnableToInsertRowsIntoBindingRange": "Cannot add a row(s) to a data source range.",
  "XtraSpreadsheetStringId.Msg_UnableToInsertRowsIntoBindingRangeAPI": "Cannot add a row(s) to a data source range for which the AllowEdit or AllowNew option is not set.",
  "XtraSpreadsheetStringId.Msg_UnableToRemoveRowsFromBindingRange": "Cannot remove a row(s) from a data source range.",
  "XtraSpreadsheetStringId.Msg_UnableToRemoveRowsFromBindingRangeAPI": "Cannot remove a row(s) from a data source range for which the AllowRemove option is not set.",
  "XtraSpreadsheetStringId.Msg_UnableToSortMergedCells": "This operation requires the merged cells to be identically sized.",
  "XtraSpreadsheetStringId.Msg_UnableToSortMultipleSelection": "The command you chose cannot be performed with multiple selections.\n\nSelect a single range and click the command again.",
  "XtraSpreadsheetStringId.Msg_UnableToSortRangeContainsBindingRange": "Cannot sort the selected data. It belongs to a data source range for which sorting is not allowed.",
  "XtraSpreadsheetStringId.Msg_UnableToSortRangeContainsBindingRangeAPI": "Cannot sort a data source range for which the AllowSort option is not set.",
  "XtraSpreadsheetStringId.Msg_UnableToSortSelection": "The command could not be completed by using range specified. Select a single cell within the range and try the command again.",
  "XtraSpreadsheetStringId.Msg_UnmergeMergedCellsClarification": "Данная операция приведет к отмене объединения ячеек. Продолжить?",
  "XtraSpreadsheetStringId.Msg_UnsupportedChart": "Данная диаграмма недоступна в Spreadsheet.",
  "XtraSpreadsheetStringId.Msg_UnsupportedChartExcel": "Эта диаграмма недоступна в вашей версии Excel. \n\nИзменение этой фигуры или сохранение книги в другом формате приведет к остаточному повреждению диаграммы.",
  "XtraSpreadsheetStringId.Msg_UnsupportedFormControl": "This shape represents a form control that isn't available in Spreadsheet.",
  "XtraSpreadsheetStringId.Msg_UnsupportedPivotSlicerExcel": "Эта фигура представляет собой срез. Срезы поддерживаются в Excel 2010 и более поздних версиях.\n    \nЕсли фигура была изменена в более ранней версии Excel либо книга была сохранена в Excel 2003 или более ранней версии, использовать срез невозможно.",
  "XtraSpreadsheetStringId.Msg_UnsupportedSlicer": "This shape represents a slicer that isn't available in Spreadsheet.",
  "XtraSpreadsheetStringId.Msg_UnsupportedSmartArtGraphic": "This shape represents a SmartArt graphic object that isn't available in Spreadsheet.",
  "XtraSpreadsheetStringId.Msg_UnsupportedTableSlicerExcel": "Эта фигура представляет собой срез таблицы. Срезы таблицы поддерживаются в Excel и более поздних версиях.\n    \nЕсли фигура была изменена в более ранней версии Excel или если книга была сохранена в Excel 2007 или более ранней версии, этот срез использовать невозможно.",
  "XtraSpreadsheetStringId.Msg_UnsupportedTimeline": "This shape represents a timeline that isn't available in Spreadsheet.",
  "XtraSpreadsheetStringId.Msg_UnsupportedTimelineExcel": "Timeline: Works in Excel 2013 or higher. Do not move or resize.",
  "XtraSpreadsheetStringId.Msg_XFTableHasBeenTruncated": "Possible loss of formatting: the number of formats exceeds the maximum value. Extended format table has been truncated.",
  "XtraSpreadsheetStringId.NameBox_SelectionModeFormat": "{0}R x {1}C",
  "XtraSpreadsheetStringId.NewConditionalFormattingRuleForm_FormTitle": "Создание правила форматирования",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingAverage1StdDevAboveCondition": "на 1 стандартное отклонение выше",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingAverage1StdDevBelowCondition": "на 1 стандартное отклонение ниже",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingAverage2StdDevAboveCondition": "на 2 стандартных отклонения выше",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingAverage2StdDevBelowCondition": "на 2 стандартных отклонения ниже",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingAverage3StdDevAboveCondition": "на 3 стандартных отклонения выше",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingAverage3StdDevBelowCondition": "на 3 стандартных отклонения ниже",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingAverageAboveCondition": "выше",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingAverageBelowCondition": "ниже",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingAverageEqualOrAboveCondition": "равно или выше",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingAverageEqualOrBelowCondition": "равно или ниже",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingBeginsWithTextCondition": "начинается с",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingCellsBasedOnValuesColorScale2Type": "Двухцветная шкала",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingCellsBasedOnValuesColorScale3Type": "Трехцветная шкала",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingCellsBasedOnValuesDataBarType": "Гистограмма",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingCellsBasedOnValuesIconSetsType": "Наборы значков",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingCellValueOperatorTypeBetween": "между",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingCellValueOperatorTypeEqualTo": "равно",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingCellValueOperatorTypeGreaterThan": "больше",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingCellValueOperatorTypeGreaterThanOrEqualTo": "больше или равно",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingCellValueOperatorTypeLessThan": "меньше",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingCellValueOperatorTypeLessThanOrEqualTo": "меньше или равно",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingCellValueOperatorTypeNotBetween": "вне",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingCellValueOperatorTypeNotEqualTo": "не равно",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingContainsTextCondition": "содержит",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingDataBarGradientFillType": "Градиентная заливка",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingDataBarNoBorder": "Нет границы",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingDataBarSolidBorder": "Сплошная граница",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingDataBarSolidFillType": "Сплошная заливка",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingEndsWithTextCondition": "заканчивается на",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingFormatCellsThatContainTypeBlanks": "Пустые",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingFormatCellsThatContainTypeCellValue": "Значение ячейки",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingFormatCellsThatContainTypeDatesOccurring": "Даты",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingFormatCellsThatContainTypeErrors": "Ошибки",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingFormatCellsThatContainTypeNoBlanks": "Непустые",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingFormatCellsThatContainTypeNoErrors": "Без ошибок",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingFormatCellsThatContainTypeSpecificText": "Текст",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingIconSetAnd": " и",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingIconSetCustom": "Пользовательские",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingIconSetLess": " < ",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingIconSetLessOrEqual": " <= ",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingIconSetNoCellIcon": "Нет значка ячейки",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingIconSetWhen": "если",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingIconSetWhenValueIs": "если значение равно",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingLast7DayTimePeriod": "За последние 7 дней",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingLastMonthTimePeriod": "В прошлом месяце",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingLastWeekTimePeriod": "На прошлой неделе",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingNextMonthTimePeriod": "В следующем месяце",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingNextWeekTimePeriod": "На следующей неделе",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingNotContainsTextCondition": "не содержит",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingPreviewFormatSet": "AaBbБбЯя",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingPreviewNoFormatSet": "Формат не задан",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingSpecialDuplicateCondition": "повторяющиеся",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingSpecialUniqueCondition": "уникальные",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingThisMonthTimePeriod": "В этом месяце",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingThisWeekTimePeriod": "На этой неделе",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingTodayTimePeriod": "Сегодня",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingTomorrowTimePeriod": "Завтра",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingValueObjectTypeAutomatic": "Авто",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingValueObjectTypeFormula": "Формула",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingValueObjectTypeHighestValue": "Максимальное значение",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingValueObjectTypeHighestValueItem": "(Максимальное значение)",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingValueObjectTypeLowestValue": "Минимальное значение",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingValueObjectTypeLowestValueItem": "(Минимальное значение)",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingValueObjectTypeNumber": "Число",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingValueObjectTypePercent": "Процент",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingValueObjectTypePercentile": "Процентиль",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ConditionalFormattingYesterdayTimePeriod": "Вчера",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_FormatAllCellsBasedTheirValues": "Форматировать все ячейки на основании их значений",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_FormatOnlyCellsThatContain": "Форматировать только ячейки, которые содержат",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_FormatOnlyTopOrBottomRankedValues": "Форматировать только первые или последние значения",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_FormatOnlyUniqueOrDuplicateValues": "Форматировать только уникальные или повторяющиеся значения",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_FormatOnlyValuesThatAreAboveOrBelowAverage": "Форматировать только значения, которые находятся выше или ниже среднего",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_LongestBar": "значение для самого длинного столбца",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_MaximumPoint": "максимальное значение",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_MidPoint": "средние значение",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_MinimumPoint": "минимальное значение",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_RankDirectionBottom": "последним",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_RankDirectionTop": "первым",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_ShortestBar": "значение для самого короткого столбца",
  "XtraSpreadsheetStringId.NewEditConditionalFormattingRuleForm_UseFormulaToDetermineWhichCellsToFormat": "Использовать формулу для определения форматируемых ячеек",
  "XtraSpreadsheetStringId.NewSpreadsheetMailMergeParameter_Text": "New Spreadsheet Parameter...",
  "XtraSpreadsheetStringId.OptionsPivotTableForm_MissingItemsLimitAutomatic": "Авто",
  "XtraSpreadsheetStringId.OptionsPivotTableForm_MissingItemsLimitMax": "Максимум",
  "XtraSpreadsheetStringId.OptionsPivotTableForm_MissingItemsLimitNone": "Нет",
  "XtraSpreadsheetStringId.OptionsPivotTableForm_PageDownThenOver": "вниз, затем поперек",
  "XtraSpreadsheetStringId.OptionsPivotTableForm_PageOverThenDown": "поперек, затем вниз",
  "XtraSpreadsheetStringId.PageSetupForm_CommentsPrintModeAsDisplayedOnSheet": "Как на листе",
  "XtraSpreadsheetStringId.PageSetupForm_CommentsPrintModeAtEndOfSheet": "В конце листа",
  "XtraSpreadsheetStringId.PageSetupForm_CommentsPrintModeNone": "(нет)",
  "XtraSpreadsheetStringId.PageSetupForm_ErrorPrintModeBlank": "<нет>",
  "XtraSpreadsheetStringId.PageSetupForm_ErrorPrintModeDash": "--",
  "XtraSpreadsheetStringId.PageSetupForm_ErrorPrintModeDisplayed": "на экране",
  "XtraSpreadsheetStringId.PageSetupForm_ErrorPrintModeNA": "#Н/Д",
  "XtraSpreadsheetStringId.PageSetupForm_PageFirstPageNumberAuto": "Авто",
  "XtraSpreadsheetStringId.PageSetupForm_PagePrintQualityDpi": "точек на дюйм",
  "XtraSpreadsheetStringId.PivotPageFieldAllItemsCaption": "(All)",
  "XtraSpreadsheetStringId.PivotPageFieldMultipleItemsCaption": "(Multiple Items)",
  "XtraSpreadsheetStringId.PivotTableCalculatedFieldAndItemForm_Field": "Поле",
  "XtraSpreadsheetStringId.PivotTableCalculatedFieldAndItemForm_Formula": "Формула",
  "XtraSpreadsheetStringId.PivotTableCalculatedFieldAndItemForm_InsertCalculatedField": "Вставка вычисляемого поля",
  "XtraSpreadsheetStringId.PivotTableCalculatedFieldAndItemForm_InsertCalculatedItemIn": "Вставка вычисляемого элемента в \"{0}\"",
  "XtraSpreadsheetStringId.PivotTableGroupFieldForm_Days": "Дни",
  "XtraSpreadsheetStringId.PivotTableGroupFieldForm_Hours": "Часы",
  "XtraSpreadsheetStringId.PivotTableGroupFieldForm_Minutes": "Минуты",
  "XtraSpreadsheetStringId.PivotTableGroupFieldForm_Months": "Месяцы",
  "XtraSpreadsheetStringId.PivotTableGroupFieldForm_Quarters": "Кварталы",
  "XtraSpreadsheetStringId.PivotTableGroupFieldForm_Seconds": "Секунды",
  "XtraSpreadsheetStringId.PivotTableGroupFieldForm_Years": "Годы",
  "XtraSpreadsheetStringId.PivotTableMoreSortOptionsForm_SortReferenceIsNotValid": "Недопустимая ссылка для сортировки. Убедитесь, что она указывает на данные, которые требуется отсортировать, и что в первом поле \"Cорировать по\" указано допустимое значение.",
  "XtraSpreadsheetStringId.PivotTableMoreSortOptionsForm_Title": "Дополнительные параметры сортировки ({0})",
  "XtraSpreadsheetStringId.PivotTableMoreSortOptionsForm_ValuesInSelectedColumn": "Значения в выделенном столбце:",
  "XtraSpreadsheetStringId.PivotTableMoreSortOptionsForm_ValuesInSelectedRow": "Значения в выделенной строке:",
  "XtraSpreadsheetStringId.PivotTableSortOptionsForm_Title": "Сортировка ({0})",
  "XtraSpreadsheetStringId.PivotTableSortOptionsForms_SortInAscendingOrder": "по возрастанию",
  "XtraSpreadsheetStringId.PivotTableSortOptionsForms_SortInDescendingOrder": "по убыванию",
  "XtraSpreadsheetStringId.PivotTableSortOptionsForms_SortTypeManualDescription": "Перетащите элементы поля \"{0}\", чтобы отобразить их в любом порядке",
  "XtraSpreadsheetStringId.PivotTableSortOptionsForms_SortTypeNonManualByPivotDataFieldDescription": "Сортировка {0} по {1} {2}",
  "XtraSpreadsheetStringId.PivotTableSortOptionsForms_SortTypeNonManualByPivotDataFieldUsingValuesInColumnDescription": "Сортировка {0} по {1} {2}",
  "XtraSpreadsheetStringId.PivotTableSortOptionsForms_SortTypeNonManualByPivotDataFieldUsingValuesInRowDescription": "Сортировка {0} по {1} {2}",
  "XtraSpreadsheetStringId.PivotTableSortOptionsForms_SortTypeNonManualDescription": "Сортировка {0} {1}",
  "XtraSpreadsheetStringId.Scope_DefinedName": "Определенное имя",
  "XtraSpreadsheetStringId.Scope_ExternalWorkbook": "Внешняя книга",
  "XtraSpreadsheetStringId.Scope_SheetIndex": "Индекс листа={0}",
  "XtraSpreadsheetStringId.Scope_Workbook": "Книга",
  "XtraSpreadsheetStringId.StatusBarControl_Average": "AVERAGE:",
  "XtraSpreadsheetStringId.StatusBarControl_Count": "COUNT:",
  "XtraSpreadsheetStringId.StatusBarControl_Maximum": "MAX:",
  "XtraSpreadsheetStringId.StatusBarControl_Minimum": "MIN:",
  "XtraSpreadsheetStringId.StatusBarControl_NumericalCount": "NUMERICAL COUNT:",
  "XtraSpreadsheetStringId.StatusBarControl_Sum": "SUM:",
  "XtraSpreadsheetStringId.StyleName_Normal": "Обычный",
  "XtraSpreadsheetStringId.TargetFrameDescription_NewWindow": "New window",
  "XtraSpreadsheetStringId.TargetFrameDescription_ParentFrame": "Parent frame",
  "XtraSpreadsheetStringId.TargetFrameDescription_SameFrame": "Same frame",
  "XtraSpreadsheetStringId.TargetFrameDescription_WholePage": "Whole page",
  "XtraSpreadsheetStringId.Tooltip_CollapseFormulaBar": "Свернуть строку формул",
  "XtraSpreadsheetStringId.Tooltip_ExpandFormulaBar": "Развернуть строку формул",
  "XtraSpreadsheetStringId.Tooltip_FormulaBar": "Formula Bar",
  "XtraSpreadsheetStringId.Tooltip_FormulaBarCancelButton": "Отмена",
  "XtraSpreadsheetStringId.Tooltip_FormulaBarFunctionButton": "Вставить функцию",
  "XtraSpreadsheetStringId.Tooltip_FormulaBarOkButton": "Ввод",
  "XtraSpreadsheetStringId.Tooltip_Hyperlink": "Click once to follow. Click and hold to select this cell.",
  "XtraSpreadsheetStringId.Tooltip_NameBox": "Имя",
  "ASPxSpreadsheetStringId.InsertImage": "Вставить изображение",
  "ASPxSpreadsheetStringId.InsertImage_FromWeb": "Из интернета (URL)",
  "ASPxSpreadsheetStringId.InsertImage_FromLocal": "С компьютера",
  "ASPxSpreadsheetStringId.InsertImage_EnterUrl": "Введите веб-адрес изображения",
  "ASPxSpreadsheetStringId.InsertImage_UploadInstructions": "Обзор Вашего компьютера для загрузки изображения",
  "ASPxSpreadsheetStringId.InsertImage_ImagePreview": "Просмотр изображения",
  "ASPxSpreadsheetStringId.InsertImage_ImageManager_Header": "Выбор изображения",
  "ASPxSpreadsheetStringId.InsertLink": "Вставить ссылку",
  "ASPxSpreadsheetStringId.ChangeLink": "Изменить ссылку",
  "ASPxSpreadsheetStringId.InsertLink_URL": "URL",
  "ASPxSpreadsheetStringId.InsertLink_WebPage": "Web-страница",
  "ASPxSpreadsheetStringId.InsertLink_Email": "Адрес электронной почты",
  "ASPxSpreadsheetStringId.InsertLink_EmailTo": "Адресат",
  "ASPxSpreadsheetStringId.InsertLink_Subject": "Тема",
  "ASPxSpreadsheetStringId.InsertLink_Text": "Текст",
  "ASPxSpreadsheetStringId.InsertLink_ToolTip": "Подсказка",
  "ASPxSpreadsheetStringId.OpenFile": "Открыть файл электронной таблицы",
  "ASPxSpreadsheetStringId.OpenFile_FromServer": "С сервера",
  "ASPxSpreadsheetStringId.OpenFile_FromComputer": "С компьютера",
  "ASPxSpreadsheetStringId.OpenFile_ChooseInstruction": "Выбрать файл электронной таблицы с сервера",
  "ASPxSpreadsheetStringId.OpenFile_UploadInstruction": "Обзор Вашего компьютера для загрузки файла электронной таблицы",
  "ASPxSpreadsheetStringId.OpenFile_FileManager_Header": "Выбрать файл электронной таблицы",
  "ASPxSpreadsheetStringId.RenameSheet": "Переименовать лист",
  "ASPxSpreadsheetStringId.RenameSheet_SheetName": "Имя листа",
  "ASPxSpreadsheetStringId.SaveFile": "Сохранить файл электронной таблицы как",
  "ASPxSpreadsheetStringId.SaveFile_FileAlreadyExists": "уже существует. Заменить?",
  "ASPxSpreadsheetStringId.SaveFile_SaveFileToServer": "Сохранить файл на этом сервере",
  "ASPxSpreadsheetStringId.SaveFile_DownloadCopy": "Скачать копию",
  "ASPxSpreadsheetStringId.SaveFile_FolderPath": "Путь к папке",
  "ASPxSpreadsheetStringId.SaveFile_FileName": "Имя файла",
  "ASPxSpreadsheetStringId.SaveFile_FileType": "Тип файла",
  "ASPxSpreadsheetStringId.SaveFile_DownloadInstruction": "Выберите тип скачиваемого файла",
  "ASPxSpreadsheetStringId.SaveFile_FolderManager_Header": "Выберите каталог назначения или существующий файл",
  "ASPxSpreadsheetStringId.SaveFile_PathDoesNotExist": "\n      Этот путь не существует.\n      Проверьте правильность указанаия пути и повторите попытку.\n    ",
  "ASPxSpreadsheetStringId.SaveFile_WrongDocumentPath": "Невозможно сохранить документ по указанному пути.",
  "ASPxSpreadsheetStringId.SaveFile_WrongDocumentExtension": "Невозможно сохранить документ указанного формата.",
  "ASPxSpreadsheetStringId.RowHeight": "Высота строки",
  "ASPxSpreadsheetStringId.RowHeight_Caption": "Высота строки",
  "ASPxSpreadsheetStringId.ColumnWidth": "Ширина столбца",
  "ASPxSpreadsheetStringId.ColumnWidth_Caption": "Ширина столбца",
  "ASPxSpreadsheetStringId.DefaultColumnWidth": "Стандартная ширина",
  "ASPxSpreadsheetStringId.DefaultColumnWidth_Caption": "Стандартная ширина столбца",
  "ASPxSpreadsheetStringId.UnhideSheet": "Показать",
  "ASPxSpreadsheetStringId.UnhideSheet_Caption": "Скрыть лист",
  "ASPxSpreadsheetStringId.ChangeChartType": "Изменить тип графика",
  "ASPxSpreadsheetStringId.ChartSelectData": "Выбрать источник данных",
  "ASPxSpreadsheetStringId.ChartSelectData_Caption": "Диапазон данных графика",
  "ASPxSpreadsheetStringId.ModifyChartLayout": "Расположение графика",
  "ASPxSpreadsheetStringId.ChartChangeTitle": "Изменить заголовок графика",
  "ASPxSpreadsheetStringId.ChartChangeTitle_Caption": "Заголовок графика",
  "ASPxSpreadsheetStringId.ChartChangeHorizontalAxisTitle": "Изменить заголовок горизонтальной оси",
  "ASPxSpreadsheetStringId.ChartChangeHorizontalAxisTitle_Caption": "Заголовок горизонтальной оси",
  "ASPxSpreadsheetStringId.ChartChangeVerticalAxisTitle": "Изменить заголовок вертикальной оси",
  "ASPxSpreadsheetStringId.ChartChangeVerticalAxisTitle_Caption": "Заголовок вертикальной оси",
  "ASPxSpreadsheetStringId.ModifyChartStyle": "Стили графика",
  "ASPxSpreadsheetStringId.FindAndReplace": "Поиск",
  "ASPxSpreadsheetStringId.FindAndReplace_FindTab_Caption": "Поиск",
  "ASPxSpreadsheetStringId.FindAndReplace_FindWhat": "Найти",
  "ASPxSpreadsheetStringId.FindAndReplace_MatchCase": "Учитывать регистр",
  "ASPxSpreadsheetStringId.FindAndReplace_Search": "Просматривать",
  "ASPxSpreadsheetStringId.FindAndReplace_Search_ByRows": "По строкам",
  "ASPxSpreadsheetStringId.FindAndReplace_Search_ByColumns": "По столбцам",
  "ASPxSpreadsheetStringId.FindAndReplace_LookIn": "Область поиска",
  "ASPxSpreadsheetStringId.FindAndReplace_LookIn_Formulas": "Формулы",
  "ASPxSpreadsheetStringId.FindAndReplace_LookIn_Values": "Значения",
  "ASPxSpreadsheetStringId.FindAndReplace_MatchCellContent": "Ячейка целиком",
  "ASPxSpreadsheetStringId.FindAndReplace_SearchResults": "Результаты поиска",
  "ASPxSpreadsheetStringId.FindAndReplace_SearchResults_CellHeader": "Ячейка",
  "ASPxSpreadsheetStringId.FindAndReplace_SearchResults_ValueHeader": "Значение",
  "ASPxSpreadsheetStringId.ButtonInsert": "Вставить",
  "ASPxSpreadsheetStringId.ButtonChange": "Изменить",
  "ASPxSpreadsheetStringId.ButtonCancel": "Отменить",
  "ASPxSpreadsheetStringId.ButtonOK": "OK",
  "ASPxSpreadsheetStringId.ButtonOpen": "Открыть",
  "ASPxSpreadsheetStringId.ButtonSaveAs": "Сохранить как",
  "ASPxSpreadsheetStringId.ButtonSelect": "Выбрать",
  "ASPxSpreadsheetStringId.ButtonDownload": "Скачать",
  "ASPxSpreadsheetStringId.ButtonFindAll": "Найти все",
  "ASPxSpreadsheetStringId.ButtonUpdate": "Обновить",
  "ASPxSpreadsheetStringId.Invalid_FileName": "Некорректное имя файла",
  "ASPxSpreadsheetStringId.Invalid_EMail": "Некорректный адрес электронной почты",
  "ASPxSpreadsheetStringId.Invalid_URL": "Некорректный адрес ссылки",
  "ASPxSpreadsheetStringId.BorderLineStyle_Thin": "Тонкий",
  "ASPxSpreadsheetStringId.BorderLineStyle_Dashed": "Штрих",
  "ASPxSpreadsheetStringId.BorderLineStyle_Dotted": "Пунктир",
  "ASPxSpreadsheetStringId.BorderLineStyle_Double": "Двойной",
  "ASPxSpreadsheetStringId.BorderLineStyle_Medium": "Средний",
  "ASPxSpreadsheetStringId.BorderLineStyle_MediumDashed": "Средний штрих",
  "ASPxSpreadsheetStringId.BorderLineStyle_MediumDotted": "Средний пунктир",
  "ASPxSpreadsheetStringId.BorderLineStyle_Thick": "Толстый",
  "ASPxSpreadsheetStringId.ReadingViewTab_Title": "Режим чтения",
  "ASPxSpreadsheetStringId.ReadingViewGroup_Title": "Режим чтения",
  "ASPxSpreadsheetStringId.DocumentViewsGroup_Title": "Представления документа",
  "ASPxSpreadsheetStringId.EditingViewCommand_Text": "Режим редактирования",
  "ASPxSpreadsheetStringId.ReadingViewCommand_Text": "Режим чтения",
  "ASPxSpreadsheetStringId.ViewGroup_Title": "Вид",
  "ASPxSpreadsheetStringId.FullScreenCommand_Text": "На весь экран",
  "ASPxSpreadsheetStringId.FullScreenCommand_Description": "Просмотреть документ в полноэкранном режиме.",
  "ASPxSpreadsheetStringId.DownloadCopy_Text": "Скачать",
  "ASPxSpreadsheetStringId.DownloadCopy_Description": "Скачать копию документа.",
  "ASPxSpreadsheetStringId.RequiredFieldError": "Это поле обязательно",
  "ASPxSpreadsheetStringId.ExternalRibbonControl_NotFound": "Внешний риббон контрол '{0}' не найден.",
  "ASPxSpreadsheetStringId.ConfirmOnLosingChanges": "Вы уверены, что хотите выполнить это действие? Все несохраненные данные будут потеряны.",
  "ASPxSpreadsheetStringId.DataFilterSimple": "Автофильтр",
  "ASPxSpreadsheetStringId.CustomAutoFilter": "Настраиваемый автофильтр",
  "ASPxSpreadsheetStringId.TableSelectData": "Создание таблицы",
  "ASPxSpreadsheetStringId.TableSelectData_Caption": "Укажите расположение данных таблицы:",
  "ASPxSpreadsheetStringId.TableSelectData_TableHasHeaders": "Таблица с заголовками",
  "ASPxSpreadsheetStringId.MoveOrCopySheet": "Переместить или скопировать",
  "ASPxSpreadsheetStringId.MoveOrCopySheet_MoveSheetsCaption": "Переместить выбранные листы перед листом",
  "ASPxSpreadsheetStringId.MoveOrCopySheet_CreateCopy": "Создать копию",
  "ASPxSpreadsheetStringId.DataValidation": "Проверка вводимых значений",
  "ASPxSpreadsheetStringId.DataValidation_RetryButton": "Повторить",
  "ASPxSpreadsheetStringId.DataValidation_YesButton": "Да",
  "ASPxSpreadsheetStringId.DataValidation_NoButton": "Нет",
  "ASPxSpreadsheetStringId.DataValidation_Failed_Caption": "Введенное значение неверно",
  "ASPxSpreadsheetStringId.FormulaValidation_Failed_Caption": "Введенная формула неверна",
  "ASPxSpreadsheetStringId.DataValidation_Settings_Caption": "Параметры",
  "ASPxSpreadsheetStringId.DataValidation_Settings_GroupCaption": "Условие проверки",
  "ASPxSpreadsheetStringId.DataValidation_Settings_Allow": "Разрешить",
  "ASPxSpreadsheetStringId.DataValidation_Settings_IgnoreBlank": "Игнорировать пустые ячейки",
  "ASPxSpreadsheetStringId.DataValidation_Settings_Data": "Данные",
  "ASPxSpreadsheetStringId.DataValidation_Settings_InCellDropDown": "Список допустимых значений",
  "ASPxSpreadsheetStringId.DataValidation_Settings_ApplyChanges": "Распространить изменения на другие ячейки с тем же уловием",
  "ASPxSpreadsheetStringId.DataValidation_Message_Caption": "Сообщение для ввода",
  "ASPxSpreadsheetStringId.DataValidation_Message_ShowMessage": "Отображать подсказку, если ячейка является текущей",
  "ASPxSpreadsheetStringId.DataValidation_Message_ShowDescription": "При выборе ячейки вывести следующее сообщение",
  "ASPxSpreadsheetStringId.DataValidation_Message_InputMessageTitle": "Заголовок",
  "ASPxSpreadsheetStringId.DataValidation_Message_InputMessage": "Сообщение",
  "ASPxSpreadsheetStringId.DataValidation_Alert_Caption": "Сообщение об ошибке",
  "ASPxSpreadsheetStringId.DataValidation_Alert_ShowAlert": "Выводить сообщение об ошибке",
  "ASPxSpreadsheetStringId.DataValidation_Alert_ShowDescription": "При попытке ввода неверных данных отображать сообщение",
  "ASPxSpreadsheetStringId.DataValidation_Alert_Style": "Вид",
  "ASPxSpreadsheetStringId.DataValidation_Alert_ErrorMessageTitle": "Заголовок",
  "ASPxSpreadsheetStringId.DataValidation_Alert_ErrorMessage": "Сообщение",
  "ASPxSpreadsheetStringId.DataValidation_ClearAll": "Очистить все",
  "ASPxSpreadsheetStringId.ModifyTableStyle": "Стили таблицы",
  "ASPxSpreadsheetStringId.ModifyTableStyle_Command_Caption": "Изменить стиль",
  "ASPxSpreadsheetStringId.FormatAsTable": "Форматирование таблицы",
  "ASPxSpreadsheetStringId.SelectTableStyle": "Выбрать стиль таблицы",
  "ASPxSpreadsheetStringId.Caption_LightTableStyleCategory": "Светлый",
  "ASPxSpreadsheetStringId.Caption_MediumTableStyleCategory": "Средний",
  "ASPxSpreadsheetStringId.Caption_DarkTableStyleCategory": "Тёмный",
  "ASPxSpreadsheetStringId.Caption_PrefixTableStyleNamePart": "Стиль таблицы:",
  "ASPxSpreadsheetStringId.Caption_LightTableStyleNamePart": "Светлый",
  "ASPxSpreadsheetStringId.Caption_MediumTableStyleNamePart": "Средний",
  "ASPxSpreadsheetStringId.Caption_DarkTableStyleNamePart": "Тёмный",
  "ASPxSpreadsheetStringId.PageSetup": "Параметры страницы",
  "ASPxSpreadsheetStringId.PageSetup_PageTab_Caption": "Страница",
  "ASPxSpreadsheetStringId.PageSetup_PageTab_OrientationGroup": "Ориентация",
  "ASPxSpreadsheetStringId.PageSetup_PageTab_OrientationPortrait": "книжная",
  "ASPxSpreadsheetStringId.PageSetup_PageTab_OrientationLandscape": "альбомная",
  "ASPxSpreadsheetStringId.PageSetup_PageTab_ScalingGroup": "Масштаб",
  "ASPxSpreadsheetStringId.PageSetup_PageTab_AdjustTo": "установить:",
  "ASPxSpreadsheetStringId.PageSetup_PageTab_Scale": "% от натуральной величины",
  "ASPxSpreadsheetStringId.PageSetup_PageTab_FitTo": "разместить не более чем на:",
  "ASPxSpreadsheetStringId.PageSetup_PageTab_FitToWidth": "стр. в ширину и",
  "ASPxSpreadsheetStringId.PageSetup_PageTab_FitToHeight": "стр. в высоту",
  "ASPxSpreadsheetStringId.PageSetup_PageTab_PaperSize": "Размер бумаги:",
  "ASPxSpreadsheetStringId.PageSetup_PageTab_PrintQuality": "Качество печати:",
  "ASPxSpreadsheetStringId.PageSetup_PageTab_FirstPageNumber": "Номер первой страницы:",
  "ASPxSpreadsheetStringId.PageSetup_MarginsTab_Caption": "Поля",
  "ASPxSpreadsheetStringId.PageSetup_MarginsTab_Left": "левое",
  "ASPxSpreadsheetStringId.PageSetup_MarginsTab_Top": "верхнее",
  "ASPxSpreadsheetStringId.PageSetup_MarginsTab_Header": "верхнего колонтитула",
  "ASPxSpreadsheetStringId.PageSetup_MarginsTab_Right": "правое",
  "ASPxSpreadsheetStringId.PageSetup_MarginsTab_Footer": "нижнего колонтитула",
  "ASPxSpreadsheetStringId.PageSetup_MarginsTab_Bottom": "нижнее",
  "ASPxSpreadsheetStringId.PageSetup_MarginsTab_CenterOnPageGroup": "Центрировать на странице",
  "ASPxSpreadsheetStringId.PageSetup_MarginsTab_CenterHorizontally": "горизонтально",
  "ASPxSpreadsheetStringId.PageSetup_MarginsTab_CenterVertically": "вертикально",
  "ASPxSpreadsheetStringId.PageSetup_HeaderFooterTab_Caption": "Колонтитулы",
  "ASPxSpreadsheetStringId.PageSetup_HeaderFooterTab_Header": "Верхний колонтитул",
  "ASPxSpreadsheetStringId.PageSetup_HeaderFooterTab_Footer": "Нижний колонтитул",
  "ASPxSpreadsheetStringId.PageSetup_HeaderFooterTab_DifferentOddEven": "Разные колонтитулы для четных и нечетных страниц",
  "ASPxSpreadsheetStringId.PageSetup_HeaderFooterTab_DifferentFirst": "Особый колонтитул для первой страницы",
  "ASPxSpreadsheetStringId.PageSetup_HeaderFooterTab_ScaleWithDoc": "Изменять масштаб вместе с документом",
  "ASPxSpreadsheetStringId.PageSetup_HeaderFooterTab_AlignWithMargins": "Выровнять относительно полей страницы",
  "ASPxSpreadsheetStringId.PageSetup_HeaderFooterTab_CustomHeader": "Создать верхний колонтитул...",
  "ASPxSpreadsheetStringId.PageSetup_HeaderFooterTab_CustomFooter": "Создать нижний колонтитул...",
  "ASPxSpreadsheetStringId.PageSetup_SheetTab_Caption": "Лист",
  "ASPxSpreadsheetStringId.PageSetup_SheetTab_PrintArea": "Выводить на печать диапазон",
  "ASPxSpreadsheetStringId.PageSetup_SheetTab_PrintAreaErrorText": "Мы обнаружили проблему в этой формуле. Нам не удается найти ссылку на диапазон или определенное имя.",
  "ASPxSpreadsheetStringId.PageSetup_SheetTab_PrintGroup": "Печать",
  "ASPxSpreadsheetStringId.PageSetup_SheetTab_Gridlines": "сетка",
  "ASPxSpreadsheetStringId.PageSetup_SheetTab_Draft": "черновая",
  "ASPxSpreadsheetStringId.PageSetup_SheetTab_PrintHeadings": "заголовки строк и столбцов",
  "ASPxSpreadsheetStringId.PageSetup_SheetTab_Comments": "примечания",
  "ASPxSpreadsheetStringId.PageSetup_SheetTab_CellErrorAs": "ошибки ячеек как",
  "ASPxSpreadsheetStringId.PageSetup_SheetTab_PageOrderGroup": "Последовательность вывода страниц",
  "ASPxSpreadsheetStringId.PageSetup_SheetTab_PageOrder_DownThenOver": "вниз, затем вправо",
  "ASPxSpreadsheetStringId.PageSetup_SheetTab_PageOrder_OverThenDown": "вправо, затем вниз",
  "ASPxSpreadsheetStringId.PageSetup_Print": "Печать...",
  "ASPxSpreadsheetStringId.CustomFooter": "Нижний колонтитул",
  "ASPxSpreadsheetStringId.CustomHeader": "Верхний колонтитул",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_AllPagesTab_Header_Caption": "Верхний колонтитул",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_FirstPageTab_Header_Caption": "Верхний клонтитул первой страницы",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_OddPageTab_Header_Caption": "Верхний колонтитул нечетной страницы",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_EvenPageTab_Header_Caption": "Верхний колонтитул четной страницы",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_AllPagesTab_Footer_Caption": "Нижний колонтитул",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_FirstPageTab_Footer_Caption": "Нижний колонтитул первой страницы",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_OddPageTab_Footer_Caption": "Нижний колонтитул нечетной страницы",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_EvenPageTab_Footer_Caption": "Нижний колонтитул четной страницы",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_HelpText": "Чтобы поместить номер страницы, дату, время, имя файла, путь к файлу или имя листа, установите курсор на место вставки и нажмите нужную кнопку",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_LeftHeader": "Верхний колонтитул слева",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_CenterHeader": "Верхний колонтитул в центре",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_RightHeader": "Верхний колонтитул справа",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_LeftFooter": "Нижний колонтитул слева",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_CenterFooter": "Нижний колонтитул в центре",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_RightFooter": "Нижний колонтитул справа",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_InsertPageNumber": "Вставить номер страницы",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_InsertPageTotal": "Вставить число страниц",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_InsertDate": "Вставить дату",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_InsertTime": "Вставить время",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_InsertFilePath": "Вставить путь к файлу",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_InsertFileName": "Вставить имя файла",
  "ASPxSpreadsheetStringId.CustomHeaderFooter_InsertSheetName": "Вставить имя листа",
  "ASPxSpreadsheetStringId.FormulaBar_EnterButtonTooltip": "Ввод",
  "ASPxSpreadsheetStringId.FormulaBar_CancelButtonTooltip": "Отмена",
  "ASPxSpreadsheetStringId.FilterSimple_CheckAll": "Выбрать все",
  "ASPxSpreadsheetStringId.FilterSimple_UncheckAll": "Снять выделение",
  "ASPxSpreadsheetStringId.FilterTop10_Show": "Показать",
  "ASPxSpreadsheetStringId.CustomFilter_ShowRows": "Показать только те строки, значения которых",
  "ASPxSpreadsheetStringId.CustomFilter_OperatorAnd": "И",
  "ASPxSpreadsheetStringId.CustomFilter_OperatorOr": "ИЛИ",
  "ASPxSpreadsheetStringId.CustomFilter_QuestionSignDescription": "Знак вопроса \"?\" обозначает любой знак",
  "ASPxSpreadsheetStringId.CustomFilter_StarSignDescription": "Знак \"*\" обозначает последовательность любых знаков",
  "ASPxSpreadsheetStringId.FileManager_OpenedFileDeleteErrorText": "Не удалось удалить файл. Он уже открыт другим пользователем.",
  "ASPxSpreadsheetStringId.FileManager_OpenedFileMoveErrorText": "Не удалось переместить файл. Он уже открыт другим пользователем.",
  "ASPxSpreadsheetStringId.FileManager_OpenedFileRenameErrorText": "Не удалось переименовать файл. Он уже открыт другим пользователем.",
  "ASPxSpreadsheetStringId.OpeningAndOverstoreImpossibleError": "Открытие и сохранение документа невозможно, так как не задана рабочая папка",
  "ASPxSpreadsheetStringId.MessageBox_WarningTitle": "Предупреждение",
  "ASPxSpreadsheetStringId.MessageBox_ErrorTitle": "Ошибка",
  "ASPxSpreadsheetStringId.MessageBox_InformationTitle": "Информация",
  "ASPxSpreadsheetStringId.MessageBox_QuestionTitle": "Вопрос",
  "ASPxSpreadsheetStringId.MessageBox_SessionExpired": "Время сессии истекло. Пожалуйста, обновите страницу чтобы продолжить.",
  "ASPxSpreadsheetStringId.InvalidFontSize": "Размер шрифта должен быть в интервале от 1 до 409 пунктов",
  "ASPxSpreadsheetStringId.SheetTabs_NewSheet_Tooltip": "Новый лист",
  "ASPxSpreadsheetStringId.FormatCells": "Формат ячеек",
  "ASPxSpreadsheetStringId.FormatCells_CustomFormatDescription": "Выберите один из существующих в документе форматов",
  "ASPxSpreadsheetStringId.FormatCells_NumberTab_Caption": "Число",
  "ASPxSpreadsheetStringId.FormatCells_NumberTab_Category": "Категория",
  "ASPxSpreadsheetStringId.FormatCells_NumberTab_Sample": "Образец",
  "ASPxSpreadsheetStringId.FormatCells_NumberTab_DecimalPlaces": "Число десятичных знаков",
  "ASPxSpreadsheetStringId.FormatCells_NumberTab_CurrencySymbol": "Символ",
  "ASPxSpreadsheetStringId.FormatCells_NumberTab_Type": "Тип",
  "ASPxSpreadsheetStringId.FormatCells_NumberTab_Locate": "Язык (местоположение)",
  "ASPxSpreadsheetStringId.FormatCells_NumberTab_DecimalPlacesErrorText": "Введено недопустимое значение. Следует ввести число.",
  "ASPxSpreadsheetStringId.FormatCells_NumberTab_NegativeNumbers": "Negative numbers",
  "ASPxSpreadsheetStringId.FormatCells_NumberTab_ThousandSeparator": "Use 1000 Separator",
  "ASPxSpreadsheetStringId.FormatCells_NumberTab_SampleUnavailable": "Sample is unavailable",
  "ASPxSpreadsheetStringId.PivotTable": "Создание сводной таблицы",
  "ASPxSpreadsheetStringId.PivotTable_DataRangeDescription": "Выберете данные для анализа",
  "ASPxSpreadsheetStringId.PivotTable_DataRangeCaption": "Выбрать таблицу или диапазон",
  "ASPxSpreadsheetStringId.PivotTable_ReportPlacedDescription": "Укажите, куда следует поместить отчет сводной таблицы",
  "ASPxSpreadsheetStringId.PivotTable_ReportPlacedNewWorksheetCaption": "На новый лист",
  "ASPxSpreadsheetStringId.PivotTable_ReportPlacedExistingWorksheetCaption": "На существующий лист",
  "ASPxSpreadsheetStringId.PivotTable_ReportPlacedLocationCaption": "Диапазон",
  "ASPxSpreadsheetStringId.ChangeDataSourcePivotTable": "Изменить источник данных свободной таблицы",
  "ASPxSpreadsheetStringId.MovePivotTable": "Переместить сводную таблицу",
  "ASPxSpreadsheetStringId.PivotTableFieldList": "Поля сводной таблицы",
  "ASPxSpreadsheetStringId.PivotTableFieldList_SourceList_Caption": "Выберите поля для добавления в отчет",
  "ASPxSpreadsheetStringId.PivotTableFieldList_Destination_Description": "Перетащите поля в нужную область",
  "ASPxSpreadsheetStringId.PivotTableFieldList_Filters": "ФИЛЬТРЫ",
  "ASPxSpreadsheetStringId.PivotTableFieldList_Columns": "КОЛОННЫ",
  "ASPxSpreadsheetStringId.PivotTableFieldList_Rows": "СТРОКИ",
  "ASPxSpreadsheetStringId.PivotTableFieldList_Values": "ЗНАЧЕНИЯ",
  "ASPxSpreadsheetStringId.PivotTableFieldList_LayoutUpdateCaption": "Отложить обновление макета",
  "ASPxSpreadsheetStringId.PivotTableDateFilter": "Фильтр по дате",
  "ASPxSpreadsheetStringId.PivotTableDateFilter_Description": "Показывать даты, для которых выполняется следующее условие",
  "ASPxSpreadsheetStringId.PivotTableDateFilter_BetweenSeparator": "и",
  "ASPxSpreadsheetStringId.PivotTableValueFilter": "Фильтр по значению",
  "ASPxSpreadsheetStringId.PivotTableValueFilter_Description": "Показывать элементы, для которых выполняется следующее условие",
  "ASPxSpreadsheetStringId.PivotTableTop10Filter": "Фильтр «Первые 10»",
  "ASPxSpreadsheetStringId.PivotTableTop10Filter_Description": "Показать",
  "ASPxSpreadsheetStringId.PivotTableTop10Filter_BetweenSeparator": "по",
  "ASPxSpreadsheetStringId.PivotTableLabelFilter": "Фильтр по подписи",
  "ASPxSpreadsheetStringId.PivotTableLabelFilter_Description": "Показывать элементы, для подписей которых выполняется следующее условие",
  "ASPxSpreadsheetStringId.PivotTableLabelFilter_BetweenSeparator": "и",
  "ASPxSpreadsheetStringId.PivotTableItemFilter": "Фильтр по полю",
  "ASPxSpreadsheetStringId.PivotTableItemFilter_SelectMultipleItems": "Выбрать несколько элементов",
  "ASPxSpreadsheetStringId.DownloadImage_InvalidImageFormat": "Invalid image format",
  "ASPxSpreadsheetStringId.DownloadImage_InvalidImageUrl": "Incorrect image URL",
  "ASPxSpreadsheetStringId.DownloadImage_InvalidFileSize": "Invalid image file size",
  "ASPxSpreadsheetStringId.MenuCmd_SelectCustomDate": "Выбрать пользовательскую дату",
  "ASPxSpreadsheetStringId.InsertImage_Browse": "Обзор"
}
    })
});
