/**
* DevExpress AspNetCore Spreadsheet (dx-aspnetcore-spreadsheet.js)
* Version: 21.1.3
* Copyright (c) 2012 - 2021 Developer Express Inc. ALL RIGHTS RESERVED
* License: https://www.devexpress.com/Support/EULAs
*/
/*# namespace DevExpress.Web.Scripts #*/

var ASPx = ASPx || {};
var dx = dx || {};

(function module(ASPx, dx) {
ASPx.modules = { Utils: module };
/*# public class JavaScriptObject : object #*/
    
if(!ASPx.attachToReady)
    ASPx.attachToReady = function (callback) { ASPx.Evt.AttachEventToElement(window, "load", callback); };
if(!ASPx.attachToLoad)
    ASPx.attachToLoad = function(callback) { ASPx.Evt.AttachEventToDocumentCore("DOMContentLoaded", callback); };
ASPx.EmptyObject = { };
ASPx.FalseFunction = function() { return false; };

ASPx.SSLSecureBlankUrl = '<%=WebResource("custom:SSLSecureBlankUrl")%>';
ASPx.EmptyImageUrl = '<%=WebResource("custom:EmptyImageUrl")%>';

ASPx.VersionInfo = '<%=WebResource("custom:VersionInfo")%>';
ASPx.Platform = '<%=WebResource("custom:Platform")%>';
ASPx.DoctypeMode = '<%=WebResource("custom:DoctypeMode")%>';

ASPx.InvalidDimension = -10000;
ASPx.InvalidPosition = -10000;
ASPx.AbsoluteLeftPosition = -10000;
ASPx.EmptyGuid = "00000000-0000-0000-0000-000000000000";

ASPx.CallbackSeparator = ":";
ASPx.ItemIndexSeparator = "i";
ASPx.CallbackResultPrefix = "/*DX*/";
ASPx.StyleValueEncodedSemicolon = "DXsmcln";
ASPx.AccessibilityEmptyUrl = "javascript:;";
ASPx.AccessibilityPronounceTimeout = 500;

ASPx.MaxMobileWindowWidth = 576;

ASPx.PossibleNumberDecimalSeparators = [",", "."];

ASPx.CultureInfo = {
    twoDigitYearMax: 2029,
    ts: ":",
    ds: "/",
    am: "AM",
    pm: "PM",
	monthNames: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", ""],
	genMonthNames: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", ""],
	abbrMonthNames: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", ""],
	abbrDayNames: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
	dayNames: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
	
	invariantCultureDecimalPoint: ".",

    numDecimalPoint: ".",
	numPrec: 2,
	numGroupSeparator: ",",	
	numGroups: [ 3 ],
	numNegPattern: 1,
	
	numPosInf: "Infinity",	
	numNegInf: "-Infinity", 
	numNan: "NaN",
	
	currency: "$",
	
	currDecimalPoint: ".",
	currPrec: 2,
	currGroupSeparator: ",",
	currGroups: [ 3 ],
	currPosPattern: 0,
	currNegPattern: 0,
	
	percentPattern: 0,

	shortTime: "h:mm tt",
	longTime: "h:mm:ss tt",
	shortDate: "M/d/yyyy",
	longDate: "dddd, MMMM d, yyyy",
	monthDay: "MMMM d",
	yearMonth: "MMMM yyyy"
};
ASPx.CultureInfo.genMonthNames = ASPx.CultureInfo.monthNames;

ASPx.Position = {
    Left: "Left",
    Right: "Right",
    Top: "Top",
    Bottom: "Bottom"
};
ASPx.FOCUS_TIMEOUT = 100;
function setInnerHtmlInternal(el, trustedHtmlString) { 
    el.innerHTML = trustedHtmlString;
}

var DateUtils = { };
DateUtils.GetInvariantDateString = function(date) {
    if(!date)
        return "01/01/0001";
    var day = date.getDate();
    var month = date.getMonth() + 1;
    var year = date.getFullYear();
    var result = "";
    if(month < 10)
        result += "0";
    result += month.toString() + "/";
    if(day < 10)
        result += "0";
    result += day.toString() + "/";
    if(year < 1000)
        result += "0";
    result += year.toString();
    return result;
};
DateUtils.GetInvariantDateTimeString = function(date) {
    var dateTimeString = DateUtils.GetInvariantDateString(date);
    
    var time = {
        h: date.getHours(),
        m: date.getMinutes(),
        s: date.getSeconds()
    };
    for(var key in time) {
        if(time.hasOwnProperty(key)) {
            var str = time[key].toString();
            if(str.length < 2)
                str = "0" + str;
            time[key] = str;
        }
    }
    dateTimeString += " " + time.h + ":" + time.m + ":" + time.s;
    
    var msec = date.getMilliseconds();
    if(msec > 0)
        dateTimeString += "." + ("000" + msec.toString()).substr(-3);

    return dateTimeString;
};
DateUtils.ExpandTwoDigitYear = function(value) {
    value += 1900;
    if(value + 99 < ASPx.CultureInfo.twoDigitYearMax)
        value += 100;
    return value;	    
};
DateUtils.GetTimeZoneOffsetDifference = function(firstDate, secondDate) {
    if(!secondDate)
        secondDate = DateUtils.GetUtcDate(firstDate);
    return 60000 * (firstDate.getTimezoneOffset() - secondDate.getTimezoneOffset());
};

DateUtils.GetTimeZoneOffset = function(date) {
    var isECMA262Support = ASPx.Browser.Chrome && ASPx.Browser.Version >= 67;
    if(!isECMA262Support)
        return date.getTimezoneOffset() * 60000;

    var utcDate = DateUtils.GetUtcDate(date);
    var utcTimezoneOffsetDifference = DateUtils.GetTimeZoneOffsetDifference(date);

    if(utcTimezoneOffsetDifference !== 0)
        utcDate.setTime(utcDate.valueOf() + utcTimezoneOffsetDifference);

    return utcDate - date;
};
DateUtils.GetUtcDate = function(date) {
    var utcFullYear = date.getUTCFullYear();
    var result = new Date(utcFullYear, date.getUTCMonth(), date.getUTCDate(), date.getUTCHours(), date.getUTCMinutes(), date.getUTCSeconds(), date.getUTCMilliseconds());
    if(utcFullYear < 100)
        result.setFullYear(utcFullYear);
    return result;
};
DateUtils.ToUtcTime = function(date) {
	var result = new Date();
	result.setTime(date.valueOf() + ASPx.DateUtils.GetTimeZoneOffset(date));
	return result;
};
DateUtils.ToLocalTime = function(date) {
	var result = new Date();
	result.setTime(date.valueOf() - ASPx.DateUtils.GetTimeZoneOffset(date));
	return result;	
};
DateUtils.AreDatesEqualExact = function(date1, date2) {
    if(date1 == null && date2 == null)
        return true;
    if(date1 == null || date2 == null)
        return false;
    return date1.getTime() == date2.getTime();    
};
DateUtils.FixTimezoneGap = function(oldDate, newDate) {
    // B31219, B95404, Q148106, Q151614, B159521
	var diff = newDate.getHours() - oldDate.getHours();
	if(diff == 0)
		return;

	var sign = (diff == 1 || diff == -23) ? -1 : 1;
	var trial = new Date(newDate.getTime() + sign * 3600000);
    var isDateChangedAsExpected = newDate.getHours() - trial.getHours() === diff;
	if(isDateChangedAsExpected && (sign > 0 || trial.getDate() == newDate.getDate()))
		newDate.setTime(trial.getTime());
};
DateUtils.GetDecadeStartYear = function(year) {
    return 10 * Math.floor(year / 10);
};
DateUtils.GetCenturyStartYear = function(year) {
    return 100 * Math.floor(year / 100);
};
DateUtils.GetCorrectedYear = function(date, pickerType) {
    var year = date.getFullYear();
    return pickerType != ASPx.DatePickerType.Decades ? year : DateUtils.GetDecadeStartYear(year);
};
DateUtils.GetCorrectedMonth = function(date, pickerType) {
    return pickerType < ASPx.DatePickerType.Years ? date.getMonth() : 0;
};
DateUtils.GetCorrectedDay = function(date, pickerType) {
    return pickerType == ASPx.DatePickerType.Days ? date.getDate() : 1;
};
DateUtils.CorrectDateByPickerType = function(date, pickerType) {
    if(!ASPx.IsExists(pickerType))
        pickerType = ASPx.DatePickerType.Days;
    if(!date || pickerType == ASPx.DatePickerType.Days)
        return date;
    var correctedYear = DateUtils.GetCorrectedYear(date, pickerType);
    var result = new Date(
        correctedYear,
        DateUtils.GetCorrectedMonth(date, pickerType),
        DateUtils.GetCorrectedDay(date, pickerType),
        date.getHours(), date.getMinutes(), date.getSeconds(), date.getMilliseconds()
    );
    result.setFullYear(correctedYear);
    return result;
};
DateUtils.GetYearRangeFormatString = function(startYear, rangeLength) {
    return startYear + " - " + (startYear + rangeLength - 1);
};
ASPx.DateUtils = DateUtils;

var Timer = { };
Timer.ClearTimer = function(timerID){
    if(timerID > -1)
        window.clearTimeout(timerID);
    return -1;
};
Timer.ClearInterval = function(timerID){
    if(timerID > -1)
        window.clearInterval(timerID);
    return -1;
};
var setControlBoundTimer = function(handler, control, setTimerFunction, clearTimerFunction, delay) {
    var timerId;
    var getTimerId = function() { return timerId; };
    var controlMainElement = control.GetMainElement();
    var boundHandler = function() {
        var controlExists = control && ASPx.GetControlCollection().Get(control.name) === control && control.GetMainElement() === controlMainElement;
        if(controlExists)
            handler.aspxBind(control)();
        else {
            clearTimerFunction(getTimerId());
            controlMainElement = null;
        }
    };
    timerId = setTimerFunction(boundHandler, delay);
    return timerId;
};
Timer.SetControlBoundTimeout = function(handler, control, delay) {
    return setControlBoundTimer(handler, control, window.setTimeout, Timer.ClearTimer, delay);
};
Timer.SetControlBoundInterval = function(handler, control, delay) {
    return setControlBoundTimer(handler, control, window.setInterval, Timer.ClearInterval, delay);
};
Timer.Throttle = function(func, delay) {
    var isThrottled = false,
      savedArgs,
      savedThis = this;
    function wrapper() {
        if(isThrottled) {
            savedArgs = arguments;
            savedThis = this;
            return;
        }
        func.apply(this, arguments);
        isThrottled = true;
        setTimeout(function() {
            isThrottled = false;
            if(savedArgs) {
                wrapper.apply(savedThis, savedArgs);
                savedArgs = null;
            }
        }, delay);
    }

    wrapper.cancel = function() {
        clearTimeout(delay);
        delay = savedArgs = savedThis = null;
    };

    return wrapper;
};
ASPx.Timer = Timer;

var Browser = { };
Browser.UserAgent = navigator.userAgent.toLowerCase();
Browser.Mozilla = false;
Browser.IE = false;
Browser.Firefox = false;
Browser.Netscape = false;
Browser.Safari = false;
Browser.Chrome = false;
Browser.Opera = false;
Browser.Edge = false;
    
Browser.Version = undefined; // {major}.{1-digit minor}
Browser.MajorVersion = undefined; // {major}
    
Browser.WindowsPlatform = false;
Browser.MacOSPlatform = false;
Browser.MacOSMobilePlatform = false;
Browser.AndroidMobilePlatform = false;
Browser.PlaformMajorVersion = false;
Browser.WindowsPhonePlatform = false;

Browser.AndroidDefaultBrowser = false;
Browser.AndroidChromeBrowser = false;
Browser.SamsungAndroidDevice = false;
Browser.WebKitTouchUI = false;
Browser.MSTouchUI = false;
Browser.TouchUI = false;
    
Browser.WebKitFamily = false; // Safari, Chrome or Opera(Blink)
Browser.NetscapeFamily = false; // Mozilla, Nestcape, or Firefox
Browser.HardwareAcceleration = false;
Browser.VirtualKeyboardSupported = false;
Browser.Info = "";
Browser.IsQuirksMode = document.compatMode === "BackCompat";

function indentPlatformMajorVersion(userAgent) {
    var regex = /(?:(?:windows nt|macintosh|mac os|cpu os|cpu iphone os|android|windows phone|linux) )(\d+)(?:[-0-9_.])*/;
    var matches = regex.exec(userAgent);
    if(matches)
        Browser.PlaformMajorVersion = matches[1];
}
function getIECompatibleVersionString() {
    if(document.compatible) {
        for(var i = 0; i < document.compatible.length; i++)
            if(document.compatible[i].userAgent === "IE" && document.compatible[i].version)
                return document.compatible[i].version.toLowerCase();
    }
    return "";
}
Browser.IdentUserAgent = function(userAgent, ignoreDocumentMode) {
    var browserTypesOrderedList = [ "Mozilla", "IE", "Firefox", "Netscape", "Safari", "Chrome", "Opera", "Opera10", "Edge" ];
    var defaultBrowserType = "IE";
    var defaultPlatform = "Win";
    var defaultVersions = { Safari: 2, Chrome: 0.1, Mozilla: 1.9, Netscape: 8, Firefox: 2, Opera: 9, IE: 6, Edge: 12 };

    if(!userAgent || userAgent.length == 0) {
        fillUserAgentInfo(browserTypesOrderedList, defaultBrowserType, defaultVersions[defaultBrowserType], defaultPlatform);
        return;
    }

    userAgent = userAgent.toLowerCase();
    indentPlatformMajorVersion(userAgent);
    try {
        var platformIdentStrings = {
            "Windows": "Win",
            "Macintosh": "Mac",
            "Mac OS": "Mac",
            "Mac_PowerPC": "Mac",
            "cpu os": "MacMobile",
            "cpu iphone os": "MacMobile",
            "Android": "Android",
            "!Windows Phone": "WinPhone",
            "!WPDesktop": "WinPhone",
            "!ZuneWP": "WinPhone"
        };

        var optSlashOrSpace = "(?:/|\\s*)?";
        var version = "(\\d+)(?:\\.((?:\\d+?[1-9])|\\d)0*?)?";
        var optVersion = "(?:" + version + ")?";
        var patterns = {
            Safari: "applewebkit(?:.*?(?:version/" + version + "[\\.\\w\\d]*?(?:\\s+mobile\/\\S*)?\\s+safari))?",
            Chrome: "(?:chrome|crios)(?!frame)" + optSlashOrSpace + optVersion,
            Mozilla: "mozilla(?:.*rv:" + optVersion + ".*Gecko)?",
            Netscape: "(?:netscape|navigator)\\d*/?\\s*" + optVersion,
            Firefox: "firefox" + optSlashOrSpace + optVersion,
            Opera: "(?:opera|\sopr)" + optSlashOrSpace + optVersion,
            Opera10: "opera.*\\s*version" + optSlashOrSpace + optVersion,
            IE: "msie\\s*" + optVersion,
            Edge: "edge" + optSlashOrSpace + optVersion
        };

        var browserType;
        var version = -1;
        for(var i = 0; i < browserTypesOrderedList.length; i++) {
            var browserTypeCandidate = browserTypesOrderedList[i];

            var regExp = new RegExp(patterns[browserTypeCandidate], "i");
            if(regExp.compile)
                regExp.compile(patterns[browserTypeCandidate], "i");
            var matches = regExp.exec(userAgent);

            if(matches && matches.index >= 0) {
                if(browserType == "IE" && version >= 11 && browserTypeCandidate == "Safari") // WinPhone8.1 update
                    continue;
                browserType = browserTypeCandidate;
                if(browserType == "Opera10")
                    browserType = "Opera";
                var tridentPattern = "trident" + optSlashOrSpace + optVersion;
                version = Browser.GetBrowserVersion(userAgent, matches, tridentPattern, getIECompatibleVersionString());
                if(browserType == "Mozilla" && version >= 11)
                    browserType = "IE";
            }
        }
        
        if(!browserType)
            browserType = defaultBrowserType;
        var browserVersionDetected = version != -1;
		if(!browserVersionDetected)
            version = defaultVersions[browserType];
        
        var platform;
        var minOccurenceIndex = Number.MAX_VALUE;
        for(var identStr in platformIdentStrings) {
            if(!platformIdentStrings.hasOwnProperty(identStr)) continue;
            var importantIdent = identStr.substr(0,1) == "!";
            var occurenceIndex = userAgent.indexOf((importantIdent ? identStr.substr(1) : identStr).toLowerCase());
            if(occurenceIndex >= 0 && (occurenceIndex < minOccurenceIndex || importantIdent)) {
                minOccurenceIndex = importantIdent ? 0 : occurenceIndex;
                platform = platformIdentStrings[identStr];
            }
        }
        var samsungPattern = "SM-[A-Z]";
        var matches = userAgent.toUpperCase().match(samsungPattern);
        var isSamsungAndroidDevice = matches && matches.length > 0;
        if(platform == "WinPhone" && version < 9)
            version = Math.floor(getVersionFromTrident(userAgent, "trident" + optSlashOrSpace + optVersion));

        if(!ignoreDocumentMode && browserType == "IE" && version > 7 && document.documentMode < version)
            version = document.documentMode;
        
        if(platform == "WinPhone")
            version = Math.max(9, version);

        if(!platform)
            platform = defaultPlatform;
        if(platform == platformIdentStrings["cpu os"] && !browserVersionDetected) // Terra browser
            version = 4;

        fillUserAgentInfo(browserTypesOrderedList, browserType, version, platform, isSamsungAndroidDevice);
    } catch(e) {
        fillUserAgentInfo(browserTypesOrderedList, defaultBrowserType, defaultVersions[defaultBrowserType], defaultPlatform);
    }
};
function getVersionFromMatches(matches) {
    var result = -1;
    var versionStr = "";
    if(matches[1]) {
        versionStr += matches[1];
        if(matches[2])
            versionStr += "." + matches[2];
    }
    if(versionStr != "") {
        result = parseFloat(versionStr);
        if(isNaN(result))
            result = -1;
    }
    return result;
}
function getVersionFromTrident(userAgent, tridentPattern) {
    var tridentDiffFromVersion = 4;
    var matches = new RegExp(tridentPattern, "i").exec(userAgent);
    return getVersionFromMatches(matches) + tridentDiffFromVersion;
}
Browser.GetBrowserVersion = function(userAgent, matches, tridentPattern, ieCompatibleVersionString) {
    var version = getVersionFromMatches(matches);
    if(ieCompatibleVersionString) {
        var versionFromTrident = getVersionFromTrident(userAgent, tridentPattern);
        if(ieCompatibleVersionString === "edge" || parseInt(ieCompatibleVersionString) === versionFromTrident)
            return versionFromTrident;
    }
    return version;
};
function fillUserAgentInfo(browserTypesOrderedList, browserType, version, platform, isSamsungAndroidDevice) {
    for(var i = 0; i < browserTypesOrderedList.length; i++) {
        var type = browserTypesOrderedList[i];
        Browser[type] = type == browserType;
    }
    Browser.Version = Math.floor(10.0 * version) / 10.0;
    Browser.MajorVersion = Math.floor(Browser.Version);
    Browser.WindowsPlatform = platform == "Win" || platform == "WinPhone";
    Browser.MacOSPlatform = platform == "Mac";

    var isMacWithTouchSupport = platform == "Mac" && (!!window.ontouchstart || getMaxTouchPoints() > 0); // T828613, T854553
    Browser.MacOSMobilePlatform = platform == "MacMobile" || isMacWithTouchSupport;
    if(Browser.MacOSMobilePlatform)
        Browser.MacOSPlatform = false;

    Browser.AndroidMobilePlatform = platform == "Android";
    Browser.WindowsPhonePlatform = platform == "WinPhone";
    Browser.WebKitFamily = Browser.Safari || Browser.Chrome || Browser.Opera && Browser.MajorVersion >= 15;
    Browser.NetscapeFamily = Browser.Netscape || Browser.Mozilla || Browser.Firefox;
    Browser.HardwareAcceleration = (Browser.IE && Browser.MajorVersion >= 9) || (Browser.Firefox && Browser.MajorVersion >= 4) || 
        (Browser.AndroidMobilePlatform && Browser.Chrome) || (Browser.Chrome && Browser.MajorVersion >= 37) || 
        (Browser.Safari && !Browser.WindowsPlatform) || Browser.Edge || (Browser.Opera && Browser.MajorVersion >= 46);

    Browser.WebKitTouchUI = Browser.MacOSMobilePlatform || Browser.AndroidMobilePlatform;
    var isIETouchUI = Browser.IE && Browser.MajorVersion > 9 && Browser.WindowsPlatform && Browser.UserAgent.toLowerCase().indexOf("touch") >= 0;
    Browser.MSTouchUI = isIETouchUI || (Browser.Edge && !!getMaxTouchPoints());
    Browser.TouchUI = Browser.WebKitTouchUI || Browser.MSTouchUI;
    Browser.MobileUI = Browser.WebKitTouchUI || Browser.WindowsPhonePlatform;
    Browser.AndroidDefaultBrowser = Browser.AndroidMobilePlatform && !Browser.Chrome;
    Browser.AndroidChromeBrowser = Browser.AndroidMobilePlatform && Browser.Chrome;
    if(isSamsungAndroidDevice)
        Browser.SamsungAndroidDevice = isSamsungAndroidDevice;
    if(Browser.MSTouchUI) {
        var isARMArchitecture = Browser.UserAgent.toLowerCase().indexOf("arm;") > -1;       
        Browser.VirtualKeyboardSupported = isARMArchitecture || Browser.WindowsPhonePlatform;      
    } else {
        Browser.VirtualKeyboardSupported = Browser.MobileUI;
    }
    fillDocumentElementBrowserTypeClassNames(browserTypesOrderedList);
}
function getMaxTouchPoints() { // this method is to make our code think it is working on the touch screen device in tests.
    var result = navigator.maxTouchPoints;
    if(window.testingTouchMode)
        result = 10;
    return result;
}
function fillDocumentElementBrowserTypeClassNames(browserTypesOrderedList) {
    var documentElementClassName = "";
    var browserTypeslist = browserTypesOrderedList.concat(["WindowsPlatform", "MacOSPlatform", "MacOSMobilePlatform", "AndroidMobilePlatform",
      "WindowsPhonePlatform", "WebKitFamily", "WebKitTouchUI", "MSTouchUI", "TouchUI", "AndroidDefaultBrowser", "MobileUI"]);
    for(var i = 0; i < browserTypeslist.length; i++) {
        var type = browserTypeslist[i];
        if(Browser[type])
            documentElementClassName += "dx" + type + " ";
    }
    documentElementClassName += "dxBrowserVersion-" + Browser.MajorVersion;
    if(document && document.documentElement) {
        if(document.documentElement.className != "")
            documentElementClassName = " " + documentElementClassName;
        document.documentElement.className += documentElementClassName;
        Browser.Info = documentElementClassName;
    }
}
Browser.SupportsStickyPositioning = function() {
    return this.Chrome && this.MajorVersion >= 56
        || this.Firefox && this.MajorVersion >= 32
        || this.Safari && this.MajorVersion >= 6 && this.Version !== "6"
        || this.Opera && this.MajorVersion >= 42;
};
Browser.IdentUserAgent(Browser.UserAgent);
ASPx.Browser = Browser;

ASPx.BlankUrl = Browser.IE ? ASPx.SSLSecureBlankUrl : (Browser.Opera ? "about:blank" : "");

var Data = { };
Data.ArrayInsert = function(array, element, position){
    if(0 <= position && position < array.length){
        for(var i = array.length; i > position; i --)
            array[i] = array[i - 1];
        array[position] = element;
    }
    else
        array.push(element);
};
Data.ArrayRemove = function(array, element){
    var index = Data.ArrayIndexOf(array, element);
    if(index > -1) Data.ArrayRemoveAt(array, index);
};
Data.ArrayRemoveAt = function(array, index){
    if(index >= 0  && index < array.length){
        for(var i = index; i < array.length - 1; i++)
            array[i] = array[i + 1];
        array.pop();
    }
};
Data.ArrayClear = function(array){
    while(array.length > 0)
        array.pop();
};
Data.ArrayIndexOf = function(array, element, comparer) {
    if(!comparer) {
        for(var i = 0; i < array.length; i++) {
            if(array[i] == element)
                return i;
        }
    } else {
        for(var i = 0; i < array.length; i++) {
            if(comparer(array[i], element))
                return i;
        }
    }
    return -1;
};
Data.ArrayContains = function(array, element) {    
    return Data.ArrayIndexOf(array, element) >= 0;
};
Data.ArrayEqual = function(array1, array2) {
    var count1 = array1.length;
    var count2 = array2.length;
    if(count1 != count2)
        return false;
    for(var i = 0; i < count1; i++)
        if(array1[i] != array2[i])
            return false;
    return true;
};
Data.ArraySame = function(array1, array2) {
    if(array1.length !== array2.length)
        return false;
    return array1.every(function(elem) { return Data.ArrayContains(array2, elem); });
};
Data.ArrayGetIntegerEdgeValues = function(array) {
    var arrayToSort = Data.CollectionToArray(array);
    Data.ArrayIntegerAscendingSort(arrayToSort);
    return {
        start: arrayToSort[0],
        end: arrayToSort[arrayToSort.length - 1]
    };
};
Data.ArrayIntegerAscendingSort = function(array){
    Data.ArrayIntegerSort(array);
};
Data.ArrayIntegerSort = function(array, desc) {
    array.sort(function(i1, i2) {
        var res = 0;
        if(i1 > i2)
            res = 1;
        else if(i1 < i2)
            res = -1;
        if(desc)
            res *= -1;
        return res;
    });
};
Data.CollectionsUnionToArray = function(firstCollection, secondCollection) {
    var result = [];
    var firstCollectionLength = firstCollection.length;
    var secondCollectionLength = secondCollection.length;
    for(var i = 0; i < firstCollectionLength + secondCollectionLength; i++) {
        if(i < firstCollectionLength)
            result.push(firstCollection[i]);
        else
            result.push(secondCollection[i - firstCollectionLength]);
    }
    return result;
};
Data.CollectionToArray = function(collection) {
    var array = [];
    for(var i = 0; i < collection.length; i++)
        array.push(collection[i]);
    return array;
};
Data.CreateHashTableFromArray = function(array) {
    var hash = [];
    for(var i = 0; i < array.length; i++)
        hash[array[i]] = 1;
    return hash;
};
Data.CreateIndexHashTableFromArray = function(array) {
    var hash = [];
    for(var i = 0; i < array.length; i++)
        hash[array[i]] = i;
    return hash;
};
Data.ArrayToHash = function(array, getKeyFunc, getValueFunc) {
    if(!(array instanceof Array)) 
        return { };
    return array.reduce(function(map, element, index) { 
        var key = getKeyFunc(element, index);
        var value = getValueFunc(element, index);
        map[key] = value;
        return map; 
    }, { });
};
Data.Sum = function(array, getValueFunc) {
    if(!(array instanceof Array)) 
        return 0;
    return array.reduce(function(prevValue, item) {
        var value = getValueFunc ? getValueFunc(item) : item;
        if(!ASPx.IsNumber(value))
            value = 0;
        return prevValue + value;
    }, 0);
};
Data.Min = function(array, getValueFunc) { return CalculateArrayMinMax(array, getValueFunc, false); };
Data.Max = function(array, getValueFunc) { return CalculateArrayMinMax(array, getValueFunc, true); };

var CalculateArrayMinMax = function(array, getValueFunc, isMax) {
    if(!(array instanceof Array)) 
        return 0;
    var startValue = isMax ? Number.NEGATIVE_INFINITY : Number.POSITIVE_INFINITY;
    return array.reduce(function(prevValue, item) {
        var value = getValueFunc ? getValueFunc(item) : item;
        if(!ASPx.IsNumber(value))
            value = startValue;
        var func = isMax ? Math.max : Math.min;
        return func(value, prevValue);
    }, startValue);
};

var defaultBinarySearchComparer = function(array, index, value) {
    var arrayElement = array[index];
    if(arrayElement == value)
        return 0;
    else
        return arrayElement < value ? -1 : 1;
};
Data.NearestLeftBinarySearchComparer = function(array, index, value) { 
    var arrayElement = array[index];
    
    var leftPoint = arrayElement < value;
    var lastLeftPoint = leftPoint && index == array.length - 1;
    var nearestLeftPoint = lastLeftPoint || (leftPoint && array[index + 1] >= value);
    if(nearestLeftPoint)
        return 0;
    else
        return arrayElement < value ? -1 : 1;
};
Data.ArrayBinarySearch = function(array, value, binarySearchComparer, startIndex, length) {
    if(!binarySearchComparer)
        binarySearchComparer = defaultBinarySearchComparer;
    if(!ASPx.IsExists(startIndex))
        startIndex = 0;
    if(!ASPx.IsExists(length))
        length = array.length - startIndex;
    var endIndex = (startIndex + length) - 1;
    while(startIndex <= endIndex) {
        var middle = (startIndex + ((endIndex - startIndex) >> 1));
        var compareResult = binarySearchComparer(array, middle, value);
        if(compareResult == 0)
            return middle;
        if(compareResult < 0)
            startIndex = middle + 1;
        else
            endIndex = middle - 1;
    }
    return -(startIndex + 1);
};
Data.ArrayFlatten = function(arrayOfArrays) {
    return [].concat.apply([], arrayOfArrays);
};
Data.GetDistinctArray = function(array) {
    var resultArray = [];
    for(var i = 0; i < array.length; i++) {
        var currentEntry = array[i];
        if(Data.ArrayIndexOf(resultArray, currentEntry) == -1) {
            resultArray.push(currentEntry);
        }
    }

    return resultArray;
};
Data.ForEach = function(arr, callback) {
    if(Array.prototype.forEach) {
        Array.prototype.forEach.call(arr, callback);
    } else {
        for(var i = 0, len = arr.length; i < len; i++) {
            callback(arr[i], i, arr);
        }
    }
};
Data.MergeHashTables = function(target, object) {
    if(!object || typeof (object) == "string")
        return target;

    if(!target)
        target = {};
    for(var key in object)
        if(key && !(key in target))
            target[key] = object[key];
    return target;
};
Data.Range = function(count, start) {
    count = parseInt(count) || 0;
    start = parseInt(start) || 0;
    if(count < 0) count = 0;
    if(start < 0) start = 0;
    return Array.apply(null, Array(count)).map(function(val, i) { return start + i; });
};
ASPx.Data = Data;

var Cookie = { };
Cookie.DelCookie = function(name){
    setCookieInternal(name, "", new Date(1970, 1, 1));
};
Cookie.GetCookie = function(name) {
    name = escape(name);
    var cookies = document.cookie.split(';');
    for(var i = 0; i < cookies.length; i++) {
        var cookie = Str.Trim(cookies[i]);
        if(cookie.indexOf(name + "=") == 0)
            return unescape(cookie.substring(name.length + 1, cookie.length));
        else if(cookie.indexOf(name + ";") == 0 || cookie === name)
            return "";
    }
    return null;
};
Cookie.SetCookie = function(name, value, expirationDate){
    if(!ASPx.IsExists(value)) {
        Cookie.DelCookie(name);
        return;
    }

    if(!ASPx.Ident.IsDate(expirationDate)) {
        expirationDate = new Date();
        expirationDate.setFullYear(expirationDate.getFullYear() + 1);
    }
    setCookieInternal(name, value, expirationDate);
};
function setCookieInternal(name, value, date){
    document.cookie = escape(name) + "=" + escape(value.toString()) + "; expires=" + date.toGMTString() + "; path=/";
}
ASPx.Cookie = Cookie;

ASPx.ImageUtils = {
    GetImageSrc: function (image){
        return image.src;
    },
    SetImageSrc: function(image, src){
        if(isSourceResetRequired())
            image.src = "";
        image.src = src;
    },
    SetSize: function(image, width, height){
        image.style.width = width + "px";
        image.style.height = height + "px";
    },
    GetSize: function(image, isWidth) {
        return (isWidth ? ASPx.GetElementOffsetWidth(image) : ASPx.GetElementOffsetHeight(image));
    }
};

var Str = { };
Str.ApplyReplacement = function(text, replecementTable) {
    if(typeof(text) != "string")
        text = text.toString();
    for(var i = 0; i < replecementTable.length; i++) {
        var replacement = replecementTable[i];
        text = text.replace(replacement[0], replacement[1]);
    }
    return text;
};
Str.CompleteReplace = function(text, regexp, newSubStr) {
    if(typeof(text) != "string")
        text = text.toString();
    var textPrev;
    do {
        textPrev = text;
        text = text.replace(regexp, newSubStr);
    } while(text != textPrev);
    return text;
};

Str.EncodeHtml = function(html) {
    return Str.ApplyReplacement(html, [
        [ /&amp;/g,  '&ampx;'  ], [ /&/g, '&amp;'  ],
        [ /&quot;/g, '&quotx;' ], [ /"/g, '&quot;' ],
        [ /&lt;/g,   '&ltx;'   ], [ /</g, '&lt;'   ],
        [ /&gt;/g,   '&gtx;'   ], [ />/g, '&gt;'   ]
    ]);
};
Str.DecodeHtml = function(html) {
    return Str.ApplyReplacement(html, [
        [ /&gt;/g,   '>' ], [ /&gtx;/g,  '&gt;'   ],
        [ /&lt;/g,   '<' ], [ /&ltx;/g,  '&lt;'   ],
        [ /&quot;/g, '"' ], [ /&quotx;/g,'&quot;' ],
        [ /&amp;/g,  '&' ], [ /&ampx;/g, '&amp;'  ]
    ]);
};
Str.DecodeHtmlViaTextArea = function(html) {
    var textArea = document.createElement("TEXTAREA");
    setInnerHtmlInternal(textArea, html);
    return textArea.value;
};
Str.TrimStart = function(str) {    
    return trimInternal(str, true);
};
Str.TrimEnd = function(str) {    
    return trimInternal(str, false, true);
};
Str.Trim = function(str) {    
    return trimInternal(str, true, true);    
};
Str.EscapeForRegEx = function(str) {
    return str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&");
};
var whiteSpaces = { 
    0x0009: 1, 0x000a: 1, 0x000b: 1, 0x000c: 1, 0x000d: 1, 0x0020: 1, 0x0085: 1, 
    0x00a0: 1, 0x1680: 1, 0x180e: 1, 0x2000: 1, 0x2001: 1, 0x2002: 1, 0x2003: 1, 
    0x2004: 1, 0x2005: 1, 0x2006: 1, 0x2007: 1, 0x2008: 1, 0x2009: 1, 0x200a: 1, 
    0x200b: 1, 0x2028: 1, 0x2029: 1, 0x202f: 1, 0x205f: 1, 0x3000: 1
};
var caretWidth = 1;
function trimInternal(source, trimStart, trimEnd) {
    var len = source.length;
    if(!len)
        return source;
    var result = "";
    if(len < 0xBABA1) // B181394        
        result = trimSource(source, trimStart, trimEnd);
    else
        result = trimLargeSource(source, len, trimStart, trimEnd);
    return Str.ClearString(result);
}
function trimSource(source, trimStart, trimEnd) {
    var result = source;
    if(trimStart)
        result = result.replace(/^\s+/, "");
    if(trimEnd)
        result = result.replace(/\s+$/, "");
    return result;
}
function trimLargeSource(source, len, trimStart, trimEnd) {
    var start = 0;
    if(trimEnd) {
        while(len > 0 && whiteSpaces[source.charCodeAt(len - 1)]) {
            len--;
        }
    }
    if(trimStart && len > 0) {
        while(start < len && whiteSpaces[source.charCodeAt(start)]) {
            start++;
        }
    }
    return source.substring(start, len);
}
var inlineStringLength = 12;
Str.ClearString = function(str) { //T758068
    if(!ASPx.Browser.Chrome)
        return str;
    return str.length < inlineStringLength ? str : JSON.parse(JSON.stringify(str));
};
Str.Insert = function(str, subStr, index) {    
    var leftText = str.slice(0, index);
    var rightText = str.slice(index);
    return leftText + subStr + rightText;
};
Str.InsertEx = function(str, subStr, startIndex, endIndex) {    
    var leftText = str.slice(0, startIndex);
    var rightText = str.slice(endIndex);
    return leftText + subStr + rightText;
};
var greekSLFSigmaChar = String.fromCharCode(962);
var greekSLSigmaChar = String.fromCharCode(963);
Str.PrepareStringForFilter = function(s){
    s = s.toLowerCase();
    if(ASPx.Browser.WebKitFamily) {
        return s.replace(new RegExp(greekSLFSigmaChar, "g"), greekSLSigmaChar);
    }
    return s;
};
Str.GetCoincideCharCount = function(text, filter, textMatchingDelegate) {
    var coincideText = ASPx.Str.PrepareStringForFilter(filter);
    var originText = ASPx.Str.PrepareStringForFilter(text);
    while(coincideText != "" && !textMatchingDelegate(originText, coincideText)) {
        coincideText = coincideText.slice(0, -1);
    }
    return coincideText.length;
};
Str.EndsWith = function(str, suffix) {
    return str.indexOf(suffix, str.length - suffix.length) !== -1;
};
ASPx.Str = Str;

var Xml = { };
Xml.Parse = function(xmlStr) {
    if(window.DOMParser) {
        var parser = new DOMParser();
        return parser.parseFromString(xmlStr, "text/xml");
    }
    else if(window.ActiveXObject) {
        var xmlDoc = new window.ActiveXObject("Microsoft.XMLDOM");
        if(xmlDoc) {
            xmlDoc.async = false;
            xmlDoc.loadXML(xmlStr);
            return xmlDoc;
        }
    }
    return null;
};
ASPx.Xml = Xml;

ASPx.Key = {
    F1           : 112,
    F2           : 113,
    F3           : 114,
    F4           : 115,
    F5           : 116,
    F6           : 117,
    F7           : 118,
    F8           : 119,
    F9           : 120,
    F10          : 121,
    F11          : 122,
    F12          : 123,
    Ctrl         : 17,
    Shift        : 16,
    Alt          : 18,
    Enter        : 13,
    Home         : 36,
    End          : 35,
    Left         : 37,
    Right        : 39,
    Up           : 38,
    Down         : 40,
    PageUp       : 33,
    PageDown     : 34,
    Esc          : 27,
    Space        : 32,
    Tab          : 9,
    Backspace    : 8,
    Delete       : 46,
    Insert       : 45,
    ContextMenu  : 93,
    Windows      : 91,
    Decimal      : 110,
    CapsLock     : 20
};

ASPx.ModifierKey = {
    None: 0,
    Ctrl: 1 << (0 + 16),
    Shift: 1 << (2 + 16),
    Alt: 1 << (4 + 16),
    Meta: 1 << (8 + 16)
};

ASPx.KeyCode = {
    Backspace    : 8,
    Tab          : 9,
    Enter        : 13,
    Pause        : 19,
    CapsLock     : 20,
    Esc          : 27,
    Space        : 32,
    PageUp       : 33,
    PageDown     : 34,
    End          : 35,
    Home         : 36,
    Left         : 37,
    Up           : 38,
    Right        : 39,
    Down         : 40,
    Insert       : 45,
    Delete       : 46,
    Key_0        : 48,
    Key_1        : 49,
    Key_2        : 50,
    Key_3        : 51,
    Key_4        : 52,
    Key_5        : 53,
    Key_6        : 54,
    Key_7        : 55,
    Key_8        : 56,
    Key_9        : 57,
    Key_a        : 65,
    Key_b        : 66,
    Key_c        : 67,
    Key_d        : 68,
    Key_e        : 69,
    Key_f        : 70,
    Key_g        : 71,
    Key_h        : 72,
    Key_i        : 73,
    Key_j        : 74,
    Key_k        : 75,
    Key_l        : 76,
    Key_m        : 77,
    Key_n        : 78,
    Key_o        : 79,
    Key_p        : 80,
    Key_q        : 81,
    Key_r        : 82,
    Key_s        : 83,
    Key_t        : 84,
    Key_u        : 85,
    Key_v        : 86,
    Key_w        : 87,
    Key_x        : 88,
    Key_y        : 89,
    Key_z        : 90,
    Windows      : 91,
    ContextMenu  : 93,
    Numpad_0     : 96,
    Numpad_1     : 97,
    Numpad_2     : 98,
    Numpad_3     : 99,
    Numpad_4     : 100,
    Numpad_5     : 101,
    Numpad_6     : 102,
    Numpad_7     : 103,
    Numpad_8     : 104,
    Numpad_9     : 105,
    Multiply     : 106,
    Add          : 107,
    Subtract     : 109,
    Decimal      : 110,
    Divide       : 111,
    F1           : 112,
    F2           : 113,
    F3           : 114,
    F4           : 115,
    F5           : 116,
    F6           : 117,
    F7           : 118,
    F8           : 119,
    F9           : 120,
    F10          : 121,
    F11          : 122,
    F12          : 123,
    NumLock      : 144,
    ScrollLock   : 145,
    Semicolon    : 186,
    Equals       : 187,
    Comma        : 188,
    Dash         : 189,
    Period       : 190,
    ForwardSlash : 191,
    GraveAccent  : 192,
    OpenBracket  : 219,
    BackSlash    : 220,
    CloseBracket : 221,
    SingleQuote  : 222
};

ASPx.ScrollBarMode = { Hidden: 0, Visible: 1, Auto: 2 };
ASPx.ColumnResizeMode = { None: 0, Control: 1, NextColumn: 2 };

var Selection = { };
Selection.Set = function(input, startPos, endPos, scrollToSelection, isApi) {
    if(!ASPx.IsExistsElement(input))
        return;
    var isInputFocused = ASPx.GetActiveElement() === input;
    var isInputNativeFocusLocked = ASPx.VirtualKeyboardUI.getInputNativeFocusLocked();
    if(!isApi && Browser.VirtualKeyboardSupported && (!isInputFocused || isInputNativeFocusLocked))
        return;

    var textLen = input.value.length;

    startPos = ASPx.GetDefinedValue(startPos, 0);
    endPos = ASPx.GetDefinedValue(endPos, textLen);

    if(startPos < 0)
        startPos = 0;

    if(endPos < 0 || endPos > textLen)
        endPos = textLen;

    if(startPos > endPos)
        startPos = endPos;

    var makeReadOnly = false;
    if(Browser.WebKitFamily && input.readOnly) {
        input.readOnly = false;
        makeReadOnly = true;
    }
    
    try {
        if(Browser.Firefox && Browser.Version >= 8) 
            input.setSelectionRange(startPos, endPos, "backward");
        else if(Browser.IE && input.createTextRange) {
            var range = input.createTextRange();
            range.collapse(true);
            range.moveStart("character", startPos);
            range.moveEnd("character", endPos - startPos);
            range.select();
        } else {
            forceScrollToSelectionRange(input, startPos, endPos);
            input.setSelectionRange(startPos, endPos);
        }
        if(Browser.Opera || Browser.Firefox || Browser.Chrome || Browser.Edge) // B188482
            input.focus();
    } catch(e) { }

    if(scrollToSelection && input.tagName == 'TEXTAREA') {
        var scrollHeight = input.scrollHeight;
        var approxCaretPos = startPos;
        var scrollTop = Math.max(Math.round(approxCaretPos * scrollHeight / textLen  - input.clientHeight / 2), 0);
        input.scrollTop = scrollTop;
    }

    if(makeReadOnly)
        input.readOnly = true;
};
var getTextWidthBeforePos = function(input, pos) {
    return ASPx.GetSizeOfText(input.value.toString().substr(0, pos), ASPx.GetCurrentStyle(input)).width;
};
var forceScrollToSelectionRange = function(input, startPos, endPos) {
    if(endPos === input.value.length)
        input.scrollLeft = input.scrollWidth;
    else if(startPos === 0 && endPos === 0)
        input.scrollLeft = 0;
    else {
        var inputRawWidth = ASPx.GetElementOffsetWidth(input) - ASPx.GetLeftRightBordersAndPaddingsSummaryValue(input);
        if(inputRawWidth < input.scrollWidth) {
            var widthBeforeEndPos = getTextWidthBeforePos(input, endPos) + caretWidth;
            if(input.scrollLeft < widthBeforeEndPos - inputRawWidth)
                input.scrollLeft = widthBeforeEndPos - inputRawWidth;
            else {
                var widthBeforeStartPos = getTextWidthBeforePos(input, startPos) - caretWidth;
                if(input.scrollLeft > widthBeforeStartPos)
                    input.scrollLeft = widthBeforeStartPos;
            }
        }
    }
};

Selection.GetInfo = function(input) {
    var start, end;
    if(Browser.IE && Browser.Version < 9) {
        var range = document.selection.createRange();
        var rangeCopy = range.duplicate();
        range.move('character', -input.value.length);
        range.setEndPoint('EndToStart', rangeCopy);
        start = range.text.length;
        end = start + rangeCopy.text.length;
    } else {
        try {
            start = input.selectionStart;
            end = input.selectionEnd;
        } catch (e) {
        }
    }
    return { startPos: start, endPos: end };
};
Selection.GetExtInfo = function(input) {
    var start = 0, end = 0, textLen = 0;

    if(Browser.IE && Browser.Version < 9) {
        var normalizedValue;
        var range, textInputRange, textInputEndRange;

        range = document.selection.createRange();
        if(range && range.parentElement() == input) {
            textLen = input.value.length;
            normalizedValue = input.value.replace(/\r\n/g, "\n");

            textInputRange = input.createTextRange();
            textInputRange.moveToBookmark(range.getBookmark());

            textInputEndRange = input.createTextRange();
            textInputEndRange.collapse(false);

            if(textInputRange.compareEndPoints("StartToEnd", textInputEndRange) > -1) {
                start = textLen;
                end = textLen;
            } else {
                start = normalizedValue.slice(0, start).split("\n").length - textInputRange.moveStart("character", -textLen) -1;
                if(textInputRange.compareEndPoints("EndToEnd", textInputEndRange) > -1)
                    end = textLen;
                else
                    end = normalizedValue.slice(0, end).split("\n").length - textInputRange.moveEnd("character", -textLen) - 1;                
            }
        }
        return {startPos: start, endPos: end};
    }
    try {
        start = input.selectionStart;
        end = input.selectionEnd;
    } catch (e) {
    }
    return {startPos: start, endPos: end};    
};
Selection.SetCaretPosition = function(input, caretPos) {
    if(typeof caretPos === "undefined" || caretPos < 0)
        caretPos = input.value.length;
    Selection.Set(input, caretPos, caretPos, true);
};
Selection.GetCaretPosition = function(element, isDialogMode) {
    var pos = 0;

    if("selectionStart" in element) {
        pos = element.selectionStart;
    } else if("selection" in document) {
        element.focus();
        var sel = document.selection.createRange(),
            selLength = document.selection.createRange().text.length;

        sel.moveStart("character", -element.value.length);
        pos = sel.text.length - selLength;
    }

    if(isDialogMode && !pos) {
        pos = element.value.length - 1;
    }

    return pos;
};
Selection.Clear = function() {
    try {
        if(window.getSelection) {
            window.getSelection().removeAllRanges();
        }
        else if(document.selection) {
            if(document.selection.empty)
                document.selection.empty();
            else if(document.selection.clear)
                document.selection.clear();
        }
    } catch(e) {

    }
};
Selection.ClearOnMouseMove = function(evt) {
    if(!Browser.IE || (evt.button != 0)) 
        Selection.Clear();
};
Selection.SetElementSelectionEnabled = function(element, value) {
    var userSelectValue = value ? "" : "none";
    var func = value ? Evt.DetachEventFromElement : Evt.AttachEventToElement;
    if(Browser.Firefox)
        element.style.MozUserSelect = userSelectValue;
    else if(Browser.WebKitFamily)
        element.style.webkitUserSelect = userSelectValue;
    else if(Browser.IE && Browser.Version > 10 || Browser.Edge)
        element.style.msUserSelect = userSelectValue;
    else if(Browser.Opera)
        func(element, "mousemove", Selection.Clear);
    else {
        func(element, "selectstart", ASPx.FalseFunction);
        func(element, "mousemove", Selection.Clear);
    }
};
Selection.SetElementAsUnselectable = function(element, isWithChild, recursive) {
    if(element && element.nodeType == 1) {
        element.unselectable = "on";
        if(Browser.NetscapeFamily)
            element.onmousedown = ASPx.FalseFunction;
        if((Browser.IE && Browser.Version >= 9) || Browser.WebKitFamily)
            Evt.AttachEventToElement(element, "mousedown", Evt.PreventEventAndBubble);
        if(isWithChild === true){
            for(var j = 0; j < element.childNodes.length; j ++)
                Selection.SetElementAsUnselectable(element.childNodes[j], (!!recursive ? true : false), (!!recursive));
        }
    }
};
Selection.AreEqual = function(selection1, selection2) {
    return selection1.startPos === selection2.startPos && selection1.endPos === selection2.endPos;
};
ASPx.Selection = Selection;

var MouseScroller = { };
MouseScroller.MinimumOffset = 10;
MouseScroller.Create = function(getElement, getScrollXElement, getScrollYElement, needPreventScrolling, vertRecursive, onMouseDown, onMouseMove, onMouseUp, onMouseUpMissed) {
    var element = getElement();
    if(!element) 
        return;
    if(!element.dxMouseScroller)
        element.dxMouseScroller = new MouseScroller.Extender(getElement, getScrollXElement, getScrollYElement, needPreventScrolling, vertRecursive, onMouseDown, onMouseMove, onMouseUp, onMouseUpMissed);
    return element.dxMouseScroller;
};
MouseScroller.Extender = function(getElement, getScrollXElement, getScrollYElement, needPreventScrolling, vertRecursive, onMouseDown, onMouseMove, onMouseUp, onMouseUpMissed) {
    this.getElement = getElement;
    this.getScrollXElement = getScrollXElement;
    this.getScrollYElement = getScrollYElement;
    this.needPreventScrolling = needPreventScrolling;
    this.vertRecursive = !!vertRecursive;

    this.createHandlers(onMouseDown || function() { }, onMouseMove || function() { }, onMouseUp || function() { }, onMouseUpMissed || function() { });
    this.update();
};
MouseScroller.Extender.prototype = {
    update: function() {
        if(this.element)
            Evt.DetachEventFromElement(this.element, ASPx.TouchUIHelper.touchMouseDownEventName, this.mouseDownHandler);

        this.element = this.getElement();
        Evt.AttachEventToElement(this.element, ASPx.TouchUIHelper.touchMouseDownEventName, this.mouseDownHandler);        
        Evt.AttachEventToElement(this.element, "click", this.mouseClickHandler);   
        if(Browser.MSTouchUI && this.element.className.indexOf(ASPx.TouchUIHelper.msTouchDraggableClassName) < 0)
            this.element.className += " " + ASPx.TouchUIHelper.msTouchDraggableClassName;

        this.scrollXElement = this.getScrollXElement();
        this.scrollYElement = this.getScrollYElement();
    },
    createHandlers: function(onMouseDown, onMouseMove, onMouseUp, onMouseUpMissed) {
        var mouseDownCounter = 0;
        this.onMouseDown = onMouseDown;
        this.onMouseMove = onMouseMove;
        this.onMouseUp = onMouseUp;        
        this.mouseDownHandler = function(e) {
            if(mouseDownCounter++ > 0) {
                this.finishScrolling();
                onMouseUpMissed();
            }
            var eventSource = Evt.GetEventSource(e);
            var requirePreventCustonScroll = ASPx.IsExists(ASPx.TouchUIHelper.RequirePreventCustomScroll) && ASPx.TouchUIHelper.RequirePreventCustomScroll(eventSource, this.element);
            this.requirePreventScroll = requirePreventCustonScroll || this.needPreventScrolling && this.needPreventScrolling(eventSource);
            if(this.requirePreventScroll)
                return;
            this.scrollableTreeLine = this.GetScrollableElements();
            this.firstX = this.prevX = Evt.GetEventX(e);
            this.firstY = this.prevY = Evt.GetEventY(e);
            Evt.AttachEventToDocument(ASPx.TouchUIHelper.touchMouseMoveEventName, this.mouseMoveHandler);
            Evt.AttachEventToDocument(ASPx.TouchUIHelper.touchMouseUpEventName, this.mouseUpHandler);
            this.onMouseDown(e);
        }.aspxBind(this);
        this.mouseMoveHandler = function(e) {
            if(ASPx.TouchUIHelper.isGesture)
                return;
            var x = Evt.GetEventX(e);
            var y = Evt.GetEventY(e);
            var xDiff = this.prevX - x;
            var yDiff = this.prevY - y;
            if(this.vertRecursive) {
                var isTopDirection = yDiff < 0;
                this.scrollYElement = this.GetElementForVertScrolling(isTopDirection, this.prevIsTopDirection, this.scrollYElement);
                this.prevIsTopDirection = isTopDirection;
            }
            if(this.scrollXElement && xDiff != 0)
                this.scrollXElement.scrollLeft += xDiff;
            if(this.scrollYElement && yDiff != 0) {
                this.scrollYElement.scrollTop += yDiff;
                var isOuterScrollableElement = this.scrollableTreeLine[this.scrollableTreeLine.length - 1] == this.scrollYElement;
                if(isOuterScrollableElement)
                    y += yDiff;
            }

            this.prevX = x;
            this.prevY = y;
            Evt.PreventEvent(e);

            this.onMouseMove(e);
        }.aspxBind(this);
        this.mouseUpHandler = function(e) {
            this.finishScrolling();
            this.onMouseUp(e);
        }.aspxBind(this);
        this.mouseClickHandler = function(e){
            if(this.requirePreventScroll || (ASPx.IsExists(e.isTrusted) && !e.isTrusted))
                return;
            var xDiff = this.firstX - Evt.GetEventX(e);
            var yDiff = this.firstY - Evt.GetEventY(e);
            if(xDiff > MouseScroller.MinimumOffset || yDiff > MouseScroller.MinimumOffset)
                return Evt.PreventEventAndBubble(e);
        }.aspxBind(this);

        this.finishScrolling = function() {
            Evt.DetachEventFromDocument(ASPx.TouchUIHelper.touchMouseMoveEventName, this.mouseMoveHandler);
            Evt.DetachEventFromDocument(ASPx.TouchUIHelper.touchMouseUpEventName, this.mouseUpHandler);
            this.scrollableTreeLine = [];
            this.prevIsTopDirection = null;
            mouseDownCounter--;
        };
    },
    GetScrollableElements: function() {
        if(!this.vertRecursive) return [ ];
        var isHtmlScrollableElement = !ASPx.Browser.IsQuirksMode && !ASPx.Browser.Safari;
        var outerScrollableElementTag = isHtmlScrollableElement ? "HTML" : "BODY";
        return ASPx.GetElementTreeLine(this.element, null, function(el) { return el == document; })
            .filter(function(el) {
                var tagName = el.tagName;
                if(isHtmlScrollableElement && tagName == "BODY")
                    return false;
                return ASPx.IsScrollableElement(el, false, true) || tagName == outerScrollableElementTag || el.dxScrollable;
            }.bind(this));
    },
    GetElementForVertScrolling: function(currentIsTop, prevIsTop, prevElement) {
        if(prevElement && currentIsTop === prevIsTop && this.GetVertScrollExcess(prevElement, currentIsTop) > 0)
            return prevElement;
        for(var i = 0; i < this.scrollableTreeLine.length; i++) {
            var element = this.scrollableTreeLine[i];
            var excess = this.GetVertScrollExcess(element, currentIsTop);
            if(excess > 0)
                return element;
        }
        return null;
    },
    GetVertScrollExcess: function(element, isTop) {
        if(isTop)
            return element.scrollTop;
        var isDocument = element.tagName == "HTML" || ASPx.Browser.Safari && !ASPx.Browser.IsQuirksMode && element.tagName == "BODY";
        var clientHeight = isDocument ? ASPx.GetDocumentClientHeight() : element.clientHeight;
        return element.scrollHeight - clientHeight - element.scrollTop;
    }
};
ASPx.MouseScroller = MouseScroller;

var Evt = { };
Evt.GetEvent = function(evt){
    return (typeof(event) != "undefined" && event != null && Browser.IE) ? event : evt; 
};
Evt.IsEventPrevented = function(evt) {
    return evt.defaultPrevented || evt.returnValue === false;
};
Evt.PreventEvent = function(evt){
    if(evt.preventDefault) {
        if(evt.cancelable)
            evt.preventDefault();
    }
    else
        evt.returnValue = false;
    return false;
};
Evt.PreventEventAndBubble = function(evt){
    Evt.PreventEvent(evt);
    if(evt.stopPropagation)
        evt.stopPropagation();
    evt.cancelBubble = true;
    return false;
};
Evt.CancelBubble = function(evt){
    evt.stopPropagation();
    return false;
};

Evt.PreventImageDragging = function(image) {
    if(image)
        image.ondragstart = function() { return false; };
};
Evt.PreventDragStart = function(evt) {
    evt = Evt.GetEvent(evt);
    var element = Evt.GetEventSource(evt);
    if(element.releaseCapture)
        element.releaseCapture(); 
    return false;
};
Evt.PreventElementDrag = function(element) {
    if(Browser.IE)
        Evt.AttachEventToElement(element, "dragstart", Evt.PreventEvent);
    else
        Evt.AttachEventToElement(element, "mousedown", Evt.PreventEvent);
};
Evt.PreventElementDragAndSelect = function(element, skipMouseMove, skipIESelect){
    if(Browser.WebKitFamily)
        Evt.AttachEventToElement(element, "selectstart", Evt.PreventEventAndBubble);
    if(Browser.IE){
        if(!skipIESelect)
            Evt.AttachEventToElement(element, "selectstart", ASPx.FalseFunction);
        if(!skipMouseMove)
            Evt.AttachEventToElement(element, "mousemove", Selection.ClearOnMouseMove);
        Evt.AttachEventToElement(element, "dragstart", Evt.PreventDragStart);
    }
};
Evt.GetEventSource = function(evt){
    if(!ASPx.IsExists(evt)) return null; 
    return evt.srcElement ? evt.srcElement : evt.target;
};
Evt.GetKeyCode = function(srcEvt) {
    return Browser.NetscapeFamily || Browser.Opera ? srcEvt.which : srcEvt.keyCode;
};
function clientEventRequiresDocScrollCorrection() {
    var isSafariVerLess3 = Browser.Safari && Browser.Version < 3,
        isMacOSMobileVerLess51 = Browser.MacOSMobilePlatform && Browser.Version < 5.1;

    return Browser.AndroidDefaultBrowser || Browser.AndroidChromeBrowser || !(isSafariVerLess3 || isMacOSMobileVerLess51);
}
Evt.GetEventX = function(evt){
    if(ASPx.TouchUIHelper.isTouchEvent(evt))
        return ASPx.TouchUIHelper.getEventX(evt);
    return evt.clientX + (clientEventRequiresDocScrollCorrection() ? ASPx.GetDocumentScrollLeft() : 0);
};
Evt.GetEventY = function(evt){
    if(ASPx.TouchUIHelper.isTouchEvent(evt))
        return ASPx.TouchUIHelper.getEventY(evt);
    return evt.clientY + (clientEventRequiresDocScrollCorrection() ? ASPx.GetDocumentScrollTop() : 0 );
};
Evt.IsLeftButtonPressed = function(evt) {
    if(ASPx.TouchUIHelper.isTouchEvent(evt))
        return true;

    evt = Evt.GetEvent(evt);
    if(!evt) return false;
    if(Browser.IE && Browser.Version < 11) {
        if(Browser.MSTouchUI)
            return true;
        return evt.button % 2 == 1; // B213431
    } else if(Browser.WebKitFamily) {
        if(evt.type === "pointermove")
            return evt.buttons === 1;
        return evt.which == 1;
    } else if(Browser.NetscapeFamily || Browser.Edge || (Browser.IE && Browser.Version >= 11)) {
        if(evt.type === ASPx.TouchUIHelper.touchMouseMoveEventName)
            return evt.buttons === 1;
        return evt.which == 1;
    } else if(Browser.Opera)
        return evt.button == 0;

    return true;
};
Evt.IsRightButtonPressed = function(evt){
    evt = Evt.GetEvent(evt);
    if(!ASPx.IsExists(evt)) return false;
    if(Browser.IE || Browser.Edge) {
        if(evt.type === "pointermove")
            return evt.buttons === 2;
        return evt.button == 2;
    }
    else if(Browser.NetscapeFamily || Browser.WebKitFamily)
        return evt.which == 3;
    else if (Browser.Opera)
        return evt.button == 1;
    return true;
};
Evt.GetWheelDelta = function(evt) {
    var ret;
    if(Browser.NetscapeFamily && Browser.MajorVersion < 17)
        ret = -evt.detail;
    else if(Browser.Safari)
        ret = evt.wheelDelta;
    else
        ret = -evt.deltaY;
    if(Browser.Opera && Browser.Version < 9)
        ret = -ret;
    return ret;
};
Evt.IsWheelEventWithDirection = function(evt) {
    return ASPx.Data.ArrayContains(["wheel", "mousewheel"], evt.type);
};
Evt.GetWheelDeltaX = function(evt) {
    if(evt.type === "wheel")
        return -evt.deltaX;
    if(evt.type === "mousewheel")
        return evt.wheelDeltaX;
};
Evt.GetWheelDeltaY = function(evt) {
    if(evt.type === "wheel")
        return -evt.deltaY;
    if(evt.type === "mousewheel")
        return evt.wheelDeltaY;
};

Evt.IsPassiveListenersSupported = function() {
    if(Browser.Chrome && Browser.MajorVersion > 69 || Browser.Edge && Browser.MajorVersion > 15 || Browser.Firefox && Browser.MajorVersion > 62)
        return true;
    if(Evt.isPassiveListenersSupported === undefined) {
        Evt.isPassiveListenersSupported = false;
        try {
            var options = Object.defineProperty({}, "passive", { get: function() { Evt.isPassiveListenersSupported = true; } });
            window.addEventListener("test", options, options);
            window.removeEventListener("test", options, options);
        }
        catch(err) { Evt.isPassiveListenersSupported = false; }
    }
    return !!Evt.isPassiveListenersSupported;
};
Evt.AttachEventToElement = function(element, eventName, func, onlyBubbling, passive) {
    if(element.addEventListener)
        element.addEventListener(eventName, func, Evt.IsPassiveListenersSupported() ? { capture: !onlyBubbling, passive: !!passive } : !onlyBubbling);
    else
        element.attachEvent("on" + eventName, func);
};
Evt.DetachEventFromElement = function(element, eventName, func, onlyBubbling) {
    if(element.removeEventListener)
        element.removeEventListener(eventName, func, Evt.IsPassiveListenersSupported() ? { capture: !onlyBubbling } : !onlyBubbling);
    else
        element.detachEvent("on" + eventName, func);
};
Evt.AttachEventToDocument = function(eventName, func) {
    var attachingAllowed = ASPx.TouchUIHelper.onEventAttachingToDocument(eventName, func);
    if(attachingAllowed)
        Evt.AttachEventToDocumentCore(eventName, func);
};
Evt.AttachEventToDocumentCore = function(eventName, func) {
    Evt.AttachEventToElement(document, eventName, func);
};
Evt.DetachEventFromDocument = function(eventName, func) {
    Evt.DetachEventFromDocumentCore(eventName, func);
    ASPx.TouchUIHelper.onEventDettachedFromDocument(eventName, func);
};
Evt.DetachEventFromDocumentCore = function(eventName, func){
    Evt.DetachEventFromElement(document, eventName, func);
};
Evt.GetMouseWheelEventName = function() {
    if(Browser.Safari)
        return "mousewheel";
    if(Browser.NetscapeFamily && Browser.MajorVersion < 17)
        return "DOMMouseScroll";
    return "wheel";
};
Evt.AttachMouseEnterToElement = function (element, onMouseOverHandler, onMouseOutHandler) {
    Evt.AttachEventToElement(element, ASPx.TouchUIHelper.pointerEnabled ? ASPx.TouchUIHelper.pointerOverEventName : "mouseover", function (evt) { mouseEnterHandler(evt, element, onMouseOverHandler, onMouseOutHandler); });
    Evt.AttachEventToElement(element, ASPx.TouchUIHelper.pointerEnabled ? ASPx.TouchUIHelper.pointerOutEventName : "mouseout", function (evt) { mouseEnterHandler(evt, element, onMouseOverHandler, onMouseOutHandler); });
};
Evt.GetEventRelatedTarget = function(evt, isMouseOverEvent) {
    return evt.relatedTarget || (isMouseOverEvent ? evt.srcElement : evt.toElement);
};
function mouseEnterHandler(evt, element, onMouseOverHandler, onMouseOutHandler) {
    var isMouseOverExecuted = !!element.dxMouseOverExecuted;
    var isMouseOverEvent = (evt.type == "mouseover" || evt.type == ASPx.TouchUIHelper.pointerOverEventName);
    if(isMouseOverEvent && isMouseOverExecuted || !isMouseOverEvent && !isMouseOverExecuted)
        return;
    var source = Evt.GetEventRelatedTarget(evt, isMouseOverEvent);
    if(!ASPx.GetIsParent(element, source)) {
        element.dxMouseOverExecuted = isMouseOverEvent;
        if(isMouseOverEvent)
            onMouseOverHandler(element);
        else
            onMouseOutHandler(element);
    }
    else if(isMouseOverEvent && !isMouseOverExecuted) {
        element.dxMouseOverExecuted = true;
        onMouseOverHandler(element);
    }
}
Evt.DispatchEvent = function(target, eventName, canBubble, cancellable) {
    var event;

    if(Browser.IE && Browser.Version < 9) {
        eventName = "on" + eventName;

        if(eventName in target) {
            event = document.createEventObject();
            target.fireEvent("on" + eventName, event);
        }
    } else {
        event = document.createEvent("Event");
        event.initEvent(eventName, canBubble || false, cancellable || false);
        target.dispatchEvent(event);
    }
};
// Method doesn't work in WebKit browsers
Evt.EmulateDocumentOnMouseDown = function(evt) {
    Evt.EmulateOnMouseDown(document, evt);
};
Evt.EmulateOnMouseDown = function(element, evt) {
    if(Browser.IE && Browser.Version < 9)
        element.fireEvent("onmousedown", evt);
    else if(!Browser.WebKitFamily){
        var emulatedEvt = document.createEvent("MouseEvents");
        emulatedEvt.initMouseEvent("mousedown", true, true, window, 0, evt.screenX, evt.screenY, 
            evt.clientX, evt.clientY, evt.ctrlKey, evt.altKey, evt.shiftKey, false, 0, null);
        element.dispatchEvent(emulatedEvt);
    }
};
Evt.EmulateOnMouseEvent = function (type, element, evt) {
    evt.type = type;
    var emulatedEvt = document.createEvent("MouseEvents");
    emulatedEvt.initMouseEvent(type, true, true, window, 0, evt.screenX, evt.screenY,
        evt.clientX, evt.clientY, evt.ctrlKey, evt.altKey, evt.shiftKey, false, 0, null);
    emulatedEvt.target = element;
    element.dispatchEvent(emulatedEvt);
};
Evt.EmulateMouseClick = function (element, evt) {
    var x = ASPx.GetElementOffsetWidth(element) / 2;
    var y = ASPx.GetElementOffsetHeight(element) / 2;
    if (!evt)
        evt = {
            bubbles: true,
            cancelable: true,
            view: window,
            detail: 1,
            screenX: 0,
            screenY: 0,
            clientX: x,
            clientY: y,
            ctrlKey: false,
            altKey: false,
            shiftKey: false,
            metaKey: false,
            button: 0,
            relatedTarget: null
        };
    Evt.EmulateOnMouseEvent("mousedown", element, evt);
    Evt.EmulateOnMouseEvent("mouseup", element, evt);
    Evt.EmulateOnMouseEvent("click", element, evt);
};
Evt.DoElementClick = function(element) {
    try{
        element.click();
    }
    catch(e){ // B153651
    }
};
Evt.IsActionKeyPressed = function(evt) {
    return evt.keyCode === ASPx.Key.Space ||
           evt.keyCode === ASPx.Key.Enter ||
          (evt.keyCode === ASPx.Key.Down && evt.altKey);
};
Evt.InvokeMouseClickByKeyDown = function(evt, handler) {
    if(Evt.IsActionKeyPressed(evt)) {
        ASPx.Evt.PreventEvent(evt);	
		if(!handler)
            ASPx.Evt.GetEventSource(evt).onclick();
        else
            handler(evt);
    }
};

Evt.AttachContextMenuToElement = function (element, handler, onlyBubbling) {
    if (ASPx.TouchUIHelper.useLongTapHelper())
        element.detachContextMenuEventHandler = ASPx.TouchUIHelper.attachLongTapHandler(element, handler, onlyBubbling);
    else
        Evt.AttachEventToElement(element, "contextmenu", handler, onlyBubbling);
};
Evt.DetachContextMenuFromElement = function (element, handler) {
    if (element.detachContextMenuEventHandler)
        element.detachContextMenuEventHandler();
    else
        Evt.DetachEventFromElement(element, "contextmenu", handler);
};
Evt.PreventContextMenuOnElement = function(element) {
    Evt.AttachContextMenuToElement(element, function(evt) {
        Evt.PreventEvent(evt);
    });
};
ASPx.Evt = Evt;

var Attr = { };

Attr.GetAttribute = function(obj, attrName){
    if(obj.getAttribute)
        return obj.getAttribute(attrName);
    else if(obj.getPropertyValue) {
        if(Browser.Firefox) { //T644613
            try {
                return obj.getPropertyValue(attrName);
            } catch(e) {
                return obj[attrName];
            }
        }
        return obj.getPropertyValue(attrName);
    }
    return null;
};
Attr.SetAttribute = function(obj, attrName, value){
    if(obj.setAttribute) {
        if(isSourceResetRequired() && attrName.toLowerCase() === "src") // T481593
            obj.setAttribute(attrName, "");
        obj.setAttribute(attrName, value);
    } else if(obj.setProperty)
        obj.setProperty(attrName, value, "");
};
Attr.ToggleAttribute = function(obj, attrName, value, condition) {
    if(condition)
        Attr.SetAttribute(obj, attrName, value);
    else
        Attr.RemoveAttribute(obj, attrName);
};
Attr.RemoveAttribute = function(obj, attrName){
    if(obj.removeAttribute)
        obj.removeAttribute(attrName);
    else if(obj.removeProperty)
        obj.removeProperty(attrName);
};
Attr.IsExistsAttribute = function(obj, attrName){
    var value = Attr.GetAttribute(obj, attrName);
    return (value != null) && (value !== "");
};
Attr.SetOrRemoveAttribute = function(obj, attrName, value) {
    if(!value)
        Attr.RemoveAttribute(obj, attrName);
    else
        Attr.SetAttribute(obj, attrName, value);
};
Attr.SaveAttribute = function(obj, attrName, savedObj, savedAttrName){
    if(!Attr.IsExistsAttribute(savedObj, savedAttrName)){
        var oldValue = Attr.IsExistsAttribute(obj, attrName) ? Attr.GetAttribute(obj, attrName) : ASPx.EmptyObject;
        Attr.SetAttribute(savedObj, savedAttrName, oldValue);
    }
};
Attr.SaveStyleAttribute = function(obj, attrName){
    Attr.SaveAttribute(obj.style, attrName, obj, "saved" + attrName);
};
Attr.ChangeAttributeExtended = function(obj, attrName, savedObj, savedAttrName, newValue){
    Attr.SaveAttribute(obj, attrName, savedObj, savedAttrName);
    Attr.SetAttribute(obj, attrName, newValue);
};
Attr.ChangeAttribute = function(obj, attrName, newValue){
    Attr.ChangeAttributeExtended(obj, attrName, obj, "saved" + attrName, newValue);
};
Attr.ChangeStyleAttribute = function(obj, attrName, newValue){
    Attr.ChangeAttributeExtended(obj.style, attrName, obj, "saved" + attrName, newValue);
};
Attr.ResetAttributeExtended = function(obj, attrName, savedObj, savedAttrName){
    Attr.SaveAttribute(obj, attrName, savedObj, savedAttrName);
    Attr.SetAttribute(obj, attrName, "");
    Attr.RemoveAttribute(obj, attrName);
};
Attr.ResetAttribute = function(obj, attrName){
    Attr.ResetAttributeExtended(obj, attrName, obj, "saved" + attrName);
};
Attr.ResetStyleAttribute = function(obj, attrName){
    Attr.ResetAttributeExtended(obj.style, attrName, obj, "saved" + attrName);
};
Attr.RestoreAttributeExtended = function(obj, attrName, savedObj, savedAttrName){
    if(Attr.IsExistsAttribute(savedObj, savedAttrName)){
        var oldValue = Attr.GetAttribute(savedObj, savedAttrName);
        if(oldValue != ASPx.EmptyObject)
            Attr.SetAttribute(obj, attrName, oldValue);
        else
            Attr.RemoveAttribute(obj, attrName);
        Attr.RemoveAttribute(savedObj, savedAttrName);
        return true;
    }
    return false;
};
Attr.RestoreAttribute = function(obj, attrName){
    return Attr.RestoreAttributeExtended(obj, attrName, obj, "saved" + attrName);
};
Attr.RestoreStyleAttribute = function(obj, attrName){
    return Attr.RestoreAttributeExtended(obj.style, attrName, obj, "saved" + attrName);
};
Attr.CopyAllAttributes = function(sourceElem, destElement) {
    var attrs = sourceElem.attributes;
    for(var n = 0; n < attrs.length; n++) {
	    var attr = attrs[n];
	    if(attr.specified) {
	        var attrName = attr.nodeName;
	        var attrValue = sourceElem.getAttribute(attrName, 2);
	        if(attrValue == null)
	            attrValue = attr.nodeValue;
	        destElement.setAttribute(attrName, attrValue, 0); // 0 : Case Insensitive
		}
	}
	if(sourceElem.style.cssText !== '')
	    destElement.style.cssText = sourceElem.style.cssText;
};
Attr.RemoveAllAttributes = function(element, excludedAttributes) {
    var excludedAttributesHashTable = {};
    if(excludedAttributes)
        excludedAttributesHashTable = Data.CreateHashTableFromArray(excludedAttributes);
        
    if(element.attributes) {
        var attrArray = element.attributes;
        for(var i = 0; i < attrArray.length; i++) {
            var attrName = attrArray[i].name;
            if(!ASPx.IsExists(excludedAttributesHashTable[attrName.toLowerCase()])) {
                try {
                    attrArray.removeNamedItem(attrName);
                } catch (e) { }
            }
        }
    }
};
Attr.RemoveStyleAttribute = function(element, attrName) {
    if(element.style) {
        if(Browser.Firefox && element.style[attrName]) // attribute isn't removed if it isn't empty
            element.style[attrName] = "";
        if(element.style.removeAttribute && element.style.removeAttribute != "")
            element.style.removeAttribute(attrName);
        else if(element.style.removeProperty && element.style.removeProperty != "")
            element.style.removeProperty(attrName);
    }
};
Attr.RemoveAllStyles = function(element) {
    if(element.style) {
        /* jshint ignore:start */
        for(var key in element.style)
            Attr.RemoveStyleAttribute(element, key);
        /* jshint ignore:end */
       Attr.RemoveAttribute(element, "style");
    }
};
Attr.GetTabIndexAttributeName = function(){
    return Browser.IE  ? "tabIndex" : "tabindex";
};
Attr.ChangeTabIndexAttribute = function(element){
    var attribute = Attr.GetTabIndexAttributeName();    
    if(Attr.GetAttribute(element, attribute) != -1)
       Attr.ChangeAttribute(element, attribute, -1);
};
Attr.SaveTabIndexAttributeAndReset = function(element) {
    var attribute = Attr.GetTabIndexAttributeName();
    Attr.SaveAttribute(element, attribute, element, "saved" + attribute);
    Attr.SetAttribute(element, attribute, -1);
};
Attr.RestoreTabIndexAttribute = function(element){
    var attribute = Attr.GetTabIndexAttributeName();
    if(Attr.IsExistsAttribute(element, attribute)) {
        if(Attr.GetAttribute(element, attribute) == -1) {
            if(Attr.IsExistsAttribute(element, "saved" + attribute)){
                var oldValue = Attr.GetAttribute(element, "saved" + attribute);
                if(oldValue != ASPx.EmptyObject)
                    Attr.SetAttribute(element, attribute, oldValue);
                else {
                    if(Browser.WebKitFamily) 
                        Attr.SetAttribute(element, attribute, 0); 
                    Attr.RemoveAttribute(element, attribute);            
                }
                Attr.RemoveAttribute(element, "saved" + attribute); 
            }
        }
    }
};

Attr.ChangeAttributesMethod = function(enabled){
    return enabled ? Attr.RestoreAttribute : Attr.ResetAttribute;
};
Attr.InitiallyChangeAttributesMethod = function(enabled){
    return enabled ? Attr.ChangeAttribute : Attr.ResetAttribute;
};
Attr.ChangeStyleAttributesMethod = function(enabled){
    return enabled ? Attr.RestoreStyleAttribute : Attr.ResetStyleAttribute;
};
Attr.InitiallyChangeStyleAttributesMethod = function(enabled){
    return enabled ? Attr.ChangeStyleAttribute : Attr.ResetStyleAttribute;
};
Attr.ChangeEventsMethod = function(enabled){
    return enabled ? Evt.AttachEventToElement : Evt.DetachEventFromElement;
};
Attr.ChangeDocumentEventsMethod = function(enabled){
    return enabled ? Evt.AttachEventToDocument : Evt.DetachEventFromDocument;
};
Attr.ChangeCellSpanCount = function(cell, value, isColumnSpan) {
    if(!cell) return;
    var propertyKey = isColumnSpan ? "colSpan" : "rowSpan";
    var prevValue = cell[propertyKey];
    if(value > 1)
        cell[propertyKey] = value;
    else if(prevValue !== 1)
        Attr.RemoveAttribute(cell, propertyKey);
};

function isSourceResetRequired() {
    return Browser.IE && Browser.MajorVersion >= 11;
}

Attr.AppendScriptType = function(script) {
    if(!isHtml5Mode())
        script.type = "text/javascript";
};
Attr.AppendStyleType = function(style) {
    if(!isHtml5Mode())
        style.type = "text/css";
};
function isHtml5Mode() {
    return ASPx.DoctypeMode === "Html5";
}

ASPx.Attr = Attr;

var Aria = {
    atomic: "aria-atomic",
    checked: "aria-checked",
    descendant: "aria-activedescendant",
    described: "aria-describedby",
    disabled: "aria-disabled",
    expanded: "aria-expanded",
    haspopup: "aria-haspopup",
    invalid: "aria-invalid",
    label: "aria-label",
    labelled: "aria-labelledby",
    level: "aria-level",
    owns: "aria-owns",
    posinset: "aria-posinset",
    role: "role",
    selected: "aria-selected",
    setsize: "aria-setsize",
    valuemax: "aria-valuemax",
    valuemin: "aria-valuemin",
    valuenow: "aria-valuenow"
};
Aria.SetOrRemoveDescendant = function(obj, value) {
    ASPx.Attr.SetOrRemoveAttribute(obj, Aria.descendant, value);
};
Aria.SetOrRemoveLabel = function(obj, value) {
    ASPx.Attr.SetOrRemoveAttribute(obj, Aria.label, value);
};
Aria.SetOrRemoveDisabled = function(obj, value) {
    ASPx.Attr.SetOrRemoveAttribute(obj, Aria.disabled, value);
};
Aria.AppendLabel = function(obj, value, checkExists) {
    var currentValue = ASPx.Attr.GetAttribute(obj, Aria.label) || "";
    var resultParts = [ ];
    if(currentValue)
        resultParts.push(currentValue);
    var needAppendValue = value && (!checkExists || currentValue.indexOf(value) == -1);
    if(needAppendValue)
        resultParts.push(value);
    ASPx.Attr.SetAttribute(obj, Aria.label, resultParts.join(" "));
};
Aria.SetOrRemoveLabelled = function(obj, value) {
    ASPx.Attr.SetOrRemoveAttribute(obj, Aria.labelled, value);
};
Aria.SetApplicationRole = function(obj) {
     ASPx.Attr.SetAttribute(obj, Aria.role, "application");
};
Aria.SetSilence = function(obj) {
    ASPx.Attr.SetAttribute(obj, Aria.label, ";");
};
Aria.SetExpanded = function(obj, expanded) {
    if(!obj || !ASPx.Attr.GetAttribute(obj, Aria.expanded)) return;

    Aria.SetBoolAttribute(obj, Aria.expanded, expanded);
};
Aria.SetAtomic = function(obj, value) {
    Aria.SetBoolAttribute(obj, Aria.atomic, value);
};
Aria.SetBoolAttribute = function(obj, attribute, value) {
    if(value)
        ASPx.Attr.SetAttribute(obj, attribute, true);
    else 
        ASPx.Attr.SetAttribute(obj, attribute, false);
};

ASPx.Attr.Aria = Aria;

var Color = { };
function _aspxToHex(d) {
    return (d < 16) ? ("0" + d.toString(16)) : d.toString(16);
}
Color.RGBRegexp = /rgb\s*\(\s*([0-9]+)\s*,\s*([0-9]+)\s*,\s*([0-9]+)\s*\)/;
Color.RGBARegexp = /rgba?\s*\(\s*([0-9]+)\s*,\s*([0-9]+)\s*,\s*([0-9]+)\s*,?\s*([0-9]*\.?[0-9]*)\s*\)/;
Color.ColorToHexadecimal = function(colorValue, isRGBA) {
    if(typeof(colorValue) == "number") {
        var r = colorValue & 0xFF;
        var g = (colorValue >> 8) & 0xFF;
        var b = (colorValue >> 16) & 0xFF;
        return "#" + _aspxToHex(r) + _aspxToHex(g) + _aspxToHex(b);
    }
    if(colorValue && (colorValue.substr(0, 3).toLowerCase() == "rgb")) {
        // in rgb(...) form -- Mozilla
        var regResult = colorValue.toLowerCase().match(isRGBA ? Color.RGBARegexp : Color.RGBRegexp);
        if(regResult) {
            var r = parseInt(regResult[1]);
            var g = parseInt(regResult[2]);
            var b = parseInt(regResult[3]);
            if (isRGBA)
                return { r: r, g: g, b: b, a: regResult[4] !== undefined ? parseFloat(regResult[4]) : 1 };
            return "#" + _aspxToHex(r) + _aspxToHex(g) + _aspxToHex(b);
        }
        return null;
    }    
    if(colorValue && (colorValue.charAt(0) == "#"))
        return colorValue;
    return null;
};
Color.Names = {
    AddColorNames: function(stringResourcesObj) {
        if(stringResourcesObj) {
            for(var key in stringResourcesObj)
                if(stringResourcesObj.hasOwnProperty(key))
                    this[key] = stringResourcesObj[key];
        }
    }
};

ASPx.Color = Color;

var Url = { };
Url.Navigate = function(url, target) {
    var javascriptPrefix = "javascript:";
    if(!url || url === "")
        return;
    else if(url.indexOf(javascriptPrefix) != -1) 
        eval(url.substr(javascriptPrefix.length));
    else {
        try{
            if(target != "")
                navigateTo(url, target);
            else
                location.href = url;
        }
        catch(e){
            // fix IE bug - B145116
        }
    }
};
Url.NavigateByLink = function(linkElement) {
    Url.Navigate(Attr.GetAttribute(linkElement, "href"), linkElement.target);
};
Url.GetAbsoluteUrl = function(url) {
    if(url)
        url = Url.getURLObject(url).href;
    return url;
};
Url.Redirect = function(url) {
    if(!ASPx.Browser.IE)
        window.location.href = url;
    else { // B194434
        var fakeLink = document.createElement("a");
        fakeLink.href = url;
        document.body.appendChild(fakeLink);
        try { fakeLink.click(); } catch(e) { } // T307446
    }
};

var absolutePathPrefixes = 
    [ "about:", "file:///", "ftp://", "gopher://", "http://", "https://", "javascript:", "mailto:", "news:", "res://", "telnet://", "view-source:" ];

Url.isAbsoluteUrl = function(url) {
    if (url) {
        for (var i = 0; i < absolutePathPrefixes.length; i++) {
            if(url.indexOf(absolutePathPrefixes[i]) == 0)
                return true;
        }
    }
    return false;
};

Url.getURLObject = function(url) {
    var link = document.createElement('A');
    link.href = url || "";
    return { 
        href: link.href,
        protocol: link.protocol,
        host: link.host,
        port: link.port,
        pathname: link.pathname,
        search: link.search,
        hash: link.hash
    };    
};

Url.getRootRelativeUrl = function(url) {
    return getRelativeUrl(url, !Url.isRootRelativeUrl(url), true);    
};

Url.getPathRelativeUrl = function(url) {
    return getRelativeUrl(url, !Url.isPathRelativeUrl(url), false);
};

function getRelativeUrl(url, isValid, isRootRelative) {
    if(url && !(/data:([^;]+\/?[^;]*)(;charset=[^;]*)?(;base64,)/.test(url)) && isValid) {
        var urlObject = Url.getURLObject(url);
        var baseUrlObject = Url.getURLObject();
        if(!Url.isAbsoluteUrl(url) || urlObject.host === baseUrlObject.host && urlObject.protocol === baseUrlObject.protocol) {
            url = urlObject.pathname;
            if(!isRootRelative)
                url = getPathRelativeUrl(baseUrlObject.pathname, url);
            url = url + urlObject.search + urlObject.hash;
        }
    }
    return url;         
}
    
function getPathRelativeUrl(baseUrl, url) {
    var requestSegments = getSegments(baseUrl, false);
    var urlSegments = getSegments(url, true);
    return buildPathRelativeUrl(requestSegments, urlSegments, 0, 0, "");
}
function getSegments(url, addTail) {
    var segments = [];
    var startIndex = 0;
    var endIndex = -1;
    while ((endIndex = url.indexOf("/", startIndex)) != -1) {
        segments.push(url.substring(startIndex, ++endIndex));
        startIndex = endIndex;
    }
    if(addTail && startIndex < url.length)
        segments.push(url.substring(startIndex, url.length));    
    return segments;
}

function buildPathRelativeUrl(requestSegments, urlSegments, reqIndex, urlIndex, buffer) {
    if(urlIndex >= urlSegments.length)
        return buffer;
    if(reqIndex >= requestSegments.length)
        return buildPathRelativeUrl(requestSegments, urlSegments, reqIndex, urlIndex + 1, buffer + urlSegments[urlIndex]);
    if(requestSegments[reqIndex] === urlSegments[urlIndex] && urlIndex === reqIndex)
        return buildPathRelativeUrl(requestSegments, urlSegments, reqIndex + 1, urlIndex + 1, buffer);
    return buildPathRelativeUrl(requestSegments, urlSegments, reqIndex + 1, urlIndex, buffer + "../");
}

Url.isPathRelativeUrl = function(url) {
    return !!url && !Url.isAbsoluteUrl(url) && url.indexOf("/") != 0;  
};

Url.isRootRelativeUrl = function(url) {
    return !!url && !Url.isAbsoluteUrl(url) && url.indexOf("/") == 0 && url.indexOf("//") != 0;
};

function navigateTo(url, target) {
    var lowerCaseTarget = target.toLowerCase();
    if("_top" == lowerCaseTarget)
        top.location.href = url;
    else if("_self" == lowerCaseTarget)
        location.href = url;
    else if("_search" == lowerCaseTarget)
        openInNewWindow(url);
    else if("_media" == lowerCaseTarget)
        openInNewWindow(url);
    else if("_parent" == lowerCaseTarget)
        window.parent.location.href = url;
    else if("_blank" == lowerCaseTarget)
        openInNewWindow(url);
    else {
        var frame = getFrame(top.frames, target);
        if(frame != null)
            frame.location.href = url;
        else
            openInNewWindow(url);
    }
}
function openInNewWindow(url) {
    if(ASPx.Browser.Safari)
        openInNewWindowViaIframe(url);
    else {
        var newWindow = window.open();
        newWindow.opener = null;
        newWindow.location = url;
    }
}
function openInNewWindowViaIframe(url) {
    var iframe = document.createElement('iframe');
    iframe.style.display = 'none';
    document.body.appendChild(iframe);
    var iframeDoc = iframe.contentDocument || iframe.contentWindow.document;

    var openArgs = '"' + url + '"';
    var script = iframeDoc.createElement('script');
    script.type = 'text/javascript';
    script.text = 'window.parent = null; ' +
        'window.top = null;' +
        'window.frameElement = null;' +
        'var child = window.open(' + openArgs + ');' +
        'child.opener = null';
    iframeDoc.body.appendChild(script);

    document.body.removeChild(iframe);
}
ASPx.Url = Url;

var Json = { };
function isValid(JsonString) {
    return !(/[^,:{}\[\]0-9.\-+Eaeflnr-u \n\r\t]/.test(JsonString.replace(/"(\\.|[^"\\])*"/g, '')));
}
Json.Eval = function(jsonString, controlName) {
    if(isValid(jsonString))
        return eval("(" + jsonString + ")");
    else
        throw new Error(controlName + " received incorrect JSON-data: " + jsonString);
};
Json.ToJson = function(param, skipEncodeHtml){
    var paramType = typeof(param);
    if((paramType == "undefined") || (param == null))
        return null;
    if((paramType == "object") && (typeof(param.__toJson) == "function"))
        return param.__toJson();
    if((paramType == "number") || (paramType == "boolean"))
        return param;
    if(param.constructor == Date)
        return dateToJson(param);
    if(paramType == "string") {
        var result = param.replace(/\\/g, "\\\\");
        result = result.replace(/"/g, "\\\"");
        result = result.replace(/\n/g, "\\n");
        result = result.replace(/\r/g, "\\r");
        // For request validation
        if(!skipEncodeHtml) {
            result = result.replace(/</g, "\\u003c");
            result = result.replace(/>/g, "\\u003e");
        }
        return "\"" + result + "\"";
    }
    if(param.constructor == Array){
        var values = [];
        for(var i = 0; i < param.length; i++) {
            var jsonValue = Json.ToJson(param[i], skipEncodeHtml);
            if(jsonValue === null)
                jsonValue = "null";
            values.push(jsonValue);
        }
        return "[" + values.join(",") + "]";
    }
    var exceptKeys = {};
    if(ASPx.Ident.IsArray(param.__toJsonExceptKeys))
        exceptKeys = Data.CreateHashTableFromArray(param.__toJsonExceptKeys);
    exceptKeys["__toJsonExceptKeys"] = 1;
    var values = [];
    for(var key in param) {
        if(param.hasOwnProperty(key)) {
            if(ASPx.IsFunction(param[key]))
                continue;
            if(exceptKeys[key] == 1)
                continue;
            values.push(Json.ToJson(key) + ":" + Json.ToJson(param[key], skipEncodeHtml));
        }
    }
    return "{" + values.join(",") + "}";
};
function dateToJson(date) {
    var result = [ 
        date.getFullYear(),
        date.getMonth(),
        date.getDate()
    ];
    var time = {
        h: date.getHours(),
        m: date.getMinutes(),
        s: date.getSeconds(),
        ms: date.getMilliseconds()
    };
    if(time.h || time.m || time.s || time.ms)
        result.push(time.h);
    if(time.m || time.s || time.ms)
        result.push(time.m);
    if(time.s || time.ms)
        result.push(time.s);
    if(time.ms)
        result.push(time.ms);
    return "new Date(" + result.join() + ")";
}
ASPx.Json = Json;

// Classes
ASPx.CreateClass = function(parentClass, properties) {
    if(arguments.length == 1) {
        properties = parentClass;
        parentClass = null;
    }
    var ret = function() {
        if(ret.preparing) 
            return delete(ret.preparing);
        if(ret.constr) {
            this.constructor = ret;
            ret.constr.apply(this, arguments);
        }
    };
    ret.prototype = {};
    if(parentClass) {
        parentClass.preparing = true;
        for(var name in parentClass) {
            if(parentClass.hasOwnProperty(name) && name != 'constr' && ASPx.IsFunction(parentClass[name]) && !ret[name])
                ret[name] = parentClass[name].aspxBind(parentClass);
        }
        /*jshint -W058 */
        ret.prototype = new parentClass;
        /*jshint +W058 */
        ret.prototype.constructor = parentClass;
        ret.constr = parentClass;
    }
    if(properties) {
        var constructorName = "constructor";
        for(var name in properties) {
            if(!properties.hasOwnProperty(name)) 
                continue;
            var getter = Object.getOwnPropertyDescriptor(properties, name).get;
            var setter = Object.getOwnPropertyDescriptor(properties, name).set;
            if(getter || setter)
                Object.defineProperty(ret.prototype, name, {
                    set: setter,
                    get: getter,
                    enumerable: true,
                    configurable: true
                });


            if(name != constructorName && !getter && !setter)
                ret.prototype[name] = properties[name];
        }
        if(properties[constructorName] && properties[constructorName] != Object)
            ret.constr = properties[constructorName];
    }
    return ret;
};
var registeredMixins = {};
ASPx.GetMixin = function (name, baseClass) {
    var mixinCache = baseClass._mixins || (baseClass._mixins = {});
    var resultClass = mixinCache[name];
    if (!resultClass) {
        var mixinCodeBuilder = registeredMixins[name];
        if (!mixinCodeBuilder)
            throw new Error("mixin with the '" + name + "' is not registered");
        var mixinCode = mixinCodeBuilder(baseClass);
        mixinCode.mixinName = name;
        resultClass = ASPx.CreateClass(baseClass, mixinCode);
        mixinCache[name] = resultClass;
    }
    return resultClass;
};
ASPx.RegisterMixin = function() {
    var name = arguments.length == 1 ? "mixin_" + ASPx.CreateGuid() : arguments[0];
    var mixinCodeBuilder = arguments[arguments.length - 1];
    if (registeredMixins[name])
        throw new Error("mixin with the '" + name + "' name is already defined");
    registeredMixins[name] = mixinCodeBuilder;
    return function(baseClass) { return ASPx.GetMixin(name, baseClass); };
};

// Callbacks
ASPx.FormatCallbackArg = function(prefix, arg) {
    // [Victor] TODO: refactor HtmlEditor->Dialogs.js and remove this logics (only simple data types are expected)
    if(prefix == null && arg == null)
        return "";    
    if(prefix == null) prefix = "";
    if(arg == null) arg = "";
    
    if(arg != null && !ASPx.IsExists(arg.length) && ASPx.IsExists(arg.value))
        arg = arg.value;
    arg = arg.toString();
    return [prefix, '|', arg.length, '|' , arg].join('');
};
ASPx.FormatCallbackArgs = function(callbackData) {
    var sb = [ ];
    for(var i = 0; i < callbackData.length; i++)
        sb.push(ASPx.FormatCallbackArg(callbackData[i][0], callbackData[i][1]));
    return sb.join("");
};

// Shortcuts
ASPx.ParseShortcutString = function(shortcutString) {
    if(!shortcutString)
        return 0;

    var isCtrlKey = false;
    var isShiftKey = false;
    var isAltKey = false;
    var isMetaKey = false;
    var keyCode = null;
    
    var shcKeys = shortcutString.toString().split("+");
    
    if(shcKeys.length > 0) {
        for(var i = 0; i < shcKeys.length; i++) {
            var key = Str.Trim(shcKeys[i].toUpperCase());
            switch (key) {
                case "CONTROL":
                case "CONTROLKEY":
                case "CTRL":
                    isCtrlKey = true;
                    break;
                case "SHIFT":
                case "SHIFTKEY":
                    isShiftKey = true;
                    break;
                case "ALT":
                    isAltKey = true;
                    break;
                case "CMD":
                    isMetaKey = true;
                    break;

                case "F1":    keyCode = ASPx.Key.F1; break;
                case "F2":    keyCode = ASPx.Key.F2; break;
                case "F3":    keyCode = ASPx.Key.F3; break;
                case "F4":    keyCode = ASPx.Key.F4; break;
                case "F5":    keyCode = ASPx.Key.F5; break;
                case "F6":    keyCode = ASPx.Key.F6; break;
                case "F7":    keyCode = ASPx.Key.F7; break;
                case "F8":    keyCode = ASPx.Key.F8; break;
                case "F9":    keyCode = ASPx.Key.F9; break;
                case "F10":   keyCode = ASPx.Key.F10; break;
                case "F11":   keyCode = ASPx.Key.F11; break;
                case "F12":   keyCode = ASPx.Key.F12; break;

                case "RETURN":
                case "ENTER": keyCode = ASPx.Key.Enter; break;
                case "HOME":  keyCode = ASPx.Key.Home; break;
                case "END":   keyCode = ASPx.Key.End; break;
                case "LEFT":  keyCode = ASPx.Key.Left; break;
                case "RIGHT": keyCode = ASPx.Key.Right; break;
                case "UP":    keyCode = ASPx.Key.Up; break;
                case "DOWN":  keyCode = ASPx.Key.Down; break;
                case "PAGEUP": keyCode = ASPx.Key.PageUp; break;
                case "PAGEDOWN": keyCode = ASPx.Key.PageDown; break;
                case "SPACE": keyCode = ASPx.Key.Space; break;
                case "TAB":   keyCode = ASPx.Key.Tab; break;
                case "BACKSPACE": 
                case "BACK": keyCode = ASPx.Key.Backspace; break;
                case "CONTEXT": keyCode = ASPx.Key.ContextMenu; break;

                case "ESCAPE":
                case "ESC":
                    keyCode = ASPx.Key.Esc;
                    break;

                case "DELETE":
                case "DEL":
                    keyCode = ASPx.Key.Delete;
                    break;

                case "INSERT":
                case "INS":
                    keyCode = ASPx.Key.Insert;
                    break;

                case "PLUS":
                    keyCode = "+".charCodeAt(0);
                    break;
                default:
                    keyCode = key.charCodeAt(0);
                    break;
            }
        }
    } else
        ASPx.ShowErrorAlert("Invalid shortcut");
    return ASPx.GetShortcutCode(keyCode, isCtrlKey, isShiftKey, isAltKey, isMetaKey);
};
ASPx.GetShortcutCode = function(keyCode, isCtrlKey, isShiftKey, isAltKey, isMetaKey) {
    var value = keyCode;
    value |= isCtrlKey ? ASPx.ModifierKey.Ctrl : 0;
    value |= isShiftKey ? ASPx.ModifierKey.Shift : 0;
    value |= isAltKey ? ASPx.ModifierKey.Alt : 0;
    value |= isMetaKey ? ASPx.ModifierKey.Meta : 0;
    return value;
};
ASPx.GetShortcutCodeByEvent = function(evt) {
    return ASPx.GetShortcutCode(Evt.GetKeyCode(evt), evt.ctrlKey, evt.shiftKey, evt.altKey, ASPx.Browser.MacOSPlatform ? evt.metaKey : false);
};
ASPx.IsPasteShortcut = function(evt) {
    if(evt.type === "paste")
        return true;
    var keyCode = Evt.GetKeyCode(evt);
    
    if(Browser.NetscapeFamily && evt.which == 0)        
        keyCode = evt.keyCode;
    
    return (evt.ctrlKey && (keyCode == 118 /*v*/ || (keyCode == 86)/*V*/)) ||
           (evt.shiftKey && !evt.ctrlKey && !evt.altKey &&
           (keyCode == ASPx.Key.Insert)) ;
};
var NotPrintableKeyCodes = null;
ASPx.IsPrintableKey = function(keyCode) {
    if (!NotPrintableKeyCodes)
        NotPrintableKeyCodes = Object.keys(ASPx.Key).map(function(key) { return ASPx.Key[key]; });
    return !ASPx.Data.ArrayContains(NotPrintableKeyCodes, keyCode);
};

// Focus
ASPx.SetFocus = function(element, selectAction) {
    function focusCore(element, selectAction){
        try {
                element.focus();
                if(Browser.IE && document.activeElement != element)
                    element.focus();

                // Q339238
                if(selectAction) {
                    var currentSelection = Selection.GetInfo(element);
                    // apply selection only if there is no selection present already
                    if(currentSelection.startPos == currentSelection.endPos) {
                    
                        switch(selectAction) {
                            case "start":
                                Selection.SetCaretPosition(element, 0);
                                break;
                            case "all":
                                Selection.Set(element);
                                break;
                        }
                    }
                }
            } catch (e) {
        }
    }
    if(ASPxClientUtils.iOSPlatform) // Q471191
        focusCore(element, selectAction);
    else {
        window.setTimeout(function() { // B39538
            focusCore(element, selectAction);
        }, ASPx.FOCUS_TIMEOUT);
    }
};
ASPx.IsFocusableCore = function(element, skipContainerVisibilityCheck) {
    var current = element;
    while(current && current.nodeType == 1) {
        if(current == element || !skipContainerVisibilityCheck(current)) {
            var tagName = current.tagName.toUpperCase();
            if(tagName == "BODY")
                return true;
            var disabledElementTags = ["INPUT", "BUTTON", "TEXTAREA", "SELECT", "OPTION"];
            if(disabledElementTags.indexOf(tagName) !== -1 && current.disabled || !ASPx.GetElementDisplay(current) || !ASPx.GetElementVisibility(current))
                return false;
        }
        current = current.parentNode;
    }
    return true;
};
ASPx.IsFocusable = function(element) {
    return ASPx.IsFocusableCore(element, ASPx.FalseFunction);
};
ASPx.RemoveFocus = function(parent) {
    var div = document.createElement('div');
    div.tabIndex = "-1";
    concealDivElement(div);
    parent.appendChild(div);
    if(ASPx.IsFocusable(div))
        div.focus();
    ASPx.RemoveElement(div);
};
function concealDivElement(div){
    div.style.position = "absolute";
    div.style.left = 0;
    div.style.top = 0;
    if(ASPx.Browser.WebKitFamily) {
        div.style.opacity = 0;
        div.style.width = 1;
        div.style.height = 1;
    } else {
        div.style.border = 0;
        div.style.width = 0;
        div.style.height = 0;
    }
}

var ActionElementsCache = ASPx.CreateClass(null, {
    constructor: function() {
        this.usageCounter = 0;
        this.elements = [ ];
        this.values = [ ];
    },
    IsActive: function() { return this.usageCounter > 0; },
    BeginUsage: function() {
        this.usageCounter++;
    },
    EndUsage: function() {
        this.usageCounter--;
        if(this.usageCounter === 0)
            this.Clear();
    },

    Add: function(element, value) {
        var index = this.elements.length;
        this.elements[index] = element;
        this.values[index] = value;
    },
    Get: function(element) { 
        var index = this.elements.indexOf(element);
        var hasValue = index > -1;
        var value = hasValue ? this.values[index] : undefined;
        return { hasValue: hasValue, value: value };
    },
    Clear: function() { 
        this.elements = [ ];
        this.values = [ ];
    }
});
ASPx.ActionElementsCache = new ActionElementsCache();

ASPx.IsActionElement = function(element) {
    if(!ASPx.IsExistsElement(element))
        return false;

    var useCache = ASPx.ActionElementsCache.IsActive();
    if(useCache) {
        var cacheValue = ASPx.ActionElementsCache.Get(element);
        if(cacheValue.hasValue)
            return cacheValue.value;
    }
    var isActionElement = ASPx.IsActionElementCore(element);
    if(useCache)
        ASPx.ActionElementsCache.Add(element, isActionElement);

    return isActionElement;
};
ASPx.IsActionElementCore = function(element) {
    var tabIndex = parseInt(ASPx.Attr.GetAttribute(element, ASPx.Attr.GetTabIndexAttributeName()));
    var hasTabIndex = !isNaN(tabIndex);
    var hasNonNegativeTabIndex = hasTabIndex && tabIndex > -1;
    var hasNegativeTabIndex = hasTabIndex && tabIndex < 0;
    var tagName = element.tagName;
    var focusableElementTags = ["BUTTON", "SELECT", "TEXTAREA", "OPTION", "IFRAME"];

    var isFocusableCore = ASPx.IsFocusable(element);
    var isFocusableTag = focusableElementTags.indexOf(tagName) !== -1;
    var isFocusableLink = tagName === "A" && (!!element.href || hasNonNegativeTabIndex);
    var isFocusableInput = tagName === "INPUT" && element.type.toLowerCase() !== "hidden";
    var isFocusableByTabIndex = tagName !== "INPUT" && hasNonNegativeTabIndex;
    var isEditableDiv = tagName == "DIV" && element.contentEditable === "true";

    return isFocusableCore && !hasNegativeTabIndex && (isFocusableTag || isFocusableLink || isFocusableInput || isFocusableByTabIndex || isEditableDiv);
};

ASPx.GetCanBeActiveElementsInContainer = function(container) {
    var canBeActiveTags = ["INPUT", "A", "UL", "BUTTON", "TEXTAREA", "SELECT", "IFRAME"],
        canBeActiveElements = [];
    Data.ForEach(canBeActiveTags, function(tag) {
        var elements = container.getElementsByTagName(tag);
        canBeActiveElements = canBeActiveElements.concat([].slice.call(elements));
    });
    return canBeActiveElements;
};

function isActionElementAllowedByPredicate(element, predicate) {
     var allowedByPredicate = !predicate || predicate(element);
     return allowedByPredicate && ASPx.IsActionElement(element);
}
ASPx.FindChildActionElements = function(container, predicate) {
    return ASPx.GetNodes(container, function(el) {
        return isActionElementAllowedByPredicate(el, predicate);
    });
};
ASPx.FindAllSortedActionElements = function(container, predicate) {
    var result = [ ];
    if(!container || !container.getElementsByTagName) return result;
    var actionElements = ASPx.FindChildActionElements(container, predicate);

    var getTabOrderValue = function(el) {
        var tabIndex = parseInt(ASPx.Attr.GetAttribute(el, ASPx.Attr.GetTabIndexAttributeName()));
        return isNaN(tabIndex) ? 0 : tabIndex;
    };
    var positiveTabIndexElements = actionElements.filter(function(x) { return getTabOrderValue(x) > 0; });
    var nonPositiveTabIndexElements = actionElements.filter(function(x) { return getTabOrderValue(x) === 0; });
    var sortedTabIndexElements = positiveTabIndexElements.sort(function(x, y) { return getTabOrderValue(x) - getTabOrderValue(y); });
    result = sortedTabIndexElements.concat(nonPositiveTabIndexElements);
    return result;
};
ASPx.FindFirstChildActionElement = function(container, predicate) {
    if(!container || isActionElementAllowedByPredicate(container, predicate))
        return !container ? null : container;
    var sortedActionElements = ASPx.FindAllSortedActionElements(container, predicate);
    return sortedActionElements[0];
};
ASPx.FindLastChildActionElement = function(container, predicate) {
    if(!container)
        return null;
    var sortedActionElements = ASPx.FindAllSortedActionElements(container, predicate);
    var actionElement = sortedActionElements[sortedActionElements.length - 1];
    if(!actionElement && isActionElementAllowedByPredicate(container, predicate))
        actionElement = container;
    return actionElement;
};

ASPx.GetParentClientControls = function(name) {
    var nameParts = name.split("_");
    var result = [ ];
    var controlCollection = ASPx.GetControlCollection();
    for(var i = 1; i <= nameParts.length; i++) {
        var controlName = nameParts.slice(0, i).join("_");
        var control = controlCollection.Get(controlName);
        if(control)
            result.push(control);
    }
    return result;
};
ASPx.GetRootClientControl = function(childControlName) {
    var parentControls = ASPx.GetParentClientControls(childControlName);
    return parentControls[0];
};
ASPx.GetClientControlByElementID = function(elementID) {
    var parentControls = ASPx.GetParentClientControls(elementID);
    return parentControls[parentControls.length - 1];
};

// Common
ASPx.IsExists = function(obj){
    return (typeof(obj) != "undefined") && (obj != null);
};
ASPx.IsFunction = function(obj){
    return typeof(obj) == "function";
};
ASPx.IsNumber = function(str) {
    return !isNaN(parseFloat(str)) && isFinite(str);
};
ASPx.GetDefinedValue = function(value, defaultValue){
    return (typeof(value) != "undefined") ? value : defaultValue;
};
ASPx.CorrectJSFloatNumber = function(number) {
    // Hack: 3.12 + 10 = 13.1200000000000001 - bug is javascript
    var ret = 21; // max number
    var numString = number.toPrecision(21);
    numString = numString.replace("-", ""); // B196112
    var integerDigitsCount = numString.indexOf(ASPx.PossibleNumberDecimalSeparators[0]);

    if(integerDigitsCount < 0)
        integerDigitsCount = numString.indexOf(ASPx.PossibleNumberDecimalSeparators[1]);

    var floatDigitsCount = numString.length - integerDigitsCount - 1;
    if(floatDigitsCount < 10)
        return number;

    if(integerDigitsCount > 0) {
        // 12 was fitted. Elsewise, the testChangeNumberInternal isn't successful
        ret = integerDigitsCount + 12;
    }
    
    var toPrecisionNumber = Math.min(ret, 21);
    var newValueString = number.toPrecision(toPrecisionNumber);
    return parseFloat(newValueString, 10);
};
ASPx.CorrectRounding = function(number, step) { //T222586
    var regex = /[,|.](.*)/,
        isFloatValue = regex.test(number),
        isFloatStep = regex.test(step);

    if(isFloatValue || isFloatStep) {
        var valueAccuracy = (isFloatValue) ? regex.exec(number)[0].length - 1 : 0,
            stepAccuracy = (isFloatStep) ? regex.exec(step)[0].length - 1 : 0,
            accuracy = Math.max(valueAccuracy, stepAccuracy);

        var multiplier = Math.pow(10, accuracy);
        number = Math.round((number + step) * multiplier) / multiplier;
        return number;
    }

    return number + step;
};

// DOM
ASPx.GetActiveElement = function() {
    try{ return document.activeElement; } catch(e) { return null; }
};
var verticalScrollBarWidth;
ASPx.GetVerticalScrollBarWidth = function() {
    if(typeof(verticalScrollBarWidth) == "undefined") {
        var container = document.createElement("DIV");
        container.style.cssText = "position: absolute; top: 0px; left: 0px; visibility: hidden; width: 200px; height: 150px; overflow: hidden; box-sizing: content-box";
        document.body.appendChild(container);

        var child = document.createElement("P");
        container.appendChild(child);
        child.style.cssText = "width: 100%; height: 200px;";

        var widthWithoutScrollBar = child.offsetWidth;
        container.style.overflow = "scroll";
        var widthWithScrollBar = child.offsetWidth;
        if(widthWithoutScrollBar == widthWithScrollBar)
            widthWithScrollBar = container.clientWidth;

        verticalScrollBarWidth = widthWithoutScrollBar - widthWithScrollBar;
        
        document.body.removeChild(container);
    }
    return verticalScrollBarWidth;
};
function hideScrollBarCore(element, scrollName) {
    if(element.tagName == "IFRAME") {
        if((element.scrolling == "yes") || (element.scrolling == "auto")) {
            Attr.ChangeAttribute(element, "scrolling", "no");
            return true;
        }
    }
    else if(element.tagName == "DIV") {
        if((element.style[scrollName] == "scroll") || (element.style[scrollName] == "auto")) {
            Attr.ChangeStyleAttribute(element, scrollName, "hidden");
            return true;
        }
    }
    return false;
}
function restoreScrollBarCore(element, scrollName) {
    if(element.tagName == "IFRAME")
        return Attr.RestoreAttribute(element, "scrolling");
    else if(element.tagName == "DIV")
        return Attr.RestoreStyleAttribute(element, scrollName);
    return false;
}
ASPx.SetScrollBarVisibilityCore = function(element, scrollName, isVisible) {
    return isVisible ? restoreScrollBarCore(element, scrollName) : hideScrollBarCore(element, scrollName);
};
ASPx.SetScrollBarVisibility = function(element, isVisible) {
    if(ASPx.SetScrollBarVisibilityCore(element, "overflow", isVisible)) // B143193
        return true;
    var result = ASPx.SetScrollBarVisibilityCore(element, "overflowX", isVisible)
        || ASPx.SetScrollBarVisibilityCore(element, "overflowY", isVisible);
    return result;
};

ASPx.SetInnerHtml = function(element, html) {
    if(Browser.IE) {
        setInnerHtmlInternal(element, "<em>&nbsp;</em>" + html);
        element.removeChild(element.firstChild);
    } else
        setInnerHtmlInternal(element, html);
};
ASPx.GetInnerText = function(container) {
    if(Browser.Safari && Browser.MajorVersion <= 5) {
        var filter = getHtml2PlainTextFilter();
        setInnerHtmlInternal(filter, container.innerHTML);
        ASPx.SetElementDisplay(filter, true);
        var innerText = filter.innerText;
        ASPx.SetElementDisplay(filter, false);
        return innerText;
    } else if(Browser.NetscapeFamily || Browser.WebKitFamily || (Browser.IE && Browser.Version >= 9) || Browser.Edge) {
        return container.textContent;
    } else
        return container.innerText;
};
ASPx.GetEllipsisTooltipText = function(element) {
    var innerText = ASPx.GetInnerText(element);
    innerText = ASPx.RemoveComment(innerText);
    return innerText;
};
ASPx.RemoveComment = function(text) {
    var result = text;
    var commentStart = "<!--";
    var commentEnd = "//-->";
    var positionStart = result.indexOf(commentStart);
    while(positionStart > -1) {
        var positionEnd = result.indexOf(commentEnd);
        var startStr = result.substring(0, positionStart);
        var endStr = result.substring(positionEnd + commentEnd.length);
        result = startStr + endStr;
        positionStart = result.indexOf(commentStart);
    }
    return result;
};

var html2PlainTextFilter = null;
function getHtml2PlainTextFilter() {
    if(html2PlainTextFilter == null) {
        html2PlainTextFilter = document.createElement("DIV");
        html2PlainTextFilter.style.width = "0";
        html2PlainTextFilter.style.height = "0";
        html2PlainTextFilter.style.overflow = "visible";
        ASPx.SetElementDisplay(html2PlainTextFilter, false);
        document.body.appendChild(html2PlainTextFilter);
    }
    return html2PlainTextFilter;
}
ASPx.CreateHiddenField = function(name, id, parent) {
    var input = document.createElement("INPUT");
    input.setAttribute("type", "hidden");
    if(name)
        input.setAttribute("name", name);
    if(id)
        input.setAttribute("id", id);
    if(parent)
        parent.appendChild(input);
    return input;
};
ASPx.CloneObject = function(srcObject) {
    if(typeof(srcObject) != 'object' || srcObject == null)
        return srcObject;
    var newObject = {};
    /* jshint ignore:start */
    for(var i in srcObject)
        newObject[i] = srcObject[i];
    /* jshint ignore:end */
    return newObject;
};

ASPx.InsertRowsBefore = function(table, rowsHtml, index) {
    var row = null;
    if(index >= 0 && index < table.rows.length)
        row = table.rows[index];

    var func = ASPx.Browser.IE && ASPx.Browser.Version < 10 ? insertRowsBefore_IE9 : insertRowsBefore;
    func(table, rowsHtml, row);
};
var insertRowsBefore = function(table, rowsHtml, row) {
    if(!row && table.tBodies.length > 0) {
        row = document.createElement("TR");
        table.tBodies[0].appendChild(row);
        row.shouldRemove = true;
    }
    if(row) {
        row.insertAdjacentHTML("beforeBegin", rowsHtml);
        if(row.shouldRemove)
            ASPx.RemoveElement(row);
    }
};
var insertRowsBefore_IE9 = function(table, rowsHtml, nextRow) {
    var row = document.createElement("TR");
    var cell = document.createElement("TD");
    setInnerHtmlInternal(cell, "<table><tbody>" + rowsHtml + "</tbody></table>");

    var tbody = table.tBodies[0];
    tbody.appendChild(row);
    row.appendChild(cell);
        
    var newTable = ASPx.GetNodeByTagName(cell, "TABLE", 0);
    var rowCount = newTable.rows.length;

    for(var i = rowCount - 1; i >= 0; i--) {
        var newRow = newTable.rows[i];
        if(nextRow == null)
            tbody.appendChild(newRow);
        else
            tbody.insertBefore(newRow, nextRow);
        nextRow = newRow;
    }
    ASPx.RemoveElement(row);
};

ASPx.IsPercentageSize = function(size) {
    return size && size.indexOf('%') != -1;
};

ASPx.GetElementById = function(id) {
    if(document.getElementById)
        return document.getElementById(id);
    else
        return document.all[id];
};
ASPx.GetInputElementById = function(id) {
    var elem = ASPx.GetElementById(id);
    if(!Browser.IE)
        return elem;

    if(elem) {
        if(elem.id == id)
            return elem;
        else {
            for(var i = 1; i < document.all[id].length; i++) {
                if(document.all[id][i].id == id)
                    return document.all[id][i];
            }
        }
    }
    return null;
};
ASPx.GetElementByIdInDocument = function(documentObj, id) {
    if(documentObj.getElementById)
        return documentObj.getElementById(id);
    else
        return documentObj.all[id];
};
ASPx.GetIsParent = function(parentElement, element) {
    if(!parentElement || !element)
        return false;
    while(element){
        if(element === parentElement)
            return true;
        if(element.tagName === "BODY")
            return false;
        element = element.parentNode;
    }
    return false;
};
ASPx.GetParentById = function(element, id) {
    element = element.parentNode;
    while(element){
        if(element.id === id)
            return element;
        element = element.parentNode;
    }
    return null;
};
ASPx.GetParentByPartialId = function(element, idPart){
    while(element && element.tagName != "BODY") {
        if(element.id && element.id.match(idPart)) 
            return element;

        element = element.parentNode;
    }
    return null;
};
ASPx.GetParentByTagName = function(element, tagName) {
    tagName = tagName.toUpperCase();
    while(element) {
        if(element.tagName === "BODY")
            return null;
        if(element.tagName === tagName)
            return element;
        element = element.parentNode;
    }
    return null;
};
function getParentByCondition(element, conditionArg, condition) {
    while(element != null) {
        if(element.tagName == "BODY" || element.nodeName == "#document")
            return null;
        if (condition(element, conditionArg))
            return element;
        element = element.parentNode;
    }
    return null;
}
ASPx.GetParentByPartialClassName = function(element, className) {
    return getParentByCondition(element, className, ASPx.ElementContainsCssClass);
};
ASPx.GetParentByClassName = function(element, className) {
    return getParentByCondition(element, className, ASPx.ElementHasCssClass);
};
ASPx.GetParentBySelector = function (element, selector) {
    return getParentByCondition(element, selector, ASPx.ElementMatchesSelector);
};
ASPx.GetParentByTagNameAndAttributeValue = function(element, tagName, attrName, attrValue) {
    tagName = tagName.toUpperCase();
    while(element != null) {
        if(element.tagName == "BODY")
            return null;
        if(element.tagName == tagName && element[attrName] == attrValue)
            return element;
        element = element.parentNode;
    }
    return null;
};
ASPx.GetParent = function(element, testFunc){
    if (!ASPx.IsExists(testFunc)) return null;
    
    while(element != null && element.tagName != "BODY"){
        if(testFunc(element))
            return element;
        element = element.parentNode;
    }
    return null;
};

ASPx.GetElementTreeLine = function(element, stopTagName, stopFunc) {
    var result = [];

    stopTagName = stopTagName || "BODY";

    while(element != null) {
        if(!stopFunc && element.tagName == stopTagName)
            break;
        if(stopFunc && stopFunc(element))
            break;
        result.push(element);
        element = element.parentNode;
    }

    return result;
};

ASPx.IsScrollableElement = function(element, isHorzScrollable, isVertScrollable) {
    isHorzScrollable = ASPx.IsExists(isHorzScrollable) ? isHorzScrollable : true;
    isVertScrollable = ASPx.IsExists(isVertScrollable) ? isVertScrollable : true;

    var style = ASPx.GetCurrentStyle(element);
    var overflowStyleNames = ["overflow"];
    if(isHorzScrollable)
        overflowStyleNames.push("overflowX");
    if(isVertScrollable)
        overflowStyleNames.push("overflowY");
    for(var i = 0; i < overflowStyleNames.length; i++)
        if(style[overflowStyleNames[i]] == "scroll" || style[overflowStyleNames[i]] == "auto")
            return true;
    return false;
};


ASPx.GetPreviousSibling = function(el) {
    if(el.previousElementSibling) {
        return el.previousElementSibling;
    } else {
        while(el = el.previousSibling) {
            if(el.nodeType === 1)
                return el;
        }
    }
};
ASPx.ElementMatchesSelector = (function (e) {
    return (function (matches) {
        return function (el, selector) { return !!el && !!selector && matches.call(el, selector); };
    })(e.matches || e.matchesSelector || e.webkitMatchesSelector || e.mozMatchesSelector || e.msMatchesSelector || e.oMatchesSelector);
})(Element.prototype);
ASPx.ElementHasCssClass = function(element, className) {
    //B220674
    try {
        var elementClasses;
        var classList = ASPx.GetClassNameList(element);
        if(!classList) {
            var elementClassName = ASPx.GetClassName(element);
            if(!elementClassName) {
                return false;
            }
            elementClasses = elementClassName.split(" ");
        }
        var classNames = className.split(" ");
        for(var i = classNames.length - 1; i >= 0; i--) {
            if(classList) {
                if(classList.indexOf(classNames[i]) === -1)
                    return false;
                continue;
            }
            if(Data.ArrayIndexOf(elementClasses, classNames[i]) < 0)
                return false;
        }
        return true;
    } catch(e) {
        return false;
    }
};
ASPx.ElementContainsCssClass = function(element, className) {
    //B187659
    try {
        var elementClassName = ASPx.GetClassName(element);
        if(!elementClassName) {
            return false;
        }
        return elementClassName.indexOf(className) != -1;
    } catch(e) {
        return false;
    }
};
ASPx.AddClassNameToElement = function (element, className) {
    if(!element || typeof(className) !== "string" ) return;
    className = className.trim();
    if(!ASPx.ElementHasCssClass(element, className) && className !== "") {
        var oldClassName = ASPx.GetClassName(element);
        ASPx.SetClassName(element, (oldClassName === "") ? className : oldClassName + " " + className);
    }
};
ASPx.RemoveClassNameFromElement = function(element, className) {
    if(!element) return;
    var elementClassName = ASPx.GetClassName(element);
    var updClassName = " " + elementClassName + " ";
    var newClassName = updClassName.replace(" " + className + " ", " ");
    if(updClassName.length != newClassName.length)
        ASPx.SetClassName(element, Str.Trim(newClassName));        
};
ASPx.RemoveClassNamesFromElement = function(element, classNames) {
    if(!element) return;
    for(var i = 0; i < classNames.length; i++) {
        var className = classNames[i];
        if(ASPx.Browser.IE && ASPx.Browser.Version < 10)
            ASPx.RemoveClassNameFromElement(element, className);
        else
            element.classList.remove(className);
    }
};
ASPx.ToggleClassNameToElement = function(element, className, toggleState) {
    if(!toggleState)
        ASPx.RemoveClassNameFromElement(element, className);
    if(toggleState && !ASPx.ElementHasCssClass(element, className))
        ASPx.AddClassNameToElement(element, className);
};
ASPx.GetClassNameList = function(element) {
    var result = [];
    if(element) {
        if(element.tagName === "svg") {
            result = ASPx.GetClassName(element).replace(/^\s+|\s+$/g, '').split(/\s+/);
        }
        else {
            result = element.classList ? [].slice.call(element.classList) : ASPx.GetClassName(element).replace(/^\s+|\s+$/g, '').split(/\s+/);
        }
    }
    return result;
};
ASPx.GetClassName = function(element) {
    var result = "";
    if(element) {
        if(element.tagName === "svg") {
            result = element.className.baseVal;
        }
        else {
            result = element.className ? element.className : "";
        }
    }
    return result;
};
ASPx.SetClassName = function(element, className) {
    if(element.tagName === "svg") {
        element.className.baseVal = Str.Trim(className);
    }
    else {
        element.className = Str.Trim(className);
    }
};
ASPx.GetElementOffsetWidth = function(element) {
    if(element.tagName === "svg") {
        return element.getBoundingClientRect().width;
    }
    else {
        return element.offsetWidth;
    }
};

ASPx.GetElementOffsetHeight = function(element) {
    if(element.tagName === "svg") {
        return element.getBoundingClientRect().height;
    }
    else {
        return element.offsetHeight;
    }
};
function nodeListToArray(nodeList, filter) {
    var result = [];
    for(var i = 0, element; element = nodeList[i]; i++) {
        if(filter && !filter(element))
            continue;

        result.push(element);
    }
    return result;
}
ASPx.NodeListToArray = nodeListToArray;
function getItemByIndex(collection, index) {
    if(!index) index = 0;
    if(collection != null && collection.length > index)
        return collection[index];
    return null;
}

ASPx.GetChildNodesByQuerySelector = function (parent, selector) {
    return nodeListToArray(parent.querySelectorAll(selector), function (el) { return el.parentNode === parent; });
};

ASPx.GetChildNodesByClassName = function(parent, className) {
    if(!parent) return [];
    if(parent.querySelectorAll) {
        var children = parent.querySelectorAll('.' + className);

        return nodeListToArray(children, function(element) { 
            return element.parentNode === parent;
        });
    }
    return ASPx.GetChildNodes(parent, function(elem) { return elem.className && ASPx.ElementHasCssClass(elem, className); });
};

ASPx.GetChildNodesByPartialClassName = function(element, className) {
    return ASPx.GetChildElementNodesByPredicate(element,
        function(child) {
            return ASPx.ElementContainsCssClass(child, className);
        });
};

ASPx.GetChildByPartialClassName = function(element, className, index) {
    if(element != null){                
        var collection = ASPx.GetChildNodesByPartialClassName(element, className);
        return getItemByIndex(collection, index);
    }
    return null;
};

ASPx.GetChildByClassName = function(element, className, index) {
    if(element != null){                
        var collection = ASPx.GetChildNodesByClassName(element, className);
        return getItemByIndex(collection, index);
    }
    return null;
};
ASPx.GetNodesByPartialClassName = function(element, className) {
    if(element.querySelectorAll) {
        var list = element.querySelectorAll('*[class*=' + className + ']');
        return nodeListToArray(list);
    }
    var collection = element.all || element.getElementsByTagName('*');
    var ret = [ ];
    if(collection != null) {
        for(var i = 0; i < collection.length; i ++) {
            if(ASPx.ElementContainsCssClass(collection[i], className))
                ret.push(collection[i]);
        }
    }
    return ret;
};
ASPx.GetNodesByClassName = function(parent, className) {
    if(parent.querySelectorAll) {
        var children = parent.querySelectorAll('.' + className);
        return nodeListToArray(children);
    }

    return ASPx.GetNodes(parent, function(elem) { return elem.className && ASPx.ElementHasCssClass(elem, className); });
};
ASPx.GetNodeByClassName = function(element, className, index) {
    if(element != null){                
        var collection = ASPx.GetNodesByClassName(element, className);
        return getItemByIndex(collection, index);
    }
    return null;
};
ASPx.GetChildById = function(element, id) {
    if(element.all) {
        var child = element.all[id];
        if(!child) {
            child = element.all(id); //fix id starts with digit Q506841
        	if(!child)
                return Browser.IE ? document.getElementById(id) : null; //fix id contain "-" Q524740
		} 
		if(!ASPx.IsExists(child.length)) // fix two element with the same name and id
            return child;
        else
            return ASPx.GetElementById(id);
    }
    else
        return ASPx.GetElementById(id);
};
ASPx.GetNodesByPartialId = function(element, partialName, list) {
    if(element.id && element.id.indexOf(partialName) > -1) 
        list.push(element);

    if(element.childNodes) {
        for(var i = 0; i < element.childNodes.length; i ++) 
            ASPx.GetNodesByPartialId(element.childNodes[i], partialName, list);
    }
};
ASPx.GetNodesByTagName = function(element, tagName) {
    var tagNameToUpper = tagName.toUpperCase();
    var result = null;
    if(element) {
        if(element.getElementsByTagName) {
            result = element.getElementsByTagName(tagNameToUpper);
            if(result.length === 0) {
                result = element.getElementsByTagName(tagName);
            }
        }
        else if(element.all && element.all.tags !== undefined)
            result = Browser.Netscape ? element.all.tags[tagNameToUpper] : element.all.tags(tagNameToUpper);
    }
    return result;
};
ASPx.GetNodeByTagName = function(element, tagName, index) {
    if(element != null){                
        var collection = ASPx.GetNodesByTagName(element, tagName);
        return getItemByIndex(collection, index);
    }
    return null;
};
ASPx.GetChildNodesByTagName = function(parent, tagName) {
    return ASPx.GetChildNodes(parent, function (child) { return child.tagName === tagName; });
};
ASPx.GetChildByTagName = function(element, tagName, index) {
    if(element != null){                
        var collection = ASPx.GetChildNodesByTagName(element, tagName);
        return getItemByIndex(collection, index);
    }
    return null;
};
ASPx.RetrieveByPredicate = function(scourceCollection, predicate) {
    var result = [];
    for(var i = 0; i < scourceCollection.length; i++) {
        var element = scourceCollection[i];
        if(!predicate || predicate(element)) 
            result.push(element);
    }
    return result;
};
ASPx.GetChildNodes = function(parent, predicate) {
    return ASPx.RetrieveByPredicate(parent.childNodes, predicate);
};
ASPx.GetNodes = function(parent, predicate) {
    var c = parent.all || parent.getElementsByTagName('*');
    return ASPx.RetrieveByPredicate(c, predicate);
};


ASPx.GetChildElementNodes = function(parent) {
    if(!parent) return null;
    return ASPx.GetChildNodes(parent, function(e) { return e.nodeType == 1; });
};
ASPx.GetChildElementNodesByPredicate = function(parent, predicate) {
    if(!parent) return null;
    if(!predicate) return ASPx.GetChildElementNodes(parent);
    return ASPx.GetChildNodes(parent, function(e) { return e.nodeType == 1 && predicate(e); });
};
ASPx.GetTextNode = function(element, index) {
    if(element != null){
        var collection = [ ];
        ASPx.GetTextNodes(element, collection);
        return getItemByIndex(collection, index);
    }
    return null;
};
ASPx.GetTextNodes = function(element, collection) {
    if(element.tagName === "svg")
        return;
    for(var i = 0; i < element.childNodes.length; i ++){
        var childNode = element.childNodes[i];
        if(ASPx.IsExists(childNode.nodeValue))
            collection.push(childNode);
        ASPx.GetTextNodes(childNode, collection);
    }
};
ASPx.GetNormalizedTextNode = function(element, index) {
    var textNode = ASPx.GetTextNode(element, index);
    if(textNode != null)
        ASPx.MergeAdjacentTextNodes(textNode);
    return textNode;
};
ASPx.MergeAdjacentTextNodes = function(firstTextNode) {
    if(!ASPx.IsExists(firstTextNode.nodeValue))
        return;
    var textNode = firstTextNode;
    while(textNode.nextSibling && ASPx.IsExists(textNode.nextSibling.nodeValue)) {
        textNode.nodeValue += textNode.nextSibling.nodeValue;
        textNode.parentNode.removeChild(textNode.nextSibling);
    }
};

ASPx.GetElementDocument = function(element) {
    return element.document || element.ownerDocument;
};
ASPx.RemoveElement = function(element) {
    if(element && element.parentNode)
        element.parentNode.removeChild(element);
};
ASPx.ReplaceTagName = function(element, newTagName, cloneChilds) {
    if(element.nodeType != 1)
        return null;
    if(element.nodeName == newTagName)
        return element;
    cloneChilds = cloneChilds !== undefined ? cloneChilds : true;

    var doc = element.ownerDocument;
    var newElem = doc.createElement(newTagName);
    Attr.CopyAllAttributes(element, newElem);
    
    if(cloneChilds) {
        for(var i = 0; i < element.childNodes.length; i++)
            newElem.appendChild(element.childNodes[i].cloneNode(true));
    }
    else {
        for(var child; child = element.firstChild; )
            newElem.appendChild(child);
    }
    element.parentNode.replaceChild(newElem, element);
    return newElem;
};
ASPx.RemoveOuterTags = function(element) {
    if(ASPx.Browser.IE) {
        element.insertAdjacentHTML( 'beforeBegin', element.innerHTML ) ;
        ASPx.RemoveElement(element);
    } else {
        var docFragment = element.ownerDocument.createDocumentFragment();
        for(var i = 0; i < element.childNodes.length; i++)
            docFragment.appendChild(element.childNodes[i].cloneNode(true));
        element.parentNode.replaceChild(docFragment, element);
    }
};
ASPx.WrapElementInNewElement = function(element, newElementTagName) {    
    var wrapElement = null;
    if(Browser.IE) {
        var wrapElement = element.ownerDocument.createElement(newElementTagName);
        wrapElement.appendChild(element.cloneNode(true));
        element.parentNode.insertBefore(wrapElement, element);
        element.parentNode.removeChild(element);
    } else {
        var docFragment = element.ownerDocument.createDocumentFragment();
        wrapElement = element.ownerDocument.createElement(newElementTagName);
        docFragment.appendChild(wrapElement);
        wrapElement.appendChild(element.cloneNode(true));
        element.parentNode.replaceChild(docFragment, element);
    }
    return wrapElement;
};
ASPx.InsertElementAfter = function(newElement, targetElement) {
    var parentElem = targetElement.parentNode;
    
    if(parentElem.childNodes[parentElem.childNodes.length - 1] == targetElement)
		parentElem.appendChild(newElement);
    else if(newElement !== targetElement.nextSibling)
		parentElem.insertBefore(newElement, targetElement.nextSibling);
};

ASPx.SetElementOpacity = function(element, value) {
     var useOpacityStyle = !Browser.IE || Browser.Version > 8;
     if(useOpacityStyle){
         element.style.opacity = value;
     } else {
         if(typeof(element.filters) === "object" && element.filters["DXImageTransform.Microsoft.Alpha"])
             element.filters.item("DXImageTransform.Microsoft.Alpha").Opacity = value*100;
         else
            element.style.filter = "alpha(opacity=" + (value * 100) + ")";
     }
};
ASPx.GetElementOpacity = function(element) {
    var useOpacityStyle = !Browser.IE || Browser.Version > 8;
    if(useOpacityStyle)
        return parseFloat(ASPx.GetCurrentStyle(element).opacity);
    else {
        if(typeof(element.filters) === "object" && element.filters["DXImageTransform.Microsoft.Alpha"]){
            return element.filters.item("DXImageTransform.Microsoft.Alpha").Opacity / 100;
        } else {
            var alphaValue = ASPx.GetCurrentStyle(element).filter;
            var value = alphaValue.replace("alpha(opacity=", "");
            value = value.replace(")", "");
            return parseInt(value) / 100;
        }
        return 100;
    }
};

ASPx.HiddenChangable = "dx-hc";
ASPx.DefaultDisplayNoneSelectors = [ "dxmodalSys" ];
ASPx.DefaultDisplaySelectors = ["show"];
function getIsDefaultDisplayNone(element) {
    for(var i = 0; i < ASPx.DefaultDisplayNoneSelectors.length; i++) {
        if(ASPx.ElementHasCssClass(element, ASPx.DefaultDisplayNoneSelectors[i]))
            return true;
    }
    return false;
}
ASPx.GetElementDisplay = function(element, isCurrentStyle) {
    if(isCurrentStyle)
        return ASPx.GetCurrentStyle(element).display != "none";
    if(getIsDefaultDisplayNone(element))
        return element.style.display != "none" && element.style.display != "" || ASPx.DefaultDisplaySelectors.some(function(s) { return ASPx.ElementHasCssClass(element, s); });
    return element.style.display != "none" && !ASPx.ElementHasCssClass(element, ASPx.HiddenChangable);
};
ASPx.SetElementDisplay = function(element, value) {
    if(!element) return;

    if(ASPx.ElementHasCssClass(element, ASPx.HiddenChangable))
        ASPx.RemoveClassNameFromElement(element, ASPx.HiddenChangable);

    if(typeof(value) === "string")
        element.style.display = value;
    else if(getIsDefaultDisplayNone(element))
        element.style.display = value ? (element.tagName === "TABLE" ? "table" : "block") : "";
    else if(!value)
        element.style.display = "none";
    else
        element.style.display = "";
};
ASPx.GetElementVisibility = function(element, isCurrentStyle) {
    if(isCurrentStyle)
        return ASPx.GetCurrentStyle(element).visibility != "hidden";
    return element.style.visibility != "hidden";
};
ASPx.SetElementVisibility = function(element, value) {
    if(!element) return;
    if(typeof(value) === "string")
        element.style.visibility = value;
    else
        element.style.visibility = value ? "visible" : "hidden";
};
ASPx.IsElementVisible = function(element, isCurrentStyle) {
    while(element && element.tagName != "BODY") {
        if(!ASPx.GetElementDisplay(element, isCurrentStyle) || (!ASPx.GetElementVisibility(element, isCurrentStyle) && !Attr.IsExistsAttribute(element, "errorFrame")))
           return false;
        element = element.parentNode;
    }
    return true;
};
ASPx.IsElementDisplayed = function(element) {
    while(element && element.tagName != "BODY") {
        if(!ASPx.GetElementDisplay(element))
           return false;
        element = element.parentNode;
    }
    return true;
};

ASPx.GetElementInitializedFlag = function(element) {
    return element["dxinit"];
};
ASPx.SetElementInitializedFlag = function(element) {
    element["dxinit"] = true;
};

ASPx.AddStyleSheetLinkToDocument = function(doc, linkUrl) {
    var newLink = createStyleLink(doc, linkUrl);
    var head = ASPx.GetHeadElementOrCreateIfNotExist(doc);
    head.appendChild(newLink);
    return newLink;
};
ASPx.GetHeadElementOrCreateIfNotExist = function(doc) {
    var elements = ASPx.GetNodesByTagName(doc, "head");
    var head = null;
    // The Head element might not exist in the Safari browser, if the document content 
    // was created via the document.write() method. In this situation, we must create it.
    if(elements.length == 0) {
        head = doc.createElement("head");
        head.visibility = "hidden";
        doc.insertBefore(head, doc.body);
    } else
        head = elements[0];
    return head;
};
function createStyleLink(doc, url) {
    var newLink = doc.createElement("link");
    Attr.SetAttribute(newLink, "href", url);
    Attr.SetAttribute(newLink, "rel", "stylesheet");
    Attr.AppendStyleType(newLink);
    return newLink;
}
ASPx.GetCurrentStyle = function(element) {
    if(document.defaultView && document.defaultView.getComputedStyle) { 
        var result = document.defaultView.getComputedStyle(element, null);
        if(!result && Browser.Firefox && window.frameElement) {
            var changes = [];
            var curElement = window.frameElement;
            while(!(result = document.defaultView.getComputedStyle(element, null))) {
                changes.push([curElement, curElement.style.display]);
                ASPx.SetStylesCore(curElement, "display", "block", true);
                curElement = curElement.tagName == "BODY" ? curElement.ownerDocument.defaultView.frameElement : curElement.parentNode;
            }
            result = ASPx.CloneObject(result);
            for(var ch, i = 0; ch = changes[i]; i++)
                ASPx.SetStylesCore(ch[0], "display", ch[1]);
            var dummy = document.body.offsetWidth; //T334387
        }
        if(Browser.Firefox && Browser.MajorVersion >= 62 && window.frameElement && result.length === 0) { //T689462
            result = ASPx.CloneObject(result);
            result.display = element.style.display;
        }
        return result;
    }
    return window.getComputedStyle(element, null);
};
ASPx.CreateStyleSheetInDocument = function(doc) {
    if(doc.createStyleSheet) {
        try {
            return doc.createStyleSheet();
        }
        catch(e) {
            var message = "The CSS link limit (31) has been exceeded. Please enable CSS merging or reduce the number of CSS files on the page. For details, see http://www.devexpress.com/Support/Center/p/K18487.aspx.";
            throw new Error(message);
        }
    }
    else {
        var styleSheet = doc.createElement("STYLE");
        ASPx.GetNodeByTagName(doc, "HEAD", 0).appendChild(styleSheet);
        return styleSheet.sheet;
    }
};

ASPx.currentStyleSheet = null;
ASPx.GetCurrentStyleSheet = function() {
    if(!ASPx.currentStyleSheet)
        ASPx.currentStyleSheet = ASPx.CreateStyleSheetInDocument(document);
    return ASPx.currentStyleSheet;
};
function getStyleSheetRules(styleSheet){
    try {
        if (styleSheet.href && styleSheet.href.indexOf("file:///") === 0)
            return null;
        return Browser.IE && Browser.Version == 8 ? styleSheet.rules : styleSheet.cssRules;
    }
    catch(e) {
        return null;
    }
}
ASPx.cachedCssRules = { };
ASPx.GetStyleSheetRules = function (className, stylesStorageDocument) {
    if(ASPx.cachedCssRules[className]) {
        if(ASPx.cachedCssRules[className] != ASPx.EmptyObject)
            return ASPx.cachedCssRules[className];
        return null;
    }
    var result = iterateStyleSheetRules(stylesStorageDocument, function(rule) {
        if(rule.selectorText == "." + className){
            ASPx.cachedCssRules[className] = rule;
            return rule;
        }
    });
    if(ASPx.IsExists(result))
        return result;
    ASPx.cachedCssRules[className] = ASPx.EmptyObject;
    return null;
};
function iterateStyleSheetRules(stylesStorageDocument, callback) {
    var doc = stylesStorageDocument || document;
    for(var i = 0; i < doc.styleSheets.length; i ++){
        var styleSheet = doc.styleSheets[i];
        var rules = getStyleSheetRules(styleSheet);
        if(rules != null){
            for(var j = 0; j < rules.length; j ++) {
                var result = callback(rules[j]);
                if(result !== undefined)
                    return result;
            }
        }
    }
}
ASPx.ProcessStyleSheetRules = function(prefix, callback) {
    iterateStyleSheetRules(null, function(rule) {
        if(!!rule.selectorText && rule.selectorText.indexOf(prefix) === 0) {
            var name = rule.selectorText.substring(prefix.length);
            var result = callback(name, rule.style, rule);
            if(result !== undefined)
                return result;
        }
    });
};
ASPx.ClearCachedCssRules = function(){
    ASPx.cachedCssRules = { };
};

var styleCount = 0;
var styleNameCache = { };
ASPx.CreateImportantStyleRule = function(styleSheet, cssText, postfix, prefix) {
    styleSheet = styleSheet || ASPx.GetCurrentStyleSheet();
    var cacheKey = (postfix ? postfix + "||" : "") + cssText + (prefix ? "||" + prefix : "");
    if(styleNameCache[cacheKey])
		return styleNameCache[cacheKey];
    prefix = prefix ? prefix + " " : "";
	var className = "dxh" + styleCount + (postfix ? postfix : "");
	ASPx.AddStyleSheetRule(styleSheet, prefix + "." + className, ASPx.CreateImportantCssText(cssText));
	styleCount++;
	styleNameCache[cacheKey] = className;
	return className;	
};
ASPx.CreateImportantCssText = function(cssText) {
    var newText = "";
    var hasEncodedSemicolon = cssText.indexOf(ASPx.StyleValueEncodedSemicolon) > -1;
	var attributes = cssText.split(";");
	for(var i = 0; i < attributes.length; i++) {
        var rule = attributes[i];
		if(rule != "")
            newText += ASPx.CreateImportantCssRule(rule, hasEncodedSemicolon);
	}
    return newText;
};
ASPx.CreateImportantCssRule = function(rule, hasEncodedSemicolon) {
    var result = rule;
    if(hasEncodedSemicolon) {
        var regex = new RegExp(ASPx.StyleValueEncodedSemicolon, "g");
        result = result.replace(regex, ";");
    }
    result = result + " !important;";
    return result;
};
ASPx.AddStyleSheetRule = function(styleSheet, selector, cssText){
    if(!cssText) return;
    var index = styleSheet.cssRules.length;
    styleSheet.insertRule(selector + " { " + cssText + " }", index);
    return styleSheet.cssRules[index];
};

ASPx.GetPointerCursor = function() {
    return "pointer";
};
ASPx.SetPointerCursor = function(element) {
    if(element.style.cursor == "")
        element.style.cursor = ASPx.GetPointerCursor();
};

ASPx.SetElementFloat = function(element, value) {
    if(ASPx.IsExists(element.style.cssFloat))
        element.style.cssFloat = value;
    else if(ASPx.IsExists(element.style.styleFloat))
        element.style.styleFloat = value;
    else
        Attr.SetAttribute(element.style, "float", value);
};
ASPx.GetElementFloat = function(element) {
    var currentStyle = ASPx.GetCurrentStyle(element);
    
    if(ASPx.IsExists(currentStyle.cssFloat))
        return currentStyle.cssFloat;
    if(ASPx.IsExists(currentStyle.styleFloat))
        return currentStyle.styleFloat;
    return Attr.GetAttribute(currentStyle, "float");
};

function getElementDirection(element) {
    return ASPx.GetCurrentStyle(element).direction;
}
ASPx.IsElementRightToLeft = function(element) {
    return getElementDirection(element) == "rtl";
};

ASPx.AdjustVerticalMarginsInContainer = function(container) {
    var containerBorderAndPaddings = ASPx.GetTopBottomBordersAndPaddingsSummaryValue(container);
    var flowElements = [], floatElements = [], floatTextElements = [];
    var maxHeight = 0, maxFlowHeight = 0;
    
    for(var i = 0; i < container.childNodes.length; i++) {
        var element = container.childNodes[i];
        if(!element.offsetHeight) continue;

        ASPx.ClearVerticalMargins(element);
    }
    for(var i = 0; i < container.childNodes.length; i++) {
        var element = container.childNodes[i];
        if(!element.offsetHeight) continue;

        var float = ASPx.GetElementFloat(element);
        var isFloat = (float === "left" || float === "right");
        if(isFloat)
            floatElements.push(element);
        else {
            flowElements.push(element);
            if(element.tagName !== "IMG"){
                if(!ASPx.IsTextWrapped(element))
                    element.style.verticalAlign = 'baseline'; // prevent extra height
                floatTextElements.push(element);
            }
            if(element.tagName === "DIV")
                Attr.ChangeStyleAttribute(element, "float", "left"); // prevent extra height
        }
        if(element.offsetHeight > maxHeight) 
            maxHeight = element.offsetHeight;
        if(!isFloat && element.offsetHeight > maxFlowHeight) 
            maxFlowHeight = element.offsetHeight;
    }

    for(var i = 0; i < flowElements.length; i++) 
        Attr.RestoreStyleAttribute(flowElements[i], "float");
    
    var containerBorderAndPaddings = ASPx.GetTopBottomBordersAndPaddingsSummaryValue(container);
    var containerHeight = container.offsetHeight - containerBorderAndPaddings;
    if(maxHeight == containerHeight) {
        var verticalAlign = ASPx.GetCurrentStyle(container).verticalAlign;
        for(var i = 0; i < floatTextElements.length; i++)
            floatTextElements[i].style.verticalAlign = '';
        containerHeight = container.offsetHeight - containerBorderAndPaddings;

        for(var i = 0; i < floatElements.length; i++)
            adjustVerticalMarginsCore(floatElements[i], containerHeight, verticalAlign, true);
        for(var i = 0; i < flowElements.length; i++) {
            if(maxFlowHeight != maxHeight)
                adjustVerticalMarginsCore(flowElements[i], containerHeight, verticalAlign);
        }
    }
};
ASPx.AdjustVerticalMargins = function(element) {
    ASPx.ClearVerticalMargins(element);

    var parentElement = element.parentNode;
    var parentHeight = parentElement.getBoundingClientRect().height - ASPx.GetTopBottomBordersAndPaddingsSummaryValue(parentElement);
    adjustVerticalMarginsCore(element, parentHeight, ASPx.GetCurrentStyle(parentElement).verticalAlign);
};
function adjustVerticalMarginsCore(element, parentHeight, verticalAlign, toBottom) {
    var marginTop;
    if(verticalAlign == "top")
        marginTop = 0;
    else if(verticalAlign == "bottom")
        marginTop = parentHeight - element.getBoundingClientRect().height;
    else
        marginTop = (parentHeight - element.getBoundingClientRect().height) / 2;
    if(marginTop !== 0){
        element.style.marginTop = marginTop + "px";
    }
}
ASPx.ClearVerticalMargins = function(element) {
    element.style.marginTop = "";
    element.style.marginBottom = "";
};
ASPx.AdjustHeightInContainer = function(container) {
    var height = container.offsetHeight - ASPx.GetTopBottomBordersAndPaddingsSummaryValue(container);

    for(var i = 0; i < container.childNodes.length; i++) {
        var element = container.childNodes[i];
        if(!element.offsetHeight) continue;

        ASPx.ClearHeight(element);
    }

    var elements = [];
    var childrenHeight = 0;
    for(var i = 0; i < container.childNodes.length; i++) {
        var element = container.childNodes[i];
        if(!element.offsetHeight) continue;

        childrenHeight += element.offsetHeight + ASPx.GetTopBottomMargins(element);
        elements.push(element);
    }
    if(elements.length > 0 && childrenHeight < height) {
        var correctedHeight = 0;
        for(var i = 0; i < elements.length; i++) {
            var elementHeight = 0;
            if(i < elements.length - 1){
                var elementHeight = Math.floor(height / elements.length);
                correctedHeight += elementHeight;
            }
            else{
                var elementHeight = height - correctedHeight;
                if(elementHeight < 0) elementHeight = 0;
            }
            adjustHeightCore(elements[i], elementHeight);
        }
    }
};
ASPx.AdjustHeight = function(element) {
    ASPx.ClearHeight(element);

    var parentElement = element.parentNode;
    var height = parentElement.getBoundingClientRect().height - ASPx.GetTopBottomBordersAndPaddingsSummaryValue(parentElement);
    adjustHeightCore(element, height);
};
function adjustHeightCore(element, height) {
    var height = height - ASPx.GetTopBottomBordersAndPaddingsSummaryValue(element);
    if(height < 0) height = 0;
    element.style.height = height + "px";
}
ASPx.ClearHeight = function(element) {
    element.style.height = "";
};
ASPx.ShrinkWrappedTextInContainer = function(container) {
    if(!container) return;
    
    for(var i = 0; i < container.childNodes.length; i++){
        var child = container.childNodes[i];
        if(child.style && ASPx.IsTextWrapped(child)) {
            Attr.ChangeStyleAttribute(child, "width", "1px");
            child.shrinkedTextContainer = true;
        }
    }
};
ASPx.AdjustWrappedTextInContainer = function(container) {
    if(!container) return;
    
    var textContainer, leftWidth = 0, rightWidth = 0;
    for(var i = 0; i < container.childNodes.length; i++){
        var child = container.childNodes[i];

        if(child.tagName === "BR")
            return;
        if(!child.tagName)
            continue;
        if(child.tagName !== "IMG"){
            textContainer = child;
            if(ASPx.IsTextWrapped(textContainer)){
                if(!textContainer.shrinkedTextContainer)
                    textContainer.style.width = "";
                textContainer.style.marginRight = "";
            }
        }
        else {
            if(ASPx.GetElementOffsetWidth(child)=== 0)
                /*jshint -W083 */
                Evt.AttachEventToElement(child, "load", function(evt) { ASPx.AdjustWrappedTextInContainer(container); });
                /*jshint +W083 */
            else {
                var width = ASPx.GetElementOffsetWidth(child) + ASPx.GetLeftRightMargins(child);
                if(textContainer)
                    rightWidth += width;
                else
                    leftWidth += width;
            }
        }
    }
    
    if(textContainer && ASPx.IsTextWrapped(textContainer)) {
        var containerWidth = ASPx.GetElementOffsetWidth(container) - ASPx.GetLeftRightBordersAndPaddingsSummaryValue(container);
        if(textContainer.shrinkedTextContainer) {
            Attr.RestoreStyleAttribute(textContainer, "width");
            Attr.ChangeStyleAttribute(container, "width", containerWidth + "px");
        }
        if(ASPx.GetElementOffsetWidth(textContainer) + leftWidth + rightWidth >= containerWidth) {
             if(rightWidth > 0 && !textContainer.shrinkedTextContainer)
                textContainer.style.width = (containerWidth - rightWidth) + "px";
            else if(leftWidth > 0){
                if(ASPx.IsElementRightToLeft(container))
                    textContainer.style.marginLeft = leftWidth + "px";
                else
                    textContainer.style.marginRight = leftWidth + "px";
            }
        }
    }
};
ASPx.IsTextWrapped = function(element) {
    return element && ASPx.GetCurrentStyle(element).whiteSpace !== "nowrap";
};

ASPx.IsValidPosition = function(pos){
    return pos != ASPx.InvalidPosition && pos != -ASPx.InvalidPosition;
};
ASPx.getSpriteMainElement = function(element) {
    var cssClassMarker = "dx-acc";
    if(ASPx.ElementContainsCssClass(element, cssClassMarker))
        return element;
    if(element.parentNode && ASPx.ElementContainsCssClass(element.parentNode, cssClassMarker))
        return element.parentNode;
    return element;
};
ASPx.GetAbsoluteX = function(curEl){
    return ASPx.GetAbsolutePositionX(curEl);
};
ASPx.GetAbsoluteY = function(curEl){
    return ASPx.GetAbsolutePositionY(curEl);
};
ASPx.SetAbsoluteX = function(element, x){
    element.style.left = ASPx.PrepareClientPosForElement(x, element, true) + "px";
};
ASPx.SetAbsoluteY = function(element, y){
    element.style.top = ASPx.PrepareClientPosForElement(y, element, false) + "px";
};
ASPx.GetAbsolutePositionX = function(element){
    if(Browser.IE)
        return getAbsolutePositionX_IE(element);
    else if(Browser.Firefox && Browser.Version >= 3)
        return getAbsolutePositionX_FF3(element);
    else if(Browser.Opera)
        return getAbsolutePositionX_Opera(element);
    else if(Browser.NetscapeFamily && (!Browser.Firefox || Browser.Version < 3))
        return getAbsolutePositionX_NS(element);
    else if(Browser.WebKitFamily || Browser.Edge)
        return getAbsolutePositionX_FF3(element);
    else
        return getAbsolutePositionX_Other(element);
};
function getAbsolutePositionX_Opera(curEl){
    var isFirstCycle = true;
    var pos = getAbsoluteScrollOffset_OperaFF(curEl, true);
    while(curEl != null) {
        pos += curEl.offsetLeft;
        if(!isFirstCycle)
            pos -= curEl.scrollLeft;
        curEl = curEl.offsetParent;
        isFirstCycle = false;
    }
    pos += document.body.scrollLeft;
    return pos;
}
function getAbsolutePositionX_IE(element){
    if(element == null || Browser.IE && element.parentNode == null) return 0; // B96664
    return element.getBoundingClientRect().left + ASPx.GetDocumentScrollLeft();
}
function getAbsolutePositionX_FF3(element){
    if(element == null) return 0;
    var x = element.getBoundingClientRect().left + ASPx.GetDocumentScrollLeft();
    return x;
}
function getAbsolutePositionX_NS(curEl){
    var pos = getAbsoluteScrollOffset_OperaFF(curEl, true);
    var isFirstCycle = true;
    while(curEl != null) {
        pos += curEl.offsetLeft;
        if(!isFirstCycle && curEl.offsetParent != null)
            pos -= curEl.scrollLeft;
        if(!isFirstCycle && Browser.Firefox){
            var style = ASPx.GetCurrentStyle(curEl);
            if(curEl.tagName == "DIV" && style.overflow != "visible")
                pos += ASPx.PxToInt(style.borderLeftWidth);
        }
        isFirstCycle = false;
        curEl = curEl.offsetParent;
    }
    return pos;
}
//function getAbsolutePositionX_Safari(curEl){
//    var pos = getAbsoluteScrollOffset_WebKit(curEl, true);
//	var isSafariVerNonLessThan3OrChrome = Browser.Safari && Browser.Version >= 3 || Browser.Chrome;
//    if(curEl != null){
//        var isFirstCycle = true;
//        if(isSafariVerNonLessThan3OrChrome && curEl.tagName == "TD") {
//            pos += curEl.offsetLeft;
//            curEl = curEl.offsetParent;
//            isFirstCycle = false;
//        }
//        var hasNonStaticElement = false;
//        while (curEl != null) {
//            pos += curEl.offsetLeft;

//            var style = ASPx.GetCurrentStyle(curEl);
//            var isNonStatic = style.position !== "" && style.position !== "static";
//            if(isNonStatic)
//                hasNonStaticElement = true;
//            var safariDisplayTable = Browser.Safari && Browser.Version >= 8 && style.display === "table";
//            var posDiv = curEl.tagName == "DIV" && isNonStatic && !safariDisplayTable;
//            if(!isFirstCycle && (curEl.tagName == "TD" || curEl.tagName == "TABLE" || posDiv))
//                pos += curEl.clientLeft;
//            isFirstCycle = false;
//            curEl = curEl.offsetParent;
//        }
//        if(!hasNonStaticElement && (document.documentElement.style.position === "" || document.documentElement.style.position === "static"))
//            pos += document.documentElement.offsetLeft;
//    }
//    return pos;
//}
function getAbsolutePositionX_Other(curEl){
    var pos = 0;
    var isFirstCycle = true;
    while(curEl != null) {
        pos += curEl.offsetLeft;
        if(!isFirstCycle && curEl.offsetParent != null)
            pos -= curEl.scrollLeft;
        isFirstCycle = false;
        curEl = curEl.offsetParent;
    }
    return pos;
}
ASPx.GetAbsolutePositionY = function(element){
    if(Browser.IE)
        return getAbsolutePositionY_IE(element);
    else if(Browser.Firefox && Browser.Version >= 3)
        return getAbsolutePositionY_FF3(element);
    else if(Browser.Opera)
        return getAbsolutePositionY_Opera(element);
    else if(Browser.NetscapeFamily && (!Browser.Firefox || Browser.Version < 3))
        return getAbsolutePositionY_NS(element);
    else if(Browser.WebKitFamily || Browser.Edge)
        return getAbsolutePositionY_FF3(element);
    else
        return getAbsolutePositionY_Other(element);
};
function getAbsolutePositionY_Opera(curEl){
    var isFirstCycle = true;
    if(curEl && curEl.tagName == "TR" && curEl.cells.length > 0)
        curEl = curEl.cells[0];
    var pos = getAbsoluteScrollOffset_OperaFF(curEl, false);
    while(curEl != null) {
        pos += curEl.offsetTop;
        if(!isFirstCycle)
            pos -= curEl.scrollTop;
        curEl = curEl.offsetParent;
        isFirstCycle = false;
    }
    pos += document.body.scrollTop;
    return pos;
}
function getAbsolutePositionY_IE(element){
    if(element == null || Browser.IE && element.parentNode == null) return 0; // B96664
    return element.getBoundingClientRect().top + ASPx.GetDocumentScrollTop();
}
function getAbsolutePositionY_FF3(element){
    if(element == null) return 0;
    var y = element.getBoundingClientRect().top + ASPx.GetDocumentScrollTop();
    return y;
}
function getAbsolutePositionY_NS(curEl){
    var pos = getAbsoluteScrollOffset_OperaFF(curEl, false);
    var isFirstCycle = true;
    while(curEl != null) {
        pos += curEl.offsetTop;
        if(!isFirstCycle && curEl.offsetParent != null)
            pos -= curEl.scrollTop;
        if(!isFirstCycle && Browser.Firefox){
            var style = ASPx.GetCurrentStyle(curEl);
            if(curEl.tagName == "DIV" && style.overflow != "visible")
                pos += ASPx.PxToInt(style.borderTopWidth);
        }
        isFirstCycle = false;
        curEl = curEl.offsetParent;
    }
    return pos;
}
//var WebKit3TDRealInfo = {
//    GetOffsetTop: function(tdElement){
//        switch(ASPx.GetCurrentStyle(tdElement).verticalAlign){
//            case "middle":
//                return Math.round(tdElement.offsetTop - (tdElement.offsetHeight - tdElement.clientHeight )/2 + tdElement.clientTop);
//            case "bottom":
//                return tdElement.offsetTop - tdElement.offsetHeight + tdElement.clientHeight + tdElement.clientTop;
//        }
//        return tdElement.offsetTop;
//    },
//    GetClientHeight: function(tdElement){
//        var valign = ASPx.GetCurrentStyle(tdElement).verticalAlign;
//        switch(valign){
//            case "middle":
//                return tdElement.clientHeight + tdElement.offsetTop * 2;
//            case "top":
//                return tdElement.offsetHeight - tdElement.clientTop * 2;
//            case "bottom":
//                return tdElement.clientHeight + tdElement.offsetTop;
//        }
//        return tdElement.clientHeight;
//    }
//};
//function getAbsolutePositionY_Safari(curEl){
//    var pos = getAbsoluteScrollOffset_WebKit(curEl, false);
//    var isSafariVerNonLessThan3OrChrome = Browser.Safari && Browser.Version >= 3 || Browser.Chrome;
//    if(curEl != null){
//        var isFirstCycle = true;
//        if(isSafariVerNonLessThan3OrChrome && curEl.tagName == "TD") {
//            pos += WebKit3TDRealInfo.GetOffsetTop(curEl);
//            curEl = curEl.offsetParent;
//            isFirstCycle = false;
//        }
//        var hasNonStaticElement = false;
//        while (curEl != null) {
//            pos += curEl.offsetTop;

//            var style = ASPx.GetCurrentStyle(curEl);
//            var isNonStatic = style.position !== "" && style.position !== "static";
//            if(isNonStatic)
//                hasNonStaticElement = true;
//            var safariDisplayTable = Browser.Safari && Browser.Version >= 8 && style.display === "table";
//            var posDiv = curEl.tagName == "DIV" && isNonStatic && !safariDisplayTable;
//            if(!isFirstCycle && (curEl.tagName == "TD" || curEl.tagName == "TABLE" || posDiv))
//                pos += curEl.clientTop;
//            isFirstCycle = false;
//            curEl = curEl.offsetParent;
//        }
//        if(!hasNonStaticElement && (document.documentElement.style.position === "" || document.documentElement.style.position === "static"))
//            pos += document.documentElement.offsetTop;
//    }
//    return pos;
//}
// B91523
function getAbsoluteScrollOffset_OperaFF(curEl, isX) {
    var pos = 0;   
    var isFirstCycle = true;
    while(curEl != null) {
        if(curEl.tagName == "BODY")
            break;
        var style = ASPx.GetCurrentStyle(curEl);
        if(style.position == "absolute")
            break;
        if(!isFirstCycle && curEl.tagName == "DIV" && (style.position == "" || style.position == "static"))
            pos -= isX ? curEl.scrollLeft : curEl.scrollTop;
        curEl = curEl.parentNode;
        isFirstCycle = false;
    }
    return pos; 
}
//function getAbsoluteScrollOffset_WebKit(curEl, isX) {
//    var pos = 0;   
//    var isFirstCycle = true;
//    var step = 0;
//    var absoluteWasFoundAtStep = -1;
//    var isThereFixedParent = false;
//    while(curEl != null) {
//        if(curEl.tagName == "BODY")
//            break;
//        var style = ASPx.GetCurrentStyle(curEl);

//        var positionIsDefault = style.position == "" || style.position == "static";
//        var absoluteWasFoundAtPreviousStep = absoluteWasFoundAtStep >= 0 && absoluteWasFoundAtStep < step;
//        var canHaveScrolls = curEl.tagName == "DIV" || curEl.tagName == "SECTION" || curEl.tagName == "FORM";
//        if(!isFirstCycle && canHaveScrolls && (!positionIsDefault || !absoluteWasFoundAtPreviousStep))
//            pos -= isX ? curEl.scrollLeft : curEl.scrollTop;
        
//        if(style.position == "absolute")
//            absoluteWasFoundAtStep = step;
//        else if(style.position == "relative")
//            absoluteWasFoundAtStep = -1;
//        else if(style.position == "fixed")
//            isThereFixedParent = true;

//        curEl = curEl.parentNode;
//        isFirstCycle = false;
//        step ++;
//    }
//	if(isThereFixedParent)
//		pos += isX ? ASPx.GetDocumentScrollLeft() : ASPx.GetDocumentScrollTop();
//    return pos; 
//}
function getAbsolutePositionY_Other(curEl){
    var pos = 0;
    var isFirstCycle = true;
    while(curEl != null) {
        pos += curEl.offsetTop;
        if(!isFirstCycle && curEl.offsetParent != null)
            pos -= curEl.scrollTop;
        
        isFirstCycle = false;
        curEl = curEl.offsetParent;
    }
    return pos;
}

function createElementMock(element) {
    var div = document.createElement('DIV');
    div.style.top = "0px";
    div.style.left = "0px";
    div.visibility = "hidden";
    div.style.position = ASPx.GetCurrentStyle(element).position;
    return div;
}
ASPx.PrepareClientPosElementForOtherParent = function(pos, element, otherParent, isX) {
    if(element.parentNode == otherParent)
        return ASPx.PrepareClientPosForElement(pos, element, isX);
    var elementMock = createElementMock(element);
    otherParent.appendChild(elementMock); 
    var preparedPos = ASPx.PrepareClientPosForElement(pos, elementMock, isX);
    otherParent.removeChild(elementMock);
    return preparedPos;
};
ASPx.PrepareClientPosForElement = function(pos, element, isX) {
    pos -= ASPx.GetPositionElementOffset(element, isX);
    return pos;
};

function getExperimentalPositionOffset(element, isX) {
    var div = createElementMock(element);
    if(div.style.position == "static")
        div.style.position = "absolute";
    element.parentNode.appendChild(div); 
    var realPos = isX ? ASPx.GetAbsoluteX(div) : ASPx.GetAbsoluteY(div);
    element.parentNode.removeChild(div);
    return realPos;
}
ASPx.GetPositionElementOffset = function(element, isX) {
    return getExperimentalPositionOffset(element, isX);
};
//function getPositionElementOffsetCore(element, isX) {
//    var curEl = element.offsetParent;
//    var offset = 0;
//    var scroll = 0;
//    var isThereFixedParent = false;
//    var isFixed = false;
//    var hasDisplayTableParent = false;
//    var position = "";
//    while(curEl != null) {
//        var tagName = curEl.tagName;
//        if(tagName == "HTML"){
//            break;
//        }
//        if(tagName == "BODY"){
//            if(!Browser.Opera && !Browser.Chrome && !Browser.Edge){
//                var style = ASPx.GetCurrentStyle(curEl);
//                if(style.position != "" && style.position != "static"){
//                    offset += ASPx.PxToInt(isX ? style.left : style.top);
//                    offset += ASPx.PxToInt(isX ? style.marginLeft : style.marginTop);
//                }
//            }
//            break;
//        }
//        var style = ASPx.GetCurrentStyle(curEl);
//        isFixed = style.position == "fixed";
//        if(isFixed) {
//            isThereFixedParent = true;
//            if(Browser.IE) 
//                return getExperimentalPositionOffset(element, isX); //Q260707, B157137
//        }
            
//        hasDisplayTableParent = style.display == "table" && (style.position == "absolute" || style.position == "relative");
//        if(hasDisplayTableParent && Browser.IE)
//            return getExperimentalPositionOffset(element, isX);

//        if(style.position == "absolute" || isFixed || style.position == "relative") {
//            offset += isX ? curEl.offsetLeft : curEl.offsetTop;
//            offset += ASPx.PxToInt(isX ? style.borderLeftWidth : style.borderTopWidth);
//        }
//        if(style.position == "relative") // B199061
//            scroll += getElementChainScroll(curEl, curEl.offsetParent, isX);
//        scroll += isX ? curEl.scrollLeft : curEl.scrollTop;
//        curEl = curEl.offsetParent;
//    }
//    offset -= scroll; // Bug B92105
//    if((Browser.IE || Browser.Firefox && Browser.Version >= 3 || Browser.WebKitFamily || Browser.Edge) && isThereFixedParent)
//        offset += isX ? ASPx.GetDocumentScrollLeft() : ASPx.GetDocumentScrollTop();
//    return offset;
//}
//function getElementChainScroll(startElement, endElement, isX){
//    var curEl = startElement.parentNode;
//    var scroll = 0;
//    while(curEl != endElement){
//        scroll += isX ? curEl.scrollLeft : curEl.scrollTop;
//        curEl = curEl.parentNode;
//    }
//    return scroll;
//}

ASPx.GetSizeOfText = function(text, textCss) {
    var testContainer = document.createElement("tester");
    var defaultLineHeight = ASPx.Browser.Firefox ? "1" : "";
    
    testContainer.style.fontSize = textCss.fontSize;
    testContainer.style.fontFamily = textCss.fontFamily;
    testContainer.style.fontWeight = textCss.fontWeight;
    testContainer.style.letterSpacing = textCss.letterSpacing;
    testContainer.style.lineHeight = textCss.lineHeight || defaultLineHeight;
    
    testContainer.style.position = "absolute";
    testContainer.style.top = ASPx.InvalidPosition + "px";
    testContainer.style.left = ASPx.InvalidPosition + "px";
    testContainer.style.width = "auto";
    testContainer.style.whiteSpace = "nowrap";
    
    testContainer.appendChild(document.createTextNode(text));
    var testElement = document.body.appendChild(testContainer);
    var size = {
        "width": testElement.offsetWidth,
        "height": testElement.offsetHeight
    };
    document.body.removeChild(testElement);
    return size;
};
ASPx.PointToPixel = function(points, addPx) {  
    var result = 0;
    try {
        var indexOfPt = points.toLowerCase().indexOf("pt");
        if(indexOfPt > -1)
            result = parseInt(points.substr(0, indexOfPt)) * 96 / 72;
        else
            result = parseInt(points) * 96 / 72;
        if(addPx)
            result = result + "px";
    } catch(e) {}
    return result;
};
ASPx.PixelToPoint = function(pixels, addPt) { 
    var result = 0;
    try {
        var indexOfPx = pixels.toLowerCase().indexOf("px");
        if(indexOfPx > -1)
            result = parseInt(pixels.substr(0, indexOfPx)) * 72 / 96;
        else
            result = parseInt(pixels) * 72 / 96;
        if(addPt)
            result = result + "pt";
    } catch(e) {}
    return result;                           
};
ASPx.PxToInt = function(px) {
    return pxToNumber(px, parseInt);
};
ASPx.PxToFloat = function(px) {
    return pxToNumber(px, parseFloat);
};
function pxToNumber(px, parseFunction) {
    var result = 0;
    if(px != null && px != "") {
        try {
            var indexOfPx = px.indexOf("px");
            if(indexOfPx > -1)
                result = parseFunction(px.substr(0, indexOfPx));
        } catch(e) { }
    }
    return result;
}
ASPx.PercentageToFloat = function(perc) {
    var result = 0;
    if(perc != null && perc != "") {
        try {
            var indexOfPerc = perc.indexOf("%");
            if(indexOfPerc > -1)
                result = parseFloat(perc.substr(0, indexOfPerc)) / 100;
        } catch(e) { }
    }
    return result;
};
ASPx.CreateGuid = function() {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) { 
            var r = Math.random()*16|0,v=c=='x'?r:r&0x3|0x8;
        return v.toString(16);
    });
};

ASPx.GetLeftRightBordersAndPaddingsSummaryValue = function(element, currentStyle) {
    return ASPx.GetLeftRightPaddings(element, currentStyle) + ASPx.GetHorizontalBordersWidth(element, currentStyle);
};
ASPx.GetTopBottomBordersAndPaddingsSummaryValue = function(element, currentStyle) {
    return ASPx.GetTopBottomPaddings(element, currentStyle) + ASPx.GetVerticalBordersWidth(element, currentStyle);
};
ASPx.GetVerticalBordersWidth = function(element, style) {
    if(!ASPx.IsExists(style))
        style = (Browser.IE && Browser.MajorVersion != 9 && window.getComputedStyle) ? window.getComputedStyle(element) : ASPx.GetCurrentStyle(element);
    var res = 0;

    if(style.borderTopStyle != "none") {
		res += ASPx.PxToFloat(style.borderTopWidth);
        if(Browser.IE && Browser.MajorVersion < 9)
            res += getIe8BorderWidthFromText(style.borderTopWidth);
    }
    if(style.borderBottomStyle != "none") {
		res += ASPx.PxToFloat(style.borderBottomWidth);
        if(Browser.IE && Browser.MajorVersion < 9)
            res += getIe8BorderWidthFromText(style.borderBottomWidth);
    }
    return res;
};
ASPx.GetHorizontalBordersWidth = function(element, style) {
    if(!ASPx.IsExists(style))
        style = (Browser.IE && window.getComputedStyle) ? window.getComputedStyle(element) : ASPx.GetCurrentStyle(element);
    var res = 0;

    if(style.borderLeftStyle != "none") {
		res += ASPx.PxToFloat(style.borderLeftWidth);
        if(Browser.IE && Browser.MajorVersion < 9)
            res += getIe8BorderWidthFromText(style.borderLeftWidth);
    }
    if(style.borderRightStyle != "none") {
		res += ASPx.PxToFloat(style.borderRightWidth);
        if(Browser.IE && Browser.MajorVersion < 9)
            res += getIe8BorderWidthFromText(style.borderRightWidth);
    }

    return res;
};
function getIe8BorderWidthFromText(textWidth) {
    var availableWidth = { "thin": 1, "medium" : 3, "thick": 5 };
    var width = availableWidth[textWidth];
    return width ? width : 0;
}
ASPx.GetTopBottomPaddings = function(element, style) {
    var currentStyle = style ? style : ASPx.GetCurrentStyle(element);
    return ASPx.PxToInt(currentStyle.paddingTop) + ASPx.PxToInt(currentStyle.paddingBottom);
};
ASPx.GetTopPaddings = function(element, style) {
    var currentStyle = style ? style : ASPx.GetCurrentStyle(element);
    return ASPx.PxToInt(currentStyle.paddingTop);
};
ASPx.GetBottomPaddings = function(element, style) {
    var currentStyle = style ? style : ASPx.GetCurrentStyle(element);
    return ASPx.PxToInt(currentStyle.paddingBottom);
};
ASPx.GetLeftRightPaddings = function(element, style) {
    var currentStyle = style ? style : ASPx.GetCurrentStyle(element);
    return ASPx.PxToInt(currentStyle.paddingLeft) + ASPx.PxToInt(currentStyle.paddingRight);
};
ASPx.GetTopBottomMargins = function(element, style) {
    var currentStyle = style ? style : ASPx.GetCurrentStyle(element);
    return ASPx.PxToInt(currentStyle.marginTop) + ASPx.PxToInt(currentStyle.marginBottom);
};
ASPx.GetLeftRightMargins = function(element, style) {
    var currentStyle = style ? style : ASPx.GetCurrentStyle(element);
    return ASPx.PxToInt(currentStyle.marginLeft) + ASPx.PxToInt(currentStyle.marginRight);
};

ASPx.GetClearClientWidth = function(element) {
    return ASPx.GetElementOffsetWidth(element)- ASPx.GetLeftRightBordersAndPaddingsSummaryValue(element);
};
ASPx.GetClearClientHeight = function(element) {
    return ASPx.GetElementOffsetHeight(element) - ASPx.GetTopBottomBordersAndPaddingsSummaryValue(element);
};
ASPx.SetOffsetWidth = function(element, widthValue, currentStyle) {
    if(!ASPx.IsExists(currentStyle))
        currentStyle = ASPx.GetCurrentStyle(element);
    var value = widthValue - ASPx.PxToInt(currentStyle.marginLeft) - ASPx.PxToInt(currentStyle.marginRight);
        value -= ASPx.GetLeftRightBordersAndPaddingsSummaryValue(element, currentStyle);
    // B90988
    if(value > -1)
        element.style.width = value + "px";
};
ASPx.SetOffsetHeight = function(element, heightValue, currentStyle) {
    if(!ASPx.IsExists(currentStyle))
        currentStyle = ASPx.GetCurrentStyle(element);
    var value = heightValue - ASPx.PxToInt(currentStyle.marginTop) - ASPx.PxToInt(currentStyle.marginBottom);
        value -= ASPx.GetTopBottomBordersAndPaddingsSummaryValue(element, currentStyle);
    // B90988
    if(value > -1)
        element.style.height = value + "px";
};
ASPx.FindOffsetParent = function(element) {
    var currentElement = element.parentNode;
    while(ASPx.IsExistsElement(currentElement) && currentElement.tagName != "BODY") {
        if(ASPx.GetElementOffsetWidth(currentElement) > 0 && ASPx.GetElementOffsetHeight(currentElement) > 0)
            return currentElement;
        currentElement = currentElement.parentNode;
    }
    return document.body;
};
ASPx.GetDocumentScrollTop = function(){
    var isScrollBodyIE = Browser.IE && ASPx.GetCurrentStyle(document.body).overflow == "hidden" && document.body.scrollTop > 0;
    if(Browser.WebKitFamily || Browser.Edge || isScrollBodyIE) {
        if(Browser.MacOSMobilePlatform) //B157267
            return window.pageYOffset;
        if(Browser.WebKitFamily)
            return document.documentElement.scrollTop || document.body.scrollTop;
        return document.body.scrollTop;
    }
    else
        return document.documentElement.scrollTop;
};
ASPx.SetDocumentScrollTop = function(scrollTop) {
    if(!Browser.MacOSMobilePlatform && (Browser.Safari || (Browser.Chrome && Browser.Version < 60) || (Browser.Opera && Browser.MajorVersion >= 15) || Browser.Edge))  //Edge was added long time ago so it is not chromium based and is absent on iOS
        document.body.scrollTop = scrollTop;
    else
        document.documentElement.scrollTop = scrollTop;
};
ASPx.GetDocumentScrollLeft = function(){
    var isScrollBodyIE = Browser.IE && ASPx.GetCurrentStyle(document.body).overflow == "hidden" && document.body.scrollLeft > 0;
    if(Browser.Edge || isScrollBodyIE)
        return document.body ? document.body.scrollLeft : document.documentElement.scrollLeft;
    if(Browser.WebKitFamily)
        return document.documentElement.scrollLeft || document.body.scrollLeft;
    return document.documentElement.scrollLeft;
};
ASPx.SetDocumentScrollLeft = function (scrollLeft) {
    if(!Browser.MacOSMobilePlatform && (Browser.Safari || (Browser.Chrome && Browser.Version < 60) || (Browser.Opera && Browser.MajorVersion >= 15) || Browser.Edge))  //Edge was added long time ago so it is not chromium based and is absent on iOS
        document.body.scrollLeft = scrollLeft;
    else
        document.documentElement.scrollLeft = scrollLeft;
};
ASPx.GetDocumentClientWidth = function(){
    if(document.documentElement.clientWidth == 0)
        return document.body.clientWidth;
    else
        return document.documentElement.clientWidth;
};
ASPx.GetDocumentClientHeight = function() {
    if(Browser.Firefox && window.innerHeight - document.documentElement.clientHeight > ASPx.GetVerticalScrollBarWidth()) {
        return window.innerHeight;
    } else if(Browser.Opera && Browser.Version < 9.6 || document.documentElement.clientHeight == 0) {
         return document.body.clientHeight;
    }
    return document.documentElement.clientHeight;
};

ASPx.GetDocumentWidth = function(){
    var bodyWidth = document.body.offsetWidth;
    var docWidth = Browser.IE ? document.documentElement.clientWidth : document.documentElement.offsetWidth;
    var bodyScrollWidth = document.body.scrollWidth;
    var docScrollWidth = document.documentElement.scrollWidth;
    return getMaxDimensionOf(bodyWidth, docWidth, bodyScrollWidth, docScrollWidth);
};
ASPx.GetDocumentHeight = function(){
    var bodyHeight = document.body.offsetHeight;
    var docHeight = Browser.IE ? document.documentElement.clientHeight : document.documentElement.offsetHeight;
    var bodyScrollHeight = document.body.scrollHeight;
    var docScrollHeight = document.documentElement.scrollHeight;
    var maxHeight = getMaxDimensionOf(bodyHeight, docHeight, bodyScrollHeight, docScrollHeight);

    if(Browser.Opera && Browser.Version >= 9.6){
        if(Browser.Version < 10)
            maxHeight = getMaxDimensionOf(bodyHeight, docHeight, bodyScrollHeight);
        var visibleHeightOfDocument = document.documentElement.clientHeight;
        if(maxHeight > visibleHeightOfDocument)
            maxHeight = getMaxDimensionOf(window.outerHeight, maxHeight);
        else
            maxHeight = document.documentElement.clientHeight;
        return maxHeight;
    }
    return maxHeight;
};
ASPx.GetDocumentMaxClientWidth = function(){
    var bodyWidth = document.body.offsetWidth;
    var docWidth = document.documentElement.offsetWidth;
    var docClientWidth = document.documentElement.clientWidth;
    return getMaxDimensionOf(bodyWidth, docWidth, docClientWidth);
};
ASPx.GetDocumentMaxClientHeight = function(){
    var bodyHeight = document.body.offsetHeight;
    var docHeight = document.documentElement.offsetHeight;
    var docClientHeight = document.documentElement.clientHeight;
    return getMaxDimensionOf(bodyHeight, docHeight, docClientHeight);
};
ASPx.verticalScrollIsNotHidden = null;
ASPx.horizontalScrollIsNotHidden = null;
ASPx.GetVerticalScrollIsNotHidden = function() {
    if(!ASPx.IsExists(ASPx.verticalScrollIsNotHidden))
        ASPx.verticalScrollIsNotHidden = ASPx.GetCurrentStyle(document.body).overflowY !== "hidden"
            && ASPx.GetCurrentStyle(document.documentElement).overflowY !== "hidden";
    return ASPx.verticalScrollIsNotHidden;
};
ASPx.GetHorizontalScrollIsNotHidden = function() {
    if(!ASPx.IsExists(ASPx.horizontalScrollIsNotHidden))
        ASPx.horizontalScrollIsNotHidden = ASPx.GetCurrentStyle(document.body).overflowX !== "hidden"
            && ASPx.GetCurrentStyle(document.documentElement).overflowX !== "hidden";
    return ASPx.horizontalScrollIsNotHidden;
};
ASPx.GetCurrentDocumentWidth = function() {
    var result = ASPx.GetDocumentClientWidth();
    if(!ASPx.Browser.Safari && ASPx.GetVerticalScrollIsNotHidden() && ASPx.GetDocumentHeight() > ASPx.GetDocumentClientHeight())
        result += ASPx.GetVerticalScrollBarWidth();
    return result;
};
ASPx.GetCurrentDocumentHeight = function() {
    var result = ASPx.GetDocumentClientHeight();
    if(!ASPx.Browser.Safari && ASPx.GetHorizontalScrollIsNotHidden() && ASPx.GetDocumentWidth() > ASPx.GetDocumentClientWidth())
        result += ASPx.GetVerticalScrollBarWidth();
    return result;
};
function getMaxDimensionOf(){
    var max = ASPx.InvalidDimension;
    for(var i = 0; i < arguments.length; i++){
        if(max < arguments[i])
            max = arguments[i];
    }
    return max;
}
ASPx.GetClientLeft = function(element) {
    return ASPx.IsExists(element.clientLeft) ? element.clientLeft : (ASPx.GetElementOffsetWidth(element)- element.clientWidth) / 2;
};
ASPx.GetClientTop = function(element) {
    return ASPx.IsExists(element.clientTop) ? element.clientTop : (ASPx.GetElementOffsetHeight(element) - element.clientHeight) / 2;
};
var requestAnimationFrameFunc = window.requestAnimationFrame || function(callback) { callback(); };
var cancelAnimationFrameFunc = window.cancelAnimationFrame || function(id) { };
ASPx.CancelAnimationFrame = function(id) { cancelAnimationFrameFunc(id); };
ASPx.RequestAnimationFrame = function (callback) { return requestAnimationFrameFunc(callback); };
ASPx.SetStyles = function(element, styles, makeImportant) {
    if(ASPx.IsExists(styles.cssText))
        element.style.cssText = styles.cssText;
    if(ASPx.IsExists(styles.className)) {
        ASPx.SetClassName(element, styles.className);
    }
    for(var property in styles) {
        if(!styles.hasOwnProperty(property))
            continue;
        var value = styles[property];
        switch (property) {
            case "cssText":
            case "className":
                break;
            case "float":
                ASPx.SetElementFloat(element, value);
                break;
            case "opacity":
                ASPx.SetElementOpacity(element, value);
                break;
            case "zIndex":
                ASPx.SetStylesCore(element, property, value, makeImportant);
                break;
            /*jshint -W086 */
            case "fontWeight":
                if(ASPx.Browser.IE && ASPx.Browser.Version < 9 && typeof(styles[property]) == "number")
                    value = styles[property].toString();
            default:
                ASPx.SetStylesCore(element, property, value + (typeof (value) == "number" ? "px" : ""), makeImportant);
            /*jshint +W086 */
        }
    }
};
ASPx.SetStylesCore = function(element, property, value, makeImportant) {
    if(makeImportant) {
        var index = property.search("[A-Z]");
        if(index != -1)
            property = property.replace(property.charAt(index), "-" + property.charAt(index).toLowerCase());
        if(element.style.setProperty)
            element.style.setProperty(property, value, "important");
        else 
            element.style.cssText += ";" + property + ":" + value + "!important";
    }
    else
        element.style[property] = value;
};

ASPx.RemoveBordersAndShadows = function(el) {
    if(!el || !el.style)
        return;
    el.style.borderWidth = 0;
    if(ASPx.IsExists(el.style.boxShadow))
        el.style.boxShadow = "none";
    else if(ASPx.IsExists(el.style.MozBoxShadow))
        el.style.MozBoxShadow = "none";
    else if(ASPx.IsExists(el.style.webkitBoxShadow))
        el.style.webkitBoxShadow = "none";
};

ASPx.GetCellSpacing = function(element) {
    var val = parseInt(element.cellSpacing);
    if(!isNaN(val)) return val;
    val = parseInt(ASPx.GetCurrentStyle(element).borderSpacing);
    if(!isNaN(val)) return val;
    return 0;
};

ASPx.GetInnerScrollPositions = function(element) {
    var scrolls = [];
    getInnerScrollPositionsCore(element, scrolls);
    return scrolls;
};
function getInnerScrollPositionsCore(element, scrolls) {
    for(var child = element.firstChild; child; child = child.nextSibling) {
        var scrollTop = child.scrollTop,
            scrollLeft = child.scrollLeft;
        if(scrollTop > 0 || scrollLeft > 0)
            scrolls.push([child, scrollTop, scrollLeft]);
        getInnerScrollPositionsCore(child, scrolls);
    }
}
ASPx.RestoreInnerScrollPositions = function(scrolls) {
    for(var i = 0, scrollArr; scrollArr = scrolls[i]; i++) {
        if(scrollArr[1] > 0)
            scrollArr[0].scrollTop = scrollArr[1];
        if(scrollArr[2] > 0)
            scrollArr[0].scrollLeft = scrollArr[2];
    }
};
ASPx.GetOuterScrollPosition = function(element) {
    while(element && element.tagName !== "BODY") {
        var scrollTop = element.scrollTop,
            scrollLeft = element.scrollLeft;
        if(scrollTop > 0 || scrollLeft > 0) {
            return {
                scrollTop: scrollTop,
                scrollLeft: scrollLeft,
                element: element
            };
        }
        element = element.parentNode;
    }
    return {
        scrollTop: ASPx.GetDocumentScrollTop(),
        scrollLeft: ASPx.GetDocumentScrollLeft()
    };
};
ASPx.RestoreOuterScrollPosition = function(scrollInfo) {
    if(scrollInfo.element) {
        if(scrollInfo.scrollTop > 0)
            scrollInfo.element.scrollTop = scrollInfo.scrollTop;
        if(scrollInfo.scrollLeft > 0)
            scrollInfo.element.scrollLeft = scrollInfo.scrollLeft;
    }
    else {
        if(scrollInfo.scrollTop > 0)
            ASPx.SetDocumentScrollTop(scrollInfo.scrollTop);
        if(scrollInfo.scrollLeft > 0)
            ASPx.SetDocumentScrollLeft(scrollInfo.scrollLeft);
    }
};

ASPx.ChangeElementContainer = function(element, container, savePreviousContainer) {
    if(element.parentNode != container) {
        var parentNode = element.parentNode;
        parentNode.removeChild(element);
        container.appendChild(element);
        if(savePreviousContainer)
            element.previousContainer = parentNode;
    }
};
ASPx.RestoreElementContainer = function(element) {
    if(element.previousContainer) {
        ASPx.ChangeElementContainer(element, element.previousContainer, false);
        element.previousContainer = null;
    }
};
ASPx.MoveChildrenToElement = function(sourceElement, destinationElement){
    while(sourceElement.childNodes.length > 0)
        destinationElement.appendChild(sourceElement.childNodes[0]);
};

ASPx.GetScriptCode = function(script) {
    var useFirstChildElement = Browser.Chrome && Browser.Version < 11 || Browser.Safari && Browser.Version < 5; //B184987
	var text = useFirstChildElement ? script.firstChild.data : script.text;
    var comment = "<!--";
    var pos = text.indexOf(comment);
    if(pos > -1)
        text = text.substr(pos + comment.length);
    return text;
};
ASPx.AppendScript = function(script) {
    var parent = document.getElementsByTagName("head")[0];
    if(!parent)
        parent = document.body;
    if(parent)
        parent.appendChild(script);
};

function getFrame(frames, name) {
    if(frames[name])
        return frames[name];
    for(var i = 0; i < frames.length; i++) {
        try {
            var frame = frames[i];
            if(frame.name == name) 
                return frame;    

            frame = getFrame(frame.frames, name);
            if(frame != null)   
                return frame;    
        } catch(e) {
        
        }    
    }
    return null;
}

ASPx.IsValidElement = function(element) {
    if(!element) 
        return false;
    if(!(Browser.Firefox && Browser.Version < 4)) {
        if(element.ownerDocument && element.ownerDocument.body && element.ownerDocument.body.compareDocumentPosition)
            return element.ownerDocument.body.compareDocumentPosition(element) % 2 === 0;
    }
    if(!Browser.Opera && !(Browser.IE && Browser.Version < 9) && element.offsetParent && element.parentNode.tagName)
        return true;
    while(element != null){
        if(element.tagName == "BODY")
            return true;
        element = element.parentNode;
    }
    return false;
};
ASPx.IsValidElements = function(elements) {
    if(!elements)
        return false;    
    for(var i = 0; i < elements.length; i++) {
        if(elements[i] && !ASPx.IsValidElement(elements[i]))
            return false;
    }
    return true;
};
ASPx.IsExistsElement = function(element) {
    return element && ASPx.IsValidElement(element);
};

ASPx.CreateHtmlElementFromString = function(str) {
    var dummy = ASPx.CreateHtmlElement();
    setInnerHtmlInternal(dummy, str);
    return dummy.firstChild;
};
ASPx.CreateHtmlElement = function(tagName, styles) {
    var element = document.createElement(tagName || "DIV");
    if(styles)
        ASPx.SetStyles(element, styles);
    return element;
};

ASPx.RestoreElementOriginalWidth = function(element) {
    if(!ASPx.IsExistsElement(element)) 
        return;
    element.style.width = element.dxOrigWidth = ASPx.GetElementOriginalWidth(element);
};
ASPx.GetElementOriginalWidth = function(element) {
    if(!ASPx.IsExistsElement(element)) 
        return null;
    var width;
    if(!ASPx.IsExists(element.dxOrigWidth)) {
        width = String(element.style.width).length > 0
            ? element.style.width
            : ASPx.GetElementOffsetWidth(element) + "px";
    } else {
        width = element.dxOrigWidth;
    }
    return width;
};
ASPx.DropElementOriginalWidth = function(element) {
    if(ASPx.IsExists(element.dxOrigWidth))
        element.dxOrigWidth = null;
};

ASPx.GetObjectKeys = function(obj) {
    if(!obj) return [ ];
    if(Object.keys)
        return Object.keys(obj);

    var keys = [ ];
    for(var key in obj) {
        if(obj.hasOwnProperty(key))
            keys.push(key);
    }
    return keys;
};

ASPx.ShowErrorAlert = function(message) {
    message = ASPx.Str.DecodeHtmlViaTextArea(message);
    if(ASPx.IsExists(message) && message !== "")
        alert(message);
};

ASPx.ShowKBErrorMessage = function(text, kbid) {
    ASPx.ShowErrorMessage(text + "https://www.devexpress.com/kbid=" + kbid + ".");
};
ASPx.ShowErrorMessage = function(errorMessage) {
    var console = window.console;
    if(!console || !ASPx.IsFunction(console.error))
        return;

    console.error(errorMessage);
};

ASPx.IsInteractiveControl = function(element, extremeParent) { //TODO remove, use ASPx.IsActionElement instead
    return Data.ArrayIndexOf(["A", "INPUT", "SELECT", "OPTION", "TEXTAREA", "BUTTON", "IFRAME"], element.tagName) > -1;
};

ASPx.IsUrlContainsClientScript = function(url) {
    return url.toLowerCase().indexOf("javascript:") !== -1;
};

ASPx.GetMSAjaxRequestManager = function() {
    if(window.Sys && Sys.WebForms && Sys.WebForms.PageRequestManager && Sys.WebForms.PageRequestManager.getInstance)
        return Sys.WebForms.PageRequestManager.getInstance();
    return null;
};

/*jshint -W121 */
Function.prototype.aspxBind = function(scope) {
    var func = this;
    return function() {
        return func.apply(scope, arguments);
    };
};
/*jshint +W121 */

var FilteringUtils = { };
FilteringUtils.EventKeyCodeChangesTheInput = function(evt) {
    if(ASPx.IsPasteShortcut(evt))
        return true;
    else if(evt.ctrlKey && !evt.altKey)
        return false;

    if(ASPx.Browser.AndroidMobilePlatform || ASPx.Browser.MacOSMobilePlatform) return true; // Q525327 and T110630(bluetooth keyboard)
        
    var keyCode = ASPx.Evt.GetKeyCode(evt);
    var isSystemKey = ASPx.Key.Windows <= keyCode && keyCode <= ASPx.Key.ContextMenu;
    var isFKey = ASPx.Key.F1 <= keyCode && keyCode <= 127; // 127 - F16 for MAC
    return ASPx.Key.Delete <= keyCode && !isSystemKey && !isFKey || keyCode == ASPx.Key.Backspace || keyCode == ASPx.Key.Space;
};
FilteringUtils.FormatCallbackArg = function(prefix, arg) {
    return (ASPx.IsExists(arg) ? prefix + "|" + arg.length + ';' + arg + ';' : "");
};
ASPx.FilteringUtils = FilteringUtils;

var FormatStringHelper = { };
FormatStringHelper.PlaceHolderTemplateStruct = function(startIndex, length, index, placeHolderString){
    this.startIndex = startIndex;
    this.realStartIndex = 0;
    this.length = length;
    this.realLength = 0;
        
    this.index = index;
    this.placeHolderString = placeHolderString;
};
FormatStringHelper.GetPlaceHolderTemplates = function(formatString){
    formatString = this.CollapseDoubleBrackets(formatString);
    var templates = this.CreatePlaceHolderTemplates(formatString);
    return templates;
};
FormatStringHelper.CreatePlaceHolderTemplates = function(formatString){
    var templates = [];
    var templateStrings = formatString.match(/{[^}]+}/g);
    if(templateStrings != null){
        var pos = 0;
        for(var i = 0; i < templateStrings.length; i++){
            var tempString = templateStrings[i];
            var startIndex = formatString.indexOf(tempString, pos);
            var length = tempString.length;
            var indexString = tempString.slice(1).match(/^[0-9]+/);
            var index = parseInt(indexString);
            templates.push(new this.PlaceHolderTemplateStruct(startIndex, length, index, tempString));
            pos = startIndex + length;
        }
    }
    return templates;
};
FormatStringHelper.CollapseDoubleBrackets = function(formatString){
    formatString = this.CollapseOpenDoubleBrackets(formatString);
    formatString = this.CollapseCloseDoubleBrackets(formatString);
    return formatString;
};
FormatStringHelper.CollapseOpenDoubleBrackets = function(formatString){
    return formatString.replace(/{{/g, "_");
};
FormatStringHelper.CollapseCloseDoubleBrackets = function(formatString){
    while(true){
        var index = formatString.lastIndexOf("}}");
        if(index == -1) 
            break;
        else
            formatString = formatString.substr(0, index) + "_" + formatString.substr(index + 2);
    }
    return formatString;
};
ASPx.FormatStringHelper = FormatStringHelper;

var StartWithFilteringUtils = { };
StartWithFilteringUtils.HighlightSuggestedText = function(input, suggestedText, control, onChangeInput){
    if(this.NeedToLockAndoidKeyEvents(control))
        control.LockAndroidKeyEvents();
    var selInfo = ASPx.Selection.GetInfo(input);
    var currentTextLenght = ASPx.Str.GetCoincideCharCount(suggestedText, input.value, 
        function(text, filter) { 
            return text.indexOf(filter) == 0;
        });
    var suggestedTextLenght = suggestedText.length;
     
    var isSelected = selInfo.startPos == 0 && selInfo.endPos == currentTextLenght && 
        selInfo.endPos == suggestedTextLenght && input.value == suggestedText;
    if(!isSelected) {    
        input.value = suggestedText;
        if(onChangeInput)
            onChangeInput();
        if(this.NeedToLockAndoidKeyEvents(control)) {
            window.setTimeout(function() {
                this.SelectText(input, currentTextLenght, suggestedTextLenght);
                control.UnlockAndroidKeyEvents();
            }.aspxBind(this), control.adroidSamsungBugTimeout);
        } else
            this.SelectText(input, currentTextLenght, suggestedTextLenght);
    }
};
StartWithFilteringUtils.SelectText = function(input, startPos, stopPos) {
    if(startPos < stopPos)
        ASPx.Selection.Set(input, startPos, stopPos);
};
StartWithFilteringUtils.RollbackOneSuggestedChar = function(input){
    var currentText = input.value;
    var cutText = currentText.slice(0, -1);
    if(cutText != currentText)
        input.value = cutText;
};
StartWithFilteringUtils.NeedToLockAndoidKeyEvents = function(control) {
    return ASPx.Browser.AndroidMobilePlatform && control && control.LockAndroidKeyEvents;
};
ASPx.StartWithFilteringUtils = StartWithFilteringUtils;

var ContainsFilteringUtils = { };
ContainsFilteringUtils.ColumnSelectionStruct = function(index, startIndex, length){
    this.index = index;
    this.length = length;
    this.startIndex = startIndex;
};
ContainsFilteringUtils.IsFilterCrossPlaseHolder = function(filterStartIndex, filterEndIndex, template) {
    var left = Math.max(filterStartIndex, template.realStartIndex);
    var right = Math.min(filterEndIndex,  template.realStartIndex + template.realLength);
    return left < right;
};
ContainsFilteringUtils.GetColumnSelectionsForItem = function(itemValues, formatString, filterString) {
    if(formatString == "") 
        return this.GetSelectionForSingleColumnItem(itemValues, filterString); 
        
    var result = [];
    var formatedString = ASPx.Formatter.Format(formatString, itemValues);
            
    var filterStartIndex = ASPx.Str.PrepareStringForFilter(formatedString).indexOf(ASPx.Str.PrepareStringForFilter(filterString));
    if(filterStartIndex == -1) return result;
    var filterEndIndex = filterStartIndex + filterString.length;
                    
    var templates = FormatStringHelper.GetPlaceHolderTemplates(formatString);
    this.SupplyTemplatesWithRealValues(itemValues, templates);
            
    for(var i = 0; i < templates.length ; i++) {
        if(this.IsFilterCrossPlaseHolder(filterStartIndex, filterEndIndex, templates[i])) 
            result.push(this.GetColumnSelectionsForItemValue(templates[i], filterStartIndex, filterEndIndex));
    }
    return result;
};
ContainsFilteringUtils.GetColumnSelectionsForItemValue = function(template, filterStartIndex, filterEndIndex) {
    var selectedTextStartIndex = filterStartIndex < template.realStartIndex ? 0 :
        filterStartIndex - template.realStartIndex;
    var selectedTextEndIndex = filterEndIndex >  template.realStartIndex + template.realLength ? template.realLength :
        filterEndIndex - template.realStartIndex;
    var selectedTextLength = selectedTextEndIndex - selectedTextStartIndex;
    return new this.ColumnSelectionStruct(template.index, selectedTextStartIndex, selectedTextLength);
};
ContainsFilteringUtils.GetSelectionForSingleColumnItem = function(itemValues, filterString) {
    var selectedTextStartIndex = ASPx.Str.PrepareStringForFilter(itemValues[0]).indexOf(ASPx.Str.PrepareStringForFilter(filterString));
    var selectedTextLength = filterString.length;
    return [new this.ColumnSelectionStruct(0, selectedTextStartIndex, selectedTextLength)];
};
ContainsFilteringUtils.ResetFormatStringIndex = function(formatString, index) {
    if(index != 0)
        return formatString.replace(index.toString(), "0");
    return formatString;
};
ContainsFilteringUtils.SupplyTemplatesWithRealValues = function(itemValues, templates) {
    var shift = 0;
    for(var i = 0; i < templates.length; i++) {
        var formatString = this.ResetFormatStringIndex(templates[i].placeHolderString, templates[i].index);
        var currentItemValue = itemValues[templates[i].index];
        templates[i].realLength = ASPx.Formatter.Format(formatString, currentItemValue).length;
        templates[i].realStartIndex  += templates[i].startIndex + shift; 
        shift += templates[i].realLength - templates[i].placeHolderString.length; 
    }
};
ContainsFilteringUtils.PrepareElementText = function(itemText) {
    return itemText ? itemText.replace(/\&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;") : '';
};
ContainsFilteringUtils.UnselectContainsTextInElement = function(element, selection, highlightTagName) {
    var currentText =  ASPx.Attr.GetAttribute (element, "DXText");
    if(ASPx.IsExists(currentText)) {
        currentText = ContainsFilteringUtils.PrepareElementText(currentText);
        ASPx.Security.setInnerHtml(element, currentText === "" ? "&nbsp;" : currentText, ASPx.Security.DataType.Trusted);
    }
};
ContainsFilteringUtils.ReselectContainsTextInElement = function(element, selection, highlightTagName) {
    var currentText = ASPx.GetInnerText(element);
    if(!highlightTagName)
        highlightTagName = "em";
    highlightTagName = highlightTagName.toLowerCase();
    if(currentText.indexOf("</" + highlightTagName + ">") != -1)
        ContainsFilteringUtils.UnselectContainsTextInElement(element, selection, highlightTagName);
    return ContainsFilteringUtils.SelectContainsTextInElement(element, selection, highlightTagName);
};
ContainsFilteringUtils.SelectContainsTextInElement = function(element, selection, highlightTagName) {
    if(selection.startIndex == -1)
        return;
    var currentText =  ASPx.Attr.GetAttribute (element, "DXText");
    if(!ASPx.IsExists(currentText)) ASPx.Attr.SetAttribute (element, "DXText", ASPx.GetInnerText(element));
    if(!highlightTagName)
        highlightTagName = "em";
    highlightTagName = highlightTagName.toLowerCase();
    var oldInnerText = ASPx.GetInnerText(element);
    var newInnerText = ContainsFilteringUtils.PrepareElementText(oldInnerText.substr(0, selection.startIndex)) + "<" + highlightTagName + ">" +
                        ContainsFilteringUtils.PrepareElementText(oldInnerText.substr(selection.startIndex, selection.length)) + "</" + highlightTagName + ">" +
                        ContainsFilteringUtils.PrepareElementText(oldInnerText.substr(selection.startIndex + selection.length));
    ASPx.Security.setInnerHtml(element, newInnerText, ASPx.Security.DataType.Trusted);
};
ASPx.ContainsFilteringUtils = ContainsFilteringUtils;

ASPx.MakeEqualControlsWidth = function(name1, name2){
    var control1 = ASPx.GetControlCollection().Get(name1);
    var control2 = ASPx.GetControlCollection().Get(name2);
    if(control1 && control2){
        var width = Math.max(control1.GetWidth(), control2.GetWidth());
        control1.SetWidth(width);
        control2.SetWidth(width);
    }
};

ASPx.HighContrastForeColorHighlightColorMap = {
    "#ffff00" : "#008000",
    "#00ff00" : "#0000ff",
    "#ffffff" : "#00838f",
    "#000000" : "#a347ff"
};

var BadgeManagerBase = ASPx.CreateClass(null, {
    createBadge: function(text, iconCssClass) {
        var badge = document.createElement("SPAN");
        ASPx.SetClassName(badge, this.getBadgeClassName());
        if(iconCssClass && iconCssClass.length)
            this.setBadgeIconCssClass(badge, iconCssClass);
        if(text && text.length)
            this.setBadgeText(badge, text);
        return badge;
    },
    findBadge: function(element) {
        if(!element)
            return null;
        return element.querySelector("." + this.getBadgeClassName());
    },
    setBadgeIconCssClass: function(badge, iconCssClass) {
        if(!badge || iconCssClass === undefined)
            return;
        var iconElement = this.getBadgeIconElement(badge);
        if(!iconCssClass) {
            if(iconElement)
                badge.removeChild(iconElement);
        }
        else {
            if(!iconElement) {
                iconElement = document.createElement("SPAN");
                badge.insertBefore(iconElement, badge.childNodes[0]);
            }
            ASPx.SetClassName(iconElement, iconCssClass + " " + this.getBadgeIconDefaultClassName());
        }
    },
    getBadgeIconCssClass: function(element) {
        var badge = this.findBadge(element);
        if(badge) {
            var iconElement = this.getBadgeIconElement(badge);
            var regEx = new RegExp("(?:^|\\s)" + this.getBadgeIconDefaultClassName() + "(?!\\S)");
            return iconElement ? ASPx.Str.Trim(ASPx.GetClassName(iconElement).replace(regEx, "")) : "";
        }
        return "";
    },
    setBadgeText: function(badge, text) {
        if(!badge || text === undefined)
            return;

        var textElement = this.getBadgeTextElement(badge);
        if(!text) {
            if(textElement)
                badge.removeChild(textElement);
        }
        else {
            if(!textElement) {
                textElement = document.createElement("SPAN");
                badge.appendChild(textElement);
            }
            ASPx.Security.setInnerHtml(textElement, text, ASPx.Security.DataType.Trusted);
        }
    },
    getBadgeText: function(element) {
        var badge = this.findBadge(element);
        if(badge) {
            var textElement = this.getBadgeTextElement(badge);
            return textElement ? ASPx.GetInnerText(textElement) : "";
        }
        return "";
    },
    getBadgeClassName: function() {
        return "";
    },
    getBadgeIconDefaultClassName: function() {
        return "";
    },
    getBadgeIconElement: function(badge) {
        return badge.childNodes.length ? badge.querySelector("." + this.getBadgeIconDefaultClassName()) : null;
    },
    getBadgeTextElement: function(badge) {
        return badge.childNodes.length ? badge.querySelector("span:not(." + this.getBadgeIconDefaultClassName() + ")") : null;
    }
});
ASPx.BadgeManagerBase = BadgeManagerBase;

var BadgeManager = ASPx.CreateClass(BadgeManagerBase, {
    getBadgeClassName: function() {
        return "dxBadge";
    },
    getBadgeIconDefaultClassName: function() {
        return "dxBadgeImage";
    },
    createBadgeForButton: function(button) {
        var badge = ASPx.BadgeManager.createBadge();
        var buttonImage = button.GetButtonImage();
        var textContainer = button.GetTextContainer();
        var badgeRightSibling = !!buttonImage ? buttonImage : textContainer;
        badgeRightSibling.parentNode.insertBefore(badge, badgeRightSibling);
        if(button.IsLink() && buttonImage)
            ASPx.SetStyles(badge, { verticalAlign: "middle" });
        return badge;
    },
    createBadgeForToolbar: function(toolbarItem) {
        var badge = ASPx.BadgeManager.createBadge();
        var itemImage = toolbarItem.GetImage();
        var badgeRightSibling = itemImage;
        if(!itemImage) {
            var itemContentElement = toolbarItem.menu.GetItemContentElement(toolbarItem.indexPath);
            badgeRightSibling = toolbarItem.menu.GetContentTextElement(itemContentElement);
        }
        badgeRightSibling.parentNode.insertBefore(badge, badgeRightSibling);
        return badge;
    }
});
ASPx.BadgeManager = new BadgeManager();

var AccessibilityUtils = {
    isInitialized: false,
    highContrastCssClassMarker: "dxHighContrast",
    highContrastBackgroundCssClassMarker: "dxHCB",
    highContrastDefaultBackgroundColor: "#a347ff",
    highContrastThemeActive: false,
    accessibleBackgroundCssMarker: ".dx-runtime-background",
    createAccessibleBackgrounds: function(control) {
        if(!this.highContrastThemeActive || control.accessibleBackgroundsCreated || !control.accessibilityCompliant)
            return;
        var className = this.accessibleBackgroundCssMarker;
        var styleSheetRuleNames = [];
        iterateStyleSheetRules(null, function(rule) {
            var selectorTxt = rule.selectorText;
            if(selectorTxt && selectorTxt.indexOf(className) > -1)
                styleSheetRuleNames.push(ASPx.Str.CompleteReplace(selectorTxt, className, "")); 
        });
        for(var i = 0; i < styleSheetRuleNames.length; i++) {
            var name = styleSheetRuleNames[i];
            var rule = ASPx.GetStyleSheetRules(name.substring(1));
            if(rule && rule.style && rule.style.backgroundImage)
                this.createAccessibleBackground(control.GetMainElement(), rule.style, name);
        }
        control.accessibleBackgroundsCreated = true;
    },
    createAccessibleBackground: function(container, style, selector) {
        if(!container)
            return;
        var backgroundUrl = style.backgroundImage.substring(5, style.backgroundImage.length - 2);
        var elements = container.querySelectorAll(selector);
        var accessibleBackgroundClassName = "dx-acc-bi";
        for(var i = 0; i < elements.length; i++) {
            var element = elements[i];
            if(ASPx.ElementHasCssClass(element, accessibleBackgroundClassName))
                continue;
            var image = null;
            if(element.tagName !== "IMG") {
                ASPx.AddClassNameToElement(element, accessibleBackgroundClassName);
                image = element.ownerDocument.createElement("IMG");
                ASPx.SetStyles(image, { width: "100%", height: "100%" });
                if(element.firstChild)
                    element.insertBefore(image, element.firstChild);
                else
                    element.appendChild(image);
            } else
                image = element;
            image.src = backgroundUrl;
        }
    },
    createHighContrastBackgroundStyle: function() {
        var style = document.createElement('style');
        ASPx.Attr.AppendStyleType(style);
        var styleContent = [
            "." + this.highContrastCssClassMarker + " ." + this.highContrastBackgroundCssClassMarker + ":after {",
            "border-image: url(" + this.getHighContrastBackgroundUrl() + ") 0 1 0 0 round;",
            "}",
        ];
        setInnerHtmlInternal(style, styleContent.join('\n'));
        document.getElementsByTagName('head')[0].appendChild(style);
    },
    getHighContrastBackgroundUrl: function() {
        var canvas = document.createElement("canvas"),
		ctx = canvas.getContext('2d');
        canvas.width = 1;
        canvas.height = 1;
        ctx.fillStyle = this.getHighContrastBackgroundColor();
		ctx.fillRect(0, 0, canvas.width, canvas.height);
        return canvas.toDataURL();
    },
    getHighContrastBackgroundColor: function() {
        var foreColor = ASPx.GetCurrentStyle(document.body).color;
        var hexColor = ASPx.Color.ColorToHexadecimal(foreColor);
        return ASPx.HighContrastForeColorHighlightColorMap[hexColor] || this.highContrastDefaultBackgroundColor;
    },
    initialize: function() {
        if(this.isInitialized)
            return;
        this.isInitialized = true;
        this.detectHighContrastTheme();
        if(this.highContrastThemeActive)
            this.createHighContrastBackgroundStyle();
    },
    detectHighContrastTheme: function() {
        var testElement = document.createElement("DIV");
        ASPx.SetStyles(testElement, {
            backgroundColor: "rgb(255, 255, 255)",
            display: "none"
        }, true);
        var docElement = document.documentElement;
        docElement.appendChild(testElement);

        var actualBackgroundColor = ASPx.GetCurrentStyle(testElement).backgroundColor;
        docElement.removeChild(testElement);
        if(actualBackgroundColor === "rgb(0, 0, 0)") {
            this.highContrastThemeActive = true;
            ASPx.AddClassNameToElement(docElement, this.highContrastCssClassMarker);
        }
    }
};
ASPx.AccessibilityUtils = AccessibilityUtils;
ASPx.AccessibilityUtils.SendMessageToAssistiveTechnology = function(message) {
    var messageParts = ASPx.Ident.IsArray(message) ? message : [message];
    var args = new ASPxClientControlBeforePronounceEventArgs(messageParts, null);
    ASPx.AccessibilityPronouncer.EnsureInitialize();
    ASPx.AccessibilityPronouncer.Pronounce(args, ASPx.AccessibilityPronouncerType.live);
};
ASPx.AccessibilityUtils.SetFocusAccessible = function(focusableElement) {
    if(!focusableElement)
        return;
    var elementId = focusableElement.id;
    if(!elementId) {
        var namedParent = ASPx.GetParent(focusableElement, function(element) {
            return !!element.id;
        });
        if(ASPx.IsExists(namedParent))
            elementId = namedParent.id;
    }
    var focusableControl = ASPx.GetClientControlByElementID(elementId);
    if(focusableControl && focusableControl.OnAssociatedLabelClick)
        focusableControl.OnAssociatedLabelClick(focusableElement);
    else
        window.setTimeout(function() {
            ASPx.AccessibilityUtils.SetFocusAccessibleCore(focusableElement);
        }, 0);
};
ASPx.AccessibilityUtils.SetFocusAccessibleCore = function(focusableElement) {
    if(!ASPx.IsExists(focusableElement))
        return;
    var isTabIndexChanged = ASPx.ControlTabIndexManager.getInstance().isElementWithChangedIndex(focusableElement);
    if(isTabIndexChanged)
        return;
    if(!ASPx.IsValidElement(focusableElement) && focusableElement.id)
        focusableElement = ASPx.GetElementById(focusableElement.id);
    if(!ASPx.IsActionElement(focusableElement))
        focusableElement = ASPx.RestoreFocusHelper.findNeighbourFocusElement(focusableElement, document.body);
    if(ASPx.IsExistsElement(focusableElement))
        focusableElement.focus();
};

var Security = {
    setInnerHtml: function(el, html, dataType) {
        if(!html) {
            while(el.firstChild)
                ASPx.RemoveElement(el.firstChild);
        } else
            Security.setData(html, function(d) { ASPx.SetInnerHtml.call(window, el, d); }, dataType);
    },
    setText: function(control, text, dataType) { Security.setData(text, control.SetText.aspxBind(control), dataType); },
    safeEncodeHtml: function(html) { return ASPx.Str.EncodeHtml(ASPx.Str.DecodeHtml(html)); },
    setData: function(data, dataSetter, dataType) {
        if(dataType === undefined)
            throw new Error("Specify the dataType");
        if(dataType == Security.DataType.Untrusted)
            data = Security.safeEncodeHtml(data);
        dataSetter(data);
    }
};
Security.DataType = {
    Trusted: 0,
    Untrusted: 1
};

ASPx.EnableCssAnimation = true;

var AnimationTransitionBase = ASPx.CreateClass(null, {
    constructor: function(element, options) {
        if(element) {
            AnimationTransitionBase.Cancel(element);
            this.element = element;
            this.element.aspxTransition = this;
        }
        this.duration = options.duration || AnimationConstants.Durations.DEFAULT;
        this.transition = options.transition || AnimationConstants.Transitions.SINE;
        this.property = options.property;
        this.unit = options.unit || "";
        this.onComplete = options.onComplete;
        this.to = null;
        this.from = null;
    },
    /* Public */
    Start: function(from, to) {
        if(to != undefined) {
            this.to = to;
            this.from = from;
            this.SetValue(this.from);
        }
        else
            this.to = from;
    },
    Cancel: function() {
        if(!this.element)
            return;
        try {
            delete this.element.aspxTransition;
        } catch(e) {
            this.element.aspxTransition = undefined;
        }
    },
    GetValue: function() {
        return this.getValueInternal(this.element, this.property);
    },
    SetValue: function(value) {
        this.setValueInternal(this.element, this.property, this.unit, value);
    },
    /* Private */
    setValueInternal: function(element, property, unit, value) {
        if(property == "opacity")
            AnimationUtils.setOpacity(element, value);
        else
            element.style[property] = value + unit;
    },
    getValueInternal: function(element, property) {
        if(property == "opacity")
            return ASPx.GetElementOpacity(element);
        var value = parseFloat(element.style[property]);
        return isNaN(value) ? 0 : value;
    },
    performOnComplete: function() {
        if(this.onComplete)
            this.onComplete(this.element);
    },
    getTransition: function() {
        return this.transition;
    }
});
AnimationTransitionBase.Cancel = function(element) {
    if(element.aspxTransition)
        element.aspxTransition.Cancel();
};

var AnimationConstants = {};
AnimationConstants.Durations = {
    SHORT: 200,
    DEFAULT: 400,
    LONG: 600
};
AnimationConstants.Transitions = {
    LINER: {
        Css: "cubic-bezier(0.250, 0.250, 0.750, 0.750)",
        Js: function(progress) { return progress; }
    },
    SINE: {
        Css: "cubic-bezier(0.470, 0.000, 0.745, 0.715)",
        Js: function(progress) { return Math.sin(progress * 1.57); }
    },
    POW: {
        Css: "cubic-bezier(0.755, 0.050, 0.855, 0.060)",
        Js: function(progress) { return Math.pow(progress, 4); }
    },
    POW_EASE_OUT: {
        Css: "cubic-bezier(0.165, 0.840, 0.440, 1.000)",
        Js: function(progress) { return 1 - AnimationConstants.Transitions.POW.Js(1 - progress); }
    },
    RIPPLE: {
        Css: "cubic-bezier(0.47, 0.06, 0.23, 0.99)",
        Js: function(progress) {
            return Math.pow((progress), 3) * 0.47 + 3 * progress * Math.pow((1 - progress), 2) * 0.06 + 3 * Math.pow(progress, 2) *
                (1 - progress) * 0.23 + 0.99 * Math.pow(progress, 3);
        }
    }
};

var JsAnimationTransition = ASPx.CreateClass(AnimationTransitionBase, {
    constructor: function(element, options) {
        this.constructor.prototype.constructor.call(this, element, options);
        this.onStep = options.onStep;
        this.fps = 60;
        this.startTime = null;
    },
    /* Public */
    Start: function(from, to) {
        if(from == to) {
            this.from = this.to = from;
            setTimeout(this.complete.aspxBind(this), 0);
        }
        else {
            AnimationTransitionBase.prototype.Start.call(this, from, to);
            if(to == undefined)
                this.from = this.GetValue();
            this.initTimer();
        }
    },
    Cancel: function() {
        AnimationTransitionBase.prototype.Cancel.call(this);
        if(this.timerId)
            clearInterval(this.timerId);
    },
    /* Private */
    initTimer: function() {
        this.startTime = new Date();
        this.timerId = window.setInterval(function() { this.onTick(); }.aspxBind(this), 1000 / this.fps);
    },
    onTick: function() {
        var progress = (new Date() - this.startTime) / this.duration;
        if(progress >= 1)
            this.complete();
        else {
            this.update(progress);
            if(this.onStep)
                this.onStep();
        }
    },
    update: function(progress) {
        this.SetValue(this.gatCalculatedValue(this.from, this.to, progress));
    },
    complete: function() {
        this.Cancel();
        this.update(1);
        this.performOnComplete();
    },
    gatCalculatedValue: function(from, to, progress) {
        if(progress == 1)
            return to;
        return from + (to - from) * this.getTransition()(progress);
    },
    getTransition: function() {
        return this.transition.Js;
    }
});

var SimpleAnimationTransition = ASPx.CreateClass(JsAnimationTransition, {
    constructor: function(options) {
        this.constructor.prototype.constructor.call(this, null, options);
        this.transition = options.transition || AnimationConstants.Transitions.POW_EASE_OUT;
        this.onUpdate = options.onUpdate;
        this.lastValue = 0;
    },
    SetValue: function(value) {
        this.onUpdate(value - this.lastValue);
        this.lastValue = value;
    },
    GetValue: function() {
        return this.lastValue;
    },
    performOnComplete: function() {
        if(this.onComplete)
            this.onComplete();
    }
});

var MultipleJsAnimationTransition = ASPx.CreateClass(JsAnimationTransition, {
    constructor: function(element, options) {
        this.constructor.prototype.constructor.call(this, element, options);
        this.properties = {};
    },
    Start: function(properties) {
        this.initProperties(properties);
        this.initTimer();
    },
    /* Private */
    initProperties: function(properties) {
        this.properties = properties;
        for(var propName in this.properties)
            if(properties[propName].from == undefined)
                properties[propName].from = this.getValueInternal(this.element, propName);
    },
    update: function(progress) {
        for(var propName in this.properties) {
            if(this.properties.hasOwnProperty(propName)) {
                var property = this.properties[propName];
                if(property.from != property.to)
                    this.setValueInternal(this.element, propName, property.unit, this.gatCalculatedValue(property.from, property.to, progress));
            }
        }
    }
});

var CssAnimationTransition = ASPx.CreateClass(AnimationTransitionBase, {
    constructor: function(element, options) {
        this.constructor.prototype.constructor.call(this, element, options);
        this.transitionPropertyName = AnimationUtils.CurrentTransition.property;
        this.eventName = AnimationUtils.CurrentTransition.event;
    },
    /* Public */
    Start: function(from, to) {
        AnimationTransitionBase.prototype.Start.call(this, from, to);
        // B251923
        // This code should be executed on the end of all calculation.
        // It is not correct to modify an object while animation is running.
        this.startTimerId = window.setTimeout(function() {
            if(this.from == this.to)
                this.onTransitionEnd();
            else {
                var isHidden = ASPx.GetElementOffsetHeight(this.element) == 0 && ASPx.GetElementOffsetWidth(this.element) == 0; // B252495
                if(!isHidden)
                    this.prepareElementBeforeAnimation();
                this.SetValue(this.to);
                if(isHidden)
                    this.onTransitionEnd();
            }
        }.aspxBind(this), 0);
    },
    Cancel: function() {
        window.clearTimeout(this.startTimerId);
        AnimationTransitionBase.prototype.Cancel.call(this);
        ASPx.Evt.DetachEventFromElement(this.element, this.eventName, CssAnimationTransition.transitionEnd);
        this.setValueInternal(this.element, this.transitionPropertyName, "", "");
        this.stopAnimation();
    },
    /* Private */
    prepareElementBeforeAnimation: function() {
        ASPx.Evt.AttachEventToElement(this.element, this.eventName, CssAnimationTransition.transitionEnd);
        var dummy = this.element.offsetHeight;
        this.element.style[this.transitionPropertyName] = this.getTransitionCssString();

        if(ASPx.Browser.Safari && ASPx.Browser.MacOSMobilePlatform && ASPx.Browser.MajorVersion >= 8) //T267914
            setTimeout(function() {
                if(this.element && this.element.aspxTransition) {
                    this.element.style[this.transitionPropertyName] = "";
                    this.element.aspxTransition.onTransitionEnd();
                }
            }.aspxBind(this), this.duration + 100);
    },
    stopAnimation: function() {
        this.SetValue(ASPx.GetCurrentStyle(this.element)[this.property]);
    },
    onTransitionEnd: function() {
        this.Cancel();
        this.performOnComplete();
    },
    getTransition: function() {
        return this.transition.Css;
    },
    getTransitionCssString: function() {
        return this.getTransitionCssStringInternal(this.getCssName(this.property));
    },
    getTransitionCssStringInternal: function(cssProperty) {
        return cssProperty + " " + this.duration + "ms " + this.getTransition();
    },
    getCssName: function(property) {
        switch(property) {
            case "marginLeft":
                return "margin-left";
            case "marginTop":
                return "margin-top";
        }
        return property;
    }
});

var MultipleCssAnimationTransition = ASPx.CreateClass(CssAnimationTransition, {
    constructor: function(element, options) {
        this.constructor.prototype.constructor.call(this, element, options);
        this.properties = null;
    },
    Start: function(properties) {
        this.properties = properties;
        this.forEachProperties(function(property, propName) {
            if(property.from !== undefined)
                this.setValueInternal(this.element, propName, property.unit, property.from);
        }.aspxBind(this));

        this.prepareElementBeforeAnimation();

        window.setTimeout(function() {
            this.forEachProperties(function(property, propName) {
                this.setValueInternal(this.element, propName, property.unit, property.to);
            }.aspxBind(this));
        }.aspxBind(this), 0);
    },
    /* Private */
    stopAnimation: function() {
        var style = ASPx.GetCurrentStyle(this.element);
        this.forEachProperties(function(property, propName) {
            this.setValueInternal(this.element, propName, "", style[propName]);
        }.aspxBind(this));
    },
    getTransitionCssString: function() {
        var str = "";
        this.forEachProperties(function(property, propName) {
            str += this.getTransitionCssStringInternal(this.getCssName(propName)) + ",";
        }.aspxBind(this));
        str = str.substring(0, str.length - 1);
        return str;
    },
    forEachProperties: function(func) {
        for(var propName in this.properties) {
            if(this.properties.hasOwnProperty(propName)) {
                var property = this.properties[propName];
                if(property.from == undefined)
                    property.from = this.getValueInternal(this.element, propName);
                if(property.from != property.to)
                    func(property, propName);
            }
        }
    }
});

CssAnimationTransition.transitionEnd = function(evt) {
    var element = evt.target;
    if(element && element.aspxTransition)
        element.aspxTransition.onTransitionEnd();
};
var AnimationUtils = {
    CanUseCssTransition: function() { return ASPx.EnableCssAnimation && this.CurrentTransition; },
    CanUseCssTransform: function() { return this.CanUseCssTransition() && this.CurrentTransform; },

    CurrentTransition: (function() {
        if(ASPx.Browser.IE) //TODO ASPxFileManager, ASPxHtmlEditor
            return null;
        var transitions = [
            { property: "webkitTransition", event: "webkitTransitionEnd" },
            { property: "MozTransition", event: "transitionend" },
            { property: "OTransition", event: "oTransitionEnd" },
            { property: "transition", event: "transitionend" }
        ];
        var fakeElement = document.createElement("DIV");
        for(var i = 0; i < transitions.length; i++)
            if(transitions[i].property in fakeElement.style)
                return transitions[i];
    })(),
    CurrentTransform: (function() {
        var transforms = ["transform", "MozTransform", "-webkit-transform", "msTransform", "OTransform"];
        var fakeElement = document.createElement("DIV");
        for(var i = 0; i < transforms.length; i++)
            if(transforms[i] in fakeElement.style)
                return transforms[i];
    })(),

    SetTransformValue: function(element, position, isTop) {
        if(this.CanUseCssTransform())
            element.style[this.CurrentTransform] = this.GetTransformCssText(position, isTop);
        else
            element.style[!isTop ? "left" : "top"] = position + "px";
    },
    GetTransformValue: function(element, isTop) {
        if(this.CanUseCssTransform()) {
            var cssValue = element.style[this.CurrentTransform];
            return cssValue && cssValue != "none" ? Number(cssValue.replace('matrix(1, 0, 0, 1,', '').replace(')', '').split(',')[!isTop ? 0 : 1]) : 0;
        }
        else
            return !isTop ? element.offsetLeft : element.offsetTop;
    },
    GetTransformCssText: function(position, isTop) {
        if(!position)
            return "none";
        return "matrix(1, 0, 0, 1," + (!isTop ? position : 0) + ", " + (!isTop ? 0 : position) + ")";
    },
    createMultipleAnimationTransition: function (element, options) {
        return this.CanUseCssTransition() && !options.onStep ? new MultipleCssAnimationTransition(element, options) : new MultipleJsAnimationTransition(element, options);
    },
    createSimpleAnimationTransition: function(options) {
        return new SimpleAnimationTransition(options);
    },
    createJsAnimationTransition: function(element, options) {
        return new JsAnimationTransition(element, options);
    },
    createCssAnimationTransition: function(element, options) {
        return new CssAnimationTransition(element, options);
    },
    setOpacity: function(element, value) {
        ASPx.SetElementOpacity(element, value);
    }
};

var AsyncTracker = function() {
    var currentToken,
        lockedTokens,
        onDoneDelegates,
        lockedDelegates;

    function clearState() {
        currentToken = 1;
        lockedTokens = [];
        onDoneDelegates = [];
        lockedDelegates = {};
    }
    clearState();
                

    var log = function(msg) { };
    function setLog(delegate){
        log = delegate;
    }

    function getLockToken() {
        if(onDoneDelegates.length === 0)
            return -1;

        var token = currentToken++;

        lockedTokens.push(token);
        lockedDelegates[token] = [];

        for (var i = 0; i < onDoneDelegates.length; i++) {
            lockedDelegates[token].push(onDoneDelegates[i]);
        }

        log("module locks token " + token);

        return token;
    }

    function releaseToken(token) {
        if(token < 0) return;

        log("module releasing token " + token);

        ASPx.Data.ArrayRemove(lockedTokens, token);
        delete lockedDelegates[token];

        invokeUnlockedDelegates();

        if(lockedTokens.length === 0)
            clearState();

        log("module released token " + token);
    }
    function invokeUnlockedDelegates() {
        var onDoneDelegate;
        for (var i = onDoneDelegates.length - 1; i >= 0; i--) {
            if(onDoneDelegates[i] && !isDelegateLocked(onDoneDelegates[i])) {
                onDoneDelegate = onDoneDelegates[i];
                delete onDoneDelegates[i];
                onDoneDelegate();
            }
        }
    }
    function isDelegateLocked(delegate) {
        for (var i = lockedTokens.length - 1; i >= 0; i--) {
            var token = lockedTokens[i];
            var delegates = lockedDelegates[token];
            if(delegates) {
                for (var j = delegates.length - 1; j >= 0; j--) {
                    if(delegates[j] && delegates[j] === delegate)
                        return true;
                }
            }
        }
        return false;
    }

    function track(doDelegate, onDoneDelegate) {
        if(onDoneDelegate)
            onDoneDelegates.push(onDoneDelegate);

        doDelegate();
        
        if(onDoneDelegate)
            invokeUnlockedDelegates();
    }

    return {
        getLockToken: getLockToken,
        releaseToken: releaseToken,
        track: track,
        setLog:setLog,
    };
};

var GetEditorValuesInContainer = function(containerOrId, processInvisibleEditors, needSerialize) {
    var container = typeof(containerOrId) === "string" ? ASPx.GetElementById(containerOrId) : containerOrId;
    var result = {};
    if(!ASPx.ProcessEditorsInContainer) //T687593
        return result;
    ASPx.ProcessEditorsInContainer(container, function(editor){
        result[editor.name] = GetCorrectedByTypeValue(ASPx.GetEditorValueByControl(editor), needSerialize);
    }, null, null, processInvisibleEditors, false);
    return result;
};
var SetEditorValues = function(values) {
    for(var controlName in values) {
        if(values.hasOwnProperty(controlName)) {
            var trackedControl = ASPxClientControl.GetControlCollection().Get(controlName);
            if(!trackedControl)
                continue;
            var setValueMethod = trackedControl.SetTokenCollection || trackedControl.SelectValues || trackedControl.SetValue;
            if(setValueMethod === trackedControl.SelectValues)
                trackedControl.UnselectAll();
            setValueMethod.call(trackedControl, values[controlName]);
        }
    }
};
var GetCorrectedByTypeValue = function(value, needSerialize){
    if(ASPx.Ident.IsArray(value))
        for(var i = 0; i < value.length; i++)
            value[i] = GetCorrectedByTypeValue(value[i]);
    if(needSerialize && ASPx.Ident.IsDate(value))
        return ASPx.DateUtils.GetInvariantDateTimeString(value);
    return value;
};

var ListBoxTemporaryCache = ASPx.CreateClass(null, {
    constructor: function() { 
        this.cache = { };
        this.invalidateTimerID = -1;
    },

    Get: function(key, getObjectFunc, context, args) {
        if(this.invalidateTimerID < 0) {
            this.invalidateTimerID = window.setTimeout(function() {
                this.Invalidate();
            }.aspxBind(this), 0);
        }

        if(!ASPx.IsExists(this.cache[key])) {
            if(!ASPx.IsExists(args))
                args = [ ];
            this.cache[key] = getObjectFunc.apply(context, args);
        }
        return this.cache[key];
    },

    Invalidate: function() {
        this.cache = { };
        this.invalidateTimerID = ASPx.Timer.ClearTimer(this.invalidateTimerID);
    }
});

ASPx.GetEditorValueByControl = function(control, needSerialize) {
    var result;
    if(ASPx.IsMultipleValueOwner(control))
        result = control.GetSelectedValues();
    if(ASPx.IsTokenBox(control)) {
        if(needSerialize)
            result = control.GetTokenValuesCollection();
        else
            result = control.GetTokenCollection();
    }
    if(ASPx.IsDropDownEdit(control))
        result = control.GetKeyValue();
    return result || control.GetValue();
};

ASPx.IsMultipleValueOwner = function(control) {
    return ASPx.IsListBox(control) || ASPx.IsCheckBoxList(control);
};
ASPx.IsCheckBoxList = function(control) {
    return control && typeof(ASPxClientCheckBoxList) != "undefined" && control instanceof ASPxClientCheckBoxList;
};
ASPx.IsListBox = function(control) {
    return control && typeof(ASPxClientListBox) != "undefined" && control instanceof ASPxClientListBox;
};
ASPx.IsComboBox = function(control) {
    return control && typeof(ASPxClientComboBox) != "undefined" && control instanceof ASPxClientComboBox;
};
ASPx.IsTokenBox = function(control) {
    return control && typeof(ASPxClientTokenBox) != "undefined" && control instanceof ASPxClientTokenBox;
};
ASPx.IsDropDownEdit = function(control) {
    return control && typeof (ASPxClientDropDownEdit) != "undefined" && control instanceof ASPxClientDropDownEdit;
};
ASPx.IsGridLookup = function(control) {
    return control && typeof(MVCxClientGridLookup) != "undefined" && control instanceof MVCxClientGridLookup;
};
ASPx.IsSpinEdit = function(control) {
    return control && typeof(ASPxClientSpinEdit) != "undefined" && control instanceof ASPxClientSpinEdit;
};

ASPx.DatePickerType = {
    Days: 0,
    Months: 1,
    Years: 2,
    Decades: 3
};

ASPx.FullScreenUtils = {
    subscribeChange: function(handler) {
        Evt.AttachEventToElement(document, "fullscreenchange", handler);
        Evt.AttachEventToElement(document, "msfullscreenchange", handler); // Edge
        Evt.AttachEventToElement(document, "MSFullscreenChange", handler); // IE11
        Evt.AttachEventToElement(document, "webkitfullscreenchange", handler);
        Evt.AttachEventToElement(document, "mozfullscreenchange", handler);
    },
    unsubscribeChange: function(handler) {
        Evt.DetachEventFromElement(document, "fullscreenchange", handler);
        Evt.DetachEventFromElement(document, "msfullscreenchange", handler);
        Evt.DetachEventFromElement(document, "MSFullscreenChange", handler);
        Evt.DetachEventFromElement(document, "webkitfullscreenchange", handler);
        Evt.DetachEventFromElement(document, "mozfullscreenchange", handler);
    },
    setFullscreen: function(on) {
        var element = window.self.document.body;

        if(on) {
            if(element.requestFullscreen) {
                element.requestFullscreen();
            } else if(element.mozRequestFullScreen) {
                element.mozRequestFullScreen();
            } else if(element.webkitRequestFullscreen) {
                element.webkitRequestFullscreen();
            } else if(element.msRequestFullscreen) {
                element.msRequestFullscreen();
            }
        } else {
            if(document.exitFullscreen) {
                document.exitFullscreen();
            } else if(document.mozCancelFullScreen) {
                document.mozCancelFullScreen();
            } else if(document.webkitCancelFullScreen) {
                document.webkitCancelFullScreen();
            } else if(document.msExitFullscreen) {
                document.msExitFullscreen();
            }
        }
    },
    inFullscreen: function() {
        var fullscreenElement = document.fullscreenElement || document.msFullscreenElement || document.webkitFullscreenElement;
        var isInFullscreen = fullscreenElement === document.body || document.webkitIsFullScreen;
        return !!isInFullscreen;
    }
    };

ASPx.InitializeSVGSprite = function () {
    if (ASPx.SVGSprites && ASPx.SVGSprites.length > 0) {
        var svgContainer = document.getElementById('svgContainer');
        var hasSvgContainer = !!svgContainer;
        if (!hasSvgContainer) {
            svgContainer = document.createElement('div');
            svgContainer.id = 'svgContainer';
            svgContainer.style.display = "none";
            document.body.appendChild(svgContainer);
        }
        for (var i = 0; i < ASPx.SVGSprites.length; i++) {
            svgContainer.innerHTML += ASPx.SVGSprites[i];
        }
        ASPx.SVGSprites = null;
    }
};

var GridDynamicStyleSheetHelper = ASPx.CreateClass(null, {
    constructor: function() {
        this.styleSheet = {};
        this.rules = {};
        this.updateLock = 0;
    },

    Update: function(control, styleName, rules) {
        var key = control.name + "_" + styleName;
        this.BeginUpdate(key);
        this.ChangeRules(key, rules);
        this.EndUpdate(key);
    },

    ChangeRules: function(key, rules) {
        if(key && rules)
            this.rules[key] = rules;
    },

    BeginUpdate: function(key) {
        this.updateLock++;
        this.RemoveStyleSheetElement(key);
    },

    EndUpdate: function(key) {
        this.updateLock--;
        if(this.updateLock !== 0)
            return;

        var styleArgs = [];
        var controlRules = this.rules[key];
        for(var i = 0; i < controlRules.length; i++) {
            var rule = controlRules[i];
            styleArgs.push(rule.selector + " { " + rule.cssText + " } ");
        }
        this.styleSheet[key] = this.CreateStyleSheet(key, styleArgs.join(""));
    },

    CreateStyleSheet: function(key, cssText) {
        var container = document.createElement("DIV");
        ASPx.Security.setInnerHtml(container, "<style type='text/css' id='" + key + "'>" + cssText + "</style>", ASPx.Security.DataType.Trusted);

        styleSheet = ASPx.GetNodeByTagName(container, "style", 0);
        if(styleSheet)
            ASPx.GetNodeByTagName(document, "HEAD", 0).appendChild(styleSheet);
        return styleSheet;
    },

    ClearStyleSheet: function(control, styleName) {
        var key = control.name + "_" + styleName;
        this.RemoveStyleSheetElement(key);
    },
    RemoveStyleSheetElement: function(key) {
        if(this.styleSheet[key]) {
            ASPx.RemoveElement(this.styleSheet[key]);
            delete this.styleSheet[key];
        }
    }
});
GridDynamicStyleSheetHelper.Instance = new GridDynamicStyleSheetHelper();
ASPx.GridDynamicStyleSheetHelper = GridDynamicStyleSheetHelper;

/*# public class ASPxClientUtils : JavaScriptObject #*/
ASPxClientUtils = {};
/*# public static string agent{ get{ return ""; } } #*/
ASPxClientUtils.agent = Browser.UserAgent;
/*# public static bool opera{ get{ return false; } } #*/
ASPxClientUtils.opera = Browser.Opera;
/*# [Obsolete("This property is now obsolete. Use the ASPxClientUtils.opera and ASPxClientUtils.browserMajorVersion properties instead.")] public static bool opera9 { get { return false; } } #*/
ASPxClientUtils.opera9 = Browser.Opera && Browser.MajorVersion == 9;
/*# public static bool safari{ get{ return false; } } #*/
ASPxClientUtils.safari = Browser.Safari;
/*# [Obsolete("This property is now obsolete. Use the ASPxClientUtils.safari and ASPxClientUtils.browserMajorVersion properties instead.")] public static bool safari3 { get { return false; } } #*/
ASPxClientUtils.safari3 = Browser.Safari && Browser.MajorVersion == 3;
/*# [Obsolete("This property is now obsolete. Use the ASPxClientUtils.safari and ASPxClientUtils.macOSPlatform properties instead.")] public static bool safariMacOS{ get { return false; } } #*/
ASPxClientUtils.safariMacOS = Browser.Safari && Browser.MacOSPlatform;
/*# public static bool chrome { get { return false; } } #*/
ASPxClientUtils.chrome = Browser.Chrome;
/*# public static bool ie{ get{ return false; } } #*/
ASPxClientUtils.ie = Browser.IE;
/*# [Obsolete("This property is now obsolete. Use the ASPxClientUtils.ie and ASPxClientUtils.browserMajorVersion properties instead.")] public static bool ie7 { get { return false; } } #*/
ASPxClientUtils.ie7 = Browser.IE && Browser.MajorVersion == 7;
/*# public static bool firefox{ get{ return false; } } #*/
ASPxClientUtils.firefox = Browser.Firefox;
/*# [Obsolete("This property is now obsolete. Use the ASPxClientUtils.firefox and ASPxClientUtils.browserMajorVersion properties instead.")] public static bool firefox3 { get { return false; } } #*/
ASPxClientUtils.firefox3 = Browser.Firefox && Browser.MajorVersion == 3;
/*# public static bool mozilla { get { return false; } } #*/
ASPxClientUtils.mozilla = Browser.Mozilla;
/*# public static bool netscape{ get{ return false; } } #*/
ASPxClientUtils.netscape = Browser.Netscape;
/*# public static double browserVersion { get { return 0.0; } } #*/
ASPxClientUtils.browserVersion = Browser.Version;
/*# public static int browserMajorVersion { get { return 0; } } #*/
ASPxClientUtils.browserMajorVersion = Browser.MajorVersion;
/*# public static bool macOSPlatform { get { return false; } } #*/
ASPxClientUtils.macOSPlatform = Browser.MacOSPlatform;
/*# public static bool windowsPlatform { get { return false; } } #*/
ASPxClientUtils.windowsPlatform = Browser.WindowsPlatform;
/*# public static bool webKitFamily { get { return false; } } #*/
ASPxClientUtils.webKitFamily = Browser.WebKitFamily;
/*# public static bool netscapeFamily { get { return false; } } #*/
ASPxClientUtils.netscapeFamily = Browser.NetscapeFamily;

/*# public static bool touchUI { get { return false; } } #*/
ASPxClientUtils.touchUI = Browser.TouchUI;
/*# public static bool webKitTouchUI { get { return false; } } #*/
ASPxClientUtils.webKitTouchUI = Browser.WebKitTouchUI;
/*# public static bool msTouchUI { get { return false; } } #*/
ASPxClientUtils.msTouchUI = Browser.MSTouchUI;

/*# public static bool iOSPlatform { get { return false; } } #*/
ASPxClientUtils.iOSPlatform = Browser.MacOSMobilePlatform;
/*# public static bool androidPlatform { get { return false; } } #*/
ASPxClientUtils.androidPlatform = Browser.AndroidMobilePlatform;


/*# public static void ArrayInsert(object[] array, object element){ } #*/
ASPxClientUtils.ArrayInsert = Data.ArrayInsert;
/*# public static void ArrayRemove(object[] array, object element){ } #*/
ASPxClientUtils.ArrayRemove = Data.ArrayRemove;
/*# public static void ArrayRemoveAt(object[] array, int index){ } #*/
ASPxClientUtils.ArrayRemoveAt = Data.ArrayRemoveAt;
/*# public static void ArrayClear(object[] array){ } #*/
ASPxClientUtils.ArrayClear = Data.ArrayClear;
/*# public static int ArrayIndexOf(object[] array, object element){ return 0; } #*/
ASPxClientUtils.ArrayIndexOf = Data.ArrayIndexOf;

/*# public static void AttachEventToElement(object element, string eventName, object method){ } #*/
ASPxClientUtils.AttachEventToElement = Evt.AttachEventToElement;
/*# public static void DetachEventFromElement(object element, string eventName, object method){ } #*/
ASPxClientUtils.DetachEventFromElement = Evt.DetachEventFromElement;

/*# public static object GetEventSource(object htmlEvent){ return null; } #*/
ASPxClientUtils.GetEventSource = Evt.GetEventSource;
/*# public static int GetEventX(object htmlEvent){ return 0; } #*/
ASPxClientUtils.GetEventX = Evt.GetEventX;
/*# public static int GetEventY(object htmlEvent){ return 0; } #*/
ASPxClientUtils.GetEventY = Evt.GetEventY;
/*# public static int GetKeyCode(object htmlEvent){ return 0; } #*/
ASPxClientUtils.GetKeyCode = Evt.GetKeyCode;

/*# public static bool PreventEvent(object htmlEvent){ return false; } #*/
ASPxClientUtils.PreventEvent = Evt.PreventEvent;
/*# public static bool PreventEventAndBubble(object htmlEvent){ return false; } #*/
ASPxClientUtils.PreventEventAndBubble = Evt.PreventEventAndBubble;
/*# public static bool PreventDragStart(object htmlEvent){ return false; } #*/
ASPxClientUtils.PreventDragStart = Evt.PreventDragStart;
/*# public static void ClearSelection(){ } #*/
ASPxClientUtils.ClearSelection = Selection.Clear;

/*# public static bool IsExists(object obj){ return false; } #*/
ASPxClientUtils.IsExists = ASPx.IsExists;
/*# public static bool IsFunction(object obj){ return false; } #*/
ASPxClientUtils.IsFunction = ASPx.IsFunction;

/*# public static int GetAbsoluteX(object element){ return 0; } #*/
ASPxClientUtils.GetAbsoluteX = ASPx.GetAbsoluteX;
/*# public static int GetAbsoluteY(object element){ return 0; } #*/
ASPxClientUtils.GetAbsoluteY = ASPx.GetAbsoluteY;
/*# public static void SetAbsoluteX(object element, int x){ } #*/
ASPxClientUtils.SetAbsoluteX = ASPx.SetAbsoluteX;
/*# public static void SetAbsoluteY(object element, int y){ } #*/
ASPxClientUtils.SetAbsoluteY = ASPx.SetAbsoluteY;

/*# public static int GetDocumentScrollTop(){ return 0; } #*/
ASPxClientUtils.GetDocumentScrollTop = ASPx.GetDocumentScrollTop;
/*# public static int GetDocumentScrollLeft(){ return 0; } #*/
ASPxClientUtils.GetDocumentScrollLeft = ASPx.GetDocumentScrollLeft;
/*# public static int GetDocumentClientWidth(){ return 0; } #*/
ASPxClientUtils.GetDocumentClientWidth = ASPx.GetDocumentClientWidth;
/*# public static int GetDocumentClientHeight(){ return 0; } #*/
ASPxClientUtils.GetDocumentClientHeight = ASPx.GetDocumentClientHeight;

/*# public static void AddClassNameToElement(object element, string className){ return; } #*/
ASPxClientUtils.AddClassNameToElement = ASPx.AddClassNameToElement;
/*# public static void RemoveClassNameFromElement(object element, string className){ return; } #*/
ASPxClientUtils.RemoveClassNameFromElement = ASPx.RemoveClassNameFromElement;
/*# public static void ToggleClassName(object element, string className, bool toggleState){ return; } #*/
ASPxClientUtils.ToggleClassName = ASPx.ToggleClassNameToElement;

/*# public static bool GetIsParent(object parentElement, object element){ return false; } #*/
ASPxClientUtils.GetIsParent = ASPx.GetIsParent;
/*# public static object GetParentById(object element, string id){ return null; } #*/
ASPxClientUtils.GetParentById = ASPx.GetParentById;
/*# public static object GetParentByTagName(object element, string tagName){ return null; } #*/
ASPxClientUtils.GetParentByTagName = ASPx.GetParentByTagName;
/*# public static object GetParentByClassName(object element, string className){ return null; } #*/
ASPxClientUtils.GetParentByClassName = ASPx.GetParentByPartialClassName;

/*# public static object GetChildById(object element, string id){ return null; } #*/
ASPxClientUtils.GetChildById = ASPx.GetChildById;
/*# public static object GetChildByTagName(object element, string tagName, int index){ return null; } #*/
ASPxClientUtils.GetChildByTagName = ASPx.GetChildByTagName;

/*# public static void SetCookie(string name, string value) { return; } #*/
/*# public static void SetCookie(string name, string value, DateTime expirationDate) { return; } #*/
ASPxClientUtils.SetCookie = Cookie.SetCookie;
/*# public static string GetCookie(string name) { return ""; } #*/
ASPxClientUtils.GetCookie = Cookie.GetCookie;
/*# public static void DeleteCookie(string name) { return; } #*/
ASPxClientUtils.DeleteCookie = Cookie.DelCookie;

/*# public static int GetShortcutCode(int keyCode, bool isCtrlKey, bool isShiftKey, bool isAltKey) { return 0; } #*/
ASPxClientUtils.GetShortcutCode = ASPx.GetShortcutCode; 
/*# public static int GetShortcutCodeByEvent(object htmlEvent) { return 0; } #*/
ASPxClientUtils.GetShortcutCodeByEvent = ASPx.GetShortcutCodeByEvent;
/*# public static int StringToShortcutCode(string shortcutString) { return 0; } #*/
ASPxClientUtils.StringToShortcutCode = ASPx.ParseShortcutString;

/*# public static string Trim(string str) { return ""; } #*/
ASPxClientUtils.Trim = Str.Trim; 
/*# public static string TrimStart(string str) { return ""; } #*/
ASPxClientUtils.TrimStart = Str.TrimStart;
/*# public static string TrimEnd(string str) { return ""; } #*/
ASPxClientUtils.TrimEnd = Str.TrimEnd;

/*# public static object GetEditorValuesInContainer(object containerOrId) {return null;} #*/
/*# public static object GetEditorValuesInContainer(object containerOrId, bool processInvisibleEditors) {return null;} #*/
ASPxClientUtils.GetEditorValuesInContainer = GetEditorValuesInContainer;

/*# public static void SetEditorValues(object values) { } #*/
ASPxClientUtils.SetEditorValues = SetEditorValues;

/*# public static void SendMessageToAssistiveTechnology(string message) { } #*/
ASPxClientUtils.SendMessageToAssistiveTechnology = ASPx.AccessibilityUtils.SendMessageToAssistiveTechnology;

window.ASPxClientUtils = ASPxClientUtils;
window.ListBoxTemporaryCache = ListBoxTemporaryCache;

ASPx.AnimationUtils = AnimationUtils;
ASPx.AnimationTransitionBase = AnimationTransitionBase;
ASPx.AnimationConstants = AnimationConstants;
ASPx.AsyncTracker = AsyncTracker;
ASPx.Security = Security;
})(ASPx, dx);
      

/// <reference path="Utils.js"/>
/*# namespace DevExpress.Web.Scripts #*/

(function module(ASPx, options) {
ASPx.modules.Classes = module;

ASPx.classesScriptParsed = false;
ASPx.documentLoaded = false; 
ASPx.CallbackType = {
    Data: "d",
    Common: "c"
};
ASPx.callbackState = {
    aborted: "aborted",
    inTurn: "inTurn",
    sent: "sent"
};

/*# public class ASPxClientEvent : JavaScriptObject #*/
var ASPxClientEvent = ASPx.CreateClass(null, {
    constructor: function() {
        this.handlerInfoList = [];
        this.firingIndex = -1;
    },
    /*# public void AddHandler(object handler){} #*/
    AddHandler: function(handler, executionContext) {
        if(typeof(executionContext) == "undefined")
            executionContext = null;
        this.RemoveHandler(handler, executionContext);
        var handlerInfo = ASPxClientEvent.CreateHandlerInfo(handler, executionContext);
        this.handlerInfoList.push(handlerInfo);
    },
    /*# public void RemoveHandler(object handler){} #*/
    RemoveHandler: function(handler, executionContext) {
        this.removeHandlerByCondition(function(handlerInfo) {
            return handlerInfo.handler == handler && 
                (!executionContext || handlerInfo.executionContext == executionContext);
        });
    },

    removeHandlerByCondition: function(predicate) {
         for(var i = this.handlerInfoList.length - 1; i >= 0; i--) {
            var handlerInfo = this.handlerInfoList[i];
            if(predicate(handlerInfo)) {
                ASPx.Data.ArrayRemoveAt(this.handlerInfoList, i);
                if(i <= this.firingIndex)
                    this.firingIndex--;
            }
        }
    },

    removeHandlerByControlName: function(controlName) {
        this.removeHandlerByCondition(function(handlerInfo) {
            return handlerInfo.executionContext &&  
                handlerInfo.executionContext.name === controlName;
        });
    },

    /*# public void ClearHandlers(){} #*/
    ClearHandlers: function() {
        this.handlerInfoList.length = 0;
    },
    /*# public void FireEvent(object source, ASPxClientEventArgs e){} #*/
    FireEvent: function(obj, args) {
        for(this.firingIndex = 0; this.firingIndex < this.handlerInfoList.length; this.firingIndex++) {
            var handlerInfo = this.handlerInfoList[this.firingIndex];
            handlerInfo.handler.call(handlerInfo.executionContext, obj, args);
        }
    },
    InsertFirstHandler: function(handler, executionContext){
        if(typeof(executionContext) == "undefined")
            executionContext = null;
        var handlerInfo = ASPxClientEvent.CreateHandlerInfo(handler, executionContext);
        ASPx.Data.ArrayInsert(this.handlerInfoList, handlerInfo, 0);
    },
    IsEmpty: function() {
        return this.handlerInfoList.length == 0;
    }
});
ASPxClientEvent.CreateHandlerInfo = function(handler, executionContext) {
    return {
        handler: handler,
        executionContext: executionContext
    };
};

/*# public delegate void ASPxClientEventHandler(object source, ASPxClientEventArgs e);#*/
/*# public class ASPxClientEventArgs: JavaScriptObject #*/
var ASPxClientEventArgs = ASPx.CreateClass(null, {
    /*# public ASPxClientEventArgs() : base(){} #*/
    constructor: function() {

    }
});
ASPxClientEventArgs.Empty = new ASPxClientEventArgs();

/*# public delegate void ASPxClientCancelEventHandler(object source, ASPxClientCancelEventArgs e);#*/
/*# public class ASPxClientCancelEventArgs: ASPxClientEventArgs #*/
var ASPxClientCancelEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
    /*# public ASPxClientCancelEventArgs() : base(){} #*/
    constructor: function(){
        this.constructor.prototype.constructor.call(this);
        /*# public bool cancel{ get{return false;} set{} } #*/
        this.cancel = false;
    }
});

/*# public delegate void ASPxClientProcessingModeEventHandler(object source, ASPxClientProcessingModeEventArgs e);#*/
/*# public class ASPxClientProcessingModeEventArgs: ASPxClientEventArgs #*/
var ASPxClientProcessingModeEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
    /*# public ASPxClientProcessingModeEventArgs(bool processOnServer) : base(){} #*/
    constructor: function(processOnServer){
        this.constructor.prototype.constructor.call(this);
        /*# public bool processOnServer{ get{return false;} set{} } #*/
        this.processOnServer = !!processOnServer;
    }
});

/*# public delegate void ASPxClientProcessingModeCancelEventHandler(object source, ASPxClientProcessingModeCancelEventArgs e);#*/
/*# public class ASPxClientProcessingModeCancelEventArgs: ASPxClientProcessingModeEventArgs #*/
var ASPxClientProcessingModeCancelEventArgs = ASPx.CreateClass(ASPxClientProcessingModeEventArgs, {
    /*# public ASPxClientProcessingModeCancelEventArgs(bool processOnServer) : base(processOnServer){} #*/
    constructor: function(processOnServer){
        this.constructor.prototype.constructor.call(this, processOnServer);
        /*# public bool cancel{ get{return false;} set{} } #*/
        this.cancel = false;
    }
});

/*# public class KnockoutObservableBoolean : JavaScriptObject #*/
/*# public class KnockoutObservableArray : JavaScriptObject #*/
    
var OrderedMap = ASPx.CreateClass(null, {
    constructor: function(){
        this.entries = {};
        this.firstEntry = null;
        this.lastEntry = null;
    },
    add: function(key, element) {
        var entry = this.addEntry(key, element);
        this.entries[key] = entry;
    },
    remove: function(key) {
        var entry = this.entries[key];
        if(entry === undefined)
            return;
        
        this.removeEntry(entry);
        delete this.entries[key];
    },
    clear: function() {
        this.markAllEntriesAsRemoved();
        this.entries = {};
        this.firstEntry = null;
        this.lastEntry = null;
    },
    get: function(key) {
        var entry = this.entries[key];
        return entry ? entry.value : undefined;
    },
    forEachEntry: function(processFunc, context) {
        context = context || this;
        for(var entry = this.firstEntry; entry; entry = entry.next) {
            if(entry.removed)
                continue;
            if(processFunc.call(context, entry.key, entry.value))
                return;
        }
    },
    addEntry: function(key, element) {
        var entry = { key: key, value: element, next: null, prev: null };
        if(!this.firstEntry)
            this.firstEntry = entry;
        else {
            entry.prev = this.lastEntry;
            this.lastEntry.next = entry;
        }
        this.lastEntry = entry;
        return entry;
    },
    removeEntry: function(entry) {
        if(this.firstEntry == entry)
            this.firstEntry = entry.next;
        if(this.lastEntry == entry)
            this.lastEntry = entry.prev;
        if(entry.prev)
            entry.prev.next = entry.next;
        if(entry.next)
            entry.next.prev = entry.prev;
        entry.removed = true;
    },
    markAllEntriesAsRemoved: function() {
        for(var entry = this.firstEntry; entry; entry = entry.next)
            entry.removed = true;
    }
});

var CollectionBase = ASPx.CreateClass(null, {
    constructor: function(){
        this.elementsMap = new OrderedMap();
        this.isASPxClientCollection = true;
    },
    
    Add: function(key, element) {
        this.elementsMap.add(key, element);
    },
    Remove: function(key) {
        this.elementsMap.remove(key);
    },
    Clear: function(){
        this.elementsMap.clear();
    },
    Get: function(key){
        return this.elementsMap.get(key);
    }
});

(function garbageCollector(ASPx, options) {
    ASPx.modules.garbageCollector = garbageCollector;
    
    var interval = options.GCCheckInterval;
    window.setInterval(collectObjects, interval);
    
    function canCollectObjects() {
        if (!ASPx.GetControlCollection) return false;
        var collection = ASPx.GetControlCollection();
        return collection && !collection.InCallback();
    }
    function collectObjects() {
        if (!canCollectObjects()) return;

        ASPx.GetControlCollectionCollection().RemoveDisposedControls();
        if(typeof(ASPx.GetStateController) != "undefined")
            ASPx.GetStateController().RemoveDisposedItems();
        if(ASPx.TableScrollHelperCollection)
            ASPx.TableScrollHelperCollection.RemoveDisposedObjects();
        if(ASPx.Ident.scripts.ASPxClientRatingControl)
            ASPxClientRatingControl.RemoveDisposedElementUnderCursor();
        
        var postHandler = ASPx.GetPostHandler();
        if(postHandler)
            postHandler.RemoveDisposedFormsFromCache();
    }
})(ASPx, options);

var ControlTree = ASPx.CreateClass(null, {
    constructor: function(controlCollection, container, controlFilter) {
        this.container = container;
        this.domMap = { };
        this.rootNode = this.createNode(null, null);
        this.createControlTree(controlCollection, container, controlFilter);
    },
    createControlTree: function(controlCollection, container, controlFilter) {
        controlCollection.ProcessControlsInContainer(container, function(control) {
            control.RegisterInControlTree(this);
        }.aspxBind(this), controlFilter);

        var fixedNodes = [];
        var fixedNodesChildren = [];
        for(var domElementID in this.domMap) {
            if(!this.domMap.hasOwnProperty(domElementID)) continue;
            var node = this.domMap[domElementID];
            var controlOwner = node.control ? node.control.controlOwner : null;
            if(controlOwner && this.domMap[controlOwner.name])
                continue;
            if(this.isFixedNode(node))
                fixedNodes.push(node);
            else {
                var parentNode = this.findParentNode(domElementID);
                parentNode = parentNode || this.rootNode;
                if(this.isFixedNode(parentNode))
                    fixedNodesChildren.push(node);
                else {
                    var childNode = node.mainNode || node;
                    this.addChildNode(parentNode, childNode);
                }
            }
        }
        for(var i = fixedNodes.length - 1; i >= 0; i--)
            this.insertChildNode(this.rootNode, fixedNodes[i], 0);
        for(var i = fixedNodesChildren.length - 1; i >= 0; i--)
            this.insertChildNode(this.rootNode, fixedNodesChildren[i], 0);
    },
    findParentNode: function(id) {
        var element = document.getElementById(id).parentNode;
        while(element && element.tagName !== "BODY") {
            if(element.id) {
                var parentNode = this.domMap[element.id];
                if(parentNode)
                    return parentNode;
            }
            element = element.parentNode;
        }
        return null;
    },
    addChildNode: function(node, childNode) {
        if(!childNode.parentNode) {
            node.children.push(childNode);
            childNode.parentNode = node;
        }
    },
    insertChildNode: function(node, childNode, index) {
        if(!childNode.parentNode) {
            ASPx.Data.ArrayInsert(node.children, childNode, index);
            childNode.parentNode = node;
        }
    },
    addRelatedNode: function(node, relatedNode) {
        this.addChildNode(node, relatedNode);
        relatedNode.mainNode = node;
    },
    isFixedNode: function(node) {
        var control = node.mainNode ? node.mainNode.control : node.control;
        return control && control.HasFixedPosition();
    },
    createNode: function(domElementID, control) {
        var node = {
            control: control,
            children: [],
            parentNode: null,
            mainNode: null
        };
        if(domElementID)
            this.domMap[domElementID] = node;
        return node;
    }
});

var ControlAdjuster = ASPx.CreateClass(null, {
    constructor: function() {
    },

    adjustControlsInHierarchy: function(controlCollection, adjustFunc, container, collapseControls, controlFilter) {
        var controlTree = new ASPx.ControlTree(controlCollection, container, controlFilter);
        this.adjustControlsInTree(controlTree.rootNode, adjustFunc, container, collapseControls);
    },
    adjustControlsInTree: function(treeNode, adjustFunc, container, collapseControls) {
        var observer = _aspxGetDomObserver();
        observer.pause(container, true);
        var documentScrollInfo;
        if(collapseControls) {
            documentScrollInfo = ASPx.GetOuterScrollPosition(document.body);
            this.collapseControls(treeNode);
        }
        var adjustNodes = [], 
            autoHeightNodes = [];
        var requireReAdjust = this.forEachControlCore(treeNode, collapseControls, adjustFunc, adjustNodes, autoHeightNodes);
        if(requireReAdjust)
            this.forEachControlsBackward(adjustNodes, collapseControls, adjustFunc);
        else {
            for(var i = 0, node; node = autoHeightNodes[i]; i++)
                node.control.AdjustAutoHeight();
        }
        if(collapseControls)
            ASPx.RestoreOuterScrollPosition(documentScrollInfo);
        observer.resume(container, true);
    },

    forEachControlCore: function(node, collapseControls, processFunc, adjustNodes, autoHeightNodes) {
        var requireReAdjust = false,
            size, newSize;
        if(node.control) {
            var checkReadjustment = collapseControls && node.control.IsControlCollapsed() && node.control.CanCauseReadjustment();
            if(checkReadjustment)
                size = node.control.GetControlPercentMarkerSize(false, true);
            if(node.control.IsControlCollapsed() && !node.control.IsExpandableByAdjustment())
                node.control.ExpandControl();
            node.control.isInsideHierarchyAdjustment = true;
            processFunc(node.control);
            node.control.isInsideHierarchyAdjustment = false;
            if(checkReadjustment) {
                newSize = node.control.GetControlPercentMarkerSize(false, true);
                requireReAdjust = size.width !== newSize.width;
            }
            if(node.control.sizingConfig.supportAutoHeight)
                autoHeightNodes.push(node);
            node.control.ResetControlPercentMarkerSize();
        }

        for(var childNode, i = 0; childNode = node.children[i]; i++)
            requireReAdjust = this.forEachControlCore(childNode, collapseControls, processFunc, adjustNodes, autoHeightNodes) || requireReAdjust;

        adjustNodes.push(node);
        return requireReAdjust;
    },
    forEachControlsBackward: function(adjustNodes, collapseControls, processFunc) {
        for(var i = 0, node; node = adjustNodes[i]; i++)
            this.forEachControlsBackwardCore(node, collapseControls, processFunc);
    },
    forEachControlsBackwardCore: function(node, collapseControls, processFunc) {
        if(node.control)
            processFunc(node.control);
        if(node.children.length > 1) {
            for(var i = 0, childNode; childNode = node.children[i]; i++) {
                if(childNode.control)
                    processFunc(childNode.control);
            }
        }
    },
    collapseControls: function(node) {
        for(var childNode, i = 0; childNode = node.children[i]; i++)
            this.collapseControls(childNode);
        if(node.control && node.control.NeedCollapseControl())
            node.control.CollapseControl();
    }
});

var controlAdjuster = null;
function GetControlAdjuster() {
    if(!controlAdjuster)
        controlAdjuster = new ControlAdjuster();
    return controlAdjuster;
}

/*# public delegate void ASPxClientDataCallback(object sender, string result); #*/

function _aspxFunctionIsInCallstack(currentCallee, targetFunction, depthLimit) {
    var candidate = currentCallee;
    var depth = 0;
    while(candidate && depth <= depthLimit) {
        candidate = candidate.caller;
        if(candidate == targetFunction)
            return true;
        depth++;
    }
    return false;
}
ASPx.attachToReady(aspxClassesWindowOnLoad);
function aspxClassesWindowOnLoad(){
    ASPx.documentLoaded = true;
    _aspxMoveLinkElements();
    _aspxSweepDuplicatedLinks();
    ResourceManager.SynchronizeResources();
    var externalScriptProcessor = GetExternalScriptProcessor();
    if(externalScriptProcessor)
        externalScriptProcessor.ShowErrorMessages();
    ASPx.AccessibilityUtils.initialize();
    ASPx.GetControlCollection().Initialize();
    _aspxInitializeScripts();
    _aspxInitializeLinks();
    _aspxInitializeFocus();
    ASPx.GetControlCollection().FinalizeInitialization();
}

// Identification
Ident = { };
Ident.IsDate = function(obj) {
    return obj && obj.constructor == Date;
};
Ident.IsRegExp = function(obj) {
    return obj && obj.constructor === RegExp;
};
Ident.IsArray = function(obj) {
    return obj && obj.constructor == Array;
};
Ident.IsASPxClientCollection = function(obj) {
    return obj && obj.isASPxClientCollection;
};
Ident.IsASPxClientControl = function(obj) {
    return obj && obj instanceof ASPxClientControlBase;
};
Ident.IsASPxClientEdit = function(obj) {
    return obj && obj.isASPxClientEdit;
};
Ident.IsFocusableElementRegardlessTabIndex = function (element) {
    var tagName = element.tagName;
    return tagName == "TEXTAREA" || tagName == "INPUT" || tagName == "A" ||
        tagName == "SELECT" || tagName == "IFRAME" || tagName == "OBJECT" || tagName == "BUTTON";
};
Ident.isDialogInvisibleControl = function(control) {
    return !!ASPx.Dialog && ASPx.Dialog.isDialogInvisibleControl(control);
};
Ident.isBatchEditUnusedEditor = function(control) {
    return !!ASPx.BatchEditHelper && ASPx.BatchEditHelper.isBatchEditUnusedEditor(control);
};
Ident.scripts = {};

// Values of unnamed fields must not be sent to the server on a callback
if(ASPx.IsFunction(window.WebForm_InitCallbackAddField)) {
    (function() {
        var original = window.WebForm_InitCallbackAddField;
        window.WebForm_InitCallbackAddField = function(name, value) {
            if(typeof(name) == "string" && name)
                original.apply(null, arguments);
        };
    })();
}

// Default button
ASPx.FireDefaultButton = function(evt, buttonID) {
    if(_aspxIsDefaultButtonEvent(evt, buttonID)) {
        var defaultButton = ASPx.GetElementById(buttonID);
        if(defaultButton && defaultButton.click) {
            if(ASPx.IsFocusable(defaultButton))
                defaultButton.focus();
            ASPx.Evt.DoElementClick(defaultButton);
            ASPx.Evt.PreventEventAndBubble(evt);
            return false;
        }
    }
    return true;
};
function _aspxIsDefaultButtonEvent(evt, defaultButtonID) {
    if(evt.keyCode != ASPx.Key.Enter)
        return false;
    var srcElement = ASPx.Evt.GetEventSource(evt);
    if(!srcElement || srcElement.id === defaultButtonID)
        return true;
    var tagName = srcElement.tagName;
    var type = srcElement.type;
    return tagName != "TEXTAREA" && tagName != "BUTTON" && tagName != "A" &&
        (tagName != "INPUT" || type != "checkbox" && type != "radio" && type != "button" && type != "submit" && type != "reset");
}

// Post Handler
var PostHandler = ASPx.CreateClass(null, {
    constructor: function() {
        this.Post = new ASPxClientEvent();
        this.PostFinalization = new ASPxClientEvent();

        this.observableForms = [];
        this.dxCallbackTriggers = {};
        this.lastSubmitElementName = null;
        this.beforeOnSubmit = function() { };

        this.ReplaceGlobalPostFunctions();
        this.HandleDxCallbackBeginning();
        this.HandleMSAjaxRequestBeginning();
    },
    Update: function() {
        this.ReplaceFormsSubmit(true);
    },
    ProcessPostRequest: function(ownerID, isCallback, isMSAjaxRequest, isDXCallback) {
        this.cancelPostProcessing = false;
        this.isMSAjaxRequest = isMSAjaxRequest;

        if(this.SkipRaiseOnPost(ownerID, isCallback, isDXCallback))
            return;
        var args = new PostHandlerOnPostEventArgs(ownerID, isCallback, isMSAjaxRequest, isDXCallback);
        this.Post.FireEvent(this, args);

        this.cancelPostProcessing = args.cancel;
        if(!args.cancel)
            this.PostFinalization.FireEvent(this, args);
    },

    SkipRaiseOnPost: function(ownerID, isCallback, isDXCallback) { // skip double callback processing (BeforeInitCallback, WebForm_DoCallback)
        if(!isCallback)
            return false;
        var dxOwner = isDXCallback && ASPx.GetControlCollection().GetByName(ownerID);
        if(dxOwner) {
            this.dxCallbackTriggers[dxOwner.uniqueID] = true;
            return false;
        }
        if(this.dxCallbackTriggers[ownerID]) {
            this.dxCallbackTriggers[ownerID] = false;
            return true;
        }
        return false;
    },
    ReplaceGlobalPostFunctions: function() {
        if(ASPx.IsFunction(window.__doPostBack))
            this.ReplaceDoPostBack();
        if(ASPx.IsFunction(window.WebForm_DoCallback))
            this.ReplaceDoCallback();
        if(ASPx.IsFunction(window.WebForm_ExecuteCallback))
            this.ReplaceExecuteCallback();
                        
        this.ReplaceFormsSubmit();
    },
    HandleDxCallbackBeginning: function() {
        ASPx.GetControlCollection().BeforeInitCallback.AddHandler(function(s, e) {
            aspxRaisePostHandlerOnPost(e.callbackOwnerID, true, false, true); 
        });
    },
    HandleMSAjaxRequestBeginning: function() {
        var pageRequestManager = ASPx.GetMSAjaxRequestManager();
        if(pageRequestManager != null && Ident.IsArray(pageRequestManager._onSubmitStatements)) {
            pageRequestManager._onSubmitStatements.unshift(function() {
                var postbackSettings = Sys.WebForms.PageRequestManager.getInstance()._postBackSettings;
                var postHandler = aspxGetPostHandler();
                aspxRaisePostHandlerOnPost(postbackSettings.asyncTarget, true, true);
                return !postHandler.cancelPostProcessing;
            });
        }
    },
    ReplaceDoPostBack: function() {
        var original = __doPostBack;
        __doPostBack = function(eventTarget, eventArgument) {
            var postHandler = aspxGetPostHandler();
            aspxRaisePostHandlerOnPost(eventTarget);
            if(postHandler.cancelPostProcessing)
                return;
            ASPxClientControl.postHandlingLocked = true;
            original(eventTarget, eventArgument);
            delete ASPxClientControl.postHandlingLocked;
        };
    },
    ReplaceDoCallback: function() {
        var original = WebForm_DoCallback;
        WebForm_DoCallback = function(eventTarget, eventArgument, eventCallback, context, errorCallback, useAsync) {
            var postHandler = aspxGetPostHandler();
            aspxRaisePostHandlerOnPost(eventTarget, true);
            if(postHandler.cancelPostProcessing)
                return;
            
            return original(eventTarget, eventArgument, eventCallback, context, errorCallback, useAsync);
        };
    },
    ReplaceExecuteCallback: function() {
        var original = WebForm_ExecuteCallback;
        var handler = this;
        WebForm_ExecuteCallback = function(callbackObject) {
            var isDxCallback = callbackObject && callbackObject.context && ASPx.GetControlCollection().Get(callbackObject.context) !== null;
            ASPx.callbackProcessed = false;
            original(callbackObject);
            if(isDxCallback && !ASPx.callbackProcessed) {
                var request = callbackObject.xmlRequest;
                if(handler.HasAppErrorOnCallback(request) && ASPxClientUtils.IsExists(callbackObject.eventCallback))
                    callbackObject.eventCallback(handler.GetServerErrorText(), callbackObject.context);
            }
        };
    },
    HasAppErrorOnCallback: function(request) {
        if(!request) return false;
        var isServerError = request.status && request.status == 500;
        var pattern = /<html[^>]*>([\w|\W]*)<\/html>/im;
        var text = request.responseText;
        return isServerError && !!text && pattern.test(text);
    },
    GetServerErrorText: function() {
        return "Internal Server Error";
    },    
    ReplaceFormsSubmit: function(checkObservableCollection) {
        for(var i = 0; i < document.forms.length; i++) { // In WebForms there will be only one form, but in MVC page can have multiple forms (B203688)
            var form = document.forms[i];
            
            if(checkObservableCollection && ASPx.Data.ArrayIndexOf(this.observableForms, form) >= 0)
                continue;

            if(form.submit)
                this.ReplaceFormSubmit(form);
            this.ReplaceFormOnSumbit(form);
            this.observableForms.push(form);
        }
    },
    ReplaceFormSubmit: function(form) {
        var originalSubmit = form.submit;
        form.submit = function() {
            var postHandler = aspxGetPostHandler();
            aspxRaisePostHandlerOnPost();
            if(postHandler.cancelPostProcessing)
                return false;
            var callee = arguments.callee;
            this.submit = originalSubmit;
            var submitResult = this.submit();
            this.submit = callee;
            return submitResult;
        };
        form = null;
    },
    ReplaceFormOnSumbit: function(form) {
        var originalSubmit = form.onsubmit;
        form.onsubmit = function() {
            var postHandler = aspxGetPostHandler();

            postHandler.beforeOnSubmit();

            if(postHandler.isMSAjaxRequest)
                postHandler.isMsAjaxRequest = false;
            else
                aspxRaisePostHandlerOnPost(postHandler.GetLastSubmitElementName());

            if(postHandler.cancelPostProcessing)
                return false;

            return ASPx.IsFunction(originalSubmit)
                ? originalSubmit.apply(this, arguments)
                : true;
        };
        form = null;
    },
    SetBeforeOnSubmit: function(action) {
        this.beforeOnSubmit = action;
    },
    SetLastSubmitElementName: function(elementName) {
        this.lastSubmitElementName = elementName;
    },
    GetLastSubmitElementName: function() {
        return this.lastSubmitElementName;
    },
    RemoveDisposedFormsFromCache: function(){
        for(var i = 0; this.observableForms && i < this.observableForms.length; i++){
            var form = this.observableForms[i];
            if(!ASPx.IsExistsElement(form)){
                ASPx.Data.ArrayRemove(this.observableForms, form);
                i--;
            }
        }
    }
});

function aspxRaisePostHandlerOnPost(ownerID, isCallback, isMSAjaxRequest, isDXCallback) {
    if(ASPxClientControl.postHandlingLocked) return;
    var postHandler = aspxGetPostHandler();
    if(postHandler)
        postHandler.ProcessPostRequest(ownerID, isCallback, isMSAjaxRequest, isDXCallback);
}
var aspxPostHandler;
function aspxGetPostHandler() {
    if(!aspxPostHandler)
        aspxPostHandler = new PostHandler();
    return aspxPostHandler;
}

var PostHandlerOnPostEventArgs = ASPx.CreateClass(ASPxClientCancelEventArgs, {
    constructor: function(ownerID, isCallback, isMSAjaxCallback, isDXCallback){
        this.constructor.prototype.constructor.call(this);
        this.ownerID = ownerID;
        this.isCallback = !!isCallback;
        this.isDXCallback = !!isDXCallback;
        this.isMSAjaxCallback = !!isMSAjaxCallback;
    }
});

// Resources manager
var ResourceManager = {
    HandlerStr: "DXR.axd?r=",
    ResourceHashes: {},
    
    SynchronizeResources: function(method){
        if(!method){
            method = function(name, resource) { 
                this.UpdateInputElements(name, resource); 
            }.aspxBind(this);
        }

        var resources = this.GetResourcesData();
        for(var name in resources)
            if(resources.hasOwnProperty(name))
                method(name, resources[name]);
    },
    GetResourcesData: function(){
        return {
            DXScript: this.GetResourcesElementsString(_aspxGetIncludeScripts(), "src", "DXScript"),
            DXCss: this.GetResourcesElementsString(_aspxGetLinks(), "href", "DXCss")
        };
    },
	ParseBundleSrc: function(elements, urlAttr){
        var timeStamp = "";
		var resourceUrlArray = [];

		for(var i = 0; i < elements.length; i++) {
            var resourceUrl = ASPx.Attr.GetAttribute(elements[i], urlAttr);
            if(resourceUrl) {
                var pos = resourceUrl.indexOf(this.HandlerStr);
                if(pos > -1){
                    var list = resourceUrl.substr(pos + this.HandlerStr.length);
                    
                    var ampPos = list.lastIndexOf("-");
                    if(ampPos > -1) {
                        timeStamp = list.substr(ampPos);
                        list = list.substr(0, ampPos);
                    }
                    var indexes = list.split(",");
                    for(var j = 0; j < indexes.length; j++) {
						resourceUrlArray.push(indexes[j]);
                    }
                }
                else
					resourceUrlArray.push(resourceUrl);
            }
        }
		return {
			'resourceUrlArray': resourceUrlArray,
			'timeStamp': timeStamp
		};
	},
	GetResourceHashes: function (id) {
	    if (!this.ResourceHashes[id])
	        this.ResourceHashes[id] = {};
	    return this.ResourceHashes[id];
	},
	GetResourcesElementsString: function (elements, urlAttr, id) {
        var hash = this.GetResourceHashes(id);
		
		var resourceUrlArray = this.ParseBundleSrc(elements, urlAttr).resourceUrlArray;
	    for(var i = 0; i < resourceUrlArray.length; i++) {
            hash[resourceUrlArray[i]] = resourceUrlArray[i];
        }

		var array = [];
    	for(var key in hash)
        	if(hash.hasOwnProperty(key))
            	array.push(key);
		return array.join(",");
	},
    GetNewResourcesElementString: function (element, urlAttr, id) {
        var originalUrl = ASPx.Attr.GetAttribute(element, urlAttr);
        var handlerStrIndex = originalUrl.indexOf(this.HandlerStr);
        var dxResources = handlerStrIndex > -1;
		if(!dxResources) return element[urlAttr];

	    var hash = this.GetResourceHashes(id);
		
		var srcInfo = this.ParseBundleSrc([element], urlAttr);
		var resourceUrlArray = srcInfo.resourceUrlArray;
		var timeStamp = srcInfo.timeStamp;
		var newResourceArray = [];

	    for(var i = 0; i < resourceUrlArray.length; i++) {
			 if(!hash[resourceUrlArray[i]])
				newResourceArray.push(resourceUrlArray[i]);
        }

	    var newResources = "";
	    if(newResourceArray.length > 0) {
	        var baseUrl = originalUrl.substr(0, handlerStrIndex);
	        newResources = baseUrl + this.HandlerStr + newResourceArray.join(",") + timeStamp;
	    }
		return newResources;
    },
    UpdateInputElements: function(typeName, list){
        for(var i = 0; i < document.forms.length; i++){
            var inputElement = document.forms[i][typeName];
            if(!inputElement)
                inputElement = this.CreateInputElement(document.forms[i], typeName);
            inputElement.value = list;
        }
    },
    CreateInputElement: function(form, typeName){
        var inputElement = ASPx.CreateHiddenField(typeName);
        form.appendChild(inputElement);
        return inputElement;
    }
};

// Javascript manager
ASPx.includeScriptPrefix = "dxis_";
ASPx.startupScriptPrefix = "dxss_";

var includeScriptsCache = {};
var createdIncludeScripts = [];
var appendedScriptsCount = 0;
var callbackOwnerNames = [];
var scriptsRestartHandlers = { };

function _aspxIsKnownIncludeScript(script) {
    return !!includeScriptsCache[script.src];
}
function _aspxCacheIncludeScript(script) {
    includeScriptsCache[script.src] = 1;
}

function _aspxProcessScriptsAndLinks(ownerName, isCallback) {
    if(!ASPx.documentLoaded) return; // Q206563

    _aspxProcessScripts(ownerName, isCallback);
    getLinkProcessor().process();
    ASPx.ClearCachedCssRules();
}
function _aspxGetStartupScripts(container) {
    return _aspxGetScriptsCore(ASPx.startupScriptPrefix, container);
}
function _aspxGetIncludeScripts() {
    return _aspxGetScriptsCore(ASPx.includeScriptPrefix);
}
function _aspxGetScriptsCore(prefix, container) {
    var result = [];
    var scripts;
    if(ASPx.IsExists(container))
        scripts = ASPx.GetNodesByTagName(container, "SCRIPT");
    else
        scripts = document.getElementsByTagName("SCRIPT");
    for(var i = 0; i < scripts.length; i++) {
        if(scripts[i].id.indexOf(prefix) == 0)
            result.push(scripts[i]);
    }
    return result;
}
function _aspxIsResourceLink(link) {
    if(typeof link !== "string")
        link = link.href;
    return link.toLowerCase().indexOf(ResourceManager.HandlerStr.toLowerCase()) >= 0;
}
function _aspxGetLinks(allLinks) {
    var result = [];
    var links = document.getElementsByTagName("LINK");
    for(var i = 0; i < links.length; i++) {
        if(allLinks || _aspxIsResourceLink(links[i]))
            result.push(links[i]);
    }
    return result;
}
/* jshint ignore:start */
function _aspxIsLinksLoaded() {
    var links = _aspxGetLinks(true);
    for(var i = 0, link; link = links[i]; i++)
        if(link.readyState && link.readyState.toLowerCase() == "loading")// B208826, B220948, B209968
                return false;
    return true;
}
/* jshint ignore:end */

function _aspxInitializeLinks() {
    var links = _aspxGetLinks(true);
    for(var i = 0; i < links.length; i++)
        links[i].loaded = true;    
}
var scriptExecutedAttrName = "data-executed";
var scriptDelayedExecutionAttrName = "data-dx-delayedeval";
ASPx.MarkInnerScriptBlocksAsDelayedExecution = function(scriptsContainer) {
    var scripts = scriptsContainer.querySelectorAll("script[id^=" + ASPx.startupScriptPrefix + "]");
    for(var i = 0; i < scripts.length; i++)
        ASPx.Attr.SetAttribute(scripts[i], scriptDelayedExecutionAttrName, true);
};
function isScriptExecuted(script) {
    return ASPx.Attr.GetAttribute(script, scriptExecutedAttrName);
}
function markScriptAsExecuted(script) {
    if(ASPx.Attr.GetAttribute(script, scriptDelayedExecutionAttrName))
        ASPx.Attr.RemoveAttribute(script, scriptDelayedExecutionAttrName);
    else
        ASPx.Attr.SetAttribute(script, scriptExecutedAttrName, true);
}
function _aspxInitializeScripts() {
    var scripts = _aspxGetIncludeScripts();
    for(var i = 0; i < scripts.length; i++)
        _aspxCacheIncludeScript(scripts[i]);            
        
    var startupScripts = _aspxGetStartupScripts();
    for(var i = 0; i < startupScripts.length; i++)
        markScriptAsExecuted(startupScripts[i]);
}
function _aspxSweepDuplicatedLinks() {
    var hash = { };
    var links = _aspxGetLinks();
    for(var i = 0; i < links.length; i++) {
        var href = links[i].href;
        if(!href)
            continue;
            
        if(hash[href]){
            if((ASPx.Browser.IE || !hash[href].loaded) && links[i].loaded) {
                ASPx.RemoveElement(hash[href]);
                hash[href] = links[i];
            }
            else
                ASPx.RemoveElement(links[i]);
        }
        else
            hash[href] = links[i];
    }
}
function _aspxSweepDuplicatedScripts() {
    var hash = { };
    var scripts = _aspxGetIncludeScripts();
    for(var i = 0; i < scripts.length; i++) {
        var src = scripts[i].src;
        if(!src) continue;
        
        if(hash[src])
            ASPx.RemoveElement(scripts[i]);
        else
            hash[src] = scripts[i];
    }
}
function _aspxAreScriptsEqual(script1, script2) {
    return script1.src == script2.src;
}
function _aspxProcessScripts(ownerName, isCallback) {
    var scripts = _aspxGetIncludeScripts();
    var previousCreatedScript = null;
    var firstCreatedScript = null;

    for(var i = 0; i < scripts.length; i++) {
        var script = scripts[i];
        if(script.src == "") continue; // B134651
        if(_aspxIsKnownIncludeScript(script))
            continue;
		
		var getOnlyNewResources = true;
        var onlyNewScripts = ResourceManager.GetNewResourcesElementString(script, "src", "DXScript", getOnlyNewResources);
        if (onlyNewScripts == "")
            continue;
        
		var createdScript = document.createElement("script");

        ASPx.Attr.AppendScriptType(createdScript);
        createdScript.src = onlyNewScripts;
        createdScript.id = script.id;
        if(ASPx.Data.ArrayIndexOf(createdIncludeScripts, createdScript, _aspxAreScriptsEqual) >= 0)
            continue;

        createdIncludeScripts.push(createdScript);
        ASPx.RemoveElement(script);

        if(ASPx.Browser.IE && ASPx.Browser.Version < 9) {
            createdScript.onreadystatechange = new Function("ASPx.OnScriptReadyStateChangedCallback(this, " + isCallback + ");");
        } else if(ASPx.Browser.Edge || ASPx.Browser.WebKitFamily || (ASPx.Browser.Firefox && ASPx.Browser.Version >= 4) || ASPx.Browser.IE && ASPx.Browser.Version >= 9) {
            // Organizing scripts into a linked list to perform their loading and execution sequentially
            createdScript.onload = new Function("ASPx.OnScriptLoadCallback(this, " + isCallback + ");");
            if(firstCreatedScript == null)
                firstCreatedScript = createdScript;
            createdScript.nextCreatedScript = null;
            if(previousCreatedScript != null)
                previousCreatedScript.nextCreatedScript = createdScript;
            previousCreatedScript = createdScript;
        } else {
            // Immediate script loading
            createdScript.onload = new Function("ASPx.OnScriptLoadCallback(this);");
            ASPx.AppendScript(createdScript);
            _aspxCacheIncludeScript(createdScript);
        }
    }

    // If a scripts linked list was organized, start script loading and executing from the first list element
    if(firstCreatedScript != null) {
        ASPx.AppendScript(firstCreatedScript);
        _aspxCacheIncludeScript(firstCreatedScript);
    }

    if(isCallback)
        callbackOwnerNames.push(ownerName);

    if(createdIncludeScripts.length == 0) {
        var newLinks = ASPx.GetNodesByTagName(document.body, "link");
        var needProcessLinks = isCallback && newLinks.length > 0;
        if(needProcessLinks)
            needProcessLinks = getLinkProcessor().addLinks(newLinks);
        if(!needProcessLinks)
            ASPx.FinalizeScriptProcessing(isCallback);
    }
}
ASPx.FinalizeScriptProcessing = function(isCallback) {
    createdIncludeScripts = [];
    appendedScriptsCount = 0;
    
    var linkProcessor = getLinkProcessor();
    if(linkProcessor.hasLinks())
        _aspxSweepDuplicatedLinks();
    linkProcessor.reset();

    _aspxSweepDuplicatedScripts();
    ResourceManager.SynchronizeResources();
    _aspxRunStartupScripts(isCallback);
};

var startupScriptsRunning = false;
function _aspxRunStartupScripts(isCallback, container) {
    startupScriptsRunning = true;
    try {
        _aspxRunStartupScriptsCore(container);
    }
    finally {
        startupScriptsRunning = false;
    }

    if(ASPx.documentLoaded) {// B133784
        ASPx.GetControlCollection().ProcessActionByPredicate(
            function(collection) { collection.InitializeElements(isCallback); },
            function(control) { return !ASPx.IsExists(container) || ASPx.GetIsParent(container, control.GetMainElement()); }
        );
        for(var key in scriptsRestartHandlers)
            if(scriptsRestartHandlers.hasOwnProperty(key))
                scriptsRestartHandlers[key]();
        if(isCallback)
            _aspxRunEndCallbackScript();
    }
}
function _aspxIsStartupScriptsRunning(isCallback) {
    return startupScriptsRunning;
}
function _aspxRunStartupScriptsCore(container) {
    var scripts = _aspxGetStartupScripts(container);
    var code;
    for(var i = 0; i < scripts.length; i++){
        var script = scripts[i];
        if(!isScriptExecuted(script)) {
            _aspxEnsureStartupScriptIsUnique(script.id); //T454370
            code = ASPx.GetScriptCode(script);
            eval(code);
            markScriptAsExecuted(script);
        }
    }
}
function _aspxEnsureStartupScriptIsUnique(scriptId) {
    if(!scriptId)
        return;
    var scriptExecutedSelector = "script[" + scriptExecutedAttrName + "='true']#" + scriptId;
    ASPx.RemoveElement(document.querySelector(scriptExecutedSelector));
}
function _aspxRunEndCallbackScript() {
    while(callbackOwnerNames.length > 0) {
        var callbackOwnerName = callbackOwnerNames.pop();
        var callbackOwner = ASPx.GetControlCollection().Get(callbackOwnerName);
        if(callbackOwner)
            callbackOwner.DoEndCallback();
    }
}

ASPx.RunStartupScriptsCreatedOnClient = function(container) {
    _aspxRunStartupScriptsCore(container);
};
ASPx.OnScriptReadyStateChangedCallback = function(scriptElement, isCallback) {
    if(scriptElement.readyState == "loaded") {
        _aspxCacheIncludeScript(scriptElement);

        for(var i = 0; i < createdIncludeScripts.length; i++) {
            var script = createdIncludeScripts[i];
            if(_aspxIsKnownIncludeScript(script)) {
                if(!isScriptExecuted(script)) {
                    markScriptAsExecuted(script);
                    ASPx.AppendScript(script);
                    appendedScriptsCount++;
                }
            } else
                break;
        }

        if(createdIncludeScripts.length == appendedScriptsCount)
            ASPx.FinalizeScriptProcessing(isCallback);
    }
};
ASPx.OnScriptLoadCallback = function(scriptElement, isCallback) {
    appendedScriptsCount++;

    if(scriptElement.nextCreatedScript) {
        ASPx.AppendScript(scriptElement.nextCreatedScript);
        _aspxCacheIncludeScript(scriptElement.nextCreatedScript);
    }

    if(createdIncludeScripts.length == appendedScriptsCount)
        ASPx.FinalizeScriptProcessing(isCallback);
};

function _aspxAddScriptsRestartHandler(objectName, handler) {
    scriptsRestartHandlers[objectName] = handler;
}

function _aspxMoveLinkElements() {
    var head = ASPx.GetNodesByTagName(document, "head")[0];
    var bodyLinks = ASPx.GetNodesByTagName(document.body, "link");
    if(head && bodyLinks.length > 0){
        var headLinks = ASPx.GetNodesByTagName(head, "link");
        var dxLinkAnchor = head.firstChild;
        for(var i = 0; i < headLinks.length; i++){
            if(_aspxIsResourceLink(headLinks[i]))
                dxLinkAnchor = headLinks[i].nextSibling;
        }
        while(bodyLinks.length > 0) 
            head.insertBefore(bodyLinks[0], dxLinkAnchor);
    }
}

var LinkProcessor = ASPx.CreateClass(null, {
    constructor: function() {
        this.loadedLinkCount = 0;
        this.linkInfos = [];
        this.loadingObservationTimerID = -1;
    },
    process: function() {
        if(this.hasLinks()) {
            if(this.isLinkLoadEventSupported())
                this.processViaLoadEvent();
            else
                this.processViaTimer();
        }
        else
            _aspxSweepDuplicatedLinks();

        _aspxMoveLinkElements();
    },
    addLinks: function(links) {
        var prevLinkCount = this.linkInfos.length;
        for(var i = 0; i < links.length; i++) {
            var link = links[i];
            if(link.loaded || link.rel != "stylesheet" || !_aspxIsResourceLink(link))
                continue;

            var linkInfo = {
                link: link,
                href: link.href
            };
            this.linkInfos.push(linkInfo);
        }
        return prevLinkCount != this.linkInfos.length;
    },
    hasLinks: function() {
        return this.linkInfos.length > 0;
    },
    reset: function() {
        this.linkInfos = [];
        this.loadedLinkCount = 0;
    },
    processViaLoadEvent: function() {
        var that = this;
        for(var i = 0, linkInfo; linkInfo = this.linkInfos[i]; i++) {
            if(ASPx.Browser.IE && ASPx.Browser.Version < 9)
                /*jshint -W083 */
                linkInfo.link.onreadystatechange = function() { that.onLinkReadyStateChanged(this); };
                /*jshint +W083 */
            else
                linkInfo.link.onload = this.onLinkLoad.aspxBind(this);
        }
    },
    isLinkLoadEventSupported: function() {
        return !(ASPx.Browser.Chrome && ASPx.Browser.MajorVersion < 19 || ASPx.Browser.Firefox && ASPx.Browser.MajorVersion < 9 ||
            ASPx.Browser.Safari && ASPx.Browser.MajorVersion < 6 || ASPx.Browser.AndroidDefaultBrowser && ASPx.Browser.MajorVersion < 4.4);
    },
    processViaTimer: function() {
        if(this.loadingObservationTimerID == -1)
            this.onLinksLoadingObserve();
    },
    onLinksLoadingObserve: function() {
        if(this.getIsAllLinksLoaded()) {
            this.loadingObservationTimerID = -1;
            this.onAllLinksLoad();
        }
        else
            this.loadingObservationTimerID = window.setTimeout(this.onLinksLoadingObserve.aspxBind(this), 100);
    },
    getIsAllLinksLoaded: function() {
        var styleSheets = document.styleSheets;
        var loadedLinkHrefs = { };
        for(var i = 0; i < styleSheets.length; i++) {
            var styleSheet = styleSheets[i];
            try {
                if(styleSheet.cssRules)
                    loadedLinkHrefs[styleSheet.href] = 1;
            }
            catch(ex) { }
        }
    
        var loadedLinksCount = 0;
        for(var i = 0, linkInfo; linkInfo = this.linkInfos[i]; i++) {
            if(loadedLinkHrefs[linkInfo.href])
                loadedLinksCount++;
        }

        return loadedLinksCount == this.linkInfos.length;
    },
    onAllLinksLoad: function() {
        this.reset();
        _aspxSweepDuplicatedLinks();
        if(createdIncludeScripts.length == 0)
            ASPx.FinalizeScriptProcessing(true);
    },
    onLinkReadyStateChanged: function(linkElement) {
        if(linkElement.readyState == "complete")
            this.onLinkLoadCore(linkElement);
    },
    onLinkLoad: function(evt) {
        var linkElement = ASPx.Evt.GetEventSource(evt);
        this.onLinkLoadCore(linkElement);
    },
    onLinkLoadCore: function(linkElement) {
        if(!this.hasLinkElement(linkElement)) return;
    
        this.loadedLinkCount++;

        if(!ASPx.Browser.Firefox && this.loadedLinkCount == this.linkInfos.length || 
            ASPx.Browser.Firefox && this.loadedLinkCount == 2 * this.linkInfos.length) {
            this.onAllLinksLoad();
        }
    },
    hasLinkElement: function(linkElement) {
        for(var i = 0, linkInfo; linkInfo = this.linkInfos[i]; i++) {
            if(linkInfo.link == linkElement)
                return true;
        }
        return false;
    }
});
var linkProcessor = null;
function getLinkProcessor() {
    if(linkProcessor == null)
        linkProcessor = new LinkProcessor();
    return linkProcessor;
}
ASPx.LinkProcessor = LinkProcessor;

// IFrame helper
var IFrameHelper = ASPx.CreateClass(null, {
    constructor: function(params) {
        this.params = params || {};
        this.params.src = this.params.src || "";
        this.CreateElements();
    },
    CreateElements: function() {
        var elements = IFrameHelper.Create(this.params);
        this.containerElement = elements.container;
        this.iframeElement = elements.iframe;

        this.AttachOnLoadHandler(this, this.iframeElement);
        this.SetLoading(true);
        
        if(this.params.onCreate)
            this.params.onCreate(this.containerElement, this.iframeElement);
    },
    AttachOnLoadHandler: function(instance, element) {
        ASPx.Evt.AttachEventToElement(element, "load", function() {
            instance.OnLoad(element);
        });
    },
    OnLoad: function(element) {
        this.SetLoading(false, element);
        if(!element.preventCustomOnLoad && this.params.onLoad)
            this.params.onLoad();
    },
    IsLoading: function(element) {
        element = element || this.iframeElement;
        if(element)
            return element.loading;
        return false;
    },
    SetLoading: function(value, element) {
        element = element || this.iframeElement;
        if(element)
            element.loading = value;
    },

    GetContentUrl: function() {
        return this.params.src;
    },
    SetContentUrl: function(url, preventBrowserCaching) {
        if(url) {
            this.params.src = url;
            if(preventBrowserCaching)
                url = IFrameHelper.AddRandomParamToUrl(url);
            this.SetLoading(true);
            this.iframeElement.src = url;
        }
    },
    RefreshContentUrl: function() {
        if(this.IsLoading())
            return;
        this.SetLoading(true);

        var oldContainerElement = this.containerElement;
        var oldIframeElement = this.iframeElement;
        
        var postfix = "_del" + Math.floor(Math.random()*100000).toString();
        if(this.params.id)
            oldIframeElement.id = this.params.id + postfix;
        if(this.params.name)
            oldIframeElement.name = this.params.name + postfix;
        
        ASPx.SetStyles(oldContainerElement, { height: 0 });

        this.CreateElements();

        oldIframeElement.preventCustomOnLoad = true;
        oldIframeElement.src = ASPx.BlankUrl;
        window.setTimeout(function() {
            oldContainerElement.parentNode.removeChild(oldContainerElement);
        }, 10000); // This value has been chosen randomly. We hope that the new page will be loaded after the 10 seconds
    }
});
IFrameHelper.Create = function(params) {
    var iframeHtmlStringParts = [ "<iframe frameborder='0'" ];
    if(params) {
        if(params.id)
            iframeHtmlStringParts.push(" id='", params.id, "'");
        if(params.name)
            iframeHtmlStringParts.push(" name='", params.name, "'");
        if(params.title)
            iframeHtmlStringParts.push(" title='", params.title, "'");
        if(params.scrolling)
            iframeHtmlStringParts.push(" scrolling='", params.scrolling, "'");
        if(params.src)
            iframeHtmlStringParts.push(" src='", params.src, "'");
    }
    iframeHtmlStringParts.push("></iframe>");
    
    var containerElement = ASPx.CreateHtmlElementFromString("<div style='border-width: 0px; padding: 0px; margin: 0px'></div>");
    var iframeElement = ASPx.CreateHtmlElementFromString(iframeHtmlStringParts.join(""));
    containerElement.appendChild(iframeElement);

    return {
        container: containerElement,
        iframe: iframeElement
    };
};
IFrameHelper.AddRandomParamToUrl = function(url) {
    var prefix = url.indexOf("?") > -1
        ? "&"
        : "?";
    var param = prefix + Math.floor(Math.random()*100000).toString();
    
    var anchorIndex = url.indexOf("#");
    return anchorIndex == -1
        ? url + param
        : url.substr(0, anchorIndex) + param + url.substr(anchorIndex);
};
IFrameHelper.GetWindow = function(name) {
    if(ASPx.Browser.IE)
        return window.frames[name].window;
    else{
        var frameElement = document.getElementById(name);
        return (frameElement != null) ? frameElement.contentWindow : null;
    }
};
IFrameHelper.GetDocument = function(name) {
    var frameElement;
    if(ASPx.Browser.IE) {
        frameElement = window.frames[name];
        return (frameElement != null) ? frameElement.document : null;
    }
    else {
        frameElement = document.getElementById(name);
        return (frameElement != null) ? frameElement.contentDocument : null;
    }
};
IFrameHelper.GetDocumentBody = function(name) {
    var doc = IFrameHelper.GetDocument(name);
    return (doc != null) ? doc.body : null;
};
IFrameHelper.GetDocumentHead = function (name) {
    var doc = IFrameHelper.GetDocument(name);
    return (doc != null) ? doc.head || doc.getElementsByTagName('head')[0] : null;
};
IFrameHelper.GetElement = function(name) {
    if(ASPx.Browser.IE)
        return window.frames[name].window.frameElement;
    else
        return document.getElementById(name);
};

// Keyboard helper
var KbdHelper = ASPx.CreateClass(null, {

    constructor: function(control) {
        this.control = control;
    },
    
    Init: function() {
        KbdHelper.GlobalInit();
        var elements = this.getFocusableElements();
        for(var i = 0; i < elements.length; i++) {
            var element = elements[i];
            element.tabIndex = Math.max(element.tabIndex, 0);
        
            ASPx.Evt.AttachEventToElement(element, "click", function(e) { this.HandleClick(e); }.aspxBind(this));
            ASPx.Evt.AttachEventToElement(element, "focus", function(e) {             
                return this.onElementFocus(e);
            }.aspxBind(this));
            ASPx.Evt.AttachEventToElement(element, "blur", function () { this.onBlur(); }.aspxBind(this)); 
        }         
    },
    onElementFocus: function(e) {
        if(!this.CanFocus(e))
            return true;
        KbdHelper.active = this;
    },

    getFocusableElements: function() {
        return [this.GetFocusableElement()];    
    },
    GetFocusableElement: function() { return this.control.GetMainElement(); },
    canHandleNoFocusAction: function() { 
        var focusableElements = this.getFocusableElements();
        for(var i = 0; i < focusableElements.length; i++) {
            if(focusableElements[i] === _aspxGetFocusedElement())
                return false;
        }
        return true;
    },
    
    RequirePreventScrollOnFocus: function() { return false; },
    CanFocus: function(e) {
        var tag = ASPx.Evt.GetEventSource(e).tagName;
        return !(tag === "A" || tag === "TEXTAREA" || tag === "INPUT" || tag === "SELECT" || tag === "IFRAME" || tag === "OBJECT");
    },
    
    HandleClick: function(e) {
        if(!this.CanFocus(e))
            return;
        this.Focus();
    },
    Focus: function() {
        var preventScroll = this.RequirePreventScrollOnFocus() && !ASPx.Browser.IE; // IE blinks
        var savedDocumentScrollTop = preventScroll ? ASPx.GetDocumentScrollTop() : -1;
        try {
            this.GetFocusableElement().focus({ preventScroll: preventScroll });
        } catch(e) { }
        if(preventScroll && !this.IsNativePreventScrollOnFocusSupported() && savedDocumentScrollTop !== ASPx.GetDocumentScrollTop())
            ASPx.SetDocumentScrollTop(savedDocumentScrollTop);
    },
    IsNativePreventScrollOnFocusSupported: function() {
        if(this.isNativePreventScrollOnFocusSupported === undefined)
            this.isNativePreventScrollOnFocusSupported = this.CalcIsNativePreventScrollOnFocusSupported();
        return this.isNativePreventScrollOnFocusSupported;
    },
    CalcIsNativePreventScrollOnFocusSupported: function() {
        var result = false;
        try {
            ASPx.GetActiveElement().focus(Object.defineProperty({}, "preventScroll", { get: function() { result = true; } }));
        } catch(e) { result = false; }
        return result;
    },
    onBlur: function(){
        delete KbdHelper.active;
    },
    
    HandleKeyDown: function(e) { },    
    HandleKeyPress: function(e) { },    
    HandleKeyUp: function (e) { },
    HandleNoFocusAction: function(e) { },
    FocusByAccessKey: function () { }
});

KbdHelper.GlobalInit = function() {
    if(KbdHelper.ready)
        return;
    ASPx.Evt.AttachEventToDocument("keydown", KbdHelper.OnKeyDown);
    ASPx.Evt.AttachEventToDocument("keypress", KbdHelper.OnKeyPress);
    ASPx.Evt.AttachEventToDocument("keyup", KbdHelper.OnKeyUp);
    KbdHelper.ready = true;    
};

KbdHelper.swallowKey = false;
KbdHelper.accessKeys = { };

KbdHelper.ProcessKey = function(e, actionName) {
    if(!KbdHelper.active) 
        return;
    if (KbdHelper.active.canHandleNoFocusAction()) {
        KbdHelper.active["HandleNoFocusAction"](e, actionName);
        return;
    }
    //B208466
    var ctl = KbdHelper.active.control;
    if(ctl !== ASPx.GetControlCollection().Get(ctl.name)) {
        delete KbdHelper.active;
        return;
    }

    if(!KbdHelper.swallowKey) 
        KbdHelper.swallowKey = KbdHelper.active[actionName](e);
    if(KbdHelper.swallowKey)
        ASPx.Evt.PreventEvent(e);
};

KbdHelper.OnKeyDown = function(e) {
    KbdHelper.swallowKey = false;
    if(KbdHelper.TryAccessKey(KbdHelper.getKeyName(e)))
        ASPx.Evt.PreventEvent(e);
    else    
        KbdHelper.ProcessKey(e, "HandleKeyDown"); 
};
KbdHelper.OnKeyPress = function(e) { KbdHelper.ProcessKey(e, "HandleKeyPress"); };
KbdHelper.OnKeyUp = function(e) { KbdHelper.ProcessKey(e, "HandleKeyUp"); };

KbdHelper.RegisterAccessKey = function(obj) {
    var key;
    if(obj.accessKey)
        key = "CtrlShift" + obj.accessKey;
    else if(obj.keyTipModeShortcut)
        key = obj.keyTipModeShortcut;
    if(!key) return;
    KbdHelper.accessKeys[key.toLowerCase()] = obj.name;
};
KbdHelper.TryAccessKey = function(code) {
    var key = code.toLowerCase ? code.toLowerCase() : String.fromCharCode(code).toLowerCase();
    var name = KbdHelper.accessKeys[key];
    if(!name) return false;
    var obj = ASPx.GetControlCollection().Get(name);
    return KbdHelper.ClickAccessKey(obj);
};

KbdHelper.ClickAccessKey = function (control) {
    if (!control) return false;
    var el = control.GetMainElement();
    if (!el) return false;
    el.focus();
    setTimeout(function () {
        if (KbdHelper.active && KbdHelper.active.FocusByAccessKey)
            KbdHelper.active.FocusByAccessKey();
    }.aspxBind(this), ASPx.FOCUS_TIMEOUT);
    return true;
};

KbdHelper.getKeyName = function(e) {
    var name = "";
    if(e.altKey)
        name += "Alt";
    if(e.ctrlKey)
        name += "Ctrl";
    if(e.shiftKey)
        name += "Shift";
    var keyCode = e.key || e.code || String.fromCharCode(ASPx.Evt.GetKeyCode(e));
    if(keyCode.match(/key/i))
        name += keyCode.replace(/key/i, "");
    else if(keyCode.match(/digit/i))
        name += keyCode.replace(/digit/i, "");
    else if(keyCode.match(/arrow/i))
        name += keyCode.replace(/arrow/i, "");
    else if(keyCode.match(/ins/i))
        name += "Ins";
    else if(keyCode.match(/del/i))
        name += "Del";
    else if(keyCode.match(/back/i))
        name += "Back";
    else if(!keyCode.match(/alt/i) && !keyCode.match(/control/i) && !keyCode.match(/shift/i))
        name += keyCode;
    return name.replace(/^a-zA-Z0-9/, "");
};

AccessKeysHelper = ASPx.CreateClass(KbdHelper, {

    constructor: function (control) {
        this.constructor.prototype.constructor.call(this, control);
        this.accessKeysVisible = false;
        this.activeKey = null;
        this.accessKey = control.createAccessKey ? control.createAccessKey(control.accessKey) : new AccessKey(control.accessKey);
        this.accessKeys = this.accessKey.accessKeys;
        this.charIndex = 0;
        this.onFocusByAccessKey = null;
        this.onClose = null;
        this.manualStopProcessing = false;
        this.isActive = false;
        this.areAccessKeysShown = false;
    },

    Init: function (control) {
        KbdHelper.prototype.Init.call(this);
        KbdHelper.RegisterAccessKey(control);            
    },

    Add: function (accessKey) {
        this.accessKey.Add(accessKey);
    },

    HandleKeyDown: function (e) {
        var keyCode = ASPx.Evt.GetKeyCode(e);
        var stopProcessing = this.processKeyDown(keyCode);
        if (stopProcessing.value) {
            this.stopProcessing();
            if(this.onClosedOnEscape && (keyCode == ASPx.Key.Esc || stopProcessing.fireEvent))
                this.onClosedOnEscape();
        }
        return stopProcessing;
    },
    HandleNoFocusAction: function (e, actionName) {
        var keyCode = ASPx.Evt.GetKeyCode(e);
        if (this.onClosedOnEscape && keyCode == ASPx.Key.Esc && actionName == "HandleKeyDown")
            this.onClosedOnEscape();
    },
    Activate: function () {
        KbdHelper.ClickAccessKey(this.control);
        this.areAccessKeysShown = true;
    },
    Stop: function() {
        this.stopProcessing();
    },
    stopProcessing: function () {
        this.HideAccessKeys();
        if (KbdHelper.active && this.isActive) {
            this.isActive = false;
            KbdHelper.active.control.GetMainElement().blur();
            delete KbdHelper.active;
        }
    },
    onBlur: function() {
        if (this.manualStopProcessing) {
            this.manualStopProcessing = false;
            return;
        }
        this.HideAccessKeys();
        KbdHelper.prototype.onBlur.call(this);
    },
    processKeyDown: function (keyCode) {
        switch (keyCode) {
            case ASPx.Key.Left:
                this.TryMoveFocusLeft();
                return { value: false };
            case ASPx.Key.Right:
                this.TryMoveFocusRight();
                return { value: false };
            case ASPx.Key.Esc:
                if(this.control.hideAllPopups)
                    this.control.hideAllPopups(true, true);
                if(this.activeKey)
                    this.activeKey = this.activeKey.Return();
                this.charIndex = 0;
                if (!this.activeKey)
                    return { value: true };
                break;
            case ASPx.Key.Enter:
                return { value: true };
            default:
                if (!ASPx.IsPrintableKey(keyCode))
                    return { value: false };
                var char = String.fromCharCode(keyCode).toUpperCase();
                var needToContinue = { value: false };
                var keyResult;
                if(this.activeKey)
                    keyResult = this.activeKey.TryAccessKey(char, this.charIndex, needToContinue);
                if (needToContinue.value) {
                    this.charIndex++;
                    return { value: false };
                }
                this.charIndex = 0;
                if(keyResult !== undefined)
                    this.activeKey = keyResult;
                else
                    return { value: true, fireEvent: true };
                if (!this.activeKey || !this.activeKey.accessKeys || this.activeKey.accessKeys.length == 0) {
                    if (this.activeKey && this.activeKey.manualStopProcessing) {
                        this.manualStopProcessing = true;
                        break;
                    }
                    return { value: true, fireEvent: true };
                }
        }
        return { value: false };
    },
    TryMoveFocusLeft: function (modifier) {},
    TryMoveFocusRight: function (modifier) {},
    TryMoveFocusUp: function (modifier) {},
    TryMoveFocusDown: function (modifier) {},
    FocusByAccessKey: function() {
        if (this.onFocusByAccessKey)
            this.onFocusByAccessKey();
        this.HideAccessKeys();
        KbdHelper.prototype.FocusByAccessKey.call(this);
        this.activeKey = this.accessKey;
        this.activeKey.execute();
        this.isActive = true;
        this.areAccessKeysShown = true;
    },
    HideAccessKeys: function() {
        this.areAccessKeysShown = false;
        this.hideAccessKeys(this.accessKey);
    },
    Update: function() {
        // 10 times in one second
        this.throttleMethod(this.refresh, 100);
    },
    refresh: function() {
        if(this.activeKey && this.areAccessKeysShown) {
            this.activeKey.execute();
        }
    },
    throttleMethod: function(method, delay) {
        clearTimeout(method.timerId);
        method.timerId = setTimeout(function() {
            method.call(this);
        }.aspxBind(this), delay);

    },
    AreAccessKeysShown: function() {
        return this.areAccessKeysShown;
    },

    hideAccessKeys: function (accessKey) {
        for (var i = 0, ak; ak = accessKey.accessKeys[i]; i++) {
            this.hideAccessKeys(ak);
        }
        if (accessKey)
            accessKey.hide();
    },
    HandleClick: function(e) {
        KbdHelper.prototype.HandleClick.call(this, e);
        this.stopProcessing();
    }
});

AccessKey = ASPx.CreateClass(null, {
    constructor: function (popupItem, getPopupElement, keyTipElement, key, onlyClick, manualStopProcessing) {
        this.key = key ? key : keyTipElement ? ASPxClientUtils.Trim(ASPx.GetInnerText(keyTipElement)) : null;
        this.popupItem = popupItem;
        this.getPopupElement = getPopupElement;
        this.keyTipElement = keyTipElement;
        this.accessKeys = [];
        this.needShowChilds = true;
        this.parent = null;
        this.onlyClick = onlyClick;
        this.manualStopProcessing = manualStopProcessing;
    },

    Add: function (accessKey) {
        this.accessKeys.push(accessKey);
        accessKey.parent = this;
    },

    TryAccessKey: function (char, index, needToContinue) {
        if (!this.accessKeys || this.accessKeys.length == 0)
            return;
        for (var i = 0, accessKey; accessKey = this.accessKeys[i]; i++) {
            if (accessKey.key[index] == char && accessKey.isVisible()) {
                if (accessKey.key[index + 1]) {
                    needToContinue.value = true;
                }
                else {
                    accessKey.execute();
                    return accessKey;
                }
            } else {
                accessKey.hide();
            }
        }
        for (var i = 0, accessKey; accessKey = this.accessKeys[i]; i++) {
            var key = accessKey.TryAccessKey(char, index, needToContinue);
            if (key)
                return key;
        }
        return;
    },

    isVisible: function(){
        return ASPx.GetElementVisibility(this.keyTipElement);
    },

    Return: function () {
        this.hideChildAccessKeys();
        if (this.parent) {
            this.parent.showAccessKeys(true);
        }        
        return this.parent;
    },

    execute: function () {
        this.hideAll();
        if (this.popupItem && this.popupItem.accessKeyClick && !this.onlyClick)
            this.popupItem.accessKeyClick();
        if (this.getPopupElement && this.onlyClick)
            ASPx.Evt.EmulateMouseClick(this.getPopupElement(this.popupItem));
        if (this.accessKeys)
            setTimeout(function () {
                this.showAccessKeys(true);
            }.aspxBind(this), 100);
    },

    showAccessKeys: function(directShow) {
        if (!directShow && !this.needShowChilds)
            return;
        for (var i = 0; i < this.accessKeys.length; i++) {
            var accessKey = this.accessKeys[i];
            if (accessKey) {
                var popupElement = accessKey.getPopupElement ? accessKey.getPopupElement(accessKey.popupItem) : null;
                if (popupElement && this.isElementVisible(popupElement)) {
                    this.show(accessKey);
                }
                accessKey.showAccessKeys();
            }
        }
    },
    isElementVisible: function (el) { return ASPx.IsElementVisible(el, true); },
    show: function(accessKey) {
        var keyTipElement = accessKey.keyTipElement;
        var popupElement = accessKey.getPopupElement(accessKey.popupItem);
        this.showKeyTipElement(keyTipElement, this.calculateCoordinates(accessKey, keyTipElement, popupElement));
    },
    showKeyTipElement: function (keyTipElement, coordinates) {
        ASPx.SetAbsoluteY(keyTipElement, coordinates.top);
        ASPx.SetAbsoluteX(keyTipElement, coordinates.left);
        ASPx.SetElementVisibility(keyTipElement, true); 
    },
    calculateCoordinates: function (accessKey, keyTipElement, popupElement) {
        var top = ASPx.GetAbsolutePositionY(popupElement);
        var left = ASPx.GetAbsolutePositionX(popupElement);
        
        if (accessKey.popupItem.getAccessKeyPosition)
            switch (accessKey.popupItem.getAccessKeyPosition()) {
                case "AboveRight":
                    left = left + popupElement.offsetWidth - keyTipElement.offsetWidth / 3;
                    top = top - keyTipElement.offsetHeight / 2;
                    break;
                case "Right":
                    left = left + popupElement.offsetWidth - keyTipElement.offsetWidth / 3;
                    top = top + popupElement.offsetHeight / 2 - keyTipElement.offsetHeight / 2;
                    break;
                case "BelowRight":
                    left = left + popupElement.offsetWidth - keyTipElement.offsetWidth / 3;
                    top = top + keyTipElement.offsetHeight / 2;
                    break;
                default:
                    top = top + popupElement.offsetHeight;
                    left = left + popupElement.offsetWidth / 2 - keyTipElement.offsetWidth / 2;
                    break;
            }
        else {
            top = top + popupElement.offsetHeight;
            left = left + popupElement.offsetWidth / 2 - keyTipElement.offsetWidth / 2;
        }
        return { top: top, left: left };
    },

    hide: function() {
        if (this.keyTipElement)
            ASPx.SetElementVisibility(this.keyTipElement, false);
    },

    hideChildAccessKeys: function () {
        this.hideAccessKeys(this.accessKeys);
    },

    hideAccessKeys: function (accessKeys) {
        if (accessKeys) {
            for (var i = 0, accessKey; accessKey = accessKeys[i]; i++) {
                if (accessKey.keyTipElement)
                    accessKey.hide();
                accessKey.hideChildAccessKeys();
            }
        }
    },
    hideAll: function () {
        this.getRoot(this).hideChildAccessKeys();
    },
    getRoot: function (accessKey) {
        if (!accessKey.parent)
            return accessKey;
        return this.getRoot(accessKey.parent);
    }
});

// Focusing
var focusedElement = null;
function aspxOnElementFocused(evt) {
    evt = ASPx.Evt.GetEvent(evt);
    if(evt && evt.target)
        focusedElement = evt.target;
}
function _aspxInitializeFocus() {
    if(!ASPx.GetActiveElement())
        ASPx.Evt.AttachEventToDocument("focus", aspxOnElementFocused);
}
function _aspxGetFocusedElement() {
    var activeElement = ASPx.GetActiveElement();
    return activeElement ? activeElement : focusedElement;
}

// CheckBox
CheckBoxCheckState = {
    Checked : "Checked",
    Unchecked : "Unchecked",
    Indeterminate : "Indeterminate"
};

CheckBoxInputKey = { 
    Checked : "C",
    Unchecked : "U",
    Indeterminate : "I"
};

var CheckableElementStateController = ASPx.CreateClass(null, {
    constructor: function(imageProperties) {
        this.checkBoxStates = [];
        this.imageProperties = imageProperties;
        this.customImageMarkerClassName = "dxcbCI";
    },
    
    GetValueByInputKey: function(inputKey) {
        return this.GetFirstValueBySecondValue("Value", "StateInputKey", inputKey);
    },
    GetInputKeyByValue: function(value) {
        return this.GetFirstValueBySecondValue("StateInputKey", "Value", value);
    },
    GetImagePropertiesNumByInputKey: function(value) {
        return this.GetFirstValueBySecondValue("ImagePropertiesNumber", "StateInputKey", value);
    },
    GetNextCheckBoxValue: function(currentValue, allowGrayed) {
        var currentInputKey = this.GetInputKeyByValue(currentValue);
        var nextInputKey = '';
        
        switch(currentInputKey) {
            case CheckBoxInputKey.Checked:
                nextInputKey = CheckBoxInputKey.Unchecked; break;
            case CheckBoxInputKey.Unchecked:
                nextInputKey = allowGrayed ? CheckBoxInputKey.Indeterminate : CheckBoxInputKey.Checked; break;
            case CheckBoxInputKey.Indeterminate:
                nextInputKey = CheckBoxInputKey.Checked; break;
        }
        return this.GetValueByInputKey(nextInputKey);
    },
    GetCheckStateByInputKey: function(inputKey) {
        switch(inputKey) {
            case CheckBoxInputKey.Checked: 
                return CheckBoxCheckState.Checked;
            case CheckBoxInputKey.Unchecked: 
                return CheckBoxCheckState.Unchecked;
            case CheckBoxInputKey.Indeterminate: 
                return CheckBoxCheckState.Indeterminate;
        }
    },
    GetValueByCheckState: function(checkState) {
        switch(checkState) {
            case CheckBoxCheckState.Checked: 
                return this.GetValueByInputKey(CheckBoxInputKey.Checked);
            case CheckBoxCheckState.Unchecked: 
                return this.GetValueByInputKey(CheckBoxInputKey.Unchecked);
            case CheckBoxCheckState.Indeterminate: 
                return this.GetValueByInputKey(CheckBoxInputKey.Indeterminate);
        }
    },
    GetFirstValueBySecondValue: function(firstValueName, secondValueName, secondValue) {
        return this.GetValueByFunc(firstValueName, 
            function(checkBoxState) { return checkBoxState[secondValueName] === secondValue; });
    },
    GetValueByFunc: function(valueName, func) {
        for(var i = 0; i < this.checkBoxStates.length; i++) {
            if(func(this.checkBoxStates[i]))
                return this.checkBoxStates[i][valueName];
        }        
    },
    AssignElementClassName: function(element, cssClassPropertyKey, disabledCssClassPropertyKey, assignedClassName) {
	    var classNames = [ ];
	    for(var i = 0; i < this.imageProperties[cssClassPropertyKey].length; i++) {
		    classNames.push(this.imageProperties[disabledCssClassPropertyKey][i]);
		    classNames.push(this.imageProperties[cssClassPropertyKey][i]);
	    }
	    var elementClassName = element.className;
	    for(var i = 0; i < classNames.length; i++) {
		    var className = classNames[i];
		    var index = elementClassName.indexOf(className);
		    if(index > -1)
			    elementClassName = elementClassName.replace((index == 0 ? '' : ' ') + className, "");
	    }
	    elementClassName += " " + assignedClassName;
	    element.className = elementClassName;
    },

    UpdateInternalCheckBoxDecoration: function(mainElement, inputKey, enabled) {
        var imagePropertiesNumber = this.GetImagePropertiesNumByInputKey(inputKey);
        for(var imagePropertyKey in this.imageProperties) {
            if(this.imageProperties.hasOwnProperty(imagePropertyKey)) {
                var propertyValue = this.imageProperties[imagePropertyKey][imagePropertiesNumber];
                propertyValue = propertyValue || !isNaN(propertyValue) ? propertyValue : "";
                switch(imagePropertyKey) {
                    case "0" : mainElement.title = propertyValue; break;
                    case "1" : mainElement.style.width = propertyValue + (propertyValue != "" ? "px" : ""); break;
                    case "2" : mainElement.style.height = propertyValue + (propertyValue != "" ? "px" : ""); break;
                }
                if(enabled) {
                    switch(imagePropertyKey) {
                        case "3" : this.SetImageSrc(mainElement, propertyValue); break;
                        case "4" : 
                            this.AssignElementClassName(mainElement, "4", "8", propertyValue);
                            break;
                        case "5" : this.SetBackgroundPosition(mainElement, propertyValue, true); break;
                        case "6" : this.SetBackgroundPosition(mainElement, propertyValue, false); break;
                    }
                } else {
                    switch(imagePropertyKey) {
                        case "7" : this.SetImageSrc(mainElement, propertyValue); break;
                        case "8" : 
                            this.AssignElementClassName(mainElement, "4", "8", propertyValue);
                            break;
                        case "9" : this.SetBackgroundPosition(mainElement, propertyValue, true); break;
                        case "10" : this.SetBackgroundPosition(mainElement, propertyValue, false); break;
                    }
                }
            }
        }
    },
	SetImageSrc: function(mainElement, src) {
        if(src === ""){
            mainElement.style.backgroundImage = "";
            mainElement.style.backgroundPosition = "";
            ASPx.RemoveClassNameFromElement(mainElement, this.customImageMarkerClassName);
        }
        else{
		    mainElement.style.backgroundImage = "url('" + src + "')";
		    this.SetBackgroundPosition(mainElement, 0, true);
            this.SetBackgroundPosition(mainElement, 0, false);
            ASPx.AddClassNameToElement(mainElement, this.customImageMarkerClassName);
        }
	},
    SetBackgroundPosition: function(element, value, isX) {
        if(value === "") {
            element.style.backgroundPosition = value;
            return;
        }
        if(element.style.backgroundPosition === "")
            element.style.backgroundPosition = isX ? "-" + value.toString() + "px 0px" : "0px -" + value.toString() + "px";
        else {
            var position = element.style.backgroundPosition.split(' ');
            element.style.backgroundPosition = isX ? '-' + value.toString() + "px " + position[1] :  position[0] + " -" + value.toString() + "px";
        }
    },
   
    AddState: function(value, stateInputKey, imagePropertiesNumber) {
        this.checkBoxStates.push({
            "Value" : value, 
            "StateInputKey" : stateInputKey, 
            "ImagePropertiesNumber" : imagePropertiesNumber
        });
    },
    GetAriaCheckedValue: function(state) {
        switch(state) {
            case ASPx.CheckBoxCheckState.Checked: return "true";
            case ASPx.CheckBoxCheckState.Unchecked: return "false";
            case ASPx.CheckBoxCheckState.Indeterminate: return "mixed";
            default: return "";
        }
    },
    GetAriaSelectedValue: function(state) {
        switch(state) {
            case ASPx.CheckBoxCheckState.Checked: return "true";
            case ASPx.CheckBoxCheckState.Unchecked: return "false";
            case ASPx.CheckBoxCheckState.Indeterminate: return "undefined";
            default: return "";
        }
    },
    SetAriaCheckedSelectedAttributes: function(mainElement, state) {
        if(mainElement.attributes["aria-checked"] !== undefined) {
            var ariaCheckedValue = this.GetAriaCheckedValue(state);
            mainElement.setAttribute("aria-checked", ariaCheckedValue);
        }
        if(mainElement.attributes["aria-selected"] !== undefined) {
            var ariaSelectedValue = this.GetAriaSelectedValue(state);
            mainElement.setAttribute("aria-selected", ariaSelectedValue);
        }
    }
});

CheckableElementStateController.Create = function(imageProperties, valueChecked, valueUnchecked, valueGrayed, allowGrayed) {
    var stateController = new CheckableElementStateController(imageProperties);
    stateController.AddState(valueChecked, CheckBoxInputKey.Checked, 0);
    stateController.AddState(valueUnchecked, CheckBoxInputKey.Unchecked, 1);
    if(typeof(valueGrayed) != "undefined")
        stateController.AddState(valueGrayed, CheckBoxInputKey.Indeterminate, allowGrayed ? 2 : 1);
    stateController.allowGrayed = allowGrayed;
    return stateController;
};

var CheckableElementHelper = ASPx.CreateClass(null, {
    InternalCheckBoxInitialize: function(internalCheckBox) {
        this.AttachToMainElement(internalCheckBox);
        this.AttachToInputElement(internalCheckBox);
    },
    AttachToMainElement: function(internalCheckBox) {
        var instance = this;
        if(internalCheckBox.mainElement) {
             var toggleEvent = internalCheckBox.displaySwitch ? ASPx.TouchUIHelper.touchMouseDownEventName : "click";
             ASPx.Evt.AttachEventToElement(internalCheckBox.mainElement, toggleEvent,
                function (evt) {
                    if(ASPx.Evt.IsRightButtonPressed(evt))
                        return;
                    instance.InvokeClick(internalCheckBox, evt);
                    if(!internalCheckBox.disableCancelBubble)
                        return ASPx.Evt.PreventEventAndBubble(evt);
                }
            );
            ASPx.Evt.AttachEventToElement(internalCheckBox.mainElement, "mousedown",
                function (evt) {
                    internalCheckBox.Refocus();
                }
            );
            ASPx.Evt.PreventElementDragAndSelect(internalCheckBox.mainElement, true);
        }
    },
    AttachToInputElement: function(internalCheckBox) {
        var instance = this;
        if(internalCheckBox.inputElement && internalCheckBox.mainElement) {
            var checkableElement = internalCheckBox.accessibilityCompliant ? internalCheckBox.mainElement : internalCheckBox.inputElement;
            ASPx.Evt.AttachEventToElement(checkableElement, "focus",
                function (evt) { 
                    if(!internalCheckBox.enabled)
                        checkableElement.blur();
                    else
                        internalCheckBox.OnFocus();
                }
            );
            ASPx.Evt.AttachEventToElement(checkableElement, "blur", 
                function (evt) { 
                    internalCheckBox.OnLostFocus();
                }
            );
            ASPx.Evt.AttachEventToElement(checkableElement, "keyup",
                function (evt) { 
                    if(ASPx.Evt.GetKeyCode(evt) == ASPx.Key.Space)
                        instance.InvokeClick(internalCheckBox, evt);
                }
            );
            ASPx.Evt.AttachEventToElement(checkableElement, "keydown",
                function (evt) { 
                    if(ASPx.Evt.GetKeyCode(evt) == ASPx.Key.Space)
                        return ASPx.Evt.PreventEvent(evt);
                }
            );
        }
    },
    IsKBSInputWrapperExist: function() {
        return ASPx.Browser.Opera || ASPx.Browser.WebKitFamily;
    },
    GetICBMainElementByInput: function(icbInputElement) {
        return this.IsKBSInputWrapperExist() ? icbInputElement.parentNode.parentNode : icbInputElement.parentNode;
    },
    RequirePreventFocus: function() { return false; },
    InvokeClick: function(internalCheckBox, evt) {
        if(internalCheckBox.enabled && !internalCheckBox.GetReadOnly()) {
            var inputElementValue = internalCheckBox.inputElement.value;
            var focusableElement = internalCheckBox.accessibilityCompliant ? internalCheckBox.mainElement : internalCheckBox.inputElement; 
            if(!this.RequirePreventFocus())
                focusableElement.focus();
            if(!ASPx.Browser.IE) // Q413117
                internalCheckBox.inputElement.value = inputElementValue;
            this.InvokeClickCore(internalCheckBox, evt);
         }
    },
    InvokeClickCore: function(internalCheckBox, evt) {
        internalCheckBox.OnClick(evt);
    }
});
CheckableElementHelper.Instance = new CheckableElementHelper();

var CheckBoxInternal = ASPx.CreateClass(null, {
    constructor: function(inputElement, stateController, allowGrayed, allowGrayedByClick, helper, container, storeValueInInput, key, disableCancelBubble,
        accessibilityCompliant, displaySwitch) {
        this.inputElement = inputElement;
        this.mainElement = helper.GetICBMainElementByInput(this.inputElement);
        this.name = (key ? key : this.inputElement.id) + CheckBoxInternal.GetICBMainElementPostfix();
        this.mainElement.id = this.name;
        this.stateController = stateController;
        this.container = container;

        this.allowGrayed = allowGrayed;
        this.allowGrayedByClick = allowGrayedByClick;
        this.autoSwitchEnabled = true;
        this.displaySwitch = displaySwitch;

        this.storeValueInInput = !!storeValueInInput;
        this.storedInputKey = !this.storeValueInInput ? this.inputElement.value : null;
        this.disableCancelBubble = !!disableCancelBubble;
        this.accessibilityCompliant = accessibilityCompliant;
        
		this.focusDecoration = null;
        this.focused = false;
        this.focusLocked = false;

        this.enabled = !this.mainElement.className.match(/dxWeb_\w+Disabled(\b|_)/);
        this.readOnly = false;

        this.preventFocus = helper.RequirePreventFocus();
        
        this.CheckedChanged = new ASPxClientEvent();
        this.Focus = new ASPxClientEvent();
        this.LostFocus = new ASPxClientEvent();
        
        helper.InternalCheckBoxInitialize(this);
    },
    GetReadOnly: function() {
        return this.readOnly;
    },
    ChangeInputElementTabIndex: function() {        
        var changeMethod = this.enabled ? ASPx.Attr.RestoreTabIndexAttribute : ASPx.Attr.SaveTabIndexAttributeAndReset;
        changeMethod(this.inputElement);
    },
	CreateFocusDecoration: function(focusedStyle) {
		 this.focusDecoration = new FocusedStyleDecoration(this);
         this.focusDecoration.AddStyle('F', focusedStyle[0], focusedStyle[1]);
         this.focusDecoration.AddPostfix("");
	},
    UpdateFocusDecoration: function() {
    	this.focusDecoration.Update();
    },        
    StoreInputKey: function(inputKey) {
        if(this.storeValueInInput)
            this.inputElement.value = inputKey;
        else
            this.storedInputKey = inputKey;
    },
    GetStoredInputKey: function() {
        if(this.storeValueInInput)
            return this.inputElement.value;
        else
            return this.storedInputKey;
    },
    OnClick: function(e) {
        if(this.autoSwitchEnabled) {
            var currentValue = this.GetValue();
            var value = this.stateController.GetNextCheckBoxValue(currentValue, this.allowGrayedByClick && this.allowGrayed);
            this.SetValue(value);
        }
        this.CheckedChanged.FireEvent(this, e);
    },
    OnFocus: function() {
        if(!this.IsFocusLocked()) {
            this.focused = true;
            this.UpdateFocusDecoration();
            this.Focus.FireEvent(this, null);
        } else
            this.UnlockFocus();
    },
    OnLostFocus: function() {
        if(!this.IsFocusLocked()) {
            this.focused = false;
            this.UpdateFocusDecoration();
            this.LostFocus.FireEvent(this, null);
        }
    },
    Refocus: function() {
        if(this.preventFocus) return;
        if(this.focused) {
            this.LockFocus();
            this.inputElement.blur();

            if(ASPx.Browser.MacOSMobilePlatform) {
                window.setTimeout(function() {
                    ASPx.SetFocus(this.inputElement);
                }, ASPx.FOCUS_TIMEOUT);
            } else {
                ASPx.SetFocus(this.inputElement);
            }
        }
    },
    LockFocus: function() {
        this.focusLocked = true;
    },
    UnlockFocus: function() {
        this.focusLocked = false;
    },
    IsFocusLocked: function() {
        if(!!ASPx.Attr.GetAttribute(this.mainElement, ASPx.Attr.GetTabIndexAttributeName()))
            return false;
        return this.focusLocked;
    },
    SetValue: function(value, force) {
        var currentValue = this.GetValue();
        if(currentValue !== value || force) {
            var newInputKey = this.stateController.GetInputKeyByValue(value);
            if(newInputKey) {
                this.StoreInputKey(newInputKey);            
                this.stateController.UpdateInternalCheckBoxDecoration(this.mainElement, newInputKey, this.enabled);
            }
        }
        if(this.accessibilityCompliant) {
            var state = this.GetCurrentCheckState();
            this.stateController.SetAriaCheckedSelectedAttributes(this.mainElement, state);
        }
    },
    GetValue: function() {
        return this.stateController.GetValueByInputKey(this.GetCurrentInputKey());
    },
    GetCurrentCheckState: function() {
        return this.stateController.GetCheckStateByInputKey(this.GetCurrentInputKey());
    },
    GetCurrentInputKey: function() {
        return this.GetStoredInputKey();
    },
    GetChecked: function() {
        return this.GetCurrentInputKey() === CheckBoxInputKey.Checked;
    },
    SetChecked: function(checked) {
        var newValue = this.stateController.GetValueByCheckState(checked ? CheckBoxCheckState.Checked : CheckBoxCheckState.Unchecked);
        this.SetValue(newValue);
    },
    SetEnabled: function(enabled) {
        if(this.enabled != enabled) {
            this.enabled = enabled;
            this.stateController.UpdateInternalCheckBoxDecoration(this.mainElement, this.GetCurrentInputKey(), this.enabled);
            this.ChangeInputElementTabIndex();
        }
    },
    GetEnabled: function() {
        return this.enabled;
    }
});

CheckBoxInternal.GetICBMainElementPostfix = function() {
    return "_D";
};

var CheckBoxInternalCollection = ASPx.CreateClass(CollectionBase, {
    constructor: function(imageProperties, allowGrayed, storeValueInInput, helper, disableCancelBubble, accessibilityCompliant) {
        this.constructor.prototype.constructor.call(this);

        this.stateController = allowGrayed 
            ? CheckableElementStateController.Create(imageProperties, CheckBoxInputKey.Checked, CheckBoxInputKey.Unchecked, CheckBoxInputKey.Indeterminate, true)
            : CheckableElementStateController.Create(imageProperties, CheckBoxInputKey.Checked, CheckBoxInputKey.Unchecked);

        this.helper = helper || CheckableElementHelper.Instance;
        this.storeValueInInput = !!storeValueInInput;
        this.disableCancelBubble = !!disableCancelBubble;
        this.accessibilityCompliant = accessibilityCompliant;
    },
    Add: function(key, inputElement, container) {
        this.Remove(key);
        
        var checkBox = this.CreateInternalCheckBox(key, inputElement, container);
        CollectionBase.prototype.Add.call(this, key, checkBox);
        return checkBox;
    },
    SetImageProperties: function(imageProperties) {
        this.stateController.imageProperties = imageProperties;
    },
    CreateInternalCheckBox: function(key, inputElement, container) {
        return new CheckBoxInternal(inputElement, this.stateController, this.stateController.allowGrayed, false, this.helper, container, 
            this.storeValueInInput, key, this.disableCancelBubble, this.accessibilityCompliant);
    }
});

var FocusedStyleDecoration = ASPx.CreateClass(null, {
    constructor: function(editor) {
        this.editor = editor;
        this.postfixList = [];
        this.styles = {};
        this.innerStyles = {};
    },

    AddPostfix: function(value) {
        this.postfixList.push(value);
    },
    AddStyle: function(key, className, cssText) {
        this.styles[key] = this.CreateRule(className, cssText);
        this.innerStyles[key] = this.CreateRule("", this.FilterInnerCss(cssText));
    },
    CreateRule: function(className, cssText) {
        return ASPx.Str.Trim(className + " " + ASPx.CreateImportantStyleRule(this.GetStyleSheet(), cssText));
    },
    GetStyleSheet: function() {
        return ASPx.GetCurrentStyleSheet();
    },
    FilterInnerCss: function(css) {
        return css.replace(/(border|background-image)[^:]*:[^;]+/gi, "");
    },
    Update: function() {
        for(var i = 0; i < this.postfixList.length; i++) {
            var postfix = this.postfixList[i];
            var inner = postfix.length > 0;
            var element = this.GetElementByPostfix(postfix);
            if(element)
                this.ApplyStyles(element, inner);
        }
    },
    GetElementByPostfix: function(postfix) {
        return ASPx.GetElementById(this.editor.name + postfix);
    },
    ApplyStyles: function(element, inner) {
        this.ApplyFocusedStyle(element, inner);
    },
    ApplyFocusedStyle: function(element, inner) {
        if(this.HasDecoration("F"))
            this.ApplyDecoration("F", element, inner, this.editor.focused);
    },
    HasDecoration: function(key) {
        return !!this.styles[key];
    },
    ApplyDecoration: function(key, element, inner, active) {
        var value = inner ? this.innerStyles[key] : this.styles[key];
        this.RemoveDecoration(element, value);
        if(active) {
            ASPx.AddClassNameToElement(element, value);

            if(ASPx.Browser.IE && ASPx.Browser.Version > 10 && element.border != null) //B251467
                this.EnsureElementBorder(element);
        }
    },
    RemoveDecoration: function(element, value) {
        ASPx.RemoveClassNameFromElement(element, value);
        if(ASPx.Browser.IE && ASPx.Browser.MajorVersion >= 11)
            var dummy = element.offsetWidth; //T113180
    },
    ApplyDecorationCore: function() {

    },
    EnsureElementBorder: function(element) {
        var border = parseInt(element.border) || 0;
        element.border = 1;
        element.border = border;
    }
});

// Inheritance in the bootstrap prevents the transfer of helpers to the appropriate files

var EditorStyleDecoration = ASPx.CreateClass(FocusedStyleDecoration, {
    constructor: function(editor) {
        this.constructor.prototype.constructor.call(this, editor);

        this.lockUpdate = false;
    },

    LockUpdate: function() {
        this.lockUpdate = true;
    },
    UnlockUpdate: function() {
        this.lockUpdate = false;
    },
    IsUpdateLocked: function() {
        return this.lockUpdate;
    },
    Update: function () {
        if(this.IsUpdateLocked())
            return;
        ASPx.FocusedStyleDecoration.prototype.Update.call(this);
    },
    ApplyStyles: function (element, inner) {
        this.ApplyInvalidStyle(element, inner);
        ASPx.FocusedStyleDecoration.prototype.ApplyStyles.call(this, element, inner);
    },
    ApplyInvalidStyle: function (element, inner) {
        if(this.HasDecoration("I")) {
            var isValid = this.editor.GetIsValid();
            this.ApplyDecoration("I", element, inner, !isValid);
        }
    }
});

var TextEditorStyleDecoration = ASPx.CreateClass(EditorStyleDecoration, {
    constructor: function(editor) {
        this.constructor.prototype.constructor.call(this, editor);

        this.nullTextClassName = "";
    },

    ApplyStyles: function(element, inner) {
        ASPx.EditorStyleDecoration.prototype.ApplyStyles.call(this, element, inner);
        this.ApplyNullTextStyle(element, inner);
    },
    ApplyNullTextStyle: function(element, inner) {
        if(!this.HasDecoration("N"))
            return;
        var apply = !this.editor.focused && this.editor.CanApplyNullTextDecoration();
        this.EnsureSpellcheckAttribute(element, apply);
        this.ApplyDecoration("N", element, inner, apply);
    },
    EnsureSpellcheckAttribute: function(element, apply) {
        if(apply)
            ASPx.Attr.ChangeAttribute(element, "spellcheck", "false");
        else
            ASPx.Attr.RestoreAttribute(element, "spellcheck");
    },

    ApplyNullTextClassName: function(active) {
        var nullTextClassName = this.GetNullTextClassName();
        var editorMainElement = this.editor.GetMainElement();
        if(active)
            ASPx.AddClassNameToElement(editorMainElement, nullTextClassName);
        else
            ASPx.RemoveClassNameFromElement(editorMainElement, nullTextClassName);
    },

    GetNullTextClassName: function() {
        if (!this.nullTextClassName)
            this.InitializeNullTextClassName();
        return this.nullTextClassName;
    },

    InitializeNullTextClassName: function() {
        var nullTextStyle = this.styles["N"];
        if (nullTextStyle) {
            var nullTextStyleClassNames = nullTextStyle.split(" ");
            for (var i = 0; i < nullTextStyleClassNames.length; i++)
                if (nullTextStyleClassNames[i].match("dxeNullText"))
                    this.nullTextClassName = nullTextStyleClassNames[i];
        }
    }
});

var TouchUIHelper = {
    isGesture: false,
    isMouseEventFromScrolling: false,
    isNativeScrollingAllowed: true,
    clickSensetivity: 10,
    documentTouchHandlers: {},
    documentEventAttachingAllowed: true,

    msTouchDraggableClassName: "dxMSTouchDraggable",

    touchMouseDownEventName: ASPx.Browser.WebKitTouchUI ? "touchstart" : (ASPx.Browser.Edge && ASPx.Browser.MSTouchUI && window.PointerEvent ? "pointerdown" : "mousedown"),
    touchMouseUpEventName:   ASPx.Browser.WebKitTouchUI ? "touchend"   : (ASPx.Browser.Edge && ASPx.Browser.MSTouchUI && window.PointerEvent ? "pointerup" : "mouseup"),
    touchMouseMoveEventName: ASPx.Browser.WebKitTouchUI ? "touchmove"  : (ASPx.Browser.Edge && ASPx.Browser.MSTouchUI && window.PointerEvent ? "pointermove" : "mousemove"),

    isTouchEvent: function(evt) {
        if(!evt) return false;
        return ASPx.Browser.WebKitTouchUI && ASPx.IsExists(evt.changedTouches); 
    },
    isTouchEventName: function(eventName) {
        return ASPx.Browser.WebKitTouchUI && (eventName.indexOf("touch") > -1 || eventName.indexOf("gesture") > -1);
    },
    getEventX: function(evt) {
        if(ASPx.Browser.IE)
            return evt.pageX;
        var touchPoint = null;
        if(evt.changedTouches.length > 0)
            touchPoint = evt.changedTouches;
        else if(evt.targetTouches.length > 0)
            touchPoint = evt.targetTouches;
        return touchPoint ? touchPoint[0].pageX : 0;
    },
    getEventY: function(evt) { 
        if(ASPx.Browser.IE)
            return evt.pageY;
        var touchPoint = null;
        if(evt.changedTouches.length > 0)
            touchPoint = evt.changedTouches;
        else if(evt.targetTouches.length > 0)
            touchPoint = evt.targetTouches;
        return touchPoint ? touchPoint[0].pageY : 0;
    },
    getWebkitMajorVersion: function(){
        if(!this.webkitMajorVersion){
            var regExp = new RegExp("applewebkit/(\\d+)", "i");
            var matches = regExp.exec(ASPx.Browser.UserAgent);
            if(matches && matches.index >= 1)
                this.webkitMajorVersion = matches[1];
        }
        return this.webkitMajorVersion;
    },
    getIsLandscapeOrientation: function(){
        if(ASPx.Browser.MacOSMobilePlatform || ASPx.Browser.AndroidMobilePlatform)
            return Math.abs(window.orientation) == 90;
        return ASPx.GetDocumentClientWidth() > ASPx.GetDocumentClientHeight();
    },
    nativeScrollingSupported: function() {
        var allowedSafariVersion = ASPx.Browser.Version >= 5.1 && ASPx.Browser.Version < 8; //T250059
        var webkitMajorVersion = this.getWebkitMajorVersion();
        var allowedWebKitVersion = webkitMajorVersion > 533 && webkitMajorVersion < 600;
        return (ASPx.Browser.MacOSMobilePlatform && (allowedSafariVersion || allowedWebKitVersion))
            || (ASPx.Browser.AndroidMobilePlatform && ASPx.Browser.PlaformMajorVersion >= 3) || (ASPx.Browser.MSTouchUI && (!ASPx.Browser.WindowsPhonePlatform || !ASPx.Browser.IE));
    },
    makeScrollableIfRequired: function(element, options) {
        if(ASPx.Browser.WebKitTouchUI && element) {
            var overflow = ASPx.GetCurrentStyle(element).overflow;
            if(element.tagName == "DIV" &&  overflow != "hidden" && overflow != "visible" ){
                return this.MakeScrollable(element);
            }
        }
    },
    preventScrollOnEvent: function(evt){
    },

    handleFastTapIfRequired: function(evt, action, preventCommonClickEvents) {
        if(ASPx.Browser.WebKitTouchUI && evt.type == 'touchstart' && action) {
            this.FastTapHelper.HandleFastTap(evt, action, preventCommonClickEvents);
            return true;
        }
        return false;
    },

    ensureDocumentSizesCorrect: function (){
        return (document.documentElement.clientWidth - document.documentElement.clientHeight) / (screen.width - screen.height) > 0;
    },
    ensureOrientationChanged: function(onOrientationChangedFunction){
        if(ASPxClientUtils.iOSPlatform || this.ensureDocumentSizesCorrect())
            onOrientationChangedFunction();
        else {
            window.setTimeout(function(){
                this.ensureOrientationChanged(onOrientationChangedFunction);
            }.aspxBind(this), 100);
        }
    },

    onEventAttachingToDocument: function(eventName, func){
        if(ASPx.Browser.MacOSMobilePlatform && this.isTouchEventName(eventName)) {
            if(!this.documentTouchHandlers[eventName])
                this.documentTouchHandlers[eventName] = [];
            this.documentTouchHandlers[eventName].push(func);
			return this.documentEventAttachingAllowed;
        }
        return true;
    },
    onEventDettachedFromDocument: function(eventName, func){
        if(ASPx.Browser.MacOSMobilePlatform && this.isTouchEventName(eventName)) {
            var handlers = this.documentTouchHandlers[eventName];
            if(handlers)
                ASPx.Data.ArrayRemove(handlers, func);
        }
    },
    processDocumentTouchEventHandlers: function(proc) {
        var touchEventNames = ["touchstart", "touchend", "touchmove", "gesturestart", "gestureend"];
        for(var i = 0; i < touchEventNames.length; i++) {
            var eventName = touchEventNames[i];
            var handlers = this.documentTouchHandlers[eventName];
            if(handlers) {
                for(var j = 0; j < handlers.length; j++) {
                    proc(eventName,handlers[j]);
                }
            }
        }
    },
    removeDocumentTouchEventHandlers: function() {
        if(ASPx.Browser.MacOSMobilePlatform) {
            this.documentEventAttachingAllowed = false;
            this.processDocumentTouchEventHandlers(ASPx.Evt.DetachEventFromDocumentCore);
        }
    },
    restoreDocumentTouchEventHandlers: function () {
        if(ASPx.Browser.MacOSMobilePlatform) {
            this.documentEventAttachingAllowed = true;
            this.processDocumentTouchEventHandlers(ASPx.Evt.AttachEventToDocumentCore);
        }
    },
    IsNativeScrolling: function() {
        return TouchUIHelper.nativeScrollingSupported() && TouchUIHelper.isNativeScrollingAllowed;
    },
    
    pointerEnabled: !!(window.PointerEvent || window.MSPointerEvent),
    pointerDownEventName: window.PointerEvent ? "pointerdown" : "MSPointerDown",
    pointerUpEventName: window.PointerEvent ? "pointerup" : "MSPointerUp",
    pointerCancelEventName: window.PointerEvent ? "pointercancel" : "MSPointerCancel",
    pointerMoveEventName: window.PointerEvent ? "pointermove" : "MSPointerMove",
	pointerOverEventName: window.PointerEvent ? "pointerover" : "MSPointerOver",
    pointerOutEventName: window.PointerEvent ? "pointerout" : "MSPointerOut",
    pointerType: {
        Touch: (ASPx.Browser.IE && ASPx.Browser.Version == 10) ? 2 : "touch",
        Pen: (ASPx.Browser.IE && ASPx.Browser.Version == 10) ? 3 : "pen",
        Mouse: (ASPx.Browser.IE && ASPx.Browser.Version == 10) ? 4 : "mouse"
    },

    msGestureEnabled: !!(window.PointerEvent || window.MSPointerEvent) && typeof(MSGesture) != "undefined",
    msTouchCreateGesturesWrapper: function(element, onTap){
        if(!TouchUIHelper.msGestureEnabled) 
            return;
        var gesture = new MSGesture();
        gesture.target = element;
        ASPx.Evt.AttachEventToElement(element, TouchUIHelper.pointerDownEventName, function(evt){
            gesture.addPointer(evt.pointerId);
        });
        ASPx.Evt.AttachEventToElement(element, TouchUIHelper.pointerUpEventName, function(evt){
            gesture.stop();
        });
        if(onTap)
            ASPx.Evt.AttachEventToElement(element, "MSGestureTap", onTap);
        return gesture;
    },
    useLongTapHelper: function () {
        return ASPx.Browser.Safari && ASPx.Browser.TouchUI;
    },
    attachLongTapHandler: function(element, handler, onlyBubbling) {
        var timerID = -1;
        var timeout = 1000;
        var event = null;
        var preventClickEvent = false;
        var startX = -1;
        var startY = -1;
        var pixelLimit = 5;

        function onTouchMouseDown(evt) {
            abortWating();
            event = evt;
            startX = evt.pageX;
            startY = evt.pageY;
            preventClickEvent = false;
            timerID = window.setTimeout(onTimeout, timeout);
        }
        function onTouchMouseMove(evt) {
            if (!isUnderTouch())
                return;
            var shiftX = Math.abs(startX - evt.pageX),
                shiftY = Math.abs(startY - evt.pageY),
                maxShift = Math.max(shiftX, shiftY);
            if (maxShift > pixelLimit)
                abortWating();
        }
        function onTouchMouseUp(evt) {
            abortWating();
            if (preventClickEvent) {
                ASPx.Evt.PreventEventAndBubble(evt);
                preventClickEvent = false;
            }
        }
        function onTimeout() {
            handler(event);
            preventClickEvent = true;
            abortWatingInternal();
        }
        function isUnderTouch() {
            return timerID !== -1;
        }
        function abortWating() {
            if (isUnderTouch()) {
                window.clearTimeout(timerID);
                abortWatingInternal();
            }
        }
        function abortWatingInternal() {
            timerID = -1;
            event = null;
        }

        ASPx.Evt.AttachEventToElement(element, TouchUIHelper.touchMouseDownEventName, onTouchMouseDown, onlyBubbling);
        ASPx.Evt.AttachEventToElement(element, TouchUIHelper.touchMouseMoveEventName, onTouchMouseMove, onlyBubbling);
        ASPx.Evt.AttachEventToElement(element, TouchUIHelper.touchMouseUpEventName, onTouchMouseUp, onlyBubbling);
        element.style["-webkit-user-select"] = "none";
        return function () {
            ASPx.Evt.DetachEventFromElement(element, TouchUIHelper.touchMouseDownEventName, onTouchMouseDown);
            ASPx.Evt.DetachEventFromElement(element, TouchUIHelper.touchMouseMoveEventName, onTouchMouseMove);
            ASPx.Evt.DetachEventFromElement(element, TouchUIHelper.touchMouseUpEventName, onTouchMouseUp);
            element.style["-webkit-user-select"] = "";
        };
    }
};

var CacheHelper = {};
CacheHelper.GetCachedValueCore = function(obj, key, func, cacheObj, fillValueMethod) {
    if(!cacheObj)
        cacheObj = obj;
    if(!cacheObj.cache)
        cacheObj.cache = {};
    if(!key) 
        key = "default";
    fillValueMethod(obj, key, func, cacheObj);
    return cacheObj.cache[key];
};
CacheHelper.GetCachedValue = function(obj, key, func, cacheObj) {
    return CacheHelper.GetCachedValueCore(obj, key, func, cacheObj, 
        function(obj, key, func, cacheObj) {
            if(!ASPx.IsExists(cacheObj.cache[key]))
                cacheObj.cache[key] = func.apply(obj, []);
        });
};
CacheHelper.GetCachedElement = function(obj, key, func, cacheObj) {
    return CacheHelper.GetCachedValueCore(obj, key, func, cacheObj, 
        function(obj, key, func, cacheObj) {
            if(!ASPx.IsValidElement(cacheObj.cache[key]))
                cacheObj.cache[key] = func.apply(obj, []);
        });
};
CacheHelper.GetCachedElements = function(obj, key, func, cacheObj) {
    return CacheHelper.GetCachedValueCore(obj, key, func, cacheObj, 
        function(obj, key, func, cacheObj) {
            if(!ASPx.IsValidElements(cacheObj.cache[key])){
                var elements = func.apply(obj, []);
                if(!Ident.IsArray(elements))
                    elements = [elements];
                cacheObj.cache[key] = elements;
            }
        });
};
CacheHelper.GetCachedElementById = function(obj, id, cacheObj) {
    return CacheHelper.GetCachedElement(obj, id, function() { return ASPx.GetElementById(id); }, cacheObj);
};
CacheHelper.GetCachedChildById = function(obj, parent, id, cacheObj) {
    return CacheHelper.GetCachedElement(obj, id, function() { return ASPx.GetChildById(parent, id); }, cacheObj);
};
CacheHelper.DropCachedValue = function(cacheObj, key) {
    cacheObj.cache[key] = null;
};  
CacheHelper.DropCache = function(cacheObj) {
    cacheObj.cache = null;
};  

var DomObserver = ASPx.CreateClass(null, {
    constructor: function() {
        this.items = { };
    },
    subscribe: function(elementID, callbackFunc) {
        var item = this.items[elementID];
        if(item)
            this.unsubscribe(elementID);

        item = {
            elementID: elementID,
            callbackFunc: callbackFunc,
            pauseCount: 0
        };
        this.prepareItem(item);
        this.items[elementID] = item;
    },
    prepareItem: function(item) {
    },
    unsubscribe: function(elementID) {
        this.items[elementID] = null;
    },
    getItemElement: function(item) {
        var element = this.getElementById(item.elementID);
        if(element)
            return element;
        this.unsubscribe(item.elementID);
        return null;
    },
    getElementById: function(elementID) {
        var element = document.getElementById(elementID);
        return element && ASPx.IsValidElement(element) ? element : null;
    },
    pause: function(element, includeSubtree) {
        this.changeItemsState(element, includeSubtree, true);
    },
    resume: function(element, includeSubtree) {
        this.changeItemsState(element, includeSubtree, false);
    },
    forEachItem: function(processFunc, context) {
        context = context || this;
        for(var itemName in this.items) {
            if(!this.items.hasOwnProperty(itemName))
                continue;

            var item = this.items[itemName];
            if(item) {
                var needBreak = processFunc.call(context, item);
                if(needBreak)
                    return;
            }
        }
    },
    changeItemsState: function(element, includeSubtree, pause) {
        this.forEachItem(function(item) {
            if(!element)
                this.changeItemState(item, pause);
            else {
                var itemElement = this.getItemElement(item);
                if(itemElement && (element == itemElement || (includeSubtree && ASPx.GetIsParent(element, itemElement)))) {
                    this.changeItemState(item, pause);
                    if(!includeSubtree)
                        return true;
                }
            }
        }.aspxBind(this));
    },
    changeItemState: function(item, pause) {
        if(pause)
            this.pauseItem(item);
        else
            this.resumeItem(item);
    },
    pauseItem: function(item) {
        item.paused = true;
        item.pauseCount++;
    },
    resumeItem: function(item) {
        if(item.pauseCount > 0) {
            if(item.pauseCount == 1)
                item.paused = false;
            item.pauseCount--;
        }
    }
});

DomObserver.IsMutationObserverAvailable = function() {
    return !!window.MutationObserver;
};

var TimerObserver = ASPx.CreateClass(DomObserver, {
    constructor: function() {
        this.constructor.prototype.constructor.call(this);
        this.timerID = -1;
        this.observationTimeout = 300;
    },
    subscribe: function(elementID, callbackFunc) {
        DomObserver.prototype.subscribe.call(this, elementID, callbackFunc);
        if(!this.isActivated())
            this.startObserving();
    },
    isActivated: function() {
        return this.timerID !== -1;
    },
    startObserving: function() {
        if(this.isActivated())
            window.clearTimeout(this.timerID);
        this.timerID = window.setTimeout(this.onTimeout, this.observationTimeout);
    },
    onTimeout: function() {
        var observer = _aspxGetDomObserver();
        observer.doObserve();
        observer.startObserving();
    },
    doObserve: function() {
        if(!ASPx.documentLoaded) return;
        this.forEachItem(function(item) {
            if(!item.paused)
                this.doObserveForItem(item);
        }.aspxBind(this));
    },
    doObserveForItem: function(item) {
        var element = this.getItemElement(item);
        if(element)
            item.callbackFunc.call(this, element);
    }
});

var MutationObserver = ASPx.CreateClass(DomObserver, {
    constructor: function() {
        this.constructor.prototype.constructor.call(this);
        this.callbackTimeout = 10;
    },
    prepareItem: function(item) {
        item.callbackTimerID = -1;

        var target = this.getElementById(item.elementID);
        if(!target)
            return;

        var observerCallbackFunc = function() {
            if(item.callbackTimerID === -1) {
                var timeoutHander = function() {
                    item.callbackTimerID = -1;
                    item.callbackFunc.call(this, target);
                }.aspxBind(this);
                item.callbackTimerID = window.setTimeout(timeoutHander, this.callbackTimeout);
            }
        }.aspxBind(this);
        var observer = new window.MutationObserver(observerCallbackFunc);
        var config = { attributes: true, childList: true, characterData: true, subtree: true };
        observer.observe(target, config);
            
        item.observer = observer;
        item.config = config;
    },
    unsubscribe: function(elementID) {
        var item = this.items[elementID];
        if(item) {
            item.observer.disconnect();
            item.observer = null;
        }
        DomObserver.prototype.unsubscribe.call(this, elementID);
    },
    pauseItem: function(item) {
        DomObserver.prototype.pauseItem.call(this, item);
        item.observer.disconnect();
    },
    resumeItem: function(item) {
        DomObserver.prototype.resumeItem.call(this, item);
        if(!item.paused) {
            var target = this.getItemElement(item);
            if(target)
                item.observer.observe(target, item.config);
        }
    }
});

var domObserver = null;
function _aspxGetDomObserver() {
    if(domObserver == null)
        domObserver = DomObserver.IsMutationObserverAvailable() ? new MutationObserver() : new TimerObserver();
    return domObserver;
}

var ControlUpdateWatcher = ASPx.CreateClass(null, {
    constructor: function() {
        this.helpers = { };
        this.clearLockerTimerID = -1;
        this.clearLockerTimerDelay = 15;
        this.postProcessing = false;
        this.init();
    },
    init: function() {
        var postHandler = aspxGetPostHandler();
        postHandler.Post.AddHandler(this.OnPost, this);
    },
    Add: function(helper) {
        this.helpers[helper.GetName()] = helper;
    },
    CanSendCallback: function(dxCallbackOwner, arg) {
        this.LockConfirmOnBeforeWindowUnload();

        var modifiedHelpers = this.FilterModifiedHelpersByDXCallbackOwner(this.GetModifiedHelpers(), dxCallbackOwner, arg);
        if(modifiedHelpers.length === 0) return true;
        var modifiedHelpersInfo = this.GetToConfirmAndToResetLists(modifiedHelpers, dxCallbackOwner.name);
        if(!modifiedHelpersInfo) return true;

        if(modifiedHelpersInfo.toConfirm.length === 0) {
            this.ResetClientChanges(modifiedHelpersInfo.toReset);
            return true;
        }

        var helper = modifiedHelpersInfo.toConfirm[0];
        if(!confirm(helper.GetConfirmUpdateText()))
            return false;

        this.ResetClientChanges(modifiedHelpersInfo.toReset);
        return true;
    },
    OnPost: function(s, e) {
        if(this.isDxCallback(e))
            return;

		this.postProcessing = true;
        this.LockConfirmOnBeforeWindowUnload();

        var modifiedHelpersInfo = this.GetModifedHelpersInfo(e);
        if(!modifiedHelpersInfo)
            return;

        if(modifiedHelpersInfo.toConfirm.length === 0) {
            this.ResetClientChanges(modifiedHelpersInfo.toReset);
            return;
        }

        var helper = modifiedHelpersInfo.toConfirm[0];
        if(!confirm(helper.GetConfirmUpdateText())) {
            e.cancel = true;
            this.finishPostProcessing();
        }

        if(!e.cancel)
            this.ResetClientChanges(modifiedHelpersInfo.toReset);
    },
    isDxCallback: function(e) {
        return e.isDXCallback || this.isInternalUploadControlCallback();
    },
    isInternalUploadControlCallback: function() {
        var isInCallback = false;
        for(var key in this.helpers) {
            if(this.helpers.hasOwnProperty(key)) {
                var helper = this.helpers[key];
                isInCallback = isInCallback || helper.isInUploadCallback();
            }
        }
        return isInCallback;
    },
    finishPostProcessing: function() {
        this.postProcessing = false;
    },

    GetModifedHelpersInfo: function(e) {
        var modifiedHelpers = this.FilterModifiedHelpers(this.GetModifiedHelpers(), e);
        if(modifiedHelpers.length === 0) return;

        return this.GetToConfirmAndToResetLists(modifiedHelpers, e && e.ownerID);
    },
    GetToConfirmAndToResetLists: function(modifiedHelpers, ownerID) {
        var resetList = [ ];
        var confirmList = [ ];
        for(var i = 0; i < modifiedHelpers.length; i++) {
            var helper = modifiedHelpers[i];
            if(!helper.GetConfirmUpdateText()) { // ShowConfirmOnLosingChanges
                resetList.push(helper);
                continue;
            }
            if(helper.CanShowConfirm(ownerID)) { // Grid event
                resetList.push(helper);
                confirmList.push(helper);
            }
        }
        return { toConfirm: confirmList, toReset: resetList };
    },

    FilterModifiedHelpers: function(modifiedHelpers, e) {
        if(modifiedHelpers.length === 0)
            return [ ];
        if(this.RequireProcessUpdatePanelCallback(e))
            return this.FilterModifiedHelpersByUpdatePanels(modifiedHelpers);
        if(this.postProcessing)
            return this.FilterModifiedHelpersByPostback(modifiedHelpers);
        return modifiedHelpers;
    },

    FilterModifiedHelpersByDXCallbackOwner: function(modifiedHelpers, dxCallbackOwner, arg) {
        var result = [ ];
        for(var i = 0; i < modifiedHelpers.length; i++) {
            var helper = modifiedHelpers[i];
            if(helper.NeedConfirmOnCallback(dxCallbackOwner, arg))
                result.push(helper);
        }
        return result;
    },

    FilterModifiedHelpersByUpdatePanels: function(modifiedHelpers) {
        var result = [ ];
        var updatePanels = this.GetUpdatePanelsWaitedForUpdate();
        for(var i = 0; i < updatePanels.length; i++) {
            var panelID = updatePanels[i].replace(/\$/g, "_");
            var panel = ASPx.GetElementById(panelID);
            if(!panel) continue;
            for(var j = 0; j < modifiedHelpers.length; j++) {
                var helper = modifiedHelpers[j];
                if(ASPx.GetIsParent(panel, helper.GetControlMainElement()))
                    result.push(helper);
            }
        }
        return result;
    },

    FilterModifiedHelpersByPostback: function(modifiedHelpers) {
        var result = [ ];
        for(var i = 0; i < modifiedHelpers.length; i++) {
            var helper = modifiedHelpers[i];
            if(helper.NeedConfirmOnPostback())
                result.push(helper);
        }
        return result;
    },

    RequireProcessUpdatePanelCallback: function(e) {
        var rManager = this.GetMSRequestManager();
        if(rManager && e && e.isMSAjaxCallback)
            return rManager._postBackSettings.async;
        return false;
    },

    GetUpdatePanelsWaitedForUpdate: function() {
        var rManager = this.GetMSRequestManager();
        if(!rManager) return [ ];
        var panelUniqueIDs = rManager._postBackSettings.panelsToUpdate || [ ];

        var panelClientIDs = [ ];
        for(var i = 0; i < panelUniqueIDs.length; i++) {
            var index = ASPx.Data.ArrayIndexOf(rManager._updatePanelIDs, panelUniqueIDs[i]);
            if(index >= 0)
                panelClientIDs.push(rManager._updatePanelClientIDs[index]);
        }

        return panelClientIDs;
    },

    GetMSRequestManager: function() {
        return ASPx.GetMSAjaxRequestManager();
    },

    GetModifiedHelpers: function() {
        var result = [ ];
        for(var key in this.helpers) { 
            if(this.helpers.hasOwnProperty(key)) {
                var helper = this.helpers[key];
                if(helper.HasChanges())
                    result.push(helper);
            }
        }
        return result;
    },

    ResetClientChanges: function(modifiedHelpers) {
        for(var i = 0; i < modifiedHelpers.length; i++)
            modifiedHelpers[i].ResetClientChanges();
    },

    GetConfirmUpdateMessage: function() {
        if(this.confirmOnWindowUnloadLocked) return;

        var modifiedHelpersInfo = this.GetModifedHelpersInfo();
        if(!modifiedHelpersInfo || modifiedHelpersInfo.toConfirm.length === 0) 
            return;
        var helper = modifiedHelpersInfo.toConfirm[0];
        return helper.GetConfirmUpdateText();
    },

    LockConfirmOnBeforeWindowUnload: function() {
        this.confirmOnWindowUnloadLocked = true;
        this.clearLockerTimerID = ASPx.Timer.ClearTimer(this.clearLockerTimerID);
        this.clearLockerTimerID = window.setTimeout(function() {
            this.confirmOnWindowUnloadLocked = false;
        }.aspxBind(this), this.clearLockerTimerDelay);
    },

    OnWindowBeforeUnload: function(e) {
        var confirmMessage = this.GetConfirmUpdateMessage();
        if(confirmMessage)
            e.returnValue = confirmMessage;
        this.finishPostProcessing();
        return confirmMessage;
    },
    OnWindowUnload: function(e) {
        if(this.confirmOnWindowUnloadLocked) return;
        var modifiedHelpersInfo = this.GetModifedHelpersInfo();
        if(!modifiedHelpersInfo) return;
        this.ResetClientChanges(modifiedHelpersInfo.toReset);
    },
    OnMouseDown: function(e) {
        if(ASPx.Browser.IE)
            this.PreventBeforeUnloadOnLinkClick(e);
    },
    OnFocusIn: function(e) {
        if(ASPx.Browser.IE)
            this.PreventBeforeUnloadOnLinkClick(e);
    },

    PreventBeforeUnloadOnLinkClick: function(e) {
        if(ASPx.GetObjectKeys(this.helpers).length == 0)
            return;
        var link = ASPx.GetParentByTagName(ASPx.Evt.GetEventSource(e), "A");
        if(!link || link.dxgvLinkClickHanlderAssigned)
            return;
        var url = ASPx.Attr.GetAttribute(link, "href");
        if(!url || url.indexOf("javascript:") < 0)
            return;
        ASPx.Evt.AttachEventToElement(link, "click", function(ev) { return ASPx.Evt.PreventEvent(ev); });
        link.dxgvLinkClickHanlderAssigned = true;
    }
});

ControlUpdateWatcher.Instance = null;
ControlUpdateWatcher.getInstance = function () {
    if (!ControlUpdateWatcher.Instance) {
        ControlUpdateWatcher.Instance = new ControlUpdateWatcher();

        ASPx.Evt.AttachEventToElement(window, "beforeunload", function(e) {
            return ControlUpdateWatcher.Instance.OnWindowBeforeUnload(e);
        });
        ASPx.Evt.AttachEventToElement(window, "unload", function(e) {
            ControlUpdateWatcher.Instance.OnWindowUnload(e);
        });
        ASPx.Evt.AttachEventToDocument("mousedown", function(e) {
            ControlUpdateWatcher.Instance.OnMouseDown(e);
        });
        ASPx.Evt.AttachEventToDocument("focusin", function(e) {
            ControlUpdateWatcher.Instance.OnFocusIn(e);
        });
    }
    return ControlUpdateWatcher.Instance;
};

var UpdateWatcherHelper = ASPx.CreateClass(null, {
    constructor: function(owner) {
        this.owner = owner;
        this.ownerWatcher = ControlUpdateWatcher.getInstance();
        this.ownerWatcher.Add(this);
    },
    GetName: function() {
        return this.owner.name;
    },
    GetControlMainElement: function() {
        return this.owner.GetMainElement();
    },
    GetControlParentForm: function(){
        return ASPx.GetParentByTagName(this.GetControlMainElement(), "FORM");
    },
    CanShowConfirm: function(requestOwnerID) {
        return true;
    },
    HasChanges: function() {
        return false;
    },
    GetConfirmUpdateText: function() {
        return "";
    },
    NeedConfirmOnCallback: function(dxCallbackOwner) {
        return true;
    },
    NeedConfirmOnPostback: function() {
        if(ASPx.IsUploadSubmitRequest)
            return !ASPx.IsUploadSubmitRequest(this.GetControlParentForm());
        return true;
    },
    ResetClientChanges: function() {
    },
    ConfirmOnCustomControlEvent: function() {
        var confirmMessage = this.GetConfirmUpdateText();
        if(confirmMessage)
            return confirm(confirmMessage);
        return false;
    },
    isInUploadCallback: function() {
        return false;
    }
});

var ControlTabIndexManager = ASPx.CreateClass(null, {
    constructor: function() {
        this.elementsWithChangedTabIndex = {};
    },

    getChangedElementsForControlId: function(id) {
        if(!this.elementsWithChangedTabIndex[id])
            this.elementsWithChangedTabIndex[id] = [];
        return this.elementsWithChangedTabIndex[id];
    },

    isElementWithChangedIndex: function(element) {
        for(var key in this.elementsWithChangedTabIndex)
            if(this.elementsWithChangedTabIndex.hasOwnProperty(key))
                if(this.elementsWithChangedTabIndex[key].indexOf(element) !== -1)
                    return true;
        return false;
    },

    changeTabIndexAttribute: function(element, id) {
        var elements = this.getChangedElementsForControlId(id);
        ASPx.Attr.ChangeTabIndexAttribute(element);
        if(elements.indexOf(element) === -1)
            elements.push(element);
    },

    restoreTabIndexAttribute: function(element, id) {
        var elements = this.getChangedElementsForControlId(id),
            index = elements.indexOf(element);
        if(index !== -1) {
            elements.splice(index, 1);
            if(!this.isElementWithChangedIndex(element))
                ASPx.Attr.RestoreTabIndexAttribute(element);
        }
    }
});

ControlTabIndexManager.Instance = null;
ControlTabIndexManager.getInstance = function() {
    if(!ControlTabIndexManager.Instance)
        ControlTabIndexManager.Instance = new ControlTabIndexManager();
    return ControlTabIndexManager.Instance;
};

var ControlCallbackHandlersQueue = ASPx.CreateClass(null, {
    constructor: function (owner) {
        this.owner = owner;
        this.handlerInfos = [];
    },
    addCallbackHandler: function(handlerInfo) {
        this.handlerInfos.push(handlerInfo);
    },
    executeCallbacksHandlers: function() {
        for(var i = 0, handlerInfo; handlerInfo = this.handlerInfos[i]; i++)
            handlerInfo.handler.call(this.owner, handlerInfo.result);
        this.handlerInfos = [];
    }
});

var ControlCallbackQueueHelper = ASPx.CreateClass(null, {
    constructor: function (owner) {
        this.owner = owner;
        this.pendingCallbacks = [];
        this.receivedCallbacks = [];
        this.attachEvents();
    },
    showLoadingElements: function () {
        this.owner.ShowLoadingDiv();
        if (this.owner.IsCallbackAnimationEnabled())
            this.owner.StartBeginCallbackAnimation();
        else
            this.owner.ShowLoadingElementsInternal();
    },
    attachEvents: function () {
        this.owner.EndCallback.AddHandler(this.onEndCallback.aspxBind(this));
        this.owner.CallbackError.AddHandler(this.onCallbackError.aspxBind(this));
    },
    detachEvents: function () {
        this.owner.EndCallback.RemoveHandler(this.onEndCallback);
        this.owner.CallbackError.RemoveHandler(this.onCallbackError);
    },
    onCallbackError: function (owner, result) {
        this.sendErrorToChildControl(result);
    },
    ignoreDuplicates: function () {
        return true;
    },
    hasDuplicate: function (arg) {
        for (var i in this.pendingCallbacks) {
            if (this.pendingCallbacks[i].arg == arg && this.pendingCallbacks[i].state != ASPx.callbackState.aborted)
                return true;
        }
        return false;
    },
    getToken: function (halperContext, callbackInfo) {
        return {
            cancel: function () {
                if (callbackInfo.state == ASPx.callbackState.sent) {
                    callbackInfo.state = ASPx.callbackState.aborted;
                    halperContext.sendNext();
                }
                if (callbackInfo.state == ASPx.callbackState.inTurn)
                    ASPx.Data.ArrayRemove(halperContext.pendingCallbacks, callbackInfo);
            },
            callbackId: -1
        };
    },
    sendCallback: function (arg, handlerContext, handler, commandName, onBeforeSend) {
        if (this.ignoreDuplicates() && this.hasDuplicate(arg))
            return false;
        var handlerContext = handlerContext || this.owner;
        var callbackInfo = {
            arg: arg,
            handlerContext: handlerContext,
            handler: handler || handlerContext.OnCallback,
            state: ASPx.callbackState.inTurn,
            callbackId: -1,
            onBeforeSend: onBeforeSend
        };
        this.pendingCallbacks.push(callbackInfo);
        if (!this.hasActiveCallback()) {
            this.createCallbackByCallbackInfo(callbackInfo, commandName);
        }
        return this.getToken(this, callbackInfo);
    },
    hasActiveCallback: function () {
        return this.getCallbacksInfoByState(ASPx.callbackState.sent).length > 0;
    },
    sendNext: function () {
        var nextCallbackInfo = this.getCallbacksInfoByState(ASPx.callbackState.inTurn)[0];
        if (nextCallbackInfo) {
            this.createCallbackByCallbackInfo(nextCallbackInfo);
            return nextCallbackInfo.callbackId;
        }
    },
    createCallbackByCallbackInfo: function(callbackInfo, commandName) {
        if(callbackInfo.onBeforeSend)
            callbackInfo.onBeforeSend();
        callbackInfo.callbackId = this.owner.CreateCallback(callbackInfo.arg, commandName);
        callbackInfo.state = ASPx.callbackState.sent;
    },
    onEndCallback: function () {
        if (!this.owner.isErrorOnCallback && this.hasPendingCallbacks()) {
            var curCallbackId;
            var curCallbackInfo;
            var handlerContext;

            for (var i in this.receivedCallbacks) {
                if(this.receivedCallbacks.hasOwnProperty(i)) {
                    curCallbackId = this.receivedCallbacks[i];
                    curCallbackInfo = this.getCallbackInfoById(curCallbackId);
                    if (curCallbackInfo.state != ASPx.callbackState.aborted) {
                        handlerContext = curCallbackInfo.handlerContext;
                        if (handlerContext.OnEndCallback)
                            handlerContext.OnEndCallback();
                        this.sendNext();
                    }
                    ASPx.Data.ArrayRemove(this.pendingCallbacks, curCallbackInfo);
                }
            }
            ASPx.Data.ArrayClear(this.receivedCallbacks);
        }
    },
    hasPendingCallbacks: function () {
        return this.pendingCallbacks && this.pendingCallbacks.length && this.pendingCallbacks.length > 0;
    },
    processCallback: function (result, callbackId) {
        this.receivedCallbacks.push(callbackId);
        if (this.hasPendingCallbacks()) {
            var callbackInfo = this.getCallbackInfoById(callbackId);
            if (callbackInfo.state != ASPx.callbackState.aborted)
                callbackInfo.handler.call(callbackInfo.handlerContext, result);
        }
    },
    getCallbackInfoById: function (id) {
        for (var i in this.pendingCallbacks) {
            if (this.pendingCallbacks[i].callbackId == id)
                return this.pendingCallbacks[i];
        }
    },
    getCallbacksInfoByState: function (state) {
        var result = [];
        for (var i in this.pendingCallbacks) {
            if (this.pendingCallbacks[i].state == state)
                result.push(this.pendingCallbacks[i]);
        }
        return result;
    },
    sendErrorToChildControl: function (callbackObj) {
        if (!this.hasPendingCallbacks())
            return;

        var callbackInfo = this.getCallbackInfoById(callbackObj.callbackId || 0);
        if (!callbackInfo)
            return;

        var hasChildControlHandler = (callbackInfo.handlerContext != this.owner) && callbackInfo.handlerContext.OnCallbackError;
        if (hasChildControlHandler)
            callbackInfo.handlerContext.OnCallbackError.call(callbackInfo.handlerContext, callbackObj.message, callbackObj.data);
    }
});

var AccessibilityHelperBase = ASPx.CreateClass(null, {
    constructor: function(control) {
        this.control = control;
        this.timerID = -1;
        this.pronounceMessageTimeout = 500;

        this.activeItem = this.getItems()[0];
        this.pronounceIsStarted = false;
    },

    PronounceMessage: function(text, activeItemArgs, inactiveItemArgs, mainElementArgs, ownerMainElement) {   
        this.timerID = ASPx.Timer.ClearTimer(this.timerID);
        this.pronounceIsStarted = true;
        this.timerID = window.setTimeout(function() {
            this.PronounceMessageCore(text, activeItemArgs, inactiveItemArgs, mainElementArgs, ownerMainElement);
        }.aspxBind(this), this.getPronounceTimeout());
    },
    PronounceMessageCore: function(text, activeItemArgs, inactiveItemArgs, mainElementArgs, ownerMainElement) {
        if(!this.getItems())
            return;
        this.toogleItem();

        var mainElement = this.getMainElement();
        var activeItem = this.getItem(true);
        var inactiveItem = this.getItem();

        if(ASPx.Attr.GetAttribute(mainElement, "role") != "application")
            mainElementArgs = this.addArguments(mainElementArgs, { "aria-activedescendant" : activeItem.id });
        
        var messageAttrObj = {};
        var activeItemRole = ASPx.Attr.GetAttribute(activeItem, "role");
        var attrName = activeItemRole == "combobox" ? "aria-label" : "innerHtml";
        messageAttrObj[attrName] = ASPx.Str.EncodeHtml(text);
        activeItemArgs = this.addArguments(activeItemArgs, messageAttrObj);
        messageAttrObj[attrName] = "";
        inactiveItemArgs = this.addArguments(inactiveItemArgs, messageAttrObj);
        
        var errorTextElement = null;
        if(this.control.GetErrorCell()) {
            errorTextElement = this.getAriaExplanatoryTextManager().GetErrorTextElement();
            activeItemArgs = this.addArguments(activeItemArgs,      {"aria-invalid"  : !this.control.isValid ? "true" : "" });
            mainElementArgs = this.addArguments(mainElementArgs,    { "aria-invalid" : "" });
            inactiveItemArgs = this.addArguments(inactiveItemArgs,  { "aria-invalid" : "" });
        }

        this.changeActivityAttributes(activeItem, activeItemArgs);
        if(errorTextElement) {
            this.getAriaExplanatoryTextManager().SetOrRemoveText([activeItem], errorTextElement, !this.control.isValid, false, true);
            this.getAriaExplanatoryTextManager().SetOrRemoveText([mainElement, inactiveItem], errorTextElement, false, false, false);
        }
        this.changeActivityAttributes(mainElement, mainElementArgs);

        if(!!ownerMainElement && ASPx.Attr.GetAttribute(ownerMainElement, "role") != "application")
            this.changeActivityAttributes(ownerMainElement, { "aria-activedescendant": activeItem.id });
        this.changeActivityAttributes(inactiveItem, inactiveItemArgs);
        this.pronounceIsStarted = false;
    },

    GetActiveElement: function(inputIsMainElement) {
        if(this.pronounceIsStarted) return null;
        var mainElement = inputIsMainElement ? this.control.GetInputElement() : this.getMainElement();
        var activeElementId = ASPx.Attr.GetAttribute(mainElement, 'aria-activedescendant');
        return activeElementId ? ASPx.GetElementById(activeElementId) : mainElement;
    },

    getMainElement: function() {
        if(!ASPx.IsExistsElement(this.mainElement))
            this.mainElement = this.control.GetAccessibilityAssistantElement();
        return this.mainElement;
    },
    getItems: function() {
        if(!ASPx.IsExistsElement(this.items))
            this.items = ASPx.GetChildElementNodes(this.getMainElement());
        return this.items;
    },
    getItem: function(isActive) {
        if(isActive)
            return this.activeItem;
        var items = this.getItems();
        return items[0] === this.activeItem ? items[1] : items[0];
    },
    getAriaExplanatoryTextManager: function() { return this.control.ariaExplanatoryTextManager; },
    getPronounceTimeout: function() { return this.pronounceMessageTimeout; },
    toogleItem: function() {
        this.activeItem = this.getItem();
    },
    addArguments: function(targetArgs, newArgs) {
        if(!targetArgs) targetArgs = { };
        for(var key in newArgs) {
            if(newArgs.hasOwnProperty(key) && !targetArgs.hasOwnProperty(key))
                targetArgs[key] = newArgs[key];
        }
        return targetArgs;
    },
    changeActivityAttributes: function(element, args) {
        if(!element)
            return;
        for(var key in args) {
            if(args.hasOwnProperty(key)) {
                var value = args[key];
                if(key == "innerHtml")
                    ASPx.SetInnerHtml(element, value);
                else {
                    var action = value !== "" ? ASPx.Attr.SetAttribute : ASPx.Attr.RemoveAttribute;
                    action(element, key, value);
                }
            }
        }
    }
});

var AccessibilityPronouncer = ASPx.CreateClass(null, {
    constructor: function() {
        this.pronouncerId = "dxPronouncer";

        this.initialized = false;
        this.focusableMessageElement = null;
        this.messageElement = null;

        this.pronouncers = {
            live: new AccessibilityLivePronouncer(this),
            descendant: new AccessibilityDescendantPronouncer(this)
        };
    },
    Pronounce: function(args, type) {
        this.pronouncers[type].Pronounce(args);
    },
    EnsureInitialize: function() {
        if(!this.initialized)
            this.initialize();
    },
    RemoveState: function() {
        for(var pronouncer in this.pronouncers)
            if(this.pronouncers.hasOwnProperty(pronouncer))
                pronouncer.RemoveState();
    },
    RestoreControlState: function(type, mainElement) {
        this.pronouncers[type].RestoreControlState(mainElement);
    },
    RestoreElementsState: function(type, elements) {
        this.pronouncers[type].RestoreElementsState(elements);
    },
    RestoreElementState: function(type, element) {
        this.pronouncers[type].RestoreElementState(element);
    },

    initialize: function() {
        this.createFocusableMessageElement();
        this.createMessageElement();

        this.prepareFocusableMessageElement();
        this.setAttributesForKeyboardNavigation();
        this.initialized = true;
    },
    createFocusableMessageElement: function() {
        var focusableMessageElement = document.createElement("DIV");
        document.body.appendChild(focusableMessageElement);
        this.focusableMessageElement = focusableMessageElement;   
    },
    prepareFocusableMessageElement: function() {
        this.focusableMessageElement.className = "dxAIFME";
    },
    setAttributesForKeyboardNavigation: function() {
        ASPx.Attr.Aria.SetApplicationRole(this.focusableMessageElement);
        ASPx.Attr.Aria.SetSilence(this.focusableMessageElement);
    },
    createMessageElement: function() {
        var messageElement = document.createElement("DIV");
        messageElement.id = this.pronouncerId;
        ASPx.Attr.SetAttribute(messageElement, "role", "note");

        this.focusableMessageElement.appendChild(messageElement);
        this.messageElement = messageElement;
    },
    getMessage: function(messagePartsArg) {
        var messageParts = messagePartsArg.filter(function(x) { return ASPx.IsExists(x); });
        return messageParts.join(", ");
    }
});

var AccessibilityPronouncerBase = ASPx.CreateClass(null, {
    constructor: function() {
        this.state = { };
    },
    Pronounce: function(args) {
        var messageElement = this.getMessageElement();
        ASPx.Attr.Aria.SetOrRemoveLabel(messageElement);
        ASPx.SetInnerHtml(messageElement, "");
        this.PronounceCore(args);
    },
    PronounceCore: function(args) { },
    SaveElementState: function(element) { 
        if(this.state[element.id])
            return;

        this.state[element.id] = {
            element: element,
            descendant: ASPx.Attr.GetAttribute(element, ASPx.Attr.Aria.descendant)
        };
    },
    RemoveState: function() {
        this.state = { };
    },
    RestoreControlState: function(mainElement) { 
        for(var elementInfo in this.state) {
            if(this.state.hasOwnProperty(elementInfo)) {
                var element = this.state[elementInfo].element;
                if(!mainElement || ASPx.GetIsParent(mainElement, element))
                    this.RestoreElementState(element);
            }
        }
    },
    RestoreElementsState: function(elements) { 
        for(var i = 0; i < elements.length; i++)
            this.RestoreElementState(elements[i]);
    },
    RestoreElementState: function(element) {
        var elementState = this.state[element.id];
        if(!elementState)
            return;

        ASPx.Attr.Aria.SetOrRemoveDescendant(element, elementState.descendant);
        delete this.state[element.id];
    },
    getMessage: function(args) {
        return ASPx.AccessibilityPronouncer.getMessage(args.messageParts);
    },
    getMessageElement: function() {
        return ASPx.AccessibilityPronouncer.messageElement;
    },
    getFocusableMessageElement: function() {
         return ASPx.AccessibilityPronouncer.focusableMessageElement;
    }
});
var AccessibilityLivePronouncer = ASPx.CreateClass(AccessibilityPronouncerBase, {
    constructor: function() {
        this.constructor.prototype.constructor.call(this);
    },
    PronounceCore: function(args) {
        var message = this.getMessage(args);
        var messageElement = this.getMessageElement();
        ASPx.Attr.SetAttribute(this.getFocusableMessageElement(), "aria-live", "assertive");
        ASPx.Attr.Aria.SetAtomic(this.getFocusableMessageElement(), "true");

        ASPx.SetInnerHtml(messageElement, ASPx.Str.EncodeHtml(message));
    }
});
var AccessibilityDescendantPronouncer = ASPx.CreateClass(AccessibilityPronouncerBase, {
    constructor: function() {
        this.constructor.prototype.constructor.call(this);
    },
    PronounceCore: function(args) {
        var message = this.getMessage(args);
        var activeElement = ASPx.GetActiveElement();
        var messageElement = this.getMessageElement();
        
        this.SaveElementState(activeElement);
        ASPx.Attr.RemoveAttribute(this.getFocusableMessageElement(), "aria-live");
        ASPx.Attr.RemoveAttribute(this.getFocusableMessageElement(), "aria-atomic");
        ASPx.Attr.Aria.SetOrRemoveLabel(messageElement, message);
        ASPx.Attr.Aria.SetOrRemoveDescendant(activeElement, messageElement.id);
    }
});
ASPx.AccessibilityPronouncerType = {
    live: "live",
    descendant: "descendant"
};
ASPx.AccessibilityPronouncer = new AccessibilityPronouncer();

var RestoreFocusHelper = ASPx.CreateClass(null, {
    constructor: function() {
        this.excludedIDs = [ "DXCBtn" ]; // command button id is autogenerated
        this.pronouncerType = ASPx.AccessibilityPronouncerType.live;
        this.callbackQueue = [];
        this.Initialize();
    },
    Initialize: function() {
        var that = this;
        ASPx.attachToLoad(function() {
            ASPxClientControl.GetControlCollection().BeginCallback.AddHandler(that.OnBeginCallback, that);
            ASPxClientControl.GetControlCollection().EndCallback.AddHandler(that.OnEndCallback, that);
        });
    },
    OnBeginCallback: function(s, e) {
        var control = e.control;
        if(!control.allowRestoreFocusOnCallbacks())
            return;
        
        control.accessibilityFocusTreeLine = this.getFocusTreeLine(control);
        var controlHasCallbackTreeLine = this.callbackQueueContainsTreeLine(control);
        this.pushTreeLineInfoIntoCallbackQueue(control);
        if(control.accessibilityFocusTreeLine && !controlHasCallbackTreeLine)
            control.SendMessageToAssistiveTechnology(this.getDefaultCallbackMessage());
    },
    OnEndCallback: function(s, e) {
        var control = e.control;
        if(!control.allowRestoreFocusOnCallbacks())
            return;
      
        var treeLineInfo = this.shiftTreeLineInfoFromCallbackQueue(control);
        if(treeLineInfo.queueLength == 0) {
            if(!control.accessibilityFocusTreeLine && treeLineInfo.treeLine)
                control.accessibilityFocusTreeLine = treeLineInfo.treeLine;

            var focusElement = this.findFocusElement(control);
            var focusIsManagerByPopupwindow = this.isFocusManagedByActivePopupWindow(focusElement);
            var focusIsManagedByControl = control.shouldPreventFocusRestoringOnCallback && control.shouldPreventFocusRestoringOnCallback();
            if(!focusIsManagerByPopupwindow && !focusIsManagedByControl)
                ASPx.AccessibilityUtils.SetFocusAccessible(focusElement);
            delete control.accessibilityFocusTreeLine;
        }
    },
    pushTreeLineInfoIntoCallbackQueue: function(control) {
        var controlTreeLine = control.accessibilityFocusTreeLine ? control.accessibilityFocusTreeLine.slice(0) : null;
        if(!this.callbackQueue[control.name])
            this.callbackQueue[control.name] = [];
        this.callbackQueue[control.name].push(controlTreeLine);
    },
    shiftTreeLineInfoFromCallbackQueue: function(control) {
        var treeLineInfo = { queueLength: 0, treeLine: null };
        var treeLines = this.callbackQueue[control.name];
        if(treeLines && treeLines.length > 0) {
            treeLineInfo.treeLine = treeLines.shift();
            var linesCount = treeLines.length;
            treeLineInfo.queueLength = linesCount;
            if(linesCount > 0 && !treeLines[0] && treeLineInfo.treeLine)
                treeLines[0] = treeLineInfo.treeLine.slice(0);
        }
        return treeLineInfo;
    },
    callbackQueueContainsTreeLine: function(control) {
        var treeLines = this.callbackQueue[control.name];
        if(!treeLines || treeLines.length == 0) 
            return false;
        if(treeLines[treeLines.length - 1])
            return true;
        return false;
    },
    getDefaultCallbackMessage: function() {
        return ASPx.AccessibilitySR.DefaultCallbackMessage;
    },
    isFocusManagedByActivePopupWindow: function(focusElement) {
        var popupControl = this.getActivePopupControl();
        if(!popupControl || popupControl.accessibleFocusElement)
            return false;

        this.initializePopupAccessibleFocusElement(popupControl, focusElement);
        return popupControl.setFocusOnCallback;
    },
    getActivePopupControl: function() {
        var activePopupWindow = ASPx.GetPopupControlCollection && ASPx.GetPopupControlCollection().GetCurrentActiveWindowElement();
        if(!activePopupWindow)
            return null;

        var popupInfo = ASPx.GetPopupControlCollection().GetPopupWindowFromID(activePopupWindow.id);
        return popupInfo.popupControl;
    },
    initializePopupAccessibleFocusElement: function(popupControl, focusElement) {
        if(popupControl.setFocusOnCallback)
            popupControl.accessibleFocusElement = focusElement;
        else {
            var parentControl = popupControl.GetParentControl();
            if(parentControl && parentControl.GetMainElement())
                popupControl.accessibleFocusElement = ASPx.FindFirstChildActionElement(parentControl.GetMainElement());
        }
    },
    getFocusTreeLine: function(control) {
        var element = ASPx.GetActiveElement();
        if(!ASPx.IsExistsElement(element))
            return null;
        var mainElement = control.GetMainElement();
        if(!ASPx.GetIsParent(mainElement, element)) {
            var treeInfo = this.findFocusedControlElement(mainElement, element);
            element = treeInfo.focusElement;
            mainElement = treeInfo.rootElement;
        }
        return this.getTreeLineCore(mainElement, element);
    },
    getTreeLineCore: function(mainElement, element) {
        if(!element) return null;
        
        treeLine = [ ];
        while(element) {
            treeLine.push({ 
                id: element.id,
                tagName: element.tagName,
                index: ASPx.Data.ArrayIndexOf(element.parentNode.childNodes, element)
            });
            if(element === mainElement || element === document.body)
                break;
            element = element.parentNode;
        }
        return treeLine;
    },
    findFocusedControlElement: function(mainElement, activeElement) {
        var element = null;
        var parentElement = mainElement;
        var focusedEditor = ASPx.IsExists(ASPx.GetFocusedEditor) ? ASPx.GetFocusedEditor() : null;
        if(focusedEditor && ASPx.GetIsParent(mainElement, focusedEditor.GetMainElement()))
            element = focusedEditor.GetFocusableInputElement();
        else {
            if(mainElement && activeElement) {
                var mainControl = ASPx.GetClientControlByElementID(mainElement.id);
                var parentControls = ASPx.GetParentClientControls(activeElement.id);
                for(var i = parentControls.length - 1; i > -1; i--) {   
                    if(mainControl.name == parentControls[i].name) {
                        element = activeElement;
                        var rootIndex = i > 0 ? i - 1 : i;
                        parentElement = parentControls[rootIndex].GetMainElement();
                        if(!parentElement && parentControls[rootIndex].GetCurrentWindowElement)
                            parentElement = parentControls[rootIndex].GetCurrentWindowElement();
                        break;
                    }
                }
            }
        }
        return { focusElement: element, rootElement: parentElement };    
    },
    findFocusElement: function(control) {
        if(!control.accessibilityFocusTreeLine)
            return;

        var treeLine = control.accessibilityFocusTreeLine.slice(0);
        var focusElementParent = this.findFocusElementParentById(treeLine);
        if(!focusElementParent) 
            return;

        return this.findFocusElementFromDOMTree(treeLine, focusElementParent);
    },
    findFocusElementParentById: function(treeLine) {
        for(var i = 0; i < treeLine.length; i++) {
            var id = treeLine[i].id;
            if(!this.isValidId(id))
                continue;
            var element = document.getElementById(id);
            if(element) {
                // get first part of tree line and reverse it
                treeLine.splice(i, treeLine.length - i);
                treeLine.reverse();
                return element;
            }
        }
        return null;
    },
    findFocusElementFromDOMTree: function(treeLine, focusElementParent) {
        var element = focusElementParent;
        for(var i = 0; i < treeLine.length; i++) {
            var info = treeLine[i];

            if(info.index >= element.childNodes.length) {
                element = element.childNodes.length > 0 ? element.childNodes[element.childNodes.length - 1] : null;
                return this.findNeighbourFocusElement(element, focusElementParent);
            }

            var child = element.childNodes[info.index];
            if(child.tagName !== info.tagName)
                return this.findNeighbourFocusElement(child, focusElementParent);

            element = child;
        }
        return element;
    },
    findNeighbourFocusElement: function(element, focusElementParent) {
        ASPx.ActionElementsCache.BeginUsage();
        var result = this.findNeighbourFocusElementCore(element, focusElementParent);
        ASPx.ActionElementsCache.EndUsage();
        return result;
    },
    findNeighbourFocusElementCore: function(element, focusElementParent) {
        if(!element || !element.parentNode) return null;

        var neighbours = element.parentNode.childNodes;
        var indices = this.calcLeftRightIndices(ASPx.Data.ArrayIndexOf(neighbours, element), neighbours.length);

        for(var i = 0; i < indices.length; i++) {
            var index = indices[i];
            var actionElement = ASPx.FindFirstChildActionElement(neighbours[index]);
            if(actionElement)
                return actionElement;
        }

        if(element === focusElementParent)
            return null;
        return this.findNeighbourFocusElement(element.parentNode, focusElementParent);
    },
    calcLeftRightIndices: function(startIndex, count) {
        var indices = [ ];
        var incSides = [ 0, 0 ];
        var index = startIndex;

        for(var i = 0; i < count; i++) {
            indices.push(index);

            var even = i % 2 === 0;
            var nextIndex = this.calcNextIndex(startIndex, count, incSides, even);
            if(nextIndex < 0)
                nextIndex = this.calcNextIndex(startIndex, count, incSides, !even);
            
            index = nextIndex;
        }
        return indices;
    },
    calcNextIndex: function(startIndex, count, incSides, even) {
        var sideIndex = even ? 0 : 1;
        var inc = incSides[sideIndex];
        inc += even ? -1 : 1;

        var nextIndex = startIndex + inc;
        if(nextIndex >= 0 && nextIndex < count) {
            incSides[sideIndex] = inc;
            return nextIndex;
        }
        return -1;
    },
    isValidId: function(id) {
        return id && !this.isExcludedId(id);
    },
    isExcludedId: function(id) {
        var result = false;
        for(var i = 0; i < this.excludedIDs.length; i++) {
            if(id.indexOf(this.excludedIDs[i]) > -1) {
                result = true;
                break;
            }
        }
        return result;
    }
});

var EventStorage = ASPx.CreateClass(null, {
    constructor: function() {
        this.bag = { };
    },
    Save: function(e, data, overwrite) {
        var key = this.getEventKey(e);
        if(this.bag.hasOwnProperty(key) && !overwrite)
            return;
        this.bag[key] = data;
        window.setTimeout(function() { delete this.bag[key]; }.aspxBind(this), 100);
    },
    Load: function(e) {
        var key = this.getEventKey(e);
        return this.bag[key];
    },
    getEventKey: function(e) {
        if(ASPx.IsExists(e.timeStamp))
            return e.timeStamp.toString();
        var eventSource = ASPx.Evt.GetEventSource(e);
        var type = e.type.toString();
        return eventSource ? type + "_" + eventSource.uniqueID.toString() : type;
    }
});
ASPx.RestoreFocusHelper = new RestoreFocusHelper();

EventStorage.Instance = null;
EventStorage.getInstance = function() {
    if(!EventStorage.Instance)
        EventStorage.Instance = new EventStorage();
    return EventStorage.Instance;
};
var GetGlobalObject = function(objectName) {
    var fields = objectName.split('.');
    var obj = window[fields[0]];
    for(var i = 1; obj && i < fields.length; i++) {
        obj = obj[fields[i]];
    }
    return obj;
};
var GetExternalScriptProcessor = function() {
    return ASPx.ExternalScriptProcessor ? ASPx.ExternalScriptProcessor.getInstance() : null;
};

var SAVED_WIDTH_ATTR = "data-dx-ripple-saved-width";
var RIPPLE_FIXED_ROW_ATTR = "data-dx-ripple-locked";
var READ_ONLY_COMBOBOX_MARKER_CSS_CLASS = "dxICBReadonlyMarker";
var ThemesWithRipple = ['Material'];
var RippleHelper = {
    rippleTargetClassName: "dxRippleTarget",
    rippleTargetExternalClassName: "dxRippleTargetExternal",
    rippleContainerClassName: "dxRippleContainer",
    rippleClassName: "dxRipple",
    touchRadius: -1,
    isMobileExternalRipple: null,
    zoom: 1,

    Init: function() {
        if(this.getIsRippleFunctionalityEnabled()) {
            setTimeout(function() {
                this.calcTouchRadius();
            }.aspxBind(this), 0);
        }
    },
    calcTouchRadius: function() {
        var testBlock = document.createElement("DIV");
        ASPx.SetStyles(testBlock, {
            height: "1in",
            width: "1in",
            left: "-100%",
            top: "-100%",
            position: "absolute"
        });
        document.body.appendChild(testBlock);
        this.touchRadius = (1.8 / 2.54) * Math.max(testBlock.offsetWidth, testBlock.offsetHeight);
        document.body.removeChild(testBlock);
    },
    isRippleFunctionalityEnabled: null,
    checkRippleFunctionality: function() {
        if(ASPx.Browser.Safari && ASPx.Browser.Version <= 5.1)
            return false;
        for(var i = 0; i < ThemesWithRipple.length; i++) {
            var firstRippleThemeElement = document.querySelector("[class*='_" + ThemesWithRipple[i] + "']");
            if(firstRippleThemeElement)
                return true;
        }  
        return false;
    },
    ReInit: function() {
        this.isRippleFunctionalityEnabled = null;
        this.Init();
    },

    onDocumentMouseDown: function(evt) {
        if(RippleHelper.getIsRippleFunctionalityEnabled())
            RippleHelper.processMouseDown(evt);
    },
    getIsRippleFunctionalityEnabled: function() {
        if(!ASPx.IsExists(this.isRippleFunctionalityEnabled))
            this.isRippleFunctionalityEnabled = this.checkRippleFunctionality();
        return this.isRippleFunctionalityEnabled;
    },

   createTargetInfo: function(target) {
        return { 
            x: ASPx.GetAbsoluteX(target),
            y: ASPx.GetAbsoluteY(target),
            width: target.offsetWidth,
            height: target.offsetHeight,
            classNames: ASPx.GetClassNameList(target),

            getTarget: function() { return target; },
            getRect: function() { return {x: this.x, y: this.y, width: this.width, height: this.height }; }
        };
    },
    createEventInfo: function(evt) {
        return { x: this.getEventX(evt), y: this.getEventY(evt) };
    },
    processMouseDown: function(evt) {
        var evtSource = ASPx.Evt.GetEventSource(evt);
        var rippleTarget = this.getRippleTargetElement(evtSource);
        if(this.needToProcessRipple(rippleTarget, evtSource))
            this.processRipple(this.createTargetInfo(rippleTarget), this.createEventInfo(evt));
    },
    getRippleTargetElement: function(evtSource) {
        if(this.hasRippleMarker(evtSource))
            return evtSource;

        if(evtSource.tagName && evtSource.tagName.toLowerCase() == "input" && ASPx.ElementContainsCssClass(evtSource, "dxTI")) {
            var elements = ASPx.GetChildElementNodesByPredicate(evtSource.parentNode.parentNode, function(element) {
                return this.hasRippleMarker(element);
            }.aspxBind(this));
            return elements && elements[0];
        }

        return ASPx.GetParent(evtSource, function(element) {
            return this.hasRippleMarker(element);
        }.aspxBind(this));
    },
    hasRippleMarker: function(element) {
        if(!ASPx.IsExistsElement(element))
            return false;
        var computedStyles = window.getComputedStyle(element, ":before");
        if(ASPx.IsExists(computedStyles)) {
            var content = computedStyles.getPropertyValue("content");
            if(content.indexOf(this.rippleTargetExternalClassName) > -1) {
                ASPx.AddClassNameToElement(element, this.rippleTargetExternalClassName);
                return true;
            }
            return content.indexOf(this.rippleTargetClassName) > -1;
        }
        return false;
    },
    needToProcessRipple: function(rippleTarget, evtSource) {
        if(!rippleTarget || !ASPx.AnimationUtils)
            return false;
        var isClearButton = ASPx.ElementContainsCssClass(rippleTarget, "dxeButton") && rippleTarget.id && rippleTarget.id.indexOf("B-100") !== -1;
        var isEmptyCalendarDay = ASPx.ElementContainsCssClass(rippleTarget, "dxeCalendarDay") && ASPx.Str.Trim(rippleTarget.textContent) == "";
        var isReadonly = ASPx.ElementContainsCssClass(rippleTarget, READ_ONLY_COMBOBOX_MARKER_CSS_CLASS);
        var tempFixDisable = ASPx.ElementContainsCssClass(rippleTarget, "dxSwitcher") && ASPx.Browser.MacOSMobilePlatform;
        var rippleIsForbidden = isReadonly || isClearButton || isEmptyCalendarDay || ASPx.GetParentByPartialClassName(rippleTarget, "Disabled") ||
            ASPx.ElementContainsCssClass(rippleTarget, "dxgvBatchEditCell") || ASPx.ElementContainsCssClass(rippleTarget, "dxcvEditForm") ||
            ASPx.GetParentByPartialClassName(evtSource, "dxcvFocusedCell") || tempFixDisable;
        return !rippleIsForbidden;
    },
    hasBothOverflow: function(style) {
        return style.overflow == "scroll" || style.overflow == "auto" || style.overflow == "hidden";
    },
    hasOverflowX: function(style) {
        return style.overflowX == "scroll" || style.overflowX == "auto" || style.overflowX == "hidden";
    },
    hasOverflowY: function(style) {
        return style.overflowY == "scroll" || style.overflowY == "auto" || style.overflowY == "hidden";
    },
    getExternalRippleContainerSize: function(targetRect) {
        if(ASPx.Browser.MobileUI) {
            var origTouchRadius = this.getOriginTouchRadius();
            if(origTouchRadius < targetRect.width || origTouchRadius < targetRect.height)
                origTouchRadius = Math.max(targetRect.width, targetRect.height);
            return {x: targetRect.x + (targetRect.width - origTouchRadius) / 2, y: targetRect.y + (targetRect.height - origTouchRadius) / 2, width: origTouchRadius, height: origTouchRadius };
        }

        var result = { x: 0, y: 0, width: 0, height: 0 };
        var diff = targetRect.width - targetRect.height;
        if(diff > 0) {
            result.x = targetRect.x;
            result.y = targetRect.y - diff / 2;
            result.width = targetRect.width;
            result.height = targetRect.width;
        } else {
            result.x = targetRect.x + diff / 2;
            result.y = targetRect.y;
            result.width = targetRect.height;
            result.height = targetRect.height;
        }

        return result;
    },
    getInternalContainerSize: function(targetInfo) {
        var parentWithOverflow = RippleHelper.getParentWithOverflow(targetInfo.getTarget());
        if(!ASPx.IsExists(parentWithOverflow))
            return targetInfo;

        var parentWithOverflowStyle = ASPx.GetCurrentStyle(parentWithOverflow);
        var bothOverflow = this.hasBothOverflow(parentWithOverflowStyle);
        var overflowX = this.hasOverflowX(parentWithOverflowStyle);
        var overflowY = this.hasOverflowY(parentWithOverflowStyle);

        var parentRect = {
            x: ASPx.GetAbsoluteX(parentWithOverflow),
            y: ASPx.GetAbsoluteY(parentWithOverflow),
            width: parentWithOverflow.offsetWidth,
            height: parentWithOverflow.offsetHeight
        };

        return this.getInternalContainerSizeCore(targetInfo, parentRect, bothOverflow, overflowX, overflowY);
    },
    getInternalContainerSizeCore: function(targetRect, parentRect, bothOverflow, overflowX, overflowY) {
        var result = {};
        ASPx.Data.MergeHashTables(result, targetRect);

        if(bothOverflow || overflowX) {
            result.x = targetRect.x < parentRect.x ? parentRect.x : targetRect.x;

            if(targetRect.x + targetRect.width > parentRect.x + parentRect.width)
                result.width = parentRect.x + parentRect.width - targetRect.x;
            if(parentRect.x > targetRect.x)
                result.width -= (parentRect.x - targetRect.x);
        }
        if(bothOverflow || overflowY) {
            result.y = targetRect.y < parentRect.y ? parentRect.y : targetRect.y;

            if(targetRect.y + targetRect.height > parentRect.y + parentRect.height)
                result.height = parentRect.y + parentRect.height - targetRect.y;
            if(parentRect.y > targetRect.y)
                result.height -= (parentRect.y - targetRect.y);
        }
        return result;
    },
    calculateRippleContainerSize: function(targetInfo, isExternalRipple) {
        return isExternalRipple ? this.getExternalRippleContainerSize(targetInfo) : this.getInternalContainerSize(targetInfo);
    },
    getParentWithOverflow: function(rippleTarget) {
        var result = ASPx.GetParent(rippleTarget, function(element) {
            var elementStyle = ASPx.GetCurrentStyle(element);
            return this.hasBothOverflow(elementStyle) || this.hasOverflowX(elementStyle) || this.hasOverflowY(elementStyle);
        }.aspxBind(this));

        return result;
    },
    getDuration: function(targetInfo) {
        return this.IsExternalRipple(targetInfo) || ASPx.Browser.MobileUI ? 650 : 450;
    },
    createRippleTransition: function(container, rippleElement, radius, targetInfo) {
        var rippleSize = 2 * radius;
        var transitionEndIsAborted = true;
        var transitionProperties = {
            width: { from: 0, to: rippleSize, transition: ASPx.AnimationConstants.Transitions.RIPPLE, propName: "width", unit: "px" },
            height: { from: 0, to: rippleSize, transition: ASPx.AnimationConstants.Transitions.RIPPLE, propName: "height", unit: "px" },
            marginLeft: { from: 0, to: -rippleSize / 2, transition: ASPx.AnimationConstants.Transitions.RIPPLE, propName: "marginLeft", unit: "px" },
            marginTop: { from: 0, to: -rippleSize / 2, transition: ASPx.AnimationConstants.Transitions.RIPPLE, propName: "marginTop", unit: "px" },
            opacity: { from: 1, to: 0.05, transition: ASPx.AnimationConstants.Transitions.RIPPLE, propName: "opacity", unit: "%" }
        };
        var rippleTransition = ASPx.AnimationUtils.createMultipleAnimationTransition(rippleElement, {
            transition: ASPx.AnimationConstants.Transitions.RIPPLE,
            duration: this.getDuration(targetInfo),
            onComplete: function() {
                this.RemoveRippleContainer(container.parentElement);
                transitionEndIsAborted = false;
            }.bind(this)
        });
        rippleTransition.Start(transitionProperties);
        window.setTimeout(function() {
            if(transitionEndIsAborted)
                this.RemoveRippleContainer(container.parentElement);
        }.bind(this), 500);
    },
    calculateRadius: function(isExternalRipple, posX, posY, containerRect) {
        var radius = -1;
        if(isExternalRipple) {
            if(ASPx.Browser.MobileUI)
                radius = this.getOriginTouchRadius() / 2;
            else
                radius = Math.max(containerRect.height, containerRect.width);
        } else {
            var width1 = posX - containerRect.x;
            var width2 = containerRect.width - width1;

            var height1 = posY - containerRect.y;
            var height2 = containerRect.height - height1;

            var rippleWidth = Math.max(width1, width2);
            var rippleHeight = Math.max(height1, height2);

            radius = Math.sqrt(Math.pow(rippleHeight, 2) + Math.pow(rippleWidth, 2));
        }
        return radius;
    },
    createRippleElement: function(container, rippleCenter) {
        var rippleElement = document.createElement("DIV");
        rippleElement.className = this.rippleClassName;

        container.appendChild(rippleElement);

        ASPxClientUtils.SetAbsoluteX(rippleElement, rippleCenter.x);
        ASPxClientUtils.SetAbsoluteY(rippleElement, rippleCenter.y);

        return rippleElement;
    },
    processRipple: function(targetInfo, eventInfo) {
        this.initRippleProcess();

        var isExternalRipple = this.IsExternalRipple(targetInfo);

        var rippleCenter = this.getRippleCenter(targetInfo.getRect(), eventInfo, isExternalRipple);
        var container = this.createRippleContainer(targetInfo, isExternalRipple);
        var rippleElement = this.createRippleElement(container, rippleCenter);
   
        var radius = this.calculateRadius(isExternalRipple, rippleCenter.x, rippleCenter.y, this.getElementRect(container));
        this.createRippleTransition(container, rippleElement, radius, targetInfo);
    },
    initRippleProcess: function() {
        this.isMobileExternalRipple = null;
        this.zoom = screen.width / window.innerWidth;
    },
    getRippleCenter: function(targetInfo, eventInfo, isExternalRipple) {
        var posX = 0;
        var posY = 0;
        if(isExternalRipple) {
            posX = targetInfo.x + targetInfo.width / 2;
            posY = targetInfo.y + targetInfo.height / 2;
        } else {
            posX = eventInfo.x;
            posY = eventInfo.y;
        }
        return {x: posX, y: posY};
    },
    createRippleContainer: function(targetInfo, isExternalRipple) {
        var containerParent = targetInfo.getTarget();
        if(!containerParent)
            return;
        var containerTagName = containerParent.tagName == "TR" ? "TD" : "DIV";
        var container = document.createElement(containerTagName);
        container.className = this.rippleContainerClassName;

        if(containerParent.parentNode && containerParent.tagName == "IMG")
            containerParent = containerParent.parentNode;
        if(this.isARowInFixedLayoutTable(containerParent))
            this.lockFixedLayoutTableSizes(containerParent);
        containerParent.appendChild(container);
        if(isExternalRipple)
            container.style.borderRadius = "50%";

        var containerRect = this.calculateRippleContainerSize(targetInfo, isExternalRipple);
        this.assignContainerSettings(container, containerRect);

        return container;
    },
    isARowInFixedLayoutTable: function(containerParent) {
        if(containerParent.tagName !== "TR")
            return false;
        var parentTable = this.getParentTable(containerParent);
        return parentTable && ASPx.GetCurrentStyle(parentTable)["table-layout"] === "fixed";
    },
    processFirstRowOfFixedTable: function(containerRow, rowAction, cellAction) {
        var firstRow = this.getFirstRow(containerRow);
        rowAction(firstRow);
        var cells = ASPx.Data.CollectionToArray(firstRow.cells);
        cells.forEach(cellAction);
    },
    getParentTable: function(element) {
        var parentTable = element;
        while(parentTable && parentTable.tagName !== "TABLE")
            parentTable = parentTable.parentElement;
        return parentTable;
    },
    lockFixedLayoutTableSizes: function(containerRow) {
        var firstRow = this.getFirstRow(containerRow);
        if(this.incLockCount(firstRow) === 1) {
            var cells = ASPx.Data.CollectionToArray(firstRow.cells);
            var widths = cells.map(function(cell) { return cell.style.width; });
            var computedWidths = cells.map(function(cell) {
                if(ASPx.Browser.IE && ASPx.ElementHasCssClass(cell, "dxeCM"))
                    return cell.offsetWidth + "px";
                return window.getComputedStyle(cell).width;
            });
            var fixWidth = function(cell, i) {
                if(ASPx.Attr.IsExistsAttribute(cell, SAVED_WIDTH_ATTR))
                    return;
                if(widths[i])
                    ASPx.Attr.SetAttribute(cell, SAVED_WIDTH_ATTR, widths[i]);
                cell.style.width = computedWidths[i];
            };
            cells.forEach(fixWidth);
        }
    }, 
    unlockFixedLayoutTableSizes: function(containerRow) {
        var firstRow = this.getFirstRow(containerRow);            
        if(this.decLockCount(firstRow) === 0) {
            var cells = ASPx.Data.CollectionToArray(firstRow.cells);
            var restoreState = function(cell) {
                if(ASPx.Attr.IsExistsAttribute(cell, SAVED_WIDTH_ATTR)) {
                    cell.style.width = ASPx.Attr.GetAttribute(cell, SAVED_WIDTH_ATTR);
                    ASPx.Attr.RemoveAttribute(cell, SAVED_WIDTH_ATTR);
                } else {
                    cell.style.width = null;
                }
            };
            cells.forEach(restoreState);
        }
    },
    getFirstRow: function(containerRow) { return ASPx.GetChildByTagName(containerRow.parentElement, "TR", 0); },
    incLockCount: function(elem) { return this.changeLockCount(elem, 1); },
    decLockCount: function(elem) { return this.changeLockCount(elem, -1); },
    changeLockCount: function(elem, diff) {
        var lockCounter = this.getLockCount(elem);
        lockCounter += diff;
        lockCounter = Math.max(0, lockCounter);
        if(lockCounter === 0)
            ASPx.Attr.RemoveAttribute(elem, RIPPLE_FIXED_ROW_ATTR);
        else
            ASPx.Attr.SetAttribute(elem, RIPPLE_FIXED_ROW_ATTR, lockCounter);
        return lockCounter;
    },
    getLockCount: function(lockElement) {
        var attrValue = ASPx.Attr.GetAttribute(lockElement, RIPPLE_FIXED_ROW_ATTR);
        return parseInt(attrValue) || 0;
    },
    assignContainerSettings: function(container, containerRect) {
        var properties = {
            height: containerRect.height,
            width: containerRect.width,
            left: ASPx.PrepareClientPosForElement(containerRect.x, container, true),
            top: ASPx.PrepareClientPosForElement(containerRect.y, container, false)
        };

        if(ASPx.Browser.MobileUI)
            ASPx.Data.MergeHashTables(properties, {marginTop: 0, marginLeft: 0 });
        
        ASPx.SetStyles(container, properties, ASPx.Browser.MobileUI);
    },
    IsExternalRipple: function(targetInfo) {
        var hasExternalRippleClassName = ASPx.ElementContainsCssClass(targetInfo.getTarget(), this.rippleTargetExternalClassName);
        if(!ASPx.Browser.MobileUI)
            return hasExternalRippleClassName;
        return hasExternalRippleClassName || this.IsMobileExternalRipple(targetInfo);
    },
    IsMobileExternalRipple: function(targetInfo) {
        if(this.isMobileExternalRipple == null) {
            var originTouchRadius = this.getOriginTouchRadius();
            this.isMobileExternalRipple = ASPx.Browser.MobileUI && targetInfo.width < originTouchRadius && targetInfo.height < originTouchRadius;
        }
        return this.isMobileExternalRipple;
    },
    RemoveRippleContainer: function(element) {
        if(!element)
            return;
        var childs = ASPx.GetChildNodesByClassName(element, this.rippleContainerClassName);
        var rippleContainer = childs.length > 0 ? childs[0] : null;
        if(rippleContainer != null) {
            var containerParent = rippleContainer.parentNode;
            containerParent.removeChild(rippleContainer);
            if(this.isARowInFixedLayoutTable(containerParent))
                this.unlockFixedLayoutTableSizes(containerParent);
        }
    },

    getEventX: function(evt) {
        return ASPxClientUtils.GetEventX(evt);
    },
    getEventY: function(evt) {
        return ASPxClientUtils.GetEventY(evt);
    },
    getOriginTouchRadius: function() {
        return this.touchRadius / this.zoom;
    },
    getElementRect: function(element) {
        return { x: ASPx.GetAbsoluteX(element), y: ASPx.GetAbsoluteY(element), width: element.offsetWidth, height: element.offsetHeight };
    }
};
var AccessibilitySR = {
    AddStringResources: function(stringResourcesObj) {
        if(stringResourcesObj) {
            for(var key in stringResourcesObj)
                if(stringResourcesObj.hasOwnProperty(key))
                    this[key] = stringResourcesObj[key];
        }
    }
};

ASPx.CollectionBase = CollectionBase;
ASPx.FunctionIsInCallstack = _aspxFunctionIsInCallstack;
ASPx.RaisePostHandlerOnPost = aspxRaisePostHandlerOnPost;
ASPx.GetPostHandler = aspxGetPostHandler;
ASPx.ProcessScriptsAndLinks = _aspxProcessScriptsAndLinks;
ASPx.InitializeLinks = _aspxInitializeLinks;
ASPx.InitializeScripts = _aspxInitializeScripts;
ASPx.RunStartupScripts = _aspxRunStartupScripts;
ASPx.IsStartupScriptsRunning = _aspxIsStartupScriptsRunning;
ASPx.AddScriptsRestartHandler = _aspxAddScriptsRestartHandler;
ASPx.GetFocusedElement = _aspxGetFocusedElement;
ASPx.GetDomObserver = _aspxGetDomObserver;
ASPx.CacheHelper = CacheHelper;
ASPx.ControlTree = ControlTree;
ASPx.ControlAdjuster = ControlAdjuster;
ASPx.GetControlAdjuster = GetControlAdjuster;
ASPx.ControlCallbackHandlersQueue = ControlCallbackHandlersQueue;

ASPx.ResourceManager = ResourceManager;
ASPx.UpdateWatcherHelper = UpdateWatcherHelper;
ASPx.EventStorage = EventStorage;
ASPx.GetGlobalObject = GetGlobalObject;
ASPx.GetExternalScriptProcessor = GetExternalScriptProcessor;

ASPx.CheckBoxCheckState = CheckBoxCheckState;
ASPx.CheckBoxInputKey = CheckBoxInputKey;
ASPx.CheckableElementStateController = CheckableElementStateController;
ASPx.CheckableElementHelper = CheckableElementHelper;
ASPx.CheckBoxInternal = CheckBoxInternal;
ASPx.CheckBoxInternalCollection = CheckBoxInternalCollection;
ASPx.ControlCallbackQueueHelper = ControlCallbackQueueHelper;
ASPx.FocusedStyleDecoration = FocusedStyleDecoration;
ASPx.EditorStyleDecoration = EditorStyleDecoration;
ASPx.TextEditorStyleDecoration = TextEditorStyleDecoration;
ASPx.AccessibilitySR = AccessibilitySR;
ASPx.KbdHelper = KbdHelper;
ASPx.AccessKeysHelper = AccessKeysHelper;
ASPx.AccessKey = AccessKey;
ASPx.IFrameHelper = IFrameHelper;
ASPx.Ident = Ident;
ASPx.TouchUIHelper = TouchUIHelper;
ASPx.ControlUpdateWatcher = ControlUpdateWatcher;
ASPx.ControlTabIndexManager = ControlTabIndexManager;
ASPx.AccessibilityHelperBase = AccessibilityHelperBase;
ASPx.RippleHelper = RippleHelper;
ASPx.ThemesWithRipple = ThemesWithRipple;
window.ASPxClientEvent = ASPxClientEvent;
window.ASPxClientEventArgs = ASPxClientEventArgs;
window.ASPxClientCancelEventArgs = ASPxClientCancelEventArgs;
window.ASPxClientProcessingModeEventArgs = ASPxClientProcessingModeEventArgs;
window.ASPxClientProcessingModeCancelEventArgs = ASPxClientProcessingModeCancelEventArgs;

ASPx.Evt.AttachEventToDocument(TouchUIHelper.touchMouseDownEventName, RippleHelper.onDocumentMouseDown);
ASPx.classesScriptParsed = true;
/* Don't write any code below this line!!! */
})(ASPx, { GCCheckInterval: 5000 });

/// <reference path="Utils.js"/>
/*# namespace DevExpress.Web.Scripts #*/

(function module(ASPx) {
ASPx.modules.Controls = module;
/*# public delegate void ASPxClientBeginCallbackEventHandler(object source, ASPxClientBeginCallbackEventArgs e);#*/
/*# public class ASPxClientBeginCallbackEventArgs : ASPxClientEventArgs #*/
var ASPxClientBeginCallbackEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
    /*# public ASPxClientBeginCallbackEventArgs(string command) : base(){} #*/
    constructor: function(command){
        this.constructor.prototype.constructor.call(this);
        /*# public string command{ get{return string.Empty;} } #*/
        this.command = command;
    }
});
/*# public delegate void ASPxClientGlobalBeginCallbackEventHandler(object source, ASPxClientGlobalBeginCallbackEventArgs e);#*/
/*# public class ASPxClientGlobalBeginCallbackEventArgs : ASPxClientBeginCallbackEventArgs #*/
var ASPxClientGlobalBeginCallbackEventArgs = ASPx.CreateClass(ASPxClientBeginCallbackEventArgs, {
    /*# public ASPxClientGlobalBeginCallbackEventArgs(ASPxClientControl control, string command) : base(command){} #*/
    constructor: function(control, command){
        this.constructor.prototype.constructor.call(this, command);
        /*# public ASPxClientControl control{ get{return null;} } #*/
        this.control = control;
    }
});
/*# public delegate void ASPxClientEndCallbackEventHandler(object source, ASPxClientEndCallbackEventArgs e);#*/
/*# public class ASPxClientEndCallbackEventArgs : ASPxClientEventArgs #*/
var ASPxClientEndCallbackEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
    /*# public ASPxClientEndCallbackEventArgs(string command) : base(){} #*/
    constructor: function(command){
        this.constructor.prototype.constructor.call(this);
        /*# public string command{ get{return string.Empty;} } #*/
        this.command = command;
    }
});
/*# public delegate void ASPxClientGlobalEndCallbackEventHandler(object source, ASPxClientGlobalEndCallbackEventArgs e);#*/
/*# public class ASPxClientGlobalEndCallbackEventArgs : ASPxClientEndCallbackEventArgs #*/
var ASPxClientGlobalEndCallbackEventArgs = ASPx.CreateClass(ASPxClientEndCallbackEventArgs, {
    /*# public ASPxClientGlobalEndCallbackEventArgs(ASPxClientControl control) : base(){} #*/
    constructor: function(control){
        this.constructor.prototype.constructor.call(this);
        /*# public ASPxClientControl control{ get{return null;} } #*/
        this.control = control;
    }
});
/*# public delegate void ASPxClientCustomDataCallbackEventHandler(object source, ASPxClientCustomDataCallbackEventArgs e);#*/
/*# public class ASPxClientCustomDataCallbackEventArgs : ASPxClientEventArgs #*/
var ASPxClientCustomDataCallbackEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
    /*# public ASPxClientCustomDataCallbackEventArgs(string result) : base() { } #*/
    constructor: function(result) {
        this.constructor.prototype.constructor.call(this);
        /*# public string result { get { return string.Empty; } set { } } #*/
        this.result = result;
    }
});
/*# public delegate void ASPxClientCallbackErrorEventHandler(object source, ASPxClientCallbackErrorEventArgs e);#*/
/*# public class ASPxClientCallbackErrorEventArgs : ASPxClientEventArgs #*/
var ASPxClientCallbackErrorEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
    /*# public ASPxClientCallbackErrorEventArgs(string message) : base(){} #*/
    constructor: function (message, callbackId) {
        this.constructor.prototype.constructor.call(this);
        /*# public string message{ get{return string.Empty;} set{} } #*/
        this.message = message;
        /*# public bool handled{ get{return false;} set{} } #*/
        this.handled = false;
        this.callbackId = callbackId;
    }
});
/*# public delegate void ASPxClientGlobalCallbackErrorEventHandler(object source, ASPxClientGlobalCallbackErrorEventArgs e);#*/
/*# public class ASPxClientGlobalCallbackErrorEventArgs : ASPxClientCallbackErrorEventArgs #*/
var ASPxClientGlobalCallbackErrorEventArgs = ASPx.CreateClass(ASPxClientCallbackErrorEventArgs, {
    /*# public ASPxClientGlobalCallbackErrorEventArgs(ASPxClientControl control, string message) : base(message){} #*/
    constructor: function (control, message, callbackId) {
        this.constructor.prototype.constructor.call(this, message, callbackId);
        /*# public ASPxClientControl control{ get{return null;} } #*/
        this.control = control;
    }
});

/*# public delegate void ASPxClientValidationCompletedEventHandler(object source, ASPxClientValidationCompletedEventArgs e); #*/
/*# public class ASPxClientValidationCompletedEventArgs : ASPxClientEventArgs #*/
var ASPxClientValidationCompletedEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
    /*# public ASPxClientValidationCompletedEventArgs(object container, string validationGroup, bool invisibleControlsValidated, bool isValid, ASPxClientControl firstInvalidControl, ASPxClientControl firstVisibleInvalidControl) : base() { } #*/
    constructor: function (container, validationGroup, invisibleControlsValidated, isValid, firstInvalidControl, firstVisibleInvalidControl) {
        this.constructor.prototype.constructor.call(this);

        /*# public object container { get { return null; } } #*/
        this.container = container;
        /*# public string validationGroup { get { return null; } } #*/
        this.validationGroup = validationGroup;
        /*# public bool invisibleControlsValidated { get { return true; } } #*/
        this.invisibleControlsValidated = invisibleControlsValidated;
        /*# public bool isValid { get { return true; } set { } } #*/
        this.isValid = isValid;
        /*# public ASPxClientControl firstInvalidControl { get { return null; } } #*/
        this.firstInvalidControl = firstInvalidControl;
        /*# public ASPxClientControl firstVisibleInvalidControl { get { return null; } } #*/
        this.firstVisibleInvalidControl = firstVisibleInvalidControl;
    }
});

/*# public delegate void ASPxClientControlsInitializedEventHandler(object source, ASPxClientControlsInitializedEventArgs e); #*/
/*# public class ASPxClientControlsInitializedEventArgs : ASPxClientEventArgs  #*/
var ASPxClientControlsInitializedEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
    /*# public ASPxClientControlsInitializedEventArgs(bool isCallback) : base() { } #*/
    constructor: function(isCallback) {
        /*# public bool isCallback { get { return false; } } #*/
        this.isCallback = isCallback;
    }
});

var ASPxClientControlBeforePronounceEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
    constructor: function(messageParts, control){
        this.constructor.prototype.constructor.call(this);
        this.messageParts = messageParts;
        this.control = control;
    }
});

var ASPxClientControlUnloadEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
    constructor: function(control){
        this.constructor.prototype.constructor.call(this);
        this.control = control;
    }
});

var ASPxClientEndFocusEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
    constructor: function(item) {
        this.constructor.prototype.constructor.call(this);
        this.item = item;
    }
});
var ASPxClientItemFocusedEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
    constructor: function(item) {
        this.constructor.prototype.constructor.call(this);
        this.item = item;
    }
});

var BeforeInitCallbackEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
    constructor: function(callbackOwnerID){
        this.constructor.prototype.constructor.call(this);
        this.callbackOwnerID = callbackOwnerID;
    }
});
var ASPxClientBrowserWindowResizedInternalEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
    constructor: function(eventInfo) {
        this.constructor.prototype.constructor.call(this);

        this.htmlEvent = eventInfo.htmlEvent;
        this.windowClientWidth = eventInfo.wndWidth;
        this.windowClientHeigth = eventInfo.wndHeight;
        this.previousWindowClientWidth = eventInfo.prevWndWidth;
        this.previousWindowClientHeight = eventInfo.prevWndHeight;
        this.virtualKeyboardShownOnAndroid = eventInfo.virtualKeyboardShownOnAndroid;
    }
});

ASPx.createControl = function(type, name, windowName, properties, events, setupMethod, data){
    var globalName = windowName && windowName.length > 0 ? windowName : name;
    var dxo = new type(name);
    var haveWrapper = ASPx.Platform === "NETCORE" && dxo.createWrapper && !DevExpress.AspNetCore.Internal.BackwardCompatibility.useLegacyClientAPI;
    if(haveWrapper) {
        window[globalName] = dxo.createWrapper();
        dxo.aspNetCoreWrapperInstance = window[globalName];
    }
    else
        dxo.InitGlobalVariable(globalName);
    if(properties)
        dxo.SetProperties(properties);
    if(events)
        dxo.SetEvents(events);
    if(setupMethod)
        setupMethod.call(dxo);
    if(data)
        dxo.SetData(data);
    dxo.AfterCreate();
};

/*# public class ASPxClientControlBase: JavaScriptObject #*/
var ASPxClientControlBase = ASPx.CreateClass(null, {
    constructor: function(name){
        /*# public string name{ get{ return ""; } } #*/    
        this.name = name;
        this.uniqueID = name;   
        this.globalName = name;
        this.stateObject = null;
        this.needEncodeState = true;

        this.encodeHtml = true;
        this.enabled = true;
        this.clientEnabled = true;
        this.savedClientEnabled = true;
        this.clientVisible = true;
        this.accessibilityCompliant = false;
        this.parseJSPropertiesOnCallbackError = false;

        this.autoPostBack = false;
        this.allowMultipleCallbacks = true;
        this.callBack = null;
        this.enableCallbackAnimation = false;
        this.enableSlideCallbackAnimation = false;
        this.slideAnimationDirection = null;
        this.beginCallbackAnimationProcessing = false;
        this.endCallbackAnimationProcessing = false;
        this.savedCallbackResult = null;
        this.savedCallbacks = null;
        this.isCallbackAnimationPrevented = false;
        this.lpDelay = 300;
        this.lpTimer = -1;
        this.requestCount = 0;
        this.enableSwipeGestures = false;
        this.disableSwipeGestures = false;
        this.supportGestures = false;
        this.repeatedGestureValue = 0;
        this.repeatedGestureCount = 0;

        this.isInitialized = false;
        this.initialFocused = false;
        this.leadingAfterInitCall = ASPxClientControl.LeadingAfterInitCallConsts.None; // AfterInitialize call will be displaced to the beginning of call queue
        this.serverEvents = [];
        
        this.loadingPanelElement = null;
        this.loadingDivElement = null;        
        this.hasPhantomLoadingElements = false;
        this.mainElement = null;
        this.touchUIMouseScroller = null;
        this.hiddenFields = {};

        this.scPrefix = "dx";

        this.callbackHandlersQueue = new ASPx.ControlCallbackHandlersQueue(this);
        this.callbackCommand = {};
        this.currentCallbackID = -1;

        this.InitializeIntersectionObserversManager();

        /*# public event ASPxClientEventHandler Init{ add{} remove{}}#*/
        this.Init = new ASPxClientEvent();
        this.BeginCallback = new ASPxClientEvent();
        this.EndCallback = new ASPxClientEvent();
        this.EndCallbackAnimationStart = new ASPxClientEvent();
        this.CallbackError = new ASPxClientEvent();
        this.CustomDataCallback = new ASPxClientEvent();
        this.BeforePronounce = new ASPxClientEvent();
        this.Unload = new ASPxClientEvent();
        this.Disposed = new ASPxClientEvent(); 
        aspxGetControlCollection().Add(this);
    },

    Initialize: function() {
        if(this.callBack != null)
            this.InitializeCallBackData();
        if (this.useCallbackQueue())
            this.callbackQueueHelper = new ASPx.ControlCallbackQueueHelper(this);
        ASPx.AccessibilityUtils.createAccessibleBackgrounds(this);
        if(this.accessibilityCompliant)
            ASPx.AccessibilityPronouncer.EnsureInitialize();
    },
    FinalizeInitialization: function() { },
    InlineInitialize: function() {
        this.savedClientEnabled = this.clientEnabled;
    },
    InitializeGestures: function() {
        if(this.isSwipeGesturesEnabled() && this.supportGestures) {
            ASPx.GesturesHelper.AddSwipeGestureHandler(this.name, 
                function() { return this.GetCallbackAnimationElement(); }.aspxBind(this), 
                function(evt) { return this.CanHandleGestureCore(evt); }.aspxBind(this), 
                function(value) { return this.AllowStartGesture(value); }.aspxBind(this),
                function(value) { return this.StartGesture(); }.aspxBind(this),
                function(value) { return this.AllowExecuteGesture(value); }.aspxBind(this),
                function(value) { this.ExecuteGesture(value); }.aspxBind(this),
                function(value) { this.CancelGesture(value); }.aspxBind(this),
                this.GetDefaultanimationEngineType(),
                this.rtl
            );
            if(ASPx.Browser.MSTouchUI)
                this.touchUIMouseScroller = ASPx.MouseScroller.Create(
                    function() { return this.GetCallbackAnimationElement(); }.aspxBind(this),
                    function() { return null; },
                    function() { return this.GetCallbackAnimationElement(); }.aspxBind(this),
                    function(element) { return this.NeedPreventTouchUIMouseScrolling(element); }.aspxBind(this),
                    true
                );
        }
    },
    isSwipeGesturesEnabled: function() {
        return !this.disableSwipeGestures && (this.enableSwipeGestures || ASPx.Browser.TouchUI);
    },
    isSlideCallbackAnimationEnabled: function() {
        return this.enableSlideCallbackAnimation || this.isSwipeGesturesEnabled();    
    },
    InitGlobalVariable: function(varName){
        if(!window) return;
        
        this.globalName = varName;
        window[varName] = this;
    },
    SetElementDisplay: function(element, value, checkCurrentStyle, makeInline) {
        ASPx.SetElementDisplay(element, value, checkCurrentStyle, makeInline);
    },
    SetProperties: function(properties, obj){
        if(!obj) obj = this;
        var isAspNetCoreWrapperInstanceExist = !!obj.aspNetCoreWrapperInstance;
        for(var name in properties){
            if(!properties.hasOwnProperty(name)) continue;
            
            obj[name] = properties[name];
            if(isAspNetCoreWrapperInstanceExist && name.indexOf("cp") === 0)
                obj.aspNetCoreWrapperInstance[name] = properties[name]; 
        }
    },
    SetEvents: function(events, obj){
        if(!obj) obj = this;
        for(var name in events){
            if(events.hasOwnProperty(name) && obj[name] && obj[name].AddHandler)
                obj[name].AddHandler(events[name]);
        }
    },
    SetData: function(data){
    },

    useCallbackQueue: function(){
        return false;
    },
    NeedPreventTouchUIMouseScrolling: function(element) {
        return false;
    },
    InitailizeFocus: function() {
        if(this.initialFocused && this.IsVisible())
            this.Focus();
    },
    AfterCreate: function() {
        this.AddDefaultStateControllerItems();
        this.InlineInitialize();
        this.InitializeGestures();
    },
    AfterInitialize: function() {
        this.initializeAriaDescriptor();
        this.InitailizeFocus();
        this.isInitialized = true;
        this.RaiseInit();
            
        if(this.savedCallbacks) {
            for(var i = 0; i < this.savedCallbacks.length; i++) 
                this.CreateCallbackInternal(this.savedCallbacks[i].arg, this.savedCallbacks[i].command, 
                    false, this.savedCallbacks[i].callbackInfo);
            this.savedCallbacks = null;
        }
    },
    InitializeCallBackData: function() {
    },
    AtlasPreInitialize: function() {
    },
    AtlasInitialize: function() {
    },
    IsDOMDisposed: function() { 
        return !ASPx.IsExistsElement(this.GetMainElement());
    },
    initializeAriaDescriptor: function() {
        if(this.ariaDescription) {
            var descriptionObject = ASPx.Json.Eval(this.ariaDescription);
            if(descriptionObject) {
                this.ariaDescriptor = new AriaDescriptor(this, descriptionObject);
                this.applyAccessibilityAttributes(this.ariaDescriptor);    
            }
        }
    },
    applyAccessibilityAttributes: function() { },
    setAriaDescription: function(selector, argsList) {
        if(this.ariaDescriptor)
            this.ariaDescriptor.setDescription(selector, argsList || [[]]);
    },
    allowRestoreFocusOnCallbacks: function(){
        return this.accessibilityCompliant;
    },

    HtmlEncode: function(text) {
        return this.encodeHtml ? ASPx.Str.EncodeHtml(text) : text;
    },
    IsServerEventAssigned: function(eventName){
        return ASPx.Data.ArrayIndexOf(this.serverEvents, eventName) >= 0;
    },

    OnPost: function(args){
        this.SerializeStateHiddenField();
    },
    SerializeStateHiddenField: function() {
        this.UpdateStateObject();
        if(this.stateObject != null)
            this.UpdateStateHiddenField();
    },
    OnPostFinalization: function(args){
    },
    UpdateStateObject: function(){
    },
    UpdateStateObjectWithObject: function(obj){
        if(!obj) return;

        if(!this.stateObject)
            this.stateObject = { };
        for(var key in obj)
            if(obj.hasOwnProperty(key))
                this.stateObject[key] = obj[key];
    },
    UpdateStateHiddenField: function() {
        var stateHiddenField = this.GetStateHiddenField();
        if(stateHiddenField) {
            var stateObjectStr = ASPx.Json.ToJson(this.stateObject, !this.needEncodeState);
            stateHiddenField.value = this.needEncodeState ? ASPx.Str.EncodeHtml(stateObjectStr) : stateObjectStr;
        }
    },
    GetStateHiddenField: function() {
        return this.GetHiddenField(this.GetStateHiddenFieldName(), this.GetStateHiddenFieldID(), 
            this.GetStateHiddenFieldParent(), this.GetStateHiddenFieldOrigin());
    },
    GetStateHiddenFieldName: function() {
        return this.uniqueID;
    },
    GetStateHiddenFieldID: function() {
        return this.name + "_State";
    },
    GetStateHiddenFieldOrigin: function() {
        return this.GetMainElement();
    },
    GetStateHiddenFieldParent: function() {
        var element = this.GetStateHiddenFieldOrigin();
        return element ? element.parentNode : null;
    },
    GetHiddenField: function(name, id, parent, beforeElement) {
        var hiddenField = this.hiddenFields[id];
        if(!hiddenField || !ASPx.IsValidElement(hiddenField)) {
            if(parent) {
                var existingHiddenField = ASPx.GetElementById(this.GetStateHiddenFieldID());
                this.hiddenFields[id] = hiddenField = existingHiddenField || ASPx.CreateHiddenField(name, id);
                if(existingHiddenField)
                    return existingHiddenField;

                if(beforeElement)
                    parent.insertBefore(hiddenField, beforeElement);
                else
                    parent.appendChild(hiddenField);
            }
        }
        return hiddenField;
    },

    GetChildElement: function(idPostfix){
        var mainElement = this.GetMainElement();
        if(idPostfix.charAt && idPostfix.charAt(0) !== "_")
            idPostfix = "_" + idPostfix;
        return mainElement ? ASPx.CacheHelper.GetCachedChildById(this, mainElement, this.name + idPostfix) : null;
    },
    getChildControl: function(idPostfix) {
        var result = null;
        var childControlId = this.getChildControlUniqueID(idPostfix);
        ASPx.GetControlCollection().ProcessControlsInContainer(this.GetMainElement(), function(control) {
            if(control.uniqueID == childControlId)
                result = control;
        });
        return result;        
    },
    getChildControlUniqueID: function(idPostfix) {
        idPostfix = idPostfix.split("_").join("$");
        if(idPostfix.charAt && idPostfix.charAt(0) !== "$")
            idPostfix = "$" + idPostfix;
        return this.uniqueID + idPostfix;        
    },
    getInnerControl: function(idPostfix) {
        var name = this.name + idPostfix;
        var result = window[name];
        return result && Ident.IsASPxClientControl(result)
            ? result
            : null;
    },
    GetParentForm: function(){
        return ASPx.GetParentByTagName(this.GetMainElement(), "FORM");
    },
    /*# public object GetMainElement() { return null; } #*/
    GetMainElement: function(){
        if(!ASPx.IsExistsElement(this.mainElement))
            this.mainElement = ASPx.GetElementById(this.GetMainElementId());
        return this.mainElement;
    },
    GetMainElementId: function() {
        return this.name;
    },

    // Callback
    IsLoadingContainerVisible: function(){
        return this.IsVisible();
    },
    GetLoadingPanelElement: function(){
        return ASPx.GetElementById(this.name + "_LP");
    },
    GetClonedLoadingPanel: function(){
        return document.getElementById(this.GetLoadingPanelElement().id + "V");    
    },
    CloneLoadingPanel: function(element, parent) {
        var clone = element.cloneNode(true);
        clone.id = element.id + "V";
        parent.appendChild(clone);
        return clone;
    },
    CreateLoadingPanelWithoutBordersInsideContainer: function(container) {
        var loadingPanel = this.CreateLoadingPanelInsideContainer(container, false, true, true);
        var contentStyle = ASPx.GetCurrentStyle(container);
        if(!loadingPanel || !contentStyle)
            return;
        var elements = [ ];
        var table = (loadingPanel.tagName == "TABLE") ? loadingPanel : ASPx.GetNodeByTagName(loadingPanel, "TABLE", 0);
        if(table != null)
            elements.push(table);
        else
            elements.push(loadingPanel);
        var cells = ASPx.GetNodesByTagName(loadingPanel, "TD");
        if(!cells) cells = [ ];
        for(var i = 0; i < cells.length; i++)
            elements.push(cells[i]);

        for(var i = 0; i < elements.length; i++) {
            var el = elements[i];
            el.style.backgroundColor = contentStyle.backgroundColor;
            ASPx.RemoveBordersAndShadows(el);
        }
    },
    CreateLoadingPanelInsideContainer: function(parentElement, hideContent, collapseHeight, collapseWidth) {
        if(this.ShouldHideExistingLoadingElements())
            this.HideLoadingPanel();
        if(parentElement == null)
            return null;
        if(!this.IsLoadingContainerVisible()) {
            this.hasPhantomLoadingElements = true;
            return null;
        }

        var element = this.GetLoadingPanelElement();
        if(element != null){
            var width = collapseWidth ? 0 : ASPx.GetClearClientWidth(parentElement);
            var height = collapseHeight ? 0 : ASPx.GetClearClientHeight(parentElement);
            if(hideContent){
                for(var i = parentElement.childNodes.length - 1; i > -1; i--){
                    if(parentElement.childNodes[i].style)
                        parentElement.childNodes[i].style.display = "none";
                    else if(parentElement.childNodes[i].nodeType == 3) // Q353968
                        parentElement.removeChild(parentElement.childNodes[i]);
                }
            }
            else
                parentElement.innerHTML = "";
            
            var table = document.createElement("TABLE");
            parentElement.appendChild(table);
            table.border = 0;
            table.cellPadding = 0;
            table.cellSpacing = 0;
            ASPx.SetStyles(table, {
                width: (width > 0) ? width : "100%",
                height: (height > 0) ? height : "100%"
            });
            var tbody = document.createElement("TBODY");
            table.appendChild(tbody);
            var tr = document.createElement("TR");
            tbody.appendChild(tr);
            var td = document.createElement("TD");
            tr.appendChild(td);
            td.align = "center";
            td.vAlign = "middle";
            
            element = this.CloneLoadingPanel(element, td);
            ASPx.SetElementDisplay(element, true);
            this.loadingPanelElement = element;
            return element;
        } else
            parentElement.innerHTML = "&nbsp;";
        return null;
    },
    CreateLoadingPanelWithAbsolutePosition: function(parentElement, offsetElement) {
        if(this.ShouldHideExistingLoadingElements())
            this.HideLoadingPanel();
        if(parentElement == null)
            return null;
        if(!this.IsLoadingContainerVisible()) {
            this.hasPhantomLoadingElements = true;
            return null;
        }
        
        if(!offsetElement)
            offsetElement = parentElement;
        var element = this.GetLoadingPanelElement();
        if(element != null) {
            element = this.CloneLoadingPanel(element, parentElement);
            ASPx.SetStyles(element, {
                position: "absolute"
            });
            ASPx.SetElementDisplay(element, true);
            ASPx.Evt.AttachEventToElement(element, ASPx.Evt.GetMouseWheelEventName(), ASPx.Evt.PreventEvent);
            this.SetLoadingPanelLocation(offsetElement, element);
            this.loadingPanelElement = element;
            return element;
        }
        return null;
    },
    CreateLoadingPanelInline: function(parentElement, centerInParent){
        if(this.ShouldHideExistingLoadingElements())
            this.HideLoadingPanel();
        if(parentElement == null)
            return null;
        if(!this.IsLoadingContainerVisible()) {
            this.hasPhantomLoadingElements = true;
            return null;
        }

        var element = this.GetLoadingPanelElement();
        if(element != null) {
            element = this.CloneLoadingPanel(element, parentElement);
            if(centerInParent){
                ASPx.SetElementDisplay(element, true);
                parentElement.style.textAlign = "center";
            }
            else
                ASPx.SetElementDisplay(element, true);
            this.loadingPanelElement = element;
            return element;
        }
        return null;
    },
    ShowLoadingPanel: function() {
    },
    ShowLoadingElements: function() {
        if(this.InCallback() || this.lpTimer > -1) return;
        
        this.ShowLoadingDiv();
        if(this.IsCallbackAnimationEnabled())
            this.StartBeginCallbackAnimation();
        else
            this.ShowLoadingElementsInternal();
    },
    ShowLoadingElementsInternal: function() {
		if(this.lpDelay > 0 && !this.IsCallbackAnimationEnabled()) 
			this.lpTimer = window.setTimeout(function() { 
                this.ShowLoadingPanelOnTimer(); 
            }.aspxBind(this), this.lpDelay);
        else {
            this.RestoreLoadingDivOpacity();
			this.ShowLoadingPanel();
        }
    },
    GetLoadingPanelOffsetElement: function (baseElement) {
        if(this.IsCallbackAnimationEnabled()) {
            var element = this.GetLoadingPanelCallbackAnimationOffsetElement();
            if(element) {
                var container = typeof(ASPx.AnimationHelper) != "undefined" ? ASPx.AnimationHelper.findSlideAnimationContainer(element) : null;
                if(container)
                    return container.parentNode.parentNode;
                else
                    return element;
            }
        }
        return baseElement;
    },
    GetLoadingPanelCallbackAnimationOffsetElement: function () {
        return this.GetCallbackAnimationElement();
    },
    IsCallbackAnimationEnabled: function () {
        return (this.enableCallbackAnimation || this.isSlideCallbackAnimationEnabled()) && !this.isCallbackAnimationPrevented;
    },
    GetDefaultanimationEngineType: function() {
        return ASPx.AnimationEngineType.DEFAULT;
    },
    StartBeginCallbackAnimation: function () {
        this.beginCallbackAnimationProcessing = true;
        this.isCallbackFinished = false;

        var element = this.GetCallbackAnimationElement();
        if (element && this.isSlideCallbackAnimationEnabled() && this.slideAnimationDirection)
            ASPx.AnimationHelper.slideOut(element, this.slideAnimationDirection, this.FinishBeginCallbackAnimation.aspxBind(this), this.GetDefaultanimationEngineType(), this.rtl);
        else if(element && this.enableCallbackAnimation) 
            ASPx.AnimationHelper.fadeOut(element, this.FinishBeginCallbackAnimation.aspxBind(this), null, ASPx.AnimationEngineType.JS);
        else
            this.FinishBeginCallbackAnimation();
    },
    CancelBeginCallbackAnimation: function() {
        if(this.beginCallbackAnimationProcessing) {
            this.beginCallbackAnimationProcessing = false;
            var element = this.GetCallbackAnimationElement();
            ASPx.AnimationHelper.cancelAnimation(element);
        }
    },
    FinishBeginCallbackAnimation: function () {
        this.beginCallbackAnimationProcessing = false;
        if(!this.isCallbackFinished)
            this.ShowLoadingElementsInternal();
        else {
            this.DoCallback(this.savedCallbackResult);
            this.savedCallbackResult = null;
        }
    },
    CheckBeginCallbackAnimationInProgress: function(callbackResult) {
        if(this.beginCallbackAnimationProcessing) {
            this.savedCallbackResult = callbackResult;
            this.isCallbackFinished = true;
            return true;
        }
        return false;
    },
    StartEndCallbackAnimation: function () {
        this.HideLoadingPanel();
        this.SetInitialLoadingDivOpacity();

        this.RaiseEndCallbackAnimationStart();

        this.endCallbackAnimationProcessing = true;

        var element = this.GetCallbackAnimationElement();
        if(element && this.isSlideCallbackAnimationEnabled() && this.slideAnimationDirection) 
            ASPx.AnimationHelper.slideIn(element, this.slideAnimationDirection, this.FinishEndCallbackAnimation.aspxBind(this), this.GetDefaultanimationEngineType(), this.rtl);
        else if(element && this.enableCallbackAnimation) 
            ASPx.AnimationHelper.fadeIn(element, this.FinishEndCallbackAnimation.aspxBind(this), null, ASPx.AnimationEngineType.JS);
        else
            this.FinishEndCallbackAnimation();
        this.slideAnimationDirection = null;
    },
    FinishEndCallbackAnimation: function () {
        this.DoEndCallback();
        this.endCallbackAnimationProcessing = false;

        this.CheckRepeatGesture();
    },
    CheckEndCallbackAnimationNeeded: function() {
        if(!this.endCallbackAnimationProcessing && this.requestCount == 1) {
            this.StartEndCallbackAnimation();
            return true;
        }
        return false;
    },
    PreventCallbackAnimation: function() {
        this.isCallbackAnimationPrevented = true;
    },
    GetCallbackAnimationElement: function() {
        return null;
    },
    AssignSlideAnimationDirectionByPagerArgument: function(arg, currentPageIndex) {
        this.slideAnimationDirection = null;
        if(this.isSlideCallbackAnimationEnabled() && typeof(ASPx.AnimationHelper) != "undefined") {
            if(arg == PagerCommands.Next || arg == PagerCommands.Last)
                this.slideAnimationDirection = ASPx.AnimationHelper.SLIDE_LEFT_DIRECTION;
            else if(arg == PagerCommands.First || arg == PagerCommands.Prev)
                this.slideAnimationDirection = ASPx.AnimationHelper.SLIDE_RIGHT_DIRECTION;
            else if(!isNaN(currentPageIndex) && arg.indexOf(PagerCommands.PageNumber) == 0) {
                var newPageIndex = parseInt(arg.substring(2));
                if (!isNaN(newPageIndex)) {
                    var leftDir = this.rtl ? ASPx.AnimationHelper.SLIDE_LEFT_DIRECTION : ASPx.AnimationHelper.SLIDE_RIGHT_DIRECTION;
                    var rightDir = this.rtl ? ASPx.AnimationHelper.SLIDE_RIGHT_DIRECTION : ASPx.AnimationHelper.SLIDE_LEFT_DIRECTION;
                    this.slideAnimationDirection = newPageIndex < currentPageIndex ? leftDir : rightDir;
                }
            }
        }
    },
    TryShowPhantomLoadingElements: function () {
        if(this.hasPhantomLoadingElements && this.InCallback()) {
            this.hasPhantomLoadingElements = false;
            this.ShowLoadingDivAndPanel();
        }
    },
    ShowLoadingDivAndPanel: function () {
        this.ShowLoadingDiv();
        this.RestoreLoadingDivOpacity();
        this.ShowLoadingPanel();
    },
    HideLoadingElements: function() {
        this.CancelBeginCallbackAnimation();
        this.HideLoadingPanel();
        this.HideLoadingDiv();
    },
    ShowLoadingPanelOnTimer: function() {
        this.ClearLoadingPanelTimer();
        if(!this.IsDOMDisposed()) {
            this.RestoreLoadingDivOpacity();
            this.ShowLoadingPanel();
        }
    },
    ClearLoadingPanelTimer: function() {
		this.lpTimer = ASPx.Timer.ClearTimer(this.lpTimer);		
    },
    HideLoadingPanel: function() {
        this.ClearLoadingPanelTimer();

        this.hasPhantomLoadingElements = false;
        if(ASPx.IsExistsElement(this.loadingPanelElement)) {
            ASPx.RemoveElement(this.loadingPanelElement);
            this.loadingPanelElement = null;
        }
    },
    SetLoadingPanelLocation: function(offsetElement, loadingPanel, x, y, offsetX, offsetY) {
        if(!ASPx.IsExists(x) || !ASPx.IsExists(y)){
            var x1 = ASPx.GetAbsoluteX(offsetElement);
            var y1 = ASPx.GetAbsoluteY(offsetElement);
            var x2 = x1;
            var y2 = y1;
            if(offsetElement == document.body) {
                x1 = 0;
                y1 = 0;
                x2 = ASPx.GetDocumentMaxClientWidth();
                y2 = ASPx.GetDocumentMaxClientHeight();
            }
            else{
                x2 += offsetElement.offsetWidth;
                y2 += offsetElement.offsetHeight;
            }
            if(x1 < ASPx.GetDocumentScrollLeft())
                x1 = ASPx.GetDocumentScrollLeft();
            if(y1 < ASPx.GetDocumentScrollTop())
                y1 = ASPx.GetDocumentScrollTop();
            if(x2 > ASPx.GetDocumentScrollLeft() + ASPx.GetDocumentClientWidth())
                x2 = ASPx.GetDocumentScrollLeft() + ASPx.GetDocumentClientWidth();
            if(y2 > ASPx.GetDocumentScrollTop() + ASPx.GetDocumentClientHeight())
                y2 = ASPx.GetDocumentScrollTop() + ASPx.GetDocumentClientHeight();

            x = x1 + ((x2 - x1 - loadingPanel.offsetWidth) / 2);
            y = y1 + ((y2 - y1 - loadingPanel.offsetHeight) / 2);
        }
        if(ASPx.IsExists(offsetX) && ASPx.IsExists(offsetY)){
            x += offsetX;
            y += offsetY;
        }
        x = ASPx.PrepareClientPosForElement(x, loadingPanel, true);
        y = ASPx.PrepareClientPosForElement(y, loadingPanel, false);
        if(ASPx.Browser.IE && ASPx.Browser.Version > 8) {
            x = Math.round(x);
            y = Math.round(y);
        }
        ASPx.SetStyles(loadingPanel, { left: x, top: y });
    },
    GetLoadingDiv: function(){
        return ASPx.GetElementById(this.name + "_LD");
    },
    CreateLoadingDiv: function(parentElement, offsetElement){
        if(this.ShouldHideExistingLoadingElements())
            this.HideLoadingDiv();
        if(parentElement == null) 
            return null;
        if(!this.IsLoadingContainerVisible()) {
            this.hasPhantomLoadingElements = true;
            return null;
        }

        if(!offsetElement)
            offsetElement = parentElement;
        var div = this.GetLoadingDiv();
        if(div != null){
            div = div.cloneNode(true);
            parentElement.appendChild(div);
            ASPx.SetElementDisplay(div, true);
            ASPx.Evt.AttachEventToElement(div, ASPx.TouchUIHelper.touchMouseDownEventName, ASPx.Evt.PreventEvent);
            ASPx.Evt.AttachEventToElement(div, ASPx.TouchUIHelper.touchMouseMoveEventName, ASPx.Evt.PreventEvent);
            ASPx.Evt.AttachEventToElement(div, ASPx.TouchUIHelper.touchMouseUpEventName, ASPx.Evt.PreventEvent);
            ASPx.Evt.AttachEventToElement(div, ASPx.Evt.GetMouseWheelEventName(), ASPx.Evt.PreventEvent);
            this.SetLoadingDivBounds(offsetElement, div);
            this.loadingDivElement = div;
            this.SetInitialLoadingDivOpacity();
            return div;
        }
        return null;
    },
    SetInitialLoadingDivOpacity: function() {
        if(!this.loadingDivElement) return;

        ASPx.Attr.SaveStyleAttribute(this.loadingDivElement, "opacity");
        ASPx.Attr.SaveStyleAttribute(this.loadingDivElement, "filter");
        ASPx.SetElementOpacity(this.loadingDivElement, 0.01);
    },
    RestoreLoadingDivOpacity: function() {
        if(!this.loadingDivElement) return;
       
        ASPx.Attr.RestoreStyleAttribute(this.loadingDivElement, "opacity");
        ASPx.Attr.RestoreStyleAttribute(this.loadingDivElement, "filter");
    },
    SetLoadingDivBounds: function(offsetElement, loadingDiv) {
        var absX = (offsetElement == document.body) ? 0 : ASPx.GetAbsoluteX(offsetElement);
        var absY = (offsetElement == document.body) ? 0 : ASPx.GetAbsoluteY(offsetElement);
        ASPx.SetStyles(loadingDiv, {
            left: ASPx.PrepareClientPosForElement(absX, loadingDiv, true),
            top: ASPx.PrepareClientPosForElement(absY, loadingDiv, false)
        });
        var width = (offsetElement == document.body) ? ASPx.GetDocumentWidth() : offsetElement.offsetWidth;
        var height = (offsetElement == document.body) ? ASPx.GetDocumentHeight() : offsetElement.offsetHeight;
        if(height < 0) // B148866
            height = 0;
        ASPx.SetStyles(loadingDiv, { width: width, height: height });
        var correctedWidth = 2 * width - loadingDiv.offsetWidth;
        if(correctedWidth <= 0) correctedWidth = width;
        var correctedHeight = 2 * height - loadingDiv.offsetHeight;
        if(correctedHeight <= 0) correctedHeight = height;
        ASPx.SetStyles(loadingDiv, { width: correctedWidth, height: correctedHeight });
    },
    ShowLoadingDiv: function() {
    },
    HideLoadingDiv: function() {
        this.hasPhantomLoadingElements = false;
        if(ASPx.IsExistsElement(this.loadingDivElement)){
            ASPx.RemoveElement(this.loadingDivElement);
            this.loadingDivElement = null;
        }
    },
    CanHandleGesture: function(evt) {
        return false;
    },
    CanHandleGestureCore: function(evt) {
        var source = ASPx.Evt.GetEventSource(evt);
        if(ASPx.GetIsParent(this.loadingPanelElement, source) || ASPx.GetIsParent(this.loadingDivElement, source))
            return true; 
        var callbackAnimationElement = this.GetCallbackAnimationElement();
        if(!callbackAnimationElement)
            return false;
        var animationContainer = ASPx.AnimationHelper.getSlideAnimationContainer(callbackAnimationElement, false, false);
        if(animationContainer && ASPx.GetIsParent(animationContainer, source) && !ASPx.GetIsParent(animationContainer.childNodes[0], source))
            return true; 
        return this.CanHandleGesture(evt); 
    },
    AllowStartGesture: function() {
        return !this.beginCallbackAnimationProcessing && !this.endCallbackAnimationProcessing;
    },
    StartGesture: function() {
    },
    AllowExecuteGesture: function(value) {
        return false;
    },
    ExecuteGesture: function(value) {
    },
    CancelGesture: function(value) {
        if(this.repeatedGestureCount === 0) {
            this.repeatedGestureValue = value;
            this.repeatedGestureCount = 1;
        }
        else {
            if(this.repeatedGestureValue * value > 0)
                this.repeatedGestureCount++;
            else
                this.repeatedGestureCount--;
            if(this.repeatedGestureCount === 0)
                this.repeatedGestureCount = 0;
        }
    },
    CheckRepeatGesture: function() {
        if(this.repeatedGestureCount !== 0) {
            if(this.AllowExecuteGesture(this.repeatedGestureValue))
                this.ExecuteGesture(this.repeatedGestureValue, this.repeatedGestureCount);
            this.repeatedGestureValue = 0;
            this.repeatedGestureCount = 0;
        }
    },
    AllowExecutePagerGesture: function (pageIndex, pageCount, value) {
        if(pageIndex < 0) return false;
        if(pageCount <= 1) return false;
        if(value > 0 && pageIndex === 0) return false;
        if(value < 0 && pageIndex === pageCount - 1) return false;
        return true;
    },
    ExecutePagerGesture: function(pageIndex, pageCount, value, count, method) {
        if(!count) count = 1;

        var pageIndex = pageIndex + (value < 0 ? count : -count);
        if(pageIndex < 0) pageIndex = 0;
        if(pageIndex > pageCount - 1) pageIndex = pageCount - 1;
        method(PagerCommands.PageNumber + pageIndex);
    },

    RaiseInit: function(){
        if(!this.Init.IsEmpty()){
            var args = new ASPxClientEventArgs();
            this.Init.FireEvent(this, args);
        }
    },
    RaiseBeginCallbackInternal: function(command){
        if(!this.BeginCallback.IsEmpty()){
            var args = new ASPxClientBeginCallbackEventArgs(command);
            this.BeginCallback.FireEvent(this, args);
        }
    },
    RaiseEndCallbackInternal: function(command) {
        if(!this.EndCallback.IsEmpty()){
            var args = new ASPxClientEndCallbackEventArgs(command);
            this.EndCallback.FireEvent(this, args);
        }
    },
    RaiseCallbackErrorInternal: function(message, callbackId) {
        if(!this.CallbackError.IsEmpty()) {
            var args = new ASPxClientCallbackErrorEventArgs(message, callbackId);
            this.CallbackError.FireEvent(this, args);
            if(args.handled)
                return { isHandled: true, errorMessage: args.message };
        }
    },
    RaiseBeginCallback: function(command){
        this.RaiseBeginCallbackInternal(command);       
        aspxGetControlCollection().RaiseBeginCallback(this, command);
    },
    RaiseEndCallback: function(command){
        this.RaiseEndCallbackInternal(command);
        aspxGetControlCollection().RaiseEndCallback(this, command);
    },
    RaiseCallbackError: function (message, callbackId) {
        var result = this.RaiseCallbackErrorInternal(message, callbackId);
        if(!result) 
            result = aspxGetControlCollection().RaiseCallbackError(this, message, callbackId);
        return result;
    },
    RaiseEndCallbackAnimationStart: function(){
        if(!this.EndCallbackAnimationStart.IsEmpty()){
            var args = new ASPxClientEventArgs();
            this.EndCallbackAnimationStart.FireEvent(this, args);
        }
    },
    RaiseBeforePronounce: function(message) {
        var args = new ASPxClientControlBeforePronounceEventArgs(message, this);
        if(!this.BeforePronounce.IsEmpty())
            this.BeforePronounce.FireEvent(this, args);
        return args;
    },
    RaiseUnload: function() {
        var args = new ASPxClientControlUnloadEventArgs(this);
        if(!this.Unload.IsEmpty())
            this.Unload.FireEvent(this, args);
    },
    RaiseDisposed: function() {
        this.Disposed.FireEvent(this, new ASPxClientEventArgs(this));
    },
    /*# public void SendMessageToAssistiveTechnology(string message) {} #*/
    SendMessageToAssistiveTechnology: function(message) {
        if(!this.accessibilityCompliant)
            return;
        this.PronounceMessageInternal(message, ASPx.AccessibilityPronouncerType.live);
    },
    PronounceMessageInternal: function(messageArg, type) {
        var message = messageArg;
        if(!ASPx.Ident.IsArray(messageArg))
            message = [messageArg];
        var args = this.RaiseBeforePronounce(message);
        ASPx.AccessibilityPronouncer.Pronounce(args, type);
    },
    IsVisible: function() {
        var element = this.GetMainElement();
        return ASPx.IsElementVisible(element);
    },
    IsDisplayedElement: function(element) {
        while(element && element.tagName != "BODY") {
            if(!ASPx.GetElementDisplay(element)) 
                return false;
            element = element.parentNode;
        }
        return true;
    },
    IsDisplayed: function() {
        return this.IsDisplayedElement(this.GetMainElement());
    },
    IsHiddenElement: function(element) {
        return element && element.offsetWidth == 0 && element.offsetHeight == 0;
    },
    IsHidden: function() {
        return this.IsHiddenElement(this.GetMainElement());
    },
    IsDisposed: function() {
        return this.disposed;
    },

    /*# public object GetParentControl() { return null; } #*/
    GetParentControl: function() {
        var mainElement = this.getActualMainElement();
        var popupPostfix = ASPx.PCWIdSuffix + "-1";
        var result = null;
        ASPx.GetParent(mainElement, function(element) {
            if(element === mainElement || !element.id)
                return false;
            var controlName = element.id.replace(popupPostfix, "");
            result = ASPx.GetControlCollection().Get(controlName);
            return !!result;
        });
        return result;
    },
    getActualMainElement: function() { return this.GetMainElement(); },
    findParentByType: function (type) {
        var ctrl = this;
        while (ctrl) {
            var parent = ctrl.GetParentControl();
            if (parent && parent instanceof type)
                return parent;
            ctrl = parent;
        }
        return null;
    },
    Focus: function() {
    
    },
    /*# [Obsolete("Use the GetVisible method instead.")]public bool GetClientVisible() { return false; } #*/    
    GetClientVisible: function(){
        return this.GetVisible();
    },
    /*# [Obsolete("Use the SetVisible method instead.")]public void SetClientVisible(bool visible) {} #*/
    SetClientVisible: function(visible){
        this.SetVisible(visible);
    },
    /*# public bool GetVisible() { return false; } #*/    
    GetVisible: function(){
        return this.clientVisible;
    },
    /*# public void SetVisible(bool visible) {} #*/
    SetVisible: function(visible){
        if(this.clientVisible != visible){
            this.clientVisible = visible;
            ASPx.SetElementDisplay(this.GetMainElement(), visible);
            if(visible) {
                this.AdjustControl();
                
                var mainElement = this.GetMainElement();
                if(mainElement)
                    aspxGetControlCollection().AdjustControls(mainElement);
            }
        }
    },
    GetEnabled: function() {
        return this.clientEnabled;
    },
    SetEnabled: function(enabled) {
        this.clientEnabled = enabled;

        if(ASPxClientControl.setEnabledLocked)
            return;
        else
            ASPxClientControl.setEnabledLocked = true;

        this.savedClientEnabled = enabled;
        aspxGetControlCollection().ProcessControlsInContainer(this.GetMainElement(), function(control) {
            if(ASPx.IsFunction(control.SetEnabled))
                control.SetEnabled(enabled && control.savedClientEnabled);
        });

        delete ASPxClientControl.setEnabledLocked;
    },
    /*# public bool InCallback() { return false; } #*/        
    InCallback: function() {
        return this.requestCount > 0;
    },
    DoBeginCallback: function(command) {
        this.RaiseBeginCallback(command || "");

        aspxGetControlCollection().Before_WebForm_InitCallback(this.name);
        if(typeof(WebForm_InitCallback) != "undefined" && WebForm_InitCallback) {
            __theFormPostData = "";
            __theFormPostCollection = [ ];
            this.ClearPostBackEventInput("__EVENTTARGET");
            this.ClearPostBackEventInput("__EVENTARGUMENT");
            WebForm_InitCallback();
            this.savedFormPostData = __theFormPostData;            
            this.savedFormPostCollection = __theFormPostCollection;
        }
    },
    ClearPostBackEventInput: function(id){
        var element = ASPx.GetElementById(id);
        if(element != null) element.value = "";
    },
    PerformDataCallback: function(arg, handler) {
        this.CreateCustomDataCallback(arg, "", handler);
    },
    sendCallbackViaQueue: function (prefix, arg, showLoadingPanel, context, handler, onBeforeSend) {
        if (!this.useCallbackQueue())
            return false;
        var context = context || this;
        var token = this.callbackQueueHelper.sendCallback(ASPx.FormatCallbackArg(prefix, arg), context, handler || context.OnCallback, prefix, onBeforeSend);
        if (showLoadingPanel)
            this.callbackQueueHelper.showLoadingElements();
        return token;
    },
    CreateCallback: function (arg, command, handler) {
        var callbackInfo = this.CreateCallbackInfo(ASPx.CallbackType.Common, handler || null);
        var callbackID = this.CreateCallbackByInfo(arg, command, callbackInfo);
        return callbackID;
    },
    CreateCustomDataCallback: function(arg, command, handler) {
        var callbackInfo = this.CreateCallbackInfo(ASPx.CallbackType.Data, handler);
        this.CreateCallbackByInfo(arg, command, callbackInfo);
    },
    CreateCallbackByInfo: function(arg, command, callbackInfo) {
        if(!this.CanCreateCallback()) return;
        var callbackID;
        if(typeof(WebForm_DoCallback) != "undefined" && WebForm_DoCallback && ASPx.documentLoaded || ASPx.Platform === "NETCORE")
            callbackID = this.CreateCallbackInternal(arg, command, true, callbackInfo);
        else {
            if(!this.savedCallbacks)
                this.savedCallbacks = [];
            var callbackInfo = { arg: arg, command: command, callbackInfo: callbackInfo };
            if(this.allowMultipleCallbacks)
                this.savedCallbacks.push(callbackInfo);
            else
                this.savedCallbacks[0] = callbackInfo;
        }
        return callbackID;
    },
    CreateCallbackInternal: function(arg, command, viaTimer, callbackInfo) {
        var watcher = ASPx.ControlUpdateWatcher.getInstance();
        if(watcher && !watcher.CanSendCallback(this, arg)) {
            this.CancelCallbackInternal();
            return;
        }
        this.requestCount++;
        this.DoBeginCallback(command);
        
        if(typeof(arg) == "undefined")
            arg = "";
        if(typeof(command) == "undefined")
            command = "";
        
        var callbackID = this.SaveCallbackInfo(callbackInfo, command),
            customArgs = this.GetCustomCallbackArgs();
        if(viaTimer)
            window.setTimeout(function() { this.CreateCallbackCoreWithCustomArgs(arg, command, callbackID, customArgs); }.aspxBind(this), 0);
        else
            this.CreateCallbackCoreWithCustomArgs(arg, command, callbackID, customArgs);
        return callbackID;
    },
    CreateCallbackCoreWithCustomArgs: function(arg, command, callbackID, customArgs) {
        this.CreateCallbackCore(arg, command, callbackID);
    },
    GetCustomCallbackArgs: function() {
        return {};
    },
    CancelCallbackInternal: function() {
        this.CancelCallbackCore();
        this.HideLoadingElements();
    },
    CancelCallbackCore: function() {
    },
    CreateCallbackCore: function(arg, command, callbackID) {
        var callBackMethod = this.GetCallbackMethod(command);
        __theFormPostData = this.savedFormPostData;
        __theFormPostCollection = this.savedFormPostCollection;
        callBackMethod.call(this, this.GetSerializedCallbackInfoByID(callbackID) + arg);
    },
    GetCallbackMethod: function(command){
        return this.callBack;
    },
    CanCreateCallback: function() {
        return !this.InCallback() || (this.allowMultipleCallbacks && !this.beginCallbackAnimationProcessing && !this.endCallbackAnimationProcessing);
    },
    DoLoadCallbackScripts: function() {
        ASPx.ProcessScriptsAndLinks(this.name, true);
    },
    DoEndCallback: function() {
        if(this.IsCallbackAnimationEnabled() && this.CheckEndCallbackAnimationNeeded()) 
            return;

        this.requestCount--;
        if (this.requestCount < 1) 
            this.callbackHandlersQueue.executeCallbacksHandlers();
        if(this.HideLoadingPanelOnCallback() && this.requestCount < 1) 
            this.HideLoadingElements();

        if(this.isSwipeGesturesEnabled() && this.supportGestures) {
            ASPx.GesturesHelper.UpdateSwipeAnimationContainer(this.name);
            if(this.touchUIMouseScroller)
                this.touchUIMouseScroller.update();
        }
        this.isCallbackAnimationPrevented = false;

        this.OnCallbackFinalized();
        this.AssignEllipsisTooltips();

        var command = this.GetCallbackCommand();
        this.RaiseEndCallback(command);
        this.InitializeIntersectionObserversManager();
        this.currentCallbackID = -1;
    },
    DoFinalizeCallback: function() {
    },
    OnCallbackFinalized: function() {
    },
    AssignEllipsisTooltips: function() { },
    GetCallbackCommand: function() {
        var result = "";
        if(this.currentCallbackID != -1) {
            var command = this.callbackCommand[this.currentCallbackID];
            if(command)
                result = command;
        }
        return result;
    },
    HideLoadingPanelOnCallback: function() {
        return true;
    },
	ShouldHideExistingLoadingElements: function() {
        return true;
    },
    EvalCallbackResult: function(resultString){
        return eval(resultString);
    },
    ParseJSProperties: function(resultObj) {
        if(resultObj.cp) {
            for(var name in resultObj.cp)
                if(resultObj.cp.hasOwnProperty(name)) {
                    this[name] = resultObj.cp[name];
                    if(this.aspNetCoreWrapperInstance)
                        this.aspNetCoreWrapperInstance[name] = resultObj.cp[name]; 
                }
        }
    },
    DoCallback: function(result) {
        if(this.IsCallbackAnimationEnabled() && this.CheckBeginCallbackAnimationInProgress(result))
            return;

        result = ASPx.Str.Trim(result);
        if(result.indexOf(ASPx.CallbackResultPrefix) != 0) 
            this.ProcessCallbackGeneralError(result, false);
        else {
            var resultObj = null;
            try {
                resultObj = this.EvalCallbackResult(result);
            } 
            catch(e) {
                // B36430
            }
            if(resultObj) {
                this.currentCallbackID = resultObj.id;
                ASPx.CacheHelper.DropCache(this);

                if(resultObj.redirect) {
                    this.ParseJSProperties(resultObj); //T547999
                    ASPx.Url.Redirect(resultObj.redirect);
                }
                else if(ASPx.IsExists(resultObj.generalError)) {
                    this.ProcessCallbackGeneralError(resultObj.generalError, true);
                }
                else {
                    var errorObj = resultObj.error;
                    if(errorObj) { 
                        if(this.parseJSPropertiesOnCallbackError)
                            this.ParseJSProperties(resultObj);
                        this.ProcessCallbackError(errorObj,resultObj.id);
                    } else {
                        this.ParseJSProperties(resultObj);
                        var callbackInfo = this.DequeueCallbackInfo(resultObj.id);
                        if(callbackInfo && callbackInfo.type == ASPx.CallbackType.Data)
                            this.ProcessCustomDataCallback(resultObj.result, callbackInfo);
                        else {
                            if (this.useCallbackQueue() && this.callbackQueueHelper.getCallbackInfoById(resultObj.id))
                                this.callbackQueueHelper.processCallback(resultObj.result, resultObj.id);
                            else {
                                this.ProcessCallback(resultObj.result, resultObj.id);
                                if(callbackInfo && callbackInfo.handler) {
                                    var handlerInfo = { handler: callbackInfo.handler, result: resultObj.result.data };
                                    this.callbackHandlersQueue.addCallbackHandler(handlerInfo);
                                }
                            }
                        }
                    }
                    
                }
            }
        }
        // B156350, B148956, B204609
        this.DoLoadCallbackScripts();
    },
    DoCallbackError: function(result) {
        this.HideLoadingElements();
        this.ProcessCallbackGeneralError(result, false); // B191862
    },
    DoControlClick: function(evt) {
        this.OnControlClick(ASPx.Evt.GetEventSource(evt), evt);
    },
    ProcessCallback: function (result, callbackId) {
        this.OnCallback(result, callbackId);
    },
    ProcessCustomDataCallback: function(result, callbackInfo) {
        if(callbackInfo.handler != null)
            callbackInfo.handler(this, result);
        this.RaiseCustomDataCallback(result);
    },
    RaiseCustomDataCallback: function(result) {
        if(!this.CustomDataCallback.IsEmpty()) {
            var arg = new ASPxClientCustomDataCallbackEventArgs(result);
            this.CustomDataCallback.FireEvent(this, arg);
        }
    },
    OnCallback: function(result) {
    
    },
    CreateCallbackInfo: function(type, handler) {
        return { type: type, handler: handler };
    },
    GetSerializedCallbackInfoByID: function(callbackID) {
        return this.GetCallbackInfoByID(callbackID).type + callbackID + ASPx.CallbackSeparator;
    },
    SaveCallbackInfo: function(info, command) {
        var callbacks = this.GetActiveCallbacksInfo();
        var index = callbacks.indexOf(null);
        if(index === -1)
            index = callbacks.length;
        callbacks[index] = info;
        this.callbackCommand[index] = command;
        return index;
    },
    GetActiveCallbacksInfo: function() {
        var persistentProperties = this.GetPersistentProperties();
        if(!persistentProperties.activeCallbacks)
            persistentProperties.activeCallbacks = [ ];
        return persistentProperties.activeCallbacks;
    },
    GetPersistentProperties: function() {
        var storage = _aspxGetPersistentControlPropertiesStorage();
        var persistentProperties = storage[this.name];
        if(!persistentProperties) {
            persistentProperties = { };
            storage[this.name] = persistentProperties;
        }
        return persistentProperties;
    },
    GetCallbackInfoByID: function(callbackID) {
        return this.GetActiveCallbacksInfo()[callbackID];
    },
    DequeueCallbackInfo: function(index) {
        var activeCallbacksInfo = this.GetActiveCallbacksInfo();
        if(index < 0 || index >= activeCallbacksInfo.length)
            return null;
        var result = activeCallbacksInfo[index];
        activeCallbacksInfo[index] = null;
        return result;
    },
    ProcessCallbackError: function (errorObj, callbackId) {
        var data = ASPx.IsExists(errorObj.data) ? errorObj.data : null;
        var result = this.RaiseCallbackError(errorObj.message, callbackId);
        if(result.isHandled)
            this.OnCallbackErrorAfterUserHandle(result.errorMessage, data);    
        else
            this.OnCallbackError(result.errorMessage, data);    
    },
    OnCallbackError: function(errorMessage, data) {
        if(errorMessage)
            ASPx.ShowErrorAlert(errorMessage);
    },
    OnCallbackErrorAfterUserHandle: function(errorMessage, data) {
    },
    ProcessCallbackGeneralError: function(errorMessage, serverExceptionOnLastCallback) {
        this.serverExceptionOnLastCallback = serverExceptionOnLastCallback;
        var result = this.RaiseCallbackError(errorMessage);
        if(result.isHandled)
            this.OnCallbackGeneralErrorAfterUserHandle(result.errorMessage);
        else
            this.OnCallbackGeneralError(result.errorMessage);
    },
    OnCallbackGeneralError: function(errorMessage) {
        this.OnCallbackError(errorMessage, null);
    },
    OnCallbackGeneralErrorAfterUserHandle: function (errorMessage) {
    },

    SendPostBack: function(params, preventConvertToUpdatePanelCallback) {
        if(preventConvertToUpdatePanelCallback)
            this.sendMSAjaxCompatPostBack(params);
        else
            this.sendPostBackInternal(params);
    },
    sendPostBackInternal: function(params) {
        if(typeof(__doPostBack) != "undefined")
            __doPostBack(this.uniqueID, params);
        else{
            var form = this.GetParentForm();
            if(form) form.submit();
        }
    },
    sendMSAjaxCompatPostBack: function(params) {
        var rm = ASPx.GetMSAjaxRequestManager();
        var triggers = rm ? rm._postBackControlClientIDs : null;
        var needRegister = triggers && ASPx.Ident.IsArray(triggers) && ASPx.Data.ArrayIndexOf(triggers, this.name) == -1;
        if(needRegister)
            triggers.unshift(this.name);
        this.sendPostBackInternal(params);
        if(needRegister)
            triggers.shift();
    },

    IsValidInstance: function () {
        return aspxGetControlCollection().GetByName(this.name) === this;
    },
    OnDispose: function() { 
        this.RaiseDisposed();
        var varName = this.globalName;
        if(varName && varName !== "" && window && window[varName] && window[varName] == this){
            try{
                delete window[varName];
            }
            catch(e){ /* For IE8 */ }
        }
        if(this.callbackQueueHelper)
            this.callbackQueueHelper.detachEvents();
        if (!this.IsDisposed())
            this.disposed = true;
    },

    OnGlobalControlsInitialized: function(args) { 
    },
    OnGlobalBrowserWindowResized: function(args) { 
    },
    OnGlobalBeginCallback: function(args) { 
    },
    OnGlobalEndCallback: function(args) { 
    },
    OnGlobalCallbackError: function(args) { 
    },
    OnGlobalValidationCompleted: function(args) { 
    },

    AddDefaultStateControllerItems: function() {
        var states = this.scStates;
        if(!states) return;
        var postfix = this.scPostfix ? ("_" + this.scPostfix) : "";
        var mainElementId = this.GetMainElementId();
        if(states & 2)
            this.AddDefaultReadOnlyStateControllerItem(this.scPrefix + "ReadOnly" + postfix, mainElementId);
        if(states & 4)
            this.AddDefaultDisabledStateControllerItem(this.scPrefix + "Disabled" + postfix, mainElementId);
    },
    AddDefaultReadOnlyStateControllerItem: function(cssClass, mainElementId) { throw "Not implemented"; },
    AddDefaultDisabledStateControllerItem: function(cssClass, mainElementId) { throw "Not implemented"; },

    // from ClientControl:
    DOMContentLoaded: function() { },
    IsStateControllerEnabled: function() { return false; },
    InitializeDOM: function() {
        var mainElement = this.GetMainElement();
        if(mainElement)
            ASPx.SetElementInitializedFlag(mainElement);
    },
    IsDOMInitialized: function() {
        var mainElement = this.GetMainElement();
        return mainElement && ASPx.GetElementInitializedFlag(mainElement);
    },
    AdjustControl: function(nestedCall) { },
    OnBrowserWindowResizeInternal: function(e) { },
    RegisterInControlTree: function(tree) { },

    InitializeIntersectionObserversManager: function () {
        var elementToObserve = this.getElementToObserveVisibilityChange();
        if(elementToObserve) {
            ASPx.IntersectionObserversManager.SubscribeElemensVisibilityChangeInBrowserWindow(elementToObserve, this.processVisibilityChanged.bind(this));
        }
    },
    //virtual
    getElementToObserveVisibilityChange: function () { },
    //virtual
    processVisibilityChanged: function (visible) { }
});

/*# public static ASPxClientControlBase Cast(object obj){ return null; } #*/ 
ASPxClientControlBase.Cast = function(obj) {
    if(typeof obj == "string")
        return window[obj];
    return obj;
};

var persistentControlPropertiesStorage = null;
function _aspxGetPersistentControlPropertiesStorage() {
    if(persistentControlPropertiesStorage == null)
        persistentControlPropertiesStorage = { };
    return persistentControlPropertiesStorage;
}

var ELLIPSIS_MARKER_CLASS = "dx-ellipsis";
var ELLIPSIS_TOOLTIP_MARKER_ATTR = "dxEllipsisTitle";
/*# public class ASPxClientControl: ASPxClientControlBase #*/
var ASPxClientControl = ASPx.CreateClass(ASPxClientControlBase, {
    constructor: function(name){
        this.constructor.prototype.constructor.call(this, name);
        
        this.rtl = false;
        this.enableEllipsis = false;

        this.isNative = false;

        this.isControlCollapsed = false;
        this.isInsideHierarchyAdjustment = false;
        this.controlOwner = null;
        this.adjustedSizes = { };
        
        this.dialogContentHashTable = { };
        this.renderIFrameForPopupElements = false;
        this.widthValueSetInPercentage = false;
        this.heightValueSetInPercentage = false;
        this.verticalAlignedElements = { };
        this.wrappedTextContainers = { };
        this.scrollPositionState = { };

        this.sizingConfig = {
            allowSetWidth: true,
            allowSetHeight: true,
            correction : false,
            adjustControl : false,
            supportPercentHeight: false,
            supportAutoHeight: false
        };

        this.percentSizeConfig = {
            width: -1,
            height: -1,
            markerWidth: -1,
            markerHeight: -1
        };        
    },
    querySelector: function(selector) { return this.querySelectorAll(selector)[0] || null; },
    querySelectorAll: function(selector) {
        return ASPx.CacheHelper.GetCachedElement(this, "querySelectorAll_" + selector,
            function() { return Array.prototype.slice.call(this.GetMainElement().querySelectorAll(selector)); });
    },
    createAccessKey: function (popupItem, getPopupElement, keyTipElement, key, onlyClick, manualStopProcessing) {
        return new ASPx.AccessKey(popupItem, getPopupElement, keyTipElement, key, onlyClick, manualStopProcessing);
    },
    InlineInitialize: function() {
        this.InitializeDOM();
        ASPxClientControlBase.prototype.InlineInitialize.call(this);
    },

    AfterCreate: function() { // Don't override it
        ASPxClientControlBase.prototype.AfterCreate.call(this);

        if(!this.CanInitializeAdjustmentOnDOMContentLoaded() || ASPx.IsStartupScriptsRunning())
            this.InitializeAdjustment();
    },
    DOMContentLoaded: function() {
        if(this.CanInitializeAdjustmentOnDOMContentLoaded()) 
            this.InitializeAdjustment();
    },
    CanInitializeAdjustmentOnDOMContentLoaded: function() {
        return !ASPx.Browser.IE || ASPx.Browser.Version >= 10; // IE9- browsers flick if adjust control bounds on DOMContentLoaded
    },
    InitializeAdjustment: function() {
        this.UpdateAdjustmentFlags();
        this.AdjustControl();
    },
    AfterInitialize: function() {
        this.AdjustControl();
        ASPxClientControlBase.prototype.AfterInitialize.call(this);
    },

    IsStateControllerEnabled: function(){
        return typeof(ASPx.GetStateController) != "undefined" && ASPx.GetStateController();
    },
    
    // Sizes
    /*# public int GetWidth() { return 0; } #*/
    GetWidth: function() {
        return this.GetMainElement().offsetWidth;
    },
    /*# public int GetHeight() { return 0; } #*/
    GetHeight: function() {
        return this.GetMainElement().offsetHeight;
    },
    /*# public void SetWidth(int width) { } #*/
    SetWidth: function(width) {
        if(this.sizingConfig.allowSetWidth)
            this.SetSizeCore("width", width, "GetWidth", false);
    },
    /*# public void SetHeight(int height) { } #*/
    SetHeight: function(height) {
        if(this.sizingConfig.allowSetHeight)
            this.SetSizeCore("height", height, "GetHeight", false);
    },
    SetSizeCore: function(sizePropertyName, size, getFunctionName, corrected) {
        if(size < 0 || !this.GetMainElement())
            return;
            
        this.GetMainElement().style[sizePropertyName] = size + "px";
        this.UpdateAdjustmentFlags(sizePropertyName);
        if(this.sizingConfig.adjustControl)
            this.AdjustControl(true);
        
        if(this.sizingConfig.correction && !corrected) {
            var realSize = this[getFunctionName]();
            if(realSize != size) {
                var correctedSize = size - (realSize - size);
                this.SetSizeCore(sizePropertyName, correctedSize, getFunctionName, true);
            }
        }
    },
    
    // Size correction
    /*# public void AdjustControl() { } #*/
    AdjustControl: function(nestedCall) {
        if(this.IsAdjustmentRequired() && (!ASPxClientControl.adjustControlLocked || nestedCall)) {
            ASPxClientControl.adjustControlLocked = true;
            try {
                if(!this.IsAdjustmentAllowed())
                    return;
            
                this.AdjustControlCore();
                this.UpdateAdjustedSizes();
            } 
            finally {
                delete ASPxClientControl.adjustControlLocked;
            }
        }
        this.AssignEllipsisTooltips();
        this.TryShowPhantomLoadingElements();
    },
    ResetControlAdjustment: function () {
        this.adjustedSizes = { };
    },
	UpdateAdjustmentFlags: function(sizeProperty) {
		var mainElement = this.GetMainElement();
	    if(mainElement) {
	        var mainElementStyle = ASPx.GetCurrentStyle(mainElement);
            this.UpdatePercentSizeConfig([mainElementStyle.width, mainElement.style.width], [mainElementStyle.height, mainElement.style.height], sizeProperty);
	    }
	},
    UpdatePercentSizeConfig: function(widths, heights, modifyStyleProperty) {
        switch(modifyStyleProperty) {
            case "width":
                this.UpdatePercentWidthConfig(widths);
                break;
            case "height":
                this.UpdatePercentHeightConfig(heights);
                break;
            default:
                this.UpdatePercentWidthConfig(widths);
                this.UpdatePercentHeightConfig(heights);
                break;
        }
        this.ResetControlPercentMarkerSize();
    },
    UpdatePercentWidthConfig: function(widths) {
        this.widthValueSetInPercentage = false;
        for(var i = 0; i < widths.length; i++) {
            if(this.IsPercentageWidth(widths[i])) {
                this.percentSizeConfig.width = widths[i];
                this.widthValueSetInPercentage = true;
                break;
            }
        }
    },
    IsPercentageWidth: function(width) { return ASPx.IsPercentageSize(width); },
    UpdatePercentHeightConfig: function(heights) {
        this.heightValueSetInPercentage = false;
                for(var i = 0; i < heights.length; i++) {
            if(ASPx.IsPercentageSize(heights[i])) {
                this.percentSizeConfig.height = heights[i];
                this.heightValueSetInPercentage = true;
                break;
            }
        }
    },
    GetAdjustedSizes: function() {
		var mainElement = this.GetMainElement();
	    if(mainElement) 
            return { width: mainElement.offsetWidth, height: mainElement.offsetHeight };
        return { width: 0, height: 0 };
    },
    IsAdjusted: function() {
        return (this.adjustedSizes.width && this.adjustedSizes.width > 0) && (this.adjustedSizes.height && this.adjustedSizes.height > 0);
    },
	IsAdjustmentRequired: function() {
        if(!this.IsAdjusted())
            return true;
        if(this.widthValueSetInPercentage)
            return true;
        if(this.heightValueSetInPercentage)
            return true;

        var sizes = this.GetAdjustedSizes();
        for(var name in sizes){
            if(this.adjustedSizes[name] !== sizes[name])
                return true;
        }

        return false;
	},
    IsAdjustmentAllowed: function() {
        var mainElement = this.GetMainElement();
        return mainElement && this.IsDisplayed() && !this.IsHidden() && this.IsDOMInitialized();
    },
	UpdateAdjustedSizes: function() {
        var sizes = this.GetAdjustedSizes();
        for(var name in sizes)
            if(sizes.hasOwnProperty(name))
                this.adjustedSizes[name] = sizes[name];
	},
    AdjustControlCore: function() {
    },
    AdjustAutoHeight: function() {
    },
    IsControlCollapsed: function() {
        return this.isControlCollapsed;
    },
    NeedCollapseControl: function() {
        return this.NeedCollapseControlCore() && this.IsAdjustmentRequired() && this.IsAdjustmentAllowed();
    },
    NeedCollapseControlCore: function() {
        return false;
    },
    CollapseEditor: function() {
    },
    CollapseControl: function() {
        this.SaveScrollPositions();

        var mainElement = this.GetMainElement(),
            marker = this.GetControlPercentSizeMarker();

        marker.style.height = this.heightValueSetInPercentage && this.sizingConfig.supportPercentHeight
            ? this.percentSizeConfig.height 
            : (mainElement.offsetHeight + "px");
        
        mainElement.style.display = "none";
        this.isControlCollapsed = true;
    },
    ExpandControl: function() {
        var mainElement = this.GetMainElement();
        mainElement.style.display = "";
        this.GetControlPercentSizeMarker().style.height = "0px";
        this.isControlCollapsed = false;
        
        this.RestoreScrollPositions();
    },
    CanCauseReadjustment: function() {
        return this.NeedCollapseControlCore();
    },
    IsExpandableByAdjustment: function() {
        return false;
    },
    HasFixedPosition: function() {
        return false;
    },
    SaveScrollPositions: function() {
        var mainElement = this.GetMainElement();
        this.scrollPositionState.outer = ASPx.GetOuterScrollPosition(mainElement.parentNode);
        this.scrollPositionState.inner = ASPx.GetInnerScrollPositions(mainElement);
    },
    RestoreScrollPositions: function() {
        ASPx.RestoreOuterScrollPosition(this.scrollPositionState.outer);
        ASPx.RestoreInnerScrollPositions(this.scrollPositionState.inner);
    },
    GetControlPercentSizeMarker: function() {
        if(this.percentSizeMarker === undefined) {
            this.percentSizeMarker = ASPx.CreateHtmlElementFromString("<div style='height:0px;font-size:0px;line-height:0;width:100%;'></div>");
            ASPx.InsertElementAfter(this.percentSizeMarker, this.GetMainElement());
        }
        return this.percentSizeMarker;
    },
    KeepControlPercentSizeMarker: function(needCollapse, needCalculateHeight) {
        var marker = this.GetControlPercentSizeMarker(),
            markerHeight;

        if(needCollapse)
            this.CollapseControl();
        if(this.widthValueSetInPercentage && marker.style.width !== this.percentSizeConfig.width)
            marker.style.width = this.percentSizeConfig.width;
        
        if(needCalculateHeight) {
            if(this.IsControlCollapsed())
                markerHeight = marker.style.height;
            marker.style.height = this.percentSizeConfig.height;
        }
        this.percentSizeConfig.markerWidth = marker.offsetWidth;
        if(needCalculateHeight) {
            this.percentSizeConfig.markerHeight = marker.offsetHeight;
            if(this.IsControlCollapsed())
                marker.style.height = markerHeight;
            else
                marker.style.height = "0px";
        }

        if(needCollapse)
            this.ExpandControl();
    },
    ResetControlPercentMarkerSize: function() {
        this.percentSizeConfig.markerWidth = -1;
        this.percentSizeConfig.markerHeight = -1;
    },
    GetControlPercentMarkerSize: function(hideControl, force) {
        var needCalculateHeight = this.heightValueSetInPercentage && this.sizingConfig.supportPercentHeight;
        if(force || this.percentSizeConfig.markerWidth < 1 || (needCalculateHeight && this.percentSizeConfig.markerHeight < 1))
            this.KeepControlPercentSizeMarker(hideControl && !this.IsControlCollapsed(), needCalculateHeight);
        return {
            width: this.percentSizeConfig.markerWidth,
            height: this.percentSizeConfig.markerHeight
        };
    },

    // Ellipsis
    AssignEllipsisTooltips: function() {
        if(this.RequireAssignTooltips())
            this.AssignEllipsisTooltipsCore();
    },
    AssignEllipsisTooltipsCore: function(rootElement, reassingExistingTooltips) {
        var requirePaddingManipulation = ASPx.Browser.IE || ASPx.Browser.Edge || ASPx.Browser.Firefox;
        rootElement = rootElement || this.GetMainElement();
        var nodes = this.GetEllipsisNodes(rootElement);
        var nodeInfos = [];
        var nodesCount = nodes.length;

        for(var i = 0; i < nodesCount; i++) {
            var node = nodes[i];
            var info = { node: node };
            if(requirePaddingManipulation) {
                var style = ASPx.GetCurrentStyle(node);
                info.paddingLeft = node.style.paddingLeft;
                info.totalPadding = ASPx.GetLeftRightPaddings(node, style);
            }
            nodeInfos.push(info);
        }
        if(requirePaddingManipulation) {
            for(var i = 0; i < nodesCount; i++) {
                var info = nodeInfos[i];
                ASPx.SetStyles(info.node, { paddingLeft: info.totalPadding }, true);
            }
        }
        for(var i = 0; i < nodesCount; i++) {
            var info = nodeInfos[i];
            var node = info.node;

            info.isTextShortened = node.scrollWidth > node.clientWidth;
            info.hasTitle = ASPx.Attr.GetAttribute(node, "title") !== null;

            if(!info.hasTitle || reassingExistingTooltips)
                info.title = ASPx.GetEllipsisTooltipText(node);
        }
        for(var i = 0; i < nodesCount; i++) {
            var info = nodeInfos[i];
            var node = info.node;

            if(info.isTextShortened && info.title) {
                ASPx.Attr.SetAttribute(node, "title", info.title);
                ASPx.Attr.SetAttribute(node, ELLIPSIS_TOOLTIP_MARKER_ATTR, true);
            }
            if(!info.isTextShortened && info.hasTitle)
                ASPx.Attr.RemoveAttribute(node, "title");
        }
        if(requirePaddingManipulation) {
            for(var i = 0; i < nodesCount; i++) {
                var info = nodeInfos[i];
                var node = info.node;
                node.style.paddingLeft = info.paddingLeft;
            }
        }
    },
    GetEllipsisNodes: function(element) {
        var ellipsibleNodes = ASPx.Data.CollectionToArray(ASPx.GetNodesByClassName(element, ELLIPSIS_MARKER_CLASS));
        if(ASPx.ElementHasCssClass(element, ELLIPSIS_MARKER_CLASS))
            ellipsibleNodes.push(element);
        return ellipsibleNodes.filter(function(node) {
            return !ASPx.Attr.IsExistsAttribute(node, "title") || ASPx.Attr.IsExistsAttribute(node, ELLIPSIS_TOOLTIP_MARKER_ATTR);
        });
    },
    RequireAssignTooltips: function() {
        return this.enableEllipsis && !ASPx.Browser.MobileUI;
    },
    RemoveEllipsisFromNode: function(node) {
        ASPx.RemoveClassNameFromElement(node, ELLIPSIS_MARKER_CLASS);
        this.RemoveEllipsisTooltip(node);
    },
    RemoveEllipsisTooltip: function(node) {
        if(ASPx.Attr.IsExistsAttribute(node, ELLIPSIS_TOOLTIP_MARKER_ATTR)) {
            ASPx.Attr.RemoveAttribute(node, "title");
            ASPx.Attr.RemoveAttribute(node, ELLIPSIS_TOOLTIP_MARKER_ATTR);
        }
    },
    OnBrowserWindowResize: function(e) {
    },
	OnBrowserWindowResizeInternal: function(e){
        if(this.BrowserWindowResizeSubscriber()) 
            this.OnBrowserWindowResize(e);
    },
    BrowserWindowResizeSubscriber: function() {
        return this.widthValueSetInPercentage || !this.IsAdjusted();
    },
    ShrinkWrappedText: function(getElements, key, reCorrect) {
        if(!ASPx.Browser.Safari) return;
       
        var elements = ASPx.CacheHelper.GetCachedElements(this, key, getElements, this.wrappedTextContainers);
        for(var i = 0; i < elements.length; i++)
            this.ShrinkWrappedTextInContainer(elements[i], reCorrect);
    },
    ShrinkWrappedTextInContainer: function(container, reCorrect) {
        if(!ASPx.Browser.Safari || !container || (container.dxWrappedTextShrinked && !reCorrect) || container.offsetWidth === 0) return;

        ASPx.ShrinkWrappedTextInContainer(container);
        container.dxWrappedTextShrinked = true;
    },
    CorrectWrappedText: function(getElements, key, reCorrect) {
        var elements = ASPx.CacheHelper.GetCachedElements(this, key, getElements, this.wrappedTextContainers);
        for(var i = 0; i < elements.length; i++)
            this.CorrectWrappedTextInContainer(elements[i], reCorrect);
    },
    CorrectWrappedTextInContainer: function(container, reCorrect) {
        if(!container || (container.dxWrappedTextCorrected && !reCorrect) || container.offsetWidth === 0) return;

        ASPx.AdjustWrappedTextInContainer(container);
        container.dxWrappedTextCorrected = true;
    },
    CorrectVerticalAlignment: function(alignMethod, getElements, key, reAlign) {
        var elements = ASPx.CacheHelper.GetCachedElements(this, key, getElements, this.verticalAlignedElements);
        for(var i = 0; i < elements.length; i++)
            this.CorrectElementVerticalAlignment(alignMethod, elements[i], reAlign);
    },
    CorrectElementVerticalAlignment: function(alignMethod, element, reAlign) {
        if(!element || (element.dxVerticalAligned && !reAlign) || element.offsetHeight === 0) return;

        alignMethod(element);
        element.dxVerticalAligned = true;
    },
    ClearVerticalAlignedElementsCache: function() {
        ASPx.CacheHelper.DropCache(this.verticalAlignedElements);
    },
    ClearWrappedTextContainersCache: function() {
        ASPx.CacheHelper.DropCache(this.wrappedTextContainers);
    },
    AdjustPagerControls: function() {
        if(typeof(ASPx.GetPagersCollection) != "undefined")
            ASPx.GetPagersCollection().AdjustControls(this.GetMainElement());
    },
    
    RegisterInControlTree: function(tree) {
        var mainElement = this.GetMainElement();
        if(mainElement && mainElement.id)
            tree.createNode(mainElement.id, this);
    },

    GetItemElementName: function(element) {
        var name = "";
        if(element.id)
            name = element.id.substring(this.name.length + 1);
        return name;
    },
    GetLinkElement: function(element) {
        if(element == null) return null;
        return (element.tagName == "A") ? element : ASPx.GetNodeByTagName(element, "A", 0);
    },
    GetInternalHyperlinkElement: function(parentElement, index) {
        var element = ASPx.GetNodeByTagName(parentElement, "A", index);
        if(element == null) 
            element = ASPx.GetNodeByTagName(parentElement, "SPAN", index);
        return element;
    },

    OnControlClick: function(clickedElement, htmlEvent) {

    }
});

/*# public static ASPxClientControl Cast(object obj){ return null; } #*/ 
ASPxClientControl.Cast = function(obj) {
    if(typeof obj == "string")
        return window[obj];
    return obj;
};
/*# public static void AdjustControls(){ } #*/ 
/*# public static void AdjustControls(object container){ } #*/ 
ASPxClientControl.AdjustControls = function(container, collapseControls){
    aspxGetControlCollection().AdjustControls(container, collapseControls);
};
/*# public static ASPxClientControlCollection GetControlCollection(){return null;} #*/
ASPxClientControl.GetControlCollection = function(){
    return aspxGetControlCollection();
};

ASPxClientControl.LeadingAfterInitCallConsts = {
    None: 0,
    Direct: 1,
    Reverse: 2
};

var ASPxClientComponent = ASPx.CreateClass(ASPxClientControl, {
    constructor: function (name) {
        this.constructor.prototype.constructor.call(this, name);
    },
    IsDOMDisposed: function() { 
        return false;
    }
});

/*# public delegate bool ASPxClientControlPredicate(object control); #*/
/*# public delegate void ASPxClientControlAction(object control); #*/

/*# public class ASPxClientControlCollection: JavaScriptObject #*/
var ASPxClientControlCollection = ASPx.CreateClass(ASPx.CollectionBase, {
    constructor: function(){
        this.constructor.prototype.constructor.call(this);

        this.prevWndWidth = "";
        this.prevWndHeight = "";

        this.requestCountInternal = 0; // for testCafe tests only

        this.BeforeInitCallback = new ASPxClientEvent();
        /*# public event ASPxClientControlsInitializedEventHandler ControlsInitialized { add{} remove{} } #*/
        this.ControlsInitialized = new ASPxClientEvent();
        /*# public event ASPxClientEventHandler BrowserWindowResized { add{} remove{} } #*/
        this.BrowserWindowResized = new ASPxClientEvent();
        this.BrowserWindowResizedInternal = new ASPxClientEvent();

        /*# public event ASPxClientGlobalBeginCallbackEventHandler BeginCallback { add{} remove{} }#*/
        this.BeginCallback = new ASPxClientEvent();
        /*# public event ASPxClientGlobalEndCallbackEventHandler EndCallback { add{} remove{} }#*/
        this.EndCallback = new ASPxClientEvent();
        /*# public event ASPxClientGlobalCallbackErrorEventHandler CallbackError { add{} remove{} }#*/
        this.CallbackError = new ASPxClientEvent();
        /*# public event ASPxClientValidationCompletedEventHandler ValidationCompleted { add{} remove{} }#*/
        this.ValidationCompleted = new ASPxClientEvent();

        aspxGetControlCollectionCollection().Add(this);
    },
    
    Add: function(element) {
        var existsElement = this.Get(element.name);
        if(existsElement && existsElement !== element) 
            this.Remove(existsElement);

        ASPx.CollectionBase.prototype.Add.call(this, element.name, element);
    },
    Remove: function(element) {
        if(element && element instanceof ASPxClientControl && !element.IsDisposed())
            element.OnDispose();

        ASPx.CollectionBase.prototype.Remove.call(this, element.name);
    },
    GetGlobal: function(name) {
        var result = window[name];
        return result && Ident.IsASPxClientControl(result)
            ? result
            : null;
    },
    /*# [Obsolete("Use the GetByName method instead.")]public object Get(object name){return null;} #*/    
    /*# public object GetByName(string name){return null;} #*/    
    GetByName: function(name){
        return this.Get(name) || this.GetGlobal(name);
    },
    GetCollectionType: function(){
        return ASPxClientControlCollection.BaseCollectionType;
    },
    /*# public object[] GetControlsByPredicate(ASPxClientControlPredicate predicate){ return new object[] { };} #*/ 
    GetControlsByPredicate: function(predicate) {
        var result = [];
        this.ForEachControl(function(control) {
            if(!predicate || predicate(control))
                result.push(control);
        });
        return result;
    },
    /*# public object[] GetControlsByType(object type){ return new object[] { };} #*/ 
    GetControlsByType: function(type) {
        return this.GetControlsByPredicate(function(control) { 
            return type && (control instanceof type);
        });
    },
    /*# public void ForEachControl(ASPxClientControlAction action){ } #*/
    ForEachControl: function(action, context) {
        context = context || this;
        this.elementsMap.forEachEntry(function(name, control) {
            if(Ident.IsASPxClientControl(control) && (!this.filterPredicate || this.filterPredicate(control)))
                return action.call(context, control);
        }, context);
    },

    ProcessActionByPredicate: function(action, predicate) {
        try {
            this.filterPredicate = predicate;
            action(this);
        }
        finally {
            this.filterPredicate = null;
        }
    },

    adjustControlsInternal: function(container, context, collapseControls, adjustFunc) {
        context = context || this;
        var func = function(control) {
            adjustFunc.call(context, control);
        };
        ASPx.GetControlAdjuster().adjustControlsInHierarchy(this, func, container, collapseControls);
    },
    
    // controls group operations
    AdjustControls: function(container, collapseControls) {
        container = container || null;
        window.setTimeout(function() {
            this.AdjustControlsCore(container, collapseControls);
        }.aspxBind(this), 0);
    },
    AdjustControlsCore: function(container, collapseControls) {
        var adjustFunction = function(control) { control.AdjustControl(); };
        this.adjustControlsInternal(container, this, collapseControls, adjustFunction);
    },
    CollapseControls: function(container) {
        this.ProcessControlsInContainer(container, function(control) {
            if(control.isASPxClientEdit)
                control.CollapseEditor();
            else if(!!window.ASPxClientRibbon && control instanceof ASPxClientRibbon)
                control.CollapseControl();
        });
    },
    
    AtlasInitialize: function(isCallback) {
        this.ForEachControl(function(control) {
            control.AtlasPreInitialize();
        });

        ASPx.ProcessScriptsAndLinks("", isCallback);

        this.ForEachControl(function(control) {
            control.AtlasInitialize();
        });
    },
    DOMContentLoaded: function() {
        this.ForEachControl(function(control){
             control.DOMContentLoaded();
        });
    },
    OnDocumentUnload: function() {
        this.ForEachControl(function(control) {
            control.RaiseUnload();
        });
    },
    Initialize: function() {
        ASPx.GetPostHandler().Post.AddHandler(
            function(s, e) { this.OnPost(e); }.aspxBind(this)
        );
        ASPx.GetPostHandler().PostFinalization.AddHandler(
            function(s, e) { this.OnPostFinalization(e); }.aspxBind(this)
        );

        this.InitializeElements(false /* isCallback */);
        if(typeof(Sys) != "undefined" && typeof(Sys.Application) != "undefined") {
            var checkIsInitialized = function() {
                if(Sys.Application.get_isInitialized())
                    Sys.Application.add_load(aspxCAInit);
                else
                    setTimeout(checkIsInitialized, 0);
            };
            checkIsInitialized();
        }
        this.InitWindowSizeCache();
    },
    FinalizeInitialization: function() {
        this.ForEachControl(function(control) {
            control.FinalizeInitialization();
        });
    },
    InitializeElements: function(isCallback) {
        this.ForEachControl(function(control){
            if(!control.isInitialized)
                control.Initialize();
        });
        
        this.AfterInitializeElementsLeadingCall();
        this.AfterInitializeElements();
        this.RaiseControlsInitialized(isCallback);
    },
    AfterInitializeElementsLeadingCall: function() {
        var controls = {};
        controls[ASPxClientControl.LeadingAfterInitCallConsts.Direct] = [];
        controls[ASPxClientControl.LeadingAfterInitCallConsts.Reverse] = [];
        
        this.ForEachControl(function(control) {
            if(control.leadingAfterInitCall != ASPxClientControl.LeadingAfterInitCallConsts.None && !control.isInitialized)
                controls[control.leadingAfterInitCall].push(control);
        });

        var directInitControls = controls[ASPxClientControl.LeadingAfterInitCallConsts.Direct],
            reverseInitControls = controls[ASPxClientControl.LeadingAfterInitCallConsts.Reverse];
        
        for(var i = 0, control; control = directInitControls[i]; i++)
            control.AfterInitialize();
        for(var i = reverseInitControls.length - 1, control; control = reverseInitControls[i]; i--)
            control.AfterInitialize();
    },
    AfterInitializeElements: function() {
        this.ForEachControl(function(control) {
            if(control.leadingAfterInitCall == ASPxClientControl.LeadingAfterInitCallConsts.None && !control.isInitialized)
                control.AfterInitialize();
        });
        ASPx.RippleHelper.Init();
    },
    DoFinalizeCallback: function() {
        this.ForEachControl(function(control){
            control.DoFinalizeCallback();
        });
    },
    ProcessControlsInContainer: function(container, processFunc, filterFunc) {
        this.ForEachControl(function(control){
            if((!filterFunc || filterFunc(control)) && (!container || this.IsControlInContainer(container, control)))
                processFunc(control);
        });
    },
    IsControlInContainer: function(container, control) {
        if(control.GetMainElement) {
            var mainElement = control.GetMainElement();
            if(mainElement && (mainElement != container)) {
                if(ASPx.GetIsParent(container, mainElement))
                    return true;
            }
        }
        return false;
    },
    RaiseControlsInitialized: function(isCallback) {
        if(typeof(isCallback) == "undefined")
            isCallback = true;
        var args = new ASPxClientControlsInitializedEventArgs(isCallback);
        if(!this.ControlsInitialized.IsEmpty())        
            this.ControlsInitialized.FireEvent(this, args);

        this.ForEachControl(function(control){
            control.OnGlobalControlsInitialized(args);
        });
    },
    RaiseBrowserWindowResized: function() {
        var args = new ASPxClientEventArgs();
        if(!this.BrowserWindowResized.IsEmpty())
            this.BrowserWindowResized.FireEvent(this, args);

        this.ForEachControl(function(control){
            control.OnGlobalBrowserWindowResized(args);
        });
    },
    RaiseBrowserWindowResizedInternal: function(eventInfo) {
        var args = new ASPxClientBrowserWindowResizedInternalEventArgs(eventInfo);
        if(!this.BrowserWindowResizedInternal.IsEmpty())
            this.BrowserWindowResizedInternal.FireEvent(this, args);
    },
    RaiseBeginCallback: function (control, command) {
        var args = new ASPxClientGlobalBeginCallbackEventArgs(control, command);
        if(!this.BeginCallback.IsEmpty())
            this.BeginCallback.FireEvent(this, args);

        this.ForEachControl(function(control){
            control.OnGlobalBeginCallback(args);
        });
        this.IncrementRequestCount();
    },
    RaiseEndCallback: function (control) {
        var args = new ASPxClientGlobalEndCallbackEventArgs(control);
        if (!this.EndCallback.IsEmpty()) 
            this.EndCallback.FireEvent(this, args);
        
        this.ForEachControl(function(control){
            control.OnGlobalEndCallback(args);
        });
        this.DecrementRequestCount();
    },
    InCallback: function() {
        return this.requestCountInternal > 0;
    },
    RaiseCallbackError: function (control, message, callbackId) {
        var args = new ASPxClientGlobalCallbackErrorEventArgs(control, message, callbackId);
        if (!this.CallbackError.IsEmpty()) 
            this.CallbackError.FireEvent(this, args);
        
        this.ForEachControl(function(control){
            control.OnGlobalCallbackError(args);
        });

        if(args.handled)
            return { isHandled: true, errorMessage: args.message };        
        return { isHandled: false, errorMessage: message };
    },
    RaiseValidationCompleted: function (container, validationGroup, invisibleControlsValidated, isValid, firstInvalidControl, firstVisibleInvalidControl) {
        var args = new ASPxClientValidationCompletedEventArgs(container, validationGroup, invisibleControlsValidated, isValid, firstInvalidControl, firstVisibleInvalidControl);
        if (!this.ValidationCompleted.IsEmpty()) 
            this.ValidationCompleted.FireEvent(this, args);

        this.ForEachControl(function(control){
            control.OnGlobalValidationCompleted(args);
        });
        return args.isValid;
    },
    Before_WebForm_InitCallback: function(callbackOwnerID){
        var args = new BeforeInitCallbackEventArgs(callbackOwnerID);
        this.BeforeInitCallback.FireEvent(this, args);
    },
    
    InitWindowSizeCache: function(){
        this.prevWndWidth = ASPx.GetDocumentClientWidth();
        this.prevWndHeight = ASPx.GetDocumentClientHeight();
    },
    OnBrowserWindowResize: function(evt){
        var shouldIgnoreNestedEvents = ASPx.Browser.IE && ASPx.Browser.MajorVersion == 8;
        if(shouldIgnoreNestedEvents) {
            if(this.prevWndWidth === "" || this.prevWndHeight === "" || this.browserWindowResizeLocked)
                return;
            this.browserWindowResizeLocked = true;
        }
        this.OnBrowserWindowResizeCore(evt);
        if(shouldIgnoreNestedEvents)
            this.browserWindowResizeLocked = false;
    },
    OnBrowserWindowResizeCore: function(htmlEvent){
        var args = this.CreateOnBrowserWindowResizeEventArgs(htmlEvent);
        if(this.CalculateIsBrowserWindowSizeChanged()) {
            this.RaiseBrowserWindowResizedInternal(args);
            this.adjustControlsInternal(null, this, true, function(control) {
                if(control.IsDOMInitialized())
                    control.OnBrowserWindowResizeInternal(args);
            });
            this.RaiseBrowserWindowResized();
        }
    },
    CreateOnBrowserWindowResizeEventArgs: function(htmlEvent) {
        
        return {
            htmlEvent: htmlEvent,
            wndWidth: ASPx.GetDocumentClientWidth(),
            wndHeight: ASPx.GetDocumentClientHeight(),
            prevWndWidth: this.prevWndWidth,
            prevWndHeight: this.prevWndHeight,
            virtualKeyboardShownOnAndroid: this.IsVirtualKeyboardShownOnAndroid()
        };
    },
    IsVirtualKeyboardShownOnAndroid: function() {
        if(!ASPx.Browser.AndroidMobilePlatform)
            return false;

        var documentClientWidth = ASPx.GetDocumentClientWidth();
        var documentClientHeight = ASPx.GetDocumentClientHeight();

        var isDocumentClientHeightChangedOnly = documentClientWidth === this.prevWndWidth && documentClientHeight !== this.prevWndHeight;
        return isDocumentClientHeightChangedOnly && this.IsElementSupportKeyboardInput(document.activeElement);
    },
    IsElementSupportKeyboardInput: function(element) {
        if(!element || !element.tagName)
            return false;

        var supportedKeyboardInputTagNames = ["INPUT", "TEXTAREA"];
        return supportedKeyboardInputTagNames.indexOf(element.tagName) !== -1;
    },
    CalculateIsBrowserWindowSizeChanged: function(){
        var wndWidth = ASPx.GetDocumentClientWidth();
        var wndHeight = ASPx.GetDocumentClientHeight();
        var isBrowserWindowSizeChanged = (this.prevWndWidth != wndWidth) || (this.prevWndHeight != wndHeight);
        if(isBrowserWindowSizeChanged){
            this.prevWndWidth = wndWidth;
            this.prevWndHeight = wndHeight;
            return true;
        }
        return false;
    },
    OnPost: function(args){
        this.ForEachControl(function(control) {
            control.OnPost(args);
        }, null);
    },
    OnPostFinalization: function(args){
        this.ForEachControl(function(control) {
            control.OnPostFinalization(args);
        }, null);
    },
    IncrementRequestCount: function() {
        this.requestCountInternal++;
    },
    DecrementRequestCount: function() {
        this.requestCountInternal--;
    },
    ResetRequestCount: function() {
        this.requestCountInternal = 0;
    }
});
ASPxClientControlCollection.BaseCollectionType = "Control";

var controlCollection = null;
function aspxGetControlCollection(){
    if(controlCollection == null) {
        controlCollection = new ASPxClientControlCollection();
        if(ASPx.loadControlCollectionPreloadHandlers)
            ASPx.loadControlCollectionPreloadHandlers(controlCollection);
    }
    return controlCollection;
}

var ControlCollectionCollection = ASPx.CreateClass(ASPx.CollectionBase, {
    constructor: function(){
        this.constructor.prototype.constructor.call(this);
    },
    Add: function(element) {
        var key = element.GetCollectionType();
        if(!key) throw "The collection type isn't specified.";
        if(this.Get(key)) throw "The collection with type='" + key + "' already exists.";

        ASPx.CollectionBase.prototype.Add.call(this, key, element);
    },
    RemoveDisposedControls: function(){
        var baseCollection = this.Get(ASPxClientControlCollection.BaseCollectionType);
        var disposedControls = [];
        baseCollection.elementsMap.forEachEntry(function(name, control) {
            if(!ASPx.Ident.IsASPxClientControl(control)) return;

            if(control.IsDOMDisposed())
                disposedControls.push(control);
        });
        this.RemoveControls(disposedControls);
    },
    RemoveControls: function(controls){
        for(var i = 0; i < controls.length; i++) {
            /* jshint ignore:start */
            this.elementsMap.forEachEntry(function(key, collection) {
                if(ASPx.Ident.IsASPxClientCollection(collection))
                    collection.Remove(controls[i]);
            });
            /* jshint ignore:end */
        }
    }
});

var controlCollectionCollection = null;
function aspxGetControlCollectionCollection(){
    if(controlCollectionCollection == null)
        controlCollectionCollection = new ControlCollectionCollection();
    return controlCollectionCollection;
}

var AriaDescriptionAttributes = {
    Role: "0",
    AriaLabel: "1",
    TabIndex: "2",
    AriaOwns: "3",
    AriaDescribedBy: "4",
    AriaDisabled: "5",
    AriaHasPopup: "6",
    AriaLevel: "7"
};
var AriaDescriptor = ASPx.CreateClass(null, {
    constructor: function(ownerControl, description) {
        this.ownerControl = ownerControl;
        this.rootElement = ownerControl.GetMainElement();
        this.description = description;
    },
    setDescription: function(name, argList) {
        var description = this.findChildDescription(name);
        if(description) {
            var elements = name ? this.rootElement.querySelectorAll(this.getDescriptionSelector(description)) : [this.rootElement];
            for(var i = 0; i < elements.length; i++)
                this.applyDescriptionToElement(elements[i], description, argList[i] || argList[0]);
        }
    },
    getDescriptionName: function(description) {
        return description.n;
    },
    getDescriptionSelector: function(description) {
        return description.s;
    },
    findChildDescription: function(name) {
        if(name === this.getDescriptionName(this.description))
            return this.description;
        var childCollection = this.description.c || [];
        for(var i = 0; i < childCollection.length; i++) {
            var childDescription = childCollection[i];
            if(this.getDescriptionName(childDescription) === name)
                return childDescription;
        }
        return null;
    },
    applyDescriptionToElement: function(element, description, args) {
        if(!description || !element)
            return;
        this.trySetAriaOwnsAttribute(element, description);
        this.trySetAriaDescribedByAttribute(element, description);
        this.trySetAttribute(element, description, AriaDescriptionAttributes.Role, "role");
        this.trySetAttribute(element, description, AriaDescriptionAttributes.TabIndex, "tabindex");
        this.trySetAttribute(element, description, AriaDescriptionAttributes.AriaLevel, "aria-level");
        this.executeOnDescription(description, AriaDescriptionAttributes.AriaLabel, function(value) {
            ASPx.Attr.SetAttribute(element, "aria-label", ASPx.Str.ApplyReplacement(value, args));
        });
        this.executeOnDescription(description, AriaDescriptionAttributes.AriaDisabled, function(value) {
            ASPx.Attr.SetAttribute(element, "aria-disabled", !!value);    
        });
        this.executeOnDescription(description, AriaDescriptionAttributes.AriaHasPopup, function(value) {
            ASPx.Attr.SetAttribute(element, "aria-haspopup", !!value);
        });
    },
    trySetAriaDescribedByAttribute: function(element, description) {
        this.executeOnDescription(description, AriaDescriptionAttributes.AriaDescribedBy, function(selectorInfo) {
            var descriptor = this.getNodesBySelector(element, selectorInfo.descriptorSelector)[0];
            var target = this.getNodesBySelector(element, selectorInfo.targetSelector)[0];
            if(!target || !descriptor)
                return;
            ASPx.Attr.SetAttribute(target, "aria-describedby", this.getNodeId(descriptor));
        });
    },
    trySetAriaOwnsAttribute: function(element, description) {
        this.executeOnDescription(description, AriaDescriptionAttributes.AriaOwns, function(selector) {
            var ownedNodes = this.getNodesBySelector(element, selector);
            var ariaOwnsAttributeValue = "";
            for(var i = 0; i < ownedNodes.length; i++)
                ariaOwnsAttributeValue += (this.getNodeId(ownedNodes[i]) + (i != ownedNodes.length - 1 ? " " : ""));
            ASPx.Attr.SetAttribute(element, "aria-owns", ariaOwnsAttributeValue);
        });
    },
    trySetAttribute: function(element, description, ariaAttribute, attributeName) {
        this.executeOnDescription(description, ariaAttribute, function(value) { 
            ASPx.Attr.SetAttribute(element, attributeName, description[ariaAttribute]); 
        });
    },
    executeOnDescription: function(description, ariaDescAttr, callback) {
        var descInfo = description[ariaDescAttr];
        if(ASPx.IsExists(descInfo))
            callback.aspxBind(this)(descInfo);
    },
    getNodesBySelector: function(element, selector) {
        var id = element.id || "";
        var childNodes = element.querySelectorAll("#" + this.getNodeId(element) + " > " + selector);
        ASPx.Attr.SetOrRemoveAttribute(element, "id", id);
        return childNodes;
    },
    getNodeId: function(node) {
        if(!node.id)
            node.id = this.createRandomId();
        return node.id; 
    },
    createRandomId: function() {
        return "r" + ASPx.CreateGuid();
    }
});

PagerCommands = {
    Next : "PBN",
    Prev : "PBP",
    Last : "PBL",
    First : "PBF",
    PageNumber : "PN",
    PageSize : "PSP"
};
ASPx.callbackProcessed = false;

ASPx.Callback = function(result, context){    
    var collection = aspxGetControlCollection();
    collection.DoFinalizeCallback();
    var control = collection.Get(context);
    if(control != null)
        control.DoCallback(result);
    ASPx.RippleHelper.ReInit();
    ASPx.callbackProcessed = true;
};
ASPx.CallbackError = function(result, context){
    var control = aspxGetControlCollection().Get(context);
    if(control != null)
        control.DoCallbackError(result, false);
    ASPx.callbackProcessed = true;
};

ASPx.CClick = function(name, evt) {
    var control = aspxGetControlCollection().Get(name);
    if(control != null) control.DoControlClick(evt);
};

function aspxCAInit() {
    var isAppInit = typeof(Sys$_Application$initialize) != "undefined" &&
        ASPx.FunctionIsInCallstack(arguments.callee, Sys$_Application$initialize, 10 /* depthLimit */);
    aspxGetControlCollection().AtlasInitialize(!isAppInit);
}

ASPx.Evt.AttachEventToElement(window, "resize", aspxGlobalWindowResize);
function aspxGlobalWindowResize(evt){
    aspxGetControlCollection().OnBrowserWindowResize(evt);    
}

ASPx.Evt.AttachEventToElement(window, "unload", aspxClassesUnload);
function aspxClassesUnload(evt) {
    aspxGetControlCollection().OnDocumentUnload();
}

ASPx.attachToLoad(aspxClassesDOMContentLoaded);
function aspxClassesDOMContentLoaded(evt){
    aspxGetControlCollection().DOMContentLoaded();
}

ASPx.GetControlCollection = aspxGetControlCollection;
ASPx.GetControlCollectionCollection = aspxGetControlCollectionCollection;
ASPx.GetPersistentControlPropertiesStorage = _aspxGetPersistentControlPropertiesStorage;
ASPx.PagerCommands = PagerCommands;
ASPx.ELLIPSIS_MARKER_CLASS = ELLIPSIS_MARKER_CLASS;

window.ASPxClientBeginCallbackEventArgs = ASPxClientBeginCallbackEventArgs;
window.ASPxClientGlobalBeginCallbackEventArgs = ASPxClientGlobalBeginCallbackEventArgs;
window.ASPxClientEndCallbackEventArgs = ASPxClientEndCallbackEventArgs;
window.ASPxClientGlobalEndCallbackEventArgs = ASPxClientGlobalEndCallbackEventArgs;
window.ASPxClientCallbackErrorEventArgs = ASPxClientCallbackErrorEventArgs;
window.ASPxClientGlobalCallbackErrorEventArgs = ASPxClientGlobalCallbackErrorEventArgs;
window.ASPxClientCustomDataCallbackEventArgs = ASPxClientCustomDataCallbackEventArgs;
window.ASPxClientValidationCompletedEventArgs = ASPxClientValidationCompletedEventArgs;
window.ASPxClientControlsInitializedEventArgs = ASPxClientControlsInitializedEventArgs;
window.ASPxClientControlBeforePronounceEventArgs = ASPxClientControlBeforePronounceEventArgs;
window.ASPxClientControlUnloadEventArgs = ASPxClientControlUnloadEventArgs;
window.ASPxClientEndFocusEventArgs = ASPxClientEndFocusEventArgs;
window.ASPxClientItemFocusedEventArgs = ASPxClientItemFocusedEventArgs;

window.ASPxClientControlCollection = ASPxClientControlCollection;
window.ASPxClientControlBase = ASPxClientControlBase;
window.ASPxClientControl = ASPxClientControl;
window.ASPxClientComponent = ASPxClientComponent;


})(ASPx);

/// <reference path="_references.js"/>

/*# namespace DevExpress.Web.Scripts #*/
(function() {
    /*# public enum ASPxClientOfficeDocumentLinkType #*/
    var ASPxClientOfficeDocumentLinkType = {
        /*# Hyperlink = 0, #*/
        Hyperlink: 0,
        /*# Bookmark = 1, #*/
        Bookmark: 1,
        /*# EmailAddress = 2, #*/
        EmailAddress: 2,
        /*# Document = 3 #*/
        Document: 3
    };

    var OfficeWorkSessionIDInputHelper = {
        InputName: "ASPxOfficeWorkSessionID",
        
        SetValue: function(value){
            for(var i = 0; i < document.forms.length; i++){
                var inputElement = document.forms[i][this.InputName];
                if(!inputElement)
                    inputElement = this.CreateInputElementCore(document.forms[i]);
                inputElement.value = value;
            }
        },
        CreateInputElementCore: function(form){
            var inputElement = ASPx.CreateHiddenField(this.InputName, this.InputName);
            form.appendChild(inputElement);
            return inputElement;
        }

    };

    var PDFPluginHelper = {
        IsInstalled: function() {
            return !!this.GetPDFPlugin();
        },
        GetPDFPlugin: function() {
            if(!this.plugin)
                this.plugin = ASPx.Browser.IE ? this.getActiveXObject("AcroPDF.PDF") || this.getActiveXObject("PDF.PdfCtrl") :
                    this.getNavigatorPlugin("Adobe Acrobat") || this.getNavigatorPlugin("Chrome PDF Viewer") ||
                    this.getNavigatorPlugin("WebKit built-in PDF") || this.getNavigatorPlugin("Chromium PDF Viewer");
            return this.plugin;
        },
        getActiveXObject: function(name) {
            try {
                return new ActiveXObject(name);
            } catch(e) {
                return null;
            }
        },
        getNavigatorPlugin: function(name) {
            var plugins = navigator.plugins;
            for(var key in plugins) {
                if(!plugins.hasOwnProperty(key)) continue;
                var plugin = plugins[key];
                if(plugin.name == name)
                    return plugin;
            }
            return null;
        },
        GetVersion: function() {
            try {
                var plugin = this.GetPDFPlugin();
                if(ASPx.Browser.IE) {
                    var versions = plugin.GetVersions().split(',');
                    var latest = versions[0].split('=');
                    return parseFloat(latest[1]);
                }
                if(plugin.version)
                    return parseInt(plugin.version);
                return plugin.name;
            } catch(e) {
                return null;
            }
        }
    };


    var OfficeHandlerUtils = (function() {
        //var currentHandlerResourceUrl = getHandlerResourceUrl();

        function getHandlerResourceUrl(pageUrl) {
            var url = pageUrl ? pageUrl : document.URL;
            if(url.indexOf("?") != -1)
                url = url.substring(0, url.indexOf("?"));

            if(url.indexOf("#") != -1) //XAF view separator
                url = url.substring(0, url.indexOf("#"));

            if(/.*\.aspx$/.test(url))
                url = url.substring(0, url.lastIndexOf("/") + 1);
            else if(url.lastIndexOf("/") != url.length - 1)
                url += "/";
            return url;
        }

        // Does not work in IE
        //function detectLoginRedirect(originUrl, xmlHttp) {
        //    var hasReturnUrlWithOriginUrl = false;
        //    if(xmlHttp.responseURL) {
        //        var responseURL = xmlHttp.responseURL.toLowerCase();
        //        //var urlChanged = responseURL !== originUrl.toLowerCase();
        //        //var hasReturnUrl = responseURL.indexOf("?returnurl=") >= 0;

        //        var relativeResource = originUrl.replace(currentHandlerResourceUrl, "");
        //        relativeResource = encodeURIComponent("/" + relativeResource).toLowerCase();    

        //        hasReturnUrlWithOriginUrl = responseURL.indexOf("?returnurl=" + relativeResource) >= 0;
        //    }
        //    return hasReturnUrlWithOriginUrl;
        //}

        return {
            getHandlerResourceUrl: getHandlerResourceUrl,
            //detectLoginRedirect: detectLoginRedirect,
        };
    })();

    var OfficeBuffer = {
        isBrowserSupportExtendedClientBuffer: function() {
            return ASPx.Browser.WebKitFamily || (ASPx.Browser.Firefox && ASPx.Browser.MajorVersion >= 50) || (ASPx.Browser.Edge && ASPx.Browser.MajorVersion >= 14);
        },
        isBufferContainText: function(items) {
            if(this.isBrowserSupportExtendedClientBuffer()) {
                var len = items.length;
                while(len--) {
                    if(items[len].type.indexOf("text/plain") >= 0)
                        return true;
                }
            }
            return false;
        },
        getBufferImage: function(items) {
            var len = items.length;
            while(len--) {
                if(items[len].type.indexOf("image") >= 0)
                    return items[len].getAsFile();
            }
            return null;
        }
    };

    var OfficePopupMenuItem = ASPx.CreateClass(null, {
        constructor: function(name, text, parentItem, itemProperties) {
            this.parent = parentItem;
            this.name = name;
            this.text = text;
            this.enabled = true;
            this.imageClassName = "";
            this.navigateUrl = "";
            this.imageUrl = "";
            this.beginGroup = false;
            this.tooltip = "";
            this.target = "";
            this.checked = false;

            this.dropDownMode = false;
            this.clientEnabled = true;
            this.visible = true;
            this.clientVisible = true;
            this.initializeItem(itemProperties);
        },
        GetSubItems: function() {
            return this.items;
        },
        GetItem: function(index) {
            return this.items.Get[index];
        },
        GetItemByName: function(name) {
            return this.items.GetByName(name);
        },
        GetItemCount: function() {
            return this.items.GetCount();
        },

        // private methods
        initializeItem: function(itemProperties) {
            if(itemProperties) {
                this.createItemInternal(itemProperties);
                this.items = this.createItems(itemProperties.items);
            } else
                this.items = this.createItems(null);

        },
        createItems: function(itemsFromProperties) {
            return new ASPx.OfficePopupMenuItemCollection(this, itemsFromProperties);
        },
        createItemInternal: function(itemProperties) {
            this.name = itemProperties.name || "";
            if(ASPx.IsExists(itemProperties.text))
                this.text = itemProperties.text;

            if(ASPx.IsExists(itemProperties.imageUrl))
                this.imageUrl = itemProperties.imageUrl;

            if(ASPx.IsExists(itemProperties.imageHottrackSrc))
                this.imageHottrackSrc = itemProperties.imageHottrackSrc;

            if(ASPx.IsExists(itemProperties.imageClassName))
                this.imageClassName = itemProperties.imageClassName;

            if(ASPx.IsExists(itemProperties.navigateUrl))
                this.navigateUrl = itemProperties.navigateUrl;

            if(ASPx.IsExists(itemProperties.beginGroup))
                this.beginGroup = itemProperties.beginGroup;

            if(ASPx.IsExists(itemProperties.enabled))
                this.enabled = itemProperties.enabled;

            if(ASPx.IsExists(itemProperties.clientEnabled))
                this.clientEnabled = itemProperties.clientEnabled;

            if(ASPx.IsExists(itemProperties.visible))
                this.visible = itemProperties.visible;

            if(ASPx.IsExists(itemProperties.clientVisible))
                this.clientVisible = itemProperties.clientVisible;

            if(ASPx.IsExists(itemProperties.tooltip))
                this.tooltip = itemProperties.tooltip;

            if(ASPx.IsExists(itemProperties.target))
                this.target = itemProperties.target;

            if(ASPx.IsExists(itemProperties.dropDownMode))
                this.dropDownMode = itemProperties.dropDownMode;

            if(ASPx.IsExists(itemProperties.value))
                this.checked = !!itemProperties.value;

            if(ASPx.IsExists(itemProperties.groupName))
                this.groupName = itemProperties.groupName;

            if(ASPx.IsExists(itemProperties.checked))
                this.checked = itemProperties.checked;

            if(ASPx.IsExists(itemProperties.isSvg))
                this.isSvg = itemProperties.isSvg;
        }
    });

    var OfficePopupMenuItemCollection = ASPx.CreateClass(Array, {
        constructor: function(parent, items) {
            this.constructor.prototype.constructor.call(this);
            this.parent = parent;
            this.initializeItems(items);
        },

        Add: function(item) {
            item.parent = this.parent;
            this.push(item);
        },
        Remove: function(index) {
            ASPx.Data.ArrayRemoveAt(this, index);
        },
        RemoveByName: function(itemName) {
            var index = ASPx.Data.ArrayIndexOf(this, itemName, function(item, name) { return item.name == name; });
            if(index >= 0)
                ASPx.Data.ArrayRemoveAt(this, index);
        },
        Insert: function(index, item) {
            item.parent = this.parent;
            this.splice(index, 0, item);
        },
        GetCount: function() {
            return this.length;
        },
        GetByName: function(itemName) {
            var len = this.GetCount();
            while(len--)
                if(this[len].name === itemName)
                    return this[len];
            return null;
        },
        Get: function(index) {
            return this[index];
        },
        Clear: function() {
            while(this.GetCount())
                this.pop();
        },

        // private methods
        initializeItems: function(items) {
            if(items && items.length) {
                for(var i = 0, item; item = items[i]; i++) {
                    if(!ASPx.IsExists(item.visible) || item.visible == true)
                        this.push(this.createNewItem(item));
                }
            }
        },
        createNewItem: function(item) {
            return new ASPx.OfficePopupMenuItem(item.name, item.text, this.parent, item);
        }
    });

    var OfficeFullScreenUtils = (function() {
        var changedNodes = {};

        function OnFullScreenModeChanging(control, toFullScreen) {
            if(toFullScreen)
                markParentNodes(control);
            else
                unmarkParentNodes(control);
        }
        function markParentNodes(control) {
            var currentNode = control.GetMainElement();
            if(!currentNode) return;

            var mainElementId = currentNode.id;
            
            changedNodes[mainElementId] = [];
            currentNode = currentNode.parentNode;
            while(currentNode && currentNode.tagName != "BODY") {
                ASPx.Attr.ChangeStyleAttribute(currentNode, "transform", "none");
                changedNodes[mainElementId].push(currentNode);
                currentNode = currentNode.parentNode;
            }
        }

        function unmarkParentNodes(control) {
            var currentNode = control.GetMainElement();
            var mainElementId = (currentNode) ? currentNode.id : "";
            while(changedNodes[mainElementId] && changedNodes[mainElementId].length > 0) {
                var element = changedNodes[mainElementId].splice(0, 1);
                ASPx.Attr.RestoreStyleAttribute(element[0], "transform");
            }
        }

        return {
            OnFullScreenModeChanging: OnFullScreenModeChanging
        };
    })();

    ASPx.OfficeWorkSessionIDInputHelper = OfficeWorkSessionIDInputHelper;
    ASPx.PDFPluginHelper = PDFPluginHelper;
    ASPx.OfficeHandlerUtils = OfficeHandlerUtils;
    ASPx.OfficeBuffer = OfficeBuffer;
    ASPx.OfficePopupMenuItem = OfficePopupMenuItem;
    ASPx.OfficePopupMenuItemCollection = OfficePopupMenuItemCollection;
    ASPx.OfficeFullScreenUtils = OfficeFullScreenUtils;

    window.ASPxClientOfficeDocumentLinkType = ASPxClientOfficeDocumentLinkType;
})();
/// <reference path="..\_references.js"/>

/*# namespace DevExpress.Web.Scripts #*/
(function() {
    var constants = {
        InsertTableControlPostfix: "_ITC",
        InsertTableControlTablePostfix: "_ITCT",
        InsertTableControlCaptionPostfix: "_ITCC",

        InsertTableItemClass: "dxitcItem",
        InsertTableItemHoverClass: "dxitcItemHover"
    };

    var InsertTableControlTableInsertedEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
        constructor: function(rowCount, columnCount) {
            this.constructor.prototype.constructor.call(this);
            this.rowCount = rowCount;
            this.columnCount = columnCount;
        }
    });

    var InsertTableControl = ASPx.CreateClass(ASPxClientControl, {
        constructor: function(name) {
            this.constructor.prototype.constructor.call(this, name);

            this.columnCount = null;
            this.rowCount = null;
            this.insertTableText = null;

            this.cells = [];
            this.currentCell = null;
            this.currentX = 0;
            this.currentY = 0;

            this.captionTextNode = null;

            this.TableInserted = new ASPxClientEvent();
        },
        Initialize: function() {
            var caption = this.GetCaptionElement();
            while(caption.firstChild)
                ASPx.RemoveElement(caption.firstChild);
            this.captionTextNode = document.createTextNode('');
            caption.appendChild(this.captionTextNode);

            this.InitializeTable();
            this.InitializeEventHandlers();
            this.ChangeCaption();
            this.InitializeKeyboardHelper();
            ASPxClientControl.prototype.Initialize.call(this);
        },
        InitializeTable: function() {
            var tableElement = this.GetTableElement();
            var table = ASPx.CreateHtmlElement("table");
            this.prepareTableElement(table);
            for(var i = 0; i < this.rowCount; i++) {
                var row = ASPx.CreateHtmlElement("tr");
                table.appendChild(row);
                for(var j = 0; j < this.columnCount; j++) {
                    var cellContainer = ASPx.CreateHtmlElement("td");
                    row.appendChild(cellContainer);
                    this.AddCell(cellContainer, i, j);
                }
            }
            tableElement.appendChild(table);
            if(this.isStateControllerNeeded())
                ASPx.GetStateController().AddHoverItem(tableElement.id, [""], [""], [""], null, null, false);
        },
        isStateControllerNeeded: function() { return true; },
        prepareTableElement: function(table) {},
        InitializeEventHandlers: function() {
            ASPx.Evt.AttachEventToElement(this.GetTableElement(), "mouseup", function(evt) { this.OnTableMouseUp(evt); }.aspxBind(this));
            ASPx.Evt.AttachEventToElement(this.GetTableElement(), "mousemove", function(evt) { this.OnTableMouseMove(evt); }.aspxBind(this));
            ASPx.AddAfterClearHoverState(function(s, e) { this.OnTableMouseOut(e); }.aspxBind(this));
        },
        OnTableMouseUp: function(evt) {
            if(!ASPx.Evt.IsLeftButtonPressed(evt))
                return;
            var cell = this.GetCellByEvent(evt);
            if(cell)
                this.RaiseTableInserted(cell.GetX(), cell.GetY());
        },
        OnTableMouseMove: function(evt) {
            var cell = this.GetCellByEvent(evt);
            if(cell != this.currentCell) {
                this.currentCell = cell;
                this.ChangeSelection();
            }
        },
        OnTableMouseOut: function(evt) {
            if(evt.element == this.GetTableElement() && this.currentCell) {
                this.currentCell = null;
                this.ChangeSelection();
            }
        },
        RaiseTableInserted: function(rowCount, columnCount) {
            if(!this.TableInserted.IsEmpty()) {
                var args = new InsertTableControlTableInsertedEventArgs(rowCount, columnCount);
                this.TableInserted.FireEvent(this, args);
            }
        },
        RaiseRibbonExecCommand: function(ribbonName, ribbonItemName, rowCount, columnCount) {
            var params = {};
            if(rowCount > 0 && columnCount > 0)
                var params = { rowCount: rowCount, cellCount: columnCount };
            var ribbon = ASPx.GetControlCollection().GetByName(ribbonName);
            var item = ribbon.GetItemByName(ribbonItemName);
            item.hidePopup();
            if(params)
                ribbon.onExecCommand(item, params);
        },
        AddCell: function(parentElement, x, y) {
            var cell = new TableCell(this, parentElement, x, y);
            this.cells[cell.id] = cell;
        },
        ChangeSelection: function() {
            var x = this.currentCell ? this.currentCell.GetX() : 0;
            var y = this.currentCell ? this.currentCell.GetY() : 0;

            var minX = Math.min(this.currentX, x);
            var maxX = Math.max(this.currentX, x);
            var minY = Math.min(this.currentY, y);
            var maxY = Math.max(this.currentY, y);

            for(var i = 0; i < minX; i++)
                for(var j = minY; j < maxY; j++)
                    this.ChangeCellClass(i, j, i < x && j < y);
            for(var i = minX; i < maxX; i++)
                for(var j = 0; j < minY; j++)
                    this.ChangeCellClass(i, j, i < x && j < y);
            for(var i = minX; i < maxX; i++)
                for(var j = minY; j < maxY; j++)
                    this.ChangeCellClass(i, j, i < x && j < y);

            this.currentX = x;
            this.currentY = y;

            this.ChangeCaption();
        },
        ChangeCaption: function() {
            var text = this.currentX > 0 ? this.currentX + " x " + this.currentY : this.insertTableText;
            var node = this.captionTextNode;
            ASPx.RequestAnimationFrame(function() {
                node.data = text;
            });
        },
        ChangeCellClass: function(rowIndex, columnIndex, isHover) {
            var element = ASPx.GetElementById(this.name + "_" + rowIndex + "_" + columnIndex);
            var cssClass = this.getInsertTableItemHoverClass();
            ASPx.RequestAnimationFrame(function() {
                ASPx.ToggleClassNameToElement(element, cssClass, isHover);
            });
        },
        getInsertTableItemHoverClass: function() {
            return constants.InsertTableItemHoverClass;
        },
        GetCellByEvent: function(evt) {
            var srcElement = ASPx.Evt.GetEventSource(evt);
            if(!srcElement.id)
                srcElement = ASPx.GetChildByTagName(srcElement, "DIV", 0);
            return srcElement ? this.cells[srcElement.id] : null;
        },
        GetMainElement: function() {
            return ASPx.GetElementById(this.name + constants.InsertTableControlPostfix);
        },
        GetTableElement: function() {
            return ASPx.GetElementById(this.name + constants.InsertTableControlTablePostfix);
        },
        GetCaptionElement: function() {
            return ASPx.GetElementById(this.name + constants.InsertTableControlCaptionPostfix);
        },

        getEnabledCore: function() {
            return true;
        },
        getInsertTableItemClass: function() {
            return constants.InsertTableItemClass;
        },

        // Keyboard Support
        InitializeKeyboardHelper: function() {
            this.keyboardHelper = new ASPxInserTableControlKeyboardHelper(this);
            this.keyboardHelper.Init();
        }
    });

    var TableCell = ASPx.CreateClass(null, {
        constructor: function(owner, parentElement, rowIndex, columnIndex) {
            this.owner = owner;
            this.rowIndex = rowIndex;
            this.columnIndex = columnIndex;
            this.id = owner.name + "_" + rowIndex + "_" + columnIndex;

            this.CreateElement(parentElement);
        },
        CreateElement: function(parentElement) {
            var element = ASPx.CreateHtmlElement();
            element.id = this.id;
            ASPx.AddClassNameToElement(element, this.owner.getInsertTableItemClass());
            parentElement.appendChild(element);
        },
        GetX: function() {
            return this.rowIndex + 1;
        },
        GetY: function() {
            return this.columnIndex + 1;
        }
    });

    var ASPxInserTableControlKeyboardHelper = ASPx.CreateClass(ASPx.KbdHelper, {
        constructor: function(insertTableControl) {
            this.constructor.prototype.constructor.call(this, insertTableControl);
            this.control = insertTableControl;

            this.currenCell = null;
            this.focusedRowIndex = -1;
            this.focusedColumnIndex = -1;
            this.GetCurrentCellIndexes();
        },
        GetFocusableElement: function() {
            return this.control.GetMainElement();
        },
        HandleKeyDown: function(e) {
            switch(ASPx.Evt.GetKeyCode(e)) {
                case ASPx.Key.Left:
                    this.TryMoveFocus("left");
                    return true;
                case ASPx.Key.Right:
                    this.TryMoveFocus("right");
                    return true;
                case ASPx.Key.Up:
                    this.TryMoveFocus("up");
                    return true;
                case ASPx.Key.Down:
                    this.TryMoveFocus("down");
                    return true;
                case ASPx.Key.Enter:
                    this.ProcessEnterKey();
                    return true;
                case ASPx.Key.Esc:
                    this.ClearSelection();
                    this.control.RaiseTableInserted();
                    return true;
            }
            return false;
        },
        ProcessEnterKey: function() {
            var rowIndex = this.focusedRowIndex + 1;
            var columnIndex = this.focusedColumnIndex + 1;
            this.control.RaiseTableInserted(rowIndex, columnIndex);
            this.ClearSelection();
        },

        ReceivedFocus: function() {
            var result = false;
            if(this.focusedRowIndex < 0) {
                this.focusedRowIndex = 0;
                result = true;
            }    
            if(this.focusedColumnIndex < 0) {
                this.focusedColumnIndex = 0;
                result = true;
            }
            if(result)
                this.TryFocusItemByIndex(this.focusedRowIndex, this.focusedColumnIndex);
            return result;
        },
        TryMoveFocus: function(direction) {
            this.GetCurrentCellIndexes();
            if(this.ReceivedFocus()) {
                return;
            }
            var rowIndex = this.focusedRowIndex;
            var columnIndex = this.focusedColumnIndex;
            switch(direction) {
                case "left":
                    columnIndex--;
                    if(columnIndex < 0)
                        columnIndex = 0;
                    this.TryFocusItemByIndex(rowIndex, columnIndex);
                    break;
                case "right":
                    columnIndex++;
                    if(columnIndex >= this.control.columnCount)
                        columnIndex = this.control.columnCount - 1;
                    this.TryFocusItemByIndex(rowIndex, columnIndex);
                    break;
                case "up":
                    rowIndex--;
                    if(rowIndex < 0)
                        rowIndex = 0;
                    this.TryFocusItemByIndex(rowIndex, columnIndex);
                    break;
                case "down":
                    rowIndex++;
                    if(rowIndex >= this.control.rowCount)
                        rowIndex = this.control.rowCount - 1;
                    this.TryFocusItemByIndex(rowIndex, columnIndex);
                    break;
            }
        },
        TryFocusItemByIndex: function(rowIndex, columnIndex) {
            this.focusedRowIndex = rowIndex;
            this.focusedColumnIndex = columnIndex;

            var id = this.control.name + "_" + rowIndex + "_" + columnIndex;
            var element = this.control.cells[id];

            this.control.currentCell = element;
            this.control.ChangeSelection();

            this.GetCurrentCell();
        },

        GetCurrentCell: function() {
            this.currentCell = this.control.currentCell;
        },
        GetCurrentCellIndexes: function() {
            this.GetCurrentCell();
            if(this.currentCell) {
                this.focusedRowIndex = this.currentCell.rowIndex;
                this.focusedColumnIndex = this.currentCell.columnIndex;
            }
            else {
                this.focusedRowIndex = -1;
                this.focusedColumnIndex = -1;
            }
        },
        ClearSelection: function() {
            this.focusedRowIndex = -1;
            this.focusedColumnIndex = -1;
            this.control.currentCell = null;
            this.control.ChangeSelection();
        },

        onBlur: function() {
            ASPx.KbdHelper.prototype.onBlur.call(this);
            this.ClearSelection();
        }
    });

    ASPx.InsertTableControl = InsertTableControl;
})();
window.DevExpress = window.DevExpress || {};

(function () {
    var DefaultLocalization = function(localization) {
        localization.loadMessages({
            'en': {
                'OfficeStringId.Caption_EditHyperlinkForm': 'Edit Hyperlink',
                'OfficeStringId.Caption_EditHyperlinkFormDescription': ' ',
                'OfficeStringId.Caption_InsertHyperlinkForm': 'Insert Hyperlink',
                'OfficeStringId.Caption_InsertHyperlinkFormDescription': ' ',
                'OfficeStringId.Caption_UnitCentimeters': 'Centimeters',
                'OfficeStringId.Caption_UnitInches': 'Inches',
                'OfficeStringId.Caption_UnitMillimeters': 'Millimeters',
                'OfficeStringId.Caption_UnitPercent': 'Percent',
                'OfficeStringId.Caption_UnitPoints': 'Points',
                'OfficeStringId.FileFilterDescription_AllFiles': 'All Files',
                'OfficeStringId.FileFilterDescription_AllSupportedFiles': 'All Supported Files',
                'OfficeStringId.FileFilterDescription_BitmapFiles': 'Windows Bitmap',
                'OfficeStringId.FileFilterDescription_EmfFiles': 'Microsoft Enhanced Metafile',
                'OfficeStringId.FileFilterDescription_GifFiles': 'Graphics Interchange Format',
                'OfficeStringId.FileFilterDescription_JPEGFiles': 'JPEG File Interchange Format',
                'OfficeStringId.FileFilterDescription_PNGFiles': 'Portable Network Graphics',
                'OfficeStringId.FileFilterDescription_TiffFiles': 'Tag Image File Format',
                'OfficeStringId.FileFilterDescription_WmfFiles': 'Windows Metafile',
                'OfficeStringId.MenuCmd_AlignmentCenter': 'Center',
                'OfficeStringId.MenuCmd_AlignmentCenterDescription': 'Center text.',
                'OfficeStringId.MenuCmd_AlignmentJustify': 'Justify',
                'OfficeStringId.MenuCmd_AlignmentJustifyDescription': 'Align text to both left and right margins, adding extra space between words as necessary.This creates a clean look along the left and right side of the page.',
                'OfficeStringId.MenuCmd_AlignmentLeft': 'Align Text Left',
                'OfficeStringId.MenuCmd_AlignmentLeftDescription': 'Align text to the left.',
                'OfficeStringId.MenuCmd_AlignmentRight': 'Align Text Right',
                'OfficeStringId.MenuCmd_AlignmentRightDescription': 'Align text to the right.',
                'OfficeStringId.MenuCmd_ChangeFontColor': 'Font Color',
                'OfficeStringId.MenuCmd_ChangeFontColorDescription': 'Change the text color.',
                'OfficeStringId.MenuCmd_ChangeFontName': 'Font',
                'OfficeStringId.MenuCmd_ChangeFontNameDescription': 'Change the font face.',
                'OfficeStringId.MenuCmd_ChangeFontSize': 'Font Size',
                'OfficeStringId.MenuCmd_ChangeFontSizeDescription': 'Change the font size.',
                'OfficeStringId.MenuCmd_ClearUndo': 'ClearUndo',
                'OfficeStringId.MenuCmd_ClearUndoDescription': 'Clear Undo Buffer',
                'OfficeStringId.MenuCmd_CopySelection': 'Copy',
                'OfficeStringId.MenuCmd_CopySelectionDescription': 'Copy the selection and put it on the Clipboard.',
                'OfficeStringId.MenuCmd_CutSelection': 'Cut',
                'OfficeStringId.MenuCmd_CutSelectionDescription': 'Cut the selection from the document and put it on the Clipboard.',
                'OfficeStringId.MenuCmd_DecreaseFontSize': 'Shrink Font',
                'OfficeStringId.MenuCmd_DecreaseFontSizeDescription': 'Decrease the font size.',
                'OfficeStringId.MenuCmd_DeleteComment': 'Delete',
                'OfficeStringId.MenuCmd_DeleteCommentDescription': 'Delete the selected comment.',
                'OfficeStringId.MenuCmd_EditComment': 'Edit Comment',
                'OfficeStringId.MenuCmd_EditCommentDescription': 'Add a note about this part of the document.',
                'OfficeStringId.MenuCmd_EditHyperlink': 'Edit Hyperlink...',
                'OfficeStringId.MenuCmd_EditHyperlinkDescription': 'Edit Hyperlink...',
                'OfficeStringId.MenuCmd_Encrypt': 'Encrypt with Password',
                'OfficeStringId.MenuCmd_EncryptDescription': 'Require a password to open this workbook.',
                'OfficeStringId.MenuCmd_FloatingObjectBringForward': 'Bring Forward',
                'OfficeStringId.MenuCmd_FloatingObjectBringForwardCommandGroup': 'Bring Forward',
                'OfficeStringId.MenuCmd_FloatingObjectBringForwardCommandGroupDescription': 'Bring the selected object forward one level, or bring it in front of all the other objects.',
                'OfficeStringId.MenuCmd_FloatingObjectBringForwardDescription': 'Bring the selected object forward so that it is hidden by fewer objects that are in front of it.',
                'OfficeStringId.MenuCmd_FloatingObjectBringToFront': 'Bring to Front',
                'OfficeStringId.MenuCmd_FloatingObjectBringToFrontDescription': 'Bring the selected object in front of all other objects so that no part of it is hidden behind other objects.',
                'OfficeStringId.MenuCmd_FloatingObjectSendBackward': 'Send Backward',
                'OfficeStringId.MenuCmd_FloatingObjectSendBackwardCommandGroup': 'Send Backward',
                'OfficeStringId.MenuCmd_FloatingObjectSendBackwardCommandGroupDescription': 'Send the selected object back one level, or send it behind all the other objects.',
                'OfficeStringId.MenuCmd_FloatingObjectSendBackwardDescription': 'Send the selected object backward so that it is hidden by the objects that are in front of it.',
                'OfficeStringId.MenuCmd_FloatingObjectSendToBack': 'Send to Back',
                'OfficeStringId.MenuCmd_FloatingObjectSendToBackDescription': 'Send the selected object behind all other objects.',
                'OfficeStringId.MenuCmd_Hyperlink': 'Hyperlink',
                'OfficeStringId.MenuCmd_HyperlinkDescription': 'Create a link to a Web page, a picture, an e-mail address, or a program.',
                'OfficeStringId.MenuCmd_IncreaseFontSize': 'Grow Font',
                'OfficeStringId.MenuCmd_IncreaseFontSizeDescription': 'Increase the font size.',
                'OfficeStringId.MenuCmd_InsertComment': 'New Comment',
                'OfficeStringId.MenuCmd_InsertCommentDescription': 'Add a note about this part of the document.',
                'OfficeStringId.MenuCmd_InsertFloatingObjectPicture': 'Picture',
                'OfficeStringId.MenuCmd_InsertFloatingObjectPictureDescription': 'Insert a picture from a file.',
                'OfficeStringId.MenuCmd_InsertHyperlink': 'Hyperlink...',
                'OfficeStringId.MenuCmd_InsertHyperlinkDescription': 'Add a new hyperlink.',
                'OfficeStringId.MenuCmd_InsertSymbol': 'Symbol',
                'OfficeStringId.MenuCmd_InsertSymbolDescription': 'Insert symbols that are not on your keyboard, such as copyright symbols, trademark symbols, paragraph marks and Unicode characters.',
                'OfficeStringId.MenuCmd_LoadDocument': 'Open',
                'OfficeStringId.MenuCmd_LoadDocumentDescription': 'Open a document.',
                'OfficeStringId.MenuCmd_NewEmptyDocument': 'New',
                'OfficeStringId.MenuCmd_NewEmptyDocumentDescription': 'Create a new document.',
                'OfficeStringId.MenuCmd_OpenHyperlink': 'Open Hyperlink',
                'OfficeStringId.MenuCmd_OpenHyperlinkDescription': 'Open Hyperlink',
                'OfficeStringId.MenuCmd_PageMarginsModerate': 'ModerateTop: {1,10} Bottom: {3,10}Left: {0,10} Right:  {2,10}',
                'OfficeStringId.MenuCmd_PageMarginsModerateDescription': ' ',
                'OfficeStringId.MenuCmd_PageMarginsNarrow': 'NarrowTop: {1,10} Bottom: {3,10}Left: {0,10} Right:  {2,10}',
                'OfficeStringId.MenuCmd_PageMarginsNarrowDescription': ' ',
                'OfficeStringId.MenuCmd_PageMarginsNormal': 'NormalTop: {1,10} Bottom: {3,10}Left: {0,10} Right:  {2,10}',
                'OfficeStringId.MenuCmd_PageMarginsNormalDescription': ' ',
                'OfficeStringId.MenuCmd_PageMarginsWide': 'WideTop: {1,10} Bottom: {3,10}Left: {0,10} Right:  {2,10}',
                'OfficeStringId.MenuCmd_PageMarginsWideDescription': ' ',
                'OfficeStringId.MenuCmd_PageOrientationCommandGroup': 'Orientation',
                'OfficeStringId.MenuCmd_PageOrientationCommandGroupDescription': 'Switch the pages between portrait and landscape layouts.',
                'OfficeStringId.MenuCmd_PageOrientationLandscape': 'Landscape',
                'OfficeStringId.MenuCmd_PageOrientationLandscapeDescription': ' ',
                'OfficeStringId.MenuCmd_PageOrientationPortrait': 'Portrait',
                'OfficeStringId.MenuCmd_PageOrientationPortraitDescription': ' ',
                'OfficeStringId.MenuCmd_Paste': 'Paste',
                'OfficeStringId.MenuCmd_PasteDescription': 'Paste the contents of the Clipboard.',
                'OfficeStringId.MenuCmd_Print': 'Print',
                'OfficeStringId.MenuCmd_PrintDescription': 'Select a printer, number of copies, and other printing options before printing.',
                'OfficeStringId.MenuCmd_PrintPreview': 'Print Preview',
                'OfficeStringId.MenuCmd_PrintPreviewDescription': 'Preview pages before printing.',
                'OfficeStringId.MenuCmd_QuickPrint': 'Quick Print',
                'OfficeStringId.MenuCmd_QuickPrintDescription': 'Send the document directly to the default printer without making changes.',
                'OfficeStringId.MenuCmd_Redo': 'Redo',
                'OfficeStringId.MenuCmd_RedoDescription': 'Redo',
                'OfficeStringId.MenuCmd_RemoveHyperlink': 'Remove Hyperlink',
                'OfficeStringId.MenuCmd_RemoveHyperlinkDescription': 'Remove Hyperlink',
                'OfficeStringId.MenuCmd_RemoveHyperlinks': 'Remove Hyperlinks',
                'OfficeStringId.MenuCmd_RemoveHyperlinksDescription': 'Remove Hyperlinks',
                'OfficeStringId.MenuCmd_SaveDocument': 'Save',
                'OfficeStringId.MenuCmd_SaveDocumentAs': 'Save As',
                'OfficeStringId.MenuCmd_SaveDocumentAsDescription': 'Open the Save As dialog box to select a file format and save the document to a new location.',
                'OfficeStringId.MenuCmd_SaveDocumentDescription': 'Save the document.',
                'OfficeStringId.MenuCmd_ShowPasteSpecialForm': 'Paste Special',
                'OfficeStringId.MenuCmd_ShowPasteSpecialFormDescription': 'Show the Paste Special dialog box.',
                'OfficeStringId.MenuCmd_StatusBarPopupMenuHeader': 'Customize Status Bar',
                'OfficeStringId.MenuCmd_StatusBarPopupMenuZoom': 'Zoom',
                'OfficeStringId.MenuCmd_StatusBarPopupMenuZoomSlider': 'Zoom Slider',
                'OfficeStringId.MenuCmd_StatusBarZoomDescription': 'Zoom level. Click to open the Zoom dialog box.',
                'OfficeStringId.MenuCmd_StatusBarZoomSliderDescription': 'Zoom',
                'OfficeStringId.MenuCmd_ToggleFontBold': 'Bold',
                'OfficeStringId.MenuCmd_ToggleFontBoldDescription': 'Make the selected text bold.',
                'OfficeStringId.MenuCmd_ToggleFontDoubleUnderline': 'Double Underline',
                'OfficeStringId.MenuCmd_ToggleFontDoubleUnderlineDescription': 'Double underline',
                'OfficeStringId.MenuCmd_ToggleFontItalic': 'Italic',
                'OfficeStringId.MenuCmd_ToggleFontItalicDescription': 'Italicize the selected text.',
                'OfficeStringId.MenuCmd_ToggleFontStrikeout': 'Strikethrough',
                'OfficeStringId.MenuCmd_ToggleFontStrikeoutDescription': 'Draw a line through the middle of the selected text.',
                'OfficeStringId.MenuCmd_ToggleFontUnderline': 'Underline',
                'OfficeStringId.MenuCmd_ToggleFontUnderlineDescription': 'Underline the selected text.',
                'OfficeStringId.MenuCmd_Undo': 'Undo',
                'OfficeStringId.MenuCmd_UndoDescription': 'Undo',
                'OfficeStringId.MenuCmd_Zoom100Percent': '100%',
                'OfficeStringId.MenuCmd_Zoom100PercentDescription': 'Zoom the document to 100% of the normal size.',
                'OfficeStringId.MenuCmd_ZoomIn': 'Zoom In',
                'OfficeStringId.MenuCmd_ZoomInDescription': 'Zoom In',
                'OfficeStringId.MenuCmd_ZoomOut': 'Zoom Out',
                'OfficeStringId.MenuCmd_ZoomOutDescription': 'Zoom Out',
                'OfficeStringId.Msg_InternalError': 'An internal error occurred',
                'OfficeStringId.Msg_InvalidBeginInit': 'Error: call to BeginInit inside BeginUpdate',
                'OfficeStringId.Msg_InvalidBeginUpdate': 'Error: call to BeginUpdate inside BeginInit',
                'OfficeStringId.Msg_InvalidCopyFromDocumentModel': 'Error: source and destination document models are different',
                'OfficeStringId.Msg_InvalidEndInit': 'Error: call to EndInit or CancelInit without BeginInit or inside BeginUpdate',
                'OfficeStringId.Msg_InvalidEndUpdate': 'Error: call to EndUpdate or CancelUpate without BeginUpdate or inside BeginInit',
                'OfficeStringId.Msg_InvalidFontSize': 'The number must be between {0} and {1}.',
                'OfficeStringId.Msg_InvalidNumber': 'This is not a valid number.',
                'OfficeStringId.Msg_InvalidNumberConverterValue': 'Value must be between {0} and {1}.',
                'OfficeStringId.Msg_InvalidRemoveDataSource': 'A data source cannot be deleted during the mail-merge process.',
                'OfficeStringId.Msg_IsNotValid': '\'{0}\' is not a valid value for \'{1}\'',
                'OfficeStringId.Msg_Loading': 'Loading...',
                'OfficeStringId.Msg_MagicNumberNotFound': 'The file you are trying to open is in different format than specified by the file extension.',
                'OfficeStringId.Msg_UnsupportedFormatOrCorruptedFile': 'Unsupported format or corrupted file.',
                'OfficeStringId.UnitAbbreviation_Centimeter': ' cm',
                'OfficeStringId.UnitAbbreviation_Inch': '\'',
                'OfficeStringId.UnitAbbreviation_Millimeter': ' mm',
                'OfficeStringId.UnitAbbreviation_Percent': '%',
                'OfficeStringId.UnitAbbreviation_Pica': ' pc',
                'OfficeStringId.UnitAbbreviation_Point': ' pt',
                'XtraSpreadsheetCellErrorNameStringId.DivisionByZero': '#DIV/0!',
                'XtraSpreadsheetCellErrorNameStringId.GettingData': '#GETTING_DATA',
                'XtraSpreadsheetCellErrorNameStringId.Name': '#NAME?',
                'XtraSpreadsheetCellErrorNameStringId.NullIntersection': '#NULL!',
                'XtraSpreadsheetCellErrorNameStringId.Number': '#NUM!',
                'XtraSpreadsheetCellErrorNameStringId.Reference': '#REF!',
                'XtraSpreadsheetCellErrorNameStringId.Value': '#VALUE!',
                'XtraSpreadsheetCellErrorNameStringId.ValueNotAvailable': '#N/A',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CountValue1': 'are 1 to 255 arguments that can contain or refer to a variety of different types of data, but only numbers are counted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CountValue2': 'are 1 to 255 arguments that can contain or refer to a variety of different types of data, but only numbers are counted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IfLogicaltest': 'is any value or expression that can be evaluated to TRUE or FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IfValueiftrue': 'is the value that is returned if Logical_test is TRUE. If omitted, TRUE is returned. You can nest up to seven IF functions',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IfValueiffalse': 'is the value that is returned if Logical_test is FALSE. If omitted, FALSE is returned',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IsNAValue': 'is the value you want to test. Value can refer to a cell, a formula, or a name that refers to a cell, formula, or value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IsErrorValue': 'is the value you want to test. Value can refer to a cell, a formula, or a name that refers to a cell, formula, or value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SumNumber1': 'are 1 to 255 numbers to sum. Logical values and text are ignored in cells, included if typed as arguments',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SumNumber2': 'are 1 to 255 numbers to sum. Logical values and text are ignored in cells, included if typed as arguments',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AverageNumber1': 'are 1 to 255 numeric arguments for which you want the average',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AverageNumber2': 'are 1 to 255 numeric arguments for which you want the average',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MinNumber1': 'are 1 to 255 numbers, empty cells, logical values, or text numbers for which you want the minimum',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MinNumber2': 'are 1 to 255 numbers, empty cells, logical values, or text numbers for which you want the minimum',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MaxNumber1': 'are 1 to 255 numbers, empty cells, logical values, or text numbers for which you want the maximum',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MaxNumber2': 'are 1 to 255 numbers, empty cells, logical values, or text numbers for which you want the maximum',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RowReference': 'is the cell or a single range of cells for which you want the row number; if omitted, returns the cell containing the ROW function',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ColumnReference': 'is the cell or range of contiguous cells for which you want the column number. If omitted, the cell containing the COLUMN function is used',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NpvRate': 'is the rate of discount over the length of one period',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NpvValue1': 'are 1 to 254 payments and income, equally spaced in time and occurring at the end of each period',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NpvValue2': 'are 1 to 254 payments and income, equally spaced in time and occurring at the end of each period',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevNumber1': 'are 1 to 255 numbers corresponding to a sample of a population and can be numbers or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevNumber2': 'are 1 to 255 numbers corresponding to a sample of a population and can be numbers or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DollarNumber': 'is a number, a reference to a cell containing a number, or a formula that evaluates to a number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DollarDecimals': 'is the number of digits to the right of the decimal point. The number is rounded as necessary; if omitted, Decimals = 2',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FixedNumber': 'is the number you want to round and convert to text',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FixedDecimals': 'is the number of digits to the right of the decimal point. If omitted, Decimals = 2',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FixedNocommas': 'is a logical value: do not display commas in the returned text = TRUE; do display commas in the returned text = FALSE or omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SinNumber': 'is the angle in radians for which you want the sine. Degrees * PI()/180 = radians',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CosNumber': 'is the angle in radians for which you want the cosine',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TanNumber': 'is the angle in radians for which you want the tangent. Degrees * PI()/180 = radians',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ATanNumber': 'is the tangent of the angle you want',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SqrtNumber': 'is the number for which you want the square root',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ExpNumber': 'is the exponent applied to the base e. The constant e equals 2.71828182845904, the base of the natural logarithm',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LnNumber': 'is the positive real number for which you want the natural logarithm',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Log10Number': 'is the positive real number for which you want the base-10 logarithm',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AbsNumber': 'is the real number for which you want the absolute value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IntNumber': 'is the real number you want to round down to an integer',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SignNumber': 'is any real number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RoundNumber': 'is the number you want to round',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RoundNumdigits': 'is the number of digits to which you want to round. Negative rounds to the left of the decimal point; zero to the nearest integer',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LookupLookupvalue': 'is a value that LOOKUP searches for in Lookup_vector and can be a number, text, a logical value, or a name or reference to a value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LookupLookupvector': 'is a range that contains only one row or one column of text, numbers, or logical values, placed in ascending order',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LookupResultvector': 'is a range that contains only one row or column, the same size as Lookup_vector',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IndexArray': 'is a range of cells or an array constant.',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IndexRownum': 'selects the row in Array or Reference from which to return a value. If omitted, Column_num is required',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IndexColumnnum': 'selects the column in Array or Reference from which to return a value. If omitted, Row_num is required',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ReptText': 'is the text you want to repeat',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ReptNumbertimes': 'is a positive number specifying the number of times to repeat text',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MidText': 'is the text string from which you want to extract the characters',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MidStartnum': 'is the position of the first character you want to extract. The first character in Text is 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MidNumchars': 'specifies how many characters to return from Text',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LenText': 'is the text whose length you want to find. Spaces count as characters',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ValueText': 'is the text enclosed in quotation marks or a reference to a cell containing the text you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AndLogical1': 'are 1 to 255 conditions you want to test that can be either TRUE or FALSE and can be logical values, arrays, or references',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AndLogical2': 'are 1 to 255 conditions you want to test that can be either TRUE or FALSE and can be logical values, arrays, or references',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OrLogical1': 'are 1 to 255 conditions that you want to test that can be either TRUE or FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OrLogical2': 'are 1 to 255 conditions that you want to test that can be either TRUE or FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NotLogical': 'is a value or expression that can be evaluated to TRUE or FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ModNumber': 'is the number for which you want to find the remainder after the division is performed',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ModDivisor': 'is the number by which you want to divide Number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DCountDatabase': 'is the range of cells that makes up the list or database. A database is a list of related data',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DCountField': 'is either the label of the column in double quotation marks or a number that represents the column\'s position in the list',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DCountCriteria': 'is the range of cells that contains the conditions you specify. The range includes a column label and one cell below the label for a condition',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DSumDatabase': 'is the range of cells that makes up the list or database. A database is a list of related data',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DSumField': 'is either the label of the column in double quotation marks or a number that represents the column\'s position in the list',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DSumCriteria': 'is the range of cells that contains the conditions you specify. The range includes a column label and one cell below the label for a condition',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DAverageDatabase': 'is the range of cells that makes up the list or database. A database is a list of related data',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DAverageField': 'is either the label of the column in double quotation marks or a number that represents the column\'s position in the list',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DAverageCriteria': 'is the range of cells that contains the conditions you specify. The range includes a column label and one cell below the label for a condition',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DMinDatabase': 'is the range of cells that makes up the list or database. A database is a list of related data',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DMinField': 'is either the label of the column in double quotation marks or a number that represents the column\'s position in the list',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DMinCriteria': 'is the range of cells that contains the conditions you specify. The range includes a column label and one cell below the label for a condition',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DMaxDatabase': 'is the range of cells that makes up the list or database. A database is a list of related data',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DMaxField': 'is either the label of the column in double quotation marks or a number that represents the column\'s position in the list',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DMaxCriteria': 'is the range of cells that contains the conditions you specify. The range includes a column label and one cell below the label for a condition',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DStDevDatabase': 'is the range of cells that makes up the list or database. A database is a list of related data',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DStDevField': 'is either the label of the column in double quotation marks or a number that represents the column\'s position in the list',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DStDevCriteria': 'is the range of cells that contains the conditions you specify. The range includes a column label and one cell below the label for a condition',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VarNumber1': 'are 1 to 255 numeric arguments corresponding to a sample of a population',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VarNumber2': 'are 1 to 255 numeric arguments corresponding to a sample of a population',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DVarDatabase': 'is the range of cells that makes up the list or database. A database is a list of related data',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DVarField': 'is either the label of the column in double quotation marks or a number that represents the column\'s position in the list',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DVarCriteria': 'is the range of cells that contains the conditions you specify. The range includes a column label and one cell below the label for a condition',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TextValue': 'is a number, a formula that evaluates to a numeric value, or a reference to a cell containing a numeric value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TextFormattext': 'is a number format in text form from the Category box on the Number tab in the Format Cells dialog box (not General)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LinestKnownys': 'is the set of y-values you already know in the relationship y = mx + b',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LinestKnownxs': 'is an optional set of x-values that you may already know in the relationship y = mx + b',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LinestConst': 'is a logical value: the constant b is calculated normally if Const = TRUE or omitted; b is set equal to 0 if Const = FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LinestStats': 'is a logical value: return additional regression statistics = TRUE; return m-coefficients and the constant b = FALSE or omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TrendKnownys': 'is a range or array of y-values you already know in the relationship y = mx + b',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TrendKnownxs': 'is an optional range or array of x-values that you know in the relationship y = mx + b, an array the same size as Known_y\'s',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TrendNewxs': 'is a range or array of new x-values for which you want TREND to return corresponding y-values',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TrendConst': 'is a logical value: the constant b is calculated normally if Const = TRUE or omitted; b is set equal to 0 if Const = FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LogestKnownys': 'is the set of y-values you already know in the relationship y = b*m^x',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LogestKnownxs': 'is an optional set of x-values that you may already know in the relationship y = b*m^x',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LogestConst': 'is a logical value: the constant b is calculated normally if Const = TRUE or omitted; b is set equal to 1 if Const = FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LogestStats': 'is a logical value: return additional regression statistics = TRUE; return m-coefficients and the constant b = FALSE or omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GrowthKnownys': 'is the set of y-values you already know in the relationship y = b*m^x, an array or range of positive numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GrowthKnownxs': 'is an optional set of x-values that you may already know in the relationship y = b*m^x, an array or range the same size as Known_y\'s',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GrowthNewxs': 'are new x-values for which you want GROWTH to return corresponding y-values',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GrowthConst': 'is a logical value: the constant b is calculated normally if Const = TRUE; b is set equal to 1 if Const = FALSE or omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PvRate': 'is the interest rate per period. For example, use 6%/4 for quarterly payments at 6% APR',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PvNper': 'is the total number of payment periods in an investment',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PvPmt': 'is the payment made each period and cannot change over the life of the investment',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PvFv': 'is the future value, or a cash balance you want to attain after the last payment is made',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PvType': 'is a logical value: payment at the beginning of the period = 1; payment at the end of the period = 0 or omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FvRate': 'is the interest rate per period. For example, use 6%/4 for quarterly payments at 6% APR',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FvNper': 'is the total number of payment periods in the investment',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FvPmt': 'is the payment made each period; it cannot change over the life of the investment',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FvPv': 'is the present value, or the lump-sum amount that a series of future payments is worth now. If omitted, Pv = 0',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FvType': 'is a value representing the timing of payment: payment at the beginning of the period = 1; payment at the end of the period = 0 or omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NPerRate': 'is the interest rate per period. For example, use 6%/4 for quarterly payments at 6% APR',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NPerPmt': 'is the payment made each period; it cannot change over the life of the investment',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NPerPv': 'is the present value, or the lump-sum amount that a series of future payments is worth now',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NPerFv': 'is the future value, or a cash balance you want to attain after the last payment is made. If omitted, zero is used',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NPerType': 'is a logical value: payment at the beginning of the period = 1; payment at the end of the period = 0 or omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PmtRate': 'is the interest rate per period for the loan. For example, use 6%/4 for quarterly payments at 6% APR',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PmtNper': 'is the total number of payments for the loan',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PmtPv': 'is the present value: the total amount that a series of future payments is worth now',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PmtFv': 'is the future value, or a cash balance you want to attain after the last payment is made, 0 (zero) if omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PmtType': 'is a logical value: payment at the beginning of the period = 1; payment at the end of the period = 0 or omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RateNper': 'is the total number of payment periods for the loan or investment',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RatePmt': 'is the payment made each period and cannot change over the life of the loan or investment',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RatePv': 'is the present value: the total amount that a series of future payments is worth now',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RateFv': 'is the future value, or a cash balance you want to attain after the last payment is made. If omitted, uses Fv = 0',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RateType': 'is a logical value: payment at the beginning of the period = 1; payment at the end of the period = 0 or omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RateGuess': 'is your guess for what the rate will be; if omitted, Guess = 0.1 (10 percent)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MirrValues': 'is an array or a reference to cells that contain numbers that represent a series of payments (negative) and income (positive) at regular periods',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MirrFinancerate': 'is the interest rate you pay on the money used in the cash flows',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MirrReinvestrate': 'is the interest rate you receive on the cash flows as you reinvest them',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IrrValues': 'is an array or a reference to cells that contain numbers for which you want to calculate the internal rate of return',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IrrGuess': 'is a number that you guess is close to the result of IRR; 0.1 (10 percent) if omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MatchLookupvalue': 'is the value you use to find the value you want in the array, a number, text, or logical value, or a reference to one of these',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MatchLookuparray': 'is a contiguous range of cells containing possible lookup values, an array of values, or a reference to an array',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MatchMatchtype': 'is a number 1, 0, or -1 indicating which value to return.',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DateYear': 'is a number from 1900 to 9999 in Spreadsheet for Windows or from 1904 to 9999 in Spreadsheet for the Macintosh',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DateMonth': 'is a number from 1 to 12 representing the month of the year',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DateDay': 'is a number from 1 to 31 representing the day of the month',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TimeHour': 'is a number from 0 to 23 representing the hour',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TimeMinute': 'is a number from 0 to 59 representing the minute',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TimeSecond': 'is a number from 0 to 59 representing the second',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DaySerialnumber': 'is a number in the date-time code used by Spreadsheet',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MonthSerialnumber': 'is a number in the date-time code used by Spreadsheet',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YearSerialnumber': 'is a number in the date-time code used by Spreadsheet',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.WeekDaySerialnumber': 'is a number that represents a date',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.WeekDayReturntype': 'is a number: for Sunday=1 through Saturday=7, use 1; for Monday=1 through Sunday=7, use 2; for Monday=0 through Sunday=6, use 3',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.HourSerialnumber': 'is a number in the date-time code used by Spreadsheet, or text in time format, such as 16:48:00 or 4:48:00 PM',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MinuteSerialnumber': 'is a number in the date-time code used by Spreadsheet or text in time format, such as 16:48:00 or 4:48:00 PM',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SecondSerialnumber': 'is a number in the date-time code used by Spreadsheet or text in time format, such as 16:48:23 or 4:48:47 PM',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AreasReference': 'is a reference to a cell or range of cells and can refer to multiple areas',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RowsArray': 'is an array, an array formula, or a reference to a range of cells for which you want the number of rows',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ColumnsArray': 'is an array or array formula, or a reference to a range of cells for which you want the number of columns',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OffsetReference': 'is the reference from which you want to base the offset, a reference to a cell or range of adjacent cells',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OffsetRows': 'is the number of rows, up or down, that you want the upper-left cell of the result to refer to',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OffsetCols': 'is the number of columns, to the left or right, that you want the upper-left cell of the result to refer to',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OffsetHeight': 'is the height, in number of rows, that you want the result to be, the same height as Reference if omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OffsetWidth': 'is the width, in number of columns, that you want the result to be, the same width as Reference if omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SearchFindtext': 'is the text you want to find. You can use the ? and * wildcard characters; use ~? and ~* to find the ? and * characters',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SearchWithintext': 'is the text in which you want to search for Find_text',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SearchStartnum': 'is the character number in Within_text, counting from the left, at which you want to start searching. If omitted, 1 is used',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TransposeArray': 'is a range of cells on a worksheet or an array of values that you want to transpose',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TypeValue': 'can be any value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ATan2Xnum': 'is the x-coordinate of the point',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ATan2Ynum': 'is the y-coordinate of the point',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ASinNumber': 'is the sine of the angle you want and must be from -1 to 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ACosNumber': 'is the cosine of the angle you want and must be from -1 to 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ChooseIndexnum': 'specifies which value argument is selected. Index_num must be between 1 and 254, or a formula or a reference to a number between 1 and 254',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ChooseValue1': 'are 1 to 254 numbers, cell references, defined names, formulas, functions, or text arguments from which CHOOSE selects',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ChooseValue2': 'are 1 to 254 numbers, cell references, defined names, formulas, functions, or text arguments from which CHOOSE selects',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.HLookupLookupvalue': 'is the value to be found in the first row of the table and can be a value, a reference, or a text string',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.HLookupTablearray': 'is a table of text, numbers, or logical values in which data is looked up. Table_array can be a reference to a range or a range name',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.HLookupRowindexnum': 'is the row number in table_array from which the matching value should be returned. The first row of values in the table is row 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.HLookupRangelookup': 'is a logical value: to find the closest match in the top row (sorted in ascending order) = TRUE or omitted; find an exact match = FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VLookupLookupvalue': 'is the value to be found in the first column of the table, and can be a value, a reference, or a text string',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VLookupTablearray': 'is a table of text, numbers, or logical values, in which data is retrieved. Table_array can be a reference to a range or a range name',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VLookupColindexnum': 'is the column number in table_array from which the matching value should be returned. The first column of values in the table is column 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VLookupRangelookup': 'is a logical value: to find the closest match in the first column (sorted in ascending order) = TRUE or omitted; find an exact match = FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IsRefValue': 'is the value you want to test. Value can refer to a cell, a formula, or a name that refers to a cell, formula, or value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNumber': 'is the positive real number for which you want the logarithm',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LogBase': 'is the base of the logarithm; 10 if omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CharNumber': 'is a number between 1 and 255 specifying which character you want',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LowerText': 'is the text you want to convert to lowercase. Characters in Text that are not letters are not changed',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.UpperText': 'is the text you want converted to uppercase, a reference or a text string',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ProperText': 'is text enclosed in quotation marks, a formula that returns text, or a reference to a cell containing text to partially capitalize',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LeftText': 'is the text string containing the characters you want to extract',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LeftNumchars': 'specifies how many characters you want LEFT to extract; 1 if omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RightText': 'is the text string that contains the characters you want to extract',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RightNumchars': 'specifies how many characters you want to extract, 1 if omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ExactText1': 'is the first text string',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ExactText2': 'is the second text string',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TrimText': 'is the text from which you want spaces removed',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ReplaceOldtext': 'is text in which you want to replace some characters',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ReplaceStartnum': 'is the position of the character in Old_text that you want to replace with New_text',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ReplaceNumchars': 'is the number of characters in Old_text that you want to replace',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ReplaceNewtext': 'is the text that will replace characters in Old_text',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SubstituteText': 'is the text or the reference to a cell containing text in which you want to substitute characters',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SubstituteOldtext': 'is the existing text you want to replace. If the case of Old_text does not match the case of text, SUBSTITUTE will not replace the text',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SubstituteNewtext': 'is the text you want to replace Old_text with',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SubstituteInstancenum': 'specifies which occurrence of Old_text you want to replace. If omitted, every instance of Old_text is replaced',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CodeText': 'is the text for which you want the code of the first character',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FindFindtext': 'is the text you want to find. Use double quotes (empty text) to match the first character in Within_text; wildcard characters not allowed',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FindWithintext': 'is the text containing the text you want to find',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FindStartnum': 'specifies the character at which to start the search. The first character in Within_text is character number 1. If omitted, Start_num = 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CellInfotype': 'is a text value that specifies what type of cell information you want.',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CellReference': 'is the cell that you want information about',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IsErrValue': 'is the value you want to test. Value can refer to a cell, a formula, or a name that refers to a cell, formula, or value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IsTextValue': 'is the value you want to test. Value can refer to a cell, a formula, or a name that refers to a cell, formula, or value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IsNumberValue': 'is the value you want to test. Value can refer to a cell, a formula, or a name that refers to a cell, formula, or value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IsBlankValue': 'is the cell or a name that refers to the cell you want to test',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TValue': 'is the value to test',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NValue': 'is the value you want converted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DateValueDatetext': 'is text that represents a date in a Spreadsheet date format, between 1/1/1900 (Windows) or 1/1/1904 (Macintosh) and 12/31/9999',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TimeValueTimetext': 'is a text string that gives a time in any one of the Spreadsheet time formats (date information in the string is ignored)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SlnCost': 'is the initial cost of the asset',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SlnSalvage': 'is the salvage value at the end of the life of the asset',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SlnLife': 'is the number of periods over which the asset is being depreciated (sometimes called the useful life of the asset)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SydCost': 'is the initial cost of the asset',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SydSalvage': 'is the salvage value at the end of the life of the asset',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SydLife': 'is the number of periods over which the asset is being depreciated (sometimes called the useful life of the asset)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SydPer': 'is the period and must use the same units as Life',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DdbCost': 'is the initial cost of the asset',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DdbSalvage': 'is the salvage value at the end of the life of the asset',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DdbLife': 'is the number of periods over which the asset is being depreciated (sometimes called the useful life of the asset)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DdbPeriod': 'is the period for which you want to calculate the depreciation. Period must use the same units as Life',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DdbFactor': 'is the rate at which the balance declines. If Factor is omitted, it is assumed to be 2 (the double-declining balance method)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IndirectReftext': 'is a reference to a cell that contains an A1- or R1C1-style reference, a name defined as a reference, or a reference to a cell as a text string',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IndirectA1': 'is a logical value that specifies the type of reference in Ref_text: R1C1-style = FALSE; A1-style = TRUE or omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CallRegisterid': 'is the value returned by a previously executed REGISTER or REGISTER.ID function',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CallArgument1': 'are the arguments to be passed to the procedure',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CleanText': 'is any worksheet information from which you want to remove nonprintable characters',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MDetermArray': 'is a numeric array with an equal number of rows and columns, either a cell range or an array constant',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MInverseArray': 'is a numeric array with an equal number of rows and columns, either a cell range or an array constant',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MMultArray1': 'is the first array of numbers to multiply and must have the same number of columns as Array2 has rows',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MMultArray2': 'is the first array of numbers to multiply and must have the same number of columns as Array2 has rows',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IpmtRate': 'is the interest rate per period. For example, use 6%/4 for quarterly payments at 6% APR',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IpmtPer': 'is the period for which you want to find the interest and must be in the range 1 to Nper',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IpmtNper': 'is the total number of payment periods in an investment',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IpmtPv': 'is the present value, or the lump-sum amount that a series of future payments is worth now',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IpmtFv': 'is the future value, or a cash balance you want to attain after the last payment is made. If omitted, Fv = 0',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IpmtType': 'is a logical value representing the timing of payment: at the end of the period = 0 or omitted, at the beginning of the period = 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PpmtRate': 'is the interest rate per period. For example, use 6%/4 for quarterly payments at 6% APR',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PpmtPer': 'specifies the period and must be in the range 1 to nper',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PpmtNper': 'is the total number of payment periods in an investment',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PpmtPv': 'is the present value: the total amount that a series of future payments is worth now',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PpmtFv': 'is the future value, or cash balance you want to attain after the last payment is made',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PpmtType': 'is a logical value: payment at the beginning of the period = 1; payment at the end of the period = 0 or omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CountAValue1': 'are 1 to 255 arguments representing the values and cells you want to count. Values can be any type of information',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CountAValue2': 'are 1 to 255 arguments representing the values and cells you want to count. Values can be any type of information',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ProductNumber1': 'are 1 to 255 numbers, logical values, or text representations of numbers that you want to multiply',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ProductNumber2': 'are 1 to 255 numbers, logical values, or text representations of numbers that you want to multiply',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FactNumber': 'is the nonnegative number you want the factorial of',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DProductDatabase': 'is the range of cells that makes up the list or database. A database is a list of related data',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DProductField': 'is either the label of the column in double quotation marks or a number that represents the column\'s position in the list',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DProductCriteria': 'is the range of cells that contains the conditions you specify. The range includes a column label and one cell below the label for a condition',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IsNonTextValue': 'is the value you want tested: a cell; a formula; or a name referring to a cell, formula, or value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevPNumber1': 'are 1 to 255 numbers corresponding to a population and can be numbers or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevPNumber2': 'are 1 to 255 numbers corresponding to a population and can be numbers or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VarPNumber1': 'are 1 to 255 numeric arguments corresponding to a population',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VarPNumber2': 'are 1 to 255 numeric arguments corresponding to a population',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DStDevPDatabase': 'is the range of cells that makes up the list or database. A database is a list of related data',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DStDevPField': 'is either the label of the column in double quotation marks or a number that represents the column\'s position in the list',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DStDevPCriteria': 'is the range of cells that contains the conditions you specify. The range includes a column label and one cell below the label for a condition',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DVarPDatabase': 'is the range of cells that makes up the list or database. A database is a list of related data',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DVarPField': 'is either the label of the column in double quotation marks or a number that represents the column\'s position in the list',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DVarPCriteria': 'is the range of cells that contains the conditions you specify. The range includes a column label and one cell below the label for a condition',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TruncNumber': 'is the number you want to truncate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TruncNumdigits': 'is a number specifying the precision of the truncation, 0 (zero) if omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IsLogicalValue': 'is the value you want to test. Value can refer to a cell, a formula, or a name that refers to a cell, formula, or value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DCountADatabase': 'is the range of cells that makes up the list or database. A database is a list of related data',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DCountAField': 'is either the label of the column in double quotation marks or a number that represents the column\'s position in the list',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DCountACriteria': 'is the range of cells that contains the conditions you specify. The range includes a column label and one cell below the label for a condition',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FindBFindtext': 'is the text you want to find',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FindBWithintext': 'is the text containing the text you want to find',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FindBStartnum': 'specifies the character at which to start the search',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SearchBFindtext': 'is the text you want to find',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SearchBWithintext': 'is the text in which you want to search for find_text',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SearchBStartnum': 'is the character number in within_text, counting from the left, at which you want to start searching',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ReplaceBOldtext': 'is text in which you want to replace some characters',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ReplaceBStartnum': 'is the position of the character in old_text that you want to replace with new_text',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ReplaceBNumbytes': 'is the number of characters in old_text that you want to replace with new_text',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ReplaceBNewtext': 'is the text that will replace characters in old_text',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LeftBText': 'is the text string containing the characters you want to extract',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LeftBNumbytes': 'specifies how many characters you want LEFT to return',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RightBText': 'is the text string containing the characters you want to extract',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RightBNumbytes': 'specifies how many characters you want to extract',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MidBText': 'is the text string containing the characters you want to extract',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MidBStartnum': 'is the position of the first character you want to extract in text',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MidBNumbytes': 'specifies how many characters to return from text',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LenBText': 'is the text whose length you want to find',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RoundUpNumber': 'is any real number that you want rounded up',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RoundUpNumdigits': 'is the number of digits to which you want to round. Negative rounds to the left of the decimal point; zero or omitted, to the nearest integer',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RoundDownNumber': 'is any real number that you want rounded down',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RoundDownNumdigits': 'is the number of digits to which you want to round. Negative rounds to the left of the decimal point; zero or omitted, to the nearest integer',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AscText': 'is a text, or a reference to a cell containing a text',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RankNumber': 'is the number for which you want to find the rank',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RankRef': 'is an array of, or a reference to, a list of numbers. Nonnumeric values are ignored',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RankOrder': 'is a number: rank in the list sorted descending = 0 or omitted; rank in the list sorted ascending = any nonzero value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AddressRownum': 'is the row number to use in the cell reference: Row_number = 1 for row 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AddressColumnnum': 'is the column number to use in the cell reference. For example, Column_number = 4 for column D',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AddressAbsnum': 'specifies the reference type: absolute = 1; absolute row/relative column = 2; relative row/absolute column = 3; relative = 4',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AddressA1': 'is a logical value that specifies the reference style: A1 style = 1 or TRUE; R1C1 style = 0 or FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AddressSheettext': 'is text specifying the name of the worksheet to be used as the external reference',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Days360Startdate': 'start_date and end_date are the two dates between which you want to know the number of days',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Days360Enddate': 'start_date and end_date are the two dates between which you want to know the number of days',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Days360Method': 'is a logical value specifying the calculation method: U.S. (NASD) = FALSE or omitted; European = TRUE.',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VdbCost': 'is the initial cost of the asset',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VdbSalvage': 'is the salvage value at the end of the life of the asset',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VdbLife': 'is the number of periods over which the asset is being depreciated (sometimes called the useful life of the asset)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VdbStartperiod': 'is the starting period for which you want to calculate the depreciation, in the same units as Life',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VdbEndperiod': 'is the ending period for which you want to calculate the depreciation, in the same units as Life',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VdbFactor': 'is the rate at which the balance declines, 2 (double-declining balance) if omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VdbNoswitch': 'switch to straight-line depreciation when depreciation is greater than the declining balance = FALSE or omitted; do not switch = TRUE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MedianNumber1': 'are 1 to 255 numbers or names, arrays, or references that contain numbers for which you want the median',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MedianNumber2': 'are 1 to 255 numbers or names, arrays, or references that contain numbers for which you want the median',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SumProductArray1': 'are 2 to 255 arrays for which you want to multiply and then add components. All arrays must have the same dimensions',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SumProductArray2': 'are 2 to 255 arrays for which you want to multiply and then add components. All arrays must have the same dimensions',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SumProductArray3': 'are 2 to 255 arrays for which you want to multiply and then add components. All arrays must have the same dimensions',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SinHNumber': 'is any real number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CosHNumber': 'is any real number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TanHNumber': 'is any real number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ASinHNumber': 'is any real number equal to or greater than 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ACosHNumber': 'is any real number equal to or greater than 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ATanHNumber': 'is any real number between -1 and 1 excluding -1 and 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DGetDatabase': 'is the range of cells that makes up the list or database. A database is a list of related data',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DGetField': 'is either the label of the column in double quotation marks or a number that represents the column\'s position in the list',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DGetCriteria': 'is the range of cells that contains the conditions you specify. The range includes a column label and one cell below the label for a condition',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.InfoTypetext': 'is text specifying what type of information you want returned.',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DbCost': 'is the initial cost of the asset',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DbSalvage': 'is the salvage value at the end of the life of the asset',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DbLife': 'is the number of periods over which the asset is being depreciated (sometimes called the useful life of the asset)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DbPeriod': 'is the period for which you want to calculate the depreciation. Period must use the same units as Life',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DbMonth': 'is the number of months in the first year. If month is omitted, it is assumed to be 12',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FrequencyDataarray': 'is an array of or reference to a set of values for which you want to count frequencies (blanks and text are ignored)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FrequencyBinsarray': 'is an array of or reference to intervals into which you want to group the values in data_array',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ErrorTypeErrorval': 'is the error value for which you want the identifying number, and can be an actual error value or a reference to a cell containing an error value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RegisterIdModuletext': 'is text specifying the name of the DLL that contains the function in Spreadsheet for Windows',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RegisterIdProcedure': 'is text specifying the name of the function in the DLL in Spreadsheet for Windows',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RegisterIdTypetext': 'is text encoding input and return data types and can be omitted if the function is already registered.',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AvedevNumber1': 'are 1 to 255 arguments for which you want the average of the absolute deviations',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AvedevNumber2': 'are 1 to 255 arguments for which you want the average of the absolute deviations',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistCompatibilityX': 'is the value between A and B at which to evaluate the function',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistCompatibilityAlpha': 'is a parameter to the distribution and must be greater than 0',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistCompatibilityBeta': 'is a parameter to the distribution and must be greater than 0',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistCompatibilityA': 'is an optional lower bound to the interval of x. If omitted, A = 0',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistCompatibilityB': 'is an optional upper bound to the interval of x. If omitted, B = 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaLnX': 'is the value for which you want to calculate GAMMALN, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaInvProbability': 'is a probability associated with the beta distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaInvAlpha': 'is a parameter to the distribution and must be greater than 0',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaInvBeta': 'is a parameter to the distribution and must be greater than 0',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaInvA': 'is an optional lower bound to the interval of x. If omitted, A = 0',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaInvB': 'is an optional upper bound to the interval of x. If omitted, B = 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDistNumbers': 'is the number of successes in trials',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDistTrials': 'is the number of independent trials',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDistProbabilitys': 'is the probability of success on each trial',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDistCumulative': 'is a logical value: for the cumulative distribution function, use TRUE; for the probability mass function, use FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ChiDistX': 'is the value at which you want to evaluate the distribution, a nonnegative number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ChiDistDegfreedom': 'is the number of degrees of freedom, a number between 1 and 10^10, excluding 10^10',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ChiInvProbability': 'is a probability associated with the chi-squared distribution, a value between 0 and 1 inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ChiInvDegfreedom': 'is the number of degrees of freedom, a number between 1 and 10^10, excluding 10^10',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CombinNumber': 'is the total number of items',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CombinNumberchosen': 'is the number of items in each combination',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ConfidenceAlpha': 'is the significance level used to compute the confidence level, a number greater than 0 and less than 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ConfidenceStandarddev': 'is the population standard deviation for the data range and is assumed to be known. Standard_dev must be greater than 0',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ConfidenceSize': 'is the sample size',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CritBinomTrials': 'is the number of Bernoulli trials',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CritBinomProbabilitys': 'is the probability of success on each trial, a number between 0 and 1 inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CritBinomAlpha': 'is the criterion value, a number between 0 and 1 inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.EvenNumber': 'is the value to round',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ExponDistX': 'is the value of the function, a nonnegative number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ExponDistLambda': 'is the parameter value, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ExponDistCumulative': 'is a logical value for the function to return: the cumulative distribution function = TRUE; the probability density function = FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FDistX': 'is the value at which to evaluate the function, a nonnegative number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FDistDegfreedom1': 'is the numerator degrees of freedom, a number between 1 and 10^10, excluding 10^10',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FDistDegfreedom2': 'is the denominator degrees of freedom, a number between 1 and 10^10, excluding 10^10',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FInvProbability': 'is a probability associated with the F cumulative distribution, a number between 0 and 1 inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FInvDegfreedom1': 'is the numerator degrees of freedom, a number between 1 and 10^10, excluding 10^10',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FInvDegfreedom2': 'is the denominator degrees of freedom, a number between 1 and 10^10, excluding 10^10',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FisherX': 'is the value for which you want the transformation, a number between -1 and 1, excluding -1 and 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FisherInvY': 'is the value for which you want to perform the inverse of the transformation',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FloorNumber': 'is the numeric value you want to round',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FloorSignificance': 'is the multiple to which you want to round. Number and Significance must either both be positive or both be negative',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDistX': 'is the value at which you want to evaluate the distribution, a nonnegative number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDistAlpha': 'is a parameter to the distribution, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDistBeta': 'is a parameter to the distribution, a positive number. If beta = 1, GAMMADIST returns the standard gamma distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDistCumulative': 'is a logical value: return the cumulative distribution function = TRUE; return the probability mass function = FALSE or omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaInvProbability': 'is the probability associated with the gamma distribution, a number between 0 and 1, inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaInvAlpha': 'is a parameter to the distribution, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaInvBeta': 'is a parameter to the distribution, a positive number. If beta = 1, GAMMAINV returns the inverse of the standard gamma distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CeilingNumber': 'is the value you want to round',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CeilingSignificance': 'is the multiple to which you want to round',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.HypGeomDistSamples': 'is the number of successes in the sample',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.HypGeomDistNumbersample': 'is the size of the sample',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.HypGeomDistPopulations': 'is the number of successes in the population',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.HypGeomDistNumberpop': 'is the population size',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNormDistCompatibilityX': 'is the value at which to evaluate the function, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNormDistCompatibilityMean': 'is the mean of ln(x)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNormDistCompatibilityStandarddev': 'is the standard deviation of ln(x), a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LogInvCompatibilityProbability': 'is a probability associated with the lognormal distribution, a number between 0 and 1, inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LogInvCompatibilityMean': 'is the mean of ln(x)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LogInvCompatibilityStandarddev': 'is the standard deviation of ln(x), a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NegBinomDistNumberf': 'is the number of failures',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NegBinomDistNumbers': 'is the threshold number of successes',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NegBinomDistProbabilitys': 'is the probability of a success; a number between 0 and 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NormDistCompatibilityX': 'is the value for which you want the distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NormDistCompatibilityMean': 'is the arithmetic mean of the distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NormDistCompatibilityStandarddev': 'is the standard deviation of the distribution, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NormDistCompatibilityCumulative': 'is a logical value: for the cumulative distribution function, use TRUE; for the probability density function, use FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NormSDistCompatibilityZ': 'is the value for which you want the distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NormInvCompatibilityProbability': 'is a probability corresponding to the normal distribution, a number between 0 and 1 inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NormInvCompatibilityMean': 'is the arithmetic mean of the distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NormInvCompatibilityStandarddev': 'is the standard deviation of the distribution, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NormSInvCompatibilityProbability': 'is a probability corresponding to the normal distribution, a number between 0 and 1 inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.StandardizeX': 'is the value you want to normalize',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.StandardizeMean': 'is the arithmetic mean of the distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.StandardizeStandarddev': 'is the standard deviation of the distribution, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddNumber': 'is the value to round',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PermutNumber': 'is the total number of objects',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PermutNumberchosen': 'is the number of objects in each permutation',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PoissonX': 'is the number of events',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PoissonMean': 'is the expected numeric value, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PoissonCumulative': 'is a logical value: for the cumulative Poisson probability, use TRUE; for the Poisson probability mass function, use FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TDistX': 'is the numeric value at which to evaluate the distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TDistDegfreedom': 'is an integer indicating the number of degrees of freedom that characterize the distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TDistTails': 'specifies the number of distribution tails to return: one-tailed distribution = 1; two-tailed distribution = 2',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.WeibullX': 'is the value at which to evaluate the function, a nonnegative number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.WeibullAlpha': 'is a parameter to the distribution, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.WeibullBeta': 'is a parameter to the distribution, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.WeibullCumulative': 'is a logical value: for the cumulative distribution function, use TRUE; for the probability mass function, use FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SumXMY2Arrayx': 'is the first range or array of values and can be a number or name, array, or reference that contains numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SumXMY2Arrayy': 'is the second range or array of values and can be a number or name, array, or reference that contains numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SumX2MY2Arrayx': 'is the first range or array of numbers and can be a number or name, array, or reference that contains numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SumX2MY2Arrayy': 'is the second range or array of numbers and can be a number or name, array, or reference that contains numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SumX2PY2Arrayx': 'is the first range or array of numbers and can be a number or name, array, or reference that contains numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SumX2PY2Arrayy': 'is the second range or array of numbers and can be a number or name, array, or reference that contains numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ChiTestActualrange': 'is the range of data that contains observations to test against expected values',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ChiTestExpectedrange': 'is the range of data that contains the ratio of the product of row totals and column totals to the grand total',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CorrelArray1': 'is a cell range of values. The values should be numbers, names, arrays, or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CorrelArray2': 'is a second cell range of values. The values should be numbers, names, arrays, or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CovarArray1': 'is the first cell range of integers and must be numbers, arrays, or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CovarArray2': 'is the second cell range of integers and must be numbers, arrays, or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ForecastX': 'is the data point for which you want to predict a value and must be a numeric value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ForecastKnownys': 'is the dependent array or range of numeric data',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ForecastKnownxs': 'is the independent array or range of numeric data. The variance of Known_x\'s must not be zero',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FTestArray1': 'is the first array or range of data and can be numbers or names, arrays, or references that contain numbers (blanks are ignored)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FTestArray2': 'is the second array or range of data and can be numbers or names, arrays, or references that contain numbers (blanks are ignored)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.InterceptKnownys': 'is the dependent set of observations or data and can be numbers or names, arrays, or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.InterceptKnownxs': 'is the independent set of observations or data and can be numbers or names, arrays, or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PearsonArray1': 'is a set of independent values',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PearsonArray2': 'is a set of dependent values',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RsqKnownys': 'is an array or range of data points and can be numbers or names, arrays, or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RsqKnownxs': 'is an array or range of data points and can be numbers or names, arrays, or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.StEYXKnownys': 'is an array or range of dependent data points and can be numbers or names, arrays, or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.StEYXKnownxs': 'is an array or range of independent data points and can be numbers or names, arrays, or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SlopeKnownys': 'is an array or cell range of numeric dependent data points and can be numbers or names, arrays, or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SlopeKnownxs': 'is the set of independent data points and can be numbers or names, arrays, or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TTestArray1': 'is the first data set',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TTestArray2': 'is the second data set',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TTestTails': 'specifies the number of distribution tails to return: one-tailed distribution = 1; two-tailed distribution = 2',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TTestType': 'is the kind of t-test: paired = 1, two-sample equal variance (homoscedastic) = 2, two-sample unequal variance = 3',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ProbXrange': 'is the range of numeric values of x with which there are associated probabilities',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ProbProbrange': 'is the set of probabilities associated with values in X_range, values between 0 and 1 and excluding 0',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ProbLowerlimit': 'is the lower bound on the value for which you want a probability',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ProbUpperlimit': 'is the optional upper bound on the value. If omitted, PROB returns the probability that X_range values are equal to Lower_limit',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DevSqNumber1': 'are 1 to 255 arguments, or an array or array reference, on which you want DEVSQ to calculate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DevSqNumber2': 'are 1 to 255 arguments, or an array or array reference, on which you want DEVSQ to calculate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GeomeanNumber1': 'are 1 to 255 numbers or names, arrays, or references that contain numbers for which you want the mean',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GeomeanNumber2': 'are 1 to 255 numbers or names, arrays, or references that contain numbers for which you want the mean',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.HarMeanNumber1': 'are 1 to 255 numbers or names, arrays, or references that contain numbers for which you want the harmonic mean',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.HarMeanNumber2': 'are 1 to 255 numbers or names, arrays, or references that contain numbers for which you want the harmonic mean',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SumSqNumber1': 'are 1 to 255 numbers, arrays, names, or references to arrays for which you want the sum of the squares',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SumSqNumber2': 'are 1 to 255 numbers, arrays, names, or references to arrays for which you want the sum of the squares',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.KurtNumber1': 'are 1 to 255 numbers or names, arrays, or references that contain numbers for which you want the kurtosis',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.KurtNumber2': 'are 1 to 255 numbers or names, arrays, or references that contain numbers for which you want the kurtosis',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SkewNumber1': 'are 1 to 255 numbers or names, arrays, or references that contain numbers for which you want the skewness',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SkewNumber2': 'are 1 to 255 numbers or names, arrays, or references that contain numbers for which you want the skewness',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ZTestArray': 'is the array or range of data against which to test X',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ZTestX': 'is the value to test',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ZTestSigma': 'is the population (known) standard deviation. If omitted, the sample standard deviation is used',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LargeArray': 'is the array or range of data for which you want to determine the k-th largest value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LargeK': 'is the position (from the largest) in the array or cell range of the value to return',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SmallArray': 'is an array or range of numerical data for which you want to determine the k-th smallest value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SmallK': 'is the position (from the smallest) in the array or range of the value to return',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.QuartileArray': 'is the array or cell range of numeric values for which you want the quartile value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.QuartileQuart': 'is a number: minimum value = 0; 1st quartile = 1; median value = 2; 3rd quartile = 3; maximum value = 4',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentileArray': 'is the array or range of data that defines relative standing',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentileK': 'is the percentile value that is between 0 through 1, inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentRankArray': 'is the array or range of data with numeric values that defines relative standing',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentRankX': 'is the value for which you want to know the rank',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentRankSignificance': 'is an optional value that identifies the number of significant digits for the returned percentage, three digits if omitted (0.xxx%)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ModeNumber1': 'are 1 to 255 numbers, or names, arrays, or references that contain numbers for which you want the mode',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ModeNumber2': 'are 1 to 255 numbers, or names, arrays, or references that contain numbers for which you want the mode',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TrimmeanArray': 'is the range or array of values to trim and average',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TrimmeanPercent': 'is the fractional number of data points to exclude from the top and bottom of the data set',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TinvProbability': 'is the probability associated with the two-tailed Student\'s t-distribution, a number between 0 and 1 inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TinvDegfreedom': 'is a positive integer indicating the number of degrees of freedom to characterize the distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ConcatenateText1': 'are 1 to 255 text strings to be joined into a single text string and can be text strings, numbers, or single-cell references',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ConcatenateText2': 'are 1 to 255 text strings to be joined into a single text string and can be text strings, numbers, or single-cell references',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PowerNumber': 'is the base number, any real number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PowerPower': 'is the exponent, to which the base number is raised',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RadiansAngle': 'is an angle in degrees that you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DegreesAngle': 'is the angle in radians that you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SubtotalFunctionnum': 'is the number 1 to 11 that specifies the summary function for the subtotal.',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SubtotalRef1': 'are 1 to 254 ranges or references for which you want the subtotal',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SumIfRange': 'is the range of cells you want evaluated',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SumIfCriteria': 'is the condition or criteria in the form of a number, expression, or text that defines which cells will be added',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SumIfSumrange': 'are the actual cells to sum. If omitted, the cells in range are used',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CountIfRange': 'is the range of cells from which you want to count nonblank cells',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CountIfCriteria': 'is the condition in the form of a number, expression, or text that defines which cells will be counted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CountBlankRange': 'is the range from which you want to count the empty cells',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IsPmtRate': 'interest rate per period. For example, use 6%/4 for quarterly payments at 6% APR',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IsPmtPer': 'period for which you want to find the interest',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IsPmtNper': 'number of payment periods in an investment',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IsPmtPv': 'lump sum amount that a series of future payments is right now',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RomanNumber': 'is the Arabic numeral you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RomanForm': 'is the number specifying the type of Roman numeral you want.',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GetPivotDataDatafield': 'is the name of the data field to extract data from',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GetPivotDataPivottable': 'is a reference to a cell or range of cells in the PivotTable that contains the data you want to retrieve',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GetPivotDataField': 'field to refer to',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GetPivotDataItem': 'field item to refer to',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.HyperlinkLinklocation': 'is the text giving the path and file name to the document to be opened, a hard drive location, UNC address, or URL path',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.HyperlinkFriendlyname': 'is text or a number that is displayed in the cell. If omitted, the cell displays the Link_location text',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PhoneticReference': 'is a reference to a cell containing a phonetic string',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AverageAValue1': 'are 1 to 255 arguments for which you want the average',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AverageAValue2': 'are 1 to 255 arguments for which you want the average',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MaxAValue1': 'are 1 to 255 numbers, empty cells, logical values, or text numbers for which you want the maximum',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MaxAValue2': 'are 1 to 255 numbers, empty cells, logical values, or text numbers for which you want the maximum',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MinAValue1': 'are 1 to 255 numbers, empty cells, logical values, or text numbers for which you want the minimum',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MinAValue2': 'are 1 to 255 numbers, empty cells, logical values, or text numbers for which you want the minimum',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevPAValue1': 'are 1 to 255 values corresponding to a population and can be values, names, arrays, or references that contain values',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevPAValue2': 'are 1 to 255 values corresponding to a population and can be values, names, arrays, or references that contain values',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VarPAValue1': 'are 1 to 255 value arguments corresponding to a population',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VarPAValue2': 'are 1 to 255 value arguments corresponding to a population',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevAValue1': 'are 1 to 255 values corresponding to a sample of a population and can be values or names or references to values',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevAValue2': 'are 1 to 255 values corresponding to a sample of a population and can be values or names or references to values',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VarAValue1': 'are 1 to 255 value arguments corresponding to a sample of a population',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VarAValue2': 'are 1 to 255 value arguments corresponding to a sample of a population',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BahtTextNumber': 'is a number that you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RtdProgID': 'is the name of the ProgID of a registered COM automation add-in. Enclose the name in quotation marks',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RtdServer': 'is the name of the server where the add-in should be run. Enclose the name in quotation marks. If the add-in is run locally, use an empty string',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RtdTopic1': 'are 1 to 38 parameters that specify a piece of data',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RtdTopic2': 'are 1 to 38 parameters that specify a piece of data',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeValueConnection': 'is the name of a connection to an OLAP cube',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeValueMemberexpression1': 'is a slicer that determines the portion of the OLAP cube for which the aggregated value is to be retrieved',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeMemberConnection': 'is the name of a connection to an OLAP cube',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeMemberMemberexpression': 'is the expression representing the name of a member or tuple in the OLAP cube',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeMemberCaption': 'is the caption to be displayed in the cell',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeMemberPropertyConnection': 'is the name of a connection to an OLAP cube',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeMemberPropertyMemberexpression': 'is the expression representing the name of a member in the OLAP cube',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeMemberPropertyProperty': 'is the property name',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeRankedMemberConnection': 'is the name of a connection to an OLAP cube',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeRankedMemberSetexpression': 'is the set from which the element is to be retrieved',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeRankedMemberRank': 'is the rank of the element to be retrieved',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeRankedMemberCaption': 'is the caption to be displayed in the cell',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Hex2BinNumber': 'is the hexadecimal number you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Hex2BinPlaces': 'is the number of characters to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Hex2DecNumber': 'is the hexadecimal number you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Hex2OctNumber': 'is the hexadecimal number you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Hex2OctPlaces': 'is the number of characters to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Dec2BinNumber': 'is the decimal integer you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Dec2BinPlaces': 'is the number of characters to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Dec2HexNumber': 'is the decimal integer you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Dec2HexPlaces': 'is the number of characters to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Dec2OctNumber': 'is the decimal integer you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Dec2OctPlaces': 'is the number of characters to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Oct2BinNumber': 'is the octal number you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Oct2BinPlaces': 'is the number of characters to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Oct2HexNumber': 'is the octal number you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Oct2HexPlaces': 'is the number of characters to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Oct2DecNumber': 'is the octal number you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Bin2DecNumber': 'is the binary number you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Bin2OctNumber': 'is the binary number you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Bin2OctPlaces': 'is the number of characters to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Bin2HexNumber': 'is the binary number you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.Bin2HexPlaces': 'is the number of characters to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImSubInumber1': 'is the complex number from which to subtract inumber2',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImSubInumber2': 'is the complex number to subtract from inumber1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImDivInumber1': 'is the complex numerator or dividend',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImDivInumber2': 'is the complex denominator or divisor',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImPowerInumber': 'is a complex number you want to raise to a power',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImPowerNumber': 'is the power to which you want to raise the complex number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImAbsInumber': 'is a complex number for which you want the absolute value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImSqrtInumber': 'is a complex number for which you want the square root',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImLnInumber': 'is a complex number for which you want the natural logarithm',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImLog2Inumber': 'is a complex number for which you want the base-2 logarithm',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImLog10Inumber': 'is a complex number for which you want the common logarithm',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImSinInumber': 'is a complex number for which you want the sine',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImCosInumber': 'is a complex number for which you want the cosine',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImExpInumber': 'is a complex number for which you want the exponential',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImArgumentInumber': 'is a complex number for which you want the argument',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImConjugateInumber': 'is a complex number for which you want the conjugate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImaginaryInumber': 'is a complex number for which you want the imaginary coefficient',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImRealInumber': 'is a complex number for which you want the real coefficient',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ComplexRealnum': 'is the real coefficient of the complex number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ComplexInum': 'is the imaginary coefficient of the complex number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ComplexSuffix': 'is the suffix for the imaginary component of the complex number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImSumInumber1': 'are from 1 to 255 complex numbers to add',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImSumInumber2': 'are from 1 to 255 complex numbers to add',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImProductInumber1': 'Inumber1, Inumber2,... are from 1 to 255 complex numbers to multiply.',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImProductInumber2': 'Inumber1, Inumber2,... are from 1 to 255 complex numbers to multiply.',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SeriessumX': 'is the input value to the power series',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SeriessumN': 'is the initial power to which you want to raise x',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SeriessumM': 'is the step by which to increase n for each term in the series',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SeriessumCoefficients': 'is a set of coefficients by which each successive power of x is multiplied',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FactDoubleNumber': 'is the value for which to return the double factorial',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SqrtPiNumber': 'is the number by which p is multiplied',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.QuotientNumerator': 'is the dividend',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.QuotientDenominator': 'is the divisor',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DeltaNumber1': 'is the first number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DeltaNumber2': 'is the second number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GestepNumber': 'is the value to test against step',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GestepStep': 'is the threshold value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IsEvenNumber': 'is the value to test',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IsOddNumber': 'is the value to test',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MRoundNumber': 'is the value to round',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MRoundMultiple': 'is the multiple to which you want to round number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ErfLowerlimit': 'is the lower bound for integrating ERF',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ErfUpperlimit': 'is the upper bound for integrating ERF',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ErfcX': 'is the lower bound for integrating ERF',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BesselJX': 'is the value at which to evaluate the function',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BesselJN': 'is the order of the Bessel function',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BesselKX': 'is the value at which to evaluate the function',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BesselKN': 'is the order of the function',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BesselYX': 'is the value at which to evaluate the function',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BesselYN': 'is the order of the function',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BesselIX': 'is the value at which to evaluate the function',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BesselIN': 'is the order of the Bessel function',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.XirrValues': 'is a series of cash flows that correspond to a schedule of payments in dates',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.XirrDates': 'is a schedule of payment dates that corresponds to the cash flow payments',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.XirrGuess': 'is a number that you guess is close to the result of XIRR',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.XnpvRate': 'is the discount rate to apply to the cash flows',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.XnpvValues': 'is a series of cash flows that correspond to a schedule of payments in dates',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.XnpvDates': 'is a schedule of payment dates that corresponds to the cash flow payments',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceMatSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceMatMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceMatIssue': 'is the security\'s issue date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceMatRate': 'is the security\'s interest rate at date of issue',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceMatYld': 'is the security\'s annual yield',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceMatBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldMatSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldMatMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldMatIssue': 'is the security\'s issue date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldMatRate': 'is the security\'s interest rate at date of issue',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldMatPr': 'is the security\'s price per $100 face value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldMatBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IntrateSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IntrateMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IntrateInvestment': 'is the amount invested in the security',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IntrateRedemption': 'is the amount to be received at maturity',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IntrateBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ReceivedSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ReceivedMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ReceivedInvestment': 'is the amount invested in the security',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ReceivedDiscount': 'is the security\'s discount rate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ReceivedBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DiscSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DiscMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DiscPr': 'is the security\'s price per $100 face value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DiscRedemption': 'is the security\'s redemption value per $100 face value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DiscBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceDiscSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceDiscMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceDiscDiscount': 'is the security\'s discount rate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceDiscRedemption': 'is the security\'s redemption value per $100 face value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceDiscBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldDiscSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldDiscMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldDiscPr': 'is the security\'s price per $100 face value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldDiscRedemption': 'is the security\'s redemption value per $100 face value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldDiscBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TbillEqSettlement': 'is the Treasury bill\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TbillEqMaturity': 'is the Treasury bill\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TbillEqDiscount': 'is the Treasury bill\'s discount rate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TbillPriceSettlement': 'is the Treasury bill\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TbillPriceMaturity': 'is the Treasury bill\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TbillPriceDiscount': 'is the Treasury bill\'s discount rate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TbillYieldSettlement': 'is the Treasury bill\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TbillYieldMaturity': 'is the Treasury bill\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TbillYieldPr': 'is the Treasury Bill\'s price per $100 face value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceRate': 'is the security\'s annual coupon rate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceYld': 'is the security\'s annual yield',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceRedemption': 'is the security\'s redemption value per $100 face value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceFrequency': 'is the number of coupon payments per year',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PriceBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldRate': 'is the security\'s annual coupon rate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldPr': 'is the security\'s price per $100 face value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldRedemption': 'is the security\'s redemption value per $100 face value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldFrequency': 'is the number of coupon payments per year',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YieldBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DollarDeFractionaldollar': 'is a number expressed as a fraction',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DollarDeFraction': 'is the integer to use in the denominator of the fraction',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DollarFrDecimaldollar': 'is a decimal number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DollarFrFraction': 'is the integer to use in the denominator of a fraction',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NominalEffectrate': 'is the effective interest rate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NominalNpery': 'is the number of compounding periods per year',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.EffectNominalrate': 'is the nominal interest rate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.EffectNpery': 'is the number of compounding periods per year',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CumPrincRate': 'is the interest rate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CumPrincNper': 'is the total number of payment periods',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CumPrincPv': 'is the present value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CumPrincStartperiod': 'is the first period in the calculation',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CumPrincEndperiod': 'is the last period in the calculation',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CumPrincType': 'is the timing of the payment',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CumIpmtRate': 'is the interest rate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CumIpmtNper': 'is the total number of payment periods',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CumIpmtPv': 'is the present value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CumIpmtStartperiod': 'is the first period in the calculation',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CumIpmtEndperiod': 'is the last period in the calculation',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CumIpmtType': 'is the timing of the payment',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.EDateStartdate': 'is a serial date number that represents the start date',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.EDateMonths': 'is the number of months before or after start_date',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.EOMonthStartdate': 'is a serial date number that represents the start date',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.EOMonthMonths': 'is the number of months before or after the start_date',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YearFracStartdate': 'is a serial date number that represents the start date',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YearFracEnddate': 'is a serial date number that represents the end date',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.YearFracBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaybsSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaybsMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaybsFrequency': 'is the number of coupon payments per year',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaybsBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaysSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaysMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaysFrequency': 'is the number of coupon payments per year',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaysBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaysncSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaysncMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaysncFrequency': 'is the number of coupon payments per year',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupDaysncBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupncdSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupncdMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupncdFrequency': 'is the number of coupon payments per year',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupncdBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupNumSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupNumMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupNumFrequency': 'is the number of coupon payments per year',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CoupNumBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CouppcdSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CouppcdMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CouppcdFrequency': 'is the number of coupon payments per year',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CouppcdBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DurationSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DurationMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DurationCoupon': 'is the security\'s annual coupon rate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DurationYld': 'is the security\'s annual yield',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DurationFrequency': 'is the number of coupon payments per year',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DurationBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MDurationSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MDurationMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MDurationCoupon': 'is the security\'s annual coupon rate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MDurationYld': 'is the security\'s annual yield',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MDurationFrequency': 'is the number of coupon payments per year',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MDurationBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLPriceSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLPriceMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLPriceLastinterest': 'is the security\'s last coupon date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLPriceRate': 'is the security\'s interest rate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLPriceYld': 'is the security\'s annual yield',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLPriceRedemption': 'is the security\'s redemption value per $100 face value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLPriceFrequency': 'is the number of coupon payments per year',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLPriceBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLYieldSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLYieldMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLYieldLastinterest': 'is the security\'s last coupon date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLYieldRate': 'is the security\'s interest rate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLYieldPr': 'is the security\'s price',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLYieldRedemption': 'is the security\'s redemption value per $100 face value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLYieldFrequency': 'is the number of coupon payments per year',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddLYieldBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFPriceSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFPriceMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFPriceIssue': 'is the security\'s issue date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFPriceFirstcoupon': 'is the security\'s first coupon date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFPriceRate': 'is the security\'s interest rate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFPriceYld': 'is the security\'s annual yield',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFPriceRedemption': 'is the security\'s redemption value per $100 face value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFPriceFrequency': 'is the number of coupon payments per year',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFPriceBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFYieldSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFYieldMaturity': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFYieldIssue': 'is the security\'s issue date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFYieldFirstcoupon': 'is the security\'s first coupon date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFYieldRate': 'is the security\'s interest rate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFYieldPr': 'is the security\'s price',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFYieldRedemption': 'is the security\'s redemption value per $100 face value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFYieldFrequency': 'is the number of coupon payments per year',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.OddFYieldBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RandBetweenBottom': 'is the smallest integer RANDBETWEEN will return',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RandBetweenTop': 'is the largest integer RANDBETWEEN will return',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.WeekNumSerialnumber': 'is the date-time code used by Spreadsheet for date and time calculation',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.WeekNumReturntype': 'is a number (1 or 2) that determines the type of the return value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AmordegrcCost': 'is the cost of the asset',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AmordegrcDatepurchased': 'is the date the asset is purchased',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AmordegrcFirstperiod': 'is the date of the end of the first period',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AmordegrcSalvage': 'is the salvage value at the end of life of the asset.',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AmordegrcPeriod': 'is the period',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AmordegrcRate': 'is the rate of depreciation',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AmordegrcBasis': 'year_basis : 0 for year of 360 days, 1 for actual, 3 for year of 365 days.',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AmorlincCost': 'is the cost of the asset',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AmorlincDatepurchased': 'is the date the asset is purchased',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AmorlincFirstperiod': 'is the date of the end of the first period',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AmorlincSalvage': 'is the salvage value at the end of life of the asset.',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AmorlincPeriod': 'is the period',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AmorlincRate': 'is the rate of depreciation',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AmorlincBasis': 'year_basis : 0 for year of 360 days, 1 for actual, 3 for year of 365 days.',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ConvertNumber': 'is the value in from_units to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ConvertFromunit': 'is the units for number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ConvertTounit': 'is the units for the result',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintIssue': 'is the security\'s issue date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintFirstinterest': 'is the security\'s first interest date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintSettlement': 'is the security\'s settlement date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintRate': 'is the security\'s annual coupon rate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintPar': 'is the security\'s par value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintFrequency': 'is the number of coupon payments per year',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintCalcmethod': 'is a logical value: to accrued interest from issue date = TRUE or omitted; to calculate from last coupon payment date = FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintmIssue': 'is the security\'s issue date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintmSettlement': 'is the security\'s maturity date, expressed as a serial date number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintmRate': 'is the security\'s annual coupon rate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintmPar': 'is the security\'s par value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AccrintmBasis': 'is the type of day count basis to use',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.WorkDayStartdate': 'is a serial date number that represents the start date',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.WorkDayDays': 'is the number of nonweekend and non-holiday days before or after start_date',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.WorkDayHolidays': 'is an optional array of one or more serial date numbers to exclude from the working calendar, such as state and federal holidays and floating holidays',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NetworkDaysStartdate': 'is a serial date number that represents the start date',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NetworkDaysEnddate': 'is a serial date number that represents the end date',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NetworkDaysHolidays': 'is an optional set of one or more serial date numbers to exclude from the working calendar, such as state and federal holidays and floating holidays',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GcdNumber1': 'are 1 to 255 values',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GcdNumber2': 'are 1 to 255 values',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MultinomialNumber1': 'are 1 to 255 values for which you want the multinomial',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MultinomialNumber2': 'are 1 to 255 values for which you want the multinomial',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LcmNumber1': 'are 1 to 255 values for which you want the least common multiple',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LcmNumber2': 'are 1 to 255 values for which you want the least common multiple',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FvSchedulePrincipal': 'is the present value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FvScheduleSchedule': 'is an array of interest rates to apply',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeKpiMemberConnection': 'is the name of a connection to an OLAP cube',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeKpiMemberKpiname': 'is the KPI name',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeKpiMemberKpiproperty': 'is the KPI property',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeKpiMemberCaption': 'is the caption to be displayed in the cell',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeSetConnection': 'is the name of a connection to an OLAP cube',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeSetSetexpression': 'is the expression for the set',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeSetCaption': 'is the caption to be displayed in the cell',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeSetSortorder': 'is the sort order',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeSetSortby': 'is the sort by',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CubeSetCountSet': 'is the set whose elements are to be counted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IfErrorValue': 'is any value or expression or reference',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IfErrorValueiferror': 'is any value or expression or reference',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CountIfsCriteriarange': 'is the range of cells you want evaluated for the particular condition',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CountIfsCriteria': 'is the condition in the form of a number, expression, or text that defines which cells will be counted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SumIfsSumrange': 'are the actual cells to sum.',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SumIfsCriteriarange': 'is the range of cells you want evaluated for the particular condition',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SumIfsCriteria': 'is the condition or criteria in the form of a number, expression, or text that defines which cells will be added',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AverageIfRange': 'is the range of cells you want evaluated',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AverageIfCriteria': 'is the condition or criteria in the form of a number, expression, or text that defines which cells will be used to find the average',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AverageIfAveragerange': 'are the actual cells to be used to find the average. If omitted, the cells in range are used ',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AverageIfsAveragerange': 'are the actual cells to be used to find the average.',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AverageIfsCriteriarange': 'is the range of cells you want evaluated for the particular condition',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AverageIfsCriteria': 'is the condition or criteria in the form of a number, expression, or text that defines which cells will be used to find the average',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AggregateFunctionnum': 'is the number 1 to 19 that specifies the summary function for the aggregate.',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AggregateOptions': 'is the number 0 to 7 that specifies the values to ignore for the aggregate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AggregateArray': 'is the array or range of numerical data on which to calculate the aggregate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.AggregateK': 'indicates the position in the array; it is k-th largest, k-th smallest, k-th percentile, or k-th quartile.',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDotDistNumbers': 'is the number of successes in trials',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDotDistTrials': 'is the number of independent trials',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDotDistProbabilitys': 'is the probability of success on each trial',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDotDistCumulative': 'is a logical value: for the cumulative distribution function, use TRUE; for the probability mass function, use FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDotInvTrials': 'is the number of Bernoulli trials',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDotInvProbabilitys': 'is the probability of success on each trial, a number between 0 and 1 inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDotInvAlpha': 'is the criterion value, a number between 0 and 1 inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ConfidenceNormAlpha': 'is the significance level used to compute the confidence level, a number greater than 0 and less than 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ConfidenceNormStandarddev': 'is the population standard deviation for the data range and is assumed to be known. Standard_dev must be greater than 0',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ConfidenceNormSize': 'is the sample size',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ConfidenceDotTAlpha': 'is the significance level used to compute the confidence level, a number greater than 0 and less than 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ConfidenceDotTStandarddev': 'is the population standard deviation for the data range and is assumed to be known. Standard_dev must be greater than 0',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ConfidenceDotTSize': 'is the sample size',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotTestActualrange': 'is the range of data that contains observations to test against expected values',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotTestExpectedrange': 'is the range of data that contains the ratio of the product of row totals and column totals to the grand total',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotTestArray1': 'is the first array or range of data and can be numbers or names, arrays, or references that contain numbers (blanks are ignored)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotTestArray2': 'is the second array or range of data and can be numbers or names, arrays, or references that contain numbers (blanks are ignored)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CovariancePArray1': 'is the first cell range of integers and must be numbers, arrays, or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CovariancePArray2': 'is the second cell range of integers and must be numbers, arrays, or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CovarianceSArray1': 'is the first cell range of integers and must be numbers, arrays, or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CovarianceSArray2': 'is the second cell range of integers and must be numbers, arrays, or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ExponDotDistX': 'is the value of the function, a nonnegative number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ExponDotDistLambda': 'is the parameter value, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ExponDotDistCumulative': 'is a logical value for the function to return: the cumulative distribution function = TRUE; the probability density function = FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDotDistX': 'is the value at which you want to evaluate the distribution, a nonnegative number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDotDistAlpha': 'is a parameter to the distribution, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDotDistBeta': 'is a parameter to the distribution, a positive number. If beta = 1, GAMMA.DIST returns the standard gamma distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDotDistCumulative': 'is a logical value: return the cumulative distribution function = TRUE; return the probability mass function = FALSE or omitted',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDotInvProbability': 'is the probability associated with the gamma distribution, a number between 0 and 1, inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDotInvAlpha': 'is a parameter to the distribution, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaDotInvBeta': 'is a parameter to the distribution, a positive number. If beta = 1, GAMMA.INV returns the inverse of the standard gamma distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ModeMultNumber1': 'are 1 to 255 numbers, or names, arrays, or references that contain numbers for which you want the mode',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ModeMultNumber2': 'are 1 to 255 numbers, or names, arrays, or references that contain numbers for which you want the mode',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ModeSnglNumber1': 'are 1 to 255 numbers, or names, arrays, or references that contain numbers for which you want the mode',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ModeSnglNumber2': 'are 1 to 255 numbers, or names, arrays, or references that contain numbers for which you want the mode',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NormDistX': 'is the value for which you want the distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NormDistMean': 'is the arithmetic mean of the distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NormDistStandarddev': 'is the standard deviation of the distribution, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NormDistCumulative': 'is a logical value: for the cumulative distribution function, use TRUE; for the probability density function, use FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NormInvProbability': 'is a probability corresponding to the normal distribution, a number between 0 and 1 inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NormInvMean': 'is the arithmetic mean of the distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NormInvStandarddev': 'is the standard deviation of the distribution, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentileExcArray': 'is the array or range of data that defines relative standing',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentileExcK': 'is the percentile value that is between 0 through 1, inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentileIncArray': 'is the array or range of data that defines relative standing',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentileIncK': 'is the percentile value that is between 0 through 1, inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentRankExcArray': 'is the array or range of data with numeric values that defines relative standing',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentRankExcX': 'is the value for which you want to know the rank',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentRankExcSignificance': 'is an optional value that identifies the number of significant digits for the returned percentage, three digits if omitted (0.xxx%)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentRankIncArray': 'is the array or range of data with numeric values that defines relative standing',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentRankIncX': 'is the value for which you want to know the rank',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PercentRankIncSignificance': 'is an optional value that identifies the number of significant digits for the returned percentage, three digits if omitted (0.xxx%)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PoissonDotDistX': 'is the number of events',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PoissonDotDistMean': 'is the expected numeric value, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PoissonDotDistCumulative': 'is a logical value: for the cumulative Poisson probability, use TRUE; for the Poisson probability mass function, use FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.QuartileExcArray': 'is the array or cell range of numeric values for which you want the quartile value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.QuartileExcQuart': 'is a number: minimum value = 0; 1st quartile = 1; median value = 2; 3rd quartile = 3; maximum value = 4',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.QuartileIncArray': 'is the array or cell range of numeric values for which you want the quartile value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.QuartileIncQuart': 'is a number: minimum value = 0; 1st quartile = 1; median value = 2; 3rd quartile = 3; maximum value = 4',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RankDotAvgNumber': 'is the number for which you want to find the rank',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RankDotAvgRef': 'is an array of, or a reference to, a list of numbers. Nonnumeric values are ignored',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RankDotAvgOrder': 'is a number: rank in the list sorted descending = 0 or omitted; rank in the list sorted ascending = any nonzero value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RankDotEqNumber': 'is the number for which you want to find the rank',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RankDotEqRef': 'is an array of, or a reference to, a list of numbers. Nonnumeric values are ignored',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RankDotEqOrder': 'is a number: rank in the list sorted descending = 0 or omitted; rank in the list sorted ascending = any nonzero value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevDotSNumber1': 'are 1 to 255 numbers corresponding to a sample of a population and can be numbers or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevDotSNumber2': 'are 1 to 255 numbers corresponding to a sample of a population and can be numbers or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevDotPNumber1': 'are 1 to 255 numbers corresponding to a population and can be numbers or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.StDevDotPNumber2': 'are 1 to 255 numbers corresponding to a population and can be numbers or references that contain numbers',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotDistX': 'is the numeric value at which to evaluate the distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotDistDegfreedom': 'is an integer indicating the number of degrees of freedom that characterize the distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotDistCumulative': 'is a logical value: for the cumulative distribution function, use TRUE; for the probability density function, use FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotDistDot2tX': 'is the numeric value at which to evaluate the distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotDistDot2tDegfreedom': 'is an integer indicating the number of degrees of freedom that characterize the distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotDistDotTtX': 'is the numeric value at which to evaluate the distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotDistDotTtDegfreedom': 'is an integer indicating the number of degrees of freedom that characterize the distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotInvProbability': 'is the probability associated with the two-tailed Student\'s t-distribution, a number between 0 and 1 inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotInvDegfreedom': 'is a positive integer indicating the number of degrees of freedom to characterize the distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotInvDot2tProbability': 'is the probability associated with the two-tailed Student\'s t-distribution, a number between 0 and 1 inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotInvDot2tDegfreedom': 'is a positive integer indicating the number of degrees of freedom to characterize the distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VarDotSNumber1': 'are 1 to 255 numeric arguments corresponding to a sample of a population',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VarDotSNumber2': 'are 1 to 255 numeric arguments corresponding to a sample of a population',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VarDotPNumber1': 'are 1 to 255 numeric arguments corresponding to a population',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.VarDotPNumber2': 'are 1 to 255 numeric arguments corresponding to a population',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.WeibullDotDistX': 'is the value at which to evaluate the function, a nonnegative number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.WeibullDotDistAlpha': 'is a parameter to the distribution, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.WeibullDotDistBeta': 'is a parameter to the distribution, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.WeibullDotDistCumulative': 'is a logical value: for the cumulative distribution function, use TRUE; for the probability mass function, use FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NetworkDaysIntlStartdate': 'is a serial date number that represents the start date',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NetworkDaysIntlEnddate': 'is a serial date number that represents the end date',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NetworkDaysIntlWeekend': 'is a number or string specifying when weekends occur',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NetworkDaysIntlHolidays': 'is an optional set of one or more serial date numbers to exclude from the working calendar, such as state and federal holidays and floating holidays',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.WorkDayIntlStartdate': 'is a serial date number that represents the start date',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.WorkDayIntlDays': 'is the number of nonweekend and non-holiday days before or after start_date',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.WorkDayIntlWeekend': 'is a number or string specifying when weekends occur',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.WorkDayIntlHolidays': 'is an optional array of one or more serial date numbers to exclude from the working calendar, such as state and federal holidays and floating holidays',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IsoCeilingNumber': 'is the value you want to round',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IsoCeilingSignificance': 'is the optional multiple to which you want to round',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistX': 'is the value between A and B at which to evaluate the function',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistAlpha': 'is a parameter to the distribution and must be greater than 0',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistBeta': 'is a parameter to the distribution and must be greater than 0',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistCumulative': 'is a logical value: for the cumulative distribution function, use TRUE; for the probability density function, use FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistA': 'is an optional lower bound to the interval of x. If omitted, A = 0',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDistB': 'is an optional upper bound to the interval of x. If omitted, B = 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDotInvProbability': 'is a probability associated with the beta distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDotInvAlpha': 'is a parameter to the distribution and must be greater than 0',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDotInvBeta': 'is a parameter to the distribution and must be greater than 0',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDotInvA': 'is an optional lower bound to the interval of x. If omitted, A = 0',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BetaDotInvB': 'is an optional upper bound to the interval of x. If omitted, B = 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotDistX': 'is the value at which you want to evaluate the distribution, a nonnegative number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotDistDegfreedom': 'is the number of degrees of freedom, a number between 1 and 10^10, excluding 10^10',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotDistCumulative': 'is a logical value for the function to return: the cumulative distribution function = TRUE; the probability density function = FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotDistDotRtX': 'is the value at which you want to evaluate the distribution, a nonnegative number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotDistDotRtDegfreedom': 'is the number of degrees of freedom, a number between 1 and 10^10, excluding 10^10',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotInvProbability': 'is a probability associated with the chi-squared distribution, a value between 0 and 1 inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotInvDegfreedom': 'is the number of degrees of freedom, a number between 1 and 10^10, excluding 10^10',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotInvDotRtProbability': 'is a probability associated with the chi-squared distribution, a value between 0 and 1 inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ChisqDotInvDotRtDegfreedom': 'is the number of degrees of freedom, a number between 1 and 10^10, excluding 10^10',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotDistX': 'is the value at which to evaluate the function, a nonnegative number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotDistDegfreedom1': 'is the numerator degrees of freedom, a number between 1 and 10^10, excluding 10^10',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotDistDegfreedom2': 'is the denominator degrees of freedom, a number between 1 and 10^10, excluding 10^10',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotDistCumulative': 'is a logical value for the function to return: the cumulative distribution function = TRUE; the probability density function = FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotDistDotRtX': 'is the value at which to evaluate the function, a nonnegative number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotDistDotRtDegfreedom1': 'is the numerator degrees of freedom, a number between 1 and 10^10, excluding 10^10',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotDistDotRtDegfreedom2': 'is the denominator degrees of freedom, a number between 1 and 10^10, excluding 10^10',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotInvProbability': 'is a probability associated with the F cumulative distribution, a number between 0 and 1 inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotInvDegfreedom1': 'is the numerator degrees of freedom, a number between 1 and 10^10, excluding 10^10',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotInvDegfreedom2': 'is the denominator degrees of freedom, a number between 1 and 10^10, excluding 10^10',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotinvDotRtProbability': 'is a probability associated with the F cumulative distribution, a number between 0 and 1 inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotinvDotRtDegfreedom1': 'is the numerator degrees of freedom, a number between 1 and 10^10, excluding 10^10',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FDotinvDotRtDegfreedom2': 'is the denominator degrees of freedom, a number between 1 and 10^10, excluding 10^10',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.HypgeomDotDistSamples': 'is the number of successes in the sample',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.HypgeomDotDistNumbersample': 'is the size of the sample',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.HypgeomDotDistPopulations': 'is the number of successes in the population',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.HypgeomDotDistNumberpop': 'is the population size',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.HypgeomDotDistCumulative': 'is a logical value: for the cumulative distribution function, use TRUE; for the probability density function, use FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNormDistX': 'is the value at which to evaluate the function, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNormDistMean': 'is the mean of ln(x)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNormDistStandarddev': 'is the standard deviation of ln(x), a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNormDistCumulative': 'is a logical value: for the cumulative distribution function, use TRUE; for the probability density function, use FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNormInvProbability': 'is a probability associated with the lognormal distribution, a number between 0 and 1, inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNormInvMean': 'is the mean of ln(x)',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.LogNormInvStandarddev': 'is the standard deviation of ln(x), a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NegbinomDotDistNumberf': 'is the number of failures',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NegbinomDotDistNumbers': 'is the threshold number of successes',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NegbinomDotDistProbabilitys': 'is the probability of a success; a number between 0 and 1',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NegbinomDotDistCumulative': 'is a logical value: for the cumulative distribution function, use TRUE; for the probability mass function, use FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NormSDistZ': 'is the value for which you want the distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NormSDistCumulative': 'is a logical value for the function to return: the cumulative distribution function = TRUE; the probability density function = FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NormSInvProbability': 'is a probability corresponding to the normal distribution, a number between 0 and 1 inclusive',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotTestArray1': 'is the first data set',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotTestArray2': 'is the second data set',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotTestTails': 'specifies the number of distribution tails to return: one-tailed distribution = 1; two-tailed distribution = 2',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TDotTestType': 'is the kind of t-test: paired = 1, two-sample equal variance (homoscedastic) = 2, two-sample unequal variance = 3',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ZDotTestArray': 'is the array or range of data against which to test X',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ZDotTestX': 'is the value to test',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ZDotTestSigma': 'is the population (known) standard deviation. If omitted, the sample standard deviation is used',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ErfPreciseX': 'is the lower bound for integrating ERF.PRECISE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ErfcPreciseX': 'is the lower bound for integrating ERFC.PRECISE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaLnPreciseX': 'is the value for which you want to calculate GAMMALN.PRECISE, a positive number',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CeilingDotPreciseNumber': 'is the value you want to round',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CeilingDotPreciseSignificance': 'is the multiple to which you want to round',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FloorDotPreciseNumber': 'is the numeric value you want to round',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FloorDotPreciseSignificance': 'is the multiple to which you want to round. ',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ACotNumber': 'is the cotangent of the angle you want',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ACotHNumber': 'is the hyperbolic cotangent of the angle that you want',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CotNumber': 'is the angle in radians for which you want the cotangent',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CotHNumber': 'is the angle in radians for which you want the hyperbolic cotangent',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CscNumber': 'is the angle in radians for which you want the cosecant',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CscHNumber': 'is the angle in radians for which you want the hyperbolic cosecant',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SecNumber': 'is the angle in radians for which you want the secant',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SecHNumber': 'is the angle in radians for which you want the hyperbolic secant',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImTanInumber': 'is a complex number for which you want the tangent',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImCotInumber': 'is a complex number for which you want the cotangent',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImCscInumber': 'is a complex number for which you want the cosecant',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImCscHInumber': 'is a complex number for which you want the hyperbolic cosecant',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImSecInumber': 'is a complex number for which you want the secant',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImSecHInumber': 'is a complex number for which you want the hyperbolic secant',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BitAndNumber1': 'is the decimal representation of the binary number you want to evaluate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BitAndNumber2': 'is the decimal representation of the binary number you want to evaluate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BitOrNumber1': 'is the decimal representation of the binary number you want to evaluate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BitOrNumber2': 'is the decimal representation of the binary number you want to evaluate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BitXorNumber1': 'is the decimal representation of the binary number you want to evaluate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BitXorNumber2': 'is the decimal representation of the binary number you want to evaluate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BitLShiftNumber': 'is the decimal representation of the binary number you want to evaluate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BitLShiftShiftamount': 'is the number of bits that you want to shift Number left by',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BitRShiftNumber': 'is the decimal representation of the binary number you want to evaluate',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BitRShiftShiftamount': 'is the number of bits that you want to shift Number right by',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PermutationaNumber': 'is the total number of objects',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PermutationaNumberchosen': 'is the number of objects in each permutation',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CombinANumber': 'is the total number of items',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CombinANumberchosen': 'is the number of items in each combination',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.XOrLogical1': 'are 1 to 254 conditions you want to test that can be either TRUE or FALSE and can be logical values, arrays, or references',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.XOrLogical2': 'are 1 to 254 conditions you want to test that can be either TRUE or FALSE and can be logical values, arrays, or references',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PDurationRate': 'is the interest rate per period.',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PDurationPv': 'is the present value of the investment',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PDurationFv': 'is the desired future value of the investment',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BaseNumber': 'is the number that you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BaseRadix': 'is the base Radix that you want to convert the number into',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BaseMinlength': 'is the minimum length of the returned string.  If omitted leading zeros are not added',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DecimalNumber': 'is the number that you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DecimalRadix': 'is the base Radix of the number you are converting',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DaysEnddate': 'start_date and end_date are the two dates between which you want to know the number of days',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.DaysStartdate': 'start_date and end_date are the two dates between which you want to know the number of days',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDistRangeTrials': 'is the number of independent trials',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDistRangeProbabilitys': 'is the probability of success on each trial',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDistRangeNumbers': 'is the number of successes in trials',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.BinomDistRangeNumbers2': 'if provided this function returns the probability that the number of successful trials shall lie between number_s and number_s2',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.GammaX': 'is the value for which you want to calculate Gamma',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SkewPNumber1': 'are 1 to 254 numbers or names, arrays, or references that contain numbers for which you want the population skewness',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SkewPNumber2': 'are 1 to 254 numbers or names, arrays, or references that contain numbers for which you want the population skewness',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.PhiX': 'is the number for which you want the density of the standard normal distribution',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RRINper': 'is the number of periods for the investment',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RRIPv': 'is the present value of the investment',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.RRIFv': 'is the future value of the investment',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.UnicodeText': 'is the character that you want the Unicode value of',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MUnitDimension': 'is an integer specifying the dimension of the unit matrix that you want to return',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ArabicText': 'is the Roman numeral you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ISOWeekNumDate': 'is the date-time code used by Spreadsheet for date and time calculation',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NumberValueText': 'is the string representing the number you want to convert',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NumberValueDecimalseparator': 'is the character used as the decimal separator in the string',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.NumberValueGroupseparator': 'is the character used as the group separator in the string',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SheetValue': 'is the name of a sheet or a reference that you want the sheet number of.  If omitted the number of the sheet containing the function is returned',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SheetsReference': 'is a reference for which you want to know the number of sheets it contains.  If omitted the number of sheets in the workbook containing the function is returned',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FormulaTextReference': 'is a reference to a formula',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IsFormulaReference': 'is a reference to the cell you want to test.  Reference can be a cell reference, a formula, or name that refers to a cell',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IfNAValue': 'is any value or expression or reference',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IfNAValueifna': 'is any value or expression or reference',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CeilingMathNumber': 'is the value you want to round',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CeilingMathSignificance': 'is the multiple to which you want to round',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.CeilingMathMode': 'when given and nonzero this function will round away from zero',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FloorMathNumber': 'is the value you want to round',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FloorMathSignificance': 'is the multiple to which you want to round',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FloorMathMode': 'when given and nonzero this function will round towards zero',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImSinHInumber': 'is a complex number for which you want the hyperbolic sine',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ImCosHInumber': 'is a complex number for which you want the hyperbolic cosine',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FunctionFilterXMLXml': 'is a string in valid XML format',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FunctionFilterXMLXpath': 'is a string in standard XPath format',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.FunctionWebServiceUrl': 'is the URL of the web service',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.EncodeURLText': 'is a string to be URL encoded',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ConcatText1': 'are 1 to 254 text strings or ranges to be joined to a single text string',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.ConcatText2': 'are 1 to 254 text strings or ranges to be joined to a single text string',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IfsLogicaltest': 'is any value or expression that can be evaluated to TRUE or FALSE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.IfsValueiftrue': 'is the value returned if Logical_test is TRUE',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MaxIfsMaxrange': 'the cells in which to determine the maximum value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MaxIfsCriteriarange': 'is the range of cells you want evaluate for the particular condition',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MaxIfsCriteria': 'is the condition or criteria in the form of a number, expression, or text that defines which cells will be included when determining the maximum value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MinIfsMinrange': 'the cells in which to determine the minimum value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MinIfsCriteriarange': 'is the range of cells you want evaluate for the particular condition',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.MinIfsCriteria': 'is the condition or criteria in the form of a number, expression, or text that defines which cells will be included when determining the minimum value',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SwitchExpression': 'is an expression to be evaluated',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SwitchValue1': 'is a value to be compared with expression',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SwitchResult1': 'is a result to be returned if the corresponding value matches expression',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SwitchDefaultOrValue2': 'is a value to be compared with expression',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SwitchResult2': 'is a result to be returned if the corresponding value matches expression',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SwitchDefaultOrValue3': 'is a value to be compared with expression',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.SwitchResult3': 'is a result to be returned if the corresponding value matches expression',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TextJoinDelimeter': 'character or string to insert between each text item',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TextJoinIgnoreEmpty': 'if TRUE(default), ignores empty cells',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TextJoinText1': 'are 1 to 252 text strings or ranges to be joined',
                'XtraSpreadsheetFunctionArgumentDescriptionStringId.TextJoinText2': 'are 1 to 252 text strings or ranges to be joined',
                'XtraSpreadsheetFunctionArgumentNameStringId.CountValue1': 'value1',
                'XtraSpreadsheetFunctionArgumentNameStringId.CountValue2': 'value2',
                'XtraSpreadsheetFunctionArgumentNameStringId.IfLogicaltest': 'logical_test',
                'XtraSpreadsheetFunctionArgumentNameStringId.IfValueiftrue': 'value_if_true',
                'XtraSpreadsheetFunctionArgumentNameStringId.IfValueiffalse': 'value_if_false',
                'XtraSpreadsheetFunctionArgumentNameStringId.IsNAValue': 'value',
                'XtraSpreadsheetFunctionArgumentNameStringId.IsErrorValue': 'value',
                'XtraSpreadsheetFunctionArgumentNameStringId.SumNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.SumNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.AverageNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.AverageNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.MinNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.MinNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.MaxNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.MaxNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.RowReference': 'reference',
                'XtraSpreadsheetFunctionArgumentNameStringId.ColumnReference': 'reference',
                'XtraSpreadsheetFunctionArgumentNameStringId.NpvRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.NpvValue1': 'value1',
                'XtraSpreadsheetFunctionArgumentNameStringId.NpvValue2': 'value2',
                'XtraSpreadsheetFunctionArgumentNameStringId.StDevNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.StDevNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.DollarNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.DollarDecimals': 'decimals',
                'XtraSpreadsheetFunctionArgumentNameStringId.FixedNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.FixedDecimals': 'decimals',
                'XtraSpreadsheetFunctionArgumentNameStringId.FixedNocommas': 'no_commas',
                'XtraSpreadsheetFunctionArgumentNameStringId.SinNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.CosNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.TanNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.ATanNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.SqrtNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.ExpNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.LnNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.Log10Number': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.AbsNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.IntNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.SignNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.RoundNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.RoundNumdigits': 'num_digits',
                'XtraSpreadsheetFunctionArgumentNameStringId.LookupLookupvalue': 'lookup_value',
                'XtraSpreadsheetFunctionArgumentNameStringId.LookupLookupvector': 'lookup_vector',
                'XtraSpreadsheetFunctionArgumentNameStringId.LookupResultvector': 'result_vector',
                'XtraSpreadsheetFunctionArgumentNameStringId.IndexArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.IndexRownum': 'row_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.IndexColumnnum': 'column_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.ReptText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.ReptNumbertimes': 'number_times',
                'XtraSpreadsheetFunctionArgumentNameStringId.MidText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.MidStartnum': 'start_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.MidNumchars': 'num_chars',
                'XtraSpreadsheetFunctionArgumentNameStringId.LenText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.ValueText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.AndLogical1': 'logical1',
                'XtraSpreadsheetFunctionArgumentNameStringId.AndLogical2': 'logical2',
                'XtraSpreadsheetFunctionArgumentNameStringId.OrLogical1': 'logical1',
                'XtraSpreadsheetFunctionArgumentNameStringId.OrLogical2': 'logical2',
                'XtraSpreadsheetFunctionArgumentNameStringId.NotLogical': 'logical',
                'XtraSpreadsheetFunctionArgumentNameStringId.ModNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.ModDivisor': 'divisor',
                'XtraSpreadsheetFunctionArgumentNameStringId.DCountDatabase': 'database',
                'XtraSpreadsheetFunctionArgumentNameStringId.DCountField': 'field',
                'XtraSpreadsheetFunctionArgumentNameStringId.DCountCriteria': 'criteria',
                'XtraSpreadsheetFunctionArgumentNameStringId.DSumDatabase': 'database',
                'XtraSpreadsheetFunctionArgumentNameStringId.DSumField': 'field',
                'XtraSpreadsheetFunctionArgumentNameStringId.DSumCriteria': 'criteria',
                'XtraSpreadsheetFunctionArgumentNameStringId.DAverageDatabase': 'database',
                'XtraSpreadsheetFunctionArgumentNameStringId.DAverageField': 'field',
                'XtraSpreadsheetFunctionArgumentNameStringId.DAverageCriteria': 'criteria',
                'XtraSpreadsheetFunctionArgumentNameStringId.DMinDatabase': 'database',
                'XtraSpreadsheetFunctionArgumentNameStringId.DMinField': 'field',
                'XtraSpreadsheetFunctionArgumentNameStringId.DMinCriteria': 'criteria',
                'XtraSpreadsheetFunctionArgumentNameStringId.DMaxDatabase': 'database',
                'XtraSpreadsheetFunctionArgumentNameStringId.DMaxField': 'field',
                'XtraSpreadsheetFunctionArgumentNameStringId.DMaxCriteria': 'criteria',
                'XtraSpreadsheetFunctionArgumentNameStringId.DStDevDatabase': 'database',
                'XtraSpreadsheetFunctionArgumentNameStringId.DStDevField': 'field',
                'XtraSpreadsheetFunctionArgumentNameStringId.DStDevCriteria': 'criteria',
                'XtraSpreadsheetFunctionArgumentNameStringId.VarNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.VarNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.DVarDatabase': 'database',
                'XtraSpreadsheetFunctionArgumentNameStringId.DVarField': 'field',
                'XtraSpreadsheetFunctionArgumentNameStringId.DVarCriteria': 'criteria',
                'XtraSpreadsheetFunctionArgumentNameStringId.TextValue': 'value',
                'XtraSpreadsheetFunctionArgumentNameStringId.TextFormattext': 'format_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.LinestKnownys': 'known_y\'s',
                'XtraSpreadsheetFunctionArgumentNameStringId.LinestKnownxs': 'known_x\'s',
                'XtraSpreadsheetFunctionArgumentNameStringId.LinestConst': 'const',
                'XtraSpreadsheetFunctionArgumentNameStringId.LinestStats': 'stats',
                'XtraSpreadsheetFunctionArgumentNameStringId.TrendKnownys': 'known_y\'s',
                'XtraSpreadsheetFunctionArgumentNameStringId.TrendKnownxs': 'known_x\'s',
                'XtraSpreadsheetFunctionArgumentNameStringId.TrendNewxs': 'new_x\'s',
                'XtraSpreadsheetFunctionArgumentNameStringId.TrendConst': 'const',
                'XtraSpreadsheetFunctionArgumentNameStringId.LogestKnownys': 'known_y\'s',
                'XtraSpreadsheetFunctionArgumentNameStringId.LogestKnownxs': 'known_x\'s',
                'XtraSpreadsheetFunctionArgumentNameStringId.LogestConst': 'const',
                'XtraSpreadsheetFunctionArgumentNameStringId.LogestStats': 'stats',
                'XtraSpreadsheetFunctionArgumentNameStringId.GrowthKnownys': 'known_y\'s',
                'XtraSpreadsheetFunctionArgumentNameStringId.GrowthKnownxs': 'known_x\'s',
                'XtraSpreadsheetFunctionArgumentNameStringId.GrowthNewxs': 'new_x\'s',
                'XtraSpreadsheetFunctionArgumentNameStringId.GrowthConst': 'const',
                'XtraSpreadsheetFunctionArgumentNameStringId.PvRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.PvNper': 'nper',
                'XtraSpreadsheetFunctionArgumentNameStringId.PvPmt': 'pmt',
                'XtraSpreadsheetFunctionArgumentNameStringId.PvFv': 'fv',
                'XtraSpreadsheetFunctionArgumentNameStringId.PvType': 'type',
                'XtraSpreadsheetFunctionArgumentNameStringId.FvRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.FvNper': 'nper',
                'XtraSpreadsheetFunctionArgumentNameStringId.FvPmt': 'pmt',
                'XtraSpreadsheetFunctionArgumentNameStringId.FvPv': 'pv',
                'XtraSpreadsheetFunctionArgumentNameStringId.FvType': 'type',
                'XtraSpreadsheetFunctionArgumentNameStringId.NPerRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.NPerPmt': 'pmt',
                'XtraSpreadsheetFunctionArgumentNameStringId.NPerPv': 'pv',
                'XtraSpreadsheetFunctionArgumentNameStringId.NPerFv': 'fv',
                'XtraSpreadsheetFunctionArgumentNameStringId.NPerType': 'type',
                'XtraSpreadsheetFunctionArgumentNameStringId.PmtRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.PmtNper': 'nper',
                'XtraSpreadsheetFunctionArgumentNameStringId.PmtPv': 'pv',
                'XtraSpreadsheetFunctionArgumentNameStringId.PmtFv': 'fv',
                'XtraSpreadsheetFunctionArgumentNameStringId.PmtType': 'type',
                'XtraSpreadsheetFunctionArgumentNameStringId.RateNper': 'nper',
                'XtraSpreadsheetFunctionArgumentNameStringId.RatePmt': 'pmt',
                'XtraSpreadsheetFunctionArgumentNameStringId.RatePv': 'pv',
                'XtraSpreadsheetFunctionArgumentNameStringId.RateFv': 'fv',
                'XtraSpreadsheetFunctionArgumentNameStringId.RateType': 'type',
                'XtraSpreadsheetFunctionArgumentNameStringId.RateGuess': 'guess',
                'XtraSpreadsheetFunctionArgumentNameStringId.MirrValues': 'values',
                'XtraSpreadsheetFunctionArgumentNameStringId.MirrFinancerate': 'finance_rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.MirrReinvestrate': 'reinvest_rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.IrrValues': 'values',
                'XtraSpreadsheetFunctionArgumentNameStringId.IrrGuess': 'guess',
                'XtraSpreadsheetFunctionArgumentNameStringId.MatchLookupvalue': 'lookup_value',
                'XtraSpreadsheetFunctionArgumentNameStringId.MatchLookuparray': 'lookup_array',
                'XtraSpreadsheetFunctionArgumentNameStringId.MatchMatchtype': 'match_type',
                'XtraSpreadsheetFunctionArgumentNameStringId.DateYear': 'year',
                'XtraSpreadsheetFunctionArgumentNameStringId.DateMonth': 'month',
                'XtraSpreadsheetFunctionArgumentNameStringId.DateDay': 'day',
                'XtraSpreadsheetFunctionArgumentNameStringId.TimeHour': 'hour',
                'XtraSpreadsheetFunctionArgumentNameStringId.TimeMinute': 'minute',
                'XtraSpreadsheetFunctionArgumentNameStringId.TimeSecond': 'second',
                'XtraSpreadsheetFunctionArgumentNameStringId.DaySerialnumber': 'serial_number',
                'XtraSpreadsheetFunctionArgumentNameStringId.MonthSerialnumber': 'serial_number',
                'XtraSpreadsheetFunctionArgumentNameStringId.YearSerialnumber': 'serial_number',
                'XtraSpreadsheetFunctionArgumentNameStringId.WeekDaySerialnumber': 'serial_number',
                'XtraSpreadsheetFunctionArgumentNameStringId.WeekDayReturntype': 'return_type',
                'XtraSpreadsheetFunctionArgumentNameStringId.HourSerialnumber': 'serial_number',
                'XtraSpreadsheetFunctionArgumentNameStringId.MinuteSerialnumber': 'serial_number',
                'XtraSpreadsheetFunctionArgumentNameStringId.SecondSerialnumber': 'serial_number',
                'XtraSpreadsheetFunctionArgumentNameStringId.AreasReference': 'reference',
                'XtraSpreadsheetFunctionArgumentNameStringId.RowsArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.ColumnsArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.OffsetReference': 'reference',
                'XtraSpreadsheetFunctionArgumentNameStringId.OffsetRows': 'rows',
                'XtraSpreadsheetFunctionArgumentNameStringId.OffsetCols': 'cols',
                'XtraSpreadsheetFunctionArgumentNameStringId.OffsetHeight': 'height',
                'XtraSpreadsheetFunctionArgumentNameStringId.OffsetWidth': 'width',
                'XtraSpreadsheetFunctionArgumentNameStringId.SearchFindtext': 'find_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.SearchWithintext': 'within_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.SearchStartnum': 'start_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.TransposeArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.TypeValue': 'value',
                'XtraSpreadsheetFunctionArgumentNameStringId.ATan2Xnum': 'x_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.ATan2Ynum': 'y_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.ASinNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.ACosNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.ChooseIndexnum': 'index_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.ChooseValue1': 'value1',
                'XtraSpreadsheetFunctionArgumentNameStringId.ChooseValue2': 'value2',
                'XtraSpreadsheetFunctionArgumentNameStringId.HLookupLookupvalue': 'lookup_value',
                'XtraSpreadsheetFunctionArgumentNameStringId.HLookupTablearray': 'table_array',
                'XtraSpreadsheetFunctionArgumentNameStringId.HLookupRowindexnum': 'row_index_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.HLookupRangelookup': 'range_lookup',
                'XtraSpreadsheetFunctionArgumentNameStringId.VLookupLookupvalue': 'lookup_value',
                'XtraSpreadsheetFunctionArgumentNameStringId.VLookupTablearray': 'table_array',
                'XtraSpreadsheetFunctionArgumentNameStringId.VLookupColindexnum': 'col_index_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.VLookupRangelookup': 'range_lookup',
                'XtraSpreadsheetFunctionArgumentNameStringId.IsRefValue': 'value',
                'XtraSpreadsheetFunctionArgumentNameStringId.LogNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.LogBase': 'base',
                'XtraSpreadsheetFunctionArgumentNameStringId.CharNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.LowerText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.UpperText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.ProperText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.LeftText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.LeftNumchars': 'num_chars',
                'XtraSpreadsheetFunctionArgumentNameStringId.RightText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.RightNumchars': 'num_chars',
                'XtraSpreadsheetFunctionArgumentNameStringId.ExactText1': 'text1',
                'XtraSpreadsheetFunctionArgumentNameStringId.ExactText2': 'text2',
                'XtraSpreadsheetFunctionArgumentNameStringId.TrimText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.ReplaceOldtext': 'old_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.ReplaceStartnum': 'start_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.ReplaceNumchars': 'num_chars',
                'XtraSpreadsheetFunctionArgumentNameStringId.ReplaceNewtext': 'new_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.SubstituteText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.SubstituteOldtext': 'old_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.SubstituteNewtext': 'new_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.SubstituteInstancenum': 'instance_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.CodeText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.FindFindtext': 'find_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.FindWithintext': 'within_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.FindStartnum': 'start_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.CellInfotype': 'info_type',
                'XtraSpreadsheetFunctionArgumentNameStringId.CellReference': 'reference',
                'XtraSpreadsheetFunctionArgumentNameStringId.IsErrValue': 'value',
                'XtraSpreadsheetFunctionArgumentNameStringId.IsTextValue': 'value',
                'XtraSpreadsheetFunctionArgumentNameStringId.IsNumberValue': 'value',
                'XtraSpreadsheetFunctionArgumentNameStringId.IsBlankValue': 'value',
                'XtraSpreadsheetFunctionArgumentNameStringId.TValue': 'value',
                'XtraSpreadsheetFunctionArgumentNameStringId.NValue': 'value',
                'XtraSpreadsheetFunctionArgumentNameStringId.DateValueDatetext': 'date_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.TimeValueTimetext': 'time_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.SlnCost': 'cost',
                'XtraSpreadsheetFunctionArgumentNameStringId.SlnSalvage': 'salvage',
                'XtraSpreadsheetFunctionArgumentNameStringId.SlnLife': 'life',
                'XtraSpreadsheetFunctionArgumentNameStringId.SydCost': 'cost',
                'XtraSpreadsheetFunctionArgumentNameStringId.SydSalvage': 'salvage',
                'XtraSpreadsheetFunctionArgumentNameStringId.SydLife': 'life',
                'XtraSpreadsheetFunctionArgumentNameStringId.SydPer': 'per',
                'XtraSpreadsheetFunctionArgumentNameStringId.DdbCost': 'cost',
                'XtraSpreadsheetFunctionArgumentNameStringId.DdbSalvage': 'salvage',
                'XtraSpreadsheetFunctionArgumentNameStringId.DdbLife': 'life',
                'XtraSpreadsheetFunctionArgumentNameStringId.DdbPeriod': 'period',
                'XtraSpreadsheetFunctionArgumentNameStringId.DdbFactor': 'factor',
                'XtraSpreadsheetFunctionArgumentNameStringId.IndirectReftext': 'ref_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.IndirectA1': 'a1',
                'XtraSpreadsheetFunctionArgumentNameStringId.CallRegisterid': 'register_id',
                'XtraSpreadsheetFunctionArgumentNameStringId.CallArgument1': 'argument1',
                'XtraSpreadsheetFunctionArgumentNameStringId.CleanText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.MDetermArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.MInverseArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.MMultArray1': 'array1',
                'XtraSpreadsheetFunctionArgumentNameStringId.MMultArray2': 'array2',
                'XtraSpreadsheetFunctionArgumentNameStringId.IpmtRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.IpmtPer': 'per',
                'XtraSpreadsheetFunctionArgumentNameStringId.IpmtNper': 'nper',
                'XtraSpreadsheetFunctionArgumentNameStringId.IpmtPv': 'pv',
                'XtraSpreadsheetFunctionArgumentNameStringId.IpmtFv': 'fv',
                'XtraSpreadsheetFunctionArgumentNameStringId.IpmtType': 'type',
                'XtraSpreadsheetFunctionArgumentNameStringId.PpmtRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.PpmtPer': 'per',
                'XtraSpreadsheetFunctionArgumentNameStringId.PpmtNper': 'nper',
                'XtraSpreadsheetFunctionArgumentNameStringId.PpmtPv': 'pv',
                'XtraSpreadsheetFunctionArgumentNameStringId.PpmtFv': 'fv',
                'XtraSpreadsheetFunctionArgumentNameStringId.PpmtType': 'type',
                'XtraSpreadsheetFunctionArgumentNameStringId.CountAValue1': 'value1',
                'XtraSpreadsheetFunctionArgumentNameStringId.CountAValue2': 'value2',
                'XtraSpreadsheetFunctionArgumentNameStringId.ProductNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.ProductNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.FactNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.DProductDatabase': 'database',
                'XtraSpreadsheetFunctionArgumentNameStringId.DProductField': 'field',
                'XtraSpreadsheetFunctionArgumentNameStringId.DProductCriteria': 'criteria',
                'XtraSpreadsheetFunctionArgumentNameStringId.IsNonTextValue': 'value',
                'XtraSpreadsheetFunctionArgumentNameStringId.StDevPNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.StDevPNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.VarPNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.VarPNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.DStDevPDatabase': 'database',
                'XtraSpreadsheetFunctionArgumentNameStringId.DStDevPField': 'field',
                'XtraSpreadsheetFunctionArgumentNameStringId.DStDevPCriteria': 'criteria',
                'XtraSpreadsheetFunctionArgumentNameStringId.DVarPDatabase': 'database',
                'XtraSpreadsheetFunctionArgumentNameStringId.DVarPField': 'field',
                'XtraSpreadsheetFunctionArgumentNameStringId.DVarPCriteria': 'criteria',
                'XtraSpreadsheetFunctionArgumentNameStringId.TruncNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.TruncNumdigits': 'num_digits',
                'XtraSpreadsheetFunctionArgumentNameStringId.IsLogicalValue': 'value',
                'XtraSpreadsheetFunctionArgumentNameStringId.DCountADatabase': 'database',
                'XtraSpreadsheetFunctionArgumentNameStringId.DCountAField': 'field',
                'XtraSpreadsheetFunctionArgumentNameStringId.DCountACriteria': 'criteria',
                'XtraSpreadsheetFunctionArgumentNameStringId.FindBFindtext': 'find_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.FindBWithintext': 'within_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.FindBStartnum': 'start_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.SearchBFindtext': 'find_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.SearchBWithintext': 'within_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.SearchBStartnum': 'start_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.ReplaceBOldtext': 'old_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.ReplaceBStartnum': 'start_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.ReplaceBNumbytes': 'num_bytes',
                'XtraSpreadsheetFunctionArgumentNameStringId.ReplaceBNewtext': 'new_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.LeftBText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.LeftBNumbytes': 'num_bytes',
                'XtraSpreadsheetFunctionArgumentNameStringId.RightBText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.RightBNumbytes': 'num_bytes',
                'XtraSpreadsheetFunctionArgumentNameStringId.MidBText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.MidBStartnum': 'start_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.MidBNumbytes': 'num_bytes',
                'XtraSpreadsheetFunctionArgumentNameStringId.LenBText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.RoundUpNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.RoundUpNumdigits': 'num_digits',
                'XtraSpreadsheetFunctionArgumentNameStringId.RoundDownNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.RoundDownNumdigits': 'num_digits',
                'XtraSpreadsheetFunctionArgumentNameStringId.AscText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.RankNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.RankRef': 'ref',
                'XtraSpreadsheetFunctionArgumentNameStringId.RankOrder': 'order',
                'XtraSpreadsheetFunctionArgumentNameStringId.AddressRownum': 'row_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.AddressColumnnum': 'column_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.AddressAbsnum': 'abs_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.AddressA1': 'a1',
                'XtraSpreadsheetFunctionArgumentNameStringId.AddressSheettext': 'sheet_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.Days360Startdate': 'start_date',
                'XtraSpreadsheetFunctionArgumentNameStringId.Days360Enddate': 'end_date',
                'XtraSpreadsheetFunctionArgumentNameStringId.Days360Method': 'method',
                'XtraSpreadsheetFunctionArgumentNameStringId.VdbCost': 'cost',
                'XtraSpreadsheetFunctionArgumentNameStringId.VdbSalvage': 'salvage',
                'XtraSpreadsheetFunctionArgumentNameStringId.VdbLife': 'life',
                'XtraSpreadsheetFunctionArgumentNameStringId.VdbStartperiod': 'start_period',
                'XtraSpreadsheetFunctionArgumentNameStringId.VdbEndperiod': 'end_period',
                'XtraSpreadsheetFunctionArgumentNameStringId.VdbFactor': 'factor',
                'XtraSpreadsheetFunctionArgumentNameStringId.VdbNoswitch': 'no_switch',
                'XtraSpreadsheetFunctionArgumentNameStringId.MedianNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.MedianNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.SumProductArray1': 'array1',
                'XtraSpreadsheetFunctionArgumentNameStringId.SumProductArray2': 'array2',
                'XtraSpreadsheetFunctionArgumentNameStringId.SumProductArray3': 'array3',
                'XtraSpreadsheetFunctionArgumentNameStringId.SinHNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.CosHNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.TanHNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.ASinHNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.ACosHNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.ATanHNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.DGetDatabase': 'database',
                'XtraSpreadsheetFunctionArgumentNameStringId.DGetField': 'field',
                'XtraSpreadsheetFunctionArgumentNameStringId.DGetCriteria': 'criteria',
                'XtraSpreadsheetFunctionArgumentNameStringId.InfoTypetext': 'type_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.DbCost': 'cost',
                'XtraSpreadsheetFunctionArgumentNameStringId.DbSalvage': 'salvage',
                'XtraSpreadsheetFunctionArgumentNameStringId.DbLife': 'life',
                'XtraSpreadsheetFunctionArgumentNameStringId.DbPeriod': 'period',
                'XtraSpreadsheetFunctionArgumentNameStringId.DbMonth': 'month',
                'XtraSpreadsheetFunctionArgumentNameStringId.FrequencyDataarray': 'data_array',
                'XtraSpreadsheetFunctionArgumentNameStringId.FrequencyBinsarray': 'bins_array',
                'XtraSpreadsheetFunctionArgumentNameStringId.ErrorTypeErrorval': 'error_val',
                'XtraSpreadsheetFunctionArgumentNameStringId.RegisterIdModuletext': 'module_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.RegisterIdProcedure': 'procedure',
                'XtraSpreadsheetFunctionArgumentNameStringId.RegisterIdTypetext': 'type_text',
                'XtraSpreadsheetFunctionArgumentNameStringId.AvedevNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.AvedevNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaDistCompatibilityX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaDistCompatibilityAlpha': 'alpha',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaDistCompatibilityBeta': 'beta',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaDistCompatibilityA': 'A',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaDistCompatibilityB': 'B',
                'XtraSpreadsheetFunctionArgumentNameStringId.GammaLnX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaInvProbability': 'probability',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaInvAlpha': 'alpha',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaInvBeta': 'beta',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaInvA': 'A',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaInvB': 'B',
                'XtraSpreadsheetFunctionArgumentNameStringId.BinomDistNumbers': 'number_s',
                'XtraSpreadsheetFunctionArgumentNameStringId.BinomDistTrials': 'trials',
                'XtraSpreadsheetFunctionArgumentNameStringId.BinomDistProbabilitys': 'probability_s',
                'XtraSpreadsheetFunctionArgumentNameStringId.BinomDistCumulative': 'cumulative',
                'XtraSpreadsheetFunctionArgumentNameStringId.ChiDistX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.ChiDistDegfreedom': 'deg_freedom',
                'XtraSpreadsheetFunctionArgumentNameStringId.ChiInvProbability': 'probability',
                'XtraSpreadsheetFunctionArgumentNameStringId.ChiInvDegfreedom': 'deg_freedom',
                'XtraSpreadsheetFunctionArgumentNameStringId.CombinNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.CombinNumberchosen': 'number_chosen',
                'XtraSpreadsheetFunctionArgumentNameStringId.ConfidenceAlpha': 'alpha',
                'XtraSpreadsheetFunctionArgumentNameStringId.ConfidenceStandarddev': 'standard_dev',
                'XtraSpreadsheetFunctionArgumentNameStringId.ConfidenceSize': 'size',
                'XtraSpreadsheetFunctionArgumentNameStringId.CritBinomTrials': 'trials',
                'XtraSpreadsheetFunctionArgumentNameStringId.CritBinomProbabilitys': 'probability_s',
                'XtraSpreadsheetFunctionArgumentNameStringId.CritBinomAlpha': 'alpha',
                'XtraSpreadsheetFunctionArgumentNameStringId.EvenNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.ExponDistX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.ExponDistLambda': 'lambda',
                'XtraSpreadsheetFunctionArgumentNameStringId.ExponDistCumulative': 'cumulative',
                'XtraSpreadsheetFunctionArgumentNameStringId.FDistX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.FDistDegfreedom1': 'deg_freedom1',
                'XtraSpreadsheetFunctionArgumentNameStringId.FDistDegfreedom2': 'deg_freedom2',
                'XtraSpreadsheetFunctionArgumentNameStringId.FInvProbability': 'probability',
                'XtraSpreadsheetFunctionArgumentNameStringId.FInvDegfreedom1': 'deg_freedom1',
                'XtraSpreadsheetFunctionArgumentNameStringId.FInvDegfreedom2': 'deg_freedom2',
                'XtraSpreadsheetFunctionArgumentNameStringId.FisherX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.FisherInvY': 'y',
                'XtraSpreadsheetFunctionArgumentNameStringId.FloorNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.FloorSignificance': 'significance',
                'XtraSpreadsheetFunctionArgumentNameStringId.GammaDistX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.GammaDistAlpha': 'alpha',
                'XtraSpreadsheetFunctionArgumentNameStringId.GammaDistBeta': 'beta',
                'XtraSpreadsheetFunctionArgumentNameStringId.GammaDistCumulative': 'cumulative',
                'XtraSpreadsheetFunctionArgumentNameStringId.GammaInvProbability': 'probability',
                'XtraSpreadsheetFunctionArgumentNameStringId.GammaInvAlpha': 'alpha',
                'XtraSpreadsheetFunctionArgumentNameStringId.GammaInvBeta': 'beta',
                'XtraSpreadsheetFunctionArgumentNameStringId.CeilingNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.CeilingSignificance': 'significance',
                'XtraSpreadsheetFunctionArgumentNameStringId.HypGeomDistSamples': 'sample_s',
                'XtraSpreadsheetFunctionArgumentNameStringId.HypGeomDistNumbersample': 'number_sample',
                'XtraSpreadsheetFunctionArgumentNameStringId.HypGeomDistPopulations': 'population_s',
                'XtraSpreadsheetFunctionArgumentNameStringId.HypGeomDistNumberpop': 'number_pop',
                'XtraSpreadsheetFunctionArgumentNameStringId.LogNormDistCompatibilityX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.LogNormDistCompatibilityMean': 'mean',
                'XtraSpreadsheetFunctionArgumentNameStringId.LogNormDistCompatibilityStandarddev': 'standard_dev',
                'XtraSpreadsheetFunctionArgumentNameStringId.LogInvCompatibilityProbability': 'probability',
                'XtraSpreadsheetFunctionArgumentNameStringId.LogInvCompatibilityMean': 'mean',
                'XtraSpreadsheetFunctionArgumentNameStringId.LogInvCompatibilityStandarddev': 'standard_dev',
                'XtraSpreadsheetFunctionArgumentNameStringId.NegBinomDistNumberf': 'number_f',
                'XtraSpreadsheetFunctionArgumentNameStringId.NegBinomDistNumbers': 'number_s',
                'XtraSpreadsheetFunctionArgumentNameStringId.NegBinomDistProbabilitys': 'probability_s',
                'XtraSpreadsheetFunctionArgumentNameStringId.NormDistCompatibilityX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.NormDistCompatibilityMean': 'mean',
                'XtraSpreadsheetFunctionArgumentNameStringId.NormDistCompatibilityStandarddev': 'standard_dev',
                'XtraSpreadsheetFunctionArgumentNameStringId.NormDistCompatibilityCumulative': 'cumulative',
                'XtraSpreadsheetFunctionArgumentNameStringId.NormSDistCompatibilityZ': 'z',
                'XtraSpreadsheetFunctionArgumentNameStringId.NormInvCompatibilityProbability': 'probability',
                'XtraSpreadsheetFunctionArgumentNameStringId.NormInvCompatibilityMean': 'mean',
                'XtraSpreadsheetFunctionArgumentNameStringId.NormInvCompatibilityStandarddev': 'standard_dev',
                'XtraSpreadsheetFunctionArgumentNameStringId.NormSInvCompatibilityProbability': 'probability',
                'XtraSpreadsheetFunctionArgumentNameStringId.StandardizeX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.StandardizeMean': 'mean',
                'XtraSpreadsheetFunctionArgumentNameStringId.StandardizeStandarddev': 'standard_dev',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.PermutNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.PermutNumberchosen': 'number_chosen',
                'XtraSpreadsheetFunctionArgumentNameStringId.PoissonX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.PoissonMean': 'mean',
                'XtraSpreadsheetFunctionArgumentNameStringId.PoissonCumulative': 'cumulative',
                'XtraSpreadsheetFunctionArgumentNameStringId.TDistX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.TDistDegfreedom': 'deg_freedom',
                'XtraSpreadsheetFunctionArgumentNameStringId.TDistTails': 'tails',
                'XtraSpreadsheetFunctionArgumentNameStringId.WeibullX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.WeibullAlpha': 'alpha',
                'XtraSpreadsheetFunctionArgumentNameStringId.WeibullBeta': 'beta',
                'XtraSpreadsheetFunctionArgumentNameStringId.WeibullCumulative': 'cumulative',
                'XtraSpreadsheetFunctionArgumentNameStringId.SumXMY2Arrayx': 'array_x',
                'XtraSpreadsheetFunctionArgumentNameStringId.SumXMY2Arrayy': 'array_y',
                'XtraSpreadsheetFunctionArgumentNameStringId.SumX2MY2Arrayx': 'array_x',
                'XtraSpreadsheetFunctionArgumentNameStringId.SumX2MY2Arrayy': 'array_y',
                'XtraSpreadsheetFunctionArgumentNameStringId.SumX2PY2Arrayx': 'array_x',
                'XtraSpreadsheetFunctionArgumentNameStringId.SumX2PY2Arrayy': 'array_y',
                'XtraSpreadsheetFunctionArgumentNameStringId.ChiTestActualrange': 'actual_range',
                'XtraSpreadsheetFunctionArgumentNameStringId.ChiTestExpectedrange': 'expected_range',
                'XtraSpreadsheetFunctionArgumentNameStringId.CorrelArray1': 'array1',
                'XtraSpreadsheetFunctionArgumentNameStringId.CorrelArray2': 'array2',
                'XtraSpreadsheetFunctionArgumentNameStringId.CovarArray1': 'array1',
                'XtraSpreadsheetFunctionArgumentNameStringId.CovarArray2': 'array2',
                'XtraSpreadsheetFunctionArgumentNameStringId.ForecastX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.ForecastKnownys': 'known_y\'s',
                'XtraSpreadsheetFunctionArgumentNameStringId.ForecastKnownxs': 'known_x\'s',
                'XtraSpreadsheetFunctionArgumentNameStringId.FTestArray1': 'array1',
                'XtraSpreadsheetFunctionArgumentNameStringId.FTestArray2': 'array2',
                'XtraSpreadsheetFunctionArgumentNameStringId.InterceptKnownys': 'known_y\'s',
                'XtraSpreadsheetFunctionArgumentNameStringId.InterceptKnownxs': 'known_x\'s',
                'XtraSpreadsheetFunctionArgumentNameStringId.PearsonArray1': 'array1',
                'XtraSpreadsheetFunctionArgumentNameStringId.PearsonArray2': 'array2',
                'XtraSpreadsheetFunctionArgumentNameStringId.RsqKnownys': 'known_y\'s',
                'XtraSpreadsheetFunctionArgumentNameStringId.RsqKnownxs': 'known_x\'s',
                'XtraSpreadsheetFunctionArgumentNameStringId.StEYXKnownys': 'known_y\'s',
                'XtraSpreadsheetFunctionArgumentNameStringId.StEYXKnownxs': 'known_x\'s',
                'XtraSpreadsheetFunctionArgumentNameStringId.SlopeKnownys': 'known_y\'s',
                'XtraSpreadsheetFunctionArgumentNameStringId.SlopeKnownxs': 'known_x\'s',
                'XtraSpreadsheetFunctionArgumentNameStringId.TTestArray1': 'array1',
                'XtraSpreadsheetFunctionArgumentNameStringId.TTestArray2': 'array2',
                'XtraSpreadsheetFunctionArgumentNameStringId.TTestTails': 'tails',
                'XtraSpreadsheetFunctionArgumentNameStringId.TTestType': 'type',
                'XtraSpreadsheetFunctionArgumentNameStringId.ProbXrange': 'x_range',
                'XtraSpreadsheetFunctionArgumentNameStringId.ProbProbrange': 'prob_range',
                'XtraSpreadsheetFunctionArgumentNameStringId.ProbLowerlimit': 'lower_limit',
                'XtraSpreadsheetFunctionArgumentNameStringId.ProbUpperlimit': 'upper_limit',
                'XtraSpreadsheetFunctionArgumentNameStringId.DevSqNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.DevSqNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.GeomeanNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.GeomeanNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.HarMeanNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.HarMeanNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.SumSqNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.SumSqNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.KurtNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.KurtNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.SkewNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.SkewNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.ZTestArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.ZTestX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.ZTestSigma': 'sigma',
                'XtraSpreadsheetFunctionArgumentNameStringId.LargeArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.LargeK': 'k',
                'XtraSpreadsheetFunctionArgumentNameStringId.SmallArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.SmallK': 'k',
                'XtraSpreadsheetFunctionArgumentNameStringId.QuartileArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.QuartileQuart': 'quart',
                'XtraSpreadsheetFunctionArgumentNameStringId.PercentileArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.PercentileK': 'k',
                'XtraSpreadsheetFunctionArgumentNameStringId.PercentRankArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.PercentRankX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.PercentRankSignificance': 'significance',
                'XtraSpreadsheetFunctionArgumentNameStringId.ModeNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.ModeNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.TrimmeanArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.TrimmeanPercent': 'percent',
                'XtraSpreadsheetFunctionArgumentNameStringId.TinvProbability': 'probability',
                'XtraSpreadsheetFunctionArgumentNameStringId.TinvDegfreedom': 'deg_freedom',
                'XtraSpreadsheetFunctionArgumentNameStringId.ConcatenateText1': 'text1',
                'XtraSpreadsheetFunctionArgumentNameStringId.ConcatenateText2': 'text2',
                'XtraSpreadsheetFunctionArgumentNameStringId.PowerNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.PowerPower': 'power',
                'XtraSpreadsheetFunctionArgumentNameStringId.RadiansAngle': 'angle',
                'XtraSpreadsheetFunctionArgumentNameStringId.DegreesAngle': 'angle',
                'XtraSpreadsheetFunctionArgumentNameStringId.SubtotalFunctionnum': 'function_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.SubtotalRef1': 'ref1',
                'XtraSpreadsheetFunctionArgumentNameStringId.SumIfRange': 'range',
                'XtraSpreadsheetFunctionArgumentNameStringId.SumIfCriteria': 'criteria',
                'XtraSpreadsheetFunctionArgumentNameStringId.SumIfSumrange': 'sum_range',
                'XtraSpreadsheetFunctionArgumentNameStringId.CountIfRange': 'range',
                'XtraSpreadsheetFunctionArgumentNameStringId.CountIfCriteria': 'criteria',
                'XtraSpreadsheetFunctionArgumentNameStringId.CountBlankRange': 'range',
                'XtraSpreadsheetFunctionArgumentNameStringId.IsPmtRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.IsPmtPer': 'per',
                'XtraSpreadsheetFunctionArgumentNameStringId.IsPmtNper': 'nper',
                'XtraSpreadsheetFunctionArgumentNameStringId.IsPmtPv': 'pv',
                'XtraSpreadsheetFunctionArgumentNameStringId.RomanNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.RomanForm': 'form',
                'XtraSpreadsheetFunctionArgumentNameStringId.GetPivotDataDatafield': 'data_field',
                'XtraSpreadsheetFunctionArgumentNameStringId.GetPivotDataPivottable': 'pivot_table',
                'XtraSpreadsheetFunctionArgumentNameStringId.GetPivotDataField': 'field',
                'XtraSpreadsheetFunctionArgumentNameStringId.GetPivotDataItem': 'item',
                'XtraSpreadsheetFunctionArgumentNameStringId.HyperlinkLinklocation': 'link_location',
                'XtraSpreadsheetFunctionArgumentNameStringId.HyperlinkFriendlyname': 'friendly_name',
                'XtraSpreadsheetFunctionArgumentNameStringId.PhoneticReference': 'reference',
                'XtraSpreadsheetFunctionArgumentNameStringId.AverageAValue1': 'value1',
                'XtraSpreadsheetFunctionArgumentNameStringId.AverageAValue2': 'value2',
                'XtraSpreadsheetFunctionArgumentNameStringId.MaxAValue1': 'value1',
                'XtraSpreadsheetFunctionArgumentNameStringId.MaxAValue2': 'value2',
                'XtraSpreadsheetFunctionArgumentNameStringId.MinAValue1': 'value1',
                'XtraSpreadsheetFunctionArgumentNameStringId.MinAValue2': 'value2',
                'XtraSpreadsheetFunctionArgumentNameStringId.StDevPAValue1': 'value1',
                'XtraSpreadsheetFunctionArgumentNameStringId.StDevPAValue2': 'value2',
                'XtraSpreadsheetFunctionArgumentNameStringId.VarPAValue1': 'value1',
                'XtraSpreadsheetFunctionArgumentNameStringId.VarPAValue2': 'value2',
                'XtraSpreadsheetFunctionArgumentNameStringId.StDevAValue1': 'value1',
                'XtraSpreadsheetFunctionArgumentNameStringId.StDevAValue2': 'value2',
                'XtraSpreadsheetFunctionArgumentNameStringId.VarAValue1': 'value1',
                'XtraSpreadsheetFunctionArgumentNameStringId.VarAValue2': 'value2',
                'XtraSpreadsheetFunctionArgumentNameStringId.BahtTextNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.RtdProgID': 'progID',
                'XtraSpreadsheetFunctionArgumentNameStringId.RtdServer': 'server',
                'XtraSpreadsheetFunctionArgumentNameStringId.RtdTopic1': 'topic1',
                'XtraSpreadsheetFunctionArgumentNameStringId.RtdTopic2': 'topic2',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeValueConnection': 'connection',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeValueMemberexpression1': 'member_expression1',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeMemberConnection': 'connection',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeMemberMemberexpression': 'member_expression',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeMemberCaption': 'caption',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeMemberPropertyConnection': 'connection',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeMemberPropertyMemberexpression': 'member_expression',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeMemberPropertyProperty': 'property',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeRankedMemberConnection': 'connection',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeRankedMemberSetexpression': 'set_expression',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeRankedMemberRank': 'rank',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeRankedMemberCaption': 'caption',
                'XtraSpreadsheetFunctionArgumentNameStringId.Hex2BinNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.Hex2BinPlaces': 'places',
                'XtraSpreadsheetFunctionArgumentNameStringId.Hex2DecNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.Hex2OctNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.Hex2OctPlaces': 'places',
                'XtraSpreadsheetFunctionArgumentNameStringId.Dec2BinNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.Dec2BinPlaces': 'places',
                'XtraSpreadsheetFunctionArgumentNameStringId.Dec2HexNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.Dec2HexPlaces': 'places',
                'XtraSpreadsheetFunctionArgumentNameStringId.Dec2OctNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.Dec2OctPlaces': 'places',
                'XtraSpreadsheetFunctionArgumentNameStringId.Oct2BinNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.Oct2BinPlaces': 'places',
                'XtraSpreadsheetFunctionArgumentNameStringId.Oct2HexNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.Oct2HexPlaces': 'places',
                'XtraSpreadsheetFunctionArgumentNameStringId.Oct2DecNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.Bin2DecNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.Bin2OctNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.Bin2OctPlaces': 'places',
                'XtraSpreadsheetFunctionArgumentNameStringId.Bin2HexNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.Bin2HexPlaces': 'places',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImSubInumber1': 'inumber1',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImSubInumber2': 'inumber2',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImDivInumber1': 'inumber1',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImDivInumber2': 'inumber2',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImPowerInumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImPowerNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImAbsInumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImSqrtInumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImLnInumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImLog2Inumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImLog10Inumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImSinInumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImCosInumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImExpInumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImArgumentInumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImConjugateInumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImaginaryInumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImRealInumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.ComplexRealnum': 'real_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.ComplexInum': 'i_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.ComplexSuffix': 'suffix',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImSumInumber1': 'inumber1',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImSumInumber2': 'inumber2',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImProductInumber1': 'inumber1',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImProductInumber2': 'inumber2',
                'XtraSpreadsheetFunctionArgumentNameStringId.SeriessumX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.SeriessumN': 'n',
                'XtraSpreadsheetFunctionArgumentNameStringId.SeriessumM': 'm',
                'XtraSpreadsheetFunctionArgumentNameStringId.SeriessumCoefficients': 'coefficients',
                'XtraSpreadsheetFunctionArgumentNameStringId.FactDoubleNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.SqrtPiNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.QuotientNumerator': 'numerator',
                'XtraSpreadsheetFunctionArgumentNameStringId.QuotientDenominator': 'denominator',
                'XtraSpreadsheetFunctionArgumentNameStringId.DeltaNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.DeltaNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.GestepNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.GestepStep': 'step',
                'XtraSpreadsheetFunctionArgumentNameStringId.IsEvenNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.IsOddNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.MRoundNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.MRoundMultiple': 'multiple',
                'XtraSpreadsheetFunctionArgumentNameStringId.ErfLowerlimit': 'lower_limit',
                'XtraSpreadsheetFunctionArgumentNameStringId.ErfUpperlimit': 'upper_limit',
                'XtraSpreadsheetFunctionArgumentNameStringId.ErfcX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.BesselJX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.BesselJN': 'n',
                'XtraSpreadsheetFunctionArgumentNameStringId.BesselKX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.BesselKN': 'n',
                'XtraSpreadsheetFunctionArgumentNameStringId.BesselYX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.BesselYN': 'n',
                'XtraSpreadsheetFunctionArgumentNameStringId.BesselIX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.BesselIN': 'n',
                'XtraSpreadsheetFunctionArgumentNameStringId.XirrValues': 'values',
                'XtraSpreadsheetFunctionArgumentNameStringId.XirrDates': 'dates',
                'XtraSpreadsheetFunctionArgumentNameStringId.XirrGuess': 'guess',
                'XtraSpreadsheetFunctionArgumentNameStringId.XnpvRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.XnpvValues': 'values',
                'XtraSpreadsheetFunctionArgumentNameStringId.XnpvDates': 'dates',
                'XtraSpreadsheetFunctionArgumentNameStringId.PriceMatSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.PriceMatMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.PriceMatIssue': 'issue',
                'XtraSpreadsheetFunctionArgumentNameStringId.PriceMatRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.PriceMatYld': 'yld',
                'XtraSpreadsheetFunctionArgumentNameStringId.PriceMatBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.YieldMatSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.YieldMatMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.YieldMatIssue': 'issue',
                'XtraSpreadsheetFunctionArgumentNameStringId.YieldMatRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.YieldMatPr': 'pr',
                'XtraSpreadsheetFunctionArgumentNameStringId.YieldMatBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.IntrateSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.IntrateMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.IntrateInvestment': 'investment',
                'XtraSpreadsheetFunctionArgumentNameStringId.IntrateRedemption': 'redemption',
                'XtraSpreadsheetFunctionArgumentNameStringId.IntrateBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.ReceivedSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.ReceivedMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.ReceivedInvestment': 'investment',
                'XtraSpreadsheetFunctionArgumentNameStringId.ReceivedDiscount': 'discount',
                'XtraSpreadsheetFunctionArgumentNameStringId.ReceivedBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.DiscSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.DiscMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.DiscPr': 'pr',
                'XtraSpreadsheetFunctionArgumentNameStringId.DiscRedemption': 'redemption',
                'XtraSpreadsheetFunctionArgumentNameStringId.DiscBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.PriceDiscSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.PriceDiscMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.PriceDiscDiscount': 'discount',
                'XtraSpreadsheetFunctionArgumentNameStringId.PriceDiscRedemption': 'redemption',
                'XtraSpreadsheetFunctionArgumentNameStringId.PriceDiscBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.YieldDiscSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.YieldDiscMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.YieldDiscPr': 'pr',
                'XtraSpreadsheetFunctionArgumentNameStringId.YieldDiscRedemption': 'redemption',
                'XtraSpreadsheetFunctionArgumentNameStringId.YieldDiscBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.TbillEqSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.TbillEqMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.TbillEqDiscount': 'discount',
                'XtraSpreadsheetFunctionArgumentNameStringId.TbillPriceSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.TbillPriceMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.TbillPriceDiscount': 'discount',
                'XtraSpreadsheetFunctionArgumentNameStringId.TbillYieldSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.TbillYieldMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.TbillYieldPr': 'pr',
                'XtraSpreadsheetFunctionArgumentNameStringId.PriceSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.PriceMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.PriceRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.PriceYld': 'yld',
                'XtraSpreadsheetFunctionArgumentNameStringId.PriceRedemption': 'redemption',
                'XtraSpreadsheetFunctionArgumentNameStringId.PriceFrequency': 'frequency',
                'XtraSpreadsheetFunctionArgumentNameStringId.PriceBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.YieldSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.YieldMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.YieldRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.YieldPr': 'pr',
                'XtraSpreadsheetFunctionArgumentNameStringId.YieldRedemption': 'redemption',
                'XtraSpreadsheetFunctionArgumentNameStringId.YieldFrequency': 'frequency',
                'XtraSpreadsheetFunctionArgumentNameStringId.YieldBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.DollarDeFractionaldollar': 'fractional_dollar',
                'XtraSpreadsheetFunctionArgumentNameStringId.DollarDeFraction': 'fraction',
                'XtraSpreadsheetFunctionArgumentNameStringId.DollarFrDecimaldollar': 'decimal_dollar',
                'XtraSpreadsheetFunctionArgumentNameStringId.DollarFrFraction': 'fraction',
                'XtraSpreadsheetFunctionArgumentNameStringId.NominalEffectrate': 'effect_rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.NominalNpery': 'npery',
                'XtraSpreadsheetFunctionArgumentNameStringId.EffectNominalrate': 'nominal_rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.EffectNpery': 'npery',
                'XtraSpreadsheetFunctionArgumentNameStringId.CumPrincRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.CumPrincNper': 'nper',
                'XtraSpreadsheetFunctionArgumentNameStringId.CumPrincPv': 'pv',
                'XtraSpreadsheetFunctionArgumentNameStringId.CumPrincStartperiod': 'start_period',
                'XtraSpreadsheetFunctionArgumentNameStringId.CumPrincEndperiod': 'end_period',
                'XtraSpreadsheetFunctionArgumentNameStringId.CumPrincType': 'type',
                'XtraSpreadsheetFunctionArgumentNameStringId.CumIpmtRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.CumIpmtNper': 'nper',
                'XtraSpreadsheetFunctionArgumentNameStringId.CumIpmtPv': 'pv',
                'XtraSpreadsheetFunctionArgumentNameStringId.CumIpmtStartperiod': 'start_period',
                'XtraSpreadsheetFunctionArgumentNameStringId.CumIpmtEndperiod': 'end_period',
                'XtraSpreadsheetFunctionArgumentNameStringId.CumIpmtType': 'type',
                'XtraSpreadsheetFunctionArgumentNameStringId.EDateStartdate': 'start_date',
                'XtraSpreadsheetFunctionArgumentNameStringId.EDateMonths': 'months',
                'XtraSpreadsheetFunctionArgumentNameStringId.EOMonthStartdate': 'start_date',
                'XtraSpreadsheetFunctionArgumentNameStringId.EOMonthMonths': 'months',
                'XtraSpreadsheetFunctionArgumentNameStringId.YearFracStartdate': 'start_date',
                'XtraSpreadsheetFunctionArgumentNameStringId.YearFracEnddate': 'end_date',
                'XtraSpreadsheetFunctionArgumentNameStringId.YearFracBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.CoupDaybsSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.CoupDaybsMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.CoupDaybsFrequency': 'frequency',
                'XtraSpreadsheetFunctionArgumentNameStringId.CoupDaybsBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.CoupDaysSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.CoupDaysMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.CoupDaysFrequency': 'frequency',
                'XtraSpreadsheetFunctionArgumentNameStringId.CoupDaysBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.CoupDaysncSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.CoupDaysncMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.CoupDaysncFrequency': 'frequency',
                'XtraSpreadsheetFunctionArgumentNameStringId.CoupDaysncBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.CoupncdSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.CoupncdMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.CoupncdFrequency': 'frequency',
                'XtraSpreadsheetFunctionArgumentNameStringId.CoupncdBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.CoupNumSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.CoupNumMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.CoupNumFrequency': 'frequency',
                'XtraSpreadsheetFunctionArgumentNameStringId.CoupNumBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.CouppcdSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.CouppcdMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.CouppcdFrequency': 'frequency',
                'XtraSpreadsheetFunctionArgumentNameStringId.CouppcdBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.DurationSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.DurationMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.DurationCoupon': 'coupon',
                'XtraSpreadsheetFunctionArgumentNameStringId.DurationYld': 'yld',
                'XtraSpreadsheetFunctionArgumentNameStringId.DurationFrequency': 'frequency',
                'XtraSpreadsheetFunctionArgumentNameStringId.DurationBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.MDurationSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.MDurationMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.MDurationCoupon': 'coupon',
                'XtraSpreadsheetFunctionArgumentNameStringId.MDurationYld': 'yld',
                'XtraSpreadsheetFunctionArgumentNameStringId.MDurationFrequency': 'frequency',
                'XtraSpreadsheetFunctionArgumentNameStringId.MDurationBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddLPriceSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddLPriceMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddLPriceLastinterest': 'last_interest',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddLPriceRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddLPriceYld': 'yld',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddLPriceRedemption': 'redemption',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddLPriceFrequency': 'frequency',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddLPriceBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddLYieldSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddLYieldMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddLYieldLastinterest': 'last_interest',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddLYieldRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddLYieldPr': 'pr',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddLYieldRedemption': 'redemption',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddLYieldFrequency': 'frequency',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddLYieldBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddFPriceSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddFPriceMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddFPriceIssue': 'issue',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddFPriceFirstcoupon': 'first_coupon',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddFPriceRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddFPriceYld': 'yld',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddFPriceRedemption': 'redemption',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddFPriceFrequency': 'frequency',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddFPriceBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddFYieldSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddFYieldMaturity': 'maturity',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddFYieldIssue': 'issue',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddFYieldFirstcoupon': 'first_coupon',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddFYieldRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddFYieldPr': 'pr',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddFYieldRedemption': 'redemption',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddFYieldFrequency': 'frequency',
                'XtraSpreadsheetFunctionArgumentNameStringId.OddFYieldBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.RandBetweenBottom': 'bottom',
                'XtraSpreadsheetFunctionArgumentNameStringId.RandBetweenTop': 'top',
                'XtraSpreadsheetFunctionArgumentNameStringId.WeekNumSerialnumber': 'serial_number',
                'XtraSpreadsheetFunctionArgumentNameStringId.WeekNumReturntype': 'return_type',
                'XtraSpreadsheetFunctionArgumentNameStringId.AmordegrcCost': 'cost',
                'XtraSpreadsheetFunctionArgumentNameStringId.AmordegrcDatepurchased': 'date_purchased',
                'XtraSpreadsheetFunctionArgumentNameStringId.AmordegrcFirstperiod': 'first_period',
                'XtraSpreadsheetFunctionArgumentNameStringId.AmordegrcSalvage': 'salvage',
                'XtraSpreadsheetFunctionArgumentNameStringId.AmordegrcPeriod': 'period',
                'XtraSpreadsheetFunctionArgumentNameStringId.AmordegrcRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.AmordegrcBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.AmorlincCost': 'cost',
                'XtraSpreadsheetFunctionArgumentNameStringId.AmorlincDatepurchased': 'date_purchased',
                'XtraSpreadsheetFunctionArgumentNameStringId.AmorlincFirstperiod': 'first_period',
                'XtraSpreadsheetFunctionArgumentNameStringId.AmorlincSalvage': 'salvage',
                'XtraSpreadsheetFunctionArgumentNameStringId.AmorlincPeriod': 'period',
                'XtraSpreadsheetFunctionArgumentNameStringId.AmorlincRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.AmorlincBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.ConvertNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.ConvertFromunit': 'from_unit',
                'XtraSpreadsheetFunctionArgumentNameStringId.ConvertTounit': 'to_unit',
                'XtraSpreadsheetFunctionArgumentNameStringId.AccrintIssue': 'issue',
                'XtraSpreadsheetFunctionArgumentNameStringId.AccrintFirstinterest': 'first_interest',
                'XtraSpreadsheetFunctionArgumentNameStringId.AccrintSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.AccrintRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.AccrintPar': 'par',
                'XtraSpreadsheetFunctionArgumentNameStringId.AccrintFrequency': 'frequency',
                'XtraSpreadsheetFunctionArgumentNameStringId.AccrintBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.AccrintCalcmethod': 'calc_method',
                'XtraSpreadsheetFunctionArgumentNameStringId.AccrintmIssue': 'issue',
                'XtraSpreadsheetFunctionArgumentNameStringId.AccrintmSettlement': 'settlement',
                'XtraSpreadsheetFunctionArgumentNameStringId.AccrintmRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.AccrintmPar': 'par',
                'XtraSpreadsheetFunctionArgumentNameStringId.AccrintmBasis': 'basis',
                'XtraSpreadsheetFunctionArgumentNameStringId.WorkDayStartdate': 'start_date',
                'XtraSpreadsheetFunctionArgumentNameStringId.WorkDayDays': 'days',
                'XtraSpreadsheetFunctionArgumentNameStringId.WorkDayHolidays': 'holidays',
                'XtraSpreadsheetFunctionArgumentNameStringId.NetworkDaysStartdate': 'start_date',
                'XtraSpreadsheetFunctionArgumentNameStringId.NetworkDaysEnddate': 'end_date',
                'XtraSpreadsheetFunctionArgumentNameStringId.NetworkDaysHolidays': 'holidays',
                'XtraSpreadsheetFunctionArgumentNameStringId.GcdNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.GcdNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.MultinomialNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.MultinomialNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.LcmNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.LcmNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.FvSchedulePrincipal': 'principal',
                'XtraSpreadsheetFunctionArgumentNameStringId.FvScheduleSchedule': 'schedule',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeKpiMemberConnection': 'connection',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeKpiMemberKpiname': 'kpi_name',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeKpiMemberKpiproperty': 'kpi_property',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeKpiMemberCaption': 'caption',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeSetConnection': 'connection',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeSetSetexpression': 'set_expression',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeSetCaption': 'caption',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeSetSortorder': 'sort_order',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeSetSortby': 'sort_by',
                'XtraSpreadsheetFunctionArgumentNameStringId.CubeSetCountSet': 'set',
                'XtraSpreadsheetFunctionArgumentNameStringId.IfErrorValue': 'value',
                'XtraSpreadsheetFunctionArgumentNameStringId.IfErrorValueiferror': 'value_if_error',
                'XtraSpreadsheetFunctionArgumentNameStringId.CountIfsCriteriarange': 'criteria_range',
                'XtraSpreadsheetFunctionArgumentNameStringId.CountIfsCriteria': 'criteria',
                'XtraSpreadsheetFunctionArgumentNameStringId.SumIfsSumrange': 'sum_range',
                'XtraSpreadsheetFunctionArgumentNameStringId.SumIfsCriteriarange': 'criteria_range',
                'XtraSpreadsheetFunctionArgumentNameStringId.SumIfsCriteria': 'criteria',
                'XtraSpreadsheetFunctionArgumentNameStringId.AverageIfRange': 'range',
                'XtraSpreadsheetFunctionArgumentNameStringId.AverageIfCriteria': 'criteria',
                'XtraSpreadsheetFunctionArgumentNameStringId.AverageIfAveragerange': 'average_range',
                'XtraSpreadsheetFunctionArgumentNameStringId.AverageIfsAveragerange': 'average_range',
                'XtraSpreadsheetFunctionArgumentNameStringId.AverageIfsCriteriarange': 'criteria_range',
                'XtraSpreadsheetFunctionArgumentNameStringId.AverageIfsCriteria': 'criteria',
                'XtraSpreadsheetFunctionArgumentNameStringId.AggregateFunctionnum': 'function_num',
                'XtraSpreadsheetFunctionArgumentNameStringId.AggregateOptions': 'options',
                'XtraSpreadsheetFunctionArgumentNameStringId.AggregateArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.AggregateK': 'k',
                'XtraSpreadsheetFunctionArgumentNameStringId.BinomDotDistNumbers': 'number_s',
                'XtraSpreadsheetFunctionArgumentNameStringId.BinomDotDistTrials': 'trials',
                'XtraSpreadsheetFunctionArgumentNameStringId.BinomDotDistProbabilitys': 'probability_s',
                'XtraSpreadsheetFunctionArgumentNameStringId.BinomDotDistCumulative': 'cumulative',
                'XtraSpreadsheetFunctionArgumentNameStringId.BinomDotInvTrials': 'trials',
                'XtraSpreadsheetFunctionArgumentNameStringId.BinomDotInvProbabilitys': 'probability_s',
                'XtraSpreadsheetFunctionArgumentNameStringId.BinomDotInvAlpha': 'alpha',
                'XtraSpreadsheetFunctionArgumentNameStringId.ConfidenceNormAlpha': 'alpha',
                'XtraSpreadsheetFunctionArgumentNameStringId.ConfidenceNormStandarddev': 'standard_dev',
                'XtraSpreadsheetFunctionArgumentNameStringId.ConfidenceNormSize': 'size',
                'XtraSpreadsheetFunctionArgumentNameStringId.ConfidenceDotTAlpha': 'alpha',
                'XtraSpreadsheetFunctionArgumentNameStringId.ConfidenceDotTStandarddev': 'standard_dev',
                'XtraSpreadsheetFunctionArgumentNameStringId.ConfidenceDotTSize': 'size',
                'XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotTestActualrange': 'actual_range',
                'XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotTestExpectedrange': 'expected_range',
                'XtraSpreadsheetFunctionArgumentNameStringId.FDotTestArray1': 'array1',
                'XtraSpreadsheetFunctionArgumentNameStringId.FDotTestArray2': 'array2',
                'XtraSpreadsheetFunctionArgumentNameStringId.CovariancePArray1': 'array1',
                'XtraSpreadsheetFunctionArgumentNameStringId.CovariancePArray2': 'array2',
                'XtraSpreadsheetFunctionArgumentNameStringId.CovarianceSArray1': 'array1',
                'XtraSpreadsheetFunctionArgumentNameStringId.CovarianceSArray2': 'array2',
                'XtraSpreadsheetFunctionArgumentNameStringId.ExponDotDistX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.ExponDotDistLambda': 'lambda',
                'XtraSpreadsheetFunctionArgumentNameStringId.ExponDotDistCumulative': 'cumulative',
                'XtraSpreadsheetFunctionArgumentNameStringId.GammaDotDistX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.GammaDotDistAlpha': 'alpha',
                'XtraSpreadsheetFunctionArgumentNameStringId.GammaDotDistBeta': 'beta',
                'XtraSpreadsheetFunctionArgumentNameStringId.GammaDotDistCumulative': 'cumulative',
                'XtraSpreadsheetFunctionArgumentNameStringId.GammaDotInvProbability': 'probability',
                'XtraSpreadsheetFunctionArgumentNameStringId.GammaDotInvAlpha': 'alpha',
                'XtraSpreadsheetFunctionArgumentNameStringId.GammaDotInvBeta': 'beta',
                'XtraSpreadsheetFunctionArgumentNameStringId.ModeMultNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.ModeMultNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.ModeSnglNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.ModeSnglNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.NormDistX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.NormDistMean': 'mean',
                'XtraSpreadsheetFunctionArgumentNameStringId.NormDistStandarddev': 'standard_dev',
                'XtraSpreadsheetFunctionArgumentNameStringId.NormDistCumulative': 'cumulative',
                'XtraSpreadsheetFunctionArgumentNameStringId.NormInvProbability': 'probability',
                'XtraSpreadsheetFunctionArgumentNameStringId.NormInvMean': 'mean',
                'XtraSpreadsheetFunctionArgumentNameStringId.NormInvStandarddev': 'standard_dev',
                'XtraSpreadsheetFunctionArgumentNameStringId.PercentileExcArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.PercentileExcK': 'k',
                'XtraSpreadsheetFunctionArgumentNameStringId.PercentileIncArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.PercentileIncK': 'k',
                'XtraSpreadsheetFunctionArgumentNameStringId.PercentRankExcArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.PercentRankExcX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.PercentRankExcSignificance': 'significance',
                'XtraSpreadsheetFunctionArgumentNameStringId.PercentRankIncArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.PercentRankIncX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.PercentRankIncSignificance': 'significance',
                'XtraSpreadsheetFunctionArgumentNameStringId.PoissonDotDistX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.PoissonDotDistMean': 'mean',
                'XtraSpreadsheetFunctionArgumentNameStringId.PoissonDotDistCumulative': 'cumulative',
                'XtraSpreadsheetFunctionArgumentNameStringId.QuartileExcArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.QuartileExcQuart': 'quart',
                'XtraSpreadsheetFunctionArgumentNameStringId.QuartileIncArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.QuartileIncQuart': 'quart',
                'XtraSpreadsheetFunctionArgumentNameStringId.RankDotAvgNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.RankDotAvgRef': 'ref',
                'XtraSpreadsheetFunctionArgumentNameStringId.RankDotAvgOrder': 'order',
                'XtraSpreadsheetFunctionArgumentNameStringId.RankDotEqNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.RankDotEqRef': 'ref',
                'XtraSpreadsheetFunctionArgumentNameStringId.RankDotEqOrder': 'order',
                'XtraSpreadsheetFunctionArgumentNameStringId.StDevDotSNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.StDevDotSNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.StDevDotPNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.StDevDotPNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.TDotDistX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.TDotDistDegfreedom': 'deg_freedom',
                'XtraSpreadsheetFunctionArgumentNameStringId.TDotDistCumulative': 'cumulative',
                'XtraSpreadsheetFunctionArgumentNameStringId.TDotDistDot2tX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.TDotDistDot2tDegfreedom': 'deg_freedom',
                'XtraSpreadsheetFunctionArgumentNameStringId.TDotDistDotTtX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.TDotDistDotTtDegfreedom': 'deg_freedom',
                'XtraSpreadsheetFunctionArgumentNameStringId.TDotInvProbability': 'probability',
                'XtraSpreadsheetFunctionArgumentNameStringId.TDotInvDegfreedom': 'deg_freedom',
                'XtraSpreadsheetFunctionArgumentNameStringId.TDotInvDot2tProbability': 'probability',
                'XtraSpreadsheetFunctionArgumentNameStringId.TDotInvDot2tDegfreedom': 'deg_freedom',
                'XtraSpreadsheetFunctionArgumentNameStringId.VarDotSNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.VarDotSNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.VarDotPNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.VarDotPNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.WeibullDotDistX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.WeibullDotDistAlpha': 'alpha',
                'XtraSpreadsheetFunctionArgumentNameStringId.WeibullDotDistBeta': 'beta',
                'XtraSpreadsheetFunctionArgumentNameStringId.WeibullDotDistCumulative': 'cumulative',
                'XtraSpreadsheetFunctionArgumentNameStringId.NetworkDaysIntlStartdate': 'start_date',
                'XtraSpreadsheetFunctionArgumentNameStringId.NetworkDaysIntlEnddate': 'end_date',
                'XtraSpreadsheetFunctionArgumentNameStringId.NetworkDaysIntlWeekend': 'weekend',
                'XtraSpreadsheetFunctionArgumentNameStringId.NetworkDaysIntlHolidays': 'holidays',
                'XtraSpreadsheetFunctionArgumentNameStringId.WorkDayIntlStartdate': 'start_date',
                'XtraSpreadsheetFunctionArgumentNameStringId.WorkDayIntlDays': 'days',
                'XtraSpreadsheetFunctionArgumentNameStringId.WorkDayIntlWeekend': 'weekend',
                'XtraSpreadsheetFunctionArgumentNameStringId.WorkDayIntlHolidays': 'holidays',
                'XtraSpreadsheetFunctionArgumentNameStringId.IsoCeilingNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.IsoCeilingSignificance': 'significance',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaDistX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaDistAlpha': 'alpha',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaDistBeta': 'beta',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaDistCumulative': 'cumulative',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaDistA': 'A',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaDistB': 'B',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaDotInvProbability': 'probability',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaDotInvAlpha': 'alpha',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaDotInvBeta': 'beta',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaDotInvA': 'A',
                'XtraSpreadsheetFunctionArgumentNameStringId.BetaDotInvB': 'B',
                'XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotDistX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotDistDegfreedom': 'deg_freedom',
                'XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotDistCumulative': 'cumulative',
                'XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotDistDotRtX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotDistDotRtDegfreedom': 'deg_freedom',
                'XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotInvProbability': 'probability',
                'XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotInvDegfreedom': 'deg_freedom',
                'XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotInvDotRtProbability': 'probability',
                'XtraSpreadsheetFunctionArgumentNameStringId.ChisqDotInvDotRtDegfreedom': 'deg_freedom',
                'XtraSpreadsheetFunctionArgumentNameStringId.FDotDistX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.FDotDistDegfreedom1': 'deg_freedom1',
                'XtraSpreadsheetFunctionArgumentNameStringId.FDotDistDegfreedom2': 'deg_freedom2',
                'XtraSpreadsheetFunctionArgumentNameStringId.FDotDistCumulative': 'cumulative',
                'XtraSpreadsheetFunctionArgumentNameStringId.FDotDistDotRtX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.FDotDistDotRtDegfreedom1': 'deg_freedom1',
                'XtraSpreadsheetFunctionArgumentNameStringId.FDotDistDotRtDegfreedom2': 'deg_freedom2',
                'XtraSpreadsheetFunctionArgumentNameStringId.FDotInvProbability': 'probability',
                'XtraSpreadsheetFunctionArgumentNameStringId.FDotInvDegfreedom1': 'deg_freedom1',
                'XtraSpreadsheetFunctionArgumentNameStringId.FDotInvDegfreedom2': 'deg_freedom2',
                'XtraSpreadsheetFunctionArgumentNameStringId.FDotinvDotRtProbability': 'probability',
                'XtraSpreadsheetFunctionArgumentNameStringId.FDotinvDotRtDegfreedom1': 'deg_freedom1',
                'XtraSpreadsheetFunctionArgumentNameStringId.FDotinvDotRtDegfreedom2': 'deg_freedom2',
                'XtraSpreadsheetFunctionArgumentNameStringId.HypgeomDotDistSamples': 'sample_s',
                'XtraSpreadsheetFunctionArgumentNameStringId.HypgeomDotDistNumbersample': 'number_sample',
                'XtraSpreadsheetFunctionArgumentNameStringId.HypgeomDotDistPopulations': 'population_s',
                'XtraSpreadsheetFunctionArgumentNameStringId.HypgeomDotDistNumberpop': 'number_pop',
                'XtraSpreadsheetFunctionArgumentNameStringId.HypgeomDotDistCumulative': 'cumulative',
                'XtraSpreadsheetFunctionArgumentNameStringId.LogNormDistX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.LogNormDistMean': 'mean',
                'XtraSpreadsheetFunctionArgumentNameStringId.LogNormDistStandarddev': 'standard_dev',
                'XtraSpreadsheetFunctionArgumentNameStringId.LogNormDistCumulative': 'cumulative',
                'XtraSpreadsheetFunctionArgumentNameStringId.LogNormInvProbability': 'probability',
                'XtraSpreadsheetFunctionArgumentNameStringId.LogNormInvMean': 'mean',
                'XtraSpreadsheetFunctionArgumentNameStringId.LogNormInvStandarddev': 'standard_dev',
                'XtraSpreadsheetFunctionArgumentNameStringId.NegbinomDotDistNumberf': 'number_f',
                'XtraSpreadsheetFunctionArgumentNameStringId.NegbinomDotDistNumbers': 'number_s',
                'XtraSpreadsheetFunctionArgumentNameStringId.NegbinomDotDistProbabilitys': 'probability_s',
                'XtraSpreadsheetFunctionArgumentNameStringId.NegbinomDotDistCumulative': 'cumulative',
                'XtraSpreadsheetFunctionArgumentNameStringId.NormSDistZ': 'z',
                'XtraSpreadsheetFunctionArgumentNameStringId.NormSDistCumulative': 'cumulative',
                'XtraSpreadsheetFunctionArgumentNameStringId.NormSInvProbability': 'probability',
                'XtraSpreadsheetFunctionArgumentNameStringId.TDotTestArray1': 'array1',
                'XtraSpreadsheetFunctionArgumentNameStringId.TDotTestArray2': 'array2',
                'XtraSpreadsheetFunctionArgumentNameStringId.TDotTestTails': 'tails',
                'XtraSpreadsheetFunctionArgumentNameStringId.TDotTestType': 'type',
                'XtraSpreadsheetFunctionArgumentNameStringId.ZDotTestArray': 'array',
                'XtraSpreadsheetFunctionArgumentNameStringId.ZDotTestX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.ZDotTestSigma': 'sigma',
                'XtraSpreadsheetFunctionArgumentNameStringId.ErfPreciseX': 'X',
                'XtraSpreadsheetFunctionArgumentNameStringId.ErfcPreciseX': 'X',
                'XtraSpreadsheetFunctionArgumentNameStringId.GammaLnPreciseX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.CeilingDotPreciseNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.CeilingDotPreciseSignificance': 'significance',
                'XtraSpreadsheetFunctionArgumentNameStringId.FloorDotPreciseNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.FloorDotPreciseSignificance': 'significance',
                'XtraSpreadsheetFunctionArgumentNameStringId.ACotNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.ACotHNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.CotNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.CotHNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.CscNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.CscHNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.SecNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.SecHNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImTanInumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImCotInumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImCscInumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImCscHInumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImSecInumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImSecHInumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.BitAndNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.BitAndNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.BitOrNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.BitOrNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.BitXorNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.BitXorNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.BitLShiftNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.BitLShiftShiftamount': 'shift_amount',
                'XtraSpreadsheetFunctionArgumentNameStringId.BitRShiftNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.BitRShiftShiftamount': 'shift_amount',
                'XtraSpreadsheetFunctionArgumentNameStringId.PermutationaNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.PermutationaNumberchosen': 'number_chosen',
                'XtraSpreadsheetFunctionArgumentNameStringId.CombinANumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.CombinANumberchosen': 'number_chosen',
                'XtraSpreadsheetFunctionArgumentNameStringId.XOrLogical1': 'logical1',
                'XtraSpreadsheetFunctionArgumentNameStringId.XOrLogical2': 'logical2',
                'XtraSpreadsheetFunctionArgumentNameStringId.PDurationRate': 'rate',
                'XtraSpreadsheetFunctionArgumentNameStringId.PDurationPv': 'pv',
                'XtraSpreadsheetFunctionArgumentNameStringId.PDurationFv': 'fv',
                'XtraSpreadsheetFunctionArgumentNameStringId.BaseNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.BaseRadix': 'radix',
                'XtraSpreadsheetFunctionArgumentNameStringId.BaseMinlength': 'min_length',
                'XtraSpreadsheetFunctionArgumentNameStringId.DecimalNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.DecimalRadix': 'radix',
                'XtraSpreadsheetFunctionArgumentNameStringId.DaysEnddate': 'end_date',
                'XtraSpreadsheetFunctionArgumentNameStringId.DaysStartdate': 'start_date',
                'XtraSpreadsheetFunctionArgumentNameStringId.BinomDistRangeTrials': 'trials',
                'XtraSpreadsheetFunctionArgumentNameStringId.BinomDistRangeProbabilitys': 'probability_s',
                'XtraSpreadsheetFunctionArgumentNameStringId.BinomDistRangeNumbers': 'number_s',
                'XtraSpreadsheetFunctionArgumentNameStringId.BinomDistRangeNumbers2': 'number_s2',
                'XtraSpreadsheetFunctionArgumentNameStringId.GammaX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.SkewPNumber1': 'number1',
                'XtraSpreadsheetFunctionArgumentNameStringId.SkewPNumber2': 'number2',
                'XtraSpreadsheetFunctionArgumentNameStringId.PhiX': 'x',
                'XtraSpreadsheetFunctionArgumentNameStringId.RRINper': 'nper',
                'XtraSpreadsheetFunctionArgumentNameStringId.RRIPv': 'pv',
                'XtraSpreadsheetFunctionArgumentNameStringId.RRIFv': 'fv',
                'XtraSpreadsheetFunctionArgumentNameStringId.UnicodeText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.MUnitDimension': 'dimension',
                'XtraSpreadsheetFunctionArgumentNameStringId.ArabicText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.ISOWeekNumDate': 'date',
                'XtraSpreadsheetFunctionArgumentNameStringId.NumberValueText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.NumberValueDecimalseparator': 'decimal_separator',
                'XtraSpreadsheetFunctionArgumentNameStringId.NumberValueGroupseparator': 'group_separator',
                'XtraSpreadsheetFunctionArgumentNameStringId.SheetValue': 'value',
                'XtraSpreadsheetFunctionArgumentNameStringId.SheetsReference': 'reference',
                'XtraSpreadsheetFunctionArgumentNameStringId.FormulaTextReference': 'reference',
                'XtraSpreadsheetFunctionArgumentNameStringId.IsFormulaReference': 'reference',
                'XtraSpreadsheetFunctionArgumentNameStringId.IfNAValue': 'value',
                'XtraSpreadsheetFunctionArgumentNameStringId.IfNAValueifna': 'value_if_na',
                'XtraSpreadsheetFunctionArgumentNameStringId.CeilingMathNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.CeilingMathSignificance': 'significance',
                'XtraSpreadsheetFunctionArgumentNameStringId.CeilingMathMode': 'mode',
                'XtraSpreadsheetFunctionArgumentNameStringId.FloorMathNumber': 'number',
                'XtraSpreadsheetFunctionArgumentNameStringId.FloorMathSignificance': 'significance',
                'XtraSpreadsheetFunctionArgumentNameStringId.FloorMathMode': 'mode',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImSinHInumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.ImCosHInumber': 'inumber',
                'XtraSpreadsheetFunctionArgumentNameStringId.FunctionFilterXMLXml': 'xml',
                'XtraSpreadsheetFunctionArgumentNameStringId.FunctionFilterXMLXpath': 'xpath',
                'XtraSpreadsheetFunctionArgumentNameStringId.FunctionWebServiceUrl': 'url',
                'XtraSpreadsheetFunctionArgumentNameStringId.EncodeURLText': 'text',
                'XtraSpreadsheetFunctionArgumentNameStringId.ConcatText1': 'text1',
                'XtraSpreadsheetFunctionArgumentNameStringId.ConcatText2': 'text2',
                'XtraSpreadsheetFunctionArgumentNameStringId.IfsLogicaltest': 'logical_test1',
                'XtraSpreadsheetFunctionArgumentNameStringId.IfsValueiftrue': 'value_if_true1',
                'XtraSpreadsheetFunctionArgumentNameStringId.MaxIfsMaxrange': 'max_range',
                'XtraSpreadsheetFunctionArgumentNameStringId.MaxIfsCriteriarange': 'criteria_range',
                'XtraSpreadsheetFunctionArgumentNameStringId.MaxIfsCriteria': 'criteria',
                'XtraSpreadsheetFunctionArgumentNameStringId.MinIfsMinrange': 'min_range',
                'XtraSpreadsheetFunctionArgumentNameStringId.MinIfsCriteriarange': 'criteria_range',
                'XtraSpreadsheetFunctionArgumentNameStringId.MinIfsCriteria': 'criteria',
                'XtraSpreadsheetFunctionArgumentNameStringId.SwitchExpression': 'expression',
                'XtraSpreadsheetFunctionArgumentNameStringId.SwitchValue1': 'value1',
                'XtraSpreadsheetFunctionArgumentNameStringId.SwitchResult1': 'result1',
                'XtraSpreadsheetFunctionArgumentNameStringId.SwitchDefaultOrValue2': 'default_or_value2',
                'XtraSpreadsheetFunctionArgumentNameStringId.SwitchResult2': 'result2',
                'XtraSpreadsheetFunctionArgumentNameStringId.SwitchDefaultOrValue3': 'default_or_value3',
                'XtraSpreadsheetFunctionArgumentNameStringId.SwitchResult3': 'result3',
                'XtraSpreadsheetFunctionArgumentNameStringId.TextJoinDelimeter': 'delimeter',
                'XtraSpreadsheetFunctionArgumentNameStringId.TextJoinIgnoreEmpty': 'ignore_empty',
                'XtraSpreadsheetFunctionArgumentNameStringId.TextJoinText1': 'text1',
                'XtraSpreadsheetFunctionArgumentNameStringId.TextJoinText2': 'text2',
                'XtraSpreadsheetFunctionDescriptionStringId.Count': 'Counts the number of cells in a range that contain numbers.',
                'XtraSpreadsheetFunctionDescriptionStringId.If': 'Checks whether a condition is met, and returns one value if TRUE, and another value if FALSE.',
                'XtraSpreadsheetFunctionDescriptionStringId.IsNA': 'Checks whether a value is #N/A, and returns TRUE or FALSE.',
                'XtraSpreadsheetFunctionDescriptionStringId.IsError': 'Checks whether a value is an error (#N/A, #VALUE!, #REF!, #DIV/0!, #NUM!, #NAME?, or #NULL!), and returns TRUE or FALSE.',
                'XtraSpreadsheetFunctionDescriptionStringId.Sum': 'Adds all the numbers in a range of cells.',
                'XtraSpreadsheetFunctionDescriptionStringId.Average': 'Returns the average (arithmetic mean) of its arguments, which can be numbers or names, arrays, or references that contain numbers.',
                'XtraSpreadsheetFunctionDescriptionStringId.Min': 'Returns the smallest number in a set of values. Ignores logical values and text.',
                'XtraSpreadsheetFunctionDescriptionStringId.Max': 'Returns the largest value in a set of values. Ignores logical values and text.',
                'XtraSpreadsheetFunctionDescriptionStringId.Row': 'Returns the row number of a reference.',
                'XtraSpreadsheetFunctionDescriptionStringId.Column': 'Returns the column number of a reference.',
                'XtraSpreadsheetFunctionDescriptionStringId.NA': 'Returns the error value #N/A (value not available).',
                'XtraSpreadsheetFunctionDescriptionStringId.Npv': 'Returns the net present value of an investment based on a discount rate and a series of future payments (negative values) and income (positive values).',
                'XtraSpreadsheetFunctionDescriptionStringId.StDev': 'Estimates standard deviation based on a sample (ignores logical values and text in the sample).',
                'XtraSpreadsheetFunctionDescriptionStringId.Dollar': 'Converts a number to text, using currency format.',
                'XtraSpreadsheetFunctionDescriptionStringId.Fixed': 'Rounds a number to the specified number of decimals and returns the result as text with or without commas.',
                'XtraSpreadsheetFunctionDescriptionStringId.Sin': 'Returns the sine of an angle.',
                'XtraSpreadsheetFunctionDescriptionStringId.Cos': 'Returns the cosine of an angle.',
                'XtraSpreadsheetFunctionDescriptionStringId.Tan': 'Returns the tangent of an angle.',
                'XtraSpreadsheetFunctionDescriptionStringId.ATan': 'Returns the arctangent of a number in radians, in the range -Pi/2 to Pi/2.',
                'XtraSpreadsheetFunctionDescriptionStringId.Pi': 'Returns the value of Pi, 3.14159265358979, accurate to 15 digits.',
                'XtraSpreadsheetFunctionDescriptionStringId.Sqrt': 'Returns the square root of a number.',
                'XtraSpreadsheetFunctionDescriptionStringId.Exp': 'Returns e raised to the power of a given number.',
                'XtraSpreadsheetFunctionDescriptionStringId.Ln': 'Returns the natural logarithm of a number.',
                'XtraSpreadsheetFunctionDescriptionStringId.Log10': 'Returns the base-10 logarithm of a number.',
                'XtraSpreadsheetFunctionDescriptionStringId.Abs': 'Returns the absolute value of a number, a number without its sign.',
                'XtraSpreadsheetFunctionDescriptionStringId.Int': 'Rounds a number down to the nearest integer.',
                'XtraSpreadsheetFunctionDescriptionStringId.Sign': 'Returns the sign of a number: 1 if the number is positive, zero if the number is zero, or -1 if the number is negative.',
                'XtraSpreadsheetFunctionDescriptionStringId.Round': 'Rounds a number to a specified number of digits.',
                'XtraSpreadsheetFunctionDescriptionStringId.Lookup': 'Looks up a value either from a one-row or one-column range or from an array. Provided for backward compatibility.',
                'XtraSpreadsheetFunctionDescriptionStringId.Index': 'Returns a value or reference of the cell at the intersection of a particular row and column, in a given range.',
                'XtraSpreadsheetFunctionDescriptionStringId.Rept': 'Repeats text a given number of times. Use REPT to fill a cell with a number of instances of a text string.',
                'XtraSpreadsheetFunctionDescriptionStringId.Mid': 'Returns the characters from the middle of a text string, given a starting position and length.',
                'XtraSpreadsheetFunctionDescriptionStringId.Len': 'Returns the number of characters in a text string.',
                'XtraSpreadsheetFunctionDescriptionStringId.Value': 'Converts a text string that represents a number to a number.',
                'XtraSpreadsheetFunctionDescriptionStringId.True': 'Returns the logical value TRUE.',
                'XtraSpreadsheetFunctionDescriptionStringId.False': 'Returns the logical value FALSE.',
                'XtraSpreadsheetFunctionDescriptionStringId.And': 'Checks whether all arguments are TRUE, and returns TRUE if all arguments are TRUE.',
                'XtraSpreadsheetFunctionDescriptionStringId.Or': 'Checks whether any of the arguments are TRUE, and returns TRUE or FALSE. Returns FALSE only if all arguments are FALSE.',
                'XtraSpreadsheetFunctionDescriptionStringId.Not': 'Changes FALSE to TRUE, or TRUE to FALSE.',
                'XtraSpreadsheetFunctionDescriptionStringId.Mod': 'Returns the remainder after a number is divided by a divisor.',
                'XtraSpreadsheetFunctionDescriptionStringId.DCount': 'Counts the cells containing numbers in the field (column) of records in the database that match the conditions you specify.',
                'XtraSpreadsheetFunctionDescriptionStringId.DSum': 'Adds the numbers in the field (column) of records in the database that match the conditions you specify.',
                'XtraSpreadsheetFunctionDescriptionStringId.DAverage': 'Averages the values in a column in a list or database that match conditions you specify.',
                'XtraSpreadsheetFunctionDescriptionStringId.DMin': 'Returns the smallest number in the field (column) of records in the database that match the conditions you specify.',
                'XtraSpreadsheetFunctionDescriptionStringId.DMax': 'Returns the largest number in the field (column) of records in the database that match the conditions you specify.',
                'XtraSpreadsheetFunctionDescriptionStringId.DStDev': 'Estimates the standard deviation based on a sample from selected database entries.',
                'XtraSpreadsheetFunctionDescriptionStringId.Var': 'Estimates variance based on a sample (ignores logical values and text in the sample).',
                'XtraSpreadsheetFunctionDescriptionStringId.DVar': 'Estimates variance based on a sample from selected database entries.',
                'XtraSpreadsheetFunctionDescriptionStringId.Text': 'Converts a value to text in a specific number format.',
                'XtraSpreadsheetFunctionDescriptionStringId.Linest': 'Returns statistics that describe a linear trend matching known data points, by fitting a straight line using the least squares method.',
                'XtraSpreadsheetFunctionDescriptionStringId.Trend': 'Returns numbers in a linear trend matching known data points, using the least squares method.',
                'XtraSpreadsheetFunctionDescriptionStringId.Logest': 'Returns statistics that describe an exponential curve matching known data points.',
                'XtraSpreadsheetFunctionDescriptionStringId.Growth': 'Returns numbers in an exponential growth trend matching known data points.',
                'XtraSpreadsheetFunctionDescriptionStringId.Pv': 'Returns the present value of an investment: the total amount that a series of future payments is worth now.',
                'XtraSpreadsheetFunctionDescriptionStringId.Fv': 'Returns the future value of an investment based on periodic, constant payments and a constant interest rate.',
                'XtraSpreadsheetFunctionDescriptionStringId.NPer': 'Returns the number of periods for an investment based on periodic, constant payments and a constant interest rate.',
                'XtraSpreadsheetFunctionDescriptionStringId.Pmt': 'Calculates the payment for a loan based on constant payments and a constant interest rate.',
                'XtraSpreadsheetFunctionDescriptionStringId.Rate': 'Returns the interest rate per period of a loan or an investment. For example, use 6%/4 for quarterly payments at 6% APR.',
                'XtraSpreadsheetFunctionDescriptionStringId.Mirr': 'Returns the internal rate of return for a series of periodic cash flows, considering both cost of investment and interest on reinvestment of cash.',
                'XtraSpreadsheetFunctionDescriptionStringId.Irr': 'Returns the internal rate of return for a series of cash flows.',
                'XtraSpreadsheetFunctionDescriptionStringId.Rand': 'Returns a random number greater than or equal to 0 and less than 1, evenly distributed (changes on recalculation).',
                'XtraSpreadsheetFunctionDescriptionStringId.Match': 'Returns the relative position of an item in an array that matches a specified value in a specified order.',
                'XtraSpreadsheetFunctionDescriptionStringId.Date': 'Returns the number that represents the date in Spreadsheet date-time code.',
                'XtraSpreadsheetFunctionDescriptionStringId.Time': 'Converts hours, minutes, and seconds given as numbers to an Spreadsheet serial number, formatted with a time format.',
                'XtraSpreadsheetFunctionDescriptionStringId.Day': 'Returns the day of the month, a number from 1 to 31.',
                'XtraSpreadsheetFunctionDescriptionStringId.Month': 'Returns the month, a number from 1 (January) to 12 (December).',
                'XtraSpreadsheetFunctionDescriptionStringId.Year': 'Returns the year of a date, an integer in the range 1900 - 9999.',
                'XtraSpreadsheetFunctionDescriptionStringId.WeekDay': 'Returns a number from 1 to 7 identifying the day of the week of a date.',
                'XtraSpreadsheetFunctionDescriptionStringId.Hour': 'Returns the hour as a number from 0 (12:00 A.M.) to 23 (11:00 P.M.).',
                'XtraSpreadsheetFunctionDescriptionStringId.Minute': 'Returns the minute, a number from 0 to 59.',
                'XtraSpreadsheetFunctionDescriptionStringId.Second': 'Returns the second, a number from 0 to 59.',
                'XtraSpreadsheetFunctionDescriptionStringId.Now': 'Returns the current date and time formatted as a date and time.',
                'XtraSpreadsheetFunctionDescriptionStringId.Areas': 'Returns the number of areas in a reference. An area is a range of contiguous cells or a single cell.',
                'XtraSpreadsheetFunctionDescriptionStringId.Rows': 'Returns the number of rows in a reference or array.',
                'XtraSpreadsheetFunctionDescriptionStringId.Columns': 'Returns the number of columns in an array or reference.',
                'XtraSpreadsheetFunctionDescriptionStringId.Offset': 'Returns a reference to a range that is a given number of rows and columns from a given reference.',
                'XtraSpreadsheetFunctionDescriptionStringId.Search': 'Returns the number of the character at which a specific character or text string is first found, reading left to right (not case-sensitive).',
                'XtraSpreadsheetFunctionDescriptionStringId.Transpose': 'Converts a vertical range of cells to a horizontal range, or vice versa.',
                'XtraSpreadsheetFunctionDescriptionStringId.Type': 'Returns an integer representing the data type of a value: number = 1; text = 2; logical value = 4; error value = 16; array = 64.',
                'XtraSpreadsheetFunctionDescriptionStringId.ATan2': 'Returns the arctangent of the specified x- and y- coordinates, in radians between -Pi and Pi, excluding -Pi.',
                'XtraSpreadsheetFunctionDescriptionStringId.ASin': 'Returns the arcsine of a number in radians, in the range -Pi/2 to Pi/2.',
                'XtraSpreadsheetFunctionDescriptionStringId.ACos': 'Returns the arccosine of a number, in radians in the range 0 to Pi. The arccosine is the angle whose cosine is Number.',
                'XtraSpreadsheetFunctionDescriptionStringId.Choose': 'Chooses a value or action to perform from a list of values, based on an index number.',
                'XtraSpreadsheetFunctionDescriptionStringId.HLookup': 'Looks for a value in the top row of a table or array of values and returns the value in the same column from a row you specify.',
                'XtraSpreadsheetFunctionDescriptionStringId.VLookup': 'Looks for a value in the leftmost column of a table, and then returns a value in the same row from a column you specify. By default, the table must be sorted in an ascending order.',
                'XtraSpreadsheetFunctionDescriptionStringId.IsRef': 'Checks whether a value is a reference, and returns TRUE or FALSE.',
                'XtraSpreadsheetFunctionDescriptionStringId.Log': 'Returns the logarithm of a number to the base you specify.',
                'XtraSpreadsheetFunctionDescriptionStringId.Char': 'Returns the character specified by the code number from the character set for your computer.',
                'XtraSpreadsheetFunctionDescriptionStringId.Lower': 'Converts all letters in a text string to lowercase.',
                'XtraSpreadsheetFunctionDescriptionStringId.Upper': 'Converts a text string to all uppercase letters.',
                'XtraSpreadsheetFunctionDescriptionStringId.Proper': 'Converts a text string to proper case; the first letter in each word in uppercase, and all other letters to lowercase.',
                'XtraSpreadsheetFunctionDescriptionStringId.Left': 'Returns the specified number of characters from the start of a text string.',
                'XtraSpreadsheetFunctionDescriptionStringId.Right': 'Returns the specified number of characters from the end of a text string.',
                'XtraSpreadsheetFunctionDescriptionStringId.Exact': 'Checks whether two text strings are exactly the same, and returns TRUE or FALSE. EXACT is case-sensitive.',
                'XtraSpreadsheetFunctionDescriptionStringId.Trim': 'Removes all spaces from a text string except for single spaces between words.',
                'XtraSpreadsheetFunctionDescriptionStringId.Replace': 'Replaces part of a text string with a different text string.',
                'XtraSpreadsheetFunctionDescriptionStringId.Substitute': 'Replaces existing text with new text in a text string.',
                'XtraSpreadsheetFunctionDescriptionStringId.Code': 'Returns a numeric code for the first character in a text string, in the character set used by your computer.',
                'XtraSpreadsheetFunctionDescriptionStringId.Find': 'Returns the starting position of one text string within another text string. FIND is case-sensitive.',
                'XtraSpreadsheetFunctionDescriptionStringId.Cell': 'Returns information about the formatting, location, or contents of the first cell, according to the sheet\'s reading order, in a reference.',
                'XtraSpreadsheetFunctionDescriptionStringId.IsErr': 'Checks whether a value is an error (#VALUE!, #REF!, #DIV/0!, #NUM!, #NAME?, or #NULL!) excluding #N/A, and returns TRUE or FALSE.',
                'XtraSpreadsheetFunctionDescriptionStringId.IsText': 'Checks whether a value is text, and returns TRUE or FALSE.',
                'XtraSpreadsheetFunctionDescriptionStringId.IsNumber': 'Checks whether a value is a number, and returns TRUE or FALSE.',
                'XtraSpreadsheetFunctionDescriptionStringId.IsBlank': 'Checks whether a reference is to an empty cell, and returns TRUE or FALSE.',
                'XtraSpreadsheetFunctionDescriptionStringId.T': 'Checks whether a value is text, and returns the text if it is, or returns double quotes (empty text) if it is not.',
                'XtraSpreadsheetFunctionDescriptionStringId.N': 'Converts non-number value to a number, dates to serial numbers, TRUE to 1, anything else to 0 (zero).',
                'XtraSpreadsheetFunctionDescriptionStringId.DateValue': 'Converts a date in the form of text to a number that represents the date in Spreadsheet date-time code.',
                'XtraSpreadsheetFunctionDescriptionStringId.TimeValue': 'Converts a text time to an Spreadsheet serial number for a time, a number from 0 (12:00:00 AM) to 0.999988426 (11:59:59 PM). Format the number with a time format after entering the formula.',
                'XtraSpreadsheetFunctionDescriptionStringId.Sln': 'Returns the straight-line depreciation of an asset for one period.',
                'XtraSpreadsheetFunctionDescriptionStringId.Syd': 'Returns the sum-of-years\' digits depreciation of an asset for a specified period.',
                'XtraSpreadsheetFunctionDescriptionStringId.Ddb': 'Returns the depreciation of an asset for a specified period using the double-declining balance method or some other method you specify.',
                'XtraSpreadsheetFunctionDescriptionStringId.Indirect': 'Returns the reference specified by a text string.',
                'XtraSpreadsheetFunctionDescriptionStringId.Call': 'Calls a procedure in a dynamic link library or code resource.',
                'XtraSpreadsheetFunctionDescriptionStringId.Clean': 'Removes all nonprintable characters from text.',
                'XtraSpreadsheetFunctionDescriptionStringId.MDeterm': 'Returns the matrix determinant of an array.',
                'XtraSpreadsheetFunctionDescriptionStringId.MInverse': 'Returns the inverse matrix for the matrix stored in an array.',
                'XtraSpreadsheetFunctionDescriptionStringId.MMult': 'Returns the matrix product of two arrays, an array with the same number of rows as array1 and columns as array2.',
                'XtraSpreadsheetFunctionDescriptionStringId.Ipmt': 'Returns the interest payment for a given period for an investment, based on periodic, constant payments and a constant interest rate.',
                'XtraSpreadsheetFunctionDescriptionStringId.Ppmt': 'Returns the payment on the principal for a given investment based on periodic, constant payments and a constant interest rate.',
                'XtraSpreadsheetFunctionDescriptionStringId.CountA': 'Counts the number of cells in a range that are not empty.',
                'XtraSpreadsheetFunctionDescriptionStringId.Product': 'Multiplies all the numbers given as arguments.',
                'XtraSpreadsheetFunctionDescriptionStringId.Fact': 'Returns the factorial of a number, equal to 1*2*3*...* Number.',
                'XtraSpreadsheetFunctionDescriptionStringId.DProduct': 'Multiplies the values in the field (column) of records in the database that match the conditions you specify.',
                'XtraSpreadsheetFunctionDescriptionStringId.IsNonText': 'Checks whether a value is not text (blank cells are not text), and returns TRUE or FALSE.',
                'XtraSpreadsheetFunctionDescriptionStringId.StDevP': 'Calculates standard deviation based on the entire population given as arguments (ignores logical values and text).',
                'XtraSpreadsheetFunctionDescriptionStringId.VarP': 'Calculates variance based on the entire population (ignores logical values and text in the population).',
                'XtraSpreadsheetFunctionDescriptionStringId.DStDevP': 'Calculates the standard deviation based on the entire population of selected database entries.',
                'XtraSpreadsheetFunctionDescriptionStringId.DVarP': 'Calculates variance based on the entire population of selected database entries.',
                'XtraSpreadsheetFunctionDescriptionStringId.Trunc': 'Truncates a number to an integer by removing the decimal, or fractional, part of the number.',
                'XtraSpreadsheetFunctionDescriptionStringId.IsLogical': 'Checks whether a value is a logical value (TRUE or FALSE), and returns TRUE or FALSE.',
                'XtraSpreadsheetFunctionDescriptionStringId.DCountA': 'Counts nonblank cells in the field (column) of records in the database that match the conditions you specify.',
                'XtraSpreadsheetFunctionDescriptionStringId.FindB': 'Finds the starting position of one text string within another text string. FINDB is case-sensitive. Use with double-byte character sets (DBCS).',
                'XtraSpreadsheetFunctionDescriptionStringId.SearchB': ' Returns the number of the character at which a specific character or text string is first found, reading left to right (not case-sensitive). Use with double-byte character sets (DBCS).',
                'XtraSpreadsheetFunctionDescriptionStringId.ReplaceB': 'Replaces part of a text string with a different text string. Use with double-byte character sets (DBCS).',
                'XtraSpreadsheetFunctionDescriptionStringId.LeftB': 'Returns the specified number of characters from the start of a text string. Use with double-byte character sets (DBCS).',
                'XtraSpreadsheetFunctionDescriptionStringId.RightB': 'Returns the specified number of characters from the end of a text string. Use with double-byte character sets (DBCS).',
                'XtraSpreadsheetFunctionDescriptionStringId.MidB': 'Returns characters from the middle of a text string, given a starting position and length. Use with double-byte character sets (DBCS).',
                'XtraSpreadsheetFunctionDescriptionStringId.LenB': 'Returns the number of characters in a text string. Use with double-byte character sets (DBCS).',
                'XtraSpreadsheetFunctionDescriptionStringId.RoundUp': 'Rounds a number up, away from zero.',
                'XtraSpreadsheetFunctionDescriptionStringId.RoundDown': 'Rounds a number down, toward zero.',
                'XtraSpreadsheetFunctionDescriptionStringId.Asc': 'Changes full-width (double-byte) characters to half-width (single-byte) characters. Use with double-byte character sets (DBCS).',
                'XtraSpreadsheetFunctionDescriptionStringId.Rank': 'Returns the rank of a number in a list of numbers: its size relative to other values in the list.',
                'XtraSpreadsheetFunctionDescriptionStringId.Address': 'Creates a cell reference as text, given specified row and column numbers.',
                'XtraSpreadsheetFunctionDescriptionStringId.Days360': 'Returns the number of days between two dates based on a 360-day year (twelve 30-day months).',
                'XtraSpreadsheetFunctionDescriptionStringId.Today': 'Returns the current date formatted as a date.',
                'XtraSpreadsheetFunctionDescriptionStringId.Vdb': 'Returns the depreciation of an asset for any period you specify, including partial periods, using the double-declining balance method or some other method you specify.',
                'XtraSpreadsheetFunctionDescriptionStringId.Median': 'Returns the median, or the number in the middle of the set of given numbers.',
                'XtraSpreadsheetFunctionDescriptionStringId.SumProduct': 'Returns the sum of the products of corresponding ranges or arrays.',
                'XtraSpreadsheetFunctionDescriptionStringId.SinH': 'Returns the hyperbolic sine of a number.',
                'XtraSpreadsheetFunctionDescriptionStringId.CosH': 'Returns the hyperbolic cosine of a number.',
                'XtraSpreadsheetFunctionDescriptionStringId.TanH': 'Returns the hyperbolic tangent of a number.',
                'XtraSpreadsheetFunctionDescriptionStringId.ASinH': 'Returns the inverse hyperbolic sine of a number.',
                'XtraSpreadsheetFunctionDescriptionStringId.ACosH': 'Returns the inverse hyperbolic cosine of a number.',
                'XtraSpreadsheetFunctionDescriptionStringId.ATanH': 'Returns the inverse hyperbolic tangent of a number.',
                'XtraSpreadsheetFunctionDescriptionStringId.DGet': 'Extracts from a database a single record that matches the conditions you specify.',
                'XtraSpreadsheetFunctionDescriptionStringId.Info': 'Returns information about the current operating environment.',
                'XtraSpreadsheetFunctionDescriptionStringId.Db': 'Returns the depreciation of an asset for a specified period using the fixed-declining balance method.',
                'XtraSpreadsheetFunctionDescriptionStringId.Frequency': 'Calculates how often values occur within a range of values and then returns a vertical array of numbers having one more element than Bins_array.',
                'XtraSpreadsheetFunctionDescriptionStringId.ErrorType': 'Returns a number matching an error value.',
                'XtraSpreadsheetFunctionDescriptionStringId.RegisterId': 'Returns the register ID of the specified dynamic link library (DLL) or code resource that has been previously registered.',
                'XtraSpreadsheetFunctionDescriptionStringId.Avedev': 'Returns the average of the absolute deviations of data points from their mean. Arguments can be numbers or names, arrays, or references that contain numbers.',
                'XtraSpreadsheetFunctionDescriptionStringId.BetaDistCompatibility': 'Returns the cumulative beta probability density function.',
                'XtraSpreadsheetFunctionDescriptionStringId.GammaLn': 'Returns the natural logarithm of the gamma function.',
                'XtraSpreadsheetFunctionDescriptionStringId.BetaInv': 'Returns the inverse of the cumulative beta probability density function (BETADIST).',
                'XtraSpreadsheetFunctionDescriptionStringId.BinomDist': 'Returns the individual term binomial distribution probability.',
                'XtraSpreadsheetFunctionDescriptionStringId.ChiDist': 'Returns the right-tailed probability of the chi-squared distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.ChiInv': 'Returns the inverse of the right-tailed probability of the chi-squared distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.Combin': 'Returns the number of combinations for a given number of items.',
                'XtraSpreadsheetFunctionDescriptionStringId.Confidence': 'Returns the confidence interval for a population mean, using a normal distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.CritBinom': 'Returns the smallest value for which the cumulative binomial distribution is greater than or equal to a criterion value.',
                'XtraSpreadsheetFunctionDescriptionStringId.Even': 'Rounds a positive number up and negative number down to the nearest even integer.',
                'XtraSpreadsheetFunctionDescriptionStringId.ExponDist': 'Returns the exponential distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.FDist': 'Returns the (right-tailed) F probability distribution (degree of diversity) for two data sets.',
                'XtraSpreadsheetFunctionDescriptionStringId.FInv': 'Returns the inverse of the (right-tailed) F probability distribution: if p = FDIST(x,...), then FINV(p,...) = x.',
                'XtraSpreadsheetFunctionDescriptionStringId.Fisher': 'Returns the Fisher transformation.',
                'XtraSpreadsheetFunctionDescriptionStringId.FisherInv': 'Returns the inverse of the Fisher transformation: if y = FISHER(x), then FISHERINV(y) = x.',
                'XtraSpreadsheetFunctionDescriptionStringId.Floor': 'Rounds a number down to the nearest multiple of significance.',
                'XtraSpreadsheetFunctionDescriptionStringId.GammaDist': 'Returns the gamma distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.GammaInv': 'Returns the inverse of the gamma cumulative distribution: if p = GAMMADIST(x,...), then GAMMAINV(p,...) = x.',
                'XtraSpreadsheetFunctionDescriptionStringId.Ceiling': 'Rounds a number up, to the nearest multiple of significance.',
                'XtraSpreadsheetFunctionDescriptionStringId.HypGeomDist': 'Returns the hypergeometric distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.LogNormDistCompatibility': 'Returns the cumulative lognormal distribution of x, where ln(x) is normally distributed with parameters Mean and Standard_dev.',
                'XtraSpreadsheetFunctionDescriptionStringId.LogInvCompatibility': 'Returns the inverse of the lognormal cumulative distribution function of x, where ln(x) is normally distributed with parameters Mean and Standard_dev.',
                'XtraSpreadsheetFunctionDescriptionStringId.NegBinomDist': 'Returns the negative binomial distribution, the probability that there will be Number_f failures before the Number_s-th success, with Probability_s probability of a success.',
                'XtraSpreadsheetFunctionDescriptionStringId.NormDistCompatibility': 'Returns the normal cumulative distribution for the specified mean and standard deviation.',
                'XtraSpreadsheetFunctionDescriptionStringId.NormSDistCompatibility': 'Returns the standard normal cumulative distribution (has a mean of zero and a standard deviation of one).',
                'XtraSpreadsheetFunctionDescriptionStringId.NormInvCompatibility': 'Returns the inverse of the normal cumulative distribution for the specified mean and standard deviation.',
                'XtraSpreadsheetFunctionDescriptionStringId.NormSInvCompatibility': 'Returns the inverse of the standard normal cumulative distribution (has a mean of zero and a standard deviation of one).',
                'XtraSpreadsheetFunctionDescriptionStringId.Standardize': 'Returns a normalized value from a distribution characterized by a mean and standard deviation.',
                'XtraSpreadsheetFunctionDescriptionStringId.Odd': 'Rounds a positive number up and negative number down to the nearest odd integer.',
                'XtraSpreadsheetFunctionDescriptionStringId.Permut': 'Returns the number of permutations for a given number of objects that can be selected from the total objects.',
                'XtraSpreadsheetFunctionDescriptionStringId.Poisson': 'Returns the Poisson distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.TDist': 'Returns the Student\'s t-distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.Weibull': 'Returns the Weibull distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.SumXMY2': 'Sums the squares of the differences in two corresponding ranges or arrays.',
                'XtraSpreadsheetFunctionDescriptionStringId.SumX2MY2': 'Sums the differences between the squares of two corresponding ranges or arrays.',
                'XtraSpreadsheetFunctionDescriptionStringId.SumX2PY2': 'Returns the sum total of the sums of squares of numbers in two corresponding ranges or arrays.',
                'XtraSpreadsheetFunctionDescriptionStringId.ChiTest': 'Returns the test for independence: the value from the chi-squared distribution for the statistic and the appropriate degrees of freedom.',
                'XtraSpreadsheetFunctionDescriptionStringId.Correl': 'Returns the correlation coefficient between two data sets.',
                'XtraSpreadsheetFunctionDescriptionStringId.Covar': 'Returns covariance, the average of the products of deviations for each data point pair in two data sets.',
                'XtraSpreadsheetFunctionDescriptionStringId.Forecast': 'Calculates, or predicts, a future value along a linear trend by using existing values.',
                'XtraSpreadsheetFunctionDescriptionStringId.FTest': 'Returns the result of an F-test, the two-tailed probability that the variances in Array1 and Array2 are not significantly different.',
                'XtraSpreadsheetFunctionDescriptionStringId.Intercept': 'Calculates the point at which a line will intersect the y-axis by using a best-fit regression line plotted through the known x-values and y-values.',
                'XtraSpreadsheetFunctionDescriptionStringId.Pearson': 'Returns the Pearson product moment correlation coefficient, r.',
                'XtraSpreadsheetFunctionDescriptionStringId.Rsq': 'Returns the square of the Pearson product moment correlation coefficient through the given data points.',
                'XtraSpreadsheetFunctionDescriptionStringId.StEYX': 'Returns the standard error of the predicted y-value for each x in a regression.',
                'XtraSpreadsheetFunctionDescriptionStringId.Slope': 'Returns the slope of the linear regression line through the given data points.',
                'XtraSpreadsheetFunctionDescriptionStringId.TTest': 'Returns the probability associated with a Student\'s t-Test.',
                'XtraSpreadsheetFunctionDescriptionStringId.Prob': 'Returns the probability that values in a range are between two limits or equal to a lower limit.',
                'XtraSpreadsheetFunctionDescriptionStringId.DevSq': 'Returns the sum of squares of deviations of data points from their sample mean.',
                'XtraSpreadsheetFunctionDescriptionStringId.Geomean': 'Returns the geometric mean of an array or range of positive numeric data.',
                'XtraSpreadsheetFunctionDescriptionStringId.HarMean': 'Returns the harmonic mean of a data set of positive numbers: the reciprocal of the arithmetic mean of reciprocals.',
                'XtraSpreadsheetFunctionDescriptionStringId.SumSq': 'Returns the sum of the squares of the arguments. The arguments can be numbers, arrays, names, or references to cells that contain numbers.',
                'XtraSpreadsheetFunctionDescriptionStringId.Kurt': 'Returns the kurtosis of a data set.',
                'XtraSpreadsheetFunctionDescriptionStringId.Skew': 'Returns the skewness of a distribution: a characterization of the degree of asymmetry of a distribution around its mean.',
                'XtraSpreadsheetFunctionDescriptionStringId.ZTest': 'Returns the one-tailed P-value of a z-test.',
                'XtraSpreadsheetFunctionDescriptionStringId.Large': 'Returns the k-th largest value in a data set. For example, the fifth largest number.',
                'XtraSpreadsheetFunctionDescriptionStringId.Small': 'Returns the k-th smallest value in a data set. For example, the fifth smallest number.',
                'XtraSpreadsheetFunctionDescriptionStringId.Quartile': 'Returns the quartile of a data set.',
                'XtraSpreadsheetFunctionDescriptionStringId.Percentile': 'Returns the k-th percentile of values in a range.',
                'XtraSpreadsheetFunctionDescriptionStringId.PercentRank': 'Returns the rank of a value in a data set as a percentage of the data set.',
                'XtraSpreadsheetFunctionDescriptionStringId.Mode': 'Returns the most frequently occurring, or repetitive, value in an array or range of data.',
                'XtraSpreadsheetFunctionDescriptionStringId.Trimmean': 'Returns the mean of the interior portion of a set of data values.',
                'XtraSpreadsheetFunctionDescriptionStringId.Tinv': 'Returns the two-tailed inverse of the Student\'s t-distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.Concatenate': 'Joins several text strings into one text string.',
                'XtraSpreadsheetFunctionDescriptionStringId.Power': 'Returns the result of a number raised to a power.',
                'XtraSpreadsheetFunctionDescriptionStringId.Radians': 'Converts degrees to radians.',
                'XtraSpreadsheetFunctionDescriptionStringId.Degrees': 'Converts radians to degrees.',
                'XtraSpreadsheetFunctionDescriptionStringId.Subtotal': 'Returns a subtotal in a list or database.',
                'XtraSpreadsheetFunctionDescriptionStringId.SumIf': 'Adds the cells specified by a given condition or criteria.',
                'XtraSpreadsheetFunctionDescriptionStringId.CountIf': 'Counts the number of cells within a range that meet the given condition.',
                'XtraSpreadsheetFunctionDescriptionStringId.CountBlank': 'Counts the number of empty cells in a specified range of cells.',
                'XtraSpreadsheetFunctionDescriptionStringId.IsPmt': 'Returns the interest paid during a specific period of an investment.',
                'XtraSpreadsheetFunctionDescriptionStringId.Roman': 'Converts an Arabic numeral to Roman, as text.',
                'XtraSpreadsheetFunctionDescriptionStringId.GetPivotData': 'Extracts data stored in a PivotTable.',
                'XtraSpreadsheetFunctionDescriptionStringId.Hyperlink': 'Creates a shortcut or jump that opens a document stored on your hard drive, a network server, or on the Internet.',
                'XtraSpreadsheetFunctionDescriptionStringId.Phonetic': 'Get phonetic string.',
                'XtraSpreadsheetFunctionDescriptionStringId.AverageA': 'Returns the average (arithmetic mean) of its arguments, evaluating text and FALSE in arguments as 0; TRUE evaluates as 1. Arguments can be numbers, names, arrays, or references.',
                'XtraSpreadsheetFunctionDescriptionStringId.MaxA': 'Returns the largest value in a set of values. Does not ignore logical values and text.',
                'XtraSpreadsheetFunctionDescriptionStringId.MinA': 'Returns the smallest value in a set of values. Does not ignore logical values and text.',
                'XtraSpreadsheetFunctionDescriptionStringId.StDevPA': 'Calculates standard deviation based on an entire population, including logical values and text. Text and the logical value FALSE have the value 0; the logical value TRUE has the value 1.',
                'XtraSpreadsheetFunctionDescriptionStringId.VarPA': 'Calculates variance based on the entire population, including logical values and text. Text and the logical value FALSE have the value 0; the logical value TRUE has the value 1.',
                'XtraSpreadsheetFunctionDescriptionStringId.StDevA': 'Estimates standard deviation based on a sample, including logical values and text. Text and the logical value FALSE have the value 0; the logical value TRUE has the value 1.',
                'XtraSpreadsheetFunctionDescriptionStringId.VarA': 'Estimates variance based on a sample, including logical values and text. Text and the logical value FALSE have the value 0; the logical value TRUE has the value 1.',
                'XtraSpreadsheetFunctionDescriptionStringId.BahtText': 'Converts a number to text (baht).',
                'XtraSpreadsheetFunctionDescriptionStringId.Rtd': 'Retrieves real-time data from a program that supports COM automation.',
                'XtraSpreadsheetFunctionDescriptionStringId.CubeValue': 'Returns an aggregated value from the cube.',
                'XtraSpreadsheetFunctionDescriptionStringId.CubeMember': 'Returns a member or tuple from the cube.',
                'XtraSpreadsheetFunctionDescriptionStringId.CubeMemberProperty': 'Returns the value of a member property from the cube.',
                'XtraSpreadsheetFunctionDescriptionStringId.CubeRankedMember': 'Returns the nth, or ranked, member in a set.',
                'XtraSpreadsheetFunctionDescriptionStringId.Hex2Bin': 'Converts a Hexadecimal number to binary.',
                'XtraSpreadsheetFunctionDescriptionStringId.Hex2Dec': 'Converts a hexadecimal number to decimal.',
                'XtraSpreadsheetFunctionDescriptionStringId.Hex2Oct': 'Converts a hexadecimal number to octal.',
                'XtraSpreadsheetFunctionDescriptionStringId.Dec2Bin': 'Converts a decimal number to binary.',
                'XtraSpreadsheetFunctionDescriptionStringId.Dec2Hex': 'Converts a decimal number to hexadecimal.',
                'XtraSpreadsheetFunctionDescriptionStringId.Dec2Oct': 'Converts a decimal number to octal.',
                'XtraSpreadsheetFunctionDescriptionStringId.Oct2Bin': 'Converts an octal number to binary.',
                'XtraSpreadsheetFunctionDescriptionStringId.Oct2Hex': 'Converts an octal number to hexadecimal.',
                'XtraSpreadsheetFunctionDescriptionStringId.Oct2Dec': 'Converts an octal number to decimal.',
                'XtraSpreadsheetFunctionDescriptionStringId.Bin2Dec': 'Converts a binary number to decimal.',
                'XtraSpreadsheetFunctionDescriptionStringId.Bin2Oct': 'Converts a binary number to octal.',
                'XtraSpreadsheetFunctionDescriptionStringId.Bin2Hex': 'Converts a binary number to hexadecimal.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImSub': 'Returns the difference of two complex numbers.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImDiv': 'Returns the quotient of two complex numbers.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImPower': 'Returns a complex number raised to an integer power.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImAbs': 'Returns the absolute value (modulus) of a complex number.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImSqrt': 'Returns the square root of a complex number.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImLn': 'Returns the natural logarithm of a complex number.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImLog2': 'Returns the base-2 logarithm of a complex number.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImLog10': 'Returns the base-10 logarithm of a complex number.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImSin': 'Returns the sine of a complex number.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImCos': 'Returns the cosine of a complex number.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImExp': 'Returns the exponential of a complex number.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImArgument': 'Returns the argument q, an angle expressed in radians.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImConjugate': 'Returns the complex conjugate of a complex number.',
                'XtraSpreadsheetFunctionDescriptionStringId.Imaginary': 'Returns the imaginary coefficient of a complex number.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImReal': 'Returns the real coefficient of a complex number.',
                'XtraSpreadsheetFunctionDescriptionStringId.Complex': 'Converts real and imaginary coefficients into a complex number.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImSum': 'Returns the sum of complex numbers.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImProduct': 'Returns the product of 1 to 255 complex numbers.',
                'XtraSpreadsheetFunctionDescriptionStringId.Seriessum': 'Returns the sum of a power series based on the formula.',
                'XtraSpreadsheetFunctionDescriptionStringId.FactDouble': 'Returns the double factorial of a number.',
                'XtraSpreadsheetFunctionDescriptionStringId.SqrtPi': 'Returns the square root of (number * Pi).',
                'XtraSpreadsheetFunctionDescriptionStringId.Quotient': 'Returns the integer portion of a division.',
                'XtraSpreadsheetFunctionDescriptionStringId.Delta': 'Tests whether two numbers are equal.',
                'XtraSpreadsheetFunctionDescriptionStringId.Gestep': 'Tests whether a number is greater than a threshold value.',
                'XtraSpreadsheetFunctionDescriptionStringId.IsEven': 'Returns TRUE if the number is even.',
                'XtraSpreadsheetFunctionDescriptionStringId.IsOdd': 'Returns TRUE if the number is odd.',
                'XtraSpreadsheetFunctionDescriptionStringId.MRound': 'Returns a number rounded to the desired multiple.',
                'XtraSpreadsheetFunctionDescriptionStringId.Erf': 'Returns the error function.',
                'XtraSpreadsheetFunctionDescriptionStringId.Erfc': 'Returns the complementary error function.',
                'XtraSpreadsheetFunctionDescriptionStringId.BesselJ': 'Returns the Bessel function Jn(x).',
                'XtraSpreadsheetFunctionDescriptionStringId.BesselK': 'Returns the modified Bessel function Kn(x).',
                'XtraSpreadsheetFunctionDescriptionStringId.BesselY': 'Returns the Bessel function Yn(x).',
                'XtraSpreadsheetFunctionDescriptionStringId.BesselI': 'Returns the modified Bessel function In(x).',
                'XtraSpreadsheetFunctionDescriptionStringId.Xirr': 'Returns the internal rate of return for a schedule of cash flows.',
                'XtraSpreadsheetFunctionDescriptionStringId.Xnpv': 'Returns the net present value for a schedule of cash flows.',
                'XtraSpreadsheetFunctionDescriptionStringId.PriceMat': 'Returns the price per $100 face value of a security that pays interest at maturity.',
                'XtraSpreadsheetFunctionDescriptionStringId.YieldMat': 'Returns the annual yield of a security that pays interest at maturity.',
                'XtraSpreadsheetFunctionDescriptionStringId.Intrate': 'Returns the interest rate for a fully invested security.',
                'XtraSpreadsheetFunctionDescriptionStringId.Received': 'Returns the amount received at maturity for a fully invested security.',
                'XtraSpreadsheetFunctionDescriptionStringId.Disc': 'Returns the discount rate for a security.',
                'XtraSpreadsheetFunctionDescriptionStringId.PriceDisc': 'Returns the price per $100 face value of a discounted security.',
                'XtraSpreadsheetFunctionDescriptionStringId.YieldDisc': 'Returns the annual yield for a discounted security. For example, a treasury bill.',
                'XtraSpreadsheetFunctionDescriptionStringId.TbillEq': 'Returns the bond-equivalent yield for a treasury bill.',
                'XtraSpreadsheetFunctionDescriptionStringId.TbillPrice': 'Returns the price per $100 face value for a treasury bill.',
                'XtraSpreadsheetFunctionDescriptionStringId.TbillYield': 'Returns the yield for a treasury bill.',
                'XtraSpreadsheetFunctionDescriptionStringId.Price': 'Returns the price per $100 face value of a security that pays periodic interest.',
                'XtraSpreadsheetFunctionDescriptionStringId.Yield': 'Returns the yield on a security that pays periodic interest.',
                'XtraSpreadsheetFunctionDescriptionStringId.DollarDe': 'Converts a dollar price, expressed as a fraction, into a dollar price, expressed as a decimal number.',
                'XtraSpreadsheetFunctionDescriptionStringId.DollarFr': 'Converts a dollar price, expressed as a decimal number, into a dollar price, expressed as a fraction.',
                'XtraSpreadsheetFunctionDescriptionStringId.Nominal': 'Returns the annual nominal interest rate.',
                'XtraSpreadsheetFunctionDescriptionStringId.Effect': 'Returns the effective annual interest rate.',
                'XtraSpreadsheetFunctionDescriptionStringId.CumPrinc': 'Returns the cumulative principal paid on a loan between two periods.',
                'XtraSpreadsheetFunctionDescriptionStringId.CumIpmt': 'Returns the cumulative interest paid between two periods.',
                'XtraSpreadsheetFunctionDescriptionStringId.EDate': 'Returns the serial number of the date that is the indicated number of months before or after the start date.',
                'XtraSpreadsheetFunctionDescriptionStringId.EOMonth': 'Returns the serial number of the last day of the month before or after a specified number of months.',
                'XtraSpreadsheetFunctionDescriptionStringId.YearFrac': 'Returns the year fraction representing the number of whole days between start_date and end_date.',
                'XtraSpreadsheetFunctionDescriptionStringId.CoupDaybs': 'Returns the number of days from the beginning of the coupon period to the settlement date.',
                'XtraSpreadsheetFunctionDescriptionStringId.CoupDays': 'Returns the number of days in the coupon period that contains the settlement date.',
                'XtraSpreadsheetFunctionDescriptionStringId.CoupDaysnc': 'Returns the number of days from the settlement date to the next coupon date.',
                'XtraSpreadsheetFunctionDescriptionStringId.Coupncd': 'Returns the next coupon date after the settlement date.',
                'XtraSpreadsheetFunctionDescriptionStringId.CoupNum': 'Returns the number of coupons payable between the settlement date and maturity date.',
                'XtraSpreadsheetFunctionDescriptionStringId.Couppcd': 'Returns the previous coupon date before the settlement date.',
                'XtraSpreadsheetFunctionDescriptionStringId.Duration': 'Returns the annual duration of a security with periodic interest payments.',
                'XtraSpreadsheetFunctionDescriptionStringId.MDuration': 'Returns the Macauley modified duration for a security with an assumed par value of $100.',
                'XtraSpreadsheetFunctionDescriptionStringId.OddLPrice': 'Returns the price per $100 face value of a security with an odd last period.',
                'XtraSpreadsheetFunctionDescriptionStringId.OddLYield': 'Returns the yield of a security with an odd last period.',
                'XtraSpreadsheetFunctionDescriptionStringId.OddFPrice': 'Returns the price per $100 face value of a security with an odd first period.',
                'XtraSpreadsheetFunctionDescriptionStringId.OddFYield': 'Returns the yield of a security with an odd first period.',
                'XtraSpreadsheetFunctionDescriptionStringId.RandBetween': 'Returns a random number between the numbers you specify.',
                'XtraSpreadsheetFunctionDescriptionStringId.WeekNum': 'Returns the week number in the year.',
                'XtraSpreadsheetFunctionDescriptionStringId.Amordegrc': 'Returns the prorated linear depreciation of an asset for each accounting period.',
                'XtraSpreadsheetFunctionDescriptionStringId.Amorlinc': 'Returns the prorated linear depreciation of an asset for each accounting period.',
                'XtraSpreadsheetFunctionDescriptionStringId.Convert': 'Converts a number from one measurement system to another.',
                'XtraSpreadsheetFunctionDescriptionStringId.Accrint': 'Returns the accrued interest for a security that pays periodic interest.',
                'XtraSpreadsheetFunctionDescriptionStringId.Accrintm': 'Returns the accrued interest for a security that pays interest at maturity.',
                'XtraSpreadsheetFunctionDescriptionStringId.WorkDay': 'Returns the serial number of the date before or after a specified number of workdays.',
                'XtraSpreadsheetFunctionDescriptionStringId.NetworkDays': 'Returns the number of whole workdays between two dates.',
                'XtraSpreadsheetFunctionDescriptionStringId.Gcd': 'Returns the greatest common divisor.',
                'XtraSpreadsheetFunctionDescriptionStringId.Multinomial': 'Returns the multinomial of a set of numbers.',
                'XtraSpreadsheetFunctionDescriptionStringId.Lcm': 'Returns the least common multiple.',
                'XtraSpreadsheetFunctionDescriptionStringId.FvSchedule': 'Returns the future value of an initial principal after applying a series of compound interest rates.',
                'XtraSpreadsheetFunctionDescriptionStringId.CubeKpiMember': 'Returns a key performance indicator (KPI) property and displays the KPI name in the cell.',
                'XtraSpreadsheetFunctionDescriptionStringId.CubeSet': 'Defines a calculated set of members or tuples by sending a set expression to the cube on the server, which creates the set, and then returns that set to Spreadsheet.',
                'XtraSpreadsheetFunctionDescriptionStringId.CubeSetCount': 'Returns the number of items in a set.',
                'XtraSpreadsheetFunctionDescriptionStringId.IfError': 'Returns value_if_error if expression is an error and the value of the expression itself otherwise.',
                'XtraSpreadsheetFunctionDescriptionStringId.CountIfs': 'Counts the number of cells specified by a given set of conditions or criteria.',
                'XtraSpreadsheetFunctionDescriptionStringId.SumIfs': 'Adds the cells specified by a given set of conditions or criteria.',
                'XtraSpreadsheetFunctionDescriptionStringId.AverageIf': 'Finds average(arithmetic mean) for the cells specified by a given condition or criteria.',
                'XtraSpreadsheetFunctionDescriptionStringId.AverageIfs': 'Finds average(arithmetic mean) for the cells specified by a given set of conditions or criteria.',
                'XtraSpreadsheetFunctionDescriptionStringId.Aggregate': 'Returns an aggregate in a list or database.',
                'XtraSpreadsheetFunctionDescriptionStringId.BinomDotDist': 'Returns the individual term binomial distribution probability.',
                'XtraSpreadsheetFunctionDescriptionStringId.BinomDotInv': 'Returns the smallest value for which the cumulative binomial distribution is greater than or equal to a criterion value.',
                'XtraSpreadsheetFunctionDescriptionStringId.ConfidenceNorm': 'Returns the confidence interval for a population mean, using a normal distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.ConfidenceDotT': 'Returns the confidence interval for a population mean, using a Student\'s T distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.ChisqDotTest': 'Returns the test for independence: the value from the chi-squared distribution for the statistic and the appropriate degrees of freedom.',
                'XtraSpreadsheetFunctionDescriptionStringId.FDotTest': 'Returns the result of an F-test, the two-tailed probability that the variances in Array1 and Array2 are not significantly different.',
                'XtraSpreadsheetFunctionDescriptionStringId.CovarianceP': 'Returns population covariance, the average of the products of deviations for each data point pair in two data sets.',
                'XtraSpreadsheetFunctionDescriptionStringId.CovarianceS': 'Returns sample covariance, the average of the products of deviations for each data point pair in two data sets.',
                'XtraSpreadsheetFunctionDescriptionStringId.ExponDotDist': 'Returns the exponential distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.GammaDotDist': 'Returns the gamma distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.GammaDotInv': 'Returns the inverse of the gamma cumulative distribution: if p = GAMMA.DIST(x,...), then GAMMA.INV(p,...) = x.',
                'XtraSpreadsheetFunctionDescriptionStringId.ModeMult': 'Returns a vertical array of the most frequently occurring, or repetitive, values in an array or range of data.  For a horizontal array, use =TRANSPOSE(MODE.MULT(number1,number2,...)).',
                'XtraSpreadsheetFunctionDescriptionStringId.ModeSngl': 'Returns the most frequently occurring, or repetitive, value in an array or range of data.',
                'XtraSpreadsheetFunctionDescriptionStringId.NormDist': 'Returns the normal distribution for the specified mean and standard deviation.',
                'XtraSpreadsheetFunctionDescriptionStringId.NormInv': 'Returns the inverse of the normal cumulative distribution for the specified mean and standard deviation.',
                'XtraSpreadsheetFunctionDescriptionStringId.PercentileExc': 'Returns the k-th percentile of values in a range, where k is in the range 0..1, exclusive.',
                'XtraSpreadsheetFunctionDescriptionStringId.PercentileInc': 'Returns the k-th percentile of values in a range, where k is in the range 0..1, inclusive.',
                'XtraSpreadsheetFunctionDescriptionStringId.PercentRankExc': 'Returns the rank of a value in a data set as a percentage of the data set as a percentage (0..1, exclusive) of the data set.',
                'XtraSpreadsheetFunctionDescriptionStringId.PercentRankInc': 'Returns the rank of a value in a data set as a percentage of the data set as a percentage (0..1, inclusive) of the data set.',
                'XtraSpreadsheetFunctionDescriptionStringId.PoissonDotDist': 'Returns the Poisson distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.QuartileExc': 'Returns the quartile of a data set, based on percentile values from 0..1, exclusive.',
                'XtraSpreadsheetFunctionDescriptionStringId.QuartileInc': 'Returns the quartile of a data set, based on percentile values from 0..1, inclusive.',
                'XtraSpreadsheetFunctionDescriptionStringId.RankDotAvg': 'Returns the rank of a number in a list of numbers: its size relative to other values in the list; if more than one value has the same rank, the average rank is returned.',
                'XtraSpreadsheetFunctionDescriptionStringId.RankDotEq': 'Returns the rank of a number in a list of numbers: its size relative to other values in the list; if more than one value has the same rank, the top rank of that set of values is returned.',
                'XtraSpreadsheetFunctionDescriptionStringId.StDevDotS': 'Estimates standard deviation based on a sample (ignores logical values and text in the sample).',
                'XtraSpreadsheetFunctionDescriptionStringId.StDevDotP': 'Calculates standard deviation based on the entire population given as arguments (ignores logical values and text).',
                'XtraSpreadsheetFunctionDescriptionStringId.TDotDist': 'Returns the left-tailed Student\'s t-distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.TDotDistDot2t': 'Returns the two-tailed Student\'s t-distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.TDotDistDotTt': 'Returns the right-tailed Student\'s t-distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.TDotInv': 'Returns the left-tailed inverse of the Student\'s t-distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.TDotInvDot2t': 'Returns the two-tailed inverse of the Student\'s t-distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.VarDotS': 'Estimates variance based on a sample (ignores logical values and text in the sample).',
                'XtraSpreadsheetFunctionDescriptionStringId.VarDotP': 'Calculates variance based on the entire population (ignores logical values and text in the population).',
                'XtraSpreadsheetFunctionDescriptionStringId.WeibullDotDist': 'Returns the Weibull distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.NetworkDaysIntl': 'Returns the number of whole workdays between two dates with custom weekend parameters.',
                'XtraSpreadsheetFunctionDescriptionStringId.WorkDayIntl': 'Returns the serial number of the date before or after a specified number of workdays with custom weekend parameters.',
                'XtraSpreadsheetFunctionDescriptionStringId.IsoCeiling': 'Rounds a number up, to the nearest integer or to the nearest multiple of significance.',
                'XtraSpreadsheetFunctionDescriptionStringId.BetaDist': 'Returns the beta probability distribution function.',
                'XtraSpreadsheetFunctionDescriptionStringId.BetaDotInv': 'Returns the inverse of the cumulative beta probability density function (BETA.DIST).',
                'XtraSpreadsheetFunctionDescriptionStringId.ChisqDotDist': 'Returns the left-tailed probability of the chi-squared distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.ChisqDotDistDotRt': 'Returns the right-tailed probability of the chi-squared distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.ChisqDotInv': 'Returns the inverse of the left-tailed probability of the chi-squared distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.ChisqDotInvDotRt': 'Returns the inverse of the right-tailed probability of the chi-squared distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.FDotDist': 'Returns the (left-tailed) F probability distribution (degree of diversity) for two data sets.',
                'XtraSpreadsheetFunctionDescriptionStringId.FDotDistDotRt': 'Returns the (right-tailed) F probability distribution (degree of diversity) for two data sets.',
                'XtraSpreadsheetFunctionDescriptionStringId.FDotInv': 'Returns the inverse of the (left-tailed) F probability distribution: if p = F.DIST(x,...), then F.INV(p,...) = x.',
                'XtraSpreadsheetFunctionDescriptionStringId.FDotinvDotRt': 'Returns the inverse of the (right-tailed) F probability distribution: if p = F.DIST.RT(x,...), then F.INV.RT(p,...) = x.',
                'XtraSpreadsheetFunctionDescriptionStringId.HypgeomDotDist': 'Returns the hypergeometric distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.LogNormDist': 'Returns the lognormal distribution of x, where ln(x) is normally distributed with parameters Mean and Standard_dev.',
                'XtraSpreadsheetFunctionDescriptionStringId.LogNormInv': 'Returns the inverse of the lognormal cumulative distribution function of x, where ln(x) is normally distributed with parameters Mean and Standard_dev.',
                'XtraSpreadsheetFunctionDescriptionStringId.NegbinomDotDist': 'Returns the negative binomial distribution, the probability that there will be Number_f failures before the Number_s-th success, with Probability_s probability of a success.',
                'XtraSpreadsheetFunctionDescriptionStringId.NormSDist': 'Returns the standard normal distribution (has a mean of zero and a standard deviation of one).',
                'XtraSpreadsheetFunctionDescriptionStringId.NormSInv': 'Returns the inverse of the standard normal cumulative distribution (has a mean of zero and a standard deviation of one).',
                'XtraSpreadsheetFunctionDescriptionStringId.TDotTest': 'Returns the probability associated with a Student\'s t-Test.',
                'XtraSpreadsheetFunctionDescriptionStringId.ZDotTest': 'Returns the one-tailed P-value of a z-test.',
                'XtraSpreadsheetFunctionDescriptionStringId.ErfPrecise': 'Returns the error function.',
                'XtraSpreadsheetFunctionDescriptionStringId.ErfcPrecise': 'Returns the complementary error function.',
                'XtraSpreadsheetFunctionDescriptionStringId.GammaLnPrecise': 'Returns the natural logarithm of the gamma function.',
                'XtraSpreadsheetFunctionDescriptionStringId.CeilingDotPrecise': 'Rounds a number up, to the nearest integer or to the nearest multiple of significance.',
                'XtraSpreadsheetFunctionDescriptionStringId.FloorDotPrecise': 'Rounds a number down, to the nearest integer or to the nearest multiple of significance.',
                'XtraSpreadsheetFunctionDescriptionStringId.ACot': 'Returns the arccotangent of a number, in radians in the range 0 to Pi.',
                'XtraSpreadsheetFunctionDescriptionStringId.ACotH': 'Returns the inverse hyperbolic cotangent of a number.',
                'XtraSpreadsheetFunctionDescriptionStringId.Cot': 'Returns the cotangent of an angle.',
                'XtraSpreadsheetFunctionDescriptionStringId.CotH': 'Returns the hyperbolic cotangent of a number.',
                'XtraSpreadsheetFunctionDescriptionStringId.Csc': 'Returns the cosecant of an angle.',
                'XtraSpreadsheetFunctionDescriptionStringId.CscH': 'Returns the hyperbolic cosecant of an angle.',
                'XtraSpreadsheetFunctionDescriptionStringId.Sec': 'Returns the secant of an angle.',
                'XtraSpreadsheetFunctionDescriptionStringId.SecH': 'Returns the hyperbolic secant of an angle.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImTan': 'Returns the tangent of a complex number.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImCot': 'Returns the cotangent of a complex number.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImCsc': 'Returns the cosecant of a complex number.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImCscH': 'Returns the hyperbolic cosecant of a complex number.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImSec': 'Returns the secant of a complex number.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImSecH': 'Returns the hyperbolic secant of a complex number.',
                'XtraSpreadsheetFunctionDescriptionStringId.BitAnd': 'Returns a bitwise \'And\' of two numbers.',
                'XtraSpreadsheetFunctionDescriptionStringId.BitOr': 'Returns a bitwise \'Or\' of two numbers.',
                'XtraSpreadsheetFunctionDescriptionStringId.BitXor': 'Returns a bitwise \'Exclusive Or\' of two numbers.',
                'XtraSpreadsheetFunctionDescriptionStringId.BitLShift': 'Returns a number shifted left by shift_amount bits.',
                'XtraSpreadsheetFunctionDescriptionStringId.BitRShift': 'Returns a number shifted right by shift_amount bits.',
                'XtraSpreadsheetFunctionDescriptionStringId.Permutationa': 'Returns the number of permutations for a given number of objects (with repetitions) that can be selected from the total objects.',
                'XtraSpreadsheetFunctionDescriptionStringId.CombinA': 'Returns the number of combinations with repetitions for a given number of items.',
                'XtraSpreadsheetFunctionDescriptionStringId.XOr': 'Returns a logical \'Exclusive Or\' of all arguments.',
                'XtraSpreadsheetFunctionDescriptionStringId.PDuration': 'Returns the number of periods required by an investment to reach a specified value.',
                'XtraSpreadsheetFunctionDescriptionStringId.Base': 'Converts a number into a text representation with the given radix (base).',
                'XtraSpreadsheetFunctionDescriptionStringId.Decimal': 'Converts a text representation of a number in a given base into a decimal number.',
                'XtraSpreadsheetFunctionDescriptionStringId.Days': 'Returns the number of days between the two dates.',
                'XtraSpreadsheetFunctionDescriptionStringId.BinomDistRange': 'Returns the probability of a trial result using a binomial distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.Gamma': 'Returns the Gamma function value.',
                'XtraSpreadsheetFunctionDescriptionStringId.SkewP': 'Returns the skewness of a distribution based on a population: a characterization of the degree of asymmetry of a distribution around its mean.',
                'XtraSpreadsheetFunctionDescriptionStringId.Phi': 'Returns the value of the density function for a standard normal distribution.',
                'XtraSpreadsheetFunctionDescriptionStringId.RRI': 'Returns an equivalent interest rate for the growth of an investment.',
                'XtraSpreadsheetFunctionDescriptionStringId.Unicode': 'Returns the number (code point) corresponding to the first character of the text.',
                'XtraSpreadsheetFunctionDescriptionStringId.MUnit': 'Returns the unit matrix for the specified dimension.',
                'XtraSpreadsheetFunctionDescriptionStringId.Arabic': 'Converts a Roman numeral to Arabic.',
                'XtraSpreadsheetFunctionDescriptionStringId.ISOWeekNum': 'Returns number of the ISO week number of the year for a given date.',
                'XtraSpreadsheetFunctionDescriptionStringId.NumberValue': 'Converts text to number in a locale-independent manner.',
                'XtraSpreadsheetFunctionDescriptionStringId.Sheet': 'Returns the sheet number of the referenced sheet.',
                'XtraSpreadsheetFunctionDescriptionStringId.Sheets': 'Returns the number of sheets in a reference.',
                'XtraSpreadsheetFunctionDescriptionStringId.FormulaText': 'Returns a formula as a string.',
                'XtraSpreadsheetFunctionDescriptionStringId.IsFormula': 'Checks whether a reference is to a cell containing a formula, and returns TRUE or FALSE.',
                'XtraSpreadsheetFunctionDescriptionStringId.IfNA': 'Returns the value you specify if the expression resolves to #N/A, otherwise returns the result of the expression.',
                'XtraSpreadsheetFunctionDescriptionStringId.CeilingMath': 'Rounds a number up, to the nearest integer or to the nearest multiple of significance.',
                'XtraSpreadsheetFunctionDescriptionStringId.FloorMath': 'Rounds a number down, to the nearest integer or to the nearest multiple of significance.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImSinH': 'Returns the hyperbolic sine of a complex number.',
                'XtraSpreadsheetFunctionDescriptionStringId.ImCosH': 'Returns the hyperbolic cosine of a complex number.',
                'XtraSpreadsheetFunctionDescriptionStringId.FunctionFilterXML': 'Returns specific data from the XML content by using the specified XPath.',
                'XtraSpreadsheetFunctionDescriptionStringId.FunctionWebService': 'Returns data from a web service.',
                'XtraSpreadsheetFunctionDescriptionStringId.EncodeURL': 'Returns a URL-encoded string.',
                'XtraSpreadsheetFunctionDescriptionStringId.Concat': 'Concatenates a list or range of text strings.',
                'XtraSpreadsheetFunctionDescriptionStringId.Ifs': 'Checks whether one or more conditions are met and returns a value corresponding to the first TRUE condition.',
                'XtraSpreadsheetFunctionDescriptionStringId.MaxIfs': 'Returns the maximum value among cells specified by a given set of conditions or criteria.',
                'XtraSpreadsheetFunctionDescriptionStringId.MinIfs': 'Returns the minimum value among cells specified by a given set of conditions or criteria.',
                'XtraSpreadsheetFunctionDescriptionStringId.Switch': 'Evaluates an expression against a list of values and returns the result corresponding to the first matching value. If there is no match, an optional default value is returned.',
                'XtraSpreadsheetFunctionDescriptionStringId.TextJoin': 'Concatenates a list or range of text strings using a delimiter.',
                'XtraSpreadsheetFunctionNameStringId.Abs': 'ABS',
                'XtraSpreadsheetFunctionNameStringId.Accrint': 'ACCRINT',
                'XtraSpreadsheetFunctionNameStringId.Accrintm': 'ACCRINTM',
                'XtraSpreadsheetFunctionNameStringId.ACos': 'ACOS',
                'XtraSpreadsheetFunctionNameStringId.ACosH': 'ACOSH',
                'XtraSpreadsheetFunctionNameStringId.ACot': 'ACOT',
                'XtraSpreadsheetFunctionNameStringId.ACotH': 'ACOTH',
                'XtraSpreadsheetFunctionNameStringId.Address': 'ADDRESS',
                'XtraSpreadsheetFunctionNameStringId.AddressInfo': 'address',
                'XtraSpreadsheetFunctionNameStringId.Aggregate': 'AGGREGATE',
                'XtraSpreadsheetFunctionNameStringId.Amordegrc': 'AMORDEGRC',
                'XtraSpreadsheetFunctionNameStringId.Amorlinc': 'AMORLINC',
                'XtraSpreadsheetFunctionNameStringId.And': 'AND',
                'XtraSpreadsheetFunctionNameStringId.Arabic': 'ARABIC',
                'XtraSpreadsheetFunctionNameStringId.Areas': 'AREAS',
                'XtraSpreadsheetFunctionNameStringId.Asc': 'ASC',
                'XtraSpreadsheetFunctionNameStringId.ASin': 'ASIN',
                'XtraSpreadsheetFunctionNameStringId.ASinH': 'ASINH',
                'XtraSpreadsheetFunctionNameStringId.ATan': 'ATAN',
                'XtraSpreadsheetFunctionNameStringId.ATan2': 'ATAN2',
                'XtraSpreadsheetFunctionNameStringId.ATanH': 'ATANH',
                'XtraSpreadsheetFunctionNameStringId.AutoCalcMode': 'Automatic',
                'XtraSpreadsheetFunctionNameStringId.Avedev': 'AVEDEV',
                'XtraSpreadsheetFunctionNameStringId.Average': 'AVERAGE',
                'XtraSpreadsheetFunctionNameStringId.AverageA': 'AVERAGEA',
                'XtraSpreadsheetFunctionNameStringId.AverageIf': 'AVERAGEIF',
                'XtraSpreadsheetFunctionNameStringId.AverageIfs': 'AVERAGEIFS',
                'XtraSpreadsheetFunctionNameStringId.BahtText': 'BAHTTEXT',
                'XtraSpreadsheetFunctionNameStringId.Base': 'BASE',
                'XtraSpreadsheetFunctionNameStringId.BesselI': 'BESSELI',
                'XtraSpreadsheetFunctionNameStringId.BesselJ': 'BESSELJ',
                'XtraSpreadsheetFunctionNameStringId.BesselK': 'BESSELK',
                'XtraSpreadsheetFunctionNameStringId.BesselY': 'BESSELY',
                'XtraSpreadsheetFunctionNameStringId.BetaDist': 'BETA.DIST',
                'XtraSpreadsheetFunctionNameStringId.BetaDistCompatibility': 'BETADIST',
                'XtraSpreadsheetFunctionNameStringId.BetaDotInv': 'BETA.INV',
                'XtraSpreadsheetFunctionNameStringId.BetaInv': 'BETAINV',
                'XtraSpreadsheetFunctionNameStringId.Bin2Dec': 'BIN2DEC',
                'XtraSpreadsheetFunctionNameStringId.Bin2Hex': 'BIN2HEX',
                'XtraSpreadsheetFunctionNameStringId.Bin2Oct': 'BIN2OCT',
                'XtraSpreadsheetFunctionNameStringId.BinomDist': 'BINOMDIST',
                'XtraSpreadsheetFunctionNameStringId.BinomDistRange': 'BINOM.DIST.RANGE',
                'XtraSpreadsheetFunctionNameStringId.BinomDotDist': 'BINOM.DIST',
                'XtraSpreadsheetFunctionNameStringId.BinomDotInv': 'BINOM.INV',
                'XtraSpreadsheetFunctionNameStringId.BitAnd': 'BITAND',
                'XtraSpreadsheetFunctionNameStringId.BitLShift': 'BITLSHIFT',
                'XtraSpreadsheetFunctionNameStringId.BitOr': 'BITOR',
                'XtraSpreadsheetFunctionNameStringId.BitRShift': 'BITRSHIFT',
                'XtraSpreadsheetFunctionNameStringId.BitXor': 'BITXOR',
                'XtraSpreadsheetFunctionNameStringId.Call': 'CALL',
                'XtraSpreadsheetFunctionNameStringId.Ceiling': 'CEILING',
                'XtraSpreadsheetFunctionNameStringId.CeilingDotPrecise': 'CEILING.PRECISE',
                'XtraSpreadsheetFunctionNameStringId.CeilingMath': 'CEILING.MATH',
                'XtraSpreadsheetFunctionNameStringId.Cell': 'CELL',
                'XtraSpreadsheetFunctionNameStringId.Char': 'CHAR',
                'XtraSpreadsheetFunctionNameStringId.ChiDist': 'CHIDIST',
                'XtraSpreadsheetFunctionNameStringId.ChiInv': 'CHIINV',
                'XtraSpreadsheetFunctionNameStringId.ChisqDotDist': 'CHISQ.DIST',
                'XtraSpreadsheetFunctionNameStringId.ChisqDotDistDotRt': 'CHISQ.DIST.RT',
                'XtraSpreadsheetFunctionNameStringId.ChisqDotInv': 'CHISQ.INV',
                'XtraSpreadsheetFunctionNameStringId.ChisqDotInvDotRt': 'CHISQ.INV.RT',
                'XtraSpreadsheetFunctionNameStringId.ChisqDotTest': 'CHISQ.TEST',
                'XtraSpreadsheetFunctionNameStringId.ChiTest': 'CHITEST',
                'XtraSpreadsheetFunctionNameStringId.Choose': 'CHOOSE',
                'XtraSpreadsheetFunctionNameStringId.Clean': 'CLEAN',
                'XtraSpreadsheetFunctionNameStringId.Code': 'CODE',
                'XtraSpreadsheetFunctionNameStringId.ColorInfo': 'color',
                'XtraSpreadsheetFunctionNameStringId.Column': 'COLUMN',
                'XtraSpreadsheetFunctionNameStringId.ColumnInfo': 'col',
                'XtraSpreadsheetFunctionNameStringId.Columns': 'COLUMNS',
                'XtraSpreadsheetFunctionNameStringId.Combin': 'COMBIN',
                'XtraSpreadsheetFunctionNameStringId.CombinA': 'COMBINA',
                'XtraSpreadsheetFunctionNameStringId.Complex': 'COMPLEX',
                'XtraSpreadsheetFunctionNameStringId.Concat': 'CONCAT',
                'XtraSpreadsheetFunctionNameStringId.Concatenate': 'CONCATENATE',
                'XtraSpreadsheetFunctionNameStringId.Confidence': 'CONFIDENCE',
                'XtraSpreadsheetFunctionNameStringId.ConfidenceDotT': 'CONFIDENCE.T',
                'XtraSpreadsheetFunctionNameStringId.ConfidenceNorm': 'CONFIDENCE.NORM',
                'XtraSpreadsheetFunctionNameStringId.ContentsInfo': 'contents',
                'XtraSpreadsheetFunctionNameStringId.Convert': 'CONVERT',
                'XtraSpreadsheetFunctionNameStringId.Correl': 'CORREL',
                'XtraSpreadsheetFunctionNameStringId.Cos': 'COS',
                'XtraSpreadsheetFunctionNameStringId.CosH': 'COSH',
                'XtraSpreadsheetFunctionNameStringId.Cot': 'COT',
                'XtraSpreadsheetFunctionNameStringId.CotH': 'COTH',
                'XtraSpreadsheetFunctionNameStringId.Count': 'COUNT',
                'XtraSpreadsheetFunctionNameStringId.CountA': 'COUNTA',
                'XtraSpreadsheetFunctionNameStringId.CountBlank': 'COUNTBLANK',
                'XtraSpreadsheetFunctionNameStringId.CountIf': 'COUNTIF',
                'XtraSpreadsheetFunctionNameStringId.CountIfs': 'COUNTIFS',
                'XtraSpreadsheetFunctionNameStringId.CoupDaybs': 'COUPDAYBS',
                'XtraSpreadsheetFunctionNameStringId.CoupDays': 'COUPDAYS',
                'XtraSpreadsheetFunctionNameStringId.CoupDaysnc': 'COUPDAYSNC',
                'XtraSpreadsheetFunctionNameStringId.Coupncd': 'COUPNCD',
                'XtraSpreadsheetFunctionNameStringId.CoupNum': 'COUPNUM',
                'XtraSpreadsheetFunctionNameStringId.Couppcd': 'COUPPCD',
                'XtraSpreadsheetFunctionNameStringId.Covar': 'COVAR',
                'XtraSpreadsheetFunctionNameStringId.CovarianceP': 'COVARIANCE.P',
                'XtraSpreadsheetFunctionNameStringId.CovarianceS': 'COVARIANCE.S',
                'XtraSpreadsheetFunctionNameStringId.CritBinom': 'CRITBINOM',
                'XtraSpreadsheetFunctionNameStringId.Csc': 'CSC',
                'XtraSpreadsheetFunctionNameStringId.CscH': 'CSCH',
                'XtraSpreadsheetFunctionNameStringId.CubeKpiMember': 'CUBEKPIMEMBER',
                'XtraSpreadsheetFunctionNameStringId.CubeMember': 'CUBEMEMBER',
                'XtraSpreadsheetFunctionNameStringId.CubeMemberProperty': 'CUBEMEMBERPROPERTY',
                'XtraSpreadsheetFunctionNameStringId.CubeRankedMember': 'CUBERANKEDMEMBER',
                'XtraSpreadsheetFunctionNameStringId.CubeSet': 'CUBESET',
                'XtraSpreadsheetFunctionNameStringId.CubeSetCount': 'CUBESETCOUNT',
                'XtraSpreadsheetFunctionNameStringId.CubeValue': 'CUBEVALUE',
                'XtraSpreadsheetFunctionNameStringId.CumIpmt': 'CUMIPMT',
                'XtraSpreadsheetFunctionNameStringId.CumPrinc': 'CUMPRINC',
                'XtraSpreadsheetFunctionNameStringId.Date': 'DATE',
                'XtraSpreadsheetFunctionNameStringId.DateDif': 'DATEDIF',
                'XtraSpreadsheetFunctionNameStringId.DateValue': 'DATEVALUE',
                'XtraSpreadsheetFunctionNameStringId.DAverage': 'DAVERAGE',
                'XtraSpreadsheetFunctionNameStringId.Day': 'DAY',
                'XtraSpreadsheetFunctionNameStringId.Days': 'DAYS',
                'XtraSpreadsheetFunctionNameStringId.Days360': 'DAYS360',
                'XtraSpreadsheetFunctionNameStringId.Db': 'DB',
                'XtraSpreadsheetFunctionNameStringId.DCount': 'DCOUNT',
                'XtraSpreadsheetFunctionNameStringId.DCountA': 'DCOUNTA',
                'XtraSpreadsheetFunctionNameStringId.Ddb': 'DDB',
                'XtraSpreadsheetFunctionNameStringId.Dec2Bin': 'DEC2BIN',
                'XtraSpreadsheetFunctionNameStringId.Dec2Hex': 'DEC2HEX',
                'XtraSpreadsheetFunctionNameStringId.Dec2Oct': 'DEC2OCT',
                'XtraSpreadsheetFunctionNameStringId.Decimal': 'DECIMAL',
                'XtraSpreadsheetFunctionNameStringId.Degrees': 'DEGREES',
                'XtraSpreadsheetFunctionNameStringId.Delta': 'DELTA',
                'XtraSpreadsheetFunctionNameStringId.DevSq': 'DEVSQ',
                'XtraSpreadsheetFunctionNameStringId.DGet': 'DGET',
                'XtraSpreadsheetFunctionNameStringId.DirectoryInfo': 'directory',
                'XtraSpreadsheetFunctionNameStringId.Disc': 'DISC',
                'XtraSpreadsheetFunctionNameStringId.DMax': 'DMAX',
                'XtraSpreadsheetFunctionNameStringId.DMin': 'DMIN',
                'XtraSpreadsheetFunctionNameStringId.Dollar': 'DOLLAR',
                'XtraSpreadsheetFunctionNameStringId.DollarDe': 'DOLLARDE',
                'XtraSpreadsheetFunctionNameStringId.DollarFr': 'DOLLARFR',
                'XtraSpreadsheetFunctionNameStringId.DProduct': 'DPRODUCT',
                'XtraSpreadsheetFunctionNameStringId.DStDev': 'DSTDEV',
                'XtraSpreadsheetFunctionNameStringId.DStDevP': 'DSTDEVP',
                'XtraSpreadsheetFunctionNameStringId.DSum': 'DSUM',
                'XtraSpreadsheetFunctionNameStringId.Duration': 'DURATION',
                'XtraSpreadsheetFunctionNameStringId.DVar': 'DVAR',
                'XtraSpreadsheetFunctionNameStringId.DVarP': 'DVARP',
                'XtraSpreadsheetFunctionNameStringId.EDate': 'EDATE',
                'XtraSpreadsheetFunctionNameStringId.Effect': 'EFFECT',
                'XtraSpreadsheetFunctionNameStringId.EncodeURL': 'ENCODEURL',
                'XtraSpreadsheetFunctionNameStringId.EOMonth': 'EOMONTH',
                'XtraSpreadsheetFunctionNameStringId.Erf': 'ERF',
                'XtraSpreadsheetFunctionNameStringId.Erfc': 'ERFC',
                'XtraSpreadsheetFunctionNameStringId.ErfcPrecise': 'ERFC.PRECISE',
                'XtraSpreadsheetFunctionNameStringId.ErfPrecise': 'ERF.PRECISE',
                'XtraSpreadsheetFunctionNameStringId.ErrorType': 'ERROR.TYPE',
                'XtraSpreadsheetFunctionNameStringId.Even': 'EVEN',
                'XtraSpreadsheetFunctionNameStringId.Exact': 'EXACT',
                'XtraSpreadsheetFunctionNameStringId.Exp': 'EXP',
                'XtraSpreadsheetFunctionNameStringId.ExponDist': 'EXPONDIST',
                'XtraSpreadsheetFunctionNameStringId.ExponDotDist': 'EXPON.DIST',
                'XtraSpreadsheetFunctionNameStringId.Fact': 'FACT',
                'XtraSpreadsheetFunctionNameStringId.FactDouble': 'FACTDOUBLE',
                'XtraSpreadsheetFunctionNameStringId.False': 'FALSE',
                'XtraSpreadsheetFunctionNameStringId.FDist': 'FDIST',
                'XtraSpreadsheetFunctionNameStringId.FDotDist': 'F.DIST',
                'XtraSpreadsheetFunctionNameStringId.FDotDistDotRt': 'F.DIST.RT',
                'XtraSpreadsheetFunctionNameStringId.FDotInv': 'F.INV',
                'XtraSpreadsheetFunctionNameStringId.FDotinvDotRt': 'F.INV.RT',
                'XtraSpreadsheetFunctionNameStringId.FDotTest': 'F.TEST',
                'XtraSpreadsheetFunctionNameStringId.Field': 'FIELD',
                'XtraSpreadsheetFunctionNameStringId.FieldPicture': 'FIELDPICTURE',
                'XtraSpreadsheetFunctionNameStringId.FilenameInfo': 'filename',
                'XtraSpreadsheetFunctionNameStringId.Find': 'FIND',
                'XtraSpreadsheetFunctionNameStringId.FindB': 'FINDB',
                'XtraSpreadsheetFunctionNameStringId.FInv': 'FINV',
                'XtraSpreadsheetFunctionNameStringId.Fisher': 'FISHER',
                'XtraSpreadsheetFunctionNameStringId.FisherInv': 'FISHERINV',
                'XtraSpreadsheetFunctionNameStringId.Fixed': 'FIXED',
                'XtraSpreadsheetFunctionNameStringId.Floor': 'FLOOR',
                'XtraSpreadsheetFunctionNameStringId.FloorDotPrecise': 'FLOOR.PRECISE',
                'XtraSpreadsheetFunctionNameStringId.FloorMath': 'FLOOR.MATH',
                'XtraSpreadsheetFunctionNameStringId.Forecast': 'FORECAST',
                'XtraSpreadsheetFunctionNameStringId.FormatInfo': 'format',
                'XtraSpreadsheetFunctionNameStringId.FormulaText': 'FORMULATEXT',
                'XtraSpreadsheetFunctionNameStringId.Frequency': 'FREQUENCY',
                'XtraSpreadsheetFunctionNameStringId.FTest': 'FTEST',
                'XtraSpreadsheetFunctionNameStringId.FunctionFilterXML': 'FILTERXML',
                'XtraSpreadsheetFunctionNameStringId.FunctionWebService': 'WEBSERVICE',
                'XtraSpreadsheetFunctionNameStringId.Fv': 'FV',
                'XtraSpreadsheetFunctionNameStringId.FvSchedule': 'FVSCHEDULE',
                'XtraSpreadsheetFunctionNameStringId.Gamma': 'GAMMA',
                'XtraSpreadsheetFunctionNameStringId.GammaDist': 'GAMMADIST',
                'XtraSpreadsheetFunctionNameStringId.GammaDotDist': 'GAMMA.DIST',
                'XtraSpreadsheetFunctionNameStringId.GammaDotInv': 'GAMMA.INV',
                'XtraSpreadsheetFunctionNameStringId.GammaInv': 'GAMMAINV',
                'XtraSpreadsheetFunctionNameStringId.GammaLn': 'GAMMALN',
                'XtraSpreadsheetFunctionNameStringId.GammaLnPrecise': 'GAMMALN.PRECISE',
                'XtraSpreadsheetFunctionNameStringId.Gauss': 'GAUSS',
                'XtraSpreadsheetFunctionNameStringId.Gcd': 'GCD',
                'XtraSpreadsheetFunctionNameStringId.Geomean': 'GEOMEAN',
                'XtraSpreadsheetFunctionNameStringId.Gestep': 'GESTEP',
                'XtraSpreadsheetFunctionNameStringId.GetPivotData': 'GETPIVOTDATA',
                'XtraSpreadsheetFunctionNameStringId.Growth': 'GROWTH',
                'XtraSpreadsheetFunctionNameStringId.HarMean': 'HARMEAN',
                'XtraSpreadsheetFunctionNameStringId.Hex2Bin': 'HEX2BIN',
                'XtraSpreadsheetFunctionNameStringId.Hex2Dec': 'HEX2DEC',
                'XtraSpreadsheetFunctionNameStringId.Hex2Oct': 'HEX2OCT',
                'XtraSpreadsheetFunctionNameStringId.HLookup': 'HLOOKUP',
                'XtraSpreadsheetFunctionNameStringId.Hour': 'HOUR',
                'XtraSpreadsheetFunctionNameStringId.Hyperlink': 'HYPERLINK',
                'XtraSpreadsheetFunctionNameStringId.HypGeomDist': 'HYPGEOMDIST',
                'XtraSpreadsheetFunctionNameStringId.HypgeomDotDist': 'HYPGEOM.DIST',
                'XtraSpreadsheetFunctionNameStringId.If': 'IF',
                'XtraSpreadsheetFunctionNameStringId.IfError': 'IFERROR',
                'XtraSpreadsheetFunctionNameStringId.IfNA': 'IFNA',
                'XtraSpreadsheetFunctionNameStringId.Ifs': 'IFS',
                'XtraSpreadsheetFunctionNameStringId.ImAbs': 'IMABS',
                'XtraSpreadsheetFunctionNameStringId.Imaginary': 'IMAGINARY',
                'XtraSpreadsheetFunctionNameStringId.ImArgument': 'IMARGUMENT',
                'XtraSpreadsheetFunctionNameStringId.ImConjugate': 'IMCONJUGATE',
                'XtraSpreadsheetFunctionNameStringId.ImCos': 'IMCOS',
                'XtraSpreadsheetFunctionNameStringId.ImCosH': 'IMCOSH',
                'XtraSpreadsheetFunctionNameStringId.ImCot': 'IMCOT',
                'XtraSpreadsheetFunctionNameStringId.ImCsc': 'IMCSC',
                'XtraSpreadsheetFunctionNameStringId.ImCscH': 'IMCSCH',
                'XtraSpreadsheetFunctionNameStringId.ImDiv': 'IMDIV',
                'XtraSpreadsheetFunctionNameStringId.ImExp': 'IMEXP',
                'XtraSpreadsheetFunctionNameStringId.ImLn': 'IMLN',
                'XtraSpreadsheetFunctionNameStringId.ImLog10': 'IMLOG10',
                'XtraSpreadsheetFunctionNameStringId.ImLog2': 'IMLOG2',
                'XtraSpreadsheetFunctionNameStringId.ImPower': 'IMPOWER',
                'XtraSpreadsheetFunctionNameStringId.ImProduct': 'IMPRODUCT',
                'XtraSpreadsheetFunctionNameStringId.ImReal': 'IMREAL',
                'XtraSpreadsheetFunctionNameStringId.ImSec': 'IMSEC',
                'XtraSpreadsheetFunctionNameStringId.ImSecH': 'IMSECH',
                'XtraSpreadsheetFunctionNameStringId.ImSin': 'IMSIN',
                'XtraSpreadsheetFunctionNameStringId.ImSinH': 'IMSINH',
                'XtraSpreadsheetFunctionNameStringId.ImSqrt': 'IMSQRT',
                'XtraSpreadsheetFunctionNameStringId.ImSub': 'IMSUB',
                'XtraSpreadsheetFunctionNameStringId.ImSum': 'IMSUM',
                'XtraSpreadsheetFunctionNameStringId.ImTan': 'IMTAN',
                'XtraSpreadsheetFunctionNameStringId.Index': 'INDEX',
                'XtraSpreadsheetFunctionNameStringId.Indirect': 'INDIRECT',
                'XtraSpreadsheetFunctionNameStringId.Info': 'INFO',
                'XtraSpreadsheetFunctionNameStringId.Int': 'INT',
                'XtraSpreadsheetFunctionNameStringId.Intercept': 'INTERCEPT',
                'XtraSpreadsheetFunctionNameStringId.Intrate': 'INTRATE',
                'XtraSpreadsheetFunctionNameStringId.Ipmt': 'IPMT',
                'XtraSpreadsheetFunctionNameStringId.Irr': 'IRR',
                'XtraSpreadsheetFunctionNameStringId.IsBlank': 'ISBLANK',
                'XtraSpreadsheetFunctionNameStringId.IsErr': 'ISERR',
                'XtraSpreadsheetFunctionNameStringId.IsError': 'ISERROR',
                'XtraSpreadsheetFunctionNameStringId.IsEven': 'ISEVEN',
                'XtraSpreadsheetFunctionNameStringId.IsFormula': 'ISFORMULA',
                'XtraSpreadsheetFunctionNameStringId.IsLogical': 'ISLOGICAL',
                'XtraSpreadsheetFunctionNameStringId.IsNA': 'ISNA',
                'XtraSpreadsheetFunctionNameStringId.IsNonText': 'ISNONTEXT',
                'XtraSpreadsheetFunctionNameStringId.IsNumber': 'ISNUMBER',
                'XtraSpreadsheetFunctionNameStringId.IsoCeiling': 'ISO.CEILING',
                'XtraSpreadsheetFunctionNameStringId.IsOdd': 'ISODD',
                'XtraSpreadsheetFunctionNameStringId.ISOWeekNum': 'ISOWEEKNUM',
                'XtraSpreadsheetFunctionNameStringId.IsPmt': 'ISPMT',
                'XtraSpreadsheetFunctionNameStringId.IsRef': 'ISREF',
                'XtraSpreadsheetFunctionNameStringId.IsText': 'ISTEXT',
                'XtraSpreadsheetFunctionNameStringId.Kurt': 'KURT',
                'XtraSpreadsheetFunctionNameStringId.Large': 'LARGE',
                'XtraSpreadsheetFunctionNameStringId.Lcm': 'LCM',
                'XtraSpreadsheetFunctionNameStringId.Left': 'LEFT',
                'XtraSpreadsheetFunctionNameStringId.LeftB': 'LEFTB',
                'XtraSpreadsheetFunctionNameStringId.Len': 'LEN',
                'XtraSpreadsheetFunctionNameStringId.LenB': 'LENB',
                'XtraSpreadsheetFunctionNameStringId.Linest': 'LINEST',
                'XtraSpreadsheetFunctionNameStringId.Ln': 'LN',
                'XtraSpreadsheetFunctionNameStringId.Log': 'LOG',
                'XtraSpreadsheetFunctionNameStringId.Log10': 'LOG10',
                'XtraSpreadsheetFunctionNameStringId.Logest': 'LOGEST',
                'XtraSpreadsheetFunctionNameStringId.LogInvCompatibility': 'LOGINV',
                'XtraSpreadsheetFunctionNameStringId.LogNormDist': 'LOGNORM.DIST',
                'XtraSpreadsheetFunctionNameStringId.LogNormDistCompatibility': 'LOGNORMDIST',
                'XtraSpreadsheetFunctionNameStringId.LogNormInv': 'LOGNORM.INV',
                'XtraSpreadsheetFunctionNameStringId.Lookup': 'LOOKUP',
                'XtraSpreadsheetFunctionNameStringId.Lower': 'LOWER',
                'XtraSpreadsheetFunctionNameStringId.ManualCalcMode': 'Manual',
                'XtraSpreadsheetFunctionNameStringId.Match': 'MATCH',
                'XtraSpreadsheetFunctionNameStringId.Max': 'MAX',
                'XtraSpreadsheetFunctionNameStringId.MaxA': 'MAXA',
                'XtraSpreadsheetFunctionNameStringId.MaxIfs': 'MAXIFS',
                'XtraSpreadsheetFunctionNameStringId.MDeterm': 'MDETERM',
                'XtraSpreadsheetFunctionNameStringId.MDuration': 'MDURATION',
                'XtraSpreadsheetFunctionNameStringId.Median': 'MEDIAN',
                'XtraSpreadsheetFunctionNameStringId.MemAvailInfo': 'memavail',
                'XtraSpreadsheetFunctionNameStringId.MemUsedInfo': 'memused',
                'XtraSpreadsheetFunctionNameStringId.Mid': 'MID',
                'XtraSpreadsheetFunctionNameStringId.MidB': 'MIDB',
                'XtraSpreadsheetFunctionNameStringId.Min': 'MIN',
                'XtraSpreadsheetFunctionNameStringId.MinA': 'MINA',
                'XtraSpreadsheetFunctionNameStringId.MinIfs': 'MINIFS',
                'XtraSpreadsheetFunctionNameStringId.Minute': 'MINUTE',
                'XtraSpreadsheetFunctionNameStringId.MInverse': 'MINVERSE',
                'XtraSpreadsheetFunctionNameStringId.Mirr': 'MIRR',
                'XtraSpreadsheetFunctionNameStringId.MMult': 'MMULT',
                'XtraSpreadsheetFunctionNameStringId.Mod': 'MOD',
                'XtraSpreadsheetFunctionNameStringId.Mode': 'MODE',
                'XtraSpreadsheetFunctionNameStringId.ModeMult': 'MODE.MULT',
                'XtraSpreadsheetFunctionNameStringId.ModeSngl': 'MODE.SNGL',
                'XtraSpreadsheetFunctionNameStringId.Month': 'MONTH',
                'XtraSpreadsheetFunctionNameStringId.MRound': 'MROUND',
                'XtraSpreadsheetFunctionNameStringId.Multinomial': 'MULTINOMIAL',
                'XtraSpreadsheetFunctionNameStringId.MUnit': 'MUNIT',
                'XtraSpreadsheetFunctionNameStringId.N': 'N',
                'XtraSpreadsheetFunctionNameStringId.NA': 'NA',
                'XtraSpreadsheetFunctionNameStringId.NegBinomDist': 'NEGBINOMDIST',
                'XtraSpreadsheetFunctionNameStringId.NegbinomDotDist': 'NEGBINOM.DIST',
                'XtraSpreadsheetFunctionNameStringId.NetworkDays': 'NETWORKDAYS',
                'XtraSpreadsheetFunctionNameStringId.NetworkDaysIntl': 'NETWORKDAYS.INTL',
                'XtraSpreadsheetFunctionNameStringId.Nominal': 'NOMINAL',
                'XtraSpreadsheetFunctionNameStringId.NormDist': 'NORM.DIST',
                'XtraSpreadsheetFunctionNameStringId.NormDistCompatibility': 'NORMDIST',
                'XtraSpreadsheetFunctionNameStringId.NormInv': 'NORM.INV',
                'XtraSpreadsheetFunctionNameStringId.NormInvCompatibility': 'NORMINV',
                'XtraSpreadsheetFunctionNameStringId.NormSDist': 'NORM.S.DIST',
                'XtraSpreadsheetFunctionNameStringId.NormSDistCompatibility': 'NORMSDIST',
                'XtraSpreadsheetFunctionNameStringId.NormSInv': 'NORM.S.INV',
                'XtraSpreadsheetFunctionNameStringId.NormSInvCompatibility': 'NORMSINV',
                'XtraSpreadsheetFunctionNameStringId.Not': 'NOT',
                'XtraSpreadsheetFunctionNameStringId.Now': 'NOW',
                'XtraSpreadsheetFunctionNameStringId.NPer': 'NPER',
                'XtraSpreadsheetFunctionNameStringId.Npv': 'NPV',
                'XtraSpreadsheetFunctionNameStringId.NumberValue': 'NUMBERVALUE',
                'XtraSpreadsheetFunctionNameStringId.NumFileInfo': 'numfile',
                'XtraSpreadsheetFunctionNameStringId.Oct2Bin': 'OCT2BIN',
                'XtraSpreadsheetFunctionNameStringId.Oct2Dec': 'OCT2DEC',
                'XtraSpreadsheetFunctionNameStringId.Oct2Hex': 'OCT2HEX',
                'XtraSpreadsheetFunctionNameStringId.Odd': 'ODD',
                'XtraSpreadsheetFunctionNameStringId.OddFPrice': 'ODDFPRICE',
                'XtraSpreadsheetFunctionNameStringId.OddFYield': 'ODDFYIELD',
                'XtraSpreadsheetFunctionNameStringId.OddLPrice': 'ODDLPRICE',
                'XtraSpreadsheetFunctionNameStringId.OddLYield': 'ODDLYIELD',
                'XtraSpreadsheetFunctionNameStringId.Offset': 'OFFSET',
                'XtraSpreadsheetFunctionNameStringId.Or': 'OR',
                'XtraSpreadsheetFunctionNameStringId.OriginInfo': 'origin',
                'XtraSpreadsheetFunctionNameStringId.OsVersionInfo': 'osversion',
                'XtraSpreadsheetFunctionNameStringId.Parameter': 'PARAMETER',
                'XtraSpreadsheetFunctionNameStringId.ParenthesesInfo': 'parentheses',
                'XtraSpreadsheetFunctionNameStringId.PDuration': 'PDURATION',
                'XtraSpreadsheetFunctionNameStringId.Pearson': 'PEARSON',
                'XtraSpreadsheetFunctionNameStringId.Percentile': 'PERCENTILE',
                'XtraSpreadsheetFunctionNameStringId.PercentileExc': 'PERCENTILE.EXC',
                'XtraSpreadsheetFunctionNameStringId.PercentileInc': 'PERCENTILE.INC',
                'XtraSpreadsheetFunctionNameStringId.PercentRank': 'PERCENTRANK',
                'XtraSpreadsheetFunctionNameStringId.PercentRankExc': 'PERCENTRANK.EXC',
                'XtraSpreadsheetFunctionNameStringId.PercentRankInc': 'PERCENTRANK.INC',
                'XtraSpreadsheetFunctionNameStringId.Permut': 'PERMUT',
                'XtraSpreadsheetFunctionNameStringId.Permutationa': 'PERMUTATIONA',
                'XtraSpreadsheetFunctionNameStringId.Phi': 'PHI',
                'XtraSpreadsheetFunctionNameStringId.Phonetic': 'PHONETIC',
                'XtraSpreadsheetFunctionNameStringId.Pi': 'PI',
                'XtraSpreadsheetFunctionNameStringId.Pmt': 'PMT',
                'XtraSpreadsheetFunctionNameStringId.Poisson': 'POISSON',
                'XtraSpreadsheetFunctionNameStringId.PoissonDotDist': 'POISSON.DIST',
                'XtraSpreadsheetFunctionNameStringId.Power': 'POWER',
                'XtraSpreadsheetFunctionNameStringId.Ppmt': 'PPMT',
                'XtraSpreadsheetFunctionNameStringId.PrefixInfo': 'prefix',
                'XtraSpreadsheetFunctionNameStringId.Price': 'PRICE',
                'XtraSpreadsheetFunctionNameStringId.PriceDisc': 'PRICEDISC',
                'XtraSpreadsheetFunctionNameStringId.PriceMat': 'PRICEMAT',
                'XtraSpreadsheetFunctionNameStringId.Prob': 'PROB',
                'XtraSpreadsheetFunctionNameStringId.Product': 'PRODUCT',
                'XtraSpreadsheetFunctionNameStringId.Proper': 'PROPER',
                'XtraSpreadsheetFunctionNameStringId.ProtectInfo': 'protect',
                'XtraSpreadsheetFunctionNameStringId.Pv': 'PV',
                'XtraSpreadsheetFunctionNameStringId.Quartile': 'QUARTILE',
                'XtraSpreadsheetFunctionNameStringId.QuartileExc': 'QUARTILE.EXC',
                'XtraSpreadsheetFunctionNameStringId.QuartileInc': 'QUARTILE.INC',
                'XtraSpreadsheetFunctionNameStringId.Quotient': 'QUOTIENT',
                'XtraSpreadsheetFunctionNameStringId.Radians': 'RADIANS',
                'XtraSpreadsheetFunctionNameStringId.Rand': 'RAND',
                'XtraSpreadsheetFunctionNameStringId.RandBetween': 'RANDBETWEEN',
                'XtraSpreadsheetFunctionNameStringId.Range': 'RANGE',
                'XtraSpreadsheetFunctionNameStringId.Rank': 'RANK',
                'XtraSpreadsheetFunctionNameStringId.RankDotAvg': 'RANK.AVG',
                'XtraSpreadsheetFunctionNameStringId.RankDotEq': 'RANK.EQ',
                'XtraSpreadsheetFunctionNameStringId.Rate': 'RATE',
                'XtraSpreadsheetFunctionNameStringId.RecalcInfo': 'recalc',
                'XtraSpreadsheetFunctionNameStringId.Received': 'RECEIVED',
                'XtraSpreadsheetFunctionNameStringId.RegisterId': 'REGISTER.ID',
                'XtraSpreadsheetFunctionNameStringId.ReleaseInfo': 'release',
                'XtraSpreadsheetFunctionNameStringId.Replace': 'REPLACE',
                'XtraSpreadsheetFunctionNameStringId.ReplaceB': 'REPLACEB',
                'XtraSpreadsheetFunctionNameStringId.Rept': 'REPT',
                'XtraSpreadsheetFunctionNameStringId.Right': 'RIGHT',
                'XtraSpreadsheetFunctionNameStringId.RightB': 'RIGHTB',
                'XtraSpreadsheetFunctionNameStringId.Roman': 'ROMAN',
                'XtraSpreadsheetFunctionNameStringId.Round': 'ROUND',
                'XtraSpreadsheetFunctionNameStringId.RoundDown': 'ROUNDDOWN',
                'XtraSpreadsheetFunctionNameStringId.RoundUp': 'ROUNDUP',
                'XtraSpreadsheetFunctionNameStringId.Row': 'ROW',
                'XtraSpreadsheetFunctionNameStringId.RowInfo': 'row',
                'XtraSpreadsheetFunctionNameStringId.Rows': 'ROWS',
                'XtraSpreadsheetFunctionNameStringId.RRI': 'RRI',
                'XtraSpreadsheetFunctionNameStringId.Rsq': 'RSQ',
                'XtraSpreadsheetFunctionNameStringId.Rtd': 'RTD',
                'XtraSpreadsheetFunctionNameStringId.Search': 'SEARCH',
                'XtraSpreadsheetFunctionNameStringId.SearchB': 'SEARCHB',
                'XtraSpreadsheetFunctionNameStringId.Sec': 'SEC',
                'XtraSpreadsheetFunctionNameStringId.SecH': 'SECH',
                'XtraSpreadsheetFunctionNameStringId.Second': 'SECOND',
                'XtraSpreadsheetFunctionNameStringId.Seriessum': 'SERIESSUM',
                'XtraSpreadsheetFunctionNameStringId.Sheet': 'SHEET',
                'XtraSpreadsheetFunctionNameStringId.Sheets': 'SHEETS',
                'XtraSpreadsheetFunctionNameStringId.Sign': 'SIGN',
                'XtraSpreadsheetFunctionNameStringId.Sin': 'SIN',
                'XtraSpreadsheetFunctionNameStringId.SinH': 'SINH',
                'XtraSpreadsheetFunctionNameStringId.Skew': 'SKEW',
                'XtraSpreadsheetFunctionNameStringId.SkewP': 'SKEW.P',
                'XtraSpreadsheetFunctionNameStringId.Sln': 'SLN',
                'XtraSpreadsheetFunctionNameStringId.Slope': 'SLOPE',
                'XtraSpreadsheetFunctionNameStringId.Small': 'SMALL',
                'XtraSpreadsheetFunctionNameStringId.Sqrt': 'SQRT',
                'XtraSpreadsheetFunctionNameStringId.SqrtPi': 'SQRTPI',
                'XtraSpreadsheetFunctionNameStringId.Standardize': 'STANDARDIZE',
                'XtraSpreadsheetFunctionNameStringId.StDev': 'STDEV',
                'XtraSpreadsheetFunctionNameStringId.StDevA': 'STDEVA',
                'XtraSpreadsheetFunctionNameStringId.StDevDotP': 'STDEV.P',
                'XtraSpreadsheetFunctionNameStringId.StDevDotS': 'STDEV.S',
                'XtraSpreadsheetFunctionNameStringId.StDevP': 'STDEVP',
                'XtraSpreadsheetFunctionNameStringId.StDevPA': 'STDEVPA',
                'XtraSpreadsheetFunctionNameStringId.StEYX': 'STEYX',
                'XtraSpreadsheetFunctionNameStringId.Substitute': 'SUBSTITUTE',
                'XtraSpreadsheetFunctionNameStringId.Subtotal': 'SUBTOTAL',
                'XtraSpreadsheetFunctionNameStringId.Sum': 'SUM',
                'XtraSpreadsheetFunctionNameStringId.SumIf': 'SUMIF',
                'XtraSpreadsheetFunctionNameStringId.SumIfs': 'SUMIFS',
                'XtraSpreadsheetFunctionNameStringId.SumProduct': 'SUMPRODUCT',
                'XtraSpreadsheetFunctionNameStringId.SumSq': 'SUMSQ',
                'XtraSpreadsheetFunctionNameStringId.SumX2MY2': 'SUMX2MY2',
                'XtraSpreadsheetFunctionNameStringId.SumX2PY2': 'SUMX2PY2',
                'XtraSpreadsheetFunctionNameStringId.SumXMY2': 'SUMXMY2',
                'XtraSpreadsheetFunctionNameStringId.Switch': 'SWITCH',
                'XtraSpreadsheetFunctionNameStringId.Syd': 'SYD',
                'XtraSpreadsheetFunctionNameStringId.SystemInfo': 'system',
                'XtraSpreadsheetFunctionNameStringId.T': 'T',
                'XtraSpreadsheetFunctionNameStringId.Tan': 'TAN',
                'XtraSpreadsheetFunctionNameStringId.TanH': 'TANH',
                'XtraSpreadsheetFunctionNameStringId.TbillEq': 'TBILLEQ',
                'XtraSpreadsheetFunctionNameStringId.TbillPrice': 'TBILLPRICE',
                'XtraSpreadsheetFunctionNameStringId.TbillYield': 'TBILLYIELD',
                'XtraSpreadsheetFunctionNameStringId.TDist': 'TDIST',
                'XtraSpreadsheetFunctionNameStringId.TDotDist': 'T.DIST',
                'XtraSpreadsheetFunctionNameStringId.TDotDistDot2t': 'T.DIST.2T',
                'XtraSpreadsheetFunctionNameStringId.TDotDistDotTt': 'T.DIST.RT',
                'XtraSpreadsheetFunctionNameStringId.TDotInv': 'T.INV',
                'XtraSpreadsheetFunctionNameStringId.TDotInvDot2t': 'T.INV.2T',
                'XtraSpreadsheetFunctionNameStringId.TDotTest': 'T.TEST',
                'XtraSpreadsheetFunctionNameStringId.Text': 'TEXT',
                'XtraSpreadsheetFunctionNameStringId.TextJoin': 'TEXTJOIN',
                'XtraSpreadsheetFunctionNameStringId.Time': 'TIME',
                'XtraSpreadsheetFunctionNameStringId.TimeValue': 'TIMEVALUE',
                'XtraSpreadsheetFunctionNameStringId.Tinv': 'TINV',
                'XtraSpreadsheetFunctionNameStringId.Today': 'TODAY',
                'XtraSpreadsheetFunctionNameStringId.TotMemInfo': 'totmem',
                'XtraSpreadsheetFunctionNameStringId.Transpose': 'TRANSPOSE',
                'XtraSpreadsheetFunctionNameStringId.Trend': 'TREND',
                'XtraSpreadsheetFunctionNameStringId.Trim': 'TRIM',
                'XtraSpreadsheetFunctionNameStringId.Trimmean': 'TRIMMEAN',
                'XtraSpreadsheetFunctionNameStringId.True': 'TRUE',
                'XtraSpreadsheetFunctionNameStringId.Trunc': 'TRUNC',
                'XtraSpreadsheetFunctionNameStringId.TTest': 'TTEST',
                'XtraSpreadsheetFunctionNameStringId.Type': 'TYPE',
                'XtraSpreadsheetFunctionNameStringId.TypeInfo': 'type',
                'XtraSpreadsheetFunctionNameStringId.Unicode': 'UNICODE',
                'XtraSpreadsheetFunctionNameStringId.Upper': 'UPPER',
                'XtraSpreadsheetFunctionNameStringId.Value': 'VALUE',
                'XtraSpreadsheetFunctionNameStringId.Var': 'VAR',
                'XtraSpreadsheetFunctionNameStringId.VarA': 'VARA',
                'XtraSpreadsheetFunctionNameStringId.VarDotP': 'VAR.P',
                'XtraSpreadsheetFunctionNameStringId.VarDotS': 'VAR.S',
                'XtraSpreadsheetFunctionNameStringId.VarP': 'VARP',
                'XtraSpreadsheetFunctionNameStringId.VarPA': 'VARPA',
                'XtraSpreadsheetFunctionNameStringId.Vdb': 'VDB',
                'XtraSpreadsheetFunctionNameStringId.VLookup': 'VLOOKUP',
                'XtraSpreadsheetFunctionNameStringId.WeekDay': 'WEEKDAY',
                'XtraSpreadsheetFunctionNameStringId.WeekNum': 'WEEKNUM',
                'XtraSpreadsheetFunctionNameStringId.Weibull': 'WEIBULL',
                'XtraSpreadsheetFunctionNameStringId.WeibullDotDist': 'WEIBULL.DIST',
                'XtraSpreadsheetFunctionNameStringId.WidthInfo': 'width',
                'XtraSpreadsheetFunctionNameStringId.WorkDay': 'WORKDAY',
                'XtraSpreadsheetFunctionNameStringId.WorkDayIntl': 'WORKDAY.INTL',
                'XtraSpreadsheetFunctionNameStringId.Xirr': 'XIRR',
                'XtraSpreadsheetFunctionNameStringId.Xnpv': 'XNPV',
                'XtraSpreadsheetFunctionNameStringId.XOr': 'XOR',
                'XtraSpreadsheetFunctionNameStringId.Year': 'YEAR',
                'XtraSpreadsheetFunctionNameStringId.YearFrac': 'YEARFRAC',
                'XtraSpreadsheetFunctionNameStringId.Yield': 'YIELD',
                'XtraSpreadsheetFunctionNameStringId.YieldDisc': 'YIELDDISC',
                'XtraSpreadsheetFunctionNameStringId.YieldMat': 'YIELDMAT',
                'XtraSpreadsheetFunctionNameStringId.ZDotTest': 'Z.TEST',
                'XtraSpreadsheetFunctionNameStringId.ZTest': 'ZTEST',
                'XtraSpreadsheetStringId.Caption_Bytes': 'bytes',
                'XtraSpreadsheetStringId.Caption_CellStyleAccent': 'Accent',
                'XtraSpreadsheetStringId.Caption_CellStyleBad': 'Bad',
                'XtraSpreadsheetStringId.Caption_CellStyleCalculation': 'Calculation',
                'XtraSpreadsheetStringId.Caption_CellStyleCheckCell': 'Check Cell',
                'XtraSpreadsheetStringId.Caption_CellStyleComma': 'Comma',
                'XtraSpreadsheetStringId.Caption_CellStyleComma0': 'Comma [0]',
                'XtraSpreadsheetStringId.Caption_CellStyleCurrency': 'Currency',
                'XtraSpreadsheetStringId.Caption_CellStyleCurrency0': 'Currency [0]',
                'XtraSpreadsheetStringId.Caption_CellStyleEmphasis': 'Emphasis',
                'XtraSpreadsheetStringId.Caption_CellStyleExplanatoryText': 'Explanatory Text',
                'XtraSpreadsheetStringId.Caption_CellStyleFollowedHyperlink': 'Followed Hyperlink',
                'XtraSpreadsheetStringId.Caption_CellStyleGood': 'Good',
                'XtraSpreadsheetStringId.Caption_CellStyleHeading': 'Heading',
                'XtraSpreadsheetStringId.Caption_CellStyleHeading2': 'Heading',
                'XtraSpreadsheetStringId.Caption_CellStyleHyperlink': 'Hyperlink',
                'XtraSpreadsheetStringId.Caption_CellStyleInput': 'Input',
                'XtraSpreadsheetStringId.Caption_CellStyleLinkedCell': 'Linked Cell',
                'XtraSpreadsheetStringId.Caption_CellStyleNeutral': 'Neutral',
                'XtraSpreadsheetStringId.Caption_CellStyleNormal': 'Normal',
                'XtraSpreadsheetStringId.Caption_CellStyleNote': 'Note',
                'XtraSpreadsheetStringId.Caption_CellStyleOutput': 'Output',
                'XtraSpreadsheetStringId.Caption_CellStylePercent': 'Percent',
                'XtraSpreadsheetStringId.Caption_CellStyleTitle': 'Title',
                'XtraSpreadsheetStringId.Caption_CellStyleTotal': 'Total',
                'XtraSpreadsheetStringId.Caption_CellStyleWarningText': 'Warning Text',
                'XtraSpreadsheetStringId.Caption_ChangeChartHorizontalAxisTitleFormLabel': 'Horizontal Axis Title:',
                'XtraSpreadsheetStringId.Caption_ChangeChartTitleFormLabel': 'Chart Title:',
                'XtraSpreadsheetStringId.Caption_ChangeChartVerticalAxisTitleFormLabel': 'Vertical Axis Title:',
                'XtraSpreadsheetStringId.Caption_ChartStyle': 'Style',
                'XtraSpreadsheetStringId.Caption_ColorAutomatic': 'Automatic',
                'XtraSpreadsheetStringId.Caption_ConditionalFormatting_Duplicate': 'Duplicate',
                'XtraSpreadsheetStringId.Caption_ConditionalFormatting_Unique': 'Unique',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingAboveAverageRule_FormText': 'Above Average',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingAboveAverageRule_LabelHeaderText': 'Format cells that are ABOVE AVERAGE:',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingAboveAverageRule_LabelWithText': 'for the selected range with',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingBelowAverageRule_FormText': 'Below Average',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingBelowAverageRule_LabelHeaderText': 'Format cells that are BELOW AVERAGE:',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingBelowAverageRule_LabelWithText': 'for the selected range with',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingBetweenRule_FormText': 'Between',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingBetweenRule_LabelHeaderText': 'Format cells that are BETWEEN:',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingBottom10PercentRule_FormText': 'Bottom 10%',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingBottom10Rule_FormText': 'Bottom 10 Items',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingBottomRule_LabelHeaderText': 'Format cells that rank in the BOTTOM:',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingDateOccurringRule_FormText': 'A Date Occurring',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingDateOccurringRule_LabelHeaderText': 'Format cells that contain a date occurring:',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingDateOccurringRule_LabelWithText': 'with',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingDuplicateValuesRule_FormText': 'Duplicate Values',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingDuplicateValuesRule_LabelHeaderText': 'Format cells that contain:',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingDuplicateValuesRule_LabelWithText': 'values with',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingEqualToRule_FormText': 'Equal To',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingEqualToRule_LabelHeaderText': 'Format cells that are EQUAL TO:',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingGreaterThanRule_FormText': 'Greater Than',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingGreaterThanRule_LabelHeaderText': 'Format cells that are GREATER THAN:',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingLessThanRule_FormText': 'Less Than',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingLessThanRule_LabelHeaderText': 'Format cells that are LESS THAN:',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingTextContainsRule_FormText': 'Text That Contains',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingTextContainsRule_LabelHeaderText': 'Format cells that contain the text:',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingTop10PercentRule_FormText': 'Top 10%',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingTop10Rule_FormText': 'Top 10 Items',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingTopBottomPercentRule_LabelWithText': '% with',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingTopBottomRule_LabelWithText': 'with',
                'XtraSpreadsheetStringId.Caption_ConditionalFormattingTopRule_LabelHeaderText': 'Format cells that rank in the TOP:',
                'XtraSpreadsheetStringId.Caption_CreateTable': 'Create Table',
                'XtraSpreadsheetStringId.Caption_CustomPropertyCheckedBy': 'Checked by',
                'XtraSpreadsheetStringId.Caption_CustomPropertyClient': 'Client',
                'XtraSpreadsheetStringId.Caption_CustomPropertyDateCompleted': 'Date completed',
                'XtraSpreadsheetStringId.Caption_CustomPropertyDepartment': 'Department',
                'XtraSpreadsheetStringId.Caption_CustomPropertyDestination': 'Destination',
                'XtraSpreadsheetStringId.Caption_CustomPropertyDisposition': 'Disposition',
                'XtraSpreadsheetStringId.Caption_CustomPropertyDivision': 'Division',
                'XtraSpreadsheetStringId.Caption_CustomPropertyDocumentNumber': 'Document number',
                'XtraSpreadsheetStringId.Caption_CustomPropertyEditor': 'Editor',
                'XtraSpreadsheetStringId.Caption_CustomPropertyForwardTo': 'Forward to',
                'XtraSpreadsheetStringId.Caption_CustomPropertyGroup': 'Group',
                'XtraSpreadsheetStringId.Caption_CustomPropertyLanguage': 'Language',
                'XtraSpreadsheetStringId.Caption_CustomPropertyMailstop': 'Mailstop',
                'XtraSpreadsheetStringId.Caption_CustomPropertyMatter': 'Matter',
                'XtraSpreadsheetStringId.Caption_CustomPropertyNo': 'No',
                'XtraSpreadsheetStringId.Caption_CustomPropertyOffice': 'Office',
                'XtraSpreadsheetStringId.Caption_CustomPropertyOwner': 'Owner',
                'XtraSpreadsheetStringId.Caption_CustomPropertyProject': 'Project',
                'XtraSpreadsheetStringId.Caption_CustomPropertyPublisher': 'Publisher',
                'XtraSpreadsheetStringId.Caption_CustomPropertyPurpose': 'Purpose',
                'XtraSpreadsheetStringId.Caption_CustomPropertyReceivedFrom': 'Received from',
                'XtraSpreadsheetStringId.Caption_CustomPropertyRecordedBy': 'Recorded by',
                'XtraSpreadsheetStringId.Caption_CustomPropertyRecordedDate': 'Recorded date',
                'XtraSpreadsheetStringId.Caption_CustomPropertyReference': 'Reference',
                'XtraSpreadsheetStringId.Caption_CustomPropertySource': 'Source',
                'XtraSpreadsheetStringId.Caption_CustomPropertyStatus': 'Status',
                'XtraSpreadsheetStringId.Caption_CustomPropertyTelephoneNumber': 'Telephone number',
                'XtraSpreadsheetStringId.Caption_CustomPropertyTypeBoolean': 'Yes or no',
                'XtraSpreadsheetStringId.Caption_CustomPropertyTypeDateTime': 'Date',
                'XtraSpreadsheetStringId.Caption_CustomPropertyTypeNumber': 'Number',
                'XtraSpreadsheetStringId.Caption_CustomPropertyTypeText': 'Text',
                'XtraSpreadsheetStringId.Caption_CustomPropertyTypist': 'Typist',
                'XtraSpreadsheetStringId.Caption_CustomPropertyYes': 'Yes',
                'XtraSpreadsheetStringId.Caption_CustomTableStyleCategory': 'Custom',
                'XtraSpreadsheetStringId.Caption_DarkTableStyleCategory': 'Dark',
                'XtraSpreadsheetStringId.Caption_DarkTableStyleNamePart': 'Dark',
                'XtraSpreadsheetStringId.Caption_DataValidationAnyValue': 'Any value',
                'XtraSpreadsheetStringId.Caption_DataValidationBetween': 'between',
                'XtraSpreadsheetStringId.Caption_DataValidationCustom': 'Custom',
                'XtraSpreadsheetStringId.Caption_DataValidationDate': 'Date',
                'XtraSpreadsheetStringId.Caption_DataValidationDecimal': 'Decimal',
                'XtraSpreadsheetStringId.Caption_DataValidationEndDate': 'End date',
                'XtraSpreadsheetStringId.Caption_DataValidationEndTime': 'End time',
                'XtraSpreadsheetStringId.Caption_DataValidationEqual': 'equal to',
                'XtraSpreadsheetStringId.Caption_DataValidationFormula': 'Formula',
                'XtraSpreadsheetStringId.Caption_DataValidationGreaterThan': 'greater than',
                'XtraSpreadsheetStringId.Caption_DataValidationGreaterThanOrEqual': 'greater than or equal to',
                'XtraSpreadsheetStringId.Caption_DataValidationInformation': 'Information',
                'XtraSpreadsheetStringId.Caption_DataValidationLength': 'Length',
                'XtraSpreadsheetStringId.Caption_DataValidationLessThan': 'less than',
                'XtraSpreadsheetStringId.Caption_DataValidationLessThanOrEqual': 'less than or equal to',
                'XtraSpreadsheetStringId.Caption_DataValidationList': 'List',
                'XtraSpreadsheetStringId.Caption_DataValidationMaximum': 'Maximum',
                'XtraSpreadsheetStringId.Caption_DataValidationMinimum': 'Minimum',
                'XtraSpreadsheetStringId.Caption_DataValidationNotBetween': 'not between',
                'XtraSpreadsheetStringId.Caption_DataValidationNotEqual': 'not equal to',
                'XtraSpreadsheetStringId.Caption_DataValidationSource': 'Source',
                'XtraSpreadsheetStringId.Caption_DataValidationStartDate': 'Start date',
                'XtraSpreadsheetStringId.Caption_DataValidationStartTime': 'Start time',
                'XtraSpreadsheetStringId.Caption_DataValidationStop': 'Stop',
                'XtraSpreadsheetStringId.Caption_DataValidationTextLength': 'Text length',
                'XtraSpreadsheetStringId.Caption_DataValidationTime': 'Time',
                'XtraSpreadsheetStringId.Caption_DataValidationValue': 'Value',
                'XtraSpreadsheetStringId.Caption_DataValidationWarning': 'Warning',
                'XtraSpreadsheetStringId.Caption_DataValidationWholeNumber': 'Whole number',
                'XtraSpreadsheetStringId.Caption_EditDefinedNameFormTitle': 'Edit Name',
                'XtraSpreadsheetStringId.Caption_EditProtectedRangeFormTitle': 'Modify Range',
                'XtraSpreadsheetStringId.Caption_FormatNumberCustom': 'Custom',
                'XtraSpreadsheetStringId.Caption_FormatNumberDate': 'Date',
                'XtraSpreadsheetStringId.Caption_FormatPictureAutomatic': 'Automatic',
                'XtraSpreadsheetStringId.Caption_FormatPictureBlackAndWhite': 'Black  White',
                'XtraSpreadsheetStringId.Caption_FormatPictureGrayscale': 'Grayscale',
                'XtraSpreadsheetStringId.Caption_FormatPictureWashout': 'Washout',
                'XtraSpreadsheetStringId.Caption_FunctionArgumentAny': 'any',
                'XtraSpreadsheetStringId.Caption_FunctionArgumentArray': 'array',
                'XtraSpreadsheetStringId.Caption_FunctionArgumentLogical': 'logical',
                'XtraSpreadsheetStringId.Caption_FunctionArgumentNumber': 'number',
                'XtraSpreadsheetStringId.Caption_FunctionArgumentReference': 'reference',
                'XtraSpreadsheetStringId.Caption_FunctionArgumentText': 'text',
                'XtraSpreadsheetStringId.Caption_FunctionTakesNoArguments': 'This function takes no arguments.',
                'XtraSpreadsheetStringId.Caption_FunctionUndefined': 'Undefined',
                'XtraSpreadsheetStringId.Caption_GenericFilterOperatorAfter': 'is after',
                'XtraSpreadsheetStringId.Caption_GenericFilterOperatorAfterOrEqual': 'is after or equal to',
                'XtraSpreadsheetStringId.Caption_GenericFilterOperatorBefore': 'is before',
                'XtraSpreadsheetStringId.Caption_GenericFilterOperatorBeforeOrEqual': 'is before or equal to',
                'XtraSpreadsheetStringId.Caption_GenericFilterOperatorBeginsWith': 'begins with',
                'XtraSpreadsheetStringId.Caption_GenericFilterOperatorBetween': 'is between',
                'XtraSpreadsheetStringId.Caption_GenericFilterOperatorContains': 'contains',
                'XtraSpreadsheetStringId.Caption_GenericFilterOperatorDoesNotBeginWith': 'does not begin with',
                'XtraSpreadsheetStringId.Caption_GenericFilterOperatorDoesNotContain': 'does not contain',
                'XtraSpreadsheetStringId.Caption_GenericFilterOperatorDoesNotEndWith': 'does not end with',
                'XtraSpreadsheetStringId.Caption_GenericFilterOperatorDoesNotEqual': 'does not equal',
                'XtraSpreadsheetStringId.Caption_GenericFilterOperatorEndsWith': 'ends with',
                'XtraSpreadsheetStringId.Caption_GenericFilterOperatorEquals': 'equals',
                'XtraSpreadsheetStringId.Caption_GenericFilterOperatorGreater': 'is greater than',
                'XtraSpreadsheetStringId.Caption_GenericFilterOperatorGreaterOrEqual': 'is greater than or equal to',
                'XtraSpreadsheetStringId.Caption_GenericFilterOperatorLess': 'is less than',
                'XtraSpreadsheetStringId.Caption_GenericFilterOperatorLessOrEqual': 'is less than or equal to',
                'XtraSpreadsheetStringId.Caption_GenericFilterOperatorNone': ' ',
                'XtraSpreadsheetStringId.Caption_GenericFilterOperatorNotBetween': 'is not between',
                'XtraSpreadsheetStringId.Caption_GroupAlignment': 'Alignment',
                'XtraSpreadsheetStringId.Caption_GroupArrange': 'Arrange',
                'XtraSpreadsheetStringId.Caption_GroupCells': 'Cells',
                'XtraSpreadsheetStringId.Caption_GroupChanges': 'Changes',
                'XtraSpreadsheetStringId.Caption_GroupCharts': 'Charts',
                'XtraSpreadsheetStringId.Caption_GroupChartsDesignData': 'Data',
                'XtraSpreadsheetStringId.Caption_GroupChartsDesignLayouts': 'Chart Layouts',
                'XtraSpreadsheetStringId.Caption_GroupChartsDesignLocation': 'Location',
                'XtraSpreadsheetStringId.Caption_GroupChartsDesignStyles': 'Chart Styles',
                'XtraSpreadsheetStringId.Caption_GroupChartsDesignType': 'Type',
                'XtraSpreadsheetStringId.Caption_GroupChartsLayoutAnalysis': 'Analysis',
                'XtraSpreadsheetStringId.Caption_GroupChartsLayoutAxes': 'Axes',
                'XtraSpreadsheetStringId.Caption_GroupChartsLayoutLabels': 'Labels',
                'XtraSpreadsheetStringId.Caption_GroupClipboard': 'Clipboard',
                'XtraSpreadsheetStringId.Caption_GroupComments': 'Comments',
                'XtraSpreadsheetStringId.Caption_GroupCommon': 'Common',
                'XtraSpreadsheetStringId.Caption_GroupDataTools': 'Data Tools',
                'XtraSpreadsheetStringId.Caption_GroupEditing': 'Editing',
                'XtraSpreadsheetStringId.Caption_GroupFont': 'Font',
                'XtraSpreadsheetStringId.Caption_GroupFormulaAuditing': 'Formula Auditing',
                'XtraSpreadsheetStringId.Caption_GroupFormulaCalculation': 'Calculation',
                'XtraSpreadsheetStringId.Caption_GroupFormulaDefinedNames': 'Defined Names',
                'XtraSpreadsheetStringId.Caption_GroupFunctionLibrary': 'Function Library',
                'XtraSpreadsheetStringId.Caption_GroupIllustrations': 'Illustrations',
                'XtraSpreadsheetStringId.Caption_GroupInfo': 'Info',
                'XtraSpreadsheetStringId.Caption_GroupLinks': 'Links',
                'XtraSpreadsheetStringId.Caption_GroupMailMergeBinding': 'Design',
                'XtraSpreadsheetStringId.Caption_GroupMailMergeData': 'External Data Sources',
                'XtraSpreadsheetStringId.Caption_GroupMailMergeExtended': 'Template Ranges',
                'XtraSpreadsheetStringId.Caption_GroupMailMergeFiltering': 'Filter',
                'XtraSpreadsheetStringId.Caption_GroupMailMergeGrouping': 'Sort  Group',
                'XtraSpreadsheetStringId.Caption_GroupMailMergeMode': 'Mode',
                'XtraSpreadsheetStringId.Caption_GroupNumber': 'Number',
                'XtraSpreadsheetStringId.Caption_GroupOutline': 'Outline',
                'XtraSpreadsheetStringId.Caption_GroupPageSetup': 'Page Setup',
                'XtraSpreadsheetStringId.Caption_GroupPrint': 'Print',
                'XtraSpreadsheetStringId.Caption_GroupShow': 'Show',
                'XtraSpreadsheetStringId.Caption_GroupSortAndFilter': 'Sort  Filter',
                'XtraSpreadsheetStringId.Caption_GroupStatusBar': 'Status',
                'XtraSpreadsheetStringId.Caption_GroupStyles': 'Styles',
                'XtraSpreadsheetStringId.Caption_GroupSymbols': 'Symbols',
                'XtraSpreadsheetStringId.Caption_GroupTableProperties': 'Properties',
                'XtraSpreadsheetStringId.Caption_GroupTables': 'Tables',
                'XtraSpreadsheetStringId.Caption_GroupTableStyleOptions': 'Table Style Options',
                'XtraSpreadsheetStringId.Caption_GroupTableStyles': 'Table Styles',
                'XtraSpreadsheetStringId.Caption_GroupTableTools': 'Tools',
                'XtraSpreadsheetStringId.Caption_GroupWindow': 'Window',
                'XtraSpreadsheetStringId.Caption_GroupZoom': 'Zoom',
                'XtraSpreadsheetStringId.Caption_InvalidExpression': 'Invalid',
                'XtraSpreadsheetStringId.Caption_LightTableStyleCategory': 'Light',
                'XtraSpreadsheetStringId.Caption_LightTableStyleNamePart': 'Light',
                'XtraSpreadsheetStringId.Caption_MailMergeFilterExpressionEditor': 'Filter Expression',
                'XtraSpreadsheetStringId.Caption_MediumTableStyleCategory': 'Medium',
                'XtraSpreadsheetStringId.Caption_MediumTableStyleNamePart': 'Medium',
                'XtraSpreadsheetStringId.Caption_NewDefinedNameFormTitle': 'New Name',
                'XtraSpreadsheetStringId.Caption_NewProtectedRangeFormTitle': 'New Range',
                'XtraSpreadsheetStringId.Caption_NoColor': 'No Color',
                'XtraSpreadsheetStringId.Caption_NoFill': 'No Fill',
                'XtraSpreadsheetStringId.Caption_PageCategoryChartTools': 'Chart Tools',
                'XtraSpreadsheetStringId.Caption_PageCategoryDefault': 'Default',
                'XtraSpreadsheetStringId.Caption_PageCategoryDrawingTools': 'Drawing Tools',
                'XtraSpreadsheetStringId.Caption_PageCategoryPictureTools': 'Picture Tools',
                'XtraSpreadsheetStringId.Caption_PageCategoryPivotTableTools': 'PivotTable Tools',
                'XtraSpreadsheetStringId.Caption_PageCategoryTableTools': 'Table Tools',
                'XtraSpreadsheetStringId.Caption_PageChartsDesign': 'Design',
                'XtraSpreadsheetStringId.Caption_PageChartsLayout': 'Layout',
                'XtraSpreadsheetStringId.Caption_PageData': 'Data',
                'XtraSpreadsheetStringId.Caption_PageFile': 'File',
                'XtraSpreadsheetStringId.Caption_PageFormat': 'Format',
                'XtraSpreadsheetStringId.Caption_PageFormulas': 'Formulas',
                'XtraSpreadsheetStringId.Caption_PageHome': 'Home',
                'XtraSpreadsheetStringId.Caption_PageInsert': 'Insert',
                'XtraSpreadsheetStringId.Caption_PageMailMerge': 'Mail Merge',
                'XtraSpreadsheetStringId.Caption_PagePageLayout': 'Page Layout',
                'XtraSpreadsheetStringId.Caption_PageReview': 'Review',
                'XtraSpreadsheetStringId.Caption_PageView': 'View',
                'XtraSpreadsheetStringId.Caption_PasteSpecial_All': 'All',
                'XtraSpreadsheetStringId.Caption_PasteSpecial_AllExceptBorders': 'All except borders',
                'XtraSpreadsheetStringId.Caption_PasteSpecial_ColumnWidths': 'Column widths',
                'XtraSpreadsheetStringId.Caption_PasteSpecial_Comments': 'Comments',
                'XtraSpreadsheetStringId.Caption_PasteSpecial_Formats': 'Formats',
                'XtraSpreadsheetStringId.Caption_PasteSpecial_Formulas': 'Formulas',
                'XtraSpreadsheetStringId.Caption_PasteSpecial_FormulasAndNumberFormats': 'Formulas and number formats',
                'XtraSpreadsheetStringId.Caption_PasteSpecial_Values': 'Values',
                'XtraSpreadsheetStringId.Caption_PasteSpecial_ValuesAndNumberFormats': 'Values and number formats',
                'XtraSpreadsheetStringId.Caption_PatternType_12Gray': '12.5% Gray',
                'XtraSpreadsheetStringId.Caption_PatternType_25Gray': '25% Gray',
                'XtraSpreadsheetStringId.Caption_PatternType_50Gray': '50% Gray',
                'XtraSpreadsheetStringId.Caption_PatternType_6Gray': '6.25% Gray',
                'XtraSpreadsheetStringId.Caption_PatternType_75Gray': '75% Gray',
                'XtraSpreadsheetStringId.Caption_PatternType_DiagonalCrosshatch': 'Diagonal Crosshatch',
                'XtraSpreadsheetStringId.Caption_PatternType_DiagonalStripe': 'Diagonal Stripe',
                'XtraSpreadsheetStringId.Caption_PatternType_HorizontalStripe': 'Horizontal Stripe',
                'XtraSpreadsheetStringId.Caption_PatternType_ReverseDiagonalStripe': 'Reverse Diagonal Stripe',
                'XtraSpreadsheetStringId.Caption_PatternType_Solid': 'Solid',
                'XtraSpreadsheetStringId.Caption_PatternType_ThickDiagonalCrosshatch': 'Thick Diagonal Crosshatch',
                'XtraSpreadsheetStringId.Caption_PatternType_ThinDiagonalCrosshatch': 'Thin Diagonal Crosshatch',
                'XtraSpreadsheetStringId.Caption_PatternType_ThinDiagonalStripe': 'Thin Diagonal Stripe',
                'XtraSpreadsheetStringId.Caption_PatternType_ThinHorizontalCrosshatch': 'Thin Horizontal Crosshatch',
                'XtraSpreadsheetStringId.Caption_PatternType_ThinHorizontalStripe': 'Thin Horizontal Stripe',
                'XtraSpreadsheetStringId.Caption_PatternType_ThinReserseDiagonalStripe': 'Thin Reserse Diagonal Stripe',
                'XtraSpreadsheetStringId.Caption_PatternType_ThinVerticalStripe': 'Thin Vertical Stripe',
                'XtraSpreadsheetStringId.Caption_PatternType_VerticalStripe': 'Vertical Stripe',
                'XtraSpreadsheetStringId.Caption_PermissionAutoFilter': 'Use AutoFilter',
                'XtraSpreadsheetStringId.Caption_PermissionDeleteColumns': 'Delete columns',
                'XtraSpreadsheetStringId.Caption_PermissionDeleteRows': 'Delete rows',
                'XtraSpreadsheetStringId.Caption_PermissionEditObjects': 'Edit objects',
                'XtraSpreadsheetStringId.Caption_PermissionEditRangeWithoutPassword': 'Edit range without a password',
                'XtraSpreadsheetStringId.Caption_PermissionEditScenarios': 'Edit scenarios',
                'XtraSpreadsheetStringId.Caption_PermissionFormatCells': 'Format cells',
                'XtraSpreadsheetStringId.Caption_PermissionFormatColumns': 'Format columns',
                'XtraSpreadsheetStringId.Caption_PermissionFormatRows': 'Format rows',
                'XtraSpreadsheetStringId.Caption_PermissionInsertColumns': 'Insert columns',
                'XtraSpreadsheetStringId.Caption_PermissionInsertHyperlinks': 'Insert hyperlinks',
                'XtraSpreadsheetStringId.Caption_PermissionInsertRows': 'Insert rows',
                'XtraSpreadsheetStringId.Caption_PermissionPivotTable': 'Use PivotTable reports',
                'XtraSpreadsheetStringId.Caption_PermissionSelectLockedCells': 'Select locked cells',
                'XtraSpreadsheetStringId.Caption_PermissionSelectUnlockedCells': 'Select unlocked cells',
                'XtraSpreadsheetStringId.Caption_PermissionSort': 'Sort',
                'XtraSpreadsheetStringId.Caption_PivotDefaultColumnHeader': 'Column Labels',
                'XtraSpreadsheetStringId.Caption_PivotDefaultDataCaption': 'Values',
                'XtraSpreadsheetStringId.Caption_PivotDefaultRowHeader': 'Row Labels',
                'XtraSpreadsheetStringId.Caption_PivotEmptyValue': '(blank)',
                'XtraSpreadsheetStringId.Caption_PivotFalseValue': 'FALSE',
                'XtraSpreadsheetStringId.Caption_PivotGrandTotal': 'Grand Total',
                'XtraSpreadsheetStringId.Caption_PivotOrValue': 'or',
                'XtraSpreadsheetStringId.Caption_PivotTableAnalyze': 'Analyze',
                'XtraSpreadsheetStringId.Caption_PivotTableAnalyzeActions': 'Actions',
                'XtraSpreadsheetStringId.Caption_PivotTableAnalyzeActiveField': 'Active Field',
                'XtraSpreadsheetStringId.Caption_PivotTableAnalyzeCalculations': 'Calculations',
                'XtraSpreadsheetStringId.Caption_PivotTableAnalyzeData': 'Data',
                'XtraSpreadsheetStringId.Caption_PivotTableAnalyzeGroup': 'Group',
                'XtraSpreadsheetStringId.Caption_PivotTableAnalyzePivotTable': 'PivotTable',
                'XtraSpreadsheetStringId.Caption_PivotTableAnalyzeShow': 'Show',
                'XtraSpreadsheetStringId.Caption_PivotTableDesign': 'Design',
                'XtraSpreadsheetStringId.Caption_PivotTableDesignLayout': 'Layout',
                'XtraSpreadsheetStringId.Caption_PivotTableDesignPivotTableStyleOptions': 'PivotTable Style Options',
                'XtraSpreadsheetStringId.Caption_PivotTableDesignPivotTableStyles': 'PivotTable Styles',
                'XtraSpreadsheetStringId.Caption_PivotTrueValue': 'TRUE',
                'XtraSpreadsheetStringId.Caption_PrefixPivotStyleNamePart': 'Pivot Style',
                'XtraSpreadsheetStringId.Caption_PrefixTableStyleNamePart': 'Table Style',
                'XtraSpreadsheetStringId.Caption_SearchByColumns': 'By Columns',
                'XtraSpreadsheetStringId.Caption_SearchByRows': 'By Rows',
                'XtraSpreadsheetStringId.Caption_SearchInComments': 'Comments',
                'XtraSpreadsheetStringId.Caption_SearchInFormulas': 'Formulas',
                'XtraSpreadsheetStringId.Caption_SearchInValues': 'Values',
                'XtraSpreadsheetStringId.Caption_ShowValuesAsCalculation': 'Calculation:',
                'XtraSpreadsheetStringId.Caption_StyleGalleryGroupCustom': 'Custom',
                'XtraSpreadsheetStringId.Caption_StyleGalleryGroupDataAndModel': 'Data and Model',
                'XtraSpreadsheetStringId.Caption_StyleGalleryGroupGoogBadAndNeutral': 'Good, Bad and Neutral',
                'XtraSpreadsheetStringId.Caption_StyleGalleryGroupNumberFormat': 'Number Format',
                'XtraSpreadsheetStringId.Caption_StyleGalleryGroupThemedCellStyles': 'Themed Cell Styles',
                'XtraSpreadsheetStringId.Caption_StyleGalleryGroupTitlesAndHeadings': 'Titles and Headings',
                'XtraSpreadsheetStringId.Caption_Subtotal_ColumnHeader': '(Column {0})',
                'XtraSpreadsheetStringId.Caption_Subtotal_Grand': 'Grand {0}',
                'XtraSpreadsheetStringId.Caption_Subtotal_SumName': 'Total',
                'XtraSpreadsheetStringId.Caption_TableStyleNameIsNone': 'None',
                'XtraSpreadsheetStringId.Caption_TableToolsDesignPage': 'Design',
                'XtraSpreadsheetStringId.Caption_TimePeriod_Last7Days': 'In the last 7 days',
                'XtraSpreadsheetStringId.Caption_TimePeriod_LastMonth': 'Last month',
                'XtraSpreadsheetStringId.Caption_TimePeriod_LastWeek': 'Last week',
                'XtraSpreadsheetStringId.Caption_TimePeriod_NextMonth': 'Next month',
                'XtraSpreadsheetStringId.Caption_TimePeriod_NextWeek': 'Next week',
                'XtraSpreadsheetStringId.Caption_TimePeriod_ThisMonth': 'This month',
                'XtraSpreadsheetStringId.Caption_TimePeriod_ThisWeek': 'This week',
                'XtraSpreadsheetStringId.Caption_TimePeriod_Today': 'Today',
                'XtraSpreadsheetStringId.Caption_TimePeriod_Tomorrow': 'Tomorrow',
                'XtraSpreadsheetStringId.Caption_TimePeriod_Yesterday': 'Yesterday',
                'XtraSpreadsheetStringId.Caption_Top10FilterOrderBottom': 'Bottom',
                'XtraSpreadsheetStringId.Caption_Top10FilterOrderTop': 'Top',
                'XtraSpreadsheetStringId.Caption_Top10FilterTypeItems': 'Items',
                'XtraSpreadsheetStringId.Caption_Top10FilterTypePercent': 'Percent',
                'XtraSpreadsheetStringId.Caption_Top10FilterTypeSum': 'Sum',
                'XtraSpreadsheetStringId.CaptionAllFunctionsGroup': 'All',
                'XtraSpreadsheetStringId.CaptionDatabaseFunctionsGroup': 'Database',
                'XtraSpreadsheetStringId.CaptionUserDefinedFunctionsGroup': 'User Defined',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_BlackCircle': 'Black Circle',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_CircleWithOneWhiteQuarter': 'Circle With One White Quarter',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_CircleWithThreeWhiteQuarters': 'Circle With Three White Quarters',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_CircleWithTwoWhiteQuarters': 'Circle With Two White Quarters',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_FourFilledBoxes': 'Four Filled Boxes',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GoldStar': 'Gold Star',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GrayCircle': 'Gray Circle',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GrayDownArrow': 'Gray Down Arrow',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GrayDownInclineArrow': 'Gray Down Incline Arrow',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GraySideArrow': 'Gray Side Arrow',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GrayUpArrow': 'Gray Up Arrow',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GrayUpInclineArrow': 'Gray Up Incline Arrow',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GreenCheck': 'Green Check',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GreenCheckSymbol': 'Green Check Symbol',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GreenCircle': 'Green Circle',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GreenFlag': 'Green Flag',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GreenTrafficLight': 'Green Traffic Light',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GreenUpArrow': 'Green Up Arrow',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_GreenUpTriangle': 'Green Up Triangle',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_HalfGoldStar': 'Half Gold Star',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_NoIcon': 'No Cell Icon',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_OneFilledBox': 'One Filled Box',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_PinkCircle': 'Pink Circle',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_RedCircle': 'Red Circle',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_RedCircleWithBorder': 'Red Circle With Border',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_RedCross': 'Red Cross',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_RedCrossSymbol': 'Red Cross Symbol',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_RedDiamond': 'Red Diamond',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_RedDownArrow': 'Red Down Arrow',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_RedDownTriangle': 'Red Down Triangle',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_RedFlag': 'Red Flag',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_RedTrafficLight': 'Red Traffic Light',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_SignalMeterWithFourFilledBars': 'Signal Meter With Four Filled Bars',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_SignalMeterWithNoFilledBars': 'Signal Meter With No Filled Bars',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_SignalMeterWithOneFilledBar': 'Signal Meter With One Filled Bar',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_SignalMeterWithThreeFilledBars': 'Signal Meter With Three Filled Bars',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_SignalMeterWithTwoFilledBars': 'Signal Meter With Two Filled Bars',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_SilverStar': 'Silver Star',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_ThreeFilledBoxes': 'Three Filled Boxes',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_TwoFilledBoxes': 'Two Filled Boxes',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_WhiteCircle': 'White Circle',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_YellowCircle': 'Yellow Circle',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_YellowDash': 'Yellow Dash',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_YellowDownInclineArrow': 'Yellow Down Incline Arrow',
                'XtraSpreadsheetStringId.ConditionalFormattingIconSetToolTips_YellowExclamation': 'Yellow Exclamation',
                'XtraSpreadsheetStringId.ConditionalFormatting