////////////////////////////////////////////////////////////////////////////////
// WaitBox class
KS.WaitBox = {
    // если 0, то автосокрытие тумана не используется
    waitAutoHideDelay: 0,

    waitVisibleCount: 0,
    waitHideTimer: null,
    waitHideTimerAdded: false,
    overlapQueue: [],

    showWaitBox: function(/*msg, c*/) {
    },

    hideWaitBox: function() {
    },

    pleaseWait: function(msg, c) {
        var me = this;

        if (!KS.isValid(msg)) msg = KS.L10n.waitMessage;

        // затуманиваем родительское окно если оно есть
        if (KS.isValid(me.masterView)) {
            var p = KS.getView(me.masterView);
            p.pleaseWait.apply(p, [msg, c]);
            return;
        }

        var cnt = ++me.waitVisibleCount;

        TRACE('View ' + me.viewID + ' requests ' + (!!c ? '' : 'not ') + 'cancellable waiting panel, now count ' + cnt + ', message: ' + msg, 'wait');

        me.overlapQueue[cnt] = { msg: msg, handler: c };
        KS.waitQueue[me.viewID] = me;

        if (me.viewID == 'M') {
            // скрываем все второстепенные, т.к. перекрываются глобальным туманом
            for (viewID in KS.waitQueue) {
                if (viewID != 'M') {
                    var v = KS.waitQueue[viewID];
                    if (v.waitVisibleCount <= 0)
                        delete KS.waitQueue[viewID];
                    else
                        v.hideWaitBox();
                }
            }
        }

        me.showWaitBox(msg, c);
        me._startHideTimer();
    },

    stopWaiting: function() {
        var me = this;

        if (KS.isValid(me.masterView)) {
            var p = KS.getView(me.masterView);
            p.stopWaiting.apply(p);
            return;
        }

        var cnt = --me.waitVisibleCount;

        TRACE('View ' + me.viewID + ' requests close waiting panel, now count ' + cnt, 'wait');

        var fog;
        if (cnt <= 0) {
            delete KS.waitQueue[me.viewID];
            me.forceStopWaiting();
            // раскрываем перекрытые туманы, если глобальный рассеялся
            if (me.viewID == 'M') {
                for (viewID in KS.waitQueue) {
                    var v = KS.waitQueue[viewID];
                    cnt = v.waitVisibleCount;
                    if (cnt > 0) {
                        fog = v.overlapQueue[cnt];
                        v.showWaitBox(fog.msg, fog.handler);
                    } else
                        delete KS.waitQueue[viewID];
                }
            }
        } else {
            fog = me.overlapQueue[cnt];
            me.showWaitBox(fog.msg, fog.handler);
        }
    },

    forceStopWaiting: function() {
        var me = this;
        me.waitVisibleCount = 0;
        if (me.waitHideTimer != null) clearTimeout(me.waitHideTimer);
        me.waitHideTimer = null;
        me.overlapQueue = [];
        me.hideWaitBox();
    },

    continueWaiting: function() {
        if (this.waitVisibleCount > 0) this._startHideTimer();
    },

    _startHideTimer: function() {
        var me = this;
        if (me.waitHideTimer != null) {
            clearTimeout(me.waitHideTimer);
            me.waitHideTimer = null;
        }
        if (me.waitAutoHideDelay > 0)
            me.waitHideTimer = setTimeout(function() { me.stopWaiting.apply(me); }, me.waitAutoHideDelay);
    }
};

KS.waitQueue = {};
KS.apply(KS, KS.WaitBox);