///////////////////////////////////////////////////////////////////////////
// сбор статистики по сетевым событиям
KS.Stat = {};
KS.apply(KS.Stat, {
    trackCodes: [[301, 1], [400, 1], [401, 1], [402, 1], [403, 1], [404, 1], [405, 1], [406, 1], [407, 1], [408, 1], [500, 1], [502, 1], [503, 1], [504, 1], ['OFF', 0], ['EMP', 1], ['EXC', 0], ['REP', 1], ['TOT', 0]],
    qualityWeight: [1.0, 0.1, 0.06, 0.04, -0.0001],
    currentQuality: 4,
    currentQualityValue: 0,

    // увеличивает счетчик для указанного события
    fireEvent: function(eventName) {
        var desc = KS.Stat.getDesc(eventName);
        if (desc == null)
            return;

        var errors = 0, total = 0;

        if (typeof (eventName) !== 'string') eventName = String(eventName);
        var stat = KS.getCookie('Stat', '');
        var chunks = stat.split('.');
        var res = [];
        var found = false;
        for (var n = 0; n < chunks.length; n++) {
            var v = chunks[n];
            var s = v.split('-');

            desc = KS.Stat.getDesc(s[0]);
            if (desc == null || s.length != 2) continue;

            var c = Number(s[1]);
            if (s[0] == eventName) {
                s[1] = ++c;
                found = true;
            }

            // ограничиваем по количеству запросов
            if (s[0] == 'TOT') {
                total = c;
                if (c > 1000) {
                    KS.deleteCookie('Stat');
                    return;
                }
            } else if (desc[1] == 1)
                errors += c;

            res.push(s.join('-'));
        }
        if (!found) res.push(eventName + '-1');
        KS.setCookie('Stat', res.join('.'));

        // вычисляем относительный показатель качества связи
        if (total > 0) {
            var q = (1.0 * errors) / (1.0 * total);
            KS.Stat.currentQualityValue = q;
            for (var i = 0; i < 5; i++) {
                if (q >= KS.Stat.qualityWeight[i]) {
                    KS.Ajax.showOnlineStatus((KS.Stat.currentQuality = i + 1));
                    break;
                }
            }
        }
    },

    getDesc: function(status) {
        for (var k = 0; k < KS.Stat.trackCodes.length; k++) {
            var d = KS.Stat.trackCodes[k];
            if (d[0] == String(status)) return d;
        }
        return null;
    }
});