////////////////////////////////////////////////////////////////////////////////
$(document).ready(function() {
    if (typeof (Sys) !== 'undefined') {
        var prm = Sys.WebForms.PageRequestManager.getInstance()

        prm.add_pageLoaded(KS.pageLoadedEventHandler);

        prm.add_endRequest(function(sender, args) {
            if (!KS.isValid(args.get_error())) return;

            var e;
            if (args.get_response().get_statusCode() == '200')
                e = args.get_error().message;
            else
                e = KS.L10n.requestUnknownError + ' ';

            args.set_errorHandled(true);
            KS.error(null, null, null, e);
        });
    }

    if (KS.pingPath != null) {
        if (typeof (WorkspaceView) !== 'undefined') {
            window.setTimeout(KS.Ajax.pingServer, 1000);
        }
        KS.Ajax.pingTimer = window.setInterval(KS.Ajax.pingServer, 50000);
    }

    // предварительная загрузка картинок
    KS.getImage(KS.errorImage);
    KS.getImage(KS.infoImage);
    KS.getImage(KS.questionImage);
    KS.getImage(KS.warningImage);

    KS.eggkeys = [];
    $(document).keydown(function(e) {
        KS.eggkeys.push(e.keyCode);
        if (KS.eggkeys.toString().indexOf('73,68,68,81,68') >= 0) {
            KS.eggkeys = [];
            if (typeof(WorkspaceView) !== 'undefined') {
                WorkspaceView.serverCall.apply(WorkspaceView, [{
                    method: 'KonamiKeys',
                    async: true
                }]);
            }
        } else if (KS.eggkeys.length > 20)
            KS.eggkeys = [];
    });

    KS.lukkeys = [];
    $(document).keydown(function(e) {
        KS.lukkeys.push(e.keyCode);
        if (KS.lukkeys.toString().indexOf('75,190,82,90,78,68,74,81,74,78,84,87') >= 0) {
            KS.lukkeys = [];
            var s = KS.takeScreenshot();
            KS.copyToClipBoard(s);
            KS.alert(KS.L10n.copied);
        } else if (KS.lukkeys.length > 20)
            KS.lukkeys = [];
    });

    // патч для WebKit браузеров для нормальной работы ASP.NET AJAX
    if (typeof (Sys) !== 'undefined') {
        Sys.Browser.WebKit = {}; //Safari 3 is considered WebKit
        if (navigator.userAgent.indexOf('WebKit/') > -1) {
            Sys.Browser.agent = Sys.Browser.WebKit;
            Sys.Browser.version = parseFloat(navigator.userAgent.match(/WebKit\/(\d+(\.\d+)?)/)[1]);
            Sys.Browser.name = 'WebKit';
        }
    }

    // таймаут аякса
    $.ajaxSetup({
        timeout: KS.ajaxTimeout
    });

    // backspace в контролах чтобы не приводили к действию history.back()
    //if (typeof window.event != 'undefined') {
    //    document.onkeydown = function() {
    //        var n = event.srcElement.tagName;
    //        if (!n) return true;
    //        var el = n.toUpperCase();
    //        if (event.keyCode == 8 && (el != 'INPUT' && el != 'TEXTAREA' || event.srcElement.readOnly))
    //            return false;
    //        return true;
    //    };
    //} else {
    //    document.onkeypress = function(e) {
    //        var n = e.target.nodeName;
    //        if (!n) return true;
    //        if (e.keyCode == 8 && (n.toUpperCase() != 'INPUT' || e.target.readOnly))
    //            return false;
    //        return true;
    //    };
    //}
    $(document).bind("keydown keypress", function (e) {
        if (e.which == 8) {
            try {
                var rx = /INPUT|SELECT|TEXTAREA/i;
                if (!rx.test(e.target.tagName) || e.target.disabled || e.target.readOnly) {
                    return false;
                    //e.preventDefault();
                }
            } catch (e) {
                KS.log('Backspace return error');
            }
        }
    });
});