////////////////////////////////////////////////////////////////////////////////
// Issue tracker stuff
KS.apply(KS, {
    sendIssueReport: function(msg, details) {
        var ss = function(data) {
                if (!KS.isValid(data))
                    KS.alert(KS.L10n.msgSent);
                else
                    KS.error(data, null, null, null, false);
            },
            d = KS.gatherIssueDetails(),
            s = KS.Base64.encode(KS.takeScreenshot());

        WorkspaceView.serverCall({
            method: 'ReportIssue',
            params: new Array({
                message: msg,
                details: details,
                data: d,
                screenshot: s
            }),
            error: function() {
                // в случае ошибки пытаемся еще разок без скриншота
                WorkspaceView.serverCall({
                    method: 'ReportIssue',
                    params: new Array({
                        message: msg,
                        details: details,
                        data: d
                    }),
                    success: ss
                });
            },
            success: ss
        });
    },

    gatherIssueDetails: function() {
        var data = {};
        for (var id in KS.registeredViews) {
            var v = KS.registeredViews[id];
            KS.apply(data, v.getIssueData.apply(v));
        }
        return data;
    },

    showDesktopAlert: function (text, caption, autoClose, icon, autoCloseDelay, actionText, callback, notify) {
        var action = '';
        if (!KS.isEmpty(actionText) && !KS.isEmpty(actionText)) {
            action = "<br /><span class='like-hypertext' onclick='" + callback + "();return false;'>" + actionText + "</span>";
        }
        if (autoCloseDelay > 0 && autoCloseDelay < 1000) {
            autoCloseDelay = autoCloseDelay * 1000; // to msec
        }
        if (notify && 'Notification' in window && navigator.serviceWorker) {
            Notification.requestPermission(function (status) {
                if (status === 'granted') {
                    var options = {
                        body: text
                    };
                    var n = new Notification(caption, options);
                    try {
                        callback = eval(callback);
                        if (KS.isFunction(callback)) {
                            n.onclick = callback;
                        }
                    } catch (e) {
                    }
                } else {
                    KS.log('Notifications not granted: ', status);
                    KS.msg(text + action, caption, autoCloseDelay);
                }
            });
        } else {
            KS.log('Notifications not supports');
            KS.msg(text + action, caption, autoCloseDelay);
        }
        return false;
    }
});

