﻿Ext.define('Meta.Jobs', {
    singleton: true,
    alias: 'meta.jobs',

    GetCheckedServerTasks: function () {
        var selected = GetSelected();

        if (!selected || !selected.length) return ExtAlert('#msg#Выберите задачу сервера');

        return selected.map(function (rec) {
            return rec.job_id;
        });
    },

    ExecuteCommand: function (p) {
        p = p || {};

        var objx = ObjX,
            commandName = p.commandName,
            msg = p.msg,
            links = Meta.Jobs.GetCheckedServerTasks(),
            startTask = function () {
                AjaxRequest({
                    url: 'ServerJobList/' + commandName,
                    params: {
                        links: links
                    },
                    success: function (res) {
                        res && objx.Refresh && objx.Refresh();
                    }
                });
            };

        if (!links) return ExtAlert('#msg#Выберите задачу');

        Ext.Msg.show({
            title: 'Подтверждение',
            message: msg,
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function (btn) {
                btn === 'yes' && startTask();
            }
        });

        

    },

    List: function () {
        Dashboard.GotoTab({
            ObjectCode: 'DICTIONARY_SERVER_JOBS',
            supressSummary: true,
            supressTotal: true
        });
    },

    New: function () {
        Meta.Jobs.Edit({
            isNew: true
        });
    },

    Edit: function (p) {
        p = p || {};

        var link = null;

        if (!p.isNew) {
            var selected = GetSelected()[0];
            if (!selected) return ExtAlert('#msg#Выберите задачу сервера');
            link = selected.job_id;
        }

        Ext.create('Meta.Editor.ServerTask', {
            link: link,
            parent: this.ObjX || ObjX
        });
    },

    Delete: function () {
        Meta.Jobs.ExecuteCommand({
            commandName: 'RemoveTask',
            msg: 'Удалить задачу?'
        });
    },

    History: function () {
        var links = Meta.Jobs.GetCheckedServerTasks();

        if (!links) return;

        DictList({
            DictObject: links[0],
            ModeCode: 'admin_jobs',
            compConfig: {
                forceFit: true
            },
            title: 'История выполнения задачи',
            localColumns: [
                {
                    text: 'Сообщение',
                    dataIndex: 'message',
                }, {
                    text: 'Дата запуска',
                    dataIndex: 'run_date'
                }, {
                    text: 'Время запуска',
                    dataIndex: 'run_time'
                }, {
                    text: 'Длительность',
                    dataIndex: 'run_duration'
                }, {
                    text: 'Состояние',
                    dataIndex: 'cstate'
                }
            ],
            macroCallBack: Ext.emptyFn
        });
    },

    Run: function () {
        Meta.Jobs.ExecuteCommand({
            commandName: 'RunTask',
            msg: 'Запустить задачу?'
        });
    }
});