﻿Ext.define('Meta.Groupadmin', {

    singleton: true,

    alias: 'Meta.Groupadmin',

    CallGroupManagerMethod: function (task) {
        if (this.ObjX && this.ObjX.groupManager && task) {
            var groupManager = this.ObjX.groupManager;
            if (groupManager.isGroupManager && groupManager[task] && groupManager[task].call) {
                groupManager[task]();
            } else {
                ExtAlert('#msg#Функция в разработке');
            }
        }
    },

    Init: function () {
        var dbManager = this.ObjX && this.ObjX.containerMain ? this.ObjX.containerMain : {};
        if (WebProject.Info.IsAdm && dbManager.isDbManager) {
            var activeNode = dbManager.GetActiveDbNode();

            if (activeNode.get('INode').SqlAdminNodeType !== 10014) return;

            var dbName = dbManager.GetNodeDbName(activeNode.parentNode);

            Dashboard.GotoTab({
                ObjectCode: 'GROUP_ADMIN',
                iconCls: 'ks-icon-group_administration',
                CustomRender: function () {
                    var objx = ObjX,
                        adminGroup = Ext.create('Admin.GroupsManager', {
                            dbManager: dbManager,
                            selectedDbNode: activeNode.parentNode,
                            dbName: dbName
                        });

                    objx.containerMain.removeAll();

                    objx.containerMain.setTitle('[' + dbName + '] Администратор групп');

                    objx.containerMain.add(adminGroup);
                }
            });
        }
    },

    Save: function () {
        Meta.Groupadmin.CallGroupManagerMethod.call(this, 'Save');
    },

    AddCorr: function () {
        Meta.Groupadmin.CallGroupManagerMethod.call(this, 'AddCorr');
    },

    AddRBS: function () {
        Meta.Groupadmin.CallGroupManagerMethod.call(this, 'AddRBS');
    }, 

    AddPBS: function () {
        Meta.Groupadmin.CallGroupManagerMethod.call(this, 'AddPBS');
    },

    AddGRBSPBS: function () {
        Meta.Groupadmin.CallGroupManagerMethod.call(this, 'AddGRBSPBS');
    },

    AddBudget: function () {
        Meta.Groupadmin.CallGroupManagerMethod.call(this, 'AddBudget');
    },

    AddOkato: function () {
        Meta.Groupadmin.CallGroupManagerMethod.call(this, 'AddOkato');
    }, 

    Delete: function () {
        Meta.Groupadmin.CallGroupManagerMethod.call(this, 'Delete');
    },

    AddGroups: function () {
        Meta.Groupadmin.CallGroupManagerMethod.call(this, 'AddGroups');
    },

    Bind: function () {
        Meta.Groupadmin.CallGroupManagerMethod.call(this, 'Bind');
    }, 

    ClearBinding: function () {
        Meta.Groupadmin.CallGroupManagerMethod.call(this, 'ClearBinding');
    },

    Import: function () {
        Meta.Groupadmin.CallGroupManagerMethod.call(this, 'Import');
    },

    Export: function () {
        Meta.Groupadmin.CallGroupManagerMethod.call(this, 'Export');
    },

    Print: function () {
        Meta.Groupadmin.CallGroupManagerMethod.call(this, 'Print');
    }

});