﻿Ext.define('Core.Sqladmin', {

    singleton: true,
    alias: 'Core.Sqladmin',

    CallDbManagerMethod: function (task) {
        if (this.ObjX && this.ObjX.containerMain && task) {
            var dbManager = this.ObjX.containerMain;
            if (dbManager.isDbManager && dbManager[task] && dbManager[task].call) {
                dbManager[task]();
            } else {
                ExtAlert('#msg#Функция в разработке');
            }
        }
    },

    CopyDb: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'CopyDb');
    },

    BackupDb: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'BackupDb');
    },

    RestoreDb: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'RestoreDb');
    },

    RenameDb: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'RenameDb');
    },
    
    DeleteDb: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'DeleteDb');
    },

    UpdateStatistic: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'UpdateStatistic');
    },

    IndexDefragmentation: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'IndexDefragmentation');
    },

    ReIndex: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'ReIndex');
    },

    ShrinkDatabase: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'ShrinkDatabase');
    },

    CheckDatabase: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'CheckDatabase');
    },
    
    DbObjects: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'DbObjects');
    },

    ProcessList: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'ProcessList');
    },

    DatabaseProperties: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'DatabaseProperties');
    },

    CreateMessageServer: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'CreateMessageServer');
    },

    AttachMessageServer: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'AttachMessageServer');
    },

    DetachMessageServer: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'DetachMessageServer');
    },

    ConfigMessageServer: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'ConfigMessageServer');
    },

    CreatePrimaryDocumentServer: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'CreatePrimaryDocumentServer');
    },

    DeletePrimaryDocumentServer: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'DeletePrimaryDocumentServer');
    },

    CreateMailProfile: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'CreateMailProfile');
    },

    OpenMessageList: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'OpenMessageList');
    },

    TurnOffMailServer: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'TurnOffMailServer');
    },

    TurnSwitchMailServer: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'TurnSwitchMailServer');
    },

    DeleteMailProfile: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'DeleteMailProfile');
    },
    
    PerfInformation: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'PerfInformation');
    },

    SqlQueryManager: function () {
        ExtAlert('#msg#Функционал недоступен исходя из безопасности');
    },

    SqlQueryRun: function () {
        ExtAlert('#msg#Функционал недоступен исходя из безопасности');
    },

    BlocksMonitor: function () {
        var dbManager = this.ObjX.containerMain;

        if (!dbManager.isDbManager) return;

        var server = dbManager.currentServer;

        Dashboard.GotoTab({
            documentCode: 'BlocksMonitor',
            documentLink: -1,
            nodetype: 'NODE_SQL_BLOCKS',
            iconCls: 'ks-icon-server',
            CustomRender: function () {
                var container = ObjX.containerMain,
                    manager = Ext.create('Admin.BlocksMonitorManager', {
                        sessionKey: dbManager.sessionKey,
                        server: server,
                        user: dbManager.currentUser
                    });

                container.setTitle('Монитор блокировок сервера ['+ server +']');

                container.removeAll();
                
                container.add(manager);
            }
        });

    },

    SetTraceStatus: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'SetTraceStatus');
    },

    ServerErrorLog: function () {
        Core.Sqladmin.CallDbManagerMethod.call(this, 'ServerErrorLog');
    }
});