﻿Ext.define('Core.DbServerFolder', {
    xtype: 'selectdbserverfolder',
    alias: 'core.dbserverfolder',
    extend: 'Ext.window.Window',
    width: 680,
    height: 700,
    title: 'Выбор каталога на сервере',
    iconCls: 'ks-icon-tree',
    layout: 'fit',
    padding: 4,

    viewModel: {
        data: {
            treeSelection: null
        }
    },

    config: {
        selection: ''
    },

    dockedItems: [
        {
            xtype: 'panel',
            defaultType: 'button',
            border: false,
            dock:'bottom',
            layout: {
                type: 'vbox',
                align: 'stretch',
            },
            items: [
                {
                    xtype: 'fieldcontainer',
                    padding: 4,
                    layout: {
                        type: 'vbox',
                        align: 'stretch'
                    },
                    defaultType: 'textfield',
                    defaults: {
                        editable: false
                    },
                    items: [{
                        fieldLabel: 'Название папки',
                        bind: {
                            value: '{treeSelection.text}'
                        }
                    },
                    {
                        fieldLabel: 'Полный путь',
                        bind: {
                            value: '{treeSelection.fullPath}'
                        }
                    }
                    ]
                },
                {
                    xtype: 'toolbar',
                    ui: 'footer',
                    items: [
                        {
                            xtype: 'component',
                            flex: 1
                        },
                        {
                            xtype: 'button',
                            text: 'Применить',
                            handler: function () {
                                var cmp = this.up('selectdbserverfolder');
                                if (cmp.onSelectCallback && cmp.onSelectCallback.call) {
                                    var value = cmp.getSelection();
                                    cmp.onSelectCallback(value);
                                }
                                this.up('selectdbserverfolder').close();
                            }
                        }, 
                        {
                            xtype: 'button',
                            text: 'Отмена',
                            handler: function () {
                                this.up('selectdbserverfolder').close();
                            }
                        }
                    ]
                }
            ]
        }
    ],

    constructor: function (args) {
        var me = this;

        Ext.apply(me, args);

        me.callParent(arguments);
    },
    
    onSelect: function (node) {
        var me = this,
            path = me.GetFullPath(node);

        me.fireEvent('select');

        if (me.folderOnly && node.get('isFile')) {
            path = '';
        }

        me.setSelection(path);
    },

    onRender: function () {
        var me = this;

        me.CreateTree();

        me.callParent(arguments);

        me.FetchFolderData();
    },

    FetchFolderData: function (node, cb) {
        var me = this,
            defaultMask = {
                text: 'Загрузка списка' + (node ? 'содержимого папки' : 'папок сервера'),
                id: me
            },
            mask = me.rendered ? defaultMask : null;

        AjaxRequest({
            url: 'DbServerFolder/GetAvailableFolder',
            mask: mask,
            params: {
                key: me.sessionKey || null,
                folderKey: me.GetFullPath(node) || null
            },
            success: function (res) {
                if (res && res.Data && res.Data.Tables[0] && res.Data.Tables[0]) {
                    me.AddNodesToTreeBranch(res.Data.Tables[0], node);
                    cb && cb();
                    !cb && node && node.expand();
                } else {
                    ExtAlert('#msg#Ошибка получения содержимого папки');
                }
            }
        });
    },

    AddNodesToTreeBranch: function (datatable, node) {
        var me = this,
            store = me.store,
            parentNode = node || store.getRoot(),
            nodes = DataUtils.GetDataFromTable(datatable);

        if (me.folderOnly) {
            nodes = nodes.filter(function (node) {
                return !node.is_file;
            });
        }
        nodes = nodes.map(function (node) {
            var isFile = node.is_file || false,
                text = node.name || node.subdirectory;
            return {
                text: text,
                isFile: isFile || false,
                iconCls: 'ks-icon-' + (isFile ? 'document ' : 'folder'),
                leaf: isFile
            };
        });

        parentNode.appendChild(nodes);
    },

    GetFullPath: function (node) {
        if (!node) return;
        var fullPath = node.get('fullPath');
        if (!fullPath) {
            var folderKey = node.get('text'),
                parentFullPath = node.parentNode.get('fullPath');
            
            if (parentFullPath) {
                fullPath = parentFullPath + (parentFullPath.charAt(parentFullPath.length - 1) === '\\' ? '' : '\\') + folderKey;
                if (!node.get('isFile')) {
                    fullPath += '\\';
                }
            } else {
                if (node.parentNode.isRoot()) {
                    fullPath = folderKey;
                } else {
                    var fullPathArr = [];
                    node.bubble(function (bubbleNode) {
                        if (!bubbleNode.isRoot()) fullPathArr.push(bubbleNode.get('text'));
                    });
                    fullPath = fullPathArr.reverse().join('\\');
                }
            }

            node.set('fullPath', fullPath);
        }
        return fullPath;
    },

    CreateTree: function () {
        var me = this,
            store = me.store = Ext.create('Ext.data.TreeStore', {
                root: {
                    children: []
                }
            }),
            tree = me.tree = Ext.create('Ext.tree.Panel', {
                store: store,
                emptyText: 'Нет данных',
                useArrows: true,
                maskDisabled: true,
                rootVisible: false,
                reserveScrollbar: true,
                scrollable: true,
                border: 1,
                bind: {
                    selection: '{treeSelection}'
                },
                listeners: {
                    beforeitemexpand: function (node) {
                        if (!node.hasChildNodes()) {
                            me.FetchFolderData(node, function () {
                                node.hasChildNodes() ? node.expand() : node.set('leaf', true);
                            });
                            return false;
                        }
                    },
                    beforeselect: function (tree, node) {
                        if (me.folderOnly && node.get('isFile')) return false;
                    },
                    selectionchange: function (tree, node) {
                        me.onSelect(node[0]);
                    }
                }
            });

        me.add(tree);
    }

});