﻿Ext.define("Core.Admin", {
    singleton: true,
    alias: "core.admin",

    privates: {
        ShowSelectServerWindow: function () {
            var currentServer = WebProject.Info.DBServer,

                user = WebProject.Info.UserName,
            
                current = Ext.create("Ext.form.FieldSet", {
                    layout: {
                        type: "hbox",
                        align: "center"
                    },
                    padding: "0 8 8 8",
                    items: [
                        {
                            xtype: "radiofield",
                            margin: "0 8 0 0",
                            inputId: "currentDbServer",
                            name: "dbServer",
                            inputValue: "1",
                            width: 16,
                            bind: {
                                value: "{isCurrent}"
                            }
                        }, 
                        {
                            xtype: "label",
                            text: "Текущий сервер:",
                            forId: "currentDbServer",
                            margin: 0,
                            padding: 0,
                            width: 120,
                        }, 
                        {
                            xtype: "textfield",
                            editable: false,
                            flex: 1,
                            value: currentServer + " - " + user,
                            bind: {
                                disabled: "{!isCurrent}"
                            }
                        }
                    ]
                }),

                another = Ext.create("Ext.form.FieldSet", {
                    layout: {
                        type: "vbox",
                        align: "stretch"
                    },
                    items: [
                        {
                            xtype: "fieldcontainer",
                            layout: {
                                type: "hbox",
                                align: "center"
                            },
                            items: [
                                {
                                    xtype: "radiofield",
                                    margin: "0 8 0 0",
                                    name: "dbServer",
                                    inputValue: "1",
                                    inputId: "anotherDbServer",
                                    width: 16,
                                    bind: {
                                        value: "{isAnother}"
                                    }
                                }, 
                                {
                                    xtype: "label",
                                    text: "Другой сервер:",
                                    forId: "anotherDbServer",
                                    margin: 0,
                                    padding: 0,
                                    width: 120,
                                }, 
                                {
                                    xtype: "textfield",
                                    flex: 1,
                                    bind: {
                                        disabled: "{!isAnother}",
                                        value: "{dbServer}"
                                    }
                                }
                            ]
                        },
                        {
                            xtype: "fieldcontainer",
                            layout: {
                                type: "vbox",
                                align: "stretch"
                            },
                            margin: "16 0 0 0",
                            items: [
                                {
                                    xtype: "textfield",
                                    fieldLabel: "Имя пользователя",
                                    labelWidth: 140,
                                    value: user,
                                    bind: {
                                        disabled: "{!isAnother}",
                                        value: "{dbUser}"
                                    }
                                }, 
                                {
                                    xtype: "textfield",
                                    fieldLabel: "Пароль",
                                    labelWidth: 140,
                                    inputType: "password",
                                    value: "",
                                    bind: {
                                        disabled: "{!isAnother}",
                                        value: "{password}"
                                    }
                                }
                            ]
                        }
                    ]
                });

            Ext.create("Ext.window.Window", {
                autoShow: 1,
                title: "Администрирование баз данных",
                width: 500,
                height: 250,
                resizable: false,
                modal: true,
                bodyPadding: 10,
                layout: {
                    type: "vbox",
                    align: "stretch"
                },
                viewModel: {
                    data: {
                        isCurrent: 1,
                        isAnother: 0,
                        dbServer: "",
                        dbUser: user,
                        password: ""
                    }
                },
                defaults: {
                    padding: "8 8",
                    border: 0
                },
                items: [
                    current,
                    another
                ],
                buttons: [
                    {
                        text: "OK",
                        handler: function () {
                            var win = this.up("window");
    
                            if (!win) return;

                            var p = {},
                                vm = win.getViewModel(),
                                isAnother = vm.get("isAnother");

                            if (isAnother) {
                                p = {
                                    dbServer: vm.get("dbServer"),
                                    dbUser: vm.get("dbUser"),
                                    password: vm.get("password")
                                };
                            }
                            

                            Core.Admin.OpenDbList(p);

                            win.close();
                        }
                    },
                    {
                        text: "Отмена",
                        handler: function () {
                            this.up("window").destroy();
                        }
                    }
                ]
            });
        },

        OpenDbList: function (p) {
            p = p || {};

            AjaxRequest({
                url: "/DbList/LoadOutcome",
                mask: {
                    text: "Загрузка",
                    id: Dashboard
                },
                params: p,
                success: Core.Admin.Render
            });
        },

        Render: function (res) {
            var panel = Ext.create("Core.DbManager", {
                layout: "fit",
                border: false,
                iconCls: "ks-icon-server24",
                Closable: true,
                res: res
            });

            Dashboard.AddNavTab(panel, true);
        }
    },

    DbList: function () {
        if (!WebProject || !WebProject.Info) return;

        Core.Admin.ShowSelectServerWindow();
    }
});