Ext.define("Budget.Users", {
    singleton: true,
    BAccount: function () {
        var selected = GetSelected();

        if (!selected.length) {
            return ExtAlert("#err#Не выбрана запись.");
        }

        selected = selected.map(function (user) {
            return user.uid;
        });

        DictList({
            DictObject: "DICTIONARY_BACCOUNT",
            MultiSelect: "MULTI",
            ModeCode: "adminotbor",
            Links: selected,
            DictType: "AdminSelection",
            DictFields: "link",
            macroCallBack: function (res) {
                if (!res) return ExtAlert("#err#Ошибка справочника");
                AjaxRequest({
                    url: "/AdminUserList/SaveBaccounts",
                    params: {
                        DictObject: "DICTIONARY_BACCOUNT",
                        usersIds: selected,
                        insLinks: res.rows.insLinks,
                        delLinks: res.rows.delLinks
                    },
                    success: function (res) {
                        if (res.Fail) {
                            ExtAlert("#err#" + res.Message || "Ошибка сохранения данных.");
                        }
                    }
                });
            }
        });
    },

    Selections: function (p) {
        p = p || {};
        var uid = p.uid,
            objCode = p.objCode || ObjX.objCode,
            grid  = ObjX.grid,
            user = uid ? grid.getStore().findRecord("uid", uid) : grid.getSelection()[0];

        Ext.create("Meta.Editor.UserCorrSelection", {
            user: user,
            objCode: objCode,
            parent: ObjX
        });
    },
});