﻿///<reference path="Ext/ext-all.js" />
///<reference path="clientUtils.js" />
///<reference path="document.js" />
///<reference path="formDocList.js" />
///<reference path="clientMacros_dict.js" />
///<reference path="AdminGroup.js" />
///<reference path="formEdit.js" />
/*eslint eqeqeq: ["null", "ignore"]*/
//-------------------------------------------------------------------------------------------------------
//пользователю, авторизованному в комплексе с правами админа можно зайти в комплекс  правами профиля другого(выбранного) пользователя.
function getCorrTree() {
    var p = {};
    p.DictObject = "corrtree";
    p.RelKey = "link";
    p.RelUp = "link_self";
    p.columnsTree = "sname";
    p.DictFields = "corr";
    p.DocFields = "";
    p.macroCallBack = "getCorrTree_CallBack";

    _mmx = new _MMX();
    _mmx.ctrl = {};
    return getDictTree(p);
}
function getCorrTree_CallBack() {
    var res = _mmx.currentResult;
    if (IsEmpty(res)) return ExtAlert("#msg#Не выбран пользователь");
    AjaxRequest({
        mlt: "Пожалуйста, подождите...",
        url: _all.rsa + "/Complex/SetUser",
        success: function (r) {
            if (!IsEqual(r, "OK"))
                return ExtAlert("#msg#Пользователи не привязаны к организации, переключение контекста невозможно.");
            window.onbeforeunload = function () { };
            (new Ext.LoadMask(Ext.getBody(), { msg: "Пожалуйста, подождите..." })).show();
            window.location = Ext.String.format("view.htm?pg=navigator&cc={0}", _cc[0]);
        },
        params: { corr: res }
    });
}

//---------------------------------------------------------------------------------------------------------
function Budget_Users_Selections() {
    var links = ObjX.meta.GetValuesByCheckedRows("checked", ObjX.closeCode, true);
    if (IsEmpty(links)) return ExtAlert("#err#Не выбраны записи.");
    if (links.split(",").length > 1) return ExtAlert("#err#Выбрано больше одной записи. Выберите только одну");
    var usrName = ObjX.meta.GetValuesByCheckedRows("checked", "name", true);
    var res = AjaxRequest({
        mask: {text: "Получение настроек", id: ObjX.idContainer},
        url: Ext.String.format("{0}/AdminUserList/{1}", _all.rsa, "UserCorrSelections"),
        async: false,
        params: { uid: links }
    });
    if (res.length < 2) return ExtAlert("#err#Ошибка получения отборов");
    // Отрисовка окна.
    var grid1 = new ext_Grid(res[0]);
    var grid2 = new ext_Grid(res[1]);
    var items = new Ext.Panel({
        layout: {
            type: "hbox",
            align: "stretch"
        },
        items: [
            {
                xtype: "panel",
                flex: 1,
                layout: "fit",
                items: grid1.UI
            },
            {
                xtype: "panel",
                flex: 1,
                layout: "fit",
                items: grid2.UI
            }
        ]

    });

    var buttons = [{ text: "Сохранить", handler: function () { Budget_Users_Selections_Save(links, grid1, grid2); } },
        { text: "Закрыть", handler: function () { Ext.getCmp("_otbors").close(); } }
    ];
    ShowExtWindow_A(Ext.String.format("Отборы пользователя '{0}'", usrName), null, 1100, null, true, items, buttons, "_otbors");
}
// [UserCorrSelectionsAdapter.SaveChanges]
function Budget_Users_Selections_Save(uid, grid1, grid2) {
    var params = {};
    params.uid = uid;
    params.ins_a = grid1.GetValuesByCheckedRows("ins", "num", false);
    params.sel_a = grid1.GetValuesByCheckedRows("sel", "num", false);
    params.ins_c = grid2.GetValuesByCheckedRows("ins", "num", false);
    params.sel_c = grid2.GetValuesByCheckedRows("sel", "num", false);
    params.adm_a = grid1.GetValuesByCheckedRows("adm", "num", false);
    params.adm_c = grid2.GetValuesByCheckedRows("adm", "num", false);

    AjaxRequest({
        mask: {text: "Сохранение настройки", id: "_otbors"},
        url: Ext.String.format("{0}/AdminUserList/{1}", _all.rsa, "UserCorrSelectionsSave"),
        success: function () { Ext.getCmp("_otbors").close(); },
        error: function(res) { console.log("Budget_Users_Selections_Save: Ошибка сохранения" + res.Message); },
        params: params
    });
}
//-------------------------------------------------------------------------------------------------------
// Счета бюджета 
// <Function Name="Budget.Users.BAccount" />
// DictionaryAdapter.GetSpecificDictionary
// BudgetAccountAdapter.SetBAccounts
function Budget_Users_BAccount() {
    var links = ObjX.meta.GetValuesByCheckedRows("checked", ObjX.closeCode, true);
    if (IsEmpty(links)) return ExtAlert("#err#Не выбраны записи.");
    getOtbor({ DictObject: "DICTIONARY_BACCOUNT", links: links, ModeCode: "AdminOtbor", macroCallBack: "Budget_Users_BAccount_Save" });
}
// Сохранение отбора бюджетов
// BudgetAccountAdapter.SetBAccounts
function Budget_Users_BAccount_Save() {
    var res = _mmx.currentResult;
    var mask = ShowLoadMask("Сохранение настройки", ObjX.idContainer);
    AjaxRequest({
        url: Ext.String.format("{0}/AdminUserList/{1}", _all.rsa, "SaveBaccounts"),
        success: function (res) { mask.hide(); if (!IsEmpty(res) && res.Fail) console.log("Budget_Users_BAccount_Save: Ошибка сохранения" + res.Message); },
        params: res
    });
}
//-------------------------------------------------------------------------------------------------------
function Meta_Jobs_List() {
    ListDocSV("DICTIONARY_SERVER_JOBS");
}
function Budget_CorrSelections_Open(mode) {
    if (IsEqual(mode, "corr"))
        ListDocSV("DICTIONARY_OTBOR_CORR");
    if (IsEqual(mode, "acc"))
        ListDocSV("DICTIONARY_OTBOR_ACCOUNT");
}

//------------------------------------------------------------------------------------------//
function AccessNavChangeAccess(grid, td, cellIndex, record) {
    if (cellIndex == 0) return;
    Ext.getCmp("ua_save").enable();
    Ext.getCmp("btSaveAccessResult").enable();
    var node = AccessNavSelected();
    var allow = node.data.INode.Access;
    var deny = node.data.INode.DenyAccess;
    var mask = record.get("Value");
    var allowGrid = record.get("allow") * 1;
    var denyGrid = record.get("forbidden") * 1;
    if (allowGrid && cellIndex === 1) {
        denyGrid = 0;
        record.set("forbidden", "0");
    }
    if (denyGrid && cellIndex === 2) {
        allowGrid = 0;
        record.set("allow", "0");
    }
    node.data.INode.Access = allowGrid ? (allow | mask) : (allow & mask) > 0 ? (allow ^ mask) : allow;
    node.data.INode.DenyAccess = denyGrid ? (deny | mask) : (deny & mask) > 0 ? (deny ^ mask) : deny;
    AccessNavSaveChanges(node.data.INode);
}

function AccessNavSaveChanges(iNode) {
    var grid = Ext.getCmp("usr_ac_opt");
    if (!grid.SaveData) grid.SaveData = [];
    var idx = grid.SaveData.findIndex(CheckArrayINode, iNode);
    if (idx > -1) {
        grid.SaveData[idx].Access = iNode.Access;
        grid.SaveData[idx].DenyAccess = iNode.DenyAccess;
        return;
    }
    grid.SaveData.push(iNode);
}
function CheckArrayINode(element) {
    return (element.Code === this.Code);
}

function AccessNavNodeClick(tree, node) {
    if (!tree || !node || !node.data || !node.data.INode) return null;
    AccessNavSetValues(node.data);
}

function AccessNavSetValues(nodeData) {
    if (nodeData == null) return null;

    var grid = Ext.getCmp("usr_ac_opt");
    grid.getStore().clearFilter();
    grid.getStore().filterBy(AccessNavHideRows, nodeData);

    if (nodeData.children) {
        Ext.getCmp("us_setChild").enable();
        Ext.getCmp("us_resetChild").enable();
    } else {
        Ext.getCmp("us_setChild").disable();
        Ext.getCmp("us_resetChild").disable();
    }

    // AccessMask.TOOLBAR
    // TOOLBAR = 0x0100
    if ((nodeData.INode.Mask & 0x0100) > 0)
        Ext.getCmp("us_tb_acceess").enable();
    else
        Ext.getCmp("us_tb_acceess").disable();

    var models = grid.getStore().getRange();
    if (models.length === 0) {
        grid.disable();
        Ext.getCmp("userAccessConfig").hide();
        return null;
    }

    Ext.getCmp("userAccessConfig").show();
    grid.enable();
    // Set Data
    var allow = nodeData.INode.Access;
    var deny = nodeData.INode.DenyAccess;
    if (grid.SaveData) {
        var idx = grid.SaveData.findIndex(CheckArrayINode, nodeData.INode);
        if (idx > -1) {
            allow = grid.SaveData[idx].Access;
            deny = grid.SaveData[idx].DenyAccess;
        }
    }

    for (var i = 0; i < models.length; i++) {
        if (models[i].get("Value") & allow)
            models[i].set("allow", "1");
        else
            models[i].set("allow", "0");
        if (models[i].get("Value") & deny)
            models[i].set("forbidden", "1");
        else
            models[i].set("forbidden", "0");
    }
}

function AccessNavHideRows(record) {
    if (!this || !this.INode) return false;
    return record.get("Value") & this.INode.AccessBase;
}

function AccessNavGetToolbar(uid, usrName) {
    return [
        {
            id: "ua_save",
            tooltip: "Сохранить",
            icon: "images/icons/save.png",
            disabled: true,
            handler: function () { Meta_Users_Access_Save(uid, false); }
        },
        "-",
        ,
        {
            id: "us_setChild",
            tooltip: "Назначить у дочерних объектов",
            icon: "images/icons/treeadd.png",
            disabled: true,
            handler: function() {
            }
        }
        ,
        {
            id: "us_resetChild",
            tooltip: "Сбросить у дочерних объектов",
            icon: "images/icons/treedel.png",
            disabled: true,
            handler: function () {
            }
        },
        "-"
        ,
        {
            id: "us_tb_acceess",
            tooltip: "Редактировать доступ к панели инструментов",
            icon: "images/icons/design.png",
            disabled: true,
            handler: function () {
                Meta_Users_Access_Toolbar(uid, usrName);
            }
        }
    ];

}

function AccessNavSelected() {
    //var activeTab = GetCmp("navAccessMode").getActiveItem();
    var activeTab = GetCmp("navAccessMode").activeTab;
    var treepanel = GetCmp(activeTab.id);
    var nodes = treepanel.view.getSelectionModel().getSelection();
    if (IsEmpty(nodes)) ExtAlert("#err#Не выбран узел дерева");
    var node = nodes[0];
    return node;
}
//*******************************************// END BLOCK //*******************************************//
//------------------------------------//
//[ToolbarAccessAdapter.LoadDataSet]
function Meta_Users_Access_Toolbar(uid, userName, objCode, objName, varLink, id ) {
    if (IsEmpty(objCode)) {
        var node = AccessNavSelected();
        objCode = node.data.INode.Code;
        objName = node.data.INode.Name;
        id = "navAccessMode";
    }

    AjaxRequest({
        //mask: { text: "Получение данных", id: id },
        url: Ext.String.format("{0}/AdminUserList/{1}", _all.rsa, "GetToolbarAccess"),
        success: function (res) { Meta_Users_Access_Toolbar_Show(res, uid, varLink, objName, userName); },
        params: { uid: uid, varLink: varLink, objCode: objCode }
    });

}
function Meta_Users_Access_Toolbar_Show(res, uid, varLink, objName, userName) {
    var extTree = Ext_tree(res.ToolbarAccessTree, "ToolbarAccessTree", true, true);
    extTree.on("checkchange", function () { Ext.getCmp("btSaveToolAccessResult").enable();});

    extTree.anchor = "-0, -55";


    var items = new Ext.form.Panel({
        layout: "anchor",
        bodyPadding: 5,
        items: [
            {
                xtype: "textfield",
                editable: false,
                height: 24,
                fieldLabel: "Объект", 
                labelSeparator: ":",
                labelWidth: 150,
                anchor: "-0",
                value: objName
            },
            /*{
                xtype: "textfield",
                editable: false,
                height:24,
                fieldLabel: 'Пользователь/Группа',
                labelSeparator: ':',
                labelWidth: 150,
                anchor: "-0",
                value: userName
            },*/
            extTree
        ]
    });
    var buttons = [
        { text: "OK", handler: function () { Meta_Users_Access_Toolbar_Save(uid, varLink, true); } },
        { text: "Отмена", handler: function () { Ext.getCmp("user_tool_access").close(); } },
        { id: "btSaveToolAccessResult", disabled: true, text: "Применить", handler: function () { Meta_Users_Access_Toolbar_Save(uid, varLink, false); } }
    ];

    var win = new Ext.Window({
        title: Ext.String.format("Права доступа к панели инструментов пользователя/группы '{0}'", userName),
        id: "user_tool_access",
        width: 800,
        height: 600,
        layout: "fit",
        modal: true,
        frame: true,
        padding: 2,
        items: items,
        buttons: buttons,
        maximizable: false,
        autoScroll: false
    });
    win.show();
}
// ToolbarAccessAdapter.SaveChanges]
function Meta_Users_Access_Toolbar_Save(uid, varLink, close) {
    var bt = Ext.getCmp("btSaveToolAccessResult");
    if (bt.disabled) {
        Ext.getCmp("user_tool_access").close();
        return;
    }
    var node = Ext.getCmp("ToolbarAccessTree").getRootNode();
    var saveData = [];
    node.cascadeBy(function (child) {
        if (child.id !== "root") {
            var chk = child.get("checked");
            if (chk !== child.data.INode.Checked) {
                child.data.INode.Checked = chk;
                saveData.push(child.data.INode);
            }
        }
    });

    AjaxRequest({
        mask: { text: "Сохранение", id: "user_tool_access" },
        url: Ext.String.format("{0}/AdminUserList/{1}", _all.rsa, "SaveUserToolAccess"),
        success: function () {
            bt.disable();
            if (close)
                Ext.getCmp("user_tool_access").close();
        },
        params: { uid: uid, saveData: Ext.encode(saveData), varLink: varLink }
    });
}
//------------------------------------//
// Budget.CorrSelections.Import
// Budget.CorrSelections.Export
// Budget.CorrSelections.Print
// Отборы. Выгрузка, Загрузка, Печать.

function Budget_CorrSelections_Export() {
    var num = ObjX.meta.GetValuesByCheckedRows("checked", "num", true);
    if (IsEmpty(num)) return ExtAlert("#err#Не выбраны записи.");
    if (num.split(",").length > 1) return ExtAlert("#err#Выбрано больше одной записи. Выберите только одну");
    var params = { num: num };
    FileUtils.DownloadPost(Ext.String.format("{0}/AdminUserList/{1}", _all.rsa, "CorrSelectionsExport"), params);
}
function Budget_CorrSelections_Print() {
    var num = ObjX.meta.GetValuesByCheckedRows("checked", "num", true);
    if (IsEmpty(num)) return ExtAlert("#err#Не выбраны записи.");
    if (num.split(",").length > 1) return ExtAlert("#err#Выбрано больше одной записи. Выберите только одну");

    AjaxRequest({
        mask: { text: "Получение данных", id: ObjX.idContainer },
        url: Ext.String.format("{0}/AdminUserList/{1}", _all.rsa, "CorrSelectionsPrint"),
        success: function (res) { ShowProtocol(null, "", "Информация об отборе", res); },
        params: { num:  num}
    });
}