﻿Ext.define('Admin.SqlTrace2File', {
    extend: 'Ext.panel.Panel',
    xtype: 'sqltrace2file',
    alias: 'core.sqltrace2file',
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
    border: 0,
    bodyPadding: 10,
    viewModel: {
        data: {
            isStarted: false,
            isSaved: false,
            Databases: null,
            events: {
                selectedEvents: 2
            },
            Logins: '',
            TraceId: 0,
            MinDuration: 0,
            EventSet: null,
            TracingFile: '',
            TracingTime: null
        },
        formulas: {
            EventSet: {
                get: function (get) {
                    return get('events.selectedEvents');
                }
            },
            isSaved: {
                get: function (get) {
                    return get('TraceId') !== 0 && !get('isStarted');
                }
            },
            timeRemainField: {
                get: function (get) {
                    if (get('isStarted')) {
                        return get('timeRemain');
                    }

                    if (!get('isStarted') && get('TraceId') !== 0) {
                        return 'Трассировка завершена';
                    }

                    return '';
                }
            }
        }
    },

    tbar: [{
        tooltip: 'Старт',
        iconCls: 'ks-icon-start',
        bind: {
            disabled: '{isStarted}'
        },
        handler: function () {
            this.up('sqltrace2file').StartTracing();
        }
    },
    {
        tooltip: 'Стоп',
        iconCls: 'ks-icon-stop',
        bind: {
            disabled: '{!isStarted}'
        },
        handler: function () {
            this.up('sqltrace2file').StopTracing(true);
        }
    },
    '-',
    {
        tooltip: 'Скачать',
        iconCls: 'ks-icon-save_as',
        bind: {
            disabled: '{!isSaved}'
        },
        handler: function () {
            this.up('sqltrace2file').SaveFile();
        }
    }
    ],

    defaults: {
        margin: '0 0 8 0',
        labelWidth: 240,
    },

    items: [{
        xtype: 'radiogroup',
        fieldLabel: 'Набор событий',
        columns: 1,
        vertical: true,
        items: [{
            boxLabel: 'Анализ ошибок',
            name: 'selectedEvents',
            inputValue: 2
        },
        {
            boxLabel: 'Анализ производительности',
            name: 'selectedEvents',
            inputValue: 1
        }
        ],
        bind: {
            value: '{events}',
            disabled: '{isStarted}'
        }
    },
    {
        xtype: 'textfield',
        fieldLabel: 'Логины',
        width: '100%',
        bind: {
            value: '{Logins}',
            disabled: '{isStarted}'
        }
    },
    {
        xtype: 'numberfield',
        fieldLabel: 'Сохранять события длительность которых более (мс)',
        minValue: 0,
        bind: {
            value: '{MinDuration}',
            disabled: '{isStarted}'
        }
    },
    {
        xtype: 'textfield',
        fieldLabel: 'Сохранять файл на сервере',
        width: '100%',
        bind: {
            value: '{TracingFile}',
            disabled: '{isStarted}'
        },
        triggers: {
            explorer: {
                cls: 'ks-icon-folder_open',
                handler: function () {
                    var textfield = this,
                        me = textfield.up('sqltrace2file'),
                        dbManager = me.dbManager,
                        sessionKey = dbManager ? dbManager.sessionKey : null;
                    
                    Ext.create('Core.DbServerFolder', {
                        autoShow: true,
                        alwaysOnTop: true,
                        modal: true,
                        folderOnly: true,
                        sessionKey: sessionKey,
                        onSelectCallback: function (v) {
                            textfield.setValue(v + me.defaultFileName);
                        }
                    });
                }
            }
        }
    },
    {
        xtype: 'timefield',
        fieldLabel: 'Время работы',
        fieldAlign: 'left',
        increment: 1,
        minValue: '0:01',
        maxValue: '24:00',
        format: 'H:i:s',
        bind: {
            value: '{TracingTime}',
            disabled: '{isStarted}'
        }
    },
    {
        xtype: 'displayfield',
        fieldLabel: 'Осталось времени',
        fieldAlign: 'left',
        renderer: function (v) {
            return v && v.getTime ? '<span style="color: red;">' + Ext.Date.format(v, 'H:i:s') + '</span>' : v;
        },
        bind: {
            value: '{timeRemainField}'
        }
    }
    ],

    listeners: {
        beforeclose: function () {
            var me = this;
            if (me.IsStarted()) {
                Ext.Msg.show({
                    title: 'Подтверждение',
                    message: 'Остановить трассировку?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function (btn) {
                        if (btn === 'yes') {
                            me.StopTracing(false, function () {
                                me.close();
                            });
                        }
                    }
                });
                return false;
            }
        }
    },

    constructor: function (args) {
        var me = this;

        Ext.apply(me, {
            ObjX: ObjX,
            server: args.server,
            key: args.key
        });

        me.callParent(arguments);

        me.ObjX.container.destroy();

        me.ObjX.containerMain.add(me);

        me.ObjX.containerMain.setTitle('Трассировка событий сервера ' + args.server);

        me.FetchData();
    },

    IsStarted: function () {
        return this.getViewModel().get('isStarted');
    },

    FetchData: function (cb) {
        var me = this;

        AjaxRequest({
            url: 'SqlTraceFile/LoadOutcome',
            mask: {
                text: 'Загрузка данных',
                id: me
            },
            params: {
                key: me.key
            },
            success: function (res) {
                me.SetDefaultData(res);
                cb && cb.call && cb();
            }
        });
    },

    SetDefaultData: function (res) {
        var me = this,
            vm = me.getViewModel();

        for (var key in res) {
            if (key === 'EventSet') {
                vm.set('events.selectedEvents', res[key]);
            } else {
                vm.set(key, res[key]);
            }
        }

        var path = res.TracingFile.split('\\');
        me.defaultFileName = path[path.length - 1];
    },

    StartTracing: function () {
        var me = this,
            vm = me.getViewModel();

        AjaxRequest({
            url: 'SqlTraceFile/Start',
            mask: {
                text: 'Запуск...',
                id: me
            },
            params: {
                key: me.key,
                outcome: me.GetOutcome()
            },
            success: function (res) {
                if (!res) return ExtAlert('#err#Ошибка запуска трассировки сервера');

                if (res.Result > 0) {
                    var text = '<span style="white-space: pre-wrap">' + res.Message + '</span>';
                    return ExtAlert('#err#Ошибка запуска трассировки сервера <br>' + text);
                }
                vm.set({
                    isStarted: true,
                    TraceId: res.Code
                });

                me.StartTimer();
            }
        });
    },

    GetOutcome: function () {
        var me = this,
            data = Ext.clone(me.getViewModel().getData());

        data.TracingTime = data.TracingTime.toLocaleTimeString();
        delete data.events;
        delete data.timeRemainField;

        return data;
    },

    StopTracing: function (byUser, cb) {
        var me = this,
            vm = me.getViewModel();

        me.StopTimer();

        AjaxRequest({
            url: 'SqlTraceFile/Stop',
            mask: {
                text: 'Остановка...',
                id: me
            },
            params: {
                key: me.key,
                outcome: me.GetOutcome()
            },
            success: function () {
                var p = {
                    'isStarted': false
                };
                
                if (byUser) {
                    p.TraceId = 0;
                }

                vm.set(p);
                
                cb && cb.call && cb();
            }
        });
    },

    StartTimer: function () {
        var me = this,
            vm = me.getViewModel(),
            tracingTime = vm.get('TracingTime'),
            startTime,
            endTime;

        startTime = new Date();
        endTime = new Date();

        endTime.setMinutes(startTime.getMinutes() + tracingTime.getMinutes());
        endTime.setHours(startTime.getHours() + tracingTime.getHours());

        if (me.intervarId) clearInterval(me.intervarId);

        me.intervarId = setInterval(function () {
            if (startTime <= endTime) {
                var h, m, s, date;

                startTime = new Date();

                h = Ext.Date.diff(startTime, endTime, Ext.Date.HOUR);
                m = Ext.Date.diff(startTime, endTime, Ext.Date.MINUTE) - h * 60;
                s = Ext.Date.diff(startTime, endTime, Ext.Date.SECOND) - h * 3600 - m * 60;

                date = new Date();
                date.setHours(h);
                date.setMinutes(m);
                date.setSeconds(s);

                vm.set('timeRemain', date);
            } else {
                me.StopTracing();
            }
        });
    },

    StopTimer: function () {
        var me = this;

        me.intervarId && clearInterval(me.intervarId);
        me.getViewModel().set('timeRemain', null);
        me.intervarId = null;
    },

    SaveFile: function () {
        try {
            var path = this.getViewModel().get('TracingFile').split('\\').join('/');
            FileUtils.DownloadPost('SqlTraceFile/SaveFile', {
                TracingFile: path,
                key: this.key
            });
        } catch (e) {
            ExtAlert('#err#Ошибка загрузки файла <br>' + e.message);
        }
    },

    DeleteFile: function () {
        var me = this;

        if (me.IsStarted()) return;

        AjaxRequest({
            url: 'SqlTraceFile/Delete',
            mask: {
                text: 'Удаление файла',
                id: ObjX.idContainerMain
            },
            params: {
                key: me.key,
                outcome: me.GetOutcome()
            },
            success: Ext.emptyFn
        });
    }
});
