﻿Ext.define('Admin.SQLTrace', {
    constructor: function () {
        window.SQLTraceBuffer = window.SQLTraceBuffer || {};
        this.SQLTraceCollection = {};
        this.WithResults = false;
        this.ShowHidden = false;
        this.started = false;

        this.Button = {
            iconCls: 'ks-icon-sql_gen',
            tooltip: 'SQL Трассировщик',
            handler: this.Toggle.bind(this)
        };
    },
    // Не очень пока. Отключено. Но все возможно.
    GetNavigator: function () {
        //var me = this;
        ////панель навигации
        //me.Navigator = Ext.create("Ext.panel.Panel", {
        //    tooltip: 'Трассировщик запросов.',
        //    iconCls: 'ks-icon-sql_gen32',
        //    border: false,
        //    bodyPadding: 10,
        //    layout: 'vbox',
        //    defaultType: 'button',
        //    defaults: {
        //        scale: 'large',
        //        margin: 4,
        //    },
        //    items: [{
        //        iconCls: 'ks-icon-start',
        //        text: "Открыть",
        //        handler: me.Start.bind(me)
        //    }
        //    ]
        //});
    },
    Init: function (started) {
        if (!Dashboard)
            return;

        this.tab = {
            skipInit: true,
            closable: false,
            objectCode: "TRACE-SQL",
            iconCls: "ks-icon-sql_gen",
            CustomRender: this.Draw.bind(this, started)
        };
        Dashboard.GotoTab(this.tab);
    },
    Draw: function (started) {
        this.ObjX = ObjX;
        this.mainPanel = this.ObjX.containerMain;
        this.mainPanel.setClosable(false);
        this.mainPanel.removeAll();

        var viewModel = this.mainPanel.getViewModel();
        if (!viewModel) {
            viewModel = new Ext.app.ViewModel();
            this.mainPanel.setViewModel(viewModel);
        }
        this.ViewModel = viewModel;

        this.started = started || false;
        viewModel.set("started", this.started);

        viewModel.set("withresults", this.WithResults);
        viewModel.set("showhidden", this.ShowHidden);

        this.panelGrid = Ext.create("Ext.panel.Panel", {
            layout: 'fit',
            height: 300,
            width: '100%',
            items: [{
                xtype: 'gridlist',
                showFilter: true,
                itemId: 'shortView',
                columns: [{
                    dataIndex: 'CommandText',
                    text: 'CommandText',
                    flex: 3
                },
                {
                    dataIndex: 'CallingMethodName',
                    text: 'CallingMethodName',
                    flex: 1
                },
                {
                    dataIndex: 'BeginUtcTime',
                    xtype: 'datecolumn',
                    text: 'EndUtcTime',
                    format: 'd.m.Y H:i:s.u',
                    width: 160
                },
                {
                    dataIndex: 'EndUtcTime',
                    xtype: 'datecolumn',
                    text: 'EndUtcTime',
                    format: 'd.m.Y H:i:s.u',
                    width: 160
                },
                {
                    dataIndex: 'Duration',
                    text: 'Duration',
                    width: 50
                }

                ],
                store: Ext.create("Ext.data.Store", {
                    data: []
                }),
                width: '100%',
                readOnly: true,
                listeners: {
                    scope: this,
                    select: this.SelectBlock
                }
            }]
        });

        this.panelText = Ext.create("Ext.panel.Panel", {
            layout: 'fit',
            width: '100%',
            flex: 1,
            items: [{
                xtype: 'uxiframe',
                src: Connection.rsa + "/Viewers/HighLights/index.html",
                itemId: 'textView',
                width: '100%',
                height: '100%'
            }]
        });

        this.panelData = Ext.create("Ext.tab.Panel", {
            layout: 'fit',
            height: 200,
            width: '100%',
            bind: {
                visible: '{withresults}'
            },
            items: [{
                itemId: 'paramsPanel',
                title: 'Параметры',
                html: ''
            }]
        });

        this.container = this.mainPanel.add({
            layout: 'vbox',
            height: '100%',
            border: false,
            defaults: {
                border: false
            },
            tbar: [
                {
                    xtype: 'toolbar',
                    defaults: {
                        scale: 'large'
                    },
                    items: [{
                        iconCls: 'ks-icon-start32',
                        tooltip: 'Запустить трассировку',
                        bind: {
                            disabled: '{started}'
                        },
                        handler: this.Start.bind(this)
                    },
                    {
                        iconCls: 'ks-icon-stop32',
                        tooltip: 'Остановить трассировку',
                        bind: {
                            disabled: '{!started}'
                        },
                        handler: this.Stop.bind(this)
                    },
                        "-",
                        {
                        xtype: 'splitbutton',
                        iconCls: 'ks-icon-save32',
                        tooltip: 'Сохранить',
                        menu: [
                            {
                                text: 'Сохранить как текст',
                                handler: this.SaveText.bind(this)
                            },
                            {
                                text: 'Сохранить результат в XML',
                                handler: this.SaveDataXML.bind(this)
                            }],
                        handler: this.Save.bind(this)
                    },
                    {
                        iconCls: 'ks-icon-folder_export32',
                        tooltip: 'Загрузить',
                    },
                    {
                        iconCls: 'ks-icon-clean32',
                        tooltip: 'Очистить',
                        handler: this.Clear.bind(this)
                    },
                        "-",
                    {
                        iconCls: 'ks-icon-attachment32',
                        itemId: 'btnResults',
                        tooltip: 'Показывать параметры и результаты',
                        enableToggle: true,
                        bind: {
                            pressed: "{withresults}"
                        },
                        handler: this.ToggleResults.bind(this)
                    },
                    {
                        iconCls: 'ks-icon-ghost32',
                        itemId: 'btnHidden',
                        tooltip: 'Показывать скрытые запросы',
                        enableToggle: true,
                        bind: {
                            pressed: "{showhidden}"
                        },
                        handler: this.ToggleResults.bind(this)
                    },
                    {
                        iconCls: 'ks-icon-lock32',
                        itemId: 'btnLock',
                        tooltip: 'Блокировать перемещение курсора',
                        enableToggle: true,
                        handler: this.FreezeCursor.bind(this)
                    },

                        "-",
                    {
                        iconCls: 'ks-icon-heracly32',
                        tooltip: 'Показать полный стек',
                        handler: this.ShowFullStack.bind(this)
                    }
                    ],
                }],
            items: [this.panelGrid, { xtype: 'splitter' }, this.panelText, { xtype: 'splitter' }, this.panelData]
        });

        this.mainPanel.setTitle("");
        this.gridFullView = this.panelText.child("#fullView");
        this.gridShortView = this.panelGrid.child("#shortView");
        //this.mainPanel.on("beforeclose", this.Clean.bind(this));
        this.initialized = true;
        this.Start();
    },
    Refresh: function () {
        if (!this.mainPanel)
            return;

        this.started = true;
        this.ViewModel.set("started", true);

        //AjaxRequest({
        //    url: "/SQLTrace/GetData",
        //    success: this.Show.bind(this),
        //    params: {
        //        init: !this.initialized
        //    }
        //});
    },
    CheckOutputReady: function (rows) {

        if (!this.gridShortView || !this.gridShortView.getStore())
            return false;

        this.frameEl = this.panelText.child().iframeEl;
        if (!this.frameEl)
            return false;

        this.frameDocument = this.frameEl.dom.contentDocument;
        this.frameWindow = this.frameEl.dom.contentWindow;

        this.frameBlock = this.frameDocument.getElementById("traceScript");
        if (!this.frameBlock)
            return false;

        return true;
    },
    SelectBlock: function (grid, record) {
        // ^^ Приходит также с события select ^^
        //------------------------------------//
        // Активируется только на собитии select, иначе много действий.
        if (this.WithResults && grid) {
            var params = [];
            var pvs = record.get('ParameterValues');
            Object.keys(pvs).forEach(function (p) {
                var text = Ext.String.format("{0} = {1} ({2})", p, pvs[p], typeof pvs[p])
                params.push(text);
            });

            this.panelData.removeAll();
            if (params.length > 0) {
                this.panelData.add({
                    itemId: 'paramsPanel',
                    title: 'Параметры',
                    html: params.join("<br>")
                });
            }
            var me = this;
            if (record.data.ReturnedDataSet) {
                var tables = record.data.ReturnedDataSet.Tables;
                tables.forEach(function (table) {
                    var data = DataUtils.GetDataFromTable(table);
                    me.panelData.add({
                        xtype: 'gridlist',
                        showFilter: true,
                        readOnly: true,
                        //forceFit: true,
                        title: table.TableName,
                        columns: DataUtils.GetGridColumnsFromTable(table),
                        store: new Ext.data.Store({ data: data })
                    });
                })
            }
        }

        // Подсветка в HTML фрейме
        if (this.lastSelected)
            this.UnSelectBlock(this.lastSelected)

        var el = this.frameDocument.getElementById(record.id);
        if (el) {
            var att = this.frameDocument.createAttribute("style");
            att.value = "background-color: #ffff80";
            el.setAttributeNode(att);
            el.scrollIntoView();
            this.lastSelected = record;
        }
    },
    UnSelectBlock: function (record) {
        var el = this.frameDocument.getElementById(record.id);
        if (el)
            el.removeAttribute("style");
    },
    SelectRecord: function (record) {
        if (!record)
            return;
        this.gridShortView.getSelectionModel().select(record);
        this.gridShortView.ensureVisible(record);

        this.frameWindow.scrollTo(0, this.frameDocument.body.scrollHeight);

        this.SelectBlock(null, record);
    },
    RenderBlock: function (value, id) {
        //<code class='sql'>SQL CODE</code>
        var textnode = this.frameDocument.createTextNode(value);
        var node = this.frameDocument.createElement("code");
        node.id = id;
        var att = this.frameDocument.createAttribute("class");
        att.value = "sql";
        node.setAttributeNode(att);
        node.appendChild(textnode);
        var block = this.frameBlock.appendChild(node);
        // Highligth
        this.frameWindow.hljs.highlightBlock(block);
    },
    Show: function (rows) {
        // Пришло до старта (включили заранее)
        if (!this.tab) {
            this.StartInit();
        }

        if (!rows || Object.keys(rows).length === 0)
            return;

        if (!this.CheckOutputReady(rows)) {
            if (!IsEmpty(rows))
                Ext.apply(SQLTraceBuffer, rows);

            return;
        }

        if (Object.keys(SQLTraceBuffer).length > 0) {
            rows = Ext.apply(SQLTraceBuffer, rows);
            SQLTraceBuffer = {};
        }

        var storeFull = this.gridShortView.getStore();
        var me = this;
        Object.keys(rows).forEach(function (p) {
            var row = rows[p];
            if (row.EndUtcTime === "0001-01-01T00:00:00") {
                delete rows[p];
                return;
            }
            // Верхний грид
            row.Duration = Date.parse(row.EndUtcTime) - Date.parse(row.BeginUtcTime);
            storeFull.add(row);
            // Полный текст с подсветкой
            var value = me.GetCommentedValue(row);
            me.RenderBlock(value, row.id);
        });

        // Сохраняем все что есть на экране
        Ext.apply(this.SQLTraceCollection, rows);


        if (!this.lockCursor) {
            var record = storeFull.last();
            this.SelectRecord(record);
        }
    },
    GetCommentedValue: function (p) {
        p.CommandText = Replace(p.CommandText, "-->", "\r\n");
        p.CallingMethodSimple = p.CallingMethodName.split("-->")[0];
        p.BeginDate = Ext.Date.format(new Date(Date.parse(p.BeginUtcTime)), "d.m.Y H:i:s.u");

        var tpl = new Ext.Template("-- use [{DataBaseName}]; execute as login='{UserName}'; -- {ServerName} ({BeginDate}) [{CallingMethodSimple}]\r\n{CommandText}");
        var value = tpl.apply(p);

        return value;
    },
    //----------------------------------------- Buttons -----------------------------------//
    StartInit: function () {
        if (!this.mainPanel) {
            this.Init();

            AjaxRequest({
                url: "/SQLTrace/Init",
                success: this.FinishInit.bind(this),
            });
        }

    },
    FinishInit: function (sniffMode) {
        Ext.apply(this, sniffMode);

        if (this.ViewModel) {
            this.ViewModel.set("withresults", this.WithResults);
            this.ViewModel.set("showhidden", this.ShowHidden);
            this.started = this.On;
            this.ViewModel.set("started", this.On);
        }
    },
    Toggle: function () {
        if (this.started) {
            this.Stop()
            this.mainPanel.close();
        }
        else
            this.Start();
    },
    Start: function () {
        if (!this.mainPanel) {
            return this.StartInit();
        }

        AjaxRequest({
            url: "/SQLTrace/Start",
            success: this.Refresh.bind(this),
            params: {
                init: !this.initialized
            }
        });
    },
    Stop: function () {
        AjaxRequest({
            url: "/SQLTrace/Stop",
            mask: { text: "Остановка", id: this.mainPanel },
            scope: this,
            success: function () {
                if (!this || !this.mainPanel || this.mainPanel.destroyed)
                    return

                this.started = false;
                this.ViewModel.set("started", false);
            }
        });
    },
    Clear: function () {
        this.gridShortView.getStore().removeAll();
        this.frameBlock.innerHTML = "";
        this.SQLTraceCollection = {};
        this.lastSelected = null;
        this.panelData.removeAll();
    },
    ShowFullStack: function () {
        var selection = this.gridShortView.getSelectionModel().getSelected();
        if (!selection || selection.length === 0)
            return;
        var text = Replace(selection.items[0].get("CallingMethodName"), "-->", "<br>");
        ExtUtils.ShowText(text);
    },
    FreezeCursor: function () {
        var btn = this.container.down("#btnLock");
        this.lockCursor = btn.pressed;
    },
    Save: function () {
        FileUtils.DownloadFile("/SQLTrace/Save/", { traceJson: JSON.stringify(this.SQLTraceCollection), fileName: guid() + ".trace" }, null, true, true, FileUtils.SaveBlob, "blob");
    },
    SaveDataXML: function () {
        var selection = this.gridShortView.getSelectionModel().getSelected();
        if (!selection || selection.length === 0)
            return;
        var qn = selection.items[0].get("QueryNumber");

        var dataForSave = { 0: this.SQLTraceCollection[qn] };
        if (!dataForSave[0].ReturnedDataSet)
            return ExtAlert('Данных для запроса нет');

        FileUtils.DownloadFile("/SQLTrace/Save/", { traceJson: JSON.stringify(dataForSave), xml: true, fileName: guid() + ".xml" }, null, true, true, FileUtils.SaveBlob, "blob");
    },
    SaveText: function () {
        var output = [];
        var me = this;
        Object.values(this.SQLTraceCollection).forEach(function (p) {
            // Полный текст с подсветкой
            var value = me.GetCommentedValue(p);
            output.push(value);
        });
        FileUtils.SaveText(output.join("\r\n"), guid() + ".sql");
    },
    ToggleResults: function () {
        var btn = this.container.down("#btnResults");
        this.WithResults = btn.pressed;
        btn = this.container.down("#btnHidden");
        this.ShowHidden = btn.pressed;

        AjaxRequest({
            url: "/SQLTrace/Reconfigure",
            mask: { text: "Реконфигурация", id: this.mainPanel },
            success: this.FinishInit.bind(this),
            params: {
                showResults: this.WithResults || false,
                showHidden: this.ShowHidden || false
            }
        });
    }
});