﻿// Режим админского подключения
//-----------------------------------------------------------------------------------------------------//
Ext.define('Admin.LoginAdmin', {
    constructor: function () {
        this.Launch();
    },

    privates: {
        ParseLoginParamsString: function (field, e) {
            var me = this,
                form = me.LoginDBForm,
                string = e.getClipboardData();

            if (!string) return;

            var usernameField = form.down('[name= login]'),
                dbTypeField = form.down('[name= dbType]'),
                dbServerField = form.down('[name= dbServer]'),
                dbNameField = form.down('[name= dbName]'),
                regExpDbType = new RegExp(/^\s*(\w{2})\s*:/i),
                regExpDbParams = new RegExp(/[\w\d]*[\\]{1}[\w\d]*[\.]{1}[\w\d]*/i),
                regExpUsername = new RegExp(/-{1}\s*(\w*)\s*/i),
                dbType = string.match(regExpDbType),
                dbParams = string.match(regExpDbParams),
                username = string.match(regExpUsername);

            username && username[1] && usernameField.setValue(username[1]);

            if (dbParams && dbParams[0]) {
                dbParams = dbParams[0].split('.');
                if (dbParams[0] && dbParams[1]) {
                    dbNameField.setValue(dbParams[1]);
                    dbServerField.setValue(dbParams[0]);
                }
            }

            if (dbType && dbType[1]) {
                dbType = this.dbTypeData.find(function (rec) {
                    return rec.description === dbType[1];
                });
                dbType && dbType.value && dbTypeField.setValue(dbType.value);
            }

            if (!username && !dbParams && !dbType) {
                var value = field.getValue(),
                    start = event.target.selectionStart || 0,
                    end = event.target.selectionEnd || value.length;

                value = value.toString().split('');
                value.splice(start, end - start, string);
                value = value.join('');
                field.setValue(value);
            }
        }
    }, 

    Launch: function() {
        var _this = this;
        var profileDefault = AjaxRequest({
            url: '/Login/GetAdminProfile',
            async: false
        });
        this.connection = profileDefault;
        if (!profileDefault)
            return ExtAlert('Доступ запрещен');

        this.dbTypeData = [
            {
                value: 0,
                name: 'MSSQL',
                description: 'ms'
            },
            {
                value: 1,
                name: 'Oracle',
                description: 'or'
            },
            {
                value: 2,
                name: 'SQLite',
                description: 'sl'
            },
            {
                value: 3,
                name: 'PostgreSQL',
                description: 'pg'
            }
        ];

        var storeProfile = Ext.create('Ext.data.Store', {
            data: profileDefault
        });
        var rememberMeHandler = function(code) {
            if (code === 'void') {
                this.up().child('#spf').disable();
                this.up().child('#spf').setValue(false);
            } else
                this.up().child('#spf').enable();
        };

        var textfieldPastHandler = function (field, e) {
            _this.ParseLoginParamsString(field, e);
            e.preventDefault();
        };

        this.LoginDBForm = Ext.create('Ext.form.Panel', {
            xtype: 'form',
            reference: 'form',
            title: 'Вход в комплекс',
            layout: 'anchor',
            bodyPadding: 8,
            referenceHolder: true,
            defaultFocus: '#login',
            defaultButton: 'LoginButton',
            defaultType: 'textfield',
            defaults: {
                anchor: '-2',
                height: 22,
                labelWidth: 100
            },
            items: [
                {
                    fieldLabel: 'Профиль',
                    xtype: 'combo',
                    name: 'profile',
                    displayField: 'profile',
                    valueField: 'code',
                    queryMode: 'local',
                    typeAhead: true,
                    store: storeProfile,
                    listeners: {
                        select: function(me, rec) {
                            rememberMeHandler.call(this, rec.get('code'));
                            this.suspendEvents();
                            rec.set('saveProfile', false);
                            _this.LoginDBForm.getForm().setValues(rec.data);
                            this.resumeEvents();
                        },
                        change: function(me, code) {
                            rememberMeHandler.call(this, code);
                        }
                    }
                },
                {
                    hideEmptyLabel: false,
                    boxLabel: 'Сохранить профиль',
                    xtype: 'checkbox',
                    itemId: 'spf',
                    name: 'saveProfile',
                    value: false
                },
                {
                    xtype: 'label',
                    html: '<hr/>'
                },
                {
                    fieldLabel: 'Логин',
                    allowBlank: false,
                    name: 'login',
                    enableKeyEvents: true,
                    listeners: {
                        paste: textfieldPastHandler
                    }
                },
                {
                    fieldLabel: 'Пароль',
                    name: 'password',
                    inputType: 'password',
                    enableKeyEvents: true,
                    listeners: {
                        paste: textfieldPastHandler
                    }
                },
                {
                    fieldLabel: 'Тип СУБД',
                    name: 'dbType',
                    allowBlank: false,
                    xtype: 'combo',
                    editable: false,
                    valueField: 'value',
                    displayField: 'name',
                    store: {
                        data: this.dbTypeData
                    }
                },
                {
                        
                    fieldLabel: 'Сервер',
                    name: 'dbServer',
                    enableKeyEvents: true,
                    allowBlank: false,
                    listeners: {
                        paste: textfieldPastHandler
                    }

                },
                {
                    fieldLabel: 'База данных',
                    name: 'dbName',
                    enableKeyEvents: true,
                    allowBlank: false,
                    listeners: {
                        paste: textfieldPastHandler
                    }
                }
            ],
            buttons: [{
                reference: 'LoginButton',
                text: 'Вход',
                formBind: true,
                listeners: {
                    click: this.LoginDB.bind(this)
                }
            }]
        });

        this.LoginCPForm = Ext.create('Ext.form.Panel', {
            xtype: 'form',
            title: 'Конфигуратор',
            layout: 'anchor',
            bodyPadding: 8,
            referenceHolder: true,
            defaultFocus: '#login',
            defaultButton: 'LoginCPButton',
            defaultType: 'textfield',
            defaults: {
                anchor: '-2',
                height: 22,
                labelWidth: 70
            },
            items: [
                {
                    fieldLabel: 'Логин',
                    reference: 'form',
                    name: 'login',
                    allowBlank: false
                },
                {
                    fieldLabel: 'Пароль',
                    name: 'password',
                    inputType: 'password',
                    allowBlank: false
                }
            ],
            buttons: [{
                text: 'Вход',
                reference: 'LoginCPButton',
                formBind: true,
                listeners: {
                    click: this.LoginCP.bind(this)
                }
            }]
        });
        var logo = LoginManager.GetLogoPanel();
        var panel = {
            xtype: 'panel',
            tbar: logo,
            items: Ext.create('Ext.tab.Panel',
                {
                    items: [this.LoginDBForm, this.LoginCPForm]
                })
        };

        LoginManager.win = Ext.create('Ext.window.Window',
            {
                autoShow: true,
                closable: false,
                layout: 'fit',
                width: 370,
                title: 'Административный режим входа',
                items: panel
            });

        var profList = LocalStorage.list('kso_login_profile_');
        if (profList && profList.length > 0) {
            var combo = this.LoginDBForm.getForm().findField('profile');
            var store = combo.getStore();
            profList.forEach(function(profName) {
                var profile = LocalStorage.get(profName);
                if (profile) {
                    profile.code = profName;
                    store.insert(0, profile);
                }
            });
        }


        var lastLogin = LocalStorage.get('LastAdminLoginData');
        // Последний вход либо дефолт.
        if (lastLogin) {
            lastLogin.profile = '';
            this.LoginDBForm.getForm().setValues(lastLogin);
        } else
            this.LoginDBForm.getForm().setValues(profileDefault);
    },
    LoginDB: function(me) {
        if (arguments[1] && arguments[1].target.name == 'profile') {
            this.LoginDBForm.getForm().findField('password').focus();
            return false;
        }
        var form = me.up('form').getForm();
        var opt = form.getValues();
        var sf = form.findField('saveProfile').getValue();
        opt.profile = form.findField('profile').getRawValue();
        if (sf && Ext.isEmpty(opt.profile))
            return ExtAlert('Необходимо ввести имя профиля!');
        if (sf && !Ext.isEmpty(opt.profile) && opt.profile != '*web.config') {
            LocalStorage.set('kso_login_profile_' + opt.profile, opt);
        }
        opt.profile = '';
        opt.saveProfile = false;
        LocalStorage.set('LastAdminLoginData', opt);

        opt.rsa = Connection.rsa;

        AjaxRequest({
            url: '/Login/FormAdminLogin',
            mask: {text: 'Авторизация', id: this.LoginDBForm},
            success: LoginManager.ProcessLoginRequest.bind(LoginManager),
            params: opt
        });
    },
    LoginCP: function(me) {
        var form = me.up('form').getForm();
        var opt = form.getValues();
        AjaxRequest({
            url: '/CPanel/FormAdminCPLogin',
            mask: {text: 'Анализ данных', id: this.LoginCPForm},
            success: this.CPanel.bind(this),
            params: opt
        });

    },
    CPanel: function(params) {
        if (!params)
            return ExtAlert('#err#Нет доступа');
        this.CPanelData = params;
        LoginManager.win.close();

        var logo = LoginManager.GetLogoPanel();
        logo.add({
            xtype: 'button',
            scale: 'large',
            y: 25,
                
            border: 0,
            style: {
                backgroundColor: 'white',
                right: '10px'
            },
            width: 48,
            height: 48,
            cls: 'ks-icon-exit48',
            iconCls: 'ks-icon-exit48',
            tooltip: 'Выход',
            handler: this.CPanelExit.bind(this)
        });

        var panel = {
            xtype: 'panel',
            layout: 'fit',
            tbar: logo,
            items: Ext.create('Ext.tab.Panel',
                {
                    layout: 'fit',
                    items: [
                        this.CPanelInfo(params),
                        this.CPanelSettings(params),
                        this.CPanelOthers(params),
                        this.CPanelMessaging(params),
                        this.CPanelNews(params),
                        this.CPanelPermission(params)
                    ]
                })
        };
        this.CPWin = Ext.create('Ext.window.Window',
            {
                autoShow: true,
                closable: false,
                maximizable: true,
                layout: 'fit',
                width: 1000,
                height: 650,
                title: 'Контрольная панель',
                items: panel
            });

        this.FormInfo = this.CPWin.down('#info').getForm();
        this.FormInfo.setValues(this.GetSettingsParams(params.config, this.FormInfo));
        this.FormConfig = this.CPWin.down('#config').getForm();
        var miscSettings = this.GetSettingsParams(params.config, this.FormConfig);
        this.FormConfig.setValues(miscSettings);
        this.FormMessage = this.CPWin.down('#messaging').getForm();
        var messSettings = this.GetSettingsParams(params.config, this.FormMessage);
        this.FormNews = this.CPWin.down('#news').getForm();
        var newsSettings = this.GetSettingsParams(params.config, this.FormNews);
        this.FormNews.setValues(newsSettings);
        this.FormPerm = this.CPWin.down('#permission').getForm();
        this.FormPerm.setValues(this.GetSettingsParams(params.config, this.FormPerm));
            
        this.CPWin.down('#miscConfig').setSource(this.GetSource(params.config));

        // Новости
        if (!Ext.isEmpty(newsSettings.DbNewsAccount))
            this.BindNews.apply(this);
            // Уведомления
        if (!Ext.isEmpty(messSettings.WarningMessageFile))
            this.BindMessages.apply(this);

    },
    CPanelExit: function() {
        AjaxRequest({
            url: '/CPanel/FormAdminCPLogout',
            async: false
        });
        document.location.reload();
    },
    // Новости
    BindNews: function(mask) {
        AjaxRequest({
            url: '/Login/GetNews',
            mask: mask ? {text: 'Загрузка', id: this.CPWin.down('#gridnews') } : null,
            success: this.ShowNews.bind(this)
        });
    },
    ShowNews: function(res) {
        var store = Ext.create('Ext.data.Store',
            {
                data: res,
                sorters: [{
                    property: 'Date',
                    direction: 'DESC'
                }]
            });
        this.CPWin.down('#gridnews').setStore(store);
    },
    // Уведомления
    BindMessages: function(value) {
        //GetLoginInfoText
        AjaxRequest({
            url: '/CPanel/GetLoginInfoText',
            mask: value ? {text: 'Загрузка', id: this.CPWin.down('#messaging') } : null,
            success: this.ShowMessages.bind(this, value)
        });
    },
    ShowMessages: function(v, res) {
        if (res.length === void 0) {
            if (v)
                ExtAlert('Файл уведомлений записан в неверном формате. Удалите содержимое, чтобы работать с ним через панель');
            return;
        }

        var store = Ext.create('Ext.data.Store',
            {
                data: res,
                sorters: [
                    {
                        property: 'dateBegin',
                        direction: 'ASC'
                    },
                    {
                        property: 'dateEnd',
                        direction: 'ASC'
                    }
                ]
            });
        var grid = this.CPWin.down('#gridmess');
        grid.setStore(store);
        //var htmleditor = this.CPWin.down("#messEditor");
        //grid.on("rowclick", function(me, record) {
        //    htmleditor.setValue(record.get("html"));
        //});
    },

    CPanelInfo: function(params) {
        return Ext.create('Ext.form.Panel', {
            xtype: 'form',
            title: 'Информация',
            itemId: 'info',
            defaults: {
                xtype: 'panel',
                layout: 'anchor',
                bodyPadding: 10,
                defaultType: 'displayfield'
            },
            buttons: [{
                text: 'Сохранить',
                listeners: {
                    click: this.InfoSave.bind(this)
                }
            }],
            items: [
                {
                    defaults: {
                        labelWidth: 100
                    },
                    title: 'Информация о сервере',
                    items: [
                        {
                            fieldLabel: 'OS',
                            value: Connection.Info.OS.Name
                        },
                        {
                            fieldLabel: 'Platform',
                            value: Connection.Info.OS.Platform
                        },
                        {
                            fieldLabel: 'Webserver',
                            value: params.WebServer
                        }
                    ]
                },
                {
                    defaults: {
                        labelWidth: 250
                    },
                    title: 'Информация о приложении',
                    items: [
                        {
                            fieldLabel: 'Наименование',
                            value: Connection.Info.AppName
                        },
                        {
                            fieldLabel: 'Размещение',
                            value: params.PhisPath
                        },
                        {
                            fieldLabel: 'Версия клиента',
                            value: Connection.Info.Version //+ " " + "<a onclick='Ext.create(\"Admin.UpdateManager\")'>Проверить обновления</a>"
                        },
                        {
                            xtype: 'combo',
                            fieldLabel: 'Протокол работы',
                            editable: false,
                            valueField: 'value',
                            displayField: 'text',
                            store: [
                                {
                                    value: 'JQuery',
                                    text: 'JQuery (медленно)'
                                },
                                {
                                    value: 'SignalR',
                                    text: 'SignalR (быстро)'
                                }
                            ],
                            name: 'ConnectionType'

                            //value: Connection.connectionType
                        },
                        {
                            xtype: 'combo',
                            editable: false,
                            valueField: 'value',
                            displayField: 'text',
                            store: [
                                {
                                    value: 'on',
                                    text: 'Включен'
                                },
                                {
                                    value: 'off',
                                    text: 'Выключен'
                                },
                                {
                                    value: 'system',
                                    text: 'Системный'
                                }],
                            fieldLabel: 'Перехват ошибок',
                            name: 'debugState'
                        }

                    ]
                }
                //{
                //    defaults: {
                //        labelWidth: 150
                //    },
                //    title: "Информация о подключении к СУБД",
                //    items: [
                //        {
                //            fieldLabel: "Тип подключения",
                //            value: this.dbTypeData.find(function(rec) {
                //                return rec.value == this.connection.dbType;
                //            }.bind(this)).name
                //        },
                //        {
                //            fieldLabel: "Сервер",
                //            value: this.connection.dbServer
                //        },
                //        {
                //            fieldLabel: "База данных",
                //            value: this.connection.dbName
                //        }
                //    ]
                //}
            ]
        });
    },
    CPanelSettings: function() {
            
        return Ext.create('Ext.form.Panel',
            {
                xtype: 'form',
                itemId: 'config',
                title: 'Конфигурация приложения',
                height: '100%',
                width: '100%',
                layout: 'vbox',
                defaults: {
                    xtype: 'panel',
                    layout: 'column',
                    width: '100%'
                },
                buttons: [{
                    reference: 'SaveButton',
                    text: 'Сохранить',
                    formBind: true,
                    listeners: {
                        click: this.SettingsSave.bind(this)
                    }
                }],
                items: [
                    {
                        defaults: {
                            bodyPadding: 4,
                            layout: 'anchor',
                            defaultType: 'textfield',
                            height: 220,
                            columnWidth: 0.333333333,
                            margin: 2
                        },
                        items: [
                            {
                                title: 'Настройки БД',
                                defaults: {
                                    labelWidth: 100
                                },
                                items: [
                                    {
                                        fieldLabel: 'Тип',
                                        xtype: 'combo',
                                        editable: false,
                                        valueField: 'value',
                                        displayField: 'name',
                                        store: {
                                            data: this.dbTypeData
                                        },
                                        name: 'DataSourceType'
                                    },
                                    {
                                        fieldLabel: 'Сервер',
                                        name: 'Server'
                                    },
                                    {
                                        fieldLabel: 'База данных',
                                        name: 'DataBase'
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Время ожидания ответа СУБД (сек)',
                                        height: 80,
                                        defaults: {
                                            labelWidth: 100,
                                            anchor: '100%'
                                        },
                                        items: [
                                            {
                                                fieldLabel: 'Cоединение',
                                                name: 'ConnectionTimeout',
                                                xtype: 'numberfield'
                                            },
                                            {
                                                fieldLabel: 'Выполнение',
                                                xtype: 'numberfield',
                                                name: 'CommandTimeout'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                   
                                title: 'Авторизация',
                                itemId: 'authConfigMain',
                                defaults: {
                                    labelWidth: 100,
                                    anchor: '100%'
                                },
                                items: [
                                    {
                                        fieldLabel: 'Тип',
                                        xtype: 'combo',
                                        //height: 40,
                                        editable: false,
                                        valueField: 'value',
                                        displayField: 'text',
                                        matchFieldWidth: false,
                                        store: this.GetConnectionTypeStore(),
                                        name: 'AuthorizationType'
                                    },
                                    {
                                        fieldLabel: 'Сервис авторизации',
                                        name: 'AuthorizationService'
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Менеджер авторизации',
                                        height: 80,
                                        defaultType: 'textfield',
                                        defaults: {
                                            labelWidth: 100,
                                            anchor: '100%'
                                        },
                                        items: [
                                            {
                                                fieldLabel: 'Логин',
                                                name: 'AuthorizationAccountLogin'
                                            },
                                            {
                                                fieldLabel: 'Пароль',
                                                inputType: 'password',
                                                name: 'AuthorizationAccountPassword'
                                            }
                                        ]
                                    }
                                ]
                            },
                            this.CPanelAuthConfig()
                        ]
                    },
                    {
                        title: 'Различные учетные данные',
                        flex: 1,
                        defaultType: 'fieldset',
                        defaults: {
                            height: 190,
                            layout: 'anchor',
                            columnWidth: 0.33333333,
                            margin: 2
                        },
                        items: [
                            {
                                title: 'Почтовый работ',
                                defaultType: 'textfield',
                                defaults: {
                                    anchor: '100%',
                                    labelWidth: 100
                                },
                                items: [
                                    {
                                        xtype: 'displayfield',
                                        value: 'Используется для рассылки уведомлений на почту комплекса'
                                    },
                                    {
                                        xtype: 'label',
                                        html: '<hr>'
                                    },
                                    {
                                        fieldLabel: 'Логин',
                                        name: 'DbMailingAccountLogin'
                                    },
                                    {
                                        fieldLabel: 'Пароль',
                                        inputType: 'password',
                                        name: 'DbMailingAccountPassword'
                                    }
                                ]
                            },
                            {
                                title: 'Центр управления бизнес-процессами',
                                defaultType: 'textfield',
                                defaults: {
                                    anchor: '100%',
                                    labelWidth: 100
                                },
                                items: [
                                    {
                                        xtype: 'displayfield',
                                        value: 'Используется для подключения к базе данных с сервиса ЦУБП.'
                                    },
                                    {
                                        xtype: 'label',
                                        html: '<hr>'
                                    },
                                    {
                                        fieldLabel: 'Логин',
                                        name: 'BPMSAccountLogin'
                                    },
                                    {
                                        fieldLabel: 'Пароль',
                                        inputType: 'password',
                                        name: 'BPMSAccountPassword'
                                    }
                                ]
                            },

                        ]
                    }
                ]
            });

    },
    CPanelAuthConfig: function() {
        return Ext.create('Ext.panel.Panel',
            {
                //                    xtype: 'form',
                title: 'Настройки входа',
                itemId: 'authConfigUser',
                flex: 1,
                margin: 2,
                defaults: {
                    labelWidth: 150,
                    anchor: '100%',
                    //hideEmptyLabel: false
                },
                bodyPadding: 10,
                layout: 'anchor',
                defaultType: 'textfield',
                items: [
                    {
                        fieldLabel: 'Ограничить число неправильных вводов пароля',
                        name: 'LoginAttemptsNumber',
                        xtype: 'numberfield'
                    },
                    {
                        fieldLabel: 'Время блокировки IP',
                        name: 'LoginLockPeriod',
                        xtype: 'numberfield'
                    },
                    {
                        boxLabel: 'Уведомить администратора о блокировке',
                        name: 'LoginLockNotify',
                        xtype: 'checkbox',
                        value: 'false',
                        inputValue: 'true',
                        uncheckedValue: 'false'                        },
                    {
                        boxLabel: 'Разрешать пользователю сбрасывать пароль',
                        name: 'AllowRecoveryPassword',
                        xtype: 'checkbox',
                        value: 'false',
                        inputValue: 'true',
                        uncheckedValue: 'false'
                    }
                ]
            });
    },
    CPanelOthers: function(params) {
        return Ext.create('Ext.panel.Panel',
            {
                title: 'Прочее',
                flex: 1,
                border: false,
                layout: 'fit',
                buttons: [{
                    text: 'Сохранить',
                    listeners: {
                        click: this.PropsSave.bind(this)
                    }
                }],
                tbar: [
                    {
                        xtype: 'label',
                        padding: 4,
                        width: '100%',
                        cls: 'login-message-warning',
                        html: 'Внимание! Крайне не рекомендуется самостоятельно изменять параметры в этой секции. Необходимо точно знать что вы делаете и каков будет результат!'
                    }],
                items: [
                    {
                        xtype: 'propertygrid',
                        flex: 1,
                        itemId: 'miscConfig',
                        nameColumnWidth: 550,
                        sourceConfig: this.GetSourceConfig(params.config)
                    }
                ]
            });
    },
    CPanelMessaging: function(params) {
        return Ext.create('Ext.form.Panel',
            {
                xtype: 'form',
                height: '100%',
                layout: 'fit',
                itemId: 'messaging',
                referenceHolder: true,
                title: 'Уведомления на странице логина',
                viewModel: {
                    stores: {
                        customers: {

                        }
                    }
                },
                buttons: [{
                    text: 'Сохранить',
                    listeners: {
                        click: this.MessSave.bind(this)
                    }
                }],
                items: [
                    {
                        xtype: 'panel',
                        bodyPadding: 10,
                        layout: 'anchor',
                        defaultType: 'textfield',
                        defaults: {
                            labelWidth: 200,
                            anchor: '100%'
                        },
                        items: [
                            {
                                fieldLabel: 'Файл уведомления',
                                name: 'WarningMessageFile',
                                value: params.config.find(function (rec) {return rec.key === 'WarningMessageFile';}).value,
                                triggers: {
                                    refresh: {
                                        cls: 'ks-icon-refresh',
                                        handler: this.BindMessages.bind(this)
                                    }
                                }
                            },
                            {
                                xtype: 'label',
                                html: '<hr>'
                            },
                            {
                                xtype: 'grid',
                                itemId: 'gridmess',
                                reference: 'messages',
                                height: 160,
                                tbar: [
                                    {
                                        iconCls: 'ks-icon-new',
                                        handler: this.MessAdd.bind(this)
                                    },
                                    {
                                        iconCls: 'ks-icon-delete',
                                        handler: this.MessDelete.bind(this)
                                    }
                                ],
                                viewConfig: {
                                    stripeRows: false,
                                    getRowClass: function(record, index) {
                                        var date1 = record.get('dateBegin');
                                        var date2 = record.get('dateEnd');
                                        if (date1 == null && date2 == null)
                                            return 'login-admin-row-always';
                                        if (new Date(date1) > new Date()) {
                                            return 'login-admin-row-before';
                                        }
                                        if (date2 == null)
                                            return 'login-admin-row-always';
                                        if (new Date(date2) < new Date()) {
                                            return 'login-admin-row-after';
                                        }
                                    }
                                },
                                columns: {
                                    items: [
                                        {
                                            xtype: 'actioncolumn',
                                            hideable: false,
                                            draggable: false,
                                            sortable: false,
                                            menuDisabled: true,
                                            width: 40,
                                            items: [
                                                {
                                                    getClass: function(value) {
                                                        return value == 'warning'
                                                            ? 'ks-icon-attention'
                                                            : 'ks-icon-notification';
                                                    }
                                                }
                                            ],
                                            text: 'Тип',
                                            tooltip: 'Тип',
                                            dataIndex: 'type'
                                        },
                                        {
                                            text: 'Дата начала',
                                            width: 150,
                                            dataIndex: 'dateBegin',
                                            xtype: 'datecolumn',
                                            format: 'd.m.Y H:i:s'
                                        },
                                        {
                                            text: 'Дата окончания',
                                            width: 150,
                                            dataIndex: 'dateEnd',
                                            xtype: 'datecolumn',
                                            format: 'd.m.Y H:i:s'
                                        },
                                        {
                                            text: 'Текст',
                                            flex: 1,
                                            renderer: function(value, metaData, record) {
                                                return value ? value.replace(/<(?:.|\n)*?>/gm, '') : '';
                                            },
                                            dataIndex: 'html'
                                        }
                                    ]
                                }
                            },
                            {
                                xtype: 'fieldset',
                                title: 'Уведомление',
                                anchor: '100%',
                                height: 50,
                                layout: 'column',
                                defaultType: 'datetimefield',
                                defaults: {
                                    labelWidth: 120,
                                    margin: '0 5 0 5',
                                    format: 'd.m.Y H:i:s',
                                    // 2018-04-19T14:35:27+03:00
                                    altFormats: 'Y-m-d\\TH:i:sP'
                                },
                                items: [
                                    {
                                        xtype: 'combo',
                                        columnWidth: 0.3,
                                        fieldLabel: 'Тип',
                                        valueField: 'value',
                                        displayField: 'text',
                                        store: {
                                            data: [
                                                {
                                                    value: 'warning',
                                                    text: 'Предупреждение'
                                                },
                                                {
                                                    value: 'info',
                                                    text: 'Информация'
                                                }]
                                        },
                                        bind: {
                                            value: '{messages.selection.type}'
                                        }
                                    },
                                    {
                                        columnWidth: 0.3,
                                        fieldLabel: 'Дата начала',
                                        bind: {
                                            value: '{messages.selection.dateBegin}'
                                        }
                                    },
                                    {
                                        columnWidth: 0.3,
                                        fieldLabel: 'Дата окончания',
                                        bind: {
                                            value: '{messages.selection.dateEnd}'
                                        }
                                    }]
                            },
                            {
                                xtype: 'htmleditor',
                                itemId: 'messEditor',
                                flex: 1,
                                enableFont: false,
                                anchor: '100% -250',
                                bind: {
                                    value: '{messages.selection.html}'
                                }
                            }
                        ]
                    }]
            });
    },
    CPanelNews: function(params) {
        return Ext.create('Ext.form.Panel',
            {
                xtype: 'form',
                bodyPadding: 2,
                height: '100%',
                width: '100%',
                layout: 'vbox',
                itemId: 'news',
                title: 'Новости на странице логина',
                items: [
                    {
                        xtype: 'fieldset',
                        title: 'Данные для подключения',
                        bodyPadding: 10,
                        layout: 'anchor',
                        defaultType: 'textfield',
                        defaults: {
                            labelWidth: 200,
                            anchor: '100%'
                        },
                        items: [
                            {
                                fieldLabel: 'Пользователь',
                                name: 'DbNewsAccount'
                            },
                            {
                                fieldLabel: 'Пароль ',
                                inputType: 'password',
                                name: 'DbNewsPassword'
                            },
                            {
                                xtype: 'button',
                                text: 'Сохранить и подключиться',
                                margin: '0 0 5 0',
                                dock: 'right',
                                listeners: {
                                    click: this.NewsSave.bind(this)
                                }
                            }]
                    },
                    {
                        xtype: 'grid',
                        itemId: 'gridnews',
                        width: '100%',
                        flex: 1,
                        listeners: {
                            itemdblclick: this.NewsEdit.bind(this)
                        },
                        columns: {
                            items: [
                                {
                                    text: 'Дата',
                                    width: 150,
                                    dataIndex: 'Date',
                                    xtype:'datecolumn', 
                                    format:'d.m.Y H:i:s'
                                },
                                {
                                    xtype: 'actioncolumn',
                                    hideable: false,
                                    draggable: false,
                                    sortable: false,
                                    menuDisabled: true,
                                    width: 40,
                                    items: [
                                        {
                                            getClass: function(value, metadata, record) {
                                                return value == 2 ? 'ks-icon-attention' : '';
                                            }
                                        }
                                    ],
                                    text: 'Важность',
                                    tooltip: 'Важность',
                                    dataIndex: 'State'
                                },
                                {
                                    text: 'Тема',
                                    width: 250,
                                    dataIndex: 'Theme'
                                },
                                {
                                    text: 'Текст',
                                    width: 530,
                                    dataIndex: 'Body'
                                }
                                    
                            ]
                        },
                        tbar: [
                            {
                                iconCls: 'ks-icon-new',
                                handler: this.NewsAdd.bind(this)
                            },
                            {
                                iconCls: 'ks-icon-edit',
                                handler: this.NewsEdit.bind(this)
                            },
                            {
                                iconCls: 'ks-icon-delete',
                                handler: this.NewsDelete.bind(this)
                            }, '-',
                            {
                                iconCls: 'ks-icon-refresh',
                                handler: this.BindNews.bind(this)
                            }
                        ]
                    }]
            });
    },
    CPanelPermission: function() {
        return Ext.create('Ext.form.Panel',
            {
                xtype: 'form',
                height: '100%',
                itemId: 'permission',
                title: 'Доступ к панели',
                bodyPadding: 10,
                layout: 'anchor',
                defaultType: 'textfield',
                defaults: {
                    labelWidth: 200,
                    anchor: '100%'
                },
                buttons: [{
                    text: 'Сохранить',
                    listeners: {
                        click: this.PermSave.bind(this)
                    }
                }],
                items: [
                    {
                        fieldLabel: 'Логин',
                        name: 'AdminCPLogin'
                    },
                    {
                        fieldLabel: 'Пароль',
                        inputType: 'password',
                        name: 'AdminCPPassword'
                    },
                    {
                        fieldLabel: 'Разрешенные IP',
                        name: 'AdminCPAllowedIP'
                    }
                ]
            });
    },

    Save: function(mode, data) {
        var panel = this.CPWin.down(mode);
        if (!panel) return;

        if (!data) {
            var form = panel.getForm();
            if (!form) return;
            data = form.getValues();
        }

        AjaxRequest({
            url: '/CPanel/Save',
            mask: {text: 'Сохранение', id: panel },
            params: {
                key: this.CPanelData.key,
                data: data
            },
            success: this.SaveComplete.bind(this)
        });
    },

    InfoSave: function() {
        this.Save.call(this, '#info');
    },
    SettingsSave: function() {
        this.Save.call(this, '#config');
    },
    PermSave: function() {
        this.Save.call(this, '#permission');
    },
    PropsSave: function() {
        var grid = this.CPWin.down('#miscConfig');
        var store = grid.getStore();
        var data = store.source;
        this.Save.call(this, '#miscConfig', data);
    },
        
    NewsSave: function() {
        var data = this.FormNews.getValues();
            
        AjaxRequest({
            url: '/CPanel/Save',
            mask: {text: 'Сохранение', id: this.CPWin.down('#news') },
            params: {
                key: this.CPanelData.key,
                data: data
            },
            success: this.BindNews.bind(this)
        });
    },
    NewsAdd: function () {
        this.MailNews = Ext.create('Meta.Mail.FormMessage', {
            modal: true,
            autoShow: true
        });
        this.MailNews.SendButton.setHandler(this.NewsSend.bind(this));
        this.MailNews.SendButton.setDisabled(false);
        this.MailNews.To.getStore().add({
            DefaultName: this.GetSettingsParams(this.CPanelData.config, this.FormNews).DbNewsAccount, 
            UID: '0'
        });
        this.MailNews.To.setValue(['0']);
        this.MailNews.down('#toBtn').setHandler(null);
        //this.MailNews.show();
    },
    NewsEdit: function () {
        this.NewsAdd();
            
        var grid = this.CPWin.down('#gridnews');
        var sel = grid.getSelectionModel().getSelected().items;
        if (!sel || sel.length === 0)
            return ExtAlert('Не выбрана запись!');

        this.MailNews.SendButton.setHandler(this.NewsSend.bind(this));

        AjaxRequest({
            url: '/CPanel/GetMailData',
            mask: {text: 'Получение данных', id: this.MailNews },
            params: {
                key: this.CPanelData.key,
                id: sel[0].get('ID')
            },
            success: this.NewsEditData.bind(this)
        });

    },
    NewsEditData: function (data) {
        var me = this.MailNews;
        me.SendButton.setText('Сохранить');
        me.Theme.setValue(data.Theme);
        me.Message.setValue(data.TextBody);
        me.initState(data.State);
        me.MessageId = data.ID;
        data.AttachedFiles.forEach(function (rec) {
            me.UploadFilesStore.add(rec);
        });
    },
    NewsSend: function () {
        var me = this.MailNews;
        var files = [];
        me.UploadFilesStore.each(function (record) {
            if (record.data.uploadName)
                files.push(record.data.uploadName);
        });

        AjaxRequest({
            url: '/CPanel/SendNews',
            mask: {text: 'Отправка', id: this.CPWin.down('#news') },
            params: {
                key: this.CPanelData.key,
                id: me.MessageId || -1,
                theme: me.Theme.getValue(),
                body: me.Message.getValue(),
                state: me.State,
                sendtokey: '0',
                sendtovalue: this.GetSettingsParams(this.CPanelData.config, this.FormNews).DbNewsAccount,
                files: files
            },
            success: this.BindNews.bind(this)
        });
        me.close();
    },
    NewsDelete: function () {
        var grid = this.CPWin.down('#gridnews');
        var sel = grid.getSelectionModel().getSelected().items;
        if (!sel || sel.length === 0)
            return ExtAlert('Не выбрана запись!');
            
        AjaxRequest({
            url: '/CPanel/DeleteMail',
            mask: {text: 'Удаление', id: this.CPWin.down('#news') },
            params: {
                key: this.CPanelData.key,
                id: sel[0].get('ID'),
                type: sel[0].get('Type')
            },
            success: this.BindNews.bind(this)
        });
    },


    MessDelete: function() {
        var grid = this.CPWin.down('#gridmess');
        var sel = grid.getSelectionModel().getSelected();
        if (!sel || sel.length == 0)
            return ExtAlert('Не выбрана запись');
        grid.getStore().remove(sel.items);
    },
    MessAdd: function() {
        var grid = this.CPWin.down('#gridmess');

        grid.getStore().add({
            type: 'warning',
            dateBegin: null,
            dateEnd: null,
            html: ''
        });
    },
    MessSave: function() {
        var grid = this.CPWin.down('#gridmess');
        var store = grid.getStore();
        var data = [];
        store.each(function(rec) {
            data.push(rec.data);
            delete data[data.length - 1].id;
        });
        AjaxRequest({
            url: '/CPanel/SetLoginInfoText',
            mask: {text: 'Сохранение', id: this.CPWin.down('#messaging') },
            params: {
                key: this.CPanelData.key,
                data: data,
                filePath: this.FormMessage.findField('WarningMessageFile').getValue()
            },
            success: this.SaveComplete.bind(this)
        });
    },

    SaveComplete: function(res) {
        if (!res || !res.Result)
            ExtAlert('#err#Ошибка сохранения!');
        if (res.Result < 0)
            ExtAlert(res.Message);
        if (res.Result == 0)
            ExtAlert('#msg#Успешно сохранено!');
    },

    GetSettingsParams: function(configs, form) {
        var settings = form ? form.getValues() : this.FormConfig.getValues();
        configs.forEach(function(cfg) {
            if (settings[cfg.key] !== void 0)
                settings[cfg.key] = cfg.value;
        });
        return settings;
    },
    GetSource: function(configs) {
        var setts1 = this.FormConfig.getValues();
        var setts2 = this.FormMessage.getValues();
        var setts3 = this.FormNews.getValues();
        var setts4 = this.FormPerm.getValues();
        var setts5 = this.FormInfo.getValues();
        var result = {};
        configs.forEach(function(cfg) {
            if (cfg.label)
                if (setts1[cfg.key] === void 0 && setts2[cfg.key] === void 0 && setts3[cfg.key] === void 0 && setts4[cfg.key] === void 0 && setts5[cfg.key] === void 0)
                    result[cfg.key] = cfg.value;
        });
        return result;
    },
    GetSourceConfig: function(configs) {
        var result = {};
        configs.forEach(function(cfg) {
            if (cfg.label)
                result[cfg.key] = {displayName: '[' + cfg.key + '] ' + cfg.label};
        });
        return result;
    },
    GetConnectionTypeStore: function() {

        var store = Ext.create('Ext.data.Store',
            {
                data: [
                    {
                        text: 'Обычный вход по логин/пароль и вход по сертификату используя СА',
                        value: 0
                    },
                    {
                        text: 'Вход по логин/пароль используя СА',
                        value: 1
                    },
                    {
                        text: 'Авторизация по сертификату используя Сервис Авторизации',
                        value: 2
                    },
                    {
                        text: 'Вход по логин/пароль и авторизация по сертификату используя Сервис Авторизации',
                        value: 3
                    },
                    {
                        text: 'Авторизация через ЕСИА используя Сервис Авторизации',
                        value: 4
                    },
                    {
                        text: 'Вход по логин/пароль, сертификату, через ЕСИА используя Сервис Авторизации',
                        value: 5
                    },
                    {
                        text: 'Вход через ЕСИА. Работа только на просмотр информации',
                        value: 6
                    }
                ]
            });
        return store;
    }
});