Ext.define('Admin.GroupsManager', {

    extend: 'NavigatorTreePanel',

    xtype: 'groupsmanager',

    alias: 'admin.groupsmanager',

    border: 0,

    bodyPadding: 3,

    margin: 4,

    FindVisible: true,

    emptyText: 'Загрузка...',

    useArrows: true,

    checkPropagation: 'down',

    maskDisabled: true,

    rootVisible: false,

    reserveScrollbar: true,

    multiSelect: false,

    layout: 'fit',

    config: {
        linkCounter: -1000
    },

    getLinkCouner: function () {
        var link = this.linkCounter;
        this.linkCounter--;
        return link;
    },

    viewModel: {
        data: {
            isModify: false,
            protocolIsShow: false
        },
        store: {
            treeStore: {
                type: 'tree'
            }
        },
        formulas: {
            groupData: {
                get: function (get) {
                    return get('tree.GroupData');
                }
            }
        }
    },

    bind: {
        selection: '{tree}',
        store: '{treeStore}'
    },

    listeners: {
        protocolrender: function () {
            this.getViewModel().set('protocolIsShow', true);
        },
        protocolshow: function () {
            this.getViewModel().set('protocolIsShow', true);
        },
        protocolhide: function () {
            this.getViewModel().set('protocolIsShow', false);
        }
    },

    dockedItems: [
        {
            xtype: 'panel',
            dock: 'bottom',
            layout: {
                type: 'hbox',
                align: 'stretch'
            },
            bind: {
                hidden: '{protocolIsShow}'
            },
            items: [
                {
                    xtype: 'fieldset',
                    flex: 1,
                    defaultType: 'textfield',
                    fieldDefaults: {
                        labelWidth: 100,
                        editable: false
                    },
                    layout: {
                        type: 'vbox',
                        align: 'stretch'
                    },
                    margin: '4 2 4 4',
                    title: 'Организация',
                    items: [
                        {
                            fieldLabel: 'Тип',
                            bind: '{groupData.dict_name}'
                        },
                        {
                            fieldLabel: 'Код',
                            bind: '{groupData.code}'
                        },
                        {
                            fieldLabel: 'ИНН',
                            bind: '{groupData.inn}'
                        },
                        {
                            xtype: 'textarea',
                            fieldLabel: 'Наименование',
                            bind: '{groupData.sname}'
                        }
                    ]
                },
                {
                    xtype: 'fieldset',
                    flex: 1,
                    defaultType: 'textfield',
                    fieldDefaults: {
                        labelWidth: 100,
                        editable: false
                    },
                    layout: {
                        type: 'vbox',
                        align: 'stretch'
                    },
                    margin: '4 4 2 4',
                    title: 'Группа',
                    items: [
                        {
                            fieldLabel: 'Наименование',
                            bind: '{groupData.group_name}'
                        },
                        {
                            fieldLabel: 'Примечание',
                            bind: '{groupData.group_note}'
                        }
                    ]
                }
            ]
        }
    ],

    constructor: function (args) {
        var me = this;

        Ext.apply(me, args, {
            ObjX: ObjX
        });

        me.ObjX.groupManager = me;

        me.ObjX.Refresh = me.Refresh.bind(me);

        me.callParent(arguments);

        if (!me.CheckAccess()) {
            me.DestroyAll();
            return ExtAlert('#err#Режим доступен только администраторам');
        }

        me.InitToolbar();

        me.InitEvents();

        me.FetchData();

        me.isGroupManager = true;
    },

    InitEvents: function () {
        var me = this,
            tab = me.ObjX.containerMain,
            hardClose = function () {
                me.getStore().commitChanges();
                tab.close();
            };

        tab.on({
            beforeclose: function () {
                if (me.IsModify()) {
                    Ext.Msg.show({
                        title: 'Предупрежение',
                        message: 'Сохранить изменения?',
                        buttons: Ext.Msg.YESNOCANCEL,
                        icon: Ext.Msg.QUESTION,
                        width: '400px',
                        fn: function (confirm) {
                            if (confirm === 'yes') {
                                me.Save(hardClose);
                            } else if (confirm === 'no') {
                                hardClose();
                            }
                        }
                    });
                    return false;
                }
            }
        });
    },

    InitToolbar: function () {
        var me = this;

        me.tbar = Ext.create('Core.Toolbar', {
            container: me,
            identifier: {
                Visible: 1,
                ObjectCode: me.ObjX.code
            }
        });
    },

    RemoveAllNodes: function () {
        this.getRootNode().removeAll();

        this.getStore().commitChanges();
    },

    Refresh: function () {
        var me = this;

        me.RemoveAllNodes();

        me.FetchData();
    },

    FetchData: function () {
        var me = this,
            mask = null;

        if (me.rendered) {
            mask = {
                text: 'Загрузка данных',
                id: me
            };
        }

        AjaxRequest({
            url: 'GroupAdmin/GetGroupAdmin',
            mask: mask,
            success: function (res) {
                me.InitServerResponse(res);
            }
        });
    },

    InitServerResponse: function (res, isImport) {
        var me = this;

        if (me.destroyed) return;
        
        if (!res) {
            me.DestroyAll();
            return ExtAlert('#err#Ошибка получения данных групп');
        }

        var store = me.getStore(),
            treeRoot = store.getRoot();

        treeRoot.appendChild(res, true, !isImport);

        treeRoot.cascade(function (rec) {
            if (rec.isRoot()) return;

            rec.set('text', me.GetNewNodeText(rec.get('GroupData')));
            me.ApplyIconToNode(rec);

            if (isImport) {
                me.RelinkNode(rec);
            }
        });
    },

    RelinkNode: function (node) {
        var me = this,
            parent = node.parentNode,
            linkSelf = parent && parent.getId() !== 'root' ? parent.getId() : null,
            link = node.getId() === '0' ? '0' : me.getLinkCouner(),
            groupData = node.get('GroupData');

        node.setId(link);

        Ext.apply(groupData, {
            link: link,
            link_self: linkSelf
        });
    },

    GetRecordsToSave: function () {
        var me = this,
            store = me.getStore(),
            updNodes = store.getModifiedRecords(),
            removedNodes = store.getRemovedRecords(),
            recToSave = [],
            getGroupData = function (node, isRemoved) {
                if (node.getId() == 0) return;

                var groupData = node.get('GroupData');
                Ext.apply(groupData, {
                    upd: 1,
                    del: +isRemoved,
                    row_id: null
                });
                recToSave.push(groupData);
            };

        if (updNodes.length) {
            updNodes = updNodes.forEach(function (node) {
                getGroupData(node, false);
            });
        }

        if (removedNodes.length) {
            removedNodes = removedNodes.forEach(function (node) {
                getGroupData(node, true);
            });
        }

        return recToSave;
    },

    IsMainNodeSelectedNode: function () {
        var node = this.GetSelectionGroupData();

        return node.link === 0;
    },

    Save: function (cb) {
        var me = this,
            recToSave = me.GetRecordsToSave();

        if (!recToSave.length) return ExtAlert('#msg#Изменений нет');

        AjaxRequest({
            url: 'GroupAdmin/Save',
            mask: {
                text: 'Сохранение',
                id: me
            },
            params: {
                records: recToSave
            },
            success: function (res) {
                if (res.Fail) {
                    return ExtAlert('#err#Ошибка сохранения ' + res.Message);
                }
                cb && cb.call ? cb() : me.Refresh();
            },
        });
    },

    IsModify: function () {
        var store = this.getStore();

        return store.getModifiedRecords().length || store.getRemovedRecords().length;
    },

    CheckAccess: function () {
        var me = this;

        return WebProject.Info.IsAdm && me.dbManager && me.dbManager.isDbManager;
    },

    DestroyAll: function () {
        var me = this;

        me.ObjX.containerMain.destroy();
    },

    AppentChild: function (target, node) {
        target.appendChild(node);
        target.expand();
        this.selectPath(node);
    },

    GetSelectionGroupData: function () {
        return this.getViewModel().get('groupData');
    },

    GetDictName: function (p) {
        if (!p || !p.node || !p.dictCode) return null;

        var node = p.node,
            dictCode = p.dictCode,
            dictName = node.isRoot() || node.get('INode').Link == 0 ? null : node.get('GroupData').dict_name;

        if (!dictName) {
            AjaxRequest({
                url: 'UserSettings/GetPropValue',
                params: {
                    obj: dictCode,
                    prop: 'TITLE'
                },
                success: function (name) {
                    node.get('GroupData').dict_name = name;
                }
            });
        }

        return dictName;
    },

    GetNewNodeText: function (data) {
        var text = [];

        if (data.code) {
            text.push('<span style="color: green;"><b>' + data.code + '</b></span>');
        }

        if (data.inn) {
            text.push('<span>(' + data.inn + ')</span>');
        }

        if (data.sname) {
            text.push(data.sname);
        }

        if (data.group_name) {
            text.push('<span style="color: SteelBlue;"><b>(' + data.group_name + ')</b></span>');
        }

        return text.join(' ');
    },

    ApplyIconToNode: function (node) {

        var preCls = 'ks-icon-',
            iconCls = node.get('iconCls'),
            icons = iconCls.split(',');

        node.set('defaultIcon', iconCls);

        if (icons.length > 1) {
            node.addCls('double-icon-node');
            var icon1 = preCls + icons[0],
                icon2 = preCls + icons[1],
                iconHtml = '<div class="double-icon"><div class="double-icon-item double-icon-item-1 ' + icon1 + '"></div><div class="double-icon-item double-icon-item-2 ' + icon2 + '"></div></div>',
                text = node.get('text');
            node.set('text', iconHtml + text);
            iconCls = 'empty';
        } else {
            iconCls = preCls + iconCls;
        }

        node.set('iconCls', iconCls);
    },

    AddTreeDictNode: function (dictRes) {
        if (!dictRes.rows.length) return;

        var me = this,
            selected = me.getSelection()[0];

        if (!selected) return;

        var dictCode = dictRes.configParams.DictObject.toUpperCase(),
            dictName = me.GetDictName({
                node: selected,
                dictCode: dictCode
            }),
            imgList = {
                'DICTIONARY_CORR': 'users,empty',
                'DICTIONARY_BUDGET': 'baccount,empty',
                'DICTIONARY_ATE': 'bag,empty'
            },
            iconCls = imgList[dictCode] ? imgList[dictCode] : imgList['DICTIONARY_ATE'];

        dictRes.rows.forEach(function (rec) {
            var data = {
                    dict_code: dictCode,
                    dict_name: dictName,
                    uid: null,
                    group_name: '',
                    group_note: '',
                    inn: rec.ccorr,
                    code: dictCode === 'DICTIONARY_ATE' ? rec.cate : rec.code,
                    corr_name: dictCode === 'DICTIONARY_ATE' ? rec.ate_name : rec.corr_name,
                    sname: rec.corr_sname,
                    corr: rec.link,
                    link: me.getLinkCouner(),
                    link_self: +selected.get('INode').Link
                },
                text = me.GetNewNodeText(data),
                newNode = selected.createNode({
                    checked: false,
                    text: text,
                    iconCls: iconCls,
                    leaf: true,
                    cls: 'new-admingroup-node',
                    INode: {
                        Link: data.link
                    },
                    GroupData: data
                });

            me.ApplyIconToNode(newNode);
            
            me.AppentChild(selected, newNode);
        });
    },

    GetSelected: function (checkOnly) {
        var me = this,
            selected = me.getChecked();

        if (!selected.length && !checkOnly) {
            selected = me.getSelection();
        }

        return selected.length ? selected : false;
    },

    CreateAddGroupForm: function (p) {
        var me = this,
            checked = p.checked,
            cb = p.callback;

        return {
            xtype: 'window',
            title: '[' + me.dbName + '] Добавление групп',
            width: 745,
            height: 600,
            autoShow: true,
            modal: true,
            layout: 'fit',
            items: [
                {
                    xtype: 'form',
                    defaultType: 'textfield',
                    fieldDefaults: {
                        labelAlign: 'top',
                        labelStyle: 'font-weight:bold;'
                    },
                    border: 0,
                    bodyPadding: 10,
                    layout: {
                        type: 'vbox',
                        align: 'stretch'
                    },
                    items: [
                        {
                            fieldLabel: 'Формула',
                            bind: '{template}'
                        }, 
                        {
                            fieldLabel: 'Группа общего доступа',
                            bind: '{groupName}',
                            triggers: {
                                dict: {
                                    cls: 'ks-icon-dict',
                                    handler: function () {
                                        var textfield = this;
                                        Meta.Users.GroupsTree({
                                            id: this.up('window'),
                                            callback: function (checked, tree) {
                                                var group = this[0],
                                                    data = group.getData ? group.getData().INode : null;

                                                textfield.setValue(data.DefaultName);

                                                tree.up('window').close();
                                            }
                                        });
                                    }
                                }
                            }
                        }, 
                        {
                            xtype: 'displayfield',
                            border: 1,
                            frame: true,
                            title: 'Подсказка',
                            value: [
                                '<h4>Переменные:</h4>',
                                '<ul>',
                                '<li>INN - ИНН корреспондента/Код ОКАТО</li>',
                                '<li>CODE - Код бюджетополучателя</li>',
                                '<li>SNAME - краткое наименование корреспондента/ОКАТО</li>',
                                '<li>NAME - полное наименование</li>',
                                '</ul>',
                                '<h4>Функции:</h4>',
                                '<ul>',
                                '<li>LEFT(переменная, длина) - взять часть символов слева</li>',
                                '<li>RIGHT(переменная, длина) - взять часть символов справа</li>',
                                '<li>SUBSTRING(переменная, начало, длина) - взять часть символов, начиная с определенной</li>',
                                '</ul>'
                            ].join('')
                        }, 
                        {
                            xtype: 'displayfield',
                            fieldLabel: 'Выбрано узлов',
                            labelWidth: 150,
                            labelAlign: 'left',
                            labelStyle: 'font-style: italic;font-weight:bold;',
                            value: checked.length
                        }
                    ]
                }
            ],
            buttons: [
                {
                    text: 'Создать',
                    handler: function () {
                        cb && cb.call && cb();
                    }
                }, 
                {
                    text: 'Закрыть',
                    handler: function () {
                        this.up('window').close();
                    }
                }
            ]
        };
    },

    ChangeNodeGroupBind: function (data, node) {
        if (!node) return;
        var me = this,
            groupData = node.get('GroupData'),
            iconCls = node.get('defaultIcon') || '',
            oldIcon = data ? 'empty' : 'link',
            newIcon = data ? 'link' : 'empty';

        groupData.group_name = data ? data.DefaultName : '';
        groupData.group_note = data ? data.Note : '';
        groupData.uid = data ? data.UID : '';

        node.set({
            'text': me.GetNewNodeText(groupData),
            'iconCls': iconCls.replace(oldIcon, newIcon),
            'checked': false
        });

        me.ApplyIconToNode(node);
    },

    //TASKS
    CommonAdd: function (p) {
        if (!p) return;
        var me = this,
            dictObject = p.DictObject || '',
            pn = p.ParamNames,
            pv = p.ParamValues,
            cb = p.callback;

        DictList({
            DictObject: dictObject,
            MultiSelect: 'MULTI',
            ParamNames: pn,
            ParamValues: pv,
            macroCallBack: function (dictRes) {
                cb && cb.call && cb();
                me.AddTreeDictNode(dictRes);
            }
        });
    },

    AddCorr: function () {
        this.CommonAdd({
            DictObject: 'DICTIONARY_CORR'
        });
    },

    AddRBS: function () {
        this.CommonAdd({
            DictObject: 'DICTIONARY_CORR',
            ParamNames: '@corr_type',
            ParamValues: 'GRBS,MAIN_GRBS'
        });
    },

    AddPBS: function () {
        this.CommonAdd({
            DictObject: 'DICTIONARY_CORR_RBS'
        });
    },

    AddGRBSPBS: function () {
        var me = this,
            data = me.GetSelectionGroupData();

        if (!data) return;

        var dictObject = 'DICTIONARY_CORR',
            parentLink = data.link,
            parentDictCode = data.dict_code || '';

        if (parentLink != 0 && parentDictCode.toUpperCase() !== dictObject) {
            return ExtAlert('#msg#Тип добавляемого узла должен совпадать с типом вышестоящего');
        }

        this.CommonAdd({
            DictObject: dictObject,
            ParamNames: '@corr_head',
            ParamValues: data.corr
        });
    },

    AddBudget: function () {
        this.CommonAdd({
            DictObject: 'DICTIONARY_BUDJET_EXP'
        });
    },

    AddOkato: function () {
        this.CommonAdd({
            DictObject: 'DICTIONARY_ATE'
        });
    },

    Delete: function () {
        var me = this,
            selected = me.GetSelected();

        if (me.IsMainNodeSelectedNode()) return;

        if (!selected) return ExtAlert('#msg#Выберите запись для удаления');

        var text = selected.length > 1 ? 'Отмечено записей: ' + selected.length + '<br> Удалить записи?' : 'Удалить запись?';
 
        Ext.Msg.confirm('Подтвердите действие', text, function (confirm) {
            if (confirm === 'yes') {
                selected.forEach(function (rec) {
                    rec.remove && rec.remove();
                });
            }
        });
    },

    AddGroups: function () {
        var me = this,
            vm = me.getViewModel(),
            checked = me.GetSelected(),
            addGroups = function () {
                var links = checked.map(function (rec) {
                    return rec.getId();
                });

                AjaxRequest({
                    url: 'GroupAdmin/AddGroup',
                    mask: {
                        text: 'Генерация групп',
                        id: win
                    },
                    params: {
                        template: vm.get('template'),
                        group: vm.get('groupName'),
                        links: links
                    },
                    success: function (res) {
                        if (res) {
                            ExtUtils.ShowProtocol({
                                title: 'Добавление группы',
                                container: me,
                                hres: res
                            });
                        }

                        vm.set({
                            'template': '',
                            'groupName': ''
                        });

                        win.close();

                        me.Refresh();
                    }
                });
            };

        if (me.IsModify()) return ExtAlert('#msg#Необходимо сохранить все изменения перед запуском данной операции!');

        if (!checked) return ExtAlert('#msg#Выберите запись для добавления группы');
        var form = me.CreateAddGroupForm({
                checked: checked,
                callback: addGroups
            }),
            win = me.add(form);

        win.show();

        AjaxRequest({
            url: 'UserSettings/GetNastrValue',
            mask: {
                text: 'Получение настроек',
                id: win
            },
            params: {
                nastr: 'GROUP_ADMIN',
                prop: 'NASTR_TEMPLATE_NAME'
            },
            success: function (tpl) {
                vm.set('template', tpl || '\'web_code_\' + CODE');
            }
        });
    },

    Bind: function () {
        var me = this,
            checked = me.GetSelected();

        if (!checked) return ExtAlert('#msg#Выберите запись');

        Meta.Users.GroupsTree({
            id: me,
            callback: function (groupTreeChecked, tree) {
                var group = this[0],
                    data = group.getData ? group.getData().INode : null;

                if (!data) return;

                checked.forEach(me.ChangeNodeGroupBind.bind(me, data));

                tree.up('window').close();
            }
        });
    },

    ClearBinding: function () {
        var me = this,
            checked = me.GetSelected();

        if (!checked) return;

        checked.forEach(me.ChangeNodeGroupBind.bind(me, null));
    },

    Import: function () {
        var me = this,
            mainLevelNode = me.getRootNode().findChild('id', '0'),
            importEl,
            importGroupTree = function (action, button) {
                var mask = ShowLoadMask('Выполняется импорт', me),
                    file = button.fileInputEl.dom.files[0],
                    fd = new FormData();

                fd.append('File', file, file.name);
                fd.append('action', action);

                $.ajax({
                    url: Connection.rsa + '/GroupAdmin/Import',
                    data: fd,
                    method: 'POST',
                    dataType: 'json',
                    type: 'POST',
                    processData: false,
                    contentType: false,
                    converters: {
                        'text json': JSON.parse
                    },
                })
                    .done(function (res) {
                        var unpackRes = Ext.decode(m_unpack(res.Content), true);

                        if (!unpackRes) return ExtAlert('#err#Ошибка импорта. Нет ответа сервера');

                        if (unpackRes.isError) {
                            return ShowError(unpackRes);
                        }

                        me.getRootNode().removeAll();

                        me.InitServerResponse(unpackRes, true);
                    })
                    .always(function () {
                        mask.destroy();
                        importEl.destroy();
                    });
            },
            startImport = function (action) {
                importEl = ExtUtils.CreateOneOffHiddenFileUploader({
                    fileChangeCallback: importGroupTree.bind(me, action)
                });
            };
        
        
        if (mainLevelNode && mainLevelNode.childNodes.length) {
            Ext.Msg.show({
                title: 'Внимание',
                message: 'В дереве уже существуют записи. Выберите действие.',
                buttons: Ext.Msg.YESNOCANCEL,
                buttonText: {
                    yes: 'Добавить',
                    no: 'Заменить',
                    cancel: 'Отмена'
                },
                icon: Ext.Msg.WARNING,
                fn: function (btn) {
                    if (btn !== 'cancel') {
                        var action = btn === 'yes' ? 'add' : 'replace';
                        startImport(action);
                    }
                }
            });
        } else {
            startImport('replace');
        }
    },

    Export: function () {
        FileUtils.DownloadGet('GroupAdmin/Export');
    },

    Print: function () {
        Meta.Print.Tree(this, this.ObjX.code);
    }
});