﻿Ext.define('Admin.BlocksMonitorManager', {
    
    extend: 'Ext.panel.Panel',

    xtype: 'blocksmonitormanager',

    config: {
        gridsColumnsAdded: false,
        waitTime: null,
        interval: null,
        useScript: false,
        intervalId: null
    },

    bind: {
        waitTime: '{waitTime}',
        intervalId: '{intervalId}',
        interval: '{refreshInterval}',
        useScript: '{useScript}'
    },

    twoWayBindable: {
        waitTime: true,
        intervalId: true,
        interval: true,
        useScript: true
    },

    publishes: ['waitTime', 'intervalId', 'interval', 'useScript'],

    viewModel: {
        data: {
            waitTime: 3000,
            refreshInterval: 10,
            started: false
        },
        stores: {
            blocksStore: {
                data: []
            },
            historyStore: {
                data: []
            }
        },
        formulas: {
            started: {
                bind: {
                    bindTo: '{intervalId}'
                },
                get: function (id) {
                    return !!id;
                }
            }
        }
    },

    border: 0,

    defaults: {
        padding: 10
    },

    layout: {
        type: 'vbox',
        align: 'stretch'
    },

    tbar: [{
        tooltip: 'Сохранить',
        iconCls: 'ks-icon-save',
        bind: {
            disabled: '{!historyStore.count}'
        },
        handler: function () {
            this.up('blocksmonitormanager').Save();
        }
    },
    '-',
    {
        tooltip: 'Выполнить альтернативный скрипт',
        iconCls: 'ks-icon-sql',
        handler: function () {
            this.up('blocksmonitormanager').ExecSQL();
        }
    },
    '-',
    {
        tooltip: 'Старт',
        iconCls: 'ks-icon-start',
        bind: {
            disabled: '{started}'
        },
        handler: function () {
            this.up('blocksmonitormanager').StartWatch();
        }
    },
    {
        tooltip: 'Стоп',
        iconCls: 'ks-icon-pause',
        bind: {
            disabled: '{!started}'
        },
        handler: function () {
            this.up('blocksmonitormanager').StopWatch();
        }
    },
    {
        tooltip: 'Обновить',
        iconCls: 'ks-icon-refresh',
        handler: function () {
            this.up('blocksmonitormanager').Refresh();
        }
    },
    '-',
    {
        tooltip: 'Очистить',
        iconCls: 'ks-icon-clean',
        handler: function () {
            this.up('blocksmonitormanager').Clean();
        }
    }],

    items: [
        {
            xtype: 'fieldcontainer',
            layout: {
                type: 'vbox',
                align: 'start'
            },
            defaultType: 'numberfield',
            defaults: {
                labelWidth: 350
            },
            items: [
                {
                    fieldLabel: 'Период обновления (сек)',
                    minValue: 1,
                    bind: {
                        disabled: "{started}",
                        value: "{refreshInterval}"
                    }
                }, 
                {
                    fieldLabel: 'Сохранять историю блокировок с wait_time более (мс)',
                    minValue: 0,
                    bind: {
                        value: "{waitTime}"
                    }
                }
            ] 
        }, 
        
        {
            xtype: 'whitetabpanel',
            layout: 'fit',
            flex: 2,
            items: [
                {
                    xtype: 'grid',
                    itemId: 'activeBlocksGrid',
                    title: 'Активные блокировки',
                    columns: [],
                    bind: {
                        store: '{blocksStore}'
                    }
                },
                {
                    xtype: 'grid',
                    itemId: 'historyBlocksGrid',
                    title: 'История блокировок',
                    columns: [],
                    bind: {
                        store: '{historyStore}'
                    }
                }
            ]
        },
        
        {
            xtype: 'textarea',
            flex: 1,
            editable: false,
            fieldStyle: 'padding: 8px;',
            bind: '{useScript}'
        }
    ],

    listeners: {
        close: function () {
            this.SaveBlocksHistory();
        }
    },

    constructor: function () {
        var me = this;

        me.callParent(arguments);

        me.isBlocksMonitorManager = true;

        me.FetchData();
    },

    StartWatch: function () {
        var me = this,
            interval = me.getInterval();

        if (!interval) return ExtAlert('#msg#Не указан интервал');

        var intervarId = setInterval(function () {
            me.FetchData();
        }, interval * 1000);

        me.setIntervalId(intervarId);
    },

    StopWatch: function () {
        var me = this,
            intervarId = me.getIntervalId();

        intervarId && clearInterval(intervarId);

        me.setIntervalId(null);
    },

    FetchData: function () {
        var me = this;
        AjaxRequest({
            url: "DbList/BlocksMonitorLoadOutcome",
            params: {
                key: me.sessionKey
            },
            success: function (res) {
                var outcome = res.outcome;

                if (outcome && outcome.Data && outcome.Data.Tables && outcome.Data.Tables.length) {
                    var table = outcome.Data.Tables[0];

                    !me.getGridsColumnsAdded() && me.InitGridColumns(table);

                    res.useSql && me.setUseScript(useSql);
                    
                    me.LoadGridsStores(table);
                } else {
                    ExtAlert('#err#Ошибка получения данных с сервера');
                }
            }
        });
    },

    Refresh: function () {
        this.FetchData();
    },

    LoadGridsStores: function (table) {
        var me = this,
            vm = me.getViewModel(),
            blocksStore = vm.get('blocksStore'),
            historyStore = vm.get('historyStore'),
            blocksData = DataUtils.GetDataFromTable(table);

        blocksStore.loadData(blocksData);

        if (blocksData.length) {
            var waitTime = me.getWaitTime(),
                dataToHistory = blocksData.filter(function (rec) {
                    return rec.wait_time >= waitTime;
                });

            dataToHistory.length && historyStore.loadData(dataToHistory, true);
        }
    },

    InitGridColumns: function (table) {
        var me = this;

        if (!table) return;

        var activeGrid = me.down('#activeBlocksGrid'),
            historyGrid = me.down('#historyBlocksGrid'),
            columns = DataUtils.GetColumnsFromTable(table).map(function (col) {
                if (col) {
                    return {
                        dataIndex: col.name,
                        text: col.name,
                        width: col.defWidth || 50
                    };
                }
            });

        if (columns.length) {
            activeGrid && activeGrid.headerCt && activeGrid.headerCt.add(columns);
            historyGrid && historyGrid.headerCt && historyGrid.headerCt.add(columns);
        }

        me.setGridsColumnsAdded(true);
    },

    SaveBlocksHistory: function (isClean) {
        var me = this,
            store = me.getViewModel().get('historyStore'),
            data;

        if (isClean) {
            data = null;
        } else if (store && store.count()) {
            data = JSON.stringify(store.getData());
        }

        LocalStorage.set('blocksmonitorhistory', data);
    },

    GetBlockHistory: function () {
        return LocalStorage.get('blocksmonitorhistory');
    },

    ExecSQL: function () {
        var me = this,
            el = ExtUtils.CreateOneOffHiddenFileUploader({
                addParams: {
                    accept: ['.sql']
                },
                fileChangeCallback: function (button) {
                    var file = button.fileInputEl.dom.files[0];
                    if (file) {
                        var fd = new FormData();
                   
                        fd.append('file', file);
                        fd.append('key', me.sessionKey);

                        FileUtils.Upload('/DbList/BlocksMonitorLoadSQL', fd, function (res) {
                            if (res.isError) {
                                ShowError(res);
                            }
                            
                            el.destroy();
                            me.Refresh();
                        });
                    }

                }
            });
    },

    Save: function () {
        var me = this,
            data = me.GetBlockHistory();

        if (!data) return;

        FileUtils.SaveText(JSON.stringify(data), "blocksmonitor-" + Random(100000));
    },

    Clean: function () {
        var me = this,
            vm = me.getViewModel(),
            blocksStore = vm.get('blocksStore'),
            historyStore = vm.get('historyStore');
    
        blocksStore.removeAll(true);

        historyStore.removeAll(true);

        me.SaveBlocksHistory(true);
    }
});