var isValidBarcode = function (barcode) {
    var code = `${barcode.code}`;
    var codeFormat = barcode.format;
    var decodedCodes = barcode.decodedCodes;

    if (codeFormat === 'code_128' || codeFormat === 'i2of5') {
        if (!hasFalsePositives(decodedCodes)) return true;
        else return false;
    }

    var supportedFormats = ['ean_13', 'ean_8', 'upc_a', 'upc_e'];

    if (!supportedFormats.includes(codeFormat)) return true;

    var digits = function() { return /^\d{8,13}$/g.test(code) };
    var validlengths = [8, 12, 13];
    if (!digits() || !validlengths.includes(code.length)) return false;

    var checksum = 0;
    var codelist = code.split("");
    var checkdigit = parseInt(codelist.pop(), 10);
    codelist.map(function (value, index) {
        const digit = parseInt(value, 10);
        if (code.length % 2 === 1) checksum += index % 2 ? digit * 3 : digit;
        else checksum += index % 2 ? digit : digit * 3;
    });

    var check = checksum % 10;
    if (check !== 0) check = 10 - check;
    if (check === checkdigit) return true;
    return false;
};

//   ,  0.1
//    ,  128  i2of5   
//       0.12-0.14
function hasFalsePositives (decodedCodes) { 
    var errors = decodedCodes
        .filter(function(_) { return _.error !== undefined; })
        .map(function(_) { return _.error; });
    var median = this._getMedian(errors);
    if (median < 0.14)
        return false;
    return true;
}

function _getMedian(arr) {
    arr.sort((a, b) => a - b);
    var half = Math.floor(arr.length / 2);
    if (arr.length % 2 === 1) // Odd length
        return arr[half];
    return (arr[half - 1] + arr[half]) / 2.0;
}