SvodTemplateDictionaryEditView = KS.extend(BaseSvodView, {});

// ============= BASE =======================
(function (viewClass) {
    var sc = SvodTemplateDictionaryEditView.superclass;
    KS.apply(viewClass, {
        onTemplateRendered: function () {
            this.addPropertyGrid();
            this.discardChanges();
        },

        onSetSavedState: function(saved) {
            var saveBtn = this.getToolbarItem(this.rootPanel, null, 'SAVE');
            if (saveBtn)
                saveBtn.setDisabled(saved);
        },

        resetView: function () {
            this.addPropertyGrid();
            this.formsGrid.reload();
            this.budgetGrid.reload();
            this.usersGrid.reload();
        },

        saveErrorMsg: '',

        onServerShowSaveError: function(error){
            KS.warning(error);  
        },

        getTbarClickHandler: function(tbarItem) {
            switch (tbarItem.code) {
                case 'NEW':
                    return this.newHandler;

                case 'DELETE':
                    return this.deleteHandler;
                    
                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        },

        newHandler: function(){
            var view = this.parentView || this;
            var grid = this.parentView.findOwnerGrid(this);
            if (grid) {
                view.containerPanel.mask("Пожалуйста, подождите");
                setTimeout(function(){view.containerPanel.unmask()}, 2000);
                view.serverCall({
                    method: 'AddNewRow',
                    params: [grid.ctrlId]
                });
            }
        },

        onValuesSelected: function (args) {
            if (Ext.isEmpty(args) || Ext.isEmpty(args[0])) return;
            var view = this,
                selectedValue = args[0][0];
            for (var field in selectedValue) {
                if (selectedValue.hasOwnProperty(field) &&
                    field === 'ACTION') {
                    var action = selectedValue[field];
                    switch(action) {
                        case 'RELOAD_GRID':
                            var gridToReload = view[selectedValue['srvGridId']];
                            if (gridToReload) {
                                gridToReload.reload();
                            }
                            break;
                        case 'RELOAD_PROPERTY_GRID':
                            this.addPropertyGrid();
                            break;
                    }
                }
            }
        },

        deleteHandler: function(){
            var view = this.parentView || this;
            var grid = this.parentView.findOwnerGrid(this);
            if (grid) {
                var checkedCodes = grid.getCheckedCodes();
                if (Ext.isEmpty(checkedCodes)) return;
                KS.confirm("Будет удалено строк: " + checkedCodes.length + ". Продолжить?", "Подтвердите удаление", function (btn) {
                    if (btn === 'yes')
                        view.deleteHandlerInternal(checkedCodes, grid.ctrlId);
                });
            }
        },

        deleteHandlerInternal: function (checkedCodes, gridId) {
            var view = this;
            this.serverCall({
                method: 'DeleteRows',
                params: [gridId, checkedCodes],
                waitMessage: 'Удаление ...',
                success: function(deleted) {
                    if (deleted) {
                        view[gridId].reload();
                        view.touch();
                    }
                }
            });
        },

        addPropertyGrid: function() {
            this.serverCall({
                method: 'GetPropertiesData',
                disableFog: true,
                success: this.fillProperties
            });
        },

        fillProperties: function(listOptions) {
            if (listOptions) {
                var view = this;
                view.propertyPanel.removeAll();
                if (!Ext.Object.isEmpty(listOptions)) {
                    var i = 0;
                    for (var prop in listOptions) {
                        if (listOptions.hasOwnProperty(prop)) {
                            var propertyGrid = view.getPropertyGridByOption(listOptions[prop], "propertyGrid" + i++, prop);
                            propertyGrid.on("propertychange", view.propertyGridChange, view);
                            view.propertyPanel.add(propertyGrid);
                        }
                    }
                }
            }
        },

        propertyGridChange: function(source, recordId, value, oldValue){
            if (value == oldValue) return;
            var propId = recordId.split("#")[1];
            this.serverCall({
                method: 'ChangePropertyGridValue',
                params: [propId, value],
                disableFog: true
            });
        },

        propertyGridDictSelect: function(propId, dictId) {
            this.serverCall({
                method: 'OpenPropertyGridDict',
                params: [dictId]
            });
        }
    });
}(SvodTemplateDictionaryEditView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();