﻿SvodEArcView = KS.extend(BaseDictionaryView,
    {
        customName: 'SvodEArcView'
    });

// ============= BASE =======================
(function (viewClass) {
    var sc = SvodEArcView.superclass;

    KS.apply(viewClass, {
        onTemplateRendered: function() {
            this.containerPanel.on('activate', this.viewActivated, this);
        },

        viewActivated: function(){
            var rnv = this.getReportNavigationView();
            if (rnv && rnv.containerPanel && rnv.containerPanel.ownerCt)
                rnv.containerPanel.ownerCt.setActiveTab(rnv.containerPanel);
        },

        getReportNavigationView: function(){
            return KS.findSingleView('customNameExt', 'ReportNavigationView_EArchive');
        },

        onBeforeClose: function () {
            var rnv = this.getReportNavigationView();
            if (rnv && rnv.containerPanel && rnv.containerPanel.ownerCt)
                rnv.containerPanel.ownerCt.setActiveTab(rnv.containerPanel)

            SvodEArcView.superclass.onBeforeClose.call(this);
        },

        getTbarClickHandler: function (tbarItem) {
            var code = tbarItem.code || '';
            switch (code) {
                case 'REFRESH2':
                    return this.refreshList;
                    
                case 'PRINT_COMMON':
                case 'EDS':
                    return null;

                case 'PRINT':
                case 'EDS_INFO':
                case 'EXPORT':
                    return this.executeToolbarOperation;
            }
            return sc.getTbarClickHandler.apply(this, arguments);
        },
        
        executeToolbarOperation: function() {
            var view = this.parentView,
                grid = view.mainGrid;
            if (grid && this.tbarNode) {
                var code = this.tbarNode.code || '';
                view.executeOperation(code, grid);
            }
        },

        executeOperation: function (opCode, grid, additional) {
            var rows = this.buildChosenRows(grid, opCode !== 'CREATE_NOTIFICATION');
            if (Ext.isEmpty(rows)) {
                KS.alert("Для выполнения операции необходимо выделить один или несколько отчётов");
                return;
            }

            this.serverCall({
                method: 'OnExecuteOperation',
                params: [opCode, rows, additional || {}]
            });
        },

        refreshList: function() {
            var view = this.parentView || this;
            var rnv = view.getReportNavigationView();
            if (Ext.isEmpty(rnv)) return;
            var viewState = rnv.getFilters();
            if (Ext.isEmpty(viewState)) return;

            if (view.isRefreshing === true) {
                return;
            }
            view.isRefreshing = true;
            view.disableFilters();
            view.mainGrid.unmark();
            view.mainGrid.checkedCodes = [];
            view.serverCall({
                method: 'RefreshList',
                params: [viewState],
                cancellable: true,
                waitMessage: 'Обновление списка ...',
                success: view.refreshListCallback,
                complete: view.enableFilters
            });
        },

        refreshListCallback: function(vl) {
            this.stopRefresh();
            this.mainGrid.valueLists = vl;
            this.mainGrid.eachColumnCfg(function(colCfg){
                colCfg.vlItems = null;
            });
            this.mainGrid.reload();
        },

        stopRefresh: function() {
            this.isRefreshing = false;
        },

        enableFilters: function () {
            this.stopRefresh();
            var rnv = this.getReportNavigationView();
            if (rnv) rnv.refreshTaskListCallBack();
        },

        disableFilters: function () {
            var rnv = this.getReportNavigationView();
            if (rnv) rnv.containerPanel.disable();
        },
        
        openFileUrl: function(colKey, closeCode){
            this.serverCall({
                method: 'OpenFileUrl',
                params: [colKey, closeCode],
                waitMessage: 'Подготовка файла ...'
            });
        }
    });
}(SvodEArcView.prototype));

function earcFileUrlRenderer(value, metadata, record, rowIndex, colIndex, store) {
    var displayValue = value;
    var vl = store.grid.valueLists;
    if (vl) {
        var colCfg = store.grid.getColCfgByIndex(colIndex);
        if (!colCfg.vlItems) {
            colCfg.vlItems = {};
            Ext.each(vl, function (vlEl) {
                var columnKey = vlEl.ColumnKey || vlEl.columnKey;
                if (columnKey.toUpperCase() === colCfg.dataIndex.toUpperCase()) {
                    var vlItems = vlEl.Items || vlEl.items;
                    Ext.each(vlItems, function (item) {
                        var dataValue = item.StringDataValue || item.dataValue;
                        colCfg.vlItems[dataValue] = item.DisplayText || item.displayText;
                    });
                }
            });
        }
        displayValue = colCfg.vlItems[value] || value;
    }
    
    var viewId = store.grid.parentView.viewID;
    var colKey = metadata.column.dataIndex;
    var closeCode = KS.Grid.getAnyCase(record, store.grid.closeCode);
    return '<span class="like-hypertext" onclick="KS.getView(' + "'" + viewId + "'" + ').openFileUrl(' + "'" + colKey + "'" + ' ,' + "'" + closeCode + "'" + ');return false;"/>' + displayValue + '</span>';
}