﻿ReportCalculateByMaskView = KS.extend(BaseSvodView,
    {
        gridCellClick: function(grid, td, cellIndex) {
            var column = grid.grid.getColCfgByIndex(cellIndex),
                editor = column.editor;
            if (!Ext.isEmpty(editor)) {
                var columnName = column.text,
                maxLength = parseInt(columnName.substring(columnName.indexOf("длина")).replace(/\D+/g,""));
                editor.maxLength = maxLength;
            }
        },

        editHandler: function(e, context) {
            this.saveMask(context.grid.tableLink, context.field, context.value, context);
        },

        afterEditHandler: function(e) {
            this.saveMask(e.grid.tableLink, e.field, e.value, e);
        },

        saveMask: function(tableLink, field, value, e) {
            this.serverCall({
                method: 'SaveMask',
                disableFog: true,
                params: [this.forms.getActiveTab().ctrlId, tableLink, field, value],
                success: function(hasErrors) {
                    if (hasErrors) e.record.reject();
                }
            });
        },

        calculate: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'DoCalculate',
                waitMessage: 'Досчет ...',
                params: [view.makeBackup ? view.makeBackup.checked : false],
                success: function() {
                    view.showHtmlProtocolInContainer();
                    view.refreshTaskList();
                }
            });
        }
    });

Ext.define('maskEditor',
    {
        extend: 'Ext.form.TextField',
        allowBlank: true,
        enforceMaxLength: true,
        maxLength: 1000,
        style: 'text-align:center'
    });

if (typeof (Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();