﻿MQView = KS.extend(BaseSvodView, {
    onTemplateRendered: function () {
    },

    buildContainerToolbarItemControl: function (tbarItem, schema) {
        switch (tbarItem.code) {
            case 'upload':
                this.filesPanel = new Ext.FormPanel({
                    fileUpload: true,
                    width: 150,
                    hideLabels: true,
                    autoHeight: true,
                    layout: 'hbox',
                    bodyStyle: 'padding: 2px 2px 0px 2px;',
                    defaults: {
                        flex: 1,
                        allowBlank: false,
                        msgTarget: 'side'
                    },
                    items: [
                        {
                            xtype: 'fileuploadfield',
                            emptyText: 'Выберите файл',
                            buttonText: '',
                            ref: 'upload',
                            multiple: true,
                            buttonCfg: {
                                iconCls: 'ks-icon-new'
                            }
                        }
                    ]
                });
                this.filesPanel.upload.on('fileselected', this.doUpload, this);
                return this.filesPanel;
        }
        return MQView.superclass.buildContainerToolbarItemControl.call(this, tbarItem, schema);
    },

    doUpload: function (uplField, path, evt) {
        var form = this.filesPanel.getForm();
        if (form.isValid())
            this.uploadFiles(form, this.saveFiles, uplField, evt, this.filesGrid);
    },

    saveFiles: function (fileKeys) {
        var view = this.parentView || this;
        view.serverCall({
            method: 'DoSaveFiles',
            params: [fileKeys],
            waitMessage: 'Сохранение ...',
            success: view.saveFilesCallback
        });
    },

    saveFilesCallback: function (fileName) {
        if (fileName) this.fileName.setValue(fileName);
    },

    getConnSettings: function () {
        var cs = this.data.connSettings;
        cs.QueueManagerName = this.qman.getValue();
        cs.QueueName = this.queue.getValue();
        cs.ChannelName = this.channel.getValue();
        cs.UserId = this.user.getValue();
        cs.Password = this.pass.getValue();
        return cs;
    },

    getAttributes: function() {
        return {
            fileName: this.fileName.getValue()
        };
    }
});

(function (viewClass) {
    KS.apply(viewClass, {
        fetchMessage: function () {
            var view = this.parentView;
            view.serverCall({
                method: 'FetchMessage',
                waitMessage: 'Соединение с MQ ...',
                success: view.readMessage
            });
        },

        readMessage: function () {
            var view = this.parentView || this,
                unicode = view.getToolbarItem(view.message, null, 'unicode');
            view.serverCall({
                method: 'ReadMessage',
                params: [unicode.pressed],
                waitMessage: 'Чтение ...',
                success: function (html) {
                    this.message.update(html);
                }
            });
        },

        openUnicode: function() {
            var view = this.parentView,
                ascii = view.getToolbarItem(view.message, null, 'ascii');
            ascii.toggle(!this.pressed);
            view.readMessage();
        },

        openAscii: function () {
            var view = this.parentView,
                unicode = view.getToolbarItem(view.message, null, 'unicode');
            unicode.toggle(!this.pressed);
            view.readMessage();
        },

        download: function () {
            this.parentView.serverCall({
                method: 'Download',
                success: KS.openUrl
            });
        },

        refreshList: function () {
            var view = this.parentView;
            view.serverCall({
                method: 'ReadMessages',
                waitMessage: 'Чтение ...',
                success: function () {
                    this.queryGrid.reload();
                }
            });
        },

        sendStringMessage: function () {
            var view = this.parentView;
            view.serverCall({
                method: 'SendStringMessage',
                params: [view.getConnSettings(), view.content.getValue(), this.dataType, view.getAttributes()]
            });
        },

        sendBinaryMessage: function () {
            var view = this.parentView;
            view.serverCall({
                method: 'SendBinaryMessage',
                params: [view.getConnSettings(), view.getAttributes()]
            });
        }
    });
}(MQView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();