﻿ExcelImportSettingsView = KS.extend(BaseDictionaryView, {});

// ============= COMMON =======================
(function(viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function() {
            this.discardChanges();
        },

        cellDblClickHandler: function(gridView, td, cellIndex, record, tr, rowIndex, e) {
            var column = e.position.column;
            var dataIndex = column.dataIndex;

            if (column.renderer === dictRenderer) {
                var link = KS.Grid.getAnyCase(record, gridView.grid.closeCode);
                
                this.serverCall({
                    method: 'OpenDictionary',
                    params: [dataIndex, link]
                });
                return;
            }

            switch (dataIndex.toUpperCase()) {
                case "FILE_NAME":
                case "CELL":
                case "CELL_VALUE":
                case "PATH":
                    this.showPopupStringEditor(dataIndex.toUpperCase(), record);
                    return;
            }

            var closeCode = KS.Grid.getAnyCase(record, gridView.grid.closeCode);
            this.editExcelSettings(closeCode);
        },
        
        showPopupStringEditor: function (dataIndex, record) {
            var view = this;
            var value = KS.Grid.getAnyCase(record, dataIndex);
            view.pseWin = KS.showModal({
                xtype: 'textarea',
                itemId: 'pseArea',
                value: value
            },{
                layout: 'fit',
                plain: true,
                frame: true,
                autoScroll: true,
                modal: true,
                maximizable: true,
                minWidth: 400,
                minHeight: 300,
                width: Math.max(400, KS.rootViewport.getWidth() / 3),
                height: Math.max(300, KS.rootViewport.getHeight() / 2),
                title: "Введите значение",
                buttonAlign: 'right',
                buttons: new Array({
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            var newValue = view.pseWin.getComponent("pseArea").getValue();
                            view.editCell({
                                value : newValue,
                                originalValue : value,
                                field : dataIndex,
                                record : record
                            });
                            view.pseWin.close();
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.pseWin.close();
                        }
                    })
            }, true);
        },

        editCell: function(context) {
            var value = context.value;
            var dataIndex = context.field;

            var view = this;
            var closeCode = KS.Grid.getAnyCase(context.record, this.mainGrid.closeCode);

            view.serverCall({
                method: 'EditCell',
                params: [dataIndex, closeCode, value],
                disableFog: true,
                success: function(result) {
                    if (result) {
                        context.record.set(dataIndex, value);
                        view.touch();
                    }
                }
            });
            return true;
        },

        editExcelSettings: function(closeCode) {
            this.serverCall({
                method: 'EditExcelSettings',
                params: [closeCode]
            });
        },

        onServerShowExcelSettings: function(tabPanel, title) {
            this.settingTable = this.createTemplateControl(tabPanel);
            this.addPanelItems(tabPanel, this.settingTable);

            var view = this;
            view.excelSettingsWin = KS.showModal(this.settingTable,
                {
                    layout: 'fit',
                    frame: true,
                    modal: true,
                    maximizable: true,
                    minWidth: 400,
                    minHeight: 300,
                    width: Math.max(400, KS.rootViewport.getWidth() / 3),
                    height: Math.max(300, KS.rootViewport.getHeight() / 2),
                    title: title,
                    buttonAlign: 'right',
                    buttons: new Array({
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function () {
                                view.acceptExcelSettings();
                            }
                        }, { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.rejectExcelSettings();
                            }
                        })
                }, true);
        },

        excelSettingsTableEdit: function(e, context) {
            if (context.value === null || context.value === context.originalValue) return false;
            var linkCol = KS.Grid.getAnyCase(context.record, "link_col");
            var linkTable = KS.Grid.getAnyCase(context.record, "link_table");
            var linkSettings = KS.Grid.getAnyCase(context.record, "link_settings");
            var newValue = KS.Grid.getAnyCase(context.record, "value");

            this.serverCall({
                method: 'EditExcelSettingTable',
                params: [linkCol, linkTable, linkSettings, newValue],
                disableFog: true
            });
            return true;
        },

        rejectExcelSettings: function() {
            var closeCode = this.settingTable.closeCode;
            this.serverCall({
                method: 'RejectExcelSettings',
                params: [closeCode],
                disableFog: true
            });
            this.excelSettingsWin.close();
        },

        acceptExcelSettings: function() {
            this.touch();
            this.excelSettingsWin.close();
        },

        resetView: function () {
            this.mainGrid.reload();
        },

        newHandler: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'AddRecord',
                disableFog: true,
                success: function(dataRow) {
                    if (dataRow) {
                        view.mainGrid.addRecord(dataRow);
                        view.touch();
                    }
                }
            });
        },

        copyHandler: function() {
            var view = this.parentView || this;
            var checkedCodes = view.mainGrid.getCheckedCodes();
            if (Ext.isEmpty(checkedCodes)) return;
            view.serverCall({
                method: 'CopyRecord',
                params: [checkedCodes[0]],
                disableFog: true,
                success: function(dataRow) {
                    if (dataRow) {
                        view.mainGrid.addRecord(dataRow);
                        view.touch();
                    }
                }
            });
        },

        exportHandler: function() {
            var view = this.parentView;
            var checkedCodes = view.mainGrid.getCheckedCodes();
            if (Ext.isEmpty(checkedCodes)) {
                KS.alert("Не выбрана ни одна строка справочника", "Внимание");
                return;
            }

            view.serverCall({
                method: 'ExportRows',
                params: [checkedCodes]
            });
        },

        importHandler: function() {
            var view = this.parentView;

            view.importPanel = KS.create({
                    type: 'filefield',
                    parentView: view,
                    itemId: "importField"
                });

            view.selectedFilesGrid = new Ext.grid.Panel({
                store: new Ext.data.Store({
                    fields:[ 'name', 'file'],
                    data: []
                }),
                columns: [
                    { text: 'Наименование', dataIndex: 'name', flex: 1 },
                    { dataIndex: 'file', hidden: true }
                ],
                height: 200,
                width: 300
            });

            view.importWin = KS.showModal(new Ext.panel.Panel({
                    items: [view.importPanel, view.selectedFilesGrid]
                }),
            {
                layout: 'fit',
                frame: true,
                modal: true,
                maximizable: false,
                resizable: false,
                minWidth: 310,
                minHeight: 320,
                width: 310,
                height: 320,
                title: "Выберите файлы",
                buttonAlign: 'right',
                buttons: new Array({
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.importFiles();
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.importWin.close();
                        }
                    })
            }, true);
        },

        saveFiles: function(fileKeys) {
            var view = this.parentView || this;
            if (!view.validateFiles(fileKeys)) return;
            Ext.each(fileKeys, function(file) {
                view.selectedFilesGrid.getStore().add({ name: file.fileName, file: file });
            });
        },

        validateFiles: function(files) {
            var allowDownload = true;
            Ext.each(files, function(file) {
                var fileExtension = file.fileExtension;
                var validExts = [".xls", ".xlt", ".xlsx"];
                if (!KS.isEmpty(validExts) && validExts.indexOf(fileExtension) < 0) {
                    KS.alert("Тип файла " + fileExtension + " не разрешен для загрузки. Разрешенные типы : '.xls, .xlt, .xlsx'");
                    allowDownload = false;
                    return false;
                }
                return true;
            });
            
            return allowDownload;
        },

        importFiles: function() {
            var files = [];
            this.selectedFilesGrid.getStore().each(function(row) {
                files.push(KS.Grid.getAnyCase(row, "file"));
            });

            this.importWin.close();

            if (!Ext.isEmpty(files)) {
                var view = this;
                view.serverCall({
                    method: 'ImportFiles',
                    params: [files],
                    waitMessage: 'Импорт файлов...',
                    success: function() {
                        view.mainGrid.reload();
                    }
                });
            }
        }
    });
}(ExcelImportSettingsView.prototype));

if (typeof (Sys) !== 'undefined') { Sys.Application.notifyScriptLoaded(); }