﻿DataGarbageCleanerView = KS.extend(BaseDictionaryView, {});

(function(viewClass) {
    var sc = DataGarbageCleanerView.superclass;

    KS.apply(viewClass, {

        getTbarClickHandler: function(tbarItem) {
            switch (tbarItem.code) {

            case 'ACTION':
                return this.clearSelectedRows;

            default:
                return sc.getTbarClickHandler.apply(this, arguments);
            }
        },

        reload: function() {
            var view = this.parentView || this;

            var dateTime = null;
            var dateTimeEditor = view.getToolbarItem(view.mainGrid, null, "Container2");
            if (dateTimeEditor) {
                dateTime = dateTimeEditor.getValue();
            }

            view.serverCall({
                method: 'ReloadData',
                params: [dateTime],
                waitMessage: 'Обновление ...',
                success: view.reloadCallback
            });
        },

        clearSelectedRows: function() {
            var view = this.parentView || this;

            var dateTime = null;
            var dateTimeEditor = view.getToolbarItem(view.mainGrid, null, "Container2");
            if (dateTimeEditor) {
                dateTime = dateTimeEditor.getValue();
            }

            var checkedIds = [];
            var checkedRows = view.mainGrid.getCheckedRows();
            if (!Ext.isEmpty(checkedRows)) {
                
                Ext.each(checkedRows, function(row) {
                    checkedIds.push(KS.Grid.getAnyCase(row, "ID"));
                });

                view.serverCall({
                    method: 'ClearSelectedRows',
                    params: [dateTime, checkedIds],
                    waitMessage: 'Выполнение ...',
                    success: function(hasSaveErrors) {
                        if (!hasSaveErrors)
                            view.reload();
                    }
                });
            }
        },

        resetView: function () {
            this.mainGrid.reload();
        }
    });
}(DataGarbageCleanerView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();