﻿BudgetHierarchyView = KS.extend(BaseSvodView, {

    isTreeMode: true,

    onTemplateRendered: function () {
        this.setCustomComboBoxExpand(this.budgetTreePanel);
    },

    // Переопределяем, чтобы не было сообщения "Закрытие окна"
    close: function (closeContainerPanel) {
        var me = this;
        me._closing = true;
        me.serverCall({
            method: 'CloseView',
            disableFog: false,
            success: function() {
                if (closeContainerPanel !== false && me.containerPanel && me.containerPanel.doClose) {
                    me.containerPanel.doClose();
                }

                me.drop();
                me.onAfterClose();
            }
        });

        return true;
    },

    onAfterClose: function(){
        if (this.parentView && Ext.isFunction(this.parentView.budgetHierarchyClosed)){
            this.parentView.budgetHierarchyClosed();
        }
    },

    selectBudgetNodes: function() {
        var view = this.parentView,
            ids = [],
            forAll = null;

        if (view.isTreeMode){
            var nodes = view.budgetTree.getChecked();

            if (Ext.isEmpty(nodes)) {
                var selNode = view.budgetTree.getSelNode();
                if (selNode) {
                    nodes.push(selNode);
                }
            }

            Ext.each(nodes, function(node) {
                ids.push(node.id);
            });
        }
        else {
            var checkedRows = view.budgetGrid.getCheckedRows();
            Ext.each(checkedRows,
                function(rec) {
                    var linkBudgetHierarchy = KS.Grid.getAnyCase(rec, 'LINK_BUDGET_HIERARCHY');
                    var linkOrganization = KS.Grid.getAnyCase(rec, 'LINK_ORGANIZATION');
                    var linkBudget = KS.Grid.getAnyCase(rec, 'LINK_BUDGET');
                    var id = `${linkBudgetHierarchy}_${linkOrganization}_${linkBudget}`;
                    ids.push(id);
                });
        }

        if (Ext.isEmpty(ids)) {
            return;
        }

        var forAllCheckBox = view.getToolbarItem(view.budgetTreePanel, null, 'forAll')
        if (forAllCheckBox) {
            forAll = forAllCheckBox.getValue();
        }

        view.budgetTree.disable();
        view.budgetGrid.disable();
        view.serverCall({
            method: 'BudgetTreeClick',
            params: [ids, forAll],
            async: true
        });
    },

    // Изменение чека узла, например для EdsSchemaView, обработку делаем в родительской view
    selectedItemsChanged: function(node, checked) {
        var parentView = this.parentView;
        if (!Ext.isEmpty(parentView) &&
            Ext.isFunction(parentView.checkBudgetTreeNode)) {
            parentView.checkBudgetTreeNode(node, checked);
        }
    },

    selectBudgetTreeVersion: function(combo, newValue) {
        var view = (Ext.isEmpty(this.viewID) && this.parentView) ? this.parentView : this;
        var selectRecord = combo.findRecord(combo.valueField, newValue);
        if (selectRecord) {
            var linkHistory = KS.Grid.getAnyCase(selectRecord, "link_history");
            var date = KS.Grid.getAnyCase(selectRecord, "DATE");
            view.serverCall({
                method: 'SelectBudgetTreeVersion',
                params: [linkHistory, date, view.isTreeMode],
                waitMessage: 'Загрузка дерева бюджетов...',
                success: function() {
                    view.reloadBudgetTreeAndGrid();
                }
            });
        }
    },

    reloadBudgetTreeAndGrid: function() {
        var view = this;

        view.budgetTree.getRootNode().removeAll(true);
        view.budgetTree.fullReload();

        if (!view.isTreeMode) {
            view.budgetGrid.reload();
        }
    }
});

// ================= TOOLBAR ===================
(function (viewClass) {
    KS.apply(viewClass, {
        reloadBudgetTree: function() {
            var view = this.parentView || this;
            view.reloadBudgetTreeAndGrid();
        },

        budgetTreeInvert: function () {
            var view = this.parentView;
            view.budgetTree.invertAll();
            view.selectedItemsChanged();
        },

        budgetTreeCheckFromBeginToCurrent: function () {
            var view = this.parentView || this;
            var selNode = view.budgetTree.getSelNode();
            var parentNode = selNode.parentNode;
            var selIndex = parentNode.indexOf(selNode);
            view.setCheckedChildNodesBetweenIndexes(parentNode, true, 0, selIndex);
            view.selectedItemsChanged();
        },

        budgetTreeCheckFromCurrentToEnd: function () {
            var view = this.parentView || this;
            var selNode = view.budgetTree.getSelNode();
            var parentNode = selNode.parentNode;
            var selIndex = parentNode.indexOf(selNode);
            view.setCheckedChildNodesBetweenIndexes(parentNode, true, selIndex);
            view.selectedItemsChanged();
        },

        budgetTreeCheckBetweenMarked: function () {
            var view = this.parentView || this;
            var checkedNodes = view.budgetTree.getChecked();
            var firstNode = checkedNodes[0];
            var secondNode = checkedNodes[1];

            if (firstNode.parentNode === secondNode.parentNode) {
                var parentNode = firstNode.parentNode;
                var idx1 = parentNode.indexOf(firstNode);
                var idx2 = parentNode.indexOf(secondNode);
                view.setCheckedChildNodesBetweenIndexes(parentNode, true, idx1, idx2);
                view.selectedItemsChanged();
            }
        },

        setCheckedChildNodesBetweenIndexes: function (parentNode, checked, begin, end) {
            if (!end) end = parentNode.childNodes.length - 1;

            if (begin > end) return;

            Ext.each(parentNode.childNodes, function (node) {
                var currIdx = parentNode.indexOf(node);
                if (currIdx >= begin && currIdx <= end)
                    node.set('checked', checked);
            });
            view.selectedItemsChanged();
        },

        budgetTreeMarkChild: function () {
            var view = this.parentView || this;
            view.budgetTree.checkAllChildren();
            view.selectedItemsChanged();
        },

        budgetTreeMarkChildOneLevel: function () {
            var view = this.parentView || this;
            view.budgetTree.checkDirectChildren();
            view.selectedItemsChanged();
        },

        budgetTreeMarkPrimary: function () {
            var view = this.parentView || this;
            view.budgetTree.checkAllLeafs();
            view.selectedItemsChanged();
        },

        budgetTreeUnmarkAll: function () {
            var view = this.parentView || this;
            view.budgetTree.uncheckAll();
            view.selectedItemsChanged();
        },

        switchViewMode: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'SwitchBudgetTreeViewMode',
                success: function () {
                    view.isTreeMode = !view.isTreeMode;
                    view.budgetTree.setHidden(!view.isTreeMode);
                    view.budgetGrid.setHidden(view.isTreeMode);

                    if (!view.isTreeMode) {
                        view.budgetGrid.reload();
                    }
                }
            })
        },

        toggleShowClosedOrgs: function (cmp, newVal, oldVal) {
            var view = this;
            view.serverCall({
                method: 'ToggleShowClosedOrgs',
                params: [newVal, view.isTreeMode],
                success: function () {
                    view.reloadBudgetTreeAndGrid();
                }
            })
        }
    })
}(BudgetHierarchyView.prototype));

if (typeof (Sys) !== 'undefined') {Sys.Application.notifyScriptLoaded(); }