﻿// ============= VIEW =======================
BaseTreeView = KS.extend(BaseDictionaryView, {});

// ============= COMMON =======================
(function (viewClass) {
    var sc = BaseTreeView.superclass;

    KS.apply(viewClass, {
        getTbarClickHandler: function (tbarItem) {
            switch (tbarItem.code) {
                case 'COLLAPSE':
                    return this.collapseHandler;
                case 'EXPAND':
                    return this.expandHandler;
                default:
                    return sc.getTbarClickHandler.call(this, tbarItem);
            }
        },

        processToolbarItemControl: function (ctrl, tbarNode) {
            if (tbarNode.code === 'AutoFilterContainer') {
                ctrl.on('change', this.setAutoFilter, this);
                return ctrl;
            }
            return sc.processToolbarItemControl.apply(this, arguments);
        },

        setAutoFilter: function (cb, set) {
            this.serverCall({
                method: 'SetAutoFilter',
                params: [set],
                waitMessage: 'Фильтрация ...',
                success: this.resetGrid
            });
        },

        baseTreeNodeSelect: function(treeModel, selected) {
            if (Ext.isEmpty(selected)) return;
            this.setTreeFilter(selected[0]);
        },

        setTreeFilter: function (node) {
            var nodeId = node.id;
            this.serverCall({
                method: 'SetTreeFilter',
                params: [(nodeId === 'filter_off') ? null : nodeId],
                waitMessage: 'Фильтрация ...',
                success: this.resetGrid
            });
        },

        resetTree: function () {
            this.mainGrid.resetGrid();
        },

        expandHandler: function () {
            this.parentView.baseTree.expandAll();
        },

        collapseHandler: function () {
            this.parentView.baseTree.collapseAll();
        },

        invertTreeNode: function() {
            var view = this.parentView;
            view.baseTree.invertAll();
        },

        checkTreeNode: function() {
            var view = this.parentView;
            view.baseTree.checkAll();
        },

        uncheckTreeNode: function() {
            var view = this.parentView;
            view.baseTree.uncheckAll();
        },

        checkAllChildrenTreeNode: function() {
            var view = this.parentView;
            view.baseTree.checkAllChildren();
        },

        checkDirectChildren: function() {
            var view = this.parentView;
            view.baseTree.checkDirectChildren();
        },

        getSelectedNodeId: function () {
            var sn = this.baseTree.getSelNode();
            return (sn) ? sn.id : null;
        },

        getCheckedNodes: function(){
            if (!this.baseTree) return [];
            var nodes = this.baseTree.getChecked();
            if (Ext.isEmpty(nodes)) {
                var selNode = this.baseTree.getSelNode();
                if (selNode) {
                    nodes.push(selNode);
                }
            }
            var nodesCodes = [];
            Ext.each(nodes,
                function(node) {
                    nodesCodes.push(node.id);
                });
            
            return nodesCodes;
        }
    });
}(BaseTreeView.prototype));

// ============= RENDERERS =======================

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();