﻿//---------------------------------------------------------------------------------------------
// constructor
NavigatorView = function(viewId) {
    NavigatorView.superclass.constructor.call(this, viewId);
};

// ============= BASE =======================
KS.extend(NavigatorView,
    KS.Ext.ClientView,
    {
        nodeClick: function(v, node) {
            if (node.isLeaf()) {
                this.serverCall({
                    method: 'NavigatorTreeClick',
                    params: [node.data.id, node.data.json]
                });
            } else {
                if (node.isExpanded()) {
                    node.expand();
                } else {
                    node.collapse();
                }
            }
            return false;
        },

        scrollable : true,

        reloadNavTreeNodes: function(data) {
            this.navTree.reloadRootNodes(data);
        },

        navigatorLoader: function() {
            return true;
        },

        onTemplateRendered: function () {
            var sel = this.navTree.getSelection();
            if (sel && sel[0] && this.navTree.isVisible()) {
                var newY = 0,
                    ind,
                    len,
                    halfHeight = this.navTree.getHeight() / 2,
                    calcY = function(node) {
                        if (node.isRoot() || !node.parentNode) return;
                        
                        len = node.parentNode.childNodes.length;
                        if (len) {
                            ind = KS.Array.find(node.parentNode.childNodes, ['id'], node.id);
                        }

                        newY += 23 * ind;

                        calcY(node.parentNode);
                    };

                calcY(sel[0]);

                //64 - количество пикселей всяких бордеров и отступов
                this.navTree.setScrollY(newY + 64 < this.navTree.getHeight()? 0: newY - halfHeight);
            }
        }
    });

// ============= CONTEXT MENU =======================
KS.apply(NavigatorView.prototype,
    {
        replacer: {
            'q': 'й',
            'w': 'ц',
            'e': 'у',
            'r': 'к',
            't': 'е',
            'y': 'н',
            'u': 'г',
            'i': 'ш',
            'o': 'щ',
            'p': 'з',
            '[': 'х',
            ']': 'ъ',
            'a': 'ф',
            's': 'ы',
            'd': 'в',
            'f': 'а',
            'g': 'п',
            'h': 'р',
            'j': 'о',
            'k': 'л',
            'l': 'д',
            ';': 'ж',
            "'": 'э',
            'z': 'я',
            'x': 'ч',
            'c': 'с',
            'v': 'м',
            'b': 'и',
            'n': 'т',
            'm': 'ь',
            ',': 'б',
            '.': 'ю',
            '/': '.'
        },

        
        similarity: function(s1, s2) {
            var longer = s1;
            var shorter = s2;
            if (s1.length < s2.length) {
                longer = s2;
                shorter = s1;
            }
            var longerLength = longer.length;
            if (longerLength == 0) return 1.0;
            return (longerLength - this.editDistance(longer, shorter)) / parseFloat(longerLength);
        },
        
        editDistance: function(s1, s2) {
            s1 = s1.toLowerCase();
            s2 = s2.toLowerCase();

            var costs = new Array();
            for (var i = 0; i <= s1.length; i++) {
                var lastValue = i;
                for (var j = 0; j <= s2.length; j++) {
                    if (i == 0)
                        costs[j] = j;
                    else {
                        if (j > 0) {
                            var newValue = costs[j - 1];
                            if (s1.charAt(i - 1) != s2.charAt(j - 1)) {
                                newValue = Math.min(Math.min(newValue, lastValue),
                                        costs[j]) +
                                    1;
                            }
                            costs[j - 1] = lastValue;
                            lastValue = newValue;
                        }
                    }
                }
                if (i > 0)
                    costs[s2.length] = lastValue;
            }
            return costs[s2.length];
        },


        scrollable : true,

        //обнаружение html тегов
        tagsRe: /<[^>]*>/gm,

        // DEL ASCII code
        tagsProtect: '\x0f',

        //css стиль соответсвующего поиску текста
        matchCls: 'ks-search-match',

        showMenu: function(tree, node, sel, t, event) {
            var view = this;
            view.serverCall({
                method: 'GetContextMenu',
                params: [node.data.json.relId],
                success: function(data) {
                    //TODO: УБРАТЬ КАК ТОЛЬКО ВСЕ СТАНЕТ РАБОТАТЬ. Пока скрываем нерабочие пункты контекстного меню
                    var workedMenu = [],
                        notWorkedCodes = ['BUTTON_NTP_FOLDER_ADD', '', 'BUTTON_DESIGNER_LIST', 'BUTTON_NTP_ACCESS', 'BUTTON_NTP_DELETE', 'BUTTON_NTP_COPY', 'BUTTON_DESIGN',
                            'BUTTON_FILTER_DESIGNER'];

                    Ext.each(data,
                        function(d) {
                            if (notWorkedCodes.indexOf(d.code) === -1 && d.text !== "") {
                                workedMenu.push(d);
                            }
                        });

                    var menu = new Ext.menu.Menu({
                        shadow: true,
                        ignoreParentClicks: true,
                        items: workedMenu,
                        listeners: {
                            'click': function (menu, itemClicked) {
                                // bug 125532
                                if (Ext.browser.is.Firefox && itemClicked.text === 'Копировать наименование') {
                                    var treeStore = tree.getStore().getRoot().getTreeStore(),
                                        path = node.getPath().split('/').splice(2),
                                        copyPath = '';

                                    for (var i = 0; i < path.length; i++)
                                        copyPath += ' \\ ' + treeStore.getById(path[i]).get('text');

                                    view.onServerCopyNodeName(copyPath.slice(3));
                                } else {
                                    view.serverCall({
                                        method: 'OnContextMenuClick',
                                        params: [node.data.json.relId, itemClicked.menuId || 0, node.id]
                                    });
                                }

                                var pluginWebHandler = view.checkHandler(itemClicked.pluginNameWeb);
                                if (pluginWebHandler)
                                    pluginWebHandler.call(view);
                            }
                        }
                    });
                    menu.showAt(event.getXY());
                }
            });

            event.stopEvent();
            return false;
        },

        // вызов контекстного меню в пустом пространстве
        showDefaultMenu: function (tree, event, t) {
            var view = this;
            view.serverCall({
                method: 'GetContextMenu',
                params: [null],
                success: function (data) {
                    var menu = new Ext.menu.Menu({
                        shadow: true,
                        ignoreParentClicks: true,
                        items: data,
                        listeners: {
                            'click': function (menu, itemClicked) {

                                var pluginWebHandler = view.checkHandler(itemClicked.pluginNameWeb);
                                if (pluginWebHandler)
                                    pluginWebHandler.call(view);
                            }
                        }
                    });
                    menu.showAt(event.getXY());
                }
            });

            event.stopEvent();
            return false;
        },

        onServerAppendBranch: function(parentId, subtree) {
            var node = this.navigatorTree.getNodeById(parentId);
            if (Ext.isEmpty(node)) return;
            node.appendChild(subtree);
        },

        onServerRemoveNode: function(nodeId) {
            var node = this.navigatorTree.getNodeById(nodeId);
            if (Ext.isEmpty(node)) return;
            node.remove(true);
        },

        onServerCopyNodeName: function(nodeName) {
	        KS.copyToClipBoard(nodeName);
        },
        

        searchFieldChanged: function(th, newVal, oldVal) {
            this.navTree.ksObjs.ksProgressBar.showProgressBar();
            /*
            if (newVal.indexOf('/') !== -1) {
                var splitted = newVal.split(' / ');

                if (splitted && splitted.length) {
                    newVal = splitted[splitted.length - 1];
                }
            }
            */
            
            // Проверка: скопирован ли путь из Win
            newVal = newVal.replace(new RegExp("^" + KS.L10n.navigatorTitle + ": "), '');
            newVal = newVal.replace(/\\/g, '/');
            
            var me = this,
                stringCompare = function(val, filterVal) {
                    return val.toString().toLowerCase().indexOf(filterVal.toLowerCase());
                },
                store = me.navTree.store;

            try {
                me.searchRegExp = new RegExp(newVal, 'g' + (me.caseSensitive ? '' : 'i'));
            } catch (e) {
                newVal = newVal.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
                me.searchRegExp = new RegExp(newVal, 'g' + (me.caseSensitive ? '' : 'i'));
            }


            var hasValue = newVal && newVal.length;
            
            if (hasValue) {
                //Фильтрация снизу вверх
                store.filterer = 'bottomup';
                store.filter({
                    property: 'text',
                    
                    // эту функцию надо максимально оптимизировать, т.к. она выполняется для каждого узла
                    filterFn: function (item) {
                        var path = item.getPath().split('/'),
                            searchPath = '';

                        for (var i = 2; i < path.length; i++) {
                            var node = store.getNodeById(path[i]);

                            if (node)
                                searchPath += node.get('text') + ' / ';
                        }

                        var ind = stringCompare(searchPath.slice(0, searchPath.length - 3), newVal);

                        return Ext.isNumber(ind) && ind !== -1;

                        //Подсветка побуквенно (не работает)
                        //if (match && el) {
                        //el = item.id === 'root' ? null : Ext.fly(me.navTree.view.getNode(item));
                        //var td = el.down('td'),
                        //    cell,
                        //    matches,
                        //    cellHTML;
                        //if (td) {
                        //    cell = td.down('.x-tree-node-text');
                        //    matches = cell.dom.innerHTML.match(me.tagsRe);
                        //    cellHTML = cell.dom.innerHTML.replace(me.tagsRe, me.tagsProtect);
                        //    cellHTML = cellHTML.replace(me.searchRegExp,
                        //        function(m) {
                        //            return '<span class="' + me.matchCls + '">' + m + '</span>';
                        //        });
                        //    Ext.each(matches,
                        //        function(match) {
                        //            cellHTML = cellHTML.replace(me.tagsProtect, match);
                        //        });
                        //    cell.dom.innerHTML = cellHTML;
                        //}
                        //}
                    },
                    value: newVal
                });
                me.expandNavigator();
            } else {
                store.clearFilter();
                me.collapseNavigator();
            }            
            
            var searchBtn = this.getToolbarItem(this.navTree, null, 'search');
            searchBtn && searchBtn.setIconCls('ks-icon-' + (newVal.length ? 'clean' : 'search'));
            searchBtn && searchBtn.setTooltip(newVal.length ? KS.L10n.clear : KS.L10n.search);
            
            //Скрытие делаем по таймауту, т.е. пользователь может продолжать вводить значения
            if (me.updateTimeoutId) clearTimeout(me.updateTimeoutId);
            me.updateTimeoutId = setTimeout(function() {
                delete me.updateTimeoutId;
                me.navTree.ksObjs.ksProgressBar.hideProgressBar();
            }, 1500);
        },

        clearSearchField: function() {
            var searchField = this.getToolbarItem(this.navTree, null, 'searchField');
            searchField && searchField.items.first().setValue('');
        },

        expandNavigator: function() {
            this.navTree.expandAll();
        },

        collapseNavigator: function() {
            //Не убирать. Иначе сворачивание не работает, после поиска в навигаторе
            //this.navTree.expandAll();
            this.navTree.collapseAll();
        },

        //Замена символов с английских на русские при поиске
        replaceKeyLayout: function(str) {
            var me = this,
                copyStr = str + '',
                replacedString = copyStr.replace(/[A-z/,;\'\]\[]/g,
                    function(x) {
                        return x == x.toLowerCase() ? (me.replacer[x] || x) : me.replacer[x.toLowerCase()].toUpperCase();
                    });

            return me.similarity(str, replacedString) > 0.9 ? str : replacedString;
        }
    });