///////////////////////////////////////////////////////////////////////////
// Views manager
KS.apply(KS, {
    registeredViews: { },

    registerView: function(view) {
        KS.registeredViews[view.viewID] = view;
        TRACE('Registering view: ' + view.viewID, 'view');
    },

    unregisterView: function (view) {
        if (KS.registeredViews[view.viewID]) {
            TRACE('Unregistering view: ' + view.viewID, 'view');
            delete KS.registeredViews[view.viewID];
        }
    },

    getView: function(viewID) {
        return KS.registeredViews[viewID];
    },

    findViews: function (field, value) {
        var found = [];
        for (var view in KS.registeredViews) {
            if (KS.registeredViews.hasOwnProperty(view) && KS.registeredViews[view][field] === value)
                found.push(KS.registeredViews[view]);
        }
        return found;
    },

    findSingleView: function (field, value) {
        var found = this.findViews(field, value);
        return (found.length === 1) ? found[0] : null;
    },

    stopWaitingAllViews: function() {
        for (var id in KS.registeredViews)
            KS.registeredViews[id].forceStopWaiting();
    },

    stopWaitingAll: function() {
        KS.stopWaitingAllViews();
        KS.forceStopWaiting();
    },

    changeDependencyKey: function(oldKey, newKey) {
        for (var vid in KS.registeredViews) {
            var view = KS.registeredViews[vid];
            var changed = false;
            for (var k = 0; k < view.dependentViews.length; k++) {
                if (view.dependentViews[k] == oldKey) {
                    view.dependentViews[k] = newKey;
                    changed = true;
                }
            }
            if (view.masterView == oldKey)
                view.masterView = newKey;
            if (changed)
                view.onDependentChanged.apply(view);
        }
    }
});
